/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-vli-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"





/**
 * fu_vli_device_kind_to_string:
 * @val: value, e.g. %FU_VLI_DEVICE_KIND_VL100
 *
 * Converts an enumerated value to a string.
 *
 * Returns: identifier string
 **/
const gchar *
fu_vli_device_kind_to_string(FuVliDeviceKind val)
{
    if (val == FU_VLI_DEVICE_KIND_VL100)
        return "vl100";
    if (val == FU_VLI_DEVICE_KIND_VL101)
        return "vl101";
    if (val == FU_VLI_DEVICE_KIND_VL102)
        return "vl102";
    if (val == FU_VLI_DEVICE_KIND_VL103)
        return "vl103";
    if (val == FU_VLI_DEVICE_KIND_VL104)
        return "vl104";
    if (val == FU_VLI_DEVICE_KIND_VL105)
        return "vl105";
    if (val == FU_VLI_DEVICE_KIND_VL106)
        return "vl106";
    if (val == FU_VLI_DEVICE_KIND_VL107)
        return "vl107";
    if (val == FU_VLI_DEVICE_KIND_VL108)
        return "vl108";
    if (val == FU_VLI_DEVICE_KIND_VL109)
        return "vl109";
    if (val == FU_VLI_DEVICE_KIND_VL120)
        return "vl120";
    if (val == FU_VLI_DEVICE_KIND_VL122)
        return "vl122";
    if (val == FU_VLI_DEVICE_KIND_VL210)
        return "vl210";
    if (val == FU_VLI_DEVICE_KIND_VL211)
        return "vl211";
    if (val == FU_VLI_DEVICE_KIND_VL212)
        return "vl212";
    if (val == FU_VLI_DEVICE_KIND_VL650)
        return "vl650";
    if (val == FU_VLI_DEVICE_KIND_VL810)
        return "vl810";
    if (val == FU_VLI_DEVICE_KIND_VL811)
        return "vl811";
    if (val == FU_VLI_DEVICE_KIND_VL811PB0)
        return "vl811pb0";
    if (val == FU_VLI_DEVICE_KIND_VL811PB3)
        return "vl811pb3";
    if (val == FU_VLI_DEVICE_KIND_VL812B0)
        return "vl812b0";
    if (val == FU_VLI_DEVICE_KIND_VL812B3)
        return "vl812b3";
    if (val == FU_VLI_DEVICE_KIND_VL812Q4S)
        return "vl812q4s";
    if (val == FU_VLI_DEVICE_KIND_VL813)
        return "vl813";
    if (val == FU_VLI_DEVICE_KIND_VL815)
        return "vl815";
    if (val == FU_VLI_DEVICE_KIND_VL817)
        return "vl817";
    if (val == FU_VLI_DEVICE_KIND_VL817S)
        return "vl817s";
    if (val == FU_VLI_DEVICE_KIND_VL819Q7)
        return "vl819q7";
    if (val == FU_VLI_DEVICE_KIND_VL819Q8)
        return "vl819q8";
    if (val == FU_VLI_DEVICE_KIND_VL820Q7)
        return "vl820q7";
    if (val == FU_VLI_DEVICE_KIND_VL820Q8)
        return "vl820q8";
    if (val == FU_VLI_DEVICE_KIND_VL821Q7)
        return "vl821q7";
    if (val == FU_VLI_DEVICE_KIND_VL821Q8)
        return "vl821q8";
    if (val == FU_VLI_DEVICE_KIND_VL822Q5)
        return "vl822q5";
    if (val == FU_VLI_DEVICE_KIND_VL822Q7)
        return "vl822q7";
    if (val == FU_VLI_DEVICE_KIND_VL822Q8)
        return "vl822q8";
    if (val == FU_VLI_DEVICE_KIND_VL822T)
        return "vl822t";
    if (val == FU_VLI_DEVICE_KIND_VL822C0)
        return "vl822c0";
    if (val == FU_VLI_DEVICE_KIND_VL830)
        return "vl830";
    if (val == FU_VLI_DEVICE_KIND_VL832)
        return "vl832";
    if (val == FU_VLI_DEVICE_KIND_MSP430)
        return "msp430";
    if (val == FU_VLI_DEVICE_KIND_PS186)
        return "ps186";
    if (val == FU_VLI_DEVICE_KIND_RTD21XX)
        return "rtd21xx";
    return NULL;
}
/**
 * fu_vli_device_kind_from_string:
 * @val: (nullable): a string, e.g. `vl100`
 *
 * Converts a string to an enumerated value.
 *
 * Returns: enumerated value
 **/
FuVliDeviceKind
fu_vli_device_kind_from_string(const gchar *val)
{
    if (g_strcmp0(val, "vl100") == 0)
        return FU_VLI_DEVICE_KIND_VL100;
    if (g_strcmp0(val, "vl101") == 0)
        return FU_VLI_DEVICE_KIND_VL101;
    if (g_strcmp0(val, "vl102") == 0)
        return FU_VLI_DEVICE_KIND_VL102;
    if (g_strcmp0(val, "vl103") == 0)
        return FU_VLI_DEVICE_KIND_VL103;
    if (g_strcmp0(val, "vl104") == 0)
        return FU_VLI_DEVICE_KIND_VL104;
    if (g_strcmp0(val, "vl105") == 0)
        return FU_VLI_DEVICE_KIND_VL105;
    if (g_strcmp0(val, "vl106") == 0)
        return FU_VLI_DEVICE_KIND_VL106;
    if (g_strcmp0(val, "vl107") == 0)
        return FU_VLI_DEVICE_KIND_VL107;
    if (g_strcmp0(val, "vl108") == 0)
        return FU_VLI_DEVICE_KIND_VL108;
    if (g_strcmp0(val, "vl109") == 0)
        return FU_VLI_DEVICE_KIND_VL109;
    if (g_strcmp0(val, "vl120") == 0)
        return FU_VLI_DEVICE_KIND_VL120;
    if (g_strcmp0(val, "vl122") == 0)
        return FU_VLI_DEVICE_KIND_VL122;
    if (g_strcmp0(val, "vl210") == 0)
        return FU_VLI_DEVICE_KIND_VL210;
    if (g_strcmp0(val, "vl211") == 0)
        return FU_VLI_DEVICE_KIND_VL211;
    if (g_strcmp0(val, "vl212") == 0)
        return FU_VLI_DEVICE_KIND_VL212;
    if (g_strcmp0(val, "vl650") == 0)
        return FU_VLI_DEVICE_KIND_VL650;
    if (g_strcmp0(val, "vl810") == 0)
        return FU_VLI_DEVICE_KIND_VL810;
    if (g_strcmp0(val, "vl811") == 0)
        return FU_VLI_DEVICE_KIND_VL811;
    if (g_strcmp0(val, "vl811pb0") == 0)
        return FU_VLI_DEVICE_KIND_VL811PB0;
    if (g_strcmp0(val, "vl811pb3") == 0)
        return FU_VLI_DEVICE_KIND_VL811PB3;
    if (g_strcmp0(val, "vl812b0") == 0)
        return FU_VLI_DEVICE_KIND_VL812B0;
    if (g_strcmp0(val, "vl812b3") == 0)
        return FU_VLI_DEVICE_KIND_VL812B3;
    if (g_strcmp0(val, "vl812q4s") == 0)
        return FU_VLI_DEVICE_KIND_VL812Q4S;
    if (g_strcmp0(val, "vl813") == 0)
        return FU_VLI_DEVICE_KIND_VL813;
    if (g_strcmp0(val, "vl815") == 0)
        return FU_VLI_DEVICE_KIND_VL815;
    if (g_strcmp0(val, "vl817") == 0)
        return FU_VLI_DEVICE_KIND_VL817;
    if (g_strcmp0(val, "vl817s") == 0)
        return FU_VLI_DEVICE_KIND_VL817S;
    if (g_strcmp0(val, "vl819q7") == 0)
        return FU_VLI_DEVICE_KIND_VL819Q7;
    if (g_strcmp0(val, "vl819q8") == 0)
        return FU_VLI_DEVICE_KIND_VL819Q8;
    if (g_strcmp0(val, "vl820q7") == 0)
        return FU_VLI_DEVICE_KIND_VL820Q7;
    if (g_strcmp0(val, "vl820q8") == 0)
        return FU_VLI_DEVICE_KIND_VL820Q8;
    if (g_strcmp0(val, "vl821q7") == 0)
        return FU_VLI_DEVICE_KIND_VL821Q7;
    if (g_strcmp0(val, "vl821q8") == 0)
        return FU_VLI_DEVICE_KIND_VL821Q8;
    if (g_strcmp0(val, "vl822q5") == 0)
        return FU_VLI_DEVICE_KIND_VL822Q5;
    if (g_strcmp0(val, "vl822q7") == 0)
        return FU_VLI_DEVICE_KIND_VL822Q7;
    if (g_strcmp0(val, "vl822q8") == 0)
        return FU_VLI_DEVICE_KIND_VL822Q8;
    if (g_strcmp0(val, "vl822t") == 0)
        return FU_VLI_DEVICE_KIND_VL822T;
    if (g_strcmp0(val, "vl822c0") == 0)
        return FU_VLI_DEVICE_KIND_VL822C0;
    if (g_strcmp0(val, "vl830") == 0)
        return FU_VLI_DEVICE_KIND_VL830;
    if (g_strcmp0(val, "vl832") == 0)
        return FU_VLI_DEVICE_KIND_VL832;
    if (g_strcmp0(val, "msp430") == 0)
        return FU_VLI_DEVICE_KIND_MSP430;
    if (g_strcmp0(val, "ps186") == 0)
        return FU_VLI_DEVICE_KIND_PS186;
    if (g_strcmp0(val, "rtd21xx") == 0)
        return FU_VLI_DEVICE_KIND_RTD21XX;
    return FU_VLI_DEVICE_KIND_UNKNOWN;
}



/**
 * fu_struct_vli_pd_hdr_ref: (skip):
 **/
FuStructVliPdHdr *
fu_struct_vli_pd_hdr_ref(FuStructVliPdHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_vli_pd_hdr_unref: (skip):
 **/
void
fu_struct_vli_pd_hdr_unref(FuStructVliPdHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructVliPdHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_vli_pd_hdr_new_internal: (skip):
 **/
static FuStructVliPdHdr *
fu_struct_vli_pd_hdr_new_internal(void)
{
    FuStructVliPdHdr *st = g_new0(FuStructVliPdHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_vli_pd_hdr_get_fwver: (skip):
 **/
guint32
fu_struct_vli_pd_hdr_get_fwver(const FuStructVliPdHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_pd_hdr_get_vid: (skip):
 **/
guint16
fu_struct_vli_pd_hdr_get_vid(const FuStructVliPdHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_vli_pd_hdr_get_pid: (skip):
 **/
guint16
fu_struct_vli_pd_hdr_get_pid(const FuStructVliPdHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_vli_pd_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_vli_pd_hdr_to_string(const FuStructVliPdHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructVliPdHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  fwver: 0x%x\n",
                           (guint) fu_struct_vli_pd_hdr_get_fwver(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_vli_pd_hdr_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_vli_pd_hdr_get_pid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_vli_pd_hdr_validate_internal(FuStructVliPdHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_vli_pd_hdr_parse_internal(FuStructVliPdHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_vli_pd_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_vli_pd_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_vli_pd_hdr_parse: (skip):
 **/
FuStructVliPdHdr *
fu_struct_vli_pd_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructVliPdHdr) st = fu_struct_vli_pd_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructVliPdHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_vli_pd_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_vli_pd_hdr_parse_stream: (skip):
 **/
FuStructVliPdHdr *
fu_struct_vli_pd_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructVliPdHdr) st = fu_struct_vli_pd_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 8, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructVliPdHdr failed read of 0x%x: ", (guint) 8);
        return NULL;
    }
    if (st->buf->len != 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructVliPdHdr requested 0x%x and got 0x%x",
                    (guint) 8,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_vli_pd_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_vli_usbhub_hdr_ref: (skip):
 **/
FuStructVliUsbhubHdr *
fu_struct_vli_usbhub_hdr_ref(FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_vli_usbhub_hdr_unref: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_unref(FuStructVliUsbhubHdr *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructVliUsbhubHdr refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_vli_usbhub_hdr_new_internal: (skip):
 **/
static FuStructVliUsbhubHdr *
fu_struct_vli_usbhub_hdr_new_internal(void)
{
    FuStructVliUsbhubHdr *st = g_new0(FuStructVliUsbhubHdr, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_vli_usbhub_hdr_get_dev_id: (skip):
 **/
guint16
fu_struct_vli_usbhub_hdr_get_dev_id(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_get_strapping1: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_strapping1(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[2];
}
/**
 * fu_struct_vli_usbhub_hdr_get_strapping2: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_strapping2(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[3];
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb3_fw_addr: (skip):
 **/
guint16
fu_struct_vli_usbhub_hdr_get_usb3_fw_addr(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb3_fw_sz: (skip):
 **/
guint16
fu_struct_vli_usbhub_hdr_get_usb3_fw_sz(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 6, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb2_fw_addr: (skip):
 **/
guint16
fu_struct_vli_usbhub_hdr_get_usb2_fw_addr(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb2_fw_sz: (skip):
 **/
guint16
fu_struct_vli_usbhub_hdr_get_usb2_fw_sz(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 10, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb3_fw_addr_high: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_usb3_fw_addr_high(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[12];
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb3_fw_sz_high: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_usb3_fw_sz_high(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[13];
}
/**
 * fu_struct_vli_usbhub_hdr_get_usb2_fw_addr_high: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_usb2_fw_addr_high(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[16];
}
/**
 * fu_struct_vli_usbhub_hdr_get_inverse_pe41: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_inverse_pe41(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[27];
}
/**
 * fu_struct_vli_usbhub_hdr_get_prev_ptr: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_prev_ptr(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[28];
}
/**
 * fu_struct_vli_usbhub_hdr_get_next_ptr: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_next_ptr(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[29];
}
/**
 * fu_struct_vli_usbhub_hdr_get_variant: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_variant(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[30];
}
/**
 * fu_struct_vli_usbhub_hdr_get_checksum: (skip):
 **/
guint8
fu_struct_vli_usbhub_hdr_get_checksum(const FuStructVliUsbhubHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[31];
}

/* setters */
/**
 * fu_struct_vli_usbhub_hdr_set_dev_id: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_dev_id(FuStructVliUsbhubHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_set_strapping1: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_strapping1(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[2] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_strapping2: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_strapping2(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[3] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb3_fw_addr: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb3_fw_addr(FuStructVliUsbhubHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 4, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb3_fw_sz: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb3_fw_sz(FuStructVliUsbhubHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 6, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb2_fw_addr: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb2_fw_addr(FuStructVliUsbhubHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 8, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb2_fw_sz: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb2_fw_sz(FuStructVliUsbhubHdr *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 10, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb3_fw_addr_high: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb3_fw_addr_high(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[12] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb3_fw_sz_high: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb3_fw_sz_high(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[13] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_usb2_fw_addr_high: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_usb2_fw_addr_high(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[16] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_inverse_pe41: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_inverse_pe41(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[27] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_prev_ptr: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_prev_ptr(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[28] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_next_ptr: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_next_ptr(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[29] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_variant: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_variant(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[30] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_set_checksum: (skip):
 **/
void
fu_struct_vli_usbhub_hdr_set_checksum(FuStructVliUsbhubHdr *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[31] = value;
}
/**
 * fu_struct_vli_usbhub_hdr_new: (skip):
 **/
FuStructVliUsbhubHdr *
fu_struct_vli_usbhub_hdr_new(void)
{
    FuStructVliUsbhubHdr *st = fu_struct_vli_usbhub_hdr_new_internal();
    st->buf = g_byte_array_sized_new(32);
    fu_byte_array_set_size(st->buf, 32, 0x0);
    return st;
}
/**
 * fu_struct_vli_usbhub_hdr_to_string: (skip):
 **/
gchar *
fu_struct_vli_usbhub_hdr_to_string(const FuStructVliUsbhubHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructVliUsbhubHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  dev_id: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_dev_id(st));
    g_string_append_printf(str, "  strapping1: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_strapping1(st));
    g_string_append_printf(str, "  strapping2: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_strapping2(st));
    g_string_append_printf(str, "  usb3_fw_addr: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb3_fw_addr(st));
    g_string_append_printf(str, "  usb3_fw_sz: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb3_fw_sz(st));
    g_string_append_printf(str, "  usb2_fw_addr: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb2_fw_addr(st));
    g_string_append_printf(str, "  usb2_fw_sz: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb2_fw_sz(st));
    g_string_append_printf(str, "  usb3_fw_addr_high: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb3_fw_addr_high(st));
    g_string_append_printf(str, "  usb3_fw_sz_high: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb3_fw_sz_high(st));
    g_string_append_printf(str, "  usb2_fw_addr_high: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_usb2_fw_addr_high(st));
    g_string_append_printf(str, "  inverse_pe41: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_inverse_pe41(st));
    g_string_append_printf(str, "  prev_ptr: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_prev_ptr(st));
    g_string_append_printf(str, "  next_ptr: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_next_ptr(st));
    g_string_append_printf(str, "  variant: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_variant(st));
    g_string_append_printf(str, "  checksum: 0x%x\n",
                           (guint) fu_struct_vli_usbhub_hdr_get_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_vli_usbhub_hdr_validate_internal(FuStructVliUsbhubHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_vli_usbhub_hdr_parse_internal(FuStructVliUsbhubHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_vli_usbhub_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_vli_usbhub_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_vli_usbhub_hdr_parse: (skip):
 **/
FuStructVliUsbhubHdr *
fu_struct_vli_usbhub_hdr_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructVliUsbhubHdr) st = fu_struct_vli_usbhub_hdr_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 32, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructVliUsbhubHdr: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 32);
    if (!fu_struct_vli_usbhub_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_vli_usbhub_hdr_parse_stream: (skip):
 **/
FuStructVliUsbhubHdr *
fu_struct_vli_usbhub_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructVliUsbhubHdr) st = fu_struct_vli_usbhub_hdr_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 32, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructVliUsbhubHdr failed read of 0x%x: ", (guint) 32);
        return NULL;
    }
    if (st->buf->len != 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructVliUsbhubHdr requested 0x%x and got 0x%x",
                    (guint) 32,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_vli_usbhub_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
