/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-fdt-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

/**
 * fu_struct_fdt_ref: (skip):
 **/
FuStructFdt *
fu_struct_fdt_ref(FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fdt_unref: (skip):
 **/
void
fu_struct_fdt_unref(FuStructFdt *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFdt refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_fdt_new_internal: (skip):
 **/
static FuStructFdt *
fu_struct_fdt_new_internal(void)
{
    FuStructFdt *st = g_new0(FuStructFdt, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fdt_get_magic: (skip):
 **/
static guint32
fu_struct_fdt_get_magic(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_totalsize: (skip):
 **/
guint32
fu_struct_fdt_get_totalsize(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_dt_struct: (skip):
 **/
guint32
fu_struct_fdt_get_off_dt_struct(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 8, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_dt_strings: (skip):
 **/
guint32
fu_struct_fdt_get_off_dt_strings(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 12, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_off_mem_rsvmap: (skip):
 **/
guint32
fu_struct_fdt_get_off_mem_rsvmap(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 16, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_version: (skip):
 **/
guint32
fu_struct_fdt_get_version(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 20, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_last_comp_version: (skip):
 **/
guint32
fu_struct_fdt_get_last_comp_version(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 24, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_boot_cpuid_phys: (skip):
 **/
guint32
fu_struct_fdt_get_boot_cpuid_phys(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 28, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_size_dt_strings: (skip):
 **/
guint32
fu_struct_fdt_get_size_dt_strings(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 32, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_get_size_dt_struct: (skip):
 **/
guint32
fu_struct_fdt_get_size_dt_struct(const FuStructFdt *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 36, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_set_magic: (skip):
 **/
static void
fu_struct_fdt_set_magic(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_totalsize: (skip):
 **/
void
fu_struct_fdt_set_totalsize(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_dt_struct: (skip):
 **/
void
fu_struct_fdt_set_off_dt_struct(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 8, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_dt_strings: (skip):
 **/
void
fu_struct_fdt_set_off_dt_strings(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 12, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_off_mem_rsvmap: (skip):
 **/
void
fu_struct_fdt_set_off_mem_rsvmap(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 16, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_version: (skip):
 **/
void
fu_struct_fdt_set_version(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 20, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_last_comp_version: (skip):
 **/
void
fu_struct_fdt_set_last_comp_version(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 24, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_boot_cpuid_phys: (skip):
 **/
void
fu_struct_fdt_set_boot_cpuid_phys(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 28, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_size_dt_strings: (skip):
 **/
void
fu_struct_fdt_set_size_dt_strings(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 32, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_set_size_dt_struct: (skip):
 **/
void
fu_struct_fdt_set_size_dt_struct(FuStructFdt *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 36, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_new: (skip):
 **/
FuStructFdt *
fu_struct_fdt_new(void)
{
    FuStructFdt *st = fu_struct_fdt_new_internal();
    st->buf = g_byte_array_sized_new(40);
    fu_byte_array_set_size(st->buf, 40, 0x0);
    fu_struct_fdt_set_magic(st, 0xD00DFEED);
    fu_struct_fdt_set_last_comp_version(st, 2);
    return st;
}
/**
 * fu_struct_fdt_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_to_string(const FuStructFdt *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFdt:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  totalsize: 0x%x\n",
                           (guint) fu_struct_fdt_get_totalsize(st));
    g_string_append_printf(str, "  off_dt_struct: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_dt_struct(st));
    g_string_append_printf(str, "  off_dt_strings: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_dt_strings(st));
    g_string_append_printf(str, "  off_mem_rsvmap: 0x%x\n",
                           (guint) fu_struct_fdt_get_off_mem_rsvmap(st));
    g_string_append_printf(str, "  version: 0x%x\n",
                           (guint) fu_struct_fdt_get_version(st));
    g_string_append_printf(str, "  last_comp_version: 0x%x\n",
                           (guint) fu_struct_fdt_get_last_comp_version(st));
    g_string_append_printf(str, "  boot_cpuid_phys: 0x%x\n",
                           (guint) fu_struct_fdt_get_boot_cpuid_phys(st));
    g_string_append_printf(str, "  size_dt_strings: 0x%x\n",
                           (guint) fu_struct_fdt_get_size_dt_strings(st));
    g_string_append_printf(str, "  size_dt_struct: 0x%x\n",
                           (guint) fu_struct_fdt_get_size_dt_struct(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fdt_validate_internal(FuStructFdt *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_fdt_get_magic(st) != 0xD00DFEED) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructFdt.magic was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0xD00DFEED,
                    (guint) fu_struct_fdt_get_magic(st));
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_fdt_validate_stream: (skip):
 **/
gboolean
fu_struct_fdt_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFdt) st = fu_struct_fdt_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFdt failed read of 0x%x: ", (guint) 40);
        return FALSE;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFdt requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_fdt_validate_internal(st, error);
}
static gboolean
fu_struct_fdt_parse_internal(FuStructFdt *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fdt_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fdt_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fdt_parse_stream: (skip):
 **/
FuStructFdt *
fu_struct_fdt_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFdt) st = fu_struct_fdt_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 40, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFdt failed read of 0x%x: ", (guint) 40);
        return NULL;
    }
    if (st->buf->len != 40) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFdt requested 0x%x and got 0x%x",
                    (guint) 40,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fdt_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fdt_reserve_entry_ref: (skip):
 **/
FuStructFdtReserveEntry *
fu_struct_fdt_reserve_entry_ref(FuStructFdtReserveEntry *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fdt_reserve_entry_unref: (skip):
 **/
void
fu_struct_fdt_reserve_entry_unref(FuStructFdtReserveEntry *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFdtReserveEntry refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_fdt_reserve_entry_new_internal: (skip):
 **/
static FuStructFdtReserveEntry *
fu_struct_fdt_reserve_entry_new_internal(void)
{
    FuStructFdtReserveEntry *st = g_new0(FuStructFdtReserveEntry, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fdt_reserve_entry_get_address: (skip):
 **/
guint64
fu_struct_fdt_reserve_entry_get_address(const FuStructFdtReserveEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_get_size: (skip):
 **/
guint64
fu_struct_fdt_reserve_entry_get_size(const FuStructFdtReserveEntry *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 8, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_reserve_entry_set_address: (skip):
 **/
void
fu_struct_fdt_reserve_entry_set_address(FuStructFdtReserveEntry *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_set_size: (skip):
 **/
void
fu_struct_fdt_reserve_entry_set_size(FuStructFdtReserveEntry *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 8, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_reserve_entry_new: (skip):
 **/
FuStructFdtReserveEntry *
fu_struct_fdt_reserve_entry_new(void)
{
    FuStructFdtReserveEntry *st = fu_struct_fdt_reserve_entry_new_internal();
    st->buf = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st->buf, 16, 0x0);
    return st;
}
/**
 * fu_struct_fdt_reserve_entry_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_reserve_entry_to_string(const FuStructFdtReserveEntry *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFdtReserveEntry:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  address: 0x%x\n",
                           (guint) fu_struct_fdt_reserve_entry_get_address(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fdt_reserve_entry_get_size(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fdt_reserve_entry_validate_internal(FuStructFdtReserveEntry *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_fdt_reserve_entry_parse_internal(FuStructFdtReserveEntry *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fdt_reserve_entry_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fdt_reserve_entry_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fdt_reserve_entry_parse_stream: (skip):
 **/
FuStructFdtReserveEntry *
fu_struct_fdt_reserve_entry_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFdtReserveEntry) st = fu_struct_fdt_reserve_entry_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 16, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFdtReserveEntry failed read of 0x%x: ", (guint) 16);
        return NULL;
    }
    if (st->buf->len != 16) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFdtReserveEntry requested 0x%x and got 0x%x",
                    (guint) 16,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fdt_reserve_entry_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fdt_prop_ref: (skip):
 **/
FuStructFdtProp *
fu_struct_fdt_prop_ref(FuStructFdtProp *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fdt_prop_unref: (skip):
 **/
void
fu_struct_fdt_prop_unref(FuStructFdtProp *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFdtProp refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_fdt_prop_new_internal: (skip):
 **/
static FuStructFdtProp *
fu_struct_fdt_prop_new_internal(void)
{
    FuStructFdtProp *st = g_new0(FuStructFdtProp, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fdt_prop_get_len: (skip):
 **/
guint32
fu_struct_fdt_prop_get_len(const FuStructFdtProp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_get_nameoff: (skip):
 **/
guint32
fu_struct_fdt_prop_get_nameoff(const FuStructFdtProp *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_fdt_prop_set_len: (skip):
 **/
void
fu_struct_fdt_prop_set_len(FuStructFdtProp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_set_nameoff: (skip):
 **/
void
fu_struct_fdt_prop_set_nameoff(FuStructFdtProp *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_fdt_prop_new: (skip):
 **/
FuStructFdtProp *
fu_struct_fdt_prop_new(void)
{
    FuStructFdtProp *st = fu_struct_fdt_prop_new_internal();
    st->buf = g_byte_array_sized_new(8);
    fu_byte_array_set_size(st->buf, 8, 0x0);
    return st;
}
/**
 * fu_struct_fdt_prop_to_string: (skip):
 **/
static gchar *
fu_struct_fdt_prop_to_string(const FuStructFdtProp *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFdtProp:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  len: 0x%x\n",
                           (guint) fu_struct_fdt_prop_get_len(st));
    g_string_append_printf(str, "  nameoff: 0x%x\n",
                           (guint) fu_struct_fdt_prop_get_nameoff(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fdt_prop_validate_internal(FuStructFdtProp *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_fdt_prop_parse_internal(FuStructFdtProp *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fdt_prop_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fdt_prop_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_fdt_prop_parse: (skip):
 **/
FuStructFdtProp *
fu_struct_fdt_prop_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(FuStructFdtProp) st = fu_struct_fdt_prop_new_internal();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 8, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructFdtProp: ");
        return NULL;
    }
    st->buf = g_byte_array_new();
    g_byte_array_append(st->buf, buf + offset, 8);
    if (!fu_struct_fdt_prop_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
