/* auto-generated, do not modify */
#include "config.h"

#include "fu-qc-s5gen2-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"



const gchar *
fu_qc_status_to_string(FuQcStatus val)
{
    if (val == FU_QC_STATUS_SUCCESS)
        return "success";
    if (val == FU_QC_STATUS_UNEXPECTED_ERROR)
        return "unexpected-error";
    if (val == FU_QC_STATUS_ALREADY_CONNECTED_WARNING)
        return "already-connected-warning";
    if (val == FU_QC_STATUS_IN_PROGRESS)
        return "in-progress";
    if (val == FU_QC_STATUS_BUSY)
        return "busy";
    if (val == FU_QC_STATUS_INVALID_POWER_STATE)
        return "invalid-power-state";
    return NULL;
}

const gchar *
fu_qc_resume_point_to_string(FuQcResumePoint val)
{
    if (val == FU_QC_RESUME_POINT_START)
        return "start";
    if (val == FU_QC_RESUME_POINT_PRE_VALIDATE)
        return "pre-validate";
    if (val == FU_QC_RESUME_POINT_PRE_REBOOT)
        return "pre-reboot";
    if (val == FU_QC_RESUME_POINT_POST_REBOOT)
        return "post-reboot";
    if (val == FU_QC_RESUME_POINT_COMMIT)
        return "commit";
    if (val == FU_QC_RESUME_POINT_POST_COMMIT)
        return "post-commit";
    return NULL;
}

const gchar *
fu_qc_start_status_to_string(FuQcStartStatus val)
{
    if (val == FU_QC_START_STATUS_SUCCESS)
        return "success";
    if (val == FU_QC_START_STATUS_FAILURE)
        return "failure";
    return NULL;
}




/* getters */

/* setters */
/**
 * fu_struct_qc_connect_req_set_req: (skip):
 **/
static void
fu_struct_qc_connect_req_set_req(FuStructQcConnectReq *st, FuQcReq value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_connect_req_set_data_len: (skip):
 **/
void
fu_struct_qc_connect_req_set_data_len(FuStructQcConnectReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_connect_req_new: (skip):
 **/
FuStructQcConnectReq *
fu_struct_qc_connect_req_new(void)
{
    FuStructQcConnectReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_connect_req_set_req(st, FU_QC_REQ_CONNECT);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_disconnect_req_set_req: (skip):
 **/
static void
fu_struct_qc_disconnect_req_set_req(FuStructQcDisconnectReq *st, FuQcReq value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_disconnect_req_set_data_len: (skip):
 **/
void
fu_struct_qc_disconnect_req_set_data_len(FuStructQcDisconnectReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_disconnect_req_new: (skip):
 **/
FuStructQcDisconnectReq *
fu_struct_qc_disconnect_req_new(void)
{
    FuStructQcDisconnectReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_disconnect_req_set_req(st, FU_QC_REQ_DISCONNECT);
    return st;
}
/* getters */
/**
 * fu_struct_qc_update_status_get_status: (skip):
 **/
FuQcStatus
fu_struct_qc_update_status_get_status(const FuStructQcUpdateStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}

/* setters */
/**
 * fu_struct_qc_update_status_to_string: (skip):
 **/
static gchar *
fu_struct_qc_update_status_to_string(const FuStructQcUpdateStatus *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcUpdateStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_qc_status_to_string(fu_struct_qc_update_status_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_qc_update_status_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_qc_update_status_get_status(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_update_status_validate_internal(FuStructQcUpdateStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_qc_update_status_parse_internal(FuStructQcUpdateStatus *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_update_status_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_update_status_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_update_status_parse: (skip):
 **/
FuStructQcUpdateStatus *
fu_struct_qc_update_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 1, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcUpdateStatus: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 1);
    if (!fu_struct_qc_update_status_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_version_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_version_req_set_opcode(FuStructQcVersionReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_version_req_set_data_len: (skip):
 **/
static void
fu_struct_qc_version_req_set_data_len(FuStructQcVersionReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_req_new: (skip):
 **/
FuStructQcVersionReq *
fu_struct_qc_version_req_new(void)
{
    FuStructQcVersionReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_version_req_set_opcode(st, FU_QC_OPCODE_HOST_VERSION_REQ);
    fu_struct_qc_version_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_version_get_status: (skip):
 **/
static FuQcOpcode
fu_struct_qc_version_get_status(const FuStructQcVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_version_get_data_len: (skip):
 **/
static guint16
fu_struct_qc_version_get_data_len(const FuStructQcVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_major: (skip):
 **/
guint16
fu_struct_qc_version_get_major(const FuStructQcVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_minor: (skip):
 **/
guint16
fu_struct_qc_version_get_minor(const FuStructQcVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 5, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_version_get_config: (skip):
 **/
guint16
fu_struct_qc_version_get_config(const FuStructQcVersion *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 7, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_version_to_string: (skip):
 **/
static gchar *
fu_struct_qc_version_to_string(const FuStructQcVersion *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcVersion:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_qc_version_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_qc_version_get_minor(st));
    g_string_append_printf(str, "  config: 0x%x\n",
                           (guint) fu_struct_qc_version_get_config(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_version_validate_internal(FuStructQcVersion *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_version_get_status(st) != FU_QC_OPCODE_HOST_VERSION_CFM) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcVersion.status was not valid");
        return FALSE;
    }
    if (fu_struct_qc_version_get_data_len(st) != 0x0006) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructQcVersion.data_len was not valid, "
                    "expected 0x%x and got 0x%x",
                    (guint) 0x0006,
                    (guint) fu_struct_qc_version_get_data_len(st));
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_version_parse_internal(FuStructQcVersion *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_version_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_version_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_version_parse: (skip):
 **/
FuStructQcVersion *
fu_struct_qc_version_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 9, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcVersion: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 9);
    if (!fu_struct_qc_version_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_abort_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_abort_req_set_opcode(FuStructQcAbortReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_abort_req_set_data_len: (skip):
 **/
void
fu_struct_qc_abort_req_set_data_len(FuStructQcAbortReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_abort_req_new: (skip):
 **/
FuStructQcAbortReq *
fu_struct_qc_abort_req_new(void)
{
    FuStructQcAbortReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_abort_req_set_opcode(st, FU_QC_OPCODE_ABORT_REQ);
    fu_struct_qc_abort_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_abort_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_abort_get_opcode(const FuStructQcAbort *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_abort_get_data_len: (skip):
 **/
guint16
fu_struct_qc_abort_get_data_len(const FuStructQcAbort *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_abort_to_string: (skip):
 **/
static gchar *
fu_struct_qc_abort_to_string(const FuStructQcAbort *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcAbort:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_abort_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_abort_validate_internal(FuStructQcAbort *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_abort_get_opcode(st) != FU_QC_OPCODE_ABORT_CFM) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcAbort.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_abort_parse_internal(FuStructQcAbort *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_abort_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_abort_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_abort_parse: (skip):
 **/
FuStructQcAbort *
fu_struct_qc_abort_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcAbort: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (!fu_struct_qc_abort_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_sync_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_sync_req_set_opcode(FuStructQcSyncReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_sync_req_set_data_len: (skip):
 **/
void
fu_struct_qc_sync_req_set_data_len(FuStructQcSyncReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_req_set_file_id: (skip):
 **/
void
fu_struct_qc_sync_req_set_file_id(FuStructQcSyncReq *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_req_new: (skip):
 **/
FuStructQcSyncReq *
fu_struct_qc_sync_req_new(void)
{
    FuStructQcSyncReq *st = g_byte_array_sized_new(7);
    fu_byte_array_set_size(st, 7, 0x0);
    fu_struct_qc_sync_req_set_opcode(st, FU_QC_OPCODE_SYNC_REQ);
    fu_struct_qc_sync_req_set_data_len(st, 0x04);
    return st;
}
/* getters */
/**
 * fu_struct_qc_sync_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_sync_get_opcode(const FuStructQcSync *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_sync_get_data_len: (skip):
 **/
guint16
fu_struct_qc_sync_get_data_len(const FuStructQcSync *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_get_resume_point: (skip):
 **/
FuQcResumePoint
fu_struct_qc_sync_get_resume_point(const FuStructQcSync *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_qc_sync_get_file_id: (skip):
 **/
guint32
fu_struct_qc_sync_get_file_id(const FuStructQcSync *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_sync_get_protocol_version: (skip):
 **/
guint8
fu_struct_qc_sync_get_protocol_version(const FuStructQcSync *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[8];
}

/* setters */
/**
 * fu_struct_qc_sync_to_string: (skip):
 **/
static gchar *
fu_struct_qc_sync_to_string(const FuStructQcSync *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcSync:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_data_len(st));
    {
        const gchar *tmp = fu_qc_resume_point_to_string(fu_struct_qc_sync_get_resume_point(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  resume_point: 0x%x [%s]\n", (guint) fu_struct_qc_sync_get_resume_point(st), tmp);
        } else {
            g_string_append_printf(str, "  resume_point: 0x%x\n", (guint) fu_struct_qc_sync_get_resume_point(st));
        }
    }
    g_string_append_printf(str, "  file_id: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_file_id(st));
    g_string_append_printf(str, "  protocolVersion: 0x%x\n",
                           (guint) fu_struct_qc_sync_get_protocol_version(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_sync_validate_internal(FuStructQcSync *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_sync_get_opcode(st) != FU_QC_OPCODE_SYNC_CFM) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcSync.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_sync_parse_internal(FuStructQcSync *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_sync_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_sync_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_sync_parse: (skip):
 **/
FuStructQcSync *
fu_struct_qc_sync_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 9, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcSync: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 9);
    if (!fu_struct_qc_sync_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_start_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_start_req_set_opcode(FuStructQcStartReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_start_req_set_data_len: (skip):
 **/
void
fu_struct_qc_start_req_set_data_len(FuStructQcStartReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_req_new: (skip):
 **/
FuStructQcStartReq *
fu_struct_qc_start_req_new(void)
{
    FuStructQcStartReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_start_req_set_opcode(st, FU_QC_OPCODE_START_REQ);
    fu_struct_qc_start_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_start_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_start_get_opcode(const FuStructQcStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_start_get_data_len: (skip):
 **/
guint16
fu_struct_qc_start_get_data_len(const FuStructQcStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_get_status: (skip):
 **/
FuQcStartStatus
fu_struct_qc_start_get_status(const FuStructQcStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[3];
}
/**
 * fu_struct_qc_start_get_battery_level: (skip):
 **/
guint16
fu_struct_qc_start_get_battery_level(const FuStructQcStart *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 4, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_start_to_string: (skip):
 **/
static gchar *
fu_struct_qc_start_to_string(const FuStructQcStart *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcStart:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_start_get_data_len(st));
    {
        const gchar *tmp = fu_qc_start_status_to_string(fu_struct_qc_start_get_status(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  status: 0x%x [%s]\n", (guint) fu_struct_qc_start_get_status(st), tmp);
        } else {
            g_string_append_printf(str, "  status: 0x%x\n", (guint) fu_struct_qc_start_get_status(st));
        }
    }
    g_string_append_printf(str, "  battery_level: 0x%x\n",
                           (guint) fu_struct_qc_start_get_battery_level(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_start_validate_internal(FuStructQcStart *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_start_get_opcode(st) != FU_QC_OPCODE_START_CFM) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcStart.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_start_parse_internal(FuStructQcStart *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_start_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_start_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_start_parse: (skip):
 **/
FuStructQcStart *
fu_struct_qc_start_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 6, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcStart: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 6);
    if (!fu_struct_qc_start_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_start_data_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_start_data_req_set_opcode(FuStructQcStartDataReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_start_data_req_set_data_len: (skip):
 **/
void
fu_struct_qc_start_data_req_set_data_len(FuStructQcStartDataReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_start_data_req_new: (skip):
 **/
FuStructQcStartDataReq *
fu_struct_qc_start_data_req_new(void)
{
    FuStructQcStartDataReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_start_data_req_set_opcode(st, FU_QC_OPCODE_START_DATA_REQ);
    fu_struct_qc_start_data_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_data_req_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_data_req_get_opcode(const FuStructQcDataReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_data_req_get_data_len: (skip):
 **/
guint16
fu_struct_qc_data_req_get_data_len(const FuStructQcDataReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_req_get_fw_data_len: (skip):
 **/
guint32
fu_struct_qc_data_req_get_fw_data_len(const FuStructQcDataReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 3, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_req_get_fw_data_offset: (skip):
 **/
guint32
fu_struct_qc_data_req_get_fw_data_offset(const FuStructQcDataReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 7, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_data_req_to_string: (skip):
 **/
static gchar *
fu_struct_qc_data_req_to_string(const FuStructQcDataReq *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcDataReq:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_data_len(st));
    g_string_append_printf(str, "  fw_data_len: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_fw_data_len(st));
    g_string_append_printf(str, "  fw_data_offset: 0x%x\n",
                           (guint) fu_struct_qc_data_req_get_fw_data_offset(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_data_req_validate_internal(FuStructQcDataReq *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_data_req_get_opcode(st) != FU_QC_OPCODE_DATA_BYTES_REQ) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcDataReq.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_data_req_parse_internal(FuStructQcDataReq *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_data_req_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_data_req_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_data_req_parse: (skip):
 **/
FuStructQcDataReq *
fu_struct_qc_data_req_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 11, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcDataReq: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 11);
    if (!fu_struct_qc_data_req_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_data_set_opcode: (skip):
 **/
static void
fu_struct_qc_data_set_opcode(FuStructQcData *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_data_set_data_len: (skip):
 **/
void
fu_struct_qc_data_set_data_len(FuStructQcData *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_data_set_last_packet: (skip):
 **/
void
fu_struct_qc_data_set_last_packet(FuStructQcData *st, FuQcMoreData value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_data_new: (skip):
 **/
FuStructQcData *
fu_struct_qc_data_new(void)
{
    FuStructQcData *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_data_set_opcode(st, FU_QC_OPCODE_DATA);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_validation_req_set_opcode: (skip):
 **/
static void
fu_struct_qc_validation_req_set_opcode(FuStructQcValidationReq *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_validation_req_set_data_len: (skip):
 **/
void
fu_struct_qc_validation_req_set_data_len(FuStructQcValidationReq *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_validation_req_new: (skip):
 **/
FuStructQcValidationReq *
fu_struct_qc_validation_req_new(void)
{
    FuStructQcValidationReq *st = g_byte_array_sized_new(3);
    fu_byte_array_set_size(st, 3, 0x0);
    fu_struct_qc_validation_req_set_opcode(st, FU_QC_OPCODE_IS_VALIDATION_DONE_REQ);
    fu_struct_qc_validation_req_set_data_len(st, 0x00);
    return st;
}
/* getters */
/**
 * fu_struct_qc_is_validation_done_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_is_validation_done_get_opcode(const FuStructQcIsValidationDone *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_is_validation_done_get_data_len: (skip):
 **/
guint16
fu_struct_qc_is_validation_done_get_data_len(const FuStructQcIsValidationDone *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_is_validation_done_get_delay: (skip):
 **/
guint16
fu_struct_qc_is_validation_done_get_delay(const FuStructQcIsValidationDone *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_is_validation_done_to_string: (skip):
 **/
static gchar *
fu_struct_qc_is_validation_done_to_string(const FuStructQcIsValidationDone *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcIsValidationDone:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_is_validation_done_get_data_len(st));
    g_string_append_printf(str, "  delay: 0x%x\n",
                           (guint) fu_struct_qc_is_validation_done_get_delay(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_is_validation_done_validate_internal(FuStructQcIsValidationDone *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_is_validation_done_get_opcode(st) != FU_QC_OPCODE_IS_VALIDATION_DONE_CFM) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcIsValidationDone.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_is_validation_done_parse_internal(FuStructQcIsValidationDone *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_is_validation_done_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_is_validation_done_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_is_validation_done_parse: (skip):
 **/
FuStructQcIsValidationDone *
fu_struct_qc_is_validation_done_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 5, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcIsValidationDone: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 5);
    if (!fu_struct_qc_is_validation_done_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_qc_transfer_complete_ind_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_transfer_complete_ind_get_opcode(const FuStructQcTransferCompleteInd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_transfer_complete_ind_get_data_len: (skip):
 **/
guint16
fu_struct_qc_transfer_complete_ind_get_data_len(const FuStructQcTransferCompleteInd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_transfer_complete_ind_to_string: (skip):
 **/
static gchar *
fu_struct_qc_transfer_complete_ind_to_string(const FuStructQcTransferCompleteInd *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcTransferCompleteInd:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_transfer_complete_ind_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_transfer_complete_ind_validate_internal(FuStructQcTransferCompleteInd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_transfer_complete_ind_get_opcode(st) != FU_QC_OPCODE_TRANSFER_COMPLETE_IND) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcTransferCompleteInd.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_transfer_complete_ind_parse_internal(FuStructQcTransferCompleteInd *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_transfer_complete_ind_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_transfer_complete_ind_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_transfer_complete_ind_parse: (skip):
 **/
FuStructQcTransferCompleteInd *
fu_struct_qc_transfer_complete_ind_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcTransferCompleteInd: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (!fu_struct_qc_transfer_complete_ind_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_transfer_complete_set_opcode: (skip):
 **/
static void
fu_struct_qc_transfer_complete_set_opcode(FuStructQcTransferComplete *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_transfer_complete_set_data_len: (skip):
 **/
void
fu_struct_qc_transfer_complete_set_data_len(FuStructQcTransferComplete *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_transfer_complete_set_action: (skip):
 **/
void
fu_struct_qc_transfer_complete_set_action(FuStructQcTransferComplete *st, FuQcTransferAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_transfer_complete_new: (skip):
 **/
FuStructQcTransferComplete *
fu_struct_qc_transfer_complete_new(void)
{
    FuStructQcTransferComplete *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_transfer_complete_set_opcode(st, FU_QC_OPCODE_TRANSFER_COMPLETE_RES);
    fu_struct_qc_transfer_complete_set_data_len(st, 0x01);
    return st;
}
/* getters */

/* setters */
/**
 * fu_struct_qc_proceed_to_commit_set_opcode: (skip):
 **/
static void
fu_struct_qc_proceed_to_commit_set_opcode(FuStructQcProceedToCommit *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_proceed_to_commit_set_data_len: (skip):
 **/
void
fu_struct_qc_proceed_to_commit_set_data_len(FuStructQcProceedToCommit *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_proceed_to_commit_set_action: (skip):
 **/
void
fu_struct_qc_proceed_to_commit_set_action(FuStructQcProceedToCommit *st, FuQcCommitAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_proceed_to_commit_new: (skip):
 **/
FuStructQcProceedToCommit *
fu_struct_qc_proceed_to_commit_new(void)
{
    FuStructQcProceedToCommit *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_proceed_to_commit_set_opcode(st, FU_QC_OPCODE_PROCEED_TO_COMMIT);
    fu_struct_qc_proceed_to_commit_set_data_len(st, 0x01);
    return st;
}
/* getters */
/**
 * fu_struct_qc_commit_req_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_commit_req_get_opcode(const FuStructQcCommitReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_commit_req_get_data_len: (skip):
 **/
guint16
fu_struct_qc_commit_req_get_data_len(const FuStructQcCommitReq *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_commit_req_to_string: (skip):
 **/
static gchar *
fu_struct_qc_commit_req_to_string(const FuStructQcCommitReq *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcCommitReq:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_commit_req_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_commit_req_validate_internal(FuStructQcCommitReq *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_commit_req_get_opcode(st) != FU_QC_OPCODE_COMMIT_REQ) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcCommitReq.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_commit_req_parse_internal(FuStructQcCommitReq *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_commit_req_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_commit_req_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_commit_req_parse: (skip):
 **/
FuStructQcCommitReq *
fu_struct_qc_commit_req_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcCommitReq: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (!fu_struct_qc_commit_req_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_commit_cfm_set_opcode: (skip):
 **/
static void
fu_struct_qc_commit_cfm_set_opcode(FuStructQcCommitCfm *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_commit_cfm_set_data_len: (skip):
 **/
void
fu_struct_qc_commit_cfm_set_data_len(FuStructQcCommitCfm *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_commit_cfm_set_action: (skip):
 **/
void
fu_struct_qc_commit_cfm_set_action(FuStructQcCommitCfm *st, FuQcCommitCfmAction value)
{
    g_return_if_fail(st != NULL);
    st->data[3] = value;
}
/**
 * fu_struct_qc_commit_cfm_new: (skip):
 **/
FuStructQcCommitCfm *
fu_struct_qc_commit_cfm_new(void)
{
    FuStructQcCommitCfm *st = g_byte_array_sized_new(4);
    fu_byte_array_set_size(st, 4, 0x0);
    fu_struct_qc_commit_cfm_set_opcode(st, FU_QC_OPCODE_COMMIT_CFM);
    fu_struct_qc_commit_cfm_set_data_len(st, 0x01);
    return st;
}
/* getters */
/**
 * fu_struct_qc_complete_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_complete_get_opcode(const FuStructQcComplete *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_complete_get_data_len: (skip):
 **/
guint16
fu_struct_qc_complete_get_data_len(const FuStructQcComplete *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_complete_to_string: (skip):
 **/
static gchar *
fu_struct_qc_complete_to_string(const FuStructQcComplete *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcComplete:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_complete_get_data_len(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_complete_validate_internal(FuStructQcComplete *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_complete_get_opcode(st) != FU_QC_OPCODE_COMPLETE_IND) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcComplete.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_complete_parse_internal(FuStructQcComplete *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_complete_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_complete_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_complete_parse: (skip):
 **/
FuStructQcComplete *
fu_struct_qc_complete_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 3, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcComplete: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 3);
    if (!fu_struct_qc_complete_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_qc_error_ind_get_opcode: (skip):
 **/
static FuQcOpcode
fu_struct_qc_error_ind_get_opcode(const FuStructQcErrorInd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_qc_error_ind_get_data_len: (skip):
 **/
guint16
fu_struct_qc_error_ind_get_data_len(const FuStructQcErrorInd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 1, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_error_ind_get_error_code: (skip):
 **/
guint16
fu_struct_qc_error_ind_get_error_code(const FuStructQcErrorInd *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 3, G_BIG_ENDIAN);
}

/* setters */
/**
 * fu_struct_qc_error_ind_to_string: (skip):
 **/
static gchar *
fu_struct_qc_error_ind_to_string(const FuStructQcErrorInd *st)
{
    g_autoptr(GString) str = g_string_new("FuStructQcErrorInd:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  data_len: 0x%x\n",
                           (guint) fu_struct_qc_error_ind_get_data_len(st));
    g_string_append_printf(str, "  error_code: 0x%x\n",
                           (guint) fu_struct_qc_error_ind_get_error_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_qc_error_ind_validate_internal(FuStructQcErrorInd *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (fu_struct_qc_error_ind_get_opcode(st) != FU_QC_OPCODE_ERROR_IND) {
        g_set_error_literal(error,
                            FWUPD_ERROR,
                            FWUPD_ERROR_INVALID_DATA,
                            "constant FuStructQcErrorInd.opcode was not valid");
        return FALSE;
    }
    return TRUE;
}
static gboolean
fu_struct_qc_error_ind_parse_internal(FuStructQcErrorInd *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_qc_error_ind_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_qc_error_ind_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_qc_error_ind_parse: (skip):
 **/
FuStructQcErrorInd *
fu_struct_qc_error_ind_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 5, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructQcErrorInd: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 5);
    if (!fu_struct_qc_error_ind_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */

/* setters */
/**
 * fu_struct_qc_error_res_set_opcode: (skip):
 **/
static void
fu_struct_qc_error_res_set_opcode(FuStructQcErrorRes *st, FuQcOpcode value)
{
    g_return_if_fail(st != NULL);
    st->data[0] = value;
}
/**
 * fu_struct_qc_error_res_set_data_len: (skip):
 **/
void
fu_struct_qc_error_res_set_data_len(FuStructQcErrorRes *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 1, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_error_res_set_error_code: (skip):
 **/
void
fu_struct_qc_error_res_set_error_code(FuStructQcErrorRes *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->data + 3, value, G_BIG_ENDIAN);
}
/**
 * fu_struct_qc_error_res_new: (skip):
 **/
FuStructQcErrorRes *
fu_struct_qc_error_res_new(void)
{
    FuStructQcErrorRes *st = g_byte_array_sized_new(5);
    fu_byte_array_set_size(st, 5, 0x0);
    fu_struct_qc_error_res_set_opcode(st, FU_QC_OPCODE_ERROR_RES);
    fu_struct_qc_error_res_set_data_len(st, 0x02);
    return st;
}
