//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PNeckoParent.h"
#include "SerializedLoadContext.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PermissionMessageUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/ipc/IPCStreamUtils.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/NeckoParent.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsIPrincipal.h"
#include "nsIPropertyBag2.h"

#include "mozilla/dom/PContentParent.h"
#include "mozilla/net/PHttpChannelParent.h"
#include "mozilla/net/PCacheEntryWriteHandleParent.h"
#include "mozilla/net/PCookieServiceParent.h"
#include "mozilla/dom/PBrowserParent.h"
#include "mozilla/net/PGIOChannelParent.h"
#include "mozilla/net/PWebSocketParent.h"
#include "mozilla/net/PWebSocketEventListenerParent.h"
#include "mozilla/net/PTCPSocketParent.h"
#include "mozilla/net/PTCPServerSocketParent.h"
#include "mozilla/net/PUDPSocketParent.h"
#include "mozilla/net/PDNSRequestParent.h"
#include "mozilla/net/PTransportProviderParent.h"
#include "mozilla/net/PStunAddrsRequestParent.h"
#include "mozilla/net/PWebrtcTCPSocketParent.h"
#include "mozilla/net/PSocketProcessBridgeParent.h"
#include "mozilla/net/PDocumentChannelParent.h"
#include "mozilla/net/PAltDataOutputStreamParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PNeckoParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPCookieServiceConstructor(PCookieServiceParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPHttpChannelConstructor(
        PHttpChannelParent* actor,
        PBrowserParent* browser,
        const SerializedLoadContext& loadContext,
        const HttpChannelCreationArgs& args) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPWebSocketConstructor(
        PWebSocketParent* actor,
        PBrowserParent* browser,
        const SerializedLoadContext& loadContext,
        const uint32_t& aSerialID) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPTCPServerSocketConstructor(
        PTCPServerSocketParent* actor,
        const uint16_t& localPort,
        const uint16_t& backlog,
        const bool& useArrayBuffers) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPUDPSocketConstructor(
        PUDPSocketParent* actor,
        nsIPrincipal* principal,
        const nsACString& filter) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPDNSRequestConstructor(
        PDNSRequestParent* actor,
        const nsACString& hostName,
        const nsACString& trrServer,
        const int32_t& port,
        const uint16_t& type,
        const OriginAttributes& originAttributes,
        const DNSFlags& flags) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPDocumentChannelConstructor(
        PDocumentChannelParent* actor,
        const MaybeDiscardedBrowsingContext& browsingContext,
        const DocumentChannelCreationArgs& args) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPWebSocketEventListenerConstructor(
        PWebSocketEventListenerParent* actor,
        const uint64_t& aInnerWindowID) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPGIOChannelConstructor(
        PGIOChannelParent* actor,
        PBrowserParent* browser,
        const SerializedLoadContext& loadContext,
        const GIOChannelCreationArgs& args) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPCacheEntryWriteHandleConstructor(
        PCacheEntryWriteHandleParent* actor,
        mozilla::NotNull<PHttpChannelParent*> channel) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPAltDataOutputStreamConstructor(
        PAltDataOutputStreamParent* actor,
        const nsACString& type,
        const int64_t& predictedSize,
        const mozilla::Maybe<mozilla::NotNull<PHttpChannelParent*>>& channel,
        const mozilla::Maybe<mozilla::NotNull<PCacheEntryWriteHandleParent*>>& handle) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPStunAddrsRequestConstructor(PStunAddrsRequestParent* actor) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPWebrtcTCPSocketConstructor(
        PWebrtcTCPSocketParent* actor,
        const mozilla::Maybe<TabId>& tabId) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PNeckoParent::RecvPTCPSocketConstructor(
        PTCPSocketParent* actor,
        const nsAString& host,
        const uint16_t& port) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PNeckoParent::PNeckoParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PNeckoParent);
}

PNeckoParent::~PNeckoParent()
{
    MOZ_COUNT_DTOR(PNeckoParent);
}

auto PNeckoParent::ActorAlloc() -> void
{
    AddRef();
}

auto PNeckoParent::ActorDealloc() -> void
{
    Release();
}

auto PNeckoParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PNeckoParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PNeckoParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PNeckoParent::Manager() const -> PContentParent*
{
    return static_cast<PContentParent*>(IProtocol::Manager());
}

auto PNeckoParent::ManagedPHttpChannelParent(nsTArray<PHttpChannelParent*>& aArr) const -> void
{
    mManagedPHttpChannelParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPHttpChannelParent() const -> const ManagedContainer<PHttpChannelParent>&
{
    return mManagedPHttpChannelParent;
}

auto PNeckoParent::ManagedPCacheEntryWriteHandleParent(nsTArray<PCacheEntryWriteHandleParent*>& aArr) const -> void
{
    mManagedPCacheEntryWriteHandleParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPCacheEntryWriteHandleParent() const -> const ManagedContainer<PCacheEntryWriteHandleParent>&
{
    return mManagedPCacheEntryWriteHandleParent;
}

auto PNeckoParent::ManagedPCookieServiceParent(nsTArray<PCookieServiceParent*>& aArr) const -> void
{
    mManagedPCookieServiceParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPCookieServiceParent() const -> const ManagedContainer<PCookieServiceParent>&
{
    return mManagedPCookieServiceParent;
}

auto PNeckoParent::ManagedPWebSocketParent(nsTArray<PWebSocketParent*>& aArr) const -> void
{
    mManagedPWebSocketParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPWebSocketParent() const -> const ManagedContainer<PWebSocketParent>&
{
    return mManagedPWebSocketParent;
}

auto PNeckoParent::ManagedPWebSocketEventListenerParent(nsTArray<PWebSocketEventListenerParent*>& aArr) const -> void
{
    mManagedPWebSocketEventListenerParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPWebSocketEventListenerParent() const -> const ManagedContainer<PWebSocketEventListenerParent>&
{
    return mManagedPWebSocketEventListenerParent;
}

auto PNeckoParent::ManagedPTCPSocketParent(nsTArray<PTCPSocketParent*>& aArr) const -> void
{
    mManagedPTCPSocketParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPTCPSocketParent() const -> const ManagedContainer<PTCPSocketParent>&
{
    return mManagedPTCPSocketParent;
}

auto PNeckoParent::ManagedPTCPServerSocketParent(nsTArray<PTCPServerSocketParent*>& aArr) const -> void
{
    mManagedPTCPServerSocketParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPTCPServerSocketParent() const -> const ManagedContainer<PTCPServerSocketParent>&
{
    return mManagedPTCPServerSocketParent;
}

auto PNeckoParent::ManagedPUDPSocketParent(nsTArray<PUDPSocketParent*>& aArr) const -> void
{
    mManagedPUDPSocketParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPUDPSocketParent() const -> const ManagedContainer<PUDPSocketParent>&
{
    return mManagedPUDPSocketParent;
}

auto PNeckoParent::ManagedPDNSRequestParent(nsTArray<PDNSRequestParent*>& aArr) const -> void
{
    mManagedPDNSRequestParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPDNSRequestParent() const -> const ManagedContainer<PDNSRequestParent>&
{
    return mManagedPDNSRequestParent;
}

auto PNeckoParent::ManagedPGIOChannelParent(nsTArray<PGIOChannelParent*>& aArr) const -> void
{
    mManagedPGIOChannelParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPGIOChannelParent() const -> const ManagedContainer<PGIOChannelParent>&
{
    return mManagedPGIOChannelParent;
}

auto PNeckoParent::ManagedPTransportProviderParent(nsTArray<PTransportProviderParent*>& aArr) const -> void
{
    mManagedPTransportProviderParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPTransportProviderParent() const -> const ManagedContainer<PTransportProviderParent>&
{
    return mManagedPTransportProviderParent;
}

auto PNeckoParent::ManagedPAltDataOutputStreamParent(nsTArray<PAltDataOutputStreamParent*>& aArr) const -> void
{
    mManagedPAltDataOutputStreamParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPAltDataOutputStreamParent() const -> const ManagedContainer<PAltDataOutputStreamParent>&
{
    return mManagedPAltDataOutputStreamParent;
}

auto PNeckoParent::ManagedPStunAddrsRequestParent(nsTArray<PStunAddrsRequestParent*>& aArr) const -> void
{
    mManagedPStunAddrsRequestParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPStunAddrsRequestParent() const -> const ManagedContainer<PStunAddrsRequestParent>&
{
    return mManagedPStunAddrsRequestParent;
}

auto PNeckoParent::ManagedPWebrtcTCPSocketParent(nsTArray<PWebrtcTCPSocketParent*>& aArr) const -> void
{
    mManagedPWebrtcTCPSocketParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPWebrtcTCPSocketParent() const -> const ManagedContainer<PWebrtcTCPSocketParent>&
{
    return mManagedPWebrtcTCPSocketParent;
}

auto PNeckoParent::ManagedPDocumentChannelParent(nsTArray<PDocumentChannelParent*>& aArr) const -> void
{
    mManagedPDocumentChannelParent.ToArray(aArr);
}

auto PNeckoParent::ManagedPDocumentChannelParent() const -> const ManagedContainer<PDocumentChannelParent>&
{
    return mManagedPDocumentChannelParent;
}

auto PNeckoParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PHttpChannelMsgStart,
        PCacheEntryWriteHandleMsgStart,
        PCookieServiceMsgStart,
        PWebSocketMsgStart,
        PWebSocketEventListenerMsgStart,
        PTCPSocketMsgStart,
        PTCPServerSocketMsgStart,
        PUDPSocketMsgStart,
        PDNSRequestMsgStart,
        PGIOChannelMsgStart,
        PTransportProviderMsgStart,
        PAltDataOutputStreamMsgStart,
        PStunAddrsRequestMsgStart,
        PWebrtcTCPSocketMsgStart,
        PDocumentChannelMsgStart
    };
    return sIds;
}

auto PNeckoParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PHttpChannelMsgStart:
        return (&(mManagedPHttpChannelParent));
    case PCacheEntryWriteHandleMsgStart:
        return (&(mManagedPCacheEntryWriteHandleParent));
    case PCookieServiceMsgStart:
        return (&(mManagedPCookieServiceParent));
    case PWebSocketMsgStart:
        return (&(mManagedPWebSocketParent));
    case PWebSocketEventListenerMsgStart:
        return (&(mManagedPWebSocketEventListenerParent));
    case PTCPSocketMsgStart:
        return (&(mManagedPTCPSocketParent));
    case PTCPServerSocketMsgStart:
        return (&(mManagedPTCPServerSocketParent));
    case PUDPSocketMsgStart:
        return (&(mManagedPUDPSocketParent));
    case PDNSRequestMsgStart:
        return (&(mManagedPDNSRequestParent));
    case PGIOChannelMsgStart:
        return (&(mManagedPGIOChannelParent));
    case PTransportProviderMsgStart:
        return (&(mManagedPTransportProviderParent));
    case PAltDataOutputStreamMsgStart:
        return (&(mManagedPAltDataOutputStreamParent));
    case PStunAddrsRequestMsgStart:
        return (&(mManagedPStunAddrsRequestParent));
    case PWebrtcTCPSocketMsgStart:
        return (&(mManagedPWebrtcTCPSocketParent));
    case PDocumentChannelMsgStart:
        return (&(mManagedPDocumentChannelParent));
    default:
        return nullptr;
    }
}

auto PNeckoParent::RejectPendingResponses(ResponseRejectReason aReason) -> void
{
    mAsyncCallbacks.RejectPendingResponses(aReason);
}

auto PNeckoParent::OpenPHttpChannelEndpoint(PHttpChannelParent* aActor) -> ManagedEndpoint<PHttpChannelChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PHttpChannelParent actor");
        return ManagedEndpoint<PHttpChannelChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PHttpChannelParent actor");
        return ManagedEndpoint<PHttpChannelChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PHttpChannelChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPHttpChannelEndpoint(
        ManagedEndpoint<PHttpChannelParent> aEndpoint,
        PHttpChannelParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPCacheEntryWriteHandleEndpoint(PCacheEntryWriteHandleParent* aActor) -> ManagedEndpoint<PCacheEntryWriteHandleChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCacheEntryWriteHandleParent actor");
        return ManagedEndpoint<PCacheEntryWriteHandleChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCacheEntryWriteHandleParent actor");
        return ManagedEndpoint<PCacheEntryWriteHandleChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCacheEntryWriteHandleChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPCacheEntryWriteHandleEndpoint(
        ManagedEndpoint<PCacheEntryWriteHandleParent> aEndpoint,
        PCacheEntryWriteHandleParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPCookieServiceEndpoint(PCookieServiceParent* aActor) -> ManagedEndpoint<PCookieServiceChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PCookieServiceParent actor");
        return ManagedEndpoint<PCookieServiceChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PCookieServiceParent actor");
        return ManagedEndpoint<PCookieServiceChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PCookieServiceChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPCookieServiceEndpoint(
        ManagedEndpoint<PCookieServiceParent> aEndpoint,
        PCookieServiceParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPWebSocketEndpoint(PWebSocketParent* aActor) -> ManagedEndpoint<PWebSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebSocketParent actor");
        return ManagedEndpoint<PWebSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebSocketParent actor");
        return ManagedEndpoint<PWebSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPWebSocketEndpoint(
        ManagedEndpoint<PWebSocketParent> aEndpoint,
        PWebSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPWebSocketEventListenerEndpoint(PWebSocketEventListenerParent* aActor) -> ManagedEndpoint<PWebSocketEventListenerChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebSocketEventListenerParent actor");
        return ManagedEndpoint<PWebSocketEventListenerChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebSocketEventListenerParent actor");
        return ManagedEndpoint<PWebSocketEventListenerChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebSocketEventListenerChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPWebSocketEventListenerEndpoint(
        ManagedEndpoint<PWebSocketEventListenerParent> aEndpoint,
        PWebSocketEventListenerParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPTCPSocketEndpoint(PTCPSocketParent* aActor) -> ManagedEndpoint<PTCPSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTCPSocketParent actor");
        return ManagedEndpoint<PTCPSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTCPSocketParent actor");
        return ManagedEndpoint<PTCPSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTCPSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPTCPSocketEndpoint(
        ManagedEndpoint<PTCPSocketParent> aEndpoint,
        PTCPSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPTCPServerSocketEndpoint(PTCPServerSocketParent* aActor) -> ManagedEndpoint<PTCPServerSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTCPServerSocketParent actor");
        return ManagedEndpoint<PTCPServerSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTCPServerSocketParent actor");
        return ManagedEndpoint<PTCPServerSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTCPServerSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPTCPServerSocketEndpoint(
        ManagedEndpoint<PTCPServerSocketParent> aEndpoint,
        PTCPServerSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPUDPSocketEndpoint(PUDPSocketParent* aActor) -> ManagedEndpoint<PUDPSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PUDPSocketParent actor");
        return ManagedEndpoint<PUDPSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PUDPSocketParent actor");
        return ManagedEndpoint<PUDPSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PUDPSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPUDPSocketEndpoint(
        ManagedEndpoint<PUDPSocketParent> aEndpoint,
        PUDPSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPDNSRequestEndpoint(PDNSRequestParent* aActor) -> ManagedEndpoint<PDNSRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PDNSRequestParent actor");
        return ManagedEndpoint<PDNSRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDNSRequestParent actor");
        return ManagedEndpoint<PDNSRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PDNSRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPDNSRequestEndpoint(
        ManagedEndpoint<PDNSRequestParent> aEndpoint,
        PDNSRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPGIOChannelEndpoint(PGIOChannelParent* aActor) -> ManagedEndpoint<PGIOChannelChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PGIOChannelParent actor");
        return ManagedEndpoint<PGIOChannelChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PGIOChannelParent actor");
        return ManagedEndpoint<PGIOChannelChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PGIOChannelChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPGIOChannelEndpoint(
        ManagedEndpoint<PGIOChannelParent> aEndpoint,
        PGIOChannelParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPTransportProviderEndpoint(PTransportProviderParent* aActor) -> ManagedEndpoint<PTransportProviderChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PTransportProviderParent actor");
        return ManagedEndpoint<PTransportProviderChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTransportProviderParent actor");
        return ManagedEndpoint<PTransportProviderChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PTransportProviderChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPTransportProviderEndpoint(
        ManagedEndpoint<PTransportProviderParent> aEndpoint,
        PTransportProviderParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPAltDataOutputStreamEndpoint(PAltDataOutputStreamParent* aActor) -> ManagedEndpoint<PAltDataOutputStreamChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PAltDataOutputStreamParent actor");
        return ManagedEndpoint<PAltDataOutputStreamChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PAltDataOutputStreamParent actor");
        return ManagedEndpoint<PAltDataOutputStreamChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PAltDataOutputStreamChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPAltDataOutputStreamEndpoint(
        ManagedEndpoint<PAltDataOutputStreamParent> aEndpoint,
        PAltDataOutputStreamParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPStunAddrsRequestEndpoint(PStunAddrsRequestParent* aActor) -> ManagedEndpoint<PStunAddrsRequestChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PStunAddrsRequestParent actor");
        return ManagedEndpoint<PStunAddrsRequestChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PStunAddrsRequestParent actor");
        return ManagedEndpoint<PStunAddrsRequestChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PStunAddrsRequestChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPStunAddrsRequestEndpoint(
        ManagedEndpoint<PStunAddrsRequestParent> aEndpoint,
        PStunAddrsRequestParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPWebrtcTCPSocketEndpoint(PWebrtcTCPSocketParent* aActor) -> ManagedEndpoint<PWebrtcTCPSocketChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PWebrtcTCPSocketParent actor");
        return ManagedEndpoint<PWebrtcTCPSocketChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PWebrtcTCPSocketParent actor");
        return ManagedEndpoint<PWebrtcTCPSocketChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PWebrtcTCPSocketChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPWebrtcTCPSocketEndpoint(
        ManagedEndpoint<PWebrtcTCPSocketParent> aEndpoint,
        PWebrtcTCPSocketParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::OpenPDocumentChannelEndpoint(PDocumentChannelParent* aActor) -> ManagedEndpoint<PDocumentChannelChild>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PDocumentChannelParent actor");
        return ManagedEndpoint<PDocumentChannelChild>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PDocumentChannelParent actor");
        return ManagedEndpoint<PDocumentChannelChild>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PDocumentChannelChild>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PNeckoParent::BindPDocumentChannelEndpoint(
        ManagedEndpoint<PDocumentChannelParent> aEndpoint,
        PDocumentChannelParent* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PNeckoParent::SendSpeculativeConnectRequest() -> bool
{
    UniquePtr<IPC::Message> msg__ = PNecko::Msg_SpeculativeConnectRequest(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PNeckoParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PNecko::Msg_SpeculativeConnectRequest", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PNeckoParent::SendNetworkChangeNotification(const nsACString& type) -> bool
{
    UniquePtr<IPC::Message> msg__ = PNecko::Msg_NetworkChangeNotification(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), type);
    // Sentinel = 'type'
    ((&(writer__)))->WriteSentinel(75760067);


    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PNeckoParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PNecko::Msg_NetworkChangeNotification", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PNeckoParent::SendPTransportProviderConstructor() -> PTransportProviderParent*
{
    PTransportProviderParent* actor = (static_cast<NeckoParent*>(this))->AllocPTransportProviderParent();
    return SendPTransportProviderConstructor(std::move(actor));
}

auto PNeckoParent::SendPTransportProviderConstructor(PTransportProviderParent* actor) -> PTransportProviderParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PTransportProviderParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTransportProviderParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PNecko::Msg_PTransportProviderConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PNeckoParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PNecko::Msg_PTransportProviderConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PTransportProviderParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PNeckoParent::SendSetTRRDomain(const nsACString& domain) -> bool
{
    UniquePtr<IPC::Message> msg__ = PNecko::Msg_SetTRRDomain(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), domain);
    // Sentinel = 'domain'
    ((&(writer__)))->WriteSentinel(144704121);


    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PNeckoParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PNecko::Msg_SetTRRDomain", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PNeckoParent::SendPTCPSocketConstructor(
        const nsAString& host,
        const uint16_t& port) -> PTCPSocketParent*
{
    PTCPSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPTCPSocketParent(host, port);
    return SendPTCPSocketConstructor(std::move(actor), std::move(host), std::move(port));
}

auto PNeckoParent::SendPTCPSocketConstructor(
        PTCPSocketParent* actor,
        const nsAString& host,
        const uint16_t& port) -> PTCPSocketParent*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PTCPSocketParent actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PTCPSocketParent actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PNecko::Msg_PTCPSocketConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), host);
    // Sentinel = 'host'
    ((&(writer__)))->WriteSentinel(72024511);
    IPC::WriteParam((&(writer__)), port);
    // Sentinel = 'port'
    ((&(writer__)))->WriteSentinel(73990598);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PNeckoParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PNecko::Msg_PTCPSocketConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PTCPSocketParent constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PNeckoParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PCacheEntryWriteHandleMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPCacheEntryWriteHandleParent(static_cast<PCacheEntryWriteHandleParent*>(aListener));
        return;
    case PCookieServiceMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPCookieServiceParent(static_cast<PCookieServiceParent*>(aListener));
        return;
    case PWebSocketMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPWebSocketParent(static_cast<PWebSocketParent*>(aListener));
        return;
    case PWebSocketEventListenerMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPWebSocketEventListenerParent(static_cast<PWebSocketEventListenerParent*>(aListener));
        return;
    case PTCPSocketMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPTCPSocketParent(static_cast<PTCPSocketParent*>(aListener));
        return;
    case PTCPServerSocketMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPTCPServerSocketParent(static_cast<PTCPServerSocketParent*>(aListener));
        return;
    case PUDPSocketMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPUDPSocketParent(static_cast<PUDPSocketParent*>(aListener));
        return;
    case PGIOChannelMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPGIOChannelParent(static_cast<PGIOChannelParent*>(aListener));
        return;
    case PTransportProviderMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPTransportProviderParent(static_cast<PTransportProviderParent*>(aListener));
        return;
    case PAltDataOutputStreamMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPAltDataOutputStreamParent(static_cast<PAltDataOutputStreamParent*>(aListener));
        return;
    case PStunAddrsRequestMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPStunAddrsRequestParent(static_cast<PStunAddrsRequestParent*>(aListener));
        return;
    case PWebrtcTCPSocketMsgStart:
        static_cast<NeckoParent*>(this)->DeallocPWebrtcTCPSocketParent(static_cast<PWebrtcTCPSocketParent*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PNeckoParent::OnMessageReceived(const Message& msg__) -> PNeckoParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PNecko::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PNecko::Msg_PCookieServiceConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PCookieServiceConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            PCookieServiceParent* actor = (static_cast<NeckoParent*>(this))->AllocPCookieServiceParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PCookieServiceParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PCookieServiceParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPCookieServiceConstructor(std::move(actor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PHttpChannelConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PHttpChannelConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__browser = IPC::ReadParam<PBrowserParent*>((&(reader__)));
            if (!maybe__browser) {
                FatalError("Error deserializing 'PBrowser'");
                return MsgValueError;

            }
            auto& browser = *maybe__browser;
            // Sentinel = 'browser'
            if ((!(((&(reader__)))->ReadSentinel(201130757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PBrowser'");
                return MsgValueError;
            }
            auto maybe__loadContext = IPC::ReadParam<SerializedLoadContext>((&(reader__)));
            if (!maybe__loadContext) {
                FatalError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;

            }
            auto& loadContext = *maybe__loadContext;
            // Sentinel = 'loadContext'
            if ((!(((&(reader__)))->ReadSentinel(444990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;
            }
            auto maybe__args = IPC::ReadParam<HttpChannelCreationArgs>((&(reader__)));
            if (!maybe__args) {
                FatalError("Error deserializing 'HttpChannelCreationArgs'");
                return MsgValueError;

            }
            auto& args = *maybe__args;
            // Sentinel = 'args'
            if ((!(((&(reader__)))->ReadSentinel(69140910)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'HttpChannelCreationArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PHttpChannelParent> actor = (static_cast<NeckoParent*>(this))->AllocPHttpChannelParent(browser, loadContext, args);
            if (!actor) {
                NS_WARNING("Cannot bind null PHttpChannelParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PHttpChannelParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPHttpChannelConstructor(actor, browser, std::move(loadContext), std::move(args));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PWebSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PWebSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__browser = IPC::ReadParam<PBrowserParent*>((&(reader__)));
            if (!maybe__browser) {
                FatalError("Error deserializing 'PBrowser'");
                return MsgValueError;

            }
            auto& browser = *maybe__browser;
            // Sentinel = 'browser'
            if ((!(((&(reader__)))->ReadSentinel(201130757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PBrowser'");
                return MsgValueError;
            }
            auto maybe__loadContext = IPC::ReadParam<SerializedLoadContext>((&(reader__)));
            if (!maybe__loadContext) {
                FatalError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;

            }
            auto& loadContext = *maybe__loadContext;
            // Sentinel = 'loadContext'
            if ((!(((&(reader__)))->ReadSentinel(444990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;
            }
            auto maybe__aSerialID = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__aSerialID) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& aSerialID = *maybe__aSerialID;
            // Sentinel = 'aSerialID'
            if ((!(((&(reader__)))->ReadSentinel(287572815)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            PWebSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPWebSocketParent(browser, loadContext, aSerialID);
            if (!actor) {
                NS_WARNING("Cannot bind null PWebSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPWebSocketConstructor(std::move(actor), browser, std::move(loadContext), std::move(aSerialID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PTCPServerSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PTCPServerSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__localPort = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__localPort) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& localPort = *maybe__localPort;
            // Sentinel = 'localPort'
            if ((!(((&(reader__)))->ReadSentinel(306774961)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__backlog = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__backlog) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& backlog = *maybe__backlog;
            // Sentinel = 'backlog'
            if ((!(((&(reader__)))->ReadSentinel(186581716)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__useArrayBuffers = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__useArrayBuffers) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& useArrayBuffers = *maybe__useArrayBuffers;
            // Sentinel = 'useArrayBuffers'
            if ((!(((&(reader__)))->ReadSentinel(815007258)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            PTCPServerSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPTCPServerSocketParent(localPort, backlog, useArrayBuffers);
            if (!actor) {
                NS_WARNING("Cannot bind null PTCPServerSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PTCPServerSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPTCPServerSocketConstructor(std::move(actor), std::move(localPort), std::move(backlog), std::move(useArrayBuffers));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PUDPSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PUDPSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__principal = IPC::ReadParam<RefPtr<nsIPrincipal>>((&(reader__)));
            if (!maybe__principal) {
                FatalError("Error deserializing 'nsIPrincipal'");
                return MsgValueError;

            }
            auto& principal = *maybe__principal;
            // Sentinel = 'principal'
            if ((!(((&(reader__)))->ReadSentinel(319620035)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIPrincipal'");
                return MsgValueError;
            }
            auto maybe__filter = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__filter) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& filter = *maybe__filter;
            // Sentinel = 'filter'
            if ((!(((&(reader__)))->ReadSentinel(146735751)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            reader__.EndRead();
            PUDPSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPUDPSocketParent(principal, filter);
            if (!actor) {
                NS_WARNING("Cannot bind null PUDPSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PUDPSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPUDPSocketConstructor(std::move(actor), principal, std::move(filter));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PDNSRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PDNSRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__hostName = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__hostName) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& hostName = *maybe__hostName;
            // Sentinel = 'hostName'
            if ((!(((&(reader__)))->ReadSentinel(249627456)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__trrServer = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__trrServer) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& trrServer = *maybe__trrServer;
            // Sentinel = 'trrServer'
            if ((!(((&(reader__)))->ReadSentinel(320603088)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__port = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__port) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& port = *maybe__port;
            // Sentinel = 'port'
            if ((!(((&(reader__)))->ReadSentinel(73990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PDNSRequestParent> actor = (static_cast<NeckoParent*>(this))->AllocPDNSRequestParent(hostName, trrServer, port, type, originAttributes, flags);
            if (!actor) {
                NS_WARNING("Cannot bind null PDNSRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PDNSRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPDNSRequestConstructor(actor, std::move(hostName), std::move(trrServer), std::move(port), std::move(type), std::move(originAttributes), std::move(flags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PDocumentChannelConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PDocumentChannelConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__browsingContext = IPC::ReadParam<MaybeDiscardedBrowsingContext>((&(reader__)));
            if (!maybe__browsingContext) {
                FatalError("Error deserializing 'MaybeDiscardedBrowsingContext'");
                return MsgValueError;

            }
            auto& browsingContext = *maybe__browsingContext;
            // Sentinel = 'browsingContext'
            if ((!(((&(reader__)))->ReadSentinel(844695121)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'MaybeDiscardedBrowsingContext'");
                return MsgValueError;
            }
            auto maybe__args = IPC::ReadParam<DocumentChannelCreationArgs>((&(reader__)));
            if (!maybe__args) {
                FatalError("Error deserializing 'DocumentChannelCreationArgs'");
                return MsgValueError;

            }
            auto& args = *maybe__args;
            // Sentinel = 'args'
            if ((!(((&(reader__)))->ReadSentinel(69140910)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DocumentChannelCreationArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            RefPtr<PDocumentChannelParent> actor = (static_cast<NeckoParent*>(this))->AllocPDocumentChannelParent(browsingContext, args);
            if (!actor) {
                NS_WARNING("Cannot bind null PDocumentChannelParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PDocumentChannelParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPDocumentChannelConstructor(actor, std::move(browsingContext), std::move(args));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PWebSocketEventListenerConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PWebSocketEventListenerConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aInnerWindowID = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__aInnerWindowID) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& aInnerWindowID = *maybe__aInnerWindowID;
            // Sentinel = 'aInnerWindowID'
            if ((!(((&(reader__)))->ReadSentinel(687670627)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            PWebSocketEventListenerParent* actor = (static_cast<NeckoParent*>(this))->AllocPWebSocketEventListenerParent(aInnerWindowID);
            if (!actor) {
                NS_WARNING("Cannot bind null PWebSocketEventListenerParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebSocketEventListenerParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPWebSocketEventListenerConstructor(std::move(actor), std::move(aInnerWindowID));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_SpeculativeConnect__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_SpeculativeConnect", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__principal = IPC::ReadParam<RefPtr<nsIPrincipal>>((&(reader__)));
            if (!maybe__principal) {
                FatalError("Error deserializing 'nsIPrincipal'");
                return MsgValueError;

            }
            auto& principal = *maybe__principal;
            // Sentinel = 'principal'
            if ((!(((&(reader__)))->ReadSentinel(319620035)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIPrincipal'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<mozilla::Maybe<OriginAttributes>>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes?'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes?'");
                return MsgValueError;
            }
            auto maybe__anonymous = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__anonymous) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& anonymous = *maybe__anonymous;
            // Sentinel = 'anonymous'
            if ((!(((&(reader__)))->ReadSentinel(322569194)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvSpeculativeConnect(uri, principal, std::move(originAttributes), std::move(anonymous));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_HTMLDNSPrefetch__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_HTMLDNSPrefetch", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__hostname = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__hostname) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& hostname = *maybe__hostname;
            // Sentinel = 'hostname'
            if ((!(((&(reader__)))->ReadSentinel(258016096)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__isHttps = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isHttps) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isHttps = *maybe__isHttps;
            // Sentinel = 'isHttps'
            if ((!(((&(reader__)))->ReadSentinel(192873200)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvHTMLDNSPrefetch(std::move(hostname), std::move(isHttps), std::move(originAttributes), std::move(flags));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_CancelHTMLDNSPrefetch__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_CancelHTMLDNSPrefetch", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__hostname = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__hostname) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& hostname = *maybe__hostname;
            // Sentinel = 'hostname'
            if ((!(((&(reader__)))->ReadSentinel(258016096)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__isHttps = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isHttps) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isHttps = *maybe__isHttps;
            // Sentinel = 'isHttps'
            if ((!(((&(reader__)))->ReadSentinel(192873200)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__flags = IPC::ReadParam<DNSFlags>((&(reader__)));
            if (!maybe__flags) {
                FatalError("Error deserializing 'DNSFlags'");
                return MsgValueError;

            }
            auto& flags = *maybe__flags;
            // Sentinel = 'flags'
            if ((!(((&(reader__)))->ReadSentinel(102171150)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'DNSFlags'");
                return MsgValueError;
            }
            auto maybe__reason = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__reason) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& reason = *maybe__reason;
            // Sentinel = 'reason'
            if ((!(((&(reader__)))->ReadSentinel(148112009)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvCancelHTMLDNSPrefetch(std::move(hostname), std::move(isHttps), std::move(originAttributes), std::move(flags), std::move(reason));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_ConnectBaseChannel__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_ConnectBaseChannel", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__channelId = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__channelId) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& channelId = *maybe__channelId;
            // Sentinel = 'channelId'
            if ((!(((&(reader__)))->ReadSentinel(301138823)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvConnectBaseChannel(std::move(channelId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PGIOChannelConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PGIOChannelConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__browser = IPC::ReadParam<PBrowserParent*>((&(reader__)));
            if (!maybe__browser) {
                FatalError("Error deserializing 'PBrowser'");
                return MsgValueError;

            }
            auto& browser = *maybe__browser;
            // Sentinel = 'browser'
            if ((!(((&(reader__)))->ReadSentinel(201130757)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PBrowser'");
                return MsgValueError;
            }
            auto maybe__loadContext = IPC::ReadParam<SerializedLoadContext>((&(reader__)));
            if (!maybe__loadContext) {
                FatalError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;

            }
            auto& loadContext = *maybe__loadContext;
            // Sentinel = 'loadContext'
            if ((!(((&(reader__)))->ReadSentinel(444990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'SerializedLoadContext'");
                return MsgValueError;
            }
            auto maybe__args = IPC::ReadParam<GIOChannelCreationArgs>((&(reader__)));
            if (!maybe__args) {
                FatalError("Error deserializing 'GIOChannelCreationArgs'");
                return MsgValueError;

            }
            auto& args = *maybe__args;
            // Sentinel = 'args'
            if ((!(((&(reader__)))->ReadSentinel(69140910)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'GIOChannelCreationArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            PGIOChannelParent* actor = (static_cast<NeckoParent*>(this))->AllocPGIOChannelParent(browser, loadContext, args);
            if (!actor) {
                NS_WARNING("Cannot bind null PGIOChannelParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PGIOChannelParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPGIOChannelConstructor(std::move(actor), browser, std::move(loadContext), std::move(args));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_NotifyFileChannelOpened__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_NotifyFileChannelOpened", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__info = IPC::ReadParam<FileChannelInfo>((&(reader__)));
            if (!maybe__info) {
                FatalError("Error deserializing 'FileChannelInfo'");
                return MsgValueError;

            }
            auto& info = *maybe__info;
            // Sentinel = 'info'
            if ((!(((&(reader__)))->ReadSentinel(70058413)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'FileChannelInfo'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvNotifyFileChannelOpened(std::move(info));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_RequestContextLoadBegin__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_RequestContextLoadBegin", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__rcid = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__rcid) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& rcid = *maybe__rcid;
            // Sentinel = 'rcid'
            if ((!(((&(reader__)))->ReadSentinel(69927331)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvRequestContextLoadBegin(std::move(rcid));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_RequestContextAfterDOMContentLoaded__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_RequestContextAfterDOMContentLoaded", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__rcid = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__rcid) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& rcid = *maybe__rcid;
            // Sentinel = 'rcid'
            if ((!(((&(reader__)))->ReadSentinel(69927331)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvRequestContextAfterDOMContentLoaded(std::move(rcid));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_RemoveRequestContext__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_RemoveRequestContext", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__rcid = IPC::ReadParam<uint64_t>((&(reader__)));
            if (!maybe__rcid) {
                FatalError("Error deserializing 'uint64_t'");
                return MsgValueError;

            }
            auto& rcid = *maybe__rcid;
            // Sentinel = 'rcid'
            if ((!(((&(reader__)))->ReadSentinel(69927331)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint64_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvRemoveRequestContext(std::move(rcid));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PCacheEntryWriteHandleConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PCacheEntryWriteHandleConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__channel = IPC::ReadParam<mozilla::NotNull<PHttpChannelParent*>>((&(reader__)));
            if (!maybe__channel) {
                FatalError("Error deserializing 'NotNull<PHttpChannel>'");
                return MsgValueError;

            }
            auto& channel = *maybe__channel;
            // Sentinel = 'channel'
            if ((!(((&(reader__)))->ReadSentinel(189334234)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PHttpChannel>'");
                return MsgValueError;
            }
            reader__.EndRead();
            PCacheEntryWriteHandleParent* actor = (static_cast<NeckoParent*>(this))->AllocPCacheEntryWriteHandleParent(channel);
            if (!actor) {
                NS_WARNING("Cannot bind null PCacheEntryWriteHandleParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PCacheEntryWriteHandleParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPCacheEntryWriteHandleConstructor(std::move(actor), channel);
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PAltDataOutputStreamConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PAltDataOutputStreamConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__type = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__type) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& type = *maybe__type;
            // Sentinel = 'type'
            if ((!(((&(reader__)))->ReadSentinel(75760067)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__predictedSize = IPC::ReadParam<int64_t>((&(reader__)));
            if (!maybe__predictedSize) {
                FatalError("Error deserializing 'int64_t'");
                return MsgValueError;

            }
            auto& predictedSize = *maybe__predictedSize;
            // Sentinel = 'predictedSize'
            if ((!(((&(reader__)))->ReadSentinel(628819280)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int64_t'");
                return MsgValueError;
            }
            auto maybe__channel = IPC::ReadParam<mozilla::Maybe<mozilla::NotNull<PHttpChannelParent*>>>((&(reader__)));
            if (!maybe__channel) {
                FatalError("Error deserializing 'NotNull<PHttpChannel>?'");
                return MsgValueError;

            }
            auto& channel = *maybe__channel;
            // Sentinel = 'channel'
            if ((!(((&(reader__)))->ReadSentinel(189334234)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PHttpChannel>?'");
                return MsgValueError;
            }
            auto maybe__handle = IPC::ReadParam<mozilla::Maybe<mozilla::NotNull<PCacheEntryWriteHandleParent*>>>((&(reader__)));
            if (!maybe__handle) {
                FatalError("Error deserializing 'NotNull<PCacheEntryWriteHandle>?'");
                return MsgValueError;

            }
            auto& handle = *maybe__handle;
            // Sentinel = 'handle'
            if ((!(((&(reader__)))->ReadSentinel(142344813)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'NotNull<PCacheEntryWriteHandle>?'");
                return MsgValueError;
            }
            reader__.EndRead();
            PAltDataOutputStreamParent* actor = (static_cast<NeckoParent*>(this))->AllocPAltDataOutputStreamParent(type, predictedSize, channel, handle);
            if (!actor) {
                NS_WARNING("Cannot bind null PAltDataOutputStreamParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PAltDataOutputStreamParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPAltDataOutputStreamConstructor(std::move(actor), std::move(type), std::move(predictedSize), std::move(channel), std::move(handle));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PStunAddrsRequestConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PStunAddrsRequestConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            reader__.EndRead();
            PStunAddrsRequestParent* actor = (static_cast<NeckoParent*>(this))->AllocPStunAddrsRequestParent();
            if (!actor) {
                NS_WARNING("Cannot bind null PStunAddrsRequestParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PStunAddrsRequestParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPStunAddrsRequestConstructor(std::move(actor));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_PWebrtcTCPSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PWebrtcTCPSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__tabId = IPC::ReadParam<mozilla::Maybe<TabId>>((&(reader__)));
            if (!maybe__tabId) {
                FatalError("Error deserializing 'TabId?'");
                return MsgValueError;

            }
            auto& tabId = *maybe__tabId;
            // Sentinel = 'tabId'
            if ((!(((&(reader__)))->ReadSentinel(99156453)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'TabId?'");
                return MsgValueError;
            }
            reader__.EndRead();
            PWebrtcTCPSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPWebrtcTCPSocketParent(tabId);
            if (!actor) {
                NS_WARNING("Cannot bind null PWebrtcTCPSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PWebrtcTCPSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPWebrtcTCPSocketConstructor(std::move(actor), std::move(tabId));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_GetExtensionStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_GetExtensionStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_GetExtensionStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetExtensionStreamResolver resolver = [resolver__ = std::move(resolver__)](nsIInputStream* aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'stream'
                    ((&(writer__)))->WriteSentinel(153223821);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvGetExtensionStream(uri, std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_GetExtensionFD__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_GetExtensionFD", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_GetExtensionFD(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetExtensionFDResolver resolver = [resolver__ = std::move(resolver__)](const FileDescriptor& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'fd'
                    ((&(writer__)))->WriteSentinel(20054219);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvGetExtensionFD(uri, std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_InitSocketProcessBridge__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_InitSocketProcessBridge", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_InitSocketProcessBridge(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            InitSocketProcessBridgeResolver resolver = [resolver__ = std::move(resolver__)](Endpoint<::mozilla::net::PSocketProcessBridgeChild>&& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), std::move(aParam));
                    // Sentinel = 'endpoint'
                    ((&(writer__)))->WriteSentinel(251724642);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvInitSocketProcessBridge(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_ResetSocketProcessBridge__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_ResetSocketProcessBridge", OTHER);

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvResetSocketProcessBridge();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_EnsureHSTSData__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_EnsureHSTSData", OTHER);

            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_EnsureHSTSData(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            EnsureHSTSDataResolver resolver = [resolver__ = std::move(resolver__)](const bool& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'result'
                    ((&(writer__)))->WriteSentinel(153223840);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvEnsureHSTSData(std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_GetPageThumbStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_GetPageThumbStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__loadInfo = IPC::ReadParam<LoadInfoArgs>((&(reader__)));
            if (!maybe__loadInfo) {
                FatalError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;

            }
            auto& loadInfo = *maybe__loadInfo;
            // Sentinel = 'loadInfo'
            if ((!(((&(reader__)))->ReadSentinel(240386861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_GetPageThumbStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetPageThumbStreamResolver resolver = [resolver__ = std::move(resolver__)](const mozilla::Maybe<RemoteStreamInfo>& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'info'
                    ((&(writer__)))->WriteSentinel(70058413);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvGetPageThumbStream(uri, std::move(loadInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_GetPageIconStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_GetPageIconStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__loadInfo = IPC::ReadParam<LoadInfoArgs>((&(reader__)));
            if (!maybe__loadInfo) {
                FatalError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;

            }
            auto& loadInfo = *maybe__loadInfo;
            // Sentinel = 'loadInfo'
            if ((!(((&(reader__)))->ReadSentinel(240386861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_GetPageIconStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetPageIconStreamResolver resolver = [resolver__ = std::move(resolver__)](const mozilla::Maybe<RemoteStreamInfo>& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'info'
                    ((&(writer__)))->WriteSentinel(70058413);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvGetPageIconStream(uri, std::move(loadInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Msg_GetMozNewTabWallpaperStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_GetMozNewTabWallpaperStream", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__loadInfo = IPC::ReadParam<LoadInfoArgs>((&(reader__)));
            if (!maybe__loadInfo) {
                FatalError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;

            }
            auto& loadInfo = *maybe__loadInfo;
            // Sentinel = 'loadInfo'
            if ((!(((&(reader__)))->ReadSentinel(240386861)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'LoadInfoArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::ActorId id__ = Id();
            UniquePtr<IPC::Message> reply__(PNecko::Reply_GetMozNewTabWallpaperStream(id__));
            reply__->set_seqno(msg__.seqno());

            RefPtr<mozilla::ipc::IPDLResolverInner> resolver__ =
                new mozilla::ipc::IPDLResolverInner(std::move(reply__), this);

            GetMozNewTabWallpaperStreamResolver resolver = [resolver__ = std::move(resolver__)](const mozilla::Maybe<RemoteStreamInfo>& aParam) {
                resolver__->Resolve([&] (IPC::Message* reply__, IProtocol* self__) {
                    IPC::MessageWriter writer__(*reply__, self__);
                    IPC::WriteParam((&(writer__)), aParam);
                    // Sentinel = 'info'
                    ((&(writer__)))->WriteSentinel(70058413);

                    if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                        mozilla::ipc::LogMessageForProtocol(
                            "PNeckoParent",
                            self__->ToplevelProtocol()->OtherPidMaybeInvalid(),
                            "Sending reply ",
                            reply__->type(),
                            mozilla::ipc::MessageDirection::eSending);
                    }

                });
            };
            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvGetMozNewTabWallpaperStream(uri, std::move(loadInfo), std::move(resolver));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PNecko::Reply_PTransportProviderConstructor__ID:
        {
            return MsgProcessed;
        }
    case PNecko::Reply_PTCPSocketConstructor__ID:
        {
            return MsgProcessed;
        }
    case PNecko::Msg_PTCPSocketConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PNecko", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PNeckoParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PNecko::Msg_PTCPSocketConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__host = IPC::ReadParam<nsString>((&(reader__)));
            if (!maybe__host) {
                FatalError("Error deserializing 'nsString'");
                return MsgValueError;

            }
            auto& host = *maybe__host;
            // Sentinel = 'host'
            if ((!(((&(reader__)))->ReadSentinel(72024511)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsString'");
                return MsgValueError;
            }
            auto maybe__port = IPC::ReadParam<uint16_t>((&(reader__)));
            if (!maybe__port) {
                FatalError("Error deserializing 'uint16_t'");
                return MsgValueError;

            }
            auto& port = *maybe__port;
            // Sentinel = 'port'
            if ((!(((&(reader__)))->ReadSentinel(73990598)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            PTCPSocketParent* actor = (static_cast<NeckoParent*>(this))->AllocPTCPSocketParent(host, port);
            if (!actor) {
                NS_WARNING("Cannot bind null PTCPSocketParent actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PTCPSocketParent actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (static_cast<NeckoParent*>(this))->RecvPTCPSocketConstructor(std::move(actor), std::move(host), std::move(port));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PNeckoParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PNeckoParent::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PNeckoParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PNecko'
    (aWriter)->WriteSentinel(124650049);
}

auto ParamTraits<::mozilla::net::PNeckoParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PNecko actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PNecko'
    if ((!((aReader)->ReadSentinel(124650049)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PNecko actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PNeckoMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PNecko)");

        return {};
    }
    return static_cast<::mozilla::net::PNeckoParent*>(actor);
}

} // namespace IPC
