//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/dom/PClientManagerChild.h"
#include "ipc/ErrorIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingIPCUtils.h"
#include "mozilla/dom/ClientIPCUtils.h"

#include "mozilla/ipc/PBackgroundChild.h"
#include "mozilla/dom/PClientHandleChild.h"
#include "mozilla/dom/PClientManagerOpChild.h"
#include "mozilla/dom/PClientNavigateOpChild.h"
#include "mozilla/dom/PClientSourceChild.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace dom {


auto PClientManagerChild::RecvPClientNavigateOpConstructor(
        PClientNavigateOpChild* actor,
        const ClientNavigateOpConstructorArgs& aArgs) -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

auto PClientManagerChild::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PClientManagerChild::PClientManagerChild() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ChildSide)
{
    MOZ_COUNT_CTOR(PClientManagerChild);
}

PClientManagerChild::~PClientManagerChild()
{
    MOZ_COUNT_DTOR(PClientManagerChild);
}

auto PClientManagerChild::ActorAlloc() -> void
{
    AddRef();
}

auto PClientManagerChild::ActorDealloc() -> void
{
    Release();
}

auto PClientManagerChild::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PClientManagerChild::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PClientManagerChild::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PClientManagerChild::Manager() const -> PBackgroundChild*
{
    return static_cast<PBackgroundChild*>(IProtocol::Manager());
}

auto PClientManagerChild::ManagedPClientHandleChild(nsTArray<PClientHandleChild*>& aArr) const -> void
{
    mManagedPClientHandleChild.ToArray(aArr);
}

auto PClientManagerChild::ManagedPClientHandleChild() const -> const ManagedContainer<PClientHandleChild>&
{
    return mManagedPClientHandleChild;
}

auto PClientManagerChild::ManagedPClientManagerOpChild(nsTArray<PClientManagerOpChild*>& aArr) const -> void
{
    mManagedPClientManagerOpChild.ToArray(aArr);
}

auto PClientManagerChild::ManagedPClientManagerOpChild() const -> const ManagedContainer<PClientManagerOpChild>&
{
    return mManagedPClientManagerOpChild;
}

auto PClientManagerChild::ManagedPClientNavigateOpChild(nsTArray<PClientNavigateOpChild*>& aArr) const -> void
{
    mManagedPClientNavigateOpChild.ToArray(aArr);
}

auto PClientManagerChild::ManagedPClientNavigateOpChild() const -> const ManagedContainer<PClientNavigateOpChild>&
{
    return mManagedPClientNavigateOpChild;
}

auto PClientManagerChild::ManagedPClientSourceChild(nsTArray<PClientSourceChild*>& aArr) const -> void
{
    mManagedPClientSourceChild.ToArray(aArr);
}

auto PClientManagerChild::ManagedPClientSourceChild() const -> const ManagedContainer<PClientSourceChild>&
{
    return mManagedPClientSourceChild;
}

auto PClientManagerChild::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    static constexpr ::mozilla::ipc::ProtocolId sIds[] = {
        PClientHandleMsgStart,
        PClientManagerOpMsgStart,
        PClientNavigateOpMsgStart,
        PClientSourceMsgStart
    };
    return sIds;
}

auto PClientManagerChild::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    case PClientHandleMsgStart:
        return (&(mManagedPClientHandleChild));
    case PClientManagerOpMsgStart:
        return (&(mManagedPClientManagerOpChild));
    case PClientNavigateOpMsgStart:
        return (&(mManagedPClientNavigateOpChild));
    case PClientSourceMsgStart:
        return (&(mManagedPClientSourceChild));
    default:
        return nullptr;
    }
}

auto PClientManagerChild::OpenPClientHandleEndpoint(PClientHandleChild* aActor) -> ManagedEndpoint<PClientHandleParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientHandleChild actor");
        return ManagedEndpoint<PClientHandleParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleChild actor");
        return ManagedEndpoint<PClientHandleParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientHandleParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerChild::BindPClientHandleEndpoint(
        ManagedEndpoint<PClientHandleChild> aEndpoint,
        PClientHandleChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerChild::OpenPClientManagerOpEndpoint(PClientManagerOpChild* aActor) -> ManagedEndpoint<PClientManagerOpParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientManagerOpChild actor");
        return ManagedEndpoint<PClientManagerOpParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientManagerOpChild actor");
        return ManagedEndpoint<PClientManagerOpParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientManagerOpParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerChild::BindPClientManagerOpEndpoint(
        ManagedEndpoint<PClientManagerOpChild> aEndpoint,
        PClientManagerOpChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerChild::OpenPClientNavigateOpEndpoint(PClientNavigateOpChild* aActor) -> ManagedEndpoint<PClientNavigateOpParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientNavigateOpChild actor");
        return ManagedEndpoint<PClientNavigateOpParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientNavigateOpChild actor");
        return ManagedEndpoint<PClientNavigateOpParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientNavigateOpParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerChild::BindPClientNavigateOpEndpoint(
        ManagedEndpoint<PClientNavigateOpChild> aEndpoint,
        PClientNavigateOpChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerChild::OpenPClientSourceEndpoint(PClientSourceChild* aActor) -> ManagedEndpoint<PClientSourceParent>
{
    if (!aActor) {
        NS_WARNING("Cannot bind null PClientSourceChild actor");
        return ManagedEndpoint<PClientSourceParent>();
    }

    if (!aActor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientSourceChild actor");
        return ManagedEndpoint<PClientSourceParent>();
    }

    // Mark our actor as awaiting the other side to be bound. This will
    // be cleared when a `MANAGED_ENDPOINT_{DROPPED,BOUND}` message is
    // received.
    aActor->mAwaitingManagedEndpointBind = true;
    return ManagedEndpoint<PClientSourceParent>(mozilla::ipc::PrivateIPDLInterface(), aActor);
}

auto PClientManagerChild::BindPClientSourceEndpoint(
        ManagedEndpoint<PClientSourceChild> aEndpoint,
        PClientSourceChild* aActor) -> bool
{
    return aEndpoint.Bind(mozilla::ipc::PrivateIPDLInterface(), aActor, this);
}

auto PClientManagerChild::SendTeardown() -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_Teardown(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_Teardown", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientManagerChild::SendPClientHandleConstructor(
        PClientHandleChild* actor,
        const IPCClientInfo& aClientInfo) -> PClientHandleChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientHandleChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientHandleChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_PClientHandleConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aClientInfo);
    // Sentinel = 'aClientInfo'
    ((&(writer__)))->WriteSentinel(422315085);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_PClientHandleConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientHandleChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientManagerChild::SendPClientManagerOpConstructor(const ClientOpConstructorArgs& aArgs) -> PClientManagerOpChild*
{
    PClientManagerOpChild* actor = (this)->AllocPClientManagerOpChild(aArgs);
    return SendPClientManagerOpConstructor(std::move(actor), std::move(aArgs));
}

auto PClientManagerChild::SendPClientManagerOpConstructor(
        PClientManagerOpChild* actor,
        const ClientOpConstructorArgs& aArgs) -> PClientManagerOpChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientManagerOpChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientManagerOpChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_PClientManagerOpConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_PClientManagerOpConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientManagerOpChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientManagerChild::SendPClientSourceConstructor(
        PClientSourceChild* actor,
        const ClientSourceConstructorArgs& aArgs) -> PClientSourceChild*
{
    if (!actor) {
        NS_WARNING("Cannot bind null PClientSourceChild actor");
        return nullptr;
    }

    if (!actor->SetManagerAndRegister(this)) {
        NS_WARNING("Failed to bind PClientSourceChild actor");
        return nullptr;
    }


    // Build our constructor message.
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_PClientSourceConstructor(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), (actor)->Id());
    // Sentinel = 'actorid'
    ((&(writer__)))->WriteSentinel(193725159);
    IPC::WriteParam((&(writer__)), aArgs);
    // Sentinel = 'aArgs'
    ((&(writer__)))->WriteSentinel(92602863);


    // Notify the other side about the newly created actor. This can
    // fail if our manager has already been destroyed.
    //
    // NOTE: If the send call fails due to toplevel channel teardown,
    // the `IProtocol::ChannelSend` wrapper absorbs the error for us,
    // so we don't tear down actors unexpectedly.

    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_PClientSourceConstructor", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));


    // Warn, destroy the actor, and return null if the message failed to
    // send. Otherwise, return the successfully created actor reference.
    if (!sendok__) {
        NS_WARNING("Error sending PClientSourceChild constructor");
        actor->ActorDisconnected(FailedConstructor);

        return nullptr;
    }
    return actor;
}

auto PClientManagerChild::SendExpectFutureClientSource(const IPCClientInfo& aClientInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_ExpectFutureClientSource(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aClientInfo);
    // Sentinel = 'aClientInfo'
    ((&(writer__)))->WriteSentinel(422315085);


    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_ExpectFutureClientSource", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientManagerChild::SendForgetFutureClientSource(const IPCClientInfo& aClientInfo) -> bool
{
    UniquePtr<IPC::Message> msg__ = PClientManager::Msg_ForgetFutureClientSource(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), aClientInfo);
    // Sentinel = 'aClientInfo'
    ((&(writer__)))->WriteSentinel(422315085);


    if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PClientManagerChild",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PClientManager::Msg_ForgetFutureClientSource", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PClientManagerChild::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    switch (aProtocolId) {
    case PClientManagerOpMsgStart:
        this->DeallocPClientManagerOpChild(static_cast<PClientManagerOpChild*>(aListener));
        return;
    case PClientNavigateOpMsgStart:
        this->DeallocPClientNavigateOpChild(static_cast<PClientNavigateOpChild*>(aListener));
        return;
    default:
        FatalError("unreached");
        return;
    }
}

auto PClientManagerChild::OnMessageReceived(const Message& msg__) -> PClientManagerChild::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PClientManager::Reply_PClientHandleConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientManager::Reply_PClientManagerOpConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientManager::Reply_PClientSourceConstructor__ID:
        {
            return MsgProcessed;
        }
    case PClientManager::Msg_PClientNavigateOpConstructor__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg_PClientNavigateOpConstructor", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__actorid__ = IPC::ReadParam<mozilla::ipc::ActorId>((&(reader__)));
            if (!maybe__actorid__) {
                FatalError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;

            }
            auto& actorid__ = *maybe__actorid__;
            // Sentinel = 'actorid'
            if ((!(((&(reader__)))->ReadSentinel(193725159)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'mozilla::ipc::ActorId'");
                return MsgValueError;
            }
            auto maybe__aArgs = IPC::ReadParam<ClientNavigateOpConstructorArgs>((&(reader__)));
            if (!maybe__aArgs) {
                FatalError("Error deserializing 'ClientNavigateOpConstructorArgs'");
                return MsgValueError;

            }
            auto& aArgs = *maybe__aArgs;
            // Sentinel = 'aArgs'
            if ((!(((&(reader__)))->ReadSentinel(92602863)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClientNavigateOpConstructorArgs'");
                return MsgValueError;
            }
            reader__.EndRead();
            PClientNavigateOpChild* actor = (this)->AllocPClientNavigateOpChild(aArgs);
            if (!actor) {
                NS_WARNING("Cannot bind null PClientNavigateOpChild actor");
                return MsgValueError;
            }

            if (!actor->SetManagerAndRegister(this, actorid__)) {
                NS_WARNING("Failed to bind PClientNavigateOpChild actor");
                return MsgValueError;
            }

            mozilla::ipc::IPCResult __ok = (this)->RecvPClientNavigateOpConstructor(std::move(actor), std::move(aArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PClientManager::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PClientManager", mozilla::ipc::ChildSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PClientManagerChild",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PClientManager::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PClientManagerChild::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PClientManagerChild::Result
{
    return MsgNotKnown;
}



} // namespace dom
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::dom::PClientManagerChild*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PClientManager'
    (aWriter)->WriteSentinel(659817835);
}

auto ParamTraits<::mozilla::dom::PClientManagerChild*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PClientManager actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PClientManager'
    if ((!((aReader)->ReadSentinel(659817835)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PClientManager actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PClientManagerMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PClientManager)");

        return {};
    }
    return static_cast<::mozilla::dom::PClientManagerChild*>(actor);
}

} // namespace IPC
