/* automatically generated by rust-bindgen 0.72.0 */

#[allow(unknown_lints, ambiguous_glob_reexports)]
pub use self::root::*;
pub use self::root::mozilla::*;
pub use self::root::mozilla::css::*;
pub use self::root::mozilla::dom::*;
pub type RustCell<T> = ::std::cell::Cell<T>;
pub type ServoNodeData = atomic_refcell::AtomicRefCell<crate::data::ElementData>;
pub type ServoWritingMode = crate::logical_geometry::WritingMode;
pub type ServoComputedCustomProperties = crate::custom_properties::ComputedCustomProperties;
pub type ServoRuleNode = Option<crate::rule_tree::StrongRuleNode>;
pub type nsACString = nsstring::nsACString;
pub type nsAString = nsstring::nsAString;
pub type nsCString = nsstring::nsCString;
pub type nsString = nsstring::nsString;
pub type nsTArray<T> = thin_vec::ThinVec<T>;
pub type CopyableTArray<T> = thin_vec::ThinVec<T>;

#[allow(non_snake_case, non_camel_case_types, non_upper_case_globals)]
pub mod root {
    #[repr(C)]
    #[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
    pub struct __BindgenBitfieldUnit<Storage> {
        storage: Storage,
    }
    impl<Storage> __BindgenBitfieldUnit<Storage> {
        #[inline]
        pub const fn new(storage: Storage) -> Self {
            Self { storage }
        }
    }
    impl<Storage> __BindgenBitfieldUnit<Storage>
    where
        Storage: AsRef<[u8]> + AsMut<[u8]>,
    {
        #[inline]
        fn extract_bit(byte: u8, index: usize) -> bool {
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            byte & mask == mask
        }
        #[inline]
        pub fn get_bit(&self, index: usize) -> bool {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = self.storage.as_ref()[byte_index];
            Self::extract_bit(byte, index)
        }
        #[inline]
        pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
            debug_assert!(index / 8 < core::mem::size_of::<Storage>());
            let byte_index = index / 8;
            let byte = unsafe {
                *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize)
            };
            Self::extract_bit(byte, index)
        }
        #[inline]
        fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
            let bit_index = if cfg!(target_endian = "big") {
                7 - (index % 8)
            } else {
                index % 8
            };
            let mask = 1 << bit_index;
            if val { byte | mask } else { byte & !mask }
        }
        #[inline]
        pub fn set_bit(&mut self, index: usize, val: bool) {
            debug_assert!(index / 8 < self.storage.as_ref().len());
            let byte_index = index / 8;
            let byte = &mut self.storage.as_mut()[byte_index];
            *byte = Self::change_bit(*byte, index, val);
        }
        #[inline]
        pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
            debug_assert!(index / 8 < core::mem::size_of::<Storage>());
            let byte_index = index / 8;
            let byte = unsafe {
                (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize)
            };
            unsafe { *byte = Self::change_bit(*byte, index, val) };
        }
        #[inline]
        pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            let mut val = 0;
            for i in 0..(bit_width as usize) {
                if self.get_bit(i + bit_offset) {
                    let index = if cfg!(target_endian = "big") {
                        bit_width as usize - 1 - i
                    } else {
                        i
                    };
                    val |= 1 << index;
                }
            }
            val
        }
        #[inline]
        pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
            debug_assert!(
                (bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>()
            );
            let mut val = 0;
            for i in 0..(bit_width as usize) {
                if unsafe { Self::raw_get_bit(this, i + bit_offset) } {
                    let index = if cfg!(target_endian = "big") {
                        bit_width as usize - 1 - i
                    } else {
                        i
                    };
                    val |= 1 << index;
                }
            }
            val
        }
        #[inline]
        pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
            debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
            for i in 0..(bit_width as usize) {
                let mask = 1 << i;
                let val_bit_is_set = val & mask == mask;
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                self.set_bit(index + bit_offset, val_bit_is_set);
            }
        }
        #[inline]
        pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
            debug_assert!(bit_width <= 64);
            debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
            debug_assert!(
                (bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>()
            );
            for i in 0..(bit_width as usize) {
                let mask = 1 << i;
                let val_bit_is_set = val & mask == mask;
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                unsafe { Self::raw_set_bit(this, index + bit_offset, val_bit_is_set) };
            }
        }
    }
    #[derive(PartialEq, Eq, Copy, Clone, Debug, Hash)]
    #[repr(C)]
    pub struct __BindgenOpaqueArray<T>(pub T);
    impl<T: Copy + Default, const N: usize> Default for __BindgenOpaqueArray<[T; N]> {
        fn default() -> Self {
            Self([<T as Default>::default(); N])
        }
    }
    #[derive(PartialEq, Eq, Copy, Clone, Debug, Hash)]
    #[repr(C, align(8))]
    pub struct __BindgenOpaqueArray8<T>(pub T);
    impl<T: Copy + Default, const N: usize> Default for __BindgenOpaqueArray8<[T; N]> {
        fn default() -> Self {
            Self([<T as Default>::default(); N])
        }
    }
    #[repr(C)]
    #[derive(Default)]
    pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
    impl<T> __IncompleteArrayField<T> {
        #[inline]
        pub const fn new() -> Self {
            __IncompleteArrayField(::std::marker::PhantomData, [])
        }
        #[inline]
        pub fn as_ptr(&self) -> *const T {
            self as *const _ as *const T
        }
        #[inline]
        pub fn as_mut_ptr(&mut self) -> *mut T {
            self as *mut _ as *mut T
        }
        #[inline]
        pub unsafe fn as_slice(&self, len: usize) -> &[T] {
            ::std::slice::from_raw_parts(self.as_ptr(), len)
        }
        #[inline]
        pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
            ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
        }
    }
    impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
        fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
            fmt.write_str("__IncompleteArrayField")
        }
    }
    #[repr(C)]
    pub struct __BindgenUnionField<T>(::std::marker::PhantomData<T>);
    impl<T> __BindgenUnionField<T> {
        #[inline]
        pub const fn new() -> Self {
            __BindgenUnionField(::std::marker::PhantomData)
        }
        #[inline]
        pub unsafe fn as_ref(&self) -> &T {
            ::std::mem::transmute(self)
        }
        #[inline]
        pub unsafe fn as_mut(&mut self) -> &mut T {
            ::std::mem::transmute(self)
        }
    }
    impl<T> ::std::default::Default for __BindgenUnionField<T> {
        #[inline]
        fn default() -> Self {
            Self::new()
        }
    }
    impl<T> ::std::clone::Clone for __BindgenUnionField<T> {
        #[inline]
        fn clone(&self) -> Self {
            *self
        }
    }
    impl<T> ::std::marker::Copy for __BindgenUnionField<T> {}
    impl<T> ::std::fmt::Debug for __BindgenUnionField<T> {
        fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
            fmt.write_str("__BindgenUnionField")
        }
    }
    impl<T> ::std::hash::Hash for __BindgenUnionField<T> {
        fn hash<H: ::std::hash::Hasher>(&self, _state: &mut H) {}
    }
    impl<T> ::std::cmp::PartialEq for __BindgenUnionField<T> {
        fn eq(&self, _other: &__BindgenUnionField<T>) -> bool {
            true
        }
    }
    impl<T> ::std::cmp::Eq for __BindgenUnionField<T> {}
    #[allow(unused_imports)]
    use self::super::root;
    pub const NS_FONT_STYLE_NORMAL: u32 = 0;
    pub const NS_FONT_STYLE_ITALIC: u32 = 1;
    pub const NS_FONT_STYLE_OBLIQUE: u32 = 2;
    pub const NS_FONT_WEIGHT_NORMAL: u32 = 400;
    pub const NS_FONT_WEIGHT_BOLD: u32 = 700;
    pub const NS_FONT_WEIGHT_THIN: u32 = 100;
    pub const NS_FONT_STRETCH_ULTRA_CONDENSED: u32 = 50;
    pub const NS_FONT_STRETCH_EXTRA_CONDENSED: u32 = 62;
    pub const NS_FONT_STRETCH_CONDENSED: u32 = 75;
    pub const NS_FONT_STRETCH_SEMI_CONDENSED: u32 = 87;
    pub const NS_FONT_STRETCH_NORMAL: u32 = 100;
    pub const NS_FONT_STRETCH_SEMI_EXPANDED: u32 = 112;
    pub const NS_FONT_STRETCH_EXPANDED: u32 = 125;
    pub const NS_FONT_STRETCH_EXTRA_EXPANDED: u32 = 150;
    pub const NS_FONT_STRETCH_ULTRA_EXPANDED: u32 = 200;
    pub const NS_FONT_SMOOTHING_AUTO: u32 = 0;
    pub const NS_FONT_SMOOTHING_GRAYSCALE: u32 = 1;
    pub const NS_FONT_SMOOTHING_SUBPIXEL_ANTIALIASED: u32 = 2;
    pub const NS_FONT_KERNING_AUTO: u32 = 0;
    pub const NS_FONT_KERNING_NONE: u32 = 1;
    pub const NS_FONT_KERNING_NORMAL: u32 = 2;
    pub const NS_FONT_OPTICAL_SIZING_AUTO: u32 = 0;
    pub const NS_FONT_OPTICAL_SIZING_NONE: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_ALTERNATES_HISTORICAL: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLISTIC: u32 = 2;
    pub const NS_FONT_VARIANT_ALTERNATES_STYLESET: u32 = 4;
    pub const NS_FONT_VARIANT_ALTERNATES_CHARACTER_VARIANT: u32 = 8;
    pub const NS_FONT_VARIANT_ALTERNATES_SWASH: u32 = 16;
    pub const NS_FONT_VARIANT_ALTERNATES_ORNAMENTS: u32 = 32;
    pub const NS_FONT_VARIANT_ALTERNATES_ANNOTATION: u32 = 64;
    pub const NS_FONT_VARIANT_ALTERNATES_COUNT: u32 = 7;
    pub const NS_FONT_VARIANT_ALTERNATES_ENUMERATED_MASK: u32 = 1;
    pub const NS_FONT_VARIANT_ALTERNATES_FUNCTIONAL_MASK: u32 = 126;
    pub const NS_FONT_VARIANT_CAPS_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_CAPS_SMALLCAPS: u32 = 1;
    pub const NS_FONT_VARIANT_CAPS_ALLSMALL: u32 = 2;
    pub const NS_FONT_VARIANT_CAPS_PETITECAPS: u32 = 3;
    pub const NS_FONT_VARIANT_CAPS_ALLPETITE: u32 = 4;
    pub const NS_FONT_VARIANT_CAPS_TITLING: u32 = 5;
    pub const NS_FONT_VARIANT_CAPS_UNICASE: u32 = 6;
    pub const NS_FONT_VARIANT_POSITION_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_POSITION_SUPER: u32 = 1;
    pub const NS_FONT_VARIANT_POSITION_SUB: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_WIDTH_FULL: u32 = 1;
    pub const NS_FONT_VARIANT_WIDTH_HALF: u32 = 2;
    pub const NS_FONT_VARIANT_WIDTH_THIRD: u32 = 3;
    pub const NS_FONT_VARIANT_WIDTH_QUARTER: u32 = 4;
    pub const NS_FONT_SUBSCRIPT_OFFSET_RATIO: f64 = 0.2;
    pub const NS_FONT_SUPERSCRIPT_OFFSET_RATIO: f64 = 0.34;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_SMALL: f64 = 0.82;
    pub const NS_FONT_SUB_SUPER_SIZE_RATIO_LARGE: f64 = 0.667;
    pub const NS_FONT_SUB_SUPER_SMALL_SIZE: f64 = 20.0;
    pub const NS_FONT_SUB_SUPER_LARGE_SIZE: f64 = 45.0;
    pub const CSS_PSEUDO_ELEMENT_IS_CSS2: u32 = 1;
    pub const CSS_PSEUDO_ELEMENT_SUPPORTS_USER_ACTION_STATE: u32 = 8;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS: u32 = 16;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_CHROME: u32 = 32;
    pub const CSS_PSEUDO_ELEMENT_ENABLED_IN_UA_SHEETS_AND_CHROME: u32 = 48;
    pub const CSS_PSEUDO_ELEMENT_IS_JS_CREATED_NAC: u32 = 64;
    pub const CSS_PSEUDO_ELEMENT_IS_FLEX_OR_GRID_ITEM: u32 = 128;
    pub const NS_ATTRVALUE_MAX_STRINGLENGTH_ATOM: u32 = 12;
    pub const NS_ATTRVALUE_INTEGERTYPE_BITS: u32 = 4;
    pub const NS_ATTRVALUE_INTEGERTYPE_MULTIPLIER: u32 = 16;
    pub const NS_ATTRVALUE_INTEGERTYPE_MAXVALUE: u32 = 134217727;
    pub const NS_ATTRVALUE_INTEGERTYPE_MINVALUE: i32 = -134217728;
    pub const NS_ATTRVALUE_ENUMTABLEINDEX_BITS: u32 = 12;
    pub const NS_ATTRVALUE_ENUMTABLE_VALUE_NEEDS_TO_UPPER: u32 = 2048;
    pub const NS_ATTRVALUE_ENUMTABLEINDEX_MAXVALUE: u32 = 2047;
    pub const NS_FONT_VARIANT_NORMAL: u32 = 0;
    pub const NS_FONT_VARIANT_SMALL_CAPS: u32 = 1;
    pub const kNameSpaceID_Unknown: i32 = -1;
    pub const kNameSpaceID_XMLNS: u32 = 1;
    pub const kNameSpaceID_XML: u32 = 2;
    pub const kNameSpaceID_XHTML: u32 = 3;
    pub const kNameSpaceID_XLink: u32 = 4;
    pub const kNameSpaceID_XSLT: u32 = 5;
    pub const kNameSpaceID_MathML: u32 = 6;
    pub const kNameSpaceID_RDF: u32 = 7;
    pub const kNameSpaceID_XUL: u32 = 8;
    pub const kNameSpaceID_SVG: u32 = 9;
    pub const kNameSpaceID_disabled_MathML: u32 = 10;
    pub const kNameSpaceID_disabled_SVG: u32 = 11;
    pub const kNameSpaceID_LastBuiltin: u32 = 11;
    pub const kNameSpaceID_Wildcard: i32 = -2147483648;
    pub mod std {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub type integral_constant_value_type<_Tp> = _Tp;
        pub type integral_constant_type = u8;
        pub type true_type = u8;
        pub type false_type = u8;
        pub type __conditional_type<_Tp> = _Tp;
        pub type __conditional_t = u8;
        pub mod __detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct __iter_traits_impl {
                pub _address: u8,
            }
            pub type __iter_traits_impl_type = root::std::iterator_traits;
            pub type __iter_traits = root::std::__detail::__iter_traits_impl;
            pub type __iter_diff_t = root::std::__detail::__iter_traits;
            pub type __iter_value_t = root::std::__detail::__iter_traits;
            pub type __clamp_iter_cat = root::std::__conditional_t;
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_const {
            pub _address: u8,
        }
        pub type remove_const_type<_Tp> = _Tp;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_cv {
            pub _address: u8,
        }
        pub type remove_cv_type<_Tp> = _Tp;
        pub type remove_const_t = root::std::remove_const;
        pub type remove_cv_t = root::std::remove_cv;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_reference {
            pub _address: u8,
        }
        pub type remove_reference_type<_Tp> = _Tp;
        pub type remove_reference_t = root::std::remove_reference;
        pub type make_signed_t = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct add_pointer {
            pub _address: u8,
        }
        pub type add_pointer_type<_Tp> = _Tp;
        pub type add_pointer_t = root::std::add_pointer;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct decay {
            pub _address: u8,
        }
        pub type decay_type<_Tp> = _Tp;
        pub type conditional_type<_Iftrue> = _Iftrue;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct __invoke_result {
            pub _address: u8,
        }
        pub type decay_t = root::std::decay;
        pub type conditional_t = u8;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct invoke_result {
            pub _address: u8,
        }
        pub type invoke_result_t = root::std::invoke_result;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct remove_cvref {
            pub _address: u8,
        }
        pub type remove_cvref_type<_Tp> = _Tp;
        pub type remove_cvref_t = root::std::remove_cvref;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct nothrow_t {
            pub _address: u8,
        }
        #[allow(clippy::unnecessary_operation, clippy::identity_op)]
        const _: () = {
            ["Size of nothrow_t"][::std::mem::size_of::<nothrow_t>() - 1usize];
            ["Alignment of nothrow_t"][::std::mem::align_of::<nothrow_t>() - 1usize];
        };
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct atomic {
            pub _address: u8,
        }
        pub type atomic_value_type<_Tp> = _Tp;
        pub mod ranges {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub type iter_reference_t = u8;
        pub type iter_difference_t = root::std::__detail::__iter_diff_t;
        pub type iter_value_t = root::std::__detail::__iter_value_t;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct input_iterator_tag {
            pub _address: u8,
        }
        #[allow(clippy::unnecessary_operation, clippy::identity_op)]
        const _: () = {
            ["Size of input_iterator_tag"][::std::mem::size_of::<input_iterator_tag>() - 1usize];
            ["Alignment of input_iterator_tag"]
                [::std::mem::align_of::<input_iterator_tag>() - 1usize];
        };
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct forward_iterator_tag {
            pub _address: u8,
        }
        #[allow(clippy::unnecessary_operation, clippy::identity_op)]
        const _: () = {
            ["Size of forward_iterator_tag"]
                [::std::mem::size_of::<forward_iterator_tag>() - 1usize];
            ["Alignment of forward_iterator_tag"]
                [::std::mem::align_of::<forward_iterator_tag>() - 1usize];
        };
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct bidirectional_iterator_tag {
            pub _address: u8,
        }
        #[allow(clippy::unnecessary_operation, clippy::identity_op)]
        const _: () = {
            ["Size of bidirectional_iterator_tag"]
                [::std::mem::size_of::<bidirectional_iterator_tag>() - 1usize];
            ["Alignment of bidirectional_iterator_tag"]
                [::std::mem::align_of::<bidirectional_iterator_tag>() - 1usize];
        };
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct random_access_iterator_tag {
            pub _address: u8,
        }
        #[allow(clippy::unnecessary_operation, clippy::identity_op)]
        const _: () = {
            ["Size of random_access_iterator_tag"]
                [::std::mem::size_of::<random_access_iterator_tag>() - 1usize];
            ["Alignment of random_access_iterator_tag"]
                [::std::mem::align_of::<random_access_iterator_tag>() - 1usize];
        };
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct iterator {
            pub _address: u8,
        }
        pub type iterator_iterator_category<_Category> = _Category;
        pub type iterator_value_type<_Tp> = _Tp;
        pub type iterator_difference_type<_Distance> = _Distance;
        pub type iterator_pointer<_Pointer> = _Pointer;
        pub type iterator_reference<_Reference> = _Reference;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct __iterator_traits {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct iterator_traits {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct reverse_iterator<_Iterator> {
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_Iterator>>,
            pub current: _Iterator,
        }
        pub type reverse_iterator___traits_type = root::std::iterator_traits;
        pub type reverse_iterator_iterator_type<_Iterator> = _Iterator;
        pub type reverse_iterator_pointer = root::std::reverse_iterator___traits_type;
        pub type reverse_iterator_iterator_concept = root::std::__conditional_t;
        pub type reverse_iterator_iterator_category = root::std::__detail::__clamp_iter_cat;
        pub type reverse_iterator_value_type = root::std::iter_value_t;
        pub type reverse_iterator_difference_type = root::std::iter_difference_t;
        pub type reverse_iterator_reference = root::std::iter_reference_t;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct __pair_base {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct pair<_T1, _T2> {
            pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T1>>,
            pub _phantom_1: ::std::marker::PhantomData<::std::cell::UnsafeCell<_T2>>,
            pub first: _T1,
            pub second: _T2,
        }
        pub type pair_first_type<_T1> = _T1;
        pub type pair_second_type<_T2> = _T2;
        pub type basic_string_view_traits_type<_Traits> = _Traits;
        pub type basic_string_view_value_type<_CharT> = _CharT;
        pub type basic_string_view_pointer<_CharT> =
            *mut root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_pointer<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_reference<_CharT> =
            *mut root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_reference<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_const_iterator<_CharT> =
            *const root::std::basic_string_view_value_type<_CharT>;
        pub type basic_string_view_iterator<_CharT> =
            root::std::basic_string_view_const_iterator<_CharT>;
        pub type basic_string_view_const_reverse_iterator<_CharT> =
            root::std::reverse_iterator<root::std::basic_string_view_const_iterator<_CharT>>;
        pub type basic_string_view_reverse_iterator<_CharT> =
            root::std::basic_string_view_const_reverse_iterator<_CharT>;
        pub type basic_string_view_size_type = usize;
        pub type basic_string_view_difference_type = isize;
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct default_delete {
            pub _address: u8,
        }
        #[repr(C)]
        #[derive(Debug, Copy, Clone)]
        pub struct unique_ptr {
            pub _address: u8,
        }
        pub type unique_ptr__DeleterConstraint = u8;
        pub type unique_ptr_pointer = u8;
        pub type unique_ptr_element_type = u8;
        pub type unique_ptr_deleter_type = u8;
        pub type unique_ptr___safe_conversion_up = u8;
        pub mod chrono {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub mod __unicode {
            #[allow(unused_imports)]
            use self::super::super::super::root;
        }
        pub type _Base_bitset__WordT = ::std::os::raw::c_ulong;
        pub type bitset__Base = u8;
        pub type bitset__WordT = ::std::os::raw::c_ulong;
        #[repr(C)]
        #[derive(Debug)]
        pub struct bitset_reference {
            pub _M_wp: *mut root::std::bitset__WordT,
            pub _M_bpos: usize,
        }
    }
    pub mod __gnu_cxx {
        #[allow(unused_imports)]
        use self::super::super::root;
    }
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct __pthread_internal_list {
        pub __prev: *mut root::__pthread_internal_list,
        pub __next: *mut root::__pthread_internal_list,
    }
    #[allow(clippy::unnecessary_operation, clippy::identity_op)]
    const _: () = {
        ["Size of __pthread_internal_list"]
            [::std::mem::size_of::<__pthread_internal_list>() - 16usize];
        ["Alignment of __pthread_internal_list"]
            [::std::mem::align_of::<__pthread_internal_list>() - 8usize];
        ["Offset of field: __pthread_internal_list::__prev"]
            [::std::mem::offset_of!(__pthread_internal_list, __prev) - 0usize];
        ["Offset of field: __pthread_internal_list::__next"]
            [::std::mem::offset_of!(__pthread_internal_list, __next) - 8usize];
    };
    pub type __pthread_list_t = root::__pthread_internal_list;
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct __pthread_mutex_s {
        pub __lock: ::std::os::raw::c_int,
        pub __count: ::std::os::raw::c_uint,
        pub __owner: ::std::os::raw::c_int,
        pub __nusers: ::std::os::raw::c_uint,
        pub __kind: ::std::os::raw::c_int,
        pub __spins: ::std::os::raw::c_short,
        pub __elision: ::std::os::raw::c_short,
        pub __list: root::__pthread_list_t,
    }
    #[allow(clippy::unnecessary_operation, clippy::identity_op)]
    const _: () = {
        ["Size of __pthread_mutex_s"][::std::mem::size_of::<__pthread_mutex_s>() - 40usize];
        ["Alignment of __pthread_mutex_s"][::std::mem::align_of::<__pthread_mutex_s>() - 8usize];
        ["Offset of field: __pthread_mutex_s::__lock"]
            [::std::mem::offset_of!(__pthread_mutex_s, __lock) - 0usize];
        ["Offset of field: __pthread_mutex_s::__count"]
            [::std::mem::offset_of!(__pthread_mutex_s, __count) - 4usize];
        ["Offset of field: __pthread_mutex_s::__owner"]
            [::std::mem::offset_of!(__pthread_mutex_s, __owner) - 8usize];
        ["Offset of field: __pthread_mutex_s::__nusers"]
            [::std::mem::offset_of!(__pthread_mutex_s, __nusers) - 12usize];
        ["Offset of field: __pthread_mutex_s::__kind"]
            [::std::mem::offset_of!(__pthread_mutex_s, __kind) - 16usize];
        ["Offset of field: __pthread_mutex_s::__spins"]
            [::std::mem::offset_of!(__pthread_mutex_s, __spins) - 20usize];
        ["Offset of field: __pthread_mutex_s::__elision"]
            [::std::mem::offset_of!(__pthread_mutex_s, __elision) - 22usize];
        ["Offset of field: __pthread_mutex_s::__list"]
            [::std::mem::offset_of!(__pthread_mutex_s, __list) - 24usize];
    };
    #[repr(C)]
    #[derive(Debug, Copy, Clone)]
    pub struct pthread_mutex_t {
        pub __data: root::__BindgenUnionField<root::__pthread_mutex_s>,
        pub __size: root::__BindgenUnionField<[::std::os::raw::c_char; 40usize]>,
        pub __align: root::__BindgenUnionField<::std::os::raw::c_long>,
        pub bindgen_union_field: root::__BindgenOpaqueArray8<[u8; 40usize]>,
    }
    #[allow(clippy::unnecessary_operation, clippy::identity_op)]
    const _: () = {
        ["Size of pthread_mutex_t"][::std::mem::size_of::<pthread_mutex_t>() - 40usize];
        ["Alignment of pthread_mutex_t"][::std::mem::align_of::<pthread_mutex_t>() - 8usize];
        ["Offset of field: pthread_mutex_t::__data"]
            [::std::mem::offset_of!(pthread_mutex_t, __data) - 0usize];
        ["Offset of field: pthread_mutex_t::__size"]
            [::std::mem::offset_of!(pthread_mutex_t, __size) - 0usize];
        ["Offset of field: pthread_mutex_t::__align"]
            [::std::mem::offset_of!(pthread_mutex_t, __align) - 0usize];
    };
    pub mod mozilla {
        #[allow(unused_imports)]
        use self::super::super::root;
        pub use crate::Atom as StyleAtom;
        pub use crate::color::AbsoluteColor as StyleAbsoluteColor;
        pub use crate::color::component::ColorComponent as StyleColorComponent;
        pub use crate::computed_value_flags::ComputedValueFlags as StyleComputedValueFlags;
        pub use crate::counter_style::CounterStyle as StyleCounterStyle;
        pub use crate::counter_style::SymbolsType as StyleSymbolsType;
        pub use crate::font_face::ComputedFontStretchRange as StyleComputedFontStretchRange;
        pub use crate::font_face::ComputedFontStyleDescriptor as StyleComputedFontStyleDescriptor;
        pub use crate::font_face::ComputedFontWeightRange as StyleComputedFontWeightRange;
        pub use crate::font_face::FontDisplay as StyleFontDisplay;
        pub use crate::font_face::FontFaceSourceFormatKeyword as StyleFontFaceSourceFormatKeyword;
        pub use crate::font_face::FontFaceSourceListComponent as StyleFontFaceSourceListComponent;
        pub use crate::font_face::FontFaceSourceTechFlags as StyleFontFaceSourceTechFlags;
        pub use crate::gecko::arc_types::LockedDeclarationBlock as StyleLockedDeclarationBlock;
        pub use crate::gecko::arc_types::LockedFontFaceRule as StyleLockedFontFaceRule;
        pub use crate::gecko::arc_types::LockedImportRule as StyleLockedImportRule;
        pub use crate::gecko::arc_types::LockedMediaList as StyleLockedMediaList;
        pub use crate::gecko::data::AuthorStyles as StyleAuthorStyles;
        pub use crate::gecko::media_features::ColorGamut as StyleColorGamut;
        pub use crate::gecko::media_features::DisplayMode as StyleDisplayMode;
        pub use crate::gecko::media_features::DynamicRange as StyleDynamicRange;
        pub use crate::gecko::media_features::GtkThemeFamily as StyleGtkThemeFamily;
        pub use crate::gecko::media_features::Platform as StylePlatform;
        pub use crate::gecko::media_features::PrefersContrast as StylePrefersContrast;
        pub use crate::gecko::media_features::Scripting as StyleScripting;
        pub use crate::gecko::url::ComputedUrl as StyleComputedUrl;
        pub use crate::gecko::url::CssUrl as StyleCssUrl;
        pub use crate::gecko::url::LoadData as StyleLoadData;
        pub use crate::gecko::url::SpecifiedUrl as StyleSpecifiedUrl;
        pub use crate::gecko_bindings::sugar::ownership::Strong as StyleStrong;
        pub use crate::invalidation::element::restyle_hints::RestyleHint as StyleRestyleHint;
        pub use crate::properties::animated_properties::AnimationValue as StyleAnimationValue;
        pub use crate::properties::animated_properties::AnimationValueMap as StyleAnimationValueMap;
        pub use crate::properties::declaration_block::PropertyTypedValue as StylePropertyTypedValue;
        pub use crate::queries::condition::ComputedMozPrefFeatureValue as StyleComputedMozPrefFeatureValue;
        pub use crate::queries::values::PrefersColorScheme as StylePrefersColorScheme;
        pub use crate::stylesheets::Origin as StyleOrigin;
        pub use crate::stylesheets::StylesheetContents as StyleStylesheetContents;
        pub use crate::use_counters::UseCounters as StyleUseCounters;
        pub use crate::values::CustomIdent as StyleCustomIdent;
        pub use crate::values::computed::Angle as StyleAngle;
        pub use crate::values::computed::AnimationComposition as StyleAnimationComposition;
        pub use crate::values::computed::AnimationDirection as StyleAnimationDirection;
        pub use crate::values::computed::AnimationDuration as StyleAnimationDuration;
        pub use crate::values::computed::AnimationFillMode as StyleAnimationFillMode;
        pub use crate::values::computed::AnimationIterationCount as StyleAnimationIterationCount;
        pub use crate::values::computed::AnimationName as StyleAnimationName;
        pub use crate::values::computed::AnimationPlayState as StyleAnimationPlayState;
        pub use crate::values::computed::AnimationTimeline as StyleAnimationTimeline;
        pub use crate::values::computed::BackgroundSize as StyleBackgroundSize;
        pub use crate::values::computed::BaselineSource as StyleBaselineSource;
        pub use crate::values::computed::BoolInteger as StyleBoolInteger;
        pub use crate::values::computed::BorderImageSlice as StyleBorderImageSlice;
        pub use crate::values::computed::BorderSpacing as StyleBorderSpacing;
        pub use crate::values::computed::BorderStyle as StyleBorderStyle;
        pub use crate::values::computed::BreakBetween as StyleBreakBetween;
        pub use crate::values::computed::BreakWithin as StyleBreakWithin;
        pub use crate::values::computed::CSSPixelLength as StyleLength;
        pub use crate::values::computed::Clear as StyleClear;
        pub use crate::values::computed::ClipRectOrAuto as StyleClipRectOrAuto;
        pub use crate::values::computed::ColumnCount as StyleColumnCount;
        pub use crate::values::computed::Contain as StyleContain;
        pub use crate::values::computed::ContainIntrinsicSize as StyleContainIntrinsicSize;
        pub use crate::values::computed::ContainerName as StyleContainerName;
        pub use crate::values::computed::ContainerType as StyleContainerType;
        pub use crate::values::computed::ContentDistribution as StyleContentDistribution;
        pub use crate::values::computed::ContentVisibility as StyleContentVisibility;
        pub use crate::values::computed::CounterIncrement as StyleCounterIncrement;
        pub use crate::values::computed::CounterReset as StyleCounterReset;
        pub use crate::values::computed::CounterSet as StyleCounterSet;
        pub use crate::values::computed::Cursor as StyleCursor;
        pub use crate::values::computed::FlexBasis as StyleFlexBasis;
        pub use crate::values::computed::Float as StyleFloat;
        pub use crate::values::computed::ForcedColorAdjust as StyleForcedColorAdjust;
        pub use crate::values::computed::GridAutoFlow as StyleGridAutoFlow;
        pub use crate::values::computed::HyphenateCharacter as StyleHyphenateCharacter;
        pub use crate::values::computed::HyphenateLimitChars as StyleHyphenateLimitChars;
        pub use crate::values::computed::Image as StyleImage;
        pub use crate::values::computed::ImageRendering as StyleImageRendering;
        pub use crate::values::computed::ImplicitGridTracks as StyleImplicitGridTracks;
        pub use crate::values::computed::ItemPlacement as StyleItemPlacement;
        pub use crate::values::computed::LengthPercentage as StyleLengthPercentage;
        pub use crate::values::computed::LengthPercentageOrAuto as StyleLengthPercentageOrAuto;
        pub use crate::values::computed::LineBreak as StyleLineBreak;
        pub use crate::values::computed::LineClamp as StyleLineClamp;
        pub use crate::values::computed::ListStyleType as StyleListStyleType;
        pub use crate::values::computed::MaxSize as StyleMaxSize;
        pub use crate::values::computed::NonNegativeLength as StyleNonNegativeLength;
        pub use crate::values::computed::NonNegativeLengthPercentage as StyleNonNegativeLengthPercentage;
        pub use crate::values::computed::NonNegativeLengthPercentageOrAuto as StyleNonNegativeLengthPercentageOrAuto;
        pub use crate::values::computed::NonNegativeNumber as StyleNonNegativeNumber;
        pub use crate::values::computed::NumberOrPercentage as StyleNumberOrPercentage;
        pub use crate::values::computed::OutlineStyle as StyleOutlineStyle;
        pub use crate::values::computed::Overflow as StyleOverflow;
        pub use crate::values::computed::OverflowAnchor as StyleOverflowAnchor;
        pub use crate::values::computed::OverflowClipBox as StyleOverflowClipBox;
        pub use crate::values::computed::OverflowWrap as StyleOverflowWrap;
        pub use crate::values::computed::OverscrollBehavior as StyleOverscrollBehavior;
        pub use crate::values::computed::Percentage as StylePercentage;
        pub use crate::values::computed::Perspective as StylePerspective;
        pub use crate::values::computed::Position as StylePosition;
        pub use crate::values::computed::PositionOrAuto as StylePositionOrAuto;
        pub use crate::values::computed::PositionProperty as StylePositionProperty;
        pub use crate::values::computed::PrintColorAdjust as StylePrintColorAdjust;
        pub use crate::values::computed::Resize as StyleResize;
        pub use crate::values::computed::RubyPosition as StyleRubyPosition;
        pub use crate::values::computed::ScrollAxis as StyleScrollAxis;
        pub use crate::values::computed::ScrollSnapAlign as StyleScrollSnapAlign;
        pub use crate::values::computed::ScrollSnapStop as StyleScrollSnapStop;
        pub use crate::values::computed::ScrollSnapStrictness as StyleScrollSnapStrictness;
        pub use crate::values::computed::ScrollSnapType as StyleScrollSnapType;
        pub use crate::values::computed::ScrollbarGutter as StyleScrollbarGutter;
        pub use crate::values::computed::SelfAlignment as StyleSelfAlignment;
        pub use crate::values::computed::Size as StyleSize;
        pub use crate::values::computed::TextAlign as StyleTextAlign;
        pub use crate::values::computed::TextDecorationInset as StyleTextDecorationInset;
        pub use crate::values::computed::TextDecorationLength as StyleTextDecorationLength;
        pub use crate::values::computed::TextDecorationLine as StyleTextDecorationLine;
        pub use crate::values::computed::TextDecorationSkipInk as StyleTextDecorationSkipInk;
        pub use crate::values::computed::TextEmphasisPosition as StyleTextEmphasisPosition;
        pub use crate::values::computed::TextJustify as StyleTextJustify;
        pub use crate::values::computed::TextOverflow as StyleTextOverflow;
        pub use crate::values::computed::TextTransform as StyleTextTransform;
        pub use crate::values::computed::TextUnderlinePosition as StyleTextUnderlinePosition;
        pub use crate::values::computed::Time as StyleTime;
        pub use crate::values::computed::TimelineName as StyleTimelineName;
        pub use crate::values::computed::TouchAction as StyleTouchAction;
        pub use crate::values::computed::TransformBox as StyleTransformBox;
        pub use crate::values::computed::TransformOrigin as StyleTransformOrigin;
        pub use crate::values::computed::TransformStyle as StyleTransformStyle;
        pub use crate::values::computed::TransitionBehavior as StyleTransitionBehavior;
        pub use crate::values::computed::TransitionProperty as StyleTransitionProperty;
        pub use crate::values::computed::UserFocus as StyleUserFocus;
        pub use crate::values::computed::UserSelect as StyleUserSelect;
        pub use crate::values::computed::ViewTimelineInset as StyleViewTimelineInset;
        pub use crate::values::computed::ViewTransitionClass as StyleViewTransitionClass;
        pub use crate::values::computed::ViewTransitionName as StyleViewTransitionName;
        pub use crate::values::computed::WordBreak as StyleWordBreak;
        pub use crate::values::computed::XTextScale as StyleXTextScale;
        pub use crate::values::computed::ZIndex as StyleZIndex;
        pub use crate::values::computed::ZeroToOneNumber as StyleZeroToOneNumber;
        pub use crate::values::computed::Zoom as StyleZoom;
        pub use crate::values::computed::align::ComputedJustifyItems as StyleComputedJustifyItems;
        pub use crate::values::computed::basic_shape::BasicShape as StyleBasicShape;
        pub use crate::values::computed::basic_shape::ClipPath as StyleClipPath;
        pub use crate::values::computed::basic_shape::InsetRect as StyleInsetRect;
        pub use crate::values::computed::basic_shape::Shape as StyleShape;
        pub use crate::values::computed::basic_shape::ShapeCommand as StyleShapeCommand;
        pub use crate::values::computed::basic_shape::ShapeOutside as StyleShapeOutside;
        pub use crate::values::computed::border::BorderSideWidth as StyleBorderSideWidth;
        pub use crate::values::computed::box_::WritingModeProperty as StyleWritingModeProperty;
        pub use crate::values::computed::color::CaretColor as StyleCaretColor;
        pub use crate::values::computed::counters::Content as StyleContent;
        pub use crate::values::computed::easing::TimingFunction as StyleComputedTimingFunction;
        pub use crate::values::computed::font::FontFamily as StyleFontFamily;
        pub use crate::values::computed::font::FontFamilyNameSyntax as StyleFontFamilyNameSyntax;
        pub use crate::values::computed::font::FontLanguageOverride as StyleFontLanguageOverride;
        pub use crate::values::computed::font::FontPalette as StyleFontPalette;
        pub use crate::values::computed::font::FontSizeAdjust as StyleFontSizeAdjust;
        pub use crate::values::computed::font::FontStretch as StyleFontStretch;
        pub use crate::values::computed::font::FontStyle as StyleFontStyle;
        pub use crate::values::computed::font::FontSynthesis as StyleFontSynthesis;
        pub use crate::values::computed::font::FontSynthesisStyle as StyleFontSynthesisStyle;
        pub use crate::values::computed::font::FontVariantEastAsian as StyleFontVariantEastAsian;
        pub use crate::values::computed::font::FontVariantLigatures as StyleFontVariantLigatures;
        pub use crate::values::computed::font::FontVariantNumeric as StyleFontVariantNumeric;
        pub use crate::values::computed::font::FontWeight as StyleFontWeight;
        pub use crate::values::computed::font::GenericFontFamily as StyleGenericFontFamily;
        pub use crate::values::computed::image::LineDirection as StyleLineDirection;
        pub use crate::values::computed::length::CSSPixelLength as StyleCSSPixelLength;
        pub use crate::values::computed::length::Margin as StyleMargin;
        pub use crate::values::computed::motion::OffsetPath as StyleOffsetPath;
        pub use crate::values::computed::motion::OffsetPathFunction as StyleOffsetPathFunction;
        pub use crate::values::computed::motion::OffsetPosition as StyleOffsetPosition;
        pub use crate::values::computed::motion::OffsetRotate as StyleOffsetRotate;
        pub use crate::values::computed::motion::RayFunction as StyleRayFunction;
        pub use crate::values::computed::page::PageSize as StylePageSize;
        pub use crate::values::computed::position::AnchorName as StyleAnchorName;
        pub use crate::values::computed::position::AnchorScope as StyleAnchorScope;
        pub use crate::values::computed::position::AspectRatio as StyleAspectRatio;
        pub use crate::values::computed::position::GridTemplateAreas as StyleGridTemplateAreas;
        pub use crate::values::computed::position::Inset as StyleInset;
        pub use crate::values::computed::position::PositionAnchor as StylePositionAnchor;
        pub use crate::values::computed::position::PositionArea as StylePositionArea;
        pub use crate::values::computed::position::PositionTryFallbacks as StylePositionTryFallbacks;
        pub use crate::values::computed::position::PositionTryOrder as StylePositionTryOrder;
        pub use crate::values::computed::position::PositionVisibility as StylePositionVisibility;
        pub use crate::values::computed::svg::SVGLength as StyleSVGLength;
        pub use crate::values::computed::svg::SVGOpacity as StyleSVGOpacity;
        pub use crate::values::computed::svg::SVGStrokeDashArray as StyleSVGStrokeDashArray;
        pub use crate::values::computed::svg::SVGWidth as StyleSVGWidth;
        pub use crate::values::computed::table::CaptionSide as StyleCaptionSide;
        pub use crate::values::computed::text::InitialLetter as StyleInitialLetter;
        pub use crate::values::computed::text::LetterSpacing as StyleLetterSpacing;
        pub use crate::values::computed::text::MozControlCharacterVisibility as StyleMozControlCharacterVisibility;
        pub use crate::values::computed::text::TextAlignLast as StyleTextAlignLast;
        pub use crate::values::computed::text::TextAutospace as StyleTextAutospace;
        pub use crate::values::computed::text::TextEmphasisStyle as StyleTextEmphasisStyle;
        pub use crate::values::computed::text::TextIndent as StyleTextIndent;
        pub use crate::values::computed::ui::CursorKind as StyleCursorKind;
        pub use crate::values::computed::ui::Inert as StyleInert;
        pub use crate::values::computed::ui::MozTheme as StyleMozTheme;
        pub use crate::values::computed::ui::PointerEvents as StylePointerEvents;
        pub use crate::values::generics::GenericClipRect as StyleGenericClipRect;
        pub use crate::values::generics::background::BackgroundSize as StyleGenericBackgroundSize;
        pub use crate::values::generics::basic_shape::BasicShape as StyleGenericBasicShape;
        pub use crate::values::generics::basic_shape::FillRule as StyleFillRule;
        pub use crate::values::generics::basic_shape::GenericShapeRadius as StyleGenericShapeRadius;
        pub use crate::values::generics::basic_shape::InsetRect as StyleGenericInsetRect;
        pub use crate::values::generics::basic_shape::ShapeCommand as StyleGenericShapeCommand;
        pub use crate::values::generics::border::BorderImageSideWidth as StyleGenericBorderImageSideWidth;
        pub use crate::values::generics::border::BorderRadius as StyleGenericBorderRadius;
        pub use crate::values::generics::box_::Perspective as StyleGenericPerspective;
        pub use crate::values::generics::box_::VerticalAlign as StyleGenericVerticalAlign;
        pub use crate::values::generics::box_::VerticalAlignKeyword as StyleVerticalAlignKeyword;
        pub use crate::values::generics::calc::GenericCalcNode as StyleGenericCalcNode;
        pub use crate::values::generics::color::Color as StyleGenericColor;
        pub use crate::values::generics::color::ColorOrAuto as StyleGenericColorOrAuto;
        pub use crate::values::generics::counters::GenericCounterPair as StyleGenericCounterPair;
        pub use crate::values::generics::effects::BoxShadow as StyleGenericBoxShadow;
        pub use crate::values::generics::effects::Filter as StyleGenericFilter;
        pub use crate::values::generics::effects::SimpleShadow as StyleGenericSimpleShadow;
        pub use crate::values::generics::flex::FlexBasis as StyleGenericFlexBasis;
        pub use crate::values::generics::font::LineHeight as StyleGenericLineHeight;
        pub use crate::values::generics::grid::GridLine as StyleGenericGridLine;
        pub use crate::values::generics::grid::GridTemplateComponent as StyleGenericGridTemplateComponent;
        pub use crate::values::generics::grid::ImplicitGridTracks as StyleGenericImplicitGridTracks;
        pub use crate::values::generics::grid::TrackBreadth as StyleGenericTrackBreadth;
        pub use crate::values::generics::grid::TrackList as StyleGenericTrackList;
        pub use crate::values::generics::grid::TrackListValue as StyleGenericTrackListValue;
        pub use crate::values::generics::grid::TrackRepeat as StyleGenericTrackRepeat;
        pub use crate::values::generics::grid::TrackSize as StyleGenericTrackSize;
        pub use crate::values::generics::image::Gradient as StyleGenericGradient;
        pub use crate::values::generics::length::LengthOrNumber as StyleGenericLengthOrNumber;
        pub use crate::values::generics::length::LengthPercentageOrAuto as StyleGenericLengthPercentageOrAuto;
        pub use crate::values::generics::length::LengthPercentageOrNormal as StyleGenericLengthPercentageOrNormal;
        pub use crate::values::generics::length::MaxSize as StyleGenericMaxSize;
        pub use crate::values::generics::length::Size as StyleGenericSize;
        pub use crate::values::generics::motion::OffsetPath as StyleGenericOffsetPath;
        pub use crate::values::generics::motion::OffsetPathFunction as StyleGenericOffsetPathFunction;
        pub use crate::values::generics::page::PageOrientation as StylePageOrientation;
        pub use crate::values::generics::position::GenericAnchorFunction as StyleGenericAnchorFunction;
        pub use crate::values::generics::position::GenericAnchorSide as StyleGenericAnchorSide;
        pub use crate::values::generics::position::GenericPosition as StyleGenericPosition;
        pub use crate::values::generics::position::PositionOrAuto as StyleGenericPositionOrAuto;
        pub use crate::values::generics::position::ZIndex as StyleGenericZIndex;
        pub use crate::values::generics::rect::Rect as StyleRect;
        pub use crate::values::generics::svg::SVGPaint as StyleGenericSVGPaint;
        pub use crate::values::generics::transform::Rotate as StyleGenericRotate;
        pub use crate::values::generics::transform::Scale as StyleGenericScale;
        pub use crate::values::generics::transform::Transform as StyleGenericTransform;
        pub use crate::values::generics::transform::TransformOperation as StyleGenericTransformOperation;
        pub use crate::values::generics::transform::Translate as StyleGenericTranslate;
        pub use crate::values::generics::ui::GenericCursorImage as StyleGenericCursorImage;
        pub use crate::values::generics::ui::ScrollbarColor as StyleGenericScrollbarColor;
        pub use crate::values::generics::url::UrlOrNone as StyleGenericUrlOrNone;
        pub use crate::values::specified::Appearance as StyleAppearance;
        pub use crate::values::specified::Display as StyleDisplay;
        pub use crate::values::specified::MasonryAutoFlow as StyleMasonryAutoFlow;
        pub use crate::values::specified::MasonryItemOrder as StyleMasonryItemOrder;
        pub use crate::values::specified::MasonryPlacement as StyleMasonryPlacement;
        pub use crate::values::specified::border::BorderImageRepeat as StyleBorderImageRepeat;
        pub use crate::values::specified::border::BorderImageRepeatKeyword as StyleBorderImageRepeatKeyword;
        pub use crate::values::specified::box_::WillChange as StyleWillChange;
        pub use crate::values::specified::color::ColorScheme as StyleColorScheme;
        pub use crate::values::specified::color::ColorSchemeFlags as StyleColorSchemeFlags;
        pub use crate::values::specified::color::ForcedColors as StyleForcedColors;
        pub use crate::values::specified::color::SystemColor as StyleSystemColor;
        pub use crate::values::specified::font::FontSizeKeyword as StyleFontSizeKeyword;
        pub use crate::values::specified::font::FontVariantAlternates as StyleFontVariantAlternates;
        pub use crate::values::specified::font::QueryFontMetricsFlags as StyleQueryFontMetricsFlags;
        pub use crate::values::specified::font::SystemFont as StyleSystemFont;
        pub use crate::values::specified::intersection_observer::IntersectionObserverMargin as StyleIntersectionObserverMargin;
        pub use crate::values::specified::list::Quotes as StyleQuotes;
        pub use crate::values::specified::page::PageName as StylePageName;
        pub use crate::values::specified::svg::DProperty as StyleDProperty;
        pub use crate::values::specified::svg::MozContextProperties as StyleMozContextProperties;
        pub use crate::values::specified::svg::SVGPaintOrder as StyleSVGPaintOrder;
        pub use crate::values::specified::svg::VectorEffect as StyleVectorEffect;
        pub use crate::values::specified::svg_path::PathCommand as StylePathCommand;
        pub use app_units::Au as StyleAu;
        pub use cssparser::ParserState as StyleParserState;
        pub use cssparser::UnicodeRange as StyleUnicodeRange;
        pub use style_traits::TypedValue as StyleTypedValue;
        pub use style_traits::arc_slice::ArcSlice as StyleArcSlice;
        pub use style_traits::arc_slice::ForgottenArcSlicePtr as StyleForgottenArcSlicePtr;
        pub use style_traits::owned_slice::OwnedSlice as StyleOwnedSlice;
        pub use style_traits::owned_str::OwnedStr as StyleOwnedStr;
        pub mod detail {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            pub const StringDataFlags_TERMINATED: StringDataFlags = 1;
            pub const StringDataFlags_VOIDED: StringDataFlags = 2;
            pub const StringDataFlags_REFCOUNTED: StringDataFlags = 4;
            pub const StringDataFlags_OWNED: StringDataFlags = 8;
            pub const StringDataFlags_INLINE: StringDataFlags = 16;
            pub const StringDataFlags_LITERAL: StringDataFlags = 32;
            pub const StringDataFlags_INVALID_MASK: StringDataFlags = 65472;
            pub type StringDataFlags = u16;
            pub const StringClassFlags_INLINE: StringClassFlags = 1;
            pub const StringClassFlags_NULL_TERMINATED: StringClassFlags = 2;
            pub const StringClassFlags_INVALID_MASK: StringClassFlags = 65532;
            pub type StringClassFlags = u16;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringLengthStorage {
                pub mLength: u32,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr<T> {
                pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
                pub mData: *mut root::mozilla::detail::nsTStringRepr_char_type<T>,
                pub mLength: root::mozilla::detail::nsTStringRepr_LengthStorage,
                pub mDataFlags: root::mozilla::detail::nsTStringRepr_DataFlags,
                pub mClassFlags: root::mozilla::detail::nsTStringRepr_ClassFlags,
            }
            pub type nsTStringRepr_fallible_t = root::mozilla::fallible_t;
            pub type nsTStringRepr_char_type<T> = T;
            pub type nsTStringRepr_self_type<T> = root::mozilla::detail::nsTStringRepr<T>;
            pub type nsTStringRepr_base_string_type<T> =
                root::mozilla::detail::nsTStringRepr_self_type<T>;
            #[doc = " nsTSubstring is an abstract string class. From an API perspective, this\n class is the root of the string class hierarchy. It represents a single\n contiguous array of characters, which may or may not be null-terminated.\n This type is not instantiated directly. A sub-class is instantiated\n instead. For example, see nsTString.\n\n NAMES:\n   nsAString for wide characters\n   nsACString for narrow characters\n"]
            pub type nsTStringRepr_substring_type<T> = root::nsTSubstring<T>;
            #[doc = " nsTSubstringTuple\n\n Represents a tuple of string fragments.  Built as a recursive binary tree.\n It is used to implement the concatenation of two or more string objects.\n\n NOTE: This class is a private implementation detail and should never be\n referenced outside the string code."]
            pub type nsTStringRepr_substring_tuple_type<T> = root::nsTSubstringTuple<T>;
            #[doc = " @see nsTAString"]
            pub type nsTStringRepr_const_iterator<T> =
                root::nsReadingIterator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_iterator<T> =
                *mut root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_comparator_type<T> =
                root::nsTStringComparator<root::mozilla::detail::nsTStringRepr_char_type<T>>;
            pub type nsTStringRepr_const_char_iterator<T> =
                *const root::mozilla::detail::nsTStringRepr_char_type<T>;
            pub type nsTStringRepr_index_type = usize;
            pub type nsTStringRepr_size_type = usize;
            pub use self::super::super::super::root::mozilla::detail::StringClassFlags as nsTStringRepr_ClassFlags;
            pub use self::super::super::super::root::mozilla::detail::StringDataFlags as nsTStringRepr_DataFlags;
            pub type nsTStringRepr_LengthStorage = root::mozilla::detail::nsTStringLengthStorage;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsTStringRepr_raw_type {
                pub _address: u8,
            }
            pub type nsTStringRepr_raw_type_type<U> = *const U;
            pub const PackingStrategy_Variant: PackingStrategy = 0;
            pub const PackingStrategy_NullIsOk: PackingStrategy = 1;
            pub const PackingStrategy_LowBitTagIsError: PackingStrategy = 2;
            pub const PackingStrategy_PackedVariant: PackingStrategy = 3;
            pub const PackingStrategy_ZeroIsEmptyError: PackingStrategy = 4;
            pub type PackingStrategy = ::std::os::raw::c_int;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SelectResultImpl {
                pub _address: u8,
            }
            pub type SelectResultImpl_Type = u8;
            #[repr(C)]
            #[derive(Debug)]
            pub struct GkAtoms {
                pub SystemPrincipal_string: [u16; 19usize],
                pub _empty_string: [u16; 1usize],
                pub _0_string: [u16; 2usize],
                pub _1_string: [u16; 2usize],
                pub _2_string: [u16; 2usize],
                pub _3_string: [u16; 2usize],
                pub _4_string: [u16; 2usize],
                pub _5_string: [u16; 2usize],
                pub _6_string: [u16; 2usize],
                pub _7_string: [u16; 2usize],
                pub _8_string: [u16; 2usize],
                pub _9_string: [u16; 2usize],
                pub mozframetype_string: [u16; 13usize],
                pub _moz_abspos_string: [u16; 12usize],
                pub _moz_activated_string: [u16; 15usize],
                pub _moz_anonclass_string: [u16; 15usize],
                pub _moz_resizing_string: [u16; 14usize],
                pub moztype_string: [u16; 10usize],
                pub mozdirty_string: [u16; 11usize],
                pub mozdisallowselectionprint_string: [u16; 26usize],
                pub mozdonotsend_string: [u16; 16usize],
                pub mozfwcontainer_string: [u16; 22usize],
                pub mozgeneratedcontentbefore_string: [u16; 30usize],
                pub mozgeneratedcontentafter_string: [u16; 29usize],
                pub mozgeneratedcontentmarker_string: [u16; 30usize],
                pub mozgeneratedcontentimage_string: [u16; 29usize],
                pub mozquote_string: [u16; 11usize],
                pub mozsignature_string: [u16; 14usize],
                pub _moz_bullet_font_string: [u16; 17usize],
                pub _moz_is_glyph_string: [u16; 14usize],
                pub _moz_in_android_pip_mode_string: [u16; 25usize],
                pub _moz_original_size_string: [u16; 19usize],
                pub _moz_print_preview_string: [u16; 19usize],
                pub menuactive_string: [u16; 16usize],
                pub _poundDefault_string: [u16; 9usize],
                pub _asterisk_string: [u16; 2usize],
                pub a_string: [u16; 2usize],
                pub abbr_string: [u16; 5usize],
                pub abort_string: [u16; 6usize],
                pub above_string: [u16; 6usize],
                pub acceltext_string: [u16; 10usize],
                pub accept_string: [u16; 7usize],
                pub acceptcharset_string: [u16; 15usize],
                pub accessiblenode_string: [u16; 16usize],
                pub accesskey_string: [u16; 10usize],
                pub acronym_string: [u16; 8usize],
                pub action_string: [u16; 7usize],
                pub active_string: [u16; 7usize],
                pub activateontab_string: [u16; 14usize],
                pub actuate_string: [u16; 8usize],
                pub address_string: [u16; 8usize],
                pub adoptedsheetclones_string: [u16; 19usize],
                pub adult_string: [u16; 6usize],
                pub after_string: [u16; 6usize],
                pub align_string: [u16; 6usize],
                pub alink_string: [u16; 6usize],
                pub all_string: [u16; 4usize],
                pub allow_string: [u16; 6usize],
                pub allowdownloads_string: [u16; 16usize],
                pub allowevents_string: [u16; 12usize],
                pub allowforms_string: [u16; 12usize],
                pub allowfullscreen_string: [u16; 16usize],
                pub allowmodals_string: [u16; 13usize],
                pub alloworientationlock_string: [u16; 23usize],
                pub allowpointerlock_string: [u16; 19usize],
                pub allowpopupstoescapesandbox_string: [u16; 31usize],
                pub allowpopups_string: [u16; 13usize],
                pub allowpresentation_string: [u16; 19usize],
                pub allowstorageaccessbyuseractivatetion_string: [u16; 40usize],
                pub allowsameorigin_string: [u16; 18usize],
                pub allowscripts_string: [u16; 14usize],
                pub allowscriptstoclose_string: [u16; 20usize],
                pub allowtopnavigation_string: [u16; 21usize],
                pub allowtopnavigationbyuseractivation_string: [u16; 40usize],
                pub allowtopnavigationcustomprotocols_string: [u16; 41usize],
                pub allowuntrusted_string: [u16; 15usize],
                pub alt_string: [u16; 4usize],
                pub alternate_string: [u16; 10usize],
                pub always_string: [u16; 7usize],
                pub ancestor_string: [u16; 9usize],
                pub ancestorOrSelf_string: [u16; 17usize],
                pub anchor_string: [u16; 7usize],
                pub _and_string: [u16; 4usize],
                pub animations_string: [u16; 11usize],
                pub anonid_string: [u16; 7usize],
                pub anonlocation_string: [u16; 13usize],
                pub any_string: [u16; 4usize],
                pub any_hover_string: [u16; 10usize],
                pub any_pointer_string: [u16; 12usize],
                pub applet_string: [u16; 7usize],
                pub applyImports_string: [u16; 14usize],
                pub applyTemplates_string: [u16; 16usize],
                pub archive_string: [u16; 8usize],
                pub area_string: [u16; 5usize],
                pub aria_string: [u16; 5usize],
                pub aria_actions_string: [u16; 13usize],
                pub aria_activedescendant_string: [u16; 22usize],
                pub aria_atomic_string: [u16; 12usize],
                pub aria_autocomplete_string: [u16; 18usize],
                pub aria_braillelabel_string: [u16; 18usize],
                pub aria_brailleroledescription_string: [u16; 28usize],
                pub aria_busy_string: [u16; 10usize],
                pub aria_checked_string: [u16; 13usize],
                pub aria_controls_string: [u16; 14usize],
                pub aria_current_string: [u16; 13usize],
                pub aria_describedby_string: [u16; 17usize],
                pub aria_description_string: [u16; 17usize],
                pub aria_disabled_string: [u16; 14usize],
                pub aria_dropeffect_string: [u16; 16usize],
                pub aria_expanded_string: [u16; 14usize],
                pub aria_flowto_string: [u16; 12usize],
                pub aria_haspopup_string: [u16; 14usize],
                pub aria_hidden_string: [u16; 12usize],
                pub aria_invalid_string: [u16; 13usize],
                pub aria_labelledby_string: [u16; 16usize],
                pub aria_level_string: [u16; 11usize],
                pub aria_live_string: [u16; 10usize],
                pub aria_multiline_string: [u16; 15usize],
                pub aria_multiselectable_string: [u16; 21usize],
                pub aria_owns_string: [u16; 10usize],
                pub aria_posinset_string: [u16; 14usize],
                pub aria_pressed_string: [u16; 13usize],
                pub aria_readonly_string: [u16; 14usize],
                pub aria_relevant_string: [u16; 14usize],
                pub aria_required_string: [u16; 14usize],
                pub aria_selected_string: [u16; 14usize],
                pub aria_setsize_string: [u16; 13usize],
                pub aria_sort_string: [u16; 10usize],
                pub aria_valuemax_string: [u16; 14usize],
                pub aria_valuemin_string: [u16; 14usize],
                pub aria_valuenow_string: [u16; 14usize],
                pub arrow_string: [u16; 6usize],
                pub article_string: [u16; 8usize],
                pub as_string: [u16; 3usize],
                pub ascending_string: [u16; 10usize],
                pub aside_string: [u16; 6usize],
                pub aspectRatio_string: [u16; 13usize],
                pub async_string: [u16; 6usize],
                pub attribute_string: [u16; 10usize],
                pub attributes_string: [u16; 11usize],
                pub attributeSet_string: [u16; 14usize],
                pub _auto_string: [u16; 5usize],
                pub autocapitalize_string: [u16; 15usize],
                pub autocheck_string: [u16; 10usize],
                pub autocomplete_string: [u16; 13usize],
                pub autocomplete_richlistbox_string: [u16; 25usize],
                pub autofocus_string: [u16; 10usize],
                pub autoplay_string: [u16; 9usize],
                pub axis_string: [u16; 5usize],
                pub b_string: [u16; 2usize],
                pub background_string: [u16; 11usize],
                pub badge_string: [u16; 6usize],
                pub bar_string: [u16; 4usize],
                pub base_string: [u16; 5usize],
                pub basefont_string: [u16; 9usize],
                pub baseline_string: [u16; 9usize],
                pub bdi_string: [u16; 4usize],
                pub bdo_string: [u16; 4usize],
                pub before_string: [u16; 7usize],
                pub behavior_string: [u16; 9usize],
                pub below_string: [u16; 6usize],
                pub bgcolor_string: [u16; 8usize],
                pub bgsound_string: [u16; 8usize],
                pub big_string: [u16; 4usize],
                pub binding_string: [u16; 8usize],
                pub bindings_string: [u16; 9usize],
                pub bindToUntrustedContent_string: [u16; 23usize],
                pub black_string: [u16; 6usize],
                pub block_string: [u16; 6usize],
                pub block_size_string: [u16; 11usize],
                pub blocking_string: [u16; 9usize],
                pub blockquote_string: [u16; 11usize],
                pub blur_string: [u16; 5usize],
                pub body_string: [u16; 5usize],
                pub boolean_string: [u16; 8usize],
                pub border_string: [u16; 7usize],
                pub bordercolor_string: [u16; 12usize],
                pub both_string: [u16; 5usize],
                pub bottom_string: [u16; 7usize],
                pub bottomend_string: [u16; 10usize],
                pub bottomstart_string: [u16; 12usize],
                pub bottomleft_string: [u16; 11usize],
                pub bottommargin_string: [u16; 13usize],
                pub bottomright_string: [u16; 12usize],
                pub box_string: [u16; 4usize],
                pub br_string: [u16; 3usize],
                pub browser_string: [u16; 8usize],
                pub button_string: [u16; 7usize],
                pub callTemplate_string: [u16; 14usize],
                pub canvas_string: [u16; 7usize],
                pub caption_string: [u16; 8usize],
                pub captionBox_string: [u16; 12usize],
                pub capture_string: [u16; 8usize],
                pub caseOrder_string: [u16; 11usize],
                pub cdataSectionElements_string: [u16; 23usize],
                pub ceiling_string: [u16; 8usize],
                pub cell_string: [u16; 5usize],
                pub cellpadding_string: [u16; 12usize],
                pub cellspacing_string: [u16; 12usize],
                pub center_string: [u16; 7usize],
                pub change_string: [u16; 7usize],
                pub _char_string: [u16; 5usize],
                pub characterData_string: [u16; 14usize],
                pub charcode_string: [u16; 9usize],
                pub charoff_string: [u16; 8usize],
                pub charset_string: [u16; 8usize],
                pub checkbox_string: [u16; 9usize],
                pub checkboxLabel_string: [u16; 15usize],
                pub checked_string: [u16; 8usize],
                pub child_string: [u16; 6usize],
                pub children_string: [u16; 9usize],
                pub childList_string: [u16; 10usize],
                pub child_item_count_string: [u16; 17usize],
                pub choose_string: [u16; 7usize],
                pub customtitlebar_string: [u16; 15usize],
                pub exposeToUntrustedContent_string: [u16; 25usize],
                pub circ_string: [u16; 5usize],
                pub circle_string: [u16; 7usize],
                pub cite_string: [u16; 5usize],
                pub cke_wysiwyg_frame_string: [u16; 18usize],
                pub _class_string: [u16; 6usize],
                pub classid_string: [u16; 8usize],
                pub clear_string: [u16; 6usize],
                pub click_string: [u16; 6usize],
                pub clickToPlay_string: [u16; 12usize],
                pub clickcount_string: [u16; 11usize],
                pub movetoclick_string: [u16; 12usize],
                pub clip_string: [u16; 5usize],
                pub close_string: [u16; 6usize],
                pub closed_string: [u16; 7usize],
                pub closedby_string: [u16; 9usize],
                pub closemenu_string: [u16; 10usize],
                pub code_string: [u16; 5usize],
                pub codebase_string: [u16; 9usize],
                pub codetype_string: [u16; 9usize],
                pub col_string: [u16; 4usize],
                pub colgroup_string: [u16; 9usize],
                pub collapse_string: [u16; 9usize],
                pub collapsed_string: [u16; 10usize],
                pub color_string: [u16; 6usize],
                pub color_gamut_string: [u16; 12usize],
                pub color_index_string: [u16; 12usize],
                pub color_scheme_string: [u16; 13usize],
                pub cols_string: [u16; 5usize],
                pub colspan_string: [u16; 8usize],
                pub combobox_string: [u16; 9usize],
                pub command_string: [u16; 8usize],
                pub commandfor_string: [u16; 11usize],
                pub commandupdater_string: [u16; 15usize],
                pub comment_string: [u16; 8usize],
                pub compact_string: [u16; 8usize],
                pub concat_string: [u16; 7usize],
                pub constructor_string: [u16; 12usize],
                pub consumeoutsideclicks_string: [u16; 21usize],
                pub container_string: [u16; 10usize],
                pub contains_string: [u16; 9usize],
                pub content_string: [u16; 8usize],
                pub contenteditable_string: [u16; 16usize],
                pub headerContentDisposition_string: [u16; 20usize],
                pub headerContentLanguage_string: [u16; 17usize],
                pub contentLocation_string: [u16; 17usize],
                pub headerContentScriptType_string: [u16; 20usize],
                pub headerContentStyleType_string: [u16; 19usize],
                pub headerContentType_string: [u16; 13usize],
                pub consumeanchor_string: [u16; 14usize],
                pub context_string: [u16; 8usize],
                pub contextmenu_string: [u16; 12usize],
                pub control_string: [u16; 8usize],
                pub controlBar_string: [u16; 11usize],
                pub controls_string: [u16; 9usize],
                pub coords_string: [u16; 7usize],
                pub copy_string: [u16; 5usize],
                pub copyOf_string: [u16; 8usize],
                pub count_string: [u16; 6usize],
                pub crop_string: [u16; 5usize],
                pub crossorigin_string: [u16; 12usize],
                pub curpos_string: [u16; 7usize],
                pub current_string: [u16; 8usize],
                pub cutoutregion_string: [u16; 13usize],
                pub cycler_string: [u16; 7usize],
                pub dashed_string: [u16; 7usize],
                pub data_string: [u16; 5usize],
                pub dataAtShortcutkeys_string: [u16; 21usize],
                pub datalist_string: [u16; 9usize],
                pub datal10nid_string: [u16; 13usize],
                pub datal10nargs_string: [u16; 15usize],
                pub datal10nattrs_string: [u16; 16usize],
                pub datal10nname_string: [u16; 15usize],
                pub datal10nsync_string: [u16; 15usize],
                pub dataType_string: [u16; 10usize],
                pub dateTime_string: [u16; 10usize],
                pub date_string: [u16; 5usize],
                pub datetime_string: [u16; 9usize],
                pub datetime_local_string: [u16; 15usize],
                pub datetimeInputBoxWrapper_string: [u16; 27usize],
                pub dd_string: [u16; 3usize],
                pub decimal_string: [u16; 8usize],
                pub decimalFormat_string: [u16; 15usize],
                pub decimalSeparator_string: [u16; 18usize],
                pub declare_string: [u16; 8usize],
                pub decoderDoctor_string: [u16; 15usize],
                pub decoding_string: [u16; 9usize],
                pub decrement_string: [u16; 10usize],
                pub _default_string: [u16; 8usize],
                pub headerDefaultStyle_string: [u16; 14usize],
                pub defer_string: [u16; 6usize],
                pub del_string: [u16; 4usize],
                pub delegatesanchor_string: [u16; 16usize],
                pub deletion_string: [u16; 9usize],
                pub deprecation_string: [u16; 12usize],
                pub descendant_string: [u16; 11usize],
                pub descendantOrSelf_string: [u16; 19usize],
                pub descending_string: [u16; 11usize],
                pub description_string: [u16; 12usize],
                pub destructor_string: [u16; 11usize],
                pub details_string: [u16; 8usize],
                pub details_from_string: [u16; 13usize],
                pub deviceAspectRatio_string: [u16; 20usize],
                pub deviceHeight_string: [u16; 14usize],
                pub devicePixelRatio_string: [u16; 19usize],
                pub deviceWidth_string: [u16; 13usize],
                pub dfn_string: [u16; 4usize],
                pub dialog_string: [u16; 7usize],
                pub difference_string: [u16; 11usize],
                pub digit_string: [u16; 6usize],
                pub dir_string: [u16; 4usize],
                pub directory_string: [u16; 10usize],
                pub dirname_string: [u16; 8usize],
                pub disableOutputEscaping_string: [u16; 24usize],
                pub disabled_string: [u16; 9usize],
                pub disableglobalhistory_string: [u16; 21usize],
                pub disablehistory_string: [u16; 15usize],
                pub disablefullscreen_string: [u16; 18usize],
                pub disablepictureinpicture_string: [u16; 24usize],
                pub disclosure_closed_string: [u16; 18usize],
                pub disclosure_open_string: [u16; 16usize],
                pub display_string: [u16; 8usize],
                pub displayMode_string: [u16; 13usize],
                pub distinct_string: [u16; 9usize],
                pub div_string: [u16; 4usize],
                pub dl_string: [u16; 3usize],
                pub docAbstract_string: [u16; 13usize],
                pub docAcknowledgments_string: [u16; 20usize],
                pub docAfterword_string: [u16; 14usize],
                pub docAppendix_string: [u16; 13usize],
                pub docBacklink_string: [u16; 13usize],
                pub docBiblioentry_string: [u16; 16usize],
                pub docBibliography_string: [u16; 17usize],
                pub docBiblioref_string: [u16; 14usize],
                pub docChapter_string: [u16; 12usize],
                pub docColophon_string: [u16; 13usize],
                pub docConclusion_string: [u16; 15usize],
                pub docCover_string: [u16; 10usize],
                pub docCredit_string: [u16; 11usize],
                pub docCredits_string: [u16; 12usize],
                pub docDedication_string: [u16; 15usize],
                pub docEndnote_string: [u16; 12usize],
                pub docEndnotes_string: [u16; 13usize],
                pub docEpigraph_string: [u16; 13usize],
                pub docEpilogue_string: [u16; 13usize],
                pub docErrata_string: [u16; 11usize],
                pub docExample_string: [u16; 12usize],
                pub docFootnote_string: [u16; 13usize],
                pub docForeword_string: [u16; 13usize],
                pub docGlossary_string: [u16; 13usize],
                pub docGlossref_string: [u16; 13usize],
                pub docIndex_string: [u16; 10usize],
                pub docIntroduction_string: [u16; 17usize],
                pub docNoteref_string: [u16; 12usize],
                pub docNotice_string: [u16; 11usize],
                pub docPagebreak_string: [u16; 14usize],
                pub docPagefooter_string: [u16; 15usize],
                pub docPageheader_string: [u16; 15usize],
                pub docPagelist_string: [u16; 13usize],
                pub docPart_string: [u16; 9usize],
                pub docPreface_string: [u16; 12usize],
                pub docPrologue_string: [u16; 13usize],
                pub docPullquote_string: [u16; 14usize],
                pub docQna_string: [u16; 8usize],
                pub docSubtitle_string: [u16; 13usize],
                pub docTip_string: [u16; 8usize],
                pub docToc_string: [u16; 8usize],
                pub doctypePublic_string: [u16; 15usize],
                pub doctypeSystem_string: [u16; 15usize],
                pub document_string: [u16; 9usize],
                pub down_string: [u16; 5usize],
                pub download_string: [u16; 9usize],
                pub drag_string: [u16; 5usize],
                pub draggable_string: [u16; 10usize],
                pub dragging_string: [u16; 9usize],
                pub dragSession_string: [u16; 12usize],
                pub dropAfter_string: [u16; 10usize],
                pub dropBefore_string: [u16; 11usize],
                pub dropOn_string: [u16; 7usize],
                pub dropMarker_string: [u16; 11usize],
                pub dt_string: [u16; 3usize],
                pub e_string: [u16; 2usize],
                pub editable_string: [u16; 9usize],
                pub editing_string: [u16; 8usize],
                pub editor_string: [u16; 7usize],
                pub element_string: [u16; 8usize],
                pub elementAvailable_string: [u16; 18usize],
                pub elements_string: [u16; 9usize],
                pub em_string: [u16; 3usize],
                pub embed_string: [u16; 6usize],
                pub emphasis_string: [u16; 9usize],
                pub empty_string: [u16; 6usize],
                pub encoding_string: [u16; 9usize],
                pub enctype_string: [u16; 8usize],
                pub end_string: [u16; 4usize],
                pub endEvent_string: [u16; 9usize],
                pub enterkeyhint_string: [u16; 13usize],
                pub error_string: [u16; 6usize],
                pub ethiopic_numeric_string: [u16; 17usize],
                pub even_string: [u16; 5usize],
                pub event_string: [u16; 6usize],
                pub events_string: [u16; 7usize],
                pub excludeResultPrefixes_string: [u16; 24usize],
                pub exportparts_string: [u16; 12usize],
                pub explicit_name_string: [u16; 14usize],
                pub extends_string: [u16; 8usize],
                pub extensionElementPrefixes_string: [u16; 27usize],
                pub face_string: [u16; 5usize],
                pub fallback_string: [u16; 9usize],
                pub _false_string: [u16; 6usize],
                pub farthest_string: [u16; 9usize],
                pub featurePolicyViolation_string: [u16; 25usize],
                pub fetchpriority_string: [u16; 14usize],
                pub field_string: [u16; 6usize],
                pub fieldset_string: [u16; 9usize],
                pub file_string: [u16; 5usize],
                pub figcaption_string: [u16; 11usize],
                pub figure_string: [u16; 7usize],
                pub findbar_string: [u16; 8usize],
                pub firstColumn_string: [u16; 13usize],
                pub firstInput_string: [u16; 12usize],
                pub fixed_string: [u16; 6usize],
                pub flags_string: [u16; 6usize],
                pub flex_string: [u16; 5usize],
                pub flip_string: [u16; 5usize],
                pub floor_string: [u16; 6usize],
                pub flowlength_string: [u16; 11usize],
                pub focus_string: [u16; 6usize],
                pub focused_string: [u16; 8usize],
                pub followanchor_string: [u16; 13usize],
                pub following_string: [u16; 10usize],
                pub followingSibling_string: [u16; 18usize],
                pub font_string: [u16; 5usize],
                pub footer_string: [u16; 7usize],
                pub _for_string: [u16; 4usize],
                pub forEach_string: [u16; 9usize],
                pub forcedColors_string: [u16; 14usize],
                pub invertedColors_string: [u16; 16usize],
                pub forceOwnRefreshDriver_string: [u16; 22usize],
                pub form_string: [u16; 5usize],
                pub formaction_string: [u16; 11usize],
                pub format_string: [u16; 7usize],
                pub formatNumber_string: [u16; 14usize],
                pub formenctype_string: [u16; 12usize],
                pub formmethod_string: [u16; 11usize],
                pub formnovalidate_string: [u16; 15usize],
                pub formtarget_string: [u16; 11usize],
                pub frame_string: [u16; 6usize],
                pub frameborder_string: [u16; 12usize],
                pub frameset_string: [u16; 9usize],
                pub from_string: [u16; 5usize],
                pub fullscreenchange_string: [u16; 17usize],
                pub fullscreenerror_string: [u16; 16usize],
                pub functionAvailable_string: [u16; 19usize],
                pub generateId_string: [u16; 12usize],
                pub generic_string: [u16; 8usize],
                pub getter_string: [u16; 7usize],
                pub graphicsDocument_string: [u16; 18usize],
                pub graphicsObject_string: [u16; 16usize],
                pub graphicsSymbol_string: [u16; 16usize],
                pub grid_string: [u16; 5usize],
                pub group_string: [u16; 6usize],
                pub groups_string: [u16; 7usize],
                pub groupbox_string: [u16; 9usize],
                pub groupingSeparator_string: [u16; 19usize],
                pub groupingSize_string: [u16; 14usize],
                pub grow_string: [u16; 5usize],
                pub h1_string: [u16; 3usize],
                pub h2_string: [u16; 3usize],
                pub h3_string: [u16; 3usize],
                pub h4_string: [u16; 3usize],
                pub h5_string: [u16; 3usize],
                pub h6_string: [u16; 3usize],
                pub hairline_string: [u16; 9usize],
                pub handheldFriendly_string: [u16; 17usize],
                pub handler_string: [u16; 8usize],
                pub handlers_string: [u16; 9usize],
                pub HARD_string: [u16; 5usize],
                pub hasActions_string: [u16; 12usize],
                pub hasSameNode_string: [u16; 14usize],
                pub hbox_string: [u16; 5usize],
                pub head_string: [u16; 5usize],
                pub header_string: [u16; 7usize],
                pub headers_string: [u16; 8usize],
                pub hebrew_string: [u16; 7usize],
                pub height_string: [u16; 7usize],
                pub hgroup_string: [u16; 7usize],
                pub hidden_string: [u16; 7usize],
                pub hidechrome_string: [u16; 11usize],
                pub hidecolumnpicker_string: [u16; 17usize],
                pub hidetitlebarseparator_string: [u16; 22usize],
                pub hide_popover_string: [u16; 13usize],
                pub high_string: [u16; 5usize],
                pub highest_string: [u16; 8usize],
                pub horizontal_string: [u16; 11usize],
                pub hover_string: [u16; 6usize],
                pub hr_string: [u16; 3usize],
                pub href_string: [u16; 5usize],
                pub hreflang_string: [u16; 9usize],
                pub hsides_string: [u16; 7usize],
                pub hspace_string: [u16; 7usize],
                pub html_string: [u16; 5usize],
                pub httpEquiv_string: [u16; 11usize],
                pub i_string: [u16; 2usize],
                pub icon_string: [u16; 5usize],
                pub id_string: [u16; 3usize],
                pub _if_string: [u16; 3usize],
                pub iframe_string: [u16; 7usize],
                pub ignorekeys_string: [u16; 11usize],
                pub ignoreuserfocus_string: [u16; 16usize],
                pub image_string: [u16; 6usize],
                pub imageClickedPoint_string: [u16; 20usize],
                pub imagesizes_string: [u16; 11usize],
                pub imagesrcset_string: [u16; 12usize],
                pub img_string: [u16; 4usize],
                pub implementation_string: [u16; 15usize],
                pub implements_string: [u16; 11usize],
                pub import_string: [u16; 7usize],
                pub include_string: [u16; 8usize],
                pub includes_string: [u16; 9usize],
                pub incontentshell_string: [u16; 15usize],
                pub increment_string: [u16; 10usize],
                pub indent_string: [u16; 7usize],
                pub indeterminate_string: [u16; 14usize],
                pub index_string: [u16; 6usize],
                pub inert_string: [u16; 6usize],
                pub innerHTML_string: [u16; 10usize],
                pub innerText_string: [u16; 10usize],
                pub infinity_string: [u16; 9usize],
                pub inherits_string: [u16; 9usize],
                pub inheritOverflow_string: [u16; 17usize],
                pub inheritstyle_string: [u16; 13usize],
                pub initial_scale_string: [u16; 14usize],
                pub input_string: [u16; 6usize],
                pub inputmode_string: [u16; 10usize],
                pub ins_string: [u16; 4usize],
                pub insertafter_string: [u16; 12usize],
                pub insertbefore_string: [u16; 13usize],
                pub insertion_string: [u16; 10usize],
                pub integer_string: [u16; 8usize],
                pub integrity_string: [u16; 10usize],
                pub interactive_widget_string: [u16; 19usize],
                pub internal_string: [u16; 9usize],
                pub internals_string: [u16; 10usize],
                pub intersection_string: [u16; 13usize],
                pub is_string: [u16; 3usize],
                pub ismap_string: [u16; 6usize],
                pub ispopup_string: [u16; 8usize],
                pub itemid_string: [u16; 7usize],
                pub itemprop_string: [u16; 9usize],
                pub itemref_string: [u16; 8usize],
                pub itemscope_string: [u16; 10usize],
                pub itemtype_string: [u16; 9usize],
                pub japanese_formal_string: [u16; 16usize],
                pub japanese_informal_string: [u16; 18usize],
                pub kbd_string: [u16; 4usize],
                pub keepcurrentinview_string: [u16; 18usize],
                pub key_string: [u16; 4usize],
                pub keycode_string: [u16; 8usize],
                pub keydown_string: [u16; 8usize],
                pub keygen_string: [u16; 7usize],
                pub keypress_string: [u16; 9usize],
                pub keyset_string: [u16; 7usize],
                pub keysystem_string: [u16; 10usize],
                pub keyup_string: [u16; 6usize],
                pub kind_string: [u16; 5usize],
                pub korean_hangul_formal_string: [u16; 21usize],
                pub korean_hanja_formal_string: [u16; 20usize],
                pub korean_hanja_informal_string: [u16; 22usize],
                pub label_string: [u16; 6usize],
                pub lang_string: [u16; 5usize],
                pub language_string: [u16; 9usize],
                pub largestContentfulPaint_string: [u16; 25usize],
                pub last_string: [u16; 5usize],
                pub layer_string: [u16; 6usize],
                pub LayerActivity_string: [u16; 14usize],
                pub layout_guess_string: [u16; 13usize],
                pub leading_string: [u16; 8usize],
                pub leaf_string: [u16; 5usize],
                pub left_string: [u16; 5usize],
                pub leftmargin_string: [u16; 11usize],
                pub legend_string: [u16; 7usize],
                pub length_string: [u16; 7usize],
                pub letterValue_string: [u16; 13usize],
                pub level_string: [u16; 6usize],
                pub lhs_string: [u16; 4usize],
                pub li_string: [u16; 3usize],
                pub line_string: [u16; 5usize],
                pub link_string: [u16; 5usize],
                pub linkset_string: [u16; 8usize],
                pub listbox_string: [u16; 8usize],
                pub listener_string: [u16; 9usize],
                pub listheader_string: [u16; 11usize],
                pub listing_string: [u16; 8usize],
                pub listitem_string: [u16; 9usize],
                pub load_string: [u16; 5usize],
                pub loading_string: [u16; 8usize],
                pub touchmode_string: [u16; 10usize],
                pub triggeringprincipal_string: [u16; 20usize],
                pub localedir_string: [u16; 10usize],
                pub localName_string: [u16; 11usize],
                pub localization_string: [u16; 13usize],
                pub longdesc_string: [u16; 9usize],
                pub loop_string: [u16; 5usize],
                pub low_string: [u16; 4usize],
                pub lowerFirst_string: [u16; 12usize],
                pub lowest_string: [u16; 7usize],
                pub lowsrc_string: [u16; 7usize],
                pub ltr_string: [u16; 4usize],
                pub main_string: [u16; 5usize],
                pub map_string: [u16; 4usize],
                pub manifest_string: [u16; 9usize],
                pub marginBottom_string: [u16; 14usize],
                pub marginLeft_string: [u16; 12usize],
                pub marginRight_string: [u16; 13usize],
                pub marginTop_string: [u16; 11usize],
                pub marginheight_string: [u16; 13usize],
                pub marginwidth_string: [u16; 12usize],
                pub mark_string: [u16; 5usize],
                pub marquee_string: [u16; 8usize],
                pub match_string: [u16; 6usize],
                pub max_string: [u16; 4usize],
                pub maxheight_string: [u16; 10usize],
                pub maximum_scale_string: [u16; 14usize],
                pub maxlength_string: [u16; 10usize],
                pub maxpos_string: [u16; 7usize],
                pub maxwidth_string: [u16; 9usize],
                pub measure_string: [u16; 8usize],
                pub media_string: [u16; 6usize],
                pub mediaType_string: [u16; 11usize],
                pub menu_string: [u16; 5usize],
                pub menubar_string: [u16; 8usize],
                pub menucaption_string: [u16; 12usize],
                pub menugroup_string: [u16; 10usize],
                pub menuitem_string: [u16; 9usize],
                pub menulist_string: [u16; 9usize],
                pub menupopup_string: [u16; 10usize],
                pub menuseparator_string: [u16; 14usize],
                pub mesh_string: [u16; 5usize],
                pub message_string: [u16; 8usize],
                pub meta_string: [u16; 5usize],
                pub referrer_string: [u16; 9usize],
                pub referrerpolicy_string: [u16; 15usize],
                pub renderroot_string: [u16; 11usize],
                pub headerReferrerPolicy_string: [u16; 16usize],
                pub meter_string: [u16; 6usize],
                pub method_string: [u16; 7usize],
                pub middle_string: [u16; 7usize],
                pub min_string: [u16; 4usize],
                pub minheight_string: [u16; 10usize],
                pub minimum_scale_string: [u16; 14usize],
                pub minlength_string: [u16; 10usize],
                pub minpos_string: [u16; 7usize],
                pub minusSign_string: [u16; 11usize],
                pub minwidth_string: [u16; 9usize],
                pub mixed_string: [u16; 6usize],
                pub messagemanagergroup_string: [u16; 20usize],
                pub mod_string: [u16; 4usize],
                pub _module_string: [u16; 7usize],
                pub mode_string: [u16; 5usize],
                pub modifiers_string: [u16; 10usize],
                pub monochrome_string: [u16; 11usize],
                pub mouseover_string: [u16; 10usize],
                pub mozAccessiblecaret_string: [u16; 20usize],
                pub mozCustomContentContainer_string: [u16; 29usize],
                pub mozGrabber_string: [u16; 11usize],
                pub mozNativeAnonymous_string: [u16; 22usize],
                pub mozprivatebrowsing_string: [u16; 19usize],
                pub mozResizer_string: [u16; 11usize],
                pub mozResizingInfo_string: [u16; 16usize],
                pub mozResizingShadow_string: [u16; 18usize],
                pub mozTableAddColumnAfter_string: [u16; 23usize],
                pub mozTableAddColumnBefore_string: [u16; 24usize],
                pub mozTableAddRowAfter_string: [u16; 20usize],
                pub mozTableAddRowBefore_string: [u16; 21usize],
                pub mozTableRemoveRow_string: [u16; 18usize],
                pub mozTableRemoveColumn_string: [u16; 21usize],
                pub moz_opaque_string: [u16; 11usize],
                pub multicol_string: [u16; 9usize],
                pub multiple_string: [u16; 9usize],
                pub muted_string: [u16; 6usize],
                pub name_string: [u16; 5usize],
                pub native_string: [u16; 7usize],
                pub _namespace_string: [u16; 10usize],
                pub namespaceAlias_string: [u16; 16usize],
                pub namespaceUri_string: [u16; 14usize],
                pub NaN_string: [u16; 4usize],
                pub n_string: [u16; 2usize],
                pub nav_string: [u16; 4usize],
                pub ne_string: [u16; 3usize],
                pub never_string: [u16; 6usize],
                pub neverhidden_string: [u16; 12usize],
                pub _new_string: [u16; 4usize],
                pub newline_string: [u16; 8usize],
                pub nextRemoteTabId_string: [u16; 16usize],
                pub no_string: [u16; 3usize],
                pub noautofocus_string: [u16; 12usize],
                pub noautohide_string: [u16; 11usize],
                pub norolluponanchor_string: [u16; 17usize],
                pub noBar_string: [u16; 7usize],
                pub nobr_string: [u16; 5usize],
                pub nodefaultsrc_string: [u16; 13usize],
                pub nodeSet_string: [u16; 9usize],
                pub noembed_string: [u16; 8usize],
                pub noframes_string: [u16; 9usize],
                pub nohref_string: [u16; 7usize],
                pub noinitialselection_string: [u16; 19usize],
                pub nomodule_string: [u16; 9usize],
                pub nonce_string: [u16; 6usize],
                pub none_string: [u16; 5usize],
                pub noresize_string: [u16; 9usize],
                pub normal_string: [u16; 7usize],
                pub normalizeSpace_string: [u16; 16usize],
                pub noscript_string: [u16; 9usize],
                pub noshade_string: [u16; 8usize],
                pub notification_string: [u16; 13usize],
                pub novalidate_string: [u16; 11usize],
                pub _not_string: [u16; 4usize],
                pub nowrap_string: [u16; 7usize],
                pub number_string: [u16; 7usize],
                pub nw_string: [u16; 3usize],
                pub object_string: [u16; 7usize],
                pub objectType_string: [u16; 12usize],
                pub observes_string: [u16; 9usize],
                pub odd_string: [u16; 4usize],
                pub OFF_string: [u16; 4usize],
                pub ol_string: [u16; 3usize],
                pub omitXmlDeclaration_string: [u16; 21usize],
                pub onabort_string: [u16; 8usize],
                pub onmozaccesskeynotfound_string: [u16; 23usize],
                pub onactivate_string: [u16; 11usize],
                pub onafterprint_string: [u16; 13usize],
                pub onanimationcancel_string: [u16; 18usize],
                pub onanimationend_string: [u16; 15usize],
                pub onanimationiteration_string: [u16; 21usize],
                pub onanimationstart_string: [u16; 17usize],
                pub onAppCommand_string: [u16; 13usize],
                pub onaudioprocess_string: [u16; 15usize],
                pub onauxclick_string: [u16; 11usize],
                pub onbeforecopy_string: [u16; 13usize],
                pub onbeforecut_string: [u16; 12usize],
                pub onbeforeinput_string: [u16; 14usize],
                pub onbeforematch_string: [u16; 14usize],
                pub onbeforepaste_string: [u16; 14usize],
                pub onbeforeprint_string: [u16; 14usize],
                pub onbeforeunload_string: [u16; 15usize],
                pub onblocked_string: [u16; 10usize],
                pub onblur_string: [u16; 7usize],
                pub onboundschange_string: [u16; 15usize],
                pub onbroadcast_string: [u16; 12usize],
                pub onbufferedamountlow_string: [u16; 20usize],
                pub oncached_string: [u16; 9usize],
                pub oncancel_string: [u16; 9usize],
                pub onchange_string: [u16; 9usize],
                pub onchargingchange_string: [u16; 17usize],
                pub onchargingtimechange_string: [u16; 21usize],
                pub onchecking_string: [u16; 11usize],
                pub onCheckboxStateChange_string: [u16; 22usize],
                pub onCheckKeyPressEventModel_string: [u16; 26usize],
                pub onclick_string: [u16; 8usize],
                pub onclose_string: [u16; 8usize],
                pub onclosing_string: [u16; 10usize],
                pub oncontentvisibilityautostatechange_string: [u16; 35usize],
                pub oncommand_string: [u16; 10usize],
                pub oncommandupdate_string: [u16; 16usize],
                pub oncomplete_string: [u16; 11usize],
                pub oncompositionend_string: [u16; 17usize],
                pub oncompositionstart_string: [u16; 19usize],
                pub oncompositionupdate_string: [u16; 20usize],
                pub onconnect_string: [u16; 10usize],
                pub onconnectionavailable_string: [u16; 22usize],
                pub oncontextmenu_string: [u16; 14usize],
                pub oncontextlost_string: [u16; 14usize],
                pub oncontextrestored_string: [u16; 18usize],
                pub oncookiechange_string: [u16; 15usize],
                pub oncopy_string: [u16; 7usize],
                pub oncut_string: [u16; 6usize],
                pub oncurrententrychange_string: [u16; 21usize],
                pub ondblclick_string: [u16; 11usize],
                pub ondischargingtimechange_string: [u16; 24usize],
                pub ondispose_string: [u16; 10usize],
                pub ondownloading_string: [u16; 14usize],
                pub onDOMActivate_string: [u16; 14usize],
                pub onDOMFocusIn_string: [u16; 13usize],
                pub onDOMFocusOut_string: [u16; 14usize],
                pub onDOMMouseScroll_string: [u16; 17usize],
                pub ondata_string: [u16; 7usize],
                pub ondrag_string: [u16; 7usize],
                pub ondragdrop_string: [u16; 11usize],
                pub ondragend_string: [u16; 10usize],
                pub ondragenter_string: [u16; 12usize],
                pub ondragexit_string: [u16; 11usize],
                pub ondragleave_string: [u16; 12usize],
                pub ondragover_string: [u16; 11usize],
                pub ondragstart_string: [u16; 12usize],
                pub ondrain_string: [u16; 8usize],
                pub ondrop_string: [u16; 7usize],
                pub onerror_string: [u16; 8usize],
                pub onfinish_string: [u16; 9usize],
                pub onfocus_string: [u16; 8usize],
                pub onfocusin_string: [u16; 10usize],
                pub onfocusout_string: [u16; 11usize],
                pub onfullscreenchange_string: [u16; 19usize],
                pub onfullscreenerror_string: [u16; 18usize],
                pub ongatheringstatechange_string: [u16; 23usize],
                pub onget_string: [u16; 6usize],
                pub onhashchange_string: [u16; 13usize],
                pub oninput_string: [u16; 8usize],
                pub oninputsourceschange_string: [u16; 21usize],
                pub oninstall_string: [u16; 10usize],
                pub oninvalid_string: [u16; 10usize],
                pub onkeydown_string: [u16; 10usize],
                pub onkeypress_string: [u16; 11usize],
                pub onkeyup_string: [u16; 8usize],
                pub onlanguagechange_string: [u16; 17usize],
                pub onlevelchange_string: [u16; 14usize],
                pub onload_string: [u16; 7usize],
                pub onloading_string: [u16; 10usize],
                pub onloadingdone_string: [u16; 14usize],
                pub onloadingerror_string: [u16; 15usize],
                pub onpopstate_string: [u16; 11usize],
                pub only_string: [u16; 5usize],
                pub onmerchantvalidation_string: [u16; 21usize],
                pub onmessage_string: [u16; 10usize],
                pub onmessageerror_string: [u16; 15usize],
                pub onmidimessage_string: [u16; 14usize],
                pub onmousedown_string: [u16; 12usize],
                pub onmouseenter_string: [u16; 13usize],
                pub onmouseleave_string: [u16; 13usize],
                pub onmouselongtap_string: [u16; 15usize],
                pub onmousemove_string: [u16; 12usize],
                pub onmouseout_string: [u16; 11usize],
                pub onmouseover_string: [u16; 12usize],
                pub onMozMouseHittest_string: [u16; 18usize],
                pub onMozMouseExploreByTouch_string: [u16; 25usize],
                pub onmouseup_string: [u16; 10usize],
                pub onMozAfterPaint_string: [u16; 16usize],
                pub onmozfullscreenchange_string: [u16; 22usize],
                pub onmozfullscreenerror_string: [u16; 21usize],
                pub onmozpointerlockchange_string: [u16; 23usize],
                pub onmozpointerlockerror_string: [u16; 22usize],
                pub onMozMousePixelScroll_string: [u16; 22usize],
                pub onMozScrolledAreaChanged_string: [u16; 25usize],
                pub onmute_string: [u16; 7usize],
                pub onnavigate_string: [u16; 11usize],
                pub onnavigatesuccess_string: [u16; 18usize],
                pub onnavigateerror_string: [u16; 16usize],
                pub onnotificationclick_string: [u16; 20usize],
                pub onnotificationclose_string: [u16; 20usize],
                pub onnoupdate_string: [u16; 11usize],
                pub onobsolete_string: [u16; 11usize],
                pub ononline_string: [u16; 9usize],
                pub onoffline_string: [u16; 10usize],
                pub onopen_string: [u16; 7usize],
                pub onorientationchange_string: [u16; 20usize],
                pub onoverflow_string: [u16; 11usize],
                pub onpagehide_string: [u16; 11usize],
                pub onpageshow_string: [u16; 11usize],
                pub onpaste_string: [u16; 8usize],
                pub onpayerdetailchange_string: [u16; 20usize],
                pub onpaymentmethodchange_string: [u16; 22usize],
                pub onpointerlockchange_string: [u16; 20usize],
                pub onpointerlockerror_string: [u16; 19usize],
                pub onpopuphidden_string: [u16; 14usize],
                pub onpopuphiding_string: [u16; 14usize],
                pub onpopuppositioned_string: [u16; 18usize],
                pub onpopupshowing_string: [u16; 15usize],
                pub onpopupshown_string: [u16; 13usize],
                pub onprocessorerror_string: [u16; 17usize],
                pub onprioritychange_string: [u16; 17usize],
                pub onpush_string: [u16; 7usize],
                pub onpushsubscriptionchange_string: [u16; 25usize],
                pub onRadioStateChange_string: [u16; 19usize],
                pub onreadystatechange_string: [u16; 19usize],
                pub onrejectionhandled_string: [u16; 19usize],
                pub onremove_string: [u16; 9usize],
                pub onrequestprogress_string: [u16; 18usize],
                pub onresourcetimingbufferfull_string: [u16; 27usize],
                pub onresponseprogress_string: [u16; 19usize],
                pub onRequest_string: [u16; 10usize],
                pub onreset_string: [u16; 8usize],
                pub onresize_string: [u16; 9usize],
                pub onscroll_string: [u16; 9usize],
                pub onsecuritypolicyviolation_string: [u16; 26usize],
                pub onselect_string: [u16; 9usize],
                pub onselectionchange_string: [u16; 18usize],
                pub onselectend_string: [u16; 12usize],
                pub onselectstart_string: [u16; 14usize],
                pub onset_string: [u16; 6usize],
                pub onshippingaddresschange_string: [u16; 24usize],
                pub onshippingoptionchange_string: [u16; 23usize],
                pub onshow_string: [u16; 7usize],
                pub onslotchange_string: [u16; 13usize],
                pub onsqueeze_string: [u16; 10usize],
                pub onsqueezeend_string: [u16; 13usize],
                pub onsqueezestart_string: [u16; 15usize],
                pub onstatechange_string: [u16; 14usize],
                pub onstorage_string: [u16; 10usize],
                pub onsubmit_string: [u16; 9usize],
                pub onsuccess_string: [u16; 10usize],
                pub onsystemstatusbarclick_string: [u16; 23usize],
                pub ontypechange_string: [u16; 13usize],
                pub onterminate_string: [u16; 12usize],
                pub ontext_string: [u16; 7usize],
                pub ontextInput_string: [u16; 12usize],
                pub ontoggle_string: [u16; 9usize],
                pub ontonechange_string: [u16; 13usize],
                pub ontouchstart_string: [u16; 13usize],
                pub ontouchend_string: [u16; 11usize],
                pub ontouchmove_string: [u16; 12usize],
                pub ontouchcancel_string: [u16; 14usize],
                pub ontransitioncancel_string: [u16; 19usize],
                pub ontransitionend_string: [u16; 16usize],
                pub ontransitionrun_string: [u16; 16usize],
                pub ontransitionstart_string: [u16; 18usize],
                pub onuncapturederror_string: [u16; 18usize],
                pub onunderflow_string: [u16; 12usize],
                pub onunhandledrejection_string: [u16; 21usize],
                pub onunload_string: [u16; 9usize],
                pub onunmute_string: [u16; 9usize],
                pub onupdatefound_string: [u16; 14usize],
                pub onupdateready_string: [u16; 14usize],
                pub onupgradeneeded_string: [u16; 16usize],
                pub onversionchange_string: [u16; 16usize],
                pub onvisibilitychange_string: [u16; 19usize],
                pub onvoiceschanged_string: [u16; 16usize],
                pub onvrdisplayactivate_string: [u16; 20usize],
                pub onvrdisplayconnect_string: [u16; 19usize],
                pub onvrdisplaydeactivate_string: [u16; 22usize],
                pub onvrdisplaydisconnect_string: [u16; 22usize],
                pub onvrdisplaypresentchange_string: [u16; 25usize],
                pub onwebkitAnimationEnd_string: [u16; 21usize],
                pub onwebkitAnimationIteration_string: [u16; 27usize],
                pub onwebkitAnimationStart_string: [u16; 23usize],
                pub onwebkitTransitionEnd_string: [u16; 22usize],
                pub onwebkitanimationend_string: [u16; 21usize],
                pub onwebkitanimationiteration_string: [u16; 27usize],
                pub onwebkitanimationstart_string: [u16; 23usize],
                pub onwebkittransitionend_string: [u16; 22usize],
                pub onwheel_string: [u16; 8usize],
                pub open_string: [u16; 5usize],
                pub optgroup_string: [u16; 9usize],
                pub optimum_string: [u16; 8usize],
                pub option_string: [u16; 7usize],
                pub _or_string: [u16; 3usize],
                pub order_string: [u16; 6usize],
                pub ordinal_string: [u16; 8usize],
                pub orient_string: [u16; 7usize],
                pub orientation_string: [u16; 12usize],
                pub origin_trial_string: [u16; 13usize],
                pub otherwise_string: [u16; 10usize],
                pub outerHTML_string: [u16; 10usize],
                pub output_string: [u16; 7usize],
                pub overflow_string: [u16; 9usize],
                pub overflowBlock_string: [u16; 15usize],
                pub overflowInline_string: [u16; 16usize],
                pub overlay_string: [u16; 8usize],
                pub p_string: [u16; 2usize],
                pub pack_string: [u16; 5usize],
                pub page_string: [u16; 5usize],
                pub pageincrement_string: [u16; 14usize],
                pub paint_string: [u16; 6usize],
                pub paint_order_string: [u16; 12usize],
                pub panel_string: [u16; 6usize],
                pub paragraph_string: [u16; 10usize],
                pub param_string: [u16; 6usize],
                pub parameter_string: [u16; 10usize],
                pub parent_string: [u16; 7usize],
                pub parsererror_string: [u16; 12usize],
                pub part_string: [u16; 5usize],
                pub password_string: [u16; 9usize],
                pub pattern_string: [u16; 8usize],
                pub patternSeparator_string: [u16; 18usize],
                pub perMille_string: [u16; 10usize],
                pub percent_string: [u16; 8usize],
                pub persist_string: [u16; 8usize],
                pub phase_string: [u16; 6usize],
                pub picture_string: [u16; 8usize],
                pub ping_string: [u16; 5usize],
                pub pinned_string: [u16; 7usize],
                pub placeholder_string: [u16; 12usize],
                pub plaintext_string: [u16; 10usize],
                pub plaintextOnly_string: [u16; 15usize],
                pub playbackrate_string: [u16; 13usize],
                pub pointSize_string: [u16; 11usize],
                pub poly_string: [u16; 5usize],
                pub polygon_string: [u16; 8usize],
                pub popover_string: [u16; 8usize],
                pub popovertarget_string: [u16; 14usize],
                pub popovertargetaction_string: [u16; 20usize],
                pub popup_string: [u16; 6usize],
                pub popupalign_string: [u16; 11usize],
                pub popupanchor_string: [u16; 12usize],
                pub popupgroup_string: [u16; 11usize],
                pub popupset_string: [u16; 9usize],
                pub popupsinherittooltip_string: [u16; 21usize],
                pub portal_string: [u16; 7usize],
                pub position_string: [u16; 9usize],
                pub poster_string: [u16; 7usize],
                pub pre_string: [u16; 4usize],
                pub preceding_string: [u16; 10usize],
                pub precedingSibling_string: [u16; 18usize],
                pub prefersReducedMotion_string: [u16; 23usize],
                pub prefersReducedTransparency_string: [u16; 29usize],
                pub prefersColorScheme_string: [u16; 21usize],
                pub prefersContrast_string: [u16; 17usize],
                pub prefix_string: [u16; 7usize],
                pub prefwidth_string: [u16; 10usize],
                pub queue_string: [u16; 6usize],
                pub dynamicRange_string: [u16; 14usize],
                pub videoDynamicRange_string: [u16; 20usize],
                pub scripting_string: [u16; 10usize],
                pub preload_string: [u16; 8usize],
                pub preserve_string: [u16; 9usize],
                pub preserveSpace_string: [u16; 15usize],
                pub preventdefault_string: [u16; 15usize],
                pub previewDiv_string: [u16; 12usize],
                pub primary_string: [u16; 8usize],
                pub print_string: [u16; 6usize],
                pub printisfocuseddoc_string: [u16; 18usize],
                pub printselectionranges_string: [u16; 21usize],
                pub priority_string: [u16; 9usize],
                pub processingInstruction_string: [u16; 23usize],
                pub profile_string: [u16; 8usize],
                pub progress_string: [u16; 9usize],
                pub prompt_string: [u16; 7usize],
                pub properties_string: [u16; 11usize],
                pub property_string: [u16; 9usize],
                pub pubdate_string: [u16; 8usize],
                pub q_string: [u16; 2usize],
                pub radio_string: [u16; 6usize],
                pub radioLabel_string: [u16; 12usize],
                pub radiogroup_string: [u16; 11usize],
                pub range_string: [u16; 6usize],
                pub rating_string: [u16; 7usize],
                pub readonly_string: [u16; 9usize],
                pub rect_string: [u16; 5usize],
                pub rectangle_string: [u16; 10usize],
                pub refresh_string: [u16; 8usize],
                pub rel_string: [u16; 4usize],
                pub relativeBounds_string: [u16; 16usize],
                pub rem_string: [u16; 4usize],
                pub remote_string: [u16; 7usize],
                pub removeelement_string: [u16; 14usize],
                pub render_string: [u16; 7usize],
                pub renderingobserverset_string: [u16; 21usize],
                pub repeat_string: [u16; 7usize],
                pub replace_string: [u16; 8usize],
                pub requestcontextid_string: [u16; 17usize],
                pub required_string: [u16; 9usize],
                pub reserved_string: [u16; 9usize],
                pub reset_string: [u16; 6usize],
                pub resizeafter_string: [u16; 12usize],
                pub resizebefore_string: [u16; 13usize],
                pub resizer_string: [u16; 8usize],
                pub resolution_string: [u16; 11usize],
                pub resources_string: [u16; 10usize],
                pub restrictToAdults_string: [u16; 28usize],
                pub result_string: [u16; 7usize],
                pub resultPrefix_string: [u16; 14usize],
                pub retargetdocumentfocus_string: [u16; 22usize],
                pub rev_string: [u16; 4usize],
                pub reverse_string: [u16; 8usize],
                pub reversed_string: [u16; 9usize],
                pub rhs_string: [u16; 4usize],
                pub richlistbox_string: [u16; 12usize],
                pub richlistitem_string: [u16; 13usize],
                pub right_string: [u16; 6usize],
                pub rightmargin_string: [u16; 12usize],
                pub role_string: [u16; 5usize],
                pub rolluponmousewheel_string: [u16; 19usize],
                pub round_string: [u16; 6usize],
                pub row_string: [u16; 4usize],
                pub rows_string: [u16; 5usize],
                pub rowspan_string: [u16; 8usize],
                pub rb_string: [u16; 3usize],
                pub rp_string: [u16; 3usize],
                pub rt_string: [u16; 3usize],
                pub rtc_string: [u16; 4usize],
                pub rtl_string: [u16; 4usize],
                pub ruby_string: [u16; 5usize],
                pub rubyBase_string: [u16; 10usize],
                pub rubyBaseContainer_string: [u16; 20usize],
                pub rubyText_string: [u16; 10usize],
                pub rubyTextContainer_string: [u16; 20usize],
                pub rules_string: [u16; 6usize],
                pub s_string: [u16; 2usize],
                pub safe_area_inset_top_string: [u16; 20usize],
                pub safe_area_inset_bottom_string: [u16; 23usize],
                pub safe_area_inset_left_string: [u16; 21usize],
                pub safe_area_inset_right_string: [u16; 22usize],
                pub samp_string: [u16; 5usize],
                pub sandbox_string: [u16; 8usize],
                pub sbattr_string: [u16; 7usize],
                pub scale_string: [u16; 6usize],
                pub scan_string: [u16; 5usize],
                pub scheme_string: [u16; 7usize],
                pub scope_string: [u16; 6usize],
                pub scoped_string: [u16; 7usize],
                pub screen_string: [u16; 7usize],
                pub screenX_string: [u16; 8usize],
                pub screenx_string: [u16; 8usize],
                pub screenY_string: [u16; 8usize],
                pub screeny_string: [u16; 8usize],
                pub script_string: [u16; 7usize],
                pub scrollbar_string: [u16; 10usize],
                pub scrollbarThumb_string: [u16; 16usize],
                pub scrollamount_string: [u16; 13usize],
                pub scrollbarbutton_string: [u16; 16usize],
                pub scrollbarDownBottom_string: [u16; 22usize],
                pub scrollbarDownTop_string: [u16; 19usize],
                pub scrollbarInlineSize_string: [u16; 22usize],
                pub scrollbarUpBottom_string: [u16; 20usize],
                pub scrollbarUpTop_string: [u16; 17usize],
                pub scrollbox_string: [u16; 10usize],
                pub scrollcorner_string: [u16; 13usize],
                pub scrolldelay_string: [u16; 12usize],
                pub scrolling_string: [u16; 10usize],
                pub scrollPosition_string: [u16; 16usize],
                pub se_string: [u16; 3usize],
                pub section_string: [u16; 8usize],
                pub select_string: [u16; 7usize],
                pub selected_string: [u16; 9usize],
                pub selectedIndex_string: [u16; 14usize],
                pub selectedindex_string: [u16; 14usize],
                pub selectmenu_string: [u16; 11usize],
                pub self_string: [u16; 5usize],
                pub seltype_string: [u16; 8usize],
                pub setcookie_string: [u16; 11usize],
                pub setter_string: [u16; 7usize],
                pub shadow_string: [u16; 7usize],
                pub shadowrootreferencetarget_string: [u16; 26usize],
                pub shape_string: [u16; 6usize],
                pub show_string: [u16; 5usize],
                pub showcaret_string: [u16; 10usize],
                pub show_modal_string: [u16; 11usize],
                pub show_popover_string: [u16; 13usize],
                pub showservicesmenu_string: [u16; 17usize],
                pub sibling_string: [u16; 8usize],
                pub simple_string: [u16; 7usize],
                pub simp_chinese_formal_string: [u16; 20usize],
                pub simp_chinese_informal_string: [u16; 22usize],
                pub single_string: [u16; 7usize],
                pub size_string: [u16; 5usize],
                pub sizes_string: [u16; 6usize],
                pub sizemode_string: [u16; 9usize],
                pub sizetopopup_string: [u16; 12usize],
                pub slider_string: [u16; 7usize],
                pub small_string: [u16; 6usize],
                pub smooth_string: [u16; 7usize],
                pub snap_string: [u16; 5usize],
                pub solid_string: [u16; 6usize],
                pub sort_string: [u16; 5usize],
                pub sortActive_string: [u16; 11usize],
                pub sortDirection_string: [u16; 14usize],
                pub sorted_string: [u16; 7usize],
                pub sorthints_string: [u16; 10usize],
                pub source_string: [u16; 7usize],
                pub sourcetext_string: [u16; 11usize],
                pub space_string: [u16; 6usize],
                pub spacer_string: [u16; 7usize],
                pub span_string: [u16; 5usize],
                pub spellcheck_string: [u16; 11usize],
                pub split_string: [u16; 6usize],
                pub splitter_string: [u16; 9usize],
                pub square_string: [u16; 7usize],
                pub src_string: [u16; 4usize],
                pub srcdoc_string: [u16; 7usize],
                pub srclang_string: [u16; 8usize],
                pub srcset_string: [u16; 7usize],
                pub standalone_string: [u16; 11usize],
                pub standby_string: [u16; 8usize],
                pub start_string: [u16; 6usize],
                pub startsWith_string: [u16; 12usize],
                pub state_string: [u16; 6usize],
                pub statusbar_string: [u16; 10usize],
                pub step_string: [u16; 5usize],
                pub stop_string: [u16; 5usize],
                pub stretch_string: [u16; 8usize],
                pub strike_string: [u16; 7usize],
                pub string_string: [u16; 7usize],
                pub stringLength_string: [u16; 14usize],
                pub stripSpace_string: [u16; 12usize],
                pub strong_string: [u16; 7usize],
                pub style_string: [u16; 6usize],
                pub stylesheet_string: [u16; 11usize],
                pub stylesheetPrefix_string: [u16; 18usize],
                pub submit_string: [u16; 7usize],
                pub substate_string: [u16; 9usize],
                pub substring_string: [u16; 10usize],
                pub substringAfter_string: [u16; 16usize],
                pub substringBefore_string: [u16; 17usize],
                pub sub_string: [u16; 4usize],
                pub suggestion_string: [u16; 11usize],
                pub sum_string: [u16; 4usize],
                pub sup_string: [u16; 4usize],
                pub summary_string: [u16; 8usize],
                pub sw_string: [u16; 3usize],
                pub systemProperty_string: [u16; 16usize],
                pub tab_string: [u16; 4usize],
                pub tabindex_string: [u16; 9usize],
                pub table_string: [u16; 6usize],
                pub tabpanel_string: [u16; 9usize],
                pub tabpanels_string: [u16; 10usize],
                pub tag_string: [u16; 4usize],
                pub target_string: [u16; 7usize],
                pub targets_string: [u16; 8usize],
                pub tbody_string: [u16; 6usize],
                pub td_string: [u16; 3usize],
                pub tel_string: [u16; 4usize],
                pub _template_string: [u16; 9usize],
                pub text_decoration_string: [u16; 16usize],
                pub terminate_string: [u16; 10usize],
                pub term_string: [u16; 5usize],
                pub test_string: [u16; 5usize],
                pub text_string: [u16; 5usize],
                pub textAlign_string: [u16; 11usize],
                pub textarea_string: [u16; 9usize],
                pub textbox_string: [u16; 8usize],
                pub textContent_string: [u16; 12usize],
                pub textLink_string: [u16; 10usize],
                pub textOverlay_string: [u16; 13usize],
                pub tfoot_string: [u16; 6usize],
                pub th_string: [u16; 3usize],
                pub thead_string: [u16; 6usize],
                pub thumb_string: [u16; 6usize],
                pub time_string: [u16; 5usize],
                pub title_string: [u16; 6usize],
                pub titletip_string: [u16; 9usize],
                pub toggle_string: [u16; 7usize],
                pub toggle_popover_string: [u16; 15usize],
                pub token_string: [u16; 6usize],
                pub tokenize_string: [u16; 9usize],
                pub toolbar_string: [u16; 8usize],
                pub toolbarbutton_string: [u16; 14usize],
                pub toolbaritem_string: [u16; 12usize],
                pub toolbarpaletteitem_string: [u16; 19usize],
                pub toolbox_string: [u16; 8usize],
                pub tooltip_string: [u16; 8usize],
                pub tooltiptext_string: [u16; 12usize],
                pub top_string: [u16; 4usize],
                pub topleft_string: [u16; 8usize],
                pub topmargin_string: [u16; 10usize],
                pub topright_string: [u16; 9usize],
                pub tr_string: [u16; 3usize],
                pub track_string: [u16; 6usize],
                pub trad_chinese_formal_string: [u16; 20usize],
                pub trad_chinese_informal_string: [u16; 22usize],
                pub trailing_string: [u16; 9usize],
                pub transform_string: [u16; 10usize],
                pub transform_3d_string: [u16; 13usize],
                pub transformiix_string: [u16; 13usize],
                pub translate_string: [u16; 10usize],
                pub transparent_string: [u16; 12usize],
                pub tree_string: [u16; 5usize],
                pub treecell_string: [u16; 9usize],
                pub treechildren_string: [u16; 13usize],
                pub treecol_string: [u16; 8usize],
                pub treecolpicker_string: [u16; 14usize],
                pub treecols_string: [u16; 9usize],
                pub treeitem_string: [u16; 9usize],
                pub treerow_string: [u16; 8usize],
                pub treeseparator_string: [u16; 14usize],
                pub _true_string: [u16; 5usize],
                pub truespeed_string: [u16; 10usize],
                pub tt_string: [u16; 3usize],
                pub type_string: [u16; 5usize],
                pub u_string: [u16; 2usize],
                pub ul_string: [u16; 3usize],
                pub unparsedEntityUri_string: [u16; 20usize],
                pub untilFound_string: [u16; 12usize],
                pub up_string: [u16; 3usize],
                pub update_string: [u16; 7usize],
                pub upperFirst_string: [u16; 12usize],
                pub use_string: [u16; 4usize],
                pub useAttributeSets_string: [u16; 19usize],
                pub usemap_string: [u16; 7usize],
                pub user_scalable_string: [u16; 14usize],
                pub validate_string: [u16; 9usize],
                pub valign_string: [u16; 7usize],
                pub value_string: [u16; 6usize],
                pub values_string: [u16; 7usize],
                pub valueOf_string: [u16; 9usize],
                pub valuetype_string: [u16; 10usize],
                pub var_string: [u16; 4usize],
                pub variable_string: [u16; 9usize],
                pub vendor_string: [u16; 7usize],
                pub vendorUrl_string: [u16; 11usize],
                pub version_string: [u16; 8usize],
                pub vertical_string: [u16; 9usize],
                pub audio_string: [u16; 6usize],
                pub video_string: [u16; 6usize],
                pub viewport_string: [u16; 9usize],
                pub viewport_fit_string: [u16; 13usize],
                pub viewport_height_string: [u16; 16usize],
                pub viewport_initial_scale_string: [u16; 23usize],
                pub viewport_maximum_scale_string: [u16; 23usize],
                pub viewport_minimum_scale_string: [u16; 23usize],
                pub viewport_user_scalable_string: [u16; 23usize],
                pub viewport_width_string: [u16; 15usize],
                pub visibility_string: [u16; 11usize],
                pub visuallyselected_string: [u16; 17usize],
                pub vlink_string: [u16; 6usize],
                pub _void_string: [u16; 5usize],
                pub vsides_string: [u16; 7usize],
                pub vspace_string: [u16; 7usize],
                pub w_string: [u16; 2usize],
                pub wbr_string: [u16; 4usize],
                pub webkitdirectory_string: [u16; 16usize],
                pub when_string: [u16; 5usize],
                pub white_string: [u16; 6usize],
                pub width_string: [u16; 6usize],
                pub willChange_string: [u16; 12usize],
                pub window_string: [u16; 7usize],
                pub headerWindowTarget_string: [u16; 14usize],
                pub windowtype_string: [u16; 11usize],
                pub withParam_string: [u16; 11usize],
                pub wrap_string: [u16; 5usize],
                pub headerDNSPrefetchControl_string: [u16; 23usize],
                pub headerCSP_string: [u16; 24usize],
                pub headerCSPReportOnly_string: [u16; 36usize],
                pub headerXFO_string: [u16; 16usize],
                pub x_western_string: [u16; 10usize],
                pub xml_string: [u16; 4usize],
                pub xml_stylesheet_string: [u16; 15usize],
                pub xmlns_string: [u16; 6usize],
                pub xmp_string: [u16; 4usize],
                pub xul_string: [u16; 4usize],
                pub yes_string: [u16; 4usize],
                pub z_index_string: [u16; 8usize],
                pub zeroDigit_string: [u16; 11usize],
                pub zlevel_string: [u16; 7usize],
                pub percentage_string: [u16; 2usize],
                pub A_string: [u16; 2usize],
                pub alignment_baseline_string: [u16; 19usize],
                pub amplitude_string: [u16; 10usize],
                pub animate_string: [u16; 8usize],
                pub animateColor_string: [u16; 13usize],
                pub animateMotion_string: [u16; 14usize],
                pub animateTransform_string: [u16; 17usize],
                pub arithmetic_string: [u16; 11usize],
                pub atop_string: [u16; 5usize],
                pub azimuth_string: [u16; 8usize],
                pub B_string: [u16; 2usize],
                pub background_color_string: [u16; 17usize],
                pub background_image_string: [u16; 17usize],
                pub baseFrequency_string: [u16; 14usize],
                pub baseline_shift_string: [u16; 15usize],
                pub bias_string: [u16; 5usize],
                pub caption_side_string: [u16; 13usize],
                pub clip_path_string: [u16; 10usize],
                pub clip_rule_string: [u16; 10usize],
                pub clipPath_string: [u16; 9usize],
                pub clipPathUnits_string: [u16; 14usize],
                pub cm_string: [u16; 3usize],
                pub color_burn_string: [u16; 11usize],
                pub color_dodge_string: [u16; 12usize],
                pub color_interpolation_string: [u16; 20usize],
                pub color_interpolation_filters_string: [u16; 28usize],
                pub color_profile_string: [u16; 14usize],
                pub cursor_string: [u16; 7usize],
                pub cx_string: [u16; 3usize],
                pub cy_string: [u16; 3usize],
                pub d_string: [u16; 2usize],
                pub darken_string: [u16; 7usize],
                pub defs_string: [u16; 5usize],
                pub deg_string: [u16; 4usize],
                pub desc_string: [u16; 5usize],
                pub diffuseConstant_string: [u16; 16usize],
                pub dilate_string: [u16; 7usize],
                pub direction_string: [u16; 10usize],
                pub disable_string: [u16; 8usize],
                pub disc_string: [u16; 5usize],
                pub discrete_string: [u16; 9usize],
                pub divisor_string: [u16; 8usize],
                pub dominant_baseline_string: [u16; 18usize],
                pub duplicate_string: [u16; 10usize],
                pub dx_string: [u16; 3usize],
                pub dy_string: [u16; 3usize],
                pub edgeMode_string: [u16; 9usize],
                pub ellipse_string: [u16; 8usize],
                pub elevation_string: [u16; 10usize],
                pub erode_string: [u16; 6usize],
                pub ex_string: [u16; 3usize],
                pub exact_string: [u16; 6usize],
                pub exclusion_string: [u16; 10usize],
                pub exponent_string: [u16; 9usize],
                pub feBlend_string: [u16; 8usize],
                pub feColorMatrix_string: [u16; 14usize],
                pub feComponentTransfer_string: [u16; 20usize],
                pub feComposite_string: [u16; 12usize],
                pub feConvolveMatrix_string: [u16; 17usize],
                pub feDiffuseLighting_string: [u16; 18usize],
                pub feDisplacementMap_string: [u16; 18usize],
                pub feDistantLight_string: [u16; 15usize],
                pub feDropShadow_string: [u16; 13usize],
                pub feFlood_string: [u16; 8usize],
                pub feFuncA_string: [u16; 8usize],
                pub feFuncB_string: [u16; 8usize],
                pub feFuncG_string: [u16; 8usize],
                pub feFuncR_string: [u16; 8usize],
                pub feGaussianBlur_string: [u16; 15usize],
                pub feImage_string: [u16; 8usize],
                pub feMerge_string: [u16; 8usize],
                pub feMergeNode_string: [u16; 12usize],
                pub feMorphology_string: [u16; 13usize],
                pub feOffset_string: [u16; 9usize],
                pub fePointLight_string: [u16; 13usize],
                pub feSpecularLighting_string: [u16; 19usize],
                pub feSpotLight_string: [u16; 12usize],
                pub feTile_string: [u16; 7usize],
                pub feTurbulence_string: [u16; 13usize],
                pub fill_string: [u16; 5usize],
                pub fill_opacity_string: [u16; 13usize],
                pub fill_rule_string: [u16; 10usize],
                pub filter_string: [u16; 7usize],
                pub filterUnits_string: [u16; 12usize],
                pub _float_string: [u16; 6usize],
                pub flood_color_string: [u16; 12usize],
                pub flood_opacity_string: [u16; 14usize],
                pub font_face_string: [u16; 10usize],
                pub font_face_format_string: [u16; 17usize],
                pub font_face_name_string: [u16; 15usize],
                pub font_face_src_string: [u16; 14usize],
                pub font_face_uri_string: [u16; 14usize],
                pub font_family_string: [u16; 12usize],
                pub font_size_string: [u16; 10usize],
                pub font_size_adjust_string: [u16; 17usize],
                pub font_stretch_string: [u16; 13usize],
                pub font_style_string: [u16; 11usize],
                pub font_variant_string: [u16; 13usize],
                pub font_weight_string: [u16; 12usize],
                pub formatting_string: [u16; 11usize],
                pub foreignObject_string: [u16; 14usize],
                pub fractalNoise_string: [u16; 13usize],
                pub fr_string: [u16; 3usize],
                pub fx_string: [u16; 3usize],
                pub fy_string: [u16; 3usize],
                pub G_string: [u16; 2usize],
                pub g_string: [u16; 2usize],
                pub gamma_string: [u16; 6usize],
                pub glyphRef_string: [u16; 9usize],
                pub grad_string: [u16; 5usize],
                pub gradientTransform_string: [u16; 18usize],
                pub gradientUnits_string: [u16; 14usize],
                pub hardLight_string: [u16; 11usize],
                pub hue_string: [u16; 4usize],
                pub hueRotate_string: [u16; 10usize],
                pub identity_string: [u16; 9usize],
                pub image_rendering_string: [u16; 16usize],
                pub in_string: [u16; 3usize],
                pub in2_string: [u16; 4usize],
                pub intercept_string: [u16; 10usize],
                pub k1_string: [u16; 3usize],
                pub k2_string: [u16; 3usize],
                pub k3_string: [u16; 3usize],
                pub k4_string: [u16; 3usize],
                pub kernelMatrix_string: [u16; 13usize],
                pub kernelUnitLength_string: [u16; 17usize],
                pub lengthAdjust_string: [u16; 13usize],
                pub letter_spacing_string: [u16; 15usize],
                pub lighten_string: [u16; 8usize],
                pub lighter_string: [u16; 8usize],
                pub lighting_color_string: [u16; 15usize],
                pub limitingConeAngle_string: [u16; 18usize],
                pub linear_string: [u16; 7usize],
                pub linearGradient_string: [u16; 15usize],
                pub list_item_string: [u16; 10usize],
                pub list_style_type_string: [u16; 16usize],
                pub luminanceToAlpha_string: [u16; 17usize],
                pub luminosity_string: [u16; 11usize],
                pub magnify_string: [u16; 8usize],
                pub marker_string: [u16; 7usize],
                pub marker_end_string: [u16; 11usize],
                pub marker_mid_string: [u16; 11usize],
                pub marker_start_string: [u16; 13usize],
                pub markerHeight_string: [u16; 13usize],
                pub markerUnits_string: [u16; 12usize],
                pub markerWidth_string: [u16; 12usize],
                pub mask_string: [u16; 5usize],
                pub maskContentUnits_string: [u16; 17usize],
                pub mask_type_string: [u16; 10usize],
                pub maskUnits_string: [u16; 10usize],
                pub matrix_string: [u16; 7usize],
                pub metadata_string: [u16; 9usize],
                pub missingGlyph_string: [u16; 14usize],
                pub mm_string: [u16; 3usize],
                pub mpath_string: [u16; 6usize],
                pub noStitch_string: [u16; 9usize],
                pub numOctaves_string: [u16; 11usize],
                pub multiply_string: [u16; 9usize],
                pub objectBoundingBox_string: [u16; 18usize],
                pub offset_string: [u16; 7usize],
                pub onSVGLoad_string: [u16; 10usize],
                pub onSVGScroll_string: [u16; 12usize],
                pub onzoom_string: [u16; 7usize],
                pub opacity_string: [u16; 8usize],
                pub _operator_string: [u16; 9usize],
                pub out_string: [u16; 4usize],
                pub over_string: [u16; 5usize],
                pub overridePreserveAspectRatio_string: [u16; 28usize],
                pub pad_string: [u16; 4usize],
                pub path_string: [u16; 5usize],
                pub pathLength_string: [u16; 11usize],
                pub patternContentUnits_string: [u16; 20usize],
                pub patternTransform_string: [u16; 17usize],
                pub patternUnits_string: [u16; 13usize],
                pub pc_string: [u16; 3usize],
                pub pointer_string: [u16; 8usize],
                pub pointer_events_string: [u16; 15usize],
                pub points_string: [u16; 7usize],
                pub pointsAtX_string: [u16; 10usize],
                pub pointsAtY_string: [u16; 10usize],
                pub pointsAtZ_string: [u16; 10usize],
                pub polyline_string: [u16; 9usize],
                pub preserveAlpha_string: [u16; 14usize],
                pub preserveAspectRatio_string: [u16; 20usize],
                pub primitiveUnits_string: [u16; 15usize],
                pub pt_string: [u16; 3usize],
                pub px_string: [u16; 3usize],
                pub R_string: [u16; 2usize],
                pub r_string: [u16; 2usize],
                pub rad_string: [u16; 4usize],
                pub radialGradient_string: [u16; 15usize],
                pub radius_string: [u16; 7usize],
                pub reflect_string: [u16; 8usize],
                pub refX_string: [u16; 5usize],
                pub refY_string: [u16; 5usize],
                pub requiredExtensions_string: [u16; 19usize],
                pub requiredFeatures_string: [u16; 17usize],
                pub rotate_string: [u16; 7usize],
                pub rx_string: [u16; 3usize],
                pub ry_string: [u16; 3usize],
                pub saturate_string: [u16; 9usize],
                pub saturation_string: [u16; 11usize],
                pub set_string: [u16; 4usize],
                pub seed_string: [u16; 5usize],
                pub shape_rendering_string: [u16; 16usize],
                pub simpleScopeChain_string: [u16; 17usize],
                pub skewX_string: [u16; 6usize],
                pub skewY_string: [u16; 6usize],
                pub slope_string: [u16; 6usize],
                pub slot_string: [u16; 5usize],
                pub softLight_string: [u16; 11usize],
                pub spacing_string: [u16; 8usize],
                pub spacingAndGlyphs_string: [u16; 17usize],
                pub specularConstant_string: [u16; 17usize],
                pub specularExponent_string: [u16; 17usize],
                pub spreadMethod_string: [u16; 13usize],
                pub startOffset_string: [u16; 12usize],
                pub stdDeviation_string: [u16; 13usize],
                pub stitch_string: [u16; 7usize],
                pub stitchTiles_string: [u16; 12usize],
                pub stop_color_string: [u16; 11usize],
                pub stop_opacity_string: [u16; 13usize],
                pub stroke_string: [u16; 7usize],
                pub stroke_dasharray_string: [u16; 17usize],
                pub stroke_dashoffset_string: [u16; 18usize],
                pub stroke_linecap_string: [u16; 15usize],
                pub stroke_linejoin_string: [u16; 16usize],
                pub stroke_miterlimit_string: [u16; 18usize],
                pub stroke_opacity_string: [u16; 15usize],
                pub stroke_width_string: [u16; 13usize],
                pub strokeWidth_string: [u16; 12usize],
                pub surfaceScale_string: [u16; 13usize],
                pub svg_string: [u16; 4usize],
                pub svgSwitch_string: [u16; 7usize],
                pub symbol_string: [u16; 7usize],
                pub systemLanguage_string: [u16; 15usize],
                pub tableValues_string: [u16; 12usize],
                pub targetX_string: [u16; 8usize],
                pub targetY_string: [u16; 8usize],
                pub text_anchor_string: [u16; 12usize],
                pub text_overflow_string: [u16; 14usize],
                pub text_rendering_string: [u16; 15usize],
                pub textLength_string: [u16; 11usize],
                pub textPath_string: [u16; 9usize],
                pub transform_origin_string: [u16; 17usize],
                pub tref_string: [u16; 5usize],
                pub tspan_string: [u16; 6usize],
                pub turbulence_string: [u16; 11usize],
                pub unicode_bidi_string: [u16; 13usize],
                pub userSpaceOnUse_string: [u16; 15usize],
                pub view_string: [u16; 5usize],
                pub viewBox_string: [u16; 8usize],
                pub viewTarget_string: [u16; 11usize],
                pub white_space_string: [u16; 12usize],
                pub windowsmica_string: [u16; 12usize],
                pub word_spacing_string: [u16; 13usize],
                pub writing_mode_string: [u16; 13usize],
                pub x_string: [u16; 2usize],
                pub x1_string: [u16; 3usize],
                pub x2_string: [u16; 3usize],
                pub xChannelSelector_string: [u16; 17usize],
                pub xor__string: [u16; 4usize],
                pub y_string: [u16; 2usize],
                pub y1_string: [u16; 3usize],
                pub y2_string: [u16; 3usize],
                pub yChannelSelector_string: [u16; 17usize],
                pub z_string: [u16; 2usize],
                pub zoomAndPan_string: [u16; 11usize],
                pub vector_effect_string: [u16; 14usize],
                pub vertical_align_string: [u16; 15usize],
                pub accumulate_string: [u16; 11usize],
                pub additive_string: [u16; 9usize],
                pub attributeName_string: [u16; 14usize],
                pub attributeType_string: [u16; 14usize],
                pub auto_reverse_string: [u16; 13usize],
                pub begin_string: [u16; 6usize],
                pub beginEvent_string: [u16; 11usize],
                pub by_string: [u16; 3usize],
                pub calcMode_string: [u16; 9usize],
                pub dur_string: [u16; 4usize],
                pub keyPoints_string: [u16; 10usize],
                pub keySplines_string: [u16; 11usize],
                pub keyTimes_string: [u16; 9usize],
                pub mozAnimateMotionDummyAttr_string: [u16; 27usize],
                pub onbegin_string: [u16; 8usize],
                pub onbeginEvent_string: [u16; 13usize],
                pub onend_string: [u16; 6usize],
                pub onendEvent_string: [u16; 11usize],
                pub onrelease_string: [u16; 10usize],
                pub onrepeat_string: [u16; 9usize],
                pub onrepeatEvent_string: [u16; 14usize],
                pub repeatCount_string: [u16; 12usize],
                pub repeatDur_string: [u16; 10usize],
                pub repeatEvent_string: [u16; 12usize],
                pub restart_string: [u16; 8usize],
                pub to_string: [u16; 3usize],
                pub abs_string: [u16; 4usize],
                pub accent_string: [u16; 7usize],
                pub accentunder_string: [u16; 12usize],
                pub actiontype_string: [u16; 11usize],
                pub alignmentscope_string: [u16; 15usize],
                pub altimg_string: [u16; 7usize],
                pub altimg_height_string: [u16; 14usize],
                pub altimg_valign_string: [u16; 14usize],
                pub altimg_width_string: [u16; 13usize],
                pub annotation_string: [u16; 11usize],
                pub annotation_xml_string: [u16; 15usize],
                pub apply_string: [u16; 6usize],
                pub approx_string: [u16; 7usize],
                pub arccos_string: [u16; 7usize],
                pub arccosh_string: [u16; 8usize],
                pub arccot_string: [u16; 7usize],
                pub arccoth_string: [u16; 8usize],
                pub arccsc_string: [u16; 7usize],
                pub arccsch_string: [u16; 8usize],
                pub arcsec_string: [u16; 7usize],
                pub arcsech_string: [u16; 8usize],
                pub arcsin_string: [u16; 7usize],
                pub arcsinh_string: [u16; 8usize],
                pub arctan_string: [u16; 7usize],
                pub arctanh_string: [u16; 8usize],
                pub arg_string: [u16; 4usize],
                pub bevelled_string: [u16; 9usize],
                pub bind_string: [u16; 5usize],
                pub bvar_string: [u16; 5usize],
                pub card_string: [u16; 5usize],
                pub cartesianproduct_string: [u16; 17usize],
                pub cbytes_string: [u16; 7usize],
                pub cd_string: [u16; 3usize],
                pub cdgroup_string: [u16; 8usize],
                pub cerror_string: [u16; 7usize],
                pub charalign_string: [u16; 10usize],
                pub ci_string: [u16; 3usize],
                pub closure_string: [u16; 8usize],
                pub cn_string: [u16; 3usize],
                pub codomain_string: [u16; 9usize],
                pub columnalign_string: [u16; 12usize],
                pub columnalignment_string: [u16; 16usize],
                pub columnlines_string: [u16; 12usize],
                pub columnspacing_string: [u16; 14usize],
                pub columnspan_string: [u16; 11usize],
                pub columnwidth_string: [u16; 12usize],
                pub complexes_string: [u16; 10usize],
                pub compose_string: [u16; 8usize],
                pub condition_string: [u16; 10usize],
                pub conjugate_string: [u16; 10usize],
                pub cos_string: [u16; 4usize],
                pub cosh_string: [u16; 5usize],
                pub cot_string: [u16; 4usize],
                pub coth_string: [u16; 5usize],
                pub crossout_string: [u16; 9usize],
                pub csc_string: [u16; 4usize],
                pub csch_string: [u16; 5usize],
                pub cs_string: [u16; 3usize],
                pub csymbol_string: [u16; 8usize],
                pub csp_string: [u16; 4usize],
                pub cspViolation_string: [u16; 14usize],
                pub curl_string: [u16; 5usize],
                pub decimalpoint_string: [u16; 13usize],
                pub definition_string: [u16; 11usize],
                pub definitionURL_string: [u16; 14usize],
                pub degree_string: [u16; 7usize],
                pub denomalign_string: [u16; 11usize],
                pub depth_string: [u16; 6usize],
                pub determinant_string: [u16; 12usize],
                pub diff_string: [u16; 5usize],
                pub displaystyle_string: [u16; 13usize],
                pub divergence_string: [u16; 11usize],
                pub divide_string: [u16; 7usize],
                pub dom_viewTransitions_enabled_string: [u16; 28usize],
                pub domain_string: [u16; 7usize],
                pub domainofapplication_string: [u16; 20usize],
                pub edge_string: [u16; 5usize],
                pub el_string: [u16; 3usize],
                pub emptyset_string: [u16; 9usize],
                pub eq_string: [u16; 3usize],
                pub equalcolumns_string: [u16; 13usize],
                pub equalrows_string: [u16; 10usize],
                pub equivalent_string: [u16; 11usize],
                pub eulergamma_string: [u16; 11usize],
                pub exists_string: [u16; 7usize],
                pub exp_string: [u16; 4usize],
                pub exponentiale_string: [u16; 13usize],
                pub factorial_string: [u16; 10usize],
                pub factorof_string: [u16; 9usize],
                pub fence_string: [u16; 6usize],
                pub fn_string: [u16; 3usize],
                pub fontfamily_string: [u16; 11usize],
                pub fontsize_string: [u16; 9usize],
                pub fontstyle_string: [u16; 10usize],
                pub fontweight_string: [u16; 11usize],
                pub forall_string: [u16; 7usize],
                pub framespacing_string: [u16; 13usize],
                pub gcd_string: [u16; 4usize],
                pub geq_string: [u16; 4usize],
                pub groupalign_string: [u16; 11usize],
                pub gt_string: [u16; 3usize],
                pub ident_string: [u16; 6usize],
                pub imaginaryi_string: [u16; 11usize],
                pub imaginary_string: [u16; 10usize],
                pub implies_string: [u16; 8usize],
                pub indentalignfirst_string: [u16; 17usize],
                pub indentalign_string: [u16; 12usize],
                pub indentalignlast_string: [u16; 16usize],
                pub indentshiftfirst_string: [u16; 17usize],
                pub indentshift_string: [u16; 12usize],
                pub indenttarget_string: [u16; 13usize],
                pub integers_string: [u16; 9usize],
                pub intersect_string: [u16; 10usize],
                pub interval_string: [u16; 9usize],
                pub int__string: [u16; 4usize],
                pub inverse_string: [u16; 8usize],
                pub lambda_string: [u16; 7usize],
                pub laplacian_string: [u16; 10usize],
                pub largeop_string: [u16; 8usize],
                pub lcm_string: [u16; 4usize],
                pub leq_string: [u16; 4usize],
                pub limit_string: [u16; 6usize],
                pub linebreak_string: [u16; 10usize],
                pub linebreakmultchar_string: [u16; 18usize],
                pub linebreakstyle_string: [u16; 15usize],
                pub linethickness_string: [u16; 14usize],
                pub list_string: [u16; 5usize],
                pub ln_string: [u16; 3usize],
                pub location_string: [u16; 9usize],
                pub logbase_string: [u16; 8usize],
                pub log_string: [u16; 4usize],
                pub longdivstyle_string: [u16; 13usize],
                pub lowlimit_string: [u16; 9usize],
                pub lquote_string: [u16; 7usize],
                pub lspace_string: [u16; 7usize],
                pub lt_string: [u16; 3usize],
                pub maction_string: [u16; 8usize],
                pub maligngroup_string: [u16; 12usize],
                pub malignmark_string: [u16; 11usize],
                pub mathbackground_string: [u16; 15usize],
                pub mathcolor_string: [u16; 10usize],
                pub mathsize_string: [u16; 9usize],
                pub mathvariant_string: [u16; 12usize],
                pub matrixrow_string: [u16; 10usize],
                pub maxsize_string: [u16; 8usize],
                pub mean_string: [u16; 5usize],
                pub median_string: [u16; 7usize],
                pub menclose_string: [u16; 9usize],
                pub merror_string: [u16; 7usize],
                pub mfenced_string: [u16; 8usize],
                pub mfrac_string: [u16; 6usize],
                pub mglyph_string: [u16; 7usize],
                pub mi_string: [u16; 3usize],
                pub minlabelspacing_string: [u16; 16usize],
                pub minsize_string: [u16; 8usize],
                pub minus_string: [u16; 6usize],
                pub mlabeledtr_string: [u16; 11usize],
                pub mlongdiv_string: [u16; 9usize],
                pub mmultiscripts_string: [u16; 14usize],
                pub mn_string: [u16; 3usize],
                pub momentabout_string: [u16; 12usize],
                pub moment_string: [u16; 7usize],
                pub mo_string: [u16; 3usize],
                pub movablelimits_string: [u16; 14usize],
                pub mover_string: [u16; 6usize],
                pub mpadded_string: [u16; 8usize],
                pub mphantom_string: [u16; 9usize],
                pub mprescripts_string: [u16; 12usize],
                pub mroot_string: [u16; 6usize],
                pub mrow_string: [u16; 5usize],
                pub mscarries_string: [u16; 10usize],
                pub mscarry_string: [u16; 8usize],
                pub msgroup_string: [u16; 8usize],
                pub msline_string: [u16; 7usize],
                pub ms_string: [u16; 3usize],
                pub mspace_string: [u16; 7usize],
                pub msqrt_string: [u16; 6usize],
                pub msrow_string: [u16; 6usize],
                pub mstack_string: [u16; 7usize],
                pub mstyle_string: [u16; 7usize],
                pub msub_string: [u16; 5usize],
                pub msubsup_string: [u16; 8usize],
                pub msup_string: [u16; 5usize],
                pub mtable_string: [u16; 7usize],
                pub mtd_string: [u16; 4usize],
                pub mtext_string: [u16; 6usize],
                pub mtr_string: [u16; 4usize],
                pub munder_string: [u16; 7usize],
                pub munderover_string: [u16; 11usize],
                pub naturalnumbers_string: [u16; 15usize],
                pub neq_string: [u16; 4usize],
                pub notanumber_string: [u16; 11usize],
                pub notation_string: [u16; 9usize],
                pub note_string: [u16; 5usize],
                pub notin_string: [u16; 6usize],
                pub notprsubset_string: [u16; 12usize],
                pub notsubset_string: [u16; 10usize],
                pub numalign_string: [u16; 9usize],
                pub other_string: [u16; 6usize],
                pub outerproduct_string: [u16; 13usize],
                pub partialdiff_string: [u16; 12usize],
                pub piece_string: [u16; 6usize],
                pub piecewise_string: [u16; 10usize],
                pub pi_string: [u16; 3usize],
                pub plus_string: [u16; 5usize],
                pub power_string: [u16; 6usize],
                pub primes_string: [u16; 7usize],
                pub product_string: [u16; 8usize],
                pub prsubset_string: [u16; 9usize],
                pub quotient_string: [u16; 9usize],
                pub rationals_string: [u16; 10usize],
                pub real_string: [u16; 5usize],
                pub reals_string: [u16; 6usize],
                pub reln_string: [u16; 5usize],
                pub root_string: [u16; 5usize],
                pub rowalign_string: [u16; 9usize],
                pub rowlines_string: [u16; 9usize],
                pub rowspacing_string: [u16; 11usize],
                pub rquote_string: [u16; 7usize],
                pub rspace_string: [u16; 7usize],
                pub scalarproduct_string: [u16; 14usize],
                pub schemaLocation_string: [u16; 15usize],
                pub scriptlevel_string: [u16; 12usize],
                pub scriptminsize_string: [u16; 14usize],
                pub scriptsizemultiplier_string: [u16; 21usize],
                pub scriptsize_string: [u16; 11usize],
                pub sdev_string: [u16; 5usize],
                pub sech_string: [u16; 5usize],
                pub sec_string: [u16; 4usize],
                pub selection_string: [u16; 10usize],
                pub selector_string: [u16; 9usize],
                pub semantics_string: [u16; 10usize],
                pub separator_string: [u16; 10usize],
                pub separators_string: [u16; 11usize],
                pub sep_string: [u16; 4usize],
                pub setdiff_string: [u16; 8usize],
                pub share_string: [u16; 6usize],
                pub shift_string: [u16; 6usize],
                pub side_string: [u16; 5usize],
                pub sinh_string: [u16; 5usize],
                pub sin_string: [u16; 4usize],
                pub stackalign_string: [u16; 11usize],
                pub stretchy_string: [u16; 9usize],
                pub subscriptshift_string: [u16; 15usize],
                pub subset_string: [u16; 7usize],
                pub superscriptshift_string: [u16; 17usize],
                pub symmetric_string: [u16; 10usize],
                pub tanh_string: [u16; 5usize],
                pub tan_string: [u16; 4usize],
                pub tendsto_string: [u16; 8usize],
                pub times_string: [u16; 6usize],
                pub transpose_string: [u16; 10usize],
                pub union__string: [u16; 6usize],
                pub uplimit_string: [u16; 8usize],
                pub variance_string: [u16; 9usize],
                pub vectorproduct_string: [u16; 14usize],
                pub vector_string: [u16; 7usize],
                pub voffset_string: [u16; 8usize],
                pub xref_string: [u16; 5usize],
                pub math_string: [u16; 5usize],
                pub booleanFromString_string: [u16; 20usize],
                pub countNonEmpty_string: [u16; 16usize],
                pub daysFromDate_string: [u16; 15usize],
                pub secondsFromDateTime_string: [u16; 22usize],
                pub tabbrowser_arrowscrollbox_string: [u16; 26usize],
                pub onMozSwipeGestureMayStart_string: [u16; 26usize],
                pub onMozSwipeGestureStart_string: [u16; 23usize],
                pub onMozSwipeGestureUpdate_string: [u16; 24usize],
                pub onMozSwipeGestureEnd_string: [u16; 21usize],
                pub onMozSwipeGesture_string: [u16; 18usize],
                pub onMozMagnifyGestureStart_string: [u16; 25usize],
                pub onMozMagnifyGestureUpdate_string: [u16; 26usize],
                pub onMozMagnifyGesture_string: [u16; 20usize],
                pub onMozRotateGestureStart_string: [u16; 24usize],
                pub onMozRotateGestureUpdate_string: [u16; 25usize],
                pub onMozRotateGesture_string: [u16; 19usize],
                pub onMozTapGesture_string: [u16; 16usize],
                pub onMozPressTapGesture_string: [u16; 21usize],
                pub onMozEdgeUIStarted_string: [u16; 19usize],
                pub onMozEdgeUICanceled_string: [u16; 20usize],
                pub onMozEdgeUICompleted_string: [u16; 21usize],
                pub onpointerdown_string: [u16; 14usize],
                pub onpointermove_string: [u16; 14usize],
                pub onpointerup_string: [u16; 12usize],
                pub onpointercancel_string: [u16; 16usize],
                pub onpointerover_string: [u16; 14usize],
                pub onpointerout_string: [u16; 13usize],
                pub onpointerenter_string: [u16; 15usize],
                pub onpointerleave_string: [u16; 15usize],
                pub onpointerrawupdate_string: [u16; 19usize],
                pub ongotpointercapture_string: [u16; 20usize],
                pub onlostpointercapture_string: [u16; 21usize],
                pub ondevicemotion_string: [u16; 15usize],
                pub ondeviceorientation_string: [u16; 20usize],
                pub ondeviceorientationabsolute_string: [u16; 28usize],
                pub onmozorientationchange_string: [u16; 23usize],
                pub onuserproximity_string: [u16; 16usize],
                pub ondevicelight_string: [u16; 14usize],
                pub ondevicechange_string: [u16; 15usize],
                pub onrtctransform_string: [u16; 15usize],
                pub onmozvisualresize_string: [u16; 18usize],
                pub onmozvisualscroll_string: [u16; 18usize],
                pub onDOMContentLoaded_string: [u16; 19usize],
                pub onDOMDocElementInserted_string: [u16; 24usize],
                pub onDOMFormBeforeSubmit_string: [u16; 22usize],
                pub onDOMFormHasPassword_string: [u16; 21usize],
                pub onDOMFrameContentLoaded_string: [u16; 24usize],
                pub onDOMHeadElementParsed_string: [u16; 23usize],
                pub onDOMInputPasswordAdded_string: [u16; 24usize],
                pub onDOMLinkAdded_string: [u16; 15usize],
                pub onDOMLinkChanged_string: [u16; 17usize],
                pub onDOMMetaAdded_string: [u16; 15usize],
                pub onDOMMetaChanged_string: [u16; 17usize],
                pub onDOMMetaRemoved_string: [u16; 17usize],
                pub onDOMPopupBlocked_string: [u16; 18usize],
                pub onDOMTitleChanged_string: [u16; 18usize],
                pub onDOMWindowClose_string: [u16; 17usize],
                pub onDOMWindowCreated_string: [u16; 19usize],
                pub onDOMWindowFocus_string: [u16; 17usize],
                pub onFullZoomChange_string: [u16; 17usize],
                pub onGloballyAutoplayBlocked_string: [u16; 26usize],
                pub onMozDOMFullscreen_Entered_string: [u16; 27usize],
                pub onMozDOMFullscreen_Exit_string: [u16; 24usize],
                pub onMozDOMFullscreen_Exited_string: [u16; 26usize],
                pub onMozDOMFullscreen_NewOrigin_string: [u16; 29usize],
                pub onMozDOMFullscreen_Request_string: [u16; 27usize],
                pub onMozDOMPointerLock_Entered_string: [u16; 28usize],
                pub onMozDOMPointerLock_Exited_string: [u16; 27usize],
                pub onMozInvalidForm_string: [u16; 17usize],
                pub onMozLocalStorageChanged_string: [u16; 25usize],
                pub onMozOpenDateTimePicker_string: [u16; 24usize],
                pub onMozSessionStorageChanged_string: [u16; 27usize],
                pub onMozTogglePictureInPicture_string: [u16; 28usize],
                pub onPluginCrashed_string: [u16; 16usize],
                pub onPrintingError_string: [u16; 16usize],
                pub onTextZoomChange_string: [u16; 17usize],
                pub onUAWidgetSetupOrChange_string: [u16; 24usize],
                pub onUAWidgetTeardown_string: [u16; 19usize],
                pub onUnselectedTabHover_Disable_string: [u16; 29usize],
                pub onUnselectedTabHover_Enable_string: [u16; 28usize],
                pub onmozshowdropdown_string: [u16; 18usize],
                pub onmozshowdropdown_sourcetouch_string: [u16; 30usize],
                pub onprintPreviewUpdate_string: [u16; 21usize],
                pub onscrollend_string: [u16; 12usize],
                pub onbeforetoggle_string: [u16; 15usize],
                pub moz_extension_string: [u16; 14usize],
                pub all_urlsPermission_string: [u16; 11usize],
                pub clipboardRead_string: [u16; 14usize],
                pub clipboardWrite_string: [u16; 15usize],
                pub debugger_string: [u16; 9usize],
                pub mozillaAddons_string: [u16; 14usize],
                pub tabs_string: [u16; 5usize],
                pub webRequestBlocking_string: [u16; 19usize],
                pub webRequestFilterResponse_serviceWorkerScript_string: [u16; 45usize],
                pub blob_string: [u16; 5usize],
                pub http_string: [u16; 5usize],
                pub https_string: [u16; 6usize],
                pub view_source_string: [u16; 12usize],
                pub ws_string: [u16; 3usize],
                pub wss_string: [u16; 4usize],
                pub ftp_string: [u16; 4usize],
                pub chrome_string: [u16; 7usize],
                pub moz_string: [u16; 4usize],
                pub moz_icon_string: [u16; 9usize],
                pub moz_gio_string: [u16; 8usize],
                pub proxy_string: [u16; 6usize],
                pub privateBrowsingAllowedPermission_string: [u16; 32usize],
                pub svgContextPropertiesAllowedPermission_string: [u16; 37usize],
                pub theme_string: [u16; 6usize],
                pub userScripts_string: [u16; 12usize],
                pub decimal_leading_zero_string: [u16; 21usize],
                pub arabic_indic_string: [u16; 13usize],
                pub armenian_string: [u16; 9usize],
                pub upper_armenian_string: [u16; 15usize],
                pub lower_armenian_string: [u16; 15usize],
                pub bengali_string: [u16; 8usize],
                pub cambodian_string: [u16; 10usize],
                pub khmer_string: [u16; 6usize],
                pub cjk_decimal_string: [u16; 12usize],
                pub devanagari_string: [u16; 11usize],
                pub georgian_string: [u16; 9usize],
                pub gujarati_string: [u16; 9usize],
                pub gurmukhi_string: [u16; 9usize],
                pub kannada_string: [u16; 8usize],
                pub lao_string: [u16; 4usize],
                pub malayalam_string: [u16; 10usize],
                pub mongolian_string: [u16; 10usize],
                pub myanmar_string: [u16; 8usize],
                pub oriya_string: [u16; 6usize],
                pub persian_string: [u16; 8usize],
                pub lower_roman_string: [u16; 12usize],
                pub upper_roman_string: [u16; 12usize],
                pub tamil_string: [u16; 6usize],
                pub telugu_string: [u16; 7usize],
                pub thai_string: [u16; 5usize],
                pub tibetan_string: [u16; 8usize],
                pub lower_alpha_string: [u16; 12usize],
                pub lower_latin_string: [u16; 12usize],
                pub upper_alpha_string: [u16; 12usize],
                pub upper_latin_string: [u16; 12usize],
                pub cjk_heavenly_stem_string: [u16; 18usize],
                pub cjk_earthly_branch_string: [u16; 19usize],
                pub lower_greek_string: [u16; 12usize],
                pub hiragana_string: [u16; 9usize],
                pub hiragana_iroha_string: [u16; 15usize],
                pub katakana_string: [u16; 9usize],
                pub katakana_iroha_string: [u16; 15usize],
                pub cjk_ideographic_string: [u16; 16usize],
                pub _moz_arabic_indic_string: [u16; 18usize],
                pub _moz_persian_string: [u16; 13usize],
                pub _moz_urdu_string: [u16; 10usize],
                pub _moz_devanagari_string: [u16; 16usize],
                pub _moz_bengali_string: [u16; 13usize],
                pub _moz_gurmukhi_string: [u16; 14usize],
                pub _moz_gujarati_string: [u16; 14usize],
                pub _moz_oriya_string: [u16; 11usize],
                pub _moz_tamil_string: [u16; 11usize],
                pub _moz_telugu_string: [u16; 12usize],
                pub _moz_kannada_string: [u16; 13usize],
                pub _moz_malayalam_string: [u16; 15usize],
                pub _moz_thai_string: [u16; 10usize],
                pub _moz_lao_string: [u16; 9usize],
                pub _moz_myanmar_string: [u16; 13usize],
                pub _moz_khmer_string: [u16; 11usize],
                pub _moz_cjk_heavenly_stem_string: [u16; 23usize],
                pub _moz_cjk_earthly_branch_string: [u16; 24usize],
                pub _moz_hangul_string: [u16; 12usize],
                pub _moz_hangul_consonant_string: [u16; 22usize],
                pub _moz_ethiopic_halehame_string: [u16; 23usize],
                pub _moz_ethiopic_halehame_am_string: [u16; 26usize],
                pub _moz_ethiopic_halehame_ti_er_string: [u16; 29usize],
                pub _moz_ethiopic_halehame_ti_et_string: [u16; 29usize],
                pub _moz_trad_chinese_informal_string: [u16; 27usize],
                pub _moz_trad_chinese_formal_string: [u16; 25usize],
                pub _moz_simp_chinese_informal_string: [u16; 27usize],
                pub _moz_simp_chinese_formal_string: [u16; 25usize],
                pub _moz_japanese_informal_string: [u16; 23usize],
                pub _moz_japanese_formal_string: [u16; 21usize],
                pub _moz_ethiopic_numeric_string: [u16; 22usize],
                pub cdataTagName_string: [u16; 15usize],
                pub commentTagName_string: [u16; 9usize],
                pub documentNodeName_string: [u16; 10usize],
                pub documentFragmentNodeName_string: [u16; 19usize],
                pub documentTypeNodeName_string: [u16; 15usize],
                pub processingInstructionTagName_string: [u16; 24usize],
                pub textTagName_string: [u16; 6usize],
                pub placeholderFrame_string: [u16; 17usize],
                pub onloadend_string: [u16; 10usize],
                pub onloadstart_string: [u16; 12usize],
                pub onprogress_string: [u16; 11usize],
                pub onsuspend_string: [u16; 10usize],
                pub onemptied_string: [u16; 10usize],
                pub onstalled_string: [u16; 10usize],
                pub onplay_string: [u16; 7usize],
                pub onpause_string: [u16; 8usize],
                pub onloadedmetadata_string: [u16; 17usize],
                pub onloadeddata_string: [u16; 13usize],
                pub onwaiting_string: [u16; 10usize],
                pub onplaying_string: [u16; 10usize],
                pub oncanplay_string: [u16; 10usize],
                pub oncanplaythrough_string: [u16; 17usize],
                pub onseeking_string: [u16; 10usize],
                pub onseeked_string: [u16; 9usize],
                pub ontimeout_string: [u16; 10usize],
                pub ontimeupdate_string: [u16; 13usize],
                pub onended_string: [u16; 8usize],
                pub onformdata_string: [u16; 11usize],
                pub onratechange_string: [u16; 13usize],
                pub ondurationchange_string: [u16; 17usize],
                pub onvolumechange_string: [u16; 15usize],
                pub onaddtrack_string: [u16; 11usize],
                pub oncontrollerchange_string: [u16; 19usize],
                pub oncuechange_string: [u16; 12usize],
                pub onenter_string: [u16; 8usize],
                pub onexit_string: [u16; 7usize],
                pub onencrypted_string: [u16; 12usize],
                pub onwaitingforkey_string: [u16; 16usize],
                pub onkeystatuseschange_string: [u16; 20usize],
                pub onremovetrack_string: [u16; 14usize],
                pub loadstart_string: [u16; 10usize],
                pub suspend_string: [u16; 8usize],
                pub emptied_string: [u16; 8usize],
                pub play_string: [u16; 5usize],
                pub pause_string: [u16; 6usize],
                pub loadedmetadata_string: [u16; 15usize],
                pub loadeddata_string: [u16; 11usize],
                pub waiting_string: [u16; 8usize],
                pub playing_string: [u16; 8usize],
                pub timeupdate_string: [u16; 11usize],
                pub canplay_string: [u16; 8usize],
                pub canplaythrough_string: [u16; 15usize],
                pub ondataavailable_string: [u16; 16usize],
                pub onwarning_string: [u16; 10usize],
                pub onstart_string: [u16; 8usize],
                pub onstop_string: [u16; 7usize],
                pub onphoto_string: [u16; 8usize],
                pub ongamepadbuttondown_string: [u16; 20usize],
                pub ongamepadbuttonup_string: [u16; 18usize],
                pub ongamepadaxismove_string: [u16; 18usize],
                pub ongamepadconnected_string: [u16; 19usize],
                pub ongamepaddisconnected_string: [u16; 22usize],
                pub onfetch_string: [u16; 8usize],
                pub afterPseudoProperty_string: [u16; 20usize],
                pub beforePseudoProperty_string: [u16; 21usize],
                pub cssPseudoElementBeforeProperty_string: [u16; 31usize],
                pub cssPseudoElementAfterProperty_string: [u16; 30usize],
                pub cssPseudoElementMarkerProperty_string: [u16; 31usize],
                pub genConInitializerProperty_string: [u16; 18usize],
                pub labelMouseDownPtProperty_string: [u16; 25usize],
                pub lockedStyleStates_string: [u16; 18usize],
                pub apzCallbackTransform_string: [u16; 21usize],
                pub apzDisabled_string: [u16; 12usize],
                pub restylableAnonymousNode_string: [u16; 24usize],
                pub docLevelNativeAnonymousContent_string: [u16; 31usize],
                pub paintRequestTime_string: [u16; 17usize],
                pub pseudoProperty_string: [u16; 15usize],
                pub manualNACProperty_string: [u16; 18usize],
                pub markerPseudoProperty_string: [u16; 21usize],
                pub Japanese_string: [u16; 3usize],
                pub Chinese_string: [u16; 6usize],
                pub Taiwanese_string: [u16; 6usize],
                pub HongKongChinese_string: [u16; 6usize],
                pub Unicode_string: [u16; 10usize],
                pub ko_string: [u16; 3usize],
                pub zh_cn_string: [u16; 6usize],
                pub zh_tw_string: [u16; 6usize],
                pub x_cyrillic_string: [u16; 11usize],
                pub he_string: [u16; 3usize],
                pub ar_string: [u16; 3usize],
                pub x_devanagari_string: [u16; 13usize],
                pub x_tamil_string: [u16; 8usize],
                pub x_armn_string: [u16; 7usize],
                pub x_beng_string: [u16; 7usize],
                pub x_cans_string: [u16; 7usize],
                pub x_ethi_string: [u16; 7usize],
                pub x_geor_string: [u16; 7usize],
                pub x_gujr_string: [u16; 7usize],
                pub x_guru_string: [u16; 7usize],
                pub x_khmr_string: [u16; 7usize],
                pub x_knda_string: [u16; 7usize],
                pub x_mlym_string: [u16; 7usize],
                pub x_orya_string: [u16; 7usize],
                pub x_sinh_string: [u16; 7usize],
                pub x_telu_string: [u16; 7usize],
                pub x_tibt_string: [u16; 7usize],
                pub az_string: [u16; 3usize],
                pub ba_string: [u16; 3usize],
                pub crh_string: [u16; 4usize],
                pub ga_string: [u16; 3usize],
                pub nl_string: [u16; 3usize],
                pub x_math_string: [u16; 7usize],
                pub zh_string: [u16; 3usize],
                pub TypingTxnName_string: [u16; 7usize],
                pub IMETxnName_string: [u16; 4usize],
                pub DeleteTxnName_string: [u16; 9usize],
                pub serif_string: [u16; 6usize],
                pub sans_serif_string: [u16; 11usize],
                pub cursive_string: [u16; 8usize],
                pub fantasy_string: [u16; 8usize],
                pub monospace_string: [u16; 10usize],
                pub mozfixed_string: [u16; 11usize],
                pub moz_fixed_pos_containing_block_string: [u16; 32usize],
                pub light_string: [u16; 6usize],
                pub dark_string: [u16; 5usize],
                pub RemoteId_string: [u16; 11usize],
                pub RemoteType_string: [u16; 11usize],
                pub DisplayPort_string: [u16; 13usize],
                pub DisplayPortMargins_string: [u16; 20usize],
                pub DisplayPortBase_string: [u16; 17usize],
                pub MinimalDisplayPort_string: [u16; 20usize],
                pub forceMousewheelAutodir_string: [u16; 26usize],
                pub forceMousewheelAutodirHonourRoot_string: [u16; 37usize],
                pub forcemessagemanager_string: [u16; 20usize],
                pub initialBrowsingContextGroupId_string: [u16; 30usize],
                pub manualactiveness_string: [u16; 17usize],
                pub _moz_bool_pref_string: [u16; 15usize],
                pub _moz_overlay_scrollbars_string: [u16; 24usize],
                pub _moz_overlay_scrollbar_fade_duration_string: [u16; 37usize],
                pub _moz_windows_accent_color_in_titlebar_string: [u16; 38usize],
                pub _moz_windows_accent_color_in_tabs_string: [u16; 34usize],
                pub _moz_windows_mica_string: [u16; 18usize],
                pub _moz_windows_mica_popups_string: [u16; 25usize],
                pub _moz_mac_big_sur_theme_string: [u16; 23usize],
                pub _moz_mac_tahoe_theme_string: [u16; 21usize],
                pub _moz_mac_rtl_string: [u16; 13usize],
                pub _moz_mac_titlebar_height_string: [u16; 25usize],
                pub _moz_platform_string: [u16; 14usize],
                pub _moz_gtk_theme_family_string: [u16; 22usize],
                pub _moz_menubar_drag_string: [u16; 18usize],
                pub _moz_device_pixel_ratio_string: [u16; 24usize],
                pub _moz_device_orientation_string: [u16; 24usize],
                pub _moz_is_resource_document_string: [u16; 26usize],
                pub _moz_swipe_animation_enabled_string: [u16; 29usize],
                pub _moz_gtk_csd_available_string: [u16; 23usize],
                pub _moz_gtk_csd_transparency_available_string: [u16; 36usize],
                pub _moz_gtk_csd_titlebar_radius_string: [u16; 29usize],
                pub _moz_gtk_csd_tooltip_radius_string: [u16; 28usize],
                pub _moz_gtk_csd_titlebar_button_spacing_string: [u16; 37usize],
                pub _moz_gtk_csd_minimize_button_string: [u16; 29usize],
                pub _moz_gtk_csd_minimize_button_position_string: [u16; 38usize],
                pub _moz_gtk_csd_maximize_button_string: [u16; 29usize],
                pub _moz_gtk_csd_maximize_button_position_string: [u16; 38usize],
                pub _moz_gtk_csd_close_button_string: [u16; 26usize],
                pub _moz_gtk_csd_close_button_position_string: [u16; 35usize],
                pub _moz_gtk_csd_reversed_placement_string: [u16; 32usize],
                pub _moz_gtk_csd_rounded_bottom_corners_string: [u16; 36usize],
                pub _moz_content_prefers_color_scheme_string: [u16; 34usize],
                pub _moz_content_preferred_color_scheme_string: [u16; 36usize],
                pub _moz_system_dark_theme_string: [u16; 23usize],
                pub _moz_native_theme_string: [u16; 18usize],
                pub _moz_panel_animations_string: [u16; 22usize],
                pub Back_string: [u16; 5usize],
                pub Forward_string: [u16; 8usize],
                pub Reload_string: [u16; 7usize],
                pub Stop_string: [u16; 5usize],
                pub Search_string: [u16; 7usize],
                pub Bookmarks_string: [u16; 10usize],
                pub Home_string: [u16; 5usize],
                pub NextTrack_string: [u16; 10usize],
                pub PreviousTrack_string: [u16; 14usize],
                pub MediaStop_string: [u16; 10usize],
                pub PlayPause_string: [u16; 10usize],
                pub New_string: [u16; 4usize],
                pub Open_string: [u16; 5usize],
                pub Close_string: [u16; 6usize],
                pub Save_string: [u16; 5usize],
                pub Find_string: [u16; 5usize],
                pub Help_string: [u16; 5usize],
                pub Print_string: [u16; 6usize],
                pub SendMail_string: [u16; 9usize],
                pub ForwardMail_string: [u16; 12usize],
                pub ReplyToMail_string: [u16; 12usize],
                pub alert_string: [u16; 6usize],
                pub alertdialog_string: [u16; 12usize],
                pub application_string: [u16; 12usize],
                pub aria_colcount_string: [u16; 14usize],
                pub aria_colindex_string: [u16; 14usize],
                pub aria_colindextext_string: [u16; 18usize],
                pub aria_colspan_string: [u16; 13usize],
                pub aria_details_string: [u16; 13usize],
                pub aria_errormessage_string: [u16; 18usize],
                pub aria_grabbed_string: [u16; 13usize],
                pub aria_keyshortcuts_string: [u16; 18usize],
                pub aria_label_string: [u16; 11usize],
                pub aria_modal_string: [u16; 11usize],
                pub aria_orientation_string: [u16; 17usize],
                pub aria_placeholder_string: [u16; 17usize],
                pub aria_roledescription_string: [u16; 21usize],
                pub aria_rowcount_string: [u16; 14usize],
                pub aria_rowindex_string: [u16; 14usize],
                pub aria_rowindextext_string: [u16; 18usize],
                pub aria_rowspan_string: [u16; 13usize],
                pub aria_valuetext_string: [u16; 15usize],
                pub assertive_string: [u16; 10usize],
                pub auto_generated_string: [u16; 15usize],
                pub banner_string: [u16; 7usize],
                pub checkable_string: [u16; 10usize],
                pub columnheader_string: [u16; 13usize],
                pub complementary_string: [u16; 14usize],
                pub containerAtomic_string: [u16; 17usize],
                pub containerBusy_string: [u16; 15usize],
                pub containerLive_string: [u16; 15usize],
                pub containerLiveRole_string: [u16; 20usize],
                pub containerRelevant_string: [u16; 19usize],
                pub contentinfo_string: [u16; 12usize],
                pub cycles_string: [u16; 7usize],
                pub datatable_string: [u16; 10usize],
                pub feed_string: [u16; 5usize],
                pub grammar_string: [u16; 8usize],
                pub gridcell_string: [u16; 9usize],
                pub heading_string: [u16; 8usize],
                pub inlinevalue_string: [u16; 7usize],
                pub inline_size_string: [u16; 12usize],
                pub invalid_string: [u16; 8usize],
                pub lineNumber_string: [u16; 12usize],
                pub menuitemcheckbox_string: [u16; 17usize],
                pub menuitemradio_string: [u16; 14usize],
                pub navigation_string: [u16; 11usize],
                pub polite_string: [u16; 7usize],
                pub posinset_string: [u16; 9usize],
                pub presentation_string: [u16; 13usize],
                pub progressbar_string: [u16; 12usize],
                pub region_string: [u16; 7usize],
                pub rowgroup_string: [u16; 9usize],
                pub rowheader_string: [u16; 10usize],
                pub search_string: [u16; 7usize],
                pub searchbox_string: [u16; 10usize],
                pub setsize_string: [u16; 8usize],
                pub spelling_string: [u16; 9usize],
                pub spinbutton_string: [u16; 11usize],
                pub status_string: [u16; 7usize],
                pub tableCellIndex_string: [u16; 17usize],
                pub tablist_string: [u16; 8usize],
                pub textIndent_string: [u16; 12usize],
                pub textInputType_string: [u16; 16usize],
                pub textLineThroughColor_string: [u16; 24usize],
                pub textLineThroughStyle_string: [u16; 24usize],
                pub textPosition_string: [u16; 14usize],
                pub textUnderlineColor_string: [u16; 21usize],
                pub textUnderlineStyle_string: [u16; 21usize],
                pub timer_string: [u16; 6usize],
                pub toolbarname_string: [u16; 12usize],
                pub toolbarseparator_string: [u16; 17usize],
                pub toolbarspacer_string: [u16; 14usize],
                pub toolbarspring_string: [u16; 14usize],
                pub treegrid_string: [u16; 9usize],
                pub _undefined_string: [u16; 10usize],
                pub xmlroles_string: [u16; 10usize],
                pub close_fence_string: [u16; 12usize],
                pub denominator_string: [u16; 12usize],
                pub numerator_string: [u16; 10usize],
                pub open_fence_string: [u16; 11usize],
                pub overscript_string: [u16; 11usize],
                pub presubscript_string: [u16; 13usize],
                pub presuperscript_string: [u16; 15usize],
                pub root_index_string: [u16; 11usize],
                pub subscript_string: [u16; 10usize],
                pub superscript_string: [u16; 12usize],
                pub underscript_string: [u16; 12usize],
                pub onaudiostart_string: [u16; 13usize],
                pub onaudioend_string: [u16; 11usize],
                pub onsoundstart_string: [u16; 13usize],
                pub onsoundend_string: [u16; 11usize],
                pub onspeechstart_string: [u16; 14usize],
                pub onspeechend_string: [u16; 12usize],
                pub onresult_string: [u16; 9usize],
                pub onnomatch_string: [u16; 10usize],
                pub onresume_string: [u16; 9usize],
                pub onmark_string: [u16; 7usize],
                pub onboundary_string: [u16; 11usize],
                pub onactivated_string: [u16; 12usize],
                pub ondeactivated_string: [u16; 14usize],
                pub onmetadatachange_string: [u16; 17usize],
                pub onplaybackstatechange_string: [u16; 22usize],
                pub onpositionstatechange_string: [u16; 22usize],
                pub onsupportedkeyschange_string: [u16; 22usize],
                pub mathml_legacy_mathvariant_attribute_disabled_string: [u16; 45usize],
                pub mathml_font_family_math_enabled_string: [u16; 32usize],
                pub layout_css_always_underline_links_string: [u16; 34usize],
                pub layout_css_android_pip_enabled_string: [u16; 31usize],
                pub layout_css_cached_scrollbar_styles_enabled_string: [u16; 43usize],
                pub layout_testing_scrollbars_always_hidden_string: [u16; 40usize],
                pub usercontextid_string: [u16; 14usize],
                pub geckoViewSessionContextId_string: [u16; 26usize],
                pub nsuri_xmlns_string: [u16; 30usize],
                pub nsuri_xml_string: [u16; 37usize],
                pub nsuri_xhtml_string: [u16; 29usize],
                pub nsuri_xlink_string: [u16; 29usize],
                pub nsuri_xslt_string: [u16; 37usize],
                pub nsuri_mathml_string: [u16; 35usize],
                pub nsuri_rdf_string: [u16; 44usize],
                pub nsuri_xul_string: [u16; 62usize],
                pub nsuri_svg_string: [u16; 27usize],
                pub nsuri_parsererror_string: [u16; 53usize],
                pub onsourceopen_string: [u16; 13usize],
                pub onsourceended_string: [u16; 14usize],
                pub onsourceclose_string: [u16; 14usize],
                pub onupdatestart_string: [u16; 14usize],
                pub onupdate_string: [u16; 9usize],
                pub onupdateend_string: [u16; 12usize],
                pub onaddsourcebuffer_string: [u16; 18usize],
                pub onremovesourcebuffer_string: [u16; 21usize],
                pub ondequeue_string: [u16; 10usize],
                pub about_string: [u16; 6usize],
                pub ID_string: [u16; 3usize],
                pub nodeID_string: [u16; 7usize],
                pub aboutEach_string: [u16; 10usize],
                pub resource_string: [u16; 9usize],
                pub RDF_string: [u16; 4usize],
                pub Description_string: [u16; 12usize],
                pub Bag_string: [u16; 4usize],
                pub Seq_string: [u16; 4usize],
                pub Alt_string: [u16; 4usize],
                pub parseType_string: [u16; 10usize],
                pub DirectoryService_CurrentProcess_string: [u16; 10usize],
                pub DirectoryService_GRE_Directory_string: [u16; 5usize],
                pub DirectoryService_GRE_BinDirectory_string: [u16; 8usize],
                pub DirectoryService_OS_TemporaryDirectory_string: [u16; 5usize],
                pub DirectoryService_OS_CurrentProcessDirectory_string: [u16; 9usize],
                pub DirectoryService_OS_CurrentWorkingDirectory_string: [u16; 9usize],
                pub DirectoryService_OS_SystemConfigDir_string: [u16; 9usize],
                pub DirectoryService_OS_DesktopDirectory_string: [u16; 5usize],
                pub DirectoryService_OS_DocumentsDirectory_string: [u16; 5usize],
                pub DirectoryService_InitCurrentProcess_dummy_string: [u16; 8usize],
                pub DirectoryService_SystemDirectory_string: [u16; 5usize],
                pub DirectoryService_UserLibDirectory_string: [u16; 8usize],
                pub DirectoryService_DefaultDownloadDirectory_string: [u16; 10usize],
                pub DirectoryService_LocalApplicationsDirectory_string: [u16; 7usize],
                pub DirectoryService_UserPreferencesDirectory_string: [u16; 8usize],
                pub DirectoryService_PictureDocumentsDirectory_string: [u16; 4usize],
                pub DirectoryService_DefaultScreenshotDirectory_string: [u16; 9usize],
                pub DirectoryService_WindowsDirectory_string: [u16; 5usize],
                pub DirectoryService_WindowsProgramFiles_string: [u16; 6usize],
                pub DirectoryService_Programs_string: [u16; 6usize],
                pub DirectoryService_Favorites_string: [u16; 5usize],
                pub DirectoryService_Appdata_string: [u16; 8usize],
                pub DirectoryService_LocalAppdata_string: [u16; 13usize],
                pub DirectoryService_WinCookiesDirectory_string: [u16; 6usize],
                pub DirectoryService_OneDrivePersonalDirectory_string: [u16; 8usize],
                pub DirectoryService_OneDriveBusinessDirectoryList_string: [u16; 9usize],
                pub _ua_view_transition_fade_out_string: [u16; 29usize],
                pub _ua_view_transition_fade_in_string: [u16; 28usize],
                pub _ua_mix_blend_mode_plus_lighter_string: [u16; 32usize],
                pub AnchorPosImplicitAnchor_string: [u16; 24usize],
                pub PseudoElement_after_string: [u16; 7usize],
                pub PseudoElement_before_string: [u16; 8usize],
                pub PseudoElement_marker_string: [u16; 8usize],
                pub PseudoElement_backdrop_string: [u16; 10usize],
                pub PseudoElement_cue_string: [u16; 5usize],
                pub PseudoElement_firstLetter_string: [u16; 14usize],
                pub PseudoElement_firstLine_string: [u16; 12usize],
                pub PseudoElement_highlight_string: [u16; 11usize],
                pub PseudoElement_selection_string: [u16; 11usize],
                pub PseudoElement_targetText_string: [u16; 13usize],
                pub PseudoElement_viewTransition_string: [u16; 17usize],
                pub PseudoElement_viewTransitionGroup_string: [u16; 23usize],
                pub PseudoElement_viewTransitionImagePair_string: [u16; 28usize],
                pub PseudoElement_viewTransitionOld_string: [u16; 21usize],
                pub PseudoElement_viewTransitionNew_string: [u16; 21usize],
                pub PseudoElement_mozSnapshotContainingBlock_string: [u16; 32usize],
                pub PseudoElement_mozNumberSpinBox_string: [u16; 22usize],
                pub PseudoElement_mozNumberSpinUp_string: [u16; 21usize],
                pub PseudoElement_mozNumberSpinDown_string: [u16; 23usize],
                pub PseudoElement_mozSearchClearButton_string: [u16; 26usize],
                pub PseudoElement_mozProgressBar_string: [u16; 19usize],
                pub PseudoElement_mozRangeTrack_string: [u16; 18usize],
                pub PseudoElement_mozRangeProgress_string: [u16; 21usize],
                pub PseudoElement_mozRangeThumb_string: [u16; 18usize],
                pub PseudoElement_mozMeterBar_string: [u16; 16usize],
                pub PseudoElement_placeholder_string: [u16; 13usize],
                pub PseudoElement_mozColorSwatch_string: [u16; 19usize],
                pub PseudoElement_mozTextControlEditingRoot_string: [u16; 32usize],
                pub PseudoElement_mozTextControlPreview_string: [u16; 27usize],
                pub PseudoElement_mozReveal_string: [u16; 13usize],
                pub PseudoElement_fileSelectorButton_string: [u16; 22usize],
                pub PseudoElement_sliderTrack_string: [u16; 14usize],
                pub PseudoElement_sliderThumb_string: [u16; 14usize],
                pub PseudoElement_sliderFill_string: [u16; 13usize],
                pub PseudoElement_detailsContent_string: [u16; 17usize],
                pub AnonBox_oofPlaceholder_string: [u16; 22usize],
                pub AnonBox_horizontalFramesetBorder_string: [u16; 23usize],
                pub AnonBox_verticalFramesetBorder_string: [u16; 23usize],
                pub AnonBox_framesetBlank_string: [u16; 21usize],
                pub AnonBox_tableColGroup_string: [u16; 25usize],
                pub AnonBox_tableCol_string: [u16; 19usize],
                pub AnonBox_page_string: [u16; 11usize],
                pub AnonBox_pageBreak_string: [u16; 17usize],
                pub AnonBox_pageContent_string: [u16; 19usize],
                pub AnonBox_printedSheet_string: [u16; 20usize],
                pub AnonBox_columnSpanWrapper_string: [u16; 26usize],
                pub AnonBox_mozText_string: [u16; 11usize],
                pub AnonBox_firstLetterContinuation_string: [u16; 32usize],
                pub AnonBox_mozBlockInsideInlineWrapper_string: [u16; 34usize],
                pub AnonBox_mozMathMLAnonymousBlock_string: [u16; 29usize],
                pub AnonBox_mozLineFrame_string: [u16; 17usize],
                pub AnonBox_cellContent_string: [u16; 19usize],
                pub AnonBox_dropDownList_string: [u16; 20usize],
                pub AnonBox_fieldsetContent_string: [u16; 23usize],
                pub AnonBox_htmlCanvasContent_string: [u16; 26usize],
                pub AnonBox_inlineTable_string: [u16; 19usize],
                pub AnonBox_table_string: [u16; 12usize],
                pub AnonBox_tableCell_string: [u16; 17usize],
                pub AnonBox_tableWrapper_string: [u16; 20usize],
                pub AnonBox_tableRowGroup_string: [u16; 22usize],
                pub AnonBox_tableRow_string: [u16; 16usize],
                pub AnonBox_canvas_string: [u16; 13usize],
                pub AnonBox_pageSequence_string: [u16; 20usize],
                pub AnonBox_scrolledContent_string: [u16; 23usize],
                pub AnonBox_scrolledCanvas_string: [u16; 22usize],
                pub AnonBox_columnSet_string: [u16; 17usize],
                pub AnonBox_columnContent_string: [u16; 21usize],
                pub AnonBox_viewport_string: [u16; 15usize],
                pub AnonBox_viewportScroll_string: [u16; 22usize],
                pub AnonBox_anonymousItem_string: [u16; 21usize],
                pub AnonBox_blockRubyContent_string: [u16; 25usize],
                pub AnonBox_ruby_string: [u16; 11usize],
                pub AnonBox_rubyBase_string: [u16; 16usize],
                pub AnonBox_rubyBaseContainer_string: [u16; 26usize],
                pub AnonBox_rubyText_string: [u16; 16usize],
                pub AnonBox_rubyTextContainer_string: [u16; 26usize],
                pub AnonBox_mozTreeColumn_string: [u16; 18usize],
                pub AnonBox_mozTreeRow_string: [u16; 15usize],
                pub AnonBox_mozTreeSeparator_string: [u16; 21usize],
                pub AnonBox_mozTreeCell_string: [u16; 16usize],
                pub AnonBox_mozTreeIndentation_string: [u16; 23usize],
                pub AnonBox_mozTreeLine_string: [u16; 16usize],
                pub AnonBox_mozTreeTwisty_string: [u16; 18usize],
                pub AnonBox_mozTreeImage_string: [u16; 17usize],
                pub AnonBox_mozTreeCellText_string: [u16; 21usize],
                pub AnonBox_mozTreeCheckbox_string: [u16; 20usize],
                pub AnonBox_mozTreeDropFeedback_string: [u16; 25usize],
                pub AnonBox_mozSVGMarkerAnonChild_string: [u16; 28usize],
                pub AnonBox_mozSVGOuterSVGAnonChild_string: [u16; 31usize],
                pub AnonBox_mozSVGForeignContent_string: [u16; 26usize],
                pub AnonBox_mozSVGText_string: [u16; 15usize],
                pub xlink_string: [u16; 6usize],
                pub xml_space_string: [u16; 10usize],
                pub xml_lang_string: [u16; 9usize],
                pub aria_grab_string: [u16; 10usize],
                pub aria_channel_string: [u16; 13usize],
                pub aria_secret_string: [u16; 12usize],
                pub aria_templateid_string: [u16; 16usize],
                pub aria_datatype_string: [u16; 14usize],
                pub local_string: [u16; 6usize],
                pub xchannelselector_string: [u16; 17usize],
                pub ychannelselector_string: [u16; 17usize],
                pub enable_background_string: [u16; 18usize],
                pub calcmode_string: [u16; 9usize],
                pub specularexponent_string: [u16; 17usize],
                pub specularconstant_string: [u16; 17usize],
                pub gradienttransform_string: [u16; 18usize],
                pub gradientunits_string: [u16; 14usize],
                pub rendering_intent_string: [u16; 17usize],
                pub shadowrootmode_string: [u16; 15usize],
                pub shadowrootclonable_string: [u16; 19usize],
                pub shadowrootserializable_string: [u16; 23usize],
                pub stddeviation_string: [u16; 13usize],
                pub shadowrootdelegatesfocus_string: [u16; 25usize],
                pub basefrequency_string: [u16; 14usize],
                pub baseprofile_string: [u16; 12usize],
                pub baseProfile_string: [u16; 12usize],
                pub edgemode_string: [u16; 9usize],
                pub repeatcount_string: [u16; 12usize],
                pub repeatdur_string: [u16; 10usize],
                pub spreadmethod_string: [u16; 13usize],
                pub diffuseconstant_string: [u16; 16usize],
                pub surfacescale_string: [u16; 13usize],
                pub lengthadjust_string: [u16; 13usize],
                pub origin_string: [u16; 7usize],
                pub targetx_string: [u16; 8usize],
                pub targety_string: [u16; 8usize],
                pub pathlength_string: [u16; 11usize],
                pub definitionurl_string: [u16; 14usize],
                pub limitingconeangle_string: [u16; 18usize],
                pub markerheight_string: [u16; 13usize],
                pub markerwidth_string: [u16; 12usize],
                pub maskunits_string: [u16; 10usize],
                pub markerunits_string: [u16; 12usize],
                pub maskcontentunits_string: [u16; 17usize],
                pub tablevalues_string: [u16; 12usize],
                pub primitiveunits_string: [u16; 15usize],
                pub zoomandpan_string: [u16; 11usize],
                pub kernelmatrix_string: [u16; 13usize],
                pub kerning_string: [u16; 8usize],
                pub kernelunitlength_string: [u16; 17usize],
                pub pointsatx_string: [u16; 10usize],
                pub pointsaty_string: [u16; 10usize],
                pub pointsatz_string: [u16; 10usize],
                pub xlink_href_string: [u16; 11usize],
                pub xlink_title_string: [u16; 12usize],
                pub xlink_role_string: [u16; 11usize],
                pub xlink_arcrole_string: [u16; 14usize],
                pub arcrole_string: [u16; 8usize],
                pub xmlns_xlink_string: [u16; 12usize],
                pub xlink_type_string: [u16; 11usize],
                pub xlink_show_string: [u16; 11usize],
                pub xlink_actuate_string: [u16; 14usize],
                pub autocorrect_string: [u16; 12usize],
                pub color_rendering_string: [u16; 16usize],
                pub numoctaves_string: [u16; 11usize],
                pub onmousewheel_string: [u16; 13usize],
                pub clippathunits_string: [u16; 14usize],
                pub glyph_orientation_vertical_string: [u16; 27usize],
                pub glyph_orientation_horizontal_string: [u16; 29usize],
                pub glyphref_string: [u16; 9usize],
                pub keypoints_string: [u16; 10usize],
                pub attributename_string: [u16; 14usize],
                pub attributetype_string: [u16; 14usize],
                pub startoffset_string: [u16; 12usize],
                pub keysplines_string: [u16; 11usize],
                pub preservealpha_string: [u16; 14usize],
                pub preserveaspectratio_string: [u16; 20usize],
                pub alttext_string: [u16; 8usize],
                pub filterunits_string: [u16; 12usize],
                pub keytimes_string: [u16; 9usize],
                pub patterntransform_string: [u16; 17usize],
                pub patternunits_string: [u16; 13usize],
                pub patterncontentunits_string: [u16; 20usize],
                pub stitchtiles_string: [u16; 12usize],
                pub systemlanguage_string: [u16; 15usize],
                pub textlength_string: [u16; 11usize],
                pub requiredfeatures_string: [u16; 17usize],
                pub requiredextensions_string: [u16; 19usize],
                pub viewtarget_string: [u16; 11usize],
                pub viewbox_string: [u16; 8usize],
                pub refx_string: [u16; 5usize],
                pub refy_string: [u16; 5usize],
                pub fefunca_string: [u16; 8usize],
                pub fefuncb_string: [u16; 8usize],
                pub feblend_string: [u16; 8usize],
                pub feflood_string: [u16; 8usize],
                pub feturbulence_string: [u16; 13usize],
                pub femergenode_string: [u16; 12usize],
                pub feimage_string: [u16; 8usize],
                pub femerge_string: [u16; 8usize],
                pub fetile_string: [u16; 7usize],
                pub fecomposite_string: [u16; 12usize],
                pub altglyphdef_string: [u16; 12usize],
                pub altGlyphDef_string: [u16; 12usize],
                pub fefuncg_string: [u16; 8usize],
                pub fediffuselighting_string: [u16; 18usize],
                pub fespecularlighting_string: [u16; 19usize],
                pub altglyph_string: [u16; 9usize],
                pub altGlyph_string: [u16; 9usize],
                pub clippath_string: [u16; 9usize],
                pub textpath_string: [u16; 9usize],
                pub altglyphitem_string: [u16; 13usize],
                pub altGlyphItem_string: [u16; 13usize],
                pub animatetransform_string: [u16; 17usize],
                pub animatemotion_string: [u16; 14usize],
                pub fedisplacementmap_string: [u16; 18usize],
                pub animatecolor_string: [u16; 13usize],
                pub fefuncr_string: [u16; 8usize],
                pub fecomponenttransfer_string: [u16; 20usize],
                pub fegaussianblur_string: [u16; 15usize],
                pub foreignobject_string: [u16; 14usize],
                pub feoffset_string: [u16; 9usize],
                pub fespotlight_string: [u16; 12usize],
                pub fepointlight_string: [u16; 13usize],
                pub fedistantlight_string: [u16; 15usize],
                pub lineargradient_string: [u16; 15usize],
                pub radialgradient_string: [u16; 15usize],
                pub fedropshadow_string: [u16; 13usize],
                pub fecolormatrix_string: [u16; 14usize],
                pub feconvolvematrix_string: [u16; 17usize],
                pub femorphology_string: [u16; 13usize],
                pub mAtoms: [root::nsStaticAtom; 2670usize],
            }
            pub const GkAtoms_Atoms_SystemPrincipal: GkAtoms_Atoms = 0;
            pub const GkAtoms_Atoms__empty: GkAtoms_Atoms = 1;
            pub const GkAtoms_Atoms__0: GkAtoms_Atoms = 2;
            pub const GkAtoms_Atoms__1: GkAtoms_Atoms = 3;
            pub const GkAtoms_Atoms__2: GkAtoms_Atoms = 4;
            pub const GkAtoms_Atoms__3: GkAtoms_Atoms = 5;
            pub const GkAtoms_Atoms__4: GkAtoms_Atoms = 6;
            pub const GkAtoms_Atoms__5: GkAtoms_Atoms = 7;
            pub const GkAtoms_Atoms__6: GkAtoms_Atoms = 8;
            pub const GkAtoms_Atoms__7: GkAtoms_Atoms = 9;
            pub const GkAtoms_Atoms__8: GkAtoms_Atoms = 10;
            pub const GkAtoms_Atoms__9: GkAtoms_Atoms = 11;
            pub const GkAtoms_Atoms_mozframetype: GkAtoms_Atoms = 12;
            pub const GkAtoms_Atoms__moz_abspos: GkAtoms_Atoms = 13;
            pub const GkAtoms_Atoms__moz_activated: GkAtoms_Atoms = 14;
            pub const GkAtoms_Atoms__moz_anonclass: GkAtoms_Atoms = 15;
            pub const GkAtoms_Atoms__moz_resizing: GkAtoms_Atoms = 16;
            pub const GkAtoms_Atoms_moztype: GkAtoms_Atoms = 17;
            pub const GkAtoms_Atoms_mozdirty: GkAtoms_Atoms = 18;
            pub const GkAtoms_Atoms_mozdisallowselectionprint: GkAtoms_Atoms = 19;
            pub const GkAtoms_Atoms_mozdonotsend: GkAtoms_Atoms = 20;
            pub const GkAtoms_Atoms_mozfwcontainer: GkAtoms_Atoms = 21;
            pub const GkAtoms_Atoms_mozgeneratedcontentbefore: GkAtoms_Atoms = 22;
            pub const GkAtoms_Atoms_mozgeneratedcontentafter: GkAtoms_Atoms = 23;
            pub const GkAtoms_Atoms_mozgeneratedcontentmarker: GkAtoms_Atoms = 24;
            pub const GkAtoms_Atoms_mozgeneratedcontentimage: GkAtoms_Atoms = 25;
            pub const GkAtoms_Atoms_mozquote: GkAtoms_Atoms = 26;
            pub const GkAtoms_Atoms_mozsignature: GkAtoms_Atoms = 27;
            pub const GkAtoms_Atoms__moz_bullet_font: GkAtoms_Atoms = 28;
            pub const GkAtoms_Atoms__moz_is_glyph: GkAtoms_Atoms = 29;
            pub const GkAtoms_Atoms__moz_in_android_pip_mode: GkAtoms_Atoms = 30;
            pub const GkAtoms_Atoms__moz_original_size: GkAtoms_Atoms = 31;
            pub const GkAtoms_Atoms__moz_print_preview: GkAtoms_Atoms = 32;
            pub const GkAtoms_Atoms_menuactive: GkAtoms_Atoms = 33;
            pub const GkAtoms_Atoms__poundDefault: GkAtoms_Atoms = 34;
            pub const GkAtoms_Atoms__asterisk: GkAtoms_Atoms = 35;
            pub const GkAtoms_Atoms_a: GkAtoms_Atoms = 36;
            pub const GkAtoms_Atoms_abbr: GkAtoms_Atoms = 37;
            pub const GkAtoms_Atoms_abort: GkAtoms_Atoms = 38;
            pub const GkAtoms_Atoms_above: GkAtoms_Atoms = 39;
            pub const GkAtoms_Atoms_acceltext: GkAtoms_Atoms = 40;
            pub const GkAtoms_Atoms_accept: GkAtoms_Atoms = 41;
            pub const GkAtoms_Atoms_acceptcharset: GkAtoms_Atoms = 42;
            pub const GkAtoms_Atoms_accessiblenode: GkAtoms_Atoms = 43;
            pub const GkAtoms_Atoms_accesskey: GkAtoms_Atoms = 44;
            pub const GkAtoms_Atoms_acronym: GkAtoms_Atoms = 45;
            pub const GkAtoms_Atoms_action: GkAtoms_Atoms = 46;
            pub const GkAtoms_Atoms_active: GkAtoms_Atoms = 47;
            pub const GkAtoms_Atoms_activateontab: GkAtoms_Atoms = 48;
            pub const GkAtoms_Atoms_actuate: GkAtoms_Atoms = 49;
            pub const GkAtoms_Atoms_address: GkAtoms_Atoms = 50;
            pub const GkAtoms_Atoms_adoptedsheetclones: GkAtoms_Atoms = 51;
            pub const GkAtoms_Atoms_adult: GkAtoms_Atoms = 52;
            pub const GkAtoms_Atoms_after: GkAtoms_Atoms = 53;
            pub const GkAtoms_Atoms_align: GkAtoms_Atoms = 54;
            pub const GkAtoms_Atoms_alink: GkAtoms_Atoms = 55;
            pub const GkAtoms_Atoms_all: GkAtoms_Atoms = 56;
            pub const GkAtoms_Atoms_allow: GkAtoms_Atoms = 57;
            pub const GkAtoms_Atoms_allowdownloads: GkAtoms_Atoms = 58;
            pub const GkAtoms_Atoms_allowevents: GkAtoms_Atoms = 59;
            pub const GkAtoms_Atoms_allowforms: GkAtoms_Atoms = 60;
            pub const GkAtoms_Atoms_allowfullscreen: GkAtoms_Atoms = 61;
            pub const GkAtoms_Atoms_allowmodals: GkAtoms_Atoms = 62;
            pub const GkAtoms_Atoms_alloworientationlock: GkAtoms_Atoms = 63;
            pub const GkAtoms_Atoms_allowpointerlock: GkAtoms_Atoms = 64;
            pub const GkAtoms_Atoms_allowpopupstoescapesandbox: GkAtoms_Atoms = 65;
            pub const GkAtoms_Atoms_allowpopups: GkAtoms_Atoms = 66;
            pub const GkAtoms_Atoms_allowpresentation: GkAtoms_Atoms = 67;
            pub const GkAtoms_Atoms_allowstorageaccessbyuseractivatetion: GkAtoms_Atoms = 68;
            pub const GkAtoms_Atoms_allowsameorigin: GkAtoms_Atoms = 69;
            pub const GkAtoms_Atoms_allowscripts: GkAtoms_Atoms = 70;
            pub const GkAtoms_Atoms_allowscriptstoclose: GkAtoms_Atoms = 71;
            pub const GkAtoms_Atoms_allowtopnavigation: GkAtoms_Atoms = 72;
            pub const GkAtoms_Atoms_allowtopnavigationbyuseractivation: GkAtoms_Atoms = 73;
            pub const GkAtoms_Atoms_allowtopnavigationcustomprotocols: GkAtoms_Atoms = 74;
            pub const GkAtoms_Atoms_allowuntrusted: GkAtoms_Atoms = 75;
            pub const GkAtoms_Atoms_alt: GkAtoms_Atoms = 76;
            pub const GkAtoms_Atoms_alternate: GkAtoms_Atoms = 77;
            pub const GkAtoms_Atoms_always: GkAtoms_Atoms = 78;
            pub const GkAtoms_Atoms_ancestor: GkAtoms_Atoms = 79;
            pub const GkAtoms_Atoms_ancestorOrSelf: GkAtoms_Atoms = 80;
            pub const GkAtoms_Atoms_anchor: GkAtoms_Atoms = 81;
            pub const GkAtoms_Atoms__and: GkAtoms_Atoms = 82;
            pub const GkAtoms_Atoms_animations: GkAtoms_Atoms = 83;
            pub const GkAtoms_Atoms_anonid: GkAtoms_Atoms = 84;
            pub const GkAtoms_Atoms_anonlocation: GkAtoms_Atoms = 85;
            pub const GkAtoms_Atoms_any: GkAtoms_Atoms = 86;
            pub const GkAtoms_Atoms_any_hover: GkAtoms_Atoms = 87;
            pub const GkAtoms_Atoms_any_pointer: GkAtoms_Atoms = 88;
            pub const GkAtoms_Atoms_applet: GkAtoms_Atoms = 89;
            pub const GkAtoms_Atoms_applyImports: GkAtoms_Atoms = 90;
            pub const GkAtoms_Atoms_applyTemplates: GkAtoms_Atoms = 91;
            pub const GkAtoms_Atoms_archive: GkAtoms_Atoms = 92;
            pub const GkAtoms_Atoms_area: GkAtoms_Atoms = 93;
            pub const GkAtoms_Atoms_aria: GkAtoms_Atoms = 94;
            pub const GkAtoms_Atoms_aria_actions: GkAtoms_Atoms = 95;
            pub const GkAtoms_Atoms_aria_activedescendant: GkAtoms_Atoms = 96;
            pub const GkAtoms_Atoms_aria_atomic: GkAtoms_Atoms = 97;
            pub const GkAtoms_Atoms_aria_autocomplete: GkAtoms_Atoms = 98;
            pub const GkAtoms_Atoms_aria_braillelabel: GkAtoms_Atoms = 99;
            pub const GkAtoms_Atoms_aria_brailleroledescription: GkAtoms_Atoms = 100;
            pub const GkAtoms_Atoms_aria_busy: GkAtoms_Atoms = 101;
            pub const GkAtoms_Atoms_aria_checked: GkAtoms_Atoms = 102;
            pub const GkAtoms_Atoms_aria_controls: GkAtoms_Atoms = 103;
            pub const GkAtoms_Atoms_aria_current: GkAtoms_Atoms = 104;
            pub const GkAtoms_Atoms_aria_describedby: GkAtoms_Atoms = 105;
            pub const GkAtoms_Atoms_aria_description: GkAtoms_Atoms = 106;
            pub const GkAtoms_Atoms_aria_disabled: GkAtoms_Atoms = 107;
            pub const GkAtoms_Atoms_aria_dropeffect: GkAtoms_Atoms = 108;
            pub const GkAtoms_Atoms_aria_expanded: GkAtoms_Atoms = 109;
            pub const GkAtoms_Atoms_aria_flowto: GkAtoms_Atoms = 110;
            pub const GkAtoms_Atoms_aria_haspopup: GkAtoms_Atoms = 111;
            pub const GkAtoms_Atoms_aria_hidden: GkAtoms_Atoms = 112;
            pub const GkAtoms_Atoms_aria_invalid: GkAtoms_Atoms = 113;
            pub const GkAtoms_Atoms_aria_labelledby: GkAtoms_Atoms = 114;
            pub const GkAtoms_Atoms_aria_level: GkAtoms_Atoms = 115;
            pub const GkAtoms_Atoms_aria_live: GkAtoms_Atoms = 116;
            pub const GkAtoms_Atoms_aria_multiline: GkAtoms_Atoms = 117;
            pub const GkAtoms_Atoms_aria_multiselectable: GkAtoms_Atoms = 118;
            pub const GkAtoms_Atoms_aria_owns: GkAtoms_Atoms = 119;
            pub const GkAtoms_Atoms_aria_posinset: GkAtoms_Atoms = 120;
            pub const GkAtoms_Atoms_aria_pressed: GkAtoms_Atoms = 121;
            pub const GkAtoms_Atoms_aria_readonly: GkAtoms_Atoms = 122;
            pub const GkAtoms_Atoms_aria_relevant: GkAtoms_Atoms = 123;
            pub const GkAtoms_Atoms_aria_required: GkAtoms_Atoms = 124;
            pub const GkAtoms_Atoms_aria_selected: GkAtoms_Atoms = 125;
            pub const GkAtoms_Atoms_aria_setsize: GkAtoms_Atoms = 126;
            pub const GkAtoms_Atoms_aria_sort: GkAtoms_Atoms = 127;
            pub const GkAtoms_Atoms_aria_valuemax: GkAtoms_Atoms = 128;
            pub const GkAtoms_Atoms_aria_valuemin: GkAtoms_Atoms = 129;
            pub const GkAtoms_Atoms_aria_valuenow: GkAtoms_Atoms = 130;
            pub const GkAtoms_Atoms_arrow: GkAtoms_Atoms = 131;
            pub const GkAtoms_Atoms_article: GkAtoms_Atoms = 132;
            pub const GkAtoms_Atoms_as_: GkAtoms_Atoms = 133;
            pub const GkAtoms_Atoms_ascending: GkAtoms_Atoms = 134;
            pub const GkAtoms_Atoms_aside: GkAtoms_Atoms = 135;
            pub const GkAtoms_Atoms_aspectRatio: GkAtoms_Atoms = 136;
            pub const GkAtoms_Atoms_async_: GkAtoms_Atoms = 137;
            pub const GkAtoms_Atoms_attribute: GkAtoms_Atoms = 138;
            pub const GkAtoms_Atoms_attributes: GkAtoms_Atoms = 139;
            pub const GkAtoms_Atoms_attributeSet: GkAtoms_Atoms = 140;
            pub const GkAtoms_Atoms__auto: GkAtoms_Atoms = 141;
            pub const GkAtoms_Atoms_autocapitalize: GkAtoms_Atoms = 142;
            pub const GkAtoms_Atoms_autocheck: GkAtoms_Atoms = 143;
            pub const GkAtoms_Atoms_autocomplete: GkAtoms_Atoms = 144;
            pub const GkAtoms_Atoms_autocomplete_richlistbox: GkAtoms_Atoms = 145;
            pub const GkAtoms_Atoms_autofocus: GkAtoms_Atoms = 146;
            pub const GkAtoms_Atoms_autoplay: GkAtoms_Atoms = 147;
            pub const GkAtoms_Atoms_axis: GkAtoms_Atoms = 148;
            pub const GkAtoms_Atoms_b: GkAtoms_Atoms = 149;
            pub const GkAtoms_Atoms_background: GkAtoms_Atoms = 150;
            pub const GkAtoms_Atoms_badge: GkAtoms_Atoms = 151;
            pub const GkAtoms_Atoms_bar: GkAtoms_Atoms = 152;
            pub const GkAtoms_Atoms_base: GkAtoms_Atoms = 153;
            pub const GkAtoms_Atoms_basefont: GkAtoms_Atoms = 154;
            pub const GkAtoms_Atoms_baseline: GkAtoms_Atoms = 155;
            pub const GkAtoms_Atoms_bdi: GkAtoms_Atoms = 156;
            pub const GkAtoms_Atoms_bdo: GkAtoms_Atoms = 157;
            pub const GkAtoms_Atoms_before: GkAtoms_Atoms = 158;
            pub const GkAtoms_Atoms_behavior: GkAtoms_Atoms = 159;
            pub const GkAtoms_Atoms_below: GkAtoms_Atoms = 160;
            pub const GkAtoms_Atoms_bgcolor: GkAtoms_Atoms = 161;
            pub const GkAtoms_Atoms_bgsound: GkAtoms_Atoms = 162;
            pub const GkAtoms_Atoms_big: GkAtoms_Atoms = 163;
            pub const GkAtoms_Atoms_binding: GkAtoms_Atoms = 164;
            pub const GkAtoms_Atoms_bindings: GkAtoms_Atoms = 165;
            pub const GkAtoms_Atoms_bindToUntrustedContent: GkAtoms_Atoms = 166;
            pub const GkAtoms_Atoms_black: GkAtoms_Atoms = 167;
            pub const GkAtoms_Atoms_block: GkAtoms_Atoms = 168;
            pub const GkAtoms_Atoms_block_size: GkAtoms_Atoms = 169;
            pub const GkAtoms_Atoms_blocking: GkAtoms_Atoms = 170;
            pub const GkAtoms_Atoms_blockquote: GkAtoms_Atoms = 171;
            pub const GkAtoms_Atoms_blur: GkAtoms_Atoms = 172;
            pub const GkAtoms_Atoms_body: GkAtoms_Atoms = 173;
            pub const GkAtoms_Atoms_boolean: GkAtoms_Atoms = 174;
            pub const GkAtoms_Atoms_border: GkAtoms_Atoms = 175;
            pub const GkAtoms_Atoms_bordercolor: GkAtoms_Atoms = 176;
            pub const GkAtoms_Atoms_both: GkAtoms_Atoms = 177;
            pub const GkAtoms_Atoms_bottom: GkAtoms_Atoms = 178;
            pub const GkAtoms_Atoms_bottomend: GkAtoms_Atoms = 179;
            pub const GkAtoms_Atoms_bottomstart: GkAtoms_Atoms = 180;
            pub const GkAtoms_Atoms_bottomleft: GkAtoms_Atoms = 181;
            pub const GkAtoms_Atoms_bottommargin: GkAtoms_Atoms = 182;
            pub const GkAtoms_Atoms_bottomright: GkAtoms_Atoms = 183;
            pub const GkAtoms_Atoms_box_: GkAtoms_Atoms = 184;
            pub const GkAtoms_Atoms_br: GkAtoms_Atoms = 185;
            pub const GkAtoms_Atoms_browser: GkAtoms_Atoms = 186;
            pub const GkAtoms_Atoms_button: GkAtoms_Atoms = 187;
            pub const GkAtoms_Atoms_callTemplate: GkAtoms_Atoms = 188;
            pub const GkAtoms_Atoms_canvas: GkAtoms_Atoms = 189;
            pub const GkAtoms_Atoms_caption: GkAtoms_Atoms = 190;
            pub const GkAtoms_Atoms_captionBox: GkAtoms_Atoms = 191;
            pub const GkAtoms_Atoms_capture: GkAtoms_Atoms = 192;
            pub const GkAtoms_Atoms_caseOrder: GkAtoms_Atoms = 193;
            pub const GkAtoms_Atoms_cdataSectionElements: GkAtoms_Atoms = 194;
            pub const GkAtoms_Atoms_ceiling: GkAtoms_Atoms = 195;
            pub const GkAtoms_Atoms_cell: GkAtoms_Atoms = 196;
            pub const GkAtoms_Atoms_cellpadding: GkAtoms_Atoms = 197;
            pub const GkAtoms_Atoms_cellspacing: GkAtoms_Atoms = 198;
            pub const GkAtoms_Atoms_center: GkAtoms_Atoms = 199;
            pub const GkAtoms_Atoms_change: GkAtoms_Atoms = 200;
            pub const GkAtoms_Atoms__char: GkAtoms_Atoms = 201;
            pub const GkAtoms_Atoms_characterData: GkAtoms_Atoms = 202;
            pub const GkAtoms_Atoms_charcode: GkAtoms_Atoms = 203;
            pub const GkAtoms_Atoms_charoff: GkAtoms_Atoms = 204;
            pub const GkAtoms_Atoms_charset: GkAtoms_Atoms = 205;
            pub const GkAtoms_Atoms_checkbox: GkAtoms_Atoms = 206;
            pub const GkAtoms_Atoms_checkboxLabel: GkAtoms_Atoms = 207;
            pub const GkAtoms_Atoms_checked: GkAtoms_Atoms = 208;
            pub const GkAtoms_Atoms_child: GkAtoms_Atoms = 209;
            pub const GkAtoms_Atoms_children: GkAtoms_Atoms = 210;
            pub const GkAtoms_Atoms_childList: GkAtoms_Atoms = 211;
            pub const GkAtoms_Atoms_child_item_count: GkAtoms_Atoms = 212;
            pub const GkAtoms_Atoms_choose: GkAtoms_Atoms = 213;
            pub const GkAtoms_Atoms_customtitlebar: GkAtoms_Atoms = 214;
            pub const GkAtoms_Atoms_exposeToUntrustedContent: GkAtoms_Atoms = 215;
            pub const GkAtoms_Atoms_circ: GkAtoms_Atoms = 216;
            pub const GkAtoms_Atoms_circle: GkAtoms_Atoms = 217;
            pub const GkAtoms_Atoms_cite: GkAtoms_Atoms = 218;
            pub const GkAtoms_Atoms_cke_wysiwyg_frame: GkAtoms_Atoms = 219;
            pub const GkAtoms_Atoms__class: GkAtoms_Atoms = 220;
            pub const GkAtoms_Atoms_classid: GkAtoms_Atoms = 221;
            pub const GkAtoms_Atoms_clear: GkAtoms_Atoms = 222;
            pub const GkAtoms_Atoms_click: GkAtoms_Atoms = 223;
            pub const GkAtoms_Atoms_clickToPlay: GkAtoms_Atoms = 224;
            pub const GkAtoms_Atoms_clickcount: GkAtoms_Atoms = 225;
            pub const GkAtoms_Atoms_movetoclick: GkAtoms_Atoms = 226;
            pub const GkAtoms_Atoms_clip: GkAtoms_Atoms = 227;
            pub const GkAtoms_Atoms_close: GkAtoms_Atoms = 228;
            pub const GkAtoms_Atoms_closed: GkAtoms_Atoms = 229;
            pub const GkAtoms_Atoms_closedby: GkAtoms_Atoms = 230;
            pub const GkAtoms_Atoms_closemenu: GkAtoms_Atoms = 231;
            pub const GkAtoms_Atoms_code: GkAtoms_Atoms = 232;
            pub const GkAtoms_Atoms_codebase: GkAtoms_Atoms = 233;
            pub const GkAtoms_Atoms_codetype: GkAtoms_Atoms = 234;
            pub const GkAtoms_Atoms_col: GkAtoms_Atoms = 235;
            pub const GkAtoms_Atoms_colgroup: GkAtoms_Atoms = 236;
            pub const GkAtoms_Atoms_collapse: GkAtoms_Atoms = 237;
            pub const GkAtoms_Atoms_collapsed: GkAtoms_Atoms = 238;
            pub const GkAtoms_Atoms_color: GkAtoms_Atoms = 239;
            pub const GkAtoms_Atoms_color_gamut: GkAtoms_Atoms = 240;
            pub const GkAtoms_Atoms_color_index: GkAtoms_Atoms = 241;
            pub const GkAtoms_Atoms_color_scheme: GkAtoms_Atoms = 242;
            pub const GkAtoms_Atoms_cols: GkAtoms_Atoms = 243;
            pub const GkAtoms_Atoms_colspan: GkAtoms_Atoms = 244;
            pub const GkAtoms_Atoms_combobox: GkAtoms_Atoms = 245;
            pub const GkAtoms_Atoms_command: GkAtoms_Atoms = 246;
            pub const GkAtoms_Atoms_commandfor: GkAtoms_Atoms = 247;
            pub const GkAtoms_Atoms_commandupdater: GkAtoms_Atoms = 248;
            pub const GkAtoms_Atoms_comment: GkAtoms_Atoms = 249;
            pub const GkAtoms_Atoms_compact: GkAtoms_Atoms = 250;
            pub const GkAtoms_Atoms_concat: GkAtoms_Atoms = 251;
            pub const GkAtoms_Atoms_constructor: GkAtoms_Atoms = 252;
            pub const GkAtoms_Atoms_consumeoutsideclicks: GkAtoms_Atoms = 253;
            pub const GkAtoms_Atoms_container: GkAtoms_Atoms = 254;
            pub const GkAtoms_Atoms_contains: GkAtoms_Atoms = 255;
            pub const GkAtoms_Atoms_content: GkAtoms_Atoms = 256;
            pub const GkAtoms_Atoms_contenteditable: GkAtoms_Atoms = 257;
            pub const GkAtoms_Atoms_headerContentDisposition: GkAtoms_Atoms = 258;
            pub const GkAtoms_Atoms_headerContentLanguage: GkAtoms_Atoms = 259;
            pub const GkAtoms_Atoms_contentLocation: GkAtoms_Atoms = 260;
            pub const GkAtoms_Atoms_headerContentScriptType: GkAtoms_Atoms = 261;
            pub const GkAtoms_Atoms_headerContentStyleType: GkAtoms_Atoms = 262;
            pub const GkAtoms_Atoms_headerContentType: GkAtoms_Atoms = 263;
            pub const GkAtoms_Atoms_consumeanchor: GkAtoms_Atoms = 264;
            pub const GkAtoms_Atoms_context: GkAtoms_Atoms = 265;
            pub const GkAtoms_Atoms_contextmenu: GkAtoms_Atoms = 266;
            pub const GkAtoms_Atoms_control: GkAtoms_Atoms = 267;
            pub const GkAtoms_Atoms_controlBar: GkAtoms_Atoms = 268;
            pub const GkAtoms_Atoms_controls: GkAtoms_Atoms = 269;
            pub const GkAtoms_Atoms_coords: GkAtoms_Atoms = 270;
            pub const GkAtoms_Atoms_copy: GkAtoms_Atoms = 271;
            pub const GkAtoms_Atoms_copyOf: GkAtoms_Atoms = 272;
            pub const GkAtoms_Atoms_count: GkAtoms_Atoms = 273;
            pub const GkAtoms_Atoms_crop: GkAtoms_Atoms = 274;
            pub const GkAtoms_Atoms_crossorigin: GkAtoms_Atoms = 275;
            pub const GkAtoms_Atoms_curpos: GkAtoms_Atoms = 276;
            pub const GkAtoms_Atoms_current: GkAtoms_Atoms = 277;
            pub const GkAtoms_Atoms_cutoutregion: GkAtoms_Atoms = 278;
            pub const GkAtoms_Atoms_cycler: GkAtoms_Atoms = 279;
            pub const GkAtoms_Atoms_dashed: GkAtoms_Atoms = 280;
            pub const GkAtoms_Atoms_data: GkAtoms_Atoms = 281;
            pub const GkAtoms_Atoms_dataAtShortcutkeys: GkAtoms_Atoms = 282;
            pub const GkAtoms_Atoms_datalist: GkAtoms_Atoms = 283;
            pub const GkAtoms_Atoms_datal10nid: GkAtoms_Atoms = 284;
            pub const GkAtoms_Atoms_datal10nargs: GkAtoms_Atoms = 285;
            pub const GkAtoms_Atoms_datal10nattrs: GkAtoms_Atoms = 286;
            pub const GkAtoms_Atoms_datal10nname: GkAtoms_Atoms = 287;
            pub const GkAtoms_Atoms_datal10nsync: GkAtoms_Atoms = 288;
            pub const GkAtoms_Atoms_dataType: GkAtoms_Atoms = 289;
            pub const GkAtoms_Atoms_dateTime: GkAtoms_Atoms = 290;
            pub const GkAtoms_Atoms_date: GkAtoms_Atoms = 291;
            pub const GkAtoms_Atoms_datetime: GkAtoms_Atoms = 292;
            pub const GkAtoms_Atoms_datetime_local: GkAtoms_Atoms = 293;
            pub const GkAtoms_Atoms_datetimeInputBoxWrapper: GkAtoms_Atoms = 294;
            pub const GkAtoms_Atoms_dd: GkAtoms_Atoms = 295;
            pub const GkAtoms_Atoms_decimal: GkAtoms_Atoms = 296;
            pub const GkAtoms_Atoms_decimalFormat: GkAtoms_Atoms = 297;
            pub const GkAtoms_Atoms_decimalSeparator: GkAtoms_Atoms = 298;
            pub const GkAtoms_Atoms_declare: GkAtoms_Atoms = 299;
            pub const GkAtoms_Atoms_decoderDoctor: GkAtoms_Atoms = 300;
            pub const GkAtoms_Atoms_decoding: GkAtoms_Atoms = 301;
            pub const GkAtoms_Atoms_decrement: GkAtoms_Atoms = 302;
            pub const GkAtoms_Atoms__default: GkAtoms_Atoms = 303;
            pub const GkAtoms_Atoms_headerDefaultStyle: GkAtoms_Atoms = 304;
            pub const GkAtoms_Atoms_defer: GkAtoms_Atoms = 305;
            pub const GkAtoms_Atoms_del: GkAtoms_Atoms = 306;
            pub const GkAtoms_Atoms_delegatesanchor: GkAtoms_Atoms = 307;
            pub const GkAtoms_Atoms_deletion: GkAtoms_Atoms = 308;
            pub const GkAtoms_Atoms_deprecation: GkAtoms_Atoms = 309;
            pub const GkAtoms_Atoms_descendant: GkAtoms_Atoms = 310;
            pub const GkAtoms_Atoms_descendantOrSelf: GkAtoms_Atoms = 311;
            pub const GkAtoms_Atoms_descending: GkAtoms_Atoms = 312;
            pub const GkAtoms_Atoms_description: GkAtoms_Atoms = 313;
            pub const GkAtoms_Atoms_destructor: GkAtoms_Atoms = 314;
            pub const GkAtoms_Atoms_details: GkAtoms_Atoms = 315;
            pub const GkAtoms_Atoms_details_from: GkAtoms_Atoms = 316;
            pub const GkAtoms_Atoms_deviceAspectRatio: GkAtoms_Atoms = 317;
            pub const GkAtoms_Atoms_deviceHeight: GkAtoms_Atoms = 318;
            pub const GkAtoms_Atoms_devicePixelRatio: GkAtoms_Atoms = 319;
            pub const GkAtoms_Atoms_deviceWidth: GkAtoms_Atoms = 320;
            pub const GkAtoms_Atoms_dfn: GkAtoms_Atoms = 321;
            pub const GkAtoms_Atoms_dialog: GkAtoms_Atoms = 322;
            pub const GkAtoms_Atoms_difference: GkAtoms_Atoms = 323;
            pub const GkAtoms_Atoms_digit: GkAtoms_Atoms = 324;
            pub const GkAtoms_Atoms_dir: GkAtoms_Atoms = 325;
            pub const GkAtoms_Atoms_directory: GkAtoms_Atoms = 326;
            pub const GkAtoms_Atoms_dirname: GkAtoms_Atoms = 327;
            pub const GkAtoms_Atoms_disableOutputEscaping: GkAtoms_Atoms = 328;
            pub const GkAtoms_Atoms_disabled: GkAtoms_Atoms = 329;
            pub const GkAtoms_Atoms_disableglobalhistory: GkAtoms_Atoms = 330;
            pub const GkAtoms_Atoms_disablehistory: GkAtoms_Atoms = 331;
            pub const GkAtoms_Atoms_disablefullscreen: GkAtoms_Atoms = 332;
            pub const GkAtoms_Atoms_disablepictureinpicture: GkAtoms_Atoms = 333;
            pub const GkAtoms_Atoms_disclosure_closed: GkAtoms_Atoms = 334;
            pub const GkAtoms_Atoms_disclosure_open: GkAtoms_Atoms = 335;
            pub const GkAtoms_Atoms_display: GkAtoms_Atoms = 336;
            pub const GkAtoms_Atoms_displayMode: GkAtoms_Atoms = 337;
            pub const GkAtoms_Atoms_distinct: GkAtoms_Atoms = 338;
            pub const GkAtoms_Atoms_div: GkAtoms_Atoms = 339;
            pub const GkAtoms_Atoms_dl: GkAtoms_Atoms = 340;
            pub const GkAtoms_Atoms_docAbstract: GkAtoms_Atoms = 341;
            pub const GkAtoms_Atoms_docAcknowledgments: GkAtoms_Atoms = 342;
            pub const GkAtoms_Atoms_docAfterword: GkAtoms_Atoms = 343;
            pub const GkAtoms_Atoms_docAppendix: GkAtoms_Atoms = 344;
            pub const GkAtoms_Atoms_docBacklink: GkAtoms_Atoms = 345;
            pub const GkAtoms_Atoms_docBiblioentry: GkAtoms_Atoms = 346;
            pub const GkAtoms_Atoms_docBibliography: GkAtoms_Atoms = 347;
            pub const GkAtoms_Atoms_docBiblioref: GkAtoms_Atoms = 348;
            pub const GkAtoms_Atoms_docChapter: GkAtoms_Atoms = 349;
            pub const GkAtoms_Atoms_docColophon: GkAtoms_Atoms = 350;
            pub const GkAtoms_Atoms_docConclusion: GkAtoms_Atoms = 351;
            pub const GkAtoms_Atoms_docCover: GkAtoms_Atoms = 352;
            pub const GkAtoms_Atoms_docCredit: GkAtoms_Atoms = 353;
            pub const GkAtoms_Atoms_docCredits: GkAtoms_Atoms = 354;
            pub const GkAtoms_Atoms_docDedication: GkAtoms_Atoms = 355;
            pub const GkAtoms_Atoms_docEndnote: GkAtoms_Atoms = 356;
            pub const GkAtoms_Atoms_docEndnotes: GkAtoms_Atoms = 357;
            pub const GkAtoms_Atoms_docEpigraph: GkAtoms_Atoms = 358;
            pub const GkAtoms_Atoms_docEpilogue: GkAtoms_Atoms = 359;
            pub const GkAtoms_Atoms_docErrata: GkAtoms_Atoms = 360;
            pub const GkAtoms_Atoms_docExample: GkAtoms_Atoms = 361;
            pub const GkAtoms_Atoms_docFootnote: GkAtoms_Atoms = 362;
            pub const GkAtoms_Atoms_docForeword: GkAtoms_Atoms = 363;
            pub const GkAtoms_Atoms_docGlossary: GkAtoms_Atoms = 364;
            pub const GkAtoms_Atoms_docGlossref: GkAtoms_Atoms = 365;
            pub const GkAtoms_Atoms_docIndex: GkAtoms_Atoms = 366;
            pub const GkAtoms_Atoms_docIntroduction: GkAtoms_Atoms = 367;
            pub const GkAtoms_Atoms_docNoteref: GkAtoms_Atoms = 368;
            pub const GkAtoms_Atoms_docNotice: GkAtoms_Atoms = 369;
            pub const GkAtoms_Atoms_docPagebreak: GkAtoms_Atoms = 370;
            pub const GkAtoms_Atoms_docPagefooter: GkAtoms_Atoms = 371;
            pub const GkAtoms_Atoms_docPageheader: GkAtoms_Atoms = 372;
            pub const GkAtoms_Atoms_docPagelist: GkAtoms_Atoms = 373;
            pub const GkAtoms_Atoms_docPart: GkAtoms_Atoms = 374;
            pub const GkAtoms_Atoms_docPreface: GkAtoms_Atoms = 375;
            pub const GkAtoms_Atoms_docPrologue: GkAtoms_Atoms = 376;
            pub const GkAtoms_Atoms_docPullquote: GkAtoms_Atoms = 377;
            pub const GkAtoms_Atoms_docQna: GkAtoms_Atoms = 378;
            pub const GkAtoms_Atoms_docSubtitle: GkAtoms_Atoms = 379;
            pub const GkAtoms_Atoms_docTip: GkAtoms_Atoms = 380;
            pub const GkAtoms_Atoms_docToc: GkAtoms_Atoms = 381;
            pub const GkAtoms_Atoms_doctypePublic: GkAtoms_Atoms = 382;
            pub const GkAtoms_Atoms_doctypeSystem: GkAtoms_Atoms = 383;
            pub const GkAtoms_Atoms_document: GkAtoms_Atoms = 384;
            pub const GkAtoms_Atoms_down: GkAtoms_Atoms = 385;
            pub const GkAtoms_Atoms_download: GkAtoms_Atoms = 386;
            pub const GkAtoms_Atoms_drag: GkAtoms_Atoms = 387;
            pub const GkAtoms_Atoms_draggable: GkAtoms_Atoms = 388;
            pub const GkAtoms_Atoms_dragging: GkAtoms_Atoms = 389;
            pub const GkAtoms_Atoms_dragSession: GkAtoms_Atoms = 390;
            pub const GkAtoms_Atoms_dropAfter: GkAtoms_Atoms = 391;
            pub const GkAtoms_Atoms_dropBefore: GkAtoms_Atoms = 392;
            pub const GkAtoms_Atoms_dropOn: GkAtoms_Atoms = 393;
            pub const GkAtoms_Atoms_dropMarker: GkAtoms_Atoms = 394;
            pub const GkAtoms_Atoms_dt: GkAtoms_Atoms = 395;
            pub const GkAtoms_Atoms_e: GkAtoms_Atoms = 396;
            pub const GkAtoms_Atoms_editable: GkAtoms_Atoms = 397;
            pub const GkAtoms_Atoms_editing: GkAtoms_Atoms = 398;
            pub const GkAtoms_Atoms_editor: GkAtoms_Atoms = 399;
            pub const GkAtoms_Atoms_element: GkAtoms_Atoms = 400;
            pub const GkAtoms_Atoms_elementAvailable: GkAtoms_Atoms = 401;
            pub const GkAtoms_Atoms_elements: GkAtoms_Atoms = 402;
            pub const GkAtoms_Atoms_em: GkAtoms_Atoms = 403;
            pub const GkAtoms_Atoms_embed: GkAtoms_Atoms = 404;
            pub const GkAtoms_Atoms_emphasis: GkAtoms_Atoms = 405;
            pub const GkAtoms_Atoms_empty: GkAtoms_Atoms = 406;
            pub const GkAtoms_Atoms_encoding: GkAtoms_Atoms = 407;
            pub const GkAtoms_Atoms_enctype: GkAtoms_Atoms = 408;
            pub const GkAtoms_Atoms_end: GkAtoms_Atoms = 409;
            pub const GkAtoms_Atoms_endEvent: GkAtoms_Atoms = 410;
            pub const GkAtoms_Atoms_enterkeyhint: GkAtoms_Atoms = 411;
            pub const GkAtoms_Atoms_error: GkAtoms_Atoms = 412;
            pub const GkAtoms_Atoms_ethiopic_numeric: GkAtoms_Atoms = 413;
            pub const GkAtoms_Atoms_even: GkAtoms_Atoms = 414;
            pub const GkAtoms_Atoms_event: GkAtoms_Atoms = 415;
            pub const GkAtoms_Atoms_events: GkAtoms_Atoms = 416;
            pub const GkAtoms_Atoms_excludeResultPrefixes: GkAtoms_Atoms = 417;
            pub const GkAtoms_Atoms_exportparts: GkAtoms_Atoms = 418;
            pub const GkAtoms_Atoms_explicit_name: GkAtoms_Atoms = 419;
            pub const GkAtoms_Atoms_extends: GkAtoms_Atoms = 420;
            pub const GkAtoms_Atoms_extensionElementPrefixes: GkAtoms_Atoms = 421;
            pub const GkAtoms_Atoms_face: GkAtoms_Atoms = 422;
            pub const GkAtoms_Atoms_fallback: GkAtoms_Atoms = 423;
            pub const GkAtoms_Atoms__false: GkAtoms_Atoms = 424;
            pub const GkAtoms_Atoms_farthest: GkAtoms_Atoms = 425;
            pub const GkAtoms_Atoms_featurePolicyViolation: GkAtoms_Atoms = 426;
            pub const GkAtoms_Atoms_fetchpriority: GkAtoms_Atoms = 427;
            pub const GkAtoms_Atoms_field: GkAtoms_Atoms = 428;
            pub const GkAtoms_Atoms_fieldset: GkAtoms_Atoms = 429;
            pub const GkAtoms_Atoms_file: GkAtoms_Atoms = 430;
            pub const GkAtoms_Atoms_figcaption: GkAtoms_Atoms = 431;
            pub const GkAtoms_Atoms_figure: GkAtoms_Atoms = 432;
            pub const GkAtoms_Atoms_findbar: GkAtoms_Atoms = 433;
            pub const GkAtoms_Atoms_firstColumn: GkAtoms_Atoms = 434;
            pub const GkAtoms_Atoms_firstInput: GkAtoms_Atoms = 435;
            pub const GkAtoms_Atoms_fixed: GkAtoms_Atoms = 436;
            pub const GkAtoms_Atoms_flags: GkAtoms_Atoms = 437;
            pub const GkAtoms_Atoms_flex: GkAtoms_Atoms = 438;
            pub const GkAtoms_Atoms_flip: GkAtoms_Atoms = 439;
            pub const GkAtoms_Atoms_floor: GkAtoms_Atoms = 440;
            pub const GkAtoms_Atoms_flowlength: GkAtoms_Atoms = 441;
            pub const GkAtoms_Atoms_focus: GkAtoms_Atoms = 442;
            pub const GkAtoms_Atoms_focused: GkAtoms_Atoms = 443;
            pub const GkAtoms_Atoms_followanchor: GkAtoms_Atoms = 444;
            pub const GkAtoms_Atoms_following: GkAtoms_Atoms = 445;
            pub const GkAtoms_Atoms_followingSibling: GkAtoms_Atoms = 446;
            pub const GkAtoms_Atoms_font: GkAtoms_Atoms = 447;
            pub const GkAtoms_Atoms_footer: GkAtoms_Atoms = 448;
            pub const GkAtoms_Atoms__for: GkAtoms_Atoms = 449;
            pub const GkAtoms_Atoms_forEach: GkAtoms_Atoms = 450;
            pub const GkAtoms_Atoms_forcedColors: GkAtoms_Atoms = 451;
            pub const GkAtoms_Atoms_invertedColors: GkAtoms_Atoms = 452;
            pub const GkAtoms_Atoms_forceOwnRefreshDriver: GkAtoms_Atoms = 453;
            pub const GkAtoms_Atoms_form: GkAtoms_Atoms = 454;
            pub const GkAtoms_Atoms_formaction: GkAtoms_Atoms = 455;
            pub const GkAtoms_Atoms_format: GkAtoms_Atoms = 456;
            pub const GkAtoms_Atoms_formatNumber: GkAtoms_Atoms = 457;
            pub const GkAtoms_Atoms_formenctype: GkAtoms_Atoms = 458;
            pub const GkAtoms_Atoms_formmethod: GkAtoms_Atoms = 459;
            pub const GkAtoms_Atoms_formnovalidate: GkAtoms_Atoms = 460;
            pub const GkAtoms_Atoms_formtarget: GkAtoms_Atoms = 461;
            pub const GkAtoms_Atoms_frame: GkAtoms_Atoms = 462;
            pub const GkAtoms_Atoms_frameborder: GkAtoms_Atoms = 463;
            pub const GkAtoms_Atoms_frameset: GkAtoms_Atoms = 464;
            pub const GkAtoms_Atoms_from: GkAtoms_Atoms = 465;
            pub const GkAtoms_Atoms_fullscreenchange: GkAtoms_Atoms = 466;
            pub const GkAtoms_Atoms_fullscreenerror: GkAtoms_Atoms = 467;
            pub const GkAtoms_Atoms_functionAvailable: GkAtoms_Atoms = 468;
            pub const GkAtoms_Atoms_generateId: GkAtoms_Atoms = 469;
            pub const GkAtoms_Atoms_generic: GkAtoms_Atoms = 470;
            pub const GkAtoms_Atoms_getter: GkAtoms_Atoms = 471;
            pub const GkAtoms_Atoms_graphicsDocument: GkAtoms_Atoms = 472;
            pub const GkAtoms_Atoms_graphicsObject: GkAtoms_Atoms = 473;
            pub const GkAtoms_Atoms_graphicsSymbol: GkAtoms_Atoms = 474;
            pub const GkAtoms_Atoms_grid: GkAtoms_Atoms = 475;
            pub const GkAtoms_Atoms_group: GkAtoms_Atoms = 476;
            pub const GkAtoms_Atoms_groups: GkAtoms_Atoms = 477;
            pub const GkAtoms_Atoms_groupbox: GkAtoms_Atoms = 478;
            pub const GkAtoms_Atoms_groupingSeparator: GkAtoms_Atoms = 479;
            pub const GkAtoms_Atoms_groupingSize: GkAtoms_Atoms = 480;
            pub const GkAtoms_Atoms_grow: GkAtoms_Atoms = 481;
            pub const GkAtoms_Atoms_h1: GkAtoms_Atoms = 482;
            pub const GkAtoms_Atoms_h2: GkAtoms_Atoms = 483;
            pub const GkAtoms_Atoms_h3: GkAtoms_Atoms = 484;
            pub const GkAtoms_Atoms_h4: GkAtoms_Atoms = 485;
            pub const GkAtoms_Atoms_h5: GkAtoms_Atoms = 486;
            pub const GkAtoms_Atoms_h6: GkAtoms_Atoms = 487;
            pub const GkAtoms_Atoms_hairline: GkAtoms_Atoms = 488;
            pub const GkAtoms_Atoms_handheldFriendly: GkAtoms_Atoms = 489;
            pub const GkAtoms_Atoms_handler: GkAtoms_Atoms = 490;
            pub const GkAtoms_Atoms_handlers: GkAtoms_Atoms = 491;
            pub const GkAtoms_Atoms_HARD: GkAtoms_Atoms = 492;
            pub const GkAtoms_Atoms_hasActions: GkAtoms_Atoms = 493;
            pub const GkAtoms_Atoms_hasSameNode: GkAtoms_Atoms = 494;
            pub const GkAtoms_Atoms_hbox: GkAtoms_Atoms = 495;
            pub const GkAtoms_Atoms_head: GkAtoms_Atoms = 496;
            pub const GkAtoms_Atoms_header: GkAtoms_Atoms = 497;
            pub const GkAtoms_Atoms_headers: GkAtoms_Atoms = 498;
            pub const GkAtoms_Atoms_hebrew: GkAtoms_Atoms = 499;
            pub const GkAtoms_Atoms_height: GkAtoms_Atoms = 500;
            pub const GkAtoms_Atoms_hgroup: GkAtoms_Atoms = 501;
            pub const GkAtoms_Atoms_hidden: GkAtoms_Atoms = 502;
            pub const GkAtoms_Atoms_hidechrome: GkAtoms_Atoms = 503;
            pub const GkAtoms_Atoms_hidecolumnpicker: GkAtoms_Atoms = 504;
            pub const GkAtoms_Atoms_hidetitlebarseparator: GkAtoms_Atoms = 505;
            pub const GkAtoms_Atoms_hide_popover: GkAtoms_Atoms = 506;
            pub const GkAtoms_Atoms_high: GkAtoms_Atoms = 507;
            pub const GkAtoms_Atoms_highest: GkAtoms_Atoms = 508;
            pub const GkAtoms_Atoms_horizontal: GkAtoms_Atoms = 509;
            pub const GkAtoms_Atoms_hover: GkAtoms_Atoms = 510;
            pub const GkAtoms_Atoms_hr: GkAtoms_Atoms = 511;
            pub const GkAtoms_Atoms_href: GkAtoms_Atoms = 512;
            pub const GkAtoms_Atoms_hreflang: GkAtoms_Atoms = 513;
            pub const GkAtoms_Atoms_hsides: GkAtoms_Atoms = 514;
            pub const GkAtoms_Atoms_hspace: GkAtoms_Atoms = 515;
            pub const GkAtoms_Atoms_html: GkAtoms_Atoms = 516;
            pub const GkAtoms_Atoms_httpEquiv: GkAtoms_Atoms = 517;
            pub const GkAtoms_Atoms_i: GkAtoms_Atoms = 518;
            pub const GkAtoms_Atoms_icon: GkAtoms_Atoms = 519;
            pub const GkAtoms_Atoms_id: GkAtoms_Atoms = 520;
            pub const GkAtoms_Atoms__if: GkAtoms_Atoms = 521;
            pub const GkAtoms_Atoms_iframe: GkAtoms_Atoms = 522;
            pub const GkAtoms_Atoms_ignorekeys: GkAtoms_Atoms = 523;
            pub const GkAtoms_Atoms_ignoreuserfocus: GkAtoms_Atoms = 524;
            pub const GkAtoms_Atoms_image: GkAtoms_Atoms = 525;
            pub const GkAtoms_Atoms_imageClickedPoint: GkAtoms_Atoms = 526;
            pub const GkAtoms_Atoms_imagesizes: GkAtoms_Atoms = 527;
            pub const GkAtoms_Atoms_imagesrcset: GkAtoms_Atoms = 528;
            pub const GkAtoms_Atoms_img: GkAtoms_Atoms = 529;
            pub const GkAtoms_Atoms_implementation: GkAtoms_Atoms = 530;
            pub const GkAtoms_Atoms_implements: GkAtoms_Atoms = 531;
            pub const GkAtoms_Atoms_import: GkAtoms_Atoms = 532;
            pub const GkAtoms_Atoms_include: GkAtoms_Atoms = 533;
            pub const GkAtoms_Atoms_includes: GkAtoms_Atoms = 534;
            pub const GkAtoms_Atoms_incontentshell: GkAtoms_Atoms = 535;
            pub const GkAtoms_Atoms_increment: GkAtoms_Atoms = 536;
            pub const GkAtoms_Atoms_indent: GkAtoms_Atoms = 537;
            pub const GkAtoms_Atoms_indeterminate: GkAtoms_Atoms = 538;
            pub const GkAtoms_Atoms_index: GkAtoms_Atoms = 539;
            pub const GkAtoms_Atoms_inert: GkAtoms_Atoms = 540;
            pub const GkAtoms_Atoms_innerHTML: GkAtoms_Atoms = 541;
            pub const GkAtoms_Atoms_innerText: GkAtoms_Atoms = 542;
            pub const GkAtoms_Atoms_infinity: GkAtoms_Atoms = 543;
            pub const GkAtoms_Atoms_inherits: GkAtoms_Atoms = 544;
            pub const GkAtoms_Atoms_inheritOverflow: GkAtoms_Atoms = 545;
            pub const GkAtoms_Atoms_inheritstyle: GkAtoms_Atoms = 546;
            pub const GkAtoms_Atoms_initial_scale: GkAtoms_Atoms = 547;
            pub const GkAtoms_Atoms_input: GkAtoms_Atoms = 548;
            pub const GkAtoms_Atoms_inputmode: GkAtoms_Atoms = 549;
            pub const GkAtoms_Atoms_ins: GkAtoms_Atoms = 550;
            pub const GkAtoms_Atoms_insertafter: GkAtoms_Atoms = 551;
            pub const GkAtoms_Atoms_insertbefore: GkAtoms_Atoms = 552;
            pub const GkAtoms_Atoms_insertion: GkAtoms_Atoms = 553;
            pub const GkAtoms_Atoms_integer: GkAtoms_Atoms = 554;
            pub const GkAtoms_Atoms_integrity: GkAtoms_Atoms = 555;
            pub const GkAtoms_Atoms_interactive_widget: GkAtoms_Atoms = 556;
            pub const GkAtoms_Atoms_internal: GkAtoms_Atoms = 557;
            pub const GkAtoms_Atoms_internals: GkAtoms_Atoms = 558;
            pub const GkAtoms_Atoms_intersection: GkAtoms_Atoms = 559;
            pub const GkAtoms_Atoms_is: GkAtoms_Atoms = 560;
            pub const GkAtoms_Atoms_ismap: GkAtoms_Atoms = 561;
            pub const GkAtoms_Atoms_ispopup: GkAtoms_Atoms = 562;
            pub const GkAtoms_Atoms_itemid: GkAtoms_Atoms = 563;
            pub const GkAtoms_Atoms_itemprop: GkAtoms_Atoms = 564;
            pub const GkAtoms_Atoms_itemref: GkAtoms_Atoms = 565;
            pub const GkAtoms_Atoms_itemscope: GkAtoms_Atoms = 566;
            pub const GkAtoms_Atoms_itemtype: GkAtoms_Atoms = 567;
            pub const GkAtoms_Atoms_japanese_formal: GkAtoms_Atoms = 568;
            pub const GkAtoms_Atoms_japanese_informal: GkAtoms_Atoms = 569;
            pub const GkAtoms_Atoms_kbd: GkAtoms_Atoms = 570;
            pub const GkAtoms_Atoms_keepcurrentinview: GkAtoms_Atoms = 571;
            pub const GkAtoms_Atoms_key: GkAtoms_Atoms = 572;
            pub const GkAtoms_Atoms_keycode: GkAtoms_Atoms = 573;
            pub const GkAtoms_Atoms_keydown: GkAtoms_Atoms = 574;
            pub const GkAtoms_Atoms_keygen: GkAtoms_Atoms = 575;
            pub const GkAtoms_Atoms_keypress: GkAtoms_Atoms = 576;
            pub const GkAtoms_Atoms_keyset: GkAtoms_Atoms = 577;
            pub const GkAtoms_Atoms_keysystem: GkAtoms_Atoms = 578;
            pub const GkAtoms_Atoms_keyup: GkAtoms_Atoms = 579;
            pub const GkAtoms_Atoms_kind: GkAtoms_Atoms = 580;
            pub const GkAtoms_Atoms_korean_hangul_formal: GkAtoms_Atoms = 581;
            pub const GkAtoms_Atoms_korean_hanja_formal: GkAtoms_Atoms = 582;
            pub const GkAtoms_Atoms_korean_hanja_informal: GkAtoms_Atoms = 583;
            pub const GkAtoms_Atoms_label: GkAtoms_Atoms = 584;
            pub const GkAtoms_Atoms_lang: GkAtoms_Atoms = 585;
            pub const GkAtoms_Atoms_language: GkAtoms_Atoms = 586;
            pub const GkAtoms_Atoms_largestContentfulPaint: GkAtoms_Atoms = 587;
            pub const GkAtoms_Atoms_last: GkAtoms_Atoms = 588;
            pub const GkAtoms_Atoms_layer: GkAtoms_Atoms = 589;
            pub const GkAtoms_Atoms_LayerActivity: GkAtoms_Atoms = 590;
            pub const GkAtoms_Atoms_layout_guess: GkAtoms_Atoms = 591;
            pub const GkAtoms_Atoms_leading: GkAtoms_Atoms = 592;
            pub const GkAtoms_Atoms_leaf: GkAtoms_Atoms = 593;
            pub const GkAtoms_Atoms_left: GkAtoms_Atoms = 594;
            pub const GkAtoms_Atoms_leftmargin: GkAtoms_Atoms = 595;
            pub const GkAtoms_Atoms_legend: GkAtoms_Atoms = 596;
            pub const GkAtoms_Atoms_length: GkAtoms_Atoms = 597;
            pub const GkAtoms_Atoms_letterValue: GkAtoms_Atoms = 598;
            pub const GkAtoms_Atoms_level: GkAtoms_Atoms = 599;
            pub const GkAtoms_Atoms_lhs: GkAtoms_Atoms = 600;
            pub const GkAtoms_Atoms_li: GkAtoms_Atoms = 601;
            pub const GkAtoms_Atoms_line: GkAtoms_Atoms = 602;
            pub const GkAtoms_Atoms_link: GkAtoms_Atoms = 603;
            pub const GkAtoms_Atoms_linkset: GkAtoms_Atoms = 604;
            pub const GkAtoms_Atoms_listbox: GkAtoms_Atoms = 605;
            pub const GkAtoms_Atoms_listener: GkAtoms_Atoms = 606;
            pub const GkAtoms_Atoms_listheader: GkAtoms_Atoms = 607;
            pub const GkAtoms_Atoms_listing: GkAtoms_Atoms = 608;
            pub const GkAtoms_Atoms_listitem: GkAtoms_Atoms = 609;
            pub const GkAtoms_Atoms_load: GkAtoms_Atoms = 610;
            pub const GkAtoms_Atoms_loading: GkAtoms_Atoms = 611;
            pub const GkAtoms_Atoms_touchmode: GkAtoms_Atoms = 612;
            pub const GkAtoms_Atoms_triggeringprincipal: GkAtoms_Atoms = 613;
            pub const GkAtoms_Atoms_localedir: GkAtoms_Atoms = 614;
            pub const GkAtoms_Atoms_localName: GkAtoms_Atoms = 615;
            pub const GkAtoms_Atoms_localization: GkAtoms_Atoms = 616;
            pub const GkAtoms_Atoms_longdesc: GkAtoms_Atoms = 617;
            pub const GkAtoms_Atoms_loop_: GkAtoms_Atoms = 618;
            pub const GkAtoms_Atoms_low: GkAtoms_Atoms = 619;
            pub const GkAtoms_Atoms_lowerFirst: GkAtoms_Atoms = 620;
            pub const GkAtoms_Atoms_lowest: GkAtoms_Atoms = 621;
            pub const GkAtoms_Atoms_lowsrc: GkAtoms_Atoms = 622;
            pub const GkAtoms_Atoms_ltr: GkAtoms_Atoms = 623;
            pub const GkAtoms_Atoms_main: GkAtoms_Atoms = 624;
            pub const GkAtoms_Atoms_map: GkAtoms_Atoms = 625;
            pub const GkAtoms_Atoms_manifest: GkAtoms_Atoms = 626;
            pub const GkAtoms_Atoms_marginBottom: GkAtoms_Atoms = 627;
            pub const GkAtoms_Atoms_marginLeft: GkAtoms_Atoms = 628;
            pub const GkAtoms_Atoms_marginRight: GkAtoms_Atoms = 629;
            pub const GkAtoms_Atoms_marginTop: GkAtoms_Atoms = 630;
            pub const GkAtoms_Atoms_marginheight: GkAtoms_Atoms = 631;
            pub const GkAtoms_Atoms_marginwidth: GkAtoms_Atoms = 632;
            pub const GkAtoms_Atoms_mark: GkAtoms_Atoms = 633;
            pub const GkAtoms_Atoms_marquee: GkAtoms_Atoms = 634;
            pub const GkAtoms_Atoms_match_: GkAtoms_Atoms = 635;
            pub const GkAtoms_Atoms_max: GkAtoms_Atoms = 636;
            pub const GkAtoms_Atoms_maxheight: GkAtoms_Atoms = 637;
            pub const GkAtoms_Atoms_maximum_scale: GkAtoms_Atoms = 638;
            pub const GkAtoms_Atoms_maxlength: GkAtoms_Atoms = 639;
            pub const GkAtoms_Atoms_maxpos: GkAtoms_Atoms = 640;
            pub const GkAtoms_Atoms_maxwidth: GkAtoms_Atoms = 641;
            pub const GkAtoms_Atoms_measure: GkAtoms_Atoms = 642;
            pub const GkAtoms_Atoms_media: GkAtoms_Atoms = 643;
            pub const GkAtoms_Atoms_mediaType: GkAtoms_Atoms = 644;
            pub const GkAtoms_Atoms_menu: GkAtoms_Atoms = 645;
            pub const GkAtoms_Atoms_menubar: GkAtoms_Atoms = 646;
            pub const GkAtoms_Atoms_menucaption: GkAtoms_Atoms = 647;
            pub const GkAtoms_Atoms_menugroup: GkAtoms_Atoms = 648;
            pub const GkAtoms_Atoms_menuitem: GkAtoms_Atoms = 649;
            pub const GkAtoms_Atoms_menulist: GkAtoms_Atoms = 650;
            pub const GkAtoms_Atoms_menupopup: GkAtoms_Atoms = 651;
            pub const GkAtoms_Atoms_menuseparator: GkAtoms_Atoms = 652;
            pub const GkAtoms_Atoms_mesh: GkAtoms_Atoms = 653;
            pub const GkAtoms_Atoms_message: GkAtoms_Atoms = 654;
            pub const GkAtoms_Atoms_meta: GkAtoms_Atoms = 655;
            pub const GkAtoms_Atoms_referrer: GkAtoms_Atoms = 656;
            pub const GkAtoms_Atoms_referrerpolicy: GkAtoms_Atoms = 657;
            pub const GkAtoms_Atoms_renderroot: GkAtoms_Atoms = 658;
            pub const GkAtoms_Atoms_headerReferrerPolicy: GkAtoms_Atoms = 659;
            pub const GkAtoms_Atoms_meter: GkAtoms_Atoms = 660;
            pub const GkAtoms_Atoms_method: GkAtoms_Atoms = 661;
            pub const GkAtoms_Atoms_middle: GkAtoms_Atoms = 662;
            pub const GkAtoms_Atoms_min: GkAtoms_Atoms = 663;
            pub const GkAtoms_Atoms_minheight: GkAtoms_Atoms = 664;
            pub const GkAtoms_Atoms_minimum_scale: GkAtoms_Atoms = 665;
            pub const GkAtoms_Atoms_minlength: GkAtoms_Atoms = 666;
            pub const GkAtoms_Atoms_minpos: GkAtoms_Atoms = 667;
            pub const GkAtoms_Atoms_minusSign: GkAtoms_Atoms = 668;
            pub const GkAtoms_Atoms_minwidth: GkAtoms_Atoms = 669;
            pub const GkAtoms_Atoms_mixed: GkAtoms_Atoms = 670;
            pub const GkAtoms_Atoms_messagemanagergroup: GkAtoms_Atoms = 671;
            pub const GkAtoms_Atoms_mod_: GkAtoms_Atoms = 672;
            pub const GkAtoms_Atoms__module: GkAtoms_Atoms = 673;
            pub const GkAtoms_Atoms_mode: GkAtoms_Atoms = 674;
            pub const GkAtoms_Atoms_modifiers: GkAtoms_Atoms = 675;
            pub const GkAtoms_Atoms_monochrome: GkAtoms_Atoms = 676;
            pub const GkAtoms_Atoms_mouseover: GkAtoms_Atoms = 677;
            pub const GkAtoms_Atoms_mozAccessiblecaret: GkAtoms_Atoms = 678;
            pub const GkAtoms_Atoms_mozCustomContentContainer: GkAtoms_Atoms = 679;
            pub const GkAtoms_Atoms_mozGrabber: GkAtoms_Atoms = 680;
            pub const GkAtoms_Atoms_mozNativeAnonymous: GkAtoms_Atoms = 681;
            pub const GkAtoms_Atoms_mozprivatebrowsing: GkAtoms_Atoms = 682;
            pub const GkAtoms_Atoms_mozResizer: GkAtoms_Atoms = 683;
            pub const GkAtoms_Atoms_mozResizingInfo: GkAtoms_Atoms = 684;
            pub const GkAtoms_Atoms_mozResizingShadow: GkAtoms_Atoms = 685;
            pub const GkAtoms_Atoms_mozTableAddColumnAfter: GkAtoms_Atoms = 686;
            pub const GkAtoms_Atoms_mozTableAddColumnBefore: GkAtoms_Atoms = 687;
            pub const GkAtoms_Atoms_mozTableAddRowAfter: GkAtoms_Atoms = 688;
            pub const GkAtoms_Atoms_mozTableAddRowBefore: GkAtoms_Atoms = 689;
            pub const GkAtoms_Atoms_mozTableRemoveRow: GkAtoms_Atoms = 690;
            pub const GkAtoms_Atoms_mozTableRemoveColumn: GkAtoms_Atoms = 691;
            pub const GkAtoms_Atoms_moz_opaque: GkAtoms_Atoms = 692;
            pub const GkAtoms_Atoms_multicol: GkAtoms_Atoms = 693;
            pub const GkAtoms_Atoms_multiple: GkAtoms_Atoms = 694;
            pub const GkAtoms_Atoms_muted: GkAtoms_Atoms = 695;
            pub const GkAtoms_Atoms_name: GkAtoms_Atoms = 696;
            pub const GkAtoms_Atoms_native: GkAtoms_Atoms = 697;
            pub const GkAtoms_Atoms__namespace: GkAtoms_Atoms = 698;
            pub const GkAtoms_Atoms_namespaceAlias: GkAtoms_Atoms = 699;
            pub const GkAtoms_Atoms_namespaceUri: GkAtoms_Atoms = 700;
            pub const GkAtoms_Atoms_NaN: GkAtoms_Atoms = 701;
            pub const GkAtoms_Atoms_n: GkAtoms_Atoms = 702;
            pub const GkAtoms_Atoms_nav: GkAtoms_Atoms = 703;
            pub const GkAtoms_Atoms_ne: GkAtoms_Atoms = 704;
            pub const GkAtoms_Atoms_never: GkAtoms_Atoms = 705;
            pub const GkAtoms_Atoms_neverhidden: GkAtoms_Atoms = 706;
            pub const GkAtoms_Atoms__new: GkAtoms_Atoms = 707;
            pub const GkAtoms_Atoms_newline: GkAtoms_Atoms = 708;
            pub const GkAtoms_Atoms_nextRemoteTabId: GkAtoms_Atoms = 709;
            pub const GkAtoms_Atoms_no: GkAtoms_Atoms = 710;
            pub const GkAtoms_Atoms_noautofocus: GkAtoms_Atoms = 711;
            pub const GkAtoms_Atoms_noautohide: GkAtoms_Atoms = 712;
            pub const GkAtoms_Atoms_norolluponanchor: GkAtoms_Atoms = 713;
            pub const GkAtoms_Atoms_noBar: GkAtoms_Atoms = 714;
            pub const GkAtoms_Atoms_nobr: GkAtoms_Atoms = 715;
            pub const GkAtoms_Atoms_nodefaultsrc: GkAtoms_Atoms = 716;
            pub const GkAtoms_Atoms_nodeSet: GkAtoms_Atoms = 717;
            pub const GkAtoms_Atoms_noembed: GkAtoms_Atoms = 718;
            pub const GkAtoms_Atoms_noframes: GkAtoms_Atoms = 719;
            pub const GkAtoms_Atoms_nohref: GkAtoms_Atoms = 720;
            pub const GkAtoms_Atoms_noinitialselection: GkAtoms_Atoms = 721;
            pub const GkAtoms_Atoms_nomodule: GkAtoms_Atoms = 722;
            pub const GkAtoms_Atoms_nonce: GkAtoms_Atoms = 723;
            pub const GkAtoms_Atoms_none: GkAtoms_Atoms = 724;
            pub const GkAtoms_Atoms_noresize: GkAtoms_Atoms = 725;
            pub const GkAtoms_Atoms_normal: GkAtoms_Atoms = 726;
            pub const GkAtoms_Atoms_normalizeSpace: GkAtoms_Atoms = 727;
            pub const GkAtoms_Atoms_noscript: GkAtoms_Atoms = 728;
            pub const GkAtoms_Atoms_noshade: GkAtoms_Atoms = 729;
            pub const GkAtoms_Atoms_notification: GkAtoms_Atoms = 730;
            pub const GkAtoms_Atoms_novalidate: GkAtoms_Atoms = 731;
            pub const GkAtoms_Atoms__not: GkAtoms_Atoms = 732;
            pub const GkAtoms_Atoms_nowrap: GkAtoms_Atoms = 733;
            pub const GkAtoms_Atoms_number: GkAtoms_Atoms = 734;
            pub const GkAtoms_Atoms_nw: GkAtoms_Atoms = 735;
            pub const GkAtoms_Atoms_object: GkAtoms_Atoms = 736;
            pub const GkAtoms_Atoms_objectType: GkAtoms_Atoms = 737;
            pub const GkAtoms_Atoms_observes: GkAtoms_Atoms = 738;
            pub const GkAtoms_Atoms_odd: GkAtoms_Atoms = 739;
            pub const GkAtoms_Atoms_OFF: GkAtoms_Atoms = 740;
            pub const GkAtoms_Atoms_ol: GkAtoms_Atoms = 741;
            pub const GkAtoms_Atoms_omitXmlDeclaration: GkAtoms_Atoms = 742;
            pub const GkAtoms_Atoms_onabort: GkAtoms_Atoms = 743;
            pub const GkAtoms_Atoms_onmozaccesskeynotfound: GkAtoms_Atoms = 744;
            pub const GkAtoms_Atoms_onactivate: GkAtoms_Atoms = 745;
            pub const GkAtoms_Atoms_onafterprint: GkAtoms_Atoms = 746;
            pub const GkAtoms_Atoms_onanimationcancel: GkAtoms_Atoms = 747;
            pub const GkAtoms_Atoms_onanimationend: GkAtoms_Atoms = 748;
            pub const GkAtoms_Atoms_onanimationiteration: GkAtoms_Atoms = 749;
            pub const GkAtoms_Atoms_onanimationstart: GkAtoms_Atoms = 750;
            pub const GkAtoms_Atoms_onAppCommand: GkAtoms_Atoms = 751;
            pub const GkAtoms_Atoms_onaudioprocess: GkAtoms_Atoms = 752;
            pub const GkAtoms_Atoms_onauxclick: GkAtoms_Atoms = 753;
            pub const GkAtoms_Atoms_onbeforecopy: GkAtoms_Atoms = 754;
            pub const GkAtoms_Atoms_onbeforecut: GkAtoms_Atoms = 755;
            pub const GkAtoms_Atoms_onbeforeinput: GkAtoms_Atoms = 756;
            pub const GkAtoms_Atoms_onbeforematch: GkAtoms_Atoms = 757;
            pub const GkAtoms_Atoms_onbeforepaste: GkAtoms_Atoms = 758;
            pub const GkAtoms_Atoms_onbeforeprint: GkAtoms_Atoms = 759;
            pub const GkAtoms_Atoms_onbeforeunload: GkAtoms_Atoms = 760;
            pub const GkAtoms_Atoms_onblocked: GkAtoms_Atoms = 761;
            pub const GkAtoms_Atoms_onblur: GkAtoms_Atoms = 762;
            pub const GkAtoms_Atoms_onboundschange: GkAtoms_Atoms = 763;
            pub const GkAtoms_Atoms_onbroadcast: GkAtoms_Atoms = 764;
            pub const GkAtoms_Atoms_onbufferedamountlow: GkAtoms_Atoms = 765;
            pub const GkAtoms_Atoms_oncached: GkAtoms_Atoms = 766;
            pub const GkAtoms_Atoms_oncancel: GkAtoms_Atoms = 767;
            pub const GkAtoms_Atoms_onchange: GkAtoms_Atoms = 768;
            pub const GkAtoms_Atoms_onchargingchange: GkAtoms_Atoms = 769;
            pub const GkAtoms_Atoms_onchargingtimechange: GkAtoms_Atoms = 770;
            pub const GkAtoms_Atoms_onchecking: GkAtoms_Atoms = 771;
            pub const GkAtoms_Atoms_onCheckboxStateChange: GkAtoms_Atoms = 772;
            pub const GkAtoms_Atoms_onCheckKeyPressEventModel: GkAtoms_Atoms = 773;
            pub const GkAtoms_Atoms_onclick: GkAtoms_Atoms = 774;
            pub const GkAtoms_Atoms_onclose: GkAtoms_Atoms = 775;
            pub const GkAtoms_Atoms_onclosing: GkAtoms_Atoms = 776;
            pub const GkAtoms_Atoms_oncontentvisibilityautostatechange: GkAtoms_Atoms = 777;
            pub const GkAtoms_Atoms_oncommand: GkAtoms_Atoms = 778;
            pub const GkAtoms_Atoms_oncommandupdate: GkAtoms_Atoms = 779;
            pub const GkAtoms_Atoms_oncomplete: GkAtoms_Atoms = 780;
            pub const GkAtoms_Atoms_oncompositionend: GkAtoms_Atoms = 781;
            pub const GkAtoms_Atoms_oncompositionstart: GkAtoms_Atoms = 782;
            pub const GkAtoms_Atoms_oncompositionupdate: GkAtoms_Atoms = 783;
            pub const GkAtoms_Atoms_onconnect: GkAtoms_Atoms = 784;
            pub const GkAtoms_Atoms_onconnectionavailable: GkAtoms_Atoms = 785;
            pub const GkAtoms_Atoms_oncontextmenu: GkAtoms_Atoms = 786;
            pub const GkAtoms_Atoms_oncontextlost: GkAtoms_Atoms = 787;
            pub const GkAtoms_Atoms_oncontextrestored: GkAtoms_Atoms = 788;
            pub const GkAtoms_Atoms_oncookiechange: GkAtoms_Atoms = 789;
            pub const GkAtoms_Atoms_oncopy: GkAtoms_Atoms = 790;
            pub const GkAtoms_Atoms_oncut: GkAtoms_Atoms = 791;
            pub const GkAtoms_Atoms_oncurrententrychange: GkAtoms_Atoms = 792;
            pub const GkAtoms_Atoms_ondblclick: GkAtoms_Atoms = 793;
            pub const GkAtoms_Atoms_ondischargingtimechange: GkAtoms_Atoms = 794;
            pub const GkAtoms_Atoms_ondispose: GkAtoms_Atoms = 795;
            pub const GkAtoms_Atoms_ondownloading: GkAtoms_Atoms = 796;
            pub const GkAtoms_Atoms_onDOMActivate: GkAtoms_Atoms = 797;
            pub const GkAtoms_Atoms_onDOMFocusIn: GkAtoms_Atoms = 798;
            pub const GkAtoms_Atoms_onDOMFocusOut: GkAtoms_Atoms = 799;
            pub const GkAtoms_Atoms_onDOMMouseScroll: GkAtoms_Atoms = 800;
            pub const GkAtoms_Atoms_ondata: GkAtoms_Atoms = 801;
            pub const GkAtoms_Atoms_ondrag: GkAtoms_Atoms = 802;
            pub const GkAtoms_Atoms_ondragdrop: GkAtoms_Atoms = 803;
            pub const GkAtoms_Atoms_ondragend: GkAtoms_Atoms = 804;
            pub const GkAtoms_Atoms_ondragenter: GkAtoms_Atoms = 805;
            pub const GkAtoms_Atoms_ondragexit: GkAtoms_Atoms = 806;
            pub const GkAtoms_Atoms_ondragleave: GkAtoms_Atoms = 807;
            pub const GkAtoms_Atoms_ondragover: GkAtoms_Atoms = 808;
            pub const GkAtoms_Atoms_ondragstart: GkAtoms_Atoms = 809;
            pub const GkAtoms_Atoms_ondrain: GkAtoms_Atoms = 810;
            pub const GkAtoms_Atoms_ondrop: GkAtoms_Atoms = 811;
            pub const GkAtoms_Atoms_onerror: GkAtoms_Atoms = 812;
            pub const GkAtoms_Atoms_onfinish: GkAtoms_Atoms = 813;
            pub const GkAtoms_Atoms_onfocus: GkAtoms_Atoms = 814;
            pub const GkAtoms_Atoms_onfocusin: GkAtoms_Atoms = 815;
            pub const GkAtoms_Atoms_onfocusout: GkAtoms_Atoms = 816;
            pub const GkAtoms_Atoms_onfullscreenchange: GkAtoms_Atoms = 817;
            pub const GkAtoms_Atoms_onfullscreenerror: GkAtoms_Atoms = 818;
            pub const GkAtoms_Atoms_ongatheringstatechange: GkAtoms_Atoms = 819;
            pub const GkAtoms_Atoms_onget: GkAtoms_Atoms = 820;
            pub const GkAtoms_Atoms_onhashchange: GkAtoms_Atoms = 821;
            pub const GkAtoms_Atoms_oninput: GkAtoms_Atoms = 822;
            pub const GkAtoms_Atoms_oninputsourceschange: GkAtoms_Atoms = 823;
            pub const GkAtoms_Atoms_oninstall: GkAtoms_Atoms = 824;
            pub const GkAtoms_Atoms_oninvalid: GkAtoms_Atoms = 825;
            pub const GkAtoms_Atoms_onkeydown: GkAtoms_Atoms = 826;
            pub const GkAtoms_Atoms_onkeypress: GkAtoms_Atoms = 827;
            pub const GkAtoms_Atoms_onkeyup: GkAtoms_Atoms = 828;
            pub const GkAtoms_Atoms_onlanguagechange: GkAtoms_Atoms = 829;
            pub const GkAtoms_Atoms_onlevelchange: GkAtoms_Atoms = 830;
            pub const GkAtoms_Atoms_onload: GkAtoms_Atoms = 831;
            pub const GkAtoms_Atoms_onloading: GkAtoms_Atoms = 832;
            pub const GkAtoms_Atoms_onloadingdone: GkAtoms_Atoms = 833;
            pub const GkAtoms_Atoms_onloadingerror: GkAtoms_Atoms = 834;
            pub const GkAtoms_Atoms_onpopstate: GkAtoms_Atoms = 835;
            pub const GkAtoms_Atoms_only: GkAtoms_Atoms = 836;
            pub const GkAtoms_Atoms_onmerchantvalidation: GkAtoms_Atoms = 837;
            pub const GkAtoms_Atoms_onmessage: GkAtoms_Atoms = 838;
            pub const GkAtoms_Atoms_onmessageerror: GkAtoms_Atoms = 839;
            pub const GkAtoms_Atoms_onmidimessage: GkAtoms_Atoms = 840;
            pub const GkAtoms_Atoms_onmousedown: GkAtoms_Atoms = 841;
            pub const GkAtoms_Atoms_onmouseenter: GkAtoms_Atoms = 842;
            pub const GkAtoms_Atoms_onmouseleave: GkAtoms_Atoms = 843;
            pub const GkAtoms_Atoms_onmouselongtap: GkAtoms_Atoms = 844;
            pub const GkAtoms_Atoms_onmousemove: GkAtoms_Atoms = 845;
            pub const GkAtoms_Atoms_onmouseout: GkAtoms_Atoms = 846;
            pub const GkAtoms_Atoms_onmouseover: GkAtoms_Atoms = 847;
            pub const GkAtoms_Atoms_onMozMouseHittest: GkAtoms_Atoms = 848;
            pub const GkAtoms_Atoms_onMozMouseExploreByTouch: GkAtoms_Atoms = 849;
            pub const GkAtoms_Atoms_onmouseup: GkAtoms_Atoms = 850;
            pub const GkAtoms_Atoms_onMozAfterPaint: GkAtoms_Atoms = 851;
            pub const GkAtoms_Atoms_onmozfullscreenchange: GkAtoms_Atoms = 852;
            pub const GkAtoms_Atoms_onmozfullscreenerror: GkAtoms_Atoms = 853;
            pub const GkAtoms_Atoms_onmozpointerlockchange: GkAtoms_Atoms = 854;
            pub const GkAtoms_Atoms_onmozpointerlockerror: GkAtoms_Atoms = 855;
            pub const GkAtoms_Atoms_onMozMousePixelScroll: GkAtoms_Atoms = 856;
            pub const GkAtoms_Atoms_onMozScrolledAreaChanged: GkAtoms_Atoms = 857;
            pub const GkAtoms_Atoms_onmute: GkAtoms_Atoms = 858;
            pub const GkAtoms_Atoms_onnavigate: GkAtoms_Atoms = 859;
            pub const GkAtoms_Atoms_onnavigatesuccess: GkAtoms_Atoms = 860;
            pub const GkAtoms_Atoms_onnavigateerror: GkAtoms_Atoms = 861;
            pub const GkAtoms_Atoms_onnotificationclick: GkAtoms_Atoms = 862;
            pub const GkAtoms_Atoms_onnotificationclose: GkAtoms_Atoms = 863;
            pub const GkAtoms_Atoms_onnoupdate: GkAtoms_Atoms = 864;
            pub const GkAtoms_Atoms_onobsolete: GkAtoms_Atoms = 865;
            pub const GkAtoms_Atoms_ononline: GkAtoms_Atoms = 866;
            pub const GkAtoms_Atoms_onoffline: GkAtoms_Atoms = 867;
            pub const GkAtoms_Atoms_onopen: GkAtoms_Atoms = 868;
            pub const GkAtoms_Atoms_onorientationchange: GkAtoms_Atoms = 869;
            pub const GkAtoms_Atoms_onoverflow: GkAtoms_Atoms = 870;
            pub const GkAtoms_Atoms_onpagehide: GkAtoms_Atoms = 871;
            pub const GkAtoms_Atoms_onpageshow: GkAtoms_Atoms = 872;
            pub const GkAtoms_Atoms_onpaste: GkAtoms_Atoms = 873;
            pub const GkAtoms_Atoms_onpayerdetailchange: GkAtoms_Atoms = 874;
            pub const GkAtoms_Atoms_onpaymentmethodchange: GkAtoms_Atoms = 875;
            pub const GkAtoms_Atoms_onpointerlockchange: GkAtoms_Atoms = 876;
            pub const GkAtoms_Atoms_onpointerlockerror: GkAtoms_Atoms = 877;
            pub const GkAtoms_Atoms_onpopuphidden: GkAtoms_Atoms = 878;
            pub const GkAtoms_Atoms_onpopuphiding: GkAtoms_Atoms = 879;
            pub const GkAtoms_Atoms_onpopuppositioned: GkAtoms_Atoms = 880;
            pub const GkAtoms_Atoms_onpopupshowing: GkAtoms_Atoms = 881;
            pub const GkAtoms_Atoms_onpopupshown: GkAtoms_Atoms = 882;
            pub const GkAtoms_Atoms_onprocessorerror: GkAtoms_Atoms = 883;
            pub const GkAtoms_Atoms_onprioritychange: GkAtoms_Atoms = 884;
            pub const GkAtoms_Atoms_onpush: GkAtoms_Atoms = 885;
            pub const GkAtoms_Atoms_onpushsubscriptionchange: GkAtoms_Atoms = 886;
            pub const GkAtoms_Atoms_onRadioStateChange: GkAtoms_Atoms = 887;
            pub const GkAtoms_Atoms_onreadystatechange: GkAtoms_Atoms = 888;
            pub const GkAtoms_Atoms_onrejectionhandled: GkAtoms_Atoms = 889;
            pub const GkAtoms_Atoms_onremove: GkAtoms_Atoms = 890;
            pub const GkAtoms_Atoms_onrequestprogress: GkAtoms_Atoms = 891;
            pub const GkAtoms_Atoms_onresourcetimingbufferfull: GkAtoms_Atoms = 892;
            pub const GkAtoms_Atoms_onresponseprogress: GkAtoms_Atoms = 893;
            pub const GkAtoms_Atoms_onRequest: GkAtoms_Atoms = 894;
            pub const GkAtoms_Atoms_onreset: GkAtoms_Atoms = 895;
            pub const GkAtoms_Atoms_onresize: GkAtoms_Atoms = 896;
            pub const GkAtoms_Atoms_onscroll: GkAtoms_Atoms = 897;
            pub const GkAtoms_Atoms_onsecuritypolicyviolation: GkAtoms_Atoms = 898;
            pub const GkAtoms_Atoms_onselect: GkAtoms_Atoms = 899;
            pub const GkAtoms_Atoms_onselectionchange: GkAtoms_Atoms = 900;
            pub const GkAtoms_Atoms_onselectend: GkAtoms_Atoms = 901;
            pub const GkAtoms_Atoms_onselectstart: GkAtoms_Atoms = 902;
            pub const GkAtoms_Atoms_onset: GkAtoms_Atoms = 903;
            pub const GkAtoms_Atoms_onshippingaddresschange: GkAtoms_Atoms = 904;
            pub const GkAtoms_Atoms_onshippingoptionchange: GkAtoms_Atoms = 905;
            pub const GkAtoms_Atoms_onshow: GkAtoms_Atoms = 906;
            pub const GkAtoms_Atoms_onslotchange: GkAtoms_Atoms = 907;
            pub const GkAtoms_Atoms_onsqueeze: GkAtoms_Atoms = 908;
            pub const GkAtoms_Atoms_onsqueezeend: GkAtoms_Atoms = 909;
            pub const GkAtoms_Atoms_onsqueezestart: GkAtoms_Atoms = 910;
            pub const GkAtoms_Atoms_onstatechange: GkAtoms_Atoms = 911;
            pub const GkAtoms_Atoms_onstorage: GkAtoms_Atoms = 912;
            pub const GkAtoms_Atoms_onsubmit: GkAtoms_Atoms = 913;
            pub const GkAtoms_Atoms_onsuccess: GkAtoms_Atoms = 914;
            pub const GkAtoms_Atoms_onsystemstatusbarclick: GkAtoms_Atoms = 915;
            pub const GkAtoms_Atoms_ontypechange: GkAtoms_Atoms = 916;
            pub const GkAtoms_Atoms_onterminate: GkAtoms_Atoms = 917;
            pub const GkAtoms_Atoms_ontext: GkAtoms_Atoms = 918;
            pub const GkAtoms_Atoms_ontextInput: GkAtoms_Atoms = 919;
            pub const GkAtoms_Atoms_ontoggle: GkAtoms_Atoms = 920;
            pub const GkAtoms_Atoms_ontonechange: GkAtoms_Atoms = 921;
            pub const GkAtoms_Atoms_ontouchstart: GkAtoms_Atoms = 922;
            pub const GkAtoms_Atoms_ontouchend: GkAtoms_Atoms = 923;
            pub const GkAtoms_Atoms_ontouchmove: GkAtoms_Atoms = 924;
            pub const GkAtoms_Atoms_ontouchcancel: GkAtoms_Atoms = 925;
            pub const GkAtoms_Atoms_ontransitioncancel: GkAtoms_Atoms = 926;
            pub const GkAtoms_Atoms_ontransitionend: GkAtoms_Atoms = 927;
            pub const GkAtoms_Atoms_ontransitionrun: GkAtoms_Atoms = 928;
            pub const GkAtoms_Atoms_ontransitionstart: GkAtoms_Atoms = 929;
            pub const GkAtoms_Atoms_onuncapturederror: GkAtoms_Atoms = 930;
            pub const GkAtoms_Atoms_onunderflow: GkAtoms_Atoms = 931;
            pub const GkAtoms_Atoms_onunhandledrejection: GkAtoms_Atoms = 932;
            pub const GkAtoms_Atoms_onunload: GkAtoms_Atoms = 933;
            pub const GkAtoms_Atoms_onunmute: GkAtoms_Atoms = 934;
            pub const GkAtoms_Atoms_onupdatefound: GkAtoms_Atoms = 935;
            pub const GkAtoms_Atoms_onupdateready: GkAtoms_Atoms = 936;
            pub const GkAtoms_Atoms_onupgradeneeded: GkAtoms_Atoms = 937;
            pub const GkAtoms_Atoms_onversionchange: GkAtoms_Atoms = 938;
            pub const GkAtoms_Atoms_onvisibilitychange: GkAtoms_Atoms = 939;
            pub const GkAtoms_Atoms_onvoiceschanged: GkAtoms_Atoms = 940;
            pub const GkAtoms_Atoms_onvrdisplayactivate: GkAtoms_Atoms = 941;
            pub const GkAtoms_Atoms_onvrdisplayconnect: GkAtoms_Atoms = 942;
            pub const GkAtoms_Atoms_onvrdisplaydeactivate: GkAtoms_Atoms = 943;
            pub const GkAtoms_Atoms_onvrdisplaydisconnect: GkAtoms_Atoms = 944;
            pub const GkAtoms_Atoms_onvrdisplaypresentchange: GkAtoms_Atoms = 945;
            pub const GkAtoms_Atoms_onwebkitAnimationEnd: GkAtoms_Atoms = 946;
            pub const GkAtoms_Atoms_onwebkitAnimationIteration: GkAtoms_Atoms = 947;
            pub const GkAtoms_Atoms_onwebkitAnimationStart: GkAtoms_Atoms = 948;
            pub const GkAtoms_Atoms_onwebkitTransitionEnd: GkAtoms_Atoms = 949;
            pub const GkAtoms_Atoms_onwebkitanimationend: GkAtoms_Atoms = 950;
            pub const GkAtoms_Atoms_onwebkitanimationiteration: GkAtoms_Atoms = 951;
            pub const GkAtoms_Atoms_onwebkitanimationstart: GkAtoms_Atoms = 952;
            pub const GkAtoms_Atoms_onwebkittransitionend: GkAtoms_Atoms = 953;
            pub const GkAtoms_Atoms_onwheel: GkAtoms_Atoms = 954;
            pub const GkAtoms_Atoms_open: GkAtoms_Atoms = 955;
            pub const GkAtoms_Atoms_optgroup: GkAtoms_Atoms = 956;
            pub const GkAtoms_Atoms_optimum: GkAtoms_Atoms = 957;
            pub const GkAtoms_Atoms_option: GkAtoms_Atoms = 958;
            pub const GkAtoms_Atoms__or: GkAtoms_Atoms = 959;
            pub const GkAtoms_Atoms_order: GkAtoms_Atoms = 960;
            pub const GkAtoms_Atoms_ordinal: GkAtoms_Atoms = 961;
            pub const GkAtoms_Atoms_orient: GkAtoms_Atoms = 962;
            pub const GkAtoms_Atoms_orientation: GkAtoms_Atoms = 963;
            pub const GkAtoms_Atoms_origin_trial: GkAtoms_Atoms = 964;
            pub const GkAtoms_Atoms_otherwise: GkAtoms_Atoms = 965;
            pub const GkAtoms_Atoms_outerHTML: GkAtoms_Atoms = 966;
            pub const GkAtoms_Atoms_output: GkAtoms_Atoms = 967;
            pub const GkAtoms_Atoms_overflow: GkAtoms_Atoms = 968;
            pub const GkAtoms_Atoms_overflowBlock: GkAtoms_Atoms = 969;
            pub const GkAtoms_Atoms_overflowInline: GkAtoms_Atoms = 970;
            pub const GkAtoms_Atoms_overlay: GkAtoms_Atoms = 971;
            pub const GkAtoms_Atoms_p: GkAtoms_Atoms = 972;
            pub const GkAtoms_Atoms_pack: GkAtoms_Atoms = 973;
            pub const GkAtoms_Atoms_page: GkAtoms_Atoms = 974;
            pub const GkAtoms_Atoms_pageincrement: GkAtoms_Atoms = 975;
            pub const GkAtoms_Atoms_paint: GkAtoms_Atoms = 976;
            pub const GkAtoms_Atoms_paint_order: GkAtoms_Atoms = 977;
            pub const GkAtoms_Atoms_panel: GkAtoms_Atoms = 978;
            pub const GkAtoms_Atoms_paragraph: GkAtoms_Atoms = 979;
            pub const GkAtoms_Atoms_param: GkAtoms_Atoms = 980;
            pub const GkAtoms_Atoms_parameter: GkAtoms_Atoms = 981;
            pub const GkAtoms_Atoms_parent: GkAtoms_Atoms = 982;
            pub const GkAtoms_Atoms_parsererror: GkAtoms_Atoms = 983;
            pub const GkAtoms_Atoms_part: GkAtoms_Atoms = 984;
            pub const GkAtoms_Atoms_password: GkAtoms_Atoms = 985;
            pub const GkAtoms_Atoms_pattern: GkAtoms_Atoms = 986;
            pub const GkAtoms_Atoms_patternSeparator: GkAtoms_Atoms = 987;
            pub const GkAtoms_Atoms_perMille: GkAtoms_Atoms = 988;
            pub const GkAtoms_Atoms_percent: GkAtoms_Atoms = 989;
            pub const GkAtoms_Atoms_persist: GkAtoms_Atoms = 990;
            pub const GkAtoms_Atoms_phase: GkAtoms_Atoms = 991;
            pub const GkAtoms_Atoms_picture: GkAtoms_Atoms = 992;
            pub const GkAtoms_Atoms_ping: GkAtoms_Atoms = 993;
            pub const GkAtoms_Atoms_pinned: GkAtoms_Atoms = 994;
            pub const GkAtoms_Atoms_placeholder: GkAtoms_Atoms = 995;
            pub const GkAtoms_Atoms_plaintext: GkAtoms_Atoms = 996;
            pub const GkAtoms_Atoms_plaintextOnly: GkAtoms_Atoms = 997;
            pub const GkAtoms_Atoms_playbackrate: GkAtoms_Atoms = 998;
            pub const GkAtoms_Atoms_pointSize: GkAtoms_Atoms = 999;
            pub const GkAtoms_Atoms_poly: GkAtoms_Atoms = 1000;
            pub const GkAtoms_Atoms_polygon: GkAtoms_Atoms = 1001;
            pub const GkAtoms_Atoms_popover: GkAtoms_Atoms = 1002;
            pub const GkAtoms_Atoms_popovertarget: GkAtoms_Atoms = 1003;
            pub const GkAtoms_Atoms_popovertargetaction: GkAtoms_Atoms = 1004;
            pub const GkAtoms_Atoms_popup: GkAtoms_Atoms = 1005;
            pub const GkAtoms_Atoms_popupalign: GkAtoms_Atoms = 1006;
            pub const GkAtoms_Atoms_popupanchor: GkAtoms_Atoms = 1007;
            pub const GkAtoms_Atoms_popupgroup: GkAtoms_Atoms = 1008;
            pub const GkAtoms_Atoms_popupset: GkAtoms_Atoms = 1009;
            pub const GkAtoms_Atoms_popupsinherittooltip: GkAtoms_Atoms = 1010;
            pub const GkAtoms_Atoms_portal: GkAtoms_Atoms = 1011;
            pub const GkAtoms_Atoms_position: GkAtoms_Atoms = 1012;
            pub const GkAtoms_Atoms_poster: GkAtoms_Atoms = 1013;
            pub const GkAtoms_Atoms_pre: GkAtoms_Atoms = 1014;
            pub const GkAtoms_Atoms_preceding: GkAtoms_Atoms = 1015;
            pub const GkAtoms_Atoms_precedingSibling: GkAtoms_Atoms = 1016;
            pub const GkAtoms_Atoms_prefersReducedMotion: GkAtoms_Atoms = 1017;
            pub const GkAtoms_Atoms_prefersReducedTransparency: GkAtoms_Atoms = 1018;
            pub const GkAtoms_Atoms_prefersColorScheme: GkAtoms_Atoms = 1019;
            pub const GkAtoms_Atoms_prefersContrast: GkAtoms_Atoms = 1020;
            pub const GkAtoms_Atoms_prefix: GkAtoms_Atoms = 1021;
            pub const GkAtoms_Atoms_prefwidth: GkAtoms_Atoms = 1022;
            pub const GkAtoms_Atoms_queue: GkAtoms_Atoms = 1023;
            pub const GkAtoms_Atoms_dynamicRange: GkAtoms_Atoms = 1024;
            pub const GkAtoms_Atoms_videoDynamicRange: GkAtoms_Atoms = 1025;
            pub const GkAtoms_Atoms_scripting: GkAtoms_Atoms = 1026;
            pub const GkAtoms_Atoms_preload: GkAtoms_Atoms = 1027;
            pub const GkAtoms_Atoms_preserve: GkAtoms_Atoms = 1028;
            pub const GkAtoms_Atoms_preserveSpace: GkAtoms_Atoms = 1029;
            pub const GkAtoms_Atoms_preventdefault: GkAtoms_Atoms = 1030;
            pub const GkAtoms_Atoms_previewDiv: GkAtoms_Atoms = 1031;
            pub const GkAtoms_Atoms_primary: GkAtoms_Atoms = 1032;
            pub const GkAtoms_Atoms_print: GkAtoms_Atoms = 1033;
            pub const GkAtoms_Atoms_printisfocuseddoc: GkAtoms_Atoms = 1034;
            pub const GkAtoms_Atoms_printselectionranges: GkAtoms_Atoms = 1035;
            pub const GkAtoms_Atoms_priority: GkAtoms_Atoms = 1036;
            pub const GkAtoms_Atoms_processingInstruction: GkAtoms_Atoms = 1037;
            pub const GkAtoms_Atoms_profile: GkAtoms_Atoms = 1038;
            pub const GkAtoms_Atoms_progress: GkAtoms_Atoms = 1039;
            pub const GkAtoms_Atoms_prompt: GkAtoms_Atoms = 1040;
            pub const GkAtoms_Atoms_properties: GkAtoms_Atoms = 1041;
            pub const GkAtoms_Atoms_property: GkAtoms_Atoms = 1042;
            pub const GkAtoms_Atoms_pubdate: GkAtoms_Atoms = 1043;
            pub const GkAtoms_Atoms_q: GkAtoms_Atoms = 1044;
            pub const GkAtoms_Atoms_radio: GkAtoms_Atoms = 1045;
            pub const GkAtoms_Atoms_radioLabel: GkAtoms_Atoms = 1046;
            pub const GkAtoms_Atoms_radiogroup: GkAtoms_Atoms = 1047;
            pub const GkAtoms_Atoms_range: GkAtoms_Atoms = 1048;
            pub const GkAtoms_Atoms_rating: GkAtoms_Atoms = 1049;
            pub const GkAtoms_Atoms_readonly: GkAtoms_Atoms = 1050;
            pub const GkAtoms_Atoms_rect: GkAtoms_Atoms = 1051;
            pub const GkAtoms_Atoms_rectangle: GkAtoms_Atoms = 1052;
            pub const GkAtoms_Atoms_refresh: GkAtoms_Atoms = 1053;
            pub const GkAtoms_Atoms_rel: GkAtoms_Atoms = 1054;
            pub const GkAtoms_Atoms_relativeBounds: GkAtoms_Atoms = 1055;
            pub const GkAtoms_Atoms_rem: GkAtoms_Atoms = 1056;
            pub const GkAtoms_Atoms_remote: GkAtoms_Atoms = 1057;
            pub const GkAtoms_Atoms_removeelement: GkAtoms_Atoms = 1058;
            pub const GkAtoms_Atoms_render: GkAtoms_Atoms = 1059;
            pub const GkAtoms_Atoms_renderingobserverset: GkAtoms_Atoms = 1060;
            pub const GkAtoms_Atoms_repeat: GkAtoms_Atoms = 1061;
            pub const GkAtoms_Atoms_replace: GkAtoms_Atoms = 1062;
            pub const GkAtoms_Atoms_requestcontextid: GkAtoms_Atoms = 1063;
            pub const GkAtoms_Atoms_required: GkAtoms_Atoms = 1064;
            pub const GkAtoms_Atoms_reserved: GkAtoms_Atoms = 1065;
            pub const GkAtoms_Atoms_reset: GkAtoms_Atoms = 1066;
            pub const GkAtoms_Atoms_resizeafter: GkAtoms_Atoms = 1067;
            pub const GkAtoms_Atoms_resizebefore: GkAtoms_Atoms = 1068;
            pub const GkAtoms_Atoms_resizer: GkAtoms_Atoms = 1069;
            pub const GkAtoms_Atoms_resolution: GkAtoms_Atoms = 1070;
            pub const GkAtoms_Atoms_resources: GkAtoms_Atoms = 1071;
            pub const GkAtoms_Atoms_restrictToAdults: GkAtoms_Atoms = 1072;
            pub const GkAtoms_Atoms_result: GkAtoms_Atoms = 1073;
            pub const GkAtoms_Atoms_resultPrefix: GkAtoms_Atoms = 1074;
            pub const GkAtoms_Atoms_retargetdocumentfocus: GkAtoms_Atoms = 1075;
            pub const GkAtoms_Atoms_rev: GkAtoms_Atoms = 1076;
            pub const GkAtoms_Atoms_reverse: GkAtoms_Atoms = 1077;
            pub const GkAtoms_Atoms_reversed: GkAtoms_Atoms = 1078;
            pub const GkAtoms_Atoms_rhs: GkAtoms_Atoms = 1079;
            pub const GkAtoms_Atoms_richlistbox: GkAtoms_Atoms = 1080;
            pub const GkAtoms_Atoms_richlistitem: GkAtoms_Atoms = 1081;
            pub const GkAtoms_Atoms_right: GkAtoms_Atoms = 1082;
            pub const GkAtoms_Atoms_rightmargin: GkAtoms_Atoms = 1083;
            pub const GkAtoms_Atoms_role: GkAtoms_Atoms = 1084;
            pub const GkAtoms_Atoms_rolluponmousewheel: GkAtoms_Atoms = 1085;
            pub const GkAtoms_Atoms_round: GkAtoms_Atoms = 1086;
            pub const GkAtoms_Atoms_row: GkAtoms_Atoms = 1087;
            pub const GkAtoms_Atoms_rows: GkAtoms_Atoms = 1088;
            pub const GkAtoms_Atoms_rowspan: GkAtoms_Atoms = 1089;
            pub const GkAtoms_Atoms_rb: GkAtoms_Atoms = 1090;
            pub const GkAtoms_Atoms_rp: GkAtoms_Atoms = 1091;
            pub const GkAtoms_Atoms_rt: GkAtoms_Atoms = 1092;
            pub const GkAtoms_Atoms_rtc: GkAtoms_Atoms = 1093;
            pub const GkAtoms_Atoms_rtl: GkAtoms_Atoms = 1094;
            pub const GkAtoms_Atoms_ruby: GkAtoms_Atoms = 1095;
            pub const GkAtoms_Atoms_rubyBase: GkAtoms_Atoms = 1096;
            pub const GkAtoms_Atoms_rubyBaseContainer: GkAtoms_Atoms = 1097;
            pub const GkAtoms_Atoms_rubyText: GkAtoms_Atoms = 1098;
            pub const GkAtoms_Atoms_rubyTextContainer: GkAtoms_Atoms = 1099;
            pub const GkAtoms_Atoms_rules: GkAtoms_Atoms = 1100;
            pub const GkAtoms_Atoms_s: GkAtoms_Atoms = 1101;
            pub const GkAtoms_Atoms_safe_area_inset_top: GkAtoms_Atoms = 1102;
            pub const GkAtoms_Atoms_safe_area_inset_bottom: GkAtoms_Atoms = 1103;
            pub const GkAtoms_Atoms_safe_area_inset_left: GkAtoms_Atoms = 1104;
            pub const GkAtoms_Atoms_safe_area_inset_right: GkAtoms_Atoms = 1105;
            pub const GkAtoms_Atoms_samp: GkAtoms_Atoms = 1106;
            pub const GkAtoms_Atoms_sandbox: GkAtoms_Atoms = 1107;
            pub const GkAtoms_Atoms_sbattr: GkAtoms_Atoms = 1108;
            pub const GkAtoms_Atoms_scale: GkAtoms_Atoms = 1109;
            pub const GkAtoms_Atoms_scan: GkAtoms_Atoms = 1110;
            pub const GkAtoms_Atoms_scheme: GkAtoms_Atoms = 1111;
            pub const GkAtoms_Atoms_scope: GkAtoms_Atoms = 1112;
            pub const GkAtoms_Atoms_scoped: GkAtoms_Atoms = 1113;
            pub const GkAtoms_Atoms_screen: GkAtoms_Atoms = 1114;
            pub const GkAtoms_Atoms_screenX: GkAtoms_Atoms = 1115;
            pub const GkAtoms_Atoms_screenx: GkAtoms_Atoms = 1116;
            pub const GkAtoms_Atoms_screenY: GkAtoms_Atoms = 1117;
            pub const GkAtoms_Atoms_screeny: GkAtoms_Atoms = 1118;
            pub const GkAtoms_Atoms_script: GkAtoms_Atoms = 1119;
            pub const GkAtoms_Atoms_scrollbar: GkAtoms_Atoms = 1120;
            pub const GkAtoms_Atoms_scrollbarThumb: GkAtoms_Atoms = 1121;
            pub const GkAtoms_Atoms_scrollamount: GkAtoms_Atoms = 1122;
            pub const GkAtoms_Atoms_scrollbarbutton: GkAtoms_Atoms = 1123;
            pub const GkAtoms_Atoms_scrollbarDownBottom: GkAtoms_Atoms = 1124;
            pub const GkAtoms_Atoms_scrollbarDownTop: GkAtoms_Atoms = 1125;
            pub const GkAtoms_Atoms_scrollbarInlineSize: GkAtoms_Atoms = 1126;
            pub const GkAtoms_Atoms_scrollbarUpBottom: GkAtoms_Atoms = 1127;
            pub const GkAtoms_Atoms_scrollbarUpTop: GkAtoms_Atoms = 1128;
            pub const GkAtoms_Atoms_scrollbox: GkAtoms_Atoms = 1129;
            pub const GkAtoms_Atoms_scrollcorner: GkAtoms_Atoms = 1130;
            pub const GkAtoms_Atoms_scrolldelay: GkAtoms_Atoms = 1131;
            pub const GkAtoms_Atoms_scrolling: GkAtoms_Atoms = 1132;
            pub const GkAtoms_Atoms_scrollPosition: GkAtoms_Atoms = 1133;
            pub const GkAtoms_Atoms_se: GkAtoms_Atoms = 1134;
            pub const GkAtoms_Atoms_section: GkAtoms_Atoms = 1135;
            pub const GkAtoms_Atoms_select: GkAtoms_Atoms = 1136;
            pub const GkAtoms_Atoms_selected: GkAtoms_Atoms = 1137;
            pub const GkAtoms_Atoms_selectedIndex: GkAtoms_Atoms = 1138;
            pub const GkAtoms_Atoms_selectedindex: GkAtoms_Atoms = 1139;
            pub const GkAtoms_Atoms_selectmenu: GkAtoms_Atoms = 1140;
            pub const GkAtoms_Atoms_self_: GkAtoms_Atoms = 1141;
            pub const GkAtoms_Atoms_seltype: GkAtoms_Atoms = 1142;
            pub const GkAtoms_Atoms_setcookie: GkAtoms_Atoms = 1143;
            pub const GkAtoms_Atoms_setter: GkAtoms_Atoms = 1144;
            pub const GkAtoms_Atoms_shadow: GkAtoms_Atoms = 1145;
            pub const GkAtoms_Atoms_shadowrootreferencetarget: GkAtoms_Atoms = 1146;
            pub const GkAtoms_Atoms_shape: GkAtoms_Atoms = 1147;
            pub const GkAtoms_Atoms_show: GkAtoms_Atoms = 1148;
            pub const GkAtoms_Atoms_showcaret: GkAtoms_Atoms = 1149;
            pub const GkAtoms_Atoms_show_modal: GkAtoms_Atoms = 1150;
            pub const GkAtoms_Atoms_show_popover: GkAtoms_Atoms = 1151;
            pub const GkAtoms_Atoms_showservicesmenu: GkAtoms_Atoms = 1152;
            pub const GkAtoms_Atoms_sibling: GkAtoms_Atoms = 1153;
            pub const GkAtoms_Atoms_simple: GkAtoms_Atoms = 1154;
            pub const GkAtoms_Atoms_simp_chinese_formal: GkAtoms_Atoms = 1155;
            pub const GkAtoms_Atoms_simp_chinese_informal: GkAtoms_Atoms = 1156;
            pub const GkAtoms_Atoms_single: GkAtoms_Atoms = 1157;
            pub const GkAtoms_Atoms_size: GkAtoms_Atoms = 1158;
            pub const GkAtoms_Atoms_sizes: GkAtoms_Atoms = 1159;
            pub const GkAtoms_Atoms_sizemode: GkAtoms_Atoms = 1160;
            pub const GkAtoms_Atoms_sizetopopup: GkAtoms_Atoms = 1161;
            pub const GkAtoms_Atoms_slider: GkAtoms_Atoms = 1162;
            pub const GkAtoms_Atoms_small: GkAtoms_Atoms = 1163;
            pub const GkAtoms_Atoms_smooth: GkAtoms_Atoms = 1164;
            pub const GkAtoms_Atoms_snap: GkAtoms_Atoms = 1165;
            pub const GkAtoms_Atoms_solid: GkAtoms_Atoms = 1166;
            pub const GkAtoms_Atoms_sort: GkAtoms_Atoms = 1167;
            pub const GkAtoms_Atoms_sortActive: GkAtoms_Atoms = 1168;
            pub const GkAtoms_Atoms_sortDirection: GkAtoms_Atoms = 1169;
            pub const GkAtoms_Atoms_sorted: GkAtoms_Atoms = 1170;
            pub const GkAtoms_Atoms_sorthints: GkAtoms_Atoms = 1171;
            pub const GkAtoms_Atoms_source: GkAtoms_Atoms = 1172;
            pub const GkAtoms_Atoms_sourcetext: GkAtoms_Atoms = 1173;
            pub const GkAtoms_Atoms_space: GkAtoms_Atoms = 1174;
            pub const GkAtoms_Atoms_spacer: GkAtoms_Atoms = 1175;
            pub const GkAtoms_Atoms_span: GkAtoms_Atoms = 1176;
            pub const GkAtoms_Atoms_spellcheck: GkAtoms_Atoms = 1177;
            pub const GkAtoms_Atoms_split: GkAtoms_Atoms = 1178;
            pub const GkAtoms_Atoms_splitter: GkAtoms_Atoms = 1179;
            pub const GkAtoms_Atoms_square: GkAtoms_Atoms = 1180;
            pub const GkAtoms_Atoms_src: GkAtoms_Atoms = 1181;
            pub const GkAtoms_Atoms_srcdoc: GkAtoms_Atoms = 1182;
            pub const GkAtoms_Atoms_srclang: GkAtoms_Atoms = 1183;
            pub const GkAtoms_Atoms_srcset: GkAtoms_Atoms = 1184;
            pub const GkAtoms_Atoms_standalone: GkAtoms_Atoms = 1185;
            pub const GkAtoms_Atoms_standby: GkAtoms_Atoms = 1186;
            pub const GkAtoms_Atoms_start: GkAtoms_Atoms = 1187;
            pub const GkAtoms_Atoms_startsWith: GkAtoms_Atoms = 1188;
            pub const GkAtoms_Atoms_state: GkAtoms_Atoms = 1189;
            pub const GkAtoms_Atoms_statusbar: GkAtoms_Atoms = 1190;
            pub const GkAtoms_Atoms_step: GkAtoms_Atoms = 1191;
            pub const GkAtoms_Atoms_stop: GkAtoms_Atoms = 1192;
            pub const GkAtoms_Atoms_stretch: GkAtoms_Atoms = 1193;
            pub const GkAtoms_Atoms_strike: GkAtoms_Atoms = 1194;
            pub const GkAtoms_Atoms_string: GkAtoms_Atoms = 1195;
            pub const GkAtoms_Atoms_stringLength: GkAtoms_Atoms = 1196;
            pub const GkAtoms_Atoms_stripSpace: GkAtoms_Atoms = 1197;
            pub const GkAtoms_Atoms_strong: GkAtoms_Atoms = 1198;
            pub const GkAtoms_Atoms_style: GkAtoms_Atoms = 1199;
            pub const GkAtoms_Atoms_stylesheet: GkAtoms_Atoms = 1200;
            pub const GkAtoms_Atoms_stylesheetPrefix: GkAtoms_Atoms = 1201;
            pub const GkAtoms_Atoms_submit: GkAtoms_Atoms = 1202;
            pub const GkAtoms_Atoms_substate: GkAtoms_Atoms = 1203;
            pub const GkAtoms_Atoms_substring: GkAtoms_Atoms = 1204;
            pub const GkAtoms_Atoms_substringAfter: GkAtoms_Atoms = 1205;
            pub const GkAtoms_Atoms_substringBefore: GkAtoms_Atoms = 1206;
            pub const GkAtoms_Atoms_sub: GkAtoms_Atoms = 1207;
            pub const GkAtoms_Atoms_suggestion: GkAtoms_Atoms = 1208;
            pub const GkAtoms_Atoms_sum: GkAtoms_Atoms = 1209;
            pub const GkAtoms_Atoms_sup: GkAtoms_Atoms = 1210;
            pub const GkAtoms_Atoms_summary: GkAtoms_Atoms = 1211;
            pub const GkAtoms_Atoms_sw: GkAtoms_Atoms = 1212;
            pub const GkAtoms_Atoms_systemProperty: GkAtoms_Atoms = 1213;
            pub const GkAtoms_Atoms_tab: GkAtoms_Atoms = 1214;
            pub const GkAtoms_Atoms_tabindex: GkAtoms_Atoms = 1215;
            pub const GkAtoms_Atoms_table: GkAtoms_Atoms = 1216;
            pub const GkAtoms_Atoms_tabpanel: GkAtoms_Atoms = 1217;
            pub const GkAtoms_Atoms_tabpanels: GkAtoms_Atoms = 1218;
            pub const GkAtoms_Atoms_tag: GkAtoms_Atoms = 1219;
            pub const GkAtoms_Atoms_target: GkAtoms_Atoms = 1220;
            pub const GkAtoms_Atoms_targets: GkAtoms_Atoms = 1221;
            pub const GkAtoms_Atoms_tbody: GkAtoms_Atoms = 1222;
            pub const GkAtoms_Atoms_td: GkAtoms_Atoms = 1223;
            pub const GkAtoms_Atoms_tel: GkAtoms_Atoms = 1224;
            pub const GkAtoms_Atoms__template: GkAtoms_Atoms = 1225;
            pub const GkAtoms_Atoms_text_decoration: GkAtoms_Atoms = 1226;
            pub const GkAtoms_Atoms_terminate: GkAtoms_Atoms = 1227;
            pub const GkAtoms_Atoms_term: GkAtoms_Atoms = 1228;
            pub const GkAtoms_Atoms_test: GkAtoms_Atoms = 1229;
            pub const GkAtoms_Atoms_text: GkAtoms_Atoms = 1230;
            pub const GkAtoms_Atoms_textAlign: GkAtoms_Atoms = 1231;
            pub const GkAtoms_Atoms_textarea: GkAtoms_Atoms = 1232;
            pub const GkAtoms_Atoms_textbox: GkAtoms_Atoms = 1233;
            pub const GkAtoms_Atoms_textContent: GkAtoms_Atoms = 1234;
            pub const GkAtoms_Atoms_textLink: GkAtoms_Atoms = 1235;
            pub const GkAtoms_Atoms_textOverlay: GkAtoms_Atoms = 1236;
            pub const GkAtoms_Atoms_tfoot: GkAtoms_Atoms = 1237;
            pub const GkAtoms_Atoms_th: GkAtoms_Atoms = 1238;
            pub const GkAtoms_Atoms_thead: GkAtoms_Atoms = 1239;
            pub const GkAtoms_Atoms_thumb: GkAtoms_Atoms = 1240;
            pub const GkAtoms_Atoms_time: GkAtoms_Atoms = 1241;
            pub const GkAtoms_Atoms_title: GkAtoms_Atoms = 1242;
            pub const GkAtoms_Atoms_titletip: GkAtoms_Atoms = 1243;
            pub const GkAtoms_Atoms_toggle: GkAtoms_Atoms = 1244;
            pub const GkAtoms_Atoms_toggle_popover: GkAtoms_Atoms = 1245;
            pub const GkAtoms_Atoms_token: GkAtoms_Atoms = 1246;
            pub const GkAtoms_Atoms_tokenize: GkAtoms_Atoms = 1247;
            pub const GkAtoms_Atoms_toolbar: GkAtoms_Atoms = 1248;
            pub const GkAtoms_Atoms_toolbarbutton: GkAtoms_Atoms = 1249;
            pub const GkAtoms_Atoms_toolbaritem: GkAtoms_Atoms = 1250;
            pub const GkAtoms_Atoms_toolbarpaletteitem: GkAtoms_Atoms = 1251;
            pub const GkAtoms_Atoms_toolbox: GkAtoms_Atoms = 1252;
            pub const GkAtoms_Atoms_tooltip: GkAtoms_Atoms = 1253;
            pub const GkAtoms_Atoms_tooltiptext: GkAtoms_Atoms = 1254;
            pub const GkAtoms_Atoms_top: GkAtoms_Atoms = 1255;
            pub const GkAtoms_Atoms_topleft: GkAtoms_Atoms = 1256;
            pub const GkAtoms_Atoms_topmargin: GkAtoms_Atoms = 1257;
            pub const GkAtoms_Atoms_topright: GkAtoms_Atoms = 1258;
            pub const GkAtoms_Atoms_tr: GkAtoms_Atoms = 1259;
            pub const GkAtoms_Atoms_track: GkAtoms_Atoms = 1260;
            pub const GkAtoms_Atoms_trad_chinese_formal: GkAtoms_Atoms = 1261;
            pub const GkAtoms_Atoms_trad_chinese_informal: GkAtoms_Atoms = 1262;
            pub const GkAtoms_Atoms_trailing: GkAtoms_Atoms = 1263;
            pub const GkAtoms_Atoms_transform: GkAtoms_Atoms = 1264;
            pub const GkAtoms_Atoms_transform_3d: GkAtoms_Atoms = 1265;
            pub const GkAtoms_Atoms_transformiix: GkAtoms_Atoms = 1266;
            pub const GkAtoms_Atoms_translate: GkAtoms_Atoms = 1267;
            pub const GkAtoms_Atoms_transparent: GkAtoms_Atoms = 1268;
            pub const GkAtoms_Atoms_tree: GkAtoms_Atoms = 1269;
            pub const GkAtoms_Atoms_treecell: GkAtoms_Atoms = 1270;
            pub const GkAtoms_Atoms_treechildren: GkAtoms_Atoms = 1271;
            pub const GkAtoms_Atoms_treecol: GkAtoms_Atoms = 1272;
            pub const GkAtoms_Atoms_treecolpicker: GkAtoms_Atoms = 1273;
            pub const GkAtoms_Atoms_treecols: GkAtoms_Atoms = 1274;
            pub const GkAtoms_Atoms_treeitem: GkAtoms_Atoms = 1275;
            pub const GkAtoms_Atoms_treerow: GkAtoms_Atoms = 1276;
            pub const GkAtoms_Atoms_treeseparator: GkAtoms_Atoms = 1277;
            pub const GkAtoms_Atoms__true: GkAtoms_Atoms = 1278;
            pub const GkAtoms_Atoms_truespeed: GkAtoms_Atoms = 1279;
            pub const GkAtoms_Atoms_tt: GkAtoms_Atoms = 1280;
            pub const GkAtoms_Atoms_type_: GkAtoms_Atoms = 1281;
            pub const GkAtoms_Atoms_u: GkAtoms_Atoms = 1282;
            pub const GkAtoms_Atoms_ul: GkAtoms_Atoms = 1283;
            pub const GkAtoms_Atoms_unparsedEntityUri: GkAtoms_Atoms = 1284;
            pub const GkAtoms_Atoms_untilFound: GkAtoms_Atoms = 1285;
            pub const GkAtoms_Atoms_up: GkAtoms_Atoms = 1286;
            pub const GkAtoms_Atoms_update: GkAtoms_Atoms = 1287;
            pub const GkAtoms_Atoms_upperFirst: GkAtoms_Atoms = 1288;
            pub const GkAtoms_Atoms_use_: GkAtoms_Atoms = 1289;
            pub const GkAtoms_Atoms_useAttributeSets: GkAtoms_Atoms = 1290;
            pub const GkAtoms_Atoms_usemap: GkAtoms_Atoms = 1291;
            pub const GkAtoms_Atoms_user_scalable: GkAtoms_Atoms = 1292;
            pub const GkAtoms_Atoms_validate: GkAtoms_Atoms = 1293;
            pub const GkAtoms_Atoms_valign: GkAtoms_Atoms = 1294;
            pub const GkAtoms_Atoms_value: GkAtoms_Atoms = 1295;
            pub const GkAtoms_Atoms_values: GkAtoms_Atoms = 1296;
            pub const GkAtoms_Atoms_valueOf: GkAtoms_Atoms = 1297;
            pub const GkAtoms_Atoms_valuetype: GkAtoms_Atoms = 1298;
            pub const GkAtoms_Atoms_var: GkAtoms_Atoms = 1299;
            pub const GkAtoms_Atoms_variable: GkAtoms_Atoms = 1300;
            pub const GkAtoms_Atoms_vendor: GkAtoms_Atoms = 1301;
            pub const GkAtoms_Atoms_vendorUrl: GkAtoms_Atoms = 1302;
            pub const GkAtoms_Atoms_version: GkAtoms_Atoms = 1303;
            pub const GkAtoms_Atoms_vertical: GkAtoms_Atoms = 1304;
            pub const GkAtoms_Atoms_audio: GkAtoms_Atoms = 1305;
            pub const GkAtoms_Atoms_video: GkAtoms_Atoms = 1306;
            pub const GkAtoms_Atoms_viewport: GkAtoms_Atoms = 1307;
            pub const GkAtoms_Atoms_viewport_fit: GkAtoms_Atoms = 1308;
            pub const GkAtoms_Atoms_viewport_height: GkAtoms_Atoms = 1309;
            pub const GkAtoms_Atoms_viewport_initial_scale: GkAtoms_Atoms = 1310;
            pub const GkAtoms_Atoms_viewport_maximum_scale: GkAtoms_Atoms = 1311;
            pub const GkAtoms_Atoms_viewport_minimum_scale: GkAtoms_Atoms = 1312;
            pub const GkAtoms_Atoms_viewport_user_scalable: GkAtoms_Atoms = 1313;
            pub const GkAtoms_Atoms_viewport_width: GkAtoms_Atoms = 1314;
            pub const GkAtoms_Atoms_visibility: GkAtoms_Atoms = 1315;
            pub const GkAtoms_Atoms_visuallyselected: GkAtoms_Atoms = 1316;
            pub const GkAtoms_Atoms_vlink: GkAtoms_Atoms = 1317;
            pub const GkAtoms_Atoms__void: GkAtoms_Atoms = 1318;
            pub const GkAtoms_Atoms_vsides: GkAtoms_Atoms = 1319;
            pub const GkAtoms_Atoms_vspace: GkAtoms_Atoms = 1320;
            pub const GkAtoms_Atoms_w: GkAtoms_Atoms = 1321;
            pub const GkAtoms_Atoms_wbr: GkAtoms_Atoms = 1322;
            pub const GkAtoms_Atoms_webkitdirectory: GkAtoms_Atoms = 1323;
            pub const GkAtoms_Atoms_when: GkAtoms_Atoms = 1324;
            pub const GkAtoms_Atoms_white: GkAtoms_Atoms = 1325;
            pub const GkAtoms_Atoms_width: GkAtoms_Atoms = 1326;
            pub const GkAtoms_Atoms_willChange: GkAtoms_Atoms = 1327;
            pub const GkAtoms_Atoms_window: GkAtoms_Atoms = 1328;
            pub const GkAtoms_Atoms_headerWindowTarget: GkAtoms_Atoms = 1329;
            pub const GkAtoms_Atoms_windowtype: GkAtoms_Atoms = 1330;
            pub const GkAtoms_Atoms_withParam: GkAtoms_Atoms = 1331;
            pub const GkAtoms_Atoms_wrap: GkAtoms_Atoms = 1332;
            pub const GkAtoms_Atoms_headerDNSPrefetchControl: GkAtoms_Atoms = 1333;
            pub const GkAtoms_Atoms_headerCSP: GkAtoms_Atoms = 1334;
            pub const GkAtoms_Atoms_headerCSPReportOnly: GkAtoms_Atoms = 1335;
            pub const GkAtoms_Atoms_headerXFO: GkAtoms_Atoms = 1336;
            pub const GkAtoms_Atoms_x_western: GkAtoms_Atoms = 1337;
            pub const GkAtoms_Atoms_xml: GkAtoms_Atoms = 1338;
            pub const GkAtoms_Atoms_xml_stylesheet: GkAtoms_Atoms = 1339;
            pub const GkAtoms_Atoms_xmlns: GkAtoms_Atoms = 1340;
            pub const GkAtoms_Atoms_xmp: GkAtoms_Atoms = 1341;
            pub const GkAtoms_Atoms_xul: GkAtoms_Atoms = 1342;
            pub const GkAtoms_Atoms_yes: GkAtoms_Atoms = 1343;
            pub const GkAtoms_Atoms_z_index: GkAtoms_Atoms = 1344;
            pub const GkAtoms_Atoms_zeroDigit: GkAtoms_Atoms = 1345;
            pub const GkAtoms_Atoms_zlevel: GkAtoms_Atoms = 1346;
            pub const GkAtoms_Atoms_percentage: GkAtoms_Atoms = 1347;
            pub const GkAtoms_Atoms_A: GkAtoms_Atoms = 1348;
            pub const GkAtoms_Atoms_alignment_baseline: GkAtoms_Atoms = 1349;
            pub const GkAtoms_Atoms_amplitude: GkAtoms_Atoms = 1350;
            pub const GkAtoms_Atoms_animate: GkAtoms_Atoms = 1351;
            pub const GkAtoms_Atoms_animateColor: GkAtoms_Atoms = 1352;
            pub const GkAtoms_Atoms_animateMotion: GkAtoms_Atoms = 1353;
            pub const GkAtoms_Atoms_animateTransform: GkAtoms_Atoms = 1354;
            pub const GkAtoms_Atoms_arithmetic: GkAtoms_Atoms = 1355;
            pub const GkAtoms_Atoms_atop: GkAtoms_Atoms = 1356;
            pub const GkAtoms_Atoms_azimuth: GkAtoms_Atoms = 1357;
            pub const GkAtoms_Atoms_B: GkAtoms_Atoms = 1358;
            pub const GkAtoms_Atoms_background_color: GkAtoms_Atoms = 1359;
            pub const GkAtoms_Atoms_background_image: GkAtoms_Atoms = 1360;
            pub const GkAtoms_Atoms_baseFrequency: GkAtoms_Atoms = 1361;
            pub const GkAtoms_Atoms_baseline_shift: GkAtoms_Atoms = 1362;
            pub const GkAtoms_Atoms_bias: GkAtoms_Atoms = 1363;
            pub const GkAtoms_Atoms_caption_side: GkAtoms_Atoms = 1364;
            pub const GkAtoms_Atoms_clip_path: GkAtoms_Atoms = 1365;
            pub const GkAtoms_Atoms_clip_rule: GkAtoms_Atoms = 1366;
            pub const GkAtoms_Atoms_clipPath: GkAtoms_Atoms = 1367;
            pub const GkAtoms_Atoms_clipPathUnits: GkAtoms_Atoms = 1368;
            pub const GkAtoms_Atoms_cm: GkAtoms_Atoms = 1369;
            pub const GkAtoms_Atoms_color_burn: GkAtoms_Atoms = 1370;
            pub const GkAtoms_Atoms_color_dodge: GkAtoms_Atoms = 1371;
            pub const GkAtoms_Atoms_color_interpolation: GkAtoms_Atoms = 1372;
            pub const GkAtoms_Atoms_color_interpolation_filters: GkAtoms_Atoms = 1373;
            pub const GkAtoms_Atoms_color_profile: GkAtoms_Atoms = 1374;
            pub const GkAtoms_Atoms_cursor: GkAtoms_Atoms = 1375;
            pub const GkAtoms_Atoms_cx: GkAtoms_Atoms = 1376;
            pub const GkAtoms_Atoms_cy: GkAtoms_Atoms = 1377;
            pub const GkAtoms_Atoms_d: GkAtoms_Atoms = 1378;
            pub const GkAtoms_Atoms_darken: GkAtoms_Atoms = 1379;
            pub const GkAtoms_Atoms_defs: GkAtoms_Atoms = 1380;
            pub const GkAtoms_Atoms_deg: GkAtoms_Atoms = 1381;
            pub const GkAtoms_Atoms_desc: GkAtoms_Atoms = 1382;
            pub const GkAtoms_Atoms_diffuseConstant: GkAtoms_Atoms = 1383;
            pub const GkAtoms_Atoms_dilate: GkAtoms_Atoms = 1384;
            pub const GkAtoms_Atoms_direction: GkAtoms_Atoms = 1385;
            pub const GkAtoms_Atoms_disable: GkAtoms_Atoms = 1386;
            pub const GkAtoms_Atoms_disc: GkAtoms_Atoms = 1387;
            pub const GkAtoms_Atoms_discrete: GkAtoms_Atoms = 1388;
            pub const GkAtoms_Atoms_divisor: GkAtoms_Atoms = 1389;
            pub const GkAtoms_Atoms_dominant_baseline: GkAtoms_Atoms = 1390;
            pub const GkAtoms_Atoms_duplicate: GkAtoms_Atoms = 1391;
            pub const GkAtoms_Atoms_dx: GkAtoms_Atoms = 1392;
            pub const GkAtoms_Atoms_dy: GkAtoms_Atoms = 1393;
            pub const GkAtoms_Atoms_edgeMode: GkAtoms_Atoms = 1394;
            pub const GkAtoms_Atoms_ellipse: GkAtoms_Atoms = 1395;
            pub const GkAtoms_Atoms_elevation: GkAtoms_Atoms = 1396;
            pub const GkAtoms_Atoms_erode: GkAtoms_Atoms = 1397;
            pub const GkAtoms_Atoms_ex: GkAtoms_Atoms = 1398;
            pub const GkAtoms_Atoms_exact: GkAtoms_Atoms = 1399;
            pub const GkAtoms_Atoms_exclusion: GkAtoms_Atoms = 1400;
            pub const GkAtoms_Atoms_exponent: GkAtoms_Atoms = 1401;
            pub const GkAtoms_Atoms_feBlend: GkAtoms_Atoms = 1402;
            pub const GkAtoms_Atoms_feColorMatrix: GkAtoms_Atoms = 1403;
            pub const GkAtoms_Atoms_feComponentTransfer: GkAtoms_Atoms = 1404;
            pub const GkAtoms_Atoms_feComposite: GkAtoms_Atoms = 1405;
            pub const GkAtoms_Atoms_feConvolveMatrix: GkAtoms_Atoms = 1406;
            pub const GkAtoms_Atoms_feDiffuseLighting: GkAtoms_Atoms = 1407;
            pub const GkAtoms_Atoms_feDisplacementMap: GkAtoms_Atoms = 1408;
            pub const GkAtoms_Atoms_feDistantLight: GkAtoms_Atoms = 1409;
            pub const GkAtoms_Atoms_feDropShadow: GkAtoms_Atoms = 1410;
            pub const GkAtoms_Atoms_feFlood: GkAtoms_Atoms = 1411;
            pub const GkAtoms_Atoms_feFuncA: GkAtoms_Atoms = 1412;
            pub const GkAtoms_Atoms_feFuncB: GkAtoms_Atoms = 1413;
            pub const GkAtoms_Atoms_feFuncG: GkAtoms_Atoms = 1414;
            pub const GkAtoms_Atoms_feFuncR: GkAtoms_Atoms = 1415;
            pub const GkAtoms_Atoms_feGaussianBlur: GkAtoms_Atoms = 1416;
            pub const GkAtoms_Atoms_feImage: GkAtoms_Atoms = 1417;
            pub const GkAtoms_Atoms_feMerge: GkAtoms_Atoms = 1418;
            pub const GkAtoms_Atoms_feMergeNode: GkAtoms_Atoms = 1419;
            pub const GkAtoms_Atoms_feMorphology: GkAtoms_Atoms = 1420;
            pub const GkAtoms_Atoms_feOffset: GkAtoms_Atoms = 1421;
            pub const GkAtoms_Atoms_fePointLight: GkAtoms_Atoms = 1422;
            pub const GkAtoms_Atoms_feSpecularLighting: GkAtoms_Atoms = 1423;
            pub const GkAtoms_Atoms_feSpotLight: GkAtoms_Atoms = 1424;
            pub const GkAtoms_Atoms_feTile: GkAtoms_Atoms = 1425;
            pub const GkAtoms_Atoms_feTurbulence: GkAtoms_Atoms = 1426;
            pub const GkAtoms_Atoms_fill: GkAtoms_Atoms = 1427;
            pub const GkAtoms_Atoms_fill_opacity: GkAtoms_Atoms = 1428;
            pub const GkAtoms_Atoms_fill_rule: GkAtoms_Atoms = 1429;
            pub const GkAtoms_Atoms_filter: GkAtoms_Atoms = 1430;
            pub const GkAtoms_Atoms_filterUnits: GkAtoms_Atoms = 1431;
            pub const GkAtoms_Atoms__float: GkAtoms_Atoms = 1432;
            pub const GkAtoms_Atoms_flood_color: GkAtoms_Atoms = 1433;
            pub const GkAtoms_Atoms_flood_opacity: GkAtoms_Atoms = 1434;
            pub const GkAtoms_Atoms_font_face: GkAtoms_Atoms = 1435;
            pub const GkAtoms_Atoms_font_face_format: GkAtoms_Atoms = 1436;
            pub const GkAtoms_Atoms_font_face_name: GkAtoms_Atoms = 1437;
            pub const GkAtoms_Atoms_font_face_src: GkAtoms_Atoms = 1438;
            pub const GkAtoms_Atoms_font_face_uri: GkAtoms_Atoms = 1439;
            pub const GkAtoms_Atoms_font_family: GkAtoms_Atoms = 1440;
            pub const GkAtoms_Atoms_font_size: GkAtoms_Atoms = 1441;
            pub const GkAtoms_Atoms_font_size_adjust: GkAtoms_Atoms = 1442;
            pub const GkAtoms_Atoms_font_stretch: GkAtoms_Atoms = 1443;
            pub const GkAtoms_Atoms_font_style: GkAtoms_Atoms = 1444;
            pub const GkAtoms_Atoms_font_variant: GkAtoms_Atoms = 1445;
            pub const GkAtoms_Atoms_font_weight: GkAtoms_Atoms = 1446;
            pub const GkAtoms_Atoms_formatting: GkAtoms_Atoms = 1447;
            pub const GkAtoms_Atoms_foreignObject: GkAtoms_Atoms = 1448;
            pub const GkAtoms_Atoms_fractalNoise: GkAtoms_Atoms = 1449;
            pub const GkAtoms_Atoms_fr: GkAtoms_Atoms = 1450;
            pub const GkAtoms_Atoms_fx: GkAtoms_Atoms = 1451;
            pub const GkAtoms_Atoms_fy: GkAtoms_Atoms = 1452;
            pub const GkAtoms_Atoms_G: GkAtoms_Atoms = 1453;
            pub const GkAtoms_Atoms_g: GkAtoms_Atoms = 1454;
            pub const GkAtoms_Atoms_gamma: GkAtoms_Atoms = 1455;
            pub const GkAtoms_Atoms_glyphRef: GkAtoms_Atoms = 1456;
            pub const GkAtoms_Atoms_grad: GkAtoms_Atoms = 1457;
            pub const GkAtoms_Atoms_gradientTransform: GkAtoms_Atoms = 1458;
            pub const GkAtoms_Atoms_gradientUnits: GkAtoms_Atoms = 1459;
            pub const GkAtoms_Atoms_hardLight: GkAtoms_Atoms = 1460;
            pub const GkAtoms_Atoms_hue: GkAtoms_Atoms = 1461;
            pub const GkAtoms_Atoms_hueRotate: GkAtoms_Atoms = 1462;
            pub const GkAtoms_Atoms_identity: GkAtoms_Atoms = 1463;
            pub const GkAtoms_Atoms_image_rendering: GkAtoms_Atoms = 1464;
            pub const GkAtoms_Atoms_in_: GkAtoms_Atoms = 1465;
            pub const GkAtoms_Atoms_in2: GkAtoms_Atoms = 1466;
            pub const GkAtoms_Atoms_intercept: GkAtoms_Atoms = 1467;
            pub const GkAtoms_Atoms_k1: GkAtoms_Atoms = 1468;
            pub const GkAtoms_Atoms_k2: GkAtoms_Atoms = 1469;
            pub const GkAtoms_Atoms_k3: GkAtoms_Atoms = 1470;
            pub const GkAtoms_Atoms_k4: GkAtoms_Atoms = 1471;
            pub const GkAtoms_Atoms_kernelMatrix: GkAtoms_Atoms = 1472;
            pub const GkAtoms_Atoms_kernelUnitLength: GkAtoms_Atoms = 1473;
            pub const GkAtoms_Atoms_lengthAdjust: GkAtoms_Atoms = 1474;
            pub const GkAtoms_Atoms_letter_spacing: GkAtoms_Atoms = 1475;
            pub const GkAtoms_Atoms_lighten: GkAtoms_Atoms = 1476;
            pub const GkAtoms_Atoms_lighter: GkAtoms_Atoms = 1477;
            pub const GkAtoms_Atoms_lighting_color: GkAtoms_Atoms = 1478;
            pub const GkAtoms_Atoms_limitingConeAngle: GkAtoms_Atoms = 1479;
            pub const GkAtoms_Atoms_linear: GkAtoms_Atoms = 1480;
            pub const GkAtoms_Atoms_linearGradient: GkAtoms_Atoms = 1481;
            pub const GkAtoms_Atoms_list_item: GkAtoms_Atoms = 1482;
            pub const GkAtoms_Atoms_list_style_type: GkAtoms_Atoms = 1483;
            pub const GkAtoms_Atoms_luminanceToAlpha: GkAtoms_Atoms = 1484;
            pub const GkAtoms_Atoms_luminosity: GkAtoms_Atoms = 1485;
            pub const GkAtoms_Atoms_magnify: GkAtoms_Atoms = 1486;
            pub const GkAtoms_Atoms_marker: GkAtoms_Atoms = 1487;
            pub const GkAtoms_Atoms_marker_end: GkAtoms_Atoms = 1488;
            pub const GkAtoms_Atoms_marker_mid: GkAtoms_Atoms = 1489;
            pub const GkAtoms_Atoms_marker_start: GkAtoms_Atoms = 1490;
            pub const GkAtoms_Atoms_markerHeight: GkAtoms_Atoms = 1491;
            pub const GkAtoms_Atoms_markerUnits: GkAtoms_Atoms = 1492;
            pub const GkAtoms_Atoms_markerWidth: GkAtoms_Atoms = 1493;
            pub const GkAtoms_Atoms_mask: GkAtoms_Atoms = 1494;
            pub const GkAtoms_Atoms_maskContentUnits: GkAtoms_Atoms = 1495;
            pub const GkAtoms_Atoms_mask_type: GkAtoms_Atoms = 1496;
            pub const GkAtoms_Atoms_maskUnits: GkAtoms_Atoms = 1497;
            pub const GkAtoms_Atoms_matrix: GkAtoms_Atoms = 1498;
            pub const GkAtoms_Atoms_metadata: GkAtoms_Atoms = 1499;
            pub const GkAtoms_Atoms_missingGlyph: GkAtoms_Atoms = 1500;
            pub const GkAtoms_Atoms_mm: GkAtoms_Atoms = 1501;
            pub const GkAtoms_Atoms_mpath: GkAtoms_Atoms = 1502;
            pub const GkAtoms_Atoms_noStitch: GkAtoms_Atoms = 1503;
            pub const GkAtoms_Atoms_numOctaves: GkAtoms_Atoms = 1504;
            pub const GkAtoms_Atoms_multiply: GkAtoms_Atoms = 1505;
            pub const GkAtoms_Atoms_objectBoundingBox: GkAtoms_Atoms = 1506;
            pub const GkAtoms_Atoms_offset: GkAtoms_Atoms = 1507;
            pub const GkAtoms_Atoms_onSVGLoad: GkAtoms_Atoms = 1508;
            pub const GkAtoms_Atoms_onSVGScroll: GkAtoms_Atoms = 1509;
            pub const GkAtoms_Atoms_onzoom: GkAtoms_Atoms = 1510;
            pub const GkAtoms_Atoms_opacity: GkAtoms_Atoms = 1511;
            pub const GkAtoms_Atoms__operator: GkAtoms_Atoms = 1512;
            pub const GkAtoms_Atoms_out: GkAtoms_Atoms = 1513;
            pub const GkAtoms_Atoms_over: GkAtoms_Atoms = 1514;
            pub const GkAtoms_Atoms_overridePreserveAspectRatio: GkAtoms_Atoms = 1515;
            pub const GkAtoms_Atoms_pad: GkAtoms_Atoms = 1516;
            pub const GkAtoms_Atoms_path: GkAtoms_Atoms = 1517;
            pub const GkAtoms_Atoms_pathLength: GkAtoms_Atoms = 1518;
            pub const GkAtoms_Atoms_patternContentUnits: GkAtoms_Atoms = 1519;
            pub const GkAtoms_Atoms_patternTransform: GkAtoms_Atoms = 1520;
            pub const GkAtoms_Atoms_patternUnits: GkAtoms_Atoms = 1521;
            pub const GkAtoms_Atoms_pc: GkAtoms_Atoms = 1522;
            pub const GkAtoms_Atoms_pointer: GkAtoms_Atoms = 1523;
            pub const GkAtoms_Atoms_pointer_events: GkAtoms_Atoms = 1524;
            pub const GkAtoms_Atoms_points: GkAtoms_Atoms = 1525;
            pub const GkAtoms_Atoms_pointsAtX: GkAtoms_Atoms = 1526;
            pub const GkAtoms_Atoms_pointsAtY: GkAtoms_Atoms = 1527;
            pub const GkAtoms_Atoms_pointsAtZ: GkAtoms_Atoms = 1528;
            pub const GkAtoms_Atoms_polyline: GkAtoms_Atoms = 1529;
            pub const GkAtoms_Atoms_preserveAlpha: GkAtoms_Atoms = 1530;
            pub const GkAtoms_Atoms_preserveAspectRatio: GkAtoms_Atoms = 1531;
            pub const GkAtoms_Atoms_primitiveUnits: GkAtoms_Atoms = 1532;
            pub const GkAtoms_Atoms_pt: GkAtoms_Atoms = 1533;
            pub const GkAtoms_Atoms_px: GkAtoms_Atoms = 1534;
            pub const GkAtoms_Atoms_R: GkAtoms_Atoms = 1535;
            pub const GkAtoms_Atoms_r: GkAtoms_Atoms = 1536;
            pub const GkAtoms_Atoms_rad: GkAtoms_Atoms = 1537;
            pub const GkAtoms_Atoms_radialGradient: GkAtoms_Atoms = 1538;
            pub const GkAtoms_Atoms_radius: GkAtoms_Atoms = 1539;
            pub const GkAtoms_Atoms_reflect: GkAtoms_Atoms = 1540;
            pub const GkAtoms_Atoms_refX: GkAtoms_Atoms = 1541;
            pub const GkAtoms_Atoms_refY: GkAtoms_Atoms = 1542;
            pub const GkAtoms_Atoms_requiredExtensions: GkAtoms_Atoms = 1543;
            pub const GkAtoms_Atoms_requiredFeatures: GkAtoms_Atoms = 1544;
            pub const GkAtoms_Atoms_rotate: GkAtoms_Atoms = 1545;
            pub const GkAtoms_Atoms_rx: GkAtoms_Atoms = 1546;
            pub const GkAtoms_Atoms_ry: GkAtoms_Atoms = 1547;
            pub const GkAtoms_Atoms_saturate: GkAtoms_Atoms = 1548;
            pub const GkAtoms_Atoms_saturation: GkAtoms_Atoms = 1549;
            pub const GkAtoms_Atoms_set: GkAtoms_Atoms = 1550;
            pub const GkAtoms_Atoms_seed: GkAtoms_Atoms = 1551;
            pub const GkAtoms_Atoms_shape_rendering: GkAtoms_Atoms = 1552;
            pub const GkAtoms_Atoms_simpleScopeChain: GkAtoms_Atoms = 1553;
            pub const GkAtoms_Atoms_skewX: GkAtoms_Atoms = 1554;
            pub const GkAtoms_Atoms_skewY: GkAtoms_Atoms = 1555;
            pub const GkAtoms_Atoms_slope: GkAtoms_Atoms = 1556;
            pub const GkAtoms_Atoms_slot: GkAtoms_Atoms = 1557;
            pub const GkAtoms_Atoms_softLight: GkAtoms_Atoms = 1558;
            pub const GkAtoms_Atoms_spacing: GkAtoms_Atoms = 1559;
            pub const GkAtoms_Atoms_spacingAndGlyphs: GkAtoms_Atoms = 1560;
            pub const GkAtoms_Atoms_specularConstant: GkAtoms_Atoms = 1561;
            pub const GkAtoms_Atoms_specularExponent: GkAtoms_Atoms = 1562;
            pub const GkAtoms_Atoms_spreadMethod: GkAtoms_Atoms = 1563;
            pub const GkAtoms_Atoms_startOffset: GkAtoms_Atoms = 1564;
            pub const GkAtoms_Atoms_stdDeviation: GkAtoms_Atoms = 1565;
            pub const GkAtoms_Atoms_stitch: GkAtoms_Atoms = 1566;
            pub const GkAtoms_Atoms_stitchTiles: GkAtoms_Atoms = 1567;
            pub const GkAtoms_Atoms_stop_color: GkAtoms_Atoms = 1568;
            pub const GkAtoms_Atoms_stop_opacity: GkAtoms_Atoms = 1569;
            pub const GkAtoms_Atoms_stroke: GkAtoms_Atoms = 1570;
            pub const GkAtoms_Atoms_stroke_dasharray: GkAtoms_Atoms = 1571;
            pub const GkAtoms_Atoms_stroke_dashoffset: GkAtoms_Atoms = 1572;
            pub const GkAtoms_Atoms_stroke_linecap: GkAtoms_Atoms = 1573;
            pub const GkAtoms_Atoms_stroke_linejoin: GkAtoms_Atoms = 1574;
            pub const GkAtoms_Atoms_stroke_miterlimit: GkAtoms_Atoms = 1575;
            pub const GkAtoms_Atoms_stroke_opacity: GkAtoms_Atoms = 1576;
            pub const GkAtoms_Atoms_stroke_width: GkAtoms_Atoms = 1577;
            pub const GkAtoms_Atoms_strokeWidth: GkAtoms_Atoms = 1578;
            pub const GkAtoms_Atoms_surfaceScale: GkAtoms_Atoms = 1579;
            pub const GkAtoms_Atoms_svg: GkAtoms_Atoms = 1580;
            pub const GkAtoms_Atoms_svgSwitch: GkAtoms_Atoms = 1581;
            pub const GkAtoms_Atoms_symbol: GkAtoms_Atoms = 1582;
            pub const GkAtoms_Atoms_systemLanguage: GkAtoms_Atoms = 1583;
            pub const GkAtoms_Atoms_tableValues: GkAtoms_Atoms = 1584;
            pub const GkAtoms_Atoms_targetX: GkAtoms_Atoms = 1585;
            pub const GkAtoms_Atoms_targetY: GkAtoms_Atoms = 1586;
            pub const GkAtoms_Atoms_text_anchor: GkAtoms_Atoms = 1587;
            pub const GkAtoms_Atoms_text_overflow: GkAtoms_Atoms = 1588;
            pub const GkAtoms_Atoms_text_rendering: GkAtoms_Atoms = 1589;
            pub const GkAtoms_Atoms_textLength: GkAtoms_Atoms = 1590;
            pub const GkAtoms_Atoms_textPath: GkAtoms_Atoms = 1591;
            pub const GkAtoms_Atoms_transform_origin: GkAtoms_Atoms = 1592;
            pub const GkAtoms_Atoms_tref: GkAtoms_Atoms = 1593;
            pub const GkAtoms_Atoms_tspan: GkAtoms_Atoms = 1594;
            pub const GkAtoms_Atoms_turbulence: GkAtoms_Atoms = 1595;
            pub const GkAtoms_Atoms_unicode_bidi: GkAtoms_Atoms = 1596;
            pub const GkAtoms_Atoms_userSpaceOnUse: GkAtoms_Atoms = 1597;
            pub const GkAtoms_Atoms_view: GkAtoms_Atoms = 1598;
            pub const GkAtoms_Atoms_viewBox: GkAtoms_Atoms = 1599;
            pub const GkAtoms_Atoms_viewTarget: GkAtoms_Atoms = 1600;
            pub const GkAtoms_Atoms_white_space: GkAtoms_Atoms = 1601;
            pub const GkAtoms_Atoms_windowsmica: GkAtoms_Atoms = 1602;
            pub const GkAtoms_Atoms_word_spacing: GkAtoms_Atoms = 1603;
            pub const GkAtoms_Atoms_writing_mode: GkAtoms_Atoms = 1604;
            pub const GkAtoms_Atoms_x: GkAtoms_Atoms = 1605;
            pub const GkAtoms_Atoms_x1: GkAtoms_Atoms = 1606;
            pub const GkAtoms_Atoms_x2: GkAtoms_Atoms = 1607;
            pub const GkAtoms_Atoms_xChannelSelector: GkAtoms_Atoms = 1608;
            pub const GkAtoms_Atoms_xor_: GkAtoms_Atoms = 1609;
            pub const GkAtoms_Atoms_y: GkAtoms_Atoms = 1610;
            pub const GkAtoms_Atoms_y1: GkAtoms_Atoms = 1611;
            pub const GkAtoms_Atoms_y2: GkAtoms_Atoms = 1612;
            pub const GkAtoms_Atoms_yChannelSelector: GkAtoms_Atoms = 1613;
            pub const GkAtoms_Atoms_z: GkAtoms_Atoms = 1614;
            pub const GkAtoms_Atoms_zoomAndPan: GkAtoms_Atoms = 1615;
            pub const GkAtoms_Atoms_vector_effect: GkAtoms_Atoms = 1616;
            pub const GkAtoms_Atoms_vertical_align: GkAtoms_Atoms = 1617;
            pub const GkAtoms_Atoms_accumulate: GkAtoms_Atoms = 1618;
            pub const GkAtoms_Atoms_additive: GkAtoms_Atoms = 1619;
            pub const GkAtoms_Atoms_attributeName: GkAtoms_Atoms = 1620;
            pub const GkAtoms_Atoms_attributeType: GkAtoms_Atoms = 1621;
            pub const GkAtoms_Atoms_auto_reverse: GkAtoms_Atoms = 1622;
            pub const GkAtoms_Atoms_begin: GkAtoms_Atoms = 1623;
            pub const GkAtoms_Atoms_beginEvent: GkAtoms_Atoms = 1624;
            pub const GkAtoms_Atoms_by: GkAtoms_Atoms = 1625;
            pub const GkAtoms_Atoms_calcMode: GkAtoms_Atoms = 1626;
            pub const GkAtoms_Atoms_dur: GkAtoms_Atoms = 1627;
            pub const GkAtoms_Atoms_keyPoints: GkAtoms_Atoms = 1628;
            pub const GkAtoms_Atoms_keySplines: GkAtoms_Atoms = 1629;
            pub const GkAtoms_Atoms_keyTimes: GkAtoms_Atoms = 1630;
            pub const GkAtoms_Atoms_mozAnimateMotionDummyAttr: GkAtoms_Atoms = 1631;
            pub const GkAtoms_Atoms_onbegin: GkAtoms_Atoms = 1632;
            pub const GkAtoms_Atoms_onbeginEvent: GkAtoms_Atoms = 1633;
            pub const GkAtoms_Atoms_onend: GkAtoms_Atoms = 1634;
            pub const GkAtoms_Atoms_onendEvent: GkAtoms_Atoms = 1635;
            pub const GkAtoms_Atoms_onrelease: GkAtoms_Atoms = 1636;
            pub const GkAtoms_Atoms_onrepeat: GkAtoms_Atoms = 1637;
            pub const GkAtoms_Atoms_onrepeatEvent: GkAtoms_Atoms = 1638;
            pub const GkAtoms_Atoms_repeatCount: GkAtoms_Atoms = 1639;
            pub const GkAtoms_Atoms_repeatDur: GkAtoms_Atoms = 1640;
            pub const GkAtoms_Atoms_repeatEvent: GkAtoms_Atoms = 1641;
            pub const GkAtoms_Atoms_restart: GkAtoms_Atoms = 1642;
            pub const GkAtoms_Atoms_to: GkAtoms_Atoms = 1643;
            pub const GkAtoms_Atoms_abs: GkAtoms_Atoms = 1644;
            pub const GkAtoms_Atoms_accent: GkAtoms_Atoms = 1645;
            pub const GkAtoms_Atoms_accentunder: GkAtoms_Atoms = 1646;
            pub const GkAtoms_Atoms_actiontype: GkAtoms_Atoms = 1647;
            pub const GkAtoms_Atoms_alignmentscope: GkAtoms_Atoms = 1648;
            pub const GkAtoms_Atoms_altimg: GkAtoms_Atoms = 1649;
            pub const GkAtoms_Atoms_altimg_height: GkAtoms_Atoms = 1650;
            pub const GkAtoms_Atoms_altimg_valign: GkAtoms_Atoms = 1651;
            pub const GkAtoms_Atoms_altimg_width: GkAtoms_Atoms = 1652;
            pub const GkAtoms_Atoms_annotation: GkAtoms_Atoms = 1653;
            pub const GkAtoms_Atoms_annotation_xml: GkAtoms_Atoms = 1654;
            pub const GkAtoms_Atoms_apply: GkAtoms_Atoms = 1655;
            pub const GkAtoms_Atoms_approx: GkAtoms_Atoms = 1656;
            pub const GkAtoms_Atoms_arccos: GkAtoms_Atoms = 1657;
            pub const GkAtoms_Atoms_arccosh: GkAtoms_Atoms = 1658;
            pub const GkAtoms_Atoms_arccot: GkAtoms_Atoms = 1659;
            pub const GkAtoms_Atoms_arccoth: GkAtoms_Atoms = 1660;
            pub const GkAtoms_Atoms_arccsc: GkAtoms_Atoms = 1661;
            pub const GkAtoms_Atoms_arccsch: GkAtoms_Atoms = 1662;
            pub const GkAtoms_Atoms_arcsec: GkAtoms_Atoms = 1663;
            pub const GkAtoms_Atoms_arcsech: GkAtoms_Atoms = 1664;
            pub const GkAtoms_Atoms_arcsin: GkAtoms_Atoms = 1665;
            pub const GkAtoms_Atoms_arcsinh: GkAtoms_Atoms = 1666;
            pub const GkAtoms_Atoms_arctan: GkAtoms_Atoms = 1667;
            pub const GkAtoms_Atoms_arctanh: GkAtoms_Atoms = 1668;
            pub const GkAtoms_Atoms_arg: GkAtoms_Atoms = 1669;
            pub const GkAtoms_Atoms_bevelled: GkAtoms_Atoms = 1670;
            pub const GkAtoms_Atoms_bind: GkAtoms_Atoms = 1671;
            pub const GkAtoms_Atoms_bvar: GkAtoms_Atoms = 1672;
            pub const GkAtoms_Atoms_card: GkAtoms_Atoms = 1673;
            pub const GkAtoms_Atoms_cartesianproduct: GkAtoms_Atoms = 1674;
            pub const GkAtoms_Atoms_cbytes: GkAtoms_Atoms = 1675;
            pub const GkAtoms_Atoms_cd: GkAtoms_Atoms = 1676;
            pub const GkAtoms_Atoms_cdgroup: GkAtoms_Atoms = 1677;
            pub const GkAtoms_Atoms_cerror: GkAtoms_Atoms = 1678;
            pub const GkAtoms_Atoms_charalign: GkAtoms_Atoms = 1679;
            pub const GkAtoms_Atoms_ci: GkAtoms_Atoms = 1680;
            pub const GkAtoms_Atoms_closure: GkAtoms_Atoms = 1681;
            pub const GkAtoms_Atoms_cn: GkAtoms_Atoms = 1682;
            pub const GkAtoms_Atoms_codomain: GkAtoms_Atoms = 1683;
            pub const GkAtoms_Atoms_columnalign: GkAtoms_Atoms = 1684;
            pub const GkAtoms_Atoms_columnalignment: GkAtoms_Atoms = 1685;
            pub const GkAtoms_Atoms_columnlines: GkAtoms_Atoms = 1686;
            pub const GkAtoms_Atoms_columnspacing: GkAtoms_Atoms = 1687;
            pub const GkAtoms_Atoms_columnspan: GkAtoms_Atoms = 1688;
            pub const GkAtoms_Atoms_columnwidth: GkAtoms_Atoms = 1689;
            pub const GkAtoms_Atoms_complexes: GkAtoms_Atoms = 1690;
            pub const GkAtoms_Atoms_compose: GkAtoms_Atoms = 1691;
            pub const GkAtoms_Atoms_condition: GkAtoms_Atoms = 1692;
            pub const GkAtoms_Atoms_conjugate: GkAtoms_Atoms = 1693;
            pub const GkAtoms_Atoms_cos: GkAtoms_Atoms = 1694;
            pub const GkAtoms_Atoms_cosh: GkAtoms_Atoms = 1695;
            pub const GkAtoms_Atoms_cot: GkAtoms_Atoms = 1696;
            pub const GkAtoms_Atoms_coth: GkAtoms_Atoms = 1697;
            pub const GkAtoms_Atoms_crossout: GkAtoms_Atoms = 1698;
            pub const GkAtoms_Atoms_csc: GkAtoms_Atoms = 1699;
            pub const GkAtoms_Atoms_csch: GkAtoms_Atoms = 1700;
            pub const GkAtoms_Atoms_cs: GkAtoms_Atoms = 1701;
            pub const GkAtoms_Atoms_csymbol: GkAtoms_Atoms = 1702;
            pub const GkAtoms_Atoms_csp: GkAtoms_Atoms = 1703;
            pub const GkAtoms_Atoms_cspViolation: GkAtoms_Atoms = 1704;
            pub const GkAtoms_Atoms_curl: GkAtoms_Atoms = 1705;
            pub const GkAtoms_Atoms_decimalpoint: GkAtoms_Atoms = 1706;
            pub const GkAtoms_Atoms_definition: GkAtoms_Atoms = 1707;
            pub const GkAtoms_Atoms_definitionURL: GkAtoms_Atoms = 1708;
            pub const GkAtoms_Atoms_degree: GkAtoms_Atoms = 1709;
            pub const GkAtoms_Atoms_denomalign: GkAtoms_Atoms = 1710;
            pub const GkAtoms_Atoms_depth: GkAtoms_Atoms = 1711;
            pub const GkAtoms_Atoms_determinant: GkAtoms_Atoms = 1712;
            pub const GkAtoms_Atoms_diff: GkAtoms_Atoms = 1713;
            pub const GkAtoms_Atoms_displaystyle: GkAtoms_Atoms = 1714;
            pub const GkAtoms_Atoms_divergence: GkAtoms_Atoms = 1715;
            pub const GkAtoms_Atoms_divide: GkAtoms_Atoms = 1716;
            pub const GkAtoms_Atoms_dom_viewTransitions_enabled: GkAtoms_Atoms = 1717;
            pub const GkAtoms_Atoms_domain: GkAtoms_Atoms = 1718;
            pub const GkAtoms_Atoms_domainofapplication: GkAtoms_Atoms = 1719;
            pub const GkAtoms_Atoms_edge: GkAtoms_Atoms = 1720;
            pub const GkAtoms_Atoms_el: GkAtoms_Atoms = 1721;
            pub const GkAtoms_Atoms_emptyset: GkAtoms_Atoms = 1722;
            pub const GkAtoms_Atoms_eq: GkAtoms_Atoms = 1723;
            pub const GkAtoms_Atoms_equalcolumns: GkAtoms_Atoms = 1724;
            pub const GkAtoms_Atoms_equalrows: GkAtoms_Atoms = 1725;
            pub const GkAtoms_Atoms_equivalent: GkAtoms_Atoms = 1726;
            pub const GkAtoms_Atoms_eulergamma: GkAtoms_Atoms = 1727;
            pub const GkAtoms_Atoms_exists: GkAtoms_Atoms = 1728;
            pub const GkAtoms_Atoms_exp: GkAtoms_Atoms = 1729;
            pub const GkAtoms_Atoms_exponentiale: GkAtoms_Atoms = 1730;
            pub const GkAtoms_Atoms_factorial: GkAtoms_Atoms = 1731;
            pub const GkAtoms_Atoms_factorof: GkAtoms_Atoms = 1732;
            pub const GkAtoms_Atoms_fence: GkAtoms_Atoms = 1733;
            pub const GkAtoms_Atoms_fn_: GkAtoms_Atoms = 1734;
            pub const GkAtoms_Atoms_fontfamily: GkAtoms_Atoms = 1735;
            pub const GkAtoms_Atoms_fontsize: GkAtoms_Atoms = 1736;
            pub const GkAtoms_Atoms_fontstyle: GkAtoms_Atoms = 1737;
            pub const GkAtoms_Atoms_fontweight: GkAtoms_Atoms = 1738;
            pub const GkAtoms_Atoms_forall: GkAtoms_Atoms = 1739;
            pub const GkAtoms_Atoms_framespacing: GkAtoms_Atoms = 1740;
            pub const GkAtoms_Atoms_gcd: GkAtoms_Atoms = 1741;
            pub const GkAtoms_Atoms_geq: GkAtoms_Atoms = 1742;
            pub const GkAtoms_Atoms_groupalign: GkAtoms_Atoms = 1743;
            pub const GkAtoms_Atoms_gt: GkAtoms_Atoms = 1744;
            pub const GkAtoms_Atoms_ident: GkAtoms_Atoms = 1745;
            pub const GkAtoms_Atoms_imaginaryi: GkAtoms_Atoms = 1746;
            pub const GkAtoms_Atoms_imaginary: GkAtoms_Atoms = 1747;
            pub const GkAtoms_Atoms_implies: GkAtoms_Atoms = 1748;
            pub const GkAtoms_Atoms_indentalignfirst: GkAtoms_Atoms = 1749;
            pub const GkAtoms_Atoms_indentalign: GkAtoms_Atoms = 1750;
            pub const GkAtoms_Atoms_indentalignlast: GkAtoms_Atoms = 1751;
            pub const GkAtoms_Atoms_indentshiftfirst: GkAtoms_Atoms = 1752;
            pub const GkAtoms_Atoms_indentshift: GkAtoms_Atoms = 1753;
            pub const GkAtoms_Atoms_indenttarget: GkAtoms_Atoms = 1754;
            pub const GkAtoms_Atoms_integers: GkAtoms_Atoms = 1755;
            pub const GkAtoms_Atoms_intersect: GkAtoms_Atoms = 1756;
            pub const GkAtoms_Atoms_interval: GkAtoms_Atoms = 1757;
            pub const GkAtoms_Atoms_int_: GkAtoms_Atoms = 1758;
            pub const GkAtoms_Atoms_inverse: GkAtoms_Atoms = 1759;
            pub const GkAtoms_Atoms_lambda: GkAtoms_Atoms = 1760;
            pub const GkAtoms_Atoms_laplacian: GkAtoms_Atoms = 1761;
            pub const GkAtoms_Atoms_largeop: GkAtoms_Atoms = 1762;
            pub const GkAtoms_Atoms_lcm: GkAtoms_Atoms = 1763;
            pub const GkAtoms_Atoms_leq: GkAtoms_Atoms = 1764;
            pub const GkAtoms_Atoms_limit: GkAtoms_Atoms = 1765;
            pub const GkAtoms_Atoms_linebreak: GkAtoms_Atoms = 1766;
            pub const GkAtoms_Atoms_linebreakmultchar: GkAtoms_Atoms = 1767;
            pub const GkAtoms_Atoms_linebreakstyle: GkAtoms_Atoms = 1768;
            pub const GkAtoms_Atoms_linethickness: GkAtoms_Atoms = 1769;
            pub const GkAtoms_Atoms_list: GkAtoms_Atoms = 1770;
            pub const GkAtoms_Atoms_ln: GkAtoms_Atoms = 1771;
            pub const GkAtoms_Atoms_location: GkAtoms_Atoms = 1772;
            pub const GkAtoms_Atoms_logbase: GkAtoms_Atoms = 1773;
            pub const GkAtoms_Atoms_log: GkAtoms_Atoms = 1774;
            pub const GkAtoms_Atoms_longdivstyle: GkAtoms_Atoms = 1775;
            pub const GkAtoms_Atoms_lowlimit: GkAtoms_Atoms = 1776;
            pub const GkAtoms_Atoms_lquote: GkAtoms_Atoms = 1777;
            pub const GkAtoms_Atoms_lspace: GkAtoms_Atoms = 1778;
            pub const GkAtoms_Atoms_lt: GkAtoms_Atoms = 1779;
            pub const GkAtoms_Atoms_maction: GkAtoms_Atoms = 1780;
            pub const GkAtoms_Atoms_maligngroup: GkAtoms_Atoms = 1781;
            pub const GkAtoms_Atoms_malignmark: GkAtoms_Atoms = 1782;
            pub const GkAtoms_Atoms_mathbackground: GkAtoms_Atoms = 1783;
            pub const GkAtoms_Atoms_mathcolor: GkAtoms_Atoms = 1784;
            pub const GkAtoms_Atoms_mathsize: GkAtoms_Atoms = 1785;
            pub const GkAtoms_Atoms_mathvariant: GkAtoms_Atoms = 1786;
            pub const GkAtoms_Atoms_matrixrow: GkAtoms_Atoms = 1787;
            pub const GkAtoms_Atoms_maxsize: GkAtoms_Atoms = 1788;
            pub const GkAtoms_Atoms_mean: GkAtoms_Atoms = 1789;
            pub const GkAtoms_Atoms_median: GkAtoms_Atoms = 1790;
            pub const GkAtoms_Atoms_menclose: GkAtoms_Atoms = 1791;
            pub const GkAtoms_Atoms_merror: GkAtoms_Atoms = 1792;
            pub const GkAtoms_Atoms_mfenced: GkAtoms_Atoms = 1793;
            pub const GkAtoms_Atoms_mfrac: GkAtoms_Atoms = 1794;
            pub const GkAtoms_Atoms_mglyph: GkAtoms_Atoms = 1795;
            pub const GkAtoms_Atoms_mi: GkAtoms_Atoms = 1796;
            pub const GkAtoms_Atoms_minlabelspacing: GkAtoms_Atoms = 1797;
            pub const GkAtoms_Atoms_minsize: GkAtoms_Atoms = 1798;
            pub const GkAtoms_Atoms_minus: GkAtoms_Atoms = 1799;
            pub const GkAtoms_Atoms_mlabeledtr: GkAtoms_Atoms = 1800;
            pub const GkAtoms_Atoms_mlongdiv: GkAtoms_Atoms = 1801;
            pub const GkAtoms_Atoms_mmultiscripts: GkAtoms_Atoms = 1802;
            pub const GkAtoms_Atoms_mn: GkAtoms_Atoms = 1803;
            pub const GkAtoms_Atoms_momentabout: GkAtoms_Atoms = 1804;
            pub const GkAtoms_Atoms_moment: GkAtoms_Atoms = 1805;
            pub const GkAtoms_Atoms_mo: GkAtoms_Atoms = 1806;
            pub const GkAtoms_Atoms_movablelimits: GkAtoms_Atoms = 1807;
            pub const GkAtoms_Atoms_mover: GkAtoms_Atoms = 1808;
            pub const GkAtoms_Atoms_mpadded: GkAtoms_Atoms = 1809;
            pub const GkAtoms_Atoms_mphantom: GkAtoms_Atoms = 1810;
            pub const GkAtoms_Atoms_mprescripts: GkAtoms_Atoms = 1811;
            pub const GkAtoms_Atoms_mroot: GkAtoms_Atoms = 1812;
            pub const GkAtoms_Atoms_mrow: GkAtoms_Atoms = 1813;
            pub const GkAtoms_Atoms_mscarries: GkAtoms_Atoms = 1814;
            pub const GkAtoms_Atoms_mscarry: GkAtoms_Atoms = 1815;
            pub const GkAtoms_Atoms_msgroup: GkAtoms_Atoms = 1816;
            pub const GkAtoms_Atoms_msline: GkAtoms_Atoms = 1817;
            pub const GkAtoms_Atoms_ms: GkAtoms_Atoms = 1818;
            pub const GkAtoms_Atoms_mspace: GkAtoms_Atoms = 1819;
            pub const GkAtoms_Atoms_msqrt: GkAtoms_Atoms = 1820;
            pub const GkAtoms_Atoms_msrow: GkAtoms_Atoms = 1821;
            pub const GkAtoms_Atoms_mstack: GkAtoms_Atoms = 1822;
            pub const GkAtoms_Atoms_mstyle: GkAtoms_Atoms = 1823;
            pub const GkAtoms_Atoms_msub: GkAtoms_Atoms = 1824;
            pub const GkAtoms_Atoms_msubsup: GkAtoms_Atoms = 1825;
            pub const GkAtoms_Atoms_msup: GkAtoms_Atoms = 1826;
            pub const GkAtoms_Atoms_mtable: GkAtoms_Atoms = 1827;
            pub const GkAtoms_Atoms_mtd: GkAtoms_Atoms = 1828;
            pub const GkAtoms_Atoms_mtext: GkAtoms_Atoms = 1829;
            pub const GkAtoms_Atoms_mtr: GkAtoms_Atoms = 1830;
            pub const GkAtoms_Atoms_munder: GkAtoms_Atoms = 1831;
            pub const GkAtoms_Atoms_munderover: GkAtoms_Atoms = 1832;
            pub const GkAtoms_Atoms_naturalnumbers: GkAtoms_Atoms = 1833;
            pub const GkAtoms_Atoms_neq: GkAtoms_Atoms = 1834;
            pub const GkAtoms_Atoms_notanumber: GkAtoms_Atoms = 1835;
            pub const GkAtoms_Atoms_notation: GkAtoms_Atoms = 1836;
            pub const GkAtoms_Atoms_note: GkAtoms_Atoms = 1837;
            pub const GkAtoms_Atoms_notin: GkAtoms_Atoms = 1838;
            pub const GkAtoms_Atoms_notprsubset: GkAtoms_Atoms = 1839;
            pub const GkAtoms_Atoms_notsubset: GkAtoms_Atoms = 1840;
            pub const GkAtoms_Atoms_numalign: GkAtoms_Atoms = 1841;
            pub const GkAtoms_Atoms_other: GkAtoms_Atoms = 1842;
            pub const GkAtoms_Atoms_outerproduct: GkAtoms_Atoms = 1843;
            pub const GkAtoms_Atoms_partialdiff: GkAtoms_Atoms = 1844;
            pub const GkAtoms_Atoms_piece: GkAtoms_Atoms = 1845;
            pub const GkAtoms_Atoms_piecewise: GkAtoms_Atoms = 1846;
            pub const GkAtoms_Atoms_pi: GkAtoms_Atoms = 1847;
            pub const GkAtoms_Atoms_plus: GkAtoms_Atoms = 1848;
            pub const GkAtoms_Atoms_power: GkAtoms_Atoms = 1849;
            pub const GkAtoms_Atoms_primes: GkAtoms_Atoms = 1850;
            pub const GkAtoms_Atoms_product: GkAtoms_Atoms = 1851;
            pub const GkAtoms_Atoms_prsubset: GkAtoms_Atoms = 1852;
            pub const GkAtoms_Atoms_quotient: GkAtoms_Atoms = 1853;
            pub const GkAtoms_Atoms_rationals: GkAtoms_Atoms = 1854;
            pub const GkAtoms_Atoms_real: GkAtoms_Atoms = 1855;
            pub const GkAtoms_Atoms_reals: GkAtoms_Atoms = 1856;
            pub const GkAtoms_Atoms_reln: GkAtoms_Atoms = 1857;
            pub const GkAtoms_Atoms_root: GkAtoms_Atoms = 1858;
            pub const GkAtoms_Atoms_rowalign: GkAtoms_Atoms = 1859;
            pub const GkAtoms_Atoms_rowlines: GkAtoms_Atoms = 1860;
            pub const GkAtoms_Atoms_rowspacing: GkAtoms_Atoms = 1861;
            pub const GkAtoms_Atoms_rquote: GkAtoms_Atoms = 1862;
            pub const GkAtoms_Atoms_rspace: GkAtoms_Atoms = 1863;
            pub const GkAtoms_Atoms_scalarproduct: GkAtoms_Atoms = 1864;
            pub const GkAtoms_Atoms_schemaLocation: GkAtoms_Atoms = 1865;
            pub const GkAtoms_Atoms_scriptlevel: GkAtoms_Atoms = 1866;
            pub const GkAtoms_Atoms_scriptminsize: GkAtoms_Atoms = 1867;
            pub const GkAtoms_Atoms_scriptsizemultiplier: GkAtoms_Atoms = 1868;
            pub const GkAtoms_Atoms_scriptsize: GkAtoms_Atoms = 1869;
            pub const GkAtoms_Atoms_sdev: GkAtoms_Atoms = 1870;
            pub const GkAtoms_Atoms_sech: GkAtoms_Atoms = 1871;
            pub const GkAtoms_Atoms_sec: GkAtoms_Atoms = 1872;
            pub const GkAtoms_Atoms_selection: GkAtoms_Atoms = 1873;
            pub const GkAtoms_Atoms_selector: GkAtoms_Atoms = 1874;
            pub const GkAtoms_Atoms_semantics: GkAtoms_Atoms = 1875;
            pub const GkAtoms_Atoms_separator: GkAtoms_Atoms = 1876;
            pub const GkAtoms_Atoms_separators: GkAtoms_Atoms = 1877;
            pub const GkAtoms_Atoms_sep: GkAtoms_Atoms = 1878;
            pub const GkAtoms_Atoms_setdiff: GkAtoms_Atoms = 1879;
            pub const GkAtoms_Atoms_share: GkAtoms_Atoms = 1880;
            pub const GkAtoms_Atoms_shift: GkAtoms_Atoms = 1881;
            pub const GkAtoms_Atoms_side: GkAtoms_Atoms = 1882;
            pub const GkAtoms_Atoms_sinh: GkAtoms_Atoms = 1883;
            pub const GkAtoms_Atoms_sin: GkAtoms_Atoms = 1884;
            pub const GkAtoms_Atoms_stackalign: GkAtoms_Atoms = 1885;
            pub const GkAtoms_Atoms_stretchy: GkAtoms_Atoms = 1886;
            pub const GkAtoms_Atoms_subscriptshift: GkAtoms_Atoms = 1887;
            pub const GkAtoms_Atoms_subset: GkAtoms_Atoms = 1888;
            pub const GkAtoms_Atoms_superscriptshift: GkAtoms_Atoms = 1889;
            pub const GkAtoms_Atoms_symmetric: GkAtoms_Atoms = 1890;
            pub const GkAtoms_Atoms_tanh: GkAtoms_Atoms = 1891;
            pub const GkAtoms_Atoms_tan: GkAtoms_Atoms = 1892;
            pub const GkAtoms_Atoms_tendsto: GkAtoms_Atoms = 1893;
            pub const GkAtoms_Atoms_times: GkAtoms_Atoms = 1894;
            pub const GkAtoms_Atoms_transpose: GkAtoms_Atoms = 1895;
            pub const GkAtoms_Atoms_union_: GkAtoms_Atoms = 1896;
            pub const GkAtoms_Atoms_uplimit: GkAtoms_Atoms = 1897;
            pub const GkAtoms_Atoms_variance: GkAtoms_Atoms = 1898;
            pub const GkAtoms_Atoms_vectorproduct: GkAtoms_Atoms = 1899;
            pub const GkAtoms_Atoms_vector: GkAtoms_Atoms = 1900;
            pub const GkAtoms_Atoms_voffset: GkAtoms_Atoms = 1901;
            pub const GkAtoms_Atoms_xref: GkAtoms_Atoms = 1902;
            pub const GkAtoms_Atoms_math: GkAtoms_Atoms = 1903;
            pub const GkAtoms_Atoms_booleanFromString: GkAtoms_Atoms = 1904;
            pub const GkAtoms_Atoms_countNonEmpty: GkAtoms_Atoms = 1905;
            pub const GkAtoms_Atoms_daysFromDate: GkAtoms_Atoms = 1906;
            pub const GkAtoms_Atoms_secondsFromDateTime: GkAtoms_Atoms = 1907;
            pub const GkAtoms_Atoms_tabbrowser_arrowscrollbox: GkAtoms_Atoms = 1908;
            pub const GkAtoms_Atoms_onMozSwipeGestureMayStart: GkAtoms_Atoms = 1909;
            pub const GkAtoms_Atoms_onMozSwipeGestureStart: GkAtoms_Atoms = 1910;
            pub const GkAtoms_Atoms_onMozSwipeGestureUpdate: GkAtoms_Atoms = 1911;
            pub const GkAtoms_Atoms_onMozSwipeGestureEnd: GkAtoms_Atoms = 1912;
            pub const GkAtoms_Atoms_onMozSwipeGesture: GkAtoms_Atoms = 1913;
            pub const GkAtoms_Atoms_onMozMagnifyGestureStart: GkAtoms_Atoms = 1914;
            pub const GkAtoms_Atoms_onMozMagnifyGestureUpdate: GkAtoms_Atoms = 1915;
            pub const GkAtoms_Atoms_onMozMagnifyGesture: GkAtoms_Atoms = 1916;
            pub const GkAtoms_Atoms_onMozRotateGestureStart: GkAtoms_Atoms = 1917;
            pub const GkAtoms_Atoms_onMozRotateGestureUpdate: GkAtoms_Atoms = 1918;
            pub const GkAtoms_Atoms_onMozRotateGesture: GkAtoms_Atoms = 1919;
            pub const GkAtoms_Atoms_onMozTapGesture: GkAtoms_Atoms = 1920;
            pub const GkAtoms_Atoms_onMozPressTapGesture: GkAtoms_Atoms = 1921;
            pub const GkAtoms_Atoms_onMozEdgeUIStarted: GkAtoms_Atoms = 1922;
            pub const GkAtoms_Atoms_onMozEdgeUICanceled: GkAtoms_Atoms = 1923;
            pub const GkAtoms_Atoms_onMozEdgeUICompleted: GkAtoms_Atoms = 1924;
            pub const GkAtoms_Atoms_onpointerdown: GkAtoms_Atoms = 1925;
            pub const GkAtoms_Atoms_onpointermove: GkAtoms_Atoms = 1926;
            pub const GkAtoms_Atoms_onpointerup: GkAtoms_Atoms = 1927;
            pub const GkAtoms_Atoms_onpointercancel: GkAtoms_Atoms = 1928;
            pub const GkAtoms_Atoms_onpointerover: GkAtoms_Atoms = 1929;
            pub const GkAtoms_Atoms_onpointerout: GkAtoms_Atoms = 1930;
            pub const GkAtoms_Atoms_onpointerenter: GkAtoms_Atoms = 1931;
            pub const GkAtoms_Atoms_onpointerleave: GkAtoms_Atoms = 1932;
            pub const GkAtoms_Atoms_onpointerrawupdate: GkAtoms_Atoms = 1933;
            pub const GkAtoms_Atoms_ongotpointercapture: GkAtoms_Atoms = 1934;
            pub const GkAtoms_Atoms_onlostpointercapture: GkAtoms_Atoms = 1935;
            pub const GkAtoms_Atoms_ondevicemotion: GkAtoms_Atoms = 1936;
            pub const GkAtoms_Atoms_ondeviceorientation: GkAtoms_Atoms = 1937;
            pub const GkAtoms_Atoms_ondeviceorientationabsolute: GkAtoms_Atoms = 1938;
            pub const GkAtoms_Atoms_onmozorientationchange: GkAtoms_Atoms = 1939;
            pub const GkAtoms_Atoms_onuserproximity: GkAtoms_Atoms = 1940;
            pub const GkAtoms_Atoms_ondevicelight: GkAtoms_Atoms = 1941;
            pub const GkAtoms_Atoms_ondevicechange: GkAtoms_Atoms = 1942;
            pub const GkAtoms_Atoms_onrtctransform: GkAtoms_Atoms = 1943;
            pub const GkAtoms_Atoms_onmozvisualresize: GkAtoms_Atoms = 1944;
            pub const GkAtoms_Atoms_onmozvisualscroll: GkAtoms_Atoms = 1945;
            pub const GkAtoms_Atoms_onDOMContentLoaded: GkAtoms_Atoms = 1946;
            pub const GkAtoms_Atoms_onDOMDocElementInserted: GkAtoms_Atoms = 1947;
            pub const GkAtoms_Atoms_onDOMFormBeforeSubmit: GkAtoms_Atoms = 1948;
            pub const GkAtoms_Atoms_onDOMFormHasPassword: GkAtoms_Atoms = 1949;
            pub const GkAtoms_Atoms_onDOMFrameContentLoaded: GkAtoms_Atoms = 1950;
            pub const GkAtoms_Atoms_onDOMHeadElementParsed: GkAtoms_Atoms = 1951;
            pub const GkAtoms_Atoms_onDOMInputPasswordAdded: GkAtoms_Atoms = 1952;
            pub const GkAtoms_Atoms_onDOMLinkAdded: GkAtoms_Atoms = 1953;
            pub const GkAtoms_Atoms_onDOMLinkChanged: GkAtoms_Atoms = 1954;
            pub const GkAtoms_Atoms_onDOMMetaAdded: GkAtoms_Atoms = 1955;
            pub const GkAtoms_Atoms_onDOMMetaChanged: GkAtoms_Atoms = 1956;
            pub const GkAtoms_Atoms_onDOMMetaRemoved: GkAtoms_Atoms = 1957;
            pub const GkAtoms_Atoms_onDOMPopupBlocked: GkAtoms_Atoms = 1958;
            pub const GkAtoms_Atoms_onDOMTitleChanged: GkAtoms_Atoms = 1959;
            pub const GkAtoms_Atoms_onDOMWindowClose: GkAtoms_Atoms = 1960;
            pub const GkAtoms_Atoms_onDOMWindowCreated: GkAtoms_Atoms = 1961;
            pub const GkAtoms_Atoms_onDOMWindowFocus: GkAtoms_Atoms = 1962;
            pub const GkAtoms_Atoms_onFullZoomChange: GkAtoms_Atoms = 1963;
            pub const GkAtoms_Atoms_onGloballyAutoplayBlocked: GkAtoms_Atoms = 1964;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Entered: GkAtoms_Atoms = 1965;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Exit: GkAtoms_Atoms = 1966;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Exited: GkAtoms_Atoms = 1967;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_NewOrigin: GkAtoms_Atoms = 1968;
            pub const GkAtoms_Atoms_onMozDOMFullscreen_Request: GkAtoms_Atoms = 1969;
            pub const GkAtoms_Atoms_onMozDOMPointerLock_Entered: GkAtoms_Atoms = 1970;
            pub const GkAtoms_Atoms_onMozDOMPointerLock_Exited: GkAtoms_Atoms = 1971;
            pub const GkAtoms_Atoms_onMozInvalidForm: GkAtoms_Atoms = 1972;
            pub const GkAtoms_Atoms_onMozLocalStorageChanged: GkAtoms_Atoms = 1973;
            pub const GkAtoms_Atoms_onMozOpenDateTimePicker: GkAtoms_Atoms = 1974;
            pub const GkAtoms_Atoms_onMozSessionStorageChanged: GkAtoms_Atoms = 1975;
            pub const GkAtoms_Atoms_onMozTogglePictureInPicture: GkAtoms_Atoms = 1976;
            pub const GkAtoms_Atoms_onPluginCrashed: GkAtoms_Atoms = 1977;
            pub const GkAtoms_Atoms_onPrintingError: GkAtoms_Atoms = 1978;
            pub const GkAtoms_Atoms_onTextZoomChange: GkAtoms_Atoms = 1979;
            pub const GkAtoms_Atoms_onUAWidgetSetupOrChange: GkAtoms_Atoms = 1980;
            pub const GkAtoms_Atoms_onUAWidgetTeardown: GkAtoms_Atoms = 1981;
            pub const GkAtoms_Atoms_onUnselectedTabHover_Disable: GkAtoms_Atoms = 1982;
            pub const GkAtoms_Atoms_onUnselectedTabHover_Enable: GkAtoms_Atoms = 1983;
            pub const GkAtoms_Atoms_onmozshowdropdown: GkAtoms_Atoms = 1984;
            pub const GkAtoms_Atoms_onmozshowdropdown_sourcetouch: GkAtoms_Atoms = 1985;
            pub const GkAtoms_Atoms_onprintPreviewUpdate: GkAtoms_Atoms = 1986;
            pub const GkAtoms_Atoms_onscrollend: GkAtoms_Atoms = 1987;
            pub const GkAtoms_Atoms_onbeforetoggle: GkAtoms_Atoms = 1988;
            pub const GkAtoms_Atoms_moz_extension: GkAtoms_Atoms = 1989;
            pub const GkAtoms_Atoms_all_urlsPermission: GkAtoms_Atoms = 1990;
            pub const GkAtoms_Atoms_clipboardRead: GkAtoms_Atoms = 1991;
            pub const GkAtoms_Atoms_clipboardWrite: GkAtoms_Atoms = 1992;
            pub const GkAtoms_Atoms_debugger: GkAtoms_Atoms = 1993;
            pub const GkAtoms_Atoms_mozillaAddons: GkAtoms_Atoms = 1994;
            pub const GkAtoms_Atoms_tabs: GkAtoms_Atoms = 1995;
            pub const GkAtoms_Atoms_webRequestBlocking: GkAtoms_Atoms = 1996;
            pub const GkAtoms_Atoms_webRequestFilterResponse_serviceWorkerScript: GkAtoms_Atoms =
                1997;
            pub const GkAtoms_Atoms_blob: GkAtoms_Atoms = 1998;
            pub const GkAtoms_Atoms_http: GkAtoms_Atoms = 1999;
            pub const GkAtoms_Atoms_https: GkAtoms_Atoms = 2000;
            pub const GkAtoms_Atoms_view_source: GkAtoms_Atoms = 2001;
            pub const GkAtoms_Atoms_ws: GkAtoms_Atoms = 2002;
            pub const GkAtoms_Atoms_wss: GkAtoms_Atoms = 2003;
            pub const GkAtoms_Atoms_ftp: GkAtoms_Atoms = 2004;
            pub const GkAtoms_Atoms_chrome: GkAtoms_Atoms = 2005;
            pub const GkAtoms_Atoms_moz: GkAtoms_Atoms = 2006;
            pub const GkAtoms_Atoms_moz_icon: GkAtoms_Atoms = 2007;
            pub const GkAtoms_Atoms_moz_gio: GkAtoms_Atoms = 2008;
            pub const GkAtoms_Atoms_proxy: GkAtoms_Atoms = 2009;
            pub const GkAtoms_Atoms_privateBrowsingAllowedPermission: GkAtoms_Atoms = 2010;
            pub const GkAtoms_Atoms_svgContextPropertiesAllowedPermission: GkAtoms_Atoms = 2011;
            pub const GkAtoms_Atoms_theme: GkAtoms_Atoms = 2012;
            pub const GkAtoms_Atoms_userScripts: GkAtoms_Atoms = 2013;
            pub const GkAtoms_Atoms_decimal_leading_zero: GkAtoms_Atoms = 2014;
            pub const GkAtoms_Atoms_arabic_indic: GkAtoms_Atoms = 2015;
            pub const GkAtoms_Atoms_armenian: GkAtoms_Atoms = 2016;
            pub const GkAtoms_Atoms_upper_armenian: GkAtoms_Atoms = 2017;
            pub const GkAtoms_Atoms_lower_armenian: GkAtoms_Atoms = 2018;
            pub const GkAtoms_Atoms_bengali: GkAtoms_Atoms = 2019;
            pub const GkAtoms_Atoms_cambodian: GkAtoms_Atoms = 2020;
            pub const GkAtoms_Atoms_khmer: GkAtoms_Atoms = 2021;
            pub const GkAtoms_Atoms_cjk_decimal: GkAtoms_Atoms = 2022;
            pub const GkAtoms_Atoms_devanagari: GkAtoms_Atoms = 2023;
            pub const GkAtoms_Atoms_georgian: GkAtoms_Atoms = 2024;
            pub const GkAtoms_Atoms_gujarati: GkAtoms_Atoms = 2025;
            pub const GkAtoms_Atoms_gurmukhi: GkAtoms_Atoms = 2026;
            pub const GkAtoms_Atoms_kannada: GkAtoms_Atoms = 2027;
            pub const GkAtoms_Atoms_lao: GkAtoms_Atoms = 2028;
            pub const GkAtoms_Atoms_malayalam: GkAtoms_Atoms = 2029;
            pub const GkAtoms_Atoms_mongolian: GkAtoms_Atoms = 2030;
            pub const GkAtoms_Atoms_myanmar: GkAtoms_Atoms = 2031;
            pub const GkAtoms_Atoms_oriya: GkAtoms_Atoms = 2032;
            pub const GkAtoms_Atoms_persian: GkAtoms_Atoms = 2033;
            pub const GkAtoms_Atoms_lower_roman: GkAtoms_Atoms = 2034;
            pub const GkAtoms_Atoms_upper_roman: GkAtoms_Atoms = 2035;
            pub const GkAtoms_Atoms_tamil: GkAtoms_Atoms = 2036;
            pub const GkAtoms_Atoms_telugu: GkAtoms_Atoms = 2037;
            pub const GkAtoms_Atoms_thai: GkAtoms_Atoms = 2038;
            pub const GkAtoms_Atoms_tibetan: GkAtoms_Atoms = 2039;
            pub const GkAtoms_Atoms_lower_alpha: GkAtoms_Atoms = 2040;
            pub const GkAtoms_Atoms_lower_latin: GkAtoms_Atoms = 2041;
            pub const GkAtoms_Atoms_upper_alpha: GkAtoms_Atoms = 2042;
            pub const GkAtoms_Atoms_upper_latin: GkAtoms_Atoms = 2043;
            pub const GkAtoms_Atoms_cjk_heavenly_stem: GkAtoms_Atoms = 2044;
            pub const GkAtoms_Atoms_cjk_earthly_branch: GkAtoms_Atoms = 2045;
            pub const GkAtoms_Atoms_lower_greek: GkAtoms_Atoms = 2046;
            pub const GkAtoms_Atoms_hiragana: GkAtoms_Atoms = 2047;
            pub const GkAtoms_Atoms_hiragana_iroha: GkAtoms_Atoms = 2048;
            pub const GkAtoms_Atoms_katakana: GkAtoms_Atoms = 2049;
            pub const GkAtoms_Atoms_katakana_iroha: GkAtoms_Atoms = 2050;
            pub const GkAtoms_Atoms_cjk_ideographic: GkAtoms_Atoms = 2051;
            pub const GkAtoms_Atoms__moz_arabic_indic: GkAtoms_Atoms = 2052;
            pub const GkAtoms_Atoms__moz_persian: GkAtoms_Atoms = 2053;
            pub const GkAtoms_Atoms__moz_urdu: GkAtoms_Atoms = 2054;
            pub const GkAtoms_Atoms__moz_devanagari: GkAtoms_Atoms = 2055;
            pub const GkAtoms_Atoms__moz_bengali: GkAtoms_Atoms = 2056;
            pub const GkAtoms_Atoms__moz_gurmukhi: GkAtoms_Atoms = 2057;
            pub const GkAtoms_Atoms__moz_gujarati: GkAtoms_Atoms = 2058;
            pub const GkAtoms_Atoms__moz_oriya: GkAtoms_Atoms = 2059;
            pub const GkAtoms_Atoms__moz_tamil: GkAtoms_Atoms = 2060;
            pub const GkAtoms_Atoms__moz_telugu: GkAtoms_Atoms = 2061;
            pub const GkAtoms_Atoms__moz_kannada: GkAtoms_Atoms = 2062;
            pub const GkAtoms_Atoms__moz_malayalam: GkAtoms_Atoms = 2063;
            pub const GkAtoms_Atoms__moz_thai: GkAtoms_Atoms = 2064;
            pub const GkAtoms_Atoms__moz_lao: GkAtoms_Atoms = 2065;
            pub const GkAtoms_Atoms__moz_myanmar: GkAtoms_Atoms = 2066;
            pub const GkAtoms_Atoms__moz_khmer: GkAtoms_Atoms = 2067;
            pub const GkAtoms_Atoms__moz_cjk_heavenly_stem: GkAtoms_Atoms = 2068;
            pub const GkAtoms_Atoms__moz_cjk_earthly_branch: GkAtoms_Atoms = 2069;
            pub const GkAtoms_Atoms__moz_hangul: GkAtoms_Atoms = 2070;
            pub const GkAtoms_Atoms__moz_hangul_consonant: GkAtoms_Atoms = 2071;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame: GkAtoms_Atoms = 2072;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_am: GkAtoms_Atoms = 2073;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_ti_er: GkAtoms_Atoms = 2074;
            pub const GkAtoms_Atoms__moz_ethiopic_halehame_ti_et: GkAtoms_Atoms = 2075;
            pub const GkAtoms_Atoms__moz_trad_chinese_informal: GkAtoms_Atoms = 2076;
            pub const GkAtoms_Atoms__moz_trad_chinese_formal: GkAtoms_Atoms = 2077;
            pub const GkAtoms_Atoms__moz_simp_chinese_informal: GkAtoms_Atoms = 2078;
            pub const GkAtoms_Atoms__moz_simp_chinese_formal: GkAtoms_Atoms = 2079;
            pub const GkAtoms_Atoms__moz_japanese_informal: GkAtoms_Atoms = 2080;
            pub const GkAtoms_Atoms__moz_japanese_formal: GkAtoms_Atoms = 2081;
            pub const GkAtoms_Atoms__moz_ethiopic_numeric: GkAtoms_Atoms = 2082;
            pub const GkAtoms_Atoms_cdataTagName: GkAtoms_Atoms = 2083;
            pub const GkAtoms_Atoms_commentTagName: GkAtoms_Atoms = 2084;
            pub const GkAtoms_Atoms_documentNodeName: GkAtoms_Atoms = 2085;
            pub const GkAtoms_Atoms_documentFragmentNodeName: GkAtoms_Atoms = 2086;
            pub const GkAtoms_Atoms_documentTypeNodeName: GkAtoms_Atoms = 2087;
            pub const GkAtoms_Atoms_processingInstructionTagName: GkAtoms_Atoms = 2088;
            pub const GkAtoms_Atoms_textTagName: GkAtoms_Atoms = 2089;
            pub const GkAtoms_Atoms_placeholderFrame: GkAtoms_Atoms = 2090;
            pub const GkAtoms_Atoms_onloadend: GkAtoms_Atoms = 2091;
            pub const GkAtoms_Atoms_onloadstart: GkAtoms_Atoms = 2092;
            pub const GkAtoms_Atoms_onprogress: GkAtoms_Atoms = 2093;
            pub const GkAtoms_Atoms_onsuspend: GkAtoms_Atoms = 2094;
            pub const GkAtoms_Atoms_onemptied: GkAtoms_Atoms = 2095;
            pub const GkAtoms_Atoms_onstalled: GkAtoms_Atoms = 2096;
            pub const GkAtoms_Atoms_onplay: GkAtoms_Atoms = 2097;
            pub const GkAtoms_Atoms_onpause: GkAtoms_Atoms = 2098;
            pub const GkAtoms_Atoms_onloadedmetadata: GkAtoms_Atoms = 2099;
            pub const GkAtoms_Atoms_onloadeddata: GkAtoms_Atoms = 2100;
            pub const GkAtoms_Atoms_onwaiting: GkAtoms_Atoms = 2101;
            pub const GkAtoms_Atoms_onplaying: GkAtoms_Atoms = 2102;
            pub const GkAtoms_Atoms_oncanplay: GkAtoms_Atoms = 2103;
            pub const GkAtoms_Atoms_oncanplaythrough: GkAtoms_Atoms = 2104;
            pub const GkAtoms_Atoms_onseeking: GkAtoms_Atoms = 2105;
            pub const GkAtoms_Atoms_onseeked: GkAtoms_Atoms = 2106;
            pub const GkAtoms_Atoms_ontimeout: GkAtoms_Atoms = 2107;
            pub const GkAtoms_Atoms_ontimeupdate: GkAtoms_Atoms = 2108;
            pub const GkAtoms_Atoms_onended: GkAtoms_Atoms = 2109;
            pub const GkAtoms_Atoms_onformdata: GkAtoms_Atoms = 2110;
            pub const GkAtoms_Atoms_onratechange: GkAtoms_Atoms = 2111;
            pub const GkAtoms_Atoms_ondurationchange: GkAtoms_Atoms = 2112;
            pub const GkAtoms_Atoms_onvolumechange: GkAtoms_Atoms = 2113;
            pub const GkAtoms_Atoms_onaddtrack: GkAtoms_Atoms = 2114;
            pub const GkAtoms_Atoms_oncontrollerchange: GkAtoms_Atoms = 2115;
            pub const GkAtoms_Atoms_oncuechange: GkAtoms_Atoms = 2116;
            pub const GkAtoms_Atoms_onenter: GkAtoms_Atoms = 2117;
            pub const GkAtoms_Atoms_onexit: GkAtoms_Atoms = 2118;
            pub const GkAtoms_Atoms_onencrypted: GkAtoms_Atoms = 2119;
            pub const GkAtoms_Atoms_onwaitingforkey: GkAtoms_Atoms = 2120;
            pub const GkAtoms_Atoms_onkeystatuseschange: GkAtoms_Atoms = 2121;
            pub const GkAtoms_Atoms_onremovetrack: GkAtoms_Atoms = 2122;
            pub const GkAtoms_Atoms_loadstart: GkAtoms_Atoms = 2123;
            pub const GkAtoms_Atoms_suspend: GkAtoms_Atoms = 2124;
            pub const GkAtoms_Atoms_emptied: GkAtoms_Atoms = 2125;
            pub const GkAtoms_Atoms_play: GkAtoms_Atoms = 2126;
            pub const GkAtoms_Atoms_pause: GkAtoms_Atoms = 2127;
            pub const GkAtoms_Atoms_loadedmetadata: GkAtoms_Atoms = 2128;
            pub const GkAtoms_Atoms_loadeddata: GkAtoms_Atoms = 2129;
            pub const GkAtoms_Atoms_waiting: GkAtoms_Atoms = 2130;
            pub const GkAtoms_Atoms_playing: GkAtoms_Atoms = 2131;
            pub const GkAtoms_Atoms_timeupdate: GkAtoms_Atoms = 2132;
            pub const GkAtoms_Atoms_canplay: GkAtoms_Atoms = 2133;
            pub const GkAtoms_Atoms_canplaythrough: GkAtoms_Atoms = 2134;
            pub const GkAtoms_Atoms_ondataavailable: GkAtoms_Atoms = 2135;
            pub const GkAtoms_Atoms_onwarning: GkAtoms_Atoms = 2136;
            pub const GkAtoms_Atoms_onstart: GkAtoms_Atoms = 2137;
            pub const GkAtoms_Atoms_onstop: GkAtoms_Atoms = 2138;
            pub const GkAtoms_Atoms_onphoto: GkAtoms_Atoms = 2139;
            pub const GkAtoms_Atoms_ongamepadbuttondown: GkAtoms_Atoms = 2140;
            pub const GkAtoms_Atoms_ongamepadbuttonup: GkAtoms_Atoms = 2141;
            pub const GkAtoms_Atoms_ongamepadaxismove: GkAtoms_Atoms = 2142;
            pub const GkAtoms_Atoms_ongamepadconnected: GkAtoms_Atoms = 2143;
            pub const GkAtoms_Atoms_ongamepaddisconnected: GkAtoms_Atoms = 2144;
            pub const GkAtoms_Atoms_onfetch: GkAtoms_Atoms = 2145;
            pub const GkAtoms_Atoms_afterPseudoProperty: GkAtoms_Atoms = 2146;
            pub const GkAtoms_Atoms_beforePseudoProperty: GkAtoms_Atoms = 2147;
            pub const GkAtoms_Atoms_cssPseudoElementBeforeProperty: GkAtoms_Atoms = 2148;
            pub const GkAtoms_Atoms_cssPseudoElementAfterProperty: GkAtoms_Atoms = 2149;
            pub const GkAtoms_Atoms_cssPseudoElementMarkerProperty: GkAtoms_Atoms = 2150;
            pub const GkAtoms_Atoms_genConInitializerProperty: GkAtoms_Atoms = 2151;
            pub const GkAtoms_Atoms_labelMouseDownPtProperty: GkAtoms_Atoms = 2152;
            pub const GkAtoms_Atoms_lockedStyleStates: GkAtoms_Atoms = 2153;
            pub const GkAtoms_Atoms_apzCallbackTransform: GkAtoms_Atoms = 2154;
            pub const GkAtoms_Atoms_apzDisabled: GkAtoms_Atoms = 2155;
            pub const GkAtoms_Atoms_restylableAnonymousNode: GkAtoms_Atoms = 2156;
            pub const GkAtoms_Atoms_docLevelNativeAnonymousContent: GkAtoms_Atoms = 2157;
            pub const GkAtoms_Atoms_paintRequestTime: GkAtoms_Atoms = 2158;
            pub const GkAtoms_Atoms_pseudoProperty: GkAtoms_Atoms = 2159;
            pub const GkAtoms_Atoms_manualNACProperty: GkAtoms_Atoms = 2160;
            pub const GkAtoms_Atoms_markerPseudoProperty: GkAtoms_Atoms = 2161;
            pub const GkAtoms_Atoms_Japanese: GkAtoms_Atoms = 2162;
            pub const GkAtoms_Atoms_Chinese: GkAtoms_Atoms = 2163;
            pub const GkAtoms_Atoms_Taiwanese: GkAtoms_Atoms = 2164;
            pub const GkAtoms_Atoms_HongKongChinese: GkAtoms_Atoms = 2165;
            pub const GkAtoms_Atoms_Unicode: GkAtoms_Atoms = 2166;
            pub const GkAtoms_Atoms_ko: GkAtoms_Atoms = 2167;
            pub const GkAtoms_Atoms_zh_cn: GkAtoms_Atoms = 2168;
            pub const GkAtoms_Atoms_zh_tw: GkAtoms_Atoms = 2169;
            pub const GkAtoms_Atoms_x_cyrillic: GkAtoms_Atoms = 2170;
            pub const GkAtoms_Atoms_he: GkAtoms_Atoms = 2171;
            pub const GkAtoms_Atoms_ar: GkAtoms_Atoms = 2172;
            pub const GkAtoms_Atoms_x_devanagari: GkAtoms_Atoms = 2173;
            pub const GkAtoms_Atoms_x_tamil: GkAtoms_Atoms = 2174;
            pub const GkAtoms_Atoms_x_armn: GkAtoms_Atoms = 2175;
            pub const GkAtoms_Atoms_x_beng: GkAtoms_Atoms = 2176;
            pub const GkAtoms_Atoms_x_cans: GkAtoms_Atoms = 2177;
            pub const GkAtoms_Atoms_x_ethi: GkAtoms_Atoms = 2178;
            pub const GkAtoms_Atoms_x_geor: GkAtoms_Atoms = 2179;
            pub const GkAtoms_Atoms_x_gujr: GkAtoms_Atoms = 2180;
            pub const GkAtoms_Atoms_x_guru: GkAtoms_Atoms = 2181;
            pub const GkAtoms_Atoms_x_khmr: GkAtoms_Atoms = 2182;
            pub const GkAtoms_Atoms_x_knda: GkAtoms_Atoms = 2183;
            pub const GkAtoms_Atoms_x_mlym: GkAtoms_Atoms = 2184;
            pub const GkAtoms_Atoms_x_orya: GkAtoms_Atoms = 2185;
            pub const GkAtoms_Atoms_x_sinh: GkAtoms_Atoms = 2186;
            pub const GkAtoms_Atoms_x_telu: GkAtoms_Atoms = 2187;
            pub const GkAtoms_Atoms_x_tibt: GkAtoms_Atoms = 2188;
            pub const GkAtoms_Atoms_az: GkAtoms_Atoms = 2189;
            pub const GkAtoms_Atoms_ba: GkAtoms_Atoms = 2190;
            pub const GkAtoms_Atoms_crh: GkAtoms_Atoms = 2191;
            pub const GkAtoms_Atoms_ga: GkAtoms_Atoms = 2192;
            pub const GkAtoms_Atoms_nl: GkAtoms_Atoms = 2193;
            pub const GkAtoms_Atoms_x_math: GkAtoms_Atoms = 2194;
            pub const GkAtoms_Atoms_zh: GkAtoms_Atoms = 2195;
            pub const GkAtoms_Atoms_TypingTxnName: GkAtoms_Atoms = 2196;
            pub const GkAtoms_Atoms_IMETxnName: GkAtoms_Atoms = 2197;
            pub const GkAtoms_Atoms_DeleteTxnName: GkAtoms_Atoms = 2198;
            pub const GkAtoms_Atoms_serif: GkAtoms_Atoms = 2199;
            pub const GkAtoms_Atoms_sans_serif: GkAtoms_Atoms = 2200;
            pub const GkAtoms_Atoms_cursive: GkAtoms_Atoms = 2201;
            pub const GkAtoms_Atoms_fantasy: GkAtoms_Atoms = 2202;
            pub const GkAtoms_Atoms_monospace: GkAtoms_Atoms = 2203;
            pub const GkAtoms_Atoms_mozfixed: GkAtoms_Atoms = 2204;
            pub const GkAtoms_Atoms_moz_fixed_pos_containing_block: GkAtoms_Atoms = 2205;
            pub const GkAtoms_Atoms_light: GkAtoms_Atoms = 2206;
            pub const GkAtoms_Atoms_dark: GkAtoms_Atoms = 2207;
            pub const GkAtoms_Atoms_RemoteId: GkAtoms_Atoms = 2208;
            pub const GkAtoms_Atoms_RemoteType: GkAtoms_Atoms = 2209;
            pub const GkAtoms_Atoms_DisplayPort: GkAtoms_Atoms = 2210;
            pub const GkAtoms_Atoms_DisplayPortMargins: GkAtoms_Atoms = 2211;
            pub const GkAtoms_Atoms_DisplayPortBase: GkAtoms_Atoms = 2212;
            pub const GkAtoms_Atoms_MinimalDisplayPort: GkAtoms_Atoms = 2213;
            pub const GkAtoms_Atoms_forceMousewheelAutodir: GkAtoms_Atoms = 2214;
            pub const GkAtoms_Atoms_forceMousewheelAutodirHonourRoot: GkAtoms_Atoms = 2215;
            pub const GkAtoms_Atoms_forcemessagemanager: GkAtoms_Atoms = 2216;
            pub const GkAtoms_Atoms_initialBrowsingContextGroupId: GkAtoms_Atoms = 2217;
            pub const GkAtoms_Atoms_manualactiveness: GkAtoms_Atoms = 2218;
            pub const GkAtoms_Atoms__moz_bool_pref: GkAtoms_Atoms = 2219;
            pub const GkAtoms_Atoms__moz_overlay_scrollbars: GkAtoms_Atoms = 2220;
            pub const GkAtoms_Atoms__moz_overlay_scrollbar_fade_duration: GkAtoms_Atoms = 2221;
            pub const GkAtoms_Atoms__moz_windows_accent_color_in_titlebar: GkAtoms_Atoms = 2222;
            pub const GkAtoms_Atoms__moz_windows_accent_color_in_tabs: GkAtoms_Atoms = 2223;
            pub const GkAtoms_Atoms__moz_windows_mica: GkAtoms_Atoms = 2224;
            pub const GkAtoms_Atoms__moz_windows_mica_popups: GkAtoms_Atoms = 2225;
            pub const GkAtoms_Atoms__moz_mac_big_sur_theme: GkAtoms_Atoms = 2226;
            pub const GkAtoms_Atoms__moz_mac_tahoe_theme: GkAtoms_Atoms = 2227;
            pub const GkAtoms_Atoms__moz_mac_rtl: GkAtoms_Atoms = 2228;
            pub const GkAtoms_Atoms__moz_mac_titlebar_height: GkAtoms_Atoms = 2229;
            pub const GkAtoms_Atoms__moz_platform: GkAtoms_Atoms = 2230;
            pub const GkAtoms_Atoms__moz_gtk_theme_family: GkAtoms_Atoms = 2231;
            pub const GkAtoms_Atoms__moz_menubar_drag: GkAtoms_Atoms = 2232;
            pub const GkAtoms_Atoms__moz_device_pixel_ratio: GkAtoms_Atoms = 2233;
            pub const GkAtoms_Atoms__moz_device_orientation: GkAtoms_Atoms = 2234;
            pub const GkAtoms_Atoms__moz_is_resource_document: GkAtoms_Atoms = 2235;
            pub const GkAtoms_Atoms__moz_swipe_animation_enabled: GkAtoms_Atoms = 2236;
            pub const GkAtoms_Atoms__moz_gtk_csd_available: GkAtoms_Atoms = 2237;
            pub const GkAtoms_Atoms__moz_gtk_csd_transparency_available: GkAtoms_Atoms = 2238;
            pub const GkAtoms_Atoms__moz_gtk_csd_titlebar_radius: GkAtoms_Atoms = 2239;
            pub const GkAtoms_Atoms__moz_gtk_csd_tooltip_radius: GkAtoms_Atoms = 2240;
            pub const GkAtoms_Atoms__moz_gtk_csd_titlebar_button_spacing: GkAtoms_Atoms = 2241;
            pub const GkAtoms_Atoms__moz_gtk_csd_minimize_button: GkAtoms_Atoms = 2242;
            pub const GkAtoms_Atoms__moz_gtk_csd_minimize_button_position: GkAtoms_Atoms = 2243;
            pub const GkAtoms_Atoms__moz_gtk_csd_maximize_button: GkAtoms_Atoms = 2244;
            pub const GkAtoms_Atoms__moz_gtk_csd_maximize_button_position: GkAtoms_Atoms = 2245;
            pub const GkAtoms_Atoms__moz_gtk_csd_close_button: GkAtoms_Atoms = 2246;
            pub const GkAtoms_Atoms__moz_gtk_csd_close_button_position: GkAtoms_Atoms = 2247;
            pub const GkAtoms_Atoms__moz_gtk_csd_reversed_placement: GkAtoms_Atoms = 2248;
            pub const GkAtoms_Atoms__moz_gtk_csd_rounded_bottom_corners: GkAtoms_Atoms = 2249;
            pub const GkAtoms_Atoms__moz_content_prefers_color_scheme: GkAtoms_Atoms = 2250;
            pub const GkAtoms_Atoms__moz_content_preferred_color_scheme: GkAtoms_Atoms = 2251;
            pub const GkAtoms_Atoms__moz_system_dark_theme: GkAtoms_Atoms = 2252;
            pub const GkAtoms_Atoms__moz_native_theme: GkAtoms_Atoms = 2253;
            pub const GkAtoms_Atoms__moz_panel_animations: GkAtoms_Atoms = 2254;
            pub const GkAtoms_Atoms_Back: GkAtoms_Atoms = 2255;
            pub const GkAtoms_Atoms_Forward: GkAtoms_Atoms = 2256;
            pub const GkAtoms_Atoms_Reload: GkAtoms_Atoms = 2257;
            pub const GkAtoms_Atoms_Stop: GkAtoms_Atoms = 2258;
            pub const GkAtoms_Atoms_Search: GkAtoms_Atoms = 2259;
            pub const GkAtoms_Atoms_Bookmarks: GkAtoms_Atoms = 2260;
            pub const GkAtoms_Atoms_Home: GkAtoms_Atoms = 2261;
            pub const GkAtoms_Atoms_NextTrack: GkAtoms_Atoms = 2262;
            pub const GkAtoms_Atoms_PreviousTrack: GkAtoms_Atoms = 2263;
            pub const GkAtoms_Atoms_MediaStop: GkAtoms_Atoms = 2264;
            pub const GkAtoms_Atoms_PlayPause: GkAtoms_Atoms = 2265;
            pub const GkAtoms_Atoms_New: GkAtoms_Atoms = 2266;
            pub const GkAtoms_Atoms_Open: GkAtoms_Atoms = 2267;
            pub const GkAtoms_Atoms_Close: GkAtoms_Atoms = 2268;
            pub const GkAtoms_Atoms_Save: GkAtoms_Atoms = 2269;
            pub const GkAtoms_Atoms_Find: GkAtoms_Atoms = 2270;
            pub const GkAtoms_Atoms_Help: GkAtoms_Atoms = 2271;
            pub const GkAtoms_Atoms_Print: GkAtoms_Atoms = 2272;
            pub const GkAtoms_Atoms_SendMail: GkAtoms_Atoms = 2273;
            pub const GkAtoms_Atoms_ForwardMail: GkAtoms_Atoms = 2274;
            pub const GkAtoms_Atoms_ReplyToMail: GkAtoms_Atoms = 2275;
            pub const GkAtoms_Atoms_alert: GkAtoms_Atoms = 2276;
            pub const GkAtoms_Atoms_alertdialog: GkAtoms_Atoms = 2277;
            pub const GkAtoms_Atoms_application: GkAtoms_Atoms = 2278;
            pub const GkAtoms_Atoms_aria_colcount: GkAtoms_Atoms = 2279;
            pub const GkAtoms_Atoms_aria_colindex: GkAtoms_Atoms = 2280;
            pub const GkAtoms_Atoms_aria_colindextext: GkAtoms_Atoms = 2281;
            pub const GkAtoms_Atoms_aria_colspan: GkAtoms_Atoms = 2282;
            pub const GkAtoms_Atoms_aria_details: GkAtoms_Atoms = 2283;
            pub const GkAtoms_Atoms_aria_errormessage: GkAtoms_Atoms = 2284;
            pub const GkAtoms_Atoms_aria_grabbed: GkAtoms_Atoms = 2285;
            pub const GkAtoms_Atoms_aria_keyshortcuts: GkAtoms_Atoms = 2286;
            pub const GkAtoms_Atoms_aria_label: GkAtoms_Atoms = 2287;
            pub const GkAtoms_Atoms_aria_modal: GkAtoms_Atoms = 2288;
            pub const GkAtoms_Atoms_aria_orientation: GkAtoms_Atoms = 2289;
            pub const GkAtoms_Atoms_aria_placeholder: GkAtoms_Atoms = 2290;
            pub const GkAtoms_Atoms_aria_roledescription: GkAtoms_Atoms = 2291;
            pub const GkAtoms_Atoms_aria_rowcount: GkAtoms_Atoms = 2292;
            pub const GkAtoms_Atoms_aria_rowindex: GkAtoms_Atoms = 2293;
            pub const GkAtoms_Atoms_aria_rowindextext: GkAtoms_Atoms = 2294;
            pub const GkAtoms_Atoms_aria_rowspan: GkAtoms_Atoms = 2295;
            pub const GkAtoms_Atoms_aria_valuetext: GkAtoms_Atoms = 2296;
            pub const GkAtoms_Atoms_assertive: GkAtoms_Atoms = 2297;
            pub const GkAtoms_Atoms_auto_generated: GkAtoms_Atoms = 2298;
            pub const GkAtoms_Atoms_banner: GkAtoms_Atoms = 2299;
            pub const GkAtoms_Atoms_checkable: GkAtoms_Atoms = 2300;
            pub const GkAtoms_Atoms_columnheader: GkAtoms_Atoms = 2301;
            pub const GkAtoms_Atoms_complementary: GkAtoms_Atoms = 2302;
            pub const GkAtoms_Atoms_containerAtomic: GkAtoms_Atoms = 2303;
            pub const GkAtoms_Atoms_containerBusy: GkAtoms_Atoms = 2304;
            pub const GkAtoms_Atoms_containerLive: GkAtoms_Atoms = 2305;
            pub const GkAtoms_Atoms_containerLiveRole: GkAtoms_Atoms = 2306;
            pub const GkAtoms_Atoms_containerRelevant: GkAtoms_Atoms = 2307;
            pub const GkAtoms_Atoms_contentinfo: GkAtoms_Atoms = 2308;
            pub const GkAtoms_Atoms_cycles: GkAtoms_Atoms = 2309;
            pub const GkAtoms_Atoms_datatable: GkAtoms_Atoms = 2310;
            pub const GkAtoms_Atoms_feed: GkAtoms_Atoms = 2311;
            pub const GkAtoms_Atoms_grammar: GkAtoms_Atoms = 2312;
            pub const GkAtoms_Atoms_gridcell: GkAtoms_Atoms = 2313;
            pub const GkAtoms_Atoms_heading: GkAtoms_Atoms = 2314;
            pub const GkAtoms_Atoms_inlinevalue: GkAtoms_Atoms = 2315;
            pub const GkAtoms_Atoms_inline_size: GkAtoms_Atoms = 2316;
            pub const GkAtoms_Atoms_invalid: GkAtoms_Atoms = 2317;
            pub const GkAtoms_Atoms_lineNumber: GkAtoms_Atoms = 2318;
            pub const GkAtoms_Atoms_menuitemcheckbox: GkAtoms_Atoms = 2319;
            pub const GkAtoms_Atoms_menuitemradio: GkAtoms_Atoms = 2320;
            pub const GkAtoms_Atoms_navigation: GkAtoms_Atoms = 2321;
            pub const GkAtoms_Atoms_polite: GkAtoms_Atoms = 2322;
            pub const GkAtoms_Atoms_posinset: GkAtoms_Atoms = 2323;
            pub const GkAtoms_Atoms_presentation: GkAtoms_Atoms = 2324;
            pub const GkAtoms_Atoms_progressbar: GkAtoms_Atoms = 2325;
            pub const GkAtoms_Atoms_region: GkAtoms_Atoms = 2326;
            pub const GkAtoms_Atoms_rowgroup: GkAtoms_Atoms = 2327;
            pub const GkAtoms_Atoms_rowheader: GkAtoms_Atoms = 2328;
            pub const GkAtoms_Atoms_search: GkAtoms_Atoms = 2329;
            pub const GkAtoms_Atoms_searchbox: GkAtoms_Atoms = 2330;
            pub const GkAtoms_Atoms_setsize: GkAtoms_Atoms = 2331;
            pub const GkAtoms_Atoms_spelling: GkAtoms_Atoms = 2332;
            pub const GkAtoms_Atoms_spinbutton: GkAtoms_Atoms = 2333;
            pub const GkAtoms_Atoms_status: GkAtoms_Atoms = 2334;
            pub const GkAtoms_Atoms_tableCellIndex: GkAtoms_Atoms = 2335;
            pub const GkAtoms_Atoms_tablist: GkAtoms_Atoms = 2336;
            pub const GkAtoms_Atoms_textIndent: GkAtoms_Atoms = 2337;
            pub const GkAtoms_Atoms_textInputType: GkAtoms_Atoms = 2338;
            pub const GkAtoms_Atoms_textLineThroughColor: GkAtoms_Atoms = 2339;
            pub const GkAtoms_Atoms_textLineThroughStyle: GkAtoms_Atoms = 2340;
            pub const GkAtoms_Atoms_textPosition: GkAtoms_Atoms = 2341;
            pub const GkAtoms_Atoms_textUnderlineColor: GkAtoms_Atoms = 2342;
            pub const GkAtoms_Atoms_textUnderlineStyle: GkAtoms_Atoms = 2343;
            pub const GkAtoms_Atoms_timer: GkAtoms_Atoms = 2344;
            pub const GkAtoms_Atoms_toolbarname: GkAtoms_Atoms = 2345;
            pub const GkAtoms_Atoms_toolbarseparator: GkAtoms_Atoms = 2346;
            pub const GkAtoms_Atoms_toolbarspacer: GkAtoms_Atoms = 2347;
            pub const GkAtoms_Atoms_toolbarspring: GkAtoms_Atoms = 2348;
            pub const GkAtoms_Atoms_treegrid: GkAtoms_Atoms = 2349;
            pub const GkAtoms_Atoms__undefined: GkAtoms_Atoms = 2350;
            pub const GkAtoms_Atoms_xmlroles: GkAtoms_Atoms = 2351;
            pub const GkAtoms_Atoms_close_fence: GkAtoms_Atoms = 2352;
            pub const GkAtoms_Atoms_denominator: GkAtoms_Atoms = 2353;
            pub const GkAtoms_Atoms_numerator: GkAtoms_Atoms = 2354;
            pub const GkAtoms_Atoms_open_fence: GkAtoms_Atoms = 2355;
            pub const GkAtoms_Atoms_overscript: GkAtoms_Atoms = 2356;
            pub const GkAtoms_Atoms_presubscript: GkAtoms_Atoms = 2357;
            pub const GkAtoms_Atoms_presuperscript: GkAtoms_Atoms = 2358;
            pub const GkAtoms_Atoms_root_index: GkAtoms_Atoms = 2359;
            pub const GkAtoms_Atoms_subscript: GkAtoms_Atoms = 2360;
            pub const GkAtoms_Atoms_superscript: GkAtoms_Atoms = 2361;
            pub const GkAtoms_Atoms_underscript: GkAtoms_Atoms = 2362;
            pub const GkAtoms_Atoms_onaudiostart: GkAtoms_Atoms = 2363;
            pub const GkAtoms_Atoms_onaudioend: GkAtoms_Atoms = 2364;
            pub const GkAtoms_Atoms_onsoundstart: GkAtoms_Atoms = 2365;
            pub const GkAtoms_Atoms_onsoundend: GkAtoms_Atoms = 2366;
            pub const GkAtoms_Atoms_onspeechstart: GkAtoms_Atoms = 2367;
            pub const GkAtoms_Atoms_onspeechend: GkAtoms_Atoms = 2368;
            pub const GkAtoms_Atoms_onresult: GkAtoms_Atoms = 2369;
            pub const GkAtoms_Atoms_onnomatch: GkAtoms_Atoms = 2370;
            pub const GkAtoms_Atoms_onresume: GkAtoms_Atoms = 2371;
            pub const GkAtoms_Atoms_onmark: GkAtoms_Atoms = 2372;
            pub const GkAtoms_Atoms_onboundary: GkAtoms_Atoms = 2373;
            pub const GkAtoms_Atoms_onactivated: GkAtoms_Atoms = 2374;
            pub const GkAtoms_Atoms_ondeactivated: GkAtoms_Atoms = 2375;
            pub const GkAtoms_Atoms_onmetadatachange: GkAtoms_Atoms = 2376;
            pub const GkAtoms_Atoms_onplaybackstatechange: GkAtoms_Atoms = 2377;
            pub const GkAtoms_Atoms_onpositionstatechange: GkAtoms_Atoms = 2378;
            pub const GkAtoms_Atoms_onsupportedkeyschange: GkAtoms_Atoms = 2379;
            pub const GkAtoms_Atoms_mathml_legacy_mathvariant_attribute_disabled: GkAtoms_Atoms =
                2380;
            pub const GkAtoms_Atoms_mathml_font_family_math_enabled: GkAtoms_Atoms = 2381;
            pub const GkAtoms_Atoms_layout_css_always_underline_links: GkAtoms_Atoms = 2382;
            pub const GkAtoms_Atoms_layout_css_android_pip_enabled: GkAtoms_Atoms = 2383;
            pub const GkAtoms_Atoms_layout_css_cached_scrollbar_styles_enabled: GkAtoms_Atoms =
                2384;
            pub const GkAtoms_Atoms_layout_testing_scrollbars_always_hidden: GkAtoms_Atoms = 2385;
            pub const GkAtoms_Atoms_usercontextid: GkAtoms_Atoms = 2386;
            pub const GkAtoms_Atoms_geckoViewSessionContextId: GkAtoms_Atoms = 2387;
            pub const GkAtoms_Atoms_nsuri_xmlns: GkAtoms_Atoms = 2388;
            pub const GkAtoms_Atoms_nsuri_xml: GkAtoms_Atoms = 2389;
            pub const GkAtoms_Atoms_nsuri_xhtml: GkAtoms_Atoms = 2390;
            pub const GkAtoms_Atoms_nsuri_xlink: GkAtoms_Atoms = 2391;
            pub const GkAtoms_Atoms_nsuri_xslt: GkAtoms_Atoms = 2392;
            pub const GkAtoms_Atoms_nsuri_mathml: GkAtoms_Atoms = 2393;
            pub const GkAtoms_Atoms_nsuri_rdf: GkAtoms_Atoms = 2394;
            pub const GkAtoms_Atoms_nsuri_xul: GkAtoms_Atoms = 2395;
            pub const GkAtoms_Atoms_nsuri_svg: GkAtoms_Atoms = 2396;
            pub const GkAtoms_Atoms_nsuri_parsererror: GkAtoms_Atoms = 2397;
            pub const GkAtoms_Atoms_onsourceopen: GkAtoms_Atoms = 2398;
            pub const GkAtoms_Atoms_onsourceended: GkAtoms_Atoms = 2399;
            pub const GkAtoms_Atoms_onsourceclose: GkAtoms_Atoms = 2400;
            pub const GkAtoms_Atoms_onupdatestart: GkAtoms_Atoms = 2401;
            pub const GkAtoms_Atoms_onupdate: GkAtoms_Atoms = 2402;
            pub const GkAtoms_Atoms_onupdateend: GkAtoms_Atoms = 2403;
            pub const GkAtoms_Atoms_onaddsourcebuffer: GkAtoms_Atoms = 2404;
            pub const GkAtoms_Atoms_onremovesourcebuffer: GkAtoms_Atoms = 2405;
            pub const GkAtoms_Atoms_ondequeue: GkAtoms_Atoms = 2406;
            pub const GkAtoms_Atoms_about: GkAtoms_Atoms = 2407;
            pub const GkAtoms_Atoms_ID: GkAtoms_Atoms = 2408;
            pub const GkAtoms_Atoms_nodeID: GkAtoms_Atoms = 2409;
            pub const GkAtoms_Atoms_aboutEach: GkAtoms_Atoms = 2410;
            pub const GkAtoms_Atoms_resource: GkAtoms_Atoms = 2411;
            pub const GkAtoms_Atoms_RDF: GkAtoms_Atoms = 2412;
            pub const GkAtoms_Atoms_Description: GkAtoms_Atoms = 2413;
            pub const GkAtoms_Atoms_Bag: GkAtoms_Atoms = 2414;
            pub const GkAtoms_Atoms_Seq: GkAtoms_Atoms = 2415;
            pub const GkAtoms_Atoms_Alt: GkAtoms_Atoms = 2416;
            pub const GkAtoms_Atoms_parseType: GkAtoms_Atoms = 2417;
            pub const GkAtoms_Atoms_DirectoryService_CurrentProcess: GkAtoms_Atoms = 2418;
            pub const GkAtoms_Atoms_DirectoryService_GRE_Directory: GkAtoms_Atoms = 2419;
            pub const GkAtoms_Atoms_DirectoryService_GRE_BinDirectory: GkAtoms_Atoms = 2420;
            pub const GkAtoms_Atoms_DirectoryService_OS_TemporaryDirectory: GkAtoms_Atoms = 2421;
            pub const GkAtoms_Atoms_DirectoryService_OS_CurrentProcessDirectory: GkAtoms_Atoms =
                2422;
            pub const GkAtoms_Atoms_DirectoryService_OS_CurrentWorkingDirectory: GkAtoms_Atoms =
                2423;
            pub const GkAtoms_Atoms_DirectoryService_OS_SystemConfigDir: GkAtoms_Atoms = 2424;
            pub const GkAtoms_Atoms_DirectoryService_OS_DesktopDirectory: GkAtoms_Atoms = 2425;
            pub const GkAtoms_Atoms_DirectoryService_OS_DocumentsDirectory: GkAtoms_Atoms = 2426;
            pub const GkAtoms_Atoms_DirectoryService_InitCurrentProcess_dummy: GkAtoms_Atoms = 2427;
            pub const GkAtoms_Atoms_DirectoryService_SystemDirectory: GkAtoms_Atoms = 2428;
            pub const GkAtoms_Atoms_DirectoryService_UserLibDirectory: GkAtoms_Atoms = 2429;
            pub const GkAtoms_Atoms_DirectoryService_DefaultDownloadDirectory: GkAtoms_Atoms = 2430;
            pub const GkAtoms_Atoms_DirectoryService_LocalApplicationsDirectory: GkAtoms_Atoms =
                2431;
            pub const GkAtoms_Atoms_DirectoryService_UserPreferencesDirectory: GkAtoms_Atoms = 2432;
            pub const GkAtoms_Atoms_DirectoryService_PictureDocumentsDirectory: GkAtoms_Atoms =
                2433;
            pub const GkAtoms_Atoms_DirectoryService_DefaultScreenshotDirectory: GkAtoms_Atoms =
                2434;
            pub const GkAtoms_Atoms_DirectoryService_WindowsDirectory: GkAtoms_Atoms = 2435;
            pub const GkAtoms_Atoms_DirectoryService_WindowsProgramFiles: GkAtoms_Atoms = 2436;
            pub const GkAtoms_Atoms_DirectoryService_Programs: GkAtoms_Atoms = 2437;
            pub const GkAtoms_Atoms_DirectoryService_Favorites: GkAtoms_Atoms = 2438;
            pub const GkAtoms_Atoms_DirectoryService_Appdata: GkAtoms_Atoms = 2439;
            pub const GkAtoms_Atoms_DirectoryService_LocalAppdata: GkAtoms_Atoms = 2440;
            pub const GkAtoms_Atoms_DirectoryService_WinCookiesDirectory: GkAtoms_Atoms = 2441;
            pub const GkAtoms_Atoms_DirectoryService_OneDrivePersonalDirectory: GkAtoms_Atoms =
                2442;
            pub const GkAtoms_Atoms_DirectoryService_OneDriveBusinessDirectoryList: GkAtoms_Atoms =
                2443;
            pub const GkAtoms_Atoms__ua_view_transition_fade_out: GkAtoms_Atoms = 2444;
            pub const GkAtoms_Atoms__ua_view_transition_fade_in: GkAtoms_Atoms = 2445;
            pub const GkAtoms_Atoms__ua_mix_blend_mode_plus_lighter: GkAtoms_Atoms = 2446;
            pub const GkAtoms_Atoms_AnchorPosImplicitAnchor: GkAtoms_Atoms = 2447;
            pub const GkAtoms_Atoms_PseudoElement_after: GkAtoms_Atoms = 2448;
            pub const GkAtoms_Atoms_PseudoElement_before: GkAtoms_Atoms = 2449;
            pub const GkAtoms_Atoms_PseudoElement_marker: GkAtoms_Atoms = 2450;
            pub const GkAtoms_Atoms_PseudoElement_backdrop: GkAtoms_Atoms = 2451;
            pub const GkAtoms_Atoms_PseudoElement_cue: GkAtoms_Atoms = 2452;
            pub const GkAtoms_Atoms_PseudoElement_firstLetter: GkAtoms_Atoms = 2453;
            pub const GkAtoms_Atoms_PseudoElement_firstLine: GkAtoms_Atoms = 2454;
            pub const GkAtoms_Atoms_PseudoElement_highlight: GkAtoms_Atoms = 2455;
            pub const GkAtoms_Atoms_PseudoElement_selection: GkAtoms_Atoms = 2456;
            pub const GkAtoms_Atoms_PseudoElement_targetText: GkAtoms_Atoms = 2457;
            pub const GkAtoms_Atoms_PseudoElement_viewTransition: GkAtoms_Atoms = 2458;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionGroup: GkAtoms_Atoms = 2459;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionImagePair: GkAtoms_Atoms = 2460;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionOld: GkAtoms_Atoms = 2461;
            pub const GkAtoms_Atoms_PseudoElement_viewTransitionNew: GkAtoms_Atoms = 2462;
            pub const GkAtoms_Atoms_PseudoElement_mozSnapshotContainingBlock: GkAtoms_Atoms = 2463;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinBox: GkAtoms_Atoms = 2464;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinUp: GkAtoms_Atoms = 2465;
            pub const GkAtoms_Atoms_PseudoElement_mozNumberSpinDown: GkAtoms_Atoms = 2466;
            pub const GkAtoms_Atoms_PseudoElement_mozSearchClearButton: GkAtoms_Atoms = 2467;
            pub const GkAtoms_Atoms_PseudoElement_mozProgressBar: GkAtoms_Atoms = 2468;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeTrack: GkAtoms_Atoms = 2469;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeProgress: GkAtoms_Atoms = 2470;
            pub const GkAtoms_Atoms_PseudoElement_mozRangeThumb: GkAtoms_Atoms = 2471;
            pub const GkAtoms_Atoms_PseudoElement_mozMeterBar: GkAtoms_Atoms = 2472;
            pub const GkAtoms_Atoms_PseudoElement_placeholder: GkAtoms_Atoms = 2473;
            pub const GkAtoms_Atoms_PseudoElement_mozColorSwatch: GkAtoms_Atoms = 2474;
            pub const GkAtoms_Atoms_PseudoElement_mozTextControlEditingRoot: GkAtoms_Atoms = 2475;
            pub const GkAtoms_Atoms_PseudoElement_mozTextControlPreview: GkAtoms_Atoms = 2476;
            pub const GkAtoms_Atoms_PseudoElement_mozReveal: GkAtoms_Atoms = 2477;
            pub const GkAtoms_Atoms_PseudoElement_fileSelectorButton: GkAtoms_Atoms = 2478;
            pub const GkAtoms_Atoms_PseudoElement_sliderTrack: GkAtoms_Atoms = 2479;
            pub const GkAtoms_Atoms_PseudoElement_sliderThumb: GkAtoms_Atoms = 2480;
            pub const GkAtoms_Atoms_PseudoElement_sliderFill: GkAtoms_Atoms = 2481;
            pub const GkAtoms_Atoms_PseudoElement_detailsContent: GkAtoms_Atoms = 2482;
            pub const GkAtoms_Atoms_AnonBox_oofPlaceholder: GkAtoms_Atoms = 2483;
            pub const GkAtoms_Atoms_AnonBox_horizontalFramesetBorder: GkAtoms_Atoms = 2484;
            pub const GkAtoms_Atoms_AnonBox_verticalFramesetBorder: GkAtoms_Atoms = 2485;
            pub const GkAtoms_Atoms_AnonBox_framesetBlank: GkAtoms_Atoms = 2486;
            pub const GkAtoms_Atoms_AnonBox_tableColGroup: GkAtoms_Atoms = 2487;
            pub const GkAtoms_Atoms_AnonBox_tableCol: GkAtoms_Atoms = 2488;
            pub const GkAtoms_Atoms_AnonBox_page: GkAtoms_Atoms = 2489;
            pub const GkAtoms_Atoms_AnonBox_pageBreak: GkAtoms_Atoms = 2490;
            pub const GkAtoms_Atoms_AnonBox_pageContent: GkAtoms_Atoms = 2491;
            pub const GkAtoms_Atoms_AnonBox_printedSheet: GkAtoms_Atoms = 2492;
            pub const GkAtoms_Atoms_AnonBox_columnSpanWrapper: GkAtoms_Atoms = 2493;
            pub const GkAtoms_Atoms_AnonBox_mozText: GkAtoms_Atoms = 2494;
            pub const GkAtoms_Atoms_AnonBox_firstLetterContinuation: GkAtoms_Atoms = 2495;
            pub const GkAtoms_Atoms_AnonBox_mozBlockInsideInlineWrapper: GkAtoms_Atoms = 2496;
            pub const GkAtoms_Atoms_AnonBox_mozMathMLAnonymousBlock: GkAtoms_Atoms = 2497;
            pub const GkAtoms_Atoms_AnonBox_mozLineFrame: GkAtoms_Atoms = 2498;
            pub const GkAtoms_Atoms_AnonBox_cellContent: GkAtoms_Atoms = 2499;
            pub const GkAtoms_Atoms_AnonBox_dropDownList: GkAtoms_Atoms = 2500;
            pub const GkAtoms_Atoms_AnonBox_fieldsetContent: GkAtoms_Atoms = 2501;
            pub const GkAtoms_Atoms_AnonBox_htmlCanvasContent: GkAtoms_Atoms = 2502;
            pub const GkAtoms_Atoms_AnonBox_inlineTable: GkAtoms_Atoms = 2503;
            pub const GkAtoms_Atoms_AnonBox_table: GkAtoms_Atoms = 2504;
            pub const GkAtoms_Atoms_AnonBox_tableCell: GkAtoms_Atoms = 2505;
            pub const GkAtoms_Atoms_AnonBox_tableWrapper: GkAtoms_Atoms = 2506;
            pub const GkAtoms_Atoms_AnonBox_tableRowGroup: GkAtoms_Atoms = 2507;
            pub const GkAtoms_Atoms_AnonBox_tableRow: GkAtoms_Atoms = 2508;
            pub const GkAtoms_Atoms_AnonBox_canvas: GkAtoms_Atoms = 2509;
            pub const GkAtoms_Atoms_AnonBox_pageSequence: GkAtoms_Atoms = 2510;
            pub const GkAtoms_Atoms_AnonBox_scrolledContent: GkAtoms_Atoms = 2511;
            pub const GkAtoms_Atoms_AnonBox_scrolledCanvas: GkAtoms_Atoms = 2512;
            pub const GkAtoms_Atoms_AnonBox_columnSet: GkAtoms_Atoms = 2513;
            pub const GkAtoms_Atoms_AnonBox_columnContent: GkAtoms_Atoms = 2514;
            pub const GkAtoms_Atoms_AnonBox_viewport: GkAtoms_Atoms = 2515;
            pub const GkAtoms_Atoms_AnonBox_viewportScroll: GkAtoms_Atoms = 2516;
            pub const GkAtoms_Atoms_AnonBox_anonymousItem: GkAtoms_Atoms = 2517;
            pub const GkAtoms_Atoms_AnonBox_blockRubyContent: GkAtoms_Atoms = 2518;
            pub const GkAtoms_Atoms_AnonBox_ruby: GkAtoms_Atoms = 2519;
            pub const GkAtoms_Atoms_AnonBox_rubyBase: GkAtoms_Atoms = 2520;
            pub const GkAtoms_Atoms_AnonBox_rubyBaseContainer: GkAtoms_Atoms = 2521;
            pub const GkAtoms_Atoms_AnonBox_rubyText: GkAtoms_Atoms = 2522;
            pub const GkAtoms_Atoms_AnonBox_rubyTextContainer: GkAtoms_Atoms = 2523;
            pub const GkAtoms_Atoms_AnonBox_mozTreeColumn: GkAtoms_Atoms = 2524;
            pub const GkAtoms_Atoms_AnonBox_mozTreeRow: GkAtoms_Atoms = 2525;
            pub const GkAtoms_Atoms_AnonBox_mozTreeSeparator: GkAtoms_Atoms = 2526;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCell: GkAtoms_Atoms = 2527;
            pub const GkAtoms_Atoms_AnonBox_mozTreeIndentation: GkAtoms_Atoms = 2528;
            pub const GkAtoms_Atoms_AnonBox_mozTreeLine: GkAtoms_Atoms = 2529;
            pub const GkAtoms_Atoms_AnonBox_mozTreeTwisty: GkAtoms_Atoms = 2530;
            pub const GkAtoms_Atoms_AnonBox_mozTreeImage: GkAtoms_Atoms = 2531;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCellText: GkAtoms_Atoms = 2532;
            pub const GkAtoms_Atoms_AnonBox_mozTreeCheckbox: GkAtoms_Atoms = 2533;
            pub const GkAtoms_Atoms_AnonBox_mozTreeDropFeedback: GkAtoms_Atoms = 2534;
            pub const GkAtoms_Atoms_AnonBox_mozSVGMarkerAnonChild: GkAtoms_Atoms = 2535;
            pub const GkAtoms_Atoms_AnonBox_mozSVGOuterSVGAnonChild: GkAtoms_Atoms = 2536;
            pub const GkAtoms_Atoms_AnonBox_mozSVGForeignContent: GkAtoms_Atoms = 2537;
            pub const GkAtoms_Atoms_AnonBox_mozSVGText: GkAtoms_Atoms = 2538;
            pub const GkAtoms_Atoms_xlink: GkAtoms_Atoms = 2539;
            pub const GkAtoms_Atoms_xml_space: GkAtoms_Atoms = 2540;
            pub const GkAtoms_Atoms_xml_lang: GkAtoms_Atoms = 2541;
            pub const GkAtoms_Atoms_aria_grab: GkAtoms_Atoms = 2542;
            pub const GkAtoms_Atoms_aria_channel: GkAtoms_Atoms = 2543;
            pub const GkAtoms_Atoms_aria_secret: GkAtoms_Atoms = 2544;
            pub const GkAtoms_Atoms_aria_templateid: GkAtoms_Atoms = 2545;
            pub const GkAtoms_Atoms_aria_datatype: GkAtoms_Atoms = 2546;
            pub const GkAtoms_Atoms_local: GkAtoms_Atoms = 2547;
            pub const GkAtoms_Atoms_xchannelselector: GkAtoms_Atoms = 2548;
            pub const GkAtoms_Atoms_ychannelselector: GkAtoms_Atoms = 2549;
            pub const GkAtoms_Atoms_enable_background: GkAtoms_Atoms = 2550;
            pub const GkAtoms_Atoms_calcmode: GkAtoms_Atoms = 2551;
            pub const GkAtoms_Atoms_specularexponent: GkAtoms_Atoms = 2552;
            pub const GkAtoms_Atoms_specularconstant: GkAtoms_Atoms = 2553;
            pub const GkAtoms_Atoms_gradienttransform: GkAtoms_Atoms = 2554;
            pub const GkAtoms_Atoms_gradientunits: GkAtoms_Atoms = 2555;
            pub const GkAtoms_Atoms_rendering_intent: GkAtoms_Atoms = 2556;
            pub const GkAtoms_Atoms_shadowrootmode: GkAtoms_Atoms = 2557;
            pub const GkAtoms_Atoms_shadowrootclonable: GkAtoms_Atoms = 2558;
            pub const GkAtoms_Atoms_shadowrootserializable: GkAtoms_Atoms = 2559;
            pub const GkAtoms_Atoms_stddeviation: GkAtoms_Atoms = 2560;
            pub const GkAtoms_Atoms_shadowrootdelegatesfocus: GkAtoms_Atoms = 2561;
            pub const GkAtoms_Atoms_basefrequency: GkAtoms_Atoms = 2562;
            pub const GkAtoms_Atoms_baseprofile: GkAtoms_Atoms = 2563;
            pub const GkAtoms_Atoms_baseProfile: GkAtoms_Atoms = 2564;
            pub const GkAtoms_Atoms_edgemode: GkAtoms_Atoms = 2565;
            pub const GkAtoms_Atoms_repeatcount: GkAtoms_Atoms = 2566;
            pub const GkAtoms_Atoms_repeatdur: GkAtoms_Atoms = 2567;
            pub const GkAtoms_Atoms_spreadmethod: GkAtoms_Atoms = 2568;
            pub const GkAtoms_Atoms_diffuseconstant: GkAtoms_Atoms = 2569;
            pub const GkAtoms_Atoms_surfacescale: GkAtoms_Atoms = 2570;
            pub const GkAtoms_Atoms_lengthadjust: GkAtoms_Atoms = 2571;
            pub const GkAtoms_Atoms_origin: GkAtoms_Atoms = 2572;
            pub const GkAtoms_Atoms_targetx: GkAtoms_Atoms = 2573;
            pub const GkAtoms_Atoms_targety: GkAtoms_Atoms = 2574;
            pub const GkAtoms_Atoms_pathlength: GkAtoms_Atoms = 2575;
            pub const GkAtoms_Atoms_definitionurl: GkAtoms_Atoms = 2576;
            pub const GkAtoms_Atoms_limitingconeangle: GkAtoms_Atoms = 2577;
            pub const GkAtoms_Atoms_markerheight: GkAtoms_Atoms = 2578;
            pub const GkAtoms_Atoms_markerwidth: GkAtoms_Atoms = 2579;
            pub const GkAtoms_Atoms_maskunits: GkAtoms_Atoms = 2580;
            pub const GkAtoms_Atoms_markerunits: GkAtoms_Atoms = 2581;
            pub const GkAtoms_Atoms_maskcontentunits: GkAtoms_Atoms = 2582;
            pub const GkAtoms_Atoms_tablevalues: GkAtoms_Atoms = 2583;
            pub const GkAtoms_Atoms_primitiveunits: GkAtoms_Atoms = 2584;
            pub const GkAtoms_Atoms_zoomandpan: GkAtoms_Atoms = 2585;
            pub const GkAtoms_Atoms_kernelmatrix: GkAtoms_Atoms = 2586;
            pub const GkAtoms_Atoms_kerning: GkAtoms_Atoms = 2587;
            pub const GkAtoms_Atoms_kernelunitlength: GkAtoms_Atoms = 2588;
            pub const GkAtoms_Atoms_pointsatx: GkAtoms_Atoms = 2589;
            pub const GkAtoms_Atoms_pointsaty: GkAtoms_Atoms = 2590;
            pub const GkAtoms_Atoms_pointsatz: GkAtoms_Atoms = 2591;
            pub const GkAtoms_Atoms_xlink_href: GkAtoms_Atoms = 2592;
            pub const GkAtoms_Atoms_xlink_title: GkAtoms_Atoms = 2593;
            pub const GkAtoms_Atoms_xlink_role: GkAtoms_Atoms = 2594;
            pub const GkAtoms_Atoms_xlink_arcrole: GkAtoms_Atoms = 2595;
            pub const GkAtoms_Atoms_arcrole: GkAtoms_Atoms = 2596;
            pub const GkAtoms_Atoms_xmlns_xlink: GkAtoms_Atoms = 2597;
            pub const GkAtoms_Atoms_xlink_type: GkAtoms_Atoms = 2598;
            pub const GkAtoms_Atoms_xlink_show: GkAtoms_Atoms = 2599;
            pub const GkAtoms_Atoms_xlink_actuate: GkAtoms_Atoms = 2600;
            pub const GkAtoms_Atoms_autocorrect: GkAtoms_Atoms = 2601;
            pub const GkAtoms_Atoms_color_rendering: GkAtoms_Atoms = 2602;
            pub const GkAtoms_Atoms_numoctaves: GkAtoms_Atoms = 2603;
            pub const GkAtoms_Atoms_onmousewheel: GkAtoms_Atoms = 2604;
            pub const GkAtoms_Atoms_clippathunits: GkAtoms_Atoms = 2605;
            pub const GkAtoms_Atoms_glyph_orientation_vertical: GkAtoms_Atoms = 2606;
            pub const GkAtoms_Atoms_glyph_orientation_horizontal: GkAtoms_Atoms = 2607;
            pub const GkAtoms_Atoms_glyphref: GkAtoms_Atoms = 2608;
            pub const GkAtoms_Atoms_keypoints: GkAtoms_Atoms = 2609;
            pub const GkAtoms_Atoms_attributename: GkAtoms_Atoms = 2610;
            pub const GkAtoms_Atoms_attributetype: GkAtoms_Atoms = 2611;
            pub const GkAtoms_Atoms_startoffset: GkAtoms_Atoms = 2612;
            pub const GkAtoms_Atoms_keysplines: GkAtoms_Atoms = 2613;
            pub const GkAtoms_Atoms_preservealpha: GkAtoms_Atoms = 2614;
            pub const GkAtoms_Atoms_preserveaspectratio: GkAtoms_Atoms = 2615;
            pub const GkAtoms_Atoms_alttext: GkAtoms_Atoms = 2616;
            pub const GkAtoms_Atoms_filterunits: GkAtoms_Atoms = 2617;
            pub const GkAtoms_Atoms_keytimes: GkAtoms_Atoms = 2618;
            pub const GkAtoms_Atoms_patterntransform: GkAtoms_Atoms = 2619;
            pub const GkAtoms_Atoms_patternunits: GkAtoms_Atoms = 2620;
            pub const GkAtoms_Atoms_patterncontentunits: GkAtoms_Atoms = 2621;
            pub const GkAtoms_Atoms_stitchtiles: GkAtoms_Atoms = 2622;
            pub const GkAtoms_Atoms_systemlanguage: GkAtoms_Atoms = 2623;
            pub const GkAtoms_Atoms_textlength: GkAtoms_Atoms = 2624;
            pub const GkAtoms_Atoms_requiredfeatures: GkAtoms_Atoms = 2625;
            pub const GkAtoms_Atoms_requiredextensions: GkAtoms_Atoms = 2626;
            pub const GkAtoms_Atoms_viewtarget: GkAtoms_Atoms = 2627;
            pub const GkAtoms_Atoms_viewbox: GkAtoms_Atoms = 2628;
            pub const GkAtoms_Atoms_refx: GkAtoms_Atoms = 2629;
            pub const GkAtoms_Atoms_refy: GkAtoms_Atoms = 2630;
            pub const GkAtoms_Atoms_fefunca: GkAtoms_Atoms = 2631;
            pub const GkAtoms_Atoms_fefuncb: GkAtoms_Atoms = 2632;
            pub const GkAtoms_Atoms_feblend: GkAtoms_Atoms = 2633;
            pub const GkAtoms_Atoms_feflood: GkAtoms_Atoms = 2634;
            pub const GkAtoms_Atoms_feturbulence: GkAtoms_Atoms = 2635;
            pub const GkAtoms_Atoms_femergenode: GkAtoms_Atoms = 2636;
            pub const GkAtoms_Atoms_feimage: GkAtoms_Atoms = 2637;
            pub const GkAtoms_Atoms_femerge: GkAtoms_Atoms = 2638;
            pub const GkAtoms_Atoms_fetile: GkAtoms_Atoms = 2639;
            pub const GkAtoms_Atoms_fecomposite: GkAtoms_Atoms = 2640;
            pub const GkAtoms_Atoms_altglyphdef: GkAtoms_Atoms = 2641;
            pub const GkAtoms_Atoms_altGlyphDef: GkAtoms_Atoms = 2642;
            pub const GkAtoms_Atoms_fefuncg: GkAtoms_Atoms = 2643;
            pub const GkAtoms_Atoms_fediffuselighting: GkAtoms_Atoms = 2644;
            pub const GkAtoms_Atoms_fespecularlighting: GkAtoms_Atoms = 2645;
            pub const GkAtoms_Atoms_altglyph: GkAtoms_Atoms = 2646;
            pub const GkAtoms_Atoms_altGlyph: GkAtoms_Atoms = 2647;
            pub const GkAtoms_Atoms_clippath: GkAtoms_Atoms = 2648;
            pub const GkAtoms_Atoms_textpath: GkAtoms_Atoms = 2649;
            pub const GkAtoms_Atoms_altglyphitem: GkAtoms_Atoms = 2650;
            pub const GkAtoms_Atoms_altGlyphItem: GkAtoms_Atoms = 2651;
            pub const GkAtoms_Atoms_animatetransform: GkAtoms_Atoms = 2652;
            pub const GkAtoms_Atoms_animatemotion: GkAtoms_Atoms = 2653;
            pub const GkAtoms_Atoms_fedisplacementmap: GkAtoms_Atoms = 2654;
            pub const GkAtoms_Atoms_animatecolor: GkAtoms_Atoms = 2655;
            pub const GkAtoms_Atoms_fefuncr: GkAtoms_Atoms = 2656;
            pub const GkAtoms_Atoms_fecomponenttransfer: GkAtoms_Atoms = 2657;
            pub const GkAtoms_Atoms_fegaussianblur: GkAtoms_Atoms = 2658;
            pub const GkAtoms_Atoms_foreignobject: GkAtoms_Atoms = 2659;
            pub const GkAtoms_Atoms_feoffset: GkAtoms_Atoms = 2660;
            pub const GkAtoms_Atoms_fespotlight: GkAtoms_Atoms = 2661;
            pub const GkAtoms_Atoms_fepointlight: GkAtoms_Atoms = 2662;
            pub const GkAtoms_Atoms_fedistantlight: GkAtoms_Atoms = 2663;
            pub const GkAtoms_Atoms_lineargradient: GkAtoms_Atoms = 2664;
            pub const GkAtoms_Atoms_radialgradient: GkAtoms_Atoms = 2665;
            pub const GkAtoms_Atoms_fedropshadow: GkAtoms_Atoms = 2666;
            pub const GkAtoms_Atoms_fecolormatrix: GkAtoms_Atoms = 2667;
            pub const GkAtoms_Atoms_feconvolvematrix: GkAtoms_Atoms = 2668;
            pub const GkAtoms_Atoms_femorphology: GkAtoms_Atoms = 2669;
            pub const GkAtoms_Atoms_AtomsCount: GkAtoms_Atoms = 2670;
            pub type GkAtoms_Atoms = ::std::os::raw::c_int;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of GkAtoms"][::std::mem::size_of::<GkAtoms>() - 95708usize];
                ["Alignment of GkAtoms"][::std::mem::align_of::<GkAtoms>() - 4usize];
                ["Offset of field: GkAtoms::SystemPrincipal_string"]
                    [::std::mem::offset_of!(GkAtoms, SystemPrincipal_string) - 0usize];
                ["Offset of field: GkAtoms::_empty_string"]
                    [::std::mem::offset_of!(GkAtoms, _empty_string) - 38usize];
                ["Offset of field: GkAtoms::_0_string"]
                    [::std::mem::offset_of!(GkAtoms, _0_string) - 40usize];
                ["Offset of field: GkAtoms::_1_string"]
                    [::std::mem::offset_of!(GkAtoms, _1_string) - 44usize];
                ["Offset of field: GkAtoms::_2_string"]
                    [::std::mem::offset_of!(GkAtoms, _2_string) - 48usize];
                ["Offset of field: GkAtoms::_3_string"]
                    [::std::mem::offset_of!(GkAtoms, _3_string) - 52usize];
                ["Offset of field: GkAtoms::_4_string"]
                    [::std::mem::offset_of!(GkAtoms, _4_string) - 56usize];
                ["Offset of field: GkAtoms::_5_string"]
                    [::std::mem::offset_of!(GkAtoms, _5_string) - 60usize];
                ["Offset of field: GkAtoms::_6_string"]
                    [::std::mem::offset_of!(GkAtoms, _6_string) - 64usize];
                ["Offset of field: GkAtoms::_7_string"]
                    [::std::mem::offset_of!(GkAtoms, _7_string) - 68usize];
                ["Offset of field: GkAtoms::_8_string"]
                    [::std::mem::offset_of!(GkAtoms, _8_string) - 72usize];
                ["Offset of field: GkAtoms::_9_string"]
                    [::std::mem::offset_of!(GkAtoms, _9_string) - 76usize];
                ["Offset of field: GkAtoms::mozframetype_string"]
                    [::std::mem::offset_of!(GkAtoms, mozframetype_string) - 80usize];
                ["Offset of field: GkAtoms::_moz_abspos_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_abspos_string) - 106usize];
                ["Offset of field: GkAtoms::_moz_activated_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_activated_string) - 130usize];
                ["Offset of field: GkAtoms::_moz_anonclass_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_anonclass_string) - 160usize];
                ["Offset of field: GkAtoms::_moz_resizing_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_resizing_string) - 190usize];
                ["Offset of field: GkAtoms::moztype_string"]
                    [::std::mem::offset_of!(GkAtoms, moztype_string) - 218usize];
                ["Offset of field: GkAtoms::mozdirty_string"]
                    [::std::mem::offset_of!(GkAtoms, mozdirty_string) - 238usize];
                ["Offset of field: GkAtoms::mozdisallowselectionprint_string"]
                    [::std::mem::offset_of!(GkAtoms, mozdisallowselectionprint_string) - 260usize];
                ["Offset of field: GkAtoms::mozdonotsend_string"]
                    [::std::mem::offset_of!(GkAtoms, mozdonotsend_string) - 312usize];
                ["Offset of field: GkAtoms::mozfwcontainer_string"]
                    [::std::mem::offset_of!(GkAtoms, mozfwcontainer_string) - 344usize];
                ["Offset of field: GkAtoms::mozgeneratedcontentbefore_string"]
                    [::std::mem::offset_of!(GkAtoms, mozgeneratedcontentbefore_string) - 388usize];
                ["Offset of field: GkAtoms::mozgeneratedcontentafter_string"]
                    [::std::mem::offset_of!(GkAtoms, mozgeneratedcontentafter_string) - 448usize];
                ["Offset of field: GkAtoms::mozgeneratedcontentmarker_string"]
                    [::std::mem::offset_of!(GkAtoms, mozgeneratedcontentmarker_string) - 506usize];
                ["Offset of field: GkAtoms::mozgeneratedcontentimage_string"]
                    [::std::mem::offset_of!(GkAtoms, mozgeneratedcontentimage_string) - 566usize];
                ["Offset of field: GkAtoms::mozquote_string"]
                    [::std::mem::offset_of!(GkAtoms, mozquote_string) - 624usize];
                ["Offset of field: GkAtoms::mozsignature_string"]
                    [::std::mem::offset_of!(GkAtoms, mozsignature_string) - 646usize];
                ["Offset of field: GkAtoms::_moz_bullet_font_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_bullet_font_string) - 674usize];
                ["Offset of field: GkAtoms::_moz_is_glyph_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_is_glyph_string) - 708usize];
                ["Offset of field: GkAtoms::_moz_in_android_pip_mode_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_in_android_pip_mode_string) - 736usize];
                ["Offset of field: GkAtoms::_moz_original_size_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_original_size_string) - 786usize];
                ["Offset of field: GkAtoms::_moz_print_preview_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_print_preview_string) - 824usize];
                ["Offset of field: GkAtoms::menuactive_string"]
                    [::std::mem::offset_of!(GkAtoms, menuactive_string) - 862usize];
                ["Offset of field: GkAtoms::_poundDefault_string"]
                    [::std::mem::offset_of!(GkAtoms, _poundDefault_string) - 894usize];
                ["Offset of field: GkAtoms::_asterisk_string"]
                    [::std::mem::offset_of!(GkAtoms, _asterisk_string) - 912usize];
                ["Offset of field: GkAtoms::a_string"]
                    [::std::mem::offset_of!(GkAtoms, a_string) - 916usize];
                ["Offset of field: GkAtoms::abbr_string"]
                    [::std::mem::offset_of!(GkAtoms, abbr_string) - 920usize];
                ["Offset of field: GkAtoms::abort_string"]
                    [::std::mem::offset_of!(GkAtoms, abort_string) - 930usize];
                ["Offset of field: GkAtoms::above_string"]
                    [::std::mem::offset_of!(GkAtoms, above_string) - 942usize];
                ["Offset of field: GkAtoms::acceltext_string"]
                    [::std::mem::offset_of!(GkAtoms, acceltext_string) - 954usize];
                ["Offset of field: GkAtoms::accept_string"]
                    [::std::mem::offset_of!(GkAtoms, accept_string) - 974usize];
                ["Offset of field: GkAtoms::acceptcharset_string"]
                    [::std::mem::offset_of!(GkAtoms, acceptcharset_string) - 988usize];
                ["Offset of field: GkAtoms::accessiblenode_string"]
                    [::std::mem::offset_of!(GkAtoms, accessiblenode_string) - 1018usize];
                ["Offset of field: GkAtoms::accesskey_string"]
                    [::std::mem::offset_of!(GkAtoms, accesskey_string) - 1050usize];
                ["Offset of field: GkAtoms::acronym_string"]
                    [::std::mem::offset_of!(GkAtoms, acronym_string) - 1070usize];
                ["Offset of field: GkAtoms::action_string"]
                    [::std::mem::offset_of!(GkAtoms, action_string) - 1086usize];
                ["Offset of field: GkAtoms::active_string"]
                    [::std::mem::offset_of!(GkAtoms, active_string) - 1100usize];
                ["Offset of field: GkAtoms::activateontab_string"]
                    [::std::mem::offset_of!(GkAtoms, activateontab_string) - 1114usize];
                ["Offset of field: GkAtoms::actuate_string"]
                    [::std::mem::offset_of!(GkAtoms, actuate_string) - 1142usize];
                ["Offset of field: GkAtoms::address_string"]
                    [::std::mem::offset_of!(GkAtoms, address_string) - 1158usize];
                ["Offset of field: GkAtoms::adoptedsheetclones_string"]
                    [::std::mem::offset_of!(GkAtoms, adoptedsheetclones_string) - 1174usize];
                ["Offset of field: GkAtoms::adult_string"]
                    [::std::mem::offset_of!(GkAtoms, adult_string) - 1212usize];
                ["Offset of field: GkAtoms::after_string"]
                    [::std::mem::offset_of!(GkAtoms, after_string) - 1224usize];
                ["Offset of field: GkAtoms::align_string"]
                    [::std::mem::offset_of!(GkAtoms, align_string) - 1236usize];
                ["Offset of field: GkAtoms::alink_string"]
                    [::std::mem::offset_of!(GkAtoms, alink_string) - 1248usize];
                ["Offset of field: GkAtoms::all_string"]
                    [::std::mem::offset_of!(GkAtoms, all_string) - 1260usize];
                ["Offset of field: GkAtoms::allow_string"]
                    [::std::mem::offset_of!(GkAtoms, allow_string) - 1268usize];
                ["Offset of field: GkAtoms::allowdownloads_string"]
                    [::std::mem::offset_of!(GkAtoms, allowdownloads_string) - 1280usize];
                ["Offset of field: GkAtoms::allowevents_string"]
                    [::std::mem::offset_of!(GkAtoms, allowevents_string) - 1312usize];
                ["Offset of field: GkAtoms::allowforms_string"]
                    [::std::mem::offset_of!(GkAtoms, allowforms_string) - 1336usize];
                ["Offset of field: GkAtoms::allowfullscreen_string"]
                    [::std::mem::offset_of!(GkAtoms, allowfullscreen_string) - 1360usize];
                ["Offset of field: GkAtoms::allowmodals_string"]
                    [::std::mem::offset_of!(GkAtoms, allowmodals_string) - 1392usize];
                ["Offset of field: GkAtoms::alloworientationlock_string"]
                    [::std::mem::offset_of!(GkAtoms, alloworientationlock_string) - 1418usize];
                ["Offset of field: GkAtoms::allowpointerlock_string"]
                    [::std::mem::offset_of!(GkAtoms, allowpointerlock_string) - 1464usize];
                ["Offset of field: GkAtoms::allowpopupstoescapesandbox_string"][::std::mem::offset_of!(
                    GkAtoms,
                    allowpopupstoescapesandbox_string
                ) - 1502usize];
                ["Offset of field: GkAtoms::allowpopups_string"]
                    [::std::mem::offset_of!(GkAtoms, allowpopups_string) - 1564usize];
                ["Offset of field: GkAtoms::allowpresentation_string"]
                    [::std::mem::offset_of!(GkAtoms, allowpresentation_string) - 1590usize];
                ["Offset of field: GkAtoms::allowstorageaccessbyuseractivatetion_string"][::std::mem::offset_of!(
                    GkAtoms,
                    allowstorageaccessbyuseractivatetion_string
                )
                    - 1628usize];
                ["Offset of field: GkAtoms::allowsameorigin_string"]
                    [::std::mem::offset_of!(GkAtoms, allowsameorigin_string) - 1708usize];
                ["Offset of field: GkAtoms::allowscripts_string"]
                    [::std::mem::offset_of!(GkAtoms, allowscripts_string) - 1744usize];
                ["Offset of field: GkAtoms::allowscriptstoclose_string"]
                    [::std::mem::offset_of!(GkAtoms, allowscriptstoclose_string) - 1772usize];
                ["Offset of field: GkAtoms::allowtopnavigation_string"]
                    [::std::mem::offset_of!(GkAtoms, allowtopnavigation_string) - 1812usize];
                ["Offset of field: GkAtoms::allowtopnavigationbyuseractivation_string"][::std::mem::offset_of!(
                    GkAtoms,
                    allowtopnavigationbyuseractivation_string
                )
                    - 1854usize];
                ["Offset of field: GkAtoms::allowtopnavigationcustomprotocols_string"][::std::mem::offset_of!(
                    GkAtoms,
                    allowtopnavigationcustomprotocols_string
                )
                    - 1934usize];
                ["Offset of field: GkAtoms::allowuntrusted_string"]
                    [::std::mem::offset_of!(GkAtoms, allowuntrusted_string) - 2016usize];
                ["Offset of field: GkAtoms::alt_string"]
                    [::std::mem::offset_of!(GkAtoms, alt_string) - 2046usize];
                ["Offset of field: GkAtoms::alternate_string"]
                    [::std::mem::offset_of!(GkAtoms, alternate_string) - 2054usize];
                ["Offset of field: GkAtoms::always_string"]
                    [::std::mem::offset_of!(GkAtoms, always_string) - 2074usize];
                ["Offset of field: GkAtoms::ancestor_string"]
                    [::std::mem::offset_of!(GkAtoms, ancestor_string) - 2088usize];
                ["Offset of field: GkAtoms::ancestorOrSelf_string"]
                    [::std::mem::offset_of!(GkAtoms, ancestorOrSelf_string) - 2106usize];
                ["Offset of field: GkAtoms::anchor_string"]
                    [::std::mem::offset_of!(GkAtoms, anchor_string) - 2140usize];
                ["Offset of field: GkAtoms::_and_string"]
                    [::std::mem::offset_of!(GkAtoms, _and_string) - 2154usize];
                ["Offset of field: GkAtoms::animations_string"]
                    [::std::mem::offset_of!(GkAtoms, animations_string) - 2162usize];
                ["Offset of field: GkAtoms::anonid_string"]
                    [::std::mem::offset_of!(GkAtoms, anonid_string) - 2184usize];
                ["Offset of field: GkAtoms::anonlocation_string"]
                    [::std::mem::offset_of!(GkAtoms, anonlocation_string) - 2198usize];
                ["Offset of field: GkAtoms::any_string"]
                    [::std::mem::offset_of!(GkAtoms, any_string) - 2224usize];
                ["Offset of field: GkAtoms::any_hover_string"]
                    [::std::mem::offset_of!(GkAtoms, any_hover_string) - 2232usize];
                ["Offset of field: GkAtoms::any_pointer_string"]
                    [::std::mem::offset_of!(GkAtoms, any_pointer_string) - 2252usize];
                ["Offset of field: GkAtoms::applet_string"]
                    [::std::mem::offset_of!(GkAtoms, applet_string) - 2276usize];
                ["Offset of field: GkAtoms::applyImports_string"]
                    [::std::mem::offset_of!(GkAtoms, applyImports_string) - 2290usize];
                ["Offset of field: GkAtoms::applyTemplates_string"]
                    [::std::mem::offset_of!(GkAtoms, applyTemplates_string) - 2318usize];
                ["Offset of field: GkAtoms::archive_string"]
                    [::std::mem::offset_of!(GkAtoms, archive_string) - 2350usize];
                ["Offset of field: GkAtoms::area_string"]
                    [::std::mem::offset_of!(GkAtoms, area_string) - 2366usize];
                ["Offset of field: GkAtoms::aria_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_string) - 2376usize];
                ["Offset of field: GkAtoms::aria_actions_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_actions_string) - 2386usize];
                ["Offset of field: GkAtoms::aria_activedescendant_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_activedescendant_string) - 2412usize];
                ["Offset of field: GkAtoms::aria_atomic_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_atomic_string) - 2456usize];
                ["Offset of field: GkAtoms::aria_autocomplete_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_autocomplete_string) - 2480usize];
                ["Offset of field: GkAtoms::aria_braillelabel_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_braillelabel_string) - 2516usize];
                ["Offset of field: GkAtoms::aria_brailleroledescription_string"][::std::mem::offset_of!(
                    GkAtoms,
                    aria_brailleroledescription_string
                ) - 2552usize];
                ["Offset of field: GkAtoms::aria_busy_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_busy_string) - 2608usize];
                ["Offset of field: GkAtoms::aria_checked_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_checked_string) - 2628usize];
                ["Offset of field: GkAtoms::aria_controls_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_controls_string) - 2654usize];
                ["Offset of field: GkAtoms::aria_current_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_current_string) - 2682usize];
                ["Offset of field: GkAtoms::aria_describedby_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_describedby_string) - 2708usize];
                ["Offset of field: GkAtoms::aria_description_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_description_string) - 2742usize];
                ["Offset of field: GkAtoms::aria_disabled_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_disabled_string) - 2776usize];
                ["Offset of field: GkAtoms::aria_dropeffect_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_dropeffect_string) - 2804usize];
                ["Offset of field: GkAtoms::aria_expanded_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_expanded_string) - 2836usize];
                ["Offset of field: GkAtoms::aria_flowto_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_flowto_string) - 2864usize];
                ["Offset of field: GkAtoms::aria_haspopup_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_haspopup_string) - 2888usize];
                ["Offset of field: GkAtoms::aria_hidden_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_hidden_string) - 2916usize];
                ["Offset of field: GkAtoms::aria_invalid_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_invalid_string) - 2940usize];
                ["Offset of field: GkAtoms::aria_labelledby_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_labelledby_string) - 2966usize];
                ["Offset of field: GkAtoms::aria_level_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_level_string) - 2998usize];
                ["Offset of field: GkAtoms::aria_live_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_live_string) - 3020usize];
                ["Offset of field: GkAtoms::aria_multiline_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_multiline_string) - 3040usize];
                ["Offset of field: GkAtoms::aria_multiselectable_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_multiselectable_string) - 3070usize];
                ["Offset of field: GkAtoms::aria_owns_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_owns_string) - 3112usize];
                ["Offset of field: GkAtoms::aria_posinset_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_posinset_string) - 3132usize];
                ["Offset of field: GkAtoms::aria_pressed_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_pressed_string) - 3160usize];
                ["Offset of field: GkAtoms::aria_readonly_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_readonly_string) - 3186usize];
                ["Offset of field: GkAtoms::aria_relevant_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_relevant_string) - 3214usize];
                ["Offset of field: GkAtoms::aria_required_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_required_string) - 3242usize];
                ["Offset of field: GkAtoms::aria_selected_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_selected_string) - 3270usize];
                ["Offset of field: GkAtoms::aria_setsize_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_setsize_string) - 3298usize];
                ["Offset of field: GkAtoms::aria_sort_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_sort_string) - 3324usize];
                ["Offset of field: GkAtoms::aria_valuemax_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_valuemax_string) - 3344usize];
                ["Offset of field: GkAtoms::aria_valuemin_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_valuemin_string) - 3372usize];
                ["Offset of field: GkAtoms::aria_valuenow_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_valuenow_string) - 3400usize];
                ["Offset of field: GkAtoms::arrow_string"]
                    [::std::mem::offset_of!(GkAtoms, arrow_string) - 3428usize];
                ["Offset of field: GkAtoms::article_string"]
                    [::std::mem::offset_of!(GkAtoms, article_string) - 3440usize];
                ["Offset of field: GkAtoms::as_string"]
                    [::std::mem::offset_of!(GkAtoms, as_string) - 3456usize];
                ["Offset of field: GkAtoms::ascending_string"]
                    [::std::mem::offset_of!(GkAtoms, ascending_string) - 3462usize];
                ["Offset of field: GkAtoms::aside_string"]
                    [::std::mem::offset_of!(GkAtoms, aside_string) - 3482usize];
                ["Offset of field: GkAtoms::aspectRatio_string"]
                    [::std::mem::offset_of!(GkAtoms, aspectRatio_string) - 3494usize];
                ["Offset of field: GkAtoms::async_string"]
                    [::std::mem::offset_of!(GkAtoms, async_string) - 3520usize];
                ["Offset of field: GkAtoms::attribute_string"]
                    [::std::mem::offset_of!(GkAtoms, attribute_string) - 3532usize];
                ["Offset of field: GkAtoms::attributes_string"]
                    [::std::mem::offset_of!(GkAtoms, attributes_string) - 3552usize];
                ["Offset of field: GkAtoms::attributeSet_string"]
                    [::std::mem::offset_of!(GkAtoms, attributeSet_string) - 3574usize];
                ["Offset of field: GkAtoms::_auto_string"]
                    [::std::mem::offset_of!(GkAtoms, _auto_string) - 3602usize];
                ["Offset of field: GkAtoms::autocapitalize_string"]
                    [::std::mem::offset_of!(GkAtoms, autocapitalize_string) - 3612usize];
                ["Offset of field: GkAtoms::autocheck_string"]
                    [::std::mem::offset_of!(GkAtoms, autocheck_string) - 3642usize];
                ["Offset of field: GkAtoms::autocomplete_string"]
                    [::std::mem::offset_of!(GkAtoms, autocomplete_string) - 3662usize];
                ["Offset of field: GkAtoms::autocomplete_richlistbox_string"]
                    [::std::mem::offset_of!(GkAtoms, autocomplete_richlistbox_string) - 3688usize];
                ["Offset of field: GkAtoms::autofocus_string"]
                    [::std::mem::offset_of!(GkAtoms, autofocus_string) - 3738usize];
                ["Offset of field: GkAtoms::autoplay_string"]
                    [::std::mem::offset_of!(GkAtoms, autoplay_string) - 3758usize];
                ["Offset of field: GkAtoms::axis_string"]
                    [::std::mem::offset_of!(GkAtoms, axis_string) - 3776usize];
                ["Offset of field: GkAtoms::b_string"]
                    [::std::mem::offset_of!(GkAtoms, b_string) - 3786usize];
                ["Offset of field: GkAtoms::background_string"]
                    [::std::mem::offset_of!(GkAtoms, background_string) - 3790usize];
                ["Offset of field: GkAtoms::badge_string"]
                    [::std::mem::offset_of!(GkAtoms, badge_string) - 3812usize];
                ["Offset of field: GkAtoms::bar_string"]
                    [::std::mem::offset_of!(GkAtoms, bar_string) - 3824usize];
                ["Offset of field: GkAtoms::base_string"]
                    [::std::mem::offset_of!(GkAtoms, base_string) - 3832usize];
                ["Offset of field: GkAtoms::basefont_string"]
                    [::std::mem::offset_of!(GkAtoms, basefont_string) - 3842usize];
                ["Offset of field: GkAtoms::baseline_string"]
                    [::std::mem::offset_of!(GkAtoms, baseline_string) - 3860usize];
                ["Offset of field: GkAtoms::bdi_string"]
                    [::std::mem::offset_of!(GkAtoms, bdi_string) - 3878usize];
                ["Offset of field: GkAtoms::bdo_string"]
                    [::std::mem::offset_of!(GkAtoms, bdo_string) - 3886usize];
                ["Offset of field: GkAtoms::before_string"]
                    [::std::mem::offset_of!(GkAtoms, before_string) - 3894usize];
                ["Offset of field: GkAtoms::behavior_string"]
                    [::std::mem::offset_of!(GkAtoms, behavior_string) - 3908usize];
                ["Offset of field: GkAtoms::below_string"]
                    [::std::mem::offset_of!(GkAtoms, below_string) - 3926usize];
                ["Offset of field: GkAtoms::bgcolor_string"]
                    [::std::mem::offset_of!(GkAtoms, bgcolor_string) - 3938usize];
                ["Offset of field: GkAtoms::bgsound_string"]
                    [::std::mem::offset_of!(GkAtoms, bgsound_string) - 3954usize];
                ["Offset of field: GkAtoms::big_string"]
                    [::std::mem::offset_of!(GkAtoms, big_string) - 3970usize];
                ["Offset of field: GkAtoms::binding_string"]
                    [::std::mem::offset_of!(GkAtoms, binding_string) - 3978usize];
                ["Offset of field: GkAtoms::bindings_string"]
                    [::std::mem::offset_of!(GkAtoms, bindings_string) - 3994usize];
                ["Offset of field: GkAtoms::bindToUntrustedContent_string"]
                    [::std::mem::offset_of!(GkAtoms, bindToUntrustedContent_string) - 4012usize];
                ["Offset of field: GkAtoms::black_string"]
                    [::std::mem::offset_of!(GkAtoms, black_string) - 4058usize];
                ["Offset of field: GkAtoms::block_string"]
                    [::std::mem::offset_of!(GkAtoms, block_string) - 4070usize];
                ["Offset of field: GkAtoms::block_size_string"]
                    [::std::mem::offset_of!(GkAtoms, block_size_string) - 4082usize];
                ["Offset of field: GkAtoms::blocking_string"]
                    [::std::mem::offset_of!(GkAtoms, blocking_string) - 4104usize];
                ["Offset of field: GkAtoms::blockquote_string"]
                    [::std::mem::offset_of!(GkAtoms, blockquote_string) - 4122usize];
                ["Offset of field: GkAtoms::blur_string"]
                    [::std::mem::offset_of!(GkAtoms, blur_string) - 4144usize];
                ["Offset of field: GkAtoms::body_string"]
                    [::std::mem::offset_of!(GkAtoms, body_string) - 4154usize];
                ["Offset of field: GkAtoms::boolean_string"]
                    [::std::mem::offset_of!(GkAtoms, boolean_string) - 4164usize];
                ["Offset of field: GkAtoms::border_string"]
                    [::std::mem::offset_of!(GkAtoms, border_string) - 4180usize];
                ["Offset of field: GkAtoms::bordercolor_string"]
                    [::std::mem::offset_of!(GkAtoms, bordercolor_string) - 4194usize];
                ["Offset of field: GkAtoms::both_string"]
                    [::std::mem::offset_of!(GkAtoms, both_string) - 4218usize];
                ["Offset of field: GkAtoms::bottom_string"]
                    [::std::mem::offset_of!(GkAtoms, bottom_string) - 4228usize];
                ["Offset of field: GkAtoms::bottomend_string"]
                    [::std::mem::offset_of!(GkAtoms, bottomend_string) - 4242usize];
                ["Offset of field: GkAtoms::bottomstart_string"]
                    [::std::mem::offset_of!(GkAtoms, bottomstart_string) - 4262usize];
                ["Offset of field: GkAtoms::bottomleft_string"]
                    [::std::mem::offset_of!(GkAtoms, bottomleft_string) - 4286usize];
                ["Offset of field: GkAtoms::bottommargin_string"]
                    [::std::mem::offset_of!(GkAtoms, bottommargin_string) - 4308usize];
                ["Offset of field: GkAtoms::bottomright_string"]
                    [::std::mem::offset_of!(GkAtoms, bottomright_string) - 4334usize];
                ["Offset of field: GkAtoms::box_string"]
                    [::std::mem::offset_of!(GkAtoms, box_string) - 4358usize];
                ["Offset of field: GkAtoms::br_string"]
                    [::std::mem::offset_of!(GkAtoms, br_string) - 4366usize];
                ["Offset of field: GkAtoms::browser_string"]
                    [::std::mem::offset_of!(GkAtoms, browser_string) - 4372usize];
                ["Offset of field: GkAtoms::button_string"]
                    [::std::mem::offset_of!(GkAtoms, button_string) - 4388usize];
                ["Offset of field: GkAtoms::callTemplate_string"]
                    [::std::mem::offset_of!(GkAtoms, callTemplate_string) - 4402usize];
                ["Offset of field: GkAtoms::canvas_string"]
                    [::std::mem::offset_of!(GkAtoms, canvas_string) - 4430usize];
                ["Offset of field: GkAtoms::caption_string"]
                    [::std::mem::offset_of!(GkAtoms, caption_string) - 4444usize];
                ["Offset of field: GkAtoms::captionBox_string"]
                    [::std::mem::offset_of!(GkAtoms, captionBox_string) - 4460usize];
                ["Offset of field: GkAtoms::capture_string"]
                    [::std::mem::offset_of!(GkAtoms, capture_string) - 4484usize];
                ["Offset of field: GkAtoms::caseOrder_string"]
                    [::std::mem::offset_of!(GkAtoms, caseOrder_string) - 4500usize];
                ["Offset of field: GkAtoms::cdataSectionElements_string"]
                    [::std::mem::offset_of!(GkAtoms, cdataSectionElements_string) - 4522usize];
                ["Offset of field: GkAtoms::ceiling_string"]
                    [::std::mem::offset_of!(GkAtoms, ceiling_string) - 4568usize];
                ["Offset of field: GkAtoms::cell_string"]
                    [::std::mem::offset_of!(GkAtoms, cell_string) - 4584usize];
                ["Offset of field: GkAtoms::cellpadding_string"]
                    [::std::mem::offset_of!(GkAtoms, cellpadding_string) - 4594usize];
                ["Offset of field: GkAtoms::cellspacing_string"]
                    [::std::mem::offset_of!(GkAtoms, cellspacing_string) - 4618usize];
                ["Offset of field: GkAtoms::center_string"]
                    [::std::mem::offset_of!(GkAtoms, center_string) - 4642usize];
                ["Offset of field: GkAtoms::change_string"]
                    [::std::mem::offset_of!(GkAtoms, change_string) - 4656usize];
                ["Offset of field: GkAtoms::_char_string"]
                    [::std::mem::offset_of!(GkAtoms, _char_string) - 4670usize];
                ["Offset of field: GkAtoms::characterData_string"]
                    [::std::mem::offset_of!(GkAtoms, characterData_string) - 4680usize];
                ["Offset of field: GkAtoms::charcode_string"]
                    [::std::mem::offset_of!(GkAtoms, charcode_string) - 4708usize];
                ["Offset of field: GkAtoms::charoff_string"]
                    [::std::mem::offset_of!(GkAtoms, charoff_string) - 4726usize];
                ["Offset of field: GkAtoms::charset_string"]
                    [::std::mem::offset_of!(GkAtoms, charset_string) - 4742usize];
                ["Offset of field: GkAtoms::checkbox_string"]
                    [::std::mem::offset_of!(GkAtoms, checkbox_string) - 4758usize];
                ["Offset of field: GkAtoms::checkboxLabel_string"]
                    [::std::mem::offset_of!(GkAtoms, checkboxLabel_string) - 4776usize];
                ["Offset of field: GkAtoms::checked_string"]
                    [::std::mem::offset_of!(GkAtoms, checked_string) - 4806usize];
                ["Offset of field: GkAtoms::child_string"]
                    [::std::mem::offset_of!(GkAtoms, child_string) - 4822usize];
                ["Offset of field: GkAtoms::children_string"]
                    [::std::mem::offset_of!(GkAtoms, children_string) - 4834usize];
                ["Offset of field: GkAtoms::childList_string"]
                    [::std::mem::offset_of!(GkAtoms, childList_string) - 4852usize];
                ["Offset of field: GkAtoms::child_item_count_string"]
                    [::std::mem::offset_of!(GkAtoms, child_item_count_string) - 4872usize];
                ["Offset of field: GkAtoms::choose_string"]
                    [::std::mem::offset_of!(GkAtoms, choose_string) - 4906usize];
                ["Offset of field: GkAtoms::customtitlebar_string"]
                    [::std::mem::offset_of!(GkAtoms, customtitlebar_string) - 4920usize];
                ["Offset of field: GkAtoms::exposeToUntrustedContent_string"]
                    [::std::mem::offset_of!(GkAtoms, exposeToUntrustedContent_string) - 4950usize];
                ["Offset of field: GkAtoms::circ_string"]
                    [::std::mem::offset_of!(GkAtoms, circ_string) - 5000usize];
                ["Offset of field: GkAtoms::circle_string"]
                    [::std::mem::offset_of!(GkAtoms, circle_string) - 5010usize];
                ["Offset of field: GkAtoms::cite_string"]
                    [::std::mem::offset_of!(GkAtoms, cite_string) - 5024usize];
                ["Offset of field: GkAtoms::cke_wysiwyg_frame_string"]
                    [::std::mem::offset_of!(GkAtoms, cke_wysiwyg_frame_string) - 5034usize];
                ["Offset of field: GkAtoms::_class_string"]
                    [::std::mem::offset_of!(GkAtoms, _class_string) - 5070usize];
                ["Offset of field: GkAtoms::classid_string"]
                    [::std::mem::offset_of!(GkAtoms, classid_string) - 5082usize];
                ["Offset of field: GkAtoms::clear_string"]
                    [::std::mem::offset_of!(GkAtoms, clear_string) - 5098usize];
                ["Offset of field: GkAtoms::click_string"]
                    [::std::mem::offset_of!(GkAtoms, click_string) - 5110usize];
                ["Offset of field: GkAtoms::clickToPlay_string"]
                    [::std::mem::offset_of!(GkAtoms, clickToPlay_string) - 5122usize];
                ["Offset of field: GkAtoms::clickcount_string"]
                    [::std::mem::offset_of!(GkAtoms, clickcount_string) - 5146usize];
                ["Offset of field: GkAtoms::movetoclick_string"]
                    [::std::mem::offset_of!(GkAtoms, movetoclick_string) - 5168usize];
                ["Offset of field: GkAtoms::clip_string"]
                    [::std::mem::offset_of!(GkAtoms, clip_string) - 5192usize];
                ["Offset of field: GkAtoms::close_string"]
                    [::std::mem::offset_of!(GkAtoms, close_string) - 5202usize];
                ["Offset of field: GkAtoms::closed_string"]
                    [::std::mem::offset_of!(GkAtoms, closed_string) - 5214usize];
                ["Offset of field: GkAtoms::closedby_string"]
                    [::std::mem::offset_of!(GkAtoms, closedby_string) - 5228usize];
                ["Offset of field: GkAtoms::closemenu_string"]
                    [::std::mem::offset_of!(GkAtoms, closemenu_string) - 5246usize];
                ["Offset of field: GkAtoms::code_string"]
                    [::std::mem::offset_of!(GkAtoms, code_string) - 5266usize];
                ["Offset of field: GkAtoms::codebase_string"]
                    [::std::mem::offset_of!(GkAtoms, codebase_string) - 5276usize];
                ["Offset of field: GkAtoms::codetype_string"]
                    [::std::mem::offset_of!(GkAtoms, codetype_string) - 5294usize];
                ["Offset of field: GkAtoms::col_string"]
                    [::std::mem::offset_of!(GkAtoms, col_string) - 5312usize];
                ["Offset of field: GkAtoms::colgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, colgroup_string) - 5320usize];
                ["Offset of field: GkAtoms::collapse_string"]
                    [::std::mem::offset_of!(GkAtoms, collapse_string) - 5338usize];
                ["Offset of field: GkAtoms::collapsed_string"]
                    [::std::mem::offset_of!(GkAtoms, collapsed_string) - 5356usize];
                ["Offset of field: GkAtoms::color_string"]
                    [::std::mem::offset_of!(GkAtoms, color_string) - 5376usize];
                ["Offset of field: GkAtoms::color_gamut_string"]
                    [::std::mem::offset_of!(GkAtoms, color_gamut_string) - 5388usize];
                ["Offset of field: GkAtoms::color_index_string"]
                    [::std::mem::offset_of!(GkAtoms, color_index_string) - 5412usize];
                ["Offset of field: GkAtoms::color_scheme_string"]
                    [::std::mem::offset_of!(GkAtoms, color_scheme_string) - 5436usize];
                ["Offset of field: GkAtoms::cols_string"]
                    [::std::mem::offset_of!(GkAtoms, cols_string) - 5462usize];
                ["Offset of field: GkAtoms::colspan_string"]
                    [::std::mem::offset_of!(GkAtoms, colspan_string) - 5472usize];
                ["Offset of field: GkAtoms::combobox_string"]
                    [::std::mem::offset_of!(GkAtoms, combobox_string) - 5488usize];
                ["Offset of field: GkAtoms::command_string"]
                    [::std::mem::offset_of!(GkAtoms, command_string) - 5506usize];
                ["Offset of field: GkAtoms::commandfor_string"]
                    [::std::mem::offset_of!(GkAtoms, commandfor_string) - 5522usize];
                ["Offset of field: GkAtoms::commandupdater_string"]
                    [::std::mem::offset_of!(GkAtoms, commandupdater_string) - 5544usize];
                ["Offset of field: GkAtoms::comment_string"]
                    [::std::mem::offset_of!(GkAtoms, comment_string) - 5574usize];
                ["Offset of field: GkAtoms::compact_string"]
                    [::std::mem::offset_of!(GkAtoms, compact_string) - 5590usize];
                ["Offset of field: GkAtoms::concat_string"]
                    [::std::mem::offset_of!(GkAtoms, concat_string) - 5606usize];
                ["Offset of field: GkAtoms::constructor_string"]
                    [::std::mem::offset_of!(GkAtoms, constructor_string) - 5620usize];
                ["Offset of field: GkAtoms::consumeoutsideclicks_string"]
                    [::std::mem::offset_of!(GkAtoms, consumeoutsideclicks_string) - 5644usize];
                ["Offset of field: GkAtoms::container_string"]
                    [::std::mem::offset_of!(GkAtoms, container_string) - 5686usize];
                ["Offset of field: GkAtoms::contains_string"]
                    [::std::mem::offset_of!(GkAtoms, contains_string) - 5706usize];
                ["Offset of field: GkAtoms::content_string"]
                    [::std::mem::offset_of!(GkAtoms, content_string) - 5724usize];
                ["Offset of field: GkAtoms::contenteditable_string"]
                    [::std::mem::offset_of!(GkAtoms, contenteditable_string) - 5740usize];
                ["Offset of field: GkAtoms::headerContentDisposition_string"]
                    [::std::mem::offset_of!(GkAtoms, headerContentDisposition_string) - 5772usize];
                ["Offset of field: GkAtoms::headerContentLanguage_string"]
                    [::std::mem::offset_of!(GkAtoms, headerContentLanguage_string) - 5812usize];
                ["Offset of field: GkAtoms::contentLocation_string"]
                    [::std::mem::offset_of!(GkAtoms, contentLocation_string) - 5846usize];
                ["Offset of field: GkAtoms::headerContentScriptType_string"]
                    [::std::mem::offset_of!(GkAtoms, headerContentScriptType_string) - 5880usize];
                ["Offset of field: GkAtoms::headerContentStyleType_string"]
                    [::std::mem::offset_of!(GkAtoms, headerContentStyleType_string) - 5920usize];
                ["Offset of field: GkAtoms::headerContentType_string"]
                    [::std::mem::offset_of!(GkAtoms, headerContentType_string) - 5958usize];
                ["Offset of field: GkAtoms::consumeanchor_string"]
                    [::std::mem::offset_of!(GkAtoms, consumeanchor_string) - 5984usize];
                ["Offset of field: GkAtoms::context_string"]
                    [::std::mem::offset_of!(GkAtoms, context_string) - 6012usize];
                ["Offset of field: GkAtoms::contextmenu_string"]
                    [::std::mem::offset_of!(GkAtoms, contextmenu_string) - 6028usize];
                ["Offset of field: GkAtoms::control_string"]
                    [::std::mem::offset_of!(GkAtoms, control_string) - 6052usize];
                ["Offset of field: GkAtoms::controlBar_string"]
                    [::std::mem::offset_of!(GkAtoms, controlBar_string) - 6068usize];
                ["Offset of field: GkAtoms::controls_string"]
                    [::std::mem::offset_of!(GkAtoms, controls_string) - 6090usize];
                ["Offset of field: GkAtoms::coords_string"]
                    [::std::mem::offset_of!(GkAtoms, coords_string) - 6108usize];
                ["Offset of field: GkAtoms::copy_string"]
                    [::std::mem::offset_of!(GkAtoms, copy_string) - 6122usize];
                ["Offset of field: GkAtoms::copyOf_string"]
                    [::std::mem::offset_of!(GkAtoms, copyOf_string) - 6132usize];
                ["Offset of field: GkAtoms::count_string"]
                    [::std::mem::offset_of!(GkAtoms, count_string) - 6148usize];
                ["Offset of field: GkAtoms::crop_string"]
                    [::std::mem::offset_of!(GkAtoms, crop_string) - 6160usize];
                ["Offset of field: GkAtoms::crossorigin_string"]
                    [::std::mem::offset_of!(GkAtoms, crossorigin_string) - 6170usize];
                ["Offset of field: GkAtoms::curpos_string"]
                    [::std::mem::offset_of!(GkAtoms, curpos_string) - 6194usize];
                ["Offset of field: GkAtoms::current_string"]
                    [::std::mem::offset_of!(GkAtoms, current_string) - 6208usize];
                ["Offset of field: GkAtoms::cutoutregion_string"]
                    [::std::mem::offset_of!(GkAtoms, cutoutregion_string) - 6224usize];
                ["Offset of field: GkAtoms::cycler_string"]
                    [::std::mem::offset_of!(GkAtoms, cycler_string) - 6250usize];
                ["Offset of field: GkAtoms::dashed_string"]
                    [::std::mem::offset_of!(GkAtoms, dashed_string) - 6264usize];
                ["Offset of field: GkAtoms::data_string"]
                    [::std::mem::offset_of!(GkAtoms, data_string) - 6278usize];
                ["Offset of field: GkAtoms::dataAtShortcutkeys_string"]
                    [::std::mem::offset_of!(GkAtoms, dataAtShortcutkeys_string) - 6288usize];
                ["Offset of field: GkAtoms::datalist_string"]
                    [::std::mem::offset_of!(GkAtoms, datalist_string) - 6330usize];
                ["Offset of field: GkAtoms::datal10nid_string"]
                    [::std::mem::offset_of!(GkAtoms, datal10nid_string) - 6348usize];
                ["Offset of field: GkAtoms::datal10nargs_string"]
                    [::std::mem::offset_of!(GkAtoms, datal10nargs_string) - 6374usize];
                ["Offset of field: GkAtoms::datal10nattrs_string"]
                    [::std::mem::offset_of!(GkAtoms, datal10nattrs_string) - 6404usize];
                ["Offset of field: GkAtoms::datal10nname_string"]
                    [::std::mem::offset_of!(GkAtoms, datal10nname_string) - 6436usize];
                ["Offset of field: GkAtoms::datal10nsync_string"]
                    [::std::mem::offset_of!(GkAtoms, datal10nsync_string) - 6466usize];
                ["Offset of field: GkAtoms::dataType_string"]
                    [::std::mem::offset_of!(GkAtoms, dataType_string) - 6496usize];
                ["Offset of field: GkAtoms::dateTime_string"]
                    [::std::mem::offset_of!(GkAtoms, dateTime_string) - 6516usize];
                ["Offset of field: GkAtoms::date_string"]
                    [::std::mem::offset_of!(GkAtoms, date_string) - 6536usize];
                ["Offset of field: GkAtoms::datetime_string"]
                    [::std::mem::offset_of!(GkAtoms, datetime_string) - 6546usize];
                ["Offset of field: GkAtoms::datetime_local_string"]
                    [::std::mem::offset_of!(GkAtoms, datetime_local_string) - 6564usize];
                ["Offset of field: GkAtoms::datetimeInputBoxWrapper_string"]
                    [::std::mem::offset_of!(GkAtoms, datetimeInputBoxWrapper_string) - 6594usize];
                ["Offset of field: GkAtoms::dd_string"]
                    [::std::mem::offset_of!(GkAtoms, dd_string) - 6648usize];
                ["Offset of field: GkAtoms::decimal_string"]
                    [::std::mem::offset_of!(GkAtoms, decimal_string) - 6654usize];
                ["Offset of field: GkAtoms::decimalFormat_string"]
                    [::std::mem::offset_of!(GkAtoms, decimalFormat_string) - 6670usize];
                ["Offset of field: GkAtoms::decimalSeparator_string"]
                    [::std::mem::offset_of!(GkAtoms, decimalSeparator_string) - 6700usize];
                ["Offset of field: GkAtoms::declare_string"]
                    [::std::mem::offset_of!(GkAtoms, declare_string) - 6736usize];
                ["Offset of field: GkAtoms::decoderDoctor_string"]
                    [::std::mem::offset_of!(GkAtoms, decoderDoctor_string) - 6752usize];
                ["Offset of field: GkAtoms::decoding_string"]
                    [::std::mem::offset_of!(GkAtoms, decoding_string) - 6782usize];
                ["Offset of field: GkAtoms::decrement_string"]
                    [::std::mem::offset_of!(GkAtoms, decrement_string) - 6800usize];
                ["Offset of field: GkAtoms::_default_string"]
                    [::std::mem::offset_of!(GkAtoms, _default_string) - 6820usize];
                ["Offset of field: GkAtoms::headerDefaultStyle_string"]
                    [::std::mem::offset_of!(GkAtoms, headerDefaultStyle_string) - 6836usize];
                ["Offset of field: GkAtoms::defer_string"]
                    [::std::mem::offset_of!(GkAtoms, defer_string) - 6864usize];
                ["Offset of field: GkAtoms::del_string"]
                    [::std::mem::offset_of!(GkAtoms, del_string) - 6876usize];
                ["Offset of field: GkAtoms::delegatesanchor_string"]
                    [::std::mem::offset_of!(GkAtoms, delegatesanchor_string) - 6884usize];
                ["Offset of field: GkAtoms::deletion_string"]
                    [::std::mem::offset_of!(GkAtoms, deletion_string) - 6916usize];
                ["Offset of field: GkAtoms::deprecation_string"]
                    [::std::mem::offset_of!(GkAtoms, deprecation_string) - 6934usize];
                ["Offset of field: GkAtoms::descendant_string"]
                    [::std::mem::offset_of!(GkAtoms, descendant_string) - 6958usize];
                ["Offset of field: GkAtoms::descendantOrSelf_string"]
                    [::std::mem::offset_of!(GkAtoms, descendantOrSelf_string) - 6980usize];
                ["Offset of field: GkAtoms::descending_string"]
                    [::std::mem::offset_of!(GkAtoms, descending_string) - 7018usize];
                ["Offset of field: GkAtoms::description_string"]
                    [::std::mem::offset_of!(GkAtoms, description_string) - 7040usize];
                ["Offset of field: GkAtoms::destructor_string"]
                    [::std::mem::offset_of!(GkAtoms, destructor_string) - 7064usize];
                ["Offset of field: GkAtoms::details_string"]
                    [::std::mem::offset_of!(GkAtoms, details_string) - 7086usize];
                ["Offset of field: GkAtoms::details_from_string"]
                    [::std::mem::offset_of!(GkAtoms, details_from_string) - 7102usize];
                ["Offset of field: GkAtoms::deviceAspectRatio_string"]
                    [::std::mem::offset_of!(GkAtoms, deviceAspectRatio_string) - 7128usize];
                ["Offset of field: GkAtoms::deviceHeight_string"]
                    [::std::mem::offset_of!(GkAtoms, deviceHeight_string) - 7168usize];
                ["Offset of field: GkAtoms::devicePixelRatio_string"]
                    [::std::mem::offset_of!(GkAtoms, devicePixelRatio_string) - 7196usize];
                ["Offset of field: GkAtoms::deviceWidth_string"]
                    [::std::mem::offset_of!(GkAtoms, deviceWidth_string) - 7234usize];
                ["Offset of field: GkAtoms::dfn_string"]
                    [::std::mem::offset_of!(GkAtoms, dfn_string) - 7260usize];
                ["Offset of field: GkAtoms::dialog_string"]
                    [::std::mem::offset_of!(GkAtoms, dialog_string) - 7268usize];
                ["Offset of field: GkAtoms::difference_string"]
                    [::std::mem::offset_of!(GkAtoms, difference_string) - 7282usize];
                ["Offset of field: GkAtoms::digit_string"]
                    [::std::mem::offset_of!(GkAtoms, digit_string) - 7304usize];
                ["Offset of field: GkAtoms::dir_string"]
                    [::std::mem::offset_of!(GkAtoms, dir_string) - 7316usize];
                ["Offset of field: GkAtoms::directory_string"]
                    [::std::mem::offset_of!(GkAtoms, directory_string) - 7324usize];
                ["Offset of field: GkAtoms::dirname_string"]
                    [::std::mem::offset_of!(GkAtoms, dirname_string) - 7344usize];
                ["Offset of field: GkAtoms::disableOutputEscaping_string"]
                    [::std::mem::offset_of!(GkAtoms, disableOutputEscaping_string) - 7360usize];
                ["Offset of field: GkAtoms::disabled_string"]
                    [::std::mem::offset_of!(GkAtoms, disabled_string) - 7408usize];
                ["Offset of field: GkAtoms::disableglobalhistory_string"]
                    [::std::mem::offset_of!(GkAtoms, disableglobalhistory_string) - 7426usize];
                ["Offset of field: GkAtoms::disablehistory_string"]
                    [::std::mem::offset_of!(GkAtoms, disablehistory_string) - 7468usize];
                ["Offset of field: GkAtoms::disablefullscreen_string"]
                    [::std::mem::offset_of!(GkAtoms, disablefullscreen_string) - 7498usize];
                ["Offset of field: GkAtoms::disablepictureinpicture_string"]
                    [::std::mem::offset_of!(GkAtoms, disablepictureinpicture_string) - 7534usize];
                ["Offset of field: GkAtoms::disclosure_closed_string"]
                    [::std::mem::offset_of!(GkAtoms, disclosure_closed_string) - 7582usize];
                ["Offset of field: GkAtoms::disclosure_open_string"]
                    [::std::mem::offset_of!(GkAtoms, disclosure_open_string) - 7618usize];
                ["Offset of field: GkAtoms::display_string"]
                    [::std::mem::offset_of!(GkAtoms, display_string) - 7650usize];
                ["Offset of field: GkAtoms::displayMode_string"]
                    [::std::mem::offset_of!(GkAtoms, displayMode_string) - 7666usize];
                ["Offset of field: GkAtoms::distinct_string"]
                    [::std::mem::offset_of!(GkAtoms, distinct_string) - 7692usize];
                ["Offset of field: GkAtoms::div_string"]
                    [::std::mem::offset_of!(GkAtoms, div_string) - 7710usize];
                ["Offset of field: GkAtoms::dl_string"]
                    [::std::mem::offset_of!(GkAtoms, dl_string) - 7718usize];
                ["Offset of field: GkAtoms::docAbstract_string"]
                    [::std::mem::offset_of!(GkAtoms, docAbstract_string) - 7724usize];
                ["Offset of field: GkAtoms::docAcknowledgments_string"]
                    [::std::mem::offset_of!(GkAtoms, docAcknowledgments_string) - 7750usize];
                ["Offset of field: GkAtoms::docAfterword_string"]
                    [::std::mem::offset_of!(GkAtoms, docAfterword_string) - 7790usize];
                ["Offset of field: GkAtoms::docAppendix_string"]
                    [::std::mem::offset_of!(GkAtoms, docAppendix_string) - 7818usize];
                ["Offset of field: GkAtoms::docBacklink_string"]
                    [::std::mem::offset_of!(GkAtoms, docBacklink_string) - 7844usize];
                ["Offset of field: GkAtoms::docBiblioentry_string"]
                    [::std::mem::offset_of!(GkAtoms, docBiblioentry_string) - 7870usize];
                ["Offset of field: GkAtoms::docBibliography_string"]
                    [::std::mem::offset_of!(GkAtoms, docBibliography_string) - 7902usize];
                ["Offset of field: GkAtoms::docBiblioref_string"]
                    [::std::mem::offset_of!(GkAtoms, docBiblioref_string) - 7936usize];
                ["Offset of field: GkAtoms::docChapter_string"]
                    [::std::mem::offset_of!(GkAtoms, docChapter_string) - 7964usize];
                ["Offset of field: GkAtoms::docColophon_string"]
                    [::std::mem::offset_of!(GkAtoms, docColophon_string) - 7988usize];
                ["Offset of field: GkAtoms::docConclusion_string"]
                    [::std::mem::offset_of!(GkAtoms, docConclusion_string) - 8014usize];
                ["Offset of field: GkAtoms::docCover_string"]
                    [::std::mem::offset_of!(GkAtoms, docCover_string) - 8044usize];
                ["Offset of field: GkAtoms::docCredit_string"]
                    [::std::mem::offset_of!(GkAtoms, docCredit_string) - 8064usize];
                ["Offset of field: GkAtoms::docCredits_string"]
                    [::std::mem::offset_of!(GkAtoms, docCredits_string) - 8086usize];
                ["Offset of field: GkAtoms::docDedication_string"]
                    [::std::mem::offset_of!(GkAtoms, docDedication_string) - 8110usize];
                ["Offset of field: GkAtoms::docEndnote_string"]
                    [::std::mem::offset_of!(GkAtoms, docEndnote_string) - 8140usize];
                ["Offset of field: GkAtoms::docEndnotes_string"]
                    [::std::mem::offset_of!(GkAtoms, docEndnotes_string) - 8164usize];
                ["Offset of field: GkAtoms::docEpigraph_string"]
                    [::std::mem::offset_of!(GkAtoms, docEpigraph_string) - 8190usize];
                ["Offset of field: GkAtoms::docEpilogue_string"]
                    [::std::mem::offset_of!(GkAtoms, docEpilogue_string) - 8216usize];
                ["Offset of field: GkAtoms::docErrata_string"]
                    [::std::mem::offset_of!(GkAtoms, docErrata_string) - 8242usize];
                ["Offset of field: GkAtoms::docExample_string"]
                    [::std::mem::offset_of!(GkAtoms, docExample_string) - 8264usize];
                ["Offset of field: GkAtoms::docFootnote_string"]
                    [::std::mem::offset_of!(GkAtoms, docFootnote_string) - 8288usize];
                ["Offset of field: GkAtoms::docForeword_string"]
                    [::std::mem::offset_of!(GkAtoms, docForeword_string) - 8314usize];
                ["Offset of field: GkAtoms::docGlossary_string"]
                    [::std::mem::offset_of!(GkAtoms, docGlossary_string) - 8340usize];
                ["Offset of field: GkAtoms::docGlossref_string"]
                    [::std::mem::offset_of!(GkAtoms, docGlossref_string) - 8366usize];
                ["Offset of field: GkAtoms::docIndex_string"]
                    [::std::mem::offset_of!(GkAtoms, docIndex_string) - 8392usize];
                ["Offset of field: GkAtoms::docIntroduction_string"]
                    [::std::mem::offset_of!(GkAtoms, docIntroduction_string) - 8412usize];
                ["Offset of field: GkAtoms::docNoteref_string"]
                    [::std::mem::offset_of!(GkAtoms, docNoteref_string) - 8446usize];
                ["Offset of field: GkAtoms::docNotice_string"]
                    [::std::mem::offset_of!(GkAtoms, docNotice_string) - 8470usize];
                ["Offset of field: GkAtoms::docPagebreak_string"]
                    [::std::mem::offset_of!(GkAtoms, docPagebreak_string) - 8492usize];
                ["Offset of field: GkAtoms::docPagefooter_string"]
                    [::std::mem::offset_of!(GkAtoms, docPagefooter_string) - 8520usize];
                ["Offset of field: GkAtoms::docPageheader_string"]
                    [::std::mem::offset_of!(GkAtoms, docPageheader_string) - 8550usize];
                ["Offset of field: GkAtoms::docPagelist_string"]
                    [::std::mem::offset_of!(GkAtoms, docPagelist_string) - 8580usize];
                ["Offset of field: GkAtoms::docPart_string"]
                    [::std::mem::offset_of!(GkAtoms, docPart_string) - 8606usize];
                ["Offset of field: GkAtoms::docPreface_string"]
                    [::std::mem::offset_of!(GkAtoms, docPreface_string) - 8624usize];
                ["Offset of field: GkAtoms::docPrologue_string"]
                    [::std::mem::offset_of!(GkAtoms, docPrologue_string) - 8648usize];
                ["Offset of field: GkAtoms::docPullquote_string"]
                    [::std::mem::offset_of!(GkAtoms, docPullquote_string) - 8674usize];
                ["Offset of field: GkAtoms::docQna_string"]
                    [::std::mem::offset_of!(GkAtoms, docQna_string) - 8702usize];
                ["Offset of field: GkAtoms::docSubtitle_string"]
                    [::std::mem::offset_of!(GkAtoms, docSubtitle_string) - 8718usize];
                ["Offset of field: GkAtoms::docTip_string"]
                    [::std::mem::offset_of!(GkAtoms, docTip_string) - 8744usize];
                ["Offset of field: GkAtoms::docToc_string"]
                    [::std::mem::offset_of!(GkAtoms, docToc_string) - 8760usize];
                ["Offset of field: GkAtoms::doctypePublic_string"]
                    [::std::mem::offset_of!(GkAtoms, doctypePublic_string) - 8776usize];
                ["Offset of field: GkAtoms::doctypeSystem_string"]
                    [::std::mem::offset_of!(GkAtoms, doctypeSystem_string) - 8806usize];
                ["Offset of field: GkAtoms::document_string"]
                    [::std::mem::offset_of!(GkAtoms, document_string) - 8836usize];
                ["Offset of field: GkAtoms::down_string"]
                    [::std::mem::offset_of!(GkAtoms, down_string) - 8854usize];
                ["Offset of field: GkAtoms::download_string"]
                    [::std::mem::offset_of!(GkAtoms, download_string) - 8864usize];
                ["Offset of field: GkAtoms::drag_string"]
                    [::std::mem::offset_of!(GkAtoms, drag_string) - 8882usize];
                ["Offset of field: GkAtoms::draggable_string"]
                    [::std::mem::offset_of!(GkAtoms, draggable_string) - 8892usize];
                ["Offset of field: GkAtoms::dragging_string"]
                    [::std::mem::offset_of!(GkAtoms, dragging_string) - 8912usize];
                ["Offset of field: GkAtoms::dragSession_string"]
                    [::std::mem::offset_of!(GkAtoms, dragSession_string) - 8930usize];
                ["Offset of field: GkAtoms::dropAfter_string"]
                    [::std::mem::offset_of!(GkAtoms, dropAfter_string) - 8954usize];
                ["Offset of field: GkAtoms::dropBefore_string"]
                    [::std::mem::offset_of!(GkAtoms, dropBefore_string) - 8974usize];
                ["Offset of field: GkAtoms::dropOn_string"]
                    [::std::mem::offset_of!(GkAtoms, dropOn_string) - 8996usize];
                ["Offset of field: GkAtoms::dropMarker_string"]
                    [::std::mem::offset_of!(GkAtoms, dropMarker_string) - 9010usize];
                ["Offset of field: GkAtoms::dt_string"]
                    [::std::mem::offset_of!(GkAtoms, dt_string) - 9032usize];
                ["Offset of field: GkAtoms::e_string"]
                    [::std::mem::offset_of!(GkAtoms, e_string) - 9038usize];
                ["Offset of field: GkAtoms::editable_string"]
                    [::std::mem::offset_of!(GkAtoms, editable_string) - 9042usize];
                ["Offset of field: GkAtoms::editing_string"]
                    [::std::mem::offset_of!(GkAtoms, editing_string) - 9060usize];
                ["Offset of field: GkAtoms::editor_string"]
                    [::std::mem::offset_of!(GkAtoms, editor_string) - 9076usize];
                ["Offset of field: GkAtoms::element_string"]
                    [::std::mem::offset_of!(GkAtoms, element_string) - 9090usize];
                ["Offset of field: GkAtoms::elementAvailable_string"]
                    [::std::mem::offset_of!(GkAtoms, elementAvailable_string) - 9106usize];
                ["Offset of field: GkAtoms::elements_string"]
                    [::std::mem::offset_of!(GkAtoms, elements_string) - 9142usize];
                ["Offset of field: GkAtoms::em_string"]
                    [::std::mem::offset_of!(GkAtoms, em_string) - 9160usize];
                ["Offset of field: GkAtoms::embed_string"]
                    [::std::mem::offset_of!(GkAtoms, embed_string) - 9166usize];
                ["Offset of field: GkAtoms::emphasis_string"]
                    [::std::mem::offset_of!(GkAtoms, emphasis_string) - 9178usize];
                ["Offset of field: GkAtoms::empty_string"]
                    [::std::mem::offset_of!(GkAtoms, empty_string) - 9196usize];
                ["Offset of field: GkAtoms::encoding_string"]
                    [::std::mem::offset_of!(GkAtoms, encoding_string) - 9208usize];
                ["Offset of field: GkAtoms::enctype_string"]
                    [::std::mem::offset_of!(GkAtoms, enctype_string) - 9226usize];
                ["Offset of field: GkAtoms::end_string"]
                    [::std::mem::offset_of!(GkAtoms, end_string) - 9242usize];
                ["Offset of field: GkAtoms::endEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, endEvent_string) - 9250usize];
                ["Offset of field: GkAtoms::enterkeyhint_string"]
                    [::std::mem::offset_of!(GkAtoms, enterkeyhint_string) - 9268usize];
                ["Offset of field: GkAtoms::error_string"]
                    [::std::mem::offset_of!(GkAtoms, error_string) - 9294usize];
                ["Offset of field: GkAtoms::ethiopic_numeric_string"]
                    [::std::mem::offset_of!(GkAtoms, ethiopic_numeric_string) - 9306usize];
                ["Offset of field: GkAtoms::even_string"]
                    [::std::mem::offset_of!(GkAtoms, even_string) - 9340usize];
                ["Offset of field: GkAtoms::event_string"]
                    [::std::mem::offset_of!(GkAtoms, event_string) - 9350usize];
                ["Offset of field: GkAtoms::events_string"]
                    [::std::mem::offset_of!(GkAtoms, events_string) - 9362usize];
                ["Offset of field: GkAtoms::excludeResultPrefixes_string"]
                    [::std::mem::offset_of!(GkAtoms, excludeResultPrefixes_string) - 9376usize];
                ["Offset of field: GkAtoms::exportparts_string"]
                    [::std::mem::offset_of!(GkAtoms, exportparts_string) - 9424usize];
                ["Offset of field: GkAtoms::explicit_name_string"]
                    [::std::mem::offset_of!(GkAtoms, explicit_name_string) - 9448usize];
                ["Offset of field: GkAtoms::extends_string"]
                    [::std::mem::offset_of!(GkAtoms, extends_string) - 9476usize];
                ["Offset of field: GkAtoms::extensionElementPrefixes_string"]
                    [::std::mem::offset_of!(GkAtoms, extensionElementPrefixes_string) - 9492usize];
                ["Offset of field: GkAtoms::face_string"]
                    [::std::mem::offset_of!(GkAtoms, face_string) - 9546usize];
                ["Offset of field: GkAtoms::fallback_string"]
                    [::std::mem::offset_of!(GkAtoms, fallback_string) - 9556usize];
                ["Offset of field: GkAtoms::_false_string"]
                    [::std::mem::offset_of!(GkAtoms, _false_string) - 9574usize];
                ["Offset of field: GkAtoms::farthest_string"]
                    [::std::mem::offset_of!(GkAtoms, farthest_string) - 9586usize];
                ["Offset of field: GkAtoms::featurePolicyViolation_string"]
                    [::std::mem::offset_of!(GkAtoms, featurePolicyViolation_string) - 9604usize];
                ["Offset of field: GkAtoms::fetchpriority_string"]
                    [::std::mem::offset_of!(GkAtoms, fetchpriority_string) - 9654usize];
                ["Offset of field: GkAtoms::field_string"]
                    [::std::mem::offset_of!(GkAtoms, field_string) - 9682usize];
                ["Offset of field: GkAtoms::fieldset_string"]
                    [::std::mem::offset_of!(GkAtoms, fieldset_string) - 9694usize];
                ["Offset of field: GkAtoms::file_string"]
                    [::std::mem::offset_of!(GkAtoms, file_string) - 9712usize];
                ["Offset of field: GkAtoms::figcaption_string"]
                    [::std::mem::offset_of!(GkAtoms, figcaption_string) - 9722usize];
                ["Offset of field: GkAtoms::figure_string"]
                    [::std::mem::offset_of!(GkAtoms, figure_string) - 9744usize];
                ["Offset of field: GkAtoms::findbar_string"]
                    [::std::mem::offset_of!(GkAtoms, findbar_string) - 9758usize];
                ["Offset of field: GkAtoms::firstColumn_string"]
                    [::std::mem::offset_of!(GkAtoms, firstColumn_string) - 9774usize];
                ["Offset of field: GkAtoms::firstInput_string"]
                    [::std::mem::offset_of!(GkAtoms, firstInput_string) - 9800usize];
                ["Offset of field: GkAtoms::fixed_string"]
                    [::std::mem::offset_of!(GkAtoms, fixed_string) - 9824usize];
                ["Offset of field: GkAtoms::flags_string"]
                    [::std::mem::offset_of!(GkAtoms, flags_string) - 9836usize];
                ["Offset of field: GkAtoms::flex_string"]
                    [::std::mem::offset_of!(GkAtoms, flex_string) - 9848usize];
                ["Offset of field: GkAtoms::flip_string"]
                    [::std::mem::offset_of!(GkAtoms, flip_string) - 9858usize];
                ["Offset of field: GkAtoms::floor_string"]
                    [::std::mem::offset_of!(GkAtoms, floor_string) - 9868usize];
                ["Offset of field: GkAtoms::flowlength_string"]
                    [::std::mem::offset_of!(GkAtoms, flowlength_string) - 9880usize];
                ["Offset of field: GkAtoms::focus_string"]
                    [::std::mem::offset_of!(GkAtoms, focus_string) - 9902usize];
                ["Offset of field: GkAtoms::focused_string"]
                    [::std::mem::offset_of!(GkAtoms, focused_string) - 9914usize];
                ["Offset of field: GkAtoms::followanchor_string"]
                    [::std::mem::offset_of!(GkAtoms, followanchor_string) - 9930usize];
                ["Offset of field: GkAtoms::following_string"]
                    [::std::mem::offset_of!(GkAtoms, following_string) - 9956usize];
                ["Offset of field: GkAtoms::followingSibling_string"]
                    [::std::mem::offset_of!(GkAtoms, followingSibling_string) - 9976usize];
                ["Offset of field: GkAtoms::font_string"]
                    [::std::mem::offset_of!(GkAtoms, font_string) - 10012usize];
                ["Offset of field: GkAtoms::footer_string"]
                    [::std::mem::offset_of!(GkAtoms, footer_string) - 10022usize];
                ["Offset of field: GkAtoms::_for_string"]
                    [::std::mem::offset_of!(GkAtoms, _for_string) - 10036usize];
                ["Offset of field: GkAtoms::forEach_string"]
                    [::std::mem::offset_of!(GkAtoms, forEach_string) - 10044usize];
                ["Offset of field: GkAtoms::forcedColors_string"]
                    [::std::mem::offset_of!(GkAtoms, forcedColors_string) - 10062usize];
                ["Offset of field: GkAtoms::invertedColors_string"]
                    [::std::mem::offset_of!(GkAtoms, invertedColors_string) - 10090usize];
                ["Offset of field: GkAtoms::forceOwnRefreshDriver_string"]
                    [::std::mem::offset_of!(GkAtoms, forceOwnRefreshDriver_string) - 10122usize];
                ["Offset of field: GkAtoms::form_string"]
                    [::std::mem::offset_of!(GkAtoms, form_string) - 10166usize];
                ["Offset of field: GkAtoms::formaction_string"]
                    [::std::mem::offset_of!(GkAtoms, formaction_string) - 10176usize];
                ["Offset of field: GkAtoms::format_string"]
                    [::std::mem::offset_of!(GkAtoms, format_string) - 10198usize];
                ["Offset of field: GkAtoms::formatNumber_string"]
                    [::std::mem::offset_of!(GkAtoms, formatNumber_string) - 10212usize];
                ["Offset of field: GkAtoms::formenctype_string"]
                    [::std::mem::offset_of!(GkAtoms, formenctype_string) - 10240usize];
                ["Offset of field: GkAtoms::formmethod_string"]
                    [::std::mem::offset_of!(GkAtoms, formmethod_string) - 10264usize];
                ["Offset of field: GkAtoms::formnovalidate_string"]
                    [::std::mem::offset_of!(GkAtoms, formnovalidate_string) - 10286usize];
                ["Offset of field: GkAtoms::formtarget_string"]
                    [::std::mem::offset_of!(GkAtoms, formtarget_string) - 10316usize];
                ["Offset of field: GkAtoms::frame_string"]
                    [::std::mem::offset_of!(GkAtoms, frame_string) - 10338usize];
                ["Offset of field: GkAtoms::frameborder_string"]
                    [::std::mem::offset_of!(GkAtoms, frameborder_string) - 10350usize];
                ["Offset of field: GkAtoms::frameset_string"]
                    [::std::mem::offset_of!(GkAtoms, frameset_string) - 10374usize];
                ["Offset of field: GkAtoms::from_string"]
                    [::std::mem::offset_of!(GkAtoms, from_string) - 10392usize];
                ["Offset of field: GkAtoms::fullscreenchange_string"]
                    [::std::mem::offset_of!(GkAtoms, fullscreenchange_string) - 10402usize];
                ["Offset of field: GkAtoms::fullscreenerror_string"]
                    [::std::mem::offset_of!(GkAtoms, fullscreenerror_string) - 10436usize];
                ["Offset of field: GkAtoms::functionAvailable_string"]
                    [::std::mem::offset_of!(GkAtoms, functionAvailable_string) - 10468usize];
                ["Offset of field: GkAtoms::generateId_string"]
                    [::std::mem::offset_of!(GkAtoms, generateId_string) - 10506usize];
                ["Offset of field: GkAtoms::generic_string"]
                    [::std::mem::offset_of!(GkAtoms, generic_string) - 10530usize];
                ["Offset of field: GkAtoms::getter_string"]
                    [::std::mem::offset_of!(GkAtoms, getter_string) - 10546usize];
                ["Offset of field: GkAtoms::graphicsDocument_string"]
                    [::std::mem::offset_of!(GkAtoms, graphicsDocument_string) - 10560usize];
                ["Offset of field: GkAtoms::graphicsObject_string"]
                    [::std::mem::offset_of!(GkAtoms, graphicsObject_string) - 10596usize];
                ["Offset of field: GkAtoms::graphicsSymbol_string"]
                    [::std::mem::offset_of!(GkAtoms, graphicsSymbol_string) - 10628usize];
                ["Offset of field: GkAtoms::grid_string"]
                    [::std::mem::offset_of!(GkAtoms, grid_string) - 10660usize];
                ["Offset of field: GkAtoms::group_string"]
                    [::std::mem::offset_of!(GkAtoms, group_string) - 10670usize];
                ["Offset of field: GkAtoms::groups_string"]
                    [::std::mem::offset_of!(GkAtoms, groups_string) - 10682usize];
                ["Offset of field: GkAtoms::groupbox_string"]
                    [::std::mem::offset_of!(GkAtoms, groupbox_string) - 10696usize];
                ["Offset of field: GkAtoms::groupingSeparator_string"]
                    [::std::mem::offset_of!(GkAtoms, groupingSeparator_string) - 10714usize];
                ["Offset of field: GkAtoms::groupingSize_string"]
                    [::std::mem::offset_of!(GkAtoms, groupingSize_string) - 10752usize];
                ["Offset of field: GkAtoms::grow_string"]
                    [::std::mem::offset_of!(GkAtoms, grow_string) - 10780usize];
                ["Offset of field: GkAtoms::h1_string"]
                    [::std::mem::offset_of!(GkAtoms, h1_string) - 10790usize];
                ["Offset of field: GkAtoms::h2_string"]
                    [::std::mem::offset_of!(GkAtoms, h2_string) - 10796usize];
                ["Offset of field: GkAtoms::h3_string"]
                    [::std::mem::offset_of!(GkAtoms, h3_string) - 10802usize];
                ["Offset of field: GkAtoms::h4_string"]
                    [::std::mem::offset_of!(GkAtoms, h4_string) - 10808usize];
                ["Offset of field: GkAtoms::h5_string"]
                    [::std::mem::offset_of!(GkAtoms, h5_string) - 10814usize];
                ["Offset of field: GkAtoms::h6_string"]
                    [::std::mem::offset_of!(GkAtoms, h6_string) - 10820usize];
                ["Offset of field: GkAtoms::hairline_string"]
                    [::std::mem::offset_of!(GkAtoms, hairline_string) - 10826usize];
                ["Offset of field: GkAtoms::handheldFriendly_string"]
                    [::std::mem::offset_of!(GkAtoms, handheldFriendly_string) - 10844usize];
                ["Offset of field: GkAtoms::handler_string"]
                    [::std::mem::offset_of!(GkAtoms, handler_string) - 10878usize];
                ["Offset of field: GkAtoms::handlers_string"]
                    [::std::mem::offset_of!(GkAtoms, handlers_string) - 10894usize];
                ["Offset of field: GkAtoms::HARD_string"]
                    [::std::mem::offset_of!(GkAtoms, HARD_string) - 10912usize];
                ["Offset of field: GkAtoms::hasActions_string"]
                    [::std::mem::offset_of!(GkAtoms, hasActions_string) - 10922usize];
                ["Offset of field: GkAtoms::hasSameNode_string"]
                    [::std::mem::offset_of!(GkAtoms, hasSameNode_string) - 10946usize];
                ["Offset of field: GkAtoms::hbox_string"]
                    [::std::mem::offset_of!(GkAtoms, hbox_string) - 10974usize];
                ["Offset of field: GkAtoms::head_string"]
                    [::std::mem::offset_of!(GkAtoms, head_string) - 10984usize];
                ["Offset of field: GkAtoms::header_string"]
                    [::std::mem::offset_of!(GkAtoms, header_string) - 10994usize];
                ["Offset of field: GkAtoms::headers_string"]
                    [::std::mem::offset_of!(GkAtoms, headers_string) - 11008usize];
                ["Offset of field: GkAtoms::hebrew_string"]
                    [::std::mem::offset_of!(GkAtoms, hebrew_string) - 11024usize];
                ["Offset of field: GkAtoms::height_string"]
                    [::std::mem::offset_of!(GkAtoms, height_string) - 11038usize];
                ["Offset of field: GkAtoms::hgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, hgroup_string) - 11052usize];
                ["Offset of field: GkAtoms::hidden_string"]
                    [::std::mem::offset_of!(GkAtoms, hidden_string) - 11066usize];
                ["Offset of field: GkAtoms::hidechrome_string"]
                    [::std::mem::offset_of!(GkAtoms, hidechrome_string) - 11080usize];
                ["Offset of field: GkAtoms::hidecolumnpicker_string"]
                    [::std::mem::offset_of!(GkAtoms, hidecolumnpicker_string) - 11102usize];
                ["Offset of field: GkAtoms::hidetitlebarseparator_string"]
                    [::std::mem::offset_of!(GkAtoms, hidetitlebarseparator_string) - 11136usize];
                ["Offset of field: GkAtoms::hide_popover_string"]
                    [::std::mem::offset_of!(GkAtoms, hide_popover_string) - 11180usize];
                ["Offset of field: GkAtoms::high_string"]
                    [::std::mem::offset_of!(GkAtoms, high_string) - 11206usize];
                ["Offset of field: GkAtoms::highest_string"]
                    [::std::mem::offset_of!(GkAtoms, highest_string) - 11216usize];
                ["Offset of field: GkAtoms::horizontal_string"]
                    [::std::mem::offset_of!(GkAtoms, horizontal_string) - 11232usize];
                ["Offset of field: GkAtoms::hover_string"]
                    [::std::mem::offset_of!(GkAtoms, hover_string) - 11254usize];
                ["Offset of field: GkAtoms::hr_string"]
                    [::std::mem::offset_of!(GkAtoms, hr_string) - 11266usize];
                ["Offset of field: GkAtoms::href_string"]
                    [::std::mem::offset_of!(GkAtoms, href_string) - 11272usize];
                ["Offset of field: GkAtoms::hreflang_string"]
                    [::std::mem::offset_of!(GkAtoms, hreflang_string) - 11282usize];
                ["Offset of field: GkAtoms::hsides_string"]
                    [::std::mem::offset_of!(GkAtoms, hsides_string) - 11300usize];
                ["Offset of field: GkAtoms::hspace_string"]
                    [::std::mem::offset_of!(GkAtoms, hspace_string) - 11314usize];
                ["Offset of field: GkAtoms::html_string"]
                    [::std::mem::offset_of!(GkAtoms, html_string) - 11328usize];
                ["Offset of field: GkAtoms::httpEquiv_string"]
                    [::std::mem::offset_of!(GkAtoms, httpEquiv_string) - 11338usize];
                ["Offset of field: GkAtoms::i_string"]
                    [::std::mem::offset_of!(GkAtoms, i_string) - 11360usize];
                ["Offset of field: GkAtoms::icon_string"]
                    [::std::mem::offset_of!(GkAtoms, icon_string) - 11364usize];
                ["Offset of field: GkAtoms::id_string"]
                    [::std::mem::offset_of!(GkAtoms, id_string) - 11374usize];
                ["Offset of field: GkAtoms::_if_string"]
                    [::std::mem::offset_of!(GkAtoms, _if_string) - 11380usize];
                ["Offset of field: GkAtoms::iframe_string"]
                    [::std::mem::offset_of!(GkAtoms, iframe_string) - 11386usize];
                ["Offset of field: GkAtoms::ignorekeys_string"]
                    [::std::mem::offset_of!(GkAtoms, ignorekeys_string) - 11400usize];
                ["Offset of field: GkAtoms::ignoreuserfocus_string"]
                    [::std::mem::offset_of!(GkAtoms, ignoreuserfocus_string) - 11422usize];
                ["Offset of field: GkAtoms::image_string"]
                    [::std::mem::offset_of!(GkAtoms, image_string) - 11454usize];
                ["Offset of field: GkAtoms::imageClickedPoint_string"]
                    [::std::mem::offset_of!(GkAtoms, imageClickedPoint_string) - 11466usize];
                ["Offset of field: GkAtoms::imagesizes_string"]
                    [::std::mem::offset_of!(GkAtoms, imagesizes_string) - 11506usize];
                ["Offset of field: GkAtoms::imagesrcset_string"]
                    [::std::mem::offset_of!(GkAtoms, imagesrcset_string) - 11528usize];
                ["Offset of field: GkAtoms::img_string"]
                    [::std::mem::offset_of!(GkAtoms, img_string) - 11552usize];
                ["Offset of field: GkAtoms::implementation_string"]
                    [::std::mem::offset_of!(GkAtoms, implementation_string) - 11560usize];
                ["Offset of field: GkAtoms::implements_string"]
                    [::std::mem::offset_of!(GkAtoms, implements_string) - 11590usize];
                ["Offset of field: GkAtoms::import_string"]
                    [::std::mem::offset_of!(GkAtoms, import_string) - 11612usize];
                ["Offset of field: GkAtoms::include_string"]
                    [::std::mem::offset_of!(GkAtoms, include_string) - 11626usize];
                ["Offset of field: GkAtoms::includes_string"]
                    [::std::mem::offset_of!(GkAtoms, includes_string) - 11642usize];
                ["Offset of field: GkAtoms::incontentshell_string"]
                    [::std::mem::offset_of!(GkAtoms, incontentshell_string) - 11660usize];
                ["Offset of field: GkAtoms::increment_string"]
                    [::std::mem::offset_of!(GkAtoms, increment_string) - 11690usize];
                ["Offset of field: GkAtoms::indent_string"]
                    [::std::mem::offset_of!(GkAtoms, indent_string) - 11710usize];
                ["Offset of field: GkAtoms::indeterminate_string"]
                    [::std::mem::offset_of!(GkAtoms, indeterminate_string) - 11724usize];
                ["Offset of field: GkAtoms::index_string"]
                    [::std::mem::offset_of!(GkAtoms, index_string) - 11752usize];
                ["Offset of field: GkAtoms::inert_string"]
                    [::std::mem::offset_of!(GkAtoms, inert_string) - 11764usize];
                ["Offset of field: GkAtoms::innerHTML_string"]
                    [::std::mem::offset_of!(GkAtoms, innerHTML_string) - 11776usize];
                ["Offset of field: GkAtoms::innerText_string"]
                    [::std::mem::offset_of!(GkAtoms, innerText_string) - 11796usize];
                ["Offset of field: GkAtoms::infinity_string"]
                    [::std::mem::offset_of!(GkAtoms, infinity_string) - 11816usize];
                ["Offset of field: GkAtoms::inherits_string"]
                    [::std::mem::offset_of!(GkAtoms, inherits_string) - 11834usize];
                ["Offset of field: GkAtoms::inheritOverflow_string"]
                    [::std::mem::offset_of!(GkAtoms, inheritOverflow_string) - 11852usize];
                ["Offset of field: GkAtoms::inheritstyle_string"]
                    [::std::mem::offset_of!(GkAtoms, inheritstyle_string) - 11886usize];
                ["Offset of field: GkAtoms::initial_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, initial_scale_string) - 11912usize];
                ["Offset of field: GkAtoms::input_string"]
                    [::std::mem::offset_of!(GkAtoms, input_string) - 11940usize];
                ["Offset of field: GkAtoms::inputmode_string"]
                    [::std::mem::offset_of!(GkAtoms, inputmode_string) - 11952usize];
                ["Offset of field: GkAtoms::ins_string"]
                    [::std::mem::offset_of!(GkAtoms, ins_string) - 11972usize];
                ["Offset of field: GkAtoms::insertafter_string"]
                    [::std::mem::offset_of!(GkAtoms, insertafter_string) - 11980usize];
                ["Offset of field: GkAtoms::insertbefore_string"]
                    [::std::mem::offset_of!(GkAtoms, insertbefore_string) - 12004usize];
                ["Offset of field: GkAtoms::insertion_string"]
                    [::std::mem::offset_of!(GkAtoms, insertion_string) - 12030usize];
                ["Offset of field: GkAtoms::integer_string"]
                    [::std::mem::offset_of!(GkAtoms, integer_string) - 12050usize];
                ["Offset of field: GkAtoms::integrity_string"]
                    [::std::mem::offset_of!(GkAtoms, integrity_string) - 12066usize];
                ["Offset of field: GkAtoms::interactive_widget_string"]
                    [::std::mem::offset_of!(GkAtoms, interactive_widget_string) - 12086usize];
                ["Offset of field: GkAtoms::internal_string"]
                    [::std::mem::offset_of!(GkAtoms, internal_string) - 12124usize];
                ["Offset of field: GkAtoms::internals_string"]
                    [::std::mem::offset_of!(GkAtoms, internals_string) - 12142usize];
                ["Offset of field: GkAtoms::intersection_string"]
                    [::std::mem::offset_of!(GkAtoms, intersection_string) - 12162usize];
                ["Offset of field: GkAtoms::is_string"]
                    [::std::mem::offset_of!(GkAtoms, is_string) - 12188usize];
                ["Offset of field: GkAtoms::ismap_string"]
                    [::std::mem::offset_of!(GkAtoms, ismap_string) - 12194usize];
                ["Offset of field: GkAtoms::ispopup_string"]
                    [::std::mem::offset_of!(GkAtoms, ispopup_string) - 12206usize];
                ["Offset of field: GkAtoms::itemid_string"]
                    [::std::mem::offset_of!(GkAtoms, itemid_string) - 12222usize];
                ["Offset of field: GkAtoms::itemprop_string"]
                    [::std::mem::offset_of!(GkAtoms, itemprop_string) - 12236usize];
                ["Offset of field: GkAtoms::itemref_string"]
                    [::std::mem::offset_of!(GkAtoms, itemref_string) - 12254usize];
                ["Offset of field: GkAtoms::itemscope_string"]
                    [::std::mem::offset_of!(GkAtoms, itemscope_string) - 12270usize];
                ["Offset of field: GkAtoms::itemtype_string"]
                    [::std::mem::offset_of!(GkAtoms, itemtype_string) - 12290usize];
                ["Offset of field: GkAtoms::japanese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, japanese_formal_string) - 12308usize];
                ["Offset of field: GkAtoms::japanese_informal_string"]
                    [::std::mem::offset_of!(GkAtoms, japanese_informal_string) - 12340usize];
                ["Offset of field: GkAtoms::kbd_string"]
                    [::std::mem::offset_of!(GkAtoms, kbd_string) - 12376usize];
                ["Offset of field: GkAtoms::keepcurrentinview_string"]
                    [::std::mem::offset_of!(GkAtoms, keepcurrentinview_string) - 12384usize];
                ["Offset of field: GkAtoms::key_string"]
                    [::std::mem::offset_of!(GkAtoms, key_string) - 12420usize];
                ["Offset of field: GkAtoms::keycode_string"]
                    [::std::mem::offset_of!(GkAtoms, keycode_string) - 12428usize];
                ["Offset of field: GkAtoms::keydown_string"]
                    [::std::mem::offset_of!(GkAtoms, keydown_string) - 12444usize];
                ["Offset of field: GkAtoms::keygen_string"]
                    [::std::mem::offset_of!(GkAtoms, keygen_string) - 12460usize];
                ["Offset of field: GkAtoms::keypress_string"]
                    [::std::mem::offset_of!(GkAtoms, keypress_string) - 12474usize];
                ["Offset of field: GkAtoms::keyset_string"]
                    [::std::mem::offset_of!(GkAtoms, keyset_string) - 12492usize];
                ["Offset of field: GkAtoms::keysystem_string"]
                    [::std::mem::offset_of!(GkAtoms, keysystem_string) - 12506usize];
                ["Offset of field: GkAtoms::keyup_string"]
                    [::std::mem::offset_of!(GkAtoms, keyup_string) - 12526usize];
                ["Offset of field: GkAtoms::kind_string"]
                    [::std::mem::offset_of!(GkAtoms, kind_string) - 12538usize];
                ["Offset of field: GkAtoms::korean_hangul_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, korean_hangul_formal_string) - 12548usize];
                ["Offset of field: GkAtoms::korean_hanja_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, korean_hanja_formal_string) - 12590usize];
                ["Offset of field: GkAtoms::korean_hanja_informal_string"]
                    [::std::mem::offset_of!(GkAtoms, korean_hanja_informal_string) - 12630usize];
                ["Offset of field: GkAtoms::label_string"]
                    [::std::mem::offset_of!(GkAtoms, label_string) - 12674usize];
                ["Offset of field: GkAtoms::lang_string"]
                    [::std::mem::offset_of!(GkAtoms, lang_string) - 12686usize];
                ["Offset of field: GkAtoms::language_string"]
                    [::std::mem::offset_of!(GkAtoms, language_string) - 12696usize];
                ["Offset of field: GkAtoms::largestContentfulPaint_string"]
                    [::std::mem::offset_of!(GkAtoms, largestContentfulPaint_string) - 12714usize];
                ["Offset of field: GkAtoms::last_string"]
                    [::std::mem::offset_of!(GkAtoms, last_string) - 12764usize];
                ["Offset of field: GkAtoms::layer_string"]
                    [::std::mem::offset_of!(GkAtoms, layer_string) - 12774usize];
                ["Offset of field: GkAtoms::LayerActivity_string"]
                    [::std::mem::offset_of!(GkAtoms, LayerActivity_string) - 12786usize];
                ["Offset of field: GkAtoms::layout_guess_string"]
                    [::std::mem::offset_of!(GkAtoms, layout_guess_string) - 12814usize];
                ["Offset of field: GkAtoms::leading_string"]
                    [::std::mem::offset_of!(GkAtoms, leading_string) - 12840usize];
                ["Offset of field: GkAtoms::leaf_string"]
                    [::std::mem::offset_of!(GkAtoms, leaf_string) - 12856usize];
                ["Offset of field: GkAtoms::left_string"]
                    [::std::mem::offset_of!(GkAtoms, left_string) - 12866usize];
                ["Offset of field: GkAtoms::leftmargin_string"]
                    [::std::mem::offset_of!(GkAtoms, leftmargin_string) - 12876usize];
                ["Offset of field: GkAtoms::legend_string"]
                    [::std::mem::offset_of!(GkAtoms, legend_string) - 12898usize];
                ["Offset of field: GkAtoms::length_string"]
                    [::std::mem::offset_of!(GkAtoms, length_string) - 12912usize];
                ["Offset of field: GkAtoms::letterValue_string"]
                    [::std::mem::offset_of!(GkAtoms, letterValue_string) - 12926usize];
                ["Offset of field: GkAtoms::level_string"]
                    [::std::mem::offset_of!(GkAtoms, level_string) - 12952usize];
                ["Offset of field: GkAtoms::lhs_string"]
                    [::std::mem::offset_of!(GkAtoms, lhs_string) - 12964usize];
                ["Offset of field: GkAtoms::li_string"]
                    [::std::mem::offset_of!(GkAtoms, li_string) - 12972usize];
                ["Offset of field: GkAtoms::line_string"]
                    [::std::mem::offset_of!(GkAtoms, line_string) - 12978usize];
                ["Offset of field: GkAtoms::link_string"]
                    [::std::mem::offset_of!(GkAtoms, link_string) - 12988usize];
                ["Offset of field: GkAtoms::linkset_string"]
                    [::std::mem::offset_of!(GkAtoms, linkset_string) - 12998usize];
                ["Offset of field: GkAtoms::listbox_string"]
                    [::std::mem::offset_of!(GkAtoms, listbox_string) - 13014usize];
                ["Offset of field: GkAtoms::listener_string"]
                    [::std::mem::offset_of!(GkAtoms, listener_string) - 13030usize];
                ["Offset of field: GkAtoms::listheader_string"]
                    [::std::mem::offset_of!(GkAtoms, listheader_string) - 13048usize];
                ["Offset of field: GkAtoms::listing_string"]
                    [::std::mem::offset_of!(GkAtoms, listing_string) - 13070usize];
                ["Offset of field: GkAtoms::listitem_string"]
                    [::std::mem::offset_of!(GkAtoms, listitem_string) - 13086usize];
                ["Offset of field: GkAtoms::load_string"]
                    [::std::mem::offset_of!(GkAtoms, load_string) - 13104usize];
                ["Offset of field: GkAtoms::loading_string"]
                    [::std::mem::offset_of!(GkAtoms, loading_string) - 13114usize];
                ["Offset of field: GkAtoms::touchmode_string"]
                    [::std::mem::offset_of!(GkAtoms, touchmode_string) - 13130usize];
                ["Offset of field: GkAtoms::triggeringprincipal_string"]
                    [::std::mem::offset_of!(GkAtoms, triggeringprincipal_string) - 13150usize];
                ["Offset of field: GkAtoms::localedir_string"]
                    [::std::mem::offset_of!(GkAtoms, localedir_string) - 13190usize];
                ["Offset of field: GkAtoms::localName_string"]
                    [::std::mem::offset_of!(GkAtoms, localName_string) - 13210usize];
                ["Offset of field: GkAtoms::localization_string"]
                    [::std::mem::offset_of!(GkAtoms, localization_string) - 13232usize];
                ["Offset of field: GkAtoms::longdesc_string"]
                    [::std::mem::offset_of!(GkAtoms, longdesc_string) - 13258usize];
                ["Offset of field: GkAtoms::loop_string"]
                    [::std::mem::offset_of!(GkAtoms, loop_string) - 13276usize];
                ["Offset of field: GkAtoms::low_string"]
                    [::std::mem::offset_of!(GkAtoms, low_string) - 13286usize];
                ["Offset of field: GkAtoms::lowerFirst_string"]
                    [::std::mem::offset_of!(GkAtoms, lowerFirst_string) - 13294usize];
                ["Offset of field: GkAtoms::lowest_string"]
                    [::std::mem::offset_of!(GkAtoms, lowest_string) - 13318usize];
                ["Offset of field: GkAtoms::lowsrc_string"]
                    [::std::mem::offset_of!(GkAtoms, lowsrc_string) - 13332usize];
                ["Offset of field: GkAtoms::ltr_string"]
                    [::std::mem::offset_of!(GkAtoms, ltr_string) - 13346usize];
                ["Offset of field: GkAtoms::main_string"]
                    [::std::mem::offset_of!(GkAtoms, main_string) - 13354usize];
                ["Offset of field: GkAtoms::map_string"]
                    [::std::mem::offset_of!(GkAtoms, map_string) - 13364usize];
                ["Offset of field: GkAtoms::manifest_string"]
                    [::std::mem::offset_of!(GkAtoms, manifest_string) - 13372usize];
                ["Offset of field: GkAtoms::marginBottom_string"]
                    [::std::mem::offset_of!(GkAtoms, marginBottom_string) - 13390usize];
                ["Offset of field: GkAtoms::marginLeft_string"]
                    [::std::mem::offset_of!(GkAtoms, marginLeft_string) - 13418usize];
                ["Offset of field: GkAtoms::marginRight_string"]
                    [::std::mem::offset_of!(GkAtoms, marginRight_string) - 13442usize];
                ["Offset of field: GkAtoms::marginTop_string"]
                    [::std::mem::offset_of!(GkAtoms, marginTop_string) - 13468usize];
                ["Offset of field: GkAtoms::marginheight_string"]
                    [::std::mem::offset_of!(GkAtoms, marginheight_string) - 13490usize];
                ["Offset of field: GkAtoms::marginwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, marginwidth_string) - 13516usize];
                ["Offset of field: GkAtoms::mark_string"]
                    [::std::mem::offset_of!(GkAtoms, mark_string) - 13540usize];
                ["Offset of field: GkAtoms::marquee_string"]
                    [::std::mem::offset_of!(GkAtoms, marquee_string) - 13550usize];
                ["Offset of field: GkAtoms::match_string"]
                    [::std::mem::offset_of!(GkAtoms, match_string) - 13566usize];
                ["Offset of field: GkAtoms::max_string"]
                    [::std::mem::offset_of!(GkAtoms, max_string) - 13578usize];
                ["Offset of field: GkAtoms::maxheight_string"]
                    [::std::mem::offset_of!(GkAtoms, maxheight_string) - 13586usize];
                ["Offset of field: GkAtoms::maximum_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, maximum_scale_string) - 13606usize];
                ["Offset of field: GkAtoms::maxlength_string"]
                    [::std::mem::offset_of!(GkAtoms, maxlength_string) - 13634usize];
                ["Offset of field: GkAtoms::maxpos_string"]
                    [::std::mem::offset_of!(GkAtoms, maxpos_string) - 13654usize];
                ["Offset of field: GkAtoms::maxwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, maxwidth_string) - 13668usize];
                ["Offset of field: GkAtoms::measure_string"]
                    [::std::mem::offset_of!(GkAtoms, measure_string) - 13686usize];
                ["Offset of field: GkAtoms::media_string"]
                    [::std::mem::offset_of!(GkAtoms, media_string) - 13702usize];
                ["Offset of field: GkAtoms::mediaType_string"]
                    [::std::mem::offset_of!(GkAtoms, mediaType_string) - 13714usize];
                ["Offset of field: GkAtoms::menu_string"]
                    [::std::mem::offset_of!(GkAtoms, menu_string) - 13736usize];
                ["Offset of field: GkAtoms::menubar_string"]
                    [::std::mem::offset_of!(GkAtoms, menubar_string) - 13746usize];
                ["Offset of field: GkAtoms::menucaption_string"]
                    [::std::mem::offset_of!(GkAtoms, menucaption_string) - 13762usize];
                ["Offset of field: GkAtoms::menugroup_string"]
                    [::std::mem::offset_of!(GkAtoms, menugroup_string) - 13786usize];
                ["Offset of field: GkAtoms::menuitem_string"]
                    [::std::mem::offset_of!(GkAtoms, menuitem_string) - 13806usize];
                ["Offset of field: GkAtoms::menulist_string"]
                    [::std::mem::offset_of!(GkAtoms, menulist_string) - 13824usize];
                ["Offset of field: GkAtoms::menupopup_string"]
                    [::std::mem::offset_of!(GkAtoms, menupopup_string) - 13842usize];
                ["Offset of field: GkAtoms::menuseparator_string"]
                    [::std::mem::offset_of!(GkAtoms, menuseparator_string) - 13862usize];
                ["Offset of field: GkAtoms::mesh_string"]
                    [::std::mem::offset_of!(GkAtoms, mesh_string) - 13890usize];
                ["Offset of field: GkAtoms::message_string"]
                    [::std::mem::offset_of!(GkAtoms, message_string) - 13900usize];
                ["Offset of field: GkAtoms::meta_string"]
                    [::std::mem::offset_of!(GkAtoms, meta_string) - 13916usize];
                ["Offset of field: GkAtoms::referrer_string"]
                    [::std::mem::offset_of!(GkAtoms, referrer_string) - 13926usize];
                ["Offset of field: GkAtoms::referrerpolicy_string"]
                    [::std::mem::offset_of!(GkAtoms, referrerpolicy_string) - 13944usize];
                ["Offset of field: GkAtoms::renderroot_string"]
                    [::std::mem::offset_of!(GkAtoms, renderroot_string) - 13974usize];
                ["Offset of field: GkAtoms::headerReferrerPolicy_string"]
                    [::std::mem::offset_of!(GkAtoms, headerReferrerPolicy_string) - 13996usize];
                ["Offset of field: GkAtoms::meter_string"]
                    [::std::mem::offset_of!(GkAtoms, meter_string) - 14028usize];
                ["Offset of field: GkAtoms::method_string"]
                    [::std::mem::offset_of!(GkAtoms, method_string) - 14040usize];
                ["Offset of field: GkAtoms::middle_string"]
                    [::std::mem::offset_of!(GkAtoms, middle_string) - 14054usize];
                ["Offset of field: GkAtoms::min_string"]
                    [::std::mem::offset_of!(GkAtoms, min_string) - 14068usize];
                ["Offset of field: GkAtoms::minheight_string"]
                    [::std::mem::offset_of!(GkAtoms, minheight_string) - 14076usize];
                ["Offset of field: GkAtoms::minimum_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, minimum_scale_string) - 14096usize];
                ["Offset of field: GkAtoms::minlength_string"]
                    [::std::mem::offset_of!(GkAtoms, minlength_string) - 14124usize];
                ["Offset of field: GkAtoms::minpos_string"]
                    [::std::mem::offset_of!(GkAtoms, minpos_string) - 14144usize];
                ["Offset of field: GkAtoms::minusSign_string"]
                    [::std::mem::offset_of!(GkAtoms, minusSign_string) - 14158usize];
                ["Offset of field: GkAtoms::minwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, minwidth_string) - 14180usize];
                ["Offset of field: GkAtoms::mixed_string"]
                    [::std::mem::offset_of!(GkAtoms, mixed_string) - 14198usize];
                ["Offset of field: GkAtoms::messagemanagergroup_string"]
                    [::std::mem::offset_of!(GkAtoms, messagemanagergroup_string) - 14210usize];
                ["Offset of field: GkAtoms::mod_string"]
                    [::std::mem::offset_of!(GkAtoms, mod_string) - 14250usize];
                ["Offset of field: GkAtoms::_module_string"]
                    [::std::mem::offset_of!(GkAtoms, _module_string) - 14258usize];
                ["Offset of field: GkAtoms::mode_string"]
                    [::std::mem::offset_of!(GkAtoms, mode_string) - 14272usize];
                ["Offset of field: GkAtoms::modifiers_string"]
                    [::std::mem::offset_of!(GkAtoms, modifiers_string) - 14282usize];
                ["Offset of field: GkAtoms::monochrome_string"]
                    [::std::mem::offset_of!(GkAtoms, monochrome_string) - 14302usize];
                ["Offset of field: GkAtoms::mouseover_string"]
                    [::std::mem::offset_of!(GkAtoms, mouseover_string) - 14324usize];
                ["Offset of field: GkAtoms::mozAccessiblecaret_string"]
                    [::std::mem::offset_of!(GkAtoms, mozAccessiblecaret_string) - 14344usize];
                ["Offset of field: GkAtoms::mozCustomContentContainer_string"][::std::mem::offset_of!(
                    GkAtoms,
                    mozCustomContentContainer_string
                ) - 14384usize];
                ["Offset of field: GkAtoms::mozGrabber_string"]
                    [::std::mem::offset_of!(GkAtoms, mozGrabber_string) - 14442usize];
                ["Offset of field: GkAtoms::mozNativeAnonymous_string"]
                    [::std::mem::offset_of!(GkAtoms, mozNativeAnonymous_string) - 14464usize];
                ["Offset of field: GkAtoms::mozprivatebrowsing_string"]
                    [::std::mem::offset_of!(GkAtoms, mozprivatebrowsing_string) - 14508usize];
                ["Offset of field: GkAtoms::mozResizer_string"]
                    [::std::mem::offset_of!(GkAtoms, mozResizer_string) - 14546usize];
                ["Offset of field: GkAtoms::mozResizingInfo_string"]
                    [::std::mem::offset_of!(GkAtoms, mozResizingInfo_string) - 14568usize];
                ["Offset of field: GkAtoms::mozResizingShadow_string"]
                    [::std::mem::offset_of!(GkAtoms, mozResizingShadow_string) - 14600usize];
                ["Offset of field: GkAtoms::mozTableAddColumnAfter_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableAddColumnAfter_string) - 14636usize];
                ["Offset of field: GkAtoms::mozTableAddColumnBefore_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableAddColumnBefore_string) - 14682usize];
                ["Offset of field: GkAtoms::mozTableAddRowAfter_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableAddRowAfter_string) - 14730usize];
                ["Offset of field: GkAtoms::mozTableAddRowBefore_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableAddRowBefore_string) - 14770usize];
                ["Offset of field: GkAtoms::mozTableRemoveRow_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableRemoveRow_string) - 14812usize];
                ["Offset of field: GkAtoms::mozTableRemoveColumn_string"]
                    [::std::mem::offset_of!(GkAtoms, mozTableRemoveColumn_string) - 14848usize];
                ["Offset of field: GkAtoms::moz_opaque_string"]
                    [::std::mem::offset_of!(GkAtoms, moz_opaque_string) - 14890usize];
                ["Offset of field: GkAtoms::multicol_string"]
                    [::std::mem::offset_of!(GkAtoms, multicol_string) - 14912usize];
                ["Offset of field: GkAtoms::multiple_string"]
                    [::std::mem::offset_of!(GkAtoms, multiple_string) - 14930usize];
                ["Offset of field: GkAtoms::muted_string"]
                    [::std::mem::offset_of!(GkAtoms, muted_string) - 14948usize];
                ["Offset of field: GkAtoms::name_string"]
                    [::std::mem::offset_of!(GkAtoms, name_string) - 14960usize];
                ["Offset of field: GkAtoms::native_string"]
                    [::std::mem::offset_of!(GkAtoms, native_string) - 14970usize];
                ["Offset of field: GkAtoms::_namespace_string"]
                    [::std::mem::offset_of!(GkAtoms, _namespace_string) - 14984usize];
                ["Offset of field: GkAtoms::namespaceAlias_string"]
                    [::std::mem::offset_of!(GkAtoms, namespaceAlias_string) - 15004usize];
                ["Offset of field: GkAtoms::namespaceUri_string"]
                    [::std::mem::offset_of!(GkAtoms, namespaceUri_string) - 15036usize];
                ["Offset of field: GkAtoms::NaN_string"]
                    [::std::mem::offset_of!(GkAtoms, NaN_string) - 15064usize];
                ["Offset of field: GkAtoms::n_string"]
                    [::std::mem::offset_of!(GkAtoms, n_string) - 15072usize];
                ["Offset of field: GkAtoms::nav_string"]
                    [::std::mem::offset_of!(GkAtoms, nav_string) - 15076usize];
                ["Offset of field: GkAtoms::ne_string"]
                    [::std::mem::offset_of!(GkAtoms, ne_string) - 15084usize];
                ["Offset of field: GkAtoms::never_string"]
                    [::std::mem::offset_of!(GkAtoms, never_string) - 15090usize];
                ["Offset of field: GkAtoms::neverhidden_string"]
                    [::std::mem::offset_of!(GkAtoms, neverhidden_string) - 15102usize];
                ["Offset of field: GkAtoms::_new_string"]
                    [::std::mem::offset_of!(GkAtoms, _new_string) - 15126usize];
                ["Offset of field: GkAtoms::newline_string"]
                    [::std::mem::offset_of!(GkAtoms, newline_string) - 15134usize];
                ["Offset of field: GkAtoms::nextRemoteTabId_string"]
                    [::std::mem::offset_of!(GkAtoms, nextRemoteTabId_string) - 15150usize];
                ["Offset of field: GkAtoms::no_string"]
                    [::std::mem::offset_of!(GkAtoms, no_string) - 15182usize];
                ["Offset of field: GkAtoms::noautofocus_string"]
                    [::std::mem::offset_of!(GkAtoms, noautofocus_string) - 15188usize];
                ["Offset of field: GkAtoms::noautohide_string"]
                    [::std::mem::offset_of!(GkAtoms, noautohide_string) - 15212usize];
                ["Offset of field: GkAtoms::norolluponanchor_string"]
                    [::std::mem::offset_of!(GkAtoms, norolluponanchor_string) - 15234usize];
                ["Offset of field: GkAtoms::noBar_string"]
                    [::std::mem::offset_of!(GkAtoms, noBar_string) - 15268usize];
                ["Offset of field: GkAtoms::nobr_string"]
                    [::std::mem::offset_of!(GkAtoms, nobr_string) - 15282usize];
                ["Offset of field: GkAtoms::nodefaultsrc_string"]
                    [::std::mem::offset_of!(GkAtoms, nodefaultsrc_string) - 15292usize];
                ["Offset of field: GkAtoms::nodeSet_string"]
                    [::std::mem::offset_of!(GkAtoms, nodeSet_string) - 15318usize];
                ["Offset of field: GkAtoms::noembed_string"]
                    [::std::mem::offset_of!(GkAtoms, noembed_string) - 15336usize];
                ["Offset of field: GkAtoms::noframes_string"]
                    [::std::mem::offset_of!(GkAtoms, noframes_string) - 15352usize];
                ["Offset of field: GkAtoms::nohref_string"]
                    [::std::mem::offset_of!(GkAtoms, nohref_string) - 15370usize];
                ["Offset of field: GkAtoms::noinitialselection_string"]
                    [::std::mem::offset_of!(GkAtoms, noinitialselection_string) - 15384usize];
                ["Offset of field: GkAtoms::nomodule_string"]
                    [::std::mem::offset_of!(GkAtoms, nomodule_string) - 15422usize];
                ["Offset of field: GkAtoms::nonce_string"]
                    [::std::mem::offset_of!(GkAtoms, nonce_string) - 15440usize];
                ["Offset of field: GkAtoms::none_string"]
                    [::std::mem::offset_of!(GkAtoms, none_string) - 15452usize];
                ["Offset of field: GkAtoms::noresize_string"]
                    [::std::mem::offset_of!(GkAtoms, noresize_string) - 15462usize];
                ["Offset of field: GkAtoms::normal_string"]
                    [::std::mem::offset_of!(GkAtoms, normal_string) - 15480usize];
                ["Offset of field: GkAtoms::normalizeSpace_string"]
                    [::std::mem::offset_of!(GkAtoms, normalizeSpace_string) - 15494usize];
                ["Offset of field: GkAtoms::noscript_string"]
                    [::std::mem::offset_of!(GkAtoms, noscript_string) - 15526usize];
                ["Offset of field: GkAtoms::noshade_string"]
                    [::std::mem::offset_of!(GkAtoms, noshade_string) - 15544usize];
                ["Offset of field: GkAtoms::notification_string"]
                    [::std::mem::offset_of!(GkAtoms, notification_string) - 15560usize];
                ["Offset of field: GkAtoms::novalidate_string"]
                    [::std::mem::offset_of!(GkAtoms, novalidate_string) - 15586usize];
                ["Offset of field: GkAtoms::_not_string"]
                    [::std::mem::offset_of!(GkAtoms, _not_string) - 15608usize];
                ["Offset of field: GkAtoms::nowrap_string"]
                    [::std::mem::offset_of!(GkAtoms, nowrap_string) - 15616usize];
                ["Offset of field: GkAtoms::number_string"]
                    [::std::mem::offset_of!(GkAtoms, number_string) - 15630usize];
                ["Offset of field: GkAtoms::nw_string"]
                    [::std::mem::offset_of!(GkAtoms, nw_string) - 15644usize];
                ["Offset of field: GkAtoms::object_string"]
                    [::std::mem::offset_of!(GkAtoms, object_string) - 15650usize];
                ["Offset of field: GkAtoms::objectType_string"]
                    [::std::mem::offset_of!(GkAtoms, objectType_string) - 15664usize];
                ["Offset of field: GkAtoms::observes_string"]
                    [::std::mem::offset_of!(GkAtoms, observes_string) - 15688usize];
                ["Offset of field: GkAtoms::odd_string"]
                    [::std::mem::offset_of!(GkAtoms, odd_string) - 15706usize];
                ["Offset of field: GkAtoms::OFF_string"]
                    [::std::mem::offset_of!(GkAtoms, OFF_string) - 15714usize];
                ["Offset of field: GkAtoms::ol_string"]
                    [::std::mem::offset_of!(GkAtoms, ol_string) - 15722usize];
                ["Offset of field: GkAtoms::omitXmlDeclaration_string"]
                    [::std::mem::offset_of!(GkAtoms, omitXmlDeclaration_string) - 15728usize];
                ["Offset of field: GkAtoms::onabort_string"]
                    [::std::mem::offset_of!(GkAtoms, onabort_string) - 15770usize];
                ["Offset of field: GkAtoms::onmozaccesskeynotfound_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozaccesskeynotfound_string) - 15786usize];
                ["Offset of field: GkAtoms::onactivate_string"]
                    [::std::mem::offset_of!(GkAtoms, onactivate_string) - 15832usize];
                ["Offset of field: GkAtoms::onafterprint_string"]
                    [::std::mem::offset_of!(GkAtoms, onafterprint_string) - 15854usize];
                ["Offset of field: GkAtoms::onanimationcancel_string"]
                    [::std::mem::offset_of!(GkAtoms, onanimationcancel_string) - 15880usize];
                ["Offset of field: GkAtoms::onanimationend_string"]
                    [::std::mem::offset_of!(GkAtoms, onanimationend_string) - 15916usize];
                ["Offset of field: GkAtoms::onanimationiteration_string"]
                    [::std::mem::offset_of!(GkAtoms, onanimationiteration_string) - 15946usize];
                ["Offset of field: GkAtoms::onanimationstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onanimationstart_string) - 15988usize];
                ["Offset of field: GkAtoms::onAppCommand_string"]
                    [::std::mem::offset_of!(GkAtoms, onAppCommand_string) - 16022usize];
                ["Offset of field: GkAtoms::onaudioprocess_string"]
                    [::std::mem::offset_of!(GkAtoms, onaudioprocess_string) - 16048usize];
                ["Offset of field: GkAtoms::onauxclick_string"]
                    [::std::mem::offset_of!(GkAtoms, onauxclick_string) - 16078usize];
                ["Offset of field: GkAtoms::onbeforecopy_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforecopy_string) - 16100usize];
                ["Offset of field: GkAtoms::onbeforecut_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforecut_string) - 16126usize];
                ["Offset of field: GkAtoms::onbeforeinput_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforeinput_string) - 16150usize];
                ["Offset of field: GkAtoms::onbeforematch_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforematch_string) - 16178usize];
                ["Offset of field: GkAtoms::onbeforepaste_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforepaste_string) - 16206usize];
                ["Offset of field: GkAtoms::onbeforeprint_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforeprint_string) - 16234usize];
                ["Offset of field: GkAtoms::onbeforeunload_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforeunload_string) - 16262usize];
                ["Offset of field: GkAtoms::onblocked_string"]
                    [::std::mem::offset_of!(GkAtoms, onblocked_string) - 16292usize];
                ["Offset of field: GkAtoms::onblur_string"]
                    [::std::mem::offset_of!(GkAtoms, onblur_string) - 16312usize];
                ["Offset of field: GkAtoms::onboundschange_string"]
                    [::std::mem::offset_of!(GkAtoms, onboundschange_string) - 16326usize];
                ["Offset of field: GkAtoms::onbroadcast_string"]
                    [::std::mem::offset_of!(GkAtoms, onbroadcast_string) - 16356usize];
                ["Offset of field: GkAtoms::onbufferedamountlow_string"]
                    [::std::mem::offset_of!(GkAtoms, onbufferedamountlow_string) - 16380usize];
                ["Offset of field: GkAtoms::oncached_string"]
                    [::std::mem::offset_of!(GkAtoms, oncached_string) - 16420usize];
                ["Offset of field: GkAtoms::oncancel_string"]
                    [::std::mem::offset_of!(GkAtoms, oncancel_string) - 16438usize];
                ["Offset of field: GkAtoms::onchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onchange_string) - 16456usize];
                ["Offset of field: GkAtoms::onchargingchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onchargingchange_string) - 16474usize];
                ["Offset of field: GkAtoms::onchargingtimechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onchargingtimechange_string) - 16508usize];
                ["Offset of field: GkAtoms::onchecking_string"]
                    [::std::mem::offset_of!(GkAtoms, onchecking_string) - 16550usize];
                ["Offset of field: GkAtoms::onCheckboxStateChange_string"]
                    [::std::mem::offset_of!(GkAtoms, onCheckboxStateChange_string) - 16572usize];
                ["Offset of field: GkAtoms::onCheckKeyPressEventModel_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onCheckKeyPressEventModel_string
                ) - 16616usize];
                ["Offset of field: GkAtoms::onclick_string"]
                    [::std::mem::offset_of!(GkAtoms, onclick_string) - 16668usize];
                ["Offset of field: GkAtoms::onclose_string"]
                    [::std::mem::offset_of!(GkAtoms, onclose_string) - 16684usize];
                ["Offset of field: GkAtoms::onclosing_string"]
                    [::std::mem::offset_of!(GkAtoms, onclosing_string) - 16700usize];
                ["Offset of field: GkAtoms::oncontentvisibilityautostatechange_string"][::std::mem::offset_of!(
                    GkAtoms,
                    oncontentvisibilityautostatechange_string
                )
                    - 16720usize];
                ["Offset of field: GkAtoms::oncommand_string"]
                    [::std::mem::offset_of!(GkAtoms, oncommand_string) - 16790usize];
                ["Offset of field: GkAtoms::oncommandupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, oncommandupdate_string) - 16810usize];
                ["Offset of field: GkAtoms::oncomplete_string"]
                    [::std::mem::offset_of!(GkAtoms, oncomplete_string) - 16842usize];
                ["Offset of field: GkAtoms::oncompositionend_string"]
                    [::std::mem::offset_of!(GkAtoms, oncompositionend_string) - 16864usize];
                ["Offset of field: GkAtoms::oncompositionstart_string"]
                    [::std::mem::offset_of!(GkAtoms, oncompositionstart_string) - 16898usize];
                ["Offset of field: GkAtoms::oncompositionupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, oncompositionupdate_string) - 16936usize];
                ["Offset of field: GkAtoms::onconnect_string"]
                    [::std::mem::offset_of!(GkAtoms, onconnect_string) - 16976usize];
                ["Offset of field: GkAtoms::onconnectionavailable_string"]
                    [::std::mem::offset_of!(GkAtoms, onconnectionavailable_string) - 16996usize];
                ["Offset of field: GkAtoms::oncontextmenu_string"]
                    [::std::mem::offset_of!(GkAtoms, oncontextmenu_string) - 17040usize];
                ["Offset of field: GkAtoms::oncontextlost_string"]
                    [::std::mem::offset_of!(GkAtoms, oncontextlost_string) - 17068usize];
                ["Offset of field: GkAtoms::oncontextrestored_string"]
                    [::std::mem::offset_of!(GkAtoms, oncontextrestored_string) - 17096usize];
                ["Offset of field: GkAtoms::oncookiechange_string"]
                    [::std::mem::offset_of!(GkAtoms, oncookiechange_string) - 17132usize];
                ["Offset of field: GkAtoms::oncopy_string"]
                    [::std::mem::offset_of!(GkAtoms, oncopy_string) - 17162usize];
                ["Offset of field: GkAtoms::oncut_string"]
                    [::std::mem::offset_of!(GkAtoms, oncut_string) - 17176usize];
                ["Offset of field: GkAtoms::oncurrententrychange_string"]
                    [::std::mem::offset_of!(GkAtoms, oncurrententrychange_string) - 17188usize];
                ["Offset of field: GkAtoms::ondblclick_string"]
                    [::std::mem::offset_of!(GkAtoms, ondblclick_string) - 17230usize];
                ["Offset of field: GkAtoms::ondischargingtimechange_string"]
                    [::std::mem::offset_of!(GkAtoms, ondischargingtimechange_string) - 17252usize];
                ["Offset of field: GkAtoms::ondispose_string"]
                    [::std::mem::offset_of!(GkAtoms, ondispose_string) - 17300usize];
                ["Offset of field: GkAtoms::ondownloading_string"]
                    [::std::mem::offset_of!(GkAtoms, ondownloading_string) - 17320usize];
                ["Offset of field: GkAtoms::onDOMActivate_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMActivate_string) - 17348usize];
                ["Offset of field: GkAtoms::onDOMFocusIn_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMFocusIn_string) - 17376usize];
                ["Offset of field: GkAtoms::onDOMFocusOut_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMFocusOut_string) - 17402usize];
                ["Offset of field: GkAtoms::onDOMMouseScroll_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMMouseScroll_string) - 17430usize];
                ["Offset of field: GkAtoms::ondata_string"]
                    [::std::mem::offset_of!(GkAtoms, ondata_string) - 17464usize];
                ["Offset of field: GkAtoms::ondrag_string"]
                    [::std::mem::offset_of!(GkAtoms, ondrag_string) - 17478usize];
                ["Offset of field: GkAtoms::ondragdrop_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragdrop_string) - 17492usize];
                ["Offset of field: GkAtoms::ondragend_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragend_string) - 17514usize];
                ["Offset of field: GkAtoms::ondragenter_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragenter_string) - 17534usize];
                ["Offset of field: GkAtoms::ondragexit_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragexit_string) - 17558usize];
                ["Offset of field: GkAtoms::ondragleave_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragleave_string) - 17580usize];
                ["Offset of field: GkAtoms::ondragover_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragover_string) - 17604usize];
                ["Offset of field: GkAtoms::ondragstart_string"]
                    [::std::mem::offset_of!(GkAtoms, ondragstart_string) - 17626usize];
                ["Offset of field: GkAtoms::ondrain_string"]
                    [::std::mem::offset_of!(GkAtoms, ondrain_string) - 17650usize];
                ["Offset of field: GkAtoms::ondrop_string"]
                    [::std::mem::offset_of!(GkAtoms, ondrop_string) - 17666usize];
                ["Offset of field: GkAtoms::onerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onerror_string) - 17680usize];
                ["Offset of field: GkAtoms::onfinish_string"]
                    [::std::mem::offset_of!(GkAtoms, onfinish_string) - 17696usize];
                ["Offset of field: GkAtoms::onfocus_string"]
                    [::std::mem::offset_of!(GkAtoms, onfocus_string) - 17714usize];
                ["Offset of field: GkAtoms::onfocusin_string"]
                    [::std::mem::offset_of!(GkAtoms, onfocusin_string) - 17730usize];
                ["Offset of field: GkAtoms::onfocusout_string"]
                    [::std::mem::offset_of!(GkAtoms, onfocusout_string) - 17750usize];
                ["Offset of field: GkAtoms::onfullscreenchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onfullscreenchange_string) - 17772usize];
                ["Offset of field: GkAtoms::onfullscreenerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onfullscreenerror_string) - 17810usize];
                ["Offset of field: GkAtoms::ongatheringstatechange_string"]
                    [::std::mem::offset_of!(GkAtoms, ongatheringstatechange_string) - 17846usize];
                ["Offset of field: GkAtoms::onget_string"]
                    [::std::mem::offset_of!(GkAtoms, onget_string) - 17892usize];
                ["Offset of field: GkAtoms::onhashchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onhashchange_string) - 17904usize];
                ["Offset of field: GkAtoms::oninput_string"]
                    [::std::mem::offset_of!(GkAtoms, oninput_string) - 17930usize];
                ["Offset of field: GkAtoms::oninputsourceschange_string"]
                    [::std::mem::offset_of!(GkAtoms, oninputsourceschange_string) - 17946usize];
                ["Offset of field: GkAtoms::oninstall_string"]
                    [::std::mem::offset_of!(GkAtoms, oninstall_string) - 17988usize];
                ["Offset of field: GkAtoms::oninvalid_string"]
                    [::std::mem::offset_of!(GkAtoms, oninvalid_string) - 18008usize];
                ["Offset of field: GkAtoms::onkeydown_string"]
                    [::std::mem::offset_of!(GkAtoms, onkeydown_string) - 18028usize];
                ["Offset of field: GkAtoms::onkeypress_string"]
                    [::std::mem::offset_of!(GkAtoms, onkeypress_string) - 18048usize];
                ["Offset of field: GkAtoms::onkeyup_string"]
                    [::std::mem::offset_of!(GkAtoms, onkeyup_string) - 18070usize];
                ["Offset of field: GkAtoms::onlanguagechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onlanguagechange_string) - 18086usize];
                ["Offset of field: GkAtoms::onlevelchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onlevelchange_string) - 18120usize];
                ["Offset of field: GkAtoms::onload_string"]
                    [::std::mem::offset_of!(GkAtoms, onload_string) - 18148usize];
                ["Offset of field: GkAtoms::onloading_string"]
                    [::std::mem::offset_of!(GkAtoms, onloading_string) - 18162usize];
                ["Offset of field: GkAtoms::onloadingdone_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadingdone_string) - 18182usize];
                ["Offset of field: GkAtoms::onloadingerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadingerror_string) - 18210usize];
                ["Offset of field: GkAtoms::onpopstate_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopstate_string) - 18240usize];
                ["Offset of field: GkAtoms::only_string"]
                    [::std::mem::offset_of!(GkAtoms, only_string) - 18262usize];
                ["Offset of field: GkAtoms::onmerchantvalidation_string"]
                    [::std::mem::offset_of!(GkAtoms, onmerchantvalidation_string) - 18272usize];
                ["Offset of field: GkAtoms::onmessage_string"]
                    [::std::mem::offset_of!(GkAtoms, onmessage_string) - 18314usize];
                ["Offset of field: GkAtoms::onmessageerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onmessageerror_string) - 18334usize];
                ["Offset of field: GkAtoms::onmidimessage_string"]
                    [::std::mem::offset_of!(GkAtoms, onmidimessage_string) - 18364usize];
                ["Offset of field: GkAtoms::onmousedown_string"]
                    [::std::mem::offset_of!(GkAtoms, onmousedown_string) - 18392usize];
                ["Offset of field: GkAtoms::onmouseenter_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouseenter_string) - 18416usize];
                ["Offset of field: GkAtoms::onmouseleave_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouseleave_string) - 18442usize];
                ["Offset of field: GkAtoms::onmouselongtap_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouselongtap_string) - 18468usize];
                ["Offset of field: GkAtoms::onmousemove_string"]
                    [::std::mem::offset_of!(GkAtoms, onmousemove_string) - 18498usize];
                ["Offset of field: GkAtoms::onmouseout_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouseout_string) - 18522usize];
                ["Offset of field: GkAtoms::onmouseover_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouseover_string) - 18544usize];
                ["Offset of field: GkAtoms::onMozMouseHittest_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozMouseHittest_string) - 18568usize];
                ["Offset of field: GkAtoms::onMozMouseExploreByTouch_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozMouseExploreByTouch_string) - 18604usize];
                ["Offset of field: GkAtoms::onmouseup_string"]
                    [::std::mem::offset_of!(GkAtoms, onmouseup_string) - 18654usize];
                ["Offset of field: GkAtoms::onMozAfterPaint_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozAfterPaint_string) - 18674usize];
                ["Offset of field: GkAtoms::onmozfullscreenchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozfullscreenchange_string) - 18706usize];
                ["Offset of field: GkAtoms::onmozfullscreenerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozfullscreenerror_string) - 18750usize];
                ["Offset of field: GkAtoms::onmozpointerlockchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozpointerlockchange_string) - 18792usize];
                ["Offset of field: GkAtoms::onmozpointerlockerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozpointerlockerror_string) - 18838usize];
                ["Offset of field: GkAtoms::onMozMousePixelScroll_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozMousePixelScroll_string) - 18882usize];
                ["Offset of field: GkAtoms::onMozScrolledAreaChanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozScrolledAreaChanged_string) - 18926usize];
                ["Offset of field: GkAtoms::onmute_string"]
                    [::std::mem::offset_of!(GkAtoms, onmute_string) - 18976usize];
                ["Offset of field: GkAtoms::onnavigate_string"]
                    [::std::mem::offset_of!(GkAtoms, onnavigate_string) - 18990usize];
                ["Offset of field: GkAtoms::onnavigatesuccess_string"]
                    [::std::mem::offset_of!(GkAtoms, onnavigatesuccess_string) - 19012usize];
                ["Offset of field: GkAtoms::onnavigateerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onnavigateerror_string) - 19048usize];
                ["Offset of field: GkAtoms::onnotificationclick_string"]
                    [::std::mem::offset_of!(GkAtoms, onnotificationclick_string) - 19080usize];
                ["Offset of field: GkAtoms::onnotificationclose_string"]
                    [::std::mem::offset_of!(GkAtoms, onnotificationclose_string) - 19120usize];
                ["Offset of field: GkAtoms::onnoupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onnoupdate_string) - 19160usize];
                ["Offset of field: GkAtoms::onobsolete_string"]
                    [::std::mem::offset_of!(GkAtoms, onobsolete_string) - 19182usize];
                ["Offset of field: GkAtoms::ononline_string"]
                    [::std::mem::offset_of!(GkAtoms, ononline_string) - 19204usize];
                ["Offset of field: GkAtoms::onoffline_string"]
                    [::std::mem::offset_of!(GkAtoms, onoffline_string) - 19222usize];
                ["Offset of field: GkAtoms::onopen_string"]
                    [::std::mem::offset_of!(GkAtoms, onopen_string) - 19242usize];
                ["Offset of field: GkAtoms::onorientationchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onorientationchange_string) - 19256usize];
                ["Offset of field: GkAtoms::onoverflow_string"]
                    [::std::mem::offset_of!(GkAtoms, onoverflow_string) - 19296usize];
                ["Offset of field: GkAtoms::onpagehide_string"]
                    [::std::mem::offset_of!(GkAtoms, onpagehide_string) - 19318usize];
                ["Offset of field: GkAtoms::onpageshow_string"]
                    [::std::mem::offset_of!(GkAtoms, onpageshow_string) - 19340usize];
                ["Offset of field: GkAtoms::onpaste_string"]
                    [::std::mem::offset_of!(GkAtoms, onpaste_string) - 19362usize];
                ["Offset of field: GkAtoms::onpayerdetailchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onpayerdetailchange_string) - 19378usize];
                ["Offset of field: GkAtoms::onpaymentmethodchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onpaymentmethodchange_string) - 19418usize];
                ["Offset of field: GkAtoms::onpointerlockchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerlockchange_string) - 19462usize];
                ["Offset of field: GkAtoms::onpointerlockerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerlockerror_string) - 19502usize];
                ["Offset of field: GkAtoms::onpopuphidden_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopuphidden_string) - 19540usize];
                ["Offset of field: GkAtoms::onpopuphiding_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopuphiding_string) - 19568usize];
                ["Offset of field: GkAtoms::onpopuppositioned_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopuppositioned_string) - 19596usize];
                ["Offset of field: GkAtoms::onpopupshowing_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopupshowing_string) - 19632usize];
                ["Offset of field: GkAtoms::onpopupshown_string"]
                    [::std::mem::offset_of!(GkAtoms, onpopupshown_string) - 19662usize];
                ["Offset of field: GkAtoms::onprocessorerror_string"]
                    [::std::mem::offset_of!(GkAtoms, onprocessorerror_string) - 19688usize];
                ["Offset of field: GkAtoms::onprioritychange_string"]
                    [::std::mem::offset_of!(GkAtoms, onprioritychange_string) - 19722usize];
                ["Offset of field: GkAtoms::onpush_string"]
                    [::std::mem::offset_of!(GkAtoms, onpush_string) - 19756usize];
                ["Offset of field: GkAtoms::onpushsubscriptionchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onpushsubscriptionchange_string) - 19770usize];
                ["Offset of field: GkAtoms::onRadioStateChange_string"]
                    [::std::mem::offset_of!(GkAtoms, onRadioStateChange_string) - 19820usize];
                ["Offset of field: GkAtoms::onreadystatechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onreadystatechange_string) - 19858usize];
                ["Offset of field: GkAtoms::onrejectionhandled_string"]
                    [::std::mem::offset_of!(GkAtoms, onrejectionhandled_string) - 19896usize];
                ["Offset of field: GkAtoms::onremove_string"]
                    [::std::mem::offset_of!(GkAtoms, onremove_string) - 19934usize];
                ["Offset of field: GkAtoms::onrequestprogress_string"]
                    [::std::mem::offset_of!(GkAtoms, onrequestprogress_string) - 19952usize];
                ["Offset of field: GkAtoms::onresourcetimingbufferfull_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onresourcetimingbufferfull_string
                ) - 19988usize];
                ["Offset of field: GkAtoms::onresponseprogress_string"]
                    [::std::mem::offset_of!(GkAtoms, onresponseprogress_string) - 20042usize];
                ["Offset of field: GkAtoms::onRequest_string"]
                    [::std::mem::offset_of!(GkAtoms, onRequest_string) - 20080usize];
                ["Offset of field: GkAtoms::onreset_string"]
                    [::std::mem::offset_of!(GkAtoms, onreset_string) - 20100usize];
                ["Offset of field: GkAtoms::onresize_string"]
                    [::std::mem::offset_of!(GkAtoms, onresize_string) - 20116usize];
                ["Offset of field: GkAtoms::onscroll_string"]
                    [::std::mem::offset_of!(GkAtoms, onscroll_string) - 20134usize];
                ["Offset of field: GkAtoms::onsecuritypolicyviolation_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onsecuritypolicyviolation_string
                ) - 20152usize];
                ["Offset of field: GkAtoms::onselect_string"]
                    [::std::mem::offset_of!(GkAtoms, onselect_string) - 20204usize];
                ["Offset of field: GkAtoms::onselectionchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onselectionchange_string) - 20222usize];
                ["Offset of field: GkAtoms::onselectend_string"]
                    [::std::mem::offset_of!(GkAtoms, onselectend_string) - 20258usize];
                ["Offset of field: GkAtoms::onselectstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onselectstart_string) - 20282usize];
                ["Offset of field: GkAtoms::onset_string"]
                    [::std::mem::offset_of!(GkAtoms, onset_string) - 20310usize];
                ["Offset of field: GkAtoms::onshippingaddresschange_string"]
                    [::std::mem::offset_of!(GkAtoms, onshippingaddresschange_string) - 20322usize];
                ["Offset of field: GkAtoms::onshippingoptionchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onshippingoptionchange_string) - 20370usize];
                ["Offset of field: GkAtoms::onshow_string"]
                    [::std::mem::offset_of!(GkAtoms, onshow_string) - 20416usize];
                ["Offset of field: GkAtoms::onslotchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onslotchange_string) - 20430usize];
                ["Offset of field: GkAtoms::onsqueeze_string"]
                    [::std::mem::offset_of!(GkAtoms, onsqueeze_string) - 20456usize];
                ["Offset of field: GkAtoms::onsqueezeend_string"]
                    [::std::mem::offset_of!(GkAtoms, onsqueezeend_string) - 20476usize];
                ["Offset of field: GkAtoms::onsqueezestart_string"]
                    [::std::mem::offset_of!(GkAtoms, onsqueezestart_string) - 20502usize];
                ["Offset of field: GkAtoms::onstatechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onstatechange_string) - 20532usize];
                ["Offset of field: GkAtoms::onstorage_string"]
                    [::std::mem::offset_of!(GkAtoms, onstorage_string) - 20560usize];
                ["Offset of field: GkAtoms::onsubmit_string"]
                    [::std::mem::offset_of!(GkAtoms, onsubmit_string) - 20580usize];
                ["Offset of field: GkAtoms::onsuccess_string"]
                    [::std::mem::offset_of!(GkAtoms, onsuccess_string) - 20598usize];
                ["Offset of field: GkAtoms::onsystemstatusbarclick_string"]
                    [::std::mem::offset_of!(GkAtoms, onsystemstatusbarclick_string) - 20618usize];
                ["Offset of field: GkAtoms::ontypechange_string"]
                    [::std::mem::offset_of!(GkAtoms, ontypechange_string) - 20664usize];
                ["Offset of field: GkAtoms::onterminate_string"]
                    [::std::mem::offset_of!(GkAtoms, onterminate_string) - 20690usize];
                ["Offset of field: GkAtoms::ontext_string"]
                    [::std::mem::offset_of!(GkAtoms, ontext_string) - 20714usize];
                ["Offset of field: GkAtoms::ontextInput_string"]
                    [::std::mem::offset_of!(GkAtoms, ontextInput_string) - 20728usize];
                ["Offset of field: GkAtoms::ontoggle_string"]
                    [::std::mem::offset_of!(GkAtoms, ontoggle_string) - 20752usize];
                ["Offset of field: GkAtoms::ontonechange_string"]
                    [::std::mem::offset_of!(GkAtoms, ontonechange_string) - 20770usize];
                ["Offset of field: GkAtoms::ontouchstart_string"]
                    [::std::mem::offset_of!(GkAtoms, ontouchstart_string) - 20796usize];
                ["Offset of field: GkAtoms::ontouchend_string"]
                    [::std::mem::offset_of!(GkAtoms, ontouchend_string) - 20822usize];
                ["Offset of field: GkAtoms::ontouchmove_string"]
                    [::std::mem::offset_of!(GkAtoms, ontouchmove_string) - 20844usize];
                ["Offset of field: GkAtoms::ontouchcancel_string"]
                    [::std::mem::offset_of!(GkAtoms, ontouchcancel_string) - 20868usize];
                ["Offset of field: GkAtoms::ontransitioncancel_string"]
                    [::std::mem::offset_of!(GkAtoms, ontransitioncancel_string) - 20896usize];
                ["Offset of field: GkAtoms::ontransitionend_string"]
                    [::std::mem::offset_of!(GkAtoms, ontransitionend_string) - 20934usize];
                ["Offset of field: GkAtoms::ontransitionrun_string"]
                    [::std::mem::offset_of!(GkAtoms, ontransitionrun_string) - 20966usize];
                ["Offset of field: GkAtoms::ontransitionstart_string"]
                    [::std::mem::offset_of!(GkAtoms, ontransitionstart_string) - 20998usize];
                ["Offset of field: GkAtoms::onuncapturederror_string"]
                    [::std::mem::offset_of!(GkAtoms, onuncapturederror_string) - 21034usize];
                ["Offset of field: GkAtoms::onunderflow_string"]
                    [::std::mem::offset_of!(GkAtoms, onunderflow_string) - 21070usize];
                ["Offset of field: GkAtoms::onunhandledrejection_string"]
                    [::std::mem::offset_of!(GkAtoms, onunhandledrejection_string) - 21094usize];
                ["Offset of field: GkAtoms::onunload_string"]
                    [::std::mem::offset_of!(GkAtoms, onunload_string) - 21136usize];
                ["Offset of field: GkAtoms::onunmute_string"]
                    [::std::mem::offset_of!(GkAtoms, onunmute_string) - 21154usize];
                ["Offset of field: GkAtoms::onupdatefound_string"]
                    [::std::mem::offset_of!(GkAtoms, onupdatefound_string) - 21172usize];
                ["Offset of field: GkAtoms::onupdateready_string"]
                    [::std::mem::offset_of!(GkAtoms, onupdateready_string) - 21200usize];
                ["Offset of field: GkAtoms::onupgradeneeded_string"]
                    [::std::mem::offset_of!(GkAtoms, onupgradeneeded_string) - 21228usize];
                ["Offset of field: GkAtoms::onversionchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onversionchange_string) - 21260usize];
                ["Offset of field: GkAtoms::onvisibilitychange_string"]
                    [::std::mem::offset_of!(GkAtoms, onvisibilitychange_string) - 21292usize];
                ["Offset of field: GkAtoms::onvoiceschanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onvoiceschanged_string) - 21330usize];
                ["Offset of field: GkAtoms::onvrdisplayactivate_string"]
                    [::std::mem::offset_of!(GkAtoms, onvrdisplayactivate_string) - 21362usize];
                ["Offset of field: GkAtoms::onvrdisplayconnect_string"]
                    [::std::mem::offset_of!(GkAtoms, onvrdisplayconnect_string) - 21402usize];
                ["Offset of field: GkAtoms::onvrdisplaydeactivate_string"]
                    [::std::mem::offset_of!(GkAtoms, onvrdisplaydeactivate_string) - 21440usize];
                ["Offset of field: GkAtoms::onvrdisplaydisconnect_string"]
                    [::std::mem::offset_of!(GkAtoms, onvrdisplaydisconnect_string) - 21484usize];
                ["Offset of field: GkAtoms::onvrdisplaypresentchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onvrdisplaypresentchange_string) - 21528usize];
                ["Offset of field: GkAtoms::onwebkitAnimationEnd_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkitAnimationEnd_string) - 21578usize];
                ["Offset of field: GkAtoms::onwebkitAnimationIteration_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onwebkitAnimationIteration_string
                ) - 21620usize];
                ["Offset of field: GkAtoms::onwebkitAnimationStart_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkitAnimationStart_string) - 21674usize];
                ["Offset of field: GkAtoms::onwebkitTransitionEnd_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkitTransitionEnd_string) - 21720usize];
                ["Offset of field: GkAtoms::onwebkitanimationend_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkitanimationend_string) - 21764usize];
                ["Offset of field: GkAtoms::onwebkitanimationiteration_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onwebkitanimationiteration_string
                ) - 21806usize];
                ["Offset of field: GkAtoms::onwebkitanimationstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkitanimationstart_string) - 21860usize];
                ["Offset of field: GkAtoms::onwebkittransitionend_string"]
                    [::std::mem::offset_of!(GkAtoms, onwebkittransitionend_string) - 21906usize];
                ["Offset of field: GkAtoms::onwheel_string"]
                    [::std::mem::offset_of!(GkAtoms, onwheel_string) - 21950usize];
                ["Offset of field: GkAtoms::open_string"]
                    [::std::mem::offset_of!(GkAtoms, open_string) - 21966usize];
                ["Offset of field: GkAtoms::optgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, optgroup_string) - 21976usize];
                ["Offset of field: GkAtoms::optimum_string"]
                    [::std::mem::offset_of!(GkAtoms, optimum_string) - 21994usize];
                ["Offset of field: GkAtoms::option_string"]
                    [::std::mem::offset_of!(GkAtoms, option_string) - 22010usize];
                ["Offset of field: GkAtoms::_or_string"]
                    [::std::mem::offset_of!(GkAtoms, _or_string) - 22024usize];
                ["Offset of field: GkAtoms::order_string"]
                    [::std::mem::offset_of!(GkAtoms, order_string) - 22030usize];
                ["Offset of field: GkAtoms::ordinal_string"]
                    [::std::mem::offset_of!(GkAtoms, ordinal_string) - 22042usize];
                ["Offset of field: GkAtoms::orient_string"]
                    [::std::mem::offset_of!(GkAtoms, orient_string) - 22058usize];
                ["Offset of field: GkAtoms::orientation_string"]
                    [::std::mem::offset_of!(GkAtoms, orientation_string) - 22072usize];
                ["Offset of field: GkAtoms::origin_trial_string"]
                    [::std::mem::offset_of!(GkAtoms, origin_trial_string) - 22096usize];
                ["Offset of field: GkAtoms::otherwise_string"]
                    [::std::mem::offset_of!(GkAtoms, otherwise_string) - 22122usize];
                ["Offset of field: GkAtoms::outerHTML_string"]
                    [::std::mem::offset_of!(GkAtoms, outerHTML_string) - 22142usize];
                ["Offset of field: GkAtoms::output_string"]
                    [::std::mem::offset_of!(GkAtoms, output_string) - 22162usize];
                ["Offset of field: GkAtoms::overflow_string"]
                    [::std::mem::offset_of!(GkAtoms, overflow_string) - 22176usize];
                ["Offset of field: GkAtoms::overflowBlock_string"]
                    [::std::mem::offset_of!(GkAtoms, overflowBlock_string) - 22194usize];
                ["Offset of field: GkAtoms::overflowInline_string"]
                    [::std::mem::offset_of!(GkAtoms, overflowInline_string) - 22224usize];
                ["Offset of field: GkAtoms::overlay_string"]
                    [::std::mem::offset_of!(GkAtoms, overlay_string) - 22256usize];
                ["Offset of field: GkAtoms::p_string"]
                    [::std::mem::offset_of!(GkAtoms, p_string) - 22272usize];
                ["Offset of field: GkAtoms::pack_string"]
                    [::std::mem::offset_of!(GkAtoms, pack_string) - 22276usize];
                ["Offset of field: GkAtoms::page_string"]
                    [::std::mem::offset_of!(GkAtoms, page_string) - 22286usize];
                ["Offset of field: GkAtoms::pageincrement_string"]
                    [::std::mem::offset_of!(GkAtoms, pageincrement_string) - 22296usize];
                ["Offset of field: GkAtoms::paint_string"]
                    [::std::mem::offset_of!(GkAtoms, paint_string) - 22324usize];
                ["Offset of field: GkAtoms::paint_order_string"]
                    [::std::mem::offset_of!(GkAtoms, paint_order_string) - 22336usize];
                ["Offset of field: GkAtoms::panel_string"]
                    [::std::mem::offset_of!(GkAtoms, panel_string) - 22360usize];
                ["Offset of field: GkAtoms::paragraph_string"]
                    [::std::mem::offset_of!(GkAtoms, paragraph_string) - 22372usize];
                ["Offset of field: GkAtoms::param_string"]
                    [::std::mem::offset_of!(GkAtoms, param_string) - 22392usize];
                ["Offset of field: GkAtoms::parameter_string"]
                    [::std::mem::offset_of!(GkAtoms, parameter_string) - 22404usize];
                ["Offset of field: GkAtoms::parent_string"]
                    [::std::mem::offset_of!(GkAtoms, parent_string) - 22424usize];
                ["Offset of field: GkAtoms::parsererror_string"]
                    [::std::mem::offset_of!(GkAtoms, parsererror_string) - 22438usize];
                ["Offset of field: GkAtoms::part_string"]
                    [::std::mem::offset_of!(GkAtoms, part_string) - 22462usize];
                ["Offset of field: GkAtoms::password_string"]
                    [::std::mem::offset_of!(GkAtoms, password_string) - 22472usize];
                ["Offset of field: GkAtoms::pattern_string"]
                    [::std::mem::offset_of!(GkAtoms, pattern_string) - 22490usize];
                ["Offset of field: GkAtoms::patternSeparator_string"]
                    [::std::mem::offset_of!(GkAtoms, patternSeparator_string) - 22506usize];
                ["Offset of field: GkAtoms::perMille_string"]
                    [::std::mem::offset_of!(GkAtoms, perMille_string) - 22542usize];
                ["Offset of field: GkAtoms::percent_string"]
                    [::std::mem::offset_of!(GkAtoms, percent_string) - 22562usize];
                ["Offset of field: GkAtoms::persist_string"]
                    [::std::mem::offset_of!(GkAtoms, persist_string) - 22578usize];
                ["Offset of field: GkAtoms::phase_string"]
                    [::std::mem::offset_of!(GkAtoms, phase_string) - 22594usize];
                ["Offset of field: GkAtoms::picture_string"]
                    [::std::mem::offset_of!(GkAtoms, picture_string) - 22606usize];
                ["Offset of field: GkAtoms::ping_string"]
                    [::std::mem::offset_of!(GkAtoms, ping_string) - 22622usize];
                ["Offset of field: GkAtoms::pinned_string"]
                    [::std::mem::offset_of!(GkAtoms, pinned_string) - 22632usize];
                ["Offset of field: GkAtoms::placeholder_string"]
                    [::std::mem::offset_of!(GkAtoms, placeholder_string) - 22646usize];
                ["Offset of field: GkAtoms::plaintext_string"]
                    [::std::mem::offset_of!(GkAtoms, plaintext_string) - 22670usize];
                ["Offset of field: GkAtoms::plaintextOnly_string"]
                    [::std::mem::offset_of!(GkAtoms, plaintextOnly_string) - 22690usize];
                ["Offset of field: GkAtoms::playbackrate_string"]
                    [::std::mem::offset_of!(GkAtoms, playbackrate_string) - 22720usize];
                ["Offset of field: GkAtoms::pointSize_string"]
                    [::std::mem::offset_of!(GkAtoms, pointSize_string) - 22746usize];
                ["Offset of field: GkAtoms::poly_string"]
                    [::std::mem::offset_of!(GkAtoms, poly_string) - 22768usize];
                ["Offset of field: GkAtoms::polygon_string"]
                    [::std::mem::offset_of!(GkAtoms, polygon_string) - 22778usize];
                ["Offset of field: GkAtoms::popover_string"]
                    [::std::mem::offset_of!(GkAtoms, popover_string) - 22794usize];
                ["Offset of field: GkAtoms::popovertarget_string"]
                    [::std::mem::offset_of!(GkAtoms, popovertarget_string) - 22810usize];
                ["Offset of field: GkAtoms::popovertargetaction_string"]
                    [::std::mem::offset_of!(GkAtoms, popovertargetaction_string) - 22838usize];
                ["Offset of field: GkAtoms::popup_string"]
                    [::std::mem::offset_of!(GkAtoms, popup_string) - 22878usize];
                ["Offset of field: GkAtoms::popupalign_string"]
                    [::std::mem::offset_of!(GkAtoms, popupalign_string) - 22890usize];
                ["Offset of field: GkAtoms::popupanchor_string"]
                    [::std::mem::offset_of!(GkAtoms, popupanchor_string) - 22912usize];
                ["Offset of field: GkAtoms::popupgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, popupgroup_string) - 22936usize];
                ["Offset of field: GkAtoms::popupset_string"]
                    [::std::mem::offset_of!(GkAtoms, popupset_string) - 22958usize];
                ["Offset of field: GkAtoms::popupsinherittooltip_string"]
                    [::std::mem::offset_of!(GkAtoms, popupsinherittooltip_string) - 22976usize];
                ["Offset of field: GkAtoms::portal_string"]
                    [::std::mem::offset_of!(GkAtoms, portal_string) - 23018usize];
                ["Offset of field: GkAtoms::position_string"]
                    [::std::mem::offset_of!(GkAtoms, position_string) - 23032usize];
                ["Offset of field: GkAtoms::poster_string"]
                    [::std::mem::offset_of!(GkAtoms, poster_string) - 23050usize];
                ["Offset of field: GkAtoms::pre_string"]
                    [::std::mem::offset_of!(GkAtoms, pre_string) - 23064usize];
                ["Offset of field: GkAtoms::preceding_string"]
                    [::std::mem::offset_of!(GkAtoms, preceding_string) - 23072usize];
                ["Offset of field: GkAtoms::precedingSibling_string"]
                    [::std::mem::offset_of!(GkAtoms, precedingSibling_string) - 23092usize];
                ["Offset of field: GkAtoms::prefersReducedMotion_string"]
                    [::std::mem::offset_of!(GkAtoms, prefersReducedMotion_string) - 23128usize];
                ["Offset of field: GkAtoms::prefersReducedTransparency_string"][::std::mem::offset_of!(
                    GkAtoms,
                    prefersReducedTransparency_string
                ) - 23174usize];
                ["Offset of field: GkAtoms::prefersColorScheme_string"]
                    [::std::mem::offset_of!(GkAtoms, prefersColorScheme_string) - 23232usize];
                ["Offset of field: GkAtoms::prefersContrast_string"]
                    [::std::mem::offset_of!(GkAtoms, prefersContrast_string) - 23274usize];
                ["Offset of field: GkAtoms::prefix_string"]
                    [::std::mem::offset_of!(GkAtoms, prefix_string) - 23308usize];
                ["Offset of field: GkAtoms::prefwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, prefwidth_string) - 23322usize];
                ["Offset of field: GkAtoms::queue_string"]
                    [::std::mem::offset_of!(GkAtoms, queue_string) - 23342usize];
                ["Offset of field: GkAtoms::dynamicRange_string"]
                    [::std::mem::offset_of!(GkAtoms, dynamicRange_string) - 23354usize];
                ["Offset of field: GkAtoms::videoDynamicRange_string"]
                    [::std::mem::offset_of!(GkAtoms, videoDynamicRange_string) - 23382usize];
                ["Offset of field: GkAtoms::scripting_string"]
                    [::std::mem::offset_of!(GkAtoms, scripting_string) - 23422usize];
                ["Offset of field: GkAtoms::preload_string"]
                    [::std::mem::offset_of!(GkAtoms, preload_string) - 23442usize];
                ["Offset of field: GkAtoms::preserve_string"]
                    [::std::mem::offset_of!(GkAtoms, preserve_string) - 23458usize];
                ["Offset of field: GkAtoms::preserveSpace_string"]
                    [::std::mem::offset_of!(GkAtoms, preserveSpace_string) - 23476usize];
                ["Offset of field: GkAtoms::preventdefault_string"]
                    [::std::mem::offset_of!(GkAtoms, preventdefault_string) - 23506usize];
                ["Offset of field: GkAtoms::previewDiv_string"]
                    [::std::mem::offset_of!(GkAtoms, previewDiv_string) - 23536usize];
                ["Offset of field: GkAtoms::primary_string"]
                    [::std::mem::offset_of!(GkAtoms, primary_string) - 23560usize];
                ["Offset of field: GkAtoms::print_string"]
                    [::std::mem::offset_of!(GkAtoms, print_string) - 23576usize];
                ["Offset of field: GkAtoms::printisfocuseddoc_string"]
                    [::std::mem::offset_of!(GkAtoms, printisfocuseddoc_string) - 23588usize];
                ["Offset of field: GkAtoms::printselectionranges_string"]
                    [::std::mem::offset_of!(GkAtoms, printselectionranges_string) - 23624usize];
                ["Offset of field: GkAtoms::priority_string"]
                    [::std::mem::offset_of!(GkAtoms, priority_string) - 23666usize];
                ["Offset of field: GkAtoms::processingInstruction_string"]
                    [::std::mem::offset_of!(GkAtoms, processingInstruction_string) - 23684usize];
                ["Offset of field: GkAtoms::profile_string"]
                    [::std::mem::offset_of!(GkAtoms, profile_string) - 23730usize];
                ["Offset of field: GkAtoms::progress_string"]
                    [::std::mem::offset_of!(GkAtoms, progress_string) - 23746usize];
                ["Offset of field: GkAtoms::prompt_string"]
                    [::std::mem::offset_of!(GkAtoms, prompt_string) - 23764usize];
                ["Offset of field: GkAtoms::properties_string"]
                    [::std::mem::offset_of!(GkAtoms, properties_string) - 23778usize];
                ["Offset of field: GkAtoms::property_string"]
                    [::std::mem::offset_of!(GkAtoms, property_string) - 23800usize];
                ["Offset of field: GkAtoms::pubdate_string"]
                    [::std::mem::offset_of!(GkAtoms, pubdate_string) - 23818usize];
                ["Offset of field: GkAtoms::q_string"]
                    [::std::mem::offset_of!(GkAtoms, q_string) - 23834usize];
                ["Offset of field: GkAtoms::radio_string"]
                    [::std::mem::offset_of!(GkAtoms, radio_string) - 23838usize];
                ["Offset of field: GkAtoms::radioLabel_string"]
                    [::std::mem::offset_of!(GkAtoms, radioLabel_string) - 23850usize];
                ["Offset of field: GkAtoms::radiogroup_string"]
                    [::std::mem::offset_of!(GkAtoms, radiogroup_string) - 23874usize];
                ["Offset of field: GkAtoms::range_string"]
                    [::std::mem::offset_of!(GkAtoms, range_string) - 23896usize];
                ["Offset of field: GkAtoms::rating_string"]
                    [::std::mem::offset_of!(GkAtoms, rating_string) - 23908usize];
                ["Offset of field: GkAtoms::readonly_string"]
                    [::std::mem::offset_of!(GkAtoms, readonly_string) - 23922usize];
                ["Offset of field: GkAtoms::rect_string"]
                    [::std::mem::offset_of!(GkAtoms, rect_string) - 23940usize];
                ["Offset of field: GkAtoms::rectangle_string"]
                    [::std::mem::offset_of!(GkAtoms, rectangle_string) - 23950usize];
                ["Offset of field: GkAtoms::refresh_string"]
                    [::std::mem::offset_of!(GkAtoms, refresh_string) - 23970usize];
                ["Offset of field: GkAtoms::rel_string"]
                    [::std::mem::offset_of!(GkAtoms, rel_string) - 23986usize];
                ["Offset of field: GkAtoms::relativeBounds_string"]
                    [::std::mem::offset_of!(GkAtoms, relativeBounds_string) - 23994usize];
                ["Offset of field: GkAtoms::rem_string"]
                    [::std::mem::offset_of!(GkAtoms, rem_string) - 24026usize];
                ["Offset of field: GkAtoms::remote_string"]
                    [::std::mem::offset_of!(GkAtoms, remote_string) - 24034usize];
                ["Offset of field: GkAtoms::removeelement_string"]
                    [::std::mem::offset_of!(GkAtoms, removeelement_string) - 24048usize];
                ["Offset of field: GkAtoms::render_string"]
                    [::std::mem::offset_of!(GkAtoms, render_string) - 24076usize];
                ["Offset of field: GkAtoms::renderingobserverset_string"]
                    [::std::mem::offset_of!(GkAtoms, renderingobserverset_string) - 24090usize];
                ["Offset of field: GkAtoms::repeat_string"]
                    [::std::mem::offset_of!(GkAtoms, repeat_string) - 24132usize];
                ["Offset of field: GkAtoms::replace_string"]
                    [::std::mem::offset_of!(GkAtoms, replace_string) - 24146usize];
                ["Offset of field: GkAtoms::requestcontextid_string"]
                    [::std::mem::offset_of!(GkAtoms, requestcontextid_string) - 24162usize];
                ["Offset of field: GkAtoms::required_string"]
                    [::std::mem::offset_of!(GkAtoms, required_string) - 24196usize];
                ["Offset of field: GkAtoms::reserved_string"]
                    [::std::mem::offset_of!(GkAtoms, reserved_string) - 24214usize];
                ["Offset of field: GkAtoms::reset_string"]
                    [::std::mem::offset_of!(GkAtoms, reset_string) - 24232usize];
                ["Offset of field: GkAtoms::resizeafter_string"]
                    [::std::mem::offset_of!(GkAtoms, resizeafter_string) - 24244usize];
                ["Offset of field: GkAtoms::resizebefore_string"]
                    [::std::mem::offset_of!(GkAtoms, resizebefore_string) - 24268usize];
                ["Offset of field: GkAtoms::resizer_string"]
                    [::std::mem::offset_of!(GkAtoms, resizer_string) - 24294usize];
                ["Offset of field: GkAtoms::resolution_string"]
                    [::std::mem::offset_of!(GkAtoms, resolution_string) - 24310usize];
                ["Offset of field: GkAtoms::resources_string"]
                    [::std::mem::offset_of!(GkAtoms, resources_string) - 24332usize];
                ["Offset of field: GkAtoms::restrictToAdults_string"]
                    [::std::mem::offset_of!(GkAtoms, restrictToAdults_string) - 24352usize];
                ["Offset of field: GkAtoms::result_string"]
                    [::std::mem::offset_of!(GkAtoms, result_string) - 24408usize];
                ["Offset of field: GkAtoms::resultPrefix_string"]
                    [::std::mem::offset_of!(GkAtoms, resultPrefix_string) - 24422usize];
                ["Offset of field: GkAtoms::retargetdocumentfocus_string"]
                    [::std::mem::offset_of!(GkAtoms, retargetdocumentfocus_string) - 24450usize];
                ["Offset of field: GkAtoms::rev_string"]
                    [::std::mem::offset_of!(GkAtoms, rev_string) - 24494usize];
                ["Offset of field: GkAtoms::reverse_string"]
                    [::std::mem::offset_of!(GkAtoms, reverse_string) - 24502usize];
                ["Offset of field: GkAtoms::reversed_string"]
                    [::std::mem::offset_of!(GkAtoms, reversed_string) - 24518usize];
                ["Offset of field: GkAtoms::rhs_string"]
                    [::std::mem::offset_of!(GkAtoms, rhs_string) - 24536usize];
                ["Offset of field: GkAtoms::richlistbox_string"]
                    [::std::mem::offset_of!(GkAtoms, richlistbox_string) - 24544usize];
                ["Offset of field: GkAtoms::richlistitem_string"]
                    [::std::mem::offset_of!(GkAtoms, richlistitem_string) - 24568usize];
                ["Offset of field: GkAtoms::right_string"]
                    [::std::mem::offset_of!(GkAtoms, right_string) - 24594usize];
                ["Offset of field: GkAtoms::rightmargin_string"]
                    [::std::mem::offset_of!(GkAtoms, rightmargin_string) - 24606usize];
                ["Offset of field: GkAtoms::role_string"]
                    [::std::mem::offset_of!(GkAtoms, role_string) - 24630usize];
                ["Offset of field: GkAtoms::rolluponmousewheel_string"]
                    [::std::mem::offset_of!(GkAtoms, rolluponmousewheel_string) - 24640usize];
                ["Offset of field: GkAtoms::round_string"]
                    [::std::mem::offset_of!(GkAtoms, round_string) - 24678usize];
                ["Offset of field: GkAtoms::row_string"]
                    [::std::mem::offset_of!(GkAtoms, row_string) - 24690usize];
                ["Offset of field: GkAtoms::rows_string"]
                    [::std::mem::offset_of!(GkAtoms, rows_string) - 24698usize];
                ["Offset of field: GkAtoms::rowspan_string"]
                    [::std::mem::offset_of!(GkAtoms, rowspan_string) - 24708usize];
                ["Offset of field: GkAtoms::rb_string"]
                    [::std::mem::offset_of!(GkAtoms, rb_string) - 24724usize];
                ["Offset of field: GkAtoms::rp_string"]
                    [::std::mem::offset_of!(GkAtoms, rp_string) - 24730usize];
                ["Offset of field: GkAtoms::rt_string"]
                    [::std::mem::offset_of!(GkAtoms, rt_string) - 24736usize];
                ["Offset of field: GkAtoms::rtc_string"]
                    [::std::mem::offset_of!(GkAtoms, rtc_string) - 24742usize];
                ["Offset of field: GkAtoms::rtl_string"]
                    [::std::mem::offset_of!(GkAtoms, rtl_string) - 24750usize];
                ["Offset of field: GkAtoms::ruby_string"]
                    [::std::mem::offset_of!(GkAtoms, ruby_string) - 24758usize];
                ["Offset of field: GkAtoms::rubyBase_string"]
                    [::std::mem::offset_of!(GkAtoms, rubyBase_string) - 24768usize];
                ["Offset of field: GkAtoms::rubyBaseContainer_string"]
                    [::std::mem::offset_of!(GkAtoms, rubyBaseContainer_string) - 24788usize];
                ["Offset of field: GkAtoms::rubyText_string"]
                    [::std::mem::offset_of!(GkAtoms, rubyText_string) - 24828usize];
                ["Offset of field: GkAtoms::rubyTextContainer_string"]
                    [::std::mem::offset_of!(GkAtoms, rubyTextContainer_string) - 24848usize];
                ["Offset of field: GkAtoms::rules_string"]
                    [::std::mem::offset_of!(GkAtoms, rules_string) - 24888usize];
                ["Offset of field: GkAtoms::s_string"]
                    [::std::mem::offset_of!(GkAtoms, s_string) - 24900usize];
                ["Offset of field: GkAtoms::safe_area_inset_top_string"]
                    [::std::mem::offset_of!(GkAtoms, safe_area_inset_top_string) - 24904usize];
                ["Offset of field: GkAtoms::safe_area_inset_bottom_string"]
                    [::std::mem::offset_of!(GkAtoms, safe_area_inset_bottom_string) - 24944usize];
                ["Offset of field: GkAtoms::safe_area_inset_left_string"]
                    [::std::mem::offset_of!(GkAtoms, safe_area_inset_left_string) - 24990usize];
                ["Offset of field: GkAtoms::safe_area_inset_right_string"]
                    [::std::mem::offset_of!(GkAtoms, safe_area_inset_right_string) - 25032usize];
                ["Offset of field: GkAtoms::samp_string"]
                    [::std::mem::offset_of!(GkAtoms, samp_string) - 25076usize];
                ["Offset of field: GkAtoms::sandbox_string"]
                    [::std::mem::offset_of!(GkAtoms, sandbox_string) - 25086usize];
                ["Offset of field: GkAtoms::sbattr_string"]
                    [::std::mem::offset_of!(GkAtoms, sbattr_string) - 25102usize];
                ["Offset of field: GkAtoms::scale_string"]
                    [::std::mem::offset_of!(GkAtoms, scale_string) - 25116usize];
                ["Offset of field: GkAtoms::scan_string"]
                    [::std::mem::offset_of!(GkAtoms, scan_string) - 25128usize];
                ["Offset of field: GkAtoms::scheme_string"]
                    [::std::mem::offset_of!(GkAtoms, scheme_string) - 25138usize];
                ["Offset of field: GkAtoms::scope_string"]
                    [::std::mem::offset_of!(GkAtoms, scope_string) - 25152usize];
                ["Offset of field: GkAtoms::scoped_string"]
                    [::std::mem::offset_of!(GkAtoms, scoped_string) - 25164usize];
                ["Offset of field: GkAtoms::screen_string"]
                    [::std::mem::offset_of!(GkAtoms, screen_string) - 25178usize];
                ["Offset of field: GkAtoms::screenX_string"]
                    [::std::mem::offset_of!(GkAtoms, screenX_string) - 25192usize];
                ["Offset of field: GkAtoms::screenx_string"]
                    [::std::mem::offset_of!(GkAtoms, screenx_string) - 25208usize];
                ["Offset of field: GkAtoms::screenY_string"]
                    [::std::mem::offset_of!(GkAtoms, screenY_string) - 25224usize];
                ["Offset of field: GkAtoms::screeny_string"]
                    [::std::mem::offset_of!(GkAtoms, screeny_string) - 25240usize];
                ["Offset of field: GkAtoms::script_string"]
                    [::std::mem::offset_of!(GkAtoms, script_string) - 25256usize];
                ["Offset of field: GkAtoms::scrollbar_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbar_string) - 25270usize];
                ["Offset of field: GkAtoms::scrollbarThumb_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarThumb_string) - 25290usize];
                ["Offset of field: GkAtoms::scrollamount_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollamount_string) - 25322usize];
                ["Offset of field: GkAtoms::scrollbarbutton_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarbutton_string) - 25348usize];
                ["Offset of field: GkAtoms::scrollbarDownBottom_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarDownBottom_string) - 25380usize];
                ["Offset of field: GkAtoms::scrollbarDownTop_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarDownTop_string) - 25424usize];
                ["Offset of field: GkAtoms::scrollbarInlineSize_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarInlineSize_string) - 25462usize];
                ["Offset of field: GkAtoms::scrollbarUpBottom_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarUpBottom_string) - 25506usize];
                ["Offset of field: GkAtoms::scrollbarUpTop_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbarUpTop_string) - 25546usize];
                ["Offset of field: GkAtoms::scrollbox_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollbox_string) - 25580usize];
                ["Offset of field: GkAtoms::scrollcorner_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollcorner_string) - 25600usize];
                ["Offset of field: GkAtoms::scrolldelay_string"]
                    [::std::mem::offset_of!(GkAtoms, scrolldelay_string) - 25626usize];
                ["Offset of field: GkAtoms::scrolling_string"]
                    [::std::mem::offset_of!(GkAtoms, scrolling_string) - 25650usize];
                ["Offset of field: GkAtoms::scrollPosition_string"]
                    [::std::mem::offset_of!(GkAtoms, scrollPosition_string) - 25670usize];
                ["Offset of field: GkAtoms::se_string"]
                    [::std::mem::offset_of!(GkAtoms, se_string) - 25702usize];
                ["Offset of field: GkAtoms::section_string"]
                    [::std::mem::offset_of!(GkAtoms, section_string) - 25708usize];
                ["Offset of field: GkAtoms::select_string"]
                    [::std::mem::offset_of!(GkAtoms, select_string) - 25724usize];
                ["Offset of field: GkAtoms::selected_string"]
                    [::std::mem::offset_of!(GkAtoms, selected_string) - 25738usize];
                ["Offset of field: GkAtoms::selectedIndex_string"]
                    [::std::mem::offset_of!(GkAtoms, selectedIndex_string) - 25756usize];
                ["Offset of field: GkAtoms::selectedindex_string"]
                    [::std::mem::offset_of!(GkAtoms, selectedindex_string) - 25784usize];
                ["Offset of field: GkAtoms::selectmenu_string"]
                    [::std::mem::offset_of!(GkAtoms, selectmenu_string) - 25812usize];
                ["Offset of field: GkAtoms::self_string"]
                    [::std::mem::offset_of!(GkAtoms, self_string) - 25834usize];
                ["Offset of field: GkAtoms::seltype_string"]
                    [::std::mem::offset_of!(GkAtoms, seltype_string) - 25844usize];
                ["Offset of field: GkAtoms::setcookie_string"]
                    [::std::mem::offset_of!(GkAtoms, setcookie_string) - 25860usize];
                ["Offset of field: GkAtoms::setter_string"]
                    [::std::mem::offset_of!(GkAtoms, setter_string) - 25882usize];
                ["Offset of field: GkAtoms::shadow_string"]
                    [::std::mem::offset_of!(GkAtoms, shadow_string) - 25896usize];
                ["Offset of field: GkAtoms::shadowrootreferencetarget_string"][::std::mem::offset_of!(
                    GkAtoms,
                    shadowrootreferencetarget_string
                ) - 25910usize];
                ["Offset of field: GkAtoms::shape_string"]
                    [::std::mem::offset_of!(GkAtoms, shape_string) - 25962usize];
                ["Offset of field: GkAtoms::show_string"]
                    [::std::mem::offset_of!(GkAtoms, show_string) - 25974usize];
                ["Offset of field: GkAtoms::showcaret_string"]
                    [::std::mem::offset_of!(GkAtoms, showcaret_string) - 25984usize];
                ["Offset of field: GkAtoms::show_modal_string"]
                    [::std::mem::offset_of!(GkAtoms, show_modal_string) - 26004usize];
                ["Offset of field: GkAtoms::show_popover_string"]
                    [::std::mem::offset_of!(GkAtoms, show_popover_string) - 26026usize];
                ["Offset of field: GkAtoms::showservicesmenu_string"]
                    [::std::mem::offset_of!(GkAtoms, showservicesmenu_string) - 26052usize];
                ["Offset of field: GkAtoms::sibling_string"]
                    [::std::mem::offset_of!(GkAtoms, sibling_string) - 26086usize];
                ["Offset of field: GkAtoms::simple_string"]
                    [::std::mem::offset_of!(GkAtoms, simple_string) - 26102usize];
                ["Offset of field: GkAtoms::simp_chinese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, simp_chinese_formal_string) - 26116usize];
                ["Offset of field: GkAtoms::simp_chinese_informal_string"]
                    [::std::mem::offset_of!(GkAtoms, simp_chinese_informal_string) - 26156usize];
                ["Offset of field: GkAtoms::single_string"]
                    [::std::mem::offset_of!(GkAtoms, single_string) - 26200usize];
                ["Offset of field: GkAtoms::size_string"]
                    [::std::mem::offset_of!(GkAtoms, size_string) - 26214usize];
                ["Offset of field: GkAtoms::sizes_string"]
                    [::std::mem::offset_of!(GkAtoms, sizes_string) - 26224usize];
                ["Offset of field: GkAtoms::sizemode_string"]
                    [::std::mem::offset_of!(GkAtoms, sizemode_string) - 26236usize];
                ["Offset of field: GkAtoms::sizetopopup_string"]
                    [::std::mem::offset_of!(GkAtoms, sizetopopup_string) - 26254usize];
                ["Offset of field: GkAtoms::slider_string"]
                    [::std::mem::offset_of!(GkAtoms, slider_string) - 26278usize];
                ["Offset of field: GkAtoms::small_string"]
                    [::std::mem::offset_of!(GkAtoms, small_string) - 26292usize];
                ["Offset of field: GkAtoms::smooth_string"]
                    [::std::mem::offset_of!(GkAtoms, smooth_string) - 26304usize];
                ["Offset of field: GkAtoms::snap_string"]
                    [::std::mem::offset_of!(GkAtoms, snap_string) - 26318usize];
                ["Offset of field: GkAtoms::solid_string"]
                    [::std::mem::offset_of!(GkAtoms, solid_string) - 26328usize];
                ["Offset of field: GkAtoms::sort_string"]
                    [::std::mem::offset_of!(GkAtoms, sort_string) - 26340usize];
                ["Offset of field: GkAtoms::sortActive_string"]
                    [::std::mem::offset_of!(GkAtoms, sortActive_string) - 26350usize];
                ["Offset of field: GkAtoms::sortDirection_string"]
                    [::std::mem::offset_of!(GkAtoms, sortDirection_string) - 26372usize];
                ["Offset of field: GkAtoms::sorted_string"]
                    [::std::mem::offset_of!(GkAtoms, sorted_string) - 26400usize];
                ["Offset of field: GkAtoms::sorthints_string"]
                    [::std::mem::offset_of!(GkAtoms, sorthints_string) - 26414usize];
                ["Offset of field: GkAtoms::source_string"]
                    [::std::mem::offset_of!(GkAtoms, source_string) - 26434usize];
                ["Offset of field: GkAtoms::sourcetext_string"]
                    [::std::mem::offset_of!(GkAtoms, sourcetext_string) - 26448usize];
                ["Offset of field: GkAtoms::space_string"]
                    [::std::mem::offset_of!(GkAtoms, space_string) - 26470usize];
                ["Offset of field: GkAtoms::spacer_string"]
                    [::std::mem::offset_of!(GkAtoms, spacer_string) - 26482usize];
                ["Offset of field: GkAtoms::span_string"]
                    [::std::mem::offset_of!(GkAtoms, span_string) - 26496usize];
                ["Offset of field: GkAtoms::spellcheck_string"]
                    [::std::mem::offset_of!(GkAtoms, spellcheck_string) - 26506usize];
                ["Offset of field: GkAtoms::split_string"]
                    [::std::mem::offset_of!(GkAtoms, split_string) - 26528usize];
                ["Offset of field: GkAtoms::splitter_string"]
                    [::std::mem::offset_of!(GkAtoms, splitter_string) - 26540usize];
                ["Offset of field: GkAtoms::square_string"]
                    [::std::mem::offset_of!(GkAtoms, square_string) - 26558usize];
                ["Offset of field: GkAtoms::src_string"]
                    [::std::mem::offset_of!(GkAtoms, src_string) - 26572usize];
                ["Offset of field: GkAtoms::srcdoc_string"]
                    [::std::mem::offset_of!(GkAtoms, srcdoc_string) - 26580usize];
                ["Offset of field: GkAtoms::srclang_string"]
                    [::std::mem::offset_of!(GkAtoms, srclang_string) - 26594usize];
                ["Offset of field: GkAtoms::srcset_string"]
                    [::std::mem::offset_of!(GkAtoms, srcset_string) - 26610usize];
                ["Offset of field: GkAtoms::standalone_string"]
                    [::std::mem::offset_of!(GkAtoms, standalone_string) - 26624usize];
                ["Offset of field: GkAtoms::standby_string"]
                    [::std::mem::offset_of!(GkAtoms, standby_string) - 26646usize];
                ["Offset of field: GkAtoms::start_string"]
                    [::std::mem::offset_of!(GkAtoms, start_string) - 26662usize];
                ["Offset of field: GkAtoms::startsWith_string"]
                    [::std::mem::offset_of!(GkAtoms, startsWith_string) - 26674usize];
                ["Offset of field: GkAtoms::state_string"]
                    [::std::mem::offset_of!(GkAtoms, state_string) - 26698usize];
                ["Offset of field: GkAtoms::statusbar_string"]
                    [::std::mem::offset_of!(GkAtoms, statusbar_string) - 26710usize];
                ["Offset of field: GkAtoms::step_string"]
                    [::std::mem::offset_of!(GkAtoms, step_string) - 26730usize];
                ["Offset of field: GkAtoms::stop_string"]
                    [::std::mem::offset_of!(GkAtoms, stop_string) - 26740usize];
                ["Offset of field: GkAtoms::stretch_string"]
                    [::std::mem::offset_of!(GkAtoms, stretch_string) - 26750usize];
                ["Offset of field: GkAtoms::strike_string"]
                    [::std::mem::offset_of!(GkAtoms, strike_string) - 26766usize];
                ["Offset of field: GkAtoms::string_string"]
                    [::std::mem::offset_of!(GkAtoms, string_string) - 26780usize];
                ["Offset of field: GkAtoms::stringLength_string"]
                    [::std::mem::offset_of!(GkAtoms, stringLength_string) - 26794usize];
                ["Offset of field: GkAtoms::stripSpace_string"]
                    [::std::mem::offset_of!(GkAtoms, stripSpace_string) - 26822usize];
                ["Offset of field: GkAtoms::strong_string"]
                    [::std::mem::offset_of!(GkAtoms, strong_string) - 26846usize];
                ["Offset of field: GkAtoms::style_string"]
                    [::std::mem::offset_of!(GkAtoms, style_string) - 26860usize];
                ["Offset of field: GkAtoms::stylesheet_string"]
                    [::std::mem::offset_of!(GkAtoms, stylesheet_string) - 26872usize];
                ["Offset of field: GkAtoms::stylesheetPrefix_string"]
                    [::std::mem::offset_of!(GkAtoms, stylesheetPrefix_string) - 26894usize];
                ["Offset of field: GkAtoms::submit_string"]
                    [::std::mem::offset_of!(GkAtoms, submit_string) - 26930usize];
                ["Offset of field: GkAtoms::substate_string"]
                    [::std::mem::offset_of!(GkAtoms, substate_string) - 26944usize];
                ["Offset of field: GkAtoms::substring_string"]
                    [::std::mem::offset_of!(GkAtoms, substring_string) - 26962usize];
                ["Offset of field: GkAtoms::substringAfter_string"]
                    [::std::mem::offset_of!(GkAtoms, substringAfter_string) - 26982usize];
                ["Offset of field: GkAtoms::substringBefore_string"]
                    [::std::mem::offset_of!(GkAtoms, substringBefore_string) - 27014usize];
                ["Offset of field: GkAtoms::sub_string"]
                    [::std::mem::offset_of!(GkAtoms, sub_string) - 27048usize];
                ["Offset of field: GkAtoms::suggestion_string"]
                    [::std::mem::offset_of!(GkAtoms, suggestion_string) - 27056usize];
                ["Offset of field: GkAtoms::sum_string"]
                    [::std::mem::offset_of!(GkAtoms, sum_string) - 27078usize];
                ["Offset of field: GkAtoms::sup_string"]
                    [::std::mem::offset_of!(GkAtoms, sup_string) - 27086usize];
                ["Offset of field: GkAtoms::summary_string"]
                    [::std::mem::offset_of!(GkAtoms, summary_string) - 27094usize];
                ["Offset of field: GkAtoms::sw_string"]
                    [::std::mem::offset_of!(GkAtoms, sw_string) - 27110usize];
                ["Offset of field: GkAtoms::systemProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, systemProperty_string) - 27116usize];
                ["Offset of field: GkAtoms::tab_string"]
                    [::std::mem::offset_of!(GkAtoms, tab_string) - 27148usize];
                ["Offset of field: GkAtoms::tabindex_string"]
                    [::std::mem::offset_of!(GkAtoms, tabindex_string) - 27156usize];
                ["Offset of field: GkAtoms::table_string"]
                    [::std::mem::offset_of!(GkAtoms, table_string) - 27174usize];
                ["Offset of field: GkAtoms::tabpanel_string"]
                    [::std::mem::offset_of!(GkAtoms, tabpanel_string) - 27186usize];
                ["Offset of field: GkAtoms::tabpanels_string"]
                    [::std::mem::offset_of!(GkAtoms, tabpanels_string) - 27204usize];
                ["Offset of field: GkAtoms::tag_string"]
                    [::std::mem::offset_of!(GkAtoms, tag_string) - 27224usize];
                ["Offset of field: GkAtoms::target_string"]
                    [::std::mem::offset_of!(GkAtoms, target_string) - 27232usize];
                ["Offset of field: GkAtoms::targets_string"]
                    [::std::mem::offset_of!(GkAtoms, targets_string) - 27246usize];
                ["Offset of field: GkAtoms::tbody_string"]
                    [::std::mem::offset_of!(GkAtoms, tbody_string) - 27262usize];
                ["Offset of field: GkAtoms::td_string"]
                    [::std::mem::offset_of!(GkAtoms, td_string) - 27274usize];
                ["Offset of field: GkAtoms::tel_string"]
                    [::std::mem::offset_of!(GkAtoms, tel_string) - 27280usize];
                ["Offset of field: GkAtoms::_template_string"]
                    [::std::mem::offset_of!(GkAtoms, _template_string) - 27288usize];
                ["Offset of field: GkAtoms::text_decoration_string"]
                    [::std::mem::offset_of!(GkAtoms, text_decoration_string) - 27306usize];
                ["Offset of field: GkAtoms::terminate_string"]
                    [::std::mem::offset_of!(GkAtoms, terminate_string) - 27338usize];
                ["Offset of field: GkAtoms::term_string"]
                    [::std::mem::offset_of!(GkAtoms, term_string) - 27358usize];
                ["Offset of field: GkAtoms::test_string"]
                    [::std::mem::offset_of!(GkAtoms, test_string) - 27368usize];
                ["Offset of field: GkAtoms::text_string"]
                    [::std::mem::offset_of!(GkAtoms, text_string) - 27378usize];
                ["Offset of field: GkAtoms::textAlign_string"]
                    [::std::mem::offset_of!(GkAtoms, textAlign_string) - 27388usize];
                ["Offset of field: GkAtoms::textarea_string"]
                    [::std::mem::offset_of!(GkAtoms, textarea_string) - 27410usize];
                ["Offset of field: GkAtoms::textbox_string"]
                    [::std::mem::offset_of!(GkAtoms, textbox_string) - 27428usize];
                ["Offset of field: GkAtoms::textContent_string"]
                    [::std::mem::offset_of!(GkAtoms, textContent_string) - 27444usize];
                ["Offset of field: GkAtoms::textLink_string"]
                    [::std::mem::offset_of!(GkAtoms, textLink_string) - 27468usize];
                ["Offset of field: GkAtoms::textOverlay_string"]
                    [::std::mem::offset_of!(GkAtoms, textOverlay_string) - 27488usize];
                ["Offset of field: GkAtoms::tfoot_string"]
                    [::std::mem::offset_of!(GkAtoms, tfoot_string) - 27514usize];
                ["Offset of field: GkAtoms::th_string"]
                    [::std::mem::offset_of!(GkAtoms, th_string) - 27526usize];
                ["Offset of field: GkAtoms::thead_string"]
                    [::std::mem::offset_of!(GkAtoms, thead_string) - 27532usize];
                ["Offset of field: GkAtoms::thumb_string"]
                    [::std::mem::offset_of!(GkAtoms, thumb_string) - 27544usize];
                ["Offset of field: GkAtoms::time_string"]
                    [::std::mem::offset_of!(GkAtoms, time_string) - 27556usize];
                ["Offset of field: GkAtoms::title_string"]
                    [::std::mem::offset_of!(GkAtoms, title_string) - 27566usize];
                ["Offset of field: GkAtoms::titletip_string"]
                    [::std::mem::offset_of!(GkAtoms, titletip_string) - 27578usize];
                ["Offset of field: GkAtoms::toggle_string"]
                    [::std::mem::offset_of!(GkAtoms, toggle_string) - 27596usize];
                ["Offset of field: GkAtoms::toggle_popover_string"]
                    [::std::mem::offset_of!(GkAtoms, toggle_popover_string) - 27610usize];
                ["Offset of field: GkAtoms::token_string"]
                    [::std::mem::offset_of!(GkAtoms, token_string) - 27640usize];
                ["Offset of field: GkAtoms::tokenize_string"]
                    [::std::mem::offset_of!(GkAtoms, tokenize_string) - 27652usize];
                ["Offset of field: GkAtoms::toolbar_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbar_string) - 27670usize];
                ["Offset of field: GkAtoms::toolbarbutton_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarbutton_string) - 27686usize];
                ["Offset of field: GkAtoms::toolbaritem_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbaritem_string) - 27714usize];
                ["Offset of field: GkAtoms::toolbarpaletteitem_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarpaletteitem_string) - 27738usize];
                ["Offset of field: GkAtoms::toolbox_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbox_string) - 27776usize];
                ["Offset of field: GkAtoms::tooltip_string"]
                    [::std::mem::offset_of!(GkAtoms, tooltip_string) - 27792usize];
                ["Offset of field: GkAtoms::tooltiptext_string"]
                    [::std::mem::offset_of!(GkAtoms, tooltiptext_string) - 27808usize];
                ["Offset of field: GkAtoms::top_string"]
                    [::std::mem::offset_of!(GkAtoms, top_string) - 27832usize];
                ["Offset of field: GkAtoms::topleft_string"]
                    [::std::mem::offset_of!(GkAtoms, topleft_string) - 27840usize];
                ["Offset of field: GkAtoms::topmargin_string"]
                    [::std::mem::offset_of!(GkAtoms, topmargin_string) - 27856usize];
                ["Offset of field: GkAtoms::topright_string"]
                    [::std::mem::offset_of!(GkAtoms, topright_string) - 27876usize];
                ["Offset of field: GkAtoms::tr_string"]
                    [::std::mem::offset_of!(GkAtoms, tr_string) - 27894usize];
                ["Offset of field: GkAtoms::track_string"]
                    [::std::mem::offset_of!(GkAtoms, track_string) - 27900usize];
                ["Offset of field: GkAtoms::trad_chinese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, trad_chinese_formal_string) - 27912usize];
                ["Offset of field: GkAtoms::trad_chinese_informal_string"]
                    [::std::mem::offset_of!(GkAtoms, trad_chinese_informal_string) - 27952usize];
                ["Offset of field: GkAtoms::trailing_string"]
                    [::std::mem::offset_of!(GkAtoms, trailing_string) - 27996usize];
                ["Offset of field: GkAtoms::transform_string"]
                    [::std::mem::offset_of!(GkAtoms, transform_string) - 28014usize];
                ["Offset of field: GkAtoms::transform_3d_string"]
                    [::std::mem::offset_of!(GkAtoms, transform_3d_string) - 28034usize];
                ["Offset of field: GkAtoms::transformiix_string"]
                    [::std::mem::offset_of!(GkAtoms, transformiix_string) - 28060usize];
                ["Offset of field: GkAtoms::translate_string"]
                    [::std::mem::offset_of!(GkAtoms, translate_string) - 28086usize];
                ["Offset of field: GkAtoms::transparent_string"]
                    [::std::mem::offset_of!(GkAtoms, transparent_string) - 28106usize];
                ["Offset of field: GkAtoms::tree_string"]
                    [::std::mem::offset_of!(GkAtoms, tree_string) - 28130usize];
                ["Offset of field: GkAtoms::treecell_string"]
                    [::std::mem::offset_of!(GkAtoms, treecell_string) - 28140usize];
                ["Offset of field: GkAtoms::treechildren_string"]
                    [::std::mem::offset_of!(GkAtoms, treechildren_string) - 28158usize];
                ["Offset of field: GkAtoms::treecol_string"]
                    [::std::mem::offset_of!(GkAtoms, treecol_string) - 28184usize];
                ["Offset of field: GkAtoms::treecolpicker_string"]
                    [::std::mem::offset_of!(GkAtoms, treecolpicker_string) - 28200usize];
                ["Offset of field: GkAtoms::treecols_string"]
                    [::std::mem::offset_of!(GkAtoms, treecols_string) - 28228usize];
                ["Offset of field: GkAtoms::treeitem_string"]
                    [::std::mem::offset_of!(GkAtoms, treeitem_string) - 28246usize];
                ["Offset of field: GkAtoms::treerow_string"]
                    [::std::mem::offset_of!(GkAtoms, treerow_string) - 28264usize];
                ["Offset of field: GkAtoms::treeseparator_string"]
                    [::std::mem::offset_of!(GkAtoms, treeseparator_string) - 28280usize];
                ["Offset of field: GkAtoms::_true_string"]
                    [::std::mem::offset_of!(GkAtoms, _true_string) - 28308usize];
                ["Offset of field: GkAtoms::truespeed_string"]
                    [::std::mem::offset_of!(GkAtoms, truespeed_string) - 28318usize];
                ["Offset of field: GkAtoms::tt_string"]
                    [::std::mem::offset_of!(GkAtoms, tt_string) - 28338usize];
                ["Offset of field: GkAtoms::type_string"]
                    [::std::mem::offset_of!(GkAtoms, type_string) - 28344usize];
                ["Offset of field: GkAtoms::u_string"]
                    [::std::mem::offset_of!(GkAtoms, u_string) - 28354usize];
                ["Offset of field: GkAtoms::ul_string"]
                    [::std::mem::offset_of!(GkAtoms, ul_string) - 28358usize];
                ["Offset of field: GkAtoms::unparsedEntityUri_string"]
                    [::std::mem::offset_of!(GkAtoms, unparsedEntityUri_string) - 28364usize];
                ["Offset of field: GkAtoms::untilFound_string"]
                    [::std::mem::offset_of!(GkAtoms, untilFound_string) - 28404usize];
                ["Offset of field: GkAtoms::up_string"]
                    [::std::mem::offset_of!(GkAtoms, up_string) - 28428usize];
                ["Offset of field: GkAtoms::update_string"]
                    [::std::mem::offset_of!(GkAtoms, update_string) - 28434usize];
                ["Offset of field: GkAtoms::upperFirst_string"]
                    [::std::mem::offset_of!(GkAtoms, upperFirst_string) - 28448usize];
                ["Offset of field: GkAtoms::use_string"]
                    [::std::mem::offset_of!(GkAtoms, use_string) - 28472usize];
                ["Offset of field: GkAtoms::useAttributeSets_string"]
                    [::std::mem::offset_of!(GkAtoms, useAttributeSets_string) - 28480usize];
                ["Offset of field: GkAtoms::usemap_string"]
                    [::std::mem::offset_of!(GkAtoms, usemap_string) - 28518usize];
                ["Offset of field: GkAtoms::user_scalable_string"]
                    [::std::mem::offset_of!(GkAtoms, user_scalable_string) - 28532usize];
                ["Offset of field: GkAtoms::validate_string"]
                    [::std::mem::offset_of!(GkAtoms, validate_string) - 28560usize];
                ["Offset of field: GkAtoms::valign_string"]
                    [::std::mem::offset_of!(GkAtoms, valign_string) - 28578usize];
                ["Offset of field: GkAtoms::value_string"]
                    [::std::mem::offset_of!(GkAtoms, value_string) - 28592usize];
                ["Offset of field: GkAtoms::values_string"]
                    [::std::mem::offset_of!(GkAtoms, values_string) - 28604usize];
                ["Offset of field: GkAtoms::valueOf_string"]
                    [::std::mem::offset_of!(GkAtoms, valueOf_string) - 28618usize];
                ["Offset of field: GkAtoms::valuetype_string"]
                    [::std::mem::offset_of!(GkAtoms, valuetype_string) - 28636usize];
                ["Offset of field: GkAtoms::var_string"]
                    [::std::mem::offset_of!(GkAtoms, var_string) - 28656usize];
                ["Offset of field: GkAtoms::variable_string"]
                    [::std::mem::offset_of!(GkAtoms, variable_string) - 28664usize];
                ["Offset of field: GkAtoms::vendor_string"]
                    [::std::mem::offset_of!(GkAtoms, vendor_string) - 28682usize];
                ["Offset of field: GkAtoms::vendorUrl_string"]
                    [::std::mem::offset_of!(GkAtoms, vendorUrl_string) - 28696usize];
                ["Offset of field: GkAtoms::version_string"]
                    [::std::mem::offset_of!(GkAtoms, version_string) - 28718usize];
                ["Offset of field: GkAtoms::vertical_string"]
                    [::std::mem::offset_of!(GkAtoms, vertical_string) - 28734usize];
                ["Offset of field: GkAtoms::audio_string"]
                    [::std::mem::offset_of!(GkAtoms, audio_string) - 28752usize];
                ["Offset of field: GkAtoms::video_string"]
                    [::std::mem::offset_of!(GkAtoms, video_string) - 28764usize];
                ["Offset of field: GkAtoms::viewport_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_string) - 28776usize];
                ["Offset of field: GkAtoms::viewport_fit_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_fit_string) - 28794usize];
                ["Offset of field: GkAtoms::viewport_height_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_height_string) - 28820usize];
                ["Offset of field: GkAtoms::viewport_initial_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_initial_scale_string) - 28852usize];
                ["Offset of field: GkAtoms::viewport_maximum_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_maximum_scale_string) - 28898usize];
                ["Offset of field: GkAtoms::viewport_minimum_scale_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_minimum_scale_string) - 28944usize];
                ["Offset of field: GkAtoms::viewport_user_scalable_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_user_scalable_string) - 28990usize];
                ["Offset of field: GkAtoms::viewport_width_string"]
                    [::std::mem::offset_of!(GkAtoms, viewport_width_string) - 29036usize];
                ["Offset of field: GkAtoms::visibility_string"]
                    [::std::mem::offset_of!(GkAtoms, visibility_string) - 29066usize];
                ["Offset of field: GkAtoms::visuallyselected_string"]
                    [::std::mem::offset_of!(GkAtoms, visuallyselected_string) - 29088usize];
                ["Offset of field: GkAtoms::vlink_string"]
                    [::std::mem::offset_of!(GkAtoms, vlink_string) - 29122usize];
                ["Offset of field: GkAtoms::_void_string"]
                    [::std::mem::offset_of!(GkAtoms, _void_string) - 29134usize];
                ["Offset of field: GkAtoms::vsides_string"]
                    [::std::mem::offset_of!(GkAtoms, vsides_string) - 29144usize];
                ["Offset of field: GkAtoms::vspace_string"]
                    [::std::mem::offset_of!(GkAtoms, vspace_string) - 29158usize];
                ["Offset of field: GkAtoms::w_string"]
                    [::std::mem::offset_of!(GkAtoms, w_string) - 29172usize];
                ["Offset of field: GkAtoms::wbr_string"]
                    [::std::mem::offset_of!(GkAtoms, wbr_string) - 29176usize];
                ["Offset of field: GkAtoms::webkitdirectory_string"]
                    [::std::mem::offset_of!(GkAtoms, webkitdirectory_string) - 29184usize];
                ["Offset of field: GkAtoms::when_string"]
                    [::std::mem::offset_of!(GkAtoms, when_string) - 29216usize];
                ["Offset of field: GkAtoms::white_string"]
                    [::std::mem::offset_of!(GkAtoms, white_string) - 29226usize];
                ["Offset of field: GkAtoms::width_string"]
                    [::std::mem::offset_of!(GkAtoms, width_string) - 29238usize];
                ["Offset of field: GkAtoms::willChange_string"]
                    [::std::mem::offset_of!(GkAtoms, willChange_string) - 29250usize];
                ["Offset of field: GkAtoms::window_string"]
                    [::std::mem::offset_of!(GkAtoms, window_string) - 29274usize];
                ["Offset of field: GkAtoms::headerWindowTarget_string"]
                    [::std::mem::offset_of!(GkAtoms, headerWindowTarget_string) - 29288usize];
                ["Offset of field: GkAtoms::windowtype_string"]
                    [::std::mem::offset_of!(GkAtoms, windowtype_string) - 29316usize];
                ["Offset of field: GkAtoms::withParam_string"]
                    [::std::mem::offset_of!(GkAtoms, withParam_string) - 29338usize];
                ["Offset of field: GkAtoms::wrap_string"]
                    [::std::mem::offset_of!(GkAtoms, wrap_string) - 29360usize];
                ["Offset of field: GkAtoms::headerDNSPrefetchControl_string"]
                    [::std::mem::offset_of!(GkAtoms, headerDNSPrefetchControl_string) - 29370usize];
                ["Offset of field: GkAtoms::headerCSP_string"]
                    [::std::mem::offset_of!(GkAtoms, headerCSP_string) - 29416usize];
                ["Offset of field: GkAtoms::headerCSPReportOnly_string"]
                    [::std::mem::offset_of!(GkAtoms, headerCSPReportOnly_string) - 29464usize];
                ["Offset of field: GkAtoms::headerXFO_string"]
                    [::std::mem::offset_of!(GkAtoms, headerXFO_string) - 29536usize];
                ["Offset of field: GkAtoms::x_western_string"]
                    [::std::mem::offset_of!(GkAtoms, x_western_string) - 29568usize];
                ["Offset of field: GkAtoms::xml_string"]
                    [::std::mem::offset_of!(GkAtoms, xml_string) - 29588usize];
                ["Offset of field: GkAtoms::xml_stylesheet_string"]
                    [::std::mem::offset_of!(GkAtoms, xml_stylesheet_string) - 29596usize];
                ["Offset of field: GkAtoms::xmlns_string"]
                    [::std::mem::offset_of!(GkAtoms, xmlns_string) - 29626usize];
                ["Offset of field: GkAtoms::xmp_string"]
                    [::std::mem::offset_of!(GkAtoms, xmp_string) - 29638usize];
                ["Offset of field: GkAtoms::xul_string"]
                    [::std::mem::offset_of!(GkAtoms, xul_string) - 29646usize];
                ["Offset of field: GkAtoms::yes_string"]
                    [::std::mem::offset_of!(GkAtoms, yes_string) - 29654usize];
                ["Offset of field: GkAtoms::z_index_string"]
                    [::std::mem::offset_of!(GkAtoms, z_index_string) - 29662usize];
                ["Offset of field: GkAtoms::zeroDigit_string"]
                    [::std::mem::offset_of!(GkAtoms, zeroDigit_string) - 29678usize];
                ["Offset of field: GkAtoms::zlevel_string"]
                    [::std::mem::offset_of!(GkAtoms, zlevel_string) - 29700usize];
                ["Offset of field: GkAtoms::percentage_string"]
                    [::std::mem::offset_of!(GkAtoms, percentage_string) - 29714usize];
                ["Offset of field: GkAtoms::A_string"]
                    [::std::mem::offset_of!(GkAtoms, A_string) - 29718usize];
                ["Offset of field: GkAtoms::alignment_baseline_string"]
                    [::std::mem::offset_of!(GkAtoms, alignment_baseline_string) - 29722usize];
                ["Offset of field: GkAtoms::amplitude_string"]
                    [::std::mem::offset_of!(GkAtoms, amplitude_string) - 29760usize];
                ["Offset of field: GkAtoms::animate_string"]
                    [::std::mem::offset_of!(GkAtoms, animate_string) - 29780usize];
                ["Offset of field: GkAtoms::animateColor_string"]
                    [::std::mem::offset_of!(GkAtoms, animateColor_string) - 29796usize];
                ["Offset of field: GkAtoms::animateMotion_string"]
                    [::std::mem::offset_of!(GkAtoms, animateMotion_string) - 29822usize];
                ["Offset of field: GkAtoms::animateTransform_string"]
                    [::std::mem::offset_of!(GkAtoms, animateTransform_string) - 29850usize];
                ["Offset of field: GkAtoms::arithmetic_string"]
                    [::std::mem::offset_of!(GkAtoms, arithmetic_string) - 29884usize];
                ["Offset of field: GkAtoms::atop_string"]
                    [::std::mem::offset_of!(GkAtoms, atop_string) - 29906usize];
                ["Offset of field: GkAtoms::azimuth_string"]
                    [::std::mem::offset_of!(GkAtoms, azimuth_string) - 29916usize];
                ["Offset of field: GkAtoms::B_string"]
                    [::std::mem::offset_of!(GkAtoms, B_string) - 29932usize];
                ["Offset of field: GkAtoms::background_color_string"]
                    [::std::mem::offset_of!(GkAtoms, background_color_string) - 29936usize];
                ["Offset of field: GkAtoms::background_image_string"]
                    [::std::mem::offset_of!(GkAtoms, background_image_string) - 29970usize];
                ["Offset of field: GkAtoms::baseFrequency_string"]
                    [::std::mem::offset_of!(GkAtoms, baseFrequency_string) - 30004usize];
                ["Offset of field: GkAtoms::baseline_shift_string"]
                    [::std::mem::offset_of!(GkAtoms, baseline_shift_string) - 30032usize];
                ["Offset of field: GkAtoms::bias_string"]
                    [::std::mem::offset_of!(GkAtoms, bias_string) - 30062usize];
                ["Offset of field: GkAtoms::caption_side_string"]
                    [::std::mem::offset_of!(GkAtoms, caption_side_string) - 30072usize];
                ["Offset of field: GkAtoms::clip_path_string"]
                    [::std::mem::offset_of!(GkAtoms, clip_path_string) - 30098usize];
                ["Offset of field: GkAtoms::clip_rule_string"]
                    [::std::mem::offset_of!(GkAtoms, clip_rule_string) - 30118usize];
                ["Offset of field: GkAtoms::clipPath_string"]
                    [::std::mem::offset_of!(GkAtoms, clipPath_string) - 30138usize];
                ["Offset of field: GkAtoms::clipPathUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, clipPathUnits_string) - 30156usize];
                ["Offset of field: GkAtoms::cm_string"]
                    [::std::mem::offset_of!(GkAtoms, cm_string) - 30184usize];
                ["Offset of field: GkAtoms::color_burn_string"]
                    [::std::mem::offset_of!(GkAtoms, color_burn_string) - 30190usize];
                ["Offset of field: GkAtoms::color_dodge_string"]
                    [::std::mem::offset_of!(GkAtoms, color_dodge_string) - 30212usize];
                ["Offset of field: GkAtoms::color_interpolation_string"]
                    [::std::mem::offset_of!(GkAtoms, color_interpolation_string) - 30236usize];
                ["Offset of field: GkAtoms::color_interpolation_filters_string"][::std::mem::offset_of!(
                    GkAtoms,
                    color_interpolation_filters_string
                ) - 30276usize];
                ["Offset of field: GkAtoms::color_profile_string"]
                    [::std::mem::offset_of!(GkAtoms, color_profile_string) - 30332usize];
                ["Offset of field: GkAtoms::cursor_string"]
                    [::std::mem::offset_of!(GkAtoms, cursor_string) - 30360usize];
                ["Offset of field: GkAtoms::cx_string"]
                    [::std::mem::offset_of!(GkAtoms, cx_string) - 30374usize];
                ["Offset of field: GkAtoms::cy_string"]
                    [::std::mem::offset_of!(GkAtoms, cy_string) - 30380usize];
                ["Offset of field: GkAtoms::d_string"]
                    [::std::mem::offset_of!(GkAtoms, d_string) - 30386usize];
                ["Offset of field: GkAtoms::darken_string"]
                    [::std::mem::offset_of!(GkAtoms, darken_string) - 30390usize];
                ["Offset of field: GkAtoms::defs_string"]
                    [::std::mem::offset_of!(GkAtoms, defs_string) - 30404usize];
                ["Offset of field: GkAtoms::deg_string"]
                    [::std::mem::offset_of!(GkAtoms, deg_string) - 30414usize];
                ["Offset of field: GkAtoms::desc_string"]
                    [::std::mem::offset_of!(GkAtoms, desc_string) - 30422usize];
                ["Offset of field: GkAtoms::diffuseConstant_string"]
                    [::std::mem::offset_of!(GkAtoms, diffuseConstant_string) - 30432usize];
                ["Offset of field: GkAtoms::dilate_string"]
                    [::std::mem::offset_of!(GkAtoms, dilate_string) - 30464usize];
                ["Offset of field: GkAtoms::direction_string"]
                    [::std::mem::offset_of!(GkAtoms, direction_string) - 30478usize];
                ["Offset of field: GkAtoms::disable_string"]
                    [::std::mem::offset_of!(GkAtoms, disable_string) - 30498usize];
                ["Offset of field: GkAtoms::disc_string"]
                    [::std::mem::offset_of!(GkAtoms, disc_string) - 30514usize];
                ["Offset of field: GkAtoms::discrete_string"]
                    [::std::mem::offset_of!(GkAtoms, discrete_string) - 30524usize];
                ["Offset of field: GkAtoms::divisor_string"]
                    [::std::mem::offset_of!(GkAtoms, divisor_string) - 30542usize];
                ["Offset of field: GkAtoms::dominant_baseline_string"]
                    [::std::mem::offset_of!(GkAtoms, dominant_baseline_string) - 30558usize];
                ["Offset of field: GkAtoms::duplicate_string"]
                    [::std::mem::offset_of!(GkAtoms, duplicate_string) - 30594usize];
                ["Offset of field: GkAtoms::dx_string"]
                    [::std::mem::offset_of!(GkAtoms, dx_string) - 30614usize];
                ["Offset of field: GkAtoms::dy_string"]
                    [::std::mem::offset_of!(GkAtoms, dy_string) - 30620usize];
                ["Offset of field: GkAtoms::edgeMode_string"]
                    [::std::mem::offset_of!(GkAtoms, edgeMode_string) - 30626usize];
                ["Offset of field: GkAtoms::ellipse_string"]
                    [::std::mem::offset_of!(GkAtoms, ellipse_string) - 30644usize];
                ["Offset of field: GkAtoms::elevation_string"]
                    [::std::mem::offset_of!(GkAtoms, elevation_string) - 30660usize];
                ["Offset of field: GkAtoms::erode_string"]
                    [::std::mem::offset_of!(GkAtoms, erode_string) - 30680usize];
                ["Offset of field: GkAtoms::ex_string"]
                    [::std::mem::offset_of!(GkAtoms, ex_string) - 30692usize];
                ["Offset of field: GkAtoms::exact_string"]
                    [::std::mem::offset_of!(GkAtoms, exact_string) - 30698usize];
                ["Offset of field: GkAtoms::exclusion_string"]
                    [::std::mem::offset_of!(GkAtoms, exclusion_string) - 30710usize];
                ["Offset of field: GkAtoms::exponent_string"]
                    [::std::mem::offset_of!(GkAtoms, exponent_string) - 30730usize];
                ["Offset of field: GkAtoms::feBlend_string"]
                    [::std::mem::offset_of!(GkAtoms, feBlend_string) - 30748usize];
                ["Offset of field: GkAtoms::feColorMatrix_string"]
                    [::std::mem::offset_of!(GkAtoms, feColorMatrix_string) - 30764usize];
                ["Offset of field: GkAtoms::feComponentTransfer_string"]
                    [::std::mem::offset_of!(GkAtoms, feComponentTransfer_string) - 30792usize];
                ["Offset of field: GkAtoms::feComposite_string"]
                    [::std::mem::offset_of!(GkAtoms, feComposite_string) - 30832usize];
                ["Offset of field: GkAtoms::feConvolveMatrix_string"]
                    [::std::mem::offset_of!(GkAtoms, feConvolveMatrix_string) - 30856usize];
                ["Offset of field: GkAtoms::feDiffuseLighting_string"]
                    [::std::mem::offset_of!(GkAtoms, feDiffuseLighting_string) - 30890usize];
                ["Offset of field: GkAtoms::feDisplacementMap_string"]
                    [::std::mem::offset_of!(GkAtoms, feDisplacementMap_string) - 30926usize];
                ["Offset of field: GkAtoms::feDistantLight_string"]
                    [::std::mem::offset_of!(GkAtoms, feDistantLight_string) - 30962usize];
                ["Offset of field: GkAtoms::feDropShadow_string"]
                    [::std::mem::offset_of!(GkAtoms, feDropShadow_string) - 30992usize];
                ["Offset of field: GkAtoms::feFlood_string"]
                    [::std::mem::offset_of!(GkAtoms, feFlood_string) - 31018usize];
                ["Offset of field: GkAtoms::feFuncA_string"]
                    [::std::mem::offset_of!(GkAtoms, feFuncA_string) - 31034usize];
                ["Offset of field: GkAtoms::feFuncB_string"]
                    [::std::mem::offset_of!(GkAtoms, feFuncB_string) - 31050usize];
                ["Offset of field: GkAtoms::feFuncG_string"]
                    [::std::mem::offset_of!(GkAtoms, feFuncG_string) - 31066usize];
                ["Offset of field: GkAtoms::feFuncR_string"]
                    [::std::mem::offset_of!(GkAtoms, feFuncR_string) - 31082usize];
                ["Offset of field: GkAtoms::feGaussianBlur_string"]
                    [::std::mem::offset_of!(GkAtoms, feGaussianBlur_string) - 31098usize];
                ["Offset of field: GkAtoms::feImage_string"]
                    [::std::mem::offset_of!(GkAtoms, feImage_string) - 31128usize];
                ["Offset of field: GkAtoms::feMerge_string"]
                    [::std::mem::offset_of!(GkAtoms, feMerge_string) - 31144usize];
                ["Offset of field: GkAtoms::feMergeNode_string"]
                    [::std::mem::offset_of!(GkAtoms, feMergeNode_string) - 31160usize];
                ["Offset of field: GkAtoms::feMorphology_string"]
                    [::std::mem::offset_of!(GkAtoms, feMorphology_string) - 31184usize];
                ["Offset of field: GkAtoms::feOffset_string"]
                    [::std::mem::offset_of!(GkAtoms, feOffset_string) - 31210usize];
                ["Offset of field: GkAtoms::fePointLight_string"]
                    [::std::mem::offset_of!(GkAtoms, fePointLight_string) - 31228usize];
                ["Offset of field: GkAtoms::feSpecularLighting_string"]
                    [::std::mem::offset_of!(GkAtoms, feSpecularLighting_string) - 31254usize];
                ["Offset of field: GkAtoms::feSpotLight_string"]
                    [::std::mem::offset_of!(GkAtoms, feSpotLight_string) - 31292usize];
                ["Offset of field: GkAtoms::feTile_string"]
                    [::std::mem::offset_of!(GkAtoms, feTile_string) - 31316usize];
                ["Offset of field: GkAtoms::feTurbulence_string"]
                    [::std::mem::offset_of!(GkAtoms, feTurbulence_string) - 31330usize];
                ["Offset of field: GkAtoms::fill_string"]
                    [::std::mem::offset_of!(GkAtoms, fill_string) - 31356usize];
                ["Offset of field: GkAtoms::fill_opacity_string"]
                    [::std::mem::offset_of!(GkAtoms, fill_opacity_string) - 31366usize];
                ["Offset of field: GkAtoms::fill_rule_string"]
                    [::std::mem::offset_of!(GkAtoms, fill_rule_string) - 31392usize];
                ["Offset of field: GkAtoms::filter_string"]
                    [::std::mem::offset_of!(GkAtoms, filter_string) - 31412usize];
                ["Offset of field: GkAtoms::filterUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, filterUnits_string) - 31426usize];
                ["Offset of field: GkAtoms::_float_string"]
                    [::std::mem::offset_of!(GkAtoms, _float_string) - 31450usize];
                ["Offset of field: GkAtoms::flood_color_string"]
                    [::std::mem::offset_of!(GkAtoms, flood_color_string) - 31462usize];
                ["Offset of field: GkAtoms::flood_opacity_string"]
                    [::std::mem::offset_of!(GkAtoms, flood_opacity_string) - 31486usize];
                ["Offset of field: GkAtoms::font_face_string"]
                    [::std::mem::offset_of!(GkAtoms, font_face_string) - 31514usize];
                ["Offset of field: GkAtoms::font_face_format_string"]
                    [::std::mem::offset_of!(GkAtoms, font_face_format_string) - 31534usize];
                ["Offset of field: GkAtoms::font_face_name_string"]
                    [::std::mem::offset_of!(GkAtoms, font_face_name_string) - 31568usize];
                ["Offset of field: GkAtoms::font_face_src_string"]
                    [::std::mem::offset_of!(GkAtoms, font_face_src_string) - 31598usize];
                ["Offset of field: GkAtoms::font_face_uri_string"]
                    [::std::mem::offset_of!(GkAtoms, font_face_uri_string) - 31626usize];
                ["Offset of field: GkAtoms::font_family_string"]
                    [::std::mem::offset_of!(GkAtoms, font_family_string) - 31654usize];
                ["Offset of field: GkAtoms::font_size_string"]
                    [::std::mem::offset_of!(GkAtoms, font_size_string) - 31678usize];
                ["Offset of field: GkAtoms::font_size_adjust_string"]
                    [::std::mem::offset_of!(GkAtoms, font_size_adjust_string) - 31698usize];
                ["Offset of field: GkAtoms::font_stretch_string"]
                    [::std::mem::offset_of!(GkAtoms, font_stretch_string) - 31732usize];
                ["Offset of field: GkAtoms::font_style_string"]
                    [::std::mem::offset_of!(GkAtoms, font_style_string) - 31758usize];
                ["Offset of field: GkAtoms::font_variant_string"]
                    [::std::mem::offset_of!(GkAtoms, font_variant_string) - 31780usize];
                ["Offset of field: GkAtoms::font_weight_string"]
                    [::std::mem::offset_of!(GkAtoms, font_weight_string) - 31806usize];
                ["Offset of field: GkAtoms::formatting_string"]
                    [::std::mem::offset_of!(GkAtoms, formatting_string) - 31830usize];
                ["Offset of field: GkAtoms::foreignObject_string"]
                    [::std::mem::offset_of!(GkAtoms, foreignObject_string) - 31852usize];
                ["Offset of field: GkAtoms::fractalNoise_string"]
                    [::std::mem::offset_of!(GkAtoms, fractalNoise_string) - 31880usize];
                ["Offset of field: GkAtoms::fr_string"]
                    [::std::mem::offset_of!(GkAtoms, fr_string) - 31906usize];
                ["Offset of field: GkAtoms::fx_string"]
                    [::std::mem::offset_of!(GkAtoms, fx_string) - 31912usize];
                ["Offset of field: GkAtoms::fy_string"]
                    [::std::mem::offset_of!(GkAtoms, fy_string) - 31918usize];
                ["Offset of field: GkAtoms::G_string"]
                    [::std::mem::offset_of!(GkAtoms, G_string) - 31924usize];
                ["Offset of field: GkAtoms::g_string"]
                    [::std::mem::offset_of!(GkAtoms, g_string) - 31928usize];
                ["Offset of field: GkAtoms::gamma_string"]
                    [::std::mem::offset_of!(GkAtoms, gamma_string) - 31932usize];
                ["Offset of field: GkAtoms::glyphRef_string"]
                    [::std::mem::offset_of!(GkAtoms, glyphRef_string) - 31944usize];
                ["Offset of field: GkAtoms::grad_string"]
                    [::std::mem::offset_of!(GkAtoms, grad_string) - 31962usize];
                ["Offset of field: GkAtoms::gradientTransform_string"]
                    [::std::mem::offset_of!(GkAtoms, gradientTransform_string) - 31972usize];
                ["Offset of field: GkAtoms::gradientUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, gradientUnits_string) - 32008usize];
                ["Offset of field: GkAtoms::hardLight_string"]
                    [::std::mem::offset_of!(GkAtoms, hardLight_string) - 32036usize];
                ["Offset of field: GkAtoms::hue_string"]
                    [::std::mem::offset_of!(GkAtoms, hue_string) - 32058usize];
                ["Offset of field: GkAtoms::hueRotate_string"]
                    [::std::mem::offset_of!(GkAtoms, hueRotate_string) - 32066usize];
                ["Offset of field: GkAtoms::identity_string"]
                    [::std::mem::offset_of!(GkAtoms, identity_string) - 32086usize];
                ["Offset of field: GkAtoms::image_rendering_string"]
                    [::std::mem::offset_of!(GkAtoms, image_rendering_string) - 32104usize];
                ["Offset of field: GkAtoms::in_string"]
                    [::std::mem::offset_of!(GkAtoms, in_string) - 32136usize];
                ["Offset of field: GkAtoms::in2_string"]
                    [::std::mem::offset_of!(GkAtoms, in2_string) - 32142usize];
                ["Offset of field: GkAtoms::intercept_string"]
                    [::std::mem::offset_of!(GkAtoms, intercept_string) - 32150usize];
                ["Offset of field: GkAtoms::k1_string"]
                    [::std::mem::offset_of!(GkAtoms, k1_string) - 32170usize];
                ["Offset of field: GkAtoms::k2_string"]
                    [::std::mem::offset_of!(GkAtoms, k2_string) - 32176usize];
                ["Offset of field: GkAtoms::k3_string"]
                    [::std::mem::offset_of!(GkAtoms, k3_string) - 32182usize];
                ["Offset of field: GkAtoms::k4_string"]
                    [::std::mem::offset_of!(GkAtoms, k4_string) - 32188usize];
                ["Offset of field: GkAtoms::kernelMatrix_string"]
                    [::std::mem::offset_of!(GkAtoms, kernelMatrix_string) - 32194usize];
                ["Offset of field: GkAtoms::kernelUnitLength_string"]
                    [::std::mem::offset_of!(GkAtoms, kernelUnitLength_string) - 32220usize];
                ["Offset of field: GkAtoms::lengthAdjust_string"]
                    [::std::mem::offset_of!(GkAtoms, lengthAdjust_string) - 32254usize];
                ["Offset of field: GkAtoms::letter_spacing_string"]
                    [::std::mem::offset_of!(GkAtoms, letter_spacing_string) - 32280usize];
                ["Offset of field: GkAtoms::lighten_string"]
                    [::std::mem::offset_of!(GkAtoms, lighten_string) - 32310usize];
                ["Offset of field: GkAtoms::lighter_string"]
                    [::std::mem::offset_of!(GkAtoms, lighter_string) - 32326usize];
                ["Offset of field: GkAtoms::lighting_color_string"]
                    [::std::mem::offset_of!(GkAtoms, lighting_color_string) - 32342usize];
                ["Offset of field: GkAtoms::limitingConeAngle_string"]
                    [::std::mem::offset_of!(GkAtoms, limitingConeAngle_string) - 32372usize];
                ["Offset of field: GkAtoms::linear_string"]
                    [::std::mem::offset_of!(GkAtoms, linear_string) - 32408usize];
                ["Offset of field: GkAtoms::linearGradient_string"]
                    [::std::mem::offset_of!(GkAtoms, linearGradient_string) - 32422usize];
                ["Offset of field: GkAtoms::list_item_string"]
                    [::std::mem::offset_of!(GkAtoms, list_item_string) - 32452usize];
                ["Offset of field: GkAtoms::list_style_type_string"]
                    [::std::mem::offset_of!(GkAtoms, list_style_type_string) - 32472usize];
                ["Offset of field: GkAtoms::luminanceToAlpha_string"]
                    [::std::mem::offset_of!(GkAtoms, luminanceToAlpha_string) - 32504usize];
                ["Offset of field: GkAtoms::luminosity_string"]
                    [::std::mem::offset_of!(GkAtoms, luminosity_string) - 32538usize];
                ["Offset of field: GkAtoms::magnify_string"]
                    [::std::mem::offset_of!(GkAtoms, magnify_string) - 32560usize];
                ["Offset of field: GkAtoms::marker_string"]
                    [::std::mem::offset_of!(GkAtoms, marker_string) - 32576usize];
                ["Offset of field: GkAtoms::marker_end_string"]
                    [::std::mem::offset_of!(GkAtoms, marker_end_string) - 32590usize];
                ["Offset of field: GkAtoms::marker_mid_string"]
                    [::std::mem::offset_of!(GkAtoms, marker_mid_string) - 32612usize];
                ["Offset of field: GkAtoms::marker_start_string"]
                    [::std::mem::offset_of!(GkAtoms, marker_start_string) - 32634usize];
                ["Offset of field: GkAtoms::markerHeight_string"]
                    [::std::mem::offset_of!(GkAtoms, markerHeight_string) - 32660usize];
                ["Offset of field: GkAtoms::markerUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, markerUnits_string) - 32686usize];
                ["Offset of field: GkAtoms::markerWidth_string"]
                    [::std::mem::offset_of!(GkAtoms, markerWidth_string) - 32710usize];
                ["Offset of field: GkAtoms::mask_string"]
                    [::std::mem::offset_of!(GkAtoms, mask_string) - 32734usize];
                ["Offset of field: GkAtoms::maskContentUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, maskContentUnits_string) - 32744usize];
                ["Offset of field: GkAtoms::mask_type_string"]
                    [::std::mem::offset_of!(GkAtoms, mask_type_string) - 32778usize];
                ["Offset of field: GkAtoms::maskUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, maskUnits_string) - 32798usize];
                ["Offset of field: GkAtoms::matrix_string"]
                    [::std::mem::offset_of!(GkAtoms, matrix_string) - 32818usize];
                ["Offset of field: GkAtoms::metadata_string"]
                    [::std::mem::offset_of!(GkAtoms, metadata_string) - 32832usize];
                ["Offset of field: GkAtoms::missingGlyph_string"]
                    [::std::mem::offset_of!(GkAtoms, missingGlyph_string) - 32850usize];
                ["Offset of field: GkAtoms::mm_string"]
                    [::std::mem::offset_of!(GkAtoms, mm_string) - 32878usize];
                ["Offset of field: GkAtoms::mpath_string"]
                    [::std::mem::offset_of!(GkAtoms, mpath_string) - 32884usize];
                ["Offset of field: GkAtoms::noStitch_string"]
                    [::std::mem::offset_of!(GkAtoms, noStitch_string) - 32896usize];
                ["Offset of field: GkAtoms::numOctaves_string"]
                    [::std::mem::offset_of!(GkAtoms, numOctaves_string) - 32914usize];
                ["Offset of field: GkAtoms::multiply_string"]
                    [::std::mem::offset_of!(GkAtoms, multiply_string) - 32936usize];
                ["Offset of field: GkAtoms::objectBoundingBox_string"]
                    [::std::mem::offset_of!(GkAtoms, objectBoundingBox_string) - 32954usize];
                ["Offset of field: GkAtoms::offset_string"]
                    [::std::mem::offset_of!(GkAtoms, offset_string) - 32990usize];
                ["Offset of field: GkAtoms::onSVGLoad_string"]
                    [::std::mem::offset_of!(GkAtoms, onSVGLoad_string) - 33004usize];
                ["Offset of field: GkAtoms::onSVGScroll_string"]
                    [::std::mem::offset_of!(GkAtoms, onSVGScroll_string) - 33024usize];
                ["Offset of field: GkAtoms::onzoom_string"]
                    [::std::mem::offset_of!(GkAtoms, onzoom_string) - 33048usize];
                ["Offset of field: GkAtoms::opacity_string"]
                    [::std::mem::offset_of!(GkAtoms, opacity_string) - 33062usize];
                ["Offset of field: GkAtoms::_operator_string"]
                    [::std::mem::offset_of!(GkAtoms, _operator_string) - 33078usize];
                ["Offset of field: GkAtoms::out_string"]
                    [::std::mem::offset_of!(GkAtoms, out_string) - 33096usize];
                ["Offset of field: GkAtoms::over_string"]
                    [::std::mem::offset_of!(GkAtoms, over_string) - 33104usize];
                ["Offset of field: GkAtoms::overridePreserveAspectRatio_string"][::std::mem::offset_of!(
                    GkAtoms,
                    overridePreserveAspectRatio_string
                ) - 33114usize];
                ["Offset of field: GkAtoms::pad_string"]
                    [::std::mem::offset_of!(GkAtoms, pad_string) - 33170usize];
                ["Offset of field: GkAtoms::path_string"]
                    [::std::mem::offset_of!(GkAtoms, path_string) - 33178usize];
                ["Offset of field: GkAtoms::pathLength_string"]
                    [::std::mem::offset_of!(GkAtoms, pathLength_string) - 33188usize];
                ["Offset of field: GkAtoms::patternContentUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, patternContentUnits_string) - 33210usize];
                ["Offset of field: GkAtoms::patternTransform_string"]
                    [::std::mem::offset_of!(GkAtoms, patternTransform_string) - 33250usize];
                ["Offset of field: GkAtoms::patternUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, patternUnits_string) - 33284usize];
                ["Offset of field: GkAtoms::pc_string"]
                    [::std::mem::offset_of!(GkAtoms, pc_string) - 33310usize];
                ["Offset of field: GkAtoms::pointer_string"]
                    [::std::mem::offset_of!(GkAtoms, pointer_string) - 33316usize];
                ["Offset of field: GkAtoms::pointer_events_string"]
                    [::std::mem::offset_of!(GkAtoms, pointer_events_string) - 33332usize];
                ["Offset of field: GkAtoms::points_string"]
                    [::std::mem::offset_of!(GkAtoms, points_string) - 33362usize];
                ["Offset of field: GkAtoms::pointsAtX_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsAtX_string) - 33376usize];
                ["Offset of field: GkAtoms::pointsAtY_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsAtY_string) - 33396usize];
                ["Offset of field: GkAtoms::pointsAtZ_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsAtZ_string) - 33416usize];
                ["Offset of field: GkAtoms::polyline_string"]
                    [::std::mem::offset_of!(GkAtoms, polyline_string) - 33436usize];
                ["Offset of field: GkAtoms::preserveAlpha_string"]
                    [::std::mem::offset_of!(GkAtoms, preserveAlpha_string) - 33454usize];
                ["Offset of field: GkAtoms::preserveAspectRatio_string"]
                    [::std::mem::offset_of!(GkAtoms, preserveAspectRatio_string) - 33482usize];
                ["Offset of field: GkAtoms::primitiveUnits_string"]
                    [::std::mem::offset_of!(GkAtoms, primitiveUnits_string) - 33522usize];
                ["Offset of field: GkAtoms::pt_string"]
                    [::std::mem::offset_of!(GkAtoms, pt_string) - 33552usize];
                ["Offset of field: GkAtoms::px_string"]
                    [::std::mem::offset_of!(GkAtoms, px_string) - 33558usize];
                ["Offset of field: GkAtoms::R_string"]
                    [::std::mem::offset_of!(GkAtoms, R_string) - 33564usize];
                ["Offset of field: GkAtoms::r_string"]
                    [::std::mem::offset_of!(GkAtoms, r_string) - 33568usize];
                ["Offset of field: GkAtoms::rad_string"]
                    [::std::mem::offset_of!(GkAtoms, rad_string) - 33572usize];
                ["Offset of field: GkAtoms::radialGradient_string"]
                    [::std::mem::offset_of!(GkAtoms, radialGradient_string) - 33580usize];
                ["Offset of field: GkAtoms::radius_string"]
                    [::std::mem::offset_of!(GkAtoms, radius_string) - 33610usize];
                ["Offset of field: GkAtoms::reflect_string"]
                    [::std::mem::offset_of!(GkAtoms, reflect_string) - 33624usize];
                ["Offset of field: GkAtoms::refX_string"]
                    [::std::mem::offset_of!(GkAtoms, refX_string) - 33640usize];
                ["Offset of field: GkAtoms::refY_string"]
                    [::std::mem::offset_of!(GkAtoms, refY_string) - 33650usize];
                ["Offset of field: GkAtoms::requiredExtensions_string"]
                    [::std::mem::offset_of!(GkAtoms, requiredExtensions_string) - 33660usize];
                ["Offset of field: GkAtoms::requiredFeatures_string"]
                    [::std::mem::offset_of!(GkAtoms, requiredFeatures_string) - 33698usize];
                ["Offset of field: GkAtoms::rotate_string"]
                    [::std::mem::offset_of!(GkAtoms, rotate_string) - 33732usize];
                ["Offset of field: GkAtoms::rx_string"]
                    [::std::mem::offset_of!(GkAtoms, rx_string) - 33746usize];
                ["Offset of field: GkAtoms::ry_string"]
                    [::std::mem::offset_of!(GkAtoms, ry_string) - 33752usize];
                ["Offset of field: GkAtoms::saturate_string"]
                    [::std::mem::offset_of!(GkAtoms, saturate_string) - 33758usize];
                ["Offset of field: GkAtoms::saturation_string"]
                    [::std::mem::offset_of!(GkAtoms, saturation_string) - 33776usize];
                ["Offset of field: GkAtoms::set_string"]
                    [::std::mem::offset_of!(GkAtoms, set_string) - 33798usize];
                ["Offset of field: GkAtoms::seed_string"]
                    [::std::mem::offset_of!(GkAtoms, seed_string) - 33806usize];
                ["Offset of field: GkAtoms::shape_rendering_string"]
                    [::std::mem::offset_of!(GkAtoms, shape_rendering_string) - 33816usize];
                ["Offset of field: GkAtoms::simpleScopeChain_string"]
                    [::std::mem::offset_of!(GkAtoms, simpleScopeChain_string) - 33848usize];
                ["Offset of field: GkAtoms::skewX_string"]
                    [::std::mem::offset_of!(GkAtoms, skewX_string) - 33882usize];
                ["Offset of field: GkAtoms::skewY_string"]
                    [::std::mem::offset_of!(GkAtoms, skewY_string) - 33894usize];
                ["Offset of field: GkAtoms::slope_string"]
                    [::std::mem::offset_of!(GkAtoms, slope_string) - 33906usize];
                ["Offset of field: GkAtoms::slot_string"]
                    [::std::mem::offset_of!(GkAtoms, slot_string) - 33918usize];
                ["Offset of field: GkAtoms::softLight_string"]
                    [::std::mem::offset_of!(GkAtoms, softLight_string) - 33928usize];
                ["Offset of field: GkAtoms::spacing_string"]
                    [::std::mem::offset_of!(GkAtoms, spacing_string) - 33950usize];
                ["Offset of field: GkAtoms::spacingAndGlyphs_string"]
                    [::std::mem::offset_of!(GkAtoms, spacingAndGlyphs_string) - 33966usize];
                ["Offset of field: GkAtoms::specularConstant_string"]
                    [::std::mem::offset_of!(GkAtoms, specularConstant_string) - 34000usize];
                ["Offset of field: GkAtoms::specularExponent_string"]
                    [::std::mem::offset_of!(GkAtoms, specularExponent_string) - 34034usize];
                ["Offset of field: GkAtoms::spreadMethod_string"]
                    [::std::mem::offset_of!(GkAtoms, spreadMethod_string) - 34068usize];
                ["Offset of field: GkAtoms::startOffset_string"]
                    [::std::mem::offset_of!(GkAtoms, startOffset_string) - 34094usize];
                ["Offset of field: GkAtoms::stdDeviation_string"]
                    [::std::mem::offset_of!(GkAtoms, stdDeviation_string) - 34118usize];
                ["Offset of field: GkAtoms::stitch_string"]
                    [::std::mem::offset_of!(GkAtoms, stitch_string) - 34144usize];
                ["Offset of field: GkAtoms::stitchTiles_string"]
                    [::std::mem::offset_of!(GkAtoms, stitchTiles_string) - 34158usize];
                ["Offset of field: GkAtoms::stop_color_string"]
                    [::std::mem::offset_of!(GkAtoms, stop_color_string) - 34182usize];
                ["Offset of field: GkAtoms::stop_opacity_string"]
                    [::std::mem::offset_of!(GkAtoms, stop_opacity_string) - 34204usize];
                ["Offset of field: GkAtoms::stroke_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_string) - 34230usize];
                ["Offset of field: GkAtoms::stroke_dasharray_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_dasharray_string) - 34244usize];
                ["Offset of field: GkAtoms::stroke_dashoffset_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_dashoffset_string) - 34278usize];
                ["Offset of field: GkAtoms::stroke_linecap_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_linecap_string) - 34314usize];
                ["Offset of field: GkAtoms::stroke_linejoin_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_linejoin_string) - 34344usize];
                ["Offset of field: GkAtoms::stroke_miterlimit_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_miterlimit_string) - 34376usize];
                ["Offset of field: GkAtoms::stroke_opacity_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_opacity_string) - 34412usize];
                ["Offset of field: GkAtoms::stroke_width_string"]
                    [::std::mem::offset_of!(GkAtoms, stroke_width_string) - 34442usize];
                ["Offset of field: GkAtoms::strokeWidth_string"]
                    [::std::mem::offset_of!(GkAtoms, strokeWidth_string) - 34468usize];
                ["Offset of field: GkAtoms::surfaceScale_string"]
                    [::std::mem::offset_of!(GkAtoms, surfaceScale_string) - 34492usize];
                ["Offset of field: GkAtoms::svg_string"]
                    [::std::mem::offset_of!(GkAtoms, svg_string) - 34518usize];
                ["Offset of field: GkAtoms::svgSwitch_string"]
                    [::std::mem::offset_of!(GkAtoms, svgSwitch_string) - 34526usize];
                ["Offset of field: GkAtoms::symbol_string"]
                    [::std::mem::offset_of!(GkAtoms, symbol_string) - 34540usize];
                ["Offset of field: GkAtoms::systemLanguage_string"]
                    [::std::mem::offset_of!(GkAtoms, systemLanguage_string) - 34554usize];
                ["Offset of field: GkAtoms::tableValues_string"]
                    [::std::mem::offset_of!(GkAtoms, tableValues_string) - 34584usize];
                ["Offset of field: GkAtoms::targetX_string"]
                    [::std::mem::offset_of!(GkAtoms, targetX_string) - 34608usize];
                ["Offset of field: GkAtoms::targetY_string"]
                    [::std::mem::offset_of!(GkAtoms, targetY_string) - 34624usize];
                ["Offset of field: GkAtoms::text_anchor_string"]
                    [::std::mem::offset_of!(GkAtoms, text_anchor_string) - 34640usize];
                ["Offset of field: GkAtoms::text_overflow_string"]
                    [::std::mem::offset_of!(GkAtoms, text_overflow_string) - 34664usize];
                ["Offset of field: GkAtoms::text_rendering_string"]
                    [::std::mem::offset_of!(GkAtoms, text_rendering_string) - 34692usize];
                ["Offset of field: GkAtoms::textLength_string"]
                    [::std::mem::offset_of!(GkAtoms, textLength_string) - 34722usize];
                ["Offset of field: GkAtoms::textPath_string"]
                    [::std::mem::offset_of!(GkAtoms, textPath_string) - 34744usize];
                ["Offset of field: GkAtoms::transform_origin_string"]
                    [::std::mem::offset_of!(GkAtoms, transform_origin_string) - 34762usize];
                ["Offset of field: GkAtoms::tref_string"]
                    [::std::mem::offset_of!(GkAtoms, tref_string) - 34796usize];
                ["Offset of field: GkAtoms::tspan_string"]
                    [::std::mem::offset_of!(GkAtoms, tspan_string) - 34806usize];
                ["Offset of field: GkAtoms::turbulence_string"]
                    [::std::mem::offset_of!(GkAtoms, turbulence_string) - 34818usize];
                ["Offset of field: GkAtoms::unicode_bidi_string"]
                    [::std::mem::offset_of!(GkAtoms, unicode_bidi_string) - 34840usize];
                ["Offset of field: GkAtoms::userSpaceOnUse_string"]
                    [::std::mem::offset_of!(GkAtoms, userSpaceOnUse_string) - 34866usize];
                ["Offset of field: GkAtoms::view_string"]
                    [::std::mem::offset_of!(GkAtoms, view_string) - 34896usize];
                ["Offset of field: GkAtoms::viewBox_string"]
                    [::std::mem::offset_of!(GkAtoms, viewBox_string) - 34906usize];
                ["Offset of field: GkAtoms::viewTarget_string"]
                    [::std::mem::offset_of!(GkAtoms, viewTarget_string) - 34922usize];
                ["Offset of field: GkAtoms::white_space_string"]
                    [::std::mem::offset_of!(GkAtoms, white_space_string) - 34944usize];
                ["Offset of field: GkAtoms::windowsmica_string"]
                    [::std::mem::offset_of!(GkAtoms, windowsmica_string) - 34968usize];
                ["Offset of field: GkAtoms::word_spacing_string"]
                    [::std::mem::offset_of!(GkAtoms, word_spacing_string) - 34992usize];
                ["Offset of field: GkAtoms::writing_mode_string"]
                    [::std::mem::offset_of!(GkAtoms, writing_mode_string) - 35018usize];
                ["Offset of field: GkAtoms::x_string"]
                    [::std::mem::offset_of!(GkAtoms, x_string) - 35044usize];
                ["Offset of field: GkAtoms::x1_string"]
                    [::std::mem::offset_of!(GkAtoms, x1_string) - 35048usize];
                ["Offset of field: GkAtoms::x2_string"]
                    [::std::mem::offset_of!(GkAtoms, x2_string) - 35054usize];
                ["Offset of field: GkAtoms::xChannelSelector_string"]
                    [::std::mem::offset_of!(GkAtoms, xChannelSelector_string) - 35060usize];
                ["Offset of field: GkAtoms::xor__string"]
                    [::std::mem::offset_of!(GkAtoms, xor__string) - 35094usize];
                ["Offset of field: GkAtoms::y_string"]
                    [::std::mem::offset_of!(GkAtoms, y_string) - 35102usize];
                ["Offset of field: GkAtoms::y1_string"]
                    [::std::mem::offset_of!(GkAtoms, y1_string) - 35106usize];
                ["Offset of field: GkAtoms::y2_string"]
                    [::std::mem::offset_of!(GkAtoms, y2_string) - 35112usize];
                ["Offset of field: GkAtoms::yChannelSelector_string"]
                    [::std::mem::offset_of!(GkAtoms, yChannelSelector_string) - 35118usize];
                ["Offset of field: GkAtoms::z_string"]
                    [::std::mem::offset_of!(GkAtoms, z_string) - 35152usize];
                ["Offset of field: GkAtoms::zoomAndPan_string"]
                    [::std::mem::offset_of!(GkAtoms, zoomAndPan_string) - 35156usize];
                ["Offset of field: GkAtoms::vector_effect_string"]
                    [::std::mem::offset_of!(GkAtoms, vector_effect_string) - 35178usize];
                ["Offset of field: GkAtoms::vertical_align_string"]
                    [::std::mem::offset_of!(GkAtoms, vertical_align_string) - 35206usize];
                ["Offset of field: GkAtoms::accumulate_string"]
                    [::std::mem::offset_of!(GkAtoms, accumulate_string) - 35236usize];
                ["Offset of field: GkAtoms::additive_string"]
                    [::std::mem::offset_of!(GkAtoms, additive_string) - 35258usize];
                ["Offset of field: GkAtoms::attributeName_string"]
                    [::std::mem::offset_of!(GkAtoms, attributeName_string) - 35276usize];
                ["Offset of field: GkAtoms::attributeType_string"]
                    [::std::mem::offset_of!(GkAtoms, attributeType_string) - 35304usize];
                ["Offset of field: GkAtoms::auto_reverse_string"]
                    [::std::mem::offset_of!(GkAtoms, auto_reverse_string) - 35332usize];
                ["Offset of field: GkAtoms::begin_string"]
                    [::std::mem::offset_of!(GkAtoms, begin_string) - 35358usize];
                ["Offset of field: GkAtoms::beginEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, beginEvent_string) - 35370usize];
                ["Offset of field: GkAtoms::by_string"]
                    [::std::mem::offset_of!(GkAtoms, by_string) - 35392usize];
                ["Offset of field: GkAtoms::calcMode_string"]
                    [::std::mem::offset_of!(GkAtoms, calcMode_string) - 35398usize];
                ["Offset of field: GkAtoms::dur_string"]
                    [::std::mem::offset_of!(GkAtoms, dur_string) - 35416usize];
                ["Offset of field: GkAtoms::keyPoints_string"]
                    [::std::mem::offset_of!(GkAtoms, keyPoints_string) - 35424usize];
                ["Offset of field: GkAtoms::keySplines_string"]
                    [::std::mem::offset_of!(GkAtoms, keySplines_string) - 35444usize];
                ["Offset of field: GkAtoms::keyTimes_string"]
                    [::std::mem::offset_of!(GkAtoms, keyTimes_string) - 35466usize];
                ["Offset of field: GkAtoms::mozAnimateMotionDummyAttr_string"][::std::mem::offset_of!(
                    GkAtoms,
                    mozAnimateMotionDummyAttr_string
                ) - 35484usize];
                ["Offset of field: GkAtoms::onbegin_string"]
                    [::std::mem::offset_of!(GkAtoms, onbegin_string) - 35538usize];
                ["Offset of field: GkAtoms::onbeginEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeginEvent_string) - 35554usize];
                ["Offset of field: GkAtoms::onend_string"]
                    [::std::mem::offset_of!(GkAtoms, onend_string) - 35580usize];
                ["Offset of field: GkAtoms::onendEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, onendEvent_string) - 35592usize];
                ["Offset of field: GkAtoms::onrelease_string"]
                    [::std::mem::offset_of!(GkAtoms, onrelease_string) - 35614usize];
                ["Offset of field: GkAtoms::onrepeat_string"]
                    [::std::mem::offset_of!(GkAtoms, onrepeat_string) - 35634usize];
                ["Offset of field: GkAtoms::onrepeatEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, onrepeatEvent_string) - 35652usize];
                ["Offset of field: GkAtoms::repeatCount_string"]
                    [::std::mem::offset_of!(GkAtoms, repeatCount_string) - 35680usize];
                ["Offset of field: GkAtoms::repeatDur_string"]
                    [::std::mem::offset_of!(GkAtoms, repeatDur_string) - 35704usize];
                ["Offset of field: GkAtoms::repeatEvent_string"]
                    [::std::mem::offset_of!(GkAtoms, repeatEvent_string) - 35724usize];
                ["Offset of field: GkAtoms::restart_string"]
                    [::std::mem::offset_of!(GkAtoms, restart_string) - 35748usize];
                ["Offset of field: GkAtoms::to_string"]
                    [::std::mem::offset_of!(GkAtoms, to_string) - 35764usize];
                ["Offset of field: GkAtoms::abs_string"]
                    [::std::mem::offset_of!(GkAtoms, abs_string) - 35770usize];
                ["Offset of field: GkAtoms::accent_string"]
                    [::std::mem::offset_of!(GkAtoms, accent_string) - 35778usize];
                ["Offset of field: GkAtoms::accentunder_string"]
                    [::std::mem::offset_of!(GkAtoms, accentunder_string) - 35792usize];
                ["Offset of field: GkAtoms::actiontype_string"]
                    [::std::mem::offset_of!(GkAtoms, actiontype_string) - 35816usize];
                ["Offset of field: GkAtoms::alignmentscope_string"]
                    [::std::mem::offset_of!(GkAtoms, alignmentscope_string) - 35838usize];
                ["Offset of field: GkAtoms::altimg_string"]
                    [::std::mem::offset_of!(GkAtoms, altimg_string) - 35868usize];
                ["Offset of field: GkAtoms::altimg_height_string"]
                    [::std::mem::offset_of!(GkAtoms, altimg_height_string) - 35882usize];
                ["Offset of field: GkAtoms::altimg_valign_string"]
                    [::std::mem::offset_of!(GkAtoms, altimg_valign_string) - 35910usize];
                ["Offset of field: GkAtoms::altimg_width_string"]
                    [::std::mem::offset_of!(GkAtoms, altimg_width_string) - 35938usize];
                ["Offset of field: GkAtoms::annotation_string"]
                    [::std::mem::offset_of!(GkAtoms, annotation_string) - 35964usize];
                ["Offset of field: GkAtoms::annotation_xml_string"]
                    [::std::mem::offset_of!(GkAtoms, annotation_xml_string) - 35986usize];
                ["Offset of field: GkAtoms::apply_string"]
                    [::std::mem::offset_of!(GkAtoms, apply_string) - 36016usize];
                ["Offset of field: GkAtoms::approx_string"]
                    [::std::mem::offset_of!(GkAtoms, approx_string) - 36028usize];
                ["Offset of field: GkAtoms::arccos_string"]
                    [::std::mem::offset_of!(GkAtoms, arccos_string) - 36042usize];
                ["Offset of field: GkAtoms::arccosh_string"]
                    [::std::mem::offset_of!(GkAtoms, arccosh_string) - 36056usize];
                ["Offset of field: GkAtoms::arccot_string"]
                    [::std::mem::offset_of!(GkAtoms, arccot_string) - 36072usize];
                ["Offset of field: GkAtoms::arccoth_string"]
                    [::std::mem::offset_of!(GkAtoms, arccoth_string) - 36086usize];
                ["Offset of field: GkAtoms::arccsc_string"]
                    [::std::mem::offset_of!(GkAtoms, arccsc_string) - 36102usize];
                ["Offset of field: GkAtoms::arccsch_string"]
                    [::std::mem::offset_of!(GkAtoms, arccsch_string) - 36116usize];
                ["Offset of field: GkAtoms::arcsec_string"]
                    [::std::mem::offset_of!(GkAtoms, arcsec_string) - 36132usize];
                ["Offset of field: GkAtoms::arcsech_string"]
                    [::std::mem::offset_of!(GkAtoms, arcsech_string) - 36146usize];
                ["Offset of field: GkAtoms::arcsin_string"]
                    [::std::mem::offset_of!(GkAtoms, arcsin_string) - 36162usize];
                ["Offset of field: GkAtoms::arcsinh_string"]
                    [::std::mem::offset_of!(GkAtoms, arcsinh_string) - 36176usize];
                ["Offset of field: GkAtoms::arctan_string"]
                    [::std::mem::offset_of!(GkAtoms, arctan_string) - 36192usize];
                ["Offset of field: GkAtoms::arctanh_string"]
                    [::std::mem::offset_of!(GkAtoms, arctanh_string) - 36206usize];
                ["Offset of field: GkAtoms::arg_string"]
                    [::std::mem::offset_of!(GkAtoms, arg_string) - 36222usize];
                ["Offset of field: GkAtoms::bevelled_string"]
                    [::std::mem::offset_of!(GkAtoms, bevelled_string) - 36230usize];
                ["Offset of field: GkAtoms::bind_string"]
                    [::std::mem::offset_of!(GkAtoms, bind_string) - 36248usize];
                ["Offset of field: GkAtoms::bvar_string"]
                    [::std::mem::offset_of!(GkAtoms, bvar_string) - 36258usize];
                ["Offset of field: GkAtoms::card_string"]
                    [::std::mem::offset_of!(GkAtoms, card_string) - 36268usize];
                ["Offset of field: GkAtoms::cartesianproduct_string"]
                    [::std::mem::offset_of!(GkAtoms, cartesianproduct_string) - 36278usize];
                ["Offset of field: GkAtoms::cbytes_string"]
                    [::std::mem::offset_of!(GkAtoms, cbytes_string) - 36312usize];
                ["Offset of field: GkAtoms::cd_string"]
                    [::std::mem::offset_of!(GkAtoms, cd_string) - 36326usize];
                ["Offset of field: GkAtoms::cdgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, cdgroup_string) - 36332usize];
                ["Offset of field: GkAtoms::cerror_string"]
                    [::std::mem::offset_of!(GkAtoms, cerror_string) - 36348usize];
                ["Offset of field: GkAtoms::charalign_string"]
                    [::std::mem::offset_of!(GkAtoms, charalign_string) - 36362usize];
                ["Offset of field: GkAtoms::ci_string"]
                    [::std::mem::offset_of!(GkAtoms, ci_string) - 36382usize];
                ["Offset of field: GkAtoms::closure_string"]
                    [::std::mem::offset_of!(GkAtoms, closure_string) - 36388usize];
                ["Offset of field: GkAtoms::cn_string"]
                    [::std::mem::offset_of!(GkAtoms, cn_string) - 36404usize];
                ["Offset of field: GkAtoms::codomain_string"]
                    [::std::mem::offset_of!(GkAtoms, codomain_string) - 36410usize];
                ["Offset of field: GkAtoms::columnalign_string"]
                    [::std::mem::offset_of!(GkAtoms, columnalign_string) - 36428usize];
                ["Offset of field: GkAtoms::columnalignment_string"]
                    [::std::mem::offset_of!(GkAtoms, columnalignment_string) - 36452usize];
                ["Offset of field: GkAtoms::columnlines_string"]
                    [::std::mem::offset_of!(GkAtoms, columnlines_string) - 36484usize];
                ["Offset of field: GkAtoms::columnspacing_string"]
                    [::std::mem::offset_of!(GkAtoms, columnspacing_string) - 36508usize];
                ["Offset of field: GkAtoms::columnspan_string"]
                    [::std::mem::offset_of!(GkAtoms, columnspan_string) - 36536usize];
                ["Offset of field: GkAtoms::columnwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, columnwidth_string) - 36558usize];
                ["Offset of field: GkAtoms::complexes_string"]
                    [::std::mem::offset_of!(GkAtoms, complexes_string) - 36582usize];
                ["Offset of field: GkAtoms::compose_string"]
                    [::std::mem::offset_of!(GkAtoms, compose_string) - 36602usize];
                ["Offset of field: GkAtoms::condition_string"]
                    [::std::mem::offset_of!(GkAtoms, condition_string) - 36618usize];
                ["Offset of field: GkAtoms::conjugate_string"]
                    [::std::mem::offset_of!(GkAtoms, conjugate_string) - 36638usize];
                ["Offset of field: GkAtoms::cos_string"]
                    [::std::mem::offset_of!(GkAtoms, cos_string) - 36658usize];
                ["Offset of field: GkAtoms::cosh_string"]
                    [::std::mem::offset_of!(GkAtoms, cosh_string) - 36666usize];
                ["Offset of field: GkAtoms::cot_string"]
                    [::std::mem::offset_of!(GkAtoms, cot_string) - 36676usize];
                ["Offset of field: GkAtoms::coth_string"]
                    [::std::mem::offset_of!(GkAtoms, coth_string) - 36684usize];
                ["Offset of field: GkAtoms::crossout_string"]
                    [::std::mem::offset_of!(GkAtoms, crossout_string) - 36694usize];
                ["Offset of field: GkAtoms::csc_string"]
                    [::std::mem::offset_of!(GkAtoms, csc_string) - 36712usize];
                ["Offset of field: GkAtoms::csch_string"]
                    [::std::mem::offset_of!(GkAtoms, csch_string) - 36720usize];
                ["Offset of field: GkAtoms::cs_string"]
                    [::std::mem::offset_of!(GkAtoms, cs_string) - 36730usize];
                ["Offset of field: GkAtoms::csymbol_string"]
                    [::std::mem::offset_of!(GkAtoms, csymbol_string) - 36736usize];
                ["Offset of field: GkAtoms::csp_string"]
                    [::std::mem::offset_of!(GkAtoms, csp_string) - 36752usize];
                ["Offset of field: GkAtoms::cspViolation_string"]
                    [::std::mem::offset_of!(GkAtoms, cspViolation_string) - 36760usize];
                ["Offset of field: GkAtoms::curl_string"]
                    [::std::mem::offset_of!(GkAtoms, curl_string) - 36788usize];
                ["Offset of field: GkAtoms::decimalpoint_string"]
                    [::std::mem::offset_of!(GkAtoms, decimalpoint_string) - 36798usize];
                ["Offset of field: GkAtoms::definition_string"]
                    [::std::mem::offset_of!(GkAtoms, definition_string) - 36824usize];
                ["Offset of field: GkAtoms::definitionURL_string"]
                    [::std::mem::offset_of!(GkAtoms, definitionURL_string) - 36846usize];
                ["Offset of field: GkAtoms::degree_string"]
                    [::std::mem::offset_of!(GkAtoms, degree_string) - 36874usize];
                ["Offset of field: GkAtoms::denomalign_string"]
                    [::std::mem::offset_of!(GkAtoms, denomalign_string) - 36888usize];
                ["Offset of field: GkAtoms::depth_string"]
                    [::std::mem::offset_of!(GkAtoms, depth_string) - 36910usize];
                ["Offset of field: GkAtoms::determinant_string"]
                    [::std::mem::offset_of!(GkAtoms, determinant_string) - 36922usize];
                ["Offset of field: GkAtoms::diff_string"]
                    [::std::mem::offset_of!(GkAtoms, diff_string) - 36946usize];
                ["Offset of field: GkAtoms::displaystyle_string"]
                    [::std::mem::offset_of!(GkAtoms, displaystyle_string) - 36956usize];
                ["Offset of field: GkAtoms::divergence_string"]
                    [::std::mem::offset_of!(GkAtoms, divergence_string) - 36982usize];
                ["Offset of field: GkAtoms::divide_string"]
                    [::std::mem::offset_of!(GkAtoms, divide_string) - 37004usize];
                ["Offset of field: GkAtoms::dom_viewTransitions_enabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    dom_viewTransitions_enabled_string
                ) - 37018usize];
                ["Offset of field: GkAtoms::domain_string"]
                    [::std::mem::offset_of!(GkAtoms, domain_string) - 37074usize];
                ["Offset of field: GkAtoms::domainofapplication_string"]
                    [::std::mem::offset_of!(GkAtoms, domainofapplication_string) - 37088usize];
                ["Offset of field: GkAtoms::edge_string"]
                    [::std::mem::offset_of!(GkAtoms, edge_string) - 37128usize];
                ["Offset of field: GkAtoms::el_string"]
                    [::std::mem::offset_of!(GkAtoms, el_string) - 37138usize];
                ["Offset of field: GkAtoms::emptyset_string"]
                    [::std::mem::offset_of!(GkAtoms, emptyset_string) - 37144usize];
                ["Offset of field: GkAtoms::eq_string"]
                    [::std::mem::offset_of!(GkAtoms, eq_string) - 37162usize];
                ["Offset of field: GkAtoms::equalcolumns_string"]
                    [::std::mem::offset_of!(GkAtoms, equalcolumns_string) - 37168usize];
                ["Offset of field: GkAtoms::equalrows_string"]
                    [::std::mem::offset_of!(GkAtoms, equalrows_string) - 37194usize];
                ["Offset of field: GkAtoms::equivalent_string"]
                    [::std::mem::offset_of!(GkAtoms, equivalent_string) - 37214usize];
                ["Offset of field: GkAtoms::eulergamma_string"]
                    [::std::mem::offset_of!(GkAtoms, eulergamma_string) - 37236usize];
                ["Offset of field: GkAtoms::exists_string"]
                    [::std::mem::offset_of!(GkAtoms, exists_string) - 37258usize];
                ["Offset of field: GkAtoms::exp_string"]
                    [::std::mem::offset_of!(GkAtoms, exp_string) - 37272usize];
                ["Offset of field: GkAtoms::exponentiale_string"]
                    [::std::mem::offset_of!(GkAtoms, exponentiale_string) - 37280usize];
                ["Offset of field: GkAtoms::factorial_string"]
                    [::std::mem::offset_of!(GkAtoms, factorial_string) - 37306usize];
                ["Offset of field: GkAtoms::factorof_string"]
                    [::std::mem::offset_of!(GkAtoms, factorof_string) - 37326usize];
                ["Offset of field: GkAtoms::fence_string"]
                    [::std::mem::offset_of!(GkAtoms, fence_string) - 37344usize];
                ["Offset of field: GkAtoms::fn_string"]
                    [::std::mem::offset_of!(GkAtoms, fn_string) - 37356usize];
                ["Offset of field: GkAtoms::fontfamily_string"]
                    [::std::mem::offset_of!(GkAtoms, fontfamily_string) - 37362usize];
                ["Offset of field: GkAtoms::fontsize_string"]
                    [::std::mem::offset_of!(GkAtoms, fontsize_string) - 37384usize];
                ["Offset of field: GkAtoms::fontstyle_string"]
                    [::std::mem::offset_of!(GkAtoms, fontstyle_string) - 37402usize];
                ["Offset of field: GkAtoms::fontweight_string"]
                    [::std::mem::offset_of!(GkAtoms, fontweight_string) - 37422usize];
                ["Offset of field: GkAtoms::forall_string"]
                    [::std::mem::offset_of!(GkAtoms, forall_string) - 37444usize];
                ["Offset of field: GkAtoms::framespacing_string"]
                    [::std::mem::offset_of!(GkAtoms, framespacing_string) - 37458usize];
                ["Offset of field: GkAtoms::gcd_string"]
                    [::std::mem::offset_of!(GkAtoms, gcd_string) - 37484usize];
                ["Offset of field: GkAtoms::geq_string"]
                    [::std::mem::offset_of!(GkAtoms, geq_string) - 37492usize];
                ["Offset of field: GkAtoms::groupalign_string"]
                    [::std::mem::offset_of!(GkAtoms, groupalign_string) - 37500usize];
                ["Offset of field: GkAtoms::gt_string"]
                    [::std::mem::offset_of!(GkAtoms, gt_string) - 37522usize];
                ["Offset of field: GkAtoms::ident_string"]
                    [::std::mem::offset_of!(GkAtoms, ident_string) - 37528usize];
                ["Offset of field: GkAtoms::imaginaryi_string"]
                    [::std::mem::offset_of!(GkAtoms, imaginaryi_string) - 37540usize];
                ["Offset of field: GkAtoms::imaginary_string"]
                    [::std::mem::offset_of!(GkAtoms, imaginary_string) - 37562usize];
                ["Offset of field: GkAtoms::implies_string"]
                    [::std::mem::offset_of!(GkAtoms, implies_string) - 37582usize];
                ["Offset of field: GkAtoms::indentalignfirst_string"]
                    [::std::mem::offset_of!(GkAtoms, indentalignfirst_string) - 37598usize];
                ["Offset of field: GkAtoms::indentalign_string"]
                    [::std::mem::offset_of!(GkAtoms, indentalign_string) - 37632usize];
                ["Offset of field: GkAtoms::indentalignlast_string"]
                    [::std::mem::offset_of!(GkAtoms, indentalignlast_string) - 37656usize];
                ["Offset of field: GkAtoms::indentshiftfirst_string"]
                    [::std::mem::offset_of!(GkAtoms, indentshiftfirst_string) - 37688usize];
                ["Offset of field: GkAtoms::indentshift_string"]
                    [::std::mem::offset_of!(GkAtoms, indentshift_string) - 37722usize];
                ["Offset of field: GkAtoms::indenttarget_string"]
                    [::std::mem::offset_of!(GkAtoms, indenttarget_string) - 37746usize];
                ["Offset of field: GkAtoms::integers_string"]
                    [::std::mem::offset_of!(GkAtoms, integers_string) - 37772usize];
                ["Offset of field: GkAtoms::intersect_string"]
                    [::std::mem::offset_of!(GkAtoms, intersect_string) - 37790usize];
                ["Offset of field: GkAtoms::interval_string"]
                    [::std::mem::offset_of!(GkAtoms, interval_string) - 37810usize];
                ["Offset of field: GkAtoms::int__string"]
                    [::std::mem::offset_of!(GkAtoms, int__string) - 37828usize];
                ["Offset of field: GkAtoms::inverse_string"]
                    [::std::mem::offset_of!(GkAtoms, inverse_string) - 37836usize];
                ["Offset of field: GkAtoms::lambda_string"]
                    [::std::mem::offset_of!(GkAtoms, lambda_string) - 37852usize];
                ["Offset of field: GkAtoms::laplacian_string"]
                    [::std::mem::offset_of!(GkAtoms, laplacian_string) - 37866usize];
                ["Offset of field: GkAtoms::largeop_string"]
                    [::std::mem::offset_of!(GkAtoms, largeop_string) - 37886usize];
                ["Offset of field: GkAtoms::lcm_string"]
                    [::std::mem::offset_of!(GkAtoms, lcm_string) - 37902usize];
                ["Offset of field: GkAtoms::leq_string"]
                    [::std::mem::offset_of!(GkAtoms, leq_string) - 37910usize];
                ["Offset of field: GkAtoms::limit_string"]
                    [::std::mem::offset_of!(GkAtoms, limit_string) - 37918usize];
                ["Offset of field: GkAtoms::linebreak_string"]
                    [::std::mem::offset_of!(GkAtoms, linebreak_string) - 37930usize];
                ["Offset of field: GkAtoms::linebreakmultchar_string"]
                    [::std::mem::offset_of!(GkAtoms, linebreakmultchar_string) - 37950usize];
                ["Offset of field: GkAtoms::linebreakstyle_string"]
                    [::std::mem::offset_of!(GkAtoms, linebreakstyle_string) - 37986usize];
                ["Offset of field: GkAtoms::linethickness_string"]
                    [::std::mem::offset_of!(GkAtoms, linethickness_string) - 38016usize];
                ["Offset of field: GkAtoms::list_string"]
                    [::std::mem::offset_of!(GkAtoms, list_string) - 38044usize];
                ["Offset of field: GkAtoms::ln_string"]
                    [::std::mem::offset_of!(GkAtoms, ln_string) - 38054usize];
                ["Offset of field: GkAtoms::location_string"]
                    [::std::mem::offset_of!(GkAtoms, location_string) - 38060usize];
                ["Offset of field: GkAtoms::logbase_string"]
                    [::std::mem::offset_of!(GkAtoms, logbase_string) - 38078usize];
                ["Offset of field: GkAtoms::log_string"]
                    [::std::mem::offset_of!(GkAtoms, log_string) - 38094usize];
                ["Offset of field: GkAtoms::longdivstyle_string"]
                    [::std::mem::offset_of!(GkAtoms, longdivstyle_string) - 38102usize];
                ["Offset of field: GkAtoms::lowlimit_string"]
                    [::std::mem::offset_of!(GkAtoms, lowlimit_string) - 38128usize];
                ["Offset of field: GkAtoms::lquote_string"]
                    [::std::mem::offset_of!(GkAtoms, lquote_string) - 38146usize];
                ["Offset of field: GkAtoms::lspace_string"]
                    [::std::mem::offset_of!(GkAtoms, lspace_string) - 38160usize];
                ["Offset of field: GkAtoms::lt_string"]
                    [::std::mem::offset_of!(GkAtoms, lt_string) - 38174usize];
                ["Offset of field: GkAtoms::maction_string"]
                    [::std::mem::offset_of!(GkAtoms, maction_string) - 38180usize];
                ["Offset of field: GkAtoms::maligngroup_string"]
                    [::std::mem::offset_of!(GkAtoms, maligngroup_string) - 38196usize];
                ["Offset of field: GkAtoms::malignmark_string"]
                    [::std::mem::offset_of!(GkAtoms, malignmark_string) - 38220usize];
                ["Offset of field: GkAtoms::mathbackground_string"]
                    [::std::mem::offset_of!(GkAtoms, mathbackground_string) - 38242usize];
                ["Offset of field: GkAtoms::mathcolor_string"]
                    [::std::mem::offset_of!(GkAtoms, mathcolor_string) - 38272usize];
                ["Offset of field: GkAtoms::mathsize_string"]
                    [::std::mem::offset_of!(GkAtoms, mathsize_string) - 38292usize];
                ["Offset of field: GkAtoms::mathvariant_string"]
                    [::std::mem::offset_of!(GkAtoms, mathvariant_string) - 38310usize];
                ["Offset of field: GkAtoms::matrixrow_string"]
                    [::std::mem::offset_of!(GkAtoms, matrixrow_string) - 38334usize];
                ["Offset of field: GkAtoms::maxsize_string"]
                    [::std::mem::offset_of!(GkAtoms, maxsize_string) - 38354usize];
                ["Offset of field: GkAtoms::mean_string"]
                    [::std::mem::offset_of!(GkAtoms, mean_string) - 38370usize];
                ["Offset of field: GkAtoms::median_string"]
                    [::std::mem::offset_of!(GkAtoms, median_string) - 38380usize];
                ["Offset of field: GkAtoms::menclose_string"]
                    [::std::mem::offset_of!(GkAtoms, menclose_string) - 38394usize];
                ["Offset of field: GkAtoms::merror_string"]
                    [::std::mem::offset_of!(GkAtoms, merror_string) - 38412usize];
                ["Offset of field: GkAtoms::mfenced_string"]
                    [::std::mem::offset_of!(GkAtoms, mfenced_string) - 38426usize];
                ["Offset of field: GkAtoms::mfrac_string"]
                    [::std::mem::offset_of!(GkAtoms, mfrac_string) - 38442usize];
                ["Offset of field: GkAtoms::mglyph_string"]
                    [::std::mem::offset_of!(GkAtoms, mglyph_string) - 38454usize];
                ["Offset of field: GkAtoms::mi_string"]
                    [::std::mem::offset_of!(GkAtoms, mi_string) - 38468usize];
                ["Offset of field: GkAtoms::minlabelspacing_string"]
                    [::std::mem::offset_of!(GkAtoms, minlabelspacing_string) - 38474usize];
                ["Offset of field: GkAtoms::minsize_string"]
                    [::std::mem::offset_of!(GkAtoms, minsize_string) - 38506usize];
                ["Offset of field: GkAtoms::minus_string"]
                    [::std::mem::offset_of!(GkAtoms, minus_string) - 38522usize];
                ["Offset of field: GkAtoms::mlabeledtr_string"]
                    [::std::mem::offset_of!(GkAtoms, mlabeledtr_string) - 38534usize];
                ["Offset of field: GkAtoms::mlongdiv_string"]
                    [::std::mem::offset_of!(GkAtoms, mlongdiv_string) - 38556usize];
                ["Offset of field: GkAtoms::mmultiscripts_string"]
                    [::std::mem::offset_of!(GkAtoms, mmultiscripts_string) - 38574usize];
                ["Offset of field: GkAtoms::mn_string"]
                    [::std::mem::offset_of!(GkAtoms, mn_string) - 38602usize];
                ["Offset of field: GkAtoms::momentabout_string"]
                    [::std::mem::offset_of!(GkAtoms, momentabout_string) - 38608usize];
                ["Offset of field: GkAtoms::moment_string"]
                    [::std::mem::offset_of!(GkAtoms, moment_string) - 38632usize];
                ["Offset of field: GkAtoms::mo_string"]
                    [::std::mem::offset_of!(GkAtoms, mo_string) - 38646usize];
                ["Offset of field: GkAtoms::movablelimits_string"]
                    [::std::mem::offset_of!(GkAtoms, movablelimits_string) - 38652usize];
                ["Offset of field: GkAtoms::mover_string"]
                    [::std::mem::offset_of!(GkAtoms, mover_string) - 38680usize];
                ["Offset of field: GkAtoms::mpadded_string"]
                    [::std::mem::offset_of!(GkAtoms, mpadded_string) - 38692usize];
                ["Offset of field: GkAtoms::mphantom_string"]
                    [::std::mem::offset_of!(GkAtoms, mphantom_string) - 38708usize];
                ["Offset of field: GkAtoms::mprescripts_string"]
                    [::std::mem::offset_of!(GkAtoms, mprescripts_string) - 38726usize];
                ["Offset of field: GkAtoms::mroot_string"]
                    [::std::mem::offset_of!(GkAtoms, mroot_string) - 38750usize];
                ["Offset of field: GkAtoms::mrow_string"]
                    [::std::mem::offset_of!(GkAtoms, mrow_string) - 38762usize];
                ["Offset of field: GkAtoms::mscarries_string"]
                    [::std::mem::offset_of!(GkAtoms, mscarries_string) - 38772usize];
                ["Offset of field: GkAtoms::mscarry_string"]
                    [::std::mem::offset_of!(GkAtoms, mscarry_string) - 38792usize];
                ["Offset of field: GkAtoms::msgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, msgroup_string) - 38808usize];
                ["Offset of field: GkAtoms::msline_string"]
                    [::std::mem::offset_of!(GkAtoms, msline_string) - 38824usize];
                ["Offset of field: GkAtoms::ms_string"]
                    [::std::mem::offset_of!(GkAtoms, ms_string) - 38838usize];
                ["Offset of field: GkAtoms::mspace_string"]
                    [::std::mem::offset_of!(GkAtoms, mspace_string) - 38844usize];
                ["Offset of field: GkAtoms::msqrt_string"]
                    [::std::mem::offset_of!(GkAtoms, msqrt_string) - 38858usize];
                ["Offset of field: GkAtoms::msrow_string"]
                    [::std::mem::offset_of!(GkAtoms, msrow_string) - 38870usize];
                ["Offset of field: GkAtoms::mstack_string"]
                    [::std::mem::offset_of!(GkAtoms, mstack_string) - 38882usize];
                ["Offset of field: GkAtoms::mstyle_string"]
                    [::std::mem::offset_of!(GkAtoms, mstyle_string) - 38896usize];
                ["Offset of field: GkAtoms::msub_string"]
                    [::std::mem::offset_of!(GkAtoms, msub_string) - 38910usize];
                ["Offset of field: GkAtoms::msubsup_string"]
                    [::std::mem::offset_of!(GkAtoms, msubsup_string) - 38920usize];
                ["Offset of field: GkAtoms::msup_string"]
                    [::std::mem::offset_of!(GkAtoms, msup_string) - 38936usize];
                ["Offset of field: GkAtoms::mtable_string"]
                    [::std::mem::offset_of!(GkAtoms, mtable_string) - 38946usize];
                ["Offset of field: GkAtoms::mtd_string"]
                    [::std::mem::offset_of!(GkAtoms, mtd_string) - 38960usize];
                ["Offset of field: GkAtoms::mtext_string"]
                    [::std::mem::offset_of!(GkAtoms, mtext_string) - 38968usize];
                ["Offset of field: GkAtoms::mtr_string"]
                    [::std::mem::offset_of!(GkAtoms, mtr_string) - 38980usize];
                ["Offset of field: GkAtoms::munder_string"]
                    [::std::mem::offset_of!(GkAtoms, munder_string) - 38988usize];
                ["Offset of field: GkAtoms::munderover_string"]
                    [::std::mem::offset_of!(GkAtoms, munderover_string) - 39002usize];
                ["Offset of field: GkAtoms::naturalnumbers_string"]
                    [::std::mem::offset_of!(GkAtoms, naturalnumbers_string) - 39024usize];
                ["Offset of field: GkAtoms::neq_string"]
                    [::std::mem::offset_of!(GkAtoms, neq_string) - 39054usize];
                ["Offset of field: GkAtoms::notanumber_string"]
                    [::std::mem::offset_of!(GkAtoms, notanumber_string) - 39062usize];
                ["Offset of field: GkAtoms::notation_string"]
                    [::std::mem::offset_of!(GkAtoms, notation_string) - 39084usize];
                ["Offset of field: GkAtoms::note_string"]
                    [::std::mem::offset_of!(GkAtoms, note_string) - 39102usize];
                ["Offset of field: GkAtoms::notin_string"]
                    [::std::mem::offset_of!(GkAtoms, notin_string) - 39112usize];
                ["Offset of field: GkAtoms::notprsubset_string"]
                    [::std::mem::offset_of!(GkAtoms, notprsubset_string) - 39124usize];
                ["Offset of field: GkAtoms::notsubset_string"]
                    [::std::mem::offset_of!(GkAtoms, notsubset_string) - 39148usize];
                ["Offset of field: GkAtoms::numalign_string"]
                    [::std::mem::offset_of!(GkAtoms, numalign_string) - 39168usize];
                ["Offset of field: GkAtoms::other_string"]
                    [::std::mem::offset_of!(GkAtoms, other_string) - 39186usize];
                ["Offset of field: GkAtoms::outerproduct_string"]
                    [::std::mem::offset_of!(GkAtoms, outerproduct_string) - 39198usize];
                ["Offset of field: GkAtoms::partialdiff_string"]
                    [::std::mem::offset_of!(GkAtoms, partialdiff_string) - 39224usize];
                ["Offset of field: GkAtoms::piece_string"]
                    [::std::mem::offset_of!(GkAtoms, piece_string) - 39248usize];
                ["Offset of field: GkAtoms::piecewise_string"]
                    [::std::mem::offset_of!(GkAtoms, piecewise_string) - 39260usize];
                ["Offset of field: GkAtoms::pi_string"]
                    [::std::mem::offset_of!(GkAtoms, pi_string) - 39280usize];
                ["Offset of field: GkAtoms::plus_string"]
                    [::std::mem::offset_of!(GkAtoms, plus_string) - 39286usize];
                ["Offset of field: GkAtoms::power_string"]
                    [::std::mem::offset_of!(GkAtoms, power_string) - 39296usize];
                ["Offset of field: GkAtoms::primes_string"]
                    [::std::mem::offset_of!(GkAtoms, primes_string) - 39308usize];
                ["Offset of field: GkAtoms::product_string"]
                    [::std::mem::offset_of!(GkAtoms, product_string) - 39322usize];
                ["Offset of field: GkAtoms::prsubset_string"]
                    [::std::mem::offset_of!(GkAtoms, prsubset_string) - 39338usize];
                ["Offset of field: GkAtoms::quotient_string"]
                    [::std::mem::offset_of!(GkAtoms, quotient_string) - 39356usize];
                ["Offset of field: GkAtoms::rationals_string"]
                    [::std::mem::offset_of!(GkAtoms, rationals_string) - 39374usize];
                ["Offset of field: GkAtoms::real_string"]
                    [::std::mem::offset_of!(GkAtoms, real_string) - 39394usize];
                ["Offset of field: GkAtoms::reals_string"]
                    [::std::mem::offset_of!(GkAtoms, reals_string) - 39404usize];
                ["Offset of field: GkAtoms::reln_string"]
                    [::std::mem::offset_of!(GkAtoms, reln_string) - 39416usize];
                ["Offset of field: GkAtoms::root_string"]
                    [::std::mem::offset_of!(GkAtoms, root_string) - 39426usize];
                ["Offset of field: GkAtoms::rowalign_string"]
                    [::std::mem::offset_of!(GkAtoms, rowalign_string) - 39436usize];
                ["Offset of field: GkAtoms::rowlines_string"]
                    [::std::mem::offset_of!(GkAtoms, rowlines_string) - 39454usize];
                ["Offset of field: GkAtoms::rowspacing_string"]
                    [::std::mem::offset_of!(GkAtoms, rowspacing_string) - 39472usize];
                ["Offset of field: GkAtoms::rquote_string"]
                    [::std::mem::offset_of!(GkAtoms, rquote_string) - 39494usize];
                ["Offset of field: GkAtoms::rspace_string"]
                    [::std::mem::offset_of!(GkAtoms, rspace_string) - 39508usize];
                ["Offset of field: GkAtoms::scalarproduct_string"]
                    [::std::mem::offset_of!(GkAtoms, scalarproduct_string) - 39522usize];
                ["Offset of field: GkAtoms::schemaLocation_string"]
                    [::std::mem::offset_of!(GkAtoms, schemaLocation_string) - 39550usize];
                ["Offset of field: GkAtoms::scriptlevel_string"]
                    [::std::mem::offset_of!(GkAtoms, scriptlevel_string) - 39580usize];
                ["Offset of field: GkAtoms::scriptminsize_string"]
                    [::std::mem::offset_of!(GkAtoms, scriptminsize_string) - 39604usize];
                ["Offset of field: GkAtoms::scriptsizemultiplier_string"]
                    [::std::mem::offset_of!(GkAtoms, scriptsizemultiplier_string) - 39632usize];
                ["Offset of field: GkAtoms::scriptsize_string"]
                    [::std::mem::offset_of!(GkAtoms, scriptsize_string) - 39674usize];
                ["Offset of field: GkAtoms::sdev_string"]
                    [::std::mem::offset_of!(GkAtoms, sdev_string) - 39696usize];
                ["Offset of field: GkAtoms::sech_string"]
                    [::std::mem::offset_of!(GkAtoms, sech_string) - 39706usize];
                ["Offset of field: GkAtoms::sec_string"]
                    [::std::mem::offset_of!(GkAtoms, sec_string) - 39716usize];
                ["Offset of field: GkAtoms::selection_string"]
                    [::std::mem::offset_of!(GkAtoms, selection_string) - 39724usize];
                ["Offset of field: GkAtoms::selector_string"]
                    [::std::mem::offset_of!(GkAtoms, selector_string) - 39744usize];
                ["Offset of field: GkAtoms::semantics_string"]
                    [::std::mem::offset_of!(GkAtoms, semantics_string) - 39762usize];
                ["Offset of field: GkAtoms::separator_string"]
                    [::std::mem::offset_of!(GkAtoms, separator_string) - 39782usize];
                ["Offset of field: GkAtoms::separators_string"]
                    [::std::mem::offset_of!(GkAtoms, separators_string) - 39802usize];
                ["Offset of field: GkAtoms::sep_string"]
                    [::std::mem::offset_of!(GkAtoms, sep_string) - 39824usize];
                ["Offset of field: GkAtoms::setdiff_string"]
                    [::std::mem::offset_of!(GkAtoms, setdiff_string) - 39832usize];
                ["Offset of field: GkAtoms::share_string"]
                    [::std::mem::offset_of!(GkAtoms, share_string) - 39848usize];
                ["Offset of field: GkAtoms::shift_string"]
                    [::std::mem::offset_of!(GkAtoms, shift_string) - 39860usize];
                ["Offset of field: GkAtoms::side_string"]
                    [::std::mem::offset_of!(GkAtoms, side_string) - 39872usize];
                ["Offset of field: GkAtoms::sinh_string"]
                    [::std::mem::offset_of!(GkAtoms, sinh_string) - 39882usize];
                ["Offset of field: GkAtoms::sin_string"]
                    [::std::mem::offset_of!(GkAtoms, sin_string) - 39892usize];
                ["Offset of field: GkAtoms::stackalign_string"]
                    [::std::mem::offset_of!(GkAtoms, stackalign_string) - 39900usize];
                ["Offset of field: GkAtoms::stretchy_string"]
                    [::std::mem::offset_of!(GkAtoms, stretchy_string) - 39922usize];
                ["Offset of field: GkAtoms::subscriptshift_string"]
                    [::std::mem::offset_of!(GkAtoms, subscriptshift_string) - 39940usize];
                ["Offset of field: GkAtoms::subset_string"]
                    [::std::mem::offset_of!(GkAtoms, subset_string) - 39970usize];
                ["Offset of field: GkAtoms::superscriptshift_string"]
                    [::std::mem::offset_of!(GkAtoms, superscriptshift_string) - 39984usize];
                ["Offset of field: GkAtoms::symmetric_string"]
                    [::std::mem::offset_of!(GkAtoms, symmetric_string) - 40018usize];
                ["Offset of field: GkAtoms::tanh_string"]
                    [::std::mem::offset_of!(GkAtoms, tanh_string) - 40038usize];
                ["Offset of field: GkAtoms::tan_string"]
                    [::std::mem::offset_of!(GkAtoms, tan_string) - 40048usize];
                ["Offset of field: GkAtoms::tendsto_string"]
                    [::std::mem::offset_of!(GkAtoms, tendsto_string) - 40056usize];
                ["Offset of field: GkAtoms::times_string"]
                    [::std::mem::offset_of!(GkAtoms, times_string) - 40072usize];
                ["Offset of field: GkAtoms::transpose_string"]
                    [::std::mem::offset_of!(GkAtoms, transpose_string) - 40084usize];
                ["Offset of field: GkAtoms::union__string"]
                    [::std::mem::offset_of!(GkAtoms, union__string) - 40104usize];
                ["Offset of field: GkAtoms::uplimit_string"]
                    [::std::mem::offset_of!(GkAtoms, uplimit_string) - 40116usize];
                ["Offset of field: GkAtoms::variance_string"]
                    [::std::mem::offset_of!(GkAtoms, variance_string) - 40132usize];
                ["Offset of field: GkAtoms::vectorproduct_string"]
                    [::std::mem::offset_of!(GkAtoms, vectorproduct_string) - 40150usize];
                ["Offset of field: GkAtoms::vector_string"]
                    [::std::mem::offset_of!(GkAtoms, vector_string) - 40178usize];
                ["Offset of field: GkAtoms::voffset_string"]
                    [::std::mem::offset_of!(GkAtoms, voffset_string) - 40192usize];
                ["Offset of field: GkAtoms::xref_string"]
                    [::std::mem::offset_of!(GkAtoms, xref_string) - 40208usize];
                ["Offset of field: GkAtoms::math_string"]
                    [::std::mem::offset_of!(GkAtoms, math_string) - 40218usize];
                ["Offset of field: GkAtoms::booleanFromString_string"]
                    [::std::mem::offset_of!(GkAtoms, booleanFromString_string) - 40228usize];
                ["Offset of field: GkAtoms::countNonEmpty_string"]
                    [::std::mem::offset_of!(GkAtoms, countNonEmpty_string) - 40268usize];
                ["Offset of field: GkAtoms::daysFromDate_string"]
                    [::std::mem::offset_of!(GkAtoms, daysFromDate_string) - 40300usize];
                ["Offset of field: GkAtoms::secondsFromDateTime_string"]
                    [::std::mem::offset_of!(GkAtoms, secondsFromDateTime_string) - 40330usize];
                ["Offset of field: GkAtoms::tabbrowser_arrowscrollbox_string"][::std::mem::offset_of!(
                    GkAtoms,
                    tabbrowser_arrowscrollbox_string
                ) - 40374usize];
                ["Offset of field: GkAtoms::onMozSwipeGestureMayStart_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozSwipeGestureMayStart_string
                ) - 40426usize];
                ["Offset of field: GkAtoms::onMozSwipeGestureStart_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozSwipeGestureStart_string) - 40478usize];
                ["Offset of field: GkAtoms::onMozSwipeGestureUpdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozSwipeGestureUpdate_string) - 40524usize];
                ["Offset of field: GkAtoms::onMozSwipeGestureEnd_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozSwipeGestureEnd_string) - 40572usize];
                ["Offset of field: GkAtoms::onMozSwipeGesture_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozSwipeGesture_string) - 40614usize];
                ["Offset of field: GkAtoms::onMozMagnifyGestureStart_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozMagnifyGestureStart_string) - 40650usize];
                ["Offset of field: GkAtoms::onMozMagnifyGestureUpdate_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozMagnifyGestureUpdate_string
                ) - 40700usize];
                ["Offset of field: GkAtoms::onMozMagnifyGesture_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozMagnifyGesture_string) - 40752usize];
                ["Offset of field: GkAtoms::onMozRotateGestureStart_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozRotateGestureStart_string) - 40792usize];
                ["Offset of field: GkAtoms::onMozRotateGestureUpdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozRotateGestureUpdate_string) - 40840usize];
                ["Offset of field: GkAtoms::onMozRotateGesture_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozRotateGesture_string) - 40890usize];
                ["Offset of field: GkAtoms::onMozTapGesture_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozTapGesture_string) - 40928usize];
                ["Offset of field: GkAtoms::onMozPressTapGesture_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozPressTapGesture_string) - 40960usize];
                ["Offset of field: GkAtoms::onMozEdgeUIStarted_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozEdgeUIStarted_string) - 41002usize];
                ["Offset of field: GkAtoms::onMozEdgeUICanceled_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozEdgeUICanceled_string) - 41040usize];
                ["Offset of field: GkAtoms::onMozEdgeUICompleted_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozEdgeUICompleted_string) - 41080usize];
                ["Offset of field: GkAtoms::onpointerdown_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerdown_string) - 41122usize];
                ["Offset of field: GkAtoms::onpointermove_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointermove_string) - 41150usize];
                ["Offset of field: GkAtoms::onpointerup_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerup_string) - 41178usize];
                ["Offset of field: GkAtoms::onpointercancel_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointercancel_string) - 41202usize];
                ["Offset of field: GkAtoms::onpointerover_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerover_string) - 41234usize];
                ["Offset of field: GkAtoms::onpointerout_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerout_string) - 41262usize];
                ["Offset of field: GkAtoms::onpointerenter_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerenter_string) - 41288usize];
                ["Offset of field: GkAtoms::onpointerleave_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerleave_string) - 41318usize];
                ["Offset of field: GkAtoms::onpointerrawupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onpointerrawupdate_string) - 41348usize];
                ["Offset of field: GkAtoms::ongotpointercapture_string"]
                    [::std::mem::offset_of!(GkAtoms, ongotpointercapture_string) - 41386usize];
                ["Offset of field: GkAtoms::onlostpointercapture_string"]
                    [::std::mem::offset_of!(GkAtoms, onlostpointercapture_string) - 41426usize];
                ["Offset of field: GkAtoms::ondevicemotion_string"]
                    [::std::mem::offset_of!(GkAtoms, ondevicemotion_string) - 41468usize];
                ["Offset of field: GkAtoms::ondeviceorientation_string"]
                    [::std::mem::offset_of!(GkAtoms, ondeviceorientation_string) - 41498usize];
                ["Offset of field: GkAtoms::ondeviceorientationabsolute_string"][::std::mem::offset_of!(
                    GkAtoms,
                    ondeviceorientationabsolute_string
                ) - 41538usize];
                ["Offset of field: GkAtoms::onmozorientationchange_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozorientationchange_string) - 41594usize];
                ["Offset of field: GkAtoms::onuserproximity_string"]
                    [::std::mem::offset_of!(GkAtoms, onuserproximity_string) - 41640usize];
                ["Offset of field: GkAtoms::ondevicelight_string"]
                    [::std::mem::offset_of!(GkAtoms, ondevicelight_string) - 41672usize];
                ["Offset of field: GkAtoms::ondevicechange_string"]
                    [::std::mem::offset_of!(GkAtoms, ondevicechange_string) - 41700usize];
                ["Offset of field: GkAtoms::onrtctransform_string"]
                    [::std::mem::offset_of!(GkAtoms, onrtctransform_string) - 41730usize];
                ["Offset of field: GkAtoms::onmozvisualresize_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozvisualresize_string) - 41760usize];
                ["Offset of field: GkAtoms::onmozvisualscroll_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozvisualscroll_string) - 41796usize];
                ["Offset of field: GkAtoms::onDOMContentLoaded_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMContentLoaded_string) - 41832usize];
                ["Offset of field: GkAtoms::onDOMDocElementInserted_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMDocElementInserted_string) - 41870usize];
                ["Offset of field: GkAtoms::onDOMFormBeforeSubmit_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMFormBeforeSubmit_string) - 41918usize];
                ["Offset of field: GkAtoms::onDOMFormHasPassword_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMFormHasPassword_string) - 41962usize];
                ["Offset of field: GkAtoms::onDOMFrameContentLoaded_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMFrameContentLoaded_string) - 42004usize];
                ["Offset of field: GkAtoms::onDOMHeadElementParsed_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMHeadElementParsed_string) - 42052usize];
                ["Offset of field: GkAtoms::onDOMInputPasswordAdded_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMInputPasswordAdded_string) - 42098usize];
                ["Offset of field: GkAtoms::onDOMLinkAdded_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMLinkAdded_string) - 42146usize];
                ["Offset of field: GkAtoms::onDOMLinkChanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMLinkChanged_string) - 42176usize];
                ["Offset of field: GkAtoms::onDOMMetaAdded_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMMetaAdded_string) - 42210usize];
                ["Offset of field: GkAtoms::onDOMMetaChanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMMetaChanged_string) - 42240usize];
                ["Offset of field: GkAtoms::onDOMMetaRemoved_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMMetaRemoved_string) - 42274usize];
                ["Offset of field: GkAtoms::onDOMPopupBlocked_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMPopupBlocked_string) - 42308usize];
                ["Offset of field: GkAtoms::onDOMTitleChanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMTitleChanged_string) - 42344usize];
                ["Offset of field: GkAtoms::onDOMWindowClose_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMWindowClose_string) - 42380usize];
                ["Offset of field: GkAtoms::onDOMWindowCreated_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMWindowCreated_string) - 42414usize];
                ["Offset of field: GkAtoms::onDOMWindowFocus_string"]
                    [::std::mem::offset_of!(GkAtoms, onDOMWindowFocus_string) - 42452usize];
                ["Offset of field: GkAtoms::onFullZoomChange_string"]
                    [::std::mem::offset_of!(GkAtoms, onFullZoomChange_string) - 42486usize];
                ["Offset of field: GkAtoms::onGloballyAutoplayBlocked_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onGloballyAutoplayBlocked_string
                ) - 42520usize];
                ["Offset of field: GkAtoms::onMozDOMFullscreen_Entered_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMFullscreen_Entered_string
                ) - 42572usize];
                ["Offset of field: GkAtoms::onMozDOMFullscreen_Exit_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozDOMFullscreen_Exit_string) - 42626usize];
                ["Offset of field: GkAtoms::onMozDOMFullscreen_Exited_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMFullscreen_Exited_string
                ) - 42674usize];
                ["Offset of field: GkAtoms::onMozDOMFullscreen_NewOrigin_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMFullscreen_NewOrigin_string
                ) - 42726usize];
                ["Offset of field: GkAtoms::onMozDOMFullscreen_Request_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMFullscreen_Request_string
                ) - 42784usize];
                ["Offset of field: GkAtoms::onMozDOMPointerLock_Entered_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMPointerLock_Entered_string
                ) - 42838usize];
                ["Offset of field: GkAtoms::onMozDOMPointerLock_Exited_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozDOMPointerLock_Exited_string
                ) - 42894usize];
                ["Offset of field: GkAtoms::onMozInvalidForm_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozInvalidForm_string) - 42948usize];
                ["Offset of field: GkAtoms::onMozLocalStorageChanged_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozLocalStorageChanged_string) - 42982usize];
                ["Offset of field: GkAtoms::onMozOpenDateTimePicker_string"]
                    [::std::mem::offset_of!(GkAtoms, onMozOpenDateTimePicker_string) - 43032usize];
                ["Offset of field: GkAtoms::onMozSessionStorageChanged_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozSessionStorageChanged_string
                ) - 43080usize];
                ["Offset of field: GkAtoms::onMozTogglePictureInPicture_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onMozTogglePictureInPicture_string
                ) - 43134usize];
                ["Offset of field: GkAtoms::onPluginCrashed_string"]
                    [::std::mem::offset_of!(GkAtoms, onPluginCrashed_string) - 43190usize];
                ["Offset of field: GkAtoms::onPrintingError_string"]
                    [::std::mem::offset_of!(GkAtoms, onPrintingError_string) - 43222usize];
                ["Offset of field: GkAtoms::onTextZoomChange_string"]
                    [::std::mem::offset_of!(GkAtoms, onTextZoomChange_string) - 43254usize];
                ["Offset of field: GkAtoms::onUAWidgetSetupOrChange_string"]
                    [::std::mem::offset_of!(GkAtoms, onUAWidgetSetupOrChange_string) - 43288usize];
                ["Offset of field: GkAtoms::onUAWidgetTeardown_string"]
                    [::std::mem::offset_of!(GkAtoms, onUAWidgetTeardown_string) - 43336usize];
                ["Offset of field: GkAtoms::onUnselectedTabHover_Disable_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onUnselectedTabHover_Disable_string
                ) - 43374usize];
                ["Offset of field: GkAtoms::onUnselectedTabHover_Enable_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onUnselectedTabHover_Enable_string
                ) - 43432usize];
                ["Offset of field: GkAtoms::onmozshowdropdown_string"]
                    [::std::mem::offset_of!(GkAtoms, onmozshowdropdown_string) - 43488usize];
                ["Offset of field: GkAtoms::onmozshowdropdown_sourcetouch_string"][::std::mem::offset_of!(
                    GkAtoms,
                    onmozshowdropdown_sourcetouch_string
                ) - 43524usize];
                ["Offset of field: GkAtoms::onprintPreviewUpdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onprintPreviewUpdate_string) - 43584usize];
                ["Offset of field: GkAtoms::onscrollend_string"]
                    [::std::mem::offset_of!(GkAtoms, onscrollend_string) - 43626usize];
                ["Offset of field: GkAtoms::onbeforetoggle_string"]
                    [::std::mem::offset_of!(GkAtoms, onbeforetoggle_string) - 43650usize];
                ["Offset of field: GkAtoms::moz_extension_string"]
                    [::std::mem::offset_of!(GkAtoms, moz_extension_string) - 43680usize];
                ["Offset of field: GkAtoms::all_urlsPermission_string"]
                    [::std::mem::offset_of!(GkAtoms, all_urlsPermission_string) - 43708usize];
                ["Offset of field: GkAtoms::clipboardRead_string"]
                    [::std::mem::offset_of!(GkAtoms, clipboardRead_string) - 43730usize];
                ["Offset of field: GkAtoms::clipboardWrite_string"]
                    [::std::mem::offset_of!(GkAtoms, clipboardWrite_string) - 43758usize];
                ["Offset of field: GkAtoms::debugger_string"]
                    [::std::mem::offset_of!(GkAtoms, debugger_string) - 43788usize];
                ["Offset of field: GkAtoms::mozillaAddons_string"]
                    [::std::mem::offset_of!(GkAtoms, mozillaAddons_string) - 43806usize];
                ["Offset of field: GkAtoms::tabs_string"]
                    [::std::mem::offset_of!(GkAtoms, tabs_string) - 43834usize];
                ["Offset of field: GkAtoms::webRequestBlocking_string"]
                    [::std::mem::offset_of!(GkAtoms, webRequestBlocking_string) - 43844usize];
                ["Offset of field: GkAtoms::webRequestFilterResponse_serviceWorkerScript_string"][::std::mem::offset_of!(
                    GkAtoms,
                    webRequestFilterResponse_serviceWorkerScript_string
                )
                    - 43882usize];
                ["Offset of field: GkAtoms::blob_string"]
                    [::std::mem::offset_of!(GkAtoms, blob_string) - 43972usize];
                ["Offset of field: GkAtoms::http_string"]
                    [::std::mem::offset_of!(GkAtoms, http_string) - 43982usize];
                ["Offset of field: GkAtoms::https_string"]
                    [::std::mem::offset_of!(GkAtoms, https_string) - 43992usize];
                ["Offset of field: GkAtoms::view_source_string"]
                    [::std::mem::offset_of!(GkAtoms, view_source_string) - 44004usize];
                ["Offset of field: GkAtoms::ws_string"]
                    [::std::mem::offset_of!(GkAtoms, ws_string) - 44028usize];
                ["Offset of field: GkAtoms::wss_string"]
                    [::std::mem::offset_of!(GkAtoms, wss_string) - 44034usize];
                ["Offset of field: GkAtoms::ftp_string"]
                    [::std::mem::offset_of!(GkAtoms, ftp_string) - 44042usize];
                ["Offset of field: GkAtoms::chrome_string"]
                    [::std::mem::offset_of!(GkAtoms, chrome_string) - 44050usize];
                ["Offset of field: GkAtoms::moz_string"]
                    [::std::mem::offset_of!(GkAtoms, moz_string) - 44064usize];
                ["Offset of field: GkAtoms::moz_icon_string"]
                    [::std::mem::offset_of!(GkAtoms, moz_icon_string) - 44072usize];
                ["Offset of field: GkAtoms::moz_gio_string"]
                    [::std::mem::offset_of!(GkAtoms, moz_gio_string) - 44090usize];
                ["Offset of field: GkAtoms::proxy_string"]
                    [::std::mem::offset_of!(GkAtoms, proxy_string) - 44106usize];
                ["Offset of field: GkAtoms::privateBrowsingAllowedPermission_string"][::std::mem::offset_of!(
                    GkAtoms,
                    privateBrowsingAllowedPermission_string
                )
                    - 44118usize];
                ["Offset of field: GkAtoms::svgContextPropertiesAllowedPermission_string"][::std::mem::offset_of!(
                    GkAtoms,
                    svgContextPropertiesAllowedPermission_string
                )
                    - 44182usize];
                ["Offset of field: GkAtoms::theme_string"]
                    [::std::mem::offset_of!(GkAtoms, theme_string) - 44256usize];
                ["Offset of field: GkAtoms::userScripts_string"]
                    [::std::mem::offset_of!(GkAtoms, userScripts_string) - 44268usize];
                ["Offset of field: GkAtoms::decimal_leading_zero_string"]
                    [::std::mem::offset_of!(GkAtoms, decimal_leading_zero_string) - 44292usize];
                ["Offset of field: GkAtoms::arabic_indic_string"]
                    [::std::mem::offset_of!(GkAtoms, arabic_indic_string) - 44334usize];
                ["Offset of field: GkAtoms::armenian_string"]
                    [::std::mem::offset_of!(GkAtoms, armenian_string) - 44360usize];
                ["Offset of field: GkAtoms::upper_armenian_string"]
                    [::std::mem::offset_of!(GkAtoms, upper_armenian_string) - 44378usize];
                ["Offset of field: GkAtoms::lower_armenian_string"]
                    [::std::mem::offset_of!(GkAtoms, lower_armenian_string) - 44408usize];
                ["Offset of field: GkAtoms::bengali_string"]
                    [::std::mem::offset_of!(GkAtoms, bengali_string) - 44438usize];
                ["Offset of field: GkAtoms::cambodian_string"]
                    [::std::mem::offset_of!(GkAtoms, cambodian_string) - 44454usize];
                ["Offset of field: GkAtoms::khmer_string"]
                    [::std::mem::offset_of!(GkAtoms, khmer_string) - 44474usize];
                ["Offset of field: GkAtoms::cjk_decimal_string"]
                    [::std::mem::offset_of!(GkAtoms, cjk_decimal_string) - 44486usize];
                ["Offset of field: GkAtoms::devanagari_string"]
                    [::std::mem::offset_of!(GkAtoms, devanagari_string) - 44510usize];
                ["Offset of field: GkAtoms::georgian_string"]
                    [::std::mem::offset_of!(GkAtoms, georgian_string) - 44532usize];
                ["Offset of field: GkAtoms::gujarati_string"]
                    [::std::mem::offset_of!(GkAtoms, gujarati_string) - 44550usize];
                ["Offset of field: GkAtoms::gurmukhi_string"]
                    [::std::mem::offset_of!(GkAtoms, gurmukhi_string) - 44568usize];
                ["Offset of field: GkAtoms::kannada_string"]
                    [::std::mem::offset_of!(GkAtoms, kannada_string) - 44586usize];
                ["Offset of field: GkAtoms::lao_string"]
                    [::std::mem::offset_of!(GkAtoms, lao_string) - 44602usize];
                ["Offset of field: GkAtoms::malayalam_string"]
                    [::std::mem::offset_of!(GkAtoms, malayalam_string) - 44610usize];
                ["Offset of field: GkAtoms::mongolian_string"]
                    [::std::mem::offset_of!(GkAtoms, mongolian_string) - 44630usize];
                ["Offset of field: GkAtoms::myanmar_string"]
                    [::std::mem::offset_of!(GkAtoms, myanmar_string) - 44650usize];
                ["Offset of field: GkAtoms::oriya_string"]
                    [::std::mem::offset_of!(GkAtoms, oriya_string) - 44666usize];
                ["Offset of field: GkAtoms::persian_string"]
                    [::std::mem::offset_of!(GkAtoms, persian_string) - 44678usize];
                ["Offset of field: GkAtoms::lower_roman_string"]
                    [::std::mem::offset_of!(GkAtoms, lower_roman_string) - 44694usize];
                ["Offset of field: GkAtoms::upper_roman_string"]
                    [::std::mem::offset_of!(GkAtoms, upper_roman_string) - 44718usize];
                ["Offset of field: GkAtoms::tamil_string"]
                    [::std::mem::offset_of!(GkAtoms, tamil_string) - 44742usize];
                ["Offset of field: GkAtoms::telugu_string"]
                    [::std::mem::offset_of!(GkAtoms, telugu_string) - 44754usize];
                ["Offset of field: GkAtoms::thai_string"]
                    [::std::mem::offset_of!(GkAtoms, thai_string) - 44768usize];
                ["Offset of field: GkAtoms::tibetan_string"]
                    [::std::mem::offset_of!(GkAtoms, tibetan_string) - 44778usize];
                ["Offset of field: GkAtoms::lower_alpha_string"]
                    [::std::mem::offset_of!(GkAtoms, lower_alpha_string) - 44794usize];
                ["Offset of field: GkAtoms::lower_latin_string"]
                    [::std::mem::offset_of!(GkAtoms, lower_latin_string) - 44818usize];
                ["Offset of field: GkAtoms::upper_alpha_string"]
                    [::std::mem::offset_of!(GkAtoms, upper_alpha_string) - 44842usize];
                ["Offset of field: GkAtoms::upper_latin_string"]
                    [::std::mem::offset_of!(GkAtoms, upper_latin_string) - 44866usize];
                ["Offset of field: GkAtoms::cjk_heavenly_stem_string"]
                    [::std::mem::offset_of!(GkAtoms, cjk_heavenly_stem_string) - 44890usize];
                ["Offset of field: GkAtoms::cjk_earthly_branch_string"]
                    [::std::mem::offset_of!(GkAtoms, cjk_earthly_branch_string) - 44926usize];
                ["Offset of field: GkAtoms::lower_greek_string"]
                    [::std::mem::offset_of!(GkAtoms, lower_greek_string) - 44964usize];
                ["Offset of field: GkAtoms::hiragana_string"]
                    [::std::mem::offset_of!(GkAtoms, hiragana_string) - 44988usize];
                ["Offset of field: GkAtoms::hiragana_iroha_string"]
                    [::std::mem::offset_of!(GkAtoms, hiragana_iroha_string) - 45006usize];
                ["Offset of field: GkAtoms::katakana_string"]
                    [::std::mem::offset_of!(GkAtoms, katakana_string) - 45036usize];
                ["Offset of field: GkAtoms::katakana_iroha_string"]
                    [::std::mem::offset_of!(GkAtoms, katakana_iroha_string) - 45054usize];
                ["Offset of field: GkAtoms::cjk_ideographic_string"]
                    [::std::mem::offset_of!(GkAtoms, cjk_ideographic_string) - 45084usize];
                ["Offset of field: GkAtoms::_moz_arabic_indic_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_arabic_indic_string) - 45116usize];
                ["Offset of field: GkAtoms::_moz_persian_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_persian_string) - 45152usize];
                ["Offset of field: GkAtoms::_moz_urdu_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_urdu_string) - 45178usize];
                ["Offset of field: GkAtoms::_moz_devanagari_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_devanagari_string) - 45198usize];
                ["Offset of field: GkAtoms::_moz_bengali_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_bengali_string) - 45230usize];
                ["Offset of field: GkAtoms::_moz_gurmukhi_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_gurmukhi_string) - 45256usize];
                ["Offset of field: GkAtoms::_moz_gujarati_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_gujarati_string) - 45284usize];
                ["Offset of field: GkAtoms::_moz_oriya_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_oriya_string) - 45312usize];
                ["Offset of field: GkAtoms::_moz_tamil_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_tamil_string) - 45334usize];
                ["Offset of field: GkAtoms::_moz_telugu_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_telugu_string) - 45356usize];
                ["Offset of field: GkAtoms::_moz_kannada_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_kannada_string) - 45380usize];
                ["Offset of field: GkAtoms::_moz_malayalam_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_malayalam_string) - 45406usize];
                ["Offset of field: GkAtoms::_moz_thai_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_thai_string) - 45436usize];
                ["Offset of field: GkAtoms::_moz_lao_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_lao_string) - 45456usize];
                ["Offset of field: GkAtoms::_moz_myanmar_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_myanmar_string) - 45474usize];
                ["Offset of field: GkAtoms::_moz_khmer_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_khmer_string) - 45500usize];
                ["Offset of field: GkAtoms::_moz_cjk_heavenly_stem_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_cjk_heavenly_stem_string) - 45522usize];
                ["Offset of field: GkAtoms::_moz_cjk_earthly_branch_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_cjk_earthly_branch_string) - 45568usize];
                ["Offset of field: GkAtoms::_moz_hangul_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_hangul_string) - 45616usize];
                ["Offset of field: GkAtoms::_moz_hangul_consonant_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_hangul_consonant_string) - 45640usize];
                ["Offset of field: GkAtoms::_moz_ethiopic_halehame_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_ethiopic_halehame_string) - 45684usize];
                ["Offset of field: GkAtoms::_moz_ethiopic_halehame_am_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_ethiopic_halehame_am_string
                ) - 45730usize];
                ["Offset of field: GkAtoms::_moz_ethiopic_halehame_ti_er_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_ethiopic_halehame_ti_er_string
                ) - 45782usize];
                ["Offset of field: GkAtoms::_moz_ethiopic_halehame_ti_et_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_ethiopic_halehame_ti_et_string
                ) - 45840usize];
                ["Offset of field: GkAtoms::_moz_trad_chinese_informal_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_trad_chinese_informal_string
                ) - 45898usize];
                ["Offset of field: GkAtoms::_moz_trad_chinese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_trad_chinese_formal_string) - 45952usize];
                ["Offset of field: GkAtoms::_moz_simp_chinese_informal_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_simp_chinese_informal_string
                ) - 46002usize];
                ["Offset of field: GkAtoms::_moz_simp_chinese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_simp_chinese_formal_string) - 46056usize];
                ["Offset of field: GkAtoms::_moz_japanese_informal_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_japanese_informal_string) - 46106usize];
                ["Offset of field: GkAtoms::_moz_japanese_formal_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_japanese_formal_string) - 46152usize];
                ["Offset of field: GkAtoms::_moz_ethiopic_numeric_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_ethiopic_numeric_string) - 46194usize];
                ["Offset of field: GkAtoms::cdataTagName_string"]
                    [::std::mem::offset_of!(GkAtoms, cdataTagName_string) - 46238usize];
                ["Offset of field: GkAtoms::commentTagName_string"]
                    [::std::mem::offset_of!(GkAtoms, commentTagName_string) - 46268usize];
                ["Offset of field: GkAtoms::documentNodeName_string"]
                    [::std::mem::offset_of!(GkAtoms, documentNodeName_string) - 46286usize];
                ["Offset of field: GkAtoms::documentFragmentNodeName_string"]
                    [::std::mem::offset_of!(GkAtoms, documentFragmentNodeName_string) - 46306usize];
                ["Offset of field: GkAtoms::documentTypeNodeName_string"]
                    [::std::mem::offset_of!(GkAtoms, documentTypeNodeName_string) - 46344usize];
                ["Offset of field: GkAtoms::processingInstructionTagName_string"][::std::mem::offset_of!(
                    GkAtoms,
                    processingInstructionTagName_string
                ) - 46374usize];
                ["Offset of field: GkAtoms::textTagName_string"]
                    [::std::mem::offset_of!(GkAtoms, textTagName_string) - 46422usize];
                ["Offset of field: GkAtoms::placeholderFrame_string"]
                    [::std::mem::offset_of!(GkAtoms, placeholderFrame_string) - 46434usize];
                ["Offset of field: GkAtoms::onloadend_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadend_string) - 46468usize];
                ["Offset of field: GkAtoms::onloadstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadstart_string) - 46488usize];
                ["Offset of field: GkAtoms::onprogress_string"]
                    [::std::mem::offset_of!(GkAtoms, onprogress_string) - 46512usize];
                ["Offset of field: GkAtoms::onsuspend_string"]
                    [::std::mem::offset_of!(GkAtoms, onsuspend_string) - 46534usize];
                ["Offset of field: GkAtoms::onemptied_string"]
                    [::std::mem::offset_of!(GkAtoms, onemptied_string) - 46554usize];
                ["Offset of field: GkAtoms::onstalled_string"]
                    [::std::mem::offset_of!(GkAtoms, onstalled_string) - 46574usize];
                ["Offset of field: GkAtoms::onplay_string"]
                    [::std::mem::offset_of!(GkAtoms, onplay_string) - 46594usize];
                ["Offset of field: GkAtoms::onpause_string"]
                    [::std::mem::offset_of!(GkAtoms, onpause_string) - 46608usize];
                ["Offset of field: GkAtoms::onloadedmetadata_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadedmetadata_string) - 46624usize];
                ["Offset of field: GkAtoms::onloadeddata_string"]
                    [::std::mem::offset_of!(GkAtoms, onloadeddata_string) - 46658usize];
                ["Offset of field: GkAtoms::onwaiting_string"]
                    [::std::mem::offset_of!(GkAtoms, onwaiting_string) - 46684usize];
                ["Offset of field: GkAtoms::onplaying_string"]
                    [::std::mem::offset_of!(GkAtoms, onplaying_string) - 46704usize];
                ["Offset of field: GkAtoms::oncanplay_string"]
                    [::std::mem::offset_of!(GkAtoms, oncanplay_string) - 46724usize];
                ["Offset of field: GkAtoms::oncanplaythrough_string"]
                    [::std::mem::offset_of!(GkAtoms, oncanplaythrough_string) - 46744usize];
                ["Offset of field: GkAtoms::onseeking_string"]
                    [::std::mem::offset_of!(GkAtoms, onseeking_string) - 46778usize];
                ["Offset of field: GkAtoms::onseeked_string"]
                    [::std::mem::offset_of!(GkAtoms, onseeked_string) - 46798usize];
                ["Offset of field: GkAtoms::ontimeout_string"]
                    [::std::mem::offset_of!(GkAtoms, ontimeout_string) - 46816usize];
                ["Offset of field: GkAtoms::ontimeupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, ontimeupdate_string) - 46836usize];
                ["Offset of field: GkAtoms::onended_string"]
                    [::std::mem::offset_of!(GkAtoms, onended_string) - 46862usize];
                ["Offset of field: GkAtoms::onformdata_string"]
                    [::std::mem::offset_of!(GkAtoms, onformdata_string) - 46878usize];
                ["Offset of field: GkAtoms::onratechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onratechange_string) - 46900usize];
                ["Offset of field: GkAtoms::ondurationchange_string"]
                    [::std::mem::offset_of!(GkAtoms, ondurationchange_string) - 46926usize];
                ["Offset of field: GkAtoms::onvolumechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onvolumechange_string) - 46960usize];
                ["Offset of field: GkAtoms::onaddtrack_string"]
                    [::std::mem::offset_of!(GkAtoms, onaddtrack_string) - 46990usize];
                ["Offset of field: GkAtoms::oncontrollerchange_string"]
                    [::std::mem::offset_of!(GkAtoms, oncontrollerchange_string) - 47012usize];
                ["Offset of field: GkAtoms::oncuechange_string"]
                    [::std::mem::offset_of!(GkAtoms, oncuechange_string) - 47050usize];
                ["Offset of field: GkAtoms::onenter_string"]
                    [::std::mem::offset_of!(GkAtoms, onenter_string) - 47074usize];
                ["Offset of field: GkAtoms::onexit_string"]
                    [::std::mem::offset_of!(GkAtoms, onexit_string) - 47090usize];
                ["Offset of field: GkAtoms::onencrypted_string"]
                    [::std::mem::offset_of!(GkAtoms, onencrypted_string) - 47104usize];
                ["Offset of field: GkAtoms::onwaitingforkey_string"]
                    [::std::mem::offset_of!(GkAtoms, onwaitingforkey_string) - 47128usize];
                ["Offset of field: GkAtoms::onkeystatuseschange_string"]
                    [::std::mem::offset_of!(GkAtoms, onkeystatuseschange_string) - 47160usize];
                ["Offset of field: GkAtoms::onremovetrack_string"]
                    [::std::mem::offset_of!(GkAtoms, onremovetrack_string) - 47200usize];
                ["Offset of field: GkAtoms::loadstart_string"]
                    [::std::mem::offset_of!(GkAtoms, loadstart_string) - 47228usize];
                ["Offset of field: GkAtoms::suspend_string"]
                    [::std::mem::offset_of!(GkAtoms, suspend_string) - 47248usize];
                ["Offset of field: GkAtoms::emptied_string"]
                    [::std::mem::offset_of!(GkAtoms, emptied_string) - 47264usize];
                ["Offset of field: GkAtoms::play_string"]
                    [::std::mem::offset_of!(GkAtoms, play_string) - 47280usize];
                ["Offset of field: GkAtoms::pause_string"]
                    [::std::mem::offset_of!(GkAtoms, pause_string) - 47290usize];
                ["Offset of field: GkAtoms::loadedmetadata_string"]
                    [::std::mem::offset_of!(GkAtoms, loadedmetadata_string) - 47302usize];
                ["Offset of field: GkAtoms::loadeddata_string"]
                    [::std::mem::offset_of!(GkAtoms, loadeddata_string) - 47332usize];
                ["Offset of field: GkAtoms::waiting_string"]
                    [::std::mem::offset_of!(GkAtoms, waiting_string) - 47354usize];
                ["Offset of field: GkAtoms::playing_string"]
                    [::std::mem::offset_of!(GkAtoms, playing_string) - 47370usize];
                ["Offset of field: GkAtoms::timeupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, timeupdate_string) - 47386usize];
                ["Offset of field: GkAtoms::canplay_string"]
                    [::std::mem::offset_of!(GkAtoms, canplay_string) - 47408usize];
                ["Offset of field: GkAtoms::canplaythrough_string"]
                    [::std::mem::offset_of!(GkAtoms, canplaythrough_string) - 47424usize];
                ["Offset of field: GkAtoms::ondataavailable_string"]
                    [::std::mem::offset_of!(GkAtoms, ondataavailable_string) - 47454usize];
                ["Offset of field: GkAtoms::onwarning_string"]
                    [::std::mem::offset_of!(GkAtoms, onwarning_string) - 47486usize];
                ["Offset of field: GkAtoms::onstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onstart_string) - 47506usize];
                ["Offset of field: GkAtoms::onstop_string"]
                    [::std::mem::offset_of!(GkAtoms, onstop_string) - 47522usize];
                ["Offset of field: GkAtoms::onphoto_string"]
                    [::std::mem::offset_of!(GkAtoms, onphoto_string) - 47536usize];
                ["Offset of field: GkAtoms::ongamepadbuttondown_string"]
                    [::std::mem::offset_of!(GkAtoms, ongamepadbuttondown_string) - 47552usize];
                ["Offset of field: GkAtoms::ongamepadbuttonup_string"]
                    [::std::mem::offset_of!(GkAtoms, ongamepadbuttonup_string) - 47592usize];
                ["Offset of field: GkAtoms::ongamepadaxismove_string"]
                    [::std::mem::offset_of!(GkAtoms, ongamepadaxismove_string) - 47628usize];
                ["Offset of field: GkAtoms::ongamepadconnected_string"]
                    [::std::mem::offset_of!(GkAtoms, ongamepadconnected_string) - 47664usize];
                ["Offset of field: GkAtoms::ongamepaddisconnected_string"]
                    [::std::mem::offset_of!(GkAtoms, ongamepaddisconnected_string) - 47702usize];
                ["Offset of field: GkAtoms::onfetch_string"]
                    [::std::mem::offset_of!(GkAtoms, onfetch_string) - 47746usize];
                ["Offset of field: GkAtoms::afterPseudoProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, afterPseudoProperty_string) - 47762usize];
                ["Offset of field: GkAtoms::beforePseudoProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, beforePseudoProperty_string) - 47802usize];
                ["Offset of field: GkAtoms::cssPseudoElementBeforeProperty_string"][::std::mem::offset_of!(
                    GkAtoms,
                    cssPseudoElementBeforeProperty_string
                ) - 47844usize];
                ["Offset of field: GkAtoms::cssPseudoElementAfterProperty_string"][::std::mem::offset_of!(
                    GkAtoms,
                    cssPseudoElementAfterProperty_string
                ) - 47906usize];
                ["Offset of field: GkAtoms::cssPseudoElementMarkerProperty_string"][::std::mem::offset_of!(
                    GkAtoms,
                    cssPseudoElementMarkerProperty_string
                ) - 47966usize];
                ["Offset of field: GkAtoms::genConInitializerProperty_string"][::std::mem::offset_of!(
                    GkAtoms,
                    genConInitializerProperty_string
                ) - 48028usize];
                ["Offset of field: GkAtoms::labelMouseDownPtProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, labelMouseDownPtProperty_string) - 48064usize];
                ["Offset of field: GkAtoms::lockedStyleStates_string"]
                    [::std::mem::offset_of!(GkAtoms, lockedStyleStates_string) - 48114usize];
                ["Offset of field: GkAtoms::apzCallbackTransform_string"]
                    [::std::mem::offset_of!(GkAtoms, apzCallbackTransform_string) - 48150usize];
                ["Offset of field: GkAtoms::apzDisabled_string"]
                    [::std::mem::offset_of!(GkAtoms, apzDisabled_string) - 48192usize];
                ["Offset of field: GkAtoms::restylableAnonymousNode_string"]
                    [::std::mem::offset_of!(GkAtoms, restylableAnonymousNode_string) - 48216usize];
                ["Offset of field: GkAtoms::docLevelNativeAnonymousContent_string"][::std::mem::offset_of!(
                    GkAtoms,
                    docLevelNativeAnonymousContent_string
                ) - 48264usize];
                ["Offset of field: GkAtoms::paintRequestTime_string"]
                    [::std::mem::offset_of!(GkAtoms, paintRequestTime_string) - 48326usize];
                ["Offset of field: GkAtoms::pseudoProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, pseudoProperty_string) - 48360usize];
                ["Offset of field: GkAtoms::manualNACProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, manualNACProperty_string) - 48390usize];
                ["Offset of field: GkAtoms::markerPseudoProperty_string"]
                    [::std::mem::offset_of!(GkAtoms, markerPseudoProperty_string) - 48426usize];
                ["Offset of field: GkAtoms::Japanese_string"]
                    [::std::mem::offset_of!(GkAtoms, Japanese_string) - 48468usize];
                ["Offset of field: GkAtoms::Chinese_string"]
                    [::std::mem::offset_of!(GkAtoms, Chinese_string) - 48474usize];
                ["Offset of field: GkAtoms::Taiwanese_string"]
                    [::std::mem::offset_of!(GkAtoms, Taiwanese_string) - 48486usize];
                ["Offset of field: GkAtoms::HongKongChinese_string"]
                    [::std::mem::offset_of!(GkAtoms, HongKongChinese_string) - 48498usize];
                ["Offset of field: GkAtoms::Unicode_string"]
                    [::std::mem::offset_of!(GkAtoms, Unicode_string) - 48510usize];
                ["Offset of field: GkAtoms::ko_string"]
                    [::std::mem::offset_of!(GkAtoms, ko_string) - 48530usize];
                ["Offset of field: GkAtoms::zh_cn_string"]
                    [::std::mem::offset_of!(GkAtoms, zh_cn_string) - 48536usize];
                ["Offset of field: GkAtoms::zh_tw_string"]
                    [::std::mem::offset_of!(GkAtoms, zh_tw_string) - 48548usize];
                ["Offset of field: GkAtoms::x_cyrillic_string"]
                    [::std::mem::offset_of!(GkAtoms, x_cyrillic_string) - 48560usize];
                ["Offset of field: GkAtoms::he_string"]
                    [::std::mem::offset_of!(GkAtoms, he_string) - 48582usize];
                ["Offset of field: GkAtoms::ar_string"]
                    [::std::mem::offset_of!(GkAtoms, ar_string) - 48588usize];
                ["Offset of field: GkAtoms::x_devanagari_string"]
                    [::std::mem::offset_of!(GkAtoms, x_devanagari_string) - 48594usize];
                ["Offset of field: GkAtoms::x_tamil_string"]
                    [::std::mem::offset_of!(GkAtoms, x_tamil_string) - 48620usize];
                ["Offset of field: GkAtoms::x_armn_string"]
                    [::std::mem::offset_of!(GkAtoms, x_armn_string) - 48636usize];
                ["Offset of field: GkAtoms::x_beng_string"]
                    [::std::mem::offset_of!(GkAtoms, x_beng_string) - 48650usize];
                ["Offset of field: GkAtoms::x_cans_string"]
                    [::std::mem::offset_of!(GkAtoms, x_cans_string) - 48664usize];
                ["Offset of field: GkAtoms::x_ethi_string"]
                    [::std::mem::offset_of!(GkAtoms, x_ethi_string) - 48678usize];
                ["Offset of field: GkAtoms::x_geor_string"]
                    [::std::mem::offset_of!(GkAtoms, x_geor_string) - 48692usize];
                ["Offset of field: GkAtoms::x_gujr_string"]
                    [::std::mem::offset_of!(GkAtoms, x_gujr_string) - 48706usize];
                ["Offset of field: GkAtoms::x_guru_string"]
                    [::std::mem::offset_of!(GkAtoms, x_guru_string) - 48720usize];
                ["Offset of field: GkAtoms::x_khmr_string"]
                    [::std::mem::offset_of!(GkAtoms, x_khmr_string) - 48734usize];
                ["Offset of field: GkAtoms::x_knda_string"]
                    [::std::mem::offset_of!(GkAtoms, x_knda_string) - 48748usize];
                ["Offset of field: GkAtoms::x_mlym_string"]
                    [::std::mem::offset_of!(GkAtoms, x_mlym_string) - 48762usize];
                ["Offset of field: GkAtoms::x_orya_string"]
                    [::std::mem::offset_of!(GkAtoms, x_orya_string) - 48776usize];
                ["Offset of field: GkAtoms::x_sinh_string"]
                    [::std::mem::offset_of!(GkAtoms, x_sinh_string) - 48790usize];
                ["Offset of field: GkAtoms::x_telu_string"]
                    [::std::mem::offset_of!(GkAtoms, x_telu_string) - 48804usize];
                ["Offset of field: GkAtoms::x_tibt_string"]
                    [::std::mem::offset_of!(GkAtoms, x_tibt_string) - 48818usize];
                ["Offset of field: GkAtoms::az_string"]
                    [::std::mem::offset_of!(GkAtoms, az_string) - 48832usize];
                ["Offset of field: GkAtoms::ba_string"]
                    [::std::mem::offset_of!(GkAtoms, ba_string) - 48838usize];
                ["Offset of field: GkAtoms::crh_string"]
                    [::std::mem::offset_of!(GkAtoms, crh_string) - 48844usize];
                ["Offset of field: GkAtoms::ga_string"]
                    [::std::mem::offset_of!(GkAtoms, ga_string) - 48852usize];
                ["Offset of field: GkAtoms::nl_string"]
                    [::std::mem::offset_of!(GkAtoms, nl_string) - 48858usize];
                ["Offset of field: GkAtoms::x_math_string"]
                    [::std::mem::offset_of!(GkAtoms, x_math_string) - 48864usize];
                ["Offset of field: GkAtoms::zh_string"]
                    [::std::mem::offset_of!(GkAtoms, zh_string) - 48878usize];
                ["Offset of field: GkAtoms::TypingTxnName_string"]
                    [::std::mem::offset_of!(GkAtoms, TypingTxnName_string) - 48884usize];
                ["Offset of field: GkAtoms::IMETxnName_string"]
                    [::std::mem::offset_of!(GkAtoms, IMETxnName_string) - 48898usize];
                ["Offset of field: GkAtoms::DeleteTxnName_string"]
                    [::std::mem::offset_of!(GkAtoms, DeleteTxnName_string) - 48906usize];
                ["Offset of field: GkAtoms::serif_string"]
                    [::std::mem::offset_of!(GkAtoms, serif_string) - 48924usize];
                ["Offset of field: GkAtoms::sans_serif_string"]
                    [::std::mem::offset_of!(GkAtoms, sans_serif_string) - 48936usize];
                ["Offset of field: GkAtoms::cursive_string"]
                    [::std::mem::offset_of!(GkAtoms, cursive_string) - 48958usize];
                ["Offset of field: GkAtoms::fantasy_string"]
                    [::std::mem::offset_of!(GkAtoms, fantasy_string) - 48974usize];
                ["Offset of field: GkAtoms::monospace_string"]
                    [::std::mem::offset_of!(GkAtoms, monospace_string) - 48990usize];
                ["Offset of field: GkAtoms::mozfixed_string"]
                    [::std::mem::offset_of!(GkAtoms, mozfixed_string) - 49010usize];
                ["Offset of field: GkAtoms::moz_fixed_pos_containing_block_string"][::std::mem::offset_of!(
                    GkAtoms,
                    moz_fixed_pos_containing_block_string
                ) - 49032usize];
                ["Offset of field: GkAtoms::light_string"]
                    [::std::mem::offset_of!(GkAtoms, light_string) - 49096usize];
                ["Offset of field: GkAtoms::dark_string"]
                    [::std::mem::offset_of!(GkAtoms, dark_string) - 49108usize];
                ["Offset of field: GkAtoms::RemoteId_string"]
                    [::std::mem::offset_of!(GkAtoms, RemoteId_string) - 49118usize];
                ["Offset of field: GkAtoms::RemoteType_string"]
                    [::std::mem::offset_of!(GkAtoms, RemoteType_string) - 49140usize];
                ["Offset of field: GkAtoms::DisplayPort_string"]
                    [::std::mem::offset_of!(GkAtoms, DisplayPort_string) - 49162usize];
                ["Offset of field: GkAtoms::DisplayPortMargins_string"]
                    [::std::mem::offset_of!(GkAtoms, DisplayPortMargins_string) - 49188usize];
                ["Offset of field: GkAtoms::DisplayPortBase_string"]
                    [::std::mem::offset_of!(GkAtoms, DisplayPortBase_string) - 49228usize];
                ["Offset of field: GkAtoms::MinimalDisplayPort_string"]
                    [::std::mem::offset_of!(GkAtoms, MinimalDisplayPort_string) - 49262usize];
                ["Offset of field: GkAtoms::forceMousewheelAutodir_string"]
                    [::std::mem::offset_of!(GkAtoms, forceMousewheelAutodir_string) - 49302usize];
                ["Offset of field: GkAtoms::forceMousewheelAutodirHonourRoot_string"][::std::mem::offset_of!(
                    GkAtoms,
                    forceMousewheelAutodirHonourRoot_string
                )
                    - 49354usize];
                ["Offset of field: GkAtoms::forcemessagemanager_string"]
                    [::std::mem::offset_of!(GkAtoms, forcemessagemanager_string) - 49428usize];
                ["Offset of field: GkAtoms::initialBrowsingContextGroupId_string"][::std::mem::offset_of!(
                    GkAtoms,
                    initialBrowsingContextGroupId_string
                ) - 49468usize];
                ["Offset of field: GkAtoms::manualactiveness_string"]
                    [::std::mem::offset_of!(GkAtoms, manualactiveness_string) - 49528usize];
                ["Offset of field: GkAtoms::_moz_bool_pref_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_bool_pref_string) - 49562usize];
                ["Offset of field: GkAtoms::_moz_overlay_scrollbars_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_overlay_scrollbars_string) - 49592usize];
                ["Offset of field: GkAtoms::_moz_overlay_scrollbar_fade_duration_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_overlay_scrollbar_fade_duration_string
                )
                    - 49640usize];
                ["Offset of field: GkAtoms::_moz_windows_accent_color_in_titlebar_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_windows_accent_color_in_titlebar_string
                )
                    - 49714usize];
                ["Offset of field: GkAtoms::_moz_windows_accent_color_in_tabs_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_windows_accent_color_in_tabs_string
                )
                    - 49790usize];
                ["Offset of field: GkAtoms::_moz_windows_mica_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_windows_mica_string) - 49858usize];
                ["Offset of field: GkAtoms::_moz_windows_mica_popups_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_windows_mica_popups_string) - 49894usize];
                ["Offset of field: GkAtoms::_moz_mac_big_sur_theme_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_mac_big_sur_theme_string) - 49944usize];
                ["Offset of field: GkAtoms::_moz_mac_tahoe_theme_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_mac_tahoe_theme_string) - 49990usize];
                ["Offset of field: GkAtoms::_moz_mac_rtl_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_mac_rtl_string) - 50032usize];
                ["Offset of field: GkAtoms::_moz_mac_titlebar_height_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_mac_titlebar_height_string) - 50058usize];
                ["Offset of field: GkAtoms::_moz_platform_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_platform_string) - 50108usize];
                ["Offset of field: GkAtoms::_moz_gtk_theme_family_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_gtk_theme_family_string) - 50136usize];
                ["Offset of field: GkAtoms::_moz_menubar_drag_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_menubar_drag_string) - 50180usize];
                ["Offset of field: GkAtoms::_moz_device_pixel_ratio_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_device_pixel_ratio_string) - 50216usize];
                ["Offset of field: GkAtoms::_moz_device_orientation_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_device_orientation_string) - 50264usize];
                ["Offset of field: GkAtoms::_moz_is_resource_document_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_is_resource_document_string
                ) - 50312usize];
                ["Offset of field: GkAtoms::_moz_swipe_animation_enabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_swipe_animation_enabled_string
                ) - 50364usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_available_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_gtk_csd_available_string) - 50422usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_transparency_available_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_transparency_available_string
                )
                    - 50468usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_titlebar_radius_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_titlebar_radius_string
                ) - 50540usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_tooltip_radius_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_tooltip_radius_string
                ) - 50598usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_titlebar_button_spacing_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_titlebar_button_spacing_string
                )
                    - 50654usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_minimize_button_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_minimize_button_string
                ) - 50728usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_minimize_button_position_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_minimize_button_position_string
                )
                    - 50786usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_maximize_button_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_maximize_button_string
                ) - 50862usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_maximize_button_position_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_maximize_button_position_string
                )
                    - 50920usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_close_button_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_close_button_string
                ) - 50996usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_close_button_position_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_close_button_position_string
                )
                    - 51048usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_reversed_placement_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_reversed_placement_string
                )
                    - 51118usize];
                ["Offset of field: GkAtoms::_moz_gtk_csd_rounded_bottom_corners_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_gtk_csd_rounded_bottom_corners_string
                )
                    - 51182usize];
                ["Offset of field: GkAtoms::_moz_content_prefers_color_scheme_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_content_prefers_color_scheme_string
                )
                    - 51254usize];
                ["Offset of field: GkAtoms::_moz_content_preferred_color_scheme_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _moz_content_preferred_color_scheme_string
                )
                    - 51322usize];
                ["Offset of field: GkAtoms::_moz_system_dark_theme_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_system_dark_theme_string) - 51394usize];
                ["Offset of field: GkAtoms::_moz_native_theme_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_native_theme_string) - 51440usize];
                ["Offset of field: GkAtoms::_moz_panel_animations_string"]
                    [::std::mem::offset_of!(GkAtoms, _moz_panel_animations_string) - 51476usize];
                ["Offset of field: GkAtoms::Back_string"]
                    [::std::mem::offset_of!(GkAtoms, Back_string) - 51520usize];
                ["Offset of field: GkAtoms::Forward_string"]
                    [::std::mem::offset_of!(GkAtoms, Forward_string) - 51530usize];
                ["Offset of field: GkAtoms::Reload_string"]
                    [::std::mem::offset_of!(GkAtoms, Reload_string) - 51546usize];
                ["Offset of field: GkAtoms::Stop_string"]
                    [::std::mem::offset_of!(GkAtoms, Stop_string) - 51560usize];
                ["Offset of field: GkAtoms::Search_string"]
                    [::std::mem::offset_of!(GkAtoms, Search_string) - 51570usize];
                ["Offset of field: GkAtoms::Bookmarks_string"]
                    [::std::mem::offset_of!(GkAtoms, Bookmarks_string) - 51584usize];
                ["Offset of field: GkAtoms::Home_string"]
                    [::std::mem::offset_of!(GkAtoms, Home_string) - 51604usize];
                ["Offset of field: GkAtoms::NextTrack_string"]
                    [::std::mem::offset_of!(GkAtoms, NextTrack_string) - 51614usize];
                ["Offset of field: GkAtoms::PreviousTrack_string"]
                    [::std::mem::offset_of!(GkAtoms, PreviousTrack_string) - 51634usize];
                ["Offset of field: GkAtoms::MediaStop_string"]
                    [::std::mem::offset_of!(GkAtoms, MediaStop_string) - 51662usize];
                ["Offset of field: GkAtoms::PlayPause_string"]
                    [::std::mem::offset_of!(GkAtoms, PlayPause_string) - 51682usize];
                ["Offset of field: GkAtoms::New_string"]
                    [::std::mem::offset_of!(GkAtoms, New_string) - 51702usize];
                ["Offset of field: GkAtoms::Open_string"]
                    [::std::mem::offset_of!(GkAtoms, Open_string) - 51710usize];
                ["Offset of field: GkAtoms::Close_string"]
                    [::std::mem::offset_of!(GkAtoms, Close_string) - 51720usize];
                ["Offset of field: GkAtoms::Save_string"]
                    [::std::mem::offset_of!(GkAtoms, Save_string) - 51732usize];
                ["Offset of field: GkAtoms::Find_string"]
                    [::std::mem::offset_of!(GkAtoms, Find_string) - 51742usize];
                ["Offset of field: GkAtoms::Help_string"]
                    [::std::mem::offset_of!(GkAtoms, Help_string) - 51752usize];
                ["Offset of field: GkAtoms::Print_string"]
                    [::std::mem::offset_of!(GkAtoms, Print_string) - 51762usize];
                ["Offset of field: GkAtoms::SendMail_string"]
                    [::std::mem::offset_of!(GkAtoms, SendMail_string) - 51774usize];
                ["Offset of field: GkAtoms::ForwardMail_string"]
                    [::std::mem::offset_of!(GkAtoms, ForwardMail_string) - 51792usize];
                ["Offset of field: GkAtoms::ReplyToMail_string"]
                    [::std::mem::offset_of!(GkAtoms, ReplyToMail_string) - 51816usize];
                ["Offset of field: GkAtoms::alert_string"]
                    [::std::mem::offset_of!(GkAtoms, alert_string) - 51840usize];
                ["Offset of field: GkAtoms::alertdialog_string"]
                    [::std::mem::offset_of!(GkAtoms, alertdialog_string) - 51852usize];
                ["Offset of field: GkAtoms::application_string"]
                    [::std::mem::offset_of!(GkAtoms, application_string) - 51876usize];
                ["Offset of field: GkAtoms::aria_colcount_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_colcount_string) - 51900usize];
                ["Offset of field: GkAtoms::aria_colindex_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_colindex_string) - 51928usize];
                ["Offset of field: GkAtoms::aria_colindextext_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_colindextext_string) - 51956usize];
                ["Offset of field: GkAtoms::aria_colspan_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_colspan_string) - 51992usize];
                ["Offset of field: GkAtoms::aria_details_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_details_string) - 52018usize];
                ["Offset of field: GkAtoms::aria_errormessage_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_errormessage_string) - 52044usize];
                ["Offset of field: GkAtoms::aria_grabbed_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_grabbed_string) - 52080usize];
                ["Offset of field: GkAtoms::aria_keyshortcuts_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_keyshortcuts_string) - 52106usize];
                ["Offset of field: GkAtoms::aria_label_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_label_string) - 52142usize];
                ["Offset of field: GkAtoms::aria_modal_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_modal_string) - 52164usize];
                ["Offset of field: GkAtoms::aria_orientation_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_orientation_string) - 52186usize];
                ["Offset of field: GkAtoms::aria_placeholder_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_placeholder_string) - 52220usize];
                ["Offset of field: GkAtoms::aria_roledescription_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_roledescription_string) - 52254usize];
                ["Offset of field: GkAtoms::aria_rowcount_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_rowcount_string) - 52296usize];
                ["Offset of field: GkAtoms::aria_rowindex_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_rowindex_string) - 52324usize];
                ["Offset of field: GkAtoms::aria_rowindextext_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_rowindextext_string) - 52352usize];
                ["Offset of field: GkAtoms::aria_rowspan_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_rowspan_string) - 52388usize];
                ["Offset of field: GkAtoms::aria_valuetext_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_valuetext_string) - 52414usize];
                ["Offset of field: GkAtoms::assertive_string"]
                    [::std::mem::offset_of!(GkAtoms, assertive_string) - 52444usize];
                ["Offset of field: GkAtoms::auto_generated_string"]
                    [::std::mem::offset_of!(GkAtoms, auto_generated_string) - 52464usize];
                ["Offset of field: GkAtoms::banner_string"]
                    [::std::mem::offset_of!(GkAtoms, banner_string) - 52494usize];
                ["Offset of field: GkAtoms::checkable_string"]
                    [::std::mem::offset_of!(GkAtoms, checkable_string) - 52508usize];
                ["Offset of field: GkAtoms::columnheader_string"]
                    [::std::mem::offset_of!(GkAtoms, columnheader_string) - 52528usize];
                ["Offset of field: GkAtoms::complementary_string"]
                    [::std::mem::offset_of!(GkAtoms, complementary_string) - 52554usize];
                ["Offset of field: GkAtoms::containerAtomic_string"]
                    [::std::mem::offset_of!(GkAtoms, containerAtomic_string) - 52582usize];
                ["Offset of field: GkAtoms::containerBusy_string"]
                    [::std::mem::offset_of!(GkAtoms, containerBusy_string) - 52616usize];
                ["Offset of field: GkAtoms::containerLive_string"]
                    [::std::mem::offset_of!(GkAtoms, containerLive_string) - 52646usize];
                ["Offset of field: GkAtoms::containerLiveRole_string"]
                    [::std::mem::offset_of!(GkAtoms, containerLiveRole_string) - 52676usize];
                ["Offset of field: GkAtoms::containerRelevant_string"]
                    [::std::mem::offset_of!(GkAtoms, containerRelevant_string) - 52716usize];
                ["Offset of field: GkAtoms::contentinfo_string"]
                    [::std::mem::offset_of!(GkAtoms, contentinfo_string) - 52754usize];
                ["Offset of field: GkAtoms::cycles_string"]
                    [::std::mem::offset_of!(GkAtoms, cycles_string) - 52778usize];
                ["Offset of field: GkAtoms::datatable_string"]
                    [::std::mem::offset_of!(GkAtoms, datatable_string) - 52792usize];
                ["Offset of field: GkAtoms::feed_string"]
                    [::std::mem::offset_of!(GkAtoms, feed_string) - 52812usize];
                ["Offset of field: GkAtoms::grammar_string"]
                    [::std::mem::offset_of!(GkAtoms, grammar_string) - 52822usize];
                ["Offset of field: GkAtoms::gridcell_string"]
                    [::std::mem::offset_of!(GkAtoms, gridcell_string) - 52838usize];
                ["Offset of field: GkAtoms::heading_string"]
                    [::std::mem::offset_of!(GkAtoms, heading_string) - 52856usize];
                ["Offset of field: GkAtoms::inlinevalue_string"]
                    [::std::mem::offset_of!(GkAtoms, inlinevalue_string) - 52872usize];
                ["Offset of field: GkAtoms::inline_size_string"]
                    [::std::mem::offset_of!(GkAtoms, inline_size_string) - 52886usize];
                ["Offset of field: GkAtoms::invalid_string"]
                    [::std::mem::offset_of!(GkAtoms, invalid_string) - 52910usize];
                ["Offset of field: GkAtoms::lineNumber_string"]
                    [::std::mem::offset_of!(GkAtoms, lineNumber_string) - 52926usize];
                ["Offset of field: GkAtoms::menuitemcheckbox_string"]
                    [::std::mem::offset_of!(GkAtoms, menuitemcheckbox_string) - 52950usize];
                ["Offset of field: GkAtoms::menuitemradio_string"]
                    [::std::mem::offset_of!(GkAtoms, menuitemradio_string) - 52984usize];
                ["Offset of field: GkAtoms::navigation_string"]
                    [::std::mem::offset_of!(GkAtoms, navigation_string) - 53012usize];
                ["Offset of field: GkAtoms::polite_string"]
                    [::std::mem::offset_of!(GkAtoms, polite_string) - 53034usize];
                ["Offset of field: GkAtoms::posinset_string"]
                    [::std::mem::offset_of!(GkAtoms, posinset_string) - 53048usize];
                ["Offset of field: GkAtoms::presentation_string"]
                    [::std::mem::offset_of!(GkAtoms, presentation_string) - 53066usize];
                ["Offset of field: GkAtoms::progressbar_string"]
                    [::std::mem::offset_of!(GkAtoms, progressbar_string) - 53092usize];
                ["Offset of field: GkAtoms::region_string"]
                    [::std::mem::offset_of!(GkAtoms, region_string) - 53116usize];
                ["Offset of field: GkAtoms::rowgroup_string"]
                    [::std::mem::offset_of!(GkAtoms, rowgroup_string) - 53130usize];
                ["Offset of field: GkAtoms::rowheader_string"]
                    [::std::mem::offset_of!(GkAtoms, rowheader_string) - 53148usize];
                ["Offset of field: GkAtoms::search_string"]
                    [::std::mem::offset_of!(GkAtoms, search_string) - 53168usize];
                ["Offset of field: GkAtoms::searchbox_string"]
                    [::std::mem::offset_of!(GkAtoms, searchbox_string) - 53182usize];
                ["Offset of field: GkAtoms::setsize_string"]
                    [::std::mem::offset_of!(GkAtoms, setsize_string) - 53202usize];
                ["Offset of field: GkAtoms::spelling_string"]
                    [::std::mem::offset_of!(GkAtoms, spelling_string) - 53218usize];
                ["Offset of field: GkAtoms::spinbutton_string"]
                    [::std::mem::offset_of!(GkAtoms, spinbutton_string) - 53236usize];
                ["Offset of field: GkAtoms::status_string"]
                    [::std::mem::offset_of!(GkAtoms, status_string) - 53258usize];
                ["Offset of field: GkAtoms::tableCellIndex_string"]
                    [::std::mem::offset_of!(GkAtoms, tableCellIndex_string) - 53272usize];
                ["Offset of field: GkAtoms::tablist_string"]
                    [::std::mem::offset_of!(GkAtoms, tablist_string) - 53306usize];
                ["Offset of field: GkAtoms::textIndent_string"]
                    [::std::mem::offset_of!(GkAtoms, textIndent_string) - 53322usize];
                ["Offset of field: GkAtoms::textInputType_string"]
                    [::std::mem::offset_of!(GkAtoms, textInputType_string) - 53346usize];
                ["Offset of field: GkAtoms::textLineThroughColor_string"]
                    [::std::mem::offset_of!(GkAtoms, textLineThroughColor_string) - 53378usize];
                ["Offset of field: GkAtoms::textLineThroughStyle_string"]
                    [::std::mem::offset_of!(GkAtoms, textLineThroughStyle_string) - 53426usize];
                ["Offset of field: GkAtoms::textPosition_string"]
                    [::std::mem::offset_of!(GkAtoms, textPosition_string) - 53474usize];
                ["Offset of field: GkAtoms::textUnderlineColor_string"]
                    [::std::mem::offset_of!(GkAtoms, textUnderlineColor_string) - 53502usize];
                ["Offset of field: GkAtoms::textUnderlineStyle_string"]
                    [::std::mem::offset_of!(GkAtoms, textUnderlineStyle_string) - 53544usize];
                ["Offset of field: GkAtoms::timer_string"]
                    [::std::mem::offset_of!(GkAtoms, timer_string) - 53586usize];
                ["Offset of field: GkAtoms::toolbarname_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarname_string) - 53598usize];
                ["Offset of field: GkAtoms::toolbarseparator_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarseparator_string) - 53622usize];
                ["Offset of field: GkAtoms::toolbarspacer_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarspacer_string) - 53656usize];
                ["Offset of field: GkAtoms::toolbarspring_string"]
                    [::std::mem::offset_of!(GkAtoms, toolbarspring_string) - 53684usize];
                ["Offset of field: GkAtoms::treegrid_string"]
                    [::std::mem::offset_of!(GkAtoms, treegrid_string) - 53712usize];
                ["Offset of field: GkAtoms::_undefined_string"]
                    [::std::mem::offset_of!(GkAtoms, _undefined_string) - 53730usize];
                ["Offset of field: GkAtoms::xmlroles_string"]
                    [::std::mem::offset_of!(GkAtoms, xmlroles_string) - 53750usize];
                ["Offset of field: GkAtoms::close_fence_string"]
                    [::std::mem::offset_of!(GkAtoms, close_fence_string) - 53770usize];
                ["Offset of field: GkAtoms::denominator_string"]
                    [::std::mem::offset_of!(GkAtoms, denominator_string) - 53794usize];
                ["Offset of field: GkAtoms::numerator_string"]
                    [::std::mem::offset_of!(GkAtoms, numerator_string) - 53818usize];
                ["Offset of field: GkAtoms::open_fence_string"]
                    [::std::mem::offset_of!(GkAtoms, open_fence_string) - 53838usize];
                ["Offset of field: GkAtoms::overscript_string"]
                    [::std::mem::offset_of!(GkAtoms, overscript_string) - 53860usize];
                ["Offset of field: GkAtoms::presubscript_string"]
                    [::std::mem::offset_of!(GkAtoms, presubscript_string) - 53882usize];
                ["Offset of field: GkAtoms::presuperscript_string"]
                    [::std::mem::offset_of!(GkAtoms, presuperscript_string) - 53908usize];
                ["Offset of field: GkAtoms::root_index_string"]
                    [::std::mem::offset_of!(GkAtoms, root_index_string) - 53938usize];
                ["Offset of field: GkAtoms::subscript_string"]
                    [::std::mem::offset_of!(GkAtoms, subscript_string) - 53960usize];
                ["Offset of field: GkAtoms::superscript_string"]
                    [::std::mem::offset_of!(GkAtoms, superscript_string) - 53980usize];
                ["Offset of field: GkAtoms::underscript_string"]
                    [::std::mem::offset_of!(GkAtoms, underscript_string) - 54004usize];
                ["Offset of field: GkAtoms::onaudiostart_string"]
                    [::std::mem::offset_of!(GkAtoms, onaudiostart_string) - 54028usize];
                ["Offset of field: GkAtoms::onaudioend_string"]
                    [::std::mem::offset_of!(GkAtoms, onaudioend_string) - 54054usize];
                ["Offset of field: GkAtoms::onsoundstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onsoundstart_string) - 54076usize];
                ["Offset of field: GkAtoms::onsoundend_string"]
                    [::std::mem::offset_of!(GkAtoms, onsoundend_string) - 54102usize];
                ["Offset of field: GkAtoms::onspeechstart_string"]
                    [::std::mem::offset_of!(GkAtoms, onspeechstart_string) - 54124usize];
                ["Offset of field: GkAtoms::onspeechend_string"]
                    [::std::mem::offset_of!(GkAtoms, onspeechend_string) - 54152usize];
                ["Offset of field: GkAtoms::onresult_string"]
                    [::std::mem::offset_of!(GkAtoms, onresult_string) - 54176usize];
                ["Offset of field: GkAtoms::onnomatch_string"]
                    [::std::mem::offset_of!(GkAtoms, onnomatch_string) - 54194usize];
                ["Offset of field: GkAtoms::onresume_string"]
                    [::std::mem::offset_of!(GkAtoms, onresume_string) - 54214usize];
                ["Offset of field: GkAtoms::onmark_string"]
                    [::std::mem::offset_of!(GkAtoms, onmark_string) - 54232usize];
                ["Offset of field: GkAtoms::onboundary_string"]
                    [::std::mem::offset_of!(GkAtoms, onboundary_string) - 54246usize];
                ["Offset of field: GkAtoms::onactivated_string"]
                    [::std::mem::offset_of!(GkAtoms, onactivated_string) - 54268usize];
                ["Offset of field: GkAtoms::ondeactivated_string"]
                    [::std::mem::offset_of!(GkAtoms, ondeactivated_string) - 54292usize];
                ["Offset of field: GkAtoms::onmetadatachange_string"]
                    [::std::mem::offset_of!(GkAtoms, onmetadatachange_string) - 54320usize];
                ["Offset of field: GkAtoms::onplaybackstatechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onplaybackstatechange_string) - 54354usize];
                ["Offset of field: GkAtoms::onpositionstatechange_string"]
                    [::std::mem::offset_of!(GkAtoms, onpositionstatechange_string) - 54398usize];
                ["Offset of field: GkAtoms::onsupportedkeyschange_string"]
                    [::std::mem::offset_of!(GkAtoms, onsupportedkeyschange_string) - 54442usize];
                ["Offset of field: GkAtoms::mathml_legacy_mathvariant_attribute_disabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    mathml_legacy_mathvariant_attribute_disabled_string
                )
                    - 54486usize];
                ["Offset of field: GkAtoms::mathml_font_family_math_enabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    mathml_font_family_math_enabled_string
                )
                    - 54576usize];
                ["Offset of field: GkAtoms::layout_css_always_underline_links_string"][::std::mem::offset_of!(
                    GkAtoms,
                    layout_css_always_underline_links_string
                )
                    - 54640usize];
                ["Offset of field: GkAtoms::layout_css_android_pip_enabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    layout_css_android_pip_enabled_string
                ) - 54708usize];
                ["Offset of field: GkAtoms::layout_css_cached_scrollbar_styles_enabled_string"][::std::mem::offset_of!(
                    GkAtoms,
                    layout_css_cached_scrollbar_styles_enabled_string
                )
                    - 54770usize];
                ["Offset of field: GkAtoms::layout_testing_scrollbars_always_hidden_string"][::std::mem::offset_of!(
                    GkAtoms,
                    layout_testing_scrollbars_always_hidden_string
                )
                    - 54856usize];
                ["Offset of field: GkAtoms::usercontextid_string"]
                    [::std::mem::offset_of!(GkAtoms, usercontextid_string) - 54936usize];
                ["Offset of field: GkAtoms::geckoViewSessionContextId_string"][::std::mem::offset_of!(
                    GkAtoms,
                    geckoViewSessionContextId_string
                ) - 54964usize];
                ["Offset of field: GkAtoms::nsuri_xmlns_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xmlns_string) - 55016usize];
                ["Offset of field: GkAtoms::nsuri_xml_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xml_string) - 55076usize];
                ["Offset of field: GkAtoms::nsuri_xhtml_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xhtml_string) - 55150usize];
                ["Offset of field: GkAtoms::nsuri_xlink_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xlink_string) - 55208usize];
                ["Offset of field: GkAtoms::nsuri_xslt_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xslt_string) - 55266usize];
                ["Offset of field: GkAtoms::nsuri_mathml_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_mathml_string) - 55340usize];
                ["Offset of field: GkAtoms::nsuri_rdf_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_rdf_string) - 55410usize];
                ["Offset of field: GkAtoms::nsuri_xul_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_xul_string) - 55498usize];
                ["Offset of field: GkAtoms::nsuri_svg_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_svg_string) - 55622usize];
                ["Offset of field: GkAtoms::nsuri_parsererror_string"]
                    [::std::mem::offset_of!(GkAtoms, nsuri_parsererror_string) - 55676usize];
                ["Offset of field: GkAtoms::onsourceopen_string"]
                    [::std::mem::offset_of!(GkAtoms, onsourceopen_string) - 55782usize];
                ["Offset of field: GkAtoms::onsourceended_string"]
                    [::std::mem::offset_of!(GkAtoms, onsourceended_string) - 55808usize];
                ["Offset of field: GkAtoms::onsourceclose_string"]
                    [::std::mem::offset_of!(GkAtoms, onsourceclose_string) - 55836usize];
                ["Offset of field: GkAtoms::onupdatestart_string"]
                    [::std::mem::offset_of!(GkAtoms, onupdatestart_string) - 55864usize];
                ["Offset of field: GkAtoms::onupdate_string"]
                    [::std::mem::offset_of!(GkAtoms, onupdate_string) - 55892usize];
                ["Offset of field: GkAtoms::onupdateend_string"]
                    [::std::mem::offset_of!(GkAtoms, onupdateend_string) - 55910usize];
                ["Offset of field: GkAtoms::onaddsourcebuffer_string"]
                    [::std::mem::offset_of!(GkAtoms, onaddsourcebuffer_string) - 55934usize];
                ["Offset of field: GkAtoms::onremovesourcebuffer_string"]
                    [::std::mem::offset_of!(GkAtoms, onremovesourcebuffer_string) - 55970usize];
                ["Offset of field: GkAtoms::ondequeue_string"]
                    [::std::mem::offset_of!(GkAtoms, ondequeue_string) - 56012usize];
                ["Offset of field: GkAtoms::about_string"]
                    [::std::mem::offset_of!(GkAtoms, about_string) - 56032usize];
                ["Offset of field: GkAtoms::ID_string"]
                    [::std::mem::offset_of!(GkAtoms, ID_string) - 56044usize];
                ["Offset of field: GkAtoms::nodeID_string"]
                    [::std::mem::offset_of!(GkAtoms, nodeID_string) - 56050usize];
                ["Offset of field: GkAtoms::aboutEach_string"]
                    [::std::mem::offset_of!(GkAtoms, aboutEach_string) - 56064usize];
                ["Offset of field: GkAtoms::resource_string"]
                    [::std::mem::offset_of!(GkAtoms, resource_string) - 56084usize];
                ["Offset of field: GkAtoms::RDF_string"]
                    [::std::mem::offset_of!(GkAtoms, RDF_string) - 56102usize];
                ["Offset of field: GkAtoms::Description_string"]
                    [::std::mem::offset_of!(GkAtoms, Description_string) - 56110usize];
                ["Offset of field: GkAtoms::Bag_string"]
                    [::std::mem::offset_of!(GkAtoms, Bag_string) - 56134usize];
                ["Offset of field: GkAtoms::Seq_string"]
                    [::std::mem::offset_of!(GkAtoms, Seq_string) - 56142usize];
                ["Offset of field: GkAtoms::Alt_string"]
                    [::std::mem::offset_of!(GkAtoms, Alt_string) - 56150usize];
                ["Offset of field: GkAtoms::parseType_string"]
                    [::std::mem::offset_of!(GkAtoms, parseType_string) - 56158usize];
                ["Offset of field: GkAtoms::DirectoryService_CurrentProcess_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_CurrentProcess_string
                )
                    - 56178usize];
                ["Offset of field: GkAtoms::DirectoryService_GRE_Directory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_GRE_Directory_string
                ) - 56198usize];
                ["Offset of field: GkAtoms::DirectoryService_GRE_BinDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_GRE_BinDirectory_string
                )
                    - 56208usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_TemporaryDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_TemporaryDirectory_string
                )
                    - 56224usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_CurrentProcessDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_CurrentProcessDirectory_string
                )
                    - 56234usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_CurrentWorkingDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_CurrentWorkingDirectory_string
                )
                    - 56252usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_SystemConfigDir_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_SystemConfigDir_string
                )
                    - 56270usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_DesktopDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_DesktopDirectory_string
                )
                    - 56288usize];
                ["Offset of field: GkAtoms::DirectoryService_OS_DocumentsDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OS_DocumentsDirectory_string
                )
                    - 56298usize];
                ["Offset of field: GkAtoms::DirectoryService_InitCurrentProcess_dummy_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_InitCurrentProcess_dummy_string
                )
                    - 56308usize];
                ["Offset of field: GkAtoms::DirectoryService_SystemDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_SystemDirectory_string
                )
                    - 56324usize];
                ["Offset of field: GkAtoms::DirectoryService_UserLibDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_UserLibDirectory_string
                )
                    - 56334usize];
                ["Offset of field: GkAtoms::DirectoryService_DefaultDownloadDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_DefaultDownloadDirectory_string
                )
                    - 56350usize];
                ["Offset of field: GkAtoms::DirectoryService_LocalApplicationsDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_LocalApplicationsDirectory_string
                )
                    - 56370usize];
                ["Offset of field: GkAtoms::DirectoryService_UserPreferencesDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_UserPreferencesDirectory_string
                )
                    - 56384usize];
                ["Offset of field: GkAtoms::DirectoryService_PictureDocumentsDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_PictureDocumentsDirectory_string
                )
                    - 56400usize];
                ["Offset of field: GkAtoms::DirectoryService_DefaultScreenshotDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_DefaultScreenshotDirectory_string
                )
                    - 56408usize];
                ["Offset of field: GkAtoms::DirectoryService_WindowsDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_WindowsDirectory_string
                )
                    - 56426usize];
                ["Offset of field: GkAtoms::DirectoryService_WindowsProgramFiles_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_WindowsProgramFiles_string
                )
                    - 56436usize];
                ["Offset of field: GkAtoms::DirectoryService_Programs_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_Programs_string
                ) - 56448usize];
                ["Offset of field: GkAtoms::DirectoryService_Favorites_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_Favorites_string
                ) - 56460usize];
                ["Offset of field: GkAtoms::DirectoryService_Appdata_string"]
                    [::std::mem::offset_of!(GkAtoms, DirectoryService_Appdata_string) - 56470usize];
                ["Offset of field: GkAtoms::DirectoryService_LocalAppdata_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_LocalAppdata_string
                ) - 56486usize];
                ["Offset of field: GkAtoms::DirectoryService_WinCookiesDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_WinCookiesDirectory_string
                )
                    - 56512usize];
                ["Offset of field: GkAtoms::DirectoryService_OneDrivePersonalDirectory_string"][::std::mem::offset_of!(
                    GkAtoms,
                    DirectoryService_OneDrivePersonalDirectory_string
                )
                    - 56524usize];
                ["Offset of field: GkAtoms::DirectoryService_OneDriveBusinessDirectoryList_string"]
                    [::std::mem::offset_of!(
                        GkAtoms,
                        DirectoryService_OneDriveBusinessDirectoryList_string
                    ) - 56540usize];
                ["Offset of field: GkAtoms::_ua_view_transition_fade_out_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _ua_view_transition_fade_out_string
                ) - 56558usize];
                ["Offset of field: GkAtoms::_ua_view_transition_fade_in_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _ua_view_transition_fade_in_string
                ) - 56616usize];
                ["Offset of field: GkAtoms::_ua_mix_blend_mode_plus_lighter_string"][::std::mem::offset_of!(
                    GkAtoms,
                    _ua_mix_blend_mode_plus_lighter_string
                )
                    - 56672usize];
                ["Offset of field: GkAtoms::AnchorPosImplicitAnchor_string"]
                    [::std::mem::offset_of!(GkAtoms, AnchorPosImplicitAnchor_string) - 56736usize];
                ["Offset of field: GkAtoms::PseudoElement_after_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_after_string) - 56784usize];
                ["Offset of field: GkAtoms::PseudoElement_before_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_before_string) - 56798usize];
                ["Offset of field: GkAtoms::PseudoElement_marker_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_marker_string) - 56814usize];
                ["Offset of field: GkAtoms::PseudoElement_backdrop_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_backdrop_string) - 56830usize];
                ["Offset of field: GkAtoms::PseudoElement_cue_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_cue_string) - 56850usize];
                ["Offset of field: GkAtoms::PseudoElement_firstLetter_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_firstLetter_string
                ) - 56860usize];
                ["Offset of field: GkAtoms::PseudoElement_firstLine_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_firstLine_string) - 56888usize];
                ["Offset of field: GkAtoms::PseudoElement_highlight_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_highlight_string) - 56912usize];
                ["Offset of field: GkAtoms::PseudoElement_selection_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_selection_string) - 56934usize];
                ["Offset of field: GkAtoms::PseudoElement_targetText_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_targetText_string) - 56956usize];
                ["Offset of field: GkAtoms::PseudoElement_viewTransition_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_viewTransition_string
                ) - 56982usize];
                ["Offset of field: GkAtoms::PseudoElement_viewTransitionGroup_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_viewTransitionGroup_string
                )
                    - 57016usize];
                ["Offset of field: GkAtoms::PseudoElement_viewTransitionImagePair_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_viewTransitionImagePair_string
                )
                    - 57062usize];
                ["Offset of field: GkAtoms::PseudoElement_viewTransitionOld_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_viewTransitionOld_string
                )
                    - 57118usize];
                ["Offset of field: GkAtoms::PseudoElement_viewTransitionNew_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_viewTransitionNew_string
                )
                    - 57160usize];
                ["Offset of field: GkAtoms::PseudoElement_mozSnapshotContainingBlock_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozSnapshotContainingBlock_string
                )
                    - 57202usize];
                ["Offset of field: GkAtoms::PseudoElement_mozNumberSpinBox_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozNumberSpinBox_string
                ) - 57266usize];
                ["Offset of field: GkAtoms::PseudoElement_mozNumberSpinUp_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozNumberSpinUp_string
                ) - 57310usize];
                ["Offset of field: GkAtoms::PseudoElement_mozNumberSpinDown_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozNumberSpinDown_string
                )
                    - 57352usize];
                ["Offset of field: GkAtoms::PseudoElement_mozSearchClearButton_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozSearchClearButton_string
                )
                    - 57398usize];
                ["Offset of field: GkAtoms::PseudoElement_mozProgressBar_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozProgressBar_string
                ) - 57450usize];
                ["Offset of field: GkAtoms::PseudoElement_mozRangeTrack_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozRangeTrack_string
                ) - 57488usize];
                ["Offset of field: GkAtoms::PseudoElement_mozRangeProgress_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozRangeProgress_string
                ) - 57524usize];
                ["Offset of field: GkAtoms::PseudoElement_mozRangeThumb_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozRangeThumb_string
                ) - 57566usize];
                ["Offset of field: GkAtoms::PseudoElement_mozMeterBar_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozMeterBar_string
                ) - 57602usize];
                ["Offset of field: GkAtoms::PseudoElement_placeholder_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_placeholder_string
                ) - 57634usize];
                ["Offset of field: GkAtoms::PseudoElement_mozColorSwatch_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozColorSwatch_string
                ) - 57660usize];
                ["Offset of field: GkAtoms::PseudoElement_mozTextControlEditingRoot_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozTextControlEditingRoot_string
                )
                    - 57698usize];
                ["Offset of field: GkAtoms::PseudoElement_mozTextControlPreview_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_mozTextControlPreview_string
                )
                    - 57762usize];
                ["Offset of field: GkAtoms::PseudoElement_mozReveal_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_mozReveal_string) - 57816usize];
                ["Offset of field: GkAtoms::PseudoElement_fileSelectorButton_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_fileSelectorButton_string
                )
                    - 57842usize];
                ["Offset of field: GkAtoms::PseudoElement_sliderTrack_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_sliderTrack_string
                ) - 57886usize];
                ["Offset of field: GkAtoms::PseudoElement_sliderThumb_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_sliderThumb_string
                ) - 57914usize];
                ["Offset of field: GkAtoms::PseudoElement_sliderFill_string"]
                    [::std::mem::offset_of!(GkAtoms, PseudoElement_sliderFill_string) - 57942usize];
                ["Offset of field: GkAtoms::PseudoElement_detailsContent_string"][::std::mem::offset_of!(
                    GkAtoms,
                    PseudoElement_detailsContent_string
                ) - 57968usize];
                ["Offset of field: GkAtoms::AnonBox_oofPlaceholder_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_oofPlaceholder_string) - 58002usize];
                ["Offset of field: GkAtoms::AnonBox_horizontalFramesetBorder_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_horizontalFramesetBorder_string
                )
                    - 58046usize];
                ["Offset of field: GkAtoms::AnonBox_verticalFramesetBorder_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_verticalFramesetBorder_string
                ) - 58092usize];
                ["Offset of field: GkAtoms::AnonBox_framesetBlank_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_framesetBlank_string) - 58138usize];
                ["Offset of field: GkAtoms::AnonBox_tableColGroup_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableColGroup_string) - 58180usize];
                ["Offset of field: GkAtoms::AnonBox_tableCol_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableCol_string) - 58230usize];
                ["Offset of field: GkAtoms::AnonBox_page_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_page_string) - 58268usize];
                ["Offset of field: GkAtoms::AnonBox_pageBreak_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_pageBreak_string) - 58290usize];
                ["Offset of field: GkAtoms::AnonBox_pageContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_pageContent_string) - 58324usize];
                ["Offset of field: GkAtoms::AnonBox_printedSheet_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_printedSheet_string) - 58362usize];
                ["Offset of field: GkAtoms::AnonBox_columnSpanWrapper_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_columnSpanWrapper_string
                ) - 58402usize];
                ["Offset of field: GkAtoms::AnonBox_mozText_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozText_string) - 58454usize];
                ["Offset of field: GkAtoms::AnonBox_firstLetterContinuation_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_firstLetterContinuation_string
                )
                    - 58476usize];
                ["Offset of field: GkAtoms::AnonBox_mozBlockInsideInlineWrapper_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozBlockInsideInlineWrapper_string
                )
                    - 58540usize];
                ["Offset of field: GkAtoms::AnonBox_mozMathMLAnonymousBlock_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozMathMLAnonymousBlock_string
                )
                    - 58608usize];
                ["Offset of field: GkAtoms::AnonBox_mozLineFrame_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozLineFrame_string) - 58666usize];
                ["Offset of field: GkAtoms::AnonBox_cellContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_cellContent_string) - 58700usize];
                ["Offset of field: GkAtoms::AnonBox_dropDownList_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_dropDownList_string) - 58738usize];
                ["Offset of field: GkAtoms::AnonBox_fieldsetContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_fieldsetContent_string) - 58778usize];
                ["Offset of field: GkAtoms::AnonBox_htmlCanvasContent_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_htmlCanvasContent_string
                ) - 58824usize];
                ["Offset of field: GkAtoms::AnonBox_inlineTable_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_inlineTable_string) - 58876usize];
                ["Offset of field: GkAtoms::AnonBox_table_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_table_string) - 58914usize];
                ["Offset of field: GkAtoms::AnonBox_tableCell_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableCell_string) - 58938usize];
                ["Offset of field: GkAtoms::AnonBox_tableWrapper_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableWrapper_string) - 58972usize];
                ["Offset of field: GkAtoms::AnonBox_tableRowGroup_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableRowGroup_string) - 59012usize];
                ["Offset of field: GkAtoms::AnonBox_tableRow_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_tableRow_string) - 59056usize];
                ["Offset of field: GkAtoms::AnonBox_canvas_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_canvas_string) - 59088usize];
                ["Offset of field: GkAtoms::AnonBox_pageSequence_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_pageSequence_string) - 59114usize];
                ["Offset of field: GkAtoms::AnonBox_scrolledContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_scrolledContent_string) - 59154usize];
                ["Offset of field: GkAtoms::AnonBox_scrolledCanvas_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_scrolledCanvas_string) - 59200usize];
                ["Offset of field: GkAtoms::AnonBox_columnSet_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_columnSet_string) - 59244usize];
                ["Offset of field: GkAtoms::AnonBox_columnContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_columnContent_string) - 59278usize];
                ["Offset of field: GkAtoms::AnonBox_viewport_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_viewport_string) - 59320usize];
                ["Offset of field: GkAtoms::AnonBox_viewportScroll_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_viewportScroll_string) - 59350usize];
                ["Offset of field: GkAtoms::AnonBox_anonymousItem_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_anonymousItem_string) - 59394usize];
                ["Offset of field: GkAtoms::AnonBox_blockRubyContent_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_blockRubyContent_string) - 59436usize];
                ["Offset of field: GkAtoms::AnonBox_ruby_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_ruby_string) - 59486usize];
                ["Offset of field: GkAtoms::AnonBox_rubyBase_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_rubyBase_string) - 59508usize];
                ["Offset of field: GkAtoms::AnonBox_rubyBaseContainer_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_rubyBaseContainer_string
                ) - 59540usize];
                ["Offset of field: GkAtoms::AnonBox_rubyText_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_rubyText_string) - 59592usize];
                ["Offset of field: GkAtoms::AnonBox_rubyTextContainer_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_rubyTextContainer_string
                ) - 59624usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeColumn_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeColumn_string) - 59676usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeRow_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeRow_string) - 59712usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeSeparator_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeSeparator_string) - 59742usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeCell_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeCell_string) - 59784usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeIndentation_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozTreeIndentation_string
                ) - 59816usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeLine_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeLine_string) - 59862usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeTwisty_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeTwisty_string) - 59894usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeImage_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeImage_string) - 59930usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeCellText_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeCellText_string) - 59964usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeCheckbox_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozTreeCheckbox_string) - 60006usize];
                ["Offset of field: GkAtoms::AnonBox_mozTreeDropFeedback_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozTreeDropFeedback_string
                ) - 60046usize];
                ["Offset of field: GkAtoms::AnonBox_mozSVGMarkerAnonChild_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozSVGMarkerAnonChild_string
                ) - 60096usize];
                ["Offset of field: GkAtoms::AnonBox_mozSVGOuterSVGAnonChild_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozSVGOuterSVGAnonChild_string
                )
                    - 60152usize];
                ["Offset of field: GkAtoms::AnonBox_mozSVGForeignContent_string"][::std::mem::offset_of!(
                    GkAtoms,
                    AnonBox_mozSVGForeignContent_string
                ) - 60214usize];
                ["Offset of field: GkAtoms::AnonBox_mozSVGText_string"]
                    [::std::mem::offset_of!(GkAtoms, AnonBox_mozSVGText_string) - 60266usize];
                ["Offset of field: GkAtoms::xlink_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_string) - 60296usize];
                ["Offset of field: GkAtoms::xml_space_string"]
                    [::std::mem::offset_of!(GkAtoms, xml_space_string) - 60308usize];
                ["Offset of field: GkAtoms::xml_lang_string"]
                    [::std::mem::offset_of!(GkAtoms, xml_lang_string) - 60328usize];
                ["Offset of field: GkAtoms::aria_grab_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_grab_string) - 60346usize];
                ["Offset of field: GkAtoms::aria_channel_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_channel_string) - 60366usize];
                ["Offset of field: GkAtoms::aria_secret_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_secret_string) - 60392usize];
                ["Offset of field: GkAtoms::aria_templateid_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_templateid_string) - 60416usize];
                ["Offset of field: GkAtoms::aria_datatype_string"]
                    [::std::mem::offset_of!(GkAtoms, aria_datatype_string) - 60448usize];
                ["Offset of field: GkAtoms::local_string"]
                    [::std::mem::offset_of!(GkAtoms, local_string) - 60476usize];
                ["Offset of field: GkAtoms::xchannelselector_string"]
                    [::std::mem::offset_of!(GkAtoms, xchannelselector_string) - 60488usize];
                ["Offset of field: GkAtoms::ychannelselector_string"]
                    [::std::mem::offset_of!(GkAtoms, ychannelselector_string) - 60522usize];
                ["Offset of field: GkAtoms::enable_background_string"]
                    [::std::mem::offset_of!(GkAtoms, enable_background_string) - 60556usize];
                ["Offset of field: GkAtoms::calcmode_string"]
                    [::std::mem::offset_of!(GkAtoms, calcmode_string) - 60592usize];
                ["Offset of field: GkAtoms::specularexponent_string"]
                    [::std::mem::offset_of!(GkAtoms, specularexponent_string) - 60610usize];
                ["Offset of field: GkAtoms::specularconstant_string"]
                    [::std::mem::offset_of!(GkAtoms, specularconstant_string) - 60644usize];
                ["Offset of field: GkAtoms::gradienttransform_string"]
                    [::std::mem::offset_of!(GkAtoms, gradienttransform_string) - 60678usize];
                ["Offset of field: GkAtoms::gradientunits_string"]
                    [::std::mem::offset_of!(GkAtoms, gradientunits_string) - 60714usize];
                ["Offset of field: GkAtoms::rendering_intent_string"]
                    [::std::mem::offset_of!(GkAtoms, rendering_intent_string) - 60742usize];
                ["Offset of field: GkAtoms::shadowrootmode_string"]
                    [::std::mem::offset_of!(GkAtoms, shadowrootmode_string) - 60776usize];
                ["Offset of field: GkAtoms::shadowrootclonable_string"]
                    [::std::mem::offset_of!(GkAtoms, shadowrootclonable_string) - 60806usize];
                ["Offset of field: GkAtoms::shadowrootserializable_string"]
                    [::std::mem::offset_of!(GkAtoms, shadowrootserializable_string) - 60844usize];
                ["Offset of field: GkAtoms::stddeviation_string"]
                    [::std::mem::offset_of!(GkAtoms, stddeviation_string) - 60890usize];
                ["Offset of field: GkAtoms::shadowrootdelegatesfocus_string"]
                    [::std::mem::offset_of!(GkAtoms, shadowrootdelegatesfocus_string) - 60916usize];
                ["Offset of field: GkAtoms::basefrequency_string"]
                    [::std::mem::offset_of!(GkAtoms, basefrequency_string) - 60966usize];
                ["Offset of field: GkAtoms::baseprofile_string"]
                    [::std::mem::offset_of!(GkAtoms, baseprofile_string) - 60994usize];
                ["Offset of field: GkAtoms::baseProfile_string"]
                    [::std::mem::offset_of!(GkAtoms, baseProfile_string) - 61018usize];
                ["Offset of field: GkAtoms::edgemode_string"]
                    [::std::mem::offset_of!(GkAtoms, edgemode_string) - 61042usize];
                ["Offset of field: GkAtoms::repeatcount_string"]
                    [::std::mem::offset_of!(GkAtoms, repeatcount_string) - 61060usize];
                ["Offset of field: GkAtoms::repeatdur_string"]
                    [::std::mem::offset_of!(GkAtoms, repeatdur_string) - 61084usize];
                ["Offset of field: GkAtoms::spreadmethod_string"]
                    [::std::mem::offset_of!(GkAtoms, spreadmethod_string) - 61104usize];
                ["Offset of field: GkAtoms::diffuseconstant_string"]
                    [::std::mem::offset_of!(GkAtoms, diffuseconstant_string) - 61130usize];
                ["Offset of field: GkAtoms::surfacescale_string"]
                    [::std::mem::offset_of!(GkAtoms, surfacescale_string) - 61162usize];
                ["Offset of field: GkAtoms::lengthadjust_string"]
                    [::std::mem::offset_of!(GkAtoms, lengthadjust_string) - 61188usize];
                ["Offset of field: GkAtoms::origin_string"]
                    [::std::mem::offset_of!(GkAtoms, origin_string) - 61214usize];
                ["Offset of field: GkAtoms::targetx_string"]
                    [::std::mem::offset_of!(GkAtoms, targetx_string) - 61228usize];
                ["Offset of field: GkAtoms::targety_string"]
                    [::std::mem::offset_of!(GkAtoms, targety_string) - 61244usize];
                ["Offset of field: GkAtoms::pathlength_string"]
                    [::std::mem::offset_of!(GkAtoms, pathlength_string) - 61260usize];
                ["Offset of field: GkAtoms::definitionurl_string"]
                    [::std::mem::offset_of!(GkAtoms, definitionurl_string) - 61282usize];
                ["Offset of field: GkAtoms::limitingconeangle_string"]
                    [::std::mem::offset_of!(GkAtoms, limitingconeangle_string) - 61310usize];
                ["Offset of field: GkAtoms::markerheight_string"]
                    [::std::mem::offset_of!(GkAtoms, markerheight_string) - 61346usize];
                ["Offset of field: GkAtoms::markerwidth_string"]
                    [::std::mem::offset_of!(GkAtoms, markerwidth_string) - 61372usize];
                ["Offset of field: GkAtoms::maskunits_string"]
                    [::std::mem::offset_of!(GkAtoms, maskunits_string) - 61396usize];
                ["Offset of field: GkAtoms::markerunits_string"]
                    [::std::mem::offset_of!(GkAtoms, markerunits_string) - 61416usize];
                ["Offset of field: GkAtoms::maskcontentunits_string"]
                    [::std::mem::offset_of!(GkAtoms, maskcontentunits_string) - 61440usize];
                ["Offset of field: GkAtoms::tablevalues_string"]
                    [::std::mem::offset_of!(GkAtoms, tablevalues_string) - 61474usize];
                ["Offset of field: GkAtoms::primitiveunits_string"]
                    [::std::mem::offset_of!(GkAtoms, primitiveunits_string) - 61498usize];
                ["Offset of field: GkAtoms::zoomandpan_string"]
                    [::std::mem::offset_of!(GkAtoms, zoomandpan_string) - 61528usize];
                ["Offset of field: GkAtoms::kernelmatrix_string"]
                    [::std::mem::offset_of!(GkAtoms, kernelmatrix_string) - 61550usize];
                ["Offset of field: GkAtoms::kerning_string"]
                    [::std::mem::offset_of!(GkAtoms, kerning_string) - 61576usize];
                ["Offset of field: GkAtoms::kernelunitlength_string"]
                    [::std::mem::offset_of!(GkAtoms, kernelunitlength_string) - 61592usize];
                ["Offset of field: GkAtoms::pointsatx_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsatx_string) - 61626usize];
                ["Offset of field: GkAtoms::pointsaty_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsaty_string) - 61646usize];
                ["Offset of field: GkAtoms::pointsatz_string"]
                    [::std::mem::offset_of!(GkAtoms, pointsatz_string) - 61666usize];
                ["Offset of field: GkAtoms::xlink_href_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_href_string) - 61686usize];
                ["Offset of field: GkAtoms::xlink_title_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_title_string) - 61708usize];
                ["Offset of field: GkAtoms::xlink_role_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_role_string) - 61732usize];
                ["Offset of field: GkAtoms::xlink_arcrole_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_arcrole_string) - 61754usize];
                ["Offset of field: GkAtoms::arcrole_string"]
                    [::std::mem::offset_of!(GkAtoms, arcrole_string) - 61782usize];
                ["Offset of field: GkAtoms::xmlns_xlink_string"]
                    [::std::mem::offset_of!(GkAtoms, xmlns_xlink_string) - 61798usize];
                ["Offset of field: GkAtoms::xlink_type_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_type_string) - 61822usize];
                ["Offset of field: GkAtoms::xlink_show_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_show_string) - 61844usize];
                ["Offset of field: GkAtoms::xlink_actuate_string"]
                    [::std::mem::offset_of!(GkAtoms, xlink_actuate_string) - 61866usize];
                ["Offset of field: GkAtoms::autocorrect_string"]
                    [::std::mem::offset_of!(GkAtoms, autocorrect_string) - 61894usize];
                ["Offset of field: GkAtoms::color_rendering_string"]
                    [::std::mem::offset_of!(GkAtoms, color_rendering_string) - 61918usize];
                ["Offset of field: GkAtoms::numoctaves_string"]
                    [::std::mem::offset_of!(GkAtoms, numoctaves_string) - 61950usize];
                ["Offset of field: GkAtoms::onmousewheel_string"]
                    [::std::mem::offset_of!(GkAtoms, onmousewheel_string) - 61972usize];
                ["Offset of field: GkAtoms::clippathunits_string"]
                    [::std::mem::offset_of!(GkAtoms, clippathunits_string) - 61998usize];
                ["Offset of field: GkAtoms::glyph_orientation_vertical_string"][::std::mem::offset_of!(
                    GkAtoms,
                    glyph_orientation_vertical_string
                ) - 62026usize];
                ["Offset of field: GkAtoms::glyph_orientation_horizontal_string"][::std::mem::offset_of!(
                    GkAtoms,
                    glyph_orientation_horizontal_string
                ) - 62080usize];
                ["Offset of field: GkAtoms::glyphref_string"]
                    [::std::mem::offset_of!(GkAtoms, glyphref_string) - 62138usize];
                ["Offset of field: GkAtoms::keypoints_string"]
                    [::std::mem::offset_of!(GkAtoms, keypoints_string) - 62156usize];
                ["Offset of field: GkAtoms::attributename_string"]
                    [::std::mem::offset_of!(GkAtoms, attributename_string) - 62176usize];
                ["Offset of field: GkAtoms::attributetype_string"]
                    [::std::mem::offset_of!(GkAtoms, attributetype_string) - 62204usize];
                ["Offset of field: GkAtoms::startoffset_string"]
                    [::std::mem::offset_of!(GkAtoms, startoffset_string) - 62232usize];
                ["Offset of field: GkAtoms::keysplines_string"]
                    [::std::mem::offset_of!(GkAtoms, keysplines_string) - 62256usize];
                ["Offset of field: GkAtoms::preservealpha_string"]
                    [::std::mem::offset_of!(GkAtoms, preservealpha_string) - 62278usize];
                ["Offset of field: GkAtoms::preserveaspectratio_string"]
                    [::std::mem::offset_of!(GkAtoms, preserveaspectratio_string) - 62306usize];
                ["Offset of field: GkAtoms::alttext_string"]
                    [::std::mem::offset_of!(GkAtoms, alttext_string) - 62346usize];
                ["Offset of field: GkAtoms::filterunits_string"]
                    [::std::mem::offset_of!(GkAtoms, filterunits_string) - 62362usize];
                ["Offset of field: GkAtoms::keytimes_string"]
                    [::std::mem::offset_of!(GkAtoms, keytimes_string) - 62386usize];
                ["Offset of field: GkAtoms::patterntransform_string"]
                    [::std::mem::offset_of!(GkAtoms, patterntransform_string) - 62404usize];
                ["Offset of field: GkAtoms::patternunits_string"]
                    [::std::mem::offset_of!(GkAtoms, patternunits_string) - 62438usize];
                ["Offset of field: GkAtoms::patterncontentunits_string"]
                    [::std::mem::offset_of!(GkAtoms, patterncontentunits_string) - 62464usize];
                ["Offset of field: GkAtoms::stitchtiles_string"]
                    [::std::mem::offset_of!(GkAtoms, stitchtiles_string) - 62504usize];
                ["Offset of field: GkAtoms::systemlanguage_string"]
                    [::std::mem::offset_of!(GkAtoms, systemlanguage_string) - 62528usize];
                ["Offset of field: GkAtoms::textlength_string"]
                    [::std::mem::offset_of!(GkAtoms, textlength_string) - 62558usize];
                ["Offset of field: GkAtoms::requiredfeatures_string"]
                    [::std::mem::offset_of!(GkAtoms, requiredfeatures_string) - 62580usize];
                ["Offset of field: GkAtoms::requiredextensions_string"]
                    [::std::mem::offset_of!(GkAtoms, requiredextensions_string) - 62614usize];
                ["Offset of field: GkAtoms::viewtarget_string"]
                    [::std::mem::offset_of!(GkAtoms, viewtarget_string) - 62652usize];
                ["Offset of field: GkAtoms::viewbox_string"]
                    [::std::mem::offset_of!(GkAtoms, viewbox_string) - 62674usize];
                ["Offset of field: GkAtoms::refx_string"]
                    [::std::mem::offset_of!(GkAtoms, refx_string) - 62690usize];
                ["Offset of field: GkAtoms::refy_string"]
                    [::std::mem::offset_of!(GkAtoms, refy_string) - 62700usize];
                ["Offset of field: GkAtoms::fefunca_string"]
                    [::std::mem::offset_of!(GkAtoms, fefunca_string) - 62710usize];
                ["Offset of field: GkAtoms::fefuncb_string"]
                    [::std::mem::offset_of!(GkAtoms, fefuncb_string) - 62726usize];
                ["Offset of field: GkAtoms::feblend_string"]
                    [::std::mem::offset_of!(GkAtoms, feblend_string) - 62742usize];
                ["Offset of field: GkAtoms::feflood_string"]
                    [::std::mem::offset_of!(GkAtoms, feflood_string) - 62758usize];
                ["Offset of field: GkAtoms::feturbulence_string"]
                    [::std::mem::offset_of!(GkAtoms, feturbulence_string) - 62774usize];
                ["Offset of field: GkAtoms::femergenode_string"]
                    [::std::mem::offset_of!(GkAtoms, femergenode_string) - 62800usize];
                ["Offset of field: GkAtoms::feimage_string"]
                    [::std::mem::offset_of!(GkAtoms, feimage_string) - 62824usize];
                ["Offset of field: GkAtoms::femerge_string"]
                    [::std::mem::offset_of!(GkAtoms, femerge_string) - 62840usize];
                ["Offset of field: GkAtoms::fetile_string"]
                    [::std::mem::offset_of!(GkAtoms, fetile_string) - 62856usize];
                ["Offset of field: GkAtoms::fecomposite_string"]
                    [::std::mem::offset_of!(GkAtoms, fecomposite_string) - 62870usize];
                ["Offset of field: GkAtoms::altglyphdef_string"]
                    [::std::mem::offset_of!(GkAtoms, altglyphdef_string) - 62894usize];
                ["Offset of field: GkAtoms::altGlyphDef_string"]
                    [::std::mem::offset_of!(GkAtoms, altGlyphDef_string) - 62918usize];
                ["Offset of field: GkAtoms::fefuncg_string"]
                    [::std::mem::offset_of!(GkAtoms, fefuncg_string) - 62942usize];
                ["Offset of field: GkAtoms::fediffuselighting_string"]
                    [::std::mem::offset_of!(GkAtoms, fediffuselighting_string) - 62958usize];
                ["Offset of field: GkAtoms::fespecularlighting_string"]
                    [::std::mem::offset_of!(GkAtoms, fespecularlighting_string) - 62994usize];
                ["Offset of field: GkAtoms::altglyph_string"]
                    [::std::mem::offset_of!(GkAtoms, altglyph_string) - 63032usize];
                ["Offset of field: GkAtoms::altGlyph_string"]
                    [::std::mem::offset_of!(GkAtoms, altGlyph_string) - 63050usize];
                ["Offset of field: GkAtoms::clippath_string"]
                    [::std::mem::offset_of!(GkAtoms, clippath_string) - 63068usize];
                ["Offset of field: GkAtoms::textpath_string"]
                    [::std::mem::offset_of!(GkAtoms, textpath_string) - 63086usize];
                ["Offset of field: GkAtoms::altglyphitem_string"]
                    [::std::mem::offset_of!(GkAtoms, altglyphitem_string) - 63104usize];
                ["Offset of field: GkAtoms::altGlyphItem_string"]
                    [::std::mem::offset_of!(GkAtoms, altGlyphItem_string) - 63130usize];
                ["Offset of field: GkAtoms::animatetransform_string"]
                    [::std::mem::offset_of!(GkAtoms, animatetransform_string) - 63156usize];
                ["Offset of field: GkAtoms::animatemotion_string"]
                    [::std::mem::offset_of!(GkAtoms, animatemotion_string) - 63190usize];
                ["Offset of field: GkAtoms::fedisplacementmap_string"]
                    [::std::mem::offset_of!(GkAtoms, fedisplacementmap_string) - 63218usize];
                ["Offset of field: GkAtoms::animatecolor_string"]
                    [::std::mem::offset_of!(GkAtoms, animatecolor_string) - 63254usize];
                ["Offset of field: GkAtoms::fefuncr_string"]
                    [::std::mem::offset_of!(GkAtoms, fefuncr_string) - 63280usize];
                ["Offset of field: GkAtoms::fecomponenttransfer_string"]
                    [::std::mem::offset_of!(GkAtoms, fecomponenttransfer_string) - 63296usize];
                ["Offset of field: GkAtoms::fegaussianblur_string"]
                    [::std::mem::offset_of!(GkAtoms, fegaussianblur_string) - 63336usize];
                ["Offset of field: GkAtoms::foreignobject_string"]
                    [::std::mem::offset_of!(GkAtoms, foreignobject_string) - 63366usize];
                ["Offset of field: GkAtoms::feoffset_string"]
                    [::std::mem::offset_of!(GkAtoms, feoffset_string) - 63394usize];
                ["Offset of field: GkAtoms::fespotlight_string"]
                    [::std::mem::offset_of!(GkAtoms, fespotlight_string) - 63412usize];
                ["Offset of field: GkAtoms::fepointlight_string"]
                    [::std::mem::offset_of!(GkAtoms, fepointlight_string) - 63436usize];
                ["Offset of field: GkAtoms::fedistantlight_string"]
                    [::std::mem::offset_of!(GkAtoms, fedistantlight_string) - 63462usize];
                ["Offset of field: GkAtoms::lineargradient_string"]
                    [::std::mem::offset_of!(GkAtoms, lineargradient_string) - 63492usize];
                ["Offset of field: GkAtoms::radialgradient_string"]
                    [::std::mem::offset_of!(GkAtoms, radialgradient_string) - 63522usize];
                ["Offset of field: GkAtoms::fedropshadow_string"]
                    [::std::mem::offset_of!(GkAtoms, fedropshadow_string) - 63552usize];
                ["Offset of field: GkAtoms::fecolormatrix_string"]
                    [::std::mem::offset_of!(GkAtoms, fecolormatrix_string) - 63578usize];
                ["Offset of field: GkAtoms::feconvolvematrix_string"]
                    [::std::mem::offset_of!(GkAtoms, feconvolvematrix_string) - 63606usize];
                ["Offset of field: GkAtoms::femorphology_string"]
                    [::std::mem::offset_of!(GkAtoms, femorphology_string) - 63640usize];
                ["Offset of field: GkAtoms::mAtoms"]
                    [::std::mem::offset_of!(GkAtoms, mAtoms) - 63668usize];
            };
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla6detail8gGkAtomsE"]
                pub static gGkAtoms: root::mozilla::detail::GkAtoms;
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct CopyablePtr<T> {
                pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<T>>,
                pub mPtr: T,
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct MutexImpl {
                pub platformData_: [*mut ::std::os::raw::c_void; 5usize],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct MutexImpl_PlatformData {
                _unused: [u8; 0],
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of MutexImpl"][::std::mem::size_of::<MutexImpl>() - 40usize];
                ["Alignment of MutexImpl"][::std::mem::align_of::<MutexImpl>() - 8usize];
                ["Offset of field: MutexImpl::platformData_"]
                    [::std::mem::offset_of!(MutexImpl, platformData_) - 0usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct VariantTag {
                pub _address: u8,
            }
            pub type VariantTag_Type = root::std::conditional_t;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct UnwrapMaybeAtomic {
                pub _address: u8,
            }
            pub type UnwrapMaybeAtomic_Type<T> = T;
            #[repr(C)]
            #[derive(Debug)]
            pub struct HashTableEntry {
                pub mValueData: *mut ::std::os::raw::c_uchar,
            }
            pub type HashTableEntry_NonConstT = root::std::remove_const_t;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct EntrySlot {
                pub mEntry: *mut root::mozilla::detail::EntrySlot_Entry,
                pub mKeyHash: *mut root::mozilla::HashNumber,
            }
            pub type EntrySlot_NonConstT = root::std::remove_const_t;
            pub type EntrySlot_Entry = root::mozilla::detail::HashTableEntry;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable {
                pub _address: u8,
            }
            pub type HashTable_NonConstT = root::std::remove_const_t;
            pub type HashTable_Key<HashPolicy> = HashPolicy;
            pub type HashTable_Lookup<HashPolicy> = HashPolicy;
            pub type HashTable_Entry = root::mozilla::detail::HashTableEntry;
            pub type HashTable_Slot = root::mozilla::detail::EntrySlot;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_Ptr {
                pub mSlot: root::mozilla::detail::HashTable_Slot,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_AddPtr {
                pub _base: root::mozilla::detail::HashTable_Ptr,
                pub mKeyHash: root::mozilla::HashNumber,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_Iterator {
                pub mCur: root::mozilla::detail::HashTable_Slot,
                pub mEnd: root::mozilla::detail::HashTable_Slot,
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct HashTable_ModIterator {
                pub _base: root::mozilla::detail::HashTable_Iterator,
                pub mTable: *mut u8,
                pub mRekeyed: bool,
                pub mRemoved: bool,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_Range {
                pub mIter: root::mozilla::detail::HashTable_Iterator,
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct HashTable_Enum {
                pub mIter: root::mozilla::detail::HashTable_ModIterator,
            }
            pub const HashTable_FailureBehavior_DontReportFailure: HashTable_FailureBehavior = 0;
            pub const HashTable_FailureBehavior_ReportFailure: HashTable_FailureBehavior = 0;
            pub type HashTable_FailureBehavior = i32;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_FakeSlot {
                pub c: *mut ::std::os::raw::c_uchar,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HashTable_DoubleHash {
                pub mHash2: root::mozilla::HashNumber,
                pub mSizeMask: root::mozilla::HashNumber,
            }
            pub const HashTable_LookupReason_ForNonAdd: HashTable_LookupReason = 0;
            pub const HashTable_LookupReason_ForAdd: HashTable_LookupReason = 0;
            pub type HashTable_LookupReason = i32;
            pub const HashTable_RebuildStatus_NotOverloaded: HashTable_RebuildStatus = 0;
            pub const HashTable_RebuildStatus_Rehashed: HashTable_RebuildStatus = 0;
            pub const HashTable_RebuildStatus_RehashFailed: HashTable_RebuildStatus = 0;
            pub type HashTable_RebuildStatus = i32;
            #[doc = " LinkedList supports refcounted elements using this adapter class. Clients\n using LinkedList<RefPtr<T>> will get a data structure that holds a strong\n reference to T as long as T is in the list."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct LinkedListElementTraits {
                pub _address: u8,
            }
            pub type LinkedListElementTraits_RawType<T> = *mut T;
            pub type LinkedListElementTraits_ConstRawType<T> = *const T;
            pub type LinkedListElementTraits_ClientType<T> = *mut T;
            pub type LinkedListElementTraits_ConstClientType<T> = *const T;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SupportsThreadSafeWeakPtrBase {
                pub _address: u8,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of SupportsThreadSafeWeakPtrBase"]
                    [::std::mem::size_of::<SupportsThreadSafeWeakPtrBase>() - 1usize];
                ["Alignment of SupportsThreadSafeWeakPtrBase"]
                    [::std::mem::align_of::<SupportsThreadSafeWeakPtrBase>() - 1usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct ThreadSafeWeakReference {
                pub _base: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mStrongCnt: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mPtr: *mut root::mozilla::detail::SupportsThreadSafeWeakPtrBase,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ThreadSafeWeakReference"]
                    [::std::mem::size_of::<ThreadSafeWeakReference>() - 24usize];
                ["Alignment of ThreadSafeWeakReference"]
                    [::std::mem::align_of::<ThreadSafeWeakReference>() - 8usize];
                ["Offset of field: ThreadSafeWeakReference::mStrongCnt"]
                    [::std::mem::offset_of!(ThreadSafeWeakReference, mStrongCnt) - 8usize];
                ["Offset of field: ThreadSafeWeakReference::mPtr"]
                    [::std::mem::offset_of!(ThreadSafeWeakReference, mPtr) - 16usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SmartPtrTraits {
                pub _address: u8,
            }
            #[repr(C)]
            #[repr(align(8))]
            #[derive(Debug, Copy, Clone)]
            pub struct WeakReference {
                pub _bindgen_opaque_blob: root::__BindgenOpaqueArray8<[u8; 16usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of WeakReference"][::std::mem::size_of::<WeakReference>() - 16usize];
                ["Alignment of WeakReference"][::std::mem::align_of::<WeakReference>() - 8usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FramePropertyTypeHelper {
                pub _address: u8,
            }
            pub type FramePropertyTypeHelper_Type<T> = *mut T;
        }
        pub type MallocSizeOf =
            ::std::option::Option<unsafe extern "C" fn(p: *const ::std::os::raw::c_void) -> usize>;
        pub mod dom {
            #[allow(unused_imports)]
            use self::super::super::super::root;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Promise {
                _unused: [u8; 0],
            }
            pub mod binding_detail {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            pub type FontFaceLoadedRejectReason = u8;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FontFaceSet {
                _unused: [u8; 0],
            }
            #[doc = " Event-based element states."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ElementState {
                pub bits: u64,
            }
            pub type ElementState_InternalType = ::std::os::raw::c_ulong;
            unsafe extern "C" {
                #[doc = " The mouse is down on this element.\n <https://html.spec.whatwg.org/multipage/#selector-active>\n FIXME(#7333): set/unset this when appropriate"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState6ACTIVEE"]
                pub static ElementState_ACTIVE: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " This element has focus.\n <https://html.spec.whatwg.org/multipage/#selector-focus>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState5FOCUSE"]
                pub static ElementState_FOCUS: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " The mouse is hovering over this element.\n <https://html.spec.whatwg.org/multipage/#selector-hover>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState5HOVERE"]
                pub static ElementState_HOVER: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Content is enabled (and can be disabled).\n <http://www.whatwg.org/html/#selector-enabled>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7ENABLEDE"]
                pub static ElementState_ENABLED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Content is disabled.\n <http://www.whatwg.org/html/#selector-disabled>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8DISABLEDE"]
                pub static ElementState_DISABLED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Content is checked.\n <https://html.spec.whatwg.org/multipage/#selector-checked>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7CHECKEDE"]
                pub static ElementState_CHECKED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-indeterminate>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState13INDETERMINATEE"]
                pub static ElementState_INDETERMINATE: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-placeholder-shown>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState17PLACEHOLDER_SHOWNE"]
                pub static ElementState_PLACEHOLDER_SHOWN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-target>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState9URLTARGETE"]
                pub static ElementState_URLTARGET: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://fullscreen.spec.whatwg.org/#%3Afullscreen-pseudo-class>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState10FULLSCREENE"]
                pub static ElementState_FULLSCREEN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-valid>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState5VALIDE"]
                pub static ElementState_VALID: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-invalid>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7INVALIDE"]
                pub static ElementState_INVALID: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://drafts.csswg.org/selectors-4/#user-valid-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState10USER_VALIDE"]
                pub static ElementState_USER_VALID: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://drafts.csswg.org/selectors-4/#user-invalid-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState12USER_INVALIDE"]
                pub static ElementState_USER_INVALID: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " All the validity bits at once."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState15VALIDITY_STATESE"]
                pub static ElementState_VALIDITY_STATES: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard: https://developer.mozilla.org/en-US/docs/Web/CSS/:-moz-broken"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState6BROKENE"]
                pub static ElementState_BROKEN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-required>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8REQUIREDE"]
                pub static ElementState_REQUIRED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-optional>\n We use an underscore to workaround a silly windows.h define."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState9OPTIONAL_E"]
                pub static ElementState_OPTIONAL_: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-defined>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7DEFINEDE"]
                pub static ElementState_DEFINED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-visited>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7VISITEDE"]
                pub static ElementState_VISITED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-link>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState9UNVISITEDE"]
                pub static ElementState_UNVISITED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://drafts.csswg.org/selectors-4/#the-any-link-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState20VISITED_OR_UNVISITEDE"]
                pub static ElementState_VISITED_OR_UNVISITED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard: https://developer.mozilla.org/en-US/docs/Web/CSS/:-moz-drag-over"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8DRAGOVERE"]
                pub static ElementState_DRAGOVER: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-in-range>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7INRANGEE"]
                pub static ElementState_INRANGE: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-out-of-range>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState10OUTOFRANGEE"]
                pub static ElementState_OUTOFRANGE: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-read-only>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8READONLYE"]
                pub static ElementState_READONLY: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-read-write>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState9READWRITEE"]
                pub static ElementState_READWRITE: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#selector-default>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7DEFAULTE"]
                pub static ElementState_DEFAULT: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState7OPTIMUME"]
                pub static ElementState_OPTIMUM: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState11SUB_OPTIMUME"]
                pub static ElementState_SUB_OPTIMUM: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState15SUB_SUB_OPTIMUME"]
                pub static ElementState_SUB_SUB_OPTIMUM: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " All the above <meter> bits in one place."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState20METER_OPTIMUM_STATESE"]
                pub static ElementState_METER_OPTIMUM_STATES: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState22INCREMENT_SCRIPT_LEVELE"]
                pub static ElementState_INCREMENT_SCRIPT_LEVEL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://drafts.csswg.org/selectors-4/#the-focus-visible-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState9FOCUSRINGE"]
                pub static ElementState_FOCUSRING: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://drafts.csswg.org/selectors-4/#the-focus-within-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState12FOCUS_WITHINE"]
                pub static ElementState_FOCUS_WITHIN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " :dir matching; the states are used for dynamic change detection.\n State that elements that match :dir(ltr) are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState3LTRE"]
                pub static ElementState_LTR: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State that elements that match :dir(rtl) are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState3RTLE"]
                pub static ElementState_RTL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State that HTML elements that have a \"dir\" attr are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState12HAS_DIR_ATTRE"]
                pub static ElementState_HAS_DIR_ATTR: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State that HTML elements with dir=\"ltr\" (or something\n case-insensitively equal to \"ltr\") are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState16HAS_DIR_ATTR_LTRE"]
                pub static ElementState_HAS_DIR_ATTR_LTR: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State that HTML elements with dir=\"rtl\" (or something\n case-insensitively equal to \"rtl\") are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState16HAS_DIR_ATTR_RTLE"]
                pub static ElementState_HAS_DIR_ATTR_RTL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State that HTML <bdi> elements without a valid-valued \"dir\" attr or\n any HTML elements (including <bdi>) with dir=\"auto\" (or something\n case-insensitively equal to \"auto\") are in."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState22HAS_DIR_ATTR_LIKE_AUTOE"]
                pub static ElementState_HAS_DIR_ATTR_LIKE_AUTO: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8AUTOFILLE"]
                pub static ElementState_AUTOFILL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Non-standard & undocumented."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState16AUTOFILL_PREVIEWE"]
                pub static ElementState_AUTOFILL_PREVIEW: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State for modal elements:\n <https://drafts.csswg.org/selectors-4/#modal-state>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState5MODALE"]
                pub static ElementState_MODAL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " <https://html.spec.whatwg.org/multipage/#inert-subtrees>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState5INERTE"]
                pub static ElementState_INERT: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " State for the topmost modal element in top layer"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState13TOPMOST_MODALE"]
                pub static ElementState_TOPMOST_MODAL: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Initially used for the devtools highlighter, but now somehow only\n used for the devtools accessibility inspector."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState20DEVTOOLS_HIGHLIGHTEDE"]
                pub static ElementState_DEVTOOLS_HIGHLIGHTED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Used for the devtools style editor. Probably should go away."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState25STYLEEDITOR_TRANSITIONINGE"]
                pub static ElementState_STYLEEDITOR_TRANSITIONING: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " For :-moz-value-empty (to show widgets like the reveal password\n button or the clear button)."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState11VALUE_EMPTYE"]
                pub static ElementState_VALUE_EMPTY: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " For :-moz-revealed."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState8REVEALEDE"]
                pub static ElementState_REVEALED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " https://html.spec.whatwg.org/#selector-popover-open\n Match element's popover visibility state of showing"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState12POPOVER_OPENE"]
                pub static ElementState_POPOVER_OPEN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " https://drafts.csswg.org/css-scoping-1/#the-has-slotted-pseudo\n Match whether a slot element has assigned nodes"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState11HAS_SLOTTEDE"]
                pub static ElementState_HAS_SLOTTED: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " https://drafts.csswg.org/selectors-4/#open-state\n Match whether an openable element is currently open"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState4OPENE"]
                pub static ElementState_OPEN: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " For :active-view-transition.\n <https://www.w3.org/TR/css-view-transitions-2/#the-active-view-transition-pseudo>"]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState22ACTIVE_VIEW_TRANSITIONE"]
                pub static ElementState_ACTIVE_VIEW_TRANSITION: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " For :-moz-suppress-for-print-selection."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState28SUPPRESS_FOR_PRINT_SELECTIONE"]
                pub static ElementState_SUPPRESS_FOR_PRINT_SELECTION:
                    root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " https://drafts.csswg.org/selectors-5/#headings\n These 4 bits are used to pack the elements heading level into the element state\n Heading levels can be from 1-9 so 4 bits allows us to express the full range."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState18HEADING_LEVEL_BITSE"]
                pub static ElementState_HEADING_LEVEL_BITS: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[doc = " Some convenience unions."]
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState10DIR_STATESE"]
                pub static ElementState_DIR_STATES: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState15DIR_ATTR_STATESE"]
                pub static ElementState_DIR_ATTR_STATES: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState15DISABLED_STATESE"]
                pub static ElementState_DISABLED_STATES: root::mozilla::dom::ElementState;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom12ElementState15REQUIRED_STATESE"]
                pub static ElementState_REQUIRED_STATES: root::mozilla::dom::ElementState;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ElementState"][::std::mem::size_of::<ElementState>() - 8usize];
                ["Alignment of ElementState"][::std::mem::align_of::<ElementState>() - 8usize];
                ["Offset of field: ElementState::bits"]
                    [::std::mem::offset_of!(ElementState, bits) - 0usize];
            };
            #[doc = " Event-based document states."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DocumentState {
                pub bits: u64,
            }
            pub type DocumentState_InternalType = ::std::os::raw::c_ulong;
            unsafe extern "C" {
                #[doc = " Window activation status"]
                #[link_name = "\u{1}_ZN7mozilla3dom13DocumentState15WINDOW_INACTIVEE"]
                pub static DocumentState_WINDOW_INACTIVE: root::mozilla::dom::DocumentState;
            }
            unsafe extern "C" {
                #[doc = " RTL locale: specific to the XUL localedir attribute"]
                #[link_name = "\u{1}_ZN7mozilla3dom13DocumentState10RTL_LOCALEE"]
                pub static DocumentState_RTL_LOCALE: root::mozilla::dom::DocumentState;
            }
            unsafe extern "C" {
                #[doc = " LTR locale: specific to the XUL localedir attribute"]
                #[link_name = "\u{1}_ZN7mozilla3dom13DocumentState10LTR_LOCALEE"]
                pub static DocumentState_LTR_LOCALE: root::mozilla::dom::DocumentState;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom13DocumentState18ALL_LOCALEDIR_BITSE"]
                pub static DocumentState_ALL_LOCALEDIR_BITS: root::mozilla::dom::DocumentState;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of DocumentState"][::std::mem::size_of::<DocumentState>() - 8usize];
                ["Alignment of DocumentState"][::std::mem::align_of::<DocumentState>() - 8usize];
                ["Offset of field: DocumentState::bits"]
                    [::std::mem::offset_of!(DocumentState, bits) - 0usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct CSSImportRule {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BrowsingContext {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AllUnionBase {
                pub _address: u8,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of AllUnionBase"][::std::mem::size_of::<AllUnionBase>() - 1usize];
                ["Alignment of AllUnionBase"][::std::mem::align_of::<AllUnionBase>() - 1usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AllOwningUnionBase {
                pub _address: u8,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of AllOwningUnionBase"]
                    [::std::mem::size_of::<AllOwningUnionBase>() - 1usize];
                ["Alignment of AllOwningUnionBase"]
                    [::std::mem::align_of::<AllOwningUnionBase>() - 1usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Sequence {
                pub _address: u8,
            }
            #[repr(u32)]
            #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
            pub enum CallerType {
                System = 0,
                NonSystem = 1,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Nullable {
                pub _address: u8,
            }
            pub mod prototypes {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            pub mod constructors {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            pub mod namedpropertiesobjects {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct EventListener {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Navigation {
                _unused: [u8; 0],
            }
            #[repr(C)]
            pub struct EventTarget {
                pub _base: root::nsISupports,
                pub _base_1: root::nsWrapperCache,
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
            }
            pub type EventTarget_HasThreadSafeRefCnt = root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of EventTarget"][::std::mem::size_of::<EventTarget>() - 40usize];
                ["Alignment of EventTarget"][::std::mem::align_of::<EventTarget>() - 8usize];
                ["Offset of field: EventTarget::mRefCnt"]
                    [::std::mem::offset_of!(EventTarget, mRefCnt) - 32usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BrowserChild {
                _unused: [u8; 0],
            }
            #[repr(C)]
            pub struct CacheablePerformanceTimingData {
                pub mEncodedBodySize: u64,
                pub mDecodedBodySize: u64,
                pub mResponseStatus: u16,
                pub mRedirectCount: u8,
                pub mBodyInfoAccessAllowed: root::nsITimedChannel_BodyInfoAccess,
                pub mAllRedirectsSameOrigin: bool,
                pub mAllRedirectsPassTAO: bool,
                pub mSecureConnection: bool,
                pub mTimingAllowed: bool,
                pub mInitialized: bool,
                pub mNextHopProtocol: crate::gecko_bindings::structs::nsString,
                pub mContentType: crate::gecko_bindings::structs::nsString,
                pub mServerTiming: crate::gecko_bindings::structs::nsTArray<root::nsCOMPtr<root::nsIServerTiming>>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of CacheablePerformanceTimingData"]
                    [::std::mem::size_of::<CacheablePerformanceTimingData>() - 72usize];
                ["Alignment of CacheablePerformanceTimingData"]
                    [::std::mem::align_of::<CacheablePerformanceTimingData>() - 8usize];
                ["Offset of field: CacheablePerformanceTimingData::mEncodedBodySize"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mEncodedBodySize
                ) - 0usize];
                ["Offset of field: CacheablePerformanceTimingData::mDecodedBodySize"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mDecodedBodySize
                ) - 8usize];
                ["Offset of field: CacheablePerformanceTimingData::mResponseStatus"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mResponseStatus
                ) - 16usize];
                ["Offset of field: CacheablePerformanceTimingData::mRedirectCount"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mRedirectCount
                ) - 18usize];
                ["Offset of field: CacheablePerformanceTimingData::mBodyInfoAccessAllowed"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mBodyInfoAccessAllowed
                )
                    - 19usize];
                ["Offset of field: CacheablePerformanceTimingData::mAllRedirectsSameOrigin"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mAllRedirectsSameOrigin
                )
                    - 20usize];
                ["Offset of field: CacheablePerformanceTimingData::mAllRedirectsPassTAO"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mAllRedirectsPassTAO
                )
                    - 21usize];
                ["Offset of field: CacheablePerformanceTimingData::mSecureConnection"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mSecureConnection
                ) - 22usize];
                ["Offset of field: CacheablePerformanceTimingData::mTimingAllowed"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mTimingAllowed
                ) - 23usize];
                ["Offset of field: CacheablePerformanceTimingData::mInitialized"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mInitialized
                ) - 24usize];
                ["Offset of field: CacheablePerformanceTimingData::mNextHopProtocol"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mNextHopProtocol
                ) - 32usize];
                ["Offset of field: CacheablePerformanceTimingData::mContentType"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mContentType
                ) - 48usize];
                ["Offset of field: CacheablePerformanceTimingData::mServerTiming"][::std::mem::offset_of!(
                    CacheablePerformanceTimingData,
                    mServerTiming
                ) - 64usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BrowserParent {
                _unused: [u8; 0],
            }
            pub const FetchPriority_High: FetchPriority = 0;
            pub const FetchPriority_Low: FetchPriority = 1;
            pub const FetchPriority_Auto: FetchPriority = 2;
            pub type FetchPriority = u8;
            #[repr(C)]
            pub struct NodeInfo {
                pub mRefCnt: root::nsCycleCollectingAutoRefCnt,
                pub mDocument: *mut root::mozilla::dom::Document,
                pub mInner: root::mozilla::dom::NodeInfo_NodeInfoInner,
                pub mOwnerManager: root::RefPtr<root::nsNodeInfoManager>,
                pub mQualifiedName: crate::gecko_bindings::structs::nsString,
                pub mNodeName: crate::gecko_bindings::structs::nsString,
                pub mLocalName: crate::gecko_bindings::structs::nsString,
            }
            pub type NodeInfo_HasThreadSafeRefCnt = root::std::false_type;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct NodeInfo_cycleCollection {
                pub _base: root::nsCycleCollectionParticipant,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of NodeInfo_cycleCollection"]
                    [::std::mem::size_of::<NodeInfo_cycleCollection>() - 16usize];
                ["Alignment of NodeInfo_cycleCollection"]
                    [::std::mem::align_of::<NodeInfo_cycleCollection>() - 8usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct NodeInfo_NodeInfoInner {
                pub mName: *mut root::nsAtom,
                pub mPrefix: *mut root::nsAtom,
                pub mNamespaceID: i32,
                pub mNodeType: u16,
                pub mNameString: *const crate::gecko_bindings::structs::nsAString,
                pub mExtraName: *mut root::nsAtom,
                pub mHash: root::__BindgenOpaqueArray<[u32; 2usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of NodeInfo_NodeInfoInner"]
                    [::std::mem::size_of::<NodeInfo_NodeInfoInner>() - 48usize];
                ["Alignment of NodeInfo_NodeInfoInner"]
                    [::std::mem::align_of::<NodeInfo_NodeInfoInner>() - 8usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mName"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mName) - 0usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mPrefix"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mPrefix) - 8usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mNamespaceID"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mNamespaceID) - 16usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mNodeType"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mNodeType) - 20usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mNameString"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mNameString) - 24usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mExtraName"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mExtraName) - 32usize];
                ["Offset of field: NodeInfo_NodeInfoInner::mHash"]
                    [::std::mem::offset_of!(NodeInfo_NodeInfoInner, mHash) - 40usize];
            };
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom8NodeInfo21_cycleCollectorGlobalE"]
                pub static mut NodeInfo__cycleCollectorGlobal:
                    root::mozilla::dom::NodeInfo_cycleCollection;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of NodeInfo"][::std::mem::size_of::<NodeInfo>() - 120usize];
                ["Alignment of NodeInfo"][::std::mem::align_of::<NodeInfo>() - 8usize];
                ["Offset of field: NodeInfo::mRefCnt"]
                    [::std::mem::offset_of!(NodeInfo, mRefCnt) - 0usize];
                ["Offset of field: NodeInfo::mDocument"]
                    [::std::mem::offset_of!(NodeInfo, mDocument) - 8usize];
                ["Offset of field: NodeInfo::mInner"]
                    [::std::mem::offset_of!(NodeInfo, mInner) - 16usize];
                ["Offset of field: NodeInfo::mOwnerManager"]
                    [::std::mem::offset_of!(NodeInfo, mOwnerManager) - 64usize];
                ["Offset of field: NodeInfo::mQualifiedName"]
                    [::std::mem::offset_of!(NodeInfo, mQualifiedName) - 72usize];
                ["Offset of field: NodeInfo::mNodeName"]
                    [::std::mem::offset_of!(NodeInfo, mNodeName) - 88usize];
                ["Offset of field: NodeInfo::mLocalName"]
                    [::std::mem::offset_of!(NodeInfo, mLocalName) - 104usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct DOMArena {
                pub mRefCnt: root::nsAutoRefCnt,
                pub mArenaId: root::arena_id_t,
            }
            pub type DOMArena_HasThreadSafeRefCnt = root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of DOMArena"][::std::mem::size_of::<DOMArena>() - 16usize];
                ["Alignment of DOMArena"][::std::mem::align_of::<DOMArena>() - 8usize];
                ["Offset of field: DOMArena::mRefCnt"]
                    [::std::mem::offset_of!(DOMArena, mRefCnt) - 0usize];
                ["Offset of field: DOMArena::mArenaId"]
                    [::std::mem::offset_of!(DOMArena, mArenaId) - 8usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AbstractRange {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BoxQuadOptions {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ConvertCoordinateOptions {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DocGroup {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMPoint {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMQuad {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HTMLDialogElement {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SelectionNodeCache {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct SVGUseElement {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct TextOrElementOrDocument {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMPointInit {
                _unused: [u8; 0],
            }
            pub type AllowRangeCrossShadowBoundary = bool;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AudioContext {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ContentFrameMessageManager {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct CloseWatcherManager {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct MediaKeys {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Navigator {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Performance {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct TimeoutManager {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct WebIdentityHandler {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct WindowGlobalChild {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Function {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Report {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ReportingObserver {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[repr(align(8))]
            #[derive(Debug, Copy, Clone)]
            pub struct FrameRequestManager {
                pub _bindgen_opaque_blob: root::__BindgenOpaqueArray8<[u8; 48usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FrameRequestManager"]
                    [::std::mem::size_of::<FrameRequestManager>() - 48usize];
                ["Alignment of FrameRequestManager"]
                    [::std::mem::align_of::<FrameRequestManager>() - 8usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct TreeOrderedArray {
                pub _address: u8,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct TreeOrderedArray_RawTypeExtractor {
                pub _address: u8,
            }
            pub type TreeOrderedArray_Node = root::mozilla::dom::TreeOrderedArray_RawTypeExtractor;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BindContext {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct UnbindContext {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct StyleSheetList {
                _unused: [u8; 0],
            }
            #[doc = " A class meant to be shared by ShadowRoot and Document, that holds a list of\n stylesheets.\n\n TODO(emilio, bug 1418159): In the future this should hold most of the\n relevant style state, this should allow us to fix bug 548397."]
            #[repr(C)]
            pub struct DocumentOrShadowRoot {
                pub mStyleSheets: crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::StyleSheet>>,
                pub mDOMStyleSheets: root::RefPtr<root::mozilla::dom::StyleSheetList>,
                #[doc = " Style sheets that are adopted by assinging to the `adoptedStyleSheets`\n WebIDL atribute. These can only be constructed stylesheets."]
                pub mAdoptedStyleSheets: crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::StyleSheet>>,
                pub mIdentifierMap: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mAsNode: *mut root::nsINode,
                pub mKind: root::mozilla::dom::DocumentOrShadowRoot_Kind,
            }
            pub const DocumentOrShadowRoot_Kind_Document: DocumentOrShadowRoot_Kind = 0;
            pub const DocumentOrShadowRoot_Kind_ShadowRoot: DocumentOrShadowRoot_Kind = 1;
            pub type DocumentOrShadowRoot_Kind = ::std::os::raw::c_int;
            #[doc = " This gets fired when the element that an id refers to changes.\n This fires at difficult times. It is generally not safe to do anything\n which could modify the DOM in any way. Use\n nsContentUtils::AddScriptRunner.\n @return true to keep the callback in the callback set, false\n to remove it."]
            pub type DocumentOrShadowRoot_IDTargetObserver = ::std::option::Option<
                unsafe extern "C" fn(
                    aOldElement: *mut root::mozilla::dom::Element,
                    aNewelement: *mut root::mozilla::dom::Element,
                    aData: *mut ::std::os::raw::c_void,
                ) -> bool,
            >;
            #[doc = " Templated hash set. Don't use this directly, but use nsTHashSet instead\n (defined as a type alias in nsHashtablesFwd.h).\n\n @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h\n   for a complete specification."]
            pub type DocumentOrShadowRoot_StyleSheetSet =
                root::__BindgenOpaqueArray8<[u8; 32usize]>;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of DocumentOrShadowRoot"]
                    [::std::mem::size_of::<DocumentOrShadowRoot>() - 72usize];
                ["Alignment of DocumentOrShadowRoot"]
                    [::std::mem::align_of::<DocumentOrShadowRoot>() - 8usize];
                ["Offset of field: DocumentOrShadowRoot::mStyleSheets"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mStyleSheets) - 0usize];
                ["Offset of field: DocumentOrShadowRoot::mDOMStyleSheets"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mDOMStyleSheets) - 8usize];
                ["Offset of field: DocumentOrShadowRoot::mAdoptedStyleSheets"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mAdoptedStyleSheets) - 16usize];
                ["Offset of field: DocumentOrShadowRoot::mIdentifierMap"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mIdentifierMap) - 24usize];
                ["Offset of field: DocumentOrShadowRoot::mAsNode"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mAsNode) - 56usize];
                ["Offset of field: DocumentOrShadowRoot::mKind"]
                    [::std::mem::offset_of!(DocumentOrShadowRoot, mKind) - 64usize];
            };
            #[doc = " Struct that stores info on an attribute. The name and value must either both\n be null or both be non-null.\n\n Note that, just as the pointers returned by GetAttrNameAt, the pointers that\n this struct hold are only valid until the element or its attributes are\n mutated (directly or via script)."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BorrowedAttrInfo {
                pub mName: *const root::nsAttrName,
                pub mValue: *const root::nsAttrValue,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of BorrowedAttrInfo"][::std::mem::size_of::<BorrowedAttrInfo>() - 16usize];
                ["Alignment of BorrowedAttrInfo"]
                    [::std::mem::align_of::<BorrowedAttrInfo>() - 8usize];
                ["Offset of field: BorrowedAttrInfo::mName"]
                    [::std::mem::offset_of!(BorrowedAttrInfo, mName) - 0usize];
                ["Offset of field: BorrowedAttrInfo::mValue"]
                    [::std::mem::offset_of!(BorrowedAttrInfo, mValue) - 8usize];
            };
            pub type DOMTokenListSupportedToken = *const ::std::os::raw::c_char;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct nsRadioGroupStruct {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct RadioGroupContainer {
                pub mRadioGroups: root::__BindgenOpaqueArray8<[u8; 32usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of RadioGroupContainer"]
                    [::std::mem::size_of::<RadioGroupContainer>() - 32usize];
                ["Alignment of RadioGroupContainer"]
                    [::std::mem::align_of::<RadioGroupContainer>() - 8usize];
                ["Offset of field: RadioGroupContainer::mRadioGroups"]
                    [::std::mem::offset_of!(RadioGroupContainer, mRadioGroups) - 0usize];
            };
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct CustomElementData {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct StylePropertyMap {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct StylePropertyMapReadOnly {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMIntersectionObserver {
                _unused: [u8; 0],
            }
            #[repr(C)]
            pub struct FragmentOrElement {
                pub _base: root::nsIContent,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FragmentOrElement_cycleCollection {
                pub _base: root::nsIContent_cycleCollection,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FragmentOrElement_cycleCollection"]
                    [::std::mem::size_of::<FragmentOrElement_cycleCollection>() - 16usize];
                ["Alignment of FragmentOrElement_cycleCollection"]
                    [::std::mem::align_of::<FragmentOrElement_cycleCollection>() - 8usize];
            };
            #[doc = " There are a set of DOM- and scripting-specific instance variables\n that may only be instantiated when a content object is accessed\n through the DOM. Rather than burn actual slots in the content\n objects for each of these instance variables, we put them off\n in a side structure that's only allocated when the content is\n accessed through the DOM."]
            #[repr(C)]
            pub struct FragmentOrElement_nsExtendedDOMSlots {
                pub _base: root::nsIContent_nsExtendedContentSlots,
                #[doc = " SMIL Overridde style rules (for SMIL animation of CSS properties)\n @see Element::GetSMILOverrideStyle"]
                pub mSMILOverrideStyle: root::RefPtr<root::nsDOMCSSAttributeDeclaration>,
                #[doc = " Holds any SMIL override style declaration for this element."]
                pub mSMILOverrideStyleDeclaration: root::RefPtr<root::mozilla::DeclarationBlock>,
                #[doc = " The controllers of the XUL Element."]
                pub mControllers: root::nsCOMPtr<root::nsIControllers>,
                #[doc = " An object implementing the .labels property for this element."]
                pub mLabelsList: root::RefPtr<root::nsLabelsNodeList>,
                #[doc = " ShadowRoot bound to the element."]
                pub mShadowRoot: root::RefPtr<root::mozilla::dom::ShadowRoot>,
                #[doc = " Web components custom element data."]
                pub mCustomElementData: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                #[doc = " Web animations data."]
                pub mAnimations: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                #[doc = " PopoverData for the element."]
                pub mPopoverData: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                #[doc = " The association to a popover that this element was the source\n showing a popover, e.g. the source in `el.showPopover({source})`."]
                pub mAssociatedPopover: root::nsWeakPtr,
                #[doc = " CustomStates for the element."]
                pub mCustomStates: crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::nsAtom>>,
                #[doc = " RadioGroupContainer for radio buttons grouped under this disconnected\n element."]
                pub mRadioGroupContainer: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                #[doc = " Last remembered size (in CSS pixels) for the element.\n @see {@link https://drafts.csswg.org/css-sizing-4/#last-remembered}"]
                pub mLastRememberedBSize: root::__BindgenOpaqueArray<[u32; 2usize]>,
                pub mLastRememberedISize: root::__BindgenOpaqueArray<[u32; 2usize]>,
                #[doc = " Whether the content of this element is relevant for the purposes\n of `content-visibility: auto.\n Reflects 'relevant to the user' concept, see\n https://drafts.csswg.org/css-contain/#relevant-to-the-user."]
                pub mContentRelevancy: root::__BindgenOpaqueArray<[u8; 2usize]>,
                #[doc = " Whether the content of this element is considered visible for\n the purposes of `content-visibility: auto.\n Reflects 'proximity to the viewport' concept, see\n https://drafts.csswg.org/css-contain/#proximity-to-the-viewport."]
                pub mVisibleForContentVisibility: root::__BindgenOpaqueArray<[u8; 2usize]>,
                #[doc = " Whether content-visibility: auto is temporarily visible for\n the purposes of the descendant of scrollIntoView."]
                pub mTemporarilyVisibleForScrolledIntoViewDescendant: bool,
                #[doc = " The .dataset attribute.\n @see nsGenericHTMLElement::GetDataset"]
                pub mDataset: *mut root::nsDOMStringMap,
                #[doc = " An object implementing the .part property for this element."]
                pub mPart: root::RefPtr<root::nsDOMTokenList>,
                #[doc = " Explicitly set attr-element, see\n https://html.spec.whatwg.org/#explicitly-set-attr-element"]
                pub mExplicitlySetAttrElementMap: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                #[doc = " Explicitly set attr-elements, see\n https://html.spec.whatwg.org/#explicitly-set-attr-elements\n\n The first member of the pair are the explicitly set attr-elements. The\n second member is the cached attr-associated elements."]
                pub mAttrElementsMap: root::__BindgenOpaqueArray8<[u8; 32usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FragmentOrElement_nsExtendedDOMSlots"]
                    [::std::mem::size_of::<FragmentOrElement_nsExtendedDOMSlots>() - 224usize];
                ["Alignment of FragmentOrElement_nsExtendedDOMSlots"]
                    [::std::mem::align_of::<FragmentOrElement_nsExtendedDOMSlots>() - 8usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mSMILOverrideStyle"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mSMILOverrideStyle
                )
                    - 32usize];
                [
                    "Offset of field: FragmentOrElement_nsExtendedDOMSlots::mSMILOverrideStyleDeclaration",
                ][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mSMILOverrideStyleDeclaration
                ) - 40usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mControllers"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mControllers
                )
                    - 48usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mLabelsList"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mLabelsList
                ) - 56usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mShadowRoot"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mShadowRoot
                ) - 64usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mCustomElementData"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mCustomElementData
                )
                    - 72usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mAnimations"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mAnimations
                ) - 80usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mPopoverData"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mPopoverData
                )
                    - 88usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mAssociatedPopover"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mAssociatedPopover
                )
                    - 96usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mCustomStates"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mCustomStates
                )
                    - 104usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mRadioGroupContainer"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mRadioGroupContainer
                )
                    - 112usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mLastRememberedBSize"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mLastRememberedBSize
                )
                    - 120usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mLastRememberedISize"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mLastRememberedISize
                )
                    - 128usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mContentRelevancy"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mContentRelevancy
                )
                    - 136usize];
                [
                    "Offset of field: FragmentOrElement_nsExtendedDOMSlots::mVisibleForContentVisibility",
                ][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mVisibleForContentVisibility
                ) - 138usize];
                [
                    "Offset of field: FragmentOrElement_nsExtendedDOMSlots::mTemporarilyVisibleForScrolledIntoViewDescendant",
                ][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mTemporarilyVisibleForScrolledIntoViewDescendant
                ) - 140usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mDataset"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mDataset
                ) - 144usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mPart"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mPart
                ) - 152usize];
                [
                    "Offset of field: FragmentOrElement_nsExtendedDOMSlots::mExplicitlySetAttrElementMap",
                ][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mExplicitlySetAttrElementMap
                ) - 160usize];
                ["Offset of field: FragmentOrElement_nsExtendedDOMSlots::mAttrElementsMap"][::std::mem::offset_of!(
                    FragmentOrElement_nsExtendedDOMSlots,
                    mAttrElementsMap
                )
                    - 192usize];
            };
            #[repr(C)]
            pub struct FragmentOrElement_nsDOMSlots {
                pub _base: root::nsIContent_nsContentSlots,
                #[doc = " The .style attribute (an interface that forwards to the actual\n style rules)\n @see nsGenericHTMLElement::GetStyle"]
                pub mStyle: root::nsCOMPtr<root::nsDOMCSSDeclaration>,
                #[doc = " @see Element::Attributes"]
                pub mAttributeMap: root::RefPtr<root::nsDOMAttributeMap>,
                #[doc = " An object implementing the .children property for this element."]
                pub mChildrenList: root::RefPtr<root::nsContentList>,
                #[doc = " An object implementing the .classList property for this element."]
                pub mClassList: root::RefPtr<root::nsDOMTokenList>,
                #[doc = " An object implementing the .computedStyleMap() method for this element."]
                pub mComputedStyleMap: root::RefPtr<root::mozilla::dom::StylePropertyMapReadOnly>,
                #[doc = " An object implementing the .attributeStyleMap property for this element."]
                pub mAttributeStyleMap: root::RefPtr<root::mozilla::dom::StylePropertyMap>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FragmentOrElement_nsDOMSlots"]
                    [::std::mem::size_of::<FragmentOrElement_nsDOMSlots>() - 120usize];
                ["Alignment of FragmentOrElement_nsDOMSlots"]
                    [::std::mem::align_of::<FragmentOrElement_nsDOMSlots>() - 8usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mStyle"]
                    [::std::mem::offset_of!(FragmentOrElement_nsDOMSlots, mStyle) - 72usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mAttributeMap"]
                    [::std::mem::offset_of!(FragmentOrElement_nsDOMSlots, mAttributeMap) - 80usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mChildrenList"]
                    [::std::mem::offset_of!(FragmentOrElement_nsDOMSlots, mChildrenList) - 88usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mClassList"]
                    [::std::mem::offset_of!(FragmentOrElement_nsDOMSlots, mClassList) - 96usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mComputedStyleMap"][::std::mem::offset_of!(
                    FragmentOrElement_nsDOMSlots,
                    mComputedStyleMap
                ) - 104usize];
                ["Offset of field: FragmentOrElement_nsDOMSlots::mAttributeStyleMap"][::std::mem::offset_of!(
                    FragmentOrElement_nsDOMSlots,
                    mAttributeStyleMap
                ) - 112usize];
            };
            #[doc = " In case ExtendedDOMSlots is needed before normal DOMSlots, an instance of\n FatSlots class, which combines those two slot types, is created.\n This way we can avoid extra allocation for ExtendedDOMSlots.\n FatSlots is useful for example when creating Custom Elements."]
            #[repr(C)]
            pub struct FragmentOrElement_FatSlots {
                pub _base: root::mozilla::dom::FragmentOrElement_nsDOMSlots,
                pub _base_1: root::mozilla::dom::FragmentOrElement_nsExtendedDOMSlots,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FragmentOrElement_FatSlots"]
                    [::std::mem::size_of::<FragmentOrElement_FatSlots>() - 344usize];
                ["Alignment of FragmentOrElement_FatSlots"]
                    [::std::mem::align_of::<FragmentOrElement_FatSlots>() - 8usize];
            };
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom17FragmentOrElement21_cycleCollectorGlobalE"]
                pub static mut FragmentOrElement__cycleCollectorGlobal:
                    root::mozilla::dom::FragmentOrElement_cycleCollection;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of FragmentOrElement"]
                    [::std::mem::size_of::<FragmentOrElement>() - 104usize];
                ["Alignment of FragmentOrElement"]
                    [::std::mem::align_of::<FragmentOrElement>() - 8usize];
            };
            pub const ShadowRootMode_Open: ShadowRootMode = 0;
            pub const ShadowRootMode_Closed: ShadowRootMode = 1;
            pub type ShadowRootMode = u8;
            pub const SlotAssignmentMode_Manual: SlotAssignmentMode = 0;
            pub const SlotAssignmentMode_Named: SlotAssignmentMode = 1;
            pub type SlotAssignmentMode = u8;
            pub mod ShadowRoot_Binding {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Link {
                _unused: [u8; 0],
            }
            #[repr(C)]
            pub struct Element {
                pub _base: root::mozilla::dom::FragmentOrElement,
                pub mState: root::mozilla::dom::ElementState,
                pub mServoData: crate::gecko_bindings::structs::RustCell<*mut crate::gecko_bindings::structs::ServoNodeData>,
                pub mAttrs: root::AttrArray,
            }
            #[doc = " StyleStateLocks is used to specify which event states should be locked,\n and whether they should be locked to on or off."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Element_StyleStateLocks {
                pub mLocks: root::mozilla::dom::ElementState,
                pub mValues: root::mozilla::dom::ElementState,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Element_StyleStateLocks"]
                    [::std::mem::size_of::<Element_StyleStateLocks>() - 16usize];
                ["Alignment of Element_StyleStateLocks"]
                    [::std::mem::align_of::<Element_StyleStateLocks>() - 8usize];
                ["Offset of field: Element_StyleStateLocks::mLocks"]
                    [::std::mem::offset_of!(Element_StyleStateLocks, mLocks) - 0usize];
                ["Offset of field: Element_StyleStateLocks::mValues"]
                    [::std::mem::offset_of!(Element_StyleStateLocks, mValues) - 8usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct Element_AutoStateChangeNotifier {
                pub mElement: *mut root::mozilla::dom::Element,
                pub mOldState: root::mozilla::dom::ElementState,
                pub mNotify: bool,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Element_AutoStateChangeNotifier"]
                    [::std::mem::size_of::<Element_AutoStateChangeNotifier>() - 24usize];
                ["Alignment of Element_AutoStateChangeNotifier"]
                    [::std::mem::align_of::<Element_AutoStateChangeNotifier>() - 8usize];
                ["Offset of field: Element_AutoStateChangeNotifier::mElement"]
                    [::std::mem::offset_of!(Element_AutoStateChangeNotifier, mElement) - 0usize];
                ["Offset of field: Element_AutoStateChangeNotifier::mOldState"]
                    [::std::mem::offset_of!(Element_AutoStateChangeNotifier, mOldState) - 8usize];
                ["Offset of field: Element_AutoStateChangeNotifier::mNotify"]
                    [::std::mem::offset_of!(Element_AutoStateChangeNotifier, mNotify) - 16usize];
            };
            #[doc = " Check whether this Element's given attribute has one of a given list of\n values. If there is a match, we return the index in the list of the first\n matching value. If there was no attribute at all, then we return\n ATTR_MISSING. If there was an attribute but it didn't match, we return\n ATTR_VALUE_NO_MATCH. A non-negative result always indicates a match.\n\n @param aNameSpaceID The namespace ID of the attribute.  Must not\n                     be kNameSpaceID_Unknown.\n @param aName The name atom of the attribute.  Must not be null.\n @param aValues a nullptr-terminated array of pointers to atom values to\n test against.\n @param aCaseSensitive Whether to do a case-sensitive compare on the values.\n @return ATTR_MISSING, ATTR_VALUE_NO_MATCH or the non-negative index\n indicating the first value of aValues that matched"]
            pub type Element_AttrValuesArray = root::AttrArray_AttrValuesArray;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Element_MappedAttributeEntry {
                pub attribute: *const root::nsStaticAtom,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Element_MappedAttributeEntry"]
                    [::std::mem::size_of::<Element_MappedAttributeEntry>() - 8usize];
                ["Alignment of Element_MappedAttributeEntry"]
                    [::std::mem::align_of::<Element_MappedAttributeEntry>() - 8usize];
                ["Offset of field: Element_MappedAttributeEntry::attribute"]
                    [::std::mem::offset_of!(Element_MappedAttributeEntry, attribute) - 0usize];
            };
            pub const Element_Command_Invalid: Element_Command = 0;
            pub const Element_Command_Custom: Element_Command = 1;
            pub const Element_Command_TogglePopover: Element_Command = 2;
            pub const Element_Command_ShowPopover: Element_Command = 3;
            pub const Element_Command_HidePopover: Element_Command = 4;
            pub const Element_Command_ShowModal: Element_Command = 5;
            pub const Element_Command_RequestClose: Element_Command = 6;
            pub const Element_Command_Toggle: Element_Command = 7;
            pub const Element_Command_Close: Element_Command = 8;
            pub const Element_Command_Open: Element_Command = 9;
            pub type Element_Command = u8;
            pub const Element_Loading_Eager: Element_Loading = 0;
            pub const Element_Loading_Lazy: Element_Loading = 1;
            pub type Element_Loading = u8;
            pub const Element_ShadowRootDeclarative_No: Element_ShadowRootDeclarative = false;
            pub const Element_ShadowRootDeclarative_Yes: Element_ShadowRootDeclarative = true;
            pub type Element_ShadowRootDeclarative = bool;
            pub const Element_DelegatesFocus_No: Element_DelegatesFocus = false;
            pub const Element_DelegatesFocus_Yes: Element_DelegatesFocus = true;
            pub type Element_DelegatesFocus = bool;
            pub const Element_ShadowRootClonable_No: Element_ShadowRootClonable = false;
            pub const Element_ShadowRootClonable_Yes: Element_ShadowRootClonable = true;
            pub type Element_ShadowRootClonable = bool;
            pub const Element_ShadowRootSerializable_No: Element_ShadowRootSerializable = false;
            pub const Element_ShadowRootSerializable_Yes: Element_ShadowRootSerializable = true;
            pub type Element_ShadowRootSerializable = bool;
            pub const Element_NotifyUAWidgetSetup_No: Element_NotifyUAWidgetSetup = false;
            pub const Element_NotifyUAWidgetSetup_Yes: Element_NotifyUAWidgetSetup = true;
            pub type Element_NotifyUAWidgetSetup = bool;
            pub const Element_UnattachShadowRoot_No: Element_UnattachShadowRoot = 0;
            pub const Element_UnattachShadowRoot_Yes: Element_UnattachShadowRoot = 1;
            pub type Element_UnattachShadowRoot = ::std::os::raw::c_int;
            pub const Element_PresContextFor_eForComposedDoc: Element_PresContextFor = 0;
            pub const Element_PresContextFor_eForUncomposedDoc: Element_PresContextFor = 1;
            #[doc = " Get the presentation context for this content node.\n @return the presentation context"]
            pub type Element_PresContextFor = ::std::os::raw::c_uint;
            pub const Element_ReparseAttributes_No: Element_ReparseAttributes = 0;
            pub const Element_ReparseAttributes_Yes: Element_ReparseAttributes = 1;
            pub type Element_ReparseAttributes = ::std::os::raw::c_int;
            pub const Element_kAllServoDescendantBits: u32 = 98560;
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom7Element23sAnchorAndFormRelValuesE"]
                pub static Element_sAnchorAndFormRelValues:
                    [root::mozilla::dom::DOMTokenListSupportedToken; 0usize];
            }
            pub const Element_kNotifyDocumentObservers: bool = true;
            pub const Element_kDontNotifyDocumentObservers: bool = false;
            pub const Element_kCallAfterSetAttr: bool = true;
            pub const Element_kDontCallAfterSetAttr: bool = false;
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom7Element24sSupportedBlockingValuesE"]
                pub static Element_sSupportedBlockingValues:
                    [root::mozilla::dom::DOMTokenListSupportedToken; 0usize];
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Element"][::std::mem::size_of::<Element>() - 128usize];
                ["Alignment of Element"][::std::mem::align_of::<Element>() - 8usize];
                ["Offset of field: Element::mState"]
                    [::std::mem::offset_of!(Element, mState) - 104usize];
                ["Offset of field: Element::mServoData"]
                    [::std::mem::offset_of!(Element, mServoData) - 112usize];
                ["Offset of field: Element::mAttrs"]
                    [::std::mem::offset_of!(Element, mAttrs) - 120usize];
            };
            #[repr(C)]
            pub struct ViewportMetaData {
                pub mWidth: crate::gecko_bindings::structs::nsString,
                pub mHeight: crate::gecko_bindings::structs::nsString,
                pub mInitialScale: crate::gecko_bindings::structs::nsString,
                pub mMinimumScale: crate::gecko_bindings::structs::nsString,
                pub mMaximumScale: crate::gecko_bindings::structs::nsString,
                pub mUserScalable: crate::gecko_bindings::structs::nsString,
                pub mViewportFit: crate::gecko_bindings::structs::nsString,
                pub mInteractiveWidgetMode: crate::gecko_bindings::structs::nsString,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ViewportMetaData"][::std::mem::size_of::<ViewportMetaData>() - 128usize];
                ["Alignment of ViewportMetaData"]
                    [::std::mem::align_of::<ViewportMetaData>() - 8usize];
                ["Offset of field: ViewportMetaData::mWidth"]
                    [::std::mem::offset_of!(ViewportMetaData, mWidth) - 0usize];
                ["Offset of field: ViewportMetaData::mHeight"]
                    [::std::mem::offset_of!(ViewportMetaData, mHeight) - 16usize];
                ["Offset of field: ViewportMetaData::mInitialScale"]
                    [::std::mem::offset_of!(ViewportMetaData, mInitialScale) - 32usize];
                ["Offset of field: ViewportMetaData::mMinimumScale"]
                    [::std::mem::offset_of!(ViewportMetaData, mMinimumScale) - 48usize];
                ["Offset of field: ViewportMetaData::mMaximumScale"]
                    [::std::mem::offset_of!(ViewportMetaData, mMaximumScale) - 64usize];
                ["Offset of field: ViewportMetaData::mUserScalable"]
                    [::std::mem::offset_of!(ViewportMetaData, mUserScalable) - 80usize];
                ["Offset of field: ViewportMetaData::mViewportFit"]
                    [::std::mem::offset_of!(ViewportMetaData, mViewportFit) - 96usize];
                ["Offset of field: ViewportMetaData::mInteractiveWidgetMode"]
                    [::std::mem::offset_of!(ViewportMetaData, mInteractiveWidgetMode) - 112usize];
            };
            pub const WakeLockType_Screen: WakeLockType = 0;
            pub type WakeLockType = u8;
            pub const ReferrerPolicy__empty: ReferrerPolicy = 0;
            pub const ReferrerPolicy_No_referrer: ReferrerPolicy = 1;
            pub const ReferrerPolicy_No_referrer_when_downgrade: ReferrerPolicy = 2;
            pub const ReferrerPolicy_Origin: ReferrerPolicy = 3;
            pub const ReferrerPolicy_Origin_when_cross_origin: ReferrerPolicy = 4;
            pub const ReferrerPolicy_Unsafe_url: ReferrerPolicy = 5;
            pub const ReferrerPolicy_Same_origin: ReferrerPolicy = 6;
            pub const ReferrerPolicy_Strict_origin: ReferrerPolicy = 7;
            pub const ReferrerPolicy_Strict_origin_when_cross_origin: ReferrerPolicy = 8;
            pub type ReferrerPolicy = u8;
            #[repr(C)]
            pub struct DocumentFragment {
                pub _base: root::mozilla::dom::FragmentOrElement,
                pub mHost: root::RefPtr<root::mozilla::dom::Element>,
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DocumentFragment_cycleCollection {
                pub _base: root::mozilla::dom::FragmentOrElement_cycleCollection,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of DocumentFragment_cycleCollection"]
                    [::std::mem::size_of::<DocumentFragment_cycleCollection>() - 16usize];
                ["Alignment of DocumentFragment_cycleCollection"]
                    [::std::mem::align_of::<DocumentFragment_cycleCollection>() - 8usize];
            };
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom16DocumentFragment21_cycleCollectorGlobalE"]
                pub static mut DocumentFragment__cycleCollectorGlobal:
                    root::mozilla::dom::DocumentFragment_cycleCollection;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of DocumentFragment"][::std::mem::size_of::<DocumentFragment>() - 112usize];
                ["Alignment of DocumentFragment"]
                    [::std::mem::align_of::<DocumentFragment>() - 8usize];
                ["Offset of field: DocumentFragment::mHost"]
                    [::std::mem::offset_of!(DocumentFragment, mHost) - 104usize];
            };
            #[repr(C)]
            pub struct ShadowRoot {
                pub _base: root::mozilla::dom::DocumentFragment,
                pub _base_1: root::mozilla::dom::DocumentOrShadowRoot,
                pub mServoStyles: root::mozilla::BindgenUniquePtr<root::mozilla::StyleAuthorStyles>,
                pub mStyleRuleMap: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mSlotMap: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mParts: crate::gecko_bindings::structs::nsTArray<*const root::mozilla::dom::Element>,
                pub mMode: root::mozilla::dom::ShadowRootMode,
                pub mDelegatesFocus: root::mozilla::dom::Element_DelegatesFocus,
                pub mSlotAssignment: root::mozilla::dom::SlotAssignmentMode,
                pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 1usize]>,
                pub mIsDeclarative: root::mozilla::dom::ShadowRoot_Declarative,
                pub mIsClonable: root::mozilla::dom::ShadowRoot_IsClonable,
                pub mIsSerializable: root::mozilla::dom::ShadowRoot_IsSerializable,
                pub mReferenceTarget: root::RefPtr<root::nsAtom>,
            }
            pub use self::super::super::super::root::mozilla::dom::Element_ShadowRootClonable as ShadowRoot_IsClonable;
            pub use self::super::super::super::root::mozilla::dom::Element_ShadowRootDeclarative as ShadowRoot_Declarative;
            pub use self::super::super::super::root::mozilla::dom::Element_ShadowRootSerializable as ShadowRoot_IsSerializable;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ShadowRoot_cycleCollection {
                pub _base: root::mozilla::dom::DocumentFragment_cycleCollection,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ShadowRoot_cycleCollection"]
                    [::std::mem::size_of::<ShadowRoot_cycleCollection>() - 16usize];
                ["Alignment of ShadowRoot_cycleCollection"]
                    [::std::mem::align_of::<ShadowRoot_cycleCollection>() - 8usize];
            };
            #[doc = " Represents the insertion point in a slot for a given node."]
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ShadowRoot_SlotInsertionPoint {
                pub mSlot: *mut root::mozilla::dom::HTMLSlotElement,
                pub mIndex: root::__BindgenOpaqueArray<[u32; 2usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ShadowRoot_SlotInsertionPoint"]
                    [::std::mem::size_of::<ShadowRoot_SlotInsertionPoint>() - 16usize];
                ["Alignment of ShadowRoot_SlotInsertionPoint"]
                    [::std::mem::align_of::<ShadowRoot_SlotInsertionPoint>() - 8usize];
                ["Offset of field: ShadowRoot_SlotInsertionPoint::mSlot"]
                    [::std::mem::offset_of!(ShadowRoot_SlotInsertionPoint, mSlot) - 0usize];
                ["Offset of field: ShadowRoot_SlotInsertionPoint::mIndex"]
                    [::std::mem::offset_of!(ShadowRoot_SlotInsertionPoint, mIndex) - 8usize];
            };
            pub const ShadowRoot_SummaryChangeReason_Deletion: ShadowRoot_SummaryChangeReason = 0;
            pub const ShadowRoot_SummaryChangeReason_Insertion: ShadowRoot_SummaryChangeReason = 1;
            #[doc = " Re-assign the current main summary if it has changed.\n\n Must be called only if mIsDetailsShadowTree is true."]
            pub type ShadowRoot_SummaryChangeReason = ::std::os::raw::c_int;
            pub type ShadowRoot_SlotArray = root::__BindgenOpaqueArray8<[u8; 24usize]>;
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom10ShadowRoot21_cycleCollectorGlobalE"]
                pub static mut ShadowRoot__cycleCollectorGlobal:
                    root::mozilla::dom::ShadowRoot_cycleCollection;
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ShadowRoot"][::std::mem::size_of::<ShadowRoot>() - 256usize];
                ["Alignment of ShadowRoot"][::std::mem::align_of::<ShadowRoot>() - 8usize];
                ["Offset of field: ShadowRoot::mServoStyles"]
                    [::std::mem::offset_of!(ShadowRoot, mServoStyles) - 184usize];
                ["Offset of field: ShadowRoot::mStyleRuleMap"]
                    [::std::mem::offset_of!(ShadowRoot, mStyleRuleMap) - 192usize];
                ["Offset of field: ShadowRoot::mSlotMap"]
                    [::std::mem::offset_of!(ShadowRoot, mSlotMap) - 200usize];
                ["Offset of field: ShadowRoot::mParts"]
                    [::std::mem::offset_of!(ShadowRoot, mParts) - 232usize];
                ["Offset of field: ShadowRoot::mMode"]
                    [::std::mem::offset_of!(ShadowRoot, mMode) - 240usize];
                ["Offset of field: ShadowRoot::mDelegatesFocus"]
                    [::std::mem::offset_of!(ShadowRoot, mDelegatesFocus) - 241usize];
                ["Offset of field: ShadowRoot::mSlotAssignment"]
                    [::std::mem::offset_of!(ShadowRoot, mSlotAssignment) - 242usize];
                ["Offset of field: ShadowRoot::mIsDeclarative"]
                    [::std::mem::offset_of!(ShadowRoot, mIsDeclarative) - 244usize];
                ["Offset of field: ShadowRoot::mIsClonable"]
                    [::std::mem::offset_of!(ShadowRoot, mIsClonable) - 245usize];
                ["Offset of field: ShadowRoot::mIsSerializable"]
                    [::std::mem::offset_of!(ShadowRoot, mIsSerializable) - 246usize];
                ["Offset of field: ShadowRoot::mReferenceTarget"]
                    [::std::mem::offset_of!(ShadowRoot, mReferenceTarget) - 248usize];
            };
            impl ShadowRoot {
                #[inline]
                pub fn mIsDetailsShadowTree(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsDetailsShadowTree(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(0usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub unsafe fn mIsDetailsShadowTree_raw(this: *const Self) -> bool {
                    unsafe {
                        ::std::mem::transmute(<root::__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                            ::std::ptr::addr_of!((*this)._bitfield_1),
                            0usize,
                            1u8,
                        ) as u8)
                    }
                }
                #[inline]
                pub unsafe fn set_mIsDetailsShadowTree_raw(this: *mut Self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        <root::__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                            ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                            0usize,
                            1u8,
                            val as u64,
                        )
                    }
                }
                #[inline]
                pub fn mIsAvailableToElementInternals(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mIsAvailableToElementInternals(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(1usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub unsafe fn mIsAvailableToElementInternals_raw(this: *const Self) -> bool {
                    unsafe {
                        ::std::mem::transmute(<root::__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                            ::std::ptr::addr_of!((*this)._bitfield_1),
                            1usize,
                            1u8,
                        ) as u8)
                    }
                }
                #[inline]
                pub unsafe fn set_mIsAvailableToElementInternals_raw(this: *mut Self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        <root::__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                            ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                            1usize,
                            1u8,
                            val as u64,
                        )
                    }
                }
                #[inline]
                pub fn new_bitfield_1(
                    mIsDetailsShadowTree: bool,
                    mIsAvailableToElementInternals: bool,
                ) -> root::__BindgenBitfieldUnit<[u8; 1usize]> {
                    let mut __bindgen_bitfield_unit: root::__BindgenBitfieldUnit<[u8; 1usize]> =
                        Default::default();
                    __bindgen_bitfield_unit.set(0usize, 1u8, {
                        let mIsDetailsShadowTree: u8 =
                            unsafe { ::std::mem::transmute(mIsDetailsShadowTree) };
                        mIsDetailsShadowTree as u64
                    });
                    __bindgen_bitfield_unit.set(1usize, 1u8, {
                        let mIsAvailableToElementInternals: u8 =
                            unsafe { ::std::mem::transmute(mIsAvailableToElementInternals) };
                        mIsAvailableToElementInternals as u64
                    });
                    __bindgen_bitfield_unit
                }
            }
            pub const VisibilityState_Hidden: VisibilityState = 0;
            pub const VisibilityState_Visible: VisibilityState = 1;
            pub type VisibilityState = u8;
            pub mod Document_Binding {
                #[allow(unused_imports)]
                use self::super::super::super::super::root;
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct AnonymousContent {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct XULBroadcastManager {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct XULPersist {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct BrowserBridgeChild {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ChromeObserver {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DocumentL10n {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DocumentTimeline {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMImplementation {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FeaturePolicy {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct FragmentDirective {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HighlightRegistry {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HTMLAllCollection {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HTMLMetaElement {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct HTMLImageElement {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct MediaQueryList {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ScriptLoader {
                _unused: [u8; 0],
            }
            pub type ViewportFitType = u8;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ViewTransition {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct WakeLockSentinel {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct WorkerDocumentListener {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct XPathEvaluator {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct DOMStyleSheetSetList {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct ResizeObserver {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct PostMessageEvent {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap {
                pub mMap: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mPendingLoads: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mHaveShutDown: bool,
            }
            pub type ExternalResourceMap_SubDocEnumFunc = root::mozilla::FunctionRef;
            pub type ExternalResourceMap_SubDocTestFunc = root::mozilla::FunctionRef;
            #[doc = " A class that represents an external resource load that has begun but\n doesn't have a document yet.  Observers can be registered on this object,\n and will be notified after the document is created.  Observers registered\n after the document has been created will NOT be notified.  When observers\n are notified, the subject will be the newly-created document, the topic\n will be \"external-resource-document-created\", and the data will be null.\n If document creation fails for some reason, observers will still be\n notified, with a null document pointer."]
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap_ExternalResourceLoad {
                pub _base: root::nsISupports,
                pub mObservers: root::__BindgenOpaqueArray8<[u8; 80usize]>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_ExternalResourceLoad"]
                    [::std::mem::size_of::<ExternalResourceMap_ExternalResourceLoad>() - 88usize];
                ["Alignment of ExternalResourceMap_ExternalResourceLoad"]
                    [::std::mem::align_of::<ExternalResourceMap_ExternalResourceLoad>() - 8usize];
                ["Offset of field: ExternalResourceMap_ExternalResourceLoad::mObservers"][::std::mem::offset_of!(
                    ExternalResourceMap_ExternalResourceLoad,
                    mObservers
                )
                    - 8usize];
            };
            #[repr(C)]
            pub struct ExternalResourceMap_ExternalResource {
                pub mDocument: root::RefPtr<root::mozilla::dom::Document>,
                pub mViewer: root::nsCOMPtr<root::nsIDocumentViewer>,
                pub mLoadGroup: root::nsCOMPtr<root::nsILoadGroup>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_ExternalResource"]
                    [::std::mem::size_of::<ExternalResourceMap_ExternalResource>() - 24usize];
                ["Alignment of ExternalResourceMap_ExternalResource"]
                    [::std::mem::align_of::<ExternalResourceMap_ExternalResource>() - 8usize];
                ["Offset of field: ExternalResourceMap_ExternalResource::mDocument"][::std::mem::offset_of!(
                    ExternalResourceMap_ExternalResource,
                    mDocument
                ) - 0usize];
                ["Offset of field: ExternalResourceMap_ExternalResource::mViewer"][::std::mem::offset_of!(
                    ExternalResourceMap_ExternalResource,
                    mViewer
                ) - 8usize];
                ["Offset of field: ExternalResourceMap_ExternalResource::mLoadGroup"][::std::mem::offset_of!(
                    ExternalResourceMap_ExternalResource,
                    mLoadGroup
                ) - 16usize];
            };
            #[repr(C)]
            pub struct ExternalResourceMap_PendingLoad {
                pub _base: root::mozilla::dom::ExternalResourceMap_ExternalResourceLoad,
                pub _base_1: root::nsIStreamListener,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mDisplayDocument: root::RefPtr<root::mozilla::dom::Document>,
                pub mTargetListener: root::nsCOMPtr<root::nsIStreamListener>,
                pub mURI: root::nsCOMPtr<root::nsIURI>,
            }
            pub type ExternalResourceMap_PendingLoad_HasThreadSafeRefCnt = root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_PendingLoad"]
                    [::std::mem::size_of::<ExternalResourceMap_PendingLoad>() - 128usize];
                ["Alignment of ExternalResourceMap_PendingLoad"]
                    [::std::mem::align_of::<ExternalResourceMap_PendingLoad>() - 8usize];
                ["Offset of field: ExternalResourceMap_PendingLoad::mRefCnt"]
                    [::std::mem::offset_of!(ExternalResourceMap_PendingLoad, mRefCnt) - 96usize];
                ["Offset of field: ExternalResourceMap_PendingLoad::mDisplayDocument"][::std::mem::offset_of!(
                    ExternalResourceMap_PendingLoad,
                    mDisplayDocument
                )
                    - 104usize];
                ["Offset of field: ExternalResourceMap_PendingLoad::mTargetListener"][::std::mem::offset_of!(
                    ExternalResourceMap_PendingLoad,
                    mTargetListener
                ) - 112usize];
                ["Offset of field: ExternalResourceMap_PendingLoad::mURI"]
                    [::std::mem::offset_of!(ExternalResourceMap_PendingLoad, mURI) - 120usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap_LoadgroupCallbacks {
                pub _base: root::nsIInterfaceRequestor,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mCallbacks: root::nsCOMPtr<root::nsIInterfaceRequestor>,
            }
            pub type ExternalResourceMap_LoadgroupCallbacks_HasThreadSafeRefCnt =
                root::std::false_type;
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim {
                pub _base: root::nsIInterfaceRequestor,
                pub _base_1: root::nsILoadContext,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mIfReq: root::nsCOMPtr<root::nsIInterfaceRequestor>,
                pub mRealPtr: root::nsCOMPtr<root::nsILoadContext>,
            }
            pub type ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim_HasThreadSafeRefCnt =
                root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim"]
                    [::std::mem::size_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim,
                    >() - 40usize];
                ["Alignment of ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim"]
                    [::std::mem::align_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim,
                    >() - 8usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim::mRefCnt",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim,
                    mRefCnt
                ) - 16usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim::mIfReq",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim,
                    mIfReq
                ) - 24usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim::mRealPtr",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsILoadContextShim,
                    mRealPtr
                ) - 32usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim {
                pub _base: root::nsIInterfaceRequestor,
                pub _base_1: root::nsIProgressEventSink,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mIfReq: root::nsCOMPtr<root::nsIInterfaceRequestor>,
                pub mRealPtr: root::nsCOMPtr<root::nsIProgressEventSink>,
            }
            pub type ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim_HasThreadSafeRefCnt =
                root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim"]
                    [::std::mem::size_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim,
                    >() - 40usize];
                ["Alignment of ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim"]
                    [::std::mem::align_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim,
                    >() - 8usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim::mRefCnt",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim,
                    mRefCnt
                ) - 16usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim::mIfReq",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim,
                    mIfReq
                ) - 24usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim::mRealPtr",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIProgressEventSinkShim,
                    mRealPtr
                ) - 32usize];
            };
            #[repr(C)]
            #[derive(Debug)]
            pub struct ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim {
                pub _base: root::nsIInterfaceRequestor,
                pub _base_1: root::nsIChannelEventSink,
                pub mRefCnt: root::nsAutoRefCnt,
                pub mIfReq: root::nsCOMPtr<root::nsIInterfaceRequestor>,
                pub mRealPtr: root::nsCOMPtr<root::nsIChannelEventSink>,
            }
            pub type ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim_HasThreadSafeRefCnt =
                root::std::false_type;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim"]
                    [::std::mem::size_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim,
                    >() - 40usize];
                ["Alignment of ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim"]
                    [::std::mem::align_of::<
                        ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim,
                    >() - 8usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim::mRefCnt",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim,
                    mRefCnt
                ) - 16usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim::mIfReq",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim,
                    mIfReq
                ) - 24usize];
                [
                    "Offset of field: ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim::mRealPtr",
                ][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks_nsIChannelEventSinkShim,
                    mRealPtr
                ) - 32usize];
            };
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap_LoadgroupCallbacks"]
                    [::std::mem::size_of::<ExternalResourceMap_LoadgroupCallbacks>() - 24usize];
                ["Alignment of ExternalResourceMap_LoadgroupCallbacks"]
                    [::std::mem::align_of::<ExternalResourceMap_LoadgroupCallbacks>() - 8usize];
                ["Offset of field: ExternalResourceMap_LoadgroupCallbacks::mRefCnt"][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks,
                    mRefCnt
                ) - 8usize];
                ["Offset of field: ExternalResourceMap_LoadgroupCallbacks::mCallbacks"][::std::mem::offset_of!(
                    ExternalResourceMap_LoadgroupCallbacks,
                    mCallbacks
                )
                    - 16usize];
            };
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of ExternalResourceMap"]
                    [::std::mem::size_of::<ExternalResourceMap>() - 72usize];
                ["Alignment of ExternalResourceMap"]
                    [::std::mem::align_of::<ExternalResourceMap>() - 8usize];
                ["Offset of field: ExternalResourceMap::mMap"]
                    [::std::mem::offset_of!(ExternalResourceMap, mMap) - 0usize];
                ["Offset of field: ExternalResourceMap::mPendingLoads"]
                    [::std::mem::offset_of!(ExternalResourceMap, mPendingLoads) - 32usize];
                ["Offset of field: ExternalResourceMap::mHaveShutDown"]
                    [::std::mem::offset_of!(ExternalResourceMap, mHaveShutDown) - 64usize];
            };
            #[repr(C)]
            pub struct Document {
                pub _base: root::nsINode,
                pub _base_1: root::mozilla::dom::DocumentOrShadowRoot,
                pub _base_2: root::nsSupportsWeakReference,
                pub _base_3: root::nsIScriptObjectPrincipal,
                pub _base_4: root::mozilla::SupportsWeakPtr,
                pub _base_5: root::mozilla::LinkedListElement,
                pub mDocumentL10n: root::RefPtr<root::mozilla::dom::DocumentL10n>,
                pub mDeprecationWarnedAbout: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mDocWarningWarnedAbout: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mStyleSet: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mPreloadReferrerInfo: root::nsCOMPtr<root::nsIReferrerInfo>,
                pub mReferrerInfo: root::nsCOMPtr<root::nsIReferrerInfo>,
                pub mRequestReferrerPolicy: root::mozilla::dom::Document_ReferrerPolicyEnum,
                pub mLastModified: crate::gecko_bindings::structs::nsString,
                pub mDocumentURI: root::nsCOMPtr<root::nsIURI>,
                pub mOriginalURI: root::nsCOMPtr<root::nsIURI>,
                pub mChromeXHRDocURI: root::nsCOMPtr<root::nsIURI>,
                pub mDocumentBaseURI: root::nsCOMPtr<root::nsIURI>,
                pub mChromeXHRDocBaseURI: root::nsCOMPtr<root::nsIURI>,
                pub mCachedURLData: root::RefPtr<root::mozilla::URLExtraData>,
                pub mCachedReferrerInfoForInternalCSSAndSVGResources:
                    root::nsCOMPtr<root::nsIReferrerInfo>,
                pub mDocumentLoadGroup: root::nsWeakPtr,
                pub mDocumentContainer: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mCharacterSet: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mCharacterSetSource: i32,
                pub mTrials: root::mozilla::OriginTrials,
                pub mParentDocument: *mut root::mozilla::dom::Document,
                pub mCachedRootElement: *mut root::mozilla::dom::Element,
                pub mCurrentContextPaint: *const root::mozilla::SVGContextPaint,
                pub mNodeInfoManager: *mut root::nsNodeInfoManager,
                pub mCSSLoader: root::RefPtr<root::mozilla::css::Loader>,
                pub mStyleImageLoader: root::RefPtr<root::mozilla::css::ImageLoader>,
                pub mAttributeStyles: root::RefPtr<root::mozilla::AttributeStyles>,
                pub mTrackedImages: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mComposedShadowRoots: root::mozilla::dom::Document_ShadowRootSet,
                pub mSVGUseElementsNeedingShadowTreeUpdate:
                    root::mozilla::dom::Document_SVGUseElementSet,
                pub mActivityObservers: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mStyledLinks: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mLinksToUpdate: root::mozilla::dom::Document_LinksToUpdateList,
                pub mAnimationController: root::RefPtr<root::mozilla::SMILAnimationController>,
                pub mPropertyTable: root::nsPropertyTable,
                pub mChildrenCollection: root::nsCOMPtr<root::nsIHTMLCollection>,
                pub mImages: root::RefPtr<root::nsContentList>,
                pub mEmbeds: root::RefPtr<root::nsContentList>,
                pub mLinks: root::RefPtr<root::nsContentList>,
                pub mForms: root::RefPtr<root::nsContentList>,
                pub mScripts: root::RefPtr<root::nsContentList>,
                pub mApplets: root::nsCOMPtr<root::nsIHTMLCollection>,
                pub mAnchors: root::RefPtr<root::nsContentList>,
                pub mFontFaceSet: root::RefPtr<root::mozilla::dom::FontFaceSet>,
                pub mLastFocusTime: root::mozilla::TimeStamp,
                pub mLastScrollLinkedEffectDetectionTime: root::mozilla::TimeStamp,
                pub mState: root::mozilla::dom::DocumentState,
                pub mReadyForIdle: root::RefPtr<root::mozilla::dom::Promise>,
                pub mFeaturePolicy: root::RefPtr<root::mozilla::dom::FeaturePolicy>,
                pub mPermissionDelegateHandler:
                    root::RefPtr<root::mozilla::PermissionDelegateHandler>,
                pub mInitialStatus: root::mozilla::dom::Document_InitialStatus,
                pub _bitfield_1: root::__BindgenBitfieldUnit<[u8; 13usize]>,
                pub mOverriddenFingerprintingSettings: root::__BindgenOpaqueArray8<[u8; 24usize]>,
                pub mXMLDeclarationBits: u8,
                pub mColorSchemeBits: u8,
                pub mOnloadBlockCount: u32,
                pub mWriteLevel: u32,
                pub mContentEditableCount: u32,
                pub mEditingState: root::mozilla::dom::Document_EditingState,
                pub mCompatMode: root::nsCompatibility,
                pub mReadyState: root::mozilla::dom::Document_ReadyState,
                pub mAncestorIsLoading: bool,
                pub mVisibilityState: root::mozilla::dom::VisibilityState,
                pub mType: root::mozilla::dom::Document_Type,
                pub mDefaultElementType: u8,
                pub mAllowXULXBL: root::mozilla::dom::Document_Tri,
                pub mSkipDTDSecurityChecks: bool,
                pub mScriptGlobalObject: root::nsCOMPtr<root::nsIScriptGlobalObject>,
                pub mOriginalDocument: root::RefPtr<root::mozilla::dom::Document>,
                pub mBidiOptions: u32,
                pub mSandboxFlags: u32,
                pub mEmbedderPolicy: root::__BindgenOpaqueArray<[u8; 2usize]>,
                pub mContentLanguage: root::RefPtr<root::nsAtom>,
                pub mChannel: root::nsCOMPtr<root::nsIChannel>,
                pub mPreloadCSP: root::nsCOMPtr<root::nsIContentSecurityPolicy>,
                pub mPolicyContainer: root::RefPtr<root::PolicyContainer>,
                pub mContentType: crate::gecko_bindings::structs::nsCString,
                pub mSecurityInfo: root::nsCOMPtr<root::nsITransportSecurityInfo>,
                pub mFailedChannel: root::nsCOMPtr<root::nsIChannel>,
                pub mASMJSExecutionTimer: root::nsCOMPtr<root::nsITimer>,
                pub mPartID: u32,
                pub mMarkedCCGeneration: u32,
                pub mPresShell: *mut root::mozilla::PresShell,
                pub mPreloadingImages: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mPreloadedPreconnects: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mPreloadPictureDepth: u32,
                pub mPreloadPictureFoundSource: crate::gecko_bindings::structs::nsString,
                pub mDisplayDocument: root::RefPtr<root::mozilla::dom::Document>,
                pub mEventsSuppressed: u32,
                pub mSuspendedQueues:
                    crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::net::ChannelEventQueue>>,
                pub mSuspendedPostMessageEvents:
                    crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::dom::PostMessageEvent>>,
                pub mSuppressedEventListener: root::RefPtr<root::mozilla::dom::EventListener>,
                #[doc = " https://html.spec.whatwg.org/#ignore-destructive-writes-counter"]
                pub mIgnoreDestructiveWritesCounter: u32,
                pub mStaticCloneCount: u32,
                pub mLatestStaticClone: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mBlockedNodesByClassifier: crate::gecko_bindings::structs::nsTArray<root::nsWeakPtr>,
                pub mWindow: *mut root::nsPIDOMWindowInner,
                pub mCachedEncoder: root::nsCOMPtr<root::nsIDocumentEncoder>,
                pub mFrameRequestManager: root::mozilla::dom::FrameRequestManager,
                pub mBFCacheEntry: *mut root::nsIBFCacheEntry,
                pub mBaseTarget: crate::gecko_bindings::structs::nsString,
                pub mStateObjectContainer: root::nsCOMPtr<root::nsIStructuredCloneContainer>,
                pub mCachedStateObject: root::JS::Heap<root::JS::Value>,
                pub mInSyncOperationCount: u32,
                pub mXPathEvaluator: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mAnonymousContents:
                    crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::dom::AnonymousContent>>,
                pub mCustomContentContainer: root::RefPtr<root::mozilla::dom::Element>,
                pub mBlockDOMContentLoaded: u32,
                pub mDOMMediaQueryLists: root::mozilla::LinkedList,
                pub mContentIdentifiersForLCP:
                    root::mozilla::dom::Document_ContentIdentifiersForLCPType,
                pub mObservers: root::__BindgenOpaqueArray8<[u8; 16usize]>,
                pub mUseCounters: root::mozilla::UseCounters,
                pub mChildDocumentUseCounters: root::mozilla::UseCounters,
                pub mStyleUseCounters: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mPageUnloadingEventTimeStamp: root::mozilla::TimeStamp,
                pub mDocGroup: root::RefPtr<root::nsINode_DocGroup>,
                pub mMidasCommandManager: root::RefPtr<root::nsCommandManager>,
                pub mTrackingScripts: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mParser: root::nsCOMPtr<root::nsIParser>,
                pub mPrototypeDocument: root::RefPtr<root::nsXULPrototypeDocument>,
                pub mWeakSink: root::nsWeakPtr,
                pub mUpdateNestLevel: u32,
                pub mHttpsOnlyStatus: u32,
                pub mViewportType: root::mozilla::dom::Document_ViewportType,
                pub mViewportFit: root::mozilla::dom::ViewportFitType,
                pub mInteractiveWidgetMode: root::mozilla::dom::InteractiveWidget,
                pub mSubDocuments: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mHeaderData: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mEarlyHints: crate::gecko_bindings::structs::nsTArray<root::mozilla::net::EarlyHintConnectArgs>,
                pub mPendingTitleChangeEvent:
                    root::nsRevocableEventPtr<root::mozilla::dom::Document_TitleChangeEvent>,
                pub mTiming: root::RefPtr<root::nsDOMNavigationTiming>,
                pub mLoadingOrRestoredFromBFCacheTimeStamp: root::mozilla::TimeStamp,
                pub mAutoFocusCandidates: root::__BindgenOpaqueArray8<[u8; 16usize]>,
                pub mScrollToRef: crate::gecko_bindings::structs::nsCString,
                pub mScopeObject: root::nsWeakPtr,
                pub mIntersectionObservers:
                    crate::gecko_bindings::structs::nsTArray<*mut root::mozilla::dom::DOMIntersectionObserver>,
                pub mResizeObservers: crate::gecko_bindings::structs::nsTArray<*mut root::mozilla::dom::ResizeObserver>,
                pub mLazyLoadObserver: root::RefPtr<root::mozilla::dom::DOMIntersectionObserver>,
                pub mElementsObservedForLastRememberedSize:
                    root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mTopLayer: crate::gecko_bindings::structs::nsTArray<root::nsWeakPtr>,
                pub mOpenDialogs: crate::gecko_bindings::structs::nsTArray<*mut root::mozilla::dom::HTMLDialogElement>,
                pub mLastDialogPointerdownTarget: root::nsWeakPtr,
                pub mFullscreenRoot: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mDOMImplementation: root::RefPtr<root::mozilla::dom::DOMImplementation>,
                pub mImageMaps: root::RefPtr<root::nsContentList>,
                pub mResponsiveContent: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mDocumentTimeline: root::RefPtr<root::mozilla::dom::DocumentTimeline>,
                pub mTimelines: root::mozilla::LinkedList,
                pub mScriptLoader: root::RefPtr<root::mozilla::dom::ScriptLoader>,
                pub mScrollTimelineAnimationTracker:
                    root::RefPtr<root::mozilla::ScrollTimelineAnimationTracker>,
                pub mTemplateContentsOwner: root::RefPtr<root::mozilla::dom::Document>,
                pub mExternalResourceMap: root::mozilla::dom::ExternalResourceMap,
                pub mOrientationPendingPromise: root::RefPtr<root::mozilla::dom::Promise>,
                pub mInitializableFrameLoaders: crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::nsFrameLoader>>,
                pub mFrameLoaderFinalizers: crate::gecko_bindings::structs::nsTArray<root::nsCOMPtr<root::nsIRunnable>>,
                pub mFrameLoaderRunner: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mPendingFrameStaticClones:
                    crate::gecko_bindings::structs::nsTArray<root::mozilla::dom::Document_PendingFrameStaticClone>,
                pub mLayoutHistoryState: root::nsCOMPtr<root::nsILayoutHistoryState>,
                pub mActiveLocks: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mLastModifiedViewportMetaData: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mColorSchemeMetaTags: root::__BindgenOpaqueArray8<[u8; 24usize]>,
                pub mScaleMinFloat: root::mozilla::LayoutDeviceToScreenScale,
                pub mScaleMaxFloat: root::mozilla::LayoutDeviceToScreenScale,
                pub mScaleFloat: root::mozilla::LayoutDeviceToScreenScale,
                pub mPixelRatio: root::mozilla::CSSToLayoutDeviceScale,
                pub mMinWidth: root::mozilla::CSSCoord,
                pub mMaxWidth: root::mozilla::CSSCoord,
                pub mMinHeight: root::mozilla::CSSCoord,
                pub mMaxHeight: root::mozilla::CSSCoord,
                pub mListenerManager: root::RefPtr<root::mozilla::EventListenerManager>,
                pub mOnloadBlocker: root::nsCOMPtr<root::nsIRequest>,
                pub mAdditionalSheets:
                    [crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::StyleSheet>>; 3usize],
                pub mLastStyleSheetSet: crate::gecko_bindings::structs::nsString,
                pub mPreferredStyleSheetSet: crate::gecko_bindings::structs::nsString,
                pub mStyleSheetSetList: root::RefPtr<root::mozilla::dom::DOMStyleSheetSetList>,
                pub mLazyPresElements: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mLanguagesUsed: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mLanguageFromCharset: *mut root::nsAtom,
                pub mServoRestyleRoot: root::nsCOMPtr<root::nsINode>,
                pub mServoRestyleRootDirtyBits: u32,
                pub mThrowOnDynamicMarkupInsertionCounter: u32,
                pub mIgnoreOpensDuringUnloadCounter: u32,
                pub mCommandDispatcher: root::nsCOMPtr<root::nsIDOMXULCommandDispatcher>,
                pub mXULBroadcastManager: root::RefPtr<root::mozilla::dom::XULBroadcastManager>,
                pub mXULPersist: root::RefPtr<root::mozilla::dom::XULPersist>,
                pub mChromeObserver: root::RefPtr<root::mozilla::dom::ChromeObserver>,
                pub mAll: root::RefPtr<root::mozilla::dom::HTMLAllCollection>,
                pub mActiveViewTransition: root::RefPtr<root::mozilla::dom::ViewTransition>,
                pub mViewTransitionUpdateCallbacks:
                    crate::gecko_bindings::structs::nsTArray<root::RefPtr<root::mozilla::dom::ViewTransition>>,
                pub mWorkerListeners: root::__BindgenOpaqueArray8<[u8; 32usize]>,
                pub mSavedResolution: f32,
                pub mCookieJarSettings: root::nsCOMPtr<root::nsICookieJarSettings>,
                pub mHasStoragePermission: bool,
                pub mClassificationFlags: root::mozilla::net::ClassificationFlags,
                pub mGeneration: i32,
                pub mCachedTabSizeGeneration: i32,
                pub mCachedTabSizes: root::nsTabSizes,
                pub mPartitionedPrincipal: root::nsCOMPtr<root::nsIPrincipal>,
                pub mActiveStoragePrincipal: root::nsCOMPtr<root::nsIPrincipal>,
                pub mActiveCookiePrincipal: root::nsCOMPtr<root::nsIPrincipal>,
                pub mPendingFullscreenEvents: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mNextFormNumber: i32,
                pub mNextControlNumber: i32,
                pub mMediaElementWithMSECount: u32,
                pub mPreloadService: root::mozilla::PreloadService,
                pub mShouldNotifyFetchSuccess: bool,
                pub mShouldNotifyFormOrPasswordRemoved: bool,
                pub mShadowedHTMLDocumentProperties: crate::gecko_bindings::structs::nsTArray<crate::gecko_bindings::structs::nsString>,
                pub mPageloadEventData:
                    root::mozilla::performance::pageload_event::PageloadEventData,
                pub mOOPChildrenLoading:
                    crate::gecko_bindings::structs::nsTArray<*const root::mozilla::dom::BrowserBridgeChild>,
                pub mHighlightRegistry: root::RefPtr<root::mozilla::dom::HighlightRegistry>,
                pub mCanvasUsage: crate::gecko_bindings::structs::nsTArray<root::mozilla::CanvasUsage>,
                pub mLastCanvasUsage: u64,
                pub mFragmentDirective: root::RefPtr<root::mozilla::dom::FragmentDirective>,
                pub mRadioGroupContainer: root::__BindgenOpaqueArray8<[u8; 8usize]>,
                pub mExpandoAndGeneration: root::JS::ExpandoAndGeneration,
                pub mL10nProtoElements: root::__BindgenOpaqueArray8<[u8; 32usize]>,
            }
            #[doc = " A class that represents an external resource load that has begun but\n doesn't have a document yet.  Observers can be registered on this object,\n and will be notified after the document is created.  Observers registered\n after the document has been created will NOT be notified.  When observers\n are notified, the subject will be the newly-created document, the topic\n will be \"external-resource-document-created\", and the data will be null.\n If document creation fails for some reason, observers will still be\n notified, with a null document pointer."]
            pub type Document_ExternalResourceLoad =
                root::mozilla::dom::ExternalResourceMap_ExternalResourceLoad;
            pub use self::super::super::super::root::mozilla::dom::ReferrerPolicy as Document_ReferrerPolicyEnum;
            pub type Document_AdoptedStyleSheetCloneCache = u8;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Document_cycleCollection {
                pub _base: root::nsXPCOMCycleCollectionParticipant,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_cycleCollection"]
                    [::std::mem::size_of::<Document_cycleCollection>() - 16usize];
                ["Alignment of Document_cycleCollection"]
                    [::std::mem::align_of::<Document_cycleCollection>() - 8usize];
            };
            #[repr(C)]
            pub struct Document_PageUnloadingEventTimeStamp {
                pub mDocument: root::RefPtr<root::mozilla::dom::Document>,
                pub mSet: bool,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_PageUnloadingEventTimeStamp"]
                    [::std::mem::size_of::<Document_PageUnloadingEventTimeStamp>() - 16usize];
                ["Alignment of Document_PageUnloadingEventTimeStamp"]
                    [::std::mem::align_of::<Document_PageUnloadingEventTimeStamp>() - 8usize];
                ["Offset of field: Document_PageUnloadingEventTimeStamp::mDocument"][::std::mem::offset_of!(
                    Document_PageUnloadingEventTimeStamp,
                    mDocument
                ) - 0usize];
                ["Offset of field: Document_PageUnloadingEventTimeStamp::mSet"]
                    [::std::mem::offset_of!(Document_PageUnloadingEventTimeStamp, mSet) - 8usize];
            };
            pub const Document_InitialStatus_IsInitial: Document_InitialStatus = 0;
            pub const Document_InitialStatus_IsInitialButExplicitlyOpened: Document_InitialStatus =
                1;
            pub const Document_InitialStatus_WasInitial: Document_InitialStatus = 2;
            pub const Document_InitialStatus_NeverInitial: Document_InitialStatus = 3;
            pub type Document_InitialStatus = u8;
            #[doc = " Return a promise which resolves to the content blocking events."]
            pub type Document_GetContentBlockingEventsPromise = u8;
            pub const Document_EditingState_eTearingDown: Document_EditingState = -2;
            pub const Document_EditingState_eSettingUp: Document_EditingState = -1;
            pub const Document_EditingState_eOff: Document_EditingState = 0;
            pub const Document_EditingState_eDesignMode: Document_EditingState = 1;
            pub const Document_EditingState_eContentEditable: Document_EditingState = 2;
            pub type Document_EditingState = i8;
            #[repr(C)]
            pub struct Document_nsAutoEditingState {
                pub mDoc: root::RefPtr<root::mozilla::dom::Document>,
                pub mSavedState: root::mozilla::dom::Document_EditingState,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_nsAutoEditingState"]
                    [::std::mem::size_of::<Document_nsAutoEditingState>() - 16usize];
                ["Alignment of Document_nsAutoEditingState"]
                    [::std::mem::align_of::<Document_nsAutoEditingState>() - 8usize];
                ["Offset of field: Document_nsAutoEditingState::mDoc"]
                    [::std::mem::offset_of!(Document_nsAutoEditingState, mDoc) - 0usize];
                ["Offset of field: Document_nsAutoEditingState::mSavedState"]
                    [::std::mem::offset_of!(Document_nsAutoEditingState, mSavedState) - 8usize];
            };
            pub const Document_additionalSheetType_eAgentSheet: Document_additionalSheetType = 0;
            pub const Document_additionalSheetType_eUserSheet: Document_additionalSheetType = 1;
            pub const Document_additionalSheetType_eAuthorSheet: Document_additionalSheetType = 2;
            pub const Document_additionalSheetType_AdditionalSheetTypeCount:
                Document_additionalSheetType = 3;
            pub type Document_additionalSheetType = ::std::os::raw::c_uint;
            pub const Document_UpdateViewport_No: Document_UpdateViewport = false;
            pub const Document_UpdateViewport_Yes: Document_UpdateViewport = true;
            pub type Document_UpdateViewport = bool;
            pub const Document_ReadyState_READYSTATE_UNINITIALIZED: Document_ReadyState = 0;
            pub const Document_ReadyState_READYSTATE_LOADING: Document_ReadyState = 1;
            pub const Document_ReadyState_READYSTATE_INTERACTIVE: Document_ReadyState = 3;
            pub const Document_ReadyState_READYSTATE_COMPLETE: Document_ReadyState = 4;
            pub type Document_ReadyState = ::std::os::raw::c_uint;
            #[doc = " Enumerate all subdocuments.\n The enumerator callback should return CallState::Continue to continue\n enumerating, or CallState::Stop to stop.  This will never get passed a null\n aDocument."]
            pub type Document_SubDocEnumFunc =
                root::mozilla::dom::ExternalResourceMap_SubDocEnumFunc;
            #[doc = " Collect all the descendant documents for which |aCalback| returns true.\n The callback function must not mutate any state for the given document.\n Note that, unlike EnumerateSubDocuments, this recurses into nested\n subdocuments."]
            pub type Document_SubDocTestFunc =
                root::mozilla::dom::ExternalResourceMap_SubDocTestFunc;
            pub const Document_IncludeSubResources_No: Document_IncludeSubResources = false;
            pub const Document_IncludeSubResources_Yes: Document_IncludeSubResources = true;
            pub type Document_IncludeSubResources = bool;
            #[doc = " Templated hashtable. Usually, this isn't instantiated directly but through\n its sub-class templates nsInterfaceHashtable, nsClassHashtable,\n nsRefPtrHashtable and nsTHashMap.\n\n Originally, UserDataType used to be the only type exposed to the user in the\n public member function signatures (hence its name), but this has proven to\n inadequate over time. Now, UserDataType is only exposed in by-value\n getter member functions that are called *Get*. Member functions that provide\n access to the DataType are called Lookup rather than Get. Note that this rule\n does not apply to nsRefPtrHashtable and nsInterfaceHashtable, as they are\n provide a similar interface, but are no genuine sub-classes of\n nsBaseHashtable.\n\n @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h\n   for a complete specification.\n @param DataType the datatype stored in the hashtable,\n   for example, uint32_t or nsCOMPtr.\n @param UserDataType the datatype returned from the by-value getter member\n   functions (named *Get*), for example uint32_t or nsISupports*\n @param Converter that is used to map from DataType to UserDataType. A\n   default converter is provided that assumes implicit conversion is an\n   option."]
            pub type Document_ContentIdentifiersForLCPType =
                root::__BindgenOpaqueArray8<[u8; 32usize]>;
            pub type Document_ActivityObserverEnumerator = root::mozilla::FunctionRef;
            pub const Document_MediaDocumentKind_NotMedia: Document_MediaDocumentKind = 0;
            pub const Document_MediaDocumentKind_Video: Document_MediaDocumentKind = 1;
            pub const Document_MediaDocumentKind_Image: Document_MediaDocumentKind = 2;
            pub type Document_MediaDocumentKind = ::std::os::raw::c_int;
            pub const Document_RequestDiscard_No: Document_RequestDiscard = false;
            pub const Document_RequestDiscard_Yes: Document_RequestDiscard = true;
            pub type Document_RequestDiscard = bool;
            #[doc = " Templated hash set. Don't use this directly, but use nsTHashSet instead\n (defined as a type alias in nsHashtablesFwd.h).\n\n @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h\n   for a complete specification."]
            pub type Document_ShadowRootSet = root::__BindgenOpaqueArray8<[u8; 32usize]>;
            pub const Document_DocumentWarnings_eIgnoringWillChangeOverBudget:
                Document_DocumentWarnings = 0;
            pub const Document_DocumentWarnings_ePreventDefaultFromPassiveListener:
                Document_DocumentWarnings = 1;
            pub const Document_DocumentWarnings_eSVGRefLoop: Document_DocumentWarnings = 2;
            pub const Document_DocumentWarnings_eSVGRefChainLengthExceeded:
                Document_DocumentWarnings = 3;
            pub const Document_DocumentWarnings_eNotificationsRequireUserGestureDeprecation:
                Document_DocumentWarnings = 4;
            pub const Document_DocumentWarnings_eDocumentSetDomainIgnored:
                Document_DocumentWarnings = 5;
            pub const Document_DocumentWarnings_eDocumentWarningCount: Document_DocumentWarnings =
                6;
            pub type Document_DocumentWarnings = ::std::os::raw::c_uint;
            pub const Document_DispatchVisibilityChange_No: Document_DispatchVisibilityChange = 0;
            pub const Document_DispatchVisibilityChange_Yes: Document_DispatchVisibilityChange = 1;
            pub type Document_DispatchVisibilityChange = ::std::os::raw::c_int;
            pub const Document_IncludeChromeOnly_No: Document_IncludeChromeOnly = false;
            pub const Document_IncludeChromeOnly_Yes: Document_IncludeChromeOnly = true;
            pub type Document_IncludeChromeOnly = bool;
            pub const Document_ReportToConsole_No: Document_ReportToConsole = false;
            pub const Document_ReportToConsole_Yes: Document_ReportToConsole = true;
            pub type Document_ReportToConsole = bool;
            pub const Document_IgnoreRFP_No: Document_IgnoreRFP = 0;
            pub const Document_IgnoreRFP_Yes: Document_IgnoreRFP = 1;
            pub type Document_IgnoreRFP = ::std::os::raw::c_int;
            #[repr(C)]
            #[derive(Debug)]
            pub struct Document_PendingFrameStaticClone {
                pub mElement: root::RefPtr<root::nsFrameLoaderOwner>,
                pub mStaticCloneOf: root::RefPtr<root::nsFrameLoader>,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_PendingFrameStaticClone"]
                    [::std::mem::size_of::<Document_PendingFrameStaticClone>() - 16usize];
                ["Alignment of Document_PendingFrameStaticClone"]
                    [::std::mem::align_of::<Document_PendingFrameStaticClone>() - 8usize];
                ["Offset of field: Document_PendingFrameStaticClone::mElement"]
                    [::std::mem::offset_of!(Document_PendingFrameStaticClone, mElement) - 0usize];
                ["Offset of field: Document_PendingFrameStaticClone::mStaticCloneOf"][::std::mem::offset_of!(
                    Document_PendingFrameStaticClone,
                    mStaticCloneOf
                ) - 8usize];
            };
            pub const Document_ExecCommandParam_Ignore: Document_ExecCommandParam = 0;
            pub const Document_ExecCommandParam_String: Document_ExecCommandParam = 1;
            pub const Document_ExecCommandParam_Boolean: Document_ExecCommandParam = 2;
            pub const Document_ExecCommandParam_InvertedBoolean: Document_ExecCommandParam = 3;
            pub type Document_ExecCommandParam = u8;
            pub type Document_GetEditorCommandFunc =
                ::std::option::Option<unsafe extern "C" fn() -> *mut root::mozilla::EditorCommand>;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Document_InternalCommandData {
                pub mXULCommandName: *const ::std::os::raw::c_char,
                pub mCommand: root::mozilla::Command,
                pub mExecCommandParam: root::mozilla::dom::Document_ExecCommandParam,
                pub mGetEditorCommandFunc: root::mozilla::dom::Document_GetEditorCommandFunc,
                pub mCommandOnTextEditor:
                    root::mozilla::dom::Document_InternalCommandData_CommandOnTextEditor,
            }
            pub const Document_InternalCommandData_CommandOnTextEditor_Disabled:
                Document_InternalCommandData_CommandOnTextEditor = 0;
            pub const Document_InternalCommandData_CommandOnTextEditor_Enabled:
                Document_InternalCommandData_CommandOnTextEditor = 1;
            pub const Document_InternalCommandData_CommandOnTextEditor_FallThrough:
                Document_InternalCommandData_CommandOnTextEditor = 2;
            pub type Document_InternalCommandData_CommandOnTextEditor = u8;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_InternalCommandData"]
                    [::std::mem::size_of::<Document_InternalCommandData>() - 32usize];
                ["Alignment of Document_InternalCommandData"]
                    [::std::mem::align_of::<Document_InternalCommandData>() - 8usize];
                ["Offset of field: Document_InternalCommandData::mXULCommandName"][::std::mem::offset_of!(
                    Document_InternalCommandData,
                    mXULCommandName
                ) - 0usize];
                ["Offset of field: Document_InternalCommandData::mCommand"]
                    [::std::mem::offset_of!(Document_InternalCommandData, mCommand) - 8usize];
                ["Offset of field: Document_InternalCommandData::mExecCommandParam"][::std::mem::offset_of!(
                    Document_InternalCommandData,
                    mExecCommandParam
                ) - 9usize];
                ["Offset of field: Document_InternalCommandData::mGetEditorCommandFunc"][::std::mem::offset_of!(
                    Document_InternalCommandData,
                    mGetEditorCommandFunc
                )
                    - 16usize];
                ["Offset of field: Document_InternalCommandData::mCommandOnTextEditor"][::std::mem::offset_of!(
                    Document_InternalCommandData,
                    mCommandOnTextEditor
                )
                    - 24usize];
            };
            #[doc = " AutoEditorCommandTarget considers which editor or global command manager\n handles given command."]
            #[repr(C)]
            #[derive(Debug)]
            pub struct Document_AutoEditorCommandTarget {
                pub mActiveEditor: root::RefPtr<root::mozilla::EditorBase>,
                pub mHTMLEditor: root::RefPtr<root::mozilla::HTMLEditor>,
                pub mEditorCommand: root::RefPtr<root::mozilla::EditorCommand>,
                pub mCommandData: *const root::mozilla::dom::Document_InternalCommandData,
                pub mDoNothing: bool,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_AutoEditorCommandTarget"]
                    [::std::mem::size_of::<Document_AutoEditorCommandTarget>() - 40usize];
                ["Alignment of Document_AutoEditorCommandTarget"]
                    [::std::mem::align_of::<Document_AutoEditorCommandTarget>() - 8usize];
                ["Offset of field: Document_AutoEditorCommandTarget::mActiveEditor"][::std::mem::offset_of!(
                    Document_AutoEditorCommandTarget,
                    mActiveEditor
                ) - 0usize];
                ["Offset of field: Document_AutoEditorCommandTarget::mHTMLEditor"][::std::mem::offset_of!(
                    Document_AutoEditorCommandTarget,
                    mHTMLEditor
                ) - 8usize];
                ["Offset of field: Document_AutoEditorCommandTarget::mEditorCommand"][::std::mem::offset_of!(
                    Document_AutoEditorCommandTarget,
                    mEditorCommand
                ) - 16usize];
                ["Offset of field: Document_AutoEditorCommandTarget::mCommandData"][::std::mem::offset_of!(
                    Document_AutoEditorCommandTarget,
                    mCommandData
                ) - 24usize];
                ["Offset of field: Document_AutoEditorCommandTarget::mDoNothing"][::std::mem::offset_of!(
                    Document_AutoEditorCommandTarget,
                    mDoNothing
                ) - 32usize];
            };
            #[doc = " AutoRunningExecCommandMarker is AutoRestorer for mIsRunningExecCommand.\n Since it's a bit field, not a bool member, therefore, we cannot use\n AutoRestorer for it."]
            #[repr(C)]
            #[derive(Debug)]
            pub struct Document_AutoRunningExecCommandMarker {
                pub mDocument: *mut root::mozilla::dom::Document,
                pub mTreatAsUserInput: bool,
                pub mHasBeenRunningByContent: bool,
                pub mHasBeenRunningByChromeOrAddon: bool,
            }
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document_AutoRunningExecCommandMarker"]
                    [::std::mem::size_of::<Document_AutoRunningExecCommandMarker>() - 16usize];
                ["Alignment of Document_AutoRunningExecCommandMarker"]
                    [::std::mem::align_of::<Document_AutoRunningExecCommandMarker>() - 8usize];
                ["Offset of field: Document_AutoRunningExecCommandMarker::mDocument"][::std::mem::offset_of!(
                    Document_AutoRunningExecCommandMarker,
                    mDocument
                ) - 0usize];
                ["Offset of field: Document_AutoRunningExecCommandMarker::mTreatAsUserInput"][::std::mem::offset_of!(
                    Document_AutoRunningExecCommandMarker,
                    mTreatAsUserInput
                )
                    - 8usize];
                [
                    "Offset of field: Document_AutoRunningExecCommandMarker::mHasBeenRunningByContent",
                ][::std::mem::offset_of!(
                    Document_AutoRunningExecCommandMarker,
                    mHasBeenRunningByContent
                ) - 9usize];
                [
                    "Offset of field: Document_AutoRunningExecCommandMarker::mHasBeenRunningByChromeOrAddon",
                ][::std::mem::offset_of!(
                    Document_AutoRunningExecCommandMarker,
                    mHasBeenRunningByChromeOrAddon
                ) - 10usize];
            };
            pub type Document_InternalCommandDataHashtable = u8;
            pub type Document_AutomaticStorageAccessPermissionGrantPromise =
                root::__BindgenOpaqueArray8<[u8; 112usize]>;
            #[doc = " Templated hash set. Don't use this directly, but use nsTHashSet instead\n (defined as a type alias in nsHashtablesFwd.h).\n\n @param KeyClass a wrapper-class for the hashtable key, see nsHashKeys.h\n   for a complete specification."]
            pub type Document_SVGUseElementSet = root::__BindgenOpaqueArray8<[u8; 32usize]>;
            pub type Document_LinksToUpdateList = root::__BindgenOpaqueArray8<[u8; 24usize]>;
            #[repr(u32)]
            #[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
            pub enum Document_Type {
                eUnknown = 0,
                eHTML = 1,
                eXHTML = 2,
                eGenericXML = 3,
                eSVG = 4,
            }
            pub const Document_Tri_eTriUnset: Document_Tri = 0;
            pub const Document_Tri_eTriFalse: Document_Tri = 1;
            pub const Document_Tri_eTriTrue: Document_Tri = 2;
            pub type Document_Tri = ::std::os::raw::c_uint;
            pub const Document_ViewportType_DisplayWidthHeight: Document_ViewportType = 0;
            pub const Document_ViewportType_Specified: Document_ViewportType = 1;
            pub const Document_ViewportType_Unknown: Document_ViewportType = 2;
            pub type Document_ViewportType = u8;
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Document_HeaderData {
                _unused: [u8; 0],
            }
            #[repr(C)]
            #[derive(Debug, Copy, Clone)]
            pub struct Document_TitleChangeEvent {
                _unused: [u8; 0],
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom8Document21_cycleCollectorGlobalE"]
                pub static mut Document__cycleCollectorGlobal:
                    root::mozilla::dom::Document_cycleCollection;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom8Document29sInternalCommandDataHashtableE"]
                pub static mut Document_sInternalCommandDataHashtable:
                    *mut root::mozilla::dom::Document_InternalCommandDataHashtable;
            }
            unsafe extern "C" {
                #[link_name = "\u{1}_ZN7mozilla3dom8Document41sLoadingForegroundTopLevelContentDocumentE"]
                pub static mut Document_sLoadingForegroundTopLevelContentDocument: *mut u8;
            }
            pub const Document_kSegmentSize: usize = 128;
            #[allow(clippy::unnecessary_operation, clippy::identity_op)]
            const _: () = {
                ["Size of Document"][::std::mem::size_of::<Document>() - 2992usize];
                ["Alignment of Document"][::std::mem::align_of::<Document>() - 8usize];
                ["Offset of field: Document::mDocumentL10n"]
                    [::std::mem::offset_of!(Document, mDocumentL10n) - 232usize];
                ["Offset of field: Document::mDeprecationWarnedAbout"]
                    [::std::mem::offset_of!(Document, mDeprecationWarnedAbout) - 240usize];
                ["Offset of field: Document::mDocWarningWarnedAbout"]
                    [::std::mem::offset_of!(Document, mDocWarningWarnedAbout) - 248usize];
                ["Offset of field: Document::mStyleSet"]
                    [::std::mem::offset_of!(Document, mStyleSet) - 256usize];
                ["Offset of field: Document::mPreloadReferrerInfo"]
                    [::std::mem::offset_of!(Document, mPreloadReferrerInfo) - 264usize];
                ["Offset of field: Document::mReferrerInfo"]
                    [::std::mem::offset_of!(Document, mReferrerInfo) - 272usize];
                ["Offset of field: Document::mRequestReferrerPolicy"]
                    [::std::mem::offset_of!(Document, mRequestReferrerPolicy) - 280usize];
                ["Offset of field: Document::mLastModified"]
                    [::std::mem::offset_of!(Document, mLastModified) - 288usize];
                ["Offset of field: Document::mDocumentURI"]
                    [::std::mem::offset_of!(Document, mDocumentURI) - 304usize];
                ["Offset of field: Document::mOriginalURI"]
                    [::std::mem::offset_of!(Document, mOriginalURI) - 312usize];
                ["Offset of field: Document::mChromeXHRDocURI"]
                    [::std::mem::offset_of!(Document, mChromeXHRDocURI) - 320usize];
                ["Offset of field: Document::mDocumentBaseURI"]
                    [::std::mem::offset_of!(Document, mDocumentBaseURI) - 328usize];
                ["Offset of field: Document::mChromeXHRDocBaseURI"]
                    [::std::mem::offset_of!(Document, mChromeXHRDocBaseURI) - 336usize];
                ["Offset of field: Document::mCachedURLData"]
                    [::std::mem::offset_of!(Document, mCachedURLData) - 344usize];
                ["Offset of field: Document::mCachedReferrerInfoForInternalCSSAndSVGResources"][::std::mem::offset_of!(
                    Document,
                    mCachedReferrerInfoForInternalCSSAndSVGResources
                )
                    - 352usize];
                ["Offset of field: Document::mDocumentLoadGroup"]
                    [::std::mem::offset_of!(Document, mDocumentLoadGroup) - 360usize];
                ["Offset of field: Document::mDocumentContainer"]
                    [::std::mem::offset_of!(Document, mDocumentContainer) - 368usize];
                ["Offset of field: Document::mCharacterSet"]
                    [::std::mem::offset_of!(Document, mCharacterSet) - 376usize];
                ["Offset of field: Document::mCharacterSetSource"]
                    [::std::mem::offset_of!(Document, mCharacterSetSource) - 384usize];
                ["Offset of field: Document::mTrials"]
                    [::std::mem::offset_of!(Document, mTrials) - 388usize];
                ["Offset of field: Document::mParentDocument"]
                    [::std::mem::offset_of!(Document, mParentDocument) - 392usize];
                ["Offset of field: Document::mCachedRootElement"]
                    [::std::mem::offset_of!(Document, mCachedRootElement) - 400usize];
                ["Offset of field: Document::mCurrentContextPaint"]
                    [::std::mem::offset_of!(Document, mCurrentContextPaint) - 408usize];
                ["Offset of field: Document::mNodeInfoManager"]
                    [::std::mem::offset_of!(Document, mNodeInfoManager) - 416usize];
                ["Offset of field: Document::mCSSLoader"]
                    [::std::mem::offset_of!(Document, mCSSLoader) - 424usize];
                ["Offset of field: Document::mStyleImageLoader"]
                    [::std::mem::offset_of!(Document, mStyleImageLoader) - 432usize];
                ["Offset of field: Document::mAttributeStyles"]
                    [::std::mem::offset_of!(Document, mAttributeStyles) - 440usize];
                ["Offset of field: Document::mTrackedImages"]
                    [::std::mem::offset_of!(Document, mTrackedImages) - 448usize];
                ["Offset of field: Document::mComposedShadowRoots"]
                    [::std::mem::offset_of!(Document, mComposedShadowRoots) - 480usize];
                ["Offset of field: Document::mSVGUseElementsNeedingShadowTreeUpdate"][::std::mem::offset_of!(
                    Document,
                    mSVGUseElementsNeedingShadowTreeUpdate
                ) - 512usize];
                ["Offset of field: Document::mActivityObservers"]
                    [::std::mem::offset_of!(Document, mActivityObservers) - 544usize];
                ["Offset of field: Document::mStyledLinks"]
                    [::std::mem::offset_of!(Document, mStyledLinks) - 552usize];
                ["Offset of field: Document::mLinksToUpdate"]
                    [::std::mem::offset_of!(Document, mLinksToUpdate) - 584usize];
                ["Offset of field: Document::mAnimationController"]
                    [::std::mem::offset_of!(Document, mAnimationController) - 608usize];
                ["Offset of field: Document::mPropertyTable"]
                    [::std::mem::offset_of!(Document, mPropertyTable) - 616usize];
                ["Offset of field: Document::mChildrenCollection"]
                    [::std::mem::offset_of!(Document, mChildrenCollection) - 624usize];
                ["Offset of field: Document::mImages"]
                    [::std::mem::offset_of!(Document, mImages) - 632usize];
                ["Offset of field: Document::mEmbeds"]
                    [::std::mem::offset_of!(Document, mEmbeds) - 640usize];
                ["Offset of field: Document::mLinks"]
                    [::std::mem::offset_of!(Document, mLinks) - 648usize];
                ["Offset of field: Document::mForms"]
                    [::std::mem::offset_of!(Document, mForms) - 656usize];
                ["Offset of field: Document::mScripts"]
                    [::std::mem::offset_of!(Document, mScripts) - 664usize];
                ["Offset of field: Document::mApplets"]
                    [::std::mem::offset_of!(Document, mApplets) - 672usize];
                ["Offset of field: Document::mAnchors"]
                    [::std::mem::offset_of!(Document, mAnchors) - 680usize];
                ["Offset of field: Document::mFontFaceSet"]
                    [::std::mem::offset_of!(Document, mFontFaceSet) - 688usize];
                ["Offset of field: Document::mLastFocusTime"]
                    [::std::mem::offset_of!(Document, mLastFocusTime) - 696usize];
                ["Offset of field: Document::mLastScrollLinkedEffectDetectionTime"][::std::mem::offset_of!(
                    Document,
                    mLastScrollLinkedEffectDetectionTime
                ) - 704usize];
                ["Offset of field: Document::mState"]
                    [::std::mem::offset_of!(Document, mState) - 712usize];
                ["Offset of field: Document::mReadyForIdle"]
                    [::std::mem::offset_of!(Document, mReadyForIdle) - 720usize];
                ["Offset of field: Document::mFeaturePolicy"]
                    [::std::mem::offset_of!(Document, mFeaturePolicy) - 728usize];
                ["Offset of field: Document::mPermissionDelegateHandler"]
                    [::std::mem::offset_of!(Document, mPermissionDelegateHandler) - 736usize];
                ["Offset of field: Document::mInitialStatus"]
                    [::std::mem::offset_of!(Document, mInitialStatus) - 744usize];
                ["Offset of field: Document::mOverriddenFingerprintingSettings"][::std::mem::offset_of!(
                    Document,
                    mOverriddenFingerprintingSettings
                ) - 760usize];
                ["Offset of field: Document::mXMLDeclarationBits"]
                    [::std::mem::offset_of!(Document, mXMLDeclarationBits) - 784usize];
                ["Offset of field: Document::mColorSchemeBits"]
                    [::std::mem::offset_of!(Document, mColorSchemeBits) - 785usize];
                ["Offset of field: Document::mOnloadBlockCount"]
                    [::std::mem::offset_of!(Document, mOnloadBlockCount) - 788usize];
                ["Offset of field: Document::mWriteLevel"]
                    [::std::mem::offset_of!(Document, mWriteLevel) - 792usize];
                ["Offset of field: Document::mContentEditableCount"]
                    [::std::mem::offset_of!(Document, mContentEditableCount) - 796usize];
                ["Offset of field: Document::mEditingState"]
                    [::std::mem::offset_of!(Document, mEditingState) - 800usize];
                ["Offset of field: Document::mCompatMode"]
                    [::std::mem::offset_of!(Document, mCompatMode) - 804usize];
                ["Offset of field: Document::mReadyState"]
                    [::std::mem::offset_of!(Document, mReadyState) - 808usize];
                ["Offset of field: Document::mAncestorIsLoading"]
                    [::std::mem::offset_of!(Document, mAncestorIsLoading) - 812usize];
                ["Offset of field: Document::mVisibilityState"]
                    [::std::mem::offset_of!(Document, mVisibilityState) - 813usize];
                ["Offset of field: Document::mType"]
                    [::std::mem::offset_of!(Document, mType) - 816usize];
                ["Offset of field: Document::mDefaultElementType"]
                    [::std::mem::offset_of!(Document, mDefaultElementType) - 820usize];
                ["Offset of field: Document::mAllowXULXBL"]
                    [::std::mem::offset_of!(Document, mAllowXULXBL) - 824usize];
                ["Offset of field: Document::mSkipDTDSecurityChecks"]
                    [::std::mem::offset_of!(Document, mSkipDTDSecurityChecks) - 828usize];
                ["Offset of field: Document::mScriptGlobalObject"]
                    [::std::mem::offset_of!(Document, mScriptGlobalObject) - 832usize];
                ["Offset of field: Document::mOriginalDocument"]
                    [::std::mem::offset_of!(Document, mOriginalDocument) - 840usize];
                ["Offset of field: Document::mBidiOptions"]
                    [::std::mem::offset_of!(Document, mBidiOptions) - 848usize];
                ["Offset of field: Document::mSandboxFlags"]
                    [::std::mem::offset_of!(Document, mSandboxFlags) - 852usize];
                ["Offset of field: Document::mEmbedderPolicy"]
                    [::std::mem::offset_of!(Document, mEmbedderPolicy) - 856usize];
                ["Offset of field: Document::mContentLanguage"]
                    [::std::mem::offset_of!(Document, mContentLanguage) - 864usize];
                ["Offset of field: Document::mChannel"]
                    [::std::mem::offset_of!(Document, mChannel) - 872usize];
                ["Offset of field: Document::mPreloadCSP"]
                    [::std::mem::offset_of!(Document, mPreloadCSP) - 880usize];
                ["Offset of field: Document::mPolicyContainer"]
                    [::std::mem::offset_of!(Document, mPolicyContainer) - 888usize];
                ["Offset of field: Document::mContentType"]
                    [::std::mem::offset_of!(Document, mContentType) - 896usize];
                ["Offset of field: Document::mSecurityInfo"]
                    [::std::mem::offset_of!(Document, mSecurityInfo) - 912usize];
                ["Offset of field: Document::mFailedChannel"]
                    [::std::mem::offset_of!(Document, mFailedChannel) - 920usize];
                ["Offset of field: Document::mASMJSExecutionTimer"]
                    [::std::mem::offset_of!(Document, mASMJSExecutionTimer) - 928usize];
                ["Offset of field: Document::mPartID"]
                    [::std::mem::offset_of!(Document, mPartID) - 936usize];
                ["Offset of field: Document::mMarkedCCGeneration"]
                    [::std::mem::offset_of!(Document, mMarkedCCGeneration) - 940usize];
                ["Offset of field: Document::mPresShell"]
                    [::std::mem::offset_of!(Document, mPresShell) - 944usize];
                ["Offset of field: Document::mPreloadingImages"]
                    [::std::mem::offset_of!(Document, mPreloadingImages) - 952usize];
                ["Offset of field: Document::mPreloadedPreconnects"]
                    [::std::mem::offset_of!(Document, mPreloadedPreconnects) - 984usize];
                ["Offset of field: Document::mPreloadPictureDepth"]
                    [::std::mem::offset_of!(Document, mPreloadPictureDepth) - 1016usize];
                ["Offset of field: Document::mPreloadPictureFoundSource"]
                    [::std::mem::offset_of!(Document, mPreloadPictureFoundSource) - 1024usize];
                ["Offset of field: Document::mDisplayDocument"]
                    [::std::mem::offset_of!(Document, mDisplayDocument) - 1040usize];
                ["Offset of field: Document::mEventsSuppressed"]
                    [::std::mem::offset_of!(Document, mEventsSuppressed) - 1048usize];
                ["Offset of field: Document::mSuspendedQueues"]
                    [::std::mem::offset_of!(Document, mSuspendedQueues) - 1056usize];
                ["Offset of field: Document::mSuspendedPostMessageEvents"]
                    [::std::mem::offset_of!(Document, mSuspendedPostMessageEvents) - 1064usize];
                ["Offset of field: Document::mSuppressedEventListener"]
                    [::std::mem::offset_of!(Document, mSuppressedEventListener) - 1072usize];
                ["Offset of field: Document::mIgnoreDestructiveWritesCounter"]
                    [::std::mem::offset_of!(Document, mIgnoreDestructiveWritesCounter) - 1080usize];
                ["Offset of field: Document::mStaticCloneCount"]
                    [::std::mem::offset_of!(Document, mStaticCloneCount) - 1084usize];
                ["Offset of field: Document::mLatestStaticClone"]
                    [::std::mem::offset_of!(Document, mLatestStaticClone) - 1088usize];
                ["Offset of field: Document::mBlockedNodesByClassifier"]
                    [::std::mem::offset_of!(Document, mBlockedNodesByClassifier) - 1096usize];
                ["Offset of field: Document::mWindow"]
                    [::std::mem::offset_of!(Document, mWindow) - 1104usize];
                ["Offset of field: Document::mCachedEncoder"]
                    [::std::mem::offset_of!(Document, mCachedEncoder) - 1112usize];
                ["Offset of field: Document::mFrameRequestManager"]
                    [::std::mem::offset_of!(Document, mFrameRequestManager) - 1120usize];
                ["Offset of field: Document::mBFCacheEntry"]
                    [::std::mem::offset_of!(Document, mBFCacheEntry) - 1168usize];
                ["Offset of field: Document::mBaseTarget"]
                    [::std::mem::offset_of!(Document, mBaseTarget) - 1176usize];
                ["Offset of field: Document::mStateObjectContainer"]
                    [::std::mem::offset_of!(Document, mStateObjectContainer) - 1192usize];
                ["Offset of field: Document::mCachedStateObject"]
                    [::std::mem::offset_of!(Document, mCachedStateObject) - 1200usize];
                ["Offset of field: Document::mInSyncOperationCount"]
                    [::std::mem::offset_of!(Document, mInSyncOperationCount) - 1208usize];
                ["Offset of field: Document::mXPathEvaluator"]
                    [::std::mem::offset_of!(Document, mXPathEvaluator) - 1216usize];
                ["Offset of field: Document::mAnonymousContents"]
                    [::std::mem::offset_of!(Document, mAnonymousContents) - 1224usize];
                ["Offset of field: Document::mCustomContentContainer"]
                    [::std::mem::offset_of!(Document, mCustomContentContainer) - 1232usize];
                ["Offset of field: Document::mBlockDOMContentLoaded"]
                    [::std::mem::offset_of!(Document, mBlockDOMContentLoaded) - 1240usize];
                ["Offset of field: Document::mDOMMediaQueryLists"]
                    [::std::mem::offset_of!(Document, mDOMMediaQueryLists) - 1248usize];
                ["Offset of field: Document::mContentIdentifiersForLCP"]
                    [::std::mem::offset_of!(Document, mContentIdentifiersForLCP) - 1272usize];
                ["Offset of field: Document::mObservers"]
                    [::std::mem::offset_of!(Document, mObservers) - 1304usize];
                ["Offset of field: Document::mUseCounters"]
                    [::std::mem::offset_of!(Document, mUseCounters) - 1320usize];
                ["Offset of field: Document::mChildDocumentUseCounters"]
                    [::std::mem::offset_of!(Document, mChildDocumentUseCounters) - 1464usize];
                ["Offset of field: Document::mStyleUseCounters"]
                    [::std::mem::offset_of!(Document, mStyleUseCounters) - 1608usize];
                ["Offset of field: Document::mPageUnloadingEventTimeStamp"]
                    [::std::mem::offset_of!(Document, mPageUnloadingEventTimeStamp) - 1616usize];
                ["Offset of field: Document::mDocGroup"]
                    [::std::mem::offset_of!(Document, mDocGroup) - 1624usize];
                ["Offset of field: Document::mMidasCommandManager"]
                    [::std::mem::offset_of!(Document, mMidasCommandManager) - 1632usize];
                ["Offset of field: Document::mTrackingScripts"]
                    [::std::mem::offset_of!(Document, mTrackingScripts) - 1640usize];
                ["Offset of field: Document::mParser"]
                    [::std::mem::offset_of!(Document, mParser) - 1672usize];
                ["Offset of field: Document::mPrototypeDocument"]
                    [::std::mem::offset_of!(Document, mPrototypeDocument) - 1680usize];
                ["Offset of field: Document::mWeakSink"]
                    [::std::mem::offset_of!(Document, mWeakSink) - 1688usize];
                ["Offset of field: Document::mUpdateNestLevel"]
                    [::std::mem::offset_of!(Document, mUpdateNestLevel) - 1696usize];
                ["Offset of field: Document::mHttpsOnlyStatus"]
                    [::std::mem::offset_of!(Document, mHttpsOnlyStatus) - 1700usize];
                ["Offset of field: Document::mViewportType"]
                    [::std::mem::offset_of!(Document, mViewportType) - 1704usize];
                ["Offset of field: Document::mViewportFit"]
                    [::std::mem::offset_of!(Document, mViewportFit) - 1705usize];
                ["Offset of field: Document::mInteractiveWidgetMode"]
                    [::std::mem::offset_of!(Document, mInteractiveWidgetMode) - 1706usize];
                ["Offset of field: Document::mSubDocuments"]
                    [::std::mem::offset_of!(Document, mSubDocuments) - 1712usize];
                ["Offset of field: Document::mHeaderData"]
                    [::std::mem::offset_of!(Document, mHeaderData) - 1720usize];
                ["Offset of field: Document::mEarlyHints"]
                    [::std::mem::offset_of!(Document, mEarlyHints) - 1728usize];
                ["Offset of field: Document::mPendingTitleChangeEvent"]
                    [::std::mem::offset_of!(Document, mPendingTitleChangeEvent) - 1736usize];
                ["Offset of field: Document::mTiming"]
                    [::std::mem::offset_of!(Document, mTiming) - 1744usize];
                ["Offset of field: Document::mLoadingOrRestoredFromBFCacheTimeStamp"][::std::mem::offset_of!(
                    Document,
                    mLoadingOrRestoredFromBFCacheTimeStamp
                )
                    - 1752usize];
                ["Offset of field: Document::mAutoFocusCandidates"]
                    [::std::mem::offset_of!(Document, mAutoFocusCandidates) - 1760usize];
                ["Offset of field: Document::mScrollToRef"]
                    [::std::mem::offset_of!(Document, mScrollToRef) - 1776usize];
                ["Offset of field: Document::mScopeObject"]
                    [::std::mem::offset_of!(Document, mScopeObject) - 1792usize];
                ["Offset of field: Document::mIntersectionObservers"]
                    [::std::mem::offset_of!(Document, mIntersectionObservers) - 1800usize];
                ["Offset of field: Document::mResizeObservers"]
                    [::std::mem::offset_of!(Document, mResizeObservers) - 1808usize];
                ["Offset of field: Document::mLazyLoadObserver"]
                    [::std::mem::offset_of!(Document, mLazyLoadObserver) - 1816usize];
                ["Offset of field: Document::mElementsObservedForLastRememberedSize"][::std::mem::offset_of!(
                    Document,
                    mElementsObservedForLastRememberedSize
                )
                    - 1824usize];
                ["Offset of field: Document::mTopLayer"]
                    [::std::mem::offset_of!(Document, mTopLayer) - 1856usize];
                ["Offset of field: Document::mOpenDialogs"]
                    [::std::mem::offset_of!(Document, mOpenDialogs) - 1864usize];
                ["Offset of field: Document::mLastDialogPointerdownTarget"]
                    [::std::mem::offset_of!(Document, mLastDialogPointerdownTarget) - 1872usize];
                ["Offset of field: Document::mFullscreenRoot"]
                    [::std::mem::offset_of!(Document, mFullscreenRoot) - 1880usize];
                ["Offset of field: Document::mDOMImplementation"]
                    [::std::mem::offset_of!(Document, mDOMImplementation) - 1888usize];
                ["Offset of field: Document::mImageMaps"]
                    [::std::mem::offset_of!(Document, mImageMaps) - 1896usize];
                ["Offset of field: Document::mResponsiveContent"]
                    [::std::mem::offset_of!(Document, mResponsiveContent) - 1904usize];
                ["Offset of field: Document::mDocumentTimeline"]
                    [::std::mem::offset_of!(Document, mDocumentTimeline) - 1936usize];
                ["Offset of field: Document::mTimelines"]
                    [::std::mem::offset_of!(Document, mTimelines) - 1944usize];
                ["Offset of field: Document::mScriptLoader"]
                    [::std::mem::offset_of!(Document, mScriptLoader) - 1968usize];
                ["Offset of field: Document::mScrollTimelineAnimationTracker"]
                    [::std::mem::offset_of!(Document, mScrollTimelineAnimationTracker) - 1976usize];
                ["Offset of field: Document::mTemplateContentsOwner"]
                    [::std::mem::offset_of!(Document, mTemplateContentsOwner) - 1984usize];
                ["Offset of field: Document::mExternalResourceMap"]
                    [::std::mem::offset_of!(Document, mExternalResourceMap) - 1992usize];
                ["Offset of field: Document::mOrientationPendingPromise"]
                    [::std::mem::offset_of!(Document, mOrientationPendingPromise) - 2064usize];
                ["Offset of field: Document::mInitializableFrameLoaders"]
                    [::std::mem::offset_of!(Document, mInitializableFrameLoaders) - 2072usize];
                ["Offset of field: Document::mFrameLoaderFinalizers"]
                    [::std::mem::offset_of!(Document, mFrameLoaderFinalizers) - 2080usize];
                ["Offset of field: Document::mFrameLoaderRunner"]
                    [::std::mem::offset_of!(Document, mFrameLoaderRunner) - 2088usize];
                ["Offset of field: Document::mPendingFrameStaticClones"]
                    [::std::mem::offset_of!(Document, mPendingFrameStaticClones) - 2096usize];
                ["Offset of field: Document::mLayoutHistoryState"]
                    [::std::mem::offset_of!(Document, mLayoutHistoryState) - 2104usize];
                ["Offset of field: Document::mActiveLocks"]
                    [::std::mem::offset_of!(Document, mActiveLocks) - 2112usize];
                ["Offset of field: Document::mLastModifiedViewportMetaData"]
                    [::std::mem::offset_of!(Document, mLastModifiedViewportMetaData) - 2144usize];
                ["Offset of field: Document::mColorSchemeMetaTags"]
                    [::std::mem::offset_of!(Document, mColorSchemeMetaTags) - 2152usize];
                ["Offset of field: Document::mScaleMinFloat"]
                    [::std::mem::offset_of!(Document, mScaleMinFloat) - 2176usize];
                ["Offset of field: Document::mScaleMaxFloat"]
                    [::std::mem::offset_of!(Document, mScaleMaxFloat) - 2180usize];
                ["Offset of field: Document::mScaleFloat"]
                    [::std::mem::offset_of!(Document, mScaleFloat) - 2184usize];
                ["Offset of field: Document::mPixelRatio"]
                    [::std::mem::offset_of!(Document, mPixelRatio) - 2188usize];
                ["Offset of field: Document::mMinWidth"]
                    [::std::mem::offset_of!(Document, mMinWidth) - 2192usize];
                ["Offset of field: Document::mMaxWidth"]
                    [::std::mem::offset_of!(Document, mMaxWidth) - 2196usize];
                ["Offset of field: Document::mMinHeight"]
                    [::std::mem::offset_of!(Document, mMinHeight) - 2200usize];
                ["Offset of field: Document::mMaxHeight"]
                    [::std::mem::offset_of!(Document, mMaxHeight) - 2204usize];
                ["Offset of field: Document::mListenerManager"]
                    [::std::mem::offset_of!(Document, mListenerManager) - 2208usize];
                ["Offset of field: Document::mOnloadBlocker"]
                    [::std::mem::offset_of!(Document, mOnloadBlocker) - 2216usize];
                ["Offset of field: Document::mAdditionalSheets"]
                    [::std::mem::offset_of!(Document, mAdditionalSheets) - 2224usize];
                ["Offset of field: Document::mLastStyleSheetSet"]
                    [::std::mem::offset_of!(Document, mLastStyleSheetSet) - 2248usize];
                ["Offset of field: Document::mPreferredStyleSheetSet"]
                    [::std::mem::offset_of!(Document, mPreferredStyleSheetSet) - 2264usize];
                ["Offset of field: Document::mStyleSheetSetList"]
                    [::std::mem::offset_of!(Document, mStyleSheetSetList) - 2280usize];
                ["Offset of field: Document::mLazyPresElements"]
                    [::std::mem::offset_of!(Document, mLazyPresElements) - 2288usize];
                ["Offset of field: Document::mLanguagesUsed"]
                    [::std::mem::offset_of!(Document, mLanguagesUsed) - 2320usize];
                ["Offset of field: Document::mLanguageFromCharset"]
                    [::std::mem::offset_of!(Document, mLanguageFromCharset) - 2352usize];
                ["Offset of field: Document::mServoRestyleRoot"]
                    [::std::mem::offset_of!(Document, mServoRestyleRoot) - 2360usize];
                ["Offset of field: Document::mServoRestyleRootDirtyBits"]
                    [::std::mem::offset_of!(Document, mServoRestyleRootDirtyBits) - 2368usize];
                ["Offset of field: Document::mThrowOnDynamicMarkupInsertionCounter"][::std::mem::offset_of!(
                    Document,
                    mThrowOnDynamicMarkupInsertionCounter
                ) - 2372usize];
                ["Offset of field: Document::mIgnoreOpensDuringUnloadCounter"]
                    [::std::mem::offset_of!(Document, mIgnoreOpensDuringUnloadCounter) - 2376usize];
                ["Offset of field: Document::mCommandDispatcher"]
                    [::std::mem::offset_of!(Document, mCommandDispatcher) - 2384usize];
                ["Offset of field: Document::mXULBroadcastManager"]
                    [::std::mem::offset_of!(Document, mXULBroadcastManager) - 2392usize];
                ["Offset of field: Document::mXULPersist"]
                    [::std::mem::offset_of!(Document, mXULPersist) - 2400usize];
                ["Offset of field: Document::mChromeObserver"]
                    [::std::mem::offset_of!(Document, mChromeObserver) - 2408usize];
                ["Offset of field: Document::mAll"]
                    [::std::mem::offset_of!(Document, mAll) - 2416usize];
                ["Offset of field: Document::mActiveViewTransition"]
                    [::std::mem::offset_of!(Document, mActiveViewTransition) - 2424usize];
                ["Offset of field: Document::mViewTransitionUpdateCallbacks"]
                    [::std::mem::offset_of!(Document, mViewTransitionUpdateCallbacks) - 2432usize];
                ["Offset of field: Document::mWorkerListeners"]
                    [::std::mem::offset_of!(Document, mWorkerListeners) - 2440usize];
                ["Offset of field: Document::mSavedResolution"]
                    [::std::mem::offset_of!(Document, mSavedResolution) - 2472usize];
                ["Offset of field: Document::mCookieJarSettings"]
                    [::std::mem::offset_of!(Document, mCookieJarSettings) - 2480usize];
                ["Offset of field: Document::mHasStoragePermission"]
                    [::std::mem::offset_of!(Document, mHasStoragePermission) - 2488usize];
                ["Offset of field: Document::mClassificationFlags"]
                    [::std::mem::offset_of!(Document, mClassificationFlags) - 2492usize];
                ["Offset of field: Document::mGeneration"]
                    [::std::mem::offset_of!(Document, mGeneration) - 2500usize];
                ["Offset of field: Document::mCachedTabSizeGeneration"]
                    [::std::mem::offset_of!(Document, mCachedTabSizeGeneration) - 2504usize];
                ["Offset of field: Document::mCachedTabSizes"]
                    [::std::mem::offset_of!(Document, mCachedTabSizes) - 2512usize];
                ["Offset of field: Document::mPartitionedPrincipal"]
                    [::std::mem::offset_of!(Document, mPartitionedPrincipal) - 2536usize];
                ["Offset of field: Document::mActiveStoragePrincipal"]
                    [::std::mem::offset_of!(Document, mActiveStoragePrincipal) - 2544usize];
                ["Offset of field: Document::mActiveCookiePrincipal"]
                    [::std::mem::offset_of!(Document, mActiveCookiePrincipal) - 2552usize];
                ["Offset of field: Document::mPendingFullscreenEvents"]
                    [::std::mem::offset_of!(Document, mPendingFullscreenEvents) - 2560usize];
                ["Offset of field: Document::mNextFormNumber"]
                    [::std::mem::offset_of!(Document, mNextFormNumber) - 2568usize];
                ["Offset of field: Document::mNextControlNumber"]
                    [::std::mem::offset_of!(Document, mNextControlNumber) - 2572usize];
                ["Offset of field: Document::mMediaElementWithMSECount"]
                    [::std::mem::offset_of!(Document, mMediaElementWithMSECount) - 2576usize];
                ["Offset of field: Document::mPreloadService"]
                    [::std::mem::offset_of!(Document, mPreloadService) - 2584usize];
                ["Offset of field: Document::mShouldNotifyFetchSuccess"]
                    [::std::mem::offset_of!(Document, mShouldNotifyFetchSuccess) - 2640usize];
                ["Offset of field: Document::mShouldNotifyFormOrPasswordRemoved"][::std::mem::offset_of!(
                    Document,
                    mShouldNotifyFormOrPasswordRemoved
                ) - 2641usize];
                ["Offset of field: Document::mShadowedHTMLDocumentProperties"]
                    [::std::mem::offset_of!(Document, mShadowedHTMLDocumentProperties) - 2648usize];
                ["Offset of field: Document::mPageloadEventData"]
                    [::std::mem::offset_of!(Document, mPageloadEventData) - 2656usize];
                ["Offset of field: Document::mOOPChildrenLoading"]
                    [::std::mem::offset_of!(Document, mOOPChildrenLoading) - 2896usize];
                ["Offset of field: Document::mHighlightRegistry"]
                    [::std::mem::offset_of!(Document, mHighlightRegistry) - 2904usize];
                ["Offset of field: Document::mCanvasUsage"]
                    [::std::mem::offset_of!(Document, mCanvasUsage) - 2912usize];
                ["Offset of field: Document::mLastCanvasUsage"]
                    [::std::mem::offset_of!(Document, mLastCanvasUsage) - 2920usize];
                ["Offset of field: Document::mFragmentDirective"]
                    [::std::mem::offset_of!(Document, mFragmentDirective) - 2928usize];
                ["Offset of field: Document::mRadioGroupContainer"]
                    [::std::mem::offset_of!(Document, mRadioGroupContainer) - 2936usize];
                ["Offset of field: Document::mExpandoAndGeneration"]
                    [::std::mem::offset_of!(Document, mExpandoAndGeneration) - 2944usize];
                ["Offset of field: Document::mL10nProtoElements"]
                    [::std::mem::offset_of!(Document, mL10nProtoElements) - 2960usize];
            };
            impl Document {
                #[inline]
                pub fn mCachedStateObjectValid(&self) -> bool {
                    unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
                }
                #[inline]
                pub fn set_mCachedStateObjectValid(&mut self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        self._bitfield_1.set(0usize, 1u8, val as u64)
                    }
                }
                #[inline]
                pub unsafe fn mCachedStateObjectValid_raw(this: *const Self) -> bool {
                    unsafe {
                        ::std::mem::transmute(
                            <root::__BindgenBitfieldUnit<[u8; 13usize]>>::raw_get(
                                ::std::ptr::addr_of!((*this)._bitfield_1),
                                0usize,
                                1u8,
                            ) as u8,
                        )
                    }
                }
                #[inline]
                pub unsafe fn set_mCachedStateObjectValid_raw(this: *mut Self, val: bool) {
                    unsafe {
                        let val: u8 = ::std::mem::transmute(val);
                        <root::__BindgenBitfieldUnit<[u8; 13usize]>>::raw_set(
                            ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                            0usize,
                            1u8,
                            val as u64,
                        )
                    }
                }
     