/* THIS FILE IS AUTOGENERATED FROM Glean.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "GleanBinding.h"
#include "GleanMetricsBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/Record.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "mozilla/glean/bindings/Category.h"
#include "mozilla/glean/bindings/Glean.h"
#include "mozilla/glean/bindings/GleanMetric.h"
#include "mozilla/glean/bindings/Labeled.h"
#include "nsContentUtils.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (boolean or unsigned long long or USVString or GleanDistributionData)", &memberSlot)) {
      return false;
    }
  }
  return true;
}







bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToUnsignedLongLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    uint64_t& memberSlot = RawSetAsUnsignedLongLong();
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, value, "Unsigned long long branch of (boolean or unsigned long long or USVString or GleanDistributionData)", &memberSlot)) {
      return false;
    }
  }
  return true;
}







bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FakeString<char>& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}








bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToGleanDistributionData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    binding_detail::FastGleanDistributionData& memberSlot = RawSetAsGleanDistributionData();
    if (!IsConvertibleToDictionary(value)) {
      DestroyGleanDistributionData();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "GleanDistributionData branch of (boolean or unsigned long long or USVString or GleanDistributionData)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToGleanDistributionData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToGleanDistributionData(cx, value, tryNext, passedToJSImpl);
}







bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToGleanDistributionData(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      if (value.isBoolean()) {
        done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
        break;
      }
      if (value.isNumber()) {
        done = (failed = !TrySetToUnsignedLongLong(cx, value, tryNext)) || !tryNext;
        break;
      }
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "GleanDistributionData");
    return false;
  }
  return true;
}

bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}


bool
BooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eBoolean: {
      rval.setBoolean(mValue.mBoolean.Value());
      return true;
    }
    case eUnsignedLongLong: {
      rval.set(JS_NumberValue(double(mValue.mUnsignedLongLong.Value())));
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eGleanDistributionData: {
      if (!mValue.mGleanDistributionData.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}



OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData(OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData&& aOther)
  : mType(eUninitialized)
{
  switch (aOther.mType) {
    case eUninitialized: {
      MOZ_ASSERT(mType == eUninitialized,
                 "We need to destroy ourselves?");
      break;
    }
    case eBoolean: {
      mType = eBoolean;
      mValue.mBoolean.SetValue(std::move(aOther.mValue.mBoolean.Value()));
      break;
    }
    case eUnsignedLongLong: {
      mType = eUnsignedLongLong;
      mValue.mUnsignedLongLong.SetValue(std::move(aOther.mValue.mUnsignedLongLong.Value()));
      break;
    }
    case eUTF8String: {
      mType = eUTF8String;
      mValue.mUTF8String.SetValue(std::move(aOther.mValue.mUTF8String.Value()));
      break;
    }
    case eGleanDistributionData: {
      mType = eGleanDistributionData;
      mValue.mGleanDistributionData.SetValue(std::move(aOther.mValue.mGleanDistributionData.Value()));
      break;
    }
  }
}


bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToBoolean(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    bool& memberSlot = RawSetAsBoolean();
    if (!ValueToPrimitive<bool, eDefault>(cx, value, "Boolean branch of (boolean or unsigned long long or USVString or GleanDistributionData)", &memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] bool&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::RawSetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}

[[nodiscard]] bool&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::SetAsBoolean()
{
  if (mType == eBoolean) {
    return mValue.mBoolean.Value();
  }
  Uninit();
  mType = eBoolean;
  return mValue.mBoolean.SetValue();
}


void
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::DestroyBoolean()
{
  MOZ_RELEASE_ASSERT(IsBoolean(), "Wrong type!");
  mValue.mBoolean.Destroy();
  mType = eUninitialized;
}



bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToUnsignedLongLong(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    uint64_t& memberSlot = RawSetAsUnsignedLongLong();
    if (!ValueToPrimitive<uint64_t, eDefault>(cx, value, "Unsigned long long branch of (boolean or unsigned long long or USVString or GleanDistributionData)", &memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] uint64_t&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::RawSetAsUnsignedLongLong()
{
  if (mType == eUnsignedLongLong) {
    return mValue.mUnsignedLongLong.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUnsignedLongLong;
  return mValue.mUnsignedLongLong.SetValue();
}

[[nodiscard]] uint64_t&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::SetAsUnsignedLongLong()
{
  if (mType == eUnsignedLongLong) {
    return mValue.mUnsignedLongLong.Value();
  }
  Uninit();
  mType = eUnsignedLongLong;
  return mValue.mUnsignedLongLong.SetValue();
}


void
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::DestroyUnsignedLongLong()
{
  MOZ_RELEASE_ASSERT(IsUnsignedLongLong(), "Wrong type!");
  mValue.mUnsignedLongLong.Destroy();
  mType = eUninitialized;
}



bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToUTF8String(JSContext* cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    nsCString& memberSlot = RawSetAsUTF8String();
    if (!ConvertJSValueToString(cx, value, eStringify, eStringify, memberSlot)) {
      return false;
    }
  }
  return true;
}

[[nodiscard]] nsCString&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::RawSetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}

[[nodiscard]] nsCString&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::SetAsUTF8String()
{
  if (mType == eUTF8String) {
    return mValue.mUTF8String.Value();
  }
  Uninit();
  mType = eUTF8String;
  return mValue.mUTF8String.SetValue();
}



void
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::DestroyUTF8String()
{
  MOZ_RELEASE_ASSERT(IsUTF8String(), "Wrong type!");
  mValue.mUTF8String.Destroy();
  mType = eUninitialized;
}



bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToGleanDistributionData(BindingCallContext& cx, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  tryNext = false;
  { // scope for memberSlot
    GleanDistributionData& memberSlot = RawSetAsGleanDistributionData();
    if (!IsConvertibleToDictionary(value)) {
      DestroyGleanDistributionData();
      tryNext = true;
      return true;
    }
    if (!memberSlot.Init(cx, value, "GleanDistributionData branch of (boolean or unsigned long long or USVString or GleanDistributionData)", passedToJSImpl)) {
      return false;
    }
  }
  return true;
}

bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::TrySetToGleanDistributionData(JSContext* cx_, JS::Handle<JS::Value> value, bool& tryNext, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return TrySetToGleanDistributionData(cx, value, tryNext, passedToJSImpl);
}

[[nodiscard]] GleanDistributionData&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::RawSetAsGleanDistributionData()
{
  if (mType == eGleanDistributionData) {
    return mValue.mGleanDistributionData.Value();
  }
  MOZ_ASSERT(mType == eUninitialized);
  mType = eGleanDistributionData;
  return mValue.mGleanDistributionData.SetValue();
}

[[nodiscard]] GleanDistributionData&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::SetAsGleanDistributionData()
{
  if (mType == eGleanDistributionData) {
    return mValue.mGleanDistributionData.Value();
  }
  Uninit();
  mType = eGleanDistributionData;
  return mValue.mGleanDistributionData.SetValue();
}


void
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::DestroyGleanDistributionData()
{
  MOZ_RELEASE_ASSERT(IsGleanDistributionData(), "Wrong type!");
  mValue.mGleanDistributionData.Destroy();
  mType = eUninitialized;
}



bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::Init(BindingCallContext& cx, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  MOZ_ASSERT(mType == eUninitialized);

  bool done = false, failed = false, tryNext;
  if (!done) {
    done = (failed = !TrySetToGleanDistributionData(cx, value, tryNext, passedToJSImpl)) || !tryNext;
  }
  if (!done) {
    do {
      if (value.isBoolean()) {
        done = (failed = !TrySetToBoolean(cx, value, tryNext)) || !tryNext;
        break;
      }
      if (value.isNumber()) {
        done = (failed = !TrySetToUnsignedLongLong(cx, value, tryNext)) || !tryNext;
        break;
      }
      done = (failed = !TrySetToUTF8String(cx, value, tryNext)) || !tryNext;
      break;
    } while (false);
  }
  if (failed) {
    return false;
  }
  if (!done) {
    cx.ThrowErrorMessage<MSG_NOT_IN_UNION>(sourceDescription, "GleanDistributionData");
    return false;
  }
  return true;
}

bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::Init(JSContext* cx_, JS::Handle<JS::Value> value, const char* sourceDescription, bool passedToJSImpl)
{
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, value, sourceDescription, passedToJSImpl);
}

void
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::Uninit()
{
  switch (mType) {
    case eUninitialized: {
      break;
    }
    case eBoolean: {
      DestroyBoolean();
      break;
    }
    case eUnsignedLongLong: {
      DestroyUnsignedLongLong();
      break;
    }
    case eUTF8String: {
      DestroyUTF8String();
      break;
    }
    case eGleanDistributionData: {
      DestroyGleanDistributionData();
      break;
    }
  }
}

bool
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::ToJSVal(JSContext* cx, JS::Handle<JSObject*> scopeObj, JS::MutableHandle<JS::Value> rval) const
{
  switch (mType) {
    case eUninitialized: {
      return false;
    }
    case eBoolean: {
      rval.setBoolean(mValue.mBoolean.Value());
      return true;
    }
    case eUnsignedLongLong: {
      rval.set(JS_NumberValue(double(mValue.mUnsignedLongLong.Value())));
      return true;
    }
    case eUTF8String: {
      if (!NonVoidUTF8StringToJsval(cx, mValue.mUTF8String.Value(), rval)) {
        return false;
      }
      return true;
    }
    case eGleanDistributionData: {
      if (!mValue.mGleanDistributionData.Value().ToObjectInternal(cx, rval)) {
        return false;
      }
      return true;
    }
    default: {
      return false;
    }
  }
}

OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData&
OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData::operator=(OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData&& aOther)
{
  this->~OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData();
  new (this) OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData (std::move(aOther));
  return *this;
}



namespace GleanCategory_Binding {

static_assert(std::is_base_of_v<nsISupports, mozilla::glean::Category>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::glean::Category*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::glean::Category*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::GleanCategory,
  constructors::id::GleanCategory,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::GleanCategory>::Depth,
  prototypes::id::GleanCategory,
  true,
  0,
  "GleanCategory",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "GleanCategoryPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::GleanCategory,
  PrototypeTraits<prototypes::id::GleanCategory>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return GleanWebidlEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!ignoreNamedProps) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    callNamedGetter = !hasOnProto;
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Category* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!GetOrCreateDOMReflector(cx, result, &value)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::Category* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  nsTArray<nsString> names;
  UnwrapProxy(proxy)->GetSupportedNames(names);
  if (!AppendNamedPropertyIds(cx, proxy, names, false, props)) {
    return false;
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool hasOnProto;
  if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
    return false;
  }
  if (!hasOnProto) {
    bool found = false;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Category* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }

    *bp = found;
    return true;
  }
  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  bool expandoHasProp = false;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
        return false;
      }

      if (expandoHasProp) {
        // Forward the get to the expando object, but our receiver is whatever our
        // receiver is.
        if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
          return false;
        }
      }
    }
  }

  if (expandoHasProp) {
    return true;
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::Category* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
  }

  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "GleanCategory";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::glean::Category* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::glean::Category>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::glean::Category>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    tryNamedDelete = !hasOnProto;
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Category* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::glean::Category>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("GleanCategory",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::GleanCategory, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::glean::Category>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::glean::Category>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::glean::Category>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::glean::Category* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::glean::Category>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::glean::Category*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::glean::Category> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::GleanCategory);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::GleanCategory);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "GleanCategory",
                              ShouldExpose<GleanCategory_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::GleanCategory,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::GleanCategory,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace GleanCategory_Binding



namespace GleanImpl_Binding {

static_assert(std::is_base_of_v<nsISupports, mozilla::glean::Glean>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::glean::Glean*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::glean::Glean*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::GleanImpl,
  constructors::id::GleanImpl,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::GleanImpl>::Depth,
  prototypes::id::GleanImpl,
  true,
  0,
  "GleanImpl",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "GleanImplPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::GleanImpl,
  PrototypeTraits<prototypes::id::GleanImpl>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return GleanWebidlEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!ignoreNamedProps) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    callNamedGetter = !hasOnProto;
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Glean* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<mozilla::glean::Category>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!GetOrCreateDOMReflector(cx, result, &value)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::Glean* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::glean::Category>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  nsTArray<nsString> names;
  UnwrapProxy(proxy)->GetSupportedNames(names);
  if (!AppendNamedPropertyIds(cx, proxy, names, false, props)) {
    return false;
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool hasOnProto;
  if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
    return false;
  }
  if (!hasOnProto) {
    bool found = false;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Glean* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::Category>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }

    *bp = found;
    return true;
  }
  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  bool expandoHasProp = false;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
        return false;
      }

      if (expandoHasProp) {
        // Forward the get to the expando object, but our receiver is whatever our
        // receiver is.
        if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
          return false;
        }
      }
    }
  }

  if (expandoHasProp) {
    return true;
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::Glean* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::glean::Category>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
  }

  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "GleanImpl";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::glean::Glean* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::glean::Glean>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::glean::Glean>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    tryNamedDelete = !hasOnProto;
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::Glean* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::Category>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::glean::Glean>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("GleanImpl",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::GleanImpl, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::glean::Glean>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::glean::Glean>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::glean::Glean>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::glean::Glean* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::glean::Glean>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::glean::Glean*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::glean::Glean> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::GleanImpl);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::GleanImpl);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "GleanImpl",
                              ShouldExpose<GleanImpl_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::GleanImpl,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::GleanImpl,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace GleanImpl_Binding



namespace GleanLabeled_Binding {

MOZ_CAN_RUN_SCRIPT static bool
testGetValue(JSContext* cx, JS::Handle<JSObject*> obj, void* void_self, const JSJitMethodCallArgs& args)
{
  AUTO_PROFILER_LABEL_DYNAMIC_FAST(
    "GleanLabeled", "testGetValue", DOM, cx,
    uint32_t(js::ProfilingStackFrame::Flags::STRING_TEMPLATE_METHOD) |
    uint32_t(js::ProfilingStackFrame::Flags::RELEVANT_FOR_JS));

  auto* self = static_cast<mozilla::glean::GleanLabeled*>(void_self);
  binding_detail::FakeString<char> arg0;
  if (args.hasDefined(0)) {
    if (!ConvertJSValueToString(cx, args[0], eStringify, eStringify, arg0)) {
      return false;
    }
  } else {
    arg0.AssignLiteral("");
  }
  FastErrorResult rv;
  Nullable<Record<nsCString, OwningBooleanOrUnsignedLongLongOrUTF8StringOrGleanDistributionData>> result;
  // NOTE: This assert does NOT call the function.
  static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->TestGetValue(Constify(arg0), result, rv))>, "Should be returning void here");
  MOZ_KnownLive(self)->TestGetValue(Constify(arg0), result, rv);
  if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "GleanLabeled.testGetValue"))) {
    return false;
  }
  MOZ_ASSERT(!JS_IsExceptionPending(cx));

  if (result.IsNull()) {
    args.rval().setNull();
    return true;
  }

  JS::Rooted<JSObject*> returnObj(cx, JS_NewPlainObject(cx));
  if (!returnObj) {
    return false;
  }
  // Scope for 'tmp'
  {
    JS::Rooted<JS::Value> tmp(cx);
    for (auto& entry : result.Value().Entries()) {
      auto& recordValue0 = entry.mValue;
      // Control block to let us common up the JS_DefineUCProperty calls when there
      // are different ways to succeed at wrapping the value.
      do {
        if (!recordValue0.ToJSVal(cx, returnObj, &tmp)) {
          return false;
        }
        break;
      } while (false);
      NS_ConvertUTF8toUTF16 expandedKey(entry.mKey);
      if (!JS_DefineUCProperty(cx, returnObj,
                               expandedKey.BeginReading(),
                               expandedKey.Length(), tmp,
                               JSPROP_ENUMERATE)) {
        return false;
      }
    }
  }
  args.rval().setObject(*returnObj);
  return true;
}

static const JSJitInfo testGetValue_methodinfo = {
  { (JSJitGetterOp)testGetValue },
  { prototypes::id::GleanLabeled },
  { PrototypeTraits<prototypes::id::GleanLabeled>::Depth },
  JSJitInfo::Method,
  JSJitInfo::AliasEverything, /* aliasSet.  Not relevant for setters. */
  JSVAL_TYPE_UNKNOWN,  /* returnType.  Not relevant for setters. */
  false,  /* isInfallible. False in setters. */
  false,  /* isMovable.  Not relevant for setters. */
  false, /* isEliminatable.  Not relevant for setters. */
  false, /* isAlwaysInSlot.  Only relevant for getters. */
  false, /* isLazilyCachedInSlot.  Only relevant for getters. */
  false,  /* isTypedMethod.  Only relevant for methods. */
  0   /* Reserved slot index, if we're stored in a slot, else 0. */
};

MOZ_GLOBINIT static const JSFunctionSpec sChromeMethods_specs[] = {
  JS_FNSPEC("testGetValue", (GenericMethod<NormalThisPolicy, ThrowExceptions>), reinterpret_cast<const JSJitInfo*>(&testGetValue_methodinfo), 0, JSPROP_ENUMERATE, nullptr),
  JS_FS_END
};


static const Prefable<const JSFunctionSpec> sChromeMethods[] = {
  { nullptr, &sChromeMethods_specs[0] },
  { nullptr, nullptr }
};

static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_PREF_INDEX,
    "We have a prefable index that is >= (1 << NUM_BITS_PROPERTY_INFO_PREF_INDEX)");
static_assert(1 <= 1ull << NUM_BITS_PROPERTY_INFO_SPEC_INDEX,
    "We have a spec index that is >= (1 << NUM_BITS_PROPERTY_INFO_SPEC_INDEX)");


static uint16_t sChromeOnlyNativeProperties_sortedPropertyIndices[1];
static PropertyInfo sChromeOnlyNativeProperties_propertyInfos[1];

static const NativePropertiesN<1> sChromeOnlyNativeProperties = {
  false, 0,
  false, 0,
  true,  0 /* sChromeMethods */,
  false, 0,
  false, 0,
  false, 0,
  false, 0,
  -1,
  1,
  sChromeOnlyNativeProperties_sortedPropertyIndices,
  {
    { sChromeMethods, &sChromeOnlyNativeProperties_propertyInfos[0] }
  }
};
static_assert(1 < 1ull << (CHAR_BIT * sizeof(sChromeOnlyNativeProperties.propertyInfoCount)),
    "We have a property info count that is oversized");

static_assert(std::is_base_of_v<nsISupports, mozilla::glean::GleanLabeled>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public mozilla::dom::DOMProxyHandler
{
public:
  using Base = mozilla::dom::DOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE mozilla::glean::GleanLabeled*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<mozilla::glean::GleanLabeled*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  nullptr
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { nullptr, sChromeOnlyNativeProperties.Upcast(), &sNativePropertiesInited },
  prototypes::id::GleanLabeled,
  constructors::id::GleanLabeled,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::GleanLabeled>::Depth,
  prototypes::id::GleanLabeled,
  true,
  0,
  "GleanLabeled",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "GleanLabeledPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::GleanLabeled,
  PrototypeTraits<prototypes::id::GleanLabeled>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

bool
ConstructorEnabled(JSContext* aCx, JS::Handle<JSObject*> aObj)
{
  return GleanWebidlEnabled(aCx, aObj);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!ignoreNamedProps) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    callNamedGetter = !hasOnProto;
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::GleanLabeled* self = UnwrapProxy(proxy);
      bool found = false;
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!GetOrCreateDOMReflector(cx, result, &value)) {
          MOZ_ASSERT(JS_IsExceptionPending(cx));
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  JSContext* cx = cx_;
  bool found = false;
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::GleanLabeled* self = UnwrapProxy(proxy);
    auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  if (found) {
    *done = true;
    return opresult.failNoNamedSetter();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  nsTArray<nsString> names;
  UnwrapProxy(proxy)->GetSupportedNames(names);
  if (!AppendNamedPropertyIds(cx, proxy, names, false, props)) {
    return false;
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool hasOnProto;
  if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
    return false;
  }
  if (!hasOnProto) {
    bool found = false;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::GleanLabeled* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }

    *bp = found;
    return true;
  }
  *bp = false;
  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  bool expandoHasProp = false;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
        return false;
      }

      if (expandoHasProp) {
        // Forward the get to the expando object, but our receiver is whatever our
        // receiver is.
        if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
          return false;
        }
      }
    }
  }

  if (expandoHasProp) {
    return true;
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  FakeString<char16_t> identifier;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    mozilla::glean::GleanLabeled* self = UnwrapProxy(proxy);
    bool found = false;
    auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!GetOrCreateDOMReflector(cx, result, vp)) {
        MOZ_ASSERT(JS_IsExceptionPending(cx));
        return false;
      }
      return true;
    }
  }

  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "GleanLabeled";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  mozilla::glean::GleanLabeled* self = UnwrapPossiblyNotInitializedDOMObject<mozilla::glean::GleanLabeled>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<mozilla::glean::GleanLabeled>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool hasOnProto;
    if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
      return false;
    }
    tryNamedDelete = !hasOnProto;
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> identifier;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, identifier, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      mozilla::glean::GleanLabeled* self = UnwrapProxy(proxy);
      auto result(StrongOrRawPtr<mozilla::glean::GleanMetric>(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(identifier)), found)));
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
      (void)result;
    }
    deleteSucceeded = !found;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<mozilla::glean::GleanLabeled>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("GleanLabeled",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::GleanLabeled, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, mozilla::glean::GleanLabeled>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<mozilla::glean::GleanLabeled>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<mozilla::glean::GleanLabeled>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, mozilla::glean::GleanLabeled* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, mozilla::glean::GleanLabeled>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), mozilla::glean::GleanLabeled*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<mozilla::glean::GleanLabeled> creator(aCx);
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false,
                            aObject, JS::UndefinedHandleValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::GleanLabeled);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::GleanLabeled);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              sChromeOnlyNativeProperties.Upcast(),
                              "GleanLabeled",
                              ShouldExpose<GleanLabeled_Binding::ConstructorEnabled>(aCx, aGlobal, aDefineOnGlobal),
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::GleanLabeled,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::GleanLabeled,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace GleanLabeled_Binding



} // namespace mozilla::dom
