/* THIS FILE IS AUTOGENERATED FROM DOMStringMap.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "DOMStringMapBinding.h"
#include "MainThreadUtils.h"
#include "WrapperFactory.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "mozilla/Atomics.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/CustomElementRegistry.h"
#include "mozilla/dom/DOMJSClass.h"
#include "mozilla/dom/DOMJSProxyHandler.h"
#include "mozilla/dom/DocGroup.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/ProxyHandlerUtils.h"
#include "mozilla/dom/XrayExpandoClass.h"
#include "nsDOMStringMap.h"

namespace mozilla::dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace DOMStringMap_Binding {

static_assert(std::is_base_of_v<nsISupports, nsDOMStringMap>,
              "We don't support non-nsISupports native classes for "
              "proxy-based bindings yet");


class DOMProxyHandler : public ShadowingDOMProxyHandler
{
public:
  using Base = ShadowingDOMProxyHandler;

  explicit constexpr DOMProxyHandler()
  {
  }

  bool
  getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const override;

  bool
  defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const override;

  using mozilla::dom::DOMProxyHandler::defineProperty;

  bool
  ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const override;

  bool
  hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const override;

  bool
  get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const override;

  const char*
  className(JSContext* cx, JS::Handle<JSObject*> proxy) const override;

  bool
  finalizeInBackground(const JS::Value& priv) const override;

  void
  finalize(JS::GCContext* gcx, JSObject* proxy) const override;

  static const DOMProxyHandler*
  getInstance();

  bool
  delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const override;

  bool
  setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const override;

  size_t
  objectMoved(JSObject* obj, JSObject* old) const override;
};

MOZ_ALWAYS_INLINE bool
IsProxy(JSObject* obj)
{
  return js::IsProxy(obj) && js::GetProxyHandler(obj) == DOMProxyHandler::getInstance();
}

MOZ_ALWAYS_INLINE nsDOMStringMap*
UnwrapProxy(JSObject* obj)
{
  MOZ_ASSERT(js::IsProxy(obj));
  if (js::GetProxyHandler(obj) != DOMProxyHandler::getInstance()) {
    MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(obj));
    obj = js::UncheckedUnwrap(obj);
  }
  MOZ_ASSERT(IsProxy(obj));
  return static_cast<nsDOMStringMap*>(js::GetProxyReservedSlot(obj, DOM_OBJECT_SLOT).toPrivate());
}

static bool
DeleteNamedProperty(JSContext* cx, JS::Handle<JSObject*> xray, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult)
{
  MOZ_ASSERT(xpc::WrapperFactory::IsXrayWrapper(xray));
  MOZ_ASSERT(js::IsProxy(proxy));
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy));
  JSAutoRealm ar(cx, proxy);
  bool deleteSucceeded = false;
  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsDOMStringMap* self = UnwrapProxy(proxy);
    Maybe<AutoCEReaction> ceReaction;
    DocGroup* docGroup = self->GetDocGroup();
    if (docGroup) {
      ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
    }
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedDeleter(NonNullHelper(Constify(name)), found))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedDeleter(NonNullHelper(Constify(name)), found);
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
  }
  deleteSucceeded = true;
  if (!found || deleteSucceeded) {
    return opresult.succeed();
  }
  return opresult.failCantDelete();
}

const NativeNamedOrIndexedPropertyHooks sNativeNamedOrIndexedPropertyHooks = {
  binding_detail::ResolveOwnProperty,
  binding_detail::EnumerateOwnProperties,
  DeleteNamedProperty
};
bool sNativePropertiesInited = false;
const NativePropertyHooks sNativePropertyHooks = {
  &sNativeNamedOrIndexedPropertyHooks,
  { nullptr, nullptr, &sNativePropertiesInited },
  prototypes::id::DOMStringMap,
  constructors::id::DOMStringMap,
  &DefaultXrayExpandoObjectClass
};

static const DOMInterfaceInfo sInterfaceObjectInfo = {
  { ThrowingConstructor, &sNativePropertyHooks },
  JS::GetRealmFunctionPrototypeHandle,
  PrototypeTraits<prototypes::id::DOMStringMap>::Depth,
  prototypes::id::DOMStringMap,
  true,
  0,
  "DOMStringMap",
};

static const DOMIfaceAndProtoJSClass sPrototypeClass = {
  {
    "DOMStringMapPrototype",
    JSCLASS_IS_DOMIFACEANDPROTOJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(DOM_INTERFACE_PROTO_SLOTS_BASE),
    JS_NULL_CLASS_OPS,
    JS_NULL_CLASS_SPEC,
    JS_NULL_CLASS_EXT,
    JS_NULL_OBJECT_OPS
  },
  eInterfacePrototype,
  prototypes::id::DOMStringMap,
  PrototypeTraits<prototypes::id::DOMStringMap>::Depth,
  &sNativePropertyHooks,
  JS::GetRealmObjectPrototype
};

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx);

bool
DOMProxyHandler::getOwnPropDescriptor(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool ignoreNamedProps, JS::MutableHandle<Maybe<JS::PropertyDescriptor>> desc) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);
  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = GetExpandoObject(proxy))) {
    if (!JS_GetOwnPropertyDescriptorById(cx, expando, id, desc)) {
      return false;
    }
    if (desc.isSome()) {
      return true;
    }
  }

  bool callNamedGetter = false;
  if (!ignoreNamedProps) {
    if (!isXray) {
      callNamedGetter = true;
    } else {
      bool hasOnProto;
      if (!HasPropertyOnPrototype(cx, proxy, id, &hasOnProto)) {
        return false;
      }
      callNamedGetter = !hasOnProto;
    }
  }
  if (callNamedGetter) {
    JS::Rooted<JS::Value> value(cx);
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      nsDOMStringMap* self = UnwrapProxy(proxy);
      bool found = false;
      DOMString result;
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));

      if (found) {
        if (!xpc::NonVoidStringToJsval(cx, result, &value)) {
          return false;
        }
        desc.set(mozilla::Some(JS::PropertyDescriptor::Data(value, { JS::PropertyAttribute::Configurable, JS::PropertyAttribute::Enumerable, JS::PropertyAttribute::Writable })));
        return true;
      }
    }
  }

  desc.reset();
  return true;
}

bool
DOMProxyHandler::defineProperty(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::PropertyDescriptor> desc, JS::ObjectOpResult& opresult, bool* done) const
{
  JSContext* cx = cx_;
  // https://webidl.spec.whatwg.org/#legacy-platform-object-defineownproperty
  // Step 2.2.2.1.
  if (!desc.isDataDescriptor()) {
    *done = true;
    return opresult.failNotDataDescriptor();
  }
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsDOMStringMap* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, desc.value());
    binding_detail::FakeString<char16_t> value;
    if (!ConvertJSValueToString(cx, desc.value(), eStringify, eStringify, value)) {
      return false;
    }
    Maybe<AutoCEReaction> ceReaction;
    DocGroup* docGroup = self->GetDocGroup();
    if (docGroup) {
      ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedSetter(NonNullHelper(Constify(name)), NonNullHelper(Constify(value)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedSetter(NonNullHelper(Constify(name)), NonNullHelper(Constify(value)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMStringMap named setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    *done = true;
    return opresult.succeed();
  }
  return mozilla::dom::DOMProxyHandler::defineProperty(cx_, proxy, id, desc, opresult, done);
}


bool
DOMProxyHandler::ownPropNames(JSContext* cx, JS::Handle<JSObject*> proxy, unsigned flags, JS::MutableHandleVector<jsid> props) const
{
  bool isXray = xpc::WrapperFactory::IsXrayWrapper(proxy);

  nsTArray<nsString> names;
  UnwrapProxy(proxy)->GetSupportedNames(names);
  if (!AppendNamedPropertyIds(cx, proxy, names, !isXray, props)) {
    return false;
  }

  JS::Rooted<JSObject*> expando(cx);
  if (!isXray &&(expando = DOMProxyHandler::GetExpandoObject(proxy)) &&
      !js::GetPropertyKeys(cx, expando, flags, props)) {
    return false;
  }

  return true;
}

bool
DOMProxyHandler::hasOwn(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, bool* bp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  JS::Rooted<JSObject*> expando(cx, GetExpandoObject(proxy));
  if (expando) {
    bool b = true;
    bool ok = JS_HasPropertyById(cx, expando, id, &b);
    *bp = !!b;
    if (!ok || *bp) {
      return ok;
    }
  }

  bool found = false;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsDOMStringMap* self = UnwrapProxy(proxy);
    DOMString result;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    (void)result;
  }

  *bp = found;

  return true;
}

bool
DOMProxyHandler::get(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<JS::Value> receiver, JS::Handle<jsid> id, JS::MutableHandle<JS::Value> vp) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
              "Should not have a XrayWrapper here");

  bool expandoHasProp = false;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      if (!JS_HasPropertyById(cx, expando, id, &expandoHasProp)) {
        return false;
      }

      if (expandoHasProp) {
        // Forward the get to the expando object, but our receiver is whatever our
        // receiver is.
        if (!JS_ForwardGetPropertyTo(cx, expando, id, receiver, vp)) {
          return false;
        }
      }
    }
  }

  if (expandoHasProp) {
    return true;
  }

  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsDOMStringMap* self = UnwrapProxy(proxy);
    bool found = false;
    DOMString result;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedGetter(NonNullHelper(Constify(name)), found, result);
    MOZ_ASSERT(!JS_IsExceptionPending(cx));

    if (found) {
      if (!xpc::NonVoidStringToJsval(cx, result, vp)) {
        return false;
      }
      return true;
    }
  }

  bool foundOnPrototype;
  if (!GetPropertyOnPrototype(cx, proxy, receiver, id, &foundOnPrototype, vp)) {
    return false;
  }

  if (foundOnPrototype) {
    return true;
  }

  MOZ_ASSERT(vp.isUndefined());
  return true;
}

const char*
DOMProxyHandler::className(JSContext* cx, JS::Handle<JSObject*> proxy) const
{
  return "DOMStringMap";
}

bool
DOMProxyHandler::finalizeInBackground(const JS::Value& priv) const
{
  return false;
}

void
DOMProxyHandler::finalize(JS::GCContext* gcx, JSObject* proxy) const
{
  nsDOMStringMap* self = UnwrapPossiblyNotInitializedDOMObject<nsDOMStringMap>(proxy);
  if (self) {
    JS::SetReservedSlot(proxy, DOM_OBJECT_SLOT, JS::UndefinedValue());
    // Either our proxy created an expando object or not.  If it did,
    // then we would have preserved ourselves, and hence if we're going
    // away so is our C++ object and we should reset its expando value.
    // It's possible that in this situation the C++ object's reflector
    // pointer has been nulled out, but if not it's pointing to us.  If
    // our proxy did _not_ create an expando object then it's possible
    // that we're no longer the reflector for our C++ object (and
    // incremental finalization is finally getting to us), and that in
    // the meantime the new reflector has created an expando object.
    // In that case we do NOT want to clear the expando pointer in the
    // C++ object.
    //
    // It's important to do this before we ClearWrapper, of course.
    JSObject* reflector = self->GetWrapperMaybeDead();
    if (!reflector || reflector == proxy) {
      self->mExpandoAndGeneration.expando = JS::UndefinedValue();
    }
    ClearWrapper(self, self, proxy);
    if (size_t mallocBytes = BindingJSObjectMallocBytes(self)) {
      JS::RemoveAssociatedMemory(proxy, mallocBytes,
                                 JS::MemoryUse::DOMBinding);
    }
    AddForDeferredFinalization<nsDOMStringMap>(self);
  }
}

const DOMProxyHandler*
DOMProxyHandler::getInstance()
{
  static const DOMProxyHandler instance;
  return &instance;
}

bool
DOMProxyHandler::delete_(JSContext* cx, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::ObjectOpResult& opresult) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
            "Should not have a XrayWrapper here");

  // Try named delete only if the named property visibility
  // algorithm says the property is visible.
  bool tryNamedDelete = true;
  { // Scope for expando
    JS::Rooted<JSObject*> expando(cx, DOMProxyHandler::GetExpandoObject(proxy));
    if (expando) {
      bool hasProp;
      if (!JS_HasPropertyById(cx, expando, id, &hasProp)) {
        return false;
      }
      tryNamedDelete = !hasProp;
    }
  }
  if (tryNamedDelete) {
    bool found = false;
    bool deleteSucceeded;
    FakeString<char16_t> name;
    bool isSymbol;
    if (!ConvertIdToString(cx, id, name, isSymbol)) {
      return false;
    }
    if (!isSymbol) {
      nsDOMStringMap* self = UnwrapProxy(proxy);
      Maybe<AutoCEReaction> ceReaction;
      DocGroup* docGroup = self->GetDocGroup();
      if (docGroup) {
        ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
      }
      // NOTE: This assert does NOT call the function.
      static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedDeleter(NonNullHelper(Constify(name)), found))>, "Should be returning void here");
      MOZ_KnownLive(self)->NamedDeleter(NonNullHelper(Constify(name)), found);
      MOZ_ASSERT(!JS_IsExceptionPending(cx));
    }
    deleteSucceeded = true;
    if (found) {
      return deleteSucceeded ? opresult.succeed() : opresult.failCantDelete();
    }
  }

  return dom::DOMProxyHandler::delete_(cx, proxy, id, opresult);
}

bool
DOMProxyHandler::setCustom(JSContext* cx_, JS::Handle<JSObject*> proxy, JS::Handle<jsid> id, JS::Handle<JS::Value> v, bool* done) const
{
  MOZ_ASSERT(!xpc::WrapperFactory::IsXrayWrapper(proxy),
             "Should not have a XrayWrapper here");
  JSContext* cx = cx_;
  FakeString<char16_t> name;
  bool isSymbol;
  if (!ConvertIdToString(cx, id, name, isSymbol)) {
    return false;
  }
  if (!isSymbol) {
    nsDOMStringMap* self = UnwrapProxy(proxy);
    JS::Rooted<JS::Value> rootedValue(cx, v);
    binding_detail::FakeString<char16_t> value;
    if (!ConvertJSValueToString(cx, v, eStringify, eStringify, value)) {
      return false;
    }
    Maybe<AutoCEReaction> ceReaction;
    DocGroup* docGroup = self->GetDocGroup();
    if (docGroup) {
      ceReaction.emplace(docGroup->CustomElementReactionsStack(), cx);
    }
    FastErrorResult rv;
    // NOTE: This assert does NOT call the function.
    static_assert(std::is_void_v<decltype(MOZ_KnownLive(self)->NamedSetter(NonNullHelper(Constify(name)), NonNullHelper(Constify(value)), rv))>, "Should be returning void here");
    MOZ_KnownLive(self)->NamedSetter(NonNullHelper(Constify(name)), NonNullHelper(Constify(value)), rv);
    if (MOZ_UNLIKELY(rv.MaybeSetPendingException(cx, "DOMStringMap named setter"))) {
      return false;
    }
    MOZ_ASSERT(!JS_IsExceptionPending(cx));
    *done = true;
    return true;
  }
  *done = false;
  return true;
}

size_t
DOMProxyHandler::objectMoved(JSObject* obj, JSObject* old) const
{
  return NativeTypeHelpers<nsDOMStringMap>::ObjectMoved(obj, old);
}

static const DOMJSClass sClass = {
  PROXY_CLASS_DEF("DOMStringMap",
                  JSCLASS_IS_DOMJSCLASS | JSCLASS_HAS_RESERVED_SLOTS(1)),
  { prototypes::id::DOMStringMap, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count, prototypes::id::_ID_Count },
  std::is_base_of_v<nsISupports, nsDOMStringMap>,
  &sNativePropertyHooks,
  FindAssociatedGlobalForNative<nsDOMStringMap>::Get,
  GetProtoObjectHandle,
  GetCCParticipant<nsDOMStringMap>::Get(),
  nullptr,
  nullptr
};

bool
Wrap(JSContext* aCx, nsDOMStringMap* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector)
{
  static_assert(!std::is_base_of_v<NonRefcountedDOMObject, nsDOMStringMap>,
                "Shouldn't have wrappercached things that are not refcounted.");
  static_assert(std::is_same_v<decltype(aObject), nsDOMStringMap*>);
  MOZ_ASSERT(ToSupportsIsCorrect(aObject));
  MOZ_ASSERT_IF(aGivenProto, js::IsObjectInContextCompartment(aGivenProto, aCx));
  MOZ_ASSERT(!aCache->GetWrapper(),
             "You should probably not be using Wrap() directly; use "
             "GetOrCreateDOMReflector instead");

  MOZ_ASSERT(ToSupportsIsOnPrimaryInheritanceChain(aObject, aCache),
             "nsISupports must be on our primary inheritance chain");

  // If the wrapper cache contains a dead reflector then finalize that
  // now, ensuring that the finalizer for the old reflector always
  // runs before the new reflector is created and attached. This
  // avoids the awkward situation where there are multiple reflector
  // objects that contain pointers to the same native.

  if (JSObject* oldReflector = aCache->GetWrapperMaybeDead()) {
    DOMProxyHandler::getInstance()->finalize(nullptr /* unused */, oldReflector);
    MOZ_ASSERT(!aCache->GetWrapperMaybeDead());
  }

  JS::Rooted<JSObject*> global(aCx, FindAssociatedGlobal(aCx, aObject->GetParentObject()));
  if (!global) {
    return false;
  }
  MOZ_ASSERT(JS_IsGlobalObject(global));
  JS::AssertObjectIsNotGray(global);

  // That might have ended up wrapping us already, due to the wonders
  // of XBL.  Check for that, and bail out as needed.
  aReflector.set(aCache->GetWrapper());
  if (aReflector) {
#ifdef DEBUG
    AssertReflectorHasGivenProto(aCx, aReflector, aGivenProto);
#endif // DEBUG
    return true;
  }

  JSAutoRealm ar(aCx, global);
  JS::Handle<JSObject*> canonicalProto = GetProtoObjectHandle(aCx);
  if (!canonicalProto) {
    return false;
  }
  JS::Rooted<JSObject*> proto(aCx);
  if (aGivenProto) {
    proto = aGivenProto;
    // Unfortunately, while aGivenProto was in the compartment of aCx
    // coming in, we changed compartments to that of "parent" so may need
    // to wrap the proto here.
    if (js::GetContextCompartment(aCx) != JS::GetCompartment(proto)) {
      if (!JS_WrapObject(aCx, &proto)) {
        return false;
      }
    }
  } else {
    proto = canonicalProto;
  }

  BindingJSObjectCreator<nsDOMStringMap> creator(aCx);
  aObject->mExpandoAndGeneration.expando.setUndefined();
  JS::Rooted<JS::Value> expandoValue(aCx, JS::PrivateValue(&aObject->mExpandoAndGeneration));
  creator.CreateProxyObject(aCx, &sClass.mBase, DOMProxyHandler::getInstance(),
                            proto, /* aLazyProto = */ false, aObject,
                            expandoValue, aReflector);
  if (!aReflector) {
    return false;
  }

  aCache->SetWrapper(aReflector);
  creator.InitializationSucceeded();

  MOZ_ASSERT(aCache->GetWrapperPreserveColor() &&
             aCache->GetWrapperPreserveColor() == aReflector);
  // If proto != canonicalProto, we have to preserve our wrapper;
  // otherwise we won't be able to properly recreate it later, since
  // we won't know what proto to use.  Note that we don't check
  // aGivenProto here, since it's entirely possible (and even
  // somewhat common) to have a non-null aGivenProto which is the
  // same as canonicalProto.
  if (proto != canonicalProto) {
    PreserveWrapper(aObject);
  }

  return true;
}

void
CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal)
{
  JS::Heap<JSObject*>* protoCache = &aProtoAndIfaceCache.EntrySlotOrCreate(prototypes::id::DOMStringMap);
  JS::Heap<JSObject*>* interfaceCache = &aProtoAndIfaceCache.EntrySlotOrCreate(constructors::id::DOMStringMap);

  JS::Handle<JSObject*> parentProto(JS::GetRealmObjectPrototypeHandle(aCx));
  if (!parentProto) {
    return;
  }

  JS::Handle<JSObject*> constructorProto(JS::GetRealmFunctionPrototypeHandle(aCx));
  if (!constructorProto) {
    return;
  }

  dom::CreateInterfaceObjects(aCx, aGlobal, parentProto,
                              &sPrototypeClass, protoCache,
                              constructorProto, &sInterfaceObjectInfo, 0, false, Span<const LegacyFactoryFunction, 0>{},
                              interfaceCache,
                              nullptr,
                              nullptr,
                              "DOMStringMap",
                              aDefineOnGlobal != DefineInterfaceProperty::No,
                              nullptr,
                              false,
                              nullptr);
}

static JS::Handle<JSObject*>
GetProtoObjectHandle(JSContext* aCx)
{
  /* Get the interface prototype object for this class.  This will create the
     object as needed. */
  return GetPerInterfaceObjectHandle(aCx, prototypes::id::DOMStringMap,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);

}

JS::Handle<JSObject*>
GetConstructorObjectHandle(JSContext* aCx)
{
  /* Get the interface object for this class.  This will create the object as
     needed. */

  return GetPerInterfaceObjectHandle(aCx, constructors::id::DOMStringMap,
                                     &CreateInterfaceObjects,
                                     DefineInterfaceProperty::CheckExposure);
}

} // namespace DOMStringMap_Binding



} // namespace mozilla::dom
