/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/*
 * Derived from the Unicode Character Database by genUnicodePropertyData.pl
 *
 * For Unicode terms of use, see http://www.unicode.org/terms_of_use.html
 */

/*
 * Created on Mon Nov 24 15:06:20 2025 from UCD data files with version info:
 *

# Unicode Character Database
# Date: 2025-08-15
# © 2025 Unicode®, Inc.
# Unicode and the Unicode Logo are registered trademarks of Unicode, Inc. in the U.S. and other countries.
# For terms of use and license, see https://www.unicode.org/terms_of_use.html
#
# For documentation, see the following:
# NamesList.html
# UAX #38, "Unicode Han Database (Unihan)"
# UAX #42, "Unicode Character Database in XML"
# UAX #44, "Unicode Character Database"
# UTS #51, "Unicode Emoji"
# UAX #57, "Unicode Egyptian Hieroglyph Database"
#
# The UAXes and UTS #51 can be accessed at https://www.unicode.org/versions/Unicode17.0.0/

This directory contains final data files
for the Unicode Character Database, for Version 17.0.0 of the Unicode Standard.

# IdentifierStatus.txt
# Date: 2025-08-01, 18:11:48 GMT

# Unihan_Variants.txt
# Date: 2025-07-24 00:00:00 GMT [KL]

 *
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */

#include <stdint.h>
#include "harfbuzz/hb.h"

#define kCharProp2MaxPlane  16
#define kCharProp2IndexBits 11
#define kCharProp2CharBits  5
static const uint8_t sCharProp2Planes[16] = {1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3};

static const uint16_t sCharProp2Pages[4][2048] = {
  {0,1,2,3,0,4,5,5,6,7,8,9,10,11,12,13,14,0,15,16,17,18,0,0,19,20,0,0,21,22,23,0,24,25,26,0,27,28,29,30,0,31,32,33,34,0,35,36,0,37,38,39,40,41,42,43,0,0,44,45,25,46,0,0,0,0,0,0,47,48,49,0,50,51,52,53,54,55,56,57,58,59,60,61,62,63,64,65,54,66,67,68,69,70,71,0,72,73,74,0,72,73,75,65,72,76,77,78,79,80,81,82,33,83,84,0,85,86,87,0,88,89,90,91,92,93,0,0,25,25,94,95,96,0,97,98,0,0,0,0,0,0,0,0,99,25,100,25,101,102,103,104,102,25,105,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,106,107,108,89,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,35,109,0,0,0,0,0,0,0,0,0,0,110,111,112,113,114,25,25,115,0,0,0,0,0,116,0,117,118,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,120,0,33,25,121,25,25,122,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,123,0,0,0,124,0,0,0,4,125,126,127,128,129,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,131,0,0,132,133,130,0,134,135,0,0,0,0,0,136,127,0,0,137,0,0,0,0,0,127,0,0,0,138,0,0,0,0,0,0,0,139,0,0,0,140,0,0,141,0,0,0,0,0,0,0,0,0,0,0,142,143,0,144,145,0,0,4,145,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,146,147,0,0,0,137,0,0,0,142,148,0,0,0,0,0,0,0,0,149,0,117,150,0,0,0,0,0,151,0,152,153,0,0,140,0,0,0,0,154,0,0,0,0,0,119,155,156,157,0,0,82,0,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,0,0,158,159,160,0,0,161,0,0,0,0,127,0,0,162,163,25,164,165,166,167,168,169,170,171,172,173,174,175,176,177,178,179,180,181,182,183,184,185,186,187,188,189,190,191,192,25,25,193,194,195,25,196,197,198,199,200,201,33,202,203,204,205,22,206,163,207,208,25,165,209,25,99,205,25,25,25,210,211,212,213,214,215,216,217,218,219,220,221,222,223,224,225,25,226,25,227,228,208,229,230,231,232,233,234,25,25,5,25,99,25,235,236,237,238,239,193,240,201,241,242,243,244,245,246,25,247,248,216,25,249,236,250,208,25,251,252,33,253,254,255,165,162,25,256,25,162,216,33,257,258,259,25,25,260,261,262,263,25,264,165,265,266,249,267,268,269,270,25,271,272,234,273,274,249,275,5,25,276,25,277,207,278,279,185,25,280,25,172,25,25,109,281,277,282,283,284,285,286,224,287,288,289,290,291,292,5,293,294,295,296,297,298,299,300,301,25,99,302,303,304,241,305,306,307,216,275,308,309,310,163,277,311,25,122,22,312,25,166,313,314,315,316,317,318,163,319,320,321,322,25,323,25,324,314,325,249,173,25,33,323,326,327,328,25,172,329,330,25,331,332,207,167,333,334,25,185,264,335,25,336,241,337,5,338,250,339,25,340,341,342,343,208,277,224,344,5,345,346,347,348,349,350,351,352,25,25,353,25,25,354,224,193,25,180,25,355,356,323,357,358,185,359,25,360,239,25,33,361,362,249,363,180,258,25,167,364,193,311,365,366,239,367,368,22,328,165,369,370,371,25,372,373,165,224,25,374,375,376,377,241,378,379,380,381,25,382,383,25,384,385,386,387,388,204,389,390,25,25,391,25,216,185,392,393,165,394,167,395,396,25,397,398,399,400,401,402,403,323,25,185,328,288,25,25,25,25,109,404,25,405,326,406,328,207,407,33,282,408,409,122,25,410,6,25,25,411,25,239,412,193,328,355,249,167,162,25,327,413,177,208,25,25,277,25,414,415,25,323,25,416,5,264,311,417,418,419,122,193,420,167,421,422,5,5,208,423,424,208,425,288,426,249,172,427,25,216,177,428,429,430,216,25,25,25,431,432,328,25,433,434,435,25,436,437,438,239,439,440,441,177,167,25,442,25,443,444,25,25,25,25,323,445,446,447,282,448,363,449,25,25,180,25,282,33,249,450,162,451,452,185,453,454,177,299,429,355,25,288,455,456,99,25,457,424,25,25,239,458,165,207,459,241,185,460,461,328,462,463,22,264,464,465,288,466,22,180,467,25,468,469,470,25,471,472,328,473,474,25,25,25,25,25,25,25,475,476,477,478,25,25,479,480,481,482,483,25,484,485,486,487,416,488,489,490,180,122,491,492,493,25,5,207,494,241,185,495,25,25,122,25,496,497,185,498,264,25,499,500,501,502,503,504,505,506,25,22,165,507,25,508,509,25,25,25,25,510,511,25,311,208,512,33,314,513,25,25,185,514,515,25,516,517,282,518,311,25,519,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,153,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,144,0,0,0,0,0,0,0,0,0,0,0,0,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,25,160,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,520,152,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,521,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,127,68,0,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,130,142,0,522,0,523,0,0,524,0,0,0,0,525,0,0,4,526,154,4,527,0,528,117,0,0,529,0,148,0,0,152,530,0,0,531,0,0,0,0,0,0,0,136,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,119,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,523,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,523,0,0,0,137,0,0,0,148,0,0,0,532,0,0,0,154,0,533,0,117,119,0,0,0,0,0,0,0,0,0,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,123,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,148,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,88,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,117,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,534,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,125,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,526,0,0,0,0,0,119,0,0,0,0,0,0,154,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,535,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,130,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0},
  {0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0}
};

static const nsCharProps2 sCharProp2Values[536][32] = {
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{0},{0},{0},{0},{1},{0},{0},{1},{1},{0},{0},{0},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0},{0},{0},{1},{0},{0}},
  {{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{1},{1},{1},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{1},{1},{0},{1},{1},{0},{1},{0},{1},{0},{0},{0},{0}},
  {{0},{0},{0},{1},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{1},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0}},
  {{0},{0},{0},{1},{0},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{0},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{0},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{1},{0},{1},{0},{1},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1}},
  {{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{0},{1},{1},{0},{0},{1},{1},{1},{0},{1},{0},{0},{0},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{0},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{0},{1},{1},{1},{1},{0},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{0},{1},{1},{0},{0},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{1},{0},{0},{1},{1},{0},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{0},{0},{0},{0},{1},{1},{0},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{0},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1},{0},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{0},{0},{0},{1},{1},{0},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{0},{1},{1},{0},{1},{0},{1},{1}},
  {{0},{0},{0},{1},{1},{0},{0},{0},{1},{1},{1},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1}},
  {{1},{1},{1},{0},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{1},{0},{1},{0},{0},{1},{1},{0},{1},{0},{0},{1},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{0},{1},{0},{0},{1},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{0}},
  {{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{1},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{0},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{1},{1},{1},{1}},
  {{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0}},
  {{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0}},
  {{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{1},{0},{0}},
  {{0},{0},{1},{1},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{0},{0}},
  {{0},{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{0},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{0},{1},{0},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{0},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0}},
  {{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{0},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{0},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1}},
  {{1},{0},{1},{0},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0}},
  {{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{0},{0}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{0}},
  {{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{0},{1},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{0},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{0},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{1},{1},{0},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{0},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1}},
  {{0},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{0},{1}},
  {{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{0},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1}},
  {{1},{0},{1},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{1},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{1},{1},{1},{1},{1},{1},{1},{0},{1},{1},{1},{1},{0},{1},{1},{0},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{1},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{1}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{1},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0}},
  {{0},{1},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0}},
  {{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{1},{0},{0},{1},{0},{0},{0},{0},{1},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0},{0}}
};
#define kFullWidthMaxPlane  0
#define kFullWidthIndexBits 10
#define kFullWidthCharBits  6
static const uint8_t sFullWidthPages[1024] = {
  0,1,2,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,4,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,5,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,3,6,7,8
};

static const uint16_t sFullWidthValues[9][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3000,0xff01,0xff02,0xff03,0xff04,0xff05,0xff06,0xff07,0xff08,0xff09,0xff0a,0xff0b,0xff0c,0xff0d,0xff0e,0xff0f,0xff10,0xff11,0xff12,0xff13,0xff14,0xff15,0xff16,0xff17,0xff18,0xff19,0xff1a,0xff1b,0xff1c,0xff1d,0xff1e,0xff1f},
  {0xff20,0xff21,0xff22,0xff23,0xff24,0xff25,0xff26,0xff27,0xff28,0xff29,0xff2a,0xff2b,0xff2c,0xff2d,0xff2e,0xff2f,0xff30,0xff31,0xff32,0xff33,0xff34,0xff35,0xff36,0xff37,0xff38,0xff39,0xff3a,0xff3b,0xff3c,0xff3d,0xff3e,0xff3f,0xff40,0xff41,0xff42,0xff43,0xff44,0xff45,0xff46,0xff47,0xff48,0xff49,0xff4a,0xff4b,0xff4c,0xff4d,0xff4e,0xff4f,0xff50,0xff51,0xff52,0xff53,0xff54,0xff55,0xff56,0xff57,0xff58,0xff59,0xff5a,0xff5b,0xff5c,0xff5d,0xff5e,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe0,0xffe1,0x0000,0xffe5,0xffe4,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe2,0x0000,0x0000,0xffe3,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe6,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0xff5f,0xff60,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x3002,0x300c,0x300d,0x3001,0x30fb,0x30f2,0x30a1,0x30a3,0x30a5,0x30a7,0x30a9,0x30e3,0x30e5,0x30e7,0x30c3,0x30fc,0x30a2,0x30a4,0x30a6,0x30a8,0x30aa,0x30ab,0x30ad,0x30af,0x30b1,0x30b3,0x30b5,0x30b7,0x30b9,0x30bb,0x30bd},
  {0x30bf,0x30c1,0x30c4,0x30c6,0x30c8,0x30ca,0x30cb,0x30cc,0x30cd,0x30ce,0x30cf,0x30d2,0x30d5,0x30d8,0x30db,0x30de,0x30df,0x30e0,0x30e1,0x30e2,0x30e4,0x30e6,0x30e8,0x30e9,0x30ea,0x30eb,0x30ec,0x30ed,0x30ef,0x30f3,0x3099,0x309a,0x3164,0x3131,0x3132,0x3133,0x3134,0x3135,0x3136,0x3137,0x3138,0x3139,0x313a,0x313b,0x313c,0x313d,0x313e,0x313f,0x3140,0x3141,0x3142,0x3143,0x3144,0x3145,0x3146,0x3147,0x3148,0x3149,0x314a,0x314b,0x314c,0x314d,0x314e,0x0000},
  {0x0000,0x0000,0x314f,0x3150,0x3151,0x3152,0x3153,0x3154,0x0000,0x0000,0x3155,0x3156,0x3157,0x3158,0x3159,0x315a,0x0000,0x0000,0x315b,0x315c,0x315d,0x315e,0x315f,0x3160,0x0000,0x0000,0x3161,0x3162,0x3163,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x2502,0x2190,0x2191,0x2192,0x2193,0x25a0,0x25cb,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};
#define kFullWidthInverseMaxPlane  0
#define kFullWidthInverseIndexBits 10
#define kFullWidthInverseCharBits  6
static const uint8_t sFullWidthInversePages[1024] = {
  0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,1,0,0,0,0,0,0,0,0,0,0,0,0,0,2,0,3,4,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,5,0,6,7,8,9,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,10,11,0,12
};

static const uint16_t sFullWidthInverseValues[13][64] = {
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffe9,0xffea,0xffeb,0xffec,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0xffe8,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffed,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffee,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0020,0xff64,0xff61,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff62,0xff63,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff9e,0xff9f,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff67,0xff71,0xff68,0xff72,0xff69,0xff73,0xff6a,0xff74,0xff6b,0xff75,0xff76,0x0000,0xff77,0x0000,0xff78,0x0000,0xff79,0x0000,0xff7a,0x0000,0xff7b,0x0000,0xff7c,0x0000,0xff7d,0x0000,0xff7e,0x0000,0xff7f,0x0000,0xff80},
  {0x0000,0xff81,0x0000,0xff6f,0xff82,0x0000,0xff83,0x0000,0xff84,0x0000,0xff85,0xff86,0xff87,0xff88,0xff89,0xff8a,0x0000,0x0000,0xff8b,0x0000,0x0000,0xff8c,0x0000,0x0000,0xff8d,0x0000,0x0000,0xff8e,0x0000,0x0000,0xff8f,0xff90,0xff91,0xff92,0xff93,0xff6c,0xff94,0xff6d,0xff95,0xff6e,0xff96,0xff97,0xff98,0xff99,0xff9a,0xff9b,0x0000,0xff9c,0x0000,0x0000,0xff66,0xff9d,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xff65,0xff70,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xffa1,0xffa2,0xffa3,0xffa4,0xffa5,0xffa6,0xffa7,0xffa8,0xffa9,0xffaa,0xffab,0xffac,0xffad,0xffae,0xffaf},
  {0xffb0,0xffb1,0xffb2,0xffb3,0xffb4,0xffb5,0xffb6,0xffb7,0xffb8,0xffb9,0xffba,0xffbb,0xffbc,0xffbd,0xffbe,0xffc2,0xffc3,0xffc4,0xffc5,0xffc6,0xffc7,0xffca,0xffcb,0xffcc,0xffcd,0xffce,0xffcf,0xffd2,0xffd3,0xffd4,0xffd5,0xffd6,0xffd7,0xffda,0xffdb,0xffdc,0xffa0,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0021,0x0022,0x0023,0x0024,0x0025,0x0026,0x0027,0x0028,0x0029,0x002a,0x002b,0x002c,0x002d,0x002e,0x002f,0x0030,0x0031,0x0032,0x0033,0x0034,0x0035,0x0036,0x0037,0x0038,0x0039,0x003a,0x003b,0x003c,0x003d,0x003e,0x003f,0x0040,0x0041,0x0042,0x0043,0x0044,0x0045,0x0046,0x0047,0x0048,0x0049,0x004a,0x004b,0x004c,0x004d,0x004e,0x004f,0x0050,0x0051,0x0052,0x0053,0x0054,0x0055,0x0056,0x0057,0x0058,0x0059,0x005a,0x005b,0x005c,0x005d,0x005e,0x005f},
  {0x0060,0x0061,0x0062,0x0063,0x0064,0x0065,0x0066,0x0067,0x0068,0x0069,0x006a,0x006b,0x006c,0x006d,0x006e,0x006f,0x0070,0x0071,0x0072,0x0073,0x0074,0x0075,0x0076,0x0077,0x0078,0x0079,0x007a,0x007b,0x007c,0x007d,0x007e,0x2985,0x2986,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000},
  {0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x00a2,0x00a3,0x00ac,0x00af,0x00a6,0x00a5,0x20a9,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000}
};
/*
 * * * * * This file contains MACHINE-GENERATED DATA, do not edit! * * * * *
 */
