/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM SpeechSynthesisEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "SpeechSynthesisEvent.h"
#include "SpeechSynthesisEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/SpeechSynthesisEvent.h"
#include "mozilla/dom/SpeechSynthesisUtterance.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(SpeechSynthesisEvent)

NS_IMPL_ADDREF_INHERITED(SpeechSynthesisEvent, Event)
NS_IMPL_RELEASE_INHERITED(SpeechSynthesisEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(SpeechSynthesisEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mUtterance)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(SpeechSynthesisEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(SpeechSynthesisEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mUtterance)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(SpeechSynthesisEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

SpeechSynthesisEvent::SpeechSynthesisEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

SpeechSynthesisEvent::~SpeechSynthesisEvent()
{
}

SpeechSynthesisEvent*
SpeechSynthesisEvent::AsSpeechSynthesisEvent()
{
  return this;
}

JSObject*
SpeechSynthesisEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return SpeechSynthesisEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<SpeechSynthesisEvent>
SpeechSynthesisEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const SpeechSynthesisEventInit& aEventInitDict)
{
  RefPtr<SpeechSynthesisEvent> e = new SpeechSynthesisEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mUtterance = aEventInitDict.mUtterance;
  e->mCharIndex = aEventInitDict.mCharIndex;
  e->mCharLength = aEventInitDict.mCharLength;
  e->mElapsedTime = aEventInitDict.mElapsedTime;
  e->mName = aEventInitDict.mName;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<SpeechSynthesisEvent>
SpeechSynthesisEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const SpeechSynthesisEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

SpeechSynthesisUtterance*
SpeechSynthesisEvent::Utterance() const
{
  return mUtterance;
}

uint32_t
SpeechSynthesisEvent::CharIndex() const
{
  return mCharIndex;
}

Nullable<uint32_t>
SpeechSynthesisEvent::GetCharLength() const
{
  return mCharLength;
}

float
SpeechSynthesisEvent::ElapsedTime() const
{
  return mElapsedTime;
}

void
SpeechSynthesisEvent::GetName(nsString& aRetVal) const
{
  aRetVal = mName;
}


} // namespace mozilla::dom
