//
// Automatically generated by ipdlc.
// Edit at your own risk
//


#include "mozilla/net/PHttpChannelParent.h"
#include "mozilla/AntiTrackingIPCUtils.h"
#include "mozilla/ProfilerLabels.h"
#include "mozilla/TimeStamp.h"
#include "mozilla/dom/DomSecurityIPCUtils.h"
#include "mozilla/dom/FeaturePolicyUtils.h"
#include "mozilla/dom/FetchIPCTypes.h"
#include "mozilla/dom/NavigationAPIIPCUtils.h"
#include "mozilla/dom/PropertyBagUtils.h"
#include "mozilla/dom/ReferrerInfoUtils.h"
#include "mozilla/dom/ServiceWorkerIPCUtils.h"
#include "mozilla/dom/SessionHistoryEntry.h"
#include "mozilla/dom/WorkerIPCUtils.h"
#include "mozilla/ipc/IPCCore.h"
#include "mozilla/ipc/TransportSecurityInfoUtils.h"
#include "mozilla/ipc/URIUtils.h"
#include "mozilla/net/CacheInfoIPCTypes.h"
#include "mozilla/net/ClassOfService.h"
#include "mozilla/net/NeckoMessageUtils.h"
#include "nsDOMNavigationTiming.h"
#include "nsDocShellLoadState.h"
#include "nsHttp.h"
#include "nsHttpResponseHead.h"
#include "nsIPropertyBag2.h"
#include "nsIReferrerInfo.h"
#include "nsITransportSecurityInfo.h"

#include "mozilla/net/PNeckoParent.h"

#include "ipc/IPCMessageUtils.h"
#include "ipc/IPCMessageUtilsSpecializations.h"
#include "nsIFile.h"
#include "mozilla/ipc/Endpoint.h"
#include "mozilla/ipc/ProtocolMessageUtils.h"
#include "mozilla/ipc/ProtocolUtils.h"
#include "mozilla/ipc/ShmemMessageUtils.h"
#include "mozilla/ipc/TaintingIPCUtils.h"

namespace mozilla {
namespace net {


auto PHttpChannelParent::Recv__delete__() -> mozilla::ipc::IPCResult
{
    return IPC_OK();
}

MOZ_IMPLICIT PHttpChannelParent::PHttpChannelParent() :
    mozilla::ipc::IRefCountedProtocol(kProtocolId, mozilla::ipc::ParentSide)
{
    MOZ_COUNT_CTOR(PHttpChannelParent);
}

PHttpChannelParent::~PHttpChannelParent()
{
    MOZ_COUNT_DTOR(PHttpChannelParent);
}

auto PHttpChannelParent::ActorAlloc() -> void
{
    AddRef();
}

auto PHttpChannelParent::ActorDealloc() -> void
{
    Release();
}

auto PHttpChannelParent::OtherPid() const -> ::base::ProcessId
{
    ::base::ProcessId pid =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherPidMaybeInvalid();
    MOZ_RELEASE_ASSERT(pid != ::base::kInvalidProcessId);
    return pid;
}

auto PHttpChannelParent::OtherChildID() const -> ::GeckoChildID
{
    ::GeckoChildID childID =
        ::mozilla::ipc::IProtocol::ToplevelProtocol()->OtherChildIDMaybeInvalid();
    MOZ_RELEASE_ASSERT(childID != -1);
    return childID;
}

auto PHttpChannelParent::OtherEndpointProcInfo() const -> ::mozilla::ipc::EndpointProcInfo
{
    return ::mozilla::ipc::EndpointProcInfo{OtherPid(), OtherChildID()};
}

auto PHttpChannelParent::Manager() const -> PNeckoParent*
{
    return static_cast<PNeckoParent*>(IProtocol::Manager());
}

auto PHttpChannelParent::ManagedProtocolIds() const -> mozilla::Span<mozilla::ipc::ProtocolId const>
{
    return {};
}

auto PHttpChannelParent::GetManagedActors(mozilla::ipc::ProtocolId aProtocol) -> UntypedManagedContainer*
{
    switch (aProtocol) {
    default:
        return nullptr;
    }
}

auto PHttpChannelParent::SendFailedAsyncOpen(const nsresult& status) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_FailedAsyncOpen(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), status);
    // Sentinel = 'status'
    ((&(writer__)))->WriteSentinel(154731173);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_FailedAsyncOpen", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendOnStartRequestSent() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_OnStartRequestSent(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_OnStartRequestSent", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendRedirect1Begin(
        const uint32_t& registrarId,
        nsIURI* newOriginalUri,
        const uint32_t& newLoadFlags,
        const uint32_t& redirectFlags,
        const ParentLoadInfoForwarderArgs& loadInfoForwarder,
        nsHttpResponseHead&& responseHead,
        nsITransportSecurityInfo* securityInfo,
        const uint64_t& channelId,
        const NetAddr& oldPeerAddr,
        const ResourceTimingStructArgs& timing) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Redirect1Begin(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), registrarId);
    // Sentinel = 'registrarId'
    ((&(writer__)))->WriteSentinel(464585857);
    IPC::WriteParam((&(writer__)), newOriginalUri);
    // Sentinel = 'newOriginalUri'
    ((&(writer__)))->WriteSentinel(719127984);
    IPC::WriteParam((&(writer__)), newLoadFlags);
    // Sentinel = 'newLoadFlags'
    ((&(writer__)))->WriteSentinel(516293816);
    IPC::WriteParam((&(writer__)), redirectFlags);
    // Sentinel = 'redirectFlags'
    ((&(writer__)))->WriteSentinel(620889408);
    IPC::WriteParam((&(writer__)), loadInfoForwarder);
    // Sentinel = 'loadInfoForwarder'
    ((&(writer__)))->WriteSentinel(1020528345);
    IPC::WriteParam((&(writer__)), std::move(responseHead));
    // Sentinel = 'responseHead'
    ((&(writer__)))->WriteSentinel(549651682);
    IPC::WriteParam((&(writer__)), securityInfo);
    // Sentinel = 'securityInfo'
    ((&(writer__)))->WriteSentinel(552535301);
    IPC::WriteParam((&(writer__)), channelId);
    // Sentinel = 'channelId'
    ((&(writer__)))->WriteSentinel(301138823);
    IPC::WriteParam((&(writer__)), oldPeerAddr);
    // Sentinel = 'oldPeerAddr'
    ((&(writer__)))->WriteSentinel(433128519);
    IPC::WriteParam((&(writer__)), timing);
    // Sentinel = 'timing'
    ((&(writer__)))->WriteSentinel(150798985);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect1Begin", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendRedirect3Complete() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_Redirect3Complete(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect3Complete", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendRedirectFailed(const nsresult& status) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_RedirectFailed(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), status);
    // Sentinel = 'status'
    ((&(writer__)))->WriteSentinel(154731173);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_RedirectFailed", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendReportSecurityMessage(
        const nsAString& messageTag,
        const nsAString& messageCategory) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_ReportSecurityMessage(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messageTag);
    // Sentinel = 'messageTag'
    ((&(writer__)))->WriteSentinel(379061250);
    IPC::WriteParam((&(writer__)), messageCategory);
    // Sentinel = 'messageCategory'
    ((&(writer__)))->WriteSentinel(816252452);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_ReportSecurityMessage", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendReportLNAToConsole(
        const NetAddr& peerAddr,
        const nsACString& messageType,
        const nsACString& promptAction,
        const nsACString& topLevelSite) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_ReportLNAToConsole(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), peerAddr);
    // Sentinel = 'peerAddr'
    ((&(writer__)))->WriteSentinel(239928104);
    IPC::WriteParam((&(writer__)), messageType);
    // Sentinel = 'messageType'
    ((&(writer__)))->WriteSentinel(458818696);
    IPC::WriteParam((&(writer__)), promptAction);
    // Sentinel = 'promptAction'
    ((&(writer__)))->WriteSentinel(550831361);
    IPC::WriteParam((&(writer__)), topLevelSite);
    // Sentinel = 'topLevelSite'
    ((&(writer__)))->WriteSentinel(536675553);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_ReportLNAToConsole", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendDeleteSelf() -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_DeleteSelf(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};



    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_DeleteSelf", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendLogBlockedCORSRequest(
        const nsAString& message,
        const nsACString& category,
        const bool& isWarning) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_LogBlockedCORSRequest(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), message);
    // Sentinel = 'message'
    ((&(writer__)))->WriteSentinel(197198566);
    IPC::WriteParam((&(writer__)), category);
    // Sentinel = 'category'
    ((&(writer__)))->WriteSentinel(247333727);
    IPC::WriteParam((&(writer__)), isWarning);
    // Sentinel = 'isWarning'
    ((&(writer__)))->WriteSentinel(308872115);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_LogBlockedCORSRequest", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendLogMimeTypeMismatch(
        const nsACString& messageName,
        const bool& warning,
        const nsAString& url,
        const nsAString& contentType) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_LogMimeTypeMismatch(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), messageName);
    // Sentinel = 'messageName'
    ((&(writer__)))->WriteSentinel(452133991);
    IPC::WriteParam((&(writer__)), warning);
    // Sentinel = 'warning'
    ((&(writer__)))->WriteSentinel(201196279);
    IPC::WriteParam((&(writer__)), url);
    // Sentinel = 'url'
    ((&(writer__)))->WriteSentinel(45220180);
    IPC::WriteParam((&(writer__)), contentType);
    // Sentinel = 'contentType'
    ((&(writer__)))->WriteSentinel(465241246);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_LogMimeTypeMismatch", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendOriginalCacheInputStreamAvailable(const mozilla::Maybe<IPCStream>& stream) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_OriginalCacheInputStreamAvailable(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), stream);
    // Sentinel = 'stream'
    ((&(writer__)))->WriteSentinel(153223821);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_OriginalCacheInputStreamAvailable", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::SendSetPriority(const int16_t& priority) -> bool
{
    UniquePtr<IPC::Message> msg__ = PHttpChannel::Msg_SetPriority(Id());
    IPC::MessageWriter writer__{
            (*(msg__)),
            this};

    IPC::WriteParam((&(writer__)), priority);
    // Sentinel = 'priority'
    ((&(writer__)))->WriteSentinel(262865795);


    if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
        mozilla::ipc::LogMessageForProtocol(
            "PHttpChannelParent",
            this->ToplevelProtocol()->OtherPidMaybeInvalid(),
            "Sending ",
            msg__->type(),
            mozilla::ipc::MessageDirection::eSending);
    }
    AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetPriority", OTHER);

    bool sendok__ = ChannelSend(std::move(msg__));
    return sendok__;
}

auto PHttpChannelParent::DeallocManagee(
        mozilla::ipc::ProtocolId aProtocolId,
        IProtocol* aListener) -> void
{
    FatalError("unreached");
    return;
}

auto PHttpChannelParent::OnMessageReceived(const Message& msg__) -> PHttpChannelParent::Result
{
    switch (msg__.type()) {
    case MANAGED_ENDPOINT_BOUND_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            return MsgProcessed;
        }
    case MANAGED_ENDPOINT_DROPPED_MESSAGE_TYPE:
        {
            if (!mAwaitingManagedEndpointBind) {
                NS_WARNING("Unexpected managed endpoint lifecycle message after actor bound!");
                return MsgNotAllowed;
            }
            mAwaitingManagedEndpointBind = false;
            this->ActorDisconnected(ManagedEndpointDropped);
            return MsgProcessed;
        }
    case PHttpChannel::Msg_SetClassOfService__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetClassOfService", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__cos = IPC::ReadParam<ClassOfService>((&(reader__)));
            if (!maybe__cos) {
                FatalError("Error deserializing 'ClassOfService'");
                return MsgValueError;

            }
            auto& cos = *maybe__cos;
            // Sentinel = 'cos'
            if ((!(((&(reader__)))->ReadSentinel(41746758)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ClassOfService'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetClassOfService(std::move(cos));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Suspend__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Suspend", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvSuspend();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Resume__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Resume", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvResume();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Cancel__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Cancel", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__status = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__status) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& status = *maybe__status;
            // Sentinel = 'status'
            if ((!(((&(reader__)))->ReadSentinel(154731173)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__requestBlockingReason = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__requestBlockingReason) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& requestBlockingReason = *maybe__requestBlockingReason;
            // Sentinel = 'requestBlockingReason'
            if ((!(((&(reader__)))->ReadSentinel(1599867035)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__aReason = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__aReason) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& aReason = *maybe__aReason;
            // Sentinel = 'aReason'
            if ((!(((&(reader__)))->ReadSentinel(180093642)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__logString = IPC::ReadParam<mozilla::Maybe<nsCString>>((&(reader__)));
            if (!maybe__logString) {
                FatalError("Error deserializing 'nsCString?'");
                return MsgValueError;

            }
            auto& logString = *maybe__logString;
            // Sentinel = 'logString'
            if ((!(((&(reader__)))->ReadSentinel(312083386)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvCancel(std::move(status), std::move(requestBlockingReason), std::move(aReason), std::move(logString));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_Redirect2Verify__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_Redirect2Verify", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__result = IPC::ReadParam<nsresult>((&(reader__)));
            if (!maybe__result) {
                FatalError("Error deserializing 'nsresult'");
                return MsgValueError;

            }
            auto& result = *maybe__result;
            // Sentinel = 'result'
            if ((!(((&(reader__)))->ReadSentinel(153223840)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsresult'");
                return MsgValueError;
            }
            auto maybe__changedHeaders = IPC::ReadParam<RequestHeaderTuples>((&(reader__)));
            if (!maybe__changedHeaders) {
                FatalError("Error deserializing 'RequestHeaderTuples'");
                return MsgValueError;

            }
            auto& changedHeaders = *maybe__changedHeaders;
            // Sentinel = 'changedHeaders'
            if ((!(((&(reader__)))->ReadSentinel(688522631)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'RequestHeaderTuples'");
                return MsgValueError;
            }
            auto maybe__sourceRequestBlockingReason = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__sourceRequestBlockingReason) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& sourceRequestBlockingReason = *maybe__sourceRequestBlockingReason;
            // Sentinel = 'sourceRequestBlockingReason'
            if ((!(((&(reader__)))->ReadSentinel(2614692620)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__targetLoadInfoForwarder = IPC::ReadParam<mozilla::Maybe<ChildLoadInfoForwarderArgs>>((&(reader__)));
            if (!maybe__targetLoadInfoForwarder) {
                FatalError("Error deserializing 'ChildLoadInfoForwarderArgs?'");
                return MsgValueError;

            }
            auto& targetLoadInfoForwarder = *maybe__targetLoadInfoForwarder;
            // Sentinel = 'targetLoadInfoForwarder'
            if ((!(((&(reader__)))->ReadSentinel(1854474560)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'ChildLoadInfoForwarderArgs?'");
                return MsgValueError;
            }
            auto maybe__loadFlags = IPC::ReadParam<uint32_t>((&(reader__)));
            if (!maybe__loadFlags) {
                FatalError("Error deserializing 'uint32_t'");
                return MsgValueError;

            }
            auto& loadFlags = *maybe__loadFlags;
            // Sentinel = 'loadFlags'
            if ((!(((&(reader__)))->ReadSentinel(297665422)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'uint32_t'");
                return MsgValueError;
            }
            auto maybe__referrerInfo = IPC::ReadParam<RefPtr<nsIReferrerInfo>>((&(reader__)));
            if (!maybe__referrerInfo) {
                FatalError("Error deserializing 'nsIReferrerInfo'");
                return MsgValueError;

            }
            auto& referrerInfo = *maybe__referrerInfo;
            // Sentinel = 'referrerInfo'
            if ((!(((&(reader__)))->ReadSentinel(540214506)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIReferrerInfo'");
                return MsgValueError;
            }
            auto maybe__apiRedirectTo = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__apiRedirectTo) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& apiRedirectTo = *maybe__apiRedirectTo;
            // Sentinel = 'apiRedirectTo'
            if ((!(((&(reader__)))->ReadSentinel(606143792)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__corsPreflightArgs = IPC::ReadParam<mozilla::Maybe<CorsPreflightArgs>>((&(reader__)));
            if (!maybe__corsPreflightArgs) {
                FatalError("Error deserializing 'CorsPreflightArgs?'");
                return MsgValueError;

            }
            auto& corsPreflightArgs = *maybe__corsPreflightArgs;
            // Sentinel = 'corsPreflightArgs'
            if ((!(((&(reader__)))->ReadSentinel(1048250090)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CorsPreflightArgs?'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRedirect2Verify(std::move(result), std::move(changedHeaders), std::move(sourceRequestBlockingReason), std::move(targetLoadInfoForwarder), std::move(loadFlags), referrerInfo, apiRedirectTo, std::move(corsPreflightArgs));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_DocumentChannelCleanup__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_DocumentChannelCleanup", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__clearCacheEntry = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__clearCacheEntry) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& clearCacheEntry = *maybe__clearCacheEntry;
            // Sentinel = 'clearCacheEntry'
            if ((!(((&(reader__)))->ReadSentinel(779486702)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvDocumentChannelCleanup(std::move(clearCacheEntry));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_RemoveCorsPreflightCacheEntry__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_RemoveCorsPreflightCacheEntry", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__uri = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__uri) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& uri = *maybe__uri;
            // Sentinel = 'uri'
            if ((!(((&(reader__)))->ReadSentinel(45023569)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__requestingPrincipal = IPC::ReadParam<PrincipalInfo>((&(reader__)));
            if (!maybe__requestingPrincipal) {
                FatalError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;

            }
            auto& requestingPrincipal = *maybe__requestingPrincipal;
            // Sentinel = 'requestingPrincipal'
            if ((!(((&(reader__)))->ReadSentinel(1344079850)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'PrincipalInfo'");
                return MsgValueError;
            }
            auto maybe__originAttributes = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__originAttributes) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& originAttributes = *maybe__originAttributes;
            // Sentinel = 'originAttributes'
            if ((!(((&(reader__)))->ReadSentinel(947259056)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvRemoveCorsPreflightCacheEntry(uri, std::move(requestingPrincipal), std::move(originAttributes));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_SetCookies__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetCookies", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__baseDomain = IPC::ReadParam<nsCString>((&(reader__)));
            if (!maybe__baseDomain) {
                FatalError("Error deserializing 'nsCString'");
                return MsgValueError;

            }
            auto& baseDomain = *maybe__baseDomain;
            // Sentinel = 'baseDomain'
            if ((!(((&(reader__)))->ReadSentinel(360449012)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsCString'");
                return MsgValueError;
            }
            auto maybe__attrs = IPC::ReadParam<OriginAttributes>((&(reader__)));
            if (!maybe__attrs) {
                FatalError("Error deserializing 'OriginAttributes'");
                return MsgValueError;

            }
            auto& attrs = *maybe__attrs;
            // Sentinel = 'attrs'
            if ((!(((&(reader__)))->ReadSentinel(107807279)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'OriginAttributes'");
                return MsgValueError;
            }
            auto maybe__host = IPC::ReadParam<RefPtr<nsIURI>>((&(reader__)));
            if (!maybe__host) {
                FatalError("Error deserializing 'nsIURI'");
                return MsgValueError;

            }
            auto& host = *maybe__host;
            // Sentinel = 'host'
            if ((!(((&(reader__)))->ReadSentinel(72024511)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'nsIURI'");
                return MsgValueError;
            }
            auto maybe__fromHttp = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__fromHttp) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& fromHttp = *maybe__fromHttp;
            // Sentinel = 'fromHttp'
            if ((!(((&(reader__)))->ReadSentinel(249889621)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__isThirdParty = IPC::ReadParam<bool>((&(reader__)));
            if (!maybe__isThirdParty) {
                FatalError("Error deserializing 'bool'");
                return MsgValueError;

            }
            auto& isThirdParty = *maybe__isThirdParty;
            // Sentinel = 'isThirdParty'
            if ((!(((&(reader__)))->ReadSentinel(526517480)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'bool'");
                return MsgValueError;
            }
            auto maybe__cookies = IPC::ReadParam<nsTArray<CookieStruct>>((&(reader__)));
            if (!maybe__cookies) {
                FatalError("Error deserializing 'CookieStruct[]'");
                return MsgValueError;

            }
            auto& cookies = *maybe__cookies;
            // Sentinel = 'cookies'
            if ((!(((&(reader__)))->ReadSentinel(195363566)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'CookieStruct[]'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetCookies(std::move(baseDomain), std::move(attrs), host, std::move(fromHttp), std::move(isThirdParty), std::move(cookies));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_DeletingChannel__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_DeletingChannel", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvDeletingChannel();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_OpenOriginalCacheInputStream__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_OpenOriginalCacheInputStream", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->RecvOpenOriginalCacheInputStream();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg_BytesRead__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_BytesRead", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__count = IPC::ReadParam<int32_t>((&(reader__)));
            if (!maybe__count) {
                FatalError("Error deserializing 'int32_t'");
                return MsgValueError;

            }
            auto& count = *maybe__count;
            // Sentinel = 'count'
            if ((!(((&(reader__)))->ReadSentinel(106889770)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int32_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvBytesRead(std::move(count));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    case PHttpChannel::Msg___delete____ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg___delete__", OTHER);

            mozilla::ipc::IPCResult __ok = (this)->Recv__delete__();
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }


            this->ActorDisconnected(Deletion);

            return MsgProcessed;
        }
    case PHttpChannel::Msg_SetPriority__ID:
        {
            if (mozilla::ipc::LoggingEnabledFor("PHttpChannel", mozilla::ipc::ParentSide)) {
                mozilla::ipc::LogMessageForProtocol(
                    "PHttpChannelParent",
                    this->ToplevelProtocol()->OtherPidMaybeInvalid(),
                    "Received ",
                    (&(msg__))->type(),
                    mozilla::ipc::MessageDirection::eReceiving);
            }
            AUTO_PROFILER_LABEL("PHttpChannel::Msg_SetPriority", OTHER);

            IPC::MessageReader reader__{
                    msg__,
                    this};

            auto maybe__priority = IPC::ReadParam<int16_t>((&(reader__)));
            if (!maybe__priority) {
                FatalError("Error deserializing 'int16_t'");
                return MsgValueError;

            }
            auto& priority = *maybe__priority;
            // Sentinel = 'priority'
            if ((!(((&(reader__)))->ReadSentinel(262865795)))) {
                mozilla::ipc::SentinelReadError("Error deserializing 'int16_t'");
                return MsgValueError;
            }
            reader__.EndRead();
            mozilla::ipc::IPCResult __ok = (this)->RecvSetPriority(std::move(priority));
            if ((!(__ok))) {
                mozilla::ipc::ProtocolErrorBreakpoint("Handler returned error code!");
                // Error handled in mozilla::ipc::IPCResult
                return MsgProcessingError;
            }

            return MsgProcessed;
        }
    default:
        return MsgNotKnown;
    }
}

auto PHttpChannelParent::OnMessageReceived(
        const Message& msg__,
        UniquePtr<Message>& reply__) -> PHttpChannelParent::Result
{
    return MsgNotKnown;
}



} // namespace net
} // namespace mozilla
namespace IPC {
auto ParamTraits<::mozilla::net::PHttpChannelParent*>::Write(
        IPC::MessageWriter* aWriter,
        const paramType& aVar) -> void
{
    IPC::WriteParam(aWriter, static_cast<mozilla::ipc::IProtocol*>(aVar));
    // Sentinel = 'PHttpChannel'
    (aWriter)->WriteSentinel(492962986);
}

auto ParamTraits<::mozilla::net::PHttpChannelParent*>::Read(IPC::MessageReader* aReader) -> IPC::ReadResult<paramType>
{
    auto maybe__actor = IPC::ReadParam<mozilla::ipc::IProtocol*>(aReader);
    if (!maybe__actor) {
        aReader->FatalError("Error deserializing managed PHttpChannel actor");
        return {};

    }
    auto& actor = *maybe__actor;
    // Sentinel = 'PHttpChannel'
    if ((!((aReader)->ReadSentinel(492962986)))) {
        mozilla::ipc::SentinelReadError("Error deserializing managed PHttpChannel actor");
        return {};
    }

    if (actor && actor->GetProtocolId() != PHttpChannelMsgStart) {
        aReader->FatalError("Unexpected actor type (expected PHttpChannel)");

        return {};
    }
    return static_cast<::mozilla::net::PHttpChannelParent*>(actor);
}

} // namespace IPC
