/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM PageRevealEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "PageRevealEvent.h"
#include "PageRevealEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PageRevealEvent.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ViewTransition.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(PageRevealEvent)

NS_IMPL_ADDREF_INHERITED(PageRevealEvent, Event)
NS_IMPL_RELEASE_INHERITED(PageRevealEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(PageRevealEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mViewTransition)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(PageRevealEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(PageRevealEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mViewTransition)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(PageRevealEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

PageRevealEvent::PageRevealEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

PageRevealEvent::~PageRevealEvent()
{
}

PageRevealEvent*
PageRevealEvent::AsPageRevealEvent()
{
  return this;
}

JSObject*
PageRevealEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return PageRevealEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<PageRevealEvent>
PageRevealEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const PageRevealEventInit& aEventInitDict)
{
  RefPtr<PageRevealEvent> e = new PageRevealEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aEventInitDict.mBubbles, aEventInitDict.mCancelable);
  e->mViewTransition = aEventInitDict.mViewTransition;
  e->SetTrusted(trusted);
  e->SetComposed(aEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<PageRevealEvent>
PageRevealEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const PageRevealEventInit& aEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aEventInitDict);
}

ViewTransition*
PageRevealEvent::GetViewTransition() const
{
  return mViewTransition;
}


} // namespace mozilla::dom
