// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanSecurityCertverifierMetrics_h
#define mozilla_GleanSecurityCertverifierMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace cert_signature_cache {
  /**
   * generated from cert_signature_cache.hits
   * How often a certificate signature to be verified is in the cache already.
   */
  constexpr impl::NumeratorMetric hits(4400);

  /**
   * generated from cert_signature_cache.total
   * How many certificate signature verifications are performed.
   */
  constexpr impl::DenominatorMetric total(4401);
}

namespace cert_trust_cache {
  /**
   * generated from cert_trust_cache.hits
   * How often a certificate's trust is in the cache already.
   */
  constexpr impl::NumeratorMetric hits(4402);

  /**
   * generated from cert_trust_cache.total
   * How many certificate trust lookups are performed.
   */
  constexpr impl::DenominatorMetric total(4403);
}

namespace cert_verifier {
  /**
   * generated from cert_verifier.cert_revocation_mechanisms
   */
  enum class CertRevocationMechanismsLabel: uint16_t {
    eCrlite = 0,
    eStapledocsp = 1,
    eCachedocsp = 2,
    eOcsp = 3,
    eOnecrl = 4,
    eShortvalidity = 5,
    e__Other__,
  };
  /**
   * Which revocation checking mechanisms were used in a TLS handshake?
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CertRevocationMechanismsLabel> cert_revocation_mechanisms(4404);

  /**
   * generated from cert_verifier.crlite_status
   */
  enum class CrliteStatusLabel: uint16_t {
    eNoFilter = 0,
    eNotCovered = 1,
    eNotEnrolled = 2,
    eNotRevoked = 3,
    eRevokedInFilter = 4,
    eRevokedInStash = 5,
    e__Other__,
  };
  /**
   * Counts the number of times different CRLite statuses were returned.
   */
  constexpr impl::Labeled<impl::CounterMetric<impl::CounterType::eBaseOrLabeled>, CrliteStatusLabel> crlite_status(4405);
}

} // namespace mozilla::glean

#endif // mozilla_GleanSecurityCertverifierMetrics_h
