/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim:set ts=2 sw=2 sts=2 et cindent: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

/* THIS FILE IS AUTOGENERATED FROM GPUUncapturedErrorEvent.webidl BY Codegen.py - DO NOT EDIT */

#include "EventBinding.h"
#include "GPUUncapturedErrorEvent.h"
#include "GPUUncapturedErrorEventBinding.h"
#include "js/GCAPI.h"
#include "mozilla/HoldDropJSObjects.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/GPUUncapturedErrorEvent.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/webgpu/Error.h"
#include "mozilla/webgpu/Instance.h"

namespace mozilla::dom {


NS_IMPL_CYCLE_COLLECTION_CLASS(GPUUncapturedErrorEvent)

NS_IMPL_ADDREF_INHERITED(GPUUncapturedErrorEvent, Event)
NS_IMPL_RELEASE_INHERITED(GPUUncapturedErrorEvent, Event)

NS_IMPL_CYCLE_COLLECTION_TRAVERSE_BEGIN_INHERITED(GPUUncapturedErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_TRAVERSE(mError)
NS_IMPL_CYCLE_COLLECTION_TRAVERSE_END

NS_IMPL_CYCLE_COLLECTION_TRACE_BEGIN_INHERITED(GPUUncapturedErrorEvent, Event)
NS_IMPL_CYCLE_COLLECTION_TRACE_END

NS_IMPL_CYCLE_COLLECTION_UNLINK_BEGIN_INHERITED(GPUUncapturedErrorEvent, Event)
  NS_IMPL_CYCLE_COLLECTION_UNLINK(mError)
NS_IMPL_CYCLE_COLLECTION_UNLINK_END

NS_INTERFACE_MAP_BEGIN_CYCLE_COLLECTION(GPUUncapturedErrorEvent)
NS_INTERFACE_MAP_END_INHERITING(Event)

GPUUncapturedErrorEvent::GPUUncapturedErrorEvent(mozilla::dom::EventTarget* aOwner)
  : Event(aOwner, nullptr, nullptr)
{
}

GPUUncapturedErrorEvent::~GPUUncapturedErrorEvent()
{
}

GPUUncapturedErrorEvent*
GPUUncapturedErrorEvent::AsGPUUncapturedErrorEvent()
{
  return this;
}

JSObject*
GPUUncapturedErrorEvent::WrapObjectInternal(JSContext* aCx, JS::Handle<JSObject*> aGivenProto)
{
  return GPUUncapturedErrorEvent_Binding::Wrap(aCx, this, aGivenProto);
}

already_AddRefed<GPUUncapturedErrorEvent>
GPUUncapturedErrorEvent::Constructor(mozilla::dom::EventTarget* aOwner, const nsAString& aType, const GPUUncapturedErrorEventInit& aGpuUncapturedErrorEventInitDict)
{
  RefPtr<GPUUncapturedErrorEvent> e = new GPUUncapturedErrorEvent(aOwner);
  bool trusted = e->Init(aOwner);
  e->InitEvent(aType, aGpuUncapturedErrorEventInitDict.mBubbles, aGpuUncapturedErrorEventInitDict.mCancelable);
  e->mError = aGpuUncapturedErrorEventInitDict.mError;
  e->SetTrusted(trusted);
  e->SetComposed(aGpuUncapturedErrorEventInitDict.mComposed);
  return e.forget();
}

already_AddRefed<GPUUncapturedErrorEvent>
GPUUncapturedErrorEvent::Constructor(const GlobalObject& aGlobal, const nsAString& aType, const GPUUncapturedErrorEventInit& aGpuUncapturedErrorEventInitDict)
{
  nsCOMPtr<mozilla::dom::EventTarget> owner = do_QueryInterface(aGlobal.GetAsSupports());
  return Constructor(owner, aType, aGpuUncapturedErrorEventInitDict);
}

webgpu::Error*
GPUUncapturedErrorEvent::Error() const
{
  return mError;
}


} // namespace mozilla::dom
