/* THIS FILE IS AUTOGENERATED FROM RTCRtpParameters.webidl BY Codegen.py - DO NOT EDIT */

#include <type_traits>
#include "AtomList.h"
#include "MainThreadUtils.h"
#include "RTCRtpParametersBinding.h"
#include "js/Array.h"
#include "js/CallAndConstruct.h"
#include "js/Exception.h"
#include "js/ForOfIterator.h"
#include "js/MapAndSet.h"
#include "js/Object.h"
#include "js/PropertyAndElement.h"
#include "js/PropertyDescriptor.h"
#include "js/experimental/JitInfo.h"
#include "jsapi.h"
#include "mozilla/FloatingPoint.h"
#include "mozilla/OwningNonNull.h"
#include "mozilla/dom/BindingCallContext.h"
#include "mozilla/dom/BindingUtils.h"
#include "mozilla/dom/NonRefcountedDOMObject.h"
#include "mozilla/dom/PrimitiveConversions.h"
#include "mozilla/dom/ScriptSettings.h"
#include "mozilla/dom/SimpleGlobalObject.h"

namespace mozilla {

namespace dom {

namespace binding_detail {}; // Just to make sure it's known as a namespace
using namespace mozilla::dom::binding_detail;


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCPriorityType>::Values[4];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCPriorityType aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCPriorityType>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCPriorityType>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCPriorityType>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}


namespace binding_detail {
constexpr nsLiteralCString EnumStrings<RTCDegradationPreference>::Values[3];
} // namespace binding_detail

bool
ToJSValue(JSContext* aCx, RTCDegradationPreference aArgument, JS::MutableHandle<JS::Value> aValue)
{
  MOZ_ASSERT(uint32_t(aArgument) < std::size(binding_detail::EnumStrings<RTCDegradationPreference>::Values));
  JSString* resultStr =
    JS_NewStringCopyN(aCx, binding_detail::EnumStrings<RTCDegradationPreference>::Values[uint32_t(aArgument)].BeginReading(),
                      binding_detail::EnumStrings<RTCDegradationPreference>::Values[uint32_t(aArgument)].Length());
  if (!resultStr) {
    return false;
  }
  aValue.setString(resultStr);
  return true;
}



RTCRtcpParameters::RTCRtcpParameters()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtcpParameters::InitIds(JSContext* cx, RTCRtcpParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->reducedSize_id.init(cx, "reducedSize") ||
      !atomsCache->cname_id.init(cx, "cname")) {
    return false;
  }
  return true;
}

bool
RTCRtcpParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtcpParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtcpParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->cname_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCname.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mCname.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->reducedSize_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mReducedSize.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'reducedSize' member of RTCRtcpParameters", &(mReducedSize.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtcpParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtcpParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtcpParametersAtoms* atomsCache = GetAtomCache<RTCRtcpParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mCname.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mCname.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->cname_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mReducedSize.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mReducedSize.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->reducedSize_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtcpParameters::TraceDictionary(JSTracer* trc)
{
}

RTCRtcpParameters&
RTCRtcpParameters::operator=(const RTCRtcpParameters& aOther)
{
  DictionaryBase::operator=(aOther);
  mCname.Reset();
  if (aOther.mCname.WasPassed()) {
    mCname.Construct(aOther.mCname.Value());
  }
  mReducedSize.Reset();
  if (aOther.mReducedSize.WasPassed()) {
    mReducedSize.Construct(aOther.mReducedSize.Value());
  }
  return *this;
}



RTCRtpCodecParameters::RTCRtpCodecParameters()
  : RTCRtpCodec(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpCodecParameters::InitIds(JSContext* cx, RTCRtpCodecParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->payloadType_id.init(cx, "payloadType")) {
    return false;
  }
  return true;
}

bool
RTCRtpCodecParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpCodecParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpCodecParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!RTCRtpCodec::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->payloadType_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<uint8_t, eDefault>(cx, temp.ref(), "'payloadType' member of RTCRtpCodecParameters", &mPayloadType)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'payloadType' member of RTCRtpCodecParameters");
  }
  return true;
}

bool
RTCRtpCodecParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpCodecParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpCodecParametersAtoms* atomsCache = GetAtomCache<RTCRtpCodecParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCRtpCodec::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    uint8_t const & currentValue = mPayloadType;
    temp.setInt32(int32_t(currentValue));
    if (!JS_DefinePropertyById(cx, obj, atomsCache->payloadType_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  return true;
}

void
RTCRtpCodecParameters::TraceDictionary(JSTracer* trc)
{
  RTCRtpCodec::TraceDictionary(trc);
}

RTCRtpCodecParameters&
RTCRtpCodecParameters::operator=(const RTCRtpCodecParameters& aOther)
{
  RTCRtpCodec::operator=(aOther);
  mPayloadType = aOther.mPayloadType;
  return *this;
}

bool
RTCRtpCodecParameters::operator==(const RTCRtpCodecParameters& aOther) const
{
  if (!RTCRtpCodec::operator==(aOther)) {
      return false;
  }
  if (mPayloadType != aOther.mPayloadType) {
      return false;
  }
  return true;
}



RTCRtpEncodingParameters::RTCRtpEncodingParameters()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpEncodingParameters::InitIds(JSContext* cx, RTCRtpEncodingParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->scaleResolutionDownBy_id.init(cx, "scaleResolutionDownBy") ||
      !atomsCache->rid_id.init(cx, "rid") ||
      !atomsCache->priority_id.init(cx, "priority") ||
      !atomsCache->maxFramerate_id.init(cx, "maxFramerate") ||
      !atomsCache->maxBitrate_id.init(cx, "maxBitrate") ||
      !atomsCache->codec_id.init(cx, "codec") ||
      !atomsCache->active_id.init(cx, "active")) {
    return false;
  }
  return true;
}

bool
RTCRtpEncodingParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpEncodingParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpEncodingParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->active_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'active' member of RTCRtpEncodingParameters", &mActive)) {
      return false;
    }
  } else {
    mActive = true;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->codec_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCodec.Construct();
    if (!(mCodec.Value()).Init(cx, temp.ref(), "'codec' member of RTCRtpEncodingParameters", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxBitrate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMaxBitrate.Construct();
    if (!ValueToPrimitive<uint32_t, eDefault>(cx, temp.ref(), "'maxBitrate' member of RTCRtpEncodingParameters", &(mMaxBitrate.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->maxFramerate_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mMaxFramerate.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'maxFramerate' member of RTCRtpEncodingParameters", &(mMaxFramerate.Value()))) {
      return false;
    } else if (!std::isfinite((mMaxFramerate.Value()))) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'maxFramerate' member of RTCRtpEncodingParameters");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->priority_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RTCPriorityType>::Values,
                                                                         "RTCPriorityType", "'priority' member of RTCRtpEncodingParameters",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      mPriority = static_cast<RTCPriorityType>(index);
    }
  } else {
    mPriority = RTCPriorityType::Low;
  }
  mIsAnyMemberPresent = true;

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->rid_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRid.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mRid.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->scaleResolutionDownBy_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mScaleResolutionDownBy.Construct();
    if (!ValueToPrimitive<double, eDefault>(cx, temp.ref(), "'scaleResolutionDownBy' member of RTCRtpEncodingParameters", &(mScaleResolutionDownBy.Value()))) {
      return false;
    } else if (!std::isfinite((mScaleResolutionDownBy.Value()))) {
      cx.ThrowErrorMessage<MSG_NOT_FINITE>("'scaleResolutionDownBy' member of RTCRtpEncodingParameters");
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtpEncodingParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpEncodingParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpEncodingParametersAtoms* atomsCache = GetAtomCache<RTCRtpEncodingParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    bool const & currentValue = mActive;
    temp.setBoolean(currentValue);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->active_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mCodec.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCRtpCodec const & currentValue = mCodec.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->codec_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMaxBitrate.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint32_t const & currentValue = mMaxBitrate.InternalValue();
      temp.setNumber(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->maxBitrate_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mMaxFramerate.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mMaxFramerate.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->maxFramerate_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    RTCPriorityType const & currentValue = mPriority;
    if (!ToJSValue(cx, currentValue, &temp)) {
      return false;
    }
    if (!JS_DefinePropertyById(cx, obj, atomsCache->priority_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mRid.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mRid.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->rid_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mScaleResolutionDownBy.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      double const & currentValue = mScaleResolutionDownBy.InternalValue();
      temp.set(JS_NumberValue(double(currentValue)));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->scaleResolutionDownBy_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpEncodingParameters::TraceDictionary(JSTracer* trc)
{
}

RTCRtpEncodingParameters&
RTCRtpEncodingParameters::operator=(const RTCRtpEncodingParameters& aOther)
{
  DictionaryBase::operator=(aOther);
  mActive = aOther.mActive;
  mCodec.Reset();
  if (aOther.mCodec.WasPassed()) {
    mCodec.Construct(aOther.mCodec.Value());
  }
  mMaxBitrate.Reset();
  if (aOther.mMaxBitrate.WasPassed()) {
    mMaxBitrate.Construct(aOther.mMaxBitrate.Value());
  }
  mMaxFramerate.Reset();
  if (aOther.mMaxFramerate.WasPassed()) {
    mMaxFramerate.Construct(aOther.mMaxFramerate.Value());
  }
  mPriority = aOther.mPriority;
  mRid.Reset();
  if (aOther.mRid.WasPassed()) {
    mRid.Construct(aOther.mRid.Value());
  }
  mScaleResolutionDownBy.Reset();
  if (aOther.mScaleResolutionDownBy.WasPassed()) {
    mScaleResolutionDownBy.Construct(aOther.mScaleResolutionDownBy.Value());
  }
  return *this;
}



RTCRtpHeaderExtensionParameters::RTCRtpHeaderExtensionParameters()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpHeaderExtensionParameters::InitIds(JSContext* cx, RTCRtpHeaderExtensionParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->uri_id.init(cx, "uri") ||
      !atomsCache->id_id.init(cx, "id") ||
      !atomsCache->encrypted_id.init(cx, "encrypted")) {
    return false;
  }
  return true;
}

bool
RTCRtpHeaderExtensionParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpHeaderExtensionParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpHeaderExtensionParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->encrypted_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mEncrypted.Construct();
    if (!ValueToPrimitive<bool, eDefault>(cx, temp.ref(), "'encrypted' member of RTCRtpHeaderExtensionParameters", &(mEncrypted.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->id_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mId.Construct();
    if (!ValueToPrimitive<uint16_t, eDefault>(cx, temp.ref(), "'id' member of RTCRtpHeaderExtensionParameters", &(mId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->uri_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mUri.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mUri.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtpHeaderExtensionParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpHeaderExtensionParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpHeaderExtensionParametersAtoms* atomsCache = GetAtomCache<RTCRtpHeaderExtensionParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mEncrypted.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      bool const & currentValue = mEncrypted.InternalValue();
      temp.setBoolean(currentValue);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->encrypted_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      uint16_t const & currentValue = mId.InternalValue();
      temp.setInt32(int32_t(currentValue));
      if (!JS_DefinePropertyById(cx, obj, atomsCache->id_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mUri.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mUri.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->uri_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpHeaderExtensionParameters::TraceDictionary(JSTracer* trc)
{
}

RTCRtpHeaderExtensionParameters&
RTCRtpHeaderExtensionParameters::operator=(const RTCRtpHeaderExtensionParameters& aOther)
{
  DictionaryBase::operator=(aOther);
  mEncrypted.Reset();
  if (aOther.mEncrypted.WasPassed()) {
    mEncrypted.Construct(aOther.mEncrypted.Value());
  }
  mId.Reset();
  if (aOther.mId.WasPassed()) {
    mId.Construct(aOther.mId.Value());
  }
  mUri.Reset();
  if (aOther.mUri.WasPassed()) {
    mUri.Construct(aOther.mUri.Value());
  }
  return *this;
}



RTCRtpParameters::RTCRtpParameters()
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpParameters::InitIds(JSContext* cx, RTCRtpParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->rtcp_id.init(cx, "rtcp") ||
      !atomsCache->headerExtensions_id.init(cx, "headerExtensions") ||
      !atomsCache->codecs_id.init(cx, "codecs")) {
    return false;
  }
  return true;
}

bool
RTCRtpParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  if (!IsConvertibleToDictionary(val)) {
    return cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>(sourceDescription, "dictionary");
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->codecs_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mCodecs.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'codecs' member of RTCRtpParameters", "sequence");
        return false;
      }
      Sequence<RTCRtpCodecParameters> &arr = (mCodecs.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        RTCRtpCodecParameters* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        RTCRtpCodecParameters& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'codecs' member of RTCRtpParameters", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'codecs' member of RTCRtpParameters", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->headerExtensions_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mHeaderExtensions.Construct();
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'headerExtensions' member of RTCRtpParameters", "sequence");
        return false;
      }
      Sequence<RTCRtpHeaderExtensionParameters> &arr = (mHeaderExtensions.Value());
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        RTCRtpHeaderExtensionParameters* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        RTCRtpHeaderExtensionParameters& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'headerExtensions' member of RTCRtpParameters", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'headerExtensions' member of RTCRtpParameters", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->rtcp_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mRtcp.Construct();
    if (!(mRtcp.Value()).Init(cx, temp.ref(), "'rtcp' member of RTCRtpParameters", passedToJSImpl)) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtpParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpParametersAtoms* atomsCache = GetAtomCache<RTCRtpParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  JS::Rooted<JSObject*> obj(cx, JS_NewPlainObject(cx));
  if (!obj) {
    return false;
  }
  rval.set(JS::ObjectValue(*obj));

  if (mCodecs.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<RTCRtpCodecParameters> const & currentValue = mCodecs.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->codecs_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mHeaderExtensions.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      Sequence<RTCRtpHeaderExtensionParameters> const & currentValue = mHeaderExtensions.InternalValue();

      uint32_t length = currentValue.Length();
      JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
      if (!returnArray) {
        return false;
      }
      // Scope for 'tmp'
      {
        JS::Rooted<JS::Value> tmp(cx);
        for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
          // Control block to let us common up the JS_DefineElement calls when there
          // are different ways to succeed at wrapping the object.
          do {
            if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
              return false;
            }
            break;
          } while (false);
          if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                                JSPROP_ENUMERATE)) {
            return false;
          }
        }
      }
      temp.setObject(*returnArray);
      if (!JS_DefinePropertyById(cx, obj, atomsCache->headerExtensions_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  if (mRtcp.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCRtcpParameters const & currentValue = mRtcp.InternalValue();
      if (!currentValue.ToObjectInternal(cx, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->rtcp_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpParameters::TraceDictionary(JSTracer* trc)
{
}

RTCRtpParameters&
RTCRtpParameters::operator=(const RTCRtpParameters& aOther)
{
  DictionaryBase::operator=(aOther);
  mCodecs.Reset();
  if (aOther.mCodecs.WasPassed()) {
    mCodecs.Construct(aOther.mCodecs.Value());
  }
  mHeaderExtensions.Reset();
  if (aOther.mHeaderExtensions.WasPassed()) {
    mHeaderExtensions.Construct(aOther.mHeaderExtensions.Value());
  }
  mRtcp.Reset();
  if (aOther.mRtcp.WasPassed()) {
    mRtcp.Construct(aOther.mRtcp.Value());
  }
  return *this;
}



RTCRtpReceiveParameters::RTCRtpReceiveParameters()
  : RTCRtpParameters(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init();
}




bool
RTCRtpReceiveParameters::Init(const char* sourceDescription, bool passedToJSImpl)
{
  // We init the parent's members first
  if (!RTCRtpParameters::Init(nullptr, JS::NullHandleValue)) {
    return false;
  }

  return true;
}

bool
RTCRtpReceiveParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  // Per spec, we define the parent's members first
  if (!RTCRtpParameters::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());


  return true;
}

void
RTCRtpReceiveParameters::TraceDictionary(JSTracer* trc)
{
  RTCRtpParameters::TraceDictionary(trc);
}

RTCRtpReceiveParameters&
RTCRtpReceiveParameters::operator=(const RTCRtpReceiveParameters& aOther)
{
  RTCRtpParameters::operator=(aOther);
  return *this;
}



RTCRtpSendParameters::RTCRtpSendParameters()
  : RTCRtpParameters(FastDictionaryInitializer())
{
  // Safe to pass a null context if we pass a null value
  Init(nullptr, JS::NullHandleValue);
}




bool
RTCRtpSendParameters::InitIds(JSContext* cx, RTCRtpSendParametersAtoms* atomsCache)
{
  MOZ_ASSERT(reinterpret_cast<jsid*>(atomsCache)->isVoid());

  // Initialize these in reverse order so that any failure leaves the first one
  // uninitialized.
  if (!atomsCache->transactionId_id.init(cx, "transactionId") ||
      !atomsCache->encodings_id.init(cx, "encodings") ||
      !atomsCache->degradationPreference_id.init(cx, "degradationPreference")) {
    return false;
  }
  return true;
}

bool
RTCRtpSendParameters::Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // Passing a null JSContext is OK only if we're initing from null,
  // Since in that case we will not have to do any property gets
  // Also evaluate isNullOrUndefined in order to avoid false-positive
  // checkers by static analysis tools
  MOZ_ASSERT_IF(!cx, val.isNull() && val.isNullOrUndefined());
  RTCRtpSendParametersAtoms* atomsCache = nullptr;
  if (cx) {
    atomsCache = GetAtomCache<RTCRtpSendParametersAtoms>(cx);
    if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
        !InitIds(cx, atomsCache)) {
      return false;
    }
  }

  // Per spec, we init the parent's members first
  if (!RTCRtpParameters::Init(cx, val)) {
    return false;
  }

  bool isNull = val.isNullOrUndefined();
  // We only need these if !isNull, in which case we have |cx|.
  Maybe<JS::Rooted<JSObject *> > object;
  Maybe<JS::Rooted<JS::Value> > temp;
  if (!isNull) {
    MOZ_ASSERT(cx);
    object.emplace(cx, &val.toObject());
    temp.emplace(cx);
  }
  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->degradationPreference_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mDegradationPreference.Construct();
    {
      int index;
      if (!binding_detail::FindEnumStringIndex<true>(cx, temp.ref(),
                                                                         binding_detail::EnumStrings<RTCDegradationPreference>::Values,
                                                                         "RTCDegradationPreference", "'degradationPreference' member of RTCRtpSendParameters",
                                                                         &index)) {
        return false;
      }
      MOZ_ASSERT(index >= 0);
      (mDegradationPreference.Value()) = static_cast<RTCDegradationPreference>(index);
    }
    mIsAnyMemberPresent = true;
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->encodings_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    if (temp.ref().isObject()) {
      JS::ForOfIterator iter(cx);
      if (!iter.init(temp.ref(), JS::ForOfIterator::AllowNonIterable)) {
        return false;
      }
      if (!iter.valueIsIterable()) {
        cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'encodings' member of RTCRtpSendParameters", "sequence");
        return false;
      }
      Sequence<RTCRtpEncodingParameters> &arr = mEncodings;
      JS::Rooted<JS::Value> temp(cx);
      while (true) {
        bool done;
        if (!iter.next(&temp, &done)) {
          return false;
        }
        if (done) {
          break;
        }
        RTCRtpEncodingParameters* slotPtr = arr.AppendElement(mozilla::fallible);
        if (!slotPtr) {
          JS_ReportOutOfMemory(cx);
          return false;
        }
        RTCRtpEncodingParameters& slot = *slotPtr;
        if (!slot.Init(cx, temp, "Element of 'encodings' member of RTCRtpSendParameters", passedToJSImpl)) {
          return false;
        }
      }
    } else {
      cx.ThrowErrorMessage<MSG_CONVERSION_ERROR>("'encodings' member of RTCRtpSendParameters", "sequence");
      return false;
    }
    mIsAnyMemberPresent = true;
  } else if (cx) {
    // Don't error out if we have no cx.  In that
    // situation the caller is default-constructing us and we'll
    // just assume they know what they're doing.
    return cx.ThrowErrorMessage<MSG_MISSING_REQUIRED_DICTIONARY_MEMBER>("'encodings' member of RTCRtpSendParameters");
  }

  if (!isNull) {
    if (!JS_GetPropertyById(cx, *object, atomsCache->transactionId_id, temp.ptr())) {
      return false;
    }
  }
  if (!isNull && !temp->isUndefined()) {
    mTransactionId.Construct();
    if (!ConvertJSValueToString(cx, temp.ref(), eStringify, eStringify, (mTransactionId.Value()))) {
      return false;
    }
    mIsAnyMemberPresent = true;
  }
  return true;
}

bool
RTCRtpSendParameters::Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription, bool passedToJSImpl)
{
  // We don't want to use sourceDescription for our context here;
  // that's not really what it's formatted for.
  BindingCallContext cx(cx_, nullptr);
  return Init(cx, val, sourceDescription, passedToJSImpl);
}

bool
RTCRtpSendParameters::ToObjectInternal(JSContext* cx, JS::MutableHandle<JS::Value> rval) const
{
  RTCRtpSendParametersAtoms* atomsCache = GetAtomCache<RTCRtpSendParametersAtoms>(cx);
  if (reinterpret_cast<jsid*>(atomsCache)->isVoid() &&
      !InitIds(cx, atomsCache)) {
    return false;
  }

  // Per spec, we define the parent's members first
  if (!RTCRtpParameters::ToObjectInternal(cx, rval)) {
    return false;
  }
  JS::Rooted<JSObject*> obj(cx, &rval.toObject());

  if (mDegradationPreference.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      RTCDegradationPreference const & currentValue = mDegradationPreference.InternalValue();
      if (!ToJSValue(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->degradationPreference_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  do {
    // block for our 'break' successCode and scope for 'temp' and 'currentValue'
    JS::Rooted<JS::Value> temp(cx);
    Sequence<RTCRtpEncodingParameters> const & currentValue = mEncodings;

    uint32_t length = currentValue.Length();
    JS::Rooted<JSObject*> returnArray(cx, JS::NewArrayObject(cx, length));
    if (!returnArray) {
      return false;
    }
    // Scope for 'tmp'
    {
      JS::Rooted<JS::Value> tmp(cx);
      for (uint32_t sequenceIdx0 = 0; sequenceIdx0 < length; ++sequenceIdx0) {
        // Control block to let us common up the JS_DefineElement calls when there
        // are different ways to succeed at wrapping the object.
        do {
          if (!currentValue[sequenceIdx0].ToObjectInternal(cx, &tmp)) {
            return false;
          }
          break;
        } while (false);
        if (!JS_DefineElement(cx, returnArray, sequenceIdx0, tmp,
                              JSPROP_ENUMERATE)) {
          return false;
        }
      }
    }
    temp.setObject(*returnArray);
    if (!JS_DefinePropertyById(cx, obj, atomsCache->encodings_id, temp, JSPROP_ENUMERATE)) {
      return false;
    }
    break;
  } while(false);

  if (mTransactionId.WasPassed()) {
    do {
      // block for our 'break' successCode and scope for 'temp' and 'currentValue'
      JS::Rooted<JS::Value> temp(cx);
      nsString const & currentValue = mTransactionId.InternalValue();
      if (!xpc::NonVoidStringToJsval(cx, currentValue, &temp)) {
        return false;
      }
      if (!JS_DefinePropertyById(cx, obj, atomsCache->transactionId_id, temp, JSPROP_ENUMERATE)) {
        return false;
      }
      break;
    } while(false);
  }

  return true;
}

void
RTCRtpSendParameters::TraceDictionary(JSTracer* trc)
{
  RTCRtpParameters::TraceDictionary(trc);
}

RTCRtpSendParameters&
RTCRtpSendParameters::operator=(const RTCRtpSendParameters& aOther)
{
  RTCRtpParameters::operator=(aOther);
  mDegradationPreference.Reset();
  if (aOther.mDegradationPreference.WasPassed()) {
    mDegradationPreference.Construct(aOther.mDegradationPreference.Value());
  }
  mEncodings = aOther.mEncodings;
  mTransactionId.Reset();
  if (aOther.mTransactionId.WasPassed()) {
    mTransactionId.Construct(aOther.mTransactionId.Value());
  }
  return *this;
}


} // namespace dom


} // namespace mozilla
