
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "navigationbar_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_NavigationBar_Type = nullptr;
static PyTypeObject *Sbk_NavigationBar_TypeF(void)
{
    return _Sbk_NavigationBar_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void NavigationBarWrapper::pysideInitQtMetaTypes()
{
}

void NavigationBarWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

NavigationBarWrapper::NavigationBarWrapper(::BrowserWindow * window) : NavigationBar(window)
{
}

void NavigationBarWrapper::actionEvent(::QActionEvent * event)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::actionEvent(event);
    }
    WebViewWrapper::sbk_o_actionEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::changeEvent(::QEvent * event)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::changeEvent(event);
    }
    WebViewWrapper::sbk_o_changeEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("NavigationBar", funcName, gil, pyOverride, signal);
}

void NavigationBarWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("NavigationBar", funcName, gil, pyOverride, event);
}

int NavigationBarWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("NavigationBar", funcName, gil, pyOverride);
}

void NavigationBarWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("NavigationBar", funcName, gil, pyOverride, signal);
}

void NavigationBarWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::enterEvent(::QEnterEvent * event)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::enterEvent(event);
    }
    WebViewWrapper::sbk_o_enterEvent("NavigationBar", funcName, gil, pyOverride, event);
}

bool NavigationBarWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::event(event);
    }
    return WebViewWrapper::sbk_o_event("NavigationBar", funcName, gil, pyOverride, event);
}

bool NavigationBarWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("NavigationBar", funcName, gil, pyOverride, watched, event);
}

void NavigationBarWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("NavigationBar", funcName, gil, pyOverride, event);
}

bool NavigationBarWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("NavigationBar", funcName, gil, pyOverride, next);
}

void NavigationBarWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("NavigationBar", funcName, gil, pyOverride, event);
}

bool NavigationBarWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("NavigationBar", funcName, gil, pyOverride);
}

int NavigationBarWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("NavigationBar", funcName, gil, pyOverride, arg__1);
}

void NavigationBarWrapper::hideEvent(::QHideEvent * event)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hideEvent(event);
    }
    WebViewWrapper::sbk_o_hideEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("NavigationBar", funcName, gil, pyOverride, painter);
}

void NavigationBarWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("NavigationBar", funcName, gil, pyOverride, event);
}

::QVariant NavigationBarWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("NavigationBar", funcName, gil, pyOverride, arg__1);
}

void NavigationBarWrapper::keyPressEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyPressEvent(event);
    }
    WebViewWrapper::sbk_o_keyPressEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::leaveEvent(::QEvent * event)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::leaveEvent(event);
    }
    WebViewWrapper::sbk_o_leaveEvent("NavigationBar", funcName, gil, pyOverride, event);
}

int NavigationBarWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("NavigationBar", funcName, gil, pyOverride, arg__1);
}

::QSize NavigationBarWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("NavigationBar", funcName, gil, pyOverride);
}

void NavigationBarWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::mousePressEvent(::QMouseEvent * event)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mousePressEvent(event);
    }
    WebViewWrapper::sbk_o_mousePressEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("NavigationBar", funcName, gil, pyOverride, event);
}

bool NavigationBarWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("NavigationBar", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * NavigationBarWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("NavigationBar", funcName, gil, pyOverride);
}

void NavigationBarWrapper::paintEvent(::QPaintEvent * event)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEvent(event);
    }
    WebViewWrapper::sbk_o_paintEvent("NavigationBar", funcName, gil, pyOverride, event);
}

::QPaintDevice * NavigationBarWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("NavigationBar", funcName, gil, pyOverride, offset);
}

void NavigationBarWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("NavigationBar", funcName, gil, pyOverride, visible);
}

::QPainter * NavigationBarWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("NavigationBar", funcName, gil, pyOverride);
}

void NavigationBarWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("NavigationBar", funcName, gil, pyOverride, event);
}

::QSize NavigationBarWrapper::sizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("NavigationBar", funcName, gil, pyOverride);
}

void NavigationBarWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("NavigationBar", funcName, gil, pyOverride, event);
}

void NavigationBarWrapper::wheelEvent(::QWheelEvent * event)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_NavigationBar_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::wheelEvent(event);
    }
    WebViewWrapper::sbk_o_wheelEvent("NavigationBar", funcName, gil, pyOverride, event);
}

const QMetaObject *NavigationBarWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return NavigationBar::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int NavigationBarWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = NavigationBar::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *NavigationBarWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< NavigationBarWrapper *>(this));
    }
    return NavigationBar::qt_metacast(_clname);
}

NavigationBarWrapper::~NavigationBarWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_NavigationBar_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_NavigationBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::NavigationBar >()))
        return -1;

    NavigationBarWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "NavigationBar", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: NavigationBar::NavigationBar(BrowserWindow*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[0])))) {
        overloadId = 0; // NavigationBar(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::BrowserWindow *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // NavigationBar(BrowserWindow*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) NavigationBarWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new NavigationBarWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< NavigationBar >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);
    };


    return 1;
}

static PyObject *Sbk_NavigationBarFunc_addToolButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::addToolButton(AbstractButtonInterface*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), (pyArg)))) {
        overloadId = 0; // addToolButton(AbstractButtonInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addToolButton", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::AbstractButtonInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addToolButton(AbstractButtonInterface*)
            cppSelf->addToolButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_addWidget(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "addWidget", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: NavigationBar::addWidget(QWidget*,QString,QString)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArgs[2])))) {
        overloadId = 0; // addWidget(QWidget*,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "addWidget", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // addWidget(QWidget*,QString,QString)
            cppSelf->addWidget(cppArg0, cppArg1, cppArg2);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_enterFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // enterFullScreen()
        cppSelf->enterFullScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_goBack(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goBack()
        cppSelf->goBack();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_goBackInNewTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goBackInNewTab()
        cppSelf->goBackInNewTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_goForward(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goForward()
        cppSelf->goForward();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_goForwardInNewTab(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // goForwardInNewTab()
        cppSelf->goForwardInNewTab();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_layoutMargin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // layoutMargin()const
        int cppResult = const_cast<const NavigationBarWrapper *>(cppSelf)->layoutMargin();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NavigationBarFunc_layoutSpacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // layoutSpacing()const
        int cppResult = const_cast<const NavigationBarWrapper *>(cppSelf)->layoutSpacing();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NavigationBarFunc_leaveFullScreen(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // leaveFullScreen()
        cppSelf->leaveFullScreen();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_reload(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // reload()
        cppSelf->reload();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_removeToolButton(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::removeToolButton(AbstractButtonInterface*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_AbstractButtonInterface_IDX]), (pyArg)))) {
        overloadId = 0; // removeToolButton(AbstractButtonInterface*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeToolButton", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::AbstractButtonInterface *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeToolButton(AbstractButtonInterface*)
            cppSelf->removeToolButton(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_removeWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::removeWidget(QString)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], (pyArg)))) {
        overloadId = 0; // removeWidget(QString)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeWidget", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeWidget(QString)
            cppSelf->removeWidget(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_setCurrentView(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::setCurrentView(TabbedWebView*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabbedWebView_IDX]), (pyArg)))) {
        overloadId = 0; // setCurrentView(TabbedWebView*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setCurrentView", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::TabbedWebView *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setCurrentView(TabbedWebView*)
            cppSelf->setCurrentView(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_setLayoutMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::setLayoutMargin(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayoutMargin(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLayoutMargin", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLayoutMargin(int)
            cppSelf->setLayoutMargin(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_setLayoutSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::setLayoutSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setLayoutSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setLayoutSpacing", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setLayoutSpacing(int)
            cppSelf->setLayoutSpacing(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_setSplitterSizes(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setSplitterSizes", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: NavigationBar::setSplitterSizes(int,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setSplitterSizes(int,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setSplitterSizes", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSplitterSizes(int,int)
            cppSelf->setSplitterSizes(cppArg0, cppArg1);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_setSuperMenuVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: NavigationBar::setSuperMenuVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setSuperMenuVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setSuperMenuVisible", errInfo, SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setSuperMenuVisible(bool)
            cppSelf->setSuperMenuVisible(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_showReloadButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showReloadButton()
        cppSelf->showReloadButton();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_showStopButton(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // showStopButton()
        cppSelf->showStopButton();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_NavigationBarFunc_splitter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // splitter()
        QSplitter * cppResult = cppSelf->splitter();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QSplitter_IDX]), cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_NavigationBarFunc_stop(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<NavigationBarWrapper *>(reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // stop()
        cppSelf->stop();
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_NavigationBar_PropertyStrings[] = {
    "layoutMargin::",
    "layoutSpacing::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_NavigationBar_methods[] = {
    {"addToolButton", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_addToolButton), METH_O, nullptr},
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_addWidget), METH_VARARGS, nullptr},
    {"enterFullScreen", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_enterFullScreen), METH_NOARGS, nullptr},
    {"goBack", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_goBack), METH_NOARGS, nullptr},
    {"goBackInNewTab", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_goBackInNewTab), METH_NOARGS, nullptr},
    {"goForward", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_goForward), METH_NOARGS, nullptr},
    {"goForwardInNewTab", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_goForwardInNewTab), METH_NOARGS, nullptr},
    {"layoutMargin", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_layoutMargin), METH_NOARGS, nullptr},
    {"layoutSpacing", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_layoutSpacing), METH_NOARGS, nullptr},
    {"leaveFullScreen", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_leaveFullScreen), METH_NOARGS, nullptr},
    {"reload", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_reload), METH_NOARGS, nullptr},
    {"removeToolButton", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_removeToolButton), METH_O, nullptr},
    {"removeWidget", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_removeWidget), METH_O, nullptr},
    {"setCurrentView", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_setCurrentView), METH_O, nullptr},
    {"setLayoutMargin", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_setLayoutMargin), METH_O, nullptr},
    {"setLayoutSpacing", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_setLayoutSpacing), METH_O, nullptr},
    {"setSplitterSizes", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_setSplitterSizes), METH_VARARGS, nullptr},
    {"setSuperMenuVisible", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_setSuperMenuVisible), METH_O, nullptr},
    {"showReloadButton", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_showReloadButton), METH_NOARGS, nullptr},
    {"showStopButton", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_showStopButton), METH_NOARGS, nullptr},
    {"splitter", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_splitter), METH_NOARGS, nullptr},
    {"stop", reinterpret_cast<PyCFunction>(Sbk_NavigationBarFunc_stop), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_NavigationBar_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::NavigationBar *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<NavigationBarWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_NavigationBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_NavigationBar_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_NavigationBarSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::NavigationBar *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_NavigationBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_NavigationBar_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_NavigationBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_NavigationBar_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_NavigationBar_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_NavigationBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_NavigationBar_spec = {
    "1:PyFalkon.NavigationBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_NavigationBar_slots
};

} //extern "C"

static void *Sbk_NavigationBar_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::NavigationBar *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::NavigationBar *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::NavigationBar *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void NavigationBar_PythonToCpp_NavigationBar_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_NavigationBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_NavigationBar_PythonToCpp_NavigationBar_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_NavigationBar_TypeF()))
        return NavigationBar_PythonToCpp_NavigationBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *NavigationBar_PTR_CppToPython_NavigationBar(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::NavigationBar *>(const_cast<void *>(cppIn)), Sbk_NavigationBar_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *NavigationBar_SignatureStrings[] = {
    "PyFalkon.NavigationBar(self,window:PyFalkon.BrowserWindow,*:KeywordOnly=None,layoutMargin:int=None,layoutSpacing:int=None)",
    "PyFalkon.NavigationBar.addToolButton(self,button:PyFalkon.AbstractButtonInterface)",
    "PyFalkon.NavigationBar.addWidget(self,widget:PySide6.QtWidgets.QWidget,id:QString,name:QString)",
    "PyFalkon.NavigationBar.enterFullScreen(self)",
    "PyFalkon.NavigationBar.goBack(self)",
    "PyFalkon.NavigationBar.goBackInNewTab(self)",
    "PyFalkon.NavigationBar.goForward(self)",
    "PyFalkon.NavigationBar.goForwardInNewTab(self)",
    "PyFalkon.NavigationBar.layoutMargin(self)->int",
    "PyFalkon.NavigationBar.layoutSpacing(self)->int",
    "PyFalkon.NavigationBar.leaveFullScreen(self)",
    "PyFalkon.NavigationBar.reload(self)",
    "PyFalkon.NavigationBar.removeToolButton(self,button:PyFalkon.AbstractButtonInterface)",
    "PyFalkon.NavigationBar.removeWidget(self,id:QString)",
    "PyFalkon.NavigationBar.setCurrentView(self,view:PyFalkon.TabbedWebView)",
    "PyFalkon.NavigationBar.setLayoutMargin(self,margin:int)",
    "PyFalkon.NavigationBar.setLayoutSpacing(self,spacing:int)",
    "PyFalkon.NavigationBar.setSplitterSizes(self,locationBar:int,websearchBar:int)",
    "PyFalkon.NavigationBar.setSuperMenuVisible(self,visible:bool)",
    "PyFalkon.NavigationBar.showReloadButton(self)",
    "PyFalkon.NavigationBar.showStopButton(self)",
    "PyFalkon.NavigationBar.splitter(self)->PySide6.QtWidgets.QSplitter",
    "PyFalkon.NavigationBar.stop(self)",
    nullptr}; // Sentinel
#else
static constexpr size_t NavigationBar_SignatureByteSize = 382;
static constexpr uint8_t NavigationBar_SignatureBytes[382] = {
    0x78, 0xda, 0xad, 0x54, 0xc1, 0x6e, 0x83, 0x30, 0x0c, 0xbd, 0xef, 0x4b, 0xb6, 0x89, 0x71, 0xdc,
    0x01, 0x69, 0x93, 0xd6, 0x49, 0x95, 0xaa, 0xad, 0x5d, 0x3b, 0xaa, 0xf6, 0x6c, 0x88, 0x4b, 0xa3,
    0xa6, 0x31, 0x4a, 0x02, 0x51, 0xf7, 0xf5, 0x0b, 0x04, 0x5a, 0x34, 0x15, 0xca, 0x61, 0x37, 0xc7,
    0xbc, 0xf7, 0xec, 0xf8, 0x39, 0x2c, 0x4f, 0x53, 0x10, 0x07, 0x92, 0xe1, 0x02, 0x4a, 0x9e, 0x81,
    0xe1, 0x24, 0x27, 0xa0, 0xee, 0x35, 0x8a, 0x5d, 0x60, 0xb9, 0x64, 0x64, 0xa3, 0x65, 0x0b, 0x99,
    0x28, 0xb2, 0x1a, 0xd5, 0xb6, 0x4e, 0x07, 0x8f, 0xd1, 0x07, 0x9e, 0x2c, 0x29, 0xf6, 0x25, 0xc5,
    0xe9, 0x65, 0x41, 0x12, 0x03, 0x01, 0x27, 0x2a, 0xcc, 0x1c, 0x54, 0xc6, 0x65, 0xc4, 0xa5, 0xe9,
    0x66, 0xe3, 0x1c, 0x52, 0x2e, 0xb3, 0x73, 0xfa, 0xe1, 0x6e, 0x79, 0xb5, 0x74, 0x08, 0x8c, 0xad,
    0x89, 0xc4, 0xa4, 0x30, 0x86, 0xa4, 0x6f, 0x24, 0xa9, 0xe3, 0x4b, 0x23, 0x6f, 0x89, 0x36, 0x0a,
    0x52, 0xe3, 0x31, 0x33, 0x69, 0x50, 0xed, 0x20, 0x1d, 0x94, 0xdc, 0x72, 0x96, 0xa1, 0x69, 0xef,
    0x55, 0xc5, 0x4e, 0x2e, 0xe6, 0x0c, 0x9f, 0xc3, 0x95, 0xf1, 0x1f, 0x75, 0xb8, 0xf2, 0x41, 0xc0,
    0x59, 0xb4, 0x8a, 0x8d, 0x72, 0xed, 0x06, 0x12, 0x8e, 0xd8, 0x1e, 0x7a, 0xf5, 0xb1, 0xea, 0x60,
    0x5a, 0x08, 0x11, 0xa7, 0x0a, 0xd1, 0x37, 0xdd, 0x0b, 0xce, 0x68, 0x02, 0xe9, 0x61, 0x0c, 0x66,
    0x26, 0x17, 0x68, 0xd7, 0x90, 0xdc, 0xc2, 0x4e, 0x49, 0x59, 0x50, 0x6c, 0x24, 0x6c, 0x9c, 0x6a,
    0xd7, 0x4a, 0x8f, 0x7c, 0x7a, 0x75, 0xd6, 0x0d, 0xc3, 0x1b, 0x8f, 0xc7, 0xe0, 0x11, 0x4a, 0x1c,
    0x3b, 0x31, 0x85, 0x82, 0x80, 0xdd, 0xc2, 0x1c, 0xa9, 0xc4, 0xff, 0x5e, 0x1c, 0xaf, 0xda, 0xdd,
    0x9d, 0xcb, 0x6a, 0xf4, 0x92, 0x34, 0x9a, 0xf7, 0x42, 0x29, 0xb7, 0x14, 0x1b, 0x8e, 0xd6, 0xd3,
    0x4a, 0x17, 0x5d, 0xda, 0x70, 0xd3, 0x4f, 0x90, 0x6d, 0x31, 0xa9, 0x00, 0x43, 0x3a, 0x9f, 0x7f,
    0x5d, 0x08, 0x8e, 0xe7, 0xc7, 0x75, 0x9b, 0xd7, 0xb5, 0x23, 0xd0, 0x97, 0xf7, 0x37, 0xc4, 0x8c,
    0x73, 0xc1, 0x8d, 0x1b, 0x4b, 0xcc, 0x7f, 0x50, 0x7b, 0xa6, 0xa0, 0xb4, 0x45, 0x54, 0xec, 0xc0,
    0x62, 0xa2, 0x11, 0x54, 0xba, 0x6f, 0x12, 0x83, 0x72, 0x45, 0x8e, 0x6a, 0x8e, 0xb2, 0xd8, 0x70,
    0xcd, 0x13, 0x81, 0xed, 0x34, 0xea, 0x43, 0x94, 0x38, 0xbb, 0xfa, 0xd9, 0x7b, 0xb2, 0xdf, 0xb5,
    0xf3, 0x1d, 0x47, 0x07, 0xd1, 0xb1, 0xa1, 0x7c, 0x14, 0xb6, 0xb9, 0x63, 0xbb, 0xa7, 0x57, 0x7e,
    0x04, 0xed, 0x18, 0x7a, 0x25, 0x5c, 0xa9, 0xa6, 0xc8, 0x2f, 0xeb, 0x58, 0xf5, 0xad
};
#endif

PyTypeObject *init_NavigationBar(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX].type;

    Shiboken::AutoDecRef Sbk_NavigationBar_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))));

    _Sbk_NavigationBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "NavigationBar",
        "NavigationBar*",
        &Sbk_NavigationBar_spec,
        &Shiboken::callCppDestructor< NavigationBar >,
        Sbk_NavigationBar_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_NavigationBar_Type; // references _Sbk_NavigationBar_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, NavigationBar_SignatureStrings);
#else
    InitSignatureBytes(pyType, NavigationBar_SignatureBytes, NavigationBar_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_NavigationBar_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_NavigationBar_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        NavigationBar_PythonToCpp_NavigationBar_PTR,
        is_NavigationBar_PythonToCpp_NavigationBar_PTR_Convertible,
        NavigationBar_PTR_CppToPython_NavigationBar);

    Shiboken::Conversions::registerConverterName(converter, "NavigationBar");
    Shiboken::Conversions::registerConverterName(converter, "NavigationBar*");
    Shiboken::Conversions::registerConverterName(converter, "NavigationBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::NavigationBar).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(NavigationBarWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_NavigationBar_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_NavigationBar_TypeF(), &Sbk_NavigationBarSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_NavigationBar_TypeF(), &Sbk_NavigationBar_typeDiscovery);

    NavigationBarWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::NavigationBar::staticMetaObject, sizeof(NavigationBarWrapper));

    return pyType;
}
