
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "loadrequest_wrapper.h"

// Argument includes
#include <QString>
#include <loadrequest.h>
#include <qbytearray.h>
#include <qurl.h>
#include <qwebenginehttprequest.h>

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_LoadRequest_Type = nullptr;
static PyTypeObject *Sbk_LoadRequest_TypeF(void)
{
    return _Sbk_LoadRequest_Type;
}
} // extern "C"


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_LoadRequest_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::LoadRequest >()))
        return -1;

    ::LoadRequest *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:LoadRequest", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: LoadRequest::LoadRequest()
    // 1: LoadRequest::LoadRequest(LoadRequest)
    // 2: LoadRequest::LoadRequest(QUrl,LoadRequest::Operation=,const QByteArray&=)
    if (numArgs == 0) {
        overloadId = 0; // LoadRequest()
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX])))->converter, (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[2])))) {
                overloadId = 2; // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
            }
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), (pyArgs[0])))) {
        overloadId = 1; // LoadRequest(LoadRequest)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    switch (overloadId) {
        case 0: // LoadRequest()
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);
            }

            // LoadRequest()
            cptr = new ::LoadRequest();
            break;
        }
        case 1: // LoadRequest(const LoadRequest &other)
        {
            if (kwds != nullptr && PyDict_Size(kwds) > 0) {
                errInfo.reset(kwds);
                Py_INCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::LoadRequest cppArg0_local;
            ::LoadRequest *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // LoadRequest(LoadRequest)
                cptr = new ::LoadRequest(*cppArg0);
            }
            break;
        }
        case 2: // LoadRequest(const QUrl &url, LoadRequest::Operation op, const QByteArray &data)
        {
            if (kwds && PyDict_Size(kwds) > 0) {
                static const Shiboken::ArgumentNameIndexMapping mapping[2] = {{"op", 1}, {"data", 2}};
                if (!Shiboken::parseKeywordArguments(kwds, mapping, 2, errInfo, pyArgs)
                    || (pyArgs[1] != nullptr && !(pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX])))->converter, (pyArgs[1]))))
                    || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArgs[2]))))) {
                    Py_XINCREF(errInfo.object());
                    return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            ::LoadRequest::Operation cppArg1(LoadRequest::Operation::GetOperation);
            if (pythonToCpp[1])
                pythonToCpp[1](pyArgs[1], &cppArg1);
            if (!Shiboken::Object::isValid(pyArgs[2]))
                return -1;
            ::QByteArray cppArg2_local = QByteArray();
            ::QByteArray *cppArg2 = &cppArg2_local;
            if (pythonToCpp[2]) {
                if (pythonToCpp[2].isValue())
                    pythonToCpp[2](pyArgs[2], &cppArg2_local);
                else
                    pythonToCpp[2](pyArgs[2], &cppArg2);
                }

            if (Shiboken::Errors::occurred() == nullptr) {
                // LoadRequest(QUrl,LoadRequest::Operation,QByteArray)
                cptr = new ::LoadRequest(*cppArg0, cppArg1, *cppArg2);
            }
            break;
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::LoadRequest >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_LoadRequestFunc_data(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // data()const
        QByteArray cppResult = const_cast<const ::LoadRequest *>(cppSelf)->data();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequestFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isValid()const
        bool cppResult = const_cast<const ::LoadRequest *>(cppSelf)->isValid();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequestFunc_operation(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // operation()const
        LoadRequest::Operation cppResult = LoadRequest::Operation(const_cast<const ::LoadRequest *>(cppSelf)->operation());
        pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX])))->converter, &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequestFunc_setData(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setData(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QByteArray_IDX]), (pyArg)))) {
        overloadId = 0; // setData(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setData", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setData(QByteArray)
            cppSelf->setData(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LoadRequestFunc_setOperation(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setOperation(LoadRequest::Operation)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX])))->converter, (pyArg)))) {
        overloadId = 0; // setOperation(LoadRequest::Operation)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setOperation", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);

    // Call function/method
    {
        ::LoadRequest::Operation cppArg0{LoadRequest::GetOperation};
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setOperation(LoadRequest::Operation)
            cppSelf->setOperation(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LoadRequestFunc_setUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: LoadRequest::setUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // setUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setUrl", errInfo, SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // setUrl(QUrl)
            cppSelf->setUrl(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_LoadRequestFunc_url(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // url()const
        QUrl cppResult = const_cast<const ::LoadRequest *>(cppSelf)->url();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequestFunc_urlString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // urlString()const
        QString cppResult = const_cast<const ::LoadRequest *>(cppSelf)->urlString();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequestFunc_webRequest(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // webRequest()const
        QWebEngineHttpRequest* cppResult = new QWebEngineHttpRequest(const_cast<const ::LoadRequest *>(cppSelf)->webRequest());
        pyResult = Shiboken::Object::newObject(Shiboken::Module::get(SbkPySide6_QtWebEngineCoreTypeStructs[SBK_QWebEngineHttpRequest_IDX]), cppResult, true, true);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_LoadRequest__copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), &cppSelf);
    if (Shiboken::Errors::occurred() != nullptr || pyResult == nullptr) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_LoadRequest_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_LoadRequest_EnumFlagInfo[] = {
    "Operation:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_LoadRequest_methods[] = {
    {"data", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_data), METH_NOARGS, nullptr},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_isValid), METH_NOARGS, nullptr},
    {"operation", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_operation), METH_NOARGS, nullptr},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setData), METH_O, nullptr},
    {"setOperation", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setOperation), METH_O, nullptr},
    {"setUrl", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_setUrl), METH_O, nullptr},
    {"url", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_url), METH_NOARGS, nullptr},
    {"urlString", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_urlString), METH_NOARGS, nullptr},
    {"webRequest", reinterpret_cast<PyCFunction>(Sbk_LoadRequestFunc_webRequest), METH_NOARGS, nullptr},
    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_LoadRequest__copy__), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_LoadRequest_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_LoadRequest_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_LoadRequest_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_LoadRequest_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_LoadRequest_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_LoadRequest_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_LoadRequest_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_LoadRequest_spec = {
    "1:PyFalkon.LoadRequest",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_LoadRequest_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_LoadRequest_Operation(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::LoadRequest::Operation>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::LoadRequest::Operation *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_LoadRequest_Operation_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX])))
        return Enum_PythonToCpp_LoadRequest_Operation;
    return {};
}

static PyObject *LoadRequest_Operation_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::LoadRequest::Operation>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::LoadRequest::Operation *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void LoadRequest_PythonToCpp_LoadRequest_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_LoadRequest_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_LoadRequest_PythonToCpp_LoadRequest_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_LoadRequest_TypeF()))
        return LoadRequest_PythonToCpp_LoadRequest_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *LoadRequest_PTR_CppToPython_LoadRequest(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_LoadRequest_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    return Shiboken::Object::newObjectWithHeuristics(Sbk_LoadRequest_TypeF(), const_cast<void *>(cppIn), false);

}

// C++ to Python copy conversion.
static PyObject *LoadRequest_COPY_CppToPython_LoadRequest(const void *cppIn)
{
    auto *source = reinterpret_cast<const ::LoadRequest *>(cppIn);
    return Shiboken::Object::newObject(Sbk_LoadRequest_TypeF(), new ::LoadRequest(*source), true, true);
}

// Python to C++ copy conversion.
static void LoadRequest_PythonToCpp_LoadRequest_COPY(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::LoadRequest *>(cppOut) = *reinterpret_cast< ::LoadRequest *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX]), reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_LoadRequest_PythonToCpp_LoadRequest_COPY_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Sbk_LoadRequest_TypeF()))
        return LoadRequest_PythonToCpp_LoadRequest_COPY;
    return {};
}

// Implicit conversions.
static void PySide6_QtCore_constQUrlREF_PythonToCpp_LoadRequest(PyObject *pyIn, void *cppOut)
{
    *reinterpret_cast<::LoadRequest *>(cppOut) = ::LoadRequest( *reinterpret_cast< ::QUrl *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_PySide6_QtCore_constQUrlREF_PythonToCpp_LoadRequest_Convertible(PyObject *pyIn)
{
    if (SbkObject_TypeCheck(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), pyIn))
        return PySide6_QtCore_constQUrlREF_PythonToCpp_LoadRequest;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *LoadRequest_SignatureStrings[] = {
    "2:PyFalkon.LoadRequest(self)",
    "1:PyFalkon.LoadRequest(self,other:PyFalkon.LoadRequest)",
    "0:PyFalkon.LoadRequest(self,url:typing.Union[PySide6.QtCore.QUrl, QString],op:PyFalkon.LoadRequest.Operation=LoadRequest.Operation.GetOperation,data:typing.Union[PySide6.QtCore.QByteArray, char*]=QByteArray())",
    "PyFalkon.LoadRequest.data(self)->PySide6.QtCore.QByteArray",
    "PyFalkon.LoadRequest.isValid(self)->bool",
    "PyFalkon.LoadRequest.operation(self)->PyFalkon.LoadRequest.Operation",
    "PyFalkon.LoadRequest.setData(self,data:typing.Union[PySide6.QtCore.QByteArray, char*])",
    "PyFalkon.LoadRequest.setOperation(self,op:PyFalkon.LoadRequest.Operation)",
    "PyFalkon.LoadRequest.setUrl(self,url:typing.Union[PySide6.QtCore.QUrl, QString])",
    "PyFalkon.LoadRequest.url(self)->PySide6.QtCore.QUrl",
    "PyFalkon.LoadRequest.urlString(self)->QString",
    "PyFalkon.LoadRequest.webRequest(self)->PySide6.QtWebEngineCore.QWebEngineHttpRequest",
    "PyFalkon.LoadRequest.__copy__(self)->typing._Self",
    nullptr}; // Sentinel
#else
static constexpr size_t LoadRequest_SignatureByteSize = 273;
static constexpr uint8_t LoadRequest_SignatureBytes[273] = {
    0x78, 0xda, 0x9d, 0x93, 0x4d, 0x4b, 0x03, 0x31, 0x10, 0x86, 0xef, 0xfb, 0x2b, 0x7a, 0x6c, 0x24,
    0x86, 0xea, 0xc1, 0x43, 0xa1, 0x82, 0x5a, 0x3f, 0x0e, 0x42, 0xbb, 0x2e, 0xd5, 0x83, 0x94, 0x90,
    0xed, 0x8e, 0x6d, 0x30, 0x24, 0x31, 0x3b, 0x8b, 0xe4, 0xdf, 0x1b, 0xd9, 0xdd, 0xd6, 0x42, 0xb2,
    0x42, 0x8f, 0x33, 0x99, 0xf7, 0x79, 0x27, 0x33, 0xc9, 0xe5, 0x74, 0xe9, 0x1f, 0x84, 0xfa, 0x34,
    0x9a, 0x3d, 0x1b, 0x51, 0xbd, 0xc0, 0x57, 0x03, 0x35, 0x8e, 0x6b, 0x50, 0x1f, 0x24, 0xbb, 0x48,
    0x1f, 0x52, 0x83, 0x3b, 0x70, 0xd1, 0x73, 0x92, 0x4d, 0x06, 0x74, 0x8d, 0x53, 0x53, 0xf4, 0x56,
    0xea, 0x2d, 0x5b, 0x69, 0x69, 0xf4, 0xfb, 0xd2, 0x17, 0xb2, 0x82, 0x2b, 0x96, 0xe3, 0x9d, 0x71,
    0xc0, 0xf2, 0x95, 0x53, 0x74, 0x94, 0x17, 0xe8, 0x42, 0xc9, 0x9a, 0x1a, 0x1b, 0x65, 0xb1, 0x85,
    0x05, 0x27, 0x30, 0xe8, 0x67, 0xd1, 0x2c, 0x7b, 0x04, 0xdc, 0x07, 0xb4, 0x12, 0x28, 0x86, 0x4d,
    0x6f, 0x3d, 0xc2, 0x8d, 0x73, 0xc2, 0xd3, 0xd1, 0x66, 0x27, 0xdc, 0xd9, 0x7a, 0x76, 0x48, 0x8d,
    0x09, 0xc9, 0xa2, 0x3d, 0xfc, 0x62, 0xdb, 0x49, 0x9d, 0x5f, 0x27, 0x81, 0x71, 0xa9, 0xac, 0x5f,
    0x85, 0x92, 0x55, 0xaf, 0x2e, 0x8d, 0x51, 0xf1, 0x42, 0xd3, 0x5f, 0xe2, 0x60, 0x34, 0x34, 0x8d,
    0x38, 0xa4, 0x06, 0x9c, 0xf7, 0xbd, 0x9e, 0x32, 0x0c, 0x92, 0xc4, 0x2e, 0x8e, 0xda, 0xfb, 0x7f,
    0x5b, 0x69, 0x52, 0x58, 0xfb, 0x29, 0x0f, 0x24, 0x01, 0x6c, 0x3a, 0x5a, 0x64, 0x33, 0x41, 0x9e,
    0xd4, 0xb4, 0xd0, 0x5e, 0xd9, 0x79, 0xc4, 0xab, 0xbf, 0xa1, 0x3c, 0xfa, 0x2c, 0x7f, 0x8d, 0xde,
    0xa0, 0xbc, 0xd7, 0x5b, 0xa9, 0xa1, 0x75, 0xdc, 0x87, 0x4f, 0x88, 0xb6, 0x13, 0xc5, 0xa1, 0x9c,
    0x6f, 0x8c, 0xf5, 0x9c, 0xf7, 0xc8, 0x6e, 0x0e, 0xbc, 0x08, 0x61, 0xf6, 0x03, 0xca, 0x18, 0x56,
    0x9b
};
#endif

PyTypeObject *init_LoadRequest(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX].type;

    Shiboken::AutoDecRef Sbk_LoadRequest_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_LoadRequest_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "LoadRequest",
        "LoadRequest",
        &Sbk_LoadRequest_spec,
        &Shiboken::callCppDestructor< ::LoadRequest >,
        Sbk_LoadRequest_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::Value);
    auto *pyType = _Sbk_LoadRequest_Type; // references _Sbk_LoadRequest_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, LoadRequest_SignatureStrings);
#else
    InitSignatureBytes(pyType, LoadRequest_SignatureBytes, LoadRequest_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_LoadRequest_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_LoadRequest_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        LoadRequest_PythonToCpp_LoadRequest_PTR,
        is_LoadRequest_PythonToCpp_LoadRequest_PTR_Convertible,
        LoadRequest_PTR_CppToPython_LoadRequest,
        LoadRequest_COPY_CppToPython_LoadRequest);

    Shiboken::Conversions::registerConverterName(converter, "LoadRequest");
    Shiboken::Conversions::registerConverterName(converter, "LoadRequest*");
    Shiboken::Conversions::registerConverterName(converter, "LoadRequest&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::LoadRequest).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        LoadRequest_PythonToCpp_LoadRequest_COPY,
        is_LoadRequest_PythonToCpp_LoadRequest_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide6_QtCore_constQUrlREF_PythonToCpp_LoadRequest,
        is_PySide6_QtCore_constQUrlREF_PythonToCpp_LoadRequest_Convertible);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_LoadRequest_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Operation'.
    const char *Operation_Initializer[] = {
        "GetOperation",
        "PostOperation",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Operation_InitializerValues[] = {
        uint8_t(LoadRequest::Operation::GetOperation), //  0x00  0
        uint8_t(LoadRequest::Operation::PostOperation) //  0x01  1
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_LoadRequest_TypeF(),
        "1:PyFalkon.LoadRequest.Operation",
        Operation_Initializer, Operation_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_LoadRequest_Operation_IDX].type = EType;
    // Register converter for enum 'LoadRequest::Operation'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            LoadRequest_Operation_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_LoadRequest_Operation,
            is_Enum_PythonToCpp_LoadRequest_Operation_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "LoadRequest::Operation");
        Shiboken::Conversions::registerConverterAlias(converter, "Operation");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Operation' enum.

    qRegisterMetaType< ::LoadRequest >("LoadRequest");
    qRegisterMetaType< ::LoadRequest::Operation >("LoadRequest::Operation");

    return pyType;
}
