
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "historymodel_wrapper.h"

// Wrappers providing overrides
#include "tabtreemodel_wrapper.h"
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_HistoryModel_Type = nullptr;
static PyTypeObject *Sbk_HistoryModel_TypeF(void)
{
    return _Sbk_HistoryModel_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void HistoryModelWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::HistoryModel::Roles >("HistoryModel::Roles");
}

void HistoryModelWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

HistoryModelWrapper::HistoryModelWrapper(::History * history) : HistoryModel(history)
{
}

::QModelIndex HistoryModelWrapper::buddy(const ::QModelIndex & index) const
{
    static const char *funcName = "buddy";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::buddy(index);
    }
    return TabTreeModelWrapper::sbk_o_buddy("HistoryModel", funcName, gil, pyOverride, index);
}

bool HistoryModelWrapper::canDropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "canDropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::canDropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("HistoryModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool HistoryModelWrapper::canFetchMore(const ::QModelIndex & parent) const
{
    static const char *funcName = "canFetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::canFetchMore(parent);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("HistoryModel", funcName, gil, pyOverride, parent);
}

void HistoryModelWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("HistoryModel", funcName, gil, pyOverride, event);
}

bool HistoryModelWrapper::clearItemData(const ::QModelIndex & index)
{
    static const char *funcName = "clearItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::clearItemData(index);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("HistoryModel", funcName, gil, pyOverride, index);
}

int HistoryModelWrapper::columnCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "columnCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::columnCount(parent);
    }
    return TabTreeModelWrapper::sbk_o_columnCount("HistoryModel", funcName, gil, pyOverride, parent);
}

void HistoryModelWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("HistoryModel", funcName, gil, pyOverride, signal);
}

void HistoryModelWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("HistoryModel", funcName, gil, pyOverride, event);
}

::QVariant HistoryModelWrapper::data(const ::QModelIndex & index, int role) const
{
    static const char *funcName = "data";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::data(index, role);
    }
    return TabTreeModelWrapper::sbk_o_data("HistoryModel", funcName, gil, pyOverride, index, role);
}

void HistoryModelWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("HistoryModel", funcName, gil, pyOverride, signal);
}

bool HistoryModelWrapper::dropMimeData(const ::QMimeData * data, ::Qt::DropAction action, int row, int column, const ::QModelIndex & parent)
{
    static const char *funcName = "dropMimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::dropMimeData(data, action, row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_canDropMimeData("HistoryModel", funcName, gil, pyOverride, data, action, row, column, parent);
}

bool HistoryModelWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("HistoryModel", funcName, gil, pyOverride, event);
}

bool HistoryModelWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("HistoryModel", funcName, gil, pyOverride, watched, event);
}

void HistoryModelWrapper::fetchMore(const ::QModelIndex & parent)
{
    static const char *funcName = "fetchMore";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::fetchMore(parent);
    }
    TabTreeModelWrapper::sbk_o_fetchMore("HistoryModel", funcName, gil, pyOverride, parent);
}

::QFlags<Qt::ItemFlag> HistoryModelWrapper::flags(const ::QModelIndex & index) const
{
    static const char *funcName = "flags";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::flags(index);
    }
    return TabTreeModelWrapper::sbk_o_flags("HistoryModel", funcName, gil, pyOverride, index);
}

bool HistoryModelWrapper::hasChildren(const ::QModelIndex & parent) const
{
    static const char *funcName = "hasChildren";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::hasChildren(parent);
    }
    return TabTreeModelWrapper::sbk_o_canFetchMore("HistoryModel", funcName, gil, pyOverride, parent);
}

::QVariant HistoryModelWrapper::headerData(int section, ::Qt::Orientation orientation, int role) const
{
    static const char *funcName = "headerData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::headerData(section, orientation, role);
    }
    return TabTreeModelWrapper::sbk_o_headerData("HistoryModel", funcName, gil, pyOverride, section, orientation, role);
}

::QModelIndex HistoryModelWrapper::index(int row, int column, const ::QModelIndex & parent) const
{
    static const char *funcName = "index";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::index(row, column, parent);
    }
    return TabTreeModelWrapper::sbk_o_index("HistoryModel", funcName, gil, pyOverride, row, column, parent);
}

bool HistoryModelWrapper::insertColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("HistoryModel", funcName, gil, pyOverride, column, count, parent);
}

bool HistoryModelWrapper::insertRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "insertRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::insertRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("HistoryModel", funcName, gil, pyOverride, row, count, parent);
}

::QMap<int,QVariant> HistoryModelWrapper::itemData(const ::QModelIndex & index) const
{
    static const char *funcName = "itemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::itemData(index);
    }
    return TabTreeModelWrapper::sbk_o_itemData("HistoryModel", funcName, gil, pyOverride, index);
}

::QList<QModelIndex> HistoryModelWrapper::match(const ::QModelIndex & start, int role, const ::QVariant & value, int hits, ::QFlags<Qt::MatchFlag> flags) const
{
    static const char *funcName = "match";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::match(start, role, value, hits, flags);
    }
    return TabTreeModelWrapper::sbk_o_match("HistoryModel", funcName, gil, pyOverride, start, role, value, hits, flags);
}

::QMimeData * HistoryModelWrapper::mimeData(const ::QList<QModelIndex> & indexes) const
{
    static const char *funcName = "mimeData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeData(indexes);
    }
    return TabTreeModelWrapper::sbk_o_mimeData("HistoryModel", funcName, gil, pyOverride, indexes);
}

::QStringList HistoryModelWrapper::mimeTypes() const
{
    static const char *funcName = "mimeTypes";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::mimeTypes();
    }
    return TabTreeModelWrapper::sbk_o_mimeTypes("HistoryModel", funcName, gil, pyOverride);
}

bool HistoryModelWrapper::moveColumns(const ::QModelIndex & sourceParent, int sourceColumn, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveColumns(sourceParent, sourceColumn, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("HistoryModel", funcName, gil, pyOverride, sourceParent, sourceColumn, count, destinationParent, destinationChild);
}

bool HistoryModelWrapper::moveRows(const ::QModelIndex & sourceParent, int sourceRow, int count, const ::QModelIndex & destinationParent, int destinationChild)
{
    static const char *funcName = "moveRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::moveRows(sourceParent, sourceRow, count, destinationParent, destinationChild);
    }
    return TabTreeModelWrapper::sbk_o_moveColumns("HistoryModel", funcName, gil, pyOverride, sourceParent, sourceRow, count, destinationParent, destinationChild);
}

void HistoryModelWrapper::multiData(const ::QModelIndex & index, ::QModelRoleDataSpan roleDataSpan) const
{
    static const char *funcName = "multiData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::multiData(index, roleDataSpan);
    }
    TabTreeModelWrapper::sbk_o_multiData("HistoryModel", funcName, gil, pyOverride, index, roleDataSpan);
}

::QModelIndex HistoryModelWrapper::parent(const ::QModelIndex & child) const
{
    static const char *funcName = "parent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::parent(child);
    }
    return TabTreeModelWrapper::sbk_o_buddy("HistoryModel", funcName, gil, pyOverride, child);
}

bool HistoryModelWrapper::removeColumns(int column, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeColumns";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeColumns(column, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("HistoryModel", funcName, gil, pyOverride, column, count, parent);
}

bool HistoryModelWrapper::removeRows(int row, int count, const ::QModelIndex & parent)
{
    static const char *funcName = "removeRows";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::removeRows(row, count, parent);
    }
    return TabTreeModelWrapper::sbk_o_insertColumns("HistoryModel", funcName, gil, pyOverride, row, count, parent);
}

void HistoryModelWrapper::resetInternalData()
{
    static const char *funcName = "resetInternalData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::resetInternalData();
    }
    WebViewWrapper::sbk_o_closeView("HistoryModel", funcName, gil, pyOverride);
}

void HistoryModelWrapper::revert()
{
    static const char *funcName = "revert";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::revert();
    }
    WebViewWrapper::sbk_o_closeView("HistoryModel", funcName, gil, pyOverride);
}

::QHash<int,QByteArray> HistoryModelWrapper::roleNames() const
{
    static const char *funcName = "roleNames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::roleNames();
    }
    return TabTreeModelWrapper::sbk_o_roleNames("HistoryModel", funcName, gil, pyOverride);
}

int HistoryModelWrapper::rowCount(const ::QModelIndex & parent) const
{
    static const char *funcName = "rowCount";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::rowCount(parent);
    }
    return TabTreeModelWrapper::sbk_o_columnCount("HistoryModel", funcName, gil, pyOverride, parent);
}

bool HistoryModelWrapper::setData(const ::QModelIndex & index, const ::QVariant & value, int role)
{
    static const char *funcName = "setData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::HistoryModel::setData(index, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setData("HistoryModel", funcName, gil, pyOverride, index, value, role);
}

bool HistoryModelWrapper::setHeaderData(int section, ::Qt::Orientation orientation, const ::QVariant & value, int role)
{
    static const char *funcName = "setHeaderData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setHeaderData(section, orientation, value, role);
    }
    return TabTreeModelWrapper::sbk_o_setHeaderData("HistoryModel", funcName, gil, pyOverride, section, orientation, value, role);
}

bool HistoryModelWrapper::setItemData(const ::QModelIndex & index, const ::QMap<int,QVariant> & roles)
{
    static const char *funcName = "setItemData";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::setItemData(index, roles);
    }
    return TabTreeModelWrapper::sbk_o_setItemData("HistoryModel", funcName, gil, pyOverride, index, roles);
}

::QModelIndex HistoryModelWrapper::sibling(int row, int column, const ::QModelIndex & idx) const
{
    static const char *funcName = "sibling";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sibling(row, column, idx);
    }
    return TabTreeModelWrapper::sbk_o_index("HistoryModel", funcName, gil, pyOverride, row, column, idx);
}

void HistoryModelWrapper::sort(int column, ::Qt::SortOrder order)
{
    static const char *funcName = "sort";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::sort(column, order);
    }
    TabTreeModelWrapper::sbk_o_sort("HistoryModel", funcName, gil, pyOverride, column, order);
}

::QSize HistoryModelWrapper::span(const ::QModelIndex & index) const
{
    static const char *funcName = "span";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::span(index);
    }
    return TabTreeModelWrapper::sbk_o_span("HistoryModel", funcName, gil, pyOverride, index);
}

bool HistoryModelWrapper::submit()
{
    static const char *funcName = "submit";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::submit();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("HistoryModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> HistoryModelWrapper::supportedDragActions() const
{
    static const char *funcName = "supportedDragActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDragActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("HistoryModel", funcName, gil, pyOverride);
}

::QFlags<Qt::DropAction> HistoryModelWrapper::supportedDropActions() const
{
    static const char *funcName = "supportedDropActions";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QAbstractItemModel::supportedDropActions();
    }
    return TabTreeModelWrapper::sbk_o_supportedDragActions("HistoryModel", funcName, gil, pyOverride);
}

void HistoryModelWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_HistoryModel_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("HistoryModel", funcName, gil, pyOverride, event);
}

const QMetaObject *HistoryModelWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return HistoryModel::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int HistoryModelWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = HistoryModel::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *HistoryModelWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< HistoryModelWrapper *>(this));
    }
    return HistoryModel::qt_metacast(_clname);
}

HistoryModelWrapper::~HistoryModelWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_HistoryModel_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_HistoryModel_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::HistoryModel >()))
        return -1;

    HistoryModelWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "HistoryModel", 1, 1, &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: HistoryModel::HistoryModel(History*)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_History_IDX]), (pyArgs[0])))) {
        overloadId = 0; // HistoryModel(History*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::History *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // HistoryModel(History*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) HistoryModelWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new HistoryModelWrapper(cppArg0);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< HistoryModel >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
    };


    return 1;
}

static PyObject *Sbk_HistoryModelFunc_canFetchMore(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::canFetchMore(QModelIndex)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // canFetchMore(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "canFetchMore", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // canFetchMore(QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::canFetchMore(*cppArg0)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->canFetchMore(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_columnCount(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    if (PyArg_ParseTuple(args, "|O:columnCount", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::columnCount(const QModelIndex&=)const->int
    if (numArgs == 0) {
        overloadId = 0; // columnCount(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // columnCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "columnCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // columnCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::columnCount(*cppArg0)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->columnCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_data(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[2];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "data", 2, 2, &(pyArgs[0]), &(pyArgs[1])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::data(QModelIndex,int)const->QVariant
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // data(QModelIndex,int)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "data", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (Shiboken::Errors::occurred() == nullptr) {
            // data(QModelIndex,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::data(*cppArg0, cppArg1)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->data(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_fetchMore(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::fetchMore(QModelIndex)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // fetchMore(QModelIndex)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "fetchMore", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // fetchMore(QModelIndex)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::HistoryModel::fetchMore(*cppArg0)
                : cppSelf->fetchMore(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryModelFunc_flags(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::flags(QModelIndex)const->QFlags<Qt::ItemFlag>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // flags(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "flags", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // flags(QModelIndex)const
            QFlags<Qt::ItemFlag> cppResult = QFlags<Qt::ItemFlag>(Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::flags(*cppArg0)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->flags(*cppArg0));
            pyResult = Shiboken::Conversions::copyToPython(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QFlags_Qt_ItemFlag_IDX])))->flagsConverter, &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_hasChildren(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QAbstractItemModel::hasChildren(QModelIndex)const->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // hasChildren(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "hasChildren", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // hasChildren(QModelIndex)const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::hasChildren(*cppArg0)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->hasChildren(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_headerData(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "headerData", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:headerData", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::headerData(int,Qt::Orientation,int=)const->QVariant
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_Qt_Orientation_IDX])))->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // headerData(int,Qt::Orientation,int)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
            overloadId = 0; // headerData(int,Qt::Orientation,int)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "headerData", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"role", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "headerData", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::Qt::Orientation cppArg1 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2 = Qt::DisplayRole;
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // headerData(int,Qt::Orientation,int)const
            QVariant cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::headerData(cppArg0, cppArg1, cppArg2)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->headerData(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_index(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 2, 3));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    if (PyArg_ParseTuple(args, "|OOO:index", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::index(int,int,const QModelIndex&=)const->QModelIndex
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // index(int,int,QModelIndex)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2])))) {
            overloadId = 0; // index(int,int,QModelIndex)const
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 2}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "index", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QModelIndex cppArg2_local = QModelIndex();
        ::QModelIndex *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
            if (pythonToCpp[2].isValue())
                pythonToCpp[2](pyArgs[2], &cppArg2_local);
            else
                pythonToCpp[2](pyArgs[2], &cppArg2);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // index(int,int,QModelIndex)const
            QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::index(cppArg0, cppArg1, *cppArg2)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->index(cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_itemFromIndex(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryModel::itemFromIndex(QModelIndex)const->HistoryItem*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArg)))) {
        overloadId = 0; // itemFromIndex(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "itemFromIndex", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // itemFromIndex(QModelIndex)const
            HistoryItem * cppResult = const_cast<const HistoryModelWrapper *>(cppSelf)->itemFromIndex(*cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryItem_IDX]), cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_parent(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "parent", 0, 1, &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::parent(QModelIndex)const->QModelIndex
    // 1: QObject::parent()const->QObject*
    if (numArgs == 0) {
        overloadId = 1; // parent()const
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // parent(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "parent", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    switch (overloadId) {
        case 0: // parent(const QModelIndex &child) const
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QModelIndex cppArg0_local;
            ::QModelIndex *cppArg0 = &cppArg0_local;
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (Shiboken::Errors::occurred() == nullptr) {
                // parent(QModelIndex)const
                QModelIndex cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::parent(*cppArg0)
                    : const_cast<const HistoryModelWrapper *>(cppSelf)->parent(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), &cppResult);
            }
            break;
        }
        case 1: // parent() const
        {

            // parent()const
            QObject * cppResult = const_cast<const QObjectWrapper *>(reinterpret_cast<QObjectWrapper *>(cppSelf))->parent();
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), cppResult);

            // Ownership transferences.
            break;
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_removeTopLevelIndexes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: HistoryModel::removeTopLevelIndexes(QList<QPersistentModelIndex>)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_QPersistentModelIndex_IDX], (pyArg)))) {
        overloadId = 0; // removeTopLevelIndexes(QList<QPersistentModelIndex>)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeTopLevelIndexes", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        ::QList<QPersistentModelIndex> cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // removeTopLevelIndexes(QList<QPersistentModelIndex>)
            cppSelf->removeTopLevelIndexes(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_HistoryModelFunc_rowCount(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths
    errInfo.reset(Shiboken::checkInvalidArgumentCount(numArgs, 0, 1));
    if (!errInfo.isNull())
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    if (PyArg_ParseTuple(args, "|O:rowCount", &(pyArgs[0])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::rowCount(const QModelIndex&=)const->int
    if (numArgs == 0) {
        overloadId = 0; // rowCount(QModelIndex)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))) {
        overloadId = 0; // rowCount(QModelIndex)const
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments(args, "rowCount", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local = QModelIndex();
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
            if (pythonToCpp[0].isValue())
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);
            }

        if (Shiboken::Errors::occurred() == nullptr) {
            // rowCount(QModelIndex)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const HistoryModelWrapper *>(cppSelf)->::HistoryModel::rowCount(*cppArg0)
                : const_cast<const HistoryModelWrapper *>(cppSelf)->rowCount(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_HistoryModelFunc_setData(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<HistoryModelWrapper *>(reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_UnpackTuple(args, "setData", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return {};


    // Overloaded function decisor
    // 0: QAbstractItemModel::setData(QModelIndex,QVariant,int)->bool
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QModelIndex_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QVariant_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))) {
        overloadId = 0; // setData(QModelIndex,QVariant,int)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(args, "setData", errInfo, SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QModelIndex cppArg0_local;
        ::QModelIndex *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0].isValue())
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setData(QModelIndex,QVariant,int)
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::HistoryModel::setData(*cppArg0, cppArg1, cppArg2)
                : cppSelf->setData(*cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_HistoryModel_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_HistoryModel_EnumFlagInfo[] = {
    "Roles:IntEnum",
    nullptr // Sentinel
};

static PyMethodDef Sbk_HistoryModel_methods[] = {
    {"canFetchMore", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_canFetchMore), METH_O, nullptr},
    {"columnCount", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_columnCount), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"data", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_data), METH_VARARGS, nullptr},
    {"fetchMore", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_fetchMore), METH_O, nullptr},
    {"flags", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_flags), METH_O, nullptr},
    {"hasChildren", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_hasChildren), METH_O, nullptr},
    {"headerData", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_headerData), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"index", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_index), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"itemFromIndex", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_itemFromIndex), METH_O, nullptr},
    {"parent", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_parent), METH_VARARGS, nullptr},
    {"removeTopLevelIndexes", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_removeTopLevelIndexes), METH_O, nullptr},
    {"rowCount", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_rowCount), METH_VARARGS|METH_KEYWORDS, nullptr},
    {"setData", reinterpret_cast<PyCFunction>(Sbk_HistoryModelFunc_setData), METH_VARARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_HistoryModel_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::HistoryModel *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<HistoryModelWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_HistoryModel_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_HistoryModel_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_HistoryModel_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_HistoryModel_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_HistoryModel_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_HistoryModel_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_HistoryModel_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_HistoryModel_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_HistoryModel_spec = {
    "1:PyFalkon.HistoryModel",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_HistoryModel_slots
};

} //extern "C"

static void *Sbk_HistoryModel_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::HistoryModel *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_HistoryModel_Roles(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::HistoryModel::Roles>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::HistoryModel::Roles *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_HistoryModel_Roles_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_HistoryModel_Roles_IDX])))
        return Enum_PythonToCpp_HistoryModel_Roles;
    return {};
}

static PyObject *HistoryModel_Roles_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::HistoryModel::Roles>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::HistoryModel::Roles *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void HistoryModel_PythonToCpp_HistoryModel_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_HistoryModel_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_HistoryModel_PythonToCpp_HistoryModel_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_HistoryModel_TypeF()))
        return HistoryModel_PythonToCpp_HistoryModel_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *HistoryModel_PTR_CppToPython_HistoryModel(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::HistoryModel *>(const_cast<void *>(cppIn)), Sbk_HistoryModel_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *HistoryModel_SignatureStrings[] = {
    "PyFalkon.HistoryModel(self,history:PyFalkon.History)",
    "PyFalkon.HistoryModel.canFetchMore(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.HistoryModel.columnCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->int",
    "PyFalkon.HistoryModel.data(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],role:int)->QVariant",
    "PyFalkon.HistoryModel.fetchMore(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])",
    "PyFalkon.HistoryModel.flags(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.Qt.ItemFlag",
    "PyFalkon.HistoryModel.hasChildren(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->bool",
    "PyFalkon.HistoryModel.headerData(self,section:int,orientation:PySide6.QtCore.Qt.Orientation,role:int=Qt.DisplayRole)->QVariant",
    "PyFalkon.HistoryModel.index(self,row:int,column:int,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->PySide6.QtCore.QModelIndex",
    "PyFalkon.HistoryModel.itemFromIndex(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PyFalkon.HistoryItem",
    "1:PyFalkon.HistoryModel.parent(self,child:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex])->PySide6.QtCore.QModelIndex",
    "0:PyFalkon.HistoryModel.parent(self)->PySide6.QtCore.QObject",
    "PyFalkon.HistoryModel.removeTopLevelIndexes(self,indexes:QList[PySide6.QtCore.QPersistentModelIndex])",
    "PyFalkon.HistoryModel.rowCount(self,parent:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex]=QModelIndex())->int",
    "PyFalkon.HistoryModel.setData(self,index:typing.Union[PySide6.QtCore.QModelIndex, PySide6.QtCore.QPersistentModelIndex],value:QVariant,role:int)->bool",
    nullptr}; // Sentinel
#else
static constexpr size_t HistoryModel_SignatureByteSize = 372;
static constexpr uint8_t HistoryModel_SignatureBytes[372] = {
    0x78, 0xda, 0xcd, 0x94, 0x3d, 0x4f, 0xc3, 0x30, 0x10, 0x86, 0xf7, 0xfe, 0x0a, 0xc6, 0x56, 0x0a,
    0x11, 0x2c, 0x0c, 0x91, 0xca, 0xd2, 0xaa, 0xa2, 0x52, 0xab, 0x26, 0x7c, 0x2d, 0x15, 0x83, 0x9b,
    0x5c, 0x1b, 0x83, 0xe3, 0x8b, 0x6c, 0x27, 0x90, 0x7f, 0xcf, 0x25, 0x86, 0x36, 0x94, 0x5a, 0x1d,
    0x20, 0x85, 0x2d, 0xb1, 0xcf, 0xf7, 0x3e, 0xbe, 0x7b, 0x7d, 0x61, 0x35, 0x61, 0xe2, 0x05, 0xa5,
    0x7f, 0xc3, 0xb5, 0x41, 0x55, 0xcd, 0x31, 0x01, 0xd1, 0xd7, 0x20, 0xd6, 0x5e, 0x6a, 0x57, 0x82,
    0x70, 0x2f, 0x64, 0xd0, 0x0b, 0x0f, 0x1d, 0xf2, 0x63, 0x26, 0x27, 0x60, 0xe2, 0x74, 0x8e, 0x0a,
    0x6c, 0x86, 0x9c, 0x29, 0x90, 0x26, 0x30, 0x55, 0xce, 0xe5, 0xc6, 0x7f, 0x90, 0x1c, 0xe5, 0x32,
    0xac, 0xee, 0x78, 0x02, 0x57, 0x7e, 0x64, 0x46, 0x14, 0xe7, 0x47, 0xcd, 0xd9, 0xa9, 0x4c, 0xe0,
    0xcd, 0x3b, 0xdb, 0xdf, 0x0b, 0x41, 0x69, 0x52, 0xa0, 0x1c, 0xbb, 0xa8, 0xa7, 0xc1, 0xf9, 0xf5,
    0x0a, 0x51, 0xb8, 0x20, 0x50, 0x14, 0x99, 0x1c, 0x61, 0x21, 0x4d, 0x87, 0x0c, 0xc3, 0xd6, 0x91,
    0xfe, 0x80, 0x88, 0xb8, 0x34, 0x0e, 0xa0, 0x84, 0x19, 0x66, 0x49, 0x78, 0x1d, 0xfd, 0xcb, 0x20,
    0x9e, 0x42, 0x01, 0x01, 0xa9, 0x13, 0x43, 0xf4, 0xc8, 0x14, 0x67, 0x4e, 0x90, 0xf5, 0x29, 0x7a,
    0xe3, 0xd2, 0x16, 0x6c, 0xa3, 0xbb, 0xab, 0x02, 0x5d, 0x7e, 0x3f, 0xce, 0xf8, 0x53, 0x03, 0xd9,
    0x84, 0x74, 0x1d, 0x48, 0x29, 0xd3, 0xa3, 0x94, 0x8b, 0x84, 0xaa, 0xf0, 0x67, 0x66, 0x4d, 0x81,
    0x25, 0xa0, 0xc6, 0x5b, 0x87, 0x68, 0x88, 0x0d, 0xc9, 0xd6, 0xfd, 0xf4, 0x50, 0x71, 0x4a, 0xc5,
    0x9a, 0xff, 0xef, 0x97, 0x5b, 0xec, 0x76, 0xb7, 0x16, 0x18, 0xd2, 0xfa, 0x98, 0xeb, 0x5c, 0xb0,
    0xea, 0x96, 0x96, 0x8e, 0x3b, 0xa2, 0x69, 0x85, 0x55, 0x56, 0xf8, 0xda, 0xa8, 0xda, 0xe7, 0xd3,
    0x7c, 0x9e, 0xe6, 0xe1, 0xb8, 0x33, 0xba, 0xa0, 0xeb, 0xb6, 0x2a, 0xcc, 0xa6, 0x3b, 0xf8, 0xce,
    0x2c, 0xf5, 0x55, 0xbf, 0x36, 0x54, 0xef, 0x32, 0x38, 0x8c, 0x65, 0xab, 0x65, 0x79, 0xe2, 0xda,
    0x57, 0xdd, 0x5b, 0xbc, 0x55, 0xaa, 0x8b, 0xe3, 0x54, 0x07, 0x12, 0x2c, 0x56, 0xcf, 0x64, 0x38,
    0x47, 0x9d, 0x15, 0x64, 0x58, 0xc2, 0x3d, 0xe6, 0x33, 0x28, 0x3f, 0x64, 0xa0, 0xfd, 0x84, 0x41,
    0x07, 0xd1, 0x8c, 0x0e, 0x2c, 0x7f, 0x34, 0x18, 0xc8, 0x77, 0xff, 0x68, 0x56, 0x6b, 0x30, 0xe3,
    0x6e, 0xc7, 0x75, 0xc9, 0x44, 0x01, 0xc1, 0xe7, 0xbb, 0x6c, 0x4f, 0xef, 0x66, 0x4c, 0xbc, 0x03,
    0x5f, 0x41, 0xc7, 0x52
};
#endif

PyTypeObject *init_HistoryModel(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX].type;

    Shiboken::AutoDecRef Sbk_HistoryModel_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QAbstractItemModel_IDX]))));

    _Sbk_HistoryModel_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "HistoryModel",
        "HistoryModel*",
        &Sbk_HistoryModel_spec,
        &Shiboken::callCppDestructor< HistoryModel >,
        Sbk_HistoryModel_Type_bases.object(),
        0);
    auto *pyType = _Sbk_HistoryModel_Type; // references _Sbk_HistoryModel_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, HistoryModel_SignatureStrings);
#else
    InitSignatureBytes(pyType, HistoryModel_SignatureBytes, HistoryModel_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_HistoryModel_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_HistoryModel_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        HistoryModel_PythonToCpp_HistoryModel_PTR,
        is_HistoryModel_PythonToCpp_HistoryModel_PTR_Convertible,
        HistoryModel_PTR_CppToPython_HistoryModel);

    Shiboken::Conversions::registerConverterName(converter, "HistoryModel");
    Shiboken::Conversions::registerConverterName(converter, "HistoryModel*");
    Shiboken::Conversions::registerConverterName(converter, "HistoryModel&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::HistoryModel).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(HistoryModelWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_HistoryModel_TypeF(), &Sbk_HistoryModel_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_HistoryModel_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Roles'.
    const char *Roles_Initializer[] = {
        "IdRole",
        "TitleRole",
        "UrlRole",
        "UrlStringRole",
        "IconRole",
        "IsTopLevelRole",
        "TimestampStartRole",
        "TimestampEndRole",
        "MaxRole",
        nullptr};
    // "uint16_t" used instead of "unsigned int"
    constexpr uint16_t Roles_InitializerValues[] = {
        uint16_t(HistoryModel::Roles::IdRole),             //  0x0101  257
        uint16_t(HistoryModel::Roles::TitleRole),          //  0x0102  258
        uint16_t(HistoryModel::Roles::UrlRole),            //  0x0103  259
        uint16_t(HistoryModel::Roles::UrlStringRole),      //  0x0104  260
        uint16_t(HistoryModel::Roles::IconRole),           //  0x0105  261
        uint16_t(HistoryModel::Roles::IsTopLevelRole),     //  0x0107  263
        uint16_t(HistoryModel::Roles::TimestampStartRole), //  0x0108  264
        uint16_t(HistoryModel::Roles::TimestampEndRole),   //  0x0109  265
        uint16_t(HistoryModel::Roles::MaxRole)             //  0x0109  265
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_HistoryModel_TypeF(),
        "1:PyFalkon.HistoryModel.Roles",
        Roles_Initializer, Roles_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_HistoryModel_Roles_IDX].type = EType;
    // Register converter for enum 'HistoryModel::Roles'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            HistoryModel_Roles_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_HistoryModel_Roles,
            is_Enum_PythonToCpp_HistoryModel_Roles_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "HistoryModel::Roles");
        Shiboken::Conversions::registerConverterAlias(converter, "Roles");
        Shiboken::Enum::setTypeConverter(EType, converter, nullptr);
    }
    // End of 'Roles' enum.

    HistoryModelWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::HistoryModel::staticMetaObject, sizeof(HistoryModelWrapper));

    return pyType;
}
