
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "tabcontextmenu_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <algorithm>
#include <cctype>
#include <cstring>
#include <iterator>
#include <set>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_TabContextMenu_Type = nullptr;
static PyTypeObject *Sbk_TabContextMenu_TypeF(void)
{
    return _Sbk_TabContextMenu_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void TabContextMenuWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::TabContextMenu::Option >("TabContextMenu::Option");
}

void TabContextMenuWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

TabContextMenuWrapper::TabContextMenuWrapper(int index, ::BrowserWindow * window, ::QFlags<TabContextMenu::Option> options) : TabContextMenu(index, window, options)
{
}

void TabContextMenuWrapper::actionEvent(::QActionEvent * arg__1)
{
    static const char *funcName = "actionEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::actionEvent(arg__1);
    }
    WebViewWrapper::sbk_o_actionEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::changeEvent(::QEvent * arg__1)
{
    static const char *funcName = "changeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::changeEvent(arg__1);
    }
    WebViewWrapper::sbk_o_changeEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::closeEvent(::QCloseEvent * event)
{
    static const char *funcName = "closeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::closeEvent(event);
    }
    WebViewWrapper::sbk_o_closeEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabContextMenu", funcName, gil, pyOverride, signal);
}

void TabContextMenuWrapper::contextMenuEvent(::QContextMenuEvent * event)
{
    static const char *funcName = "contextMenuEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::contextMenuEvent(event);
    }
    WebViewWrapper::sbk_o_contextMenuEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

int TabContextMenuWrapper::devType() const
{
    static const char *funcName = "devType";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::devType();
    }
    return WebViewWrapper::sbk_o_devType("TabContextMenu", funcName, gil, pyOverride);
}

void TabContextMenuWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("TabContextMenu", funcName, gil, pyOverride, signal);
}

void TabContextMenuWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    static const char *funcName = "dragEnterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragEnterEvent(event);
    }
    WebViewWrapper::sbk_o_dragEnterEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    static const char *funcName = "dragLeaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    WebViewWrapper::sbk_o_dragLeaveEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    static const char *funcName = "dragMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dragMoveEvent(event);
    }
    WebViewWrapper::sbk_o_dragMoveEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::dropEvent(::QDropEvent * event)
{
    static const char *funcName = "dropEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[12], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::dropEvent(event);
    }
    WebViewWrapper::sbk_o_dropEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::enterEvent(::QEnterEvent * arg__1)
{
    static const char *funcName = "enterEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[13], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::enterEvent(arg__1);
    }
    WebViewWrapper::sbk_o_enterEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

bool TabContextMenuWrapper::event(::QEvent * arg__1)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[14], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::event(arg__1);
    }
    return WebViewWrapper::sbk_o_event("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

bool TabContextMenuWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[15], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("TabContextMenu", funcName, gil, pyOverride, watched, event);
}

void TabContextMenuWrapper::focusInEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusInEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[16], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusInEvent(event);
    }
    WebViewWrapper::sbk_o_focusInEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

bool TabContextMenuWrapper::focusNextPrevChild(bool next)
{
    static const char *funcName = "focusNextPrevChild";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[17], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::focusNextPrevChild(next);
    }
    return WebViewWrapper::sbk_o_focusNextPrevChild("TabContextMenu", funcName, gil, pyOverride, next);
}

void TabContextMenuWrapper::focusOutEvent(::QFocusEvent * event)
{
    static const char *funcName = "focusOutEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[18], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::focusOutEvent(event);
    }
    WebViewWrapper::sbk_o_focusOutEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

bool TabContextMenuWrapper::hasHeightForWidth() const
{
    static const char *funcName = "hasHeightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[19], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::hasHeightForWidth();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("TabContextMenu", funcName, gil, pyOverride);
}

int TabContextMenuWrapper::heightForWidth(int arg__1) const
{
    static const char *funcName = "heightForWidth";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[20], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::heightForWidth(arg__1);
    }
    return WebViewWrapper::sbk_o_heightForWidth("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::hideEvent(::QHideEvent * arg__1)
{
    static const char *funcName = "hideEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[21], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::hideEvent(arg__1);
    }
    WebViewWrapper::sbk_o_hideEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::initPainter(::QPainter * painter) const
{
    static const char *funcName = "initPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[22], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::initPainter(painter);
    }
    WebViewWrapper::sbk_o_initPainter("TabContextMenu", funcName, gil, pyOverride, painter);
}

void TabContextMenuWrapper::initStyleOption(::QStyleOptionMenuItem * option, const ::QAction * action) const
{
    static const char *funcName = "initStyleOption";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[23], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::initStyleOption(option, action);
    }
    sbk_o_initStyleOption("TabContextMenu", funcName, gil, pyOverride, option, action);
}

void TabContextMenuWrapper::sbk_o_initStyleOption(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::QStyleOptionMenuItem * option, const ::QAction * action)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[2] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QStyleOptionMenuItem_IDX]), option),
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), action)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 2, nullptr));
    Py_DECREF(pyArgArray[0]);
    Py_DECREF(pyArgArray[1]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

void TabContextMenuWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    static const char *funcName = "inputMethodEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[24], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodEvent(event);
    }
    WebViewWrapper::sbk_o_inputMethodEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

::QVariant TabContextMenuWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    static const char *funcName = "inputMethodQuery";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[25], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::inputMethodQuery(arg__1);
    }
    return WebViewWrapper::sbk_o_inputMethodQuery("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    static const char *funcName = "keyPressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[26], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::keyPressEvent(arg__1);
    }
    WebViewWrapper::sbk_o_keyPressEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    static const char *funcName = "keyReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[27], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    WebViewWrapper::sbk_o_keyReleaseEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::leaveEvent(::QEvent * arg__1)
{
    static const char *funcName = "leaveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[28], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::leaveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_leaveEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

int TabContextMenuWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    static const char *funcName = "metric";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[29], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::metric(arg__1);
    }
    return WebViewWrapper::sbk_o_metric("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

::QSize TabContextMenuWrapper::minimumSizeHint() const
{
    // This method belongs to a property.
    static const char *funcName = "1:minimumSizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[30], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::minimumSizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabContextMenu", funcName, gil, pyOverride);
}

void TabContextMenuWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    static const char *funcName = "mouseDoubleClickEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[31], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    WebViewWrapper::sbk_o_mouseDoubleClickEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::mouseMoveEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseMoveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[32], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseMoveEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mouseMoveEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::mousePressEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mousePressEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[33], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mousePressEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mousePressEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::mouseReleaseEvent(::QMouseEvent * arg__1)
{
    static const char *funcName = "mouseReleaseEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[34], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::mouseReleaseEvent(arg__1);
    }
    WebViewWrapper::sbk_o_mouseReleaseEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::moveEvent(::QMoveEvent * event)
{
    static const char *funcName = "moveEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[35], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::moveEvent(event);
    }
    WebViewWrapper::sbk_o_moveEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

bool TabContextMenuWrapper::nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result)
{
    static const char *funcName = "nativeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[36], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    return WebViewWrapper::sbk_o_nativeEvent("TabContextMenu", funcName, gil, pyOverride, eventType, message, result);
}

::QPaintEngine * TabContextMenuWrapper::paintEngine() const
{
    static const char *funcName = "paintEngine";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[37], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::paintEngine();
    }
    return WebViewWrapper::sbk_o_paintEngine("TabContextMenu", funcName, gil, pyOverride);
}

void TabContextMenuWrapper::paintEvent(::QPaintEvent * arg__1)
{
    static const char *funcName = "paintEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[38], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::paintEvent(arg__1);
    }
    WebViewWrapper::sbk_o_paintEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

::QPaintDevice * TabContextMenuWrapper::redirected(::QPoint * offset) const
{
    static const char *funcName = "redirected";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[39], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::redirected(offset);
    }
    return WebViewWrapper::sbk_o_redirected("TabContextMenu", funcName, gil, pyOverride, offset);
}

void TabContextMenuWrapper::resizeEvent(::QResizeEvent * event)
{
    static const char *funcName = "resizeEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[40], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::resizeEvent(event);
    }
    WebViewWrapper::sbk_o_resizeEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::setVisible(bool visible)
{
    // This method belongs to a property.
    static const char *funcName = "2:setVisible";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[41], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::setVisible(visible);
    }
    WebViewWrapper::sbk_o_requestFullScreen("TabContextMenu", funcName, gil, pyOverride, visible);
}

::QPainter * TabContextMenuWrapper::sharedPainter() const
{
    static const char *funcName = "sharedPainter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[42], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::sharedPainter();
    }
    return WebViewWrapper::sbk_o_sharedPainter("TabContextMenu", funcName, gil, pyOverride);
}

void TabContextMenuWrapper::showEvent(::QShowEvent * event)
{
    static const char *funcName = "showEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[43], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::showEvent(event);
    }
    WebViewWrapper::sbk_o_showEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

::QSize TabContextMenuWrapper::sizeHint() const
{
    static const char *funcName = "sizeHint";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[44], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::sizeHint();
    }
    return WebViewWrapper::sbk_o_minimumSizeHint("TabContextMenu", funcName, gil, pyOverride);
}

void TabContextMenuWrapper::tabletEvent(::QTabletEvent * event)
{
    static const char *funcName = "tabletEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[45], nameCache));
    if (pyOverride.isNull()) {
        return this->::QWidget::tabletEvent(event);
    }
    WebViewWrapper::sbk_o_tabletEvent("TabContextMenu", funcName, gil, pyOverride, event);
}

void TabContextMenuWrapper::timerEvent(::QTimerEvent * arg__1)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[46], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::timerEvent(arg__1);
    }
    WebViewWrapper::sbk_o_timerEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

void TabContextMenuWrapper::wheelEvent(::QWheelEvent * arg__1)
{
    static const char *funcName = "wheelEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_TabContextMenu_TypeF(), gil, funcName, m_PyMethodCache[47], nameCache));
    if (pyOverride.isNull()) {
        return this->::QMenu::wheelEvent(arg__1);
    }
    WebViewWrapper::sbk_o_wheelEvent("TabContextMenu", funcName, gil, pyOverride, arg__1);
}

const QMetaObject *TabContextMenuWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return TabContextMenu::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int TabContextMenuWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = TabContextMenu::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *TabContextMenuWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< TabContextMenuWrapper *>(this));
    }
    return TabContextMenu::qt_metacast(_clname);
}

TabContextMenuWrapper::~TabContextMenuWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_TabContextMenu_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_TabContextMenu_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::TabContextMenu >()))
        return -1;

    TabContextMenuWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[3];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr, nullptr, nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|OOO:TabContextMenu", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: TabContextMenu::TabContextMenu(int,BrowserWindow*,QFlags<TabContextMenu::Option>=)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // TabContextMenu(int,BrowserWindow*,QFlags<TabContextMenu::Option>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_TabContextMenu_Option_IDX])))->flagsConverter, (pyArgs[2])))) {
            overloadId = 0; // TabContextMenu(int,BrowserWindow*,QFlags<TabContextMenu::Option>)
        }
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"options", 2}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[2] != nullptr && !(pythonToCpp[2] = Shiboken::Conversions::pythonToCppConversion(PepType_SETP(reinterpret_cast<SbkEnumType *>(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_QFlags_TabContextMenu_Option_IDX])))->flagsConverter, (pyArgs[2]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return -1;
        ::BrowserWindow *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<TabContextMenu::Option> cppArg2(TabContextMenu::Option::DefaultOptions);
        if (pythonToCpp[2])
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (Shiboken::Errors::occurred() == nullptr) {
            // TabContextMenu(int,BrowserWindow*,QFlags<TabContextMenu::Option>)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) TabContextMenuWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new TabContextMenuWrapper(cppArg0, cppArg1, cppArg2);
            }

        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< TabContextMenu >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]);
    };


    return 1;
}


static const char *Sbk_TabContextMenu_PropertyStrings[] = {
    nullptr // Sentinel
};

static const char *Sbk_TabContextMenu_EnumFlagInfo[] = {
    "Option:IntFlag:Options",
    nullptr // Sentinel
};

static PyMethodDef Sbk_TabContextMenu_methods[] = {
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_TabContextMenu_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::TabContextMenu *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<TabContextMenuWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_TabContextMenu_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_TabContextMenu_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}
static void * Sbk_TabContextMenuSpecialCastFunction(void *obj, PyTypeObject *desiredType)
{
    auto me = reinterpret_cast< ::TabContextMenu *>(obj);
    if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))
        return static_cast< ::QMenu *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QPaintDevice_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}



// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_TabContextMenu_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_TabContextMenu_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_TabContextMenu_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_TabContextMenu_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_TabContextMenu_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_TabContextMenu_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_TabContextMenu_spec = {
    "1:PyFalkon.TabContextMenu",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_TabContextMenu_slots
};

} //extern "C"

static void *Sbk_TabContextMenu_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QWidget >())
        return dynamic_cast< ::TabContextMenu *>(reinterpret_cast< ::QWidget *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::TabContextMenu *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == Shiboken::SbkType< ::QPaintDevice >())
        return dynamic_cast< ::TabContextMenu *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void Enum_PythonToCpp_TabContextMenu_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = static_cast<::TabContextMenu::Option>(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<::TabContextMenu::Option *>(cppOut) = value;

}
static PythonToCppFunc is_Enum_PythonToCpp_TabContextMenu_Option_Convertible(PyObject *pyIn)
{
    if (PyObject_TypeCheck(pyIn, Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabContextMenu_Option_IDX])))
        return Enum_PythonToCpp_TabContextMenu_Option;
    return {};
}

static PyObject *TabContextMenu_Option_CppToPython_Enum(PyTypeObject *pyType, const void *cppIn)
{
    using IntType = std::underlying_type_t<::TabContextMenu::Option>;
    const auto castCppIn = IntType(*reinterpret_cast<const ::TabContextMenu::Option *>(cppIn));
    return Shiboken::Enum::newItem(pyType, castCppIn);

}

static void Flag_PythonToCpp_TabContextMenu_Option(PyObject *pyIn, void *cppOut)
{
    const auto value = QFlags<::TabContextMenu::Option>::fromInt(Shiboken::Enum::getValue(pyIn));
    *reinterpret_cast<QFlags<::TabContextMenu::Option> *>(cppOut) = value;

}

static PyObject *TabContextMenu_Option_CppToPython_Flag(const void *cppIn)
{
    const auto flags = *reinterpret_cast<const QFlags<::TabContextMenu::Option> *>(cppIn);
    return Shiboken::Enum::newItem(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_TabContextMenu_Option_IDX]), flags.toInt());

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void TabContextMenu_PythonToCpp_TabContextMenu_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_TabContextMenu_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_TabContextMenu_PythonToCpp_TabContextMenu_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_TabContextMenu_TypeF()))
        return TabContextMenu_PythonToCpp_TabContextMenu_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *TabContextMenu_PTR_CppToPython_TabContextMenu(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::TabContextMenu *>(const_cast<void *>(cppIn)), Sbk_TabContextMenu_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *TabContextMenu_SignatureStrings[] = {
    "PyFalkon.TabContextMenu(self,index:int,window:PyFalkon.BrowserWindow,options:PyFalkon.TabContextMenu.Option=TabContextMenu.Option.DefaultOptions)",
    nullptr}; // Sentinel
#else
static constexpr size_t TabContextMenu_SignatureByteSize = 97;
static constexpr uint8_t TabContextMenu_SignatureBytes[97] = {
    0x78, 0xda, 0x0b, 0xa8, 0x74, 0x4b, 0xcc, 0xc9, 0xce, 0xcf, 0xd3, 0x0b, 0x49, 0x4c, 0x72, 0xce,
    0xcf, 0x2b, 0x49, 0xad, 0x28, 0xf1, 0x4d, 0xcd, 0x2b, 0xd5, 0x28, 0x4e, 0xcd, 0x49, 0xd3, 0xc9,
    0xcc, 0x4b, 0x49, 0xad, 0xb0, 0xca, 0xcc, 0x2b, 0xd1, 0x29, 0x07, 0x32, 0xf3, 0xcb, 0xad, 0x02,
    0x60, 0xaa, 0x9d, 0x8a, 0xf2, 0xcb, 0x8b, 0x53, 0x8b, 0xc2, 0xc1, 0xc2, 0x3a, 0xf9, 0x05, 0x25,
    0x99, 0xf9, 0x79, 0xc5, 0x08, 0x69, 0x54, 0xc3, 0xf4, 0xfc, 0xc1, 0xf2, 0xb6, 0x58, 0x45, 0xf5,
    0x5c, 0x52, 0xd3, 0x12, 0x4b, 0x73, 0x4a, 0x20, 0xbc, 0x62, 0x4d, 0x2e, 0x00, 0x0b, 0x2b, 0x37,
    0xae
};
#endif

PyTypeObject *init_TabContextMenu(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX].type;

    Shiboken::AutoDecRef Sbk_TabContextMenu_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QMenu_IDX]))));

    _Sbk_TabContextMenu_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "TabContextMenu",
        "TabContextMenu*",
        &Sbk_TabContextMenu_spec,
        &Shiboken::callCppDestructor< TabContextMenu >,
        Sbk_TabContextMenu_Type_bases.object(),
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread);
    auto *pyType = _Sbk_TabContextMenu_Type; // references _Sbk_TabContextMenu_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, TabContextMenu_SignatureStrings);
#else
    InitSignatureBytes(pyType, TabContextMenu_SignatureBytes, TabContextMenu_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_TabContextMenu_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_TabContextMenu_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        TabContextMenu_PythonToCpp_TabContextMenu_PTR,
        is_TabContextMenu_PythonToCpp_TabContextMenu_PTR_Convertible,
        TabContextMenu_PTR_CppToPython_TabContextMenu);

    Shiboken::Conversions::registerConverterName(converter, "TabContextMenu");
    Shiboken::Conversions::registerConverterName(converter, "TabContextMenu*");
    Shiboken::Conversions::registerConverterName(converter, "TabContextMenu&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::TabContextMenu).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(TabContextMenuWrapper).name());

    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_TabContextMenu_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_TabContextMenu_TypeF(), &Sbk_TabContextMenuSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_TabContextMenu_TypeF(), &Sbk_TabContextMenu_typeDiscovery);

    // Pass the ..._EnumFlagInfo to the class.
    SbkObjectType_SetEnumFlagInfo(pyType, Sbk_TabContextMenu_EnumFlagInfo);

    // Initialization of enums.
    Shiboken::AutoDecRef tpDict{};
    PyTypeObject *EType{};

    // Initialization of enum 'Option'.
    const char *Option_Initializer[] = {
        "InvalidOption",
        "HorizontalTabs",
        "VerticalTabs",
        "ShowCloseOtherTabsActions",
        "ShowDetachTabAction",
        "DefaultOptions",
        nullptr};
    // "uint8_t" used instead of "unsigned int"
    constexpr uint8_t Option_InitializerValues[] = {
        uint8_t(TabContextMenu::Option::InvalidOption),             //  0x00  0
        uint8_t(TabContextMenu::Option::HorizontalTabs),            //  0x01  1
        uint8_t(TabContextMenu::Option::VerticalTabs),              //  0x02  2
        uint8_t(TabContextMenu::Option::ShowCloseOtherTabsActions), //  0x04  4
        uint8_t(TabContextMenu::Option::ShowDetachTabAction),       //  0x08  8
        uint8_t(TabContextMenu::Option::DefaultOptions)             //  0x0d  13
        };
    EType = Shiboken::Enum::createPythonEnum(Sbk_TabContextMenu_TypeF(),
        "1:PyFalkon.TabContextMenu.Option",
        Option_Initializer, Option_InitializerValues);
    SbkPyFalkonTypeStructs[SBK_TabContextMenu_Option_IDX].type = EType;
    // PYSIDE-1735: Mapping the flags class to the same enum class.
    SbkPyFalkonTypeStructs[SBK_QFlags_TabContextMenu_Option_IDX].type =
        EType;
    // Register converter for enum 'TabContextMenu::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(EType,
            TabContextMenu_Option_CppToPython_Enum);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            Enum_PythonToCpp_TabContextMenu_Option,
            is_Enum_PythonToCpp_TabContextMenu_Option_Convertible);
        Shiboken::Conversions::registerConverterName(converter, "TabContextMenu::Option");
        Shiboken::Conversions::registerConverterAlias(converter, "Option");
        SbkConverter *flagsConverter = Shiboken::Conversions::createConverter(EType,
            TabContextMenu_Option_CppToPython_Flag);
        Shiboken::Conversions::addPythonToCppValueConversion(flagsConverter,
            Flag_PythonToCpp_TabContextMenu_Option,
            is_Enum_PythonToCpp_TabContextMenu_Option_Convertible);
        // Register converter for flag 'QFlags<TabContextMenu::Option>'.
        Shiboken::Conversions::registerConverterName(flagsConverter, "QFlags<TabContextMenu::Option>");
        Shiboken::Conversions::registerConverterName(flagsConverter, "TabContextMenu::Options");
        Shiboken::Enum::setTypeConverter(EType, converter, flagsConverter);
    }
    // End of 'Option' enum/flags.

    PySide::Signal::registerSignals(pyType, &::TabContextMenu::staticMetaObject);
    TabContextMenuWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::TabContextMenu::staticMetaObject, sizeof(TabContextMenuWrapper));

    return pyType;
}
