
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqobject.h>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "sidebarinterface_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_SideBarInterface_Type = nullptr;
static PyTypeObject *Sbk_SideBarInterface_TypeF(void)
{
    return _Sbk_SideBarInterface_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void SideBarInterfaceWrapper::pysideInitQtMetaTypes()
{
}

void SideBarInterfaceWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

SideBarInterfaceWrapper::SideBarInterfaceWrapper(::QObject * parent) : SideBarInterface(parent)
{
}

void SideBarInterfaceWrapper::childEvent(::QChildEvent * event)
{
    static const char *funcName = "childEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::childEvent(event);
    }
    WebViewWrapper::sbk_o_childEvent("SideBarInterface", funcName, gil, pyOverride, event);
}

void SideBarInterfaceWrapper::connectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "connectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::connectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SideBarInterface", funcName, gil, pyOverride, signal);
}

::QAction * SideBarInterfaceWrapper::createMenuAction()
{
    static const char *funcName = "createMenuAction";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.createMenuAction");
        return nullptr;
    }
    return sbk_o_createMenuAction("SideBarInterface", funcName, gil, pyOverride);
}

::QAction * SideBarInterfaceWrapper::sbk_o_createMenuAction(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    bool invalidateArg0 = Py_REFCNT(pyResult) == 1;
    if (invalidateArg0)
        Shiboken::Object::releaseOwnership(pyResult.object());
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QAction >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QAction *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QWidget * SideBarInterfaceWrapper::createSideBarWidget(::BrowserWindow * mainWindow)
{
    static const char *funcName = "createSideBarWidget";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.createSideBarWidget");
        return nullptr;
    }
    return sbk_o_createSideBarWidget("SideBarInterface", funcName, gil, pyOverride, mainWindow);
}

::QWidget * SideBarInterfaceWrapper::sbk_o_createSideBarWidget(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::BrowserWindow * mainWindow)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), mainWindow)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), mainWindow)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return nullptr;
    }
    bool invalidateArg0 = Py_REFCNT(pyResult) == 1;
    if (invalidateArg0)
        Shiboken::Object::releaseOwnership(pyResult.object());
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, PepType_GetFullyQualifiedNameStr(Shiboken::SbkType< QWidget >()), Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void SideBarInterfaceWrapper::customEvent(::QEvent * event)
{
    static const char *funcName = "customEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::customEvent(event);
    }
    WebViewWrapper::sbk_o_customEvent("SideBarInterface", funcName, gil, pyOverride, event);
}

void SideBarInterfaceWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    static const char *funcName = "disconnectNotify";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::disconnectNotify(signal);
    }
    WebViewWrapper::sbk_o_connectNotify("SideBarInterface", funcName, gil, pyOverride, signal);
}

bool SideBarInterfaceWrapper::event(::QEvent * event)
{
    static const char *funcName = "event";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::event(event);
    }
    return WebViewWrapper::sbk_o_event("SideBarInterface", funcName, gil, pyOverride, event);
}

bool SideBarInterfaceWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    static const char *funcName = "eventFilter";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::eventFilter(watched, event);
    }
    return WebViewWrapper::sbk_o_eventFilter("SideBarInterface", funcName, gil, pyOverride, watched, event);
}

void SideBarInterfaceWrapper::timerEvent(::QTimerEvent * event)
{
    static const char *funcName = "timerEvent";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::QObject::timerEvent(event);
    }
    WebViewWrapper::sbk_o_timerEvent("SideBarInterface", funcName, gil, pyOverride, event);
}

::QString SideBarInterfaceWrapper::title() const
{
    static const char *funcName = "title";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_SideBarInterface_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.title");
        return ::QString();
    }
    return sbk_o_title("SideBarInterface", funcName, gil, pyOverride);
}

::QString SideBarInterfaceWrapper::sbk_o_title(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QString();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QString", Py_TYPE(pyResult)->tp_name);
        return ::QString();
    }
    ::QString cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *SideBarInterfaceWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject != nullptr)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return SideBarInterface::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int SideBarInterfaceWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = SideBarInterface::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *SideBarInterfaceWrapper::qt_metacast(const char *_clname)
{
    if (_clname == nullptr)
        return {};
    if (SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this)) {
        auto *obSelf = reinterpret_cast<PyObject *>(pySelf);
        if (PySide::inherits(Py_TYPE(obSelf), _clname))
            return static_cast<void *>(const_cast< SideBarInterfaceWrapper *>(this));
    }
    return SideBarInterface::qt_metacast(_clname);
}

SideBarInterfaceWrapper::~SideBarInterfaceWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_SideBarInterface_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_SideBarInterface_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("SideBarInterface");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::SideBarInterface >()))
        return -1;

    SideBarInterfaceWrapper *cptr{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp[1];
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_Size(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {nullptr};

    // invalid argument lengths

    if (PyArg_ParseTuple(args, "|O:SideBarInterface", &(pyArgs[0])) == 0)
        return -1;


    // Overloaded function decisor
    // 0: SideBarInterface::SideBarInterface(QObject*=)
    if (numArgs == 0) {
        overloadId = 0; // SideBarInterface(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0])))) {
        overloadId = 0; // SideBarInterface(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);


    // PyMI support
    bool usesPyMI = Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {
        if (kwds && PyDict_Size(kwds) > 0) {
            static const Shiboken::ArgumentNameIndexMapping mapping[1] = {{"parent", 0}};
            if (!Shiboken::parseConstructorKeywordArguments(kwds, mapping, 1, errInfo, pyArgs)
                || (pyArgs[0] != nullptr && !(pythonToCpp[0] = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]), (pyArgs[0]))))) {
                Py_XINCREF(errInfo.object());
                return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0])
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // SideBarInterface(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr != nullptr) {
                cptr = new (addr) SideBarInterfaceWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(nullptr);
            } else {
                cptr = new SideBarInterfaceWrapper(cppArg0);
            }

            // Ownership transferences (constructor heuristics).
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< SideBarInterface >(), cptr)) {
        delete cptr;
        return -1;
    }
    if (cptr == nullptr)
        return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    const auto *metaObject = cptr->metaObject(); // <- init python qt properties
    if (!errInfo.isNull() && PyDict_Check(errInfo.object())) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo, usesPyMI))
            return Shiboken::returnWrongArguments_MinusOne(args, "__init__", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);
    };


    return 1;
}

static PyObject *Sbk_SideBarInterfaceFunc_createMenuAction(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarInterfaceWrapper *>(reinterpret_cast< ::SideBarInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // createMenuAction()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.createMenuAction");
            return {};
        }
        QAction * cppResult = cppSelf->createMenuAction();
        pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtGuiTypeStructs[SBK_QAction_IDX]), cppResult);

        // Ownership transferences.
        Shiboken::Object::releaseOwnership(pyResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SideBarInterfaceFunc_createSideBarWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarInterfaceWrapper *>(reinterpret_cast< ::SideBarInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: SideBarInterface::createSideBarWidget(BrowserWindow*)->QWidget*
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_BrowserWindow_IDX]), (pyArg)))) {
        overloadId = 0; // createSideBarWidget(BrowserWindow*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "createSideBarWidget", errInfo, SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::BrowserWindow *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // createSideBarWidget(BrowserWindow*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.createSideBarWidget");
                return {};
            }
            QWidget * cppResult = cppSelf->createSideBarWidget(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_SideBarInterfaceFunc_title(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = static_cast<SideBarInterfaceWrapper *>(reinterpret_cast< ::SideBarInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), reinterpret_cast<SbkObject *>(self))));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // title()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("SideBarInterface.title");
            return {};
        }
        QString cppResult = const_cast<const SideBarInterfaceWrapper *>(cppSelf)->title();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}


static const char *Sbk_SideBarInterface_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_SideBarInterface_methods[] = {
    {"createMenuAction", reinterpret_cast<PyCFunction>(Sbk_SideBarInterfaceFunc_createMenuAction), METH_NOARGS, nullptr},
    {"createSideBarWidget", reinterpret_cast<PyCFunction>(Sbk_SideBarInterfaceFunc_createSideBarWidget), METH_O, nullptr},
    {"title", reinterpret_cast<PyCFunction>(Sbk_SideBarInterfaceFunc_title), METH_NOARGS, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_SideBarInterface_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::SideBarInterface *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<SideBarInterfaceWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_SideBarInterface_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_SideBarInterface_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_SideBarInterface_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_SideBarInterface_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_SideBarInterface_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_SideBarInterface_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_SideBarInterface_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_SideBarInterface_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_SideBarInterface_spec = {
    "1:PyFalkon.SideBarInterface",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_SideBarInterface_slots
};

} //extern "C"

static void *Sbk_SideBarInterface_typeDiscovery(void *cptr, PyTypeObject *instanceType)
{
    SBK_UNUSED(cptr)
    SBK_UNUSED(instanceType)
    if (instanceType == Shiboken::SbkType< ::QObject >())
        return dynamic_cast< ::SideBarInterface *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void SideBarInterface_PythonToCpp_SideBarInterface_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_SideBarInterface_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_SideBarInterface_PythonToCpp_SideBarInterface_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_SideBarInterface_TypeF()))
        return SideBarInterface_PythonToCpp_SideBarInterface_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *SideBarInterface_PTR_CppToPython_SideBarInterface(const void *cppIn)
{
    return PySide::getWrapperForQObject(reinterpret_cast<::SideBarInterface *>(const_cast<void *>(cppIn)), Sbk_SideBarInterface_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *SideBarInterface_SignatureStrings[] = {
    "PyFalkon.SideBarInterface(self,parent:PySide6.QtCore.QObject=nullptr)",
    "PyFalkon.SideBarInterface.createMenuAction(self)->PySide6.QtGui.QAction",
    "PyFalkon.SideBarInterface.createSideBarWidget(self,mainWindow:PyFalkon.BrowserWindow)->PySide6.QtWidgets.QWidget",
    "PyFalkon.SideBarInterface.title(self)->QString",
    nullptr}; // Sentinel
#else
static constexpr size_t SideBarInterface_SignatureByteSize = 162;
static constexpr uint8_t SideBarInterface_SignatureBytes[162] = {
    0x78, 0xda, 0x85, 0x8e, 0xbd, 0x0a, 0xc2, 0x40, 0x10, 0x84, 0xfb, 0x3c, 0x89, 0x01, 0xbd, 0xd2,
    0x22, 0xa0, 0x60, 0x04, 0xc5, 0x42, 0xbc, 0x23, 0x45, 0xea, 0xf3, 0xb2, 0x09, 0xab, 0xe7, 0x5e,
    0xd8, 0x6c, 0x08, 0x79, 0x7b, 0xd1, 0xf3, 0x07, 0x0b, 0xb5, 0x1b, 0x66, 0x98, 0x6f, 0x46, 0x8f,
    0x1b, 0xeb, 0xcf, 0x81, 0x54, 0x81, 0x15, 0xe4, 0x96, 0x77, 0x24, 0xc0, 0xb5, 0x75, 0x30, 0xe9,
    0xc0, 0xd7, 0xd3, 0xd6, 0x32, 0x90, 0x64, 0x7a, 0xbc, 0xc5, 0x73, 0x65, 0x64, 0x1d, 0x18, 0x94,
    0x39, 0x1c, 0x4f, 0xe0, 0x64, 0x41, 0xbd, 0xf7, 0xad, 0x70, 0x9a, 0xe8, 0x6f, 0x14, 0xe5, 0x18,
    0xac, 0xc0, 0x1e, 0xa8, 0x5f, 0x39, 0xc1, 0x40, 0x77, 0x6c, 0x3a, 0x5b, 0xbe, 0x89, 0xdb, 0x1e,
    0x95, 0x89, 0xe1, 0x5f, 0xce, 0xc3, 0x2e, 0xb1, 0x6a, 0x40, 0xe2, 0xc3, 0x8b, 0x45, 0x2a, 0x91,
    0xaa, 0x30, 0x64, 0xaf, 0x76, 0xce, 0x61, 0xe8, 0x80, 0xa3, 0xfd, 0x31, 0x16, 0x9b, 0x9d, 0x32,
    0x51, 0xfc, 0x18, 0x14, 0x14, 0x0f, 0xcf, 0xb7, 0xa6, 0x10, 0x46, 0x6a, 0x92, 0x2b, 0xa5, 0x14,
    0x6e, 0x86
};
#endif

PyTypeObject *init_SideBarInterface(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX].type;

    Shiboken::AutoDecRef Sbk_SideBarInterface_Type_bases(PyTuple_Pack(1,
        reinterpret_cast<PyObject *>(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QObject_IDX]))));

    _Sbk_SideBarInterface_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "SideBarInterface",
        "SideBarInterface*",
        &Sbk_SideBarInterface_spec,
        &Shiboken::callCppDestructor< SideBarInterface >,
        Sbk_SideBarInterface_Type_bases.object(),
        0);
    auto *pyType = _Sbk_SideBarInterface_Type; // references _Sbk_SideBarInterface_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, SideBarInterface_SignatureStrings);
#else
    InitSignatureBytes(pyType, SideBarInterface_SignatureBytes, SideBarInterface_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_SideBarInterface_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_SideBarInterface_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        SideBarInterface_PythonToCpp_SideBarInterface_PTR,
        is_SideBarInterface_PythonToCpp_SideBarInterface_PTR_Convertible,
        SideBarInterface_PTR_CppToPython_SideBarInterface);

    Shiboken::Conversions::registerConverterName(converter, "SideBarInterface");
    Shiboken::Conversions::registerConverterName(converter, "SideBarInterface*");
    Shiboken::Conversions::registerConverterName(converter, "SideBarInterface&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::SideBarInterface).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(SideBarInterfaceWrapper).name());

    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(
        Sbk_SideBarInterface_TypeF(), &Sbk_SideBarInterface_typeDiscovery);

    SideBarInterfaceWrapper::pysideInitQtMetaTypes();
    Shiboken::ObjectType::setSubTypeInitHook(pyType, &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(pyType, &::SideBarInterface::staticMetaObject, sizeof(SideBarInterfaceWrapper));

    return pyType;
}
