
// default includes
#include <shiboken.h>
#include <sbkpep.h>
#include <sbkpepbuffer.h>

#define PYSIDE6_COMOPT_FULLNAME 1
#define PYSIDE6_COMOPT_COMPRESS 1
// TODO: #define PYSIDE6_COMOPT_FOLDING 1

#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QtCore/QDebug>
#include <pysideqenum.h>
#include <pysideqmetatype.h>
#include <pysideutils.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED


// module include
#include "pyfalkon_python.h"

// main header
#include "passwordbackend_wrapper.h"

// Wrappers providing overrides
#include "webview_wrapper.h"
#include "sidebarinterface_wrapper.h"
#include "passwordbackend_wrapper.h"
#include "plugininterface_wrapper.h"

#include <cctype>
#include <cstring>
#include <iterator>
#include <type_traits>
#include <typeinfo>

extern "C" {
static PyTypeObject *_Sbk_PasswordBackend_Type = nullptr;
static PyTypeObject *Sbk_PasswordBackend_TypeF(void)
{
    return _Sbk_PasswordBackend_Type;
}
} // extern "C"

// Native ---------------------------------------------------------

void PasswordBackendWrapper::pysideInitQtMetaTypes()
{
    qRegisterMetaType< ::PasswordBackend *>();
}

void PasswordBackendWrapper::resetPyMethodCache()
{
    std::fill(m_PyMethodCache.begin(), m_PyMethodCache.end(), nullptr);
}

PasswordBackendWrapper::PasswordBackendWrapper()
{
}

void PasswordBackendWrapper::addEntry(const ::PasswordEntry & entry)
{
    static const char *funcName = "addEntry";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[0], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.addEntry");
        return;
    }
    sbk_o_addEntry("PasswordBackend", funcName, gil, pyOverride, entry);
}

void PasswordBackendWrapper::sbk_o_addEntry(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::PasswordEntry & entry)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

::QList<PasswordEntry> PasswordBackendWrapper::getAllEntries()
{
    static const char *funcName = "getAllEntries";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[1], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.getAllEntries");
        return {};
    }
    return sbk_o_getAllEntries("PasswordBackend", funcName, gil, pyOverride);
}

::QList<PasswordEntry> PasswordBackendWrapper::sbk_o_getAllEntries(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if defined(PYPY_VERSION) || (defined(Py_LIMITED_API) && Py_LIMITED_API < 0x030A0000)
    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));
#endif

#if !defined(PYPY_VERSION) && ((defined(Py_LIMITED_API) && Py_LIMITED_API >= 0x030A0000) || !defined(Py_LIMITED_API))
    Shiboken::AutoDecRef pyResult(PyObject_CallNoArgs(pyOverride));
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<PasswordEntry> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QList<PasswordEntry> PasswordBackendWrapper::getEntries(const ::QUrl & url)
{
    static const char *funcName = "getEntries";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[2], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.getEntries");
        return {};
    }
    return sbk_o_getEntries("PasswordBackend", funcName, gil, pyOverride, url);
}

::QList<PasswordEntry> PasswordBackendWrapper::sbk_o_getEntries(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & url)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return {};
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "list", Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QList<PasswordEntry> cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStringList PasswordBackendWrapper::getUsernames(const ::QUrl & url)
{
    static const char *funcName = "getUsernames";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[3], nameCache));
    if (pyOverride.isNull()) {
        return this->::PasswordBackend::getUsernames(url);
    }
    return sbk_o_getUsernames("PasswordBackend", funcName, gil, pyOverride, url);
}

::QStringList PasswordBackendWrapper::sbk_o_getUsernames(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::QUrl & url)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), &url)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return ::QStringList();
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "QStringList", Py_TYPE(pyResult)->tp_name);
        return ::QStringList();
    }
    ::QStringList cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool PasswordBackendWrapper::hasSettings() const
{
    static const char *funcName = "hasSettings";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[4], nameCache));
    if (pyOverride.isNull()) {
        return this->::PasswordBackend::hasSettings();
    }
    return WebViewWrapper::sbk_o_hasHeightForWidth("PasswordBackend", funcName, gil, pyOverride);
}

::QString PasswordBackendWrapper::name() const
{
    static const char *funcName = "name";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[5], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.name");
        return ::QString();
    }
    return SideBarInterfaceWrapper::sbk_o_title("PasswordBackend", funcName, gil, pyOverride);
}

void PasswordBackendWrapper::removeAll()
{
    static const char *funcName = "removeAll";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[6], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.removeAll");
        return;
    }
    WebViewWrapper::sbk_o_closeView("PasswordBackend", funcName, gil, pyOverride);
}

void PasswordBackendWrapper::removeEntry(const ::PasswordEntry & entry)
{
    static const char *funcName = "removeEntry";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[7], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.removeEntry");
        return;
    }
    PasswordBackendWrapper::sbk_o_addEntry("PasswordBackend", funcName, gil, pyOverride, entry);
}

void PasswordBackendWrapper::setActive(bool active)
{
    static const char *funcName = "setActive";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[8], nameCache));
    if (pyOverride.isNull()) {
        return this->::PasswordBackend::setActive(active);
    }
    WebViewWrapper::sbk_o_requestFullScreen("PasswordBackend", funcName, gil, pyOverride, active);
}

void PasswordBackendWrapper::showSettings(::QWidget * parent)
{
    static const char *funcName = "showSettings";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[9], nameCache));
    if (pyOverride.isNull()) {
        return this->::PasswordBackend::showSettings(parent);
    }
    PluginInterfaceWrapper::sbk_o_showSettings("PasswordBackend", funcName, gil, pyOverride, parent);
}

bool PasswordBackendWrapper::updateEntry(const ::PasswordEntry & entry)
{
    static const char *funcName = "updateEntry";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[10], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.updateEntry");
        return false;
    }
    return sbk_o_updateEntry("PasswordBackend", funcName, gil, pyOverride, entry);
}

bool PasswordBackendWrapper::sbk_o_updateEntry(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, const ::PasswordEntry & entry)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::copyToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return false;
    }
    // Check return type
    Shiboken::Conversions::PythonToCppConversion pythonToCpp =
        Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::Warnings::warnInvalidReturnValue(ownerClassName, funcName, "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void PasswordBackendWrapper::updateLastUsed(::PasswordEntry & entry)
{
    static const char *funcName = "updateLastUsed";
    static PyObject *nameCache[2] = {};
    Shiboken::GilState gil(false);
    Shiboken::AutoDecRef pyOverride(Sbk_GetPyOverride(this, Sbk_PasswordBackend_TypeF(), gil, funcName, m_PyMethodCache[11], nameCache));
    if (pyOverride.isNull()) {
        gil.acquire();
        Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.updateLastUsed");
        return;
    }
    sbk_o_updateLastUsed("PasswordBackend", funcName, gil, pyOverride, entry);
}

void PasswordBackendWrapper::sbk_o_updateLastUsed(const char *ownerClassName, const char *funcName, Shiboken::GilState &gil, const Shiboken::AutoDecRef &pyOverride, ::PasswordEntry & entry)
{
    SBK_UNUSED(ownerClassName)
    SBK_UNUSED(funcName)
    SBK_UNUSED(gil)
    SBK_UNUSED(pyOverride)
#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    PyObject *pyArgArray[1] = {
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    };
#else
    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
        Shiboken::Conversions::referenceToPython(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), &entry)
    ));
#endif

#if !defined(PYPY_VERSION) && !defined(Py_LIMITED_API)
    Shiboken::AutoDecRef pyResult(PyObject_Vectorcall(pyOverride, pyArgArray, 1, nullptr));
    Py_DECREF(pyArgArray[0]);
#else
    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
#endif
    if (pyResult.isNull()) {
        // An error happened in python code!
        Shiboken::Errors::storePythonOverrideErrorOrPrint(ownerClassName, funcName);
        return;
    }
}

PasswordBackendWrapper::~PasswordBackendWrapper()
{
    auto *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this, Sbk_PasswordBackend_TypeF());
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_PasswordBackend_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SBK_UNUSED(args)
    SBK_UNUSED(kwds)
    auto *sbkSelf = reinterpret_cast<SbkObject *>(self);
    PyTypeObject *type = self->ob_type;
    PyTypeObject *myType = Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);
    if (type == myType) {
        Shiboken::Errors::setInstantiateAbstractClass("PasswordBackend");
        return -1;
    }

    PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::PasswordBackend >()))
        return -1;

    PasswordBackendWrapper *cptr{};
    Shiboken::PythonContextMarker pcm;


    // PyMI support
    Shiboken::callInheritedInit(self, args, kwds, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);
    if (Shiboken::Errors::occurred() != nullptr)
        return -1;

    // Call function/method
    {

        // PasswordBackend()
        cptr = new PasswordBackendWrapper();
    }

    if (Shiboken::Errors::occurred() != nullptr || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< PasswordBackend >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_PasswordBackendFunc_addEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::addEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // addEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "addEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // addEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.addEntry");
                return {};
            }
            cppSelf->addEntry(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordBackendFunc_getAllEntries(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // getAllEntries()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.getAllEntries");
            return {};
        }
        QList<PasswordEntry> cppResult = cppSelf->getAllEntries();
        pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_getEntries(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::getEntries(QUrl)->QList<PasswordEntry>
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getEntries(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getEntries", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getEntries(QUrl)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.getEntries");
                return {};
            }
            QList<PasswordEntry> cppResult = cppSelf->getEntries(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPyFalkonTypeConverters[SBK_PyFalkon_QList_PasswordEntry_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_getUsernames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::getUsernames(QUrl)->QStringList
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPySide6_QtCoreTypeStructs[SBK_QUrl_IDX]), (pyArg)))) {
        overloadId = 0; // getUsernames(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "getUsernames", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // getUsernames(QUrl)
            QStringList cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::getUsernames(*cppArg0)
                : cppSelf->getUsernames(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QStringList_IDX], &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_hasSettings(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // hasSettings()const
        bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
            ? const_cast<const PasswordBackend *>(cppSelf)->::PasswordBackend::hasSettings()
            : const_cast<const PasswordBackend *>(cppSelf)->hasSettings();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_isActive(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // isActive()const
        bool cppResult = const_cast<const PasswordBackend *>(cppSelf)->isActive();
        pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // name()const
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.name");
            return {};
        }
        QString cppResult = const_cast<const PasswordBackend *>(cppSelf)->name();
        pyResult = Shiboken::Conversions::copyToPython(SbkPySide6_QtCoreTypeConverters[SBK_QString_IDX], &cppResult);
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_removeAll(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::PythonContextMarker pcm;

    // Call function/method
    {

        // removeAll()
        if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
            Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.removeAll");
            return {};
        }
        cppSelf->removeAll();
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordBackendFunc_removeEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::removeEntry(PasswordEntry)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // removeEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "removeEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // removeEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.removeEntry");
                return {};
            }
            cppSelf->removeEntry(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordBackendFunc_setActive(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::setActive(bool)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppConversion(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setActive(bool)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "setActive", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // setActive(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::setActive(cppArg0)
                : cppSelf->setActive(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordBackendFunc_showSettings(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::showSettings(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppPointerConversion(Shiboken::Module::get(SbkPySide6_QtWidgetsTypeStructs[SBK_QWidget_IDX]), (pyArg)))) {
        overloadId = 0; // showSettings(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "showSettings", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (Shiboken::Errors::occurred() == nullptr) {
            // showSettings(QWidget*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::PasswordBackend::showSettings(cppArg0)
                : cppSelf->showSettings(cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}

static PyObject *Sbk_PasswordBackendFunc_updateEntry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::updateEntry(PasswordEntry)->bool
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // updateEntry(PasswordEntry)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateEntry", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // updateEntry(PasswordEntry)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.updateEntry");
                return {};
            }
            bool cppResult = cppSelf->updateEntry(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    return Sbk_ReturnFromPython_Result(pyResult);
}

static PyObject *Sbk_PasswordBackendFunc_updateLastUsed(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto *cppSelf = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    Shiboken::AutoDecRef errInfo{};
    Shiboken::PythonContextMarker pcm;
    int overloadId = -1;
    Shiboken::Conversions::PythonToCppConversion pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: PasswordBackend::updateLastUsed(PasswordEntry&)
    if ((pythonToCpp = Shiboken::Conversions::pythonToCppReferenceConversion(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordEntry_IDX]), (pyArg)))) {
        overloadId = 0; // updateLastUsed(PasswordEntry&)
    }

    // Function signature not found.
    if (overloadId == -1)
        return Shiboken::returnWrongArguments(pyArg, "updateLastUsed", errInfo, SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]);

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::PasswordEntry cppArg0_local;
        ::PasswordEntry *cppArg0 = &cppArg0_local;
        if (pythonToCpp.isValue())
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (Shiboken::Errors::occurred() == nullptr) {
            // updateLastUsed(PasswordEntry&)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                Shiboken::Errors::setPureVirtualMethodError("PasswordBackend.updateLastUsed");
                return {};
            }
            cppSelf->updateLastUsed(*cppArg0);
        }
    }

     return Sbk_ReturnFromPython_None();
}


static const char *Sbk_PasswordBackend_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_PasswordBackend_methods[] = {
    {"addEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_addEntry), METH_O, nullptr},
    {"getAllEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getAllEntries), METH_NOARGS, nullptr},
    {"getEntries", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getEntries), METH_O, nullptr},
    {"getUsernames", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_getUsernames), METH_O, nullptr},
    {"hasSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_hasSettings), METH_NOARGS, nullptr},
    {"isActive", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_isActive), METH_NOARGS, nullptr},
    {"name", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_name), METH_NOARGS, nullptr},
    {"removeAll", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_removeAll), METH_NOARGS, nullptr},
    {"removeEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_removeEntry), METH_O, nullptr},
    {"setActive", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_setActive), METH_O, nullptr},
    {"showSettings", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_showSettings), METH_O, nullptr},
    {"updateEntry", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_updateEntry), METH_O, nullptr},
    {"updateLastUsed", reinterpret_cast<PyCFunction>(Sbk_PasswordBackendFunc_updateLastUsed), METH_O, nullptr},
    {nullptr, nullptr, 0, nullptr} // Sentinel
};

static int Sbk_PasswordBackend_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value != nullptr && PyCallable_Check(value) != 0) {
        auto plain_inst = reinterpret_cast< ::PasswordBackend *>(Shiboken::Conversions::cppPointer(Shiboken::Module::get(SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX]), reinterpret_cast<SbkObject *>(self)));
        auto *inst = dynamic_cast<PasswordBackendWrapper *>(plain_inst);
        if (inst != nullptr)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_PasswordBackend_traverse(PyObject *self, visitproc visit, void *arg)
{
    auto traverseProc = reinterpret_cast<traverseproc>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_traverse));
    ;
    return traverseProc(self, visit, arg);
}
static int Sbk_PasswordBackend_clear(PyObject *self)
{
    auto clearProc = reinterpret_cast<inquiry>(PepType_GetSlot(SbkObject_TypeF(), Py_tp_clear));
    ;
    return clearProc(self);
}

// Class Definition -----------------------------------------------
extern "C" {

static PyType_Slot Sbk_PasswordBackend_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_PasswordBackend_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_PasswordBackend_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_PasswordBackend_clear)},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_PasswordBackend_methods)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_PasswordBackend_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObject_tp_new)},
    {0, nullptr}
};
static PyType_Spec Sbk_PasswordBackend_spec = {
    "1:PyFalkon.PasswordBackend",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_HAVE_GC,
    Sbk_PasswordBackend_slots
};

} //extern "C"

// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void PasswordBackend_PythonToCpp_PasswordBackend_PTR(PyObject *pyIn, void *cppOut)
{
    Shiboken::Conversions::pythonToCppPointer(Sbk_PasswordBackend_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_PasswordBackend_PythonToCpp_PasswordBackend_PTR_Convertible(PyObject *pyIn)
{
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, Sbk_PasswordBackend_TypeF()))
        return PasswordBackend_PythonToCpp_PasswordBackend_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *PasswordBackend_PTR_CppToPython_PasswordBackend(const void *cppIn)
{
    auto *pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn, Sbk_PasswordBackend_TypeF()));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    auto *tCppIn = reinterpret_cast<const ::PasswordBackend *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    return Shiboken::Object::newObjectForPointer(Sbk_PasswordBackend_TypeF(), const_cast<void *>(cppIn), false, typeName);

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
#if PYSIDE6_COMOPT_COMPRESS == 0
static const char *PasswordBackend_SignatureStrings[] = {
    "PyFalkon.PasswordBackend(self)",
    "PyFalkon.PasswordBackend.addEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordBackend.getAllEntries(self)->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordBackend.getEntries(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QList[PyFalkon.PasswordEntry]",
    "PyFalkon.PasswordBackend.getUsernames(self,url:typing.Union[PySide6.QtCore.QUrl, QString])->QStringList",
    "PyFalkon.PasswordBackend.hasSettings(self)->bool",
    "PyFalkon.PasswordBackend.isActive(self)->bool",
    "PyFalkon.PasswordBackend.name(self)->QString",
    "PyFalkon.PasswordBackend.removeAll(self)",
    "PyFalkon.PasswordBackend.removeEntry(self,entry:PyFalkon.PasswordEntry)",
    "PyFalkon.PasswordBackend.setActive(self,active:bool)",
    "PyFalkon.PasswordBackend.showSettings(self,parent:PySide6.QtWidgets.QWidget)",
    "PyFalkon.PasswordBackend.updateEntry(self,entry:PyFalkon.PasswordEntry)->bool",
    "PyFalkon.PasswordBackend.updateLastUsed(self,entry:PyFalkon.PasswordEntry)",
    nullptr}; // Sentinel
#else
static constexpr size_t PasswordBackend_SignatureByteSize = 258;
static constexpr uint8_t PasswordBackend_SignatureBytes[258] = {
    0x78, 0xda, 0xa5, 0x52, 0xb1, 0x4e, 0xc3, 0x30, 0x10, 0xdd, 0xf9, 0x0a, 0x46, 0x90, 0x5c, 0x8f,
    0x1d, 0x32, 0x20, 0x15, 0x04, 0x53, 0x87, 0x58, 0x51, 0xc4, 0x80, 0x3a, 0x1c, 0xf5, 0x91, 0x5a,
    0x75, 0xed, 0xc8, 0x77, 0x6d, 0x95, 0xbf, 0xc7, 0x8e, 0xa5, 0x16, 0x44, 0x93, 0x46, 0x74, 0x3b,
    0xe9, 0xde, 0xbd, 0x77, 0x77, 0xef, 0x95, 0xdd, 0x1b, 0xd8, 0xad, 0x77, 0xb2, 0x04, 0xa2, 0xa3,
    0x0f, 0xfa, 0x19, 0xd6, 0x5b, 0x74, 0xfa, 0x81, 0xd0, 0x7e, 0x3d, 0xde, 0x95, 0x03, 0x6d, 0x09,
    0x5a, 0xbf, 0x3a, 0x0e, 0x5d, 0x8f, 0x13, 0x98, 0xca, 0xe2, 0x0f, 0xb8, 0x47, 0x8c, 0x90, 0x34,
    0xc8, 0x0b, 0x6b, 0x13, 0xca, 0x20, 0x65, 0xc5, 0xd9, 0x93, 0x5a, 0x1a, 0xe2, 0x8f, 0xcb, 0x5c,
    0xab, 0x51, 0xae, 0x9f, 0x44, 0x62, 0x1f, 0x6c, 0xc1, 0x5d, 0x6b, 0x5c, 0x23, 0x6b, 0x67, 0xbc,
    0x8b, 0x8c, 0x95, 0xd1, 0x38, 0x97, 0x8a, 0x5f, 0x7c, 0x40, 0xa9, 0xea, 0x60, 0xc5, 0xbd, 0xaa,
    0xe2, 0x88, 0x6b, 0x56, 0x37, 0xe9, 0xd6, 0x84, 0xc1, 0xc1, 0xee, 0xff, 0xca, 0xb9, 0x4c, 0xfa,
    0xc3, 0x3a, 0x1b, 0xa0, 0x0a, 0x99, 0x23, 0xee, 0xf4, 0xa9, 0x4f, 0xef, 0xed, 0xf0, 0x80, 0xa1,
    0xc5, 0x9a, 0xcd, 0x01, 0xa7, 0xa1, 0xd3, 0xfe, 0x27, 0x07, 0xf2, 0x3e, 0xc3, 0xe0, 0x80, 0x3b,
    0x7f, 0xc0, 0x68, 0xdd, 0xb5, 0x94, 0x64, 0xe0, 0xed, 0x41, 0xa1, 0x18, 0x94, 0xf3, 0x31, 0x02,
    0xfa, 0xba, 0x48, 0x17, 0x8d, 0x0d, 0x6d, 0xfc, 0xf1, 0xd7, 0xcb, 0x44, 0x0b, 0x21, 0x2e, 0x50,
    0x9c, 0xfd, 0x78, 0x37, 0x3a, 0xfa, 0x47, 0x52, 0xe5, 0x62, 0x84, 0x6c, 0xdf, 0x6a, 0xe0, 0xc9,
    0x97, 0x5c, 0xfb, 0x76, 0x66, 0x5b, 0x02, 0xa5, 0xec, 0xe8, 0x29, 0xaf, 0xf9, 0x06, 0x87, 0x0b,
    0x5c, 0xd3
};
#endif

PyTypeObject *init_PasswordBackend(PyObject *module)
{
    if (SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX].type != nullptr)
        return SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX].type;

    Shiboken::AutoDecRef Sbk_PasswordBackend_Type_bases(PyTuple_Pack(1,
        SbkObject_TypeF()));

    _Sbk_PasswordBackend_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "PasswordBackend",
        "PasswordBackend*",
        &Sbk_PasswordBackend_spec,
        &Shiboken::callCppDestructor< PasswordBackend >,
        Sbk_PasswordBackend_Type_bases.object(),
        0);
    auto *pyType = Sbk_PasswordBackend_TypeF(); // references _Sbk_PasswordBackend_Type
#if PYSIDE6_COMOPT_COMPRESS == 0
    InitSignatureStrings(pyType, PasswordBackend_SignatureStrings);
#else
    InitSignatureBytes(pyType, PasswordBackend_SignatureBytes, PasswordBackend_SignatureByteSize);
#endif
    SbkObjectType_SetPropertyStrings(pyType, Sbk_PasswordBackend_PropertyStrings);
    SbkPyFalkonTypeStructs[SBK_PasswordBackend_IDX].type = pyType;

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(pyType,
        PasswordBackend_PythonToCpp_PasswordBackend_PTR,
        is_PasswordBackend_PythonToCpp_PasswordBackend_PTR_Convertible,
        PasswordBackend_PTR_CppToPython_PasswordBackend);

    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend");
    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend*");
    Shiboken::Conversions::registerConverterName(converter, "PasswordBackend&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::PasswordBackend).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(PasswordBackendWrapper).name());

    PasswordBackendWrapper::pysideInitQtMetaTypes();

    return pyType;
}
