// Code generated by protoc-gen-gogo. DO NOT EDIT.
// source: git.proto

package git

import (
	context "context"
	fmt "fmt"
	proto "github.com/gogo/protobuf/proto"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	io "io"
	math "math"
	math_bits "math/bits"
	reflect "reflect"
	strconv "strconv"
	strings "strings"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.GoGoProtoPackageIsVersion3 // please upgrade the proto package

type ErrorInfo_ErrorType int32

const (
	UNKNOWN                     ErrorInfo_ErrorType = 0
	INVALID_REQUEST             ErrorInfo_ErrorType = 1
	NOT_FOUND                   ErrorInfo_ErrorType = 2
	TIMEOUT                     ErrorInfo_ErrorType = 3
	CREDENTIAL_RETRIEVAL_FAILED ErrorInfo_ErrorType = 4
	CONFIG_RETRIEVAL_FAILED     ErrorInfo_ErrorType = 5
)

var ErrorInfo_ErrorType_name = map[int32]string{
	0: "UNKNOWN",
	1: "INVALID_REQUEST",
	2: "NOT_FOUND",
	3: "TIMEOUT",
	4: "CREDENTIAL_RETRIEVAL_FAILED",
	5: "CONFIG_RETRIEVAL_FAILED",
}

var ErrorInfo_ErrorType_value = map[string]int32{
	"UNKNOWN":                     0,
	"INVALID_REQUEST":             1,
	"NOT_FOUND":                   2,
	"TIMEOUT":                     3,
	"CREDENTIAL_RETRIEVAL_FAILED": 4,
	"CONFIG_RETRIEVAL_FAILED":     5,
}

func (ErrorInfo_ErrorType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{7, 0}
}

type GitCredentialRequest struct {
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Host     string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	Path     string `protobuf:"bytes,3,opt,name=path,proto3" json:"path,omitempty"`
}

func (m *GitCredentialRequest) Reset()      { *m = GitCredentialRequest{} }
func (*GitCredentialRequest) ProtoMessage() {}
func (*GitCredentialRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{0}
}
func (m *GitCredentialRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitCredentialRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitCredentialRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitCredentialRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitCredentialRequest.Merge(m, src)
}
func (m *GitCredentialRequest) XXX_Size() int {
	return m.Size()
}
func (m *GitCredentialRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GitCredentialRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GitCredentialRequest proto.InternalMessageInfo

func (m *GitCredentialRequest) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *GitCredentialRequest) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *GitCredentialRequest) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

type GitCredentialResponse struct {
	// Types that are valid to be assigned to Result:
	//
	//	*GitCredentialResponse_Credential
	//	*GitCredentialResponse_Error
	Result isGitCredentialResponse_Result `protobuf_oneof:"result"`
}

func (m *GitCredentialResponse) Reset()      { *m = GitCredentialResponse{} }
func (*GitCredentialResponse) ProtoMessage() {}
func (*GitCredentialResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{1}
}
func (m *GitCredentialResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitCredentialResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitCredentialResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitCredentialResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitCredentialResponse.Merge(m, src)
}
func (m *GitCredentialResponse) XXX_Size() int {
	return m.Size()
}
func (m *GitCredentialResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GitCredentialResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GitCredentialResponse proto.InternalMessageInfo

type isGitCredentialResponse_Result interface {
	isGitCredentialResponse_Result()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type GitCredentialResponse_Credential struct {
	Credential *CredentialInfo `protobuf:"bytes,1,opt,name=credential,proto3,oneof" json:"credential,omitempty"`
}
type GitCredentialResponse_Error struct {
	Error *ErrorInfo `protobuf:"bytes,2,opt,name=error,proto3,oneof" json:"error,omitempty"`
}

func (*GitCredentialResponse_Credential) isGitCredentialResponse_Result() {}
func (*GitCredentialResponse_Error) isGitCredentialResponse_Result()      {}

func (m *GitCredentialResponse) GetResult() isGitCredentialResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *GitCredentialResponse) GetCredential() *CredentialInfo {
	if x, ok := m.GetResult().(*GitCredentialResponse_Credential); ok {
		return x.Credential
	}
	return nil
}

func (m *GitCredentialResponse) GetError() *ErrorInfo {
	if x, ok := m.GetResult().(*GitCredentialResponse_Error); ok {
		return x.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GitCredentialResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GitCredentialResponse_Credential)(nil),
		(*GitCredentialResponse_Error)(nil),
	}
}

type CredentialInfo struct {
	Protocol string `protobuf:"bytes,1,opt,name=protocol,proto3" json:"protocol,omitempty"`
	Host     string `protobuf:"bytes,2,opt,name=host,proto3" json:"host,omitempty"`
	Username string `protobuf:"bytes,3,opt,name=username,proto3" json:"username,omitempty"`
	Password string `protobuf:"bytes,4,opt,name=password,proto3" json:"password,omitempty"`
}

func (m *CredentialInfo) Reset()      { *m = CredentialInfo{} }
func (*CredentialInfo) ProtoMessage() {}
func (*CredentialInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{2}
}
func (m *CredentialInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *CredentialInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_CredentialInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *CredentialInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_CredentialInfo.Merge(m, src)
}
func (m *CredentialInfo) XXX_Size() int {
	return m.Size()
}
func (m *CredentialInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_CredentialInfo.DiscardUnknown(m)
}

var xxx_messageInfo_CredentialInfo proto.InternalMessageInfo

func (m *CredentialInfo) GetProtocol() string {
	if m != nil {
		return m.Protocol
	}
	return ""
}

func (m *CredentialInfo) GetHost() string {
	if m != nil {
		return m.Host
	}
	return ""
}

func (m *CredentialInfo) GetUsername() string {
	if m != nil {
		return m.Username
	}
	return ""
}

func (m *CredentialInfo) GetPassword() string {
	if m != nil {
		return m.Password
	}
	return ""
}

type GitConfigRequest struct {
}

func (m *GitConfigRequest) Reset()      { *m = GitConfigRequest{} }
func (*GitConfigRequest) ProtoMessage() {}
func (*GitConfigRequest) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{3}
}
func (m *GitConfigRequest) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitConfigRequest) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitConfigRequest.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitConfigRequest) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitConfigRequest.Merge(m, src)
}
func (m *GitConfigRequest) XXX_Size() int {
	return m.Size()
}
func (m *GitConfigRequest) XXX_DiscardUnknown() {
	xxx_messageInfo_GitConfigRequest.DiscardUnknown(m)
}

var xxx_messageInfo_GitConfigRequest proto.InternalMessageInfo

type GitConfigResponse struct {
	// Types that are valid to be assigned to Result:
	//
	//	*GitConfigResponse_Config
	//	*GitConfigResponse_Error
	Result isGitConfigResponse_Result `protobuf_oneof:"result"`
}

func (m *GitConfigResponse) Reset()      { *m = GitConfigResponse{} }
func (*GitConfigResponse) ProtoMessage() {}
func (*GitConfigResponse) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{4}
}
func (m *GitConfigResponse) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitConfigResponse) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitConfigResponse.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitConfigResponse) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitConfigResponse.Merge(m, src)
}
func (m *GitConfigResponse) XXX_Size() int {
	return m.Size()
}
func (m *GitConfigResponse) XXX_DiscardUnknown() {
	xxx_messageInfo_GitConfigResponse.DiscardUnknown(m)
}

var xxx_messageInfo_GitConfigResponse proto.InternalMessageInfo

type isGitConfigResponse_Result interface {
	isGitConfigResponse_Result()
	Equal(interface{}) bool
	MarshalTo([]byte) (int, error)
	Size() int
}

type GitConfigResponse_Config struct {
	Config *GitConfig `protobuf:"bytes,1,opt,name=config,proto3,oneof" json:"config,omitempty"`
}
type GitConfigResponse_Error struct {
	Error *ErrorInfo `protobuf:"bytes,2,opt,name=error,proto3,oneof" json:"error,omitempty"`
}

func (*GitConfigResponse_Config) isGitConfigResponse_Result() {}
func (*GitConfigResponse_Error) isGitConfigResponse_Result()  {}

func (m *GitConfigResponse) GetResult() isGitConfigResponse_Result {
	if m != nil {
		return m.Result
	}
	return nil
}

func (m *GitConfigResponse) GetConfig() *GitConfig {
	if x, ok := m.GetResult().(*GitConfigResponse_Config); ok {
		return x.Config
	}
	return nil
}

func (m *GitConfigResponse) GetError() *ErrorInfo {
	if x, ok := m.GetResult().(*GitConfigResponse_Error); ok {
		return x.Error
	}
	return nil
}

// XXX_OneofWrappers is for the internal use of the proto package.
func (*GitConfigResponse) XXX_OneofWrappers() []interface{} {
	return []interface{}{
		(*GitConfigResponse_Config)(nil),
		(*GitConfigResponse_Error)(nil),
	}
}

type GitConfig struct {
	Entries []*GitConfigEntry `protobuf:"bytes,1,rep,name=entries,proto3" json:"entries,omitempty"`
}

func (m *GitConfig) Reset()      { *m = GitConfig{} }
func (*GitConfig) ProtoMessage() {}
func (*GitConfig) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{5}
}
func (m *GitConfig) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitConfig) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitConfig.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitConfig) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitConfig.Merge(m, src)
}
func (m *GitConfig) XXX_Size() int {
	return m.Size()
}
func (m *GitConfig) XXX_DiscardUnknown() {
	xxx_messageInfo_GitConfig.DiscardUnknown(m)
}

var xxx_messageInfo_GitConfig proto.InternalMessageInfo

func (m *GitConfig) GetEntries() []*GitConfigEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

type GitConfigEntry struct {
	Key   string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
}

func (m *GitConfigEntry) Reset()      { *m = GitConfigEntry{} }
func (*GitConfigEntry) ProtoMessage() {}
func (*GitConfigEntry) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{6}
}
func (m *GitConfigEntry) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *GitConfigEntry) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_GitConfigEntry.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *GitConfigEntry) XXX_Merge(src proto.Message) {
	xxx_messageInfo_GitConfigEntry.Merge(m, src)
}
func (m *GitConfigEntry) XXX_Size() int {
	return m.Size()
}
func (m *GitConfigEntry) XXX_DiscardUnknown() {
	xxx_messageInfo_GitConfigEntry.DiscardUnknown(m)
}

var xxx_messageInfo_GitConfigEntry proto.InternalMessageInfo

func (m *GitConfigEntry) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *GitConfigEntry) GetValue() string {
	if m != nil {
		return m.Value
	}
	return ""
}

type ErrorInfo struct {
	Type    ErrorInfo_ErrorType `protobuf:"varint,1,opt,name=type,proto3,enum=dagger.git.ErrorInfo_ErrorType" json:"type,omitempty"`
	Message string              `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (m *ErrorInfo) Reset()      { *m = ErrorInfo{} }
func (*ErrorInfo) ProtoMessage() {}
func (*ErrorInfo) Descriptor() ([]byte, []int) {
	return fileDescriptor_0d2ecb6e8d788208, []int{7}
}
func (m *ErrorInfo) XXX_Unmarshal(b []byte) error {
	return m.Unmarshal(b)
}
func (m *ErrorInfo) XXX_Marshal(b []byte, deterministic bool) ([]byte, error) {
	if deterministic {
		return xxx_messageInfo_ErrorInfo.Marshal(b, m, deterministic)
	} else {
		b = b[:cap(b)]
		n, err := m.MarshalToSizedBuffer(b)
		if err != nil {
			return nil, err
		}
		return b[:n], nil
	}
}
func (m *ErrorInfo) XXX_Merge(src proto.Message) {
	xxx_messageInfo_ErrorInfo.Merge(m, src)
}
func (m *ErrorInfo) XXX_Size() int {
	return m.Size()
}
func (m *ErrorInfo) XXX_DiscardUnknown() {
	xxx_messageInfo_ErrorInfo.DiscardUnknown(m)
}

var xxx_messageInfo_ErrorInfo proto.InternalMessageInfo

func (m *ErrorInfo) GetType() ErrorInfo_ErrorType {
	if m != nil {
		return m.Type
	}
	return UNKNOWN
}

func (m *ErrorInfo) GetMessage() string {
	if m != nil {
		return m.Message
	}
	return ""
}

func init() {
	proto.RegisterEnum("dagger.git.ErrorInfo_ErrorType", ErrorInfo_ErrorType_name, ErrorInfo_ErrorType_value)
	proto.RegisterType((*GitCredentialRequest)(nil), "dagger.git.GitCredentialRequest")
	proto.RegisterType((*GitCredentialResponse)(nil), "dagger.git.GitCredentialResponse")
	proto.RegisterType((*CredentialInfo)(nil), "dagger.git.CredentialInfo")
	proto.RegisterType((*GitConfigRequest)(nil), "dagger.git.GitConfigRequest")
	proto.RegisterType((*GitConfigResponse)(nil), "dagger.git.GitConfigResponse")
	proto.RegisterType((*GitConfig)(nil), "dagger.git.GitConfig")
	proto.RegisterType((*GitConfigEntry)(nil), "dagger.git.GitConfigEntry")
	proto.RegisterType((*ErrorInfo)(nil), "dagger.git.ErrorInfo")
}

func init() { proto.RegisterFile("git.proto", fileDescriptor_0d2ecb6e8d788208) }

var fileDescriptor_0d2ecb6e8d788208 = []byte{
	// 577 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x9c, 0x53, 0x4d, 0x6f, 0xd3, 0x40,
	0x10, 0xf5, 0xd6, 0x69, 0x13, 0x4f, 0xd4, 0x60, 0x96, 0x56, 0x58, 0x29, 0x6c, 0x83, 0x4f, 0x5c,
	0x08, 0x52, 0xca, 0x01, 0x24, 0x2e, 0x69, 0xe2, 0x24, 0x16, 0xc1, 0x11, 0xc6, 0x29, 0x52, 0x2f,
	0x91, 0x49, 0xb6, 0xae, 0x45, 0x6a, 0x07, 0x7b, 0x03, 0xe4, 0x80, 0xc4, 0x8d, 0x1b, 0xe2, 0x4f,
	0x20, 0xf1, 0x53, 0x38, 0xe6, 0xd8, 0x23, 0x71, 0x38, 0x70, 0xec, 0x4f, 0x40, 0xfe, 0x88, 0x9b,
	0x84, 0x82, 0x04, 0xb7, 0x99, 0x37, 0x6f, 0x9e, 0x76, 0xde, 0xec, 0x80, 0x60, 0xd9, 0xac, 0x3c,
	0xf2, 0x5c, 0xe6, 0x62, 0x18, 0x98, 0x96, 0x45, 0xbd, 0xb2, 0x65, 0x33, 0xf9, 0x18, 0x76, 0x9a,
	0x36, 0xab, 0x79, 0x74, 0x40, 0x1d, 0x66, 0x9b, 0x43, 0x9d, 0xbe, 0x1e, 0x53, 0x9f, 0xe1, 0x22,
	0xe4, 0x22, 0x72, 0xdf, 0x1d, 0x4a, 0xa8, 0x84, 0xee, 0x0a, 0x7a, 0x9a, 0x63, 0x0c, 0x99, 0x53,
	0xd7, 0x67, 0xd2, 0x46, 0x84, 0x47, 0x71, 0x88, 0x8d, 0x4c, 0x76, 0x2a, 0xf1, 0x31, 0x16, 0xc6,
	0xf2, 0x27, 0x04, 0xbb, 0x6b, 0xe2, 0xfe, 0xc8, 0x75, 0x7c, 0x8a, 0x1f, 0x03, 0xf4, 0x53, 0x34,
	0xd2, 0xcf, 0x57, 0x8a, 0xe5, 0xcb, 0x67, 0x95, 0x2f, 0x7b, 0x54, 0xe7, 0xc4, 0x6d, 0x71, 0xfa,
	0x12, 0x1f, 0xdf, 0x83, 0x4d, 0xea, 0x79, 0xae, 0x17, 0x3d, 0x20, 0x5f, 0xd9, 0x5d, 0x6e, 0x54,
	0xc2, 0x42, 0xd2, 0x13, 0xb3, 0x0e, 0x73, 0xb0, 0xe5, 0x51, 0x7f, 0x3c, 0x64, 0xf2, 0x3b, 0x28,
	0xac, 0x0a, 0xff, 0xf3, 0x98, 0x45, 0xc8, 0x8d, 0x7d, 0xea, 0x39, 0xe6, 0x19, 0x4d, 0x46, 0x4d,
	0xf3, 0x48, 0xcb, 0xf4, 0xfd, 0xb7, 0xae, 0x37, 0x90, 0x32, 0x89, 0x56, 0x92, 0xcb, 0x18, 0xc4,
	0xd0, 0x09, 0xd7, 0x39, 0xb1, 0xad, 0xc4, 0x62, 0xf9, 0x3d, 0x5c, 0x5f, 0xc2, 0x12, 0x67, 0xee,
	0xc3, 0x56, 0x3f, 0x42, 0x12, 0x57, 0x56, 0x86, 0x4b, 0xe9, 0x2d, 0x4e, 0x4f, 0x68, 0xff, 0x6f,
	0x46, 0x15, 0x84, 0x54, 0x0f, 0x3f, 0x80, 0x2c, 0x75, 0x98, 0x67, 0x53, 0x5f, 0x42, 0x25, 0x7e,
	0x7d, 0x1b, 0x29, 0x4f, 0x71, 0x98, 0x37, 0xd1, 0x17, 0x54, 0xf9, 0x21, 0x14, 0x56, 0x4b, 0x58,
	0x04, 0xfe, 0x15, 0x9d, 0x24, 0x56, 0x86, 0x21, 0xde, 0x81, 0xcd, 0x37, 0xe6, 0x70, 0x4c, 0x13,
	0x1b, 0xe3, 0x44, 0xfe, 0x81, 0x40, 0x48, 0x5f, 0x87, 0x0f, 0x20, 0xc3, 0x26, 0x23, 0x1a, 0xb5,
	0x15, 0x2a, 0xfb, 0x57, 0x8e, 0x10, 0x47, 0xc6, 0x64, 0x44, 0xf5, 0x88, 0x8c, 0x25, 0xc8, 0x9e,
	0x51, 0xdf, 0x37, 0xad, 0x85, 0xf4, 0x22, 0x95, 0x3f, 0x2e, 0xc4, 0x43, 0x36, 0xce, 0x43, 0xb6,
	0xab, 0x3d, 0xd1, 0x3a, 0x2f, 0x34, 0x91, 0xc3, 0x37, 0xe0, 0x9a, 0xaa, 0x1d, 0x55, 0xdb, 0x6a,
	0xbd, 0xa7, 0x2b, 0xcf, 0xba, 0xca, 0x73, 0x43, 0x44, 0x78, 0x1b, 0x04, 0xad, 0x63, 0xf4, 0x1a,
	0x9d, 0xae, 0x56, 0x17, 0x37, 0xc2, 0x06, 0x43, 0x7d, 0xaa, 0x74, 0xba, 0x86, 0xc8, 0xe3, 0x7d,
	0xd8, 0xab, 0xe9, 0x4a, 0x5d, 0xd1, 0x0c, 0xb5, 0xda, 0xee, 0xe9, 0x8a, 0xa1, 0xab, 0xca, 0x51,
	0xb5, 0xdd, 0x6b, 0x54, 0xd5, 0xb6, 0x52, 0x17, 0x33, 0x78, 0x0f, 0x6e, 0xd6, 0x3a, 0x5a, 0x43,
	0x6d, 0xfe, 0x5e, 0xdc, 0xac, 0x7c, 0x41, 0xc0, 0x37, 0x6d, 0x86, 0x0d, 0xd8, 0x6e, 0xd2, 0xa5,
	0x43, 0xc0, 0xa5, 0x75, 0x7b, 0xd7, 0x0f, 0xb0, 0x78, 0xe7, 0x2f, 0x8c, 0xe4, 0xaf, 0xb4, 0x40,
	0x08, 0x55, 0xe3, 0x0d, 0xde, 0xba, 0x72, 0x61, 0x0b, 0xb5, 0xdb, 0x7f, 0xa8, 0xc6, 0x4a, 0x87,
	0x8f, 0xa6, 0x33, 0xc2, 0x9d, 0xcf, 0x08, 0x77, 0x31, 0x23, 0xe8, 0x43, 0x40, 0xd0, 0xd7, 0x80,
	0xa0, 0x6f, 0x01, 0x41, 0xd3, 0x80, 0xa0, 0xef, 0x01, 0x41, 0x3f, 0x03, 0xc2, 0x5d, 0x04, 0x04,
	0x7d, 0x9e, 0x13, 0x6e, 0x3a, 0x27, 0xdc, 0xf9, 0x9c, 0x70, 0xc7, 0xbc, 0x65, 0xb3, 0x97, 0x5b,
	0xd1, 0xbd, 0x1c, 0xfc, 0x0a, 0x00, 0x00, 0xff, 0xff, 0xe9, 0xc8, 0x92, 0x20, 0x60, 0x04, 0x00,
	0x00,
}

func (x ErrorInfo_ErrorType) String() string {
	s, ok := ErrorInfo_ErrorType_name[int32(x)]
	if ok {
		return s
	}
	return strconv.Itoa(int(x))
}
func (this *GitCredentialRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitCredentialRequest)
	if !ok {
		that2, ok := that.(GitCredentialRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	if this.Path != that1.Path {
		return false
	}
	return true
}
func (this *GitCredentialResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitCredentialResponse)
	if !ok {
		that2, ok := that.(GitCredentialResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Result == nil {
		if this.Result != nil {
			return false
		}
	} else if this.Result == nil {
		return false
	} else if !this.Result.Equal(that1.Result) {
		return false
	}
	return true
}
func (this *GitCredentialResponse_Credential) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitCredentialResponse_Credential)
	if !ok {
		that2, ok := that.(GitCredentialResponse_Credential)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Credential.Equal(that1.Credential) {
		return false
	}
	return true
}
func (this *GitCredentialResponse_Error) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitCredentialResponse_Error)
	if !ok {
		that2, ok := that.(GitCredentialResponse_Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	return true
}
func (this *CredentialInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*CredentialInfo)
	if !ok {
		that2, ok := that.(CredentialInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Protocol != that1.Protocol {
		return false
	}
	if this.Host != that1.Host {
		return false
	}
	if this.Username != that1.Username {
		return false
	}
	if this.Password != that1.Password {
		return false
	}
	return true
}
func (this *GitConfigRequest) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfigRequest)
	if !ok {
		that2, ok := that.(GitConfigRequest)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	return true
}
func (this *GitConfigResponse) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfigResponse)
	if !ok {
		that2, ok := that.(GitConfigResponse)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if that1.Result == nil {
		if this.Result != nil {
			return false
		}
	} else if this.Result == nil {
		return false
	} else if !this.Result.Equal(that1.Result) {
		return false
	}
	return true
}
func (this *GitConfigResponse_Config) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfigResponse_Config)
	if !ok {
		that2, ok := that.(GitConfigResponse_Config)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Config.Equal(that1.Config) {
		return false
	}
	return true
}
func (this *GitConfigResponse_Error) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfigResponse_Error)
	if !ok {
		that2, ok := that.(GitConfigResponse_Error)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if !this.Error.Equal(that1.Error) {
		return false
	}
	return true
}
func (this *GitConfig) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfig)
	if !ok {
		that2, ok := that.(GitConfig)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if len(this.Entries) != len(that1.Entries) {
		return false
	}
	for i := range this.Entries {
		if !this.Entries[i].Equal(that1.Entries[i]) {
			return false
		}
	}
	return true
}
func (this *GitConfigEntry) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*GitConfigEntry)
	if !ok {
		that2, ok := that.(GitConfigEntry)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Key != that1.Key {
		return false
	}
	if this.Value != that1.Value {
		return false
	}
	return true
}
func (this *ErrorInfo) Equal(that interface{}) bool {
	if that == nil {
		return this == nil
	}

	that1, ok := that.(*ErrorInfo)
	if !ok {
		that2, ok := that.(ErrorInfo)
		if ok {
			that1 = &that2
		} else {
			return false
		}
	}
	if that1 == nil {
		return this == nil
	} else if this == nil {
		return false
	}
	if this.Type != that1.Type {
		return false
	}
	if this.Message != that1.Message {
		return false
	}
	return true
}
func (this *GitCredentialRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 7)
	s = append(s, "&git.GitCredentialRequest{")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "Path: "+fmt.Sprintf("%#v", this.Path)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitCredentialResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&git.GitCredentialResponse{")
	if this.Result != nil {
		s = append(s, "Result: "+fmt.Sprintf("%#v", this.Result)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitCredentialResponse_Credential) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&git.GitCredentialResponse_Credential{` +
		`Credential:` + fmt.Sprintf("%#v", this.Credential) + `}`}, ", ")
	return s
}
func (this *GitCredentialResponse_Error) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&git.GitCredentialResponse_Error{` +
		`Error:` + fmt.Sprintf("%#v", this.Error) + `}`}, ", ")
	return s
}
func (this *CredentialInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 8)
	s = append(s, "&git.CredentialInfo{")
	s = append(s, "Protocol: "+fmt.Sprintf("%#v", this.Protocol)+",\n")
	s = append(s, "Host: "+fmt.Sprintf("%#v", this.Host)+",\n")
	s = append(s, "Username: "+fmt.Sprintf("%#v", this.Username)+",\n")
	s = append(s, "Password: "+fmt.Sprintf("%#v", this.Password)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitConfigRequest) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 4)
	s = append(s, "&git.GitConfigRequest{")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitConfigResponse) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&git.GitConfigResponse{")
	if this.Result != nil {
		s = append(s, "Result: "+fmt.Sprintf("%#v", this.Result)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitConfigResponse_Config) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&git.GitConfigResponse_Config{` +
		`Config:` + fmt.Sprintf("%#v", this.Config) + `}`}, ", ")
	return s
}
func (this *GitConfigResponse_Error) GoString() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&git.GitConfigResponse_Error{` +
		`Error:` + fmt.Sprintf("%#v", this.Error) + `}`}, ", ")
	return s
}
func (this *GitConfig) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 5)
	s = append(s, "&git.GitConfig{")
	if this.Entries != nil {
		s = append(s, "Entries: "+fmt.Sprintf("%#v", this.Entries)+",\n")
	}
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *GitConfigEntry) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&git.GitConfigEntry{")
	s = append(s, "Key: "+fmt.Sprintf("%#v", this.Key)+",\n")
	s = append(s, "Value: "+fmt.Sprintf("%#v", this.Value)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func (this *ErrorInfo) GoString() string {
	if this == nil {
		return "nil"
	}
	s := make([]string, 0, 6)
	s = append(s, "&git.ErrorInfo{")
	s = append(s, "Type: "+fmt.Sprintf("%#v", this.Type)+",\n")
	s = append(s, "Message: "+fmt.Sprintf("%#v", this.Message)+",\n")
	s = append(s, "}")
	return strings.Join(s, "")
}
func valueToGoStringGit(v interface{}, typ string) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("func(v %v) *%v { return &v } ( %#v )", typ, typ, pv)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// GitClient is the client API for Git service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type GitClient interface {
	GetCredential(ctx context.Context, in *GitCredentialRequest, opts ...grpc.CallOption) (*GitCredentialResponse, error)
	GetConfig(ctx context.Context, in *GitConfigRequest, opts ...grpc.CallOption) (*GitConfigResponse, error)
}

type gitClient struct {
	cc *grpc.ClientConn
}

func NewGitClient(cc *grpc.ClientConn) GitClient {
	return &gitClient{cc}
}

func (c *gitClient) GetCredential(ctx context.Context, in *GitCredentialRequest, opts ...grpc.CallOption) (*GitCredentialResponse, error) {
	out := new(GitCredentialResponse)
	err := c.cc.Invoke(ctx, "/dagger.git.Git/GetCredential", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *gitClient) GetConfig(ctx context.Context, in *GitConfigRequest, opts ...grpc.CallOption) (*GitConfigResponse, error) {
	out := new(GitConfigResponse)
	err := c.cc.Invoke(ctx, "/dagger.git.Git/GetConfig", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// GitServer is the server API for Git service.
type GitServer interface {
	GetCredential(context.Context, *GitCredentialRequest) (*GitCredentialResponse, error)
	GetConfig(context.Context, *GitConfigRequest) (*GitConfigResponse, error)
}

// UnimplementedGitServer can be embedded to have forward compatible implementations.
type UnimplementedGitServer struct {
}

func (*UnimplementedGitServer) GetCredential(ctx context.Context, req *GitCredentialRequest) (*GitCredentialResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCredential not implemented")
}
func (*UnimplementedGitServer) GetConfig(ctx context.Context, req *GitConfigRequest) (*GitConfigResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetConfig not implemented")
}

func RegisterGitServer(s *grpc.Server, srv GitServer) {
	s.RegisterService(&_Git_serviceDesc, srv)
}

func _Git_GetCredential_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GitCredentialRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitServer).GetCredential(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dagger.git.Git/GetCredential",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitServer).GetCredential(ctx, req.(*GitCredentialRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _Git_GetConfig_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GitConfigRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(GitServer).GetConfig(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/dagger.git.Git/GetConfig",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(GitServer).GetConfig(ctx, req.(*GitConfigRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _Git_serviceDesc = grpc.ServiceDesc{
	ServiceName: "dagger.git.Git",
	HandlerType: (*GitServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "GetCredential",
			Handler:    _Git_GetCredential_Handler,
		},
		{
			MethodName: "GetConfig",
			Handler:    _Git_GetConfig_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "git.proto",
}

func (m *GitCredentialRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitCredentialRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitCredentialRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Path) > 0 {
		i -= len(m.Path)
		copy(dAtA[i:], m.Path)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Path)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GitCredentialResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitCredentialResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitCredentialResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GitCredentialResponse_Credential) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitCredentialResponse_Credential) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Credential != nil {
		{
			size, err := m.Credential.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *GitCredentialResponse_Error) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitCredentialResponse_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *CredentialInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *CredentialInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *CredentialInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Password) > 0 {
		i -= len(m.Password)
		copy(dAtA[i:], m.Password)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Password)))
		i--
		dAtA[i] = 0x22
	}
	if len(m.Username) > 0 {
		i -= len(m.Username)
		copy(dAtA[i:], m.Username)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Username)))
		i--
		dAtA[i] = 0x1a
	}
	if len(m.Host) > 0 {
		i -= len(m.Host)
		copy(dAtA[i:], m.Host)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Host)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Protocol) > 0 {
		i -= len(m.Protocol)
		copy(dAtA[i:], m.Protocol)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Protocol)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *GitConfigRequest) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitConfigRequest) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfigRequest) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	return len(dAtA) - i, nil
}

func (m *GitConfigResponse) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitConfigResponse) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfigResponse) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if m.Result != nil {
		{
			size := m.Result.Size()
			i -= size
			if _, err := m.Result.MarshalTo(dAtA[i:]); err != nil {
				return 0, err
			}
		}
	}
	return len(dAtA) - i, nil
}

func (m *GitConfigResponse_Config) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfigResponse_Config) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Config != nil {
		{
			size, err := m.Config.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}
func (m *GitConfigResponse_Error) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfigResponse_Error) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	if m.Error != nil {
		{
			size, err := m.Error.MarshalToSizedBuffer(dAtA[:i])
			if err != nil {
				return 0, err
			}
			i -= size
			i = encodeVarintGit(dAtA, i, uint64(size))
		}
		i--
		dAtA[i] = 0x12
	}
	return len(dAtA) - i, nil
}
func (m *GitConfig) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitConfig) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfig) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for iNdEx := len(m.Entries) - 1; iNdEx >= 0; iNdEx-- {
			{
				size, err := m.Entries[iNdEx].MarshalToSizedBuffer(dAtA[:i])
				if err != nil {
					return 0, err
				}
				i -= size
				i = encodeVarintGit(dAtA, i, uint64(size))
			}
			i--
			dAtA[i] = 0xa
		}
	}
	return len(dAtA) - i, nil
}

func (m *GitConfigEntry) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *GitConfigEntry) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *GitConfigEntry) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Value) > 0 {
		i -= len(m.Value)
		copy(dAtA[i:], m.Value)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Value)))
		i--
		dAtA[i] = 0x12
	}
	if len(m.Key) > 0 {
		i -= len(m.Key)
		copy(dAtA[i:], m.Key)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Key)))
		i--
		dAtA[i] = 0xa
	}
	return len(dAtA) - i, nil
}

func (m *ErrorInfo) Marshal() (dAtA []byte, err error) {
	size := m.Size()
	dAtA = make([]byte, size)
	n, err := m.MarshalToSizedBuffer(dAtA[:size])
	if err != nil {
		return nil, err
	}
	return dAtA[:n], nil
}

func (m *ErrorInfo) MarshalTo(dAtA []byte) (int, error) {
	size := m.Size()
	return m.MarshalToSizedBuffer(dAtA[:size])
}

func (m *ErrorInfo) MarshalToSizedBuffer(dAtA []byte) (int, error) {
	i := len(dAtA)
	_ = i
	var l int
	_ = l
	if len(m.Message) > 0 {
		i -= len(m.Message)
		copy(dAtA[i:], m.Message)
		i = encodeVarintGit(dAtA, i, uint64(len(m.Message)))
		i--
		dAtA[i] = 0x12
	}
	if m.Type != 0 {
		i = encodeVarintGit(dAtA, i, uint64(m.Type))
		i--
		dAtA[i] = 0x8
	}
	return len(dAtA) - i, nil
}

func encodeVarintGit(dAtA []byte, offset int, v uint64) int {
	offset -= sovGit(v)
	base := offset
	for v >= 1<<7 {
		dAtA[offset] = uint8(v&0x7f | 0x80)
		v >>= 7
		offset++
	}
	dAtA[offset] = uint8(v)
	return base
}
func (m *GitCredentialRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Path)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}

func (m *GitCredentialResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *GitCredentialResponse_Credential) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Credential != nil {
		l = m.Credential.Size()
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}
func (m *GitCredentialResponse_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}
func (m *CredentialInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Protocol)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Host)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Username)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Password)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}

func (m *GitConfigRequest) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	return n
}

func (m *GitConfigResponse) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Result != nil {
		n += m.Result.Size()
	}
	return n
}

func (m *GitConfigResponse_Config) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Config != nil {
		l = m.Config.Size()
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}
func (m *GitConfigResponse_Error) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Error != nil {
		l = m.Error.Size()
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}
func (m *GitConfig) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if len(m.Entries) > 0 {
		for _, e := range m.Entries {
			l = e.Size()
			n += 1 + l + sovGit(uint64(l))
		}
	}
	return n
}

func (m *GitConfigEntry) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	l = len(m.Key)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	l = len(m.Value)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}

func (m *ErrorInfo) Size() (n int) {
	if m == nil {
		return 0
	}
	var l int
	_ = l
	if m.Type != 0 {
		n += 1 + sovGit(uint64(m.Type))
	}
	l = len(m.Message)
	if l > 0 {
		n += 1 + l + sovGit(uint64(l))
	}
	return n
}

func sovGit(x uint64) (n int) {
	return (math_bits.Len64(x|1) + 6) / 7
}
func sozGit(x uint64) (n int) {
	return sovGit(uint64((x << 1) ^ uint64((int64(x) >> 63))))
}
func (this *GitCredentialRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitCredentialRequest{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`Host:` + fmt.Sprintf("%v", this.Host) + `,`,
		`Path:` + fmt.Sprintf("%v", this.Path) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitCredentialResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitCredentialResponse{`,
		`Result:` + fmt.Sprintf("%v", this.Result) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitCredentialResponse_Credential) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitCredentialResponse_Credential{`,
		`Credential:` + strings.Replace(fmt.Sprintf("%v", this.Credential), "CredentialInfo", "CredentialInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitCredentialResponse_Error) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitCredentialResponse_Error{`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "ErrorInfo", "ErrorInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *CredentialInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&CredentialInfo{`,
		`Protocol:` + fmt.Sprintf("%v", this.Protocol) + `,`,
		`Host:` + fmt.Sprintf("%v", this.Host) + `,`,
		`Username:` + fmt.Sprintf("%v", this.Username) + `,`,
		`Password:` + fmt.Sprintf("%v", this.Password) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitConfigRequest) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitConfigRequest{`,
		`}`,
	}, "")
	return s
}
func (this *GitConfigResponse) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitConfigResponse{`,
		`Result:` + fmt.Sprintf("%v", this.Result) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitConfigResponse_Config) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitConfigResponse_Config{`,
		`Config:` + strings.Replace(fmt.Sprintf("%v", this.Config), "GitConfig", "GitConfig", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitConfigResponse_Error) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitConfigResponse_Error{`,
		`Error:` + strings.Replace(fmt.Sprintf("%v", this.Error), "ErrorInfo", "ErrorInfo", 1) + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitConfig) String() string {
	if this == nil {
		return "nil"
	}
	repeatedStringForEntries := "[]*GitConfigEntry{"
	for _, f := range this.Entries {
		repeatedStringForEntries += strings.Replace(f.String(), "GitConfigEntry", "GitConfigEntry", 1) + ","
	}
	repeatedStringForEntries += "}"
	s := strings.Join([]string{`&GitConfig{`,
		`Entries:` + repeatedStringForEntries + `,`,
		`}`,
	}, "")
	return s
}
func (this *GitConfigEntry) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&GitConfigEntry{`,
		`Key:` + fmt.Sprintf("%v", this.Key) + `,`,
		`Value:` + fmt.Sprintf("%v", this.Value) + `,`,
		`}`,
	}, "")
	return s
}
func (this *ErrorInfo) String() string {
	if this == nil {
		return "nil"
	}
	s := strings.Join([]string{`&ErrorInfo{`,
		`Type:` + fmt.Sprintf("%v", this.Type) + `,`,
		`Message:` + fmt.Sprintf("%v", this.Message) + `,`,
		`}`,
	}, "")
	return s
}
func valueToStringGit(v interface{}) string {
	rv := reflect.ValueOf(v)
	if rv.IsNil() {
		return "nil"
	}
	pv := reflect.Indirect(rv).Interface()
	return fmt.Sprintf("*%v", pv)
}
func (m *GitCredentialRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitCredentialRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitCredentialRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Path", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Path = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitCredentialResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitCredentialResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitCredentialResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Credential", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &CredentialInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &GitCredentialResponse_Credential{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ErrorInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &GitCredentialResponse_Error{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *CredentialInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: CredentialInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: CredentialInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Protocol", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Protocol = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Host", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Host = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 3:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Username", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Username = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 4:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Password", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Password = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitConfigRequest) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitConfigRequest: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitConfigRequest: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitConfigResponse) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitConfigResponse: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitConfigResponse: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Config", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &GitConfig{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &GitConfigResponse_Config{v}
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Error", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			v := &ErrorInfo{}
			if err := v.Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			m.Result = &GitConfigResponse_Error{v}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitConfig) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitConfig: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitConfig: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Entries", wireType)
			}
			var msglen int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				msglen |= int(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if msglen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + msglen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Entries = append(m.Entries, &GitConfigEntry{})
			if err := m.Entries[len(m.Entries)-1].Unmarshal(dAtA[iNdEx:postIndex]); err != nil {
				return err
			}
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *GitConfigEntry) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: GitConfigEntry: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: GitConfigEntry: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Key", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Key = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Value", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Value = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func (m *ErrorInfo) Unmarshal(dAtA []byte) error {
	l := len(dAtA)
	iNdEx := 0
	for iNdEx < l {
		preIndex := iNdEx
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return ErrIntOverflowGit
			}
			if iNdEx >= l {
				return io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= uint64(b&0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		fieldNum := int32(wire >> 3)
		wireType := int(wire & 0x7)
		if wireType == 4 {
			return fmt.Errorf("proto: ErrorInfo: wiretype end group for non-group")
		}
		if fieldNum <= 0 {
			return fmt.Errorf("proto: ErrorInfo: illegal tag %d (wire type %d)", fieldNum, wire)
		}
		switch fieldNum {
		case 1:
			if wireType != 0 {
				return fmt.Errorf("proto: wrong wireType = %d for field Type", wireType)
			}
			m.Type = 0
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				m.Type |= ErrorInfo_ErrorType(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
		case 2:
			if wireType != 2 {
				return fmt.Errorf("proto: wrong wireType = %d for field Message", wireType)
			}
			var stringLen uint64
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return ErrIntOverflowGit
				}
				if iNdEx >= l {
					return io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				stringLen |= uint64(b&0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			intStringLen := int(stringLen)
			if intStringLen < 0 {
				return ErrInvalidLengthGit
			}
			postIndex := iNdEx + intStringLen
			if postIndex < 0 {
				return ErrInvalidLengthGit
			}
			if postIndex > l {
				return io.ErrUnexpectedEOF
			}
			m.Message = string(dAtA[iNdEx:postIndex])
			iNdEx = postIndex
		default:
			iNdEx = preIndex
			skippy, err := skipGit(dAtA[iNdEx:])
			if err != nil {
				return err
			}
			if (skippy < 0) || (iNdEx+skippy) < 0 {
				return ErrInvalidLengthGit
			}
			if (iNdEx + skippy) > l {
				return io.ErrUnexpectedEOF
			}
			iNdEx += skippy
		}
	}

	if iNdEx > l {
		return io.ErrUnexpectedEOF
	}
	return nil
}
func skipGit(dAtA []byte) (n int, err error) {
	l := len(dAtA)
	iNdEx := 0
	depth := 0
	for iNdEx < l {
		var wire uint64
		for shift := uint(0); ; shift += 7 {
			if shift >= 64 {
				return 0, ErrIntOverflowGit
			}
			if iNdEx >= l {
				return 0, io.ErrUnexpectedEOF
			}
			b := dAtA[iNdEx]
			iNdEx++
			wire |= (uint64(b) & 0x7F) << shift
			if b < 0x80 {
				break
			}
		}
		wireType := int(wire & 0x7)
		switch wireType {
		case 0:
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				iNdEx++
				if dAtA[iNdEx-1] < 0x80 {
					break
				}
			}
		case 1:
			iNdEx += 8
		case 2:
			var length int
			for shift := uint(0); ; shift += 7 {
				if shift >= 64 {
					return 0, ErrIntOverflowGit
				}
				if iNdEx >= l {
					return 0, io.ErrUnexpectedEOF
				}
				b := dAtA[iNdEx]
				iNdEx++
				length |= (int(b) & 0x7F) << shift
				if b < 0x80 {
					break
				}
			}
			if length < 0 {
				return 0, ErrInvalidLengthGit
			}
			iNdEx += length
		case 3:
			depth++
		case 4:
			if depth == 0 {
				return 0, ErrUnexpectedEndOfGroupGit
			}
			depth--
		case 5:
			iNdEx += 4
		default:
			return 0, fmt.Errorf("proto: illegal wireType %d", wireType)
		}
		if iNdEx < 0 {
			return 0, ErrInvalidLengthGit
		}
		if depth == 0 {
			return iNdEx, nil
		}
	}
	return 0, io.ErrUnexpectedEOF
}

var (
	ErrInvalidLengthGit        = fmt.Errorf("proto: negative length found during unmarshaling")
	ErrIntOverflowGit          = fmt.Errorf("proto: integer overflow")
	ErrUnexpectedEndOfGroupGit = fmt.Errorf("proto: unexpected end of group")
)
