// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	"fmt"
	smithy "github.com/aws/smithy-go"
)

// Error thrown for access denied scenarios with flexible HTTP status mapping
//
// Runtime HTTP Status Code Mapping:
//
//   - HTTP 401 (Unauthorized): TOKEN_EXPIRED, AUTHCODE_EXPIRED
//   - HTTP 403 (Forbidden): USER_CREDENTIALS_CHANGED, INSUFFICIENT_PERMISSIONS
//
// The specific HTTP status code is determined at runtime based on the error enum
// value. Consumers should use the error field to determine the specific access
// denial reason.
type AccessDeniedException struct {
	Message *string

	ErrorCodeOverride *string

	Error_ OAuth2ErrorCode

	noSmithyDocumentSerde
}

func (e *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *AccessDeniedException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *AccessDeniedException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "AccessDeniedException"
	}
	return *e.ErrorCodeOverride
}
func (e *AccessDeniedException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error thrown when an internal server error occurs
//
// HTTP Status Code: 500 Internal Server Error
//
// Used for unexpected server-side errors that prevent request processing.
type InternalServerException struct {
	Message *string

	ErrorCodeOverride *string

	Error_ OAuth2ErrorCode

	noSmithyDocumentSerde
}

func (e *InternalServerException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *InternalServerException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *InternalServerException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "InternalServerException"
	}
	return *e.ErrorCodeOverride
}
func (e *InternalServerException) ErrorFault() smithy.ErrorFault { return smithy.FaultServer }

// Error thrown when rate limit is exceeded
//
// HTTP Status Code: 429 Too Many Requests
//
// Possible OAuth2ErrorCode values:
//
//   - INVALID_REQUEST: Rate limiting, too many requests, abuse prevention
//
// Possible causes:
//
//   - Too many token requests from the same client
//   - Rate limiting based on client_id or IP address
//   - Abuse prevention mechanisms triggered
//   - Service protection against excessive token generation
type TooManyRequestsError struct {
	Message *string

	ErrorCodeOverride *string

	Error_ OAuth2ErrorCode

	noSmithyDocumentSerde
}

func (e *TooManyRequestsError) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *TooManyRequestsError) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *TooManyRequestsError) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "TooManyRequestsError"
	}
	return *e.ErrorCodeOverride
}
func (e *TooManyRequestsError) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }

// Error thrown when request validation fails
//
// HTTP Status Code: 400 Bad Request
//
// Used for request validation errors such as malformed parameters, missing
// required fields, or invalid parameter values.
type ValidationException struct {
	Message *string

	ErrorCodeOverride *string

	Error_ OAuth2ErrorCode

	noSmithyDocumentSerde
}

func (e *ValidationException) Error() string {
	return fmt.Sprintf("%s: %s", e.ErrorCode(), e.ErrorMessage())
}
func (e *ValidationException) ErrorMessage() string {
	if e.Message == nil {
		return ""
	}
	return *e.Message
}
func (e *ValidationException) ErrorCode() string {
	if e == nil || e.ErrorCodeOverride == nil {
		return "ValidationException"
	}
	return *e.ErrorCodeOverride
}
func (e *ValidationException) ErrorFault() smithy.ErrorFault { return smithy.FaultClient }
