// Copyright 2023-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-connect-go. DO NOT EDIT.
//
// Source: buf/registry/owner/v1/organization_service.proto

package ownerv1connect

import (
	v1 "buf.build/gen/go/bufbuild/registry/protocolbuffers/go/buf/registry/owner/v1"
	connect "connectrpc.com/connect"
	context "context"
	errors "errors"
	http "net/http"
	strings "strings"
)

// This is a compile-time assertion to ensure that this generated file and the connect package are
// compatible. If you get a compiler error that this constant is not defined, this code was
// generated with a version of connect newer than the one compiled into your binary. You can fix the
// problem by either regenerating this code with an older version of connect or updating the connect
// version compiled into your binary.
const _ = connect.IsAtLeastVersion1_13_0

const (
	// OrganizationServiceName is the fully-qualified name of the OrganizationService service.
	OrganizationServiceName = "buf.registry.owner.v1.OrganizationService"
)

// These constants are the fully-qualified names of the RPCs defined in this package. They're
// exposed at runtime as Spec.Procedure and as the final two segments of the HTTP route.
//
// Note that these are different from the fully-qualified method names used by
// google.golang.org/protobuf/reflect/protoreflect. To convert from these constants to
// reflection-formatted method names, remove the leading slash and convert the remaining slash to a
// period.
const (
	// OrganizationServiceGetOrganizationsProcedure is the fully-qualified name of the
	// OrganizationService's GetOrganizations RPC.
	OrganizationServiceGetOrganizationsProcedure = "/buf.registry.owner.v1.OrganizationService/GetOrganizations"
	// OrganizationServiceListOrganizationsProcedure is the fully-qualified name of the
	// OrganizationService's ListOrganizations RPC.
	OrganizationServiceListOrganizationsProcedure = "/buf.registry.owner.v1.OrganizationService/ListOrganizations"
	// OrganizationServiceCreateOrganizationsProcedure is the fully-qualified name of the
	// OrganizationService's CreateOrganizations RPC.
	OrganizationServiceCreateOrganizationsProcedure = "/buf.registry.owner.v1.OrganizationService/CreateOrganizations"
	// OrganizationServiceUpdateOrganizationsProcedure is the fully-qualified name of the
	// OrganizationService's UpdateOrganizations RPC.
	OrganizationServiceUpdateOrganizationsProcedure = "/buf.registry.owner.v1.OrganizationService/UpdateOrganizations"
	// OrganizationServiceDeleteOrganizationsProcedure is the fully-qualified name of the
	// OrganizationService's DeleteOrganizations RPC.
	OrganizationServiceDeleteOrganizationsProcedure = "/buf.registry.owner.v1.OrganizationService/DeleteOrganizations"
)

// OrganizationServiceClient is a client for the buf.registry.owner.v1.OrganizationService service.
type OrganizationServiceClient interface {
	// Get Organizations by id or name.
	GetOrganizations(context.Context, *connect.Request[v1.GetOrganizationsRequest]) (*connect.Response[v1.GetOrganizationsResponse], error)
	// List Organizations, usually by User.
	ListOrganizations(context.Context, *connect.Request[v1.ListOrganizationsRequest]) (*connect.Response[v1.ListOrganizationsResponse], error)
	// Create new Organizations.
	//
	// This operation is atomic. Either all Organizations are created or an error is returned.
	CreateOrganizations(context.Context, *connect.Request[v1.CreateOrganizationsRequest]) (*connect.Response[v1.CreateOrganizationsResponse], error)
	// Update existing organizations.
	//
	// This operation is atomic. Either all Organizations are updated or an error is returned.
	UpdateOrganizations(context.Context, *connect.Request[v1.UpdateOrganizationsRequest]) (*connect.Response[v1.UpdateOrganizationsResponse], error)
	// Delete existing organizations.
	//
	// This operation is atomic. Either all Organizations are deleted or an error is returned.
	DeleteOrganizations(context.Context, *connect.Request[v1.DeleteOrganizationsRequest]) (*connect.Response[v1.DeleteOrganizationsResponse], error)
}

// NewOrganizationServiceClient constructs a client for the
// buf.registry.owner.v1.OrganizationService service. By default, it uses the Connect protocol with
// the binary Protobuf Codec, asks for gzipped responses, and sends uncompressed requests. To use
// the gRPC or gRPC-Web protocols, supply the connect.WithGRPC() or connect.WithGRPCWeb() options.
//
// The URL supplied here should be the base URL for the Connect or gRPC server (for example,
// http://api.acme.com or https://acme.com/grpc).
func NewOrganizationServiceClient(httpClient connect.HTTPClient, baseURL string, opts ...connect.ClientOption) OrganizationServiceClient {
	baseURL = strings.TrimRight(baseURL, "/")
	organizationServiceMethods := v1.File_buf_registry_owner_v1_organization_service_proto.Services().ByName("OrganizationService").Methods()
	return &organizationServiceClient{
		getOrganizations: connect.NewClient[v1.GetOrganizationsRequest, v1.GetOrganizationsResponse](
			httpClient,
			baseURL+OrganizationServiceGetOrganizationsProcedure,
			connect.WithSchema(organizationServiceMethods.ByName("GetOrganizations")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		listOrganizations: connect.NewClient[v1.ListOrganizationsRequest, v1.ListOrganizationsResponse](
			httpClient,
			baseURL+OrganizationServiceListOrganizationsProcedure,
			connect.WithSchema(organizationServiceMethods.ByName("ListOrganizations")),
			connect.WithIdempotency(connect.IdempotencyNoSideEffects),
			connect.WithClientOptions(opts...),
		),
		createOrganizations: connect.NewClient[v1.CreateOrganizationsRequest, v1.CreateOrganizationsResponse](
			httpClient,
			baseURL+OrganizationServiceCreateOrganizationsProcedure,
			connect.WithSchema(organizationServiceMethods.ByName("CreateOrganizations")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		updateOrganizations: connect.NewClient[v1.UpdateOrganizationsRequest, v1.UpdateOrganizationsResponse](
			httpClient,
			baseURL+OrganizationServiceUpdateOrganizationsProcedure,
			connect.WithSchema(organizationServiceMethods.ByName("UpdateOrganizations")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
		deleteOrganizations: connect.NewClient[v1.DeleteOrganizationsRequest, v1.DeleteOrganizationsResponse](
			httpClient,
			baseURL+OrganizationServiceDeleteOrganizationsProcedure,
			connect.WithSchema(organizationServiceMethods.ByName("DeleteOrganizations")),
			connect.WithIdempotency(connect.IdempotencyIdempotent),
			connect.WithClientOptions(opts...),
		),
	}
}

// organizationServiceClient implements OrganizationServiceClient.
type organizationServiceClient struct {
	getOrganizations    *connect.Client[v1.GetOrganizationsRequest, v1.GetOrganizationsResponse]
	listOrganizations   *connect.Client[v1.ListOrganizationsRequest, v1.ListOrganizationsResponse]
	createOrganizations *connect.Client[v1.CreateOrganizationsRequest, v1.CreateOrganizationsResponse]
	updateOrganizations *connect.Client[v1.UpdateOrganizationsRequest, v1.UpdateOrganizationsResponse]
	deleteOrganizations *connect.Client[v1.DeleteOrganizationsRequest, v1.DeleteOrganizationsResponse]
}

// GetOrganizations calls buf.registry.owner.v1.OrganizationService.GetOrganizations.
func (c *organizationServiceClient) GetOrganizations(ctx context.Context, req *connect.Request[v1.GetOrganizationsRequest]) (*connect.Response[v1.GetOrganizationsResponse], error) {
	return c.getOrganizations.CallUnary(ctx, req)
}

// ListOrganizations calls buf.registry.owner.v1.OrganizationService.ListOrganizations.
func (c *organizationServiceClient) ListOrganizations(ctx context.Context, req *connect.Request[v1.ListOrganizationsRequest]) (*connect.Response[v1.ListOrganizationsResponse], error) {
	return c.listOrganizations.CallUnary(ctx, req)
}

// CreateOrganizations calls buf.registry.owner.v1.OrganizationService.CreateOrganizations.
func (c *organizationServiceClient) CreateOrganizations(ctx context.Context, req *connect.Request[v1.CreateOrganizationsRequest]) (*connect.Response[v1.CreateOrganizationsResponse], error) {
	return c.createOrganizations.CallUnary(ctx, req)
}

// UpdateOrganizations calls buf.registry.owner.v1.OrganizationService.UpdateOrganizations.
func (c *organizationServiceClient) UpdateOrganizations(ctx context.Context, req *connect.Request[v1.UpdateOrganizationsRequest]) (*connect.Response[v1.UpdateOrganizationsResponse], error) {
	return c.updateOrganizations.CallUnary(ctx, req)
}

// DeleteOrganizations calls buf.registry.owner.v1.OrganizationService.DeleteOrganizations.
func (c *organizationServiceClient) DeleteOrganizations(ctx context.Context, req *connect.Request[v1.DeleteOrganizationsRequest]) (*connect.Response[v1.DeleteOrganizationsResponse], error) {
	return c.deleteOrganizations.CallUnary(ctx, req)
}

// OrganizationServiceHandler is an implementation of the buf.registry.owner.v1.OrganizationService
// service.
type OrganizationServiceHandler interface {
	// Get Organizations by id or name.
	GetOrganizations(context.Context, *connect.Request[v1.GetOrganizationsRequest]) (*connect.Response[v1.GetOrganizationsResponse], error)
	// List Organizations, usually by User.
	ListOrganizations(context.Context, *connect.Request[v1.ListOrganizationsRequest]) (*connect.Response[v1.ListOrganizationsResponse], error)
	// Create new Organizations.
	//
	// This operation is atomic. Either all Organizations are created or an error is returned.
	CreateOrganizations(context.Context, *connect.Request[v1.CreateOrganizationsRequest]) (*connect.Response[v1.CreateOrganizationsResponse], error)
	// Update existing organizations.
	//
	// This operation is atomic. Either all Organizations are updated or an error is returned.
	UpdateOrganizations(context.Context, *connect.Request[v1.UpdateOrganizationsRequest]) (*connect.Response[v1.UpdateOrganizationsResponse], error)
	// Delete existing organizations.
	//
	// This operation is atomic. Either all Organizations are deleted or an error is returned.
	DeleteOrganizations(context.Context, *connect.Request[v1.DeleteOrganizationsRequest]) (*connect.Response[v1.DeleteOrganizationsResponse], error)
}

// NewOrganizationServiceHandler builds an HTTP handler from the service implementation. It returns
// the path on which to mount the handler and the handler itself.
//
// By default, handlers support the Connect, gRPC, and gRPC-Web protocols with the binary Protobuf
// and JSON codecs. They also support gzip compression.
func NewOrganizationServiceHandler(svc OrganizationServiceHandler, opts ...connect.HandlerOption) (string, http.Handler) {
	organizationServiceMethods := v1.File_buf_registry_owner_v1_organization_service_proto.Services().ByName("OrganizationService").Methods()
	organizationServiceGetOrganizationsHandler := connect.NewUnaryHandler(
		OrganizationServiceGetOrganizationsProcedure,
		svc.GetOrganizations,
		connect.WithSchema(organizationServiceMethods.ByName("GetOrganizations")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	organizationServiceListOrganizationsHandler := connect.NewUnaryHandler(
		OrganizationServiceListOrganizationsProcedure,
		svc.ListOrganizations,
		connect.WithSchema(organizationServiceMethods.ByName("ListOrganizations")),
		connect.WithIdempotency(connect.IdempotencyNoSideEffects),
		connect.WithHandlerOptions(opts...),
	)
	organizationServiceCreateOrganizationsHandler := connect.NewUnaryHandler(
		OrganizationServiceCreateOrganizationsProcedure,
		svc.CreateOrganizations,
		connect.WithSchema(organizationServiceMethods.ByName("CreateOrganizations")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	organizationServiceUpdateOrganizationsHandler := connect.NewUnaryHandler(
		OrganizationServiceUpdateOrganizationsProcedure,
		svc.UpdateOrganizations,
		connect.WithSchema(organizationServiceMethods.ByName("UpdateOrganizations")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	organizationServiceDeleteOrganizationsHandler := connect.NewUnaryHandler(
		OrganizationServiceDeleteOrganizationsProcedure,
		svc.DeleteOrganizations,
		connect.WithSchema(organizationServiceMethods.ByName("DeleteOrganizations")),
		connect.WithIdempotency(connect.IdempotencyIdempotent),
		connect.WithHandlerOptions(opts...),
	)
	return "/buf.registry.owner.v1.OrganizationService/", http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		switch r.URL.Path {
		case OrganizationServiceGetOrganizationsProcedure:
			organizationServiceGetOrganizationsHandler.ServeHTTP(w, r)
		case OrganizationServiceListOrganizationsProcedure:
			organizationServiceListOrganizationsHandler.ServeHTTP(w, r)
		case OrganizationServiceCreateOrganizationsProcedure:
			organizationServiceCreateOrganizationsHandler.ServeHTTP(w, r)
		case OrganizationServiceUpdateOrganizationsProcedure:
			organizationServiceUpdateOrganizationsHandler.ServeHTTP(w, r)
		case OrganizationServiceDeleteOrganizationsProcedure:
			organizationServiceDeleteOrganizationsHandler.ServeHTTP(w, r)
		default:
			http.NotFound(w, r)
		}
	})
}

// UnimplementedOrganizationServiceHandler returns CodeUnimplemented from all methods.
type UnimplementedOrganizationServiceHandler struct{}

func (UnimplementedOrganizationServiceHandler) GetOrganizations(context.Context, *connect.Request[v1.GetOrganizationsRequest]) (*connect.Response[v1.GetOrganizationsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.OrganizationService.GetOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) ListOrganizations(context.Context, *connect.Request[v1.ListOrganizationsRequest]) (*connect.Response[v1.ListOrganizationsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.OrganizationService.ListOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) CreateOrganizations(context.Context, *connect.Request[v1.CreateOrganizationsRequest]) (*connect.Response[v1.CreateOrganizationsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.OrganizationService.CreateOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) UpdateOrganizations(context.Context, *connect.Request[v1.UpdateOrganizationsRequest]) (*connect.Response[v1.UpdateOrganizationsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.OrganizationService.UpdateOrganizations is not implemented"))
}

func (UnimplementedOrganizationServiceHandler) DeleteOrganizations(context.Context, *connect.Request[v1.DeleteOrganizationsRequest]) (*connect.Response[v1.DeleteOrganizationsResponse], error) {
	return nil, connect.NewError(connect.CodeUnimplemented, errors.New("buf.registry.owner.v1.OrganizationService.DeleteOrganizations is not implemented"))
}
