/* AppSystem.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from AppSystem.vala, do not modify */

/*
 * Copyright 2011-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>

#define SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS 3
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_0_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
enum  {
	SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL,
	SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS
};
static guint slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_NUM_SIGNALS] = {0};

struct _SlingshotBackendAppSystemPrivate {
	GeeHashMap* _apps;
	guint refresh_timeout_id;
	GeeArrayList* categories_cache;
	GAppInfoMonitor* app_monitor;
};

static gint SlingshotBackendAppSystem_private_offset;
static gpointer slingshot_backend_app_system_parent_class = NULL;
static GType slingshot_backend_app_system_type_id = 0;

static void slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self);
static gboolean __lambda22_ (SlingshotBackendAppSystem* self);
static void slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self);
static gboolean ___lambda22__gsource_func (gpointer self);
static void slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static gint slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                     SlingshotBackendApp* b);
static gint _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                         gconstpointer b,
                                                                         gpointer self);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                            GeeHashMap* value);
static GObject * slingshot_backend_app_system_constructor (GType type,
                                                    guint n_construct_properties,
                                                    GObjectConstructParam * construct_properties);
static void _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                       gpointer self);
static void slingshot_backend_app_system_finalize (GObject * obj);
static void _vala_slingshot_backend_app_system_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);
static void _vala_slingshot_backend_app_system_set_property (GObject * object,
                                                      guint property_id,
                                                      const GValue * value,
                                                      GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
slingshot_backend_app_system_get_instance_private (SlingshotBackendAppSystem* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendAppSystem_private_offset);
}

static gboolean
__lambda22_ (SlingshotBackendAppSystem* self)
{
	gboolean result;
	slingshot_backend_app_system_update_app_system (self);
	self->priv->refresh_timeout_id = (guint) 0;
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda22__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda22_ ((SlingshotBackendAppSystem*) self);
	return result;
}

static void
slingshot_backend_app_system_queue_update_app_system (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->refresh_timeout_id != ((guint) 0)) {
		g_source_remove (self->priv->refresh_timeout_id);
		self->priv->refresh_timeout_id = (guint) 0;
	}
	self->priv->refresh_timeout_id = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) SLINGSHOT_BACKEND_APP_SYSTEM_MENU_REFRESH_TIMEOUT_SECONDS, ___lambda22__gsource_func, g_object_ref (self), g_object_unref);
}

static void
slingshot_backend_app_system_update_app_system (SlingshotBackendAppSystem* self)
{
	g_return_if_fail (self != NULL);
	g_debug ("AppSystem.vala:64: Updating Applications menu tree…");
	slingshot_backend_app_system_update_categories_index (self);
	g_signal_emit (self, slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL], 0);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
slingshot_backend_app_system_update_categories_index (SlingshotBackendAppSystem* self)
{
	GeeArrayList* _tmp0_;
	gchar** dir_paths = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint dir_paths_length1;
	gint _dir_paths_size_;
	gchar** predefined = NULL;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint predefined_length1;
	gint _predefined_size_;
	gchar** _tmp20_;
	gint _tmp20__length1;
	GeeArrayList* _tmp65_;
	gchar* _tmp66_;
	gchar** _tmp67_;
	gchar* _tmp68_;
	gchar* _tmp69_;
	gchar** _tmp70_;
	gchar* _tmp71_;
	gchar** _tmp72_;
	SlingshotBackendCategory* _tmp73_ = NULL;
	SlingshotBackendCategory* _tmp74_;
	GeeArrayList* _tmp75_;
	gchar* _tmp76_;
	gchar** _tmp77_;
	SlingshotBackendCategory* _tmp78_ = NULL;
	SlingshotBackendCategory* _tmp79_;
	GeeArrayList* _tmp80_;
	gchar* _tmp81_;
	gchar** _tmp82_;
	SlingshotBackendCategory* _tmp83_ = NULL;
	SlingshotBackendCategory* _tmp84_;
	GeeArrayList* _tmp85_;
	gchar* _tmp86_;
	gchar** _tmp87_;
	gchar* _tmp88_;
	gchar** _tmp89_;
	SlingshotBackendCategory* _tmp90_ = NULL;
	SlingshotBackendCategory* _tmp91_;
	GeeArrayList* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar** _tmp95_;
	gchar* _tmp96_;
	gchar** _tmp97_;
	SlingshotBackendCategory* _tmp98_ = NULL;
	SlingshotBackendCategory* _tmp99_;
	GeeArrayList* _tmp100_;
	gchar* _tmp101_;
	gchar** _tmp102_;
	SlingshotBackendCategory* _tmp103_ = NULL;
	SlingshotBackendCategory* _tmp104_;
	GeeArrayList* _tmp105_;
	gchar* _tmp106_;
	gchar** _tmp107_;
	SlingshotBackendCategory* _tmp108_ = NULL;
	SlingshotBackendCategory* _tmp109_;
	GeeArrayList* _tmp110_;
	gchar* _tmp111_;
	gchar** _tmp112_;
	SlingshotBackendCategory* _tmp113_ = NULL;
	SlingshotBackendCategory* _tmp114_;
	GeeArrayList* _tmp115_;
	gchar* _tmp116_;
	gchar** _tmp117_;
	SlingshotBackendCategory* _tmp118_ = NULL;
	SlingshotBackendCategory* _tmp119_;
	GeeArrayList* _tmp120_;
	gchar* _tmp121_;
	gchar** _tmp122_;
	SlingshotBackendCategory* _tmp123_ = NULL;
	SlingshotBackendCategory* _tmp124_;
	GeeArrayList* _tmp125_;
	gchar* _tmp126_;
	gchar* _tmp127_;
	gchar* _tmp128_;
	gchar** _tmp129_;
	gchar* _tmp130_;
	gchar** _tmp131_;
	gchar* _tmp132_;
	gchar** _tmp133_;
	SlingshotBackendCategory* _tmp134_ = NULL;
	SlingshotBackendCategory* _tmp135_;
	SlingshotBackendCategory* other_category = NULL;
	gchar* _tmp136_;
	gchar* _tmp137_;
	gchar* _tmp138_;
	gchar** _tmp139_;
	SlingshotBackendCategory* _tmp140_ = NULL;
	GList* _tmp141_;
	SlingshotBackendCategory* _tmp176_;
	GeeArrayList* _tmp177_;
	GeeArrayList* _tmp178_;
	gint _tmp179_;
	gint _tmp180_;
	GeeHashMap* _tmp183_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->categories_cache;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
	_tmp1_ = g_get_home_dir ();
	_tmp2_ = g_build_path (G_DIR_SEPARATOR_S, _tmp1_, ".local", "share", "desktop-directories", NULL);
	_tmp3_ = g_new0 (gchar*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	dir_paths = _tmp3_;
	dir_paths_length1 = 1;
	_dir_paths_size_ = dir_paths_length1;
	_tmp4_ = g_strdup ("Utility");
	_tmp5_ = g_strdup ("Accessibility");
	_tmp6_ = g_strdup ("Development");
	_tmp7_ = g_strdup ("Education");
	_tmp8_ = g_strdup ("Science");
	_tmp9_ = g_strdup ("Game");
	_tmp10_ = g_strdup ("Graphics");
	_tmp11_ = g_strdup ("Network");
	_tmp12_ = g_strdup ("AudioVideo");
	_tmp13_ = g_strdup ("Office");
	_tmp14_ = g_strdup ("System");
	_tmp15_ = g_strdup ("Administration");
	_tmp16_ = g_strdup ("Settings");
	_tmp17_ = g_strdup ("Core");
	_tmp18_ = g_strdup ("Screensaver");
	_tmp19_ = g_new0 (gchar*, 15 + 1);
	_tmp19_[0] = _tmp4_;
	_tmp19_[1] = _tmp5_;
	_tmp19_[2] = _tmp6_;
	_tmp19_[3] = _tmp7_;
	_tmp19_[4] = _tmp8_;
	_tmp19_[5] = _tmp9_;
	_tmp19_[6] = _tmp10_;
	_tmp19_[7] = _tmp11_;
	_tmp19_[8] = _tmp12_;
	_tmp19_[9] = _tmp13_;
	_tmp19_[10] = _tmp14_;
	_tmp19_[11] = _tmp15_;
	_tmp19_[12] = _tmp16_;
	_tmp19_[13] = _tmp17_;
	_tmp19_[14] = _tmp18_;
	predefined = _tmp19_;
	predefined_length1 = 15;
	_predefined_size_ = predefined_length1;
	_tmp20_ = dir_paths;
	_tmp20__length1 = dir_paths_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp20_;
		dir_collection_length1 = _tmp20__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp21_;
			gchar* dir = NULL;
			_tmp21_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp21_;
			{
				GFile* folder = NULL;
				const gchar* _tmp22_;
				GFile* _tmp23_;
				GFile* _tmp24_;
				_tmp22_ = dir;
				_tmp23_ = g_file_new_for_path (_tmp22_);
				folder = _tmp23_;
				_tmp24_ = folder;
				if (!g_file_query_exists (_tmp24_, NULL)) {
					_g_object_unref0 (folder);
					_g_free0 (dir);
					continue;
				}
				{
					GFileEnumerator* enumerator = NULL;
					GFile* _tmp25_;
					GFileEnumerator* _tmp26_;
					GFileInfo* info = NULL;
					_tmp25_ = folder;
					_tmp26_ = g_file_enumerate_children (_tmp25_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, NULL, &_inner_error0_);
					enumerator = _tmp26_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					while (TRUE) {
						GFileInfo* _tmp27_ = NULL;
						GFileEnumerator* _tmp28_;
						GFileInfo* _tmp29_;
						GFileInfo* _tmp30_;
						GFileInfo* _tmp31_;
						gchar* name = NULL;
						GFileInfo* _tmp32_;
						const gchar* _tmp33_;
						gchar* _tmp34_;
						const gchar* _tmp35_;
						gchar* cat_id = NULL;
						const gchar* _tmp36_;
						gchar* _tmp37_;
						gboolean skip = FALSE;
						gchar** _tmp38_;
						gint _tmp38__length1;
						gchar* path = NULL;
						const gchar* _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp28_ = enumerator;
						_tmp29_ = g_file_enumerator_next_file (_tmp28_, NULL, &_inner_error0_);
						_tmp27_ = _tmp29_;
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_object_unref0 (info);
							_g_object_unref0 (enumerator);
							goto __catch0_g_error;
						}
						_tmp30_ = _tmp27_;
						_tmp27_ = NULL;
						_g_object_unref0 (info);
						info = _tmp30_;
						_tmp31_ = info;
						if (!(_tmp31_ != NULL)) {
							_g_object_unref0 (_tmp27_);
							break;
						}
						_tmp32_ = info;
						_tmp33_ = g_file_info_get_name (_tmp32_);
						_tmp34_ = g_strdup (_tmp33_);
						name = _tmp34_;
						_tmp35_ = name;
						if (!g_str_has_suffix (_tmp35_, ".directory")) {
							_g_free0 (name);
							_g_object_unref0 (_tmp27_);
							continue;
						}
						_tmp36_ = name;
						_tmp37_ = string_slice (_tmp36_, (glong) 0, (glong) -10);
						cat_id = _tmp37_;
						skip = FALSE;
						_tmp38_ = predefined;
						_tmp38__length1 = predefined_length1;
						{
							gchar** pre_collection = NULL;
							gint pre_collection_length1 = 0;
							gint _pre_collection_size_ = 0;
							gint pre_it = 0;
							pre_collection = _tmp38_;
							pre_collection_length1 = _tmp38__length1;
							for (pre_it = 0; pre_it < pre_collection_length1; pre_it = pre_it + 1) {
								gchar* _tmp39_;
								gchar* pre = NULL;
								_tmp39_ = g_strdup (pre_collection[pre_it]);
								pre = _tmp39_;
								{
									const gchar* _tmp40_;
									gchar* _tmp41_;
									gchar* _tmp42_;
									const gchar* _tmp43_;
									gchar* _tmp44_;
									gchar* _tmp45_;
									gboolean _tmp46_;
									_tmp40_ = pre;
									_tmp41_ = g_utf8_strdown (_tmp40_, (gssize) -1);
									_tmp42_ = _tmp41_;
									_tmp43_ = cat_id;
									_tmp44_ = g_utf8_strdown (_tmp43_, (gssize) -1);
									_tmp45_ = _tmp44_;
									_tmp46_ = g_strcmp0 (_tmp42_, _tmp45_) == 0;
									_g_free0 (_tmp45_);
									_g_free0 (_tmp42_);
									if (_tmp46_) {
										skip = TRUE;
										_g_free0 (pre);
										break;
									}
									_g_free0 (pre);
								}
							}
						}
						if (skip) {
							_g_free0 (cat_id);
							_g_free0 (name);
							_g_object_unref0 (_tmp27_);
							continue;
						}
						_tmp47_ = dir;
						_tmp48_ = name;
						_tmp49_ = g_build_path (G_DIR_SEPARATOR_S, _tmp47_, _tmp48_, NULL);
						path = _tmp49_;
						{
							GKeyFile* keyfile = NULL;
							GKeyFile* _tmp50_;
							GKeyFile* _tmp51_;
							const gchar* _tmp52_;
							gchar* cat_name = NULL;
							GKeyFile* _tmp53_;
							gchar* _tmp54_;
							gboolean _tmp55_ = FALSE;
							const gchar* _tmp56_;
							_tmp50_ = g_key_file_new ();
							keyfile = _tmp50_;
							_tmp51_ = keyfile;
							_tmp52_ = path;
							g_key_file_load_from_file (_tmp51_, _tmp52_, G_KEY_FILE_NONE, &_inner_error0_);
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_key_file_unref0 (keyfile);
								goto __catch1_g_error;
							}
							_tmp53_ = keyfile;
							_tmp54_ = g_key_file_get_locale_string (_tmp53_, "Desktop Entry", "Name", NULL, &_inner_error0_);
							cat_name = _tmp54_;
							if (G_UNLIKELY (_inner_error0_ != NULL)) {
								_g_key_file_unref0 (keyfile);
								goto __catch1_g_error;
							}
							_tmp56_ = cat_name;
							if (_tmp56_ != NULL) {
								const gchar* _tmp57_;
								_tmp57_ = cat_name;
								_tmp55_ = g_strcmp0 (_tmp57_, "") != 0;
							} else {
								_tmp55_ = FALSE;
							}
							if (_tmp55_) {
								GeeArrayList* _tmp58_;
								const gchar* _tmp59_;
								const gchar* _tmp60_;
								gchar* _tmp61_;
								gchar** _tmp62_;
								SlingshotBackendCategory* _tmp63_ = NULL;
								SlingshotBackendCategory* _tmp64_;
								_tmp58_ = self->priv->categories_cache;
								_tmp59_ = cat_name;
								_tmp60_ = cat_id;
								_tmp61_ = g_strdup (_tmp60_);
								_tmp62_ = g_new0 (gchar*, 1 + 1);
								_tmp62_[0] = _tmp61_;
								_tmp63_ = slingshot_backend_category_new (_tmp59_, FALSE);
								_tmp63_->included_categories = (_vala_array_free (_tmp63_->included_categories, _tmp63_->included_categories_length1, (GDestroyNotify) g_free), NULL);
								_tmp63_->included_categories = _tmp62_;
								_tmp63_->included_categories_length1 = 1;
								_tmp64_ = _tmp63_;
								gee_abstract_collection_add ((GeeAbstractCollection*) _tmp58_, _tmp64_);
								_g_object_unref0 (_tmp64_);
							}
							_g_free0 (cat_name);
							_g_key_file_unref0 (keyfile);
						}
						goto __finally1;
						__catch1_g_error:
						{
							g_clear_error (&_inner_error0_);
						}
						__finally1:
						if (G_UNLIKELY (_inner_error0_ != NULL)) {
							_g_free0 (path);
							_g_free0 (cat_id);
							_g_free0 (name);
							_g_object_unref0 (_tmp27_);
							_g_object_unref0 (info);
							_g_object_unref0 (enumerator);
							goto __catch0_g_error;
						}
						_g_free0 (path);
						_g_free0 (cat_id);
						_g_free0 (name);
						_g_object_unref0 (_tmp27_);
					}
					_g_object_unref0 (info);
					_g_object_unref0 (enumerator);
				}
				goto __finally0;
				__catch0_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (folder);
					_g_free0 (dir);
					predefined = (_vala_array_free (predefined, predefined_length1, (GDestroyNotify) g_free), NULL);
					dir_paths = (_vala_array_free (dir_paths, dir_paths_length1, (GDestroyNotify) g_free), NULL);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_g_object_unref0 (folder);
				_g_free0 (dir);
			}
		}
	}
	_tmp65_ = self->priv->categories_cache;
	_tmp66_ = g_strdup ("Utility");
	_tmp67_ = g_new0 (gchar*, 1 + 1);
	_tmp67_[0] = _tmp66_;
	_tmp68_ = g_strdup ("Accessibility");
	_tmp69_ = g_strdup ("System");
	_tmp70_ = g_new0 (gchar*, 2 + 1);
	_tmp70_[0] = _tmp68_;
	_tmp70_[1] = _tmp69_;
	_tmp71_ = g_strdup ("plank.desktop");
	_tmp72_ = g_new0 (gchar*, 1 + 1);
	_tmp72_[0] = _tmp71_;
	_tmp73_ = slingshot_backend_category_new (_ ("Accessories"), FALSE);
	_tmp73_->included_categories = (_vala_array_free (_tmp73_->included_categories, _tmp73_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp73_->included_categories = _tmp67_;
	_tmp73_->included_categories_length1 = 1;
	_tmp73_->excluded_categories = (_vala_array_free (_tmp73_->excluded_categories, _tmp73_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp73_->excluded_categories = _tmp70_;
	_tmp73_->excluded_categories_length1 = 2;
	_tmp73_->excluded_applications = (_vala_array_free (_tmp73_->excluded_applications, _tmp73_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp73_->excluded_applications = _tmp72_;
	_tmp73_->excluded_applications_length1 = 1;
	_tmp74_ = _tmp73_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp65_, _tmp74_);
	_g_object_unref0 (_tmp74_);
	_tmp75_ = self->priv->categories_cache;
	_tmp76_ = g_strdup ("Accessibility");
	_tmp77_ = g_new0 (gchar*, 1 + 1);
	_tmp77_[0] = _tmp76_;
	_tmp78_ = slingshot_backend_category_new (_ ("Universal Access"), FALSE);
	_tmp78_->included_categories = (_vala_array_free (_tmp78_->included_categories, _tmp78_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp78_->included_categories = _tmp77_;
	_tmp78_->included_categories_length1 = 1;
	_tmp79_ = _tmp78_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp75_, _tmp79_);
	_g_object_unref0 (_tmp79_);
	_tmp80_ = self->priv->categories_cache;
	_tmp81_ = g_strdup ("Development");
	_tmp82_ = g_new0 (gchar*, 1 + 1);
	_tmp82_[0] = _tmp81_;
	_tmp83_ = slingshot_backend_category_new (_ ("Programming"), FALSE);
	_tmp83_->included_categories = (_vala_array_free (_tmp83_->included_categories, _tmp83_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp83_->included_categories = _tmp82_;
	_tmp83_->included_categories_length1 = 1;
	_tmp84_ = _tmp83_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp80_, _tmp84_);
	_g_object_unref0 (_tmp84_);
	_tmp85_ = self->priv->categories_cache;
	_tmp86_ = g_strdup ("Education");
	_tmp87_ = g_new0 (gchar*, 1 + 1);
	_tmp87_[0] = _tmp86_;
	_tmp88_ = g_strdup ("Science");
	_tmp89_ = g_new0 (gchar*, 1 + 1);
	_tmp89_[0] = _tmp88_;
	_tmp90_ = slingshot_backend_category_new (_ ("Education"), FALSE);
	_tmp90_->included_categories = (_vala_array_free (_tmp90_->included_categories, _tmp90_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp90_->included_categories = _tmp87_;
	_tmp90_->included_categories_length1 = 1;
	_tmp90_->excluded_categories = (_vala_array_free (_tmp90_->excluded_categories, _tmp90_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp90_->excluded_categories = _tmp89_;
	_tmp90_->excluded_categories_length1 = 1;
	_tmp91_ = _tmp90_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp85_, _tmp91_);
	_g_object_unref0 (_tmp91_);
	_tmp92_ = self->priv->categories_cache;
	_tmp93_ = g_strdup ("Science");
	_tmp94_ = g_strdup ("Education");
	_tmp95_ = g_new0 (gchar*, 2 + 1);
	_tmp95_[0] = _tmp93_;
	_tmp95_[1] = _tmp94_;
	_tmp96_ = g_strdup ("libreoffice-math.desktop");
	_tmp97_ = g_new0 (gchar*, 1 + 1);
	_tmp97_[0] = _tmp96_;
	_tmp98_ = slingshot_backend_category_new (_ ("Science"), FALSE);
	_tmp98_->included_categories = (_vala_array_free (_tmp98_->included_categories, _tmp98_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp98_->included_categories = _tmp95_;
	_tmp98_->included_categories_length1 = 2;
	_tmp98_->excluded_applications = (_vala_array_free (_tmp98_->excluded_applications, _tmp98_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp98_->excluded_applications = _tmp97_;
	_tmp98_->excluded_applications_length1 = 1;
	_tmp99_ = _tmp98_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp92_, _tmp99_);
	_g_object_unref0 (_tmp99_);
	_tmp100_ = self->priv->categories_cache;
	_tmp101_ = g_strdup ("Game");
	_tmp102_ = g_new0 (gchar*, 1 + 1);
	_tmp102_[0] = _tmp101_;
	_tmp103_ = slingshot_backend_category_new (_ ("Games"), FALSE);
	_tmp103_->included_categories = (_vala_array_free (_tmp103_->included_categories, _tmp103_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp103_->included_categories = _tmp102_;
	_tmp103_->included_categories_length1 = 1;
	_tmp104_ = _tmp103_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp100_, _tmp104_);
	_g_object_unref0 (_tmp104_);
	_tmp105_ = self->priv->categories_cache;
	_tmp106_ = g_strdup ("Graphics");
	_tmp107_ = g_new0 (gchar*, 1 + 1);
	_tmp107_[0] = _tmp106_;
	_tmp108_ = slingshot_backend_category_new (_ ("Graphics"), FALSE);
	_tmp108_->included_categories = (_vala_array_free (_tmp108_->included_categories, _tmp108_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp108_->included_categories = _tmp107_;
	_tmp108_->included_categories_length1 = 1;
	_tmp109_ = _tmp108_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp105_, _tmp109_);
	_g_object_unref0 (_tmp109_);
	_tmp110_ = self->priv->categories_cache;
	_tmp111_ = g_strdup ("Network");
	_tmp112_ = g_new0 (gchar*, 1 + 1);
	_tmp112_[0] = _tmp111_;
	_tmp113_ = slingshot_backend_category_new (_ ("Internet"), FALSE);
	_tmp113_->included_categories = (_vala_array_free (_tmp113_->included_categories, _tmp113_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp113_->included_categories = _tmp112_;
	_tmp113_->included_categories_length1 = 1;
	_tmp114_ = _tmp113_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp110_, _tmp114_);
	_g_object_unref0 (_tmp114_);
	_tmp115_ = self->priv->categories_cache;
	_tmp116_ = g_strdup ("AudioVideo");
	_tmp117_ = g_new0 (gchar*, 1 + 1);
	_tmp117_[0] = _tmp116_;
	_tmp118_ = slingshot_backend_category_new (_ ("Sound & Video"), FALSE);
	_tmp118_->included_categories = (_vala_array_free (_tmp118_->included_categories, _tmp118_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp118_->included_categories = _tmp117_;
	_tmp118_->included_categories_length1 = 1;
	_tmp119_ = _tmp118_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, _tmp119_);
	_g_object_unref0 (_tmp119_);
	_tmp120_ = self->priv->categories_cache;
	_tmp121_ = g_strdup ("Office");
	_tmp122_ = g_new0 (gchar*, 1 + 1);
	_tmp122_[0] = _tmp121_;
	_tmp123_ = slingshot_backend_category_new (_ ("Office"), FALSE);
	_tmp123_->included_categories = (_vala_array_free (_tmp123_->included_categories, _tmp123_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp123_->included_categories = _tmp122_;
	_tmp123_->included_categories_length1 = 1;
	_tmp124_ = _tmp123_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp120_, _tmp124_);
	_g_object_unref0 (_tmp124_);
	_tmp125_ = self->priv->categories_cache;
	_tmp126_ = g_strdup ("System");
	_tmp127_ = g_strdup ("Administration");
	_tmp128_ = g_strdup ("Settings");
	_tmp129_ = g_new0 (gchar*, 3 + 1);
	_tmp129_[0] = _tmp126_;
	_tmp129_[1] = _tmp127_;
	_tmp129_[2] = _tmp128_;
	_tmp130_ = g_strdup ("Game");
	_tmp131_ = g_new0 (gchar*, 1 + 1);
	_tmp131_[0] = _tmp130_;
	_tmp132_ = g_strdup ("onboard-settings.desktop");
	_tmp133_ = g_new0 (gchar*, 1 + 1);
	_tmp133_[0] = _tmp132_;
	_tmp134_ = slingshot_backend_category_new (_ ("System Tools"), FALSE);
	_tmp134_->included_categories = (_vala_array_free (_tmp134_->included_categories, _tmp134_->included_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp134_->included_categories = _tmp129_;
	_tmp134_->included_categories_length1 = 3;
	_tmp134_->excluded_categories = (_vala_array_free (_tmp134_->excluded_categories, _tmp134_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp134_->excluded_categories = _tmp131_;
	_tmp134_->excluded_categories_length1 = 1;
	_tmp134_->excluded_applications = (_vala_array_free (_tmp134_->excluded_applications, _tmp134_->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_tmp134_->excluded_applications = _tmp133_;
	_tmp134_->excluded_applications_length1 = 1;
	_tmp135_ = _tmp134_;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp125_, _tmp135_);
	_g_object_unref0 (_tmp135_);
	_tmp136_ = g_strdup ("Core");
	_tmp137_ = g_strdup ("Screensaver");
	_tmp138_ = g_strdup ("Settings");
	_tmp139_ = g_new0 (gchar*, 3 + 1);
	_tmp139_[0] = _tmp136_;
	_tmp139_[1] = _tmp137_;
	_tmp139_[2] = _tmp138_;
	_tmp140_ = slingshot_backend_category_new (_ ("Other"), TRUE);
	_tmp140_->excluded_categories = (_vala_array_free (_tmp140_->excluded_categories, _tmp140_->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	_tmp140_->excluded_categories = _tmp139_;
	_tmp140_->excluded_categories_length1 = 3;
	other_category = _tmp140_;
	_tmp141_ = g_app_info_get_all ();
	{
		GList* app_collection = NULL;
		GList* app_it = NULL;
		app_collection = _tmp141_;
		for (app_it = app_collection; app_it != NULL; app_it = app_it->next) {
			GAppInfo* _tmp142_;
			GAppInfo* app = NULL;
			_tmp142_ = _g_object_ref0 ((GAppInfo*) app_it->data);
			app = _tmp142_;
			{
				GDesktopAppInfo* desktop_app = NULL;
				GAppInfo* _tmp143_;
				GDesktopAppInfo* _tmp144_;
				GDesktopAppInfo* _tmp145_;
				gchar* control_center = NULL;
				gchar* _tmp146_;
				gchar* _tmp147_;
				gchar* _tmp148_;
				gboolean _tmp149_;
				gboolean _tmp151_ = FALSE;
				GAppInfo* _tmp152_;
				const gchar* _tmp153_;
				const gchar* _tmp154_;
				GAppInfo* _tmp162_;
				const gchar* _tmp163_;
				gboolean found_category = FALSE;
				_tmp143_ = app;
				desktop_app = G_TYPE_CHECK_INSTANCE_TYPE (_tmp143_, G_TYPE_DESKTOP_APP_INFO) ? ((GDesktopAppInfo*) _tmp143_) : NULL;
				_tmp144_ = desktop_app;
				if (_tmp144_ == NULL) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp145_ = desktop_app;
				if (!g_app_info_should_show ((GAppInfo*) _tmp145_)) {
					_g_object_unref0 (app);
					continue;
				}
				_tmp146_ = g_strdup ("gnome-control-center");
				control_center = _tmp146_;
				_tmp147_ = g_find_program_in_path ("budgie-control-center");
				_tmp148_ = _tmp147_;
				_tmp149_ = _tmp148_ != NULL;
				_g_free0 (_tmp148_);
				if (_tmp149_) {
					gchar* _tmp150_;
					_tmp150_ = g_strdup ("budgie-control-center");
					_g_free0 (control_center);
					control_center = _tmp150_;
				}
				_tmp152_ = app;
				_tmp153_ = g_app_info_get_commandline (_tmp152_);
				_tmp154_ = control_center;
				if (string_contains (_tmp153_, _tmp154_)) {
					GAppInfo* _tmp155_;
					const gchar* _tmp156_;
					gint _tmp157_;
					gint _tmp158_;
					const gchar* _tmp159_;
					gint _tmp160_;
					gint _tmp161_;
					_tmp155_ = app;
					_tmp156_ = g_app_info_get_commandline (_tmp155_);
					_tmp157_ = strlen (_tmp156_);
					_tmp158_ = _tmp157_;
					_tmp159_ = control_center;
					_tmp160_ = strlen (_tmp159_);
					_tmp161_ = _tmp160_;
					_tmp151_ = _tmp158_ != _tmp161_;
				} else {
					_tmp151_ = FALSE;
				}
				if (_tmp151_) {
					_g_free0 (control_center);
					_g_object_unref0 (app);
					continue;
				}
				_tmp162_ = app;
				_tmp163_ = g_app_info_get_commandline (_tmp162_);
				if (g_strcmp0 (_tmp163_, "plank") == 0) {
					_g_free0 (control_center);
					_g_object_unref0 (app);
					continue;
				}
				found_category = FALSE;
				{
					GeeArrayList* _category_list = NULL;
					GeeArrayList* _tmp164_;
					gint _category_size = 0;
					GeeArrayList* _tmp165_;
					gint _tmp166_;
					gint _tmp167_;
					gint _category_index = 0;
					_tmp164_ = self->priv->categories_cache;
					_category_list = _tmp164_;
					_tmp165_ = _category_list;
					_tmp166_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp165_);
					_tmp167_ = _tmp166_;
					_category_size = _tmp167_;
					_category_index = -1;
					while (TRUE) {
						gint _tmp168_;
						gint _tmp169_;
						SlingshotBackendCategory* category = NULL;
						GeeArrayList* _tmp170_;
						gpointer _tmp171_;
						SlingshotBackendCategory* _tmp172_;
						GDesktopAppInfo* _tmp173_;
						_category_index = _category_index + 1;
						_tmp168_ = _category_index;
						_tmp169_ = _category_size;
						if (!(_tmp168_ < _tmp169_)) {
							break;
						}
						_tmp170_ = _category_list;
						_tmp171_ = gee_abstract_list_get ((GeeAbstractList*) _tmp170_, _category_index);
						category = (SlingshotBackendCategory*) _tmp171_;
						_tmp172_ = category;
						_tmp173_ = desktop_app;
						if (slingshot_backend_category_add_app_if_matches (_tmp172_, _tmp173_)) {
							found_category = TRUE;
						}
						_g_object_unref0 (category);
					}
				}
				if (!found_category) {
					SlingshotBackendCategory* _tmp174_;
					GDesktopAppInfo* _tmp175_;
					_tmp174_ = other_category;
					_tmp175_ = desktop_app;
					slingshot_backend_category_add_app_if_matches (_tmp174_, _tmp175_);
				}
				_g_free0 (control_center);
				_g_object_unref0 (app);
			}
		}
		(app_collection == NULL) ? NULL : (app_collection = (_g_list_free__g_object_unref0_ (app_collection), NULL));
	}
	_tmp176_ = other_category;
	_tmp177_ = slingshot_backend_category_get_apps (_tmp176_);
	_tmp178_ = _tmp177_;
	_tmp179_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp178_);
	_tmp180_ = _tmp179_;
	if (_tmp180_ > 0) {
		GeeArrayList* _tmp181_;
		SlingshotBackendCategory* _tmp182_;
		_tmp181_ = self->priv->categories_cache;
		_tmp182_ = other_category;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp181_, _tmp182_);
	}
	_tmp183_ = self->priv->_apps;
	gee_abstract_map_clear ((GeeAbstractMap*) _tmp183_);
	{
		GeeArrayList* _cat_list = NULL;
		GeeArrayList* _tmp184_;
		gint _cat_size = 0;
		GeeArrayList* _tmp185_;
		gint _tmp186_;
		gint _tmp187_;
		gint _cat_index = 0;
		_tmp184_ = self->priv->categories_cache;
		_cat_list = _tmp184_;
		_tmp185_ = _cat_list;
		_tmp186_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp185_);
		_tmp187_ = _tmp186_;
		_cat_size = _tmp187_;
		_cat_index = -1;
		while (TRUE) {
			gint _tmp188_;
			gint _tmp189_;
			SlingshotBackendCategory* cat = NULL;
			GeeArrayList* _tmp190_;
			gpointer _tmp191_;
			SlingshotBackendCategory* _tmp192_;
			GeeArrayList* _tmp193_;
			GeeArrayList* _tmp194_;
			gint _tmp195_;
			gint _tmp196_;
			_cat_index = _cat_index + 1;
			_tmp188_ = _cat_index;
			_tmp189_ = _cat_size;
			if (!(_tmp188_ < _tmp189_)) {
				break;
			}
			_tmp190_ = _cat_list;
			_tmp191_ = gee_abstract_list_get ((GeeAbstractList*) _tmp190_, _cat_index);
			cat = (SlingshotBackendCategory*) _tmp191_;
			_tmp192_ = cat;
			_tmp193_ = slingshot_backend_category_get_apps (_tmp192_);
			_tmp194_ = _tmp193_;
			_tmp195_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp194_);
			_tmp196_ = _tmp195_;
			if (_tmp196_ > 0) {
				GeeHashMap* _tmp197_;
				SlingshotBackendCategory* _tmp198_;
				const gchar* _tmp199_;
				const gchar* _tmp200_;
				SlingshotBackendCategory* _tmp201_;
				GeeArrayList* _tmp202_;
				GeeArrayList* _tmp203_;
				_tmp197_ = self->priv->_apps;
				_tmp198_ = cat;
				_tmp199_ = slingshot_backend_category_get_name (_tmp198_);
				_tmp200_ = _tmp199_;
				_tmp201_ = cat;
				_tmp202_ = slingshot_backend_category_get_apps (_tmp201_);
				_tmp203_ = _tmp202_;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp197_, _tmp200_, _tmp203_);
			}
			_g_object_unref0 (cat);
		}
	}
	_g_object_unref0 (other_category);
	predefined = (_vala_array_free (predefined, predefined_length1, (GDestroyNotify) g_free), NULL);
	dir_paths = (_vala_array_free (dir_paths, dir_paths_length1, (GDestroyNotify) g_free), NULL);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gint
_slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func (gconstpointer a,
                                                                    gconstpointer b,
                                                                    gpointer self)
{
	gint result;
	result = slingshot_backend_app_system_sort_apps_by_name ((SlingshotBackendApp*) a, (SlingshotBackendApp*) b);
	return result;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

GSList*
slingshot_backend_app_system_get_apps_by_name (SlingshotBackendAppSystem* self)
{
	GSList* sorted_apps = NULL;
	gchar** sorted_apps_execs = NULL;
	gchar** _tmp0_;
	gint sorted_apps_execs_length1;
	gint _sorted_apps_execs_size_;
	GSList* result;
	g_return_val_if_fail (self != NULL, NULL);
	sorted_apps = NULL;
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	sorted_apps_execs = _tmp0_;
	sorted_apps_execs_length1 = 0;
	_sorted_apps_execs_size_ = sorted_apps_execs_length1;
	{
		GeeIterator* _category_it = NULL;
		GeeHashMap* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeCollection* _tmp4_;
		GeeIterator* _tmp5_;
		GeeIterator* _tmp6_;
		_tmp1_ = self->priv->_apps;
		_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp1_);
		_tmp3_ = _tmp2_;
		_tmp4_ = _tmp3_;
		_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_category_it = _tmp6_;
		while (TRUE) {
			GeeIterator* _tmp7_;
			GeeArrayList* category = NULL;
			GeeIterator* _tmp8_;
			gpointer _tmp9_;
			_tmp7_ = _category_it;
			if (!gee_iterator_next (_tmp7_)) {
				break;
			}
			_tmp8_ = _category_it;
			_tmp9_ = gee_iterator_get (_tmp8_);
			category = (GeeArrayList*) _tmp9_;
			{
				GeeArrayList* _app_list = NULL;
				GeeArrayList* _tmp10_;
				gint _app_size = 0;
				GeeArrayList* _tmp11_;
				gint _tmp12_;
				gint _tmp13_;
				gint _app_index = 0;
				_tmp10_ = category;
				_app_list = _tmp10_;
				_tmp11_ = _app_list;
				_tmp12_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp11_);
				_tmp13_ = _tmp12_;
				_app_size = _tmp13_;
				_app_index = -1;
				while (TRUE) {
					gint _tmp14_;
					gint _tmp15_;
					SlingshotBackendApp* app = NULL;
					GeeArrayList* _tmp16_;
					gpointer _tmp17_;
					SlingshotBackendApp* _tmp18_;
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					gchar** _tmp21_;
					gint _tmp21__length1;
					_app_index = _app_index + 1;
					_tmp14_ = _app_index;
					_tmp15_ = _app_size;
					if (!(_tmp14_ < _tmp15_)) {
						break;
					}
					_tmp16_ = _app_list;
					_tmp17_ = gee_abstract_list_get ((GeeAbstractList*) _tmp16_, _app_index);
					app = (SlingshotBackendApp*) _tmp17_;
					_tmp18_ = app;
					_tmp19_ = slingshot_backend_app_get_exec (_tmp18_);
					_tmp20_ = _tmp19_;
					_tmp21_ = sorted_apps_execs;
					_tmp21__length1 = sorted_apps_execs_length1;
					if (!_vala_string_array_contains (_tmp21_, _tmp21__length1, _tmp20_)) {
						SlingshotBackendApp* _tmp22_;
						SlingshotBackendApp* _tmp23_;
						SlingshotBackendApp* _tmp24_;
						const gchar* _tmp25_;
						const gchar* _tmp26_;
						gchar* _tmp27_;
						_tmp22_ = app;
						_tmp23_ = _g_object_ref0 (_tmp22_);
						sorted_apps = g_slist_insert_sorted_with_data (sorted_apps, _tmp23_, _slingshot_backend_app_system_sort_apps_by_name_gcompare_data_func, NULL);
						_tmp24_ = app;
						_tmp25_ = slingshot_backend_app_get_exec (_tmp24_);
						_tmp26_ = _tmp25_;
						_tmp27_ = g_strdup (_tmp26_);
						_vala_array_add2 (&sorted_apps_execs, &sorted_apps_execs_length1, &_sorted_apps_execs_size_, _tmp27_);
					}
					_g_object_unref0 (app);
				}
			}
			_g_object_unref0 (category);
		}
		_g_object_unref0 (_category_it);
	}
	result = sorted_apps;
	sorted_apps_execs = (_vala_array_free (sorted_apps_execs, sorted_apps_execs_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static gint
slingshot_backend_app_system_sort_apps_by_name (SlingshotBackendApp* a,
                                                SlingshotBackendApp* b)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = slingshot_backend_app_get_name (a);
	_tmp1_ = _tmp0_;
	_tmp2_ = slingshot_backend_app_get_name (b);
	_tmp3_ = _tmp2_;
	result = g_utf8_collate (_tmp1_, _tmp3_);
	return result;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_construct (GType object_type)
{
	SlingshotBackendAppSystem * self = NULL;
	self = (SlingshotBackendAppSystem*) g_object_new (object_type, NULL);
	return self;
}

SlingshotBackendAppSystem*
slingshot_backend_app_system_new (void)
{
	return slingshot_backend_app_system_construct (SLINGSHOT_BACKEND_TYPE_APP_SYSTEM);
}

GeeHashMap*
slingshot_backend_app_system_get_apps (SlingshotBackendAppSystem* self)
{
	GeeHashMap* result;
	GeeHashMap* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_app_system_set_apps (SlingshotBackendAppSystem* self,
                                       GeeHashMap* value)
{
	GeeHashMap* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_app_system_get_apps (self);
	if (old_value != value) {
		GeeHashMap* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY]);
	}
}

static void
_slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed (GAppInfoMonitor* _sender,
                                                                                  gpointer self)
{
	slingshot_backend_app_system_queue_update_app_system ((SlingshotBackendAppSystem*) self);
}

static GObject *
slingshot_backend_app_system_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendAppSystem * self;
	GAppInfoMonitor* _tmp0_;
	GAppInfoMonitor* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeArrayList* _tmp4_;
	parent_class = G_OBJECT_CLASS (slingshot_backend_app_system_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_tmp0_ = g_app_info_monitor_get ();
	_g_object_unref0 (self->priv->app_monitor);
	self->priv->app_monitor = _tmp0_;
	_tmp1_ = self->priv->app_monitor;
	g_signal_connect_object (_tmp1_, "changed", (GCallback) _slingshot_backend_app_system_queue_update_app_system_g_app_info_monitor_changed, self, 0);
	_tmp2_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, GEE_TYPE_ARRAY_LIST, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_tmp3_ = _tmp2_;
	slingshot_backend_app_system_set_apps (self, _tmp3_);
	_g_object_unref0 (_tmp3_);
	_tmp4_ = gee_array_list_new (SLINGSHOT_BACKEND_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->categories_cache);
	self->priv->categories_cache = _tmp4_;
	slingshot_backend_app_system_update_app_system (self);
	return obj;
}

static void
slingshot_backend_app_system_class_init (SlingshotBackendAppSystemClass * klass,
                                         gpointer klass_data)
{
	slingshot_backend_app_system_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendAppSystem_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_app_system_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_app_system_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_app_system_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_app_system_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY, slingshot_backend_app_system_properties[SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", GEE_TYPE_HASH_MAP, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	slingshot_backend_app_system_signals[SLINGSHOT_BACKEND_APP_SYSTEM_CHANGED_SIGNAL] = g_signal_new ("changed", SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
slingshot_backend_app_system_instance_init (SlingshotBackendAppSystem * self,
                                            gpointer klass)
{
	self->priv = slingshot_backend_app_system_get_instance_private (self);
	self->priv->_apps = NULL;
	self->priv->refresh_timeout_id = (guint) 0;
	self->priv->categories_cache = NULL;
}

static void
slingshot_backend_app_system_finalize (GObject * obj)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	_g_object_unref0 (self->priv->_apps);
	_g_object_unref0 (self->priv->categories_cache);
	_g_object_unref0 (self->priv->app_monitor);
	G_OBJECT_CLASS (slingshot_backend_app_system_parent_class)->finalize (obj);
}

GType
slingshot_backend_app_system_get_type (void)
{
	return slingshot_backend_app_system_type_id;
}

GType
slingshot_backend_app_system_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendAppSystemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_app_system_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendAppSystem), 0, (GInstanceInitFunc) slingshot_backend_app_system_instance_init, NULL };
	slingshot_backend_app_system_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "SlingshotBackendAppSystem", &g_define_type_info, 0);
	SlingshotBackendAppSystem_private_offset = sizeof (SlingshotBackendAppSystemPrivate);
	return slingshot_backend_app_system_type_id;
}

static void
_vala_slingshot_backend_app_system_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		g_value_set_object (value, slingshot_backend_app_system_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_app_system_set_property (GObject * object,
                                                 guint property_id,
                                                 const GValue * value,
                                                 GParamSpec * pspec)
{
	SlingshotBackendAppSystem * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_APP_SYSTEM, SlingshotBackendAppSystem);
	switch (property_id) {
		case SLINGSHOT_BACKEND_APP_SYSTEM_APPS_PROPERTY:
		slingshot_backend_app_system_set_apps (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

