/* desktop_menu.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from desktop_menu.vala, do not modify */

/*
Copyright Buddies of Budgie

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DESKTOP_MENU (desktop_menu_get_type ())
#define DESKTOP_MENU(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_MENU, DesktopMenu))
#define DESKTOP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_MENU, DesktopMenuClass))
#define IS_DESKTOP_MENU(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_MENU))
#define IS_DESKTOP_MENU_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_MENU))
#define DESKTOP_MENU_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_MENU, DesktopMenuClass))

typedef struct _DesktopMenu DesktopMenu;
typedef struct _DesktopMenuClass DesktopMenuClass;
typedef struct _DesktopMenuPrivate DesktopMenuPrivate;

#define TYPE_DESKTOP_VIEW (desktop_view_get_type ())
#define DESKTOP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DESKTOP_VIEW, DesktopView))
#define DESKTOP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DESKTOP_VIEW, DesktopViewClass))
#define IS_DESKTOP_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DESKTOP_VIEW))
#define IS_DESKTOP_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DESKTOP_VIEW))
#define DESKTOP_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DESKTOP_VIEW, DesktopViewClass))

typedef struct _DesktopView DesktopView;
typedef struct _DesktopViewClass DesktopViewClass;
enum  {
	DESKTOP_MENU_0_PROPERTY,
	DESKTOP_MENU_NUM_PROPERTIES
};
static GParamSpec* desktop_menu_properties[DESKTOP_MENU_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	DESKTOP_MENU_TOGGLE_AUTO_ARRANGE_SIGNAL,
	DESKTOP_MENU_NUM_SIGNALS
};
static guint desktop_menu_signals[DESKTOP_MENU_NUM_SIGNALS] = {0};

struct _DesktopMenu {
	GtkMenu parent_instance;
	DesktopMenuPrivate * priv;
};

struct _DesktopMenuClass {
	GtkMenuClass parent_class;
};

struct _DesktopMenuPrivate {
	GDesktopAppInfo* budgie_app;
	GDesktopAppInfo* bcc_app;
	DesktopView* desktop_view;
	GtkCheckMenuItem* auto_arrange_item;
};

static gint DesktopMenu_private_offset;
static gpointer desktop_menu_parent_class = NULL;

VALA_EXTERN GType desktop_menu_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopMenu, g_object_unref)
VALA_EXTERN GType desktop_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DesktopView, g_object_unref)
VALA_EXTERN DesktopMenu* desktop_menu_new (DesktopView* view);
VALA_EXTERN DesktopMenu* desktop_menu_construct (GType object_type,
                                     DesktopView* view);
static void desktop_menu_on_budgie_settings_activated (DesktopMenu* self);
static void _desktop_menu_on_budgie_settings_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void desktop_menu_on_system_settings_activated (DesktopMenu* self);
static void _desktop_menu_on_system_settings_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                        gpointer self);
static void desktop_menu_on_auto_arrange_activated (DesktopMenu* self);
static void _desktop_menu_on_auto_arrange_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                     gpointer self);
VALA_EXTERN void desktop_menu_set_auto_arrange_state (DesktopMenu* self,
                                          gboolean is_auto_arranged);
static void desktop_menu_finalize (GObject * obj);
static GType desktop_menu_get_type_once (void);

static inline gpointer
desktop_menu_get_instance_private (DesktopMenu* self)
{
	return G_STRUCT_MEMBER_P (self, DesktopMenu_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_desktop_menu_on_budgie_settings_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	desktop_menu_on_budgie_settings_activated ((DesktopMenu*) self);
}

static void
_desktop_menu_on_system_settings_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                   gpointer self)
{
	desktop_menu_on_system_settings_activated ((DesktopMenu*) self);
}

static void
_desktop_menu_on_auto_arrange_activated_gtk_menu_item_activate (GtkMenuItem* _sender,
                                                                gpointer self)
{
	desktop_menu_on_auto_arrange_activated ((DesktopMenu*) self);
}

DesktopMenu*
desktop_menu_construct (GType object_type,
                        DesktopView* view)
{
	DesktopMenu * self = NULL;
	DesktopView* _tmp0_;
	GDesktopAppInfo* _tmp1_;
	GDesktopAppInfo* _tmp2_;
	GtkMenuItem* budgie_item = NULL;
	GtkMenuItem* _tmp3_;
	GtkMenuItem* system_item = NULL;
	GtkMenuItem* _tmp4_;
	GtkCheckMenuItem* _tmp5_;
	GtkCheckMenuItem* _tmp6_;
	GtkCheckMenuItem* _tmp7_;
	GtkSeparatorMenuItem* _tmp8_;
	GtkSeparatorMenuItem* _tmp9_;
	GtkCheckMenuItem* _tmp10_;
	GtkCheckMenuItem* _tmp11_;
	g_return_val_if_fail (view != NULL, NULL);
	self = (DesktopMenu*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (view);
	_g_object_unref0 (self->priv->desktop_view);
	self->priv->desktop_view = _tmp0_;
	_tmp1_ = g_desktop_app_info_new ("org.buddiesofbudgie.BudgieDesktopSettings.desktop");
	_g_object_unref0 (self->priv->budgie_app);
	self->priv->budgie_app = _tmp1_;
	_tmp2_ = g_desktop_app_info_new ("org.buddiesofbudgie.ControlCenter.desktop");
	_g_object_unref0 (self->priv->bcc_app);
	self->priv->bcc_app = _tmp2_;
	_tmp3_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("Budgie Desktop Settings"));
	g_object_ref_sink (_tmp3_);
	budgie_item = _tmp3_;
	_tmp4_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_ ("System Settings"));
	g_object_ref_sink (_tmp4_);
	system_item = _tmp4_;
	_tmp5_ = (GtkCheckMenuItem*) gtk_check_menu_item_new_with_label (_ ("Auto-arrange"));
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->auto_arrange_item);
	self->priv->auto_arrange_item = _tmp5_;
	g_signal_connect_object (budgie_item, "activate", (GCallback) _desktop_menu_on_budgie_settings_activated_gtk_menu_item_activate, self, 0);
	g_signal_connect_object (system_item, "activate", (GCallback) _desktop_menu_on_system_settings_activated_gtk_menu_item_activate, self, 0);
	_tmp6_ = self->priv->auto_arrange_item;
	g_signal_connect_object ((GtkMenuItem*) _tmp6_, "activate", (GCallback) _desktop_menu_on_auto_arrange_activated_gtk_menu_item_activate, self, 0);
	gtk_widget_show_all ((GtkWidget*) budgie_item);
	gtk_widget_show_all ((GtkWidget*) system_item);
	_tmp7_ = self->priv->auto_arrange_item;
	gtk_widget_show_all ((GtkWidget*) _tmp7_);
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) budgie_item, 0);
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) system_item, 1);
	_tmp8_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp9_, 2);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->auto_arrange_item;
	gtk_menu_shell_insert ((GtkMenuShell*) self, (GtkWidget*) _tmp10_, 3);
	_tmp11_ = self->priv->auto_arrange_item;
	gtk_check_menu_item_set_active (_tmp11_, TRUE);
	_g_object_unref0 (system_item);
	_g_object_unref0 (budgie_item);
	return self;
}

DesktopMenu*
desktop_menu_new (DesktopView* view)
{
	return desktop_menu_construct (TYPE_DESKTOP_MENU, view);
}

static void
desktop_menu_on_auto_arrange_activated (DesktopMenu* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, desktop_menu_signals[DESKTOP_MENU_TOGGLE_AUTO_ARRANGE_SIGNAL], 0);
	gtk_menu_popdown ((GtkMenu*) self);
}

void
desktop_menu_set_auto_arrange_state (DesktopMenu* self,
                                     gboolean is_auto_arranged)
{
	GtkCheckMenuItem* _tmp0_;
	guint _tmp1_;
	GtkCheckMenuItem* _tmp2_;
	GtkCheckMenuItem* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->auto_arrange_item;
	g_signal_parse_name ("activate", gtk_menu_item_get_type (), &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched ((GtkMenuItem*) _tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _desktop_menu_on_auto_arrange_activated_gtk_menu_item_activate, self);
	_tmp2_ = self->priv->auto_arrange_item;
	gtk_check_menu_item_set_active (_tmp2_, is_auto_arranged);
	_tmp3_ = self->priv->auto_arrange_item;
	g_signal_connect_object ((GtkMenuItem*) _tmp3_, "activate", (GCallback) _desktop_menu_on_auto_arrange_activated_gtk_menu_item_activate, self, 0);
	if (is_auto_arranged) {
		g_debug ("desktop_menu.vala:70: Auto-arrange menu: checked (alphabetical sorting" \
")");
	} else {
		g_debug ("desktop_menu.vala:72: Auto-arrange menu: unchecked (manual positioning" \
")");
	}
}

static void
desktop_menu_on_budgie_settings_activated (DesktopMenu* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDesktopAppInfo* _tmp0_;
		GdkDisplay* _tmp1_;
		GdkAppLaunchContext* _tmp2_;
		GdkAppLaunchContext* _tmp3_;
		_tmp0_ = self->priv->budgie_app;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gdk_display_get_app_launch_context (_tmp1_);
		_tmp3_ = _tmp2_;
		g_app_info_launch ((GAppInfo*) _tmp0_, NULL, (GAppLaunchContext*) _tmp3_, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("desktop_menu.vala:80: Failed to launch Budgie Desktop settings: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_menu_popdown ((GtkMenu*) self);
}

static void
desktop_menu_on_system_settings_activated (DesktopMenu* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDesktopAppInfo* _tmp0_;
		GdkDisplay* _tmp1_;
		GdkAppLaunchContext* _tmp2_;
		GdkAppLaunchContext* _tmp3_;
		_tmp0_ = self->priv->bcc_app;
		_tmp1_ = gdk_display_get_default ();
		_tmp2_ = gdk_display_get_app_launch_context (_tmp1_);
		_tmp3_ = _tmp2_;
		g_app_info_launch ((GAppInfo*) _tmp0_, NULL, (GAppLaunchContext*) _tmp3_, &_inner_error0_);
		_g_object_unref0 (_tmp3_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("desktop_menu.vala:90: Failed to launch Budgie Control Center: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	gtk_menu_popdown ((GtkMenu*) self);
}

static void
desktop_menu_class_init (DesktopMenuClass * klass,
                         gpointer klass_data)
{
	desktop_menu_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DesktopMenu_private_offset);
	G_OBJECT_CLASS (klass)->finalize = desktop_menu_finalize;
	desktop_menu_signals[DESKTOP_MENU_TOGGLE_AUTO_ARRANGE_SIGNAL] = g_signal_new ("toggle-auto-arrange", TYPE_DESKTOP_MENU, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
desktop_menu_instance_init (DesktopMenu * self,
                            gpointer klass)
{
	self->priv = desktop_menu_get_instance_private (self);
}

static void
desktop_menu_finalize (GObject * obj)
{
	DesktopMenu * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DESKTOP_MENU, DesktopMenu);
	_g_object_unref0 (self->priv->budgie_app);
	_g_object_unref0 (self->priv->bcc_app);
	_g_object_unref0 (self->priv->desktop_view);
	_g_object_unref0 (self->priv->auto_arrange_item);
	G_OBJECT_CLASS (desktop_menu_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
desktop_menu_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DesktopMenuClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) desktop_menu_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DesktopMenu), 0, (GInstanceInitFunc) desktop_menu_instance_init, NULL };
	GType desktop_menu_type_id;
	desktop_menu_type_id = g_type_register_static (gtk_menu_get_type (), "DesktopMenu", &g_define_type_info, 0);
	DesktopMenu_private_offset = g_type_add_instance_private (desktop_menu_type_id, sizeof (DesktopMenuPrivate));
	return desktop_menu_type_id;
}

GType
desktop_menu_get_type (void)
{
	static volatile gsize desktop_menu_type_id__once = 0;
	if (g_once_init_enter (&desktop_menu_type_id__once)) {
		GType desktop_menu_type_id;
		desktop_menu_type_id = desktop_menu_get_type_once ();
		g_once_init_leave (&desktop_menu_type_id__once, desktop_menu_type_id);
	}
	return desktop_menu_type_id__once;
}

