/* SPDX-License-Identifier: (LGPL-2.1 OR BSD-2-Clause) */

/* THIS FILE IS AUTOGENERATED BY BPFTOOL! */
#ifndef __NUMAMOVE_BPF_SKEL_H__
#define __NUMAMOVE_BPF_SKEL_H__

#include <errno.h>
#include <stdlib.h>
#include <bpf/libbpf.h>

struct numamove_bpf {
	struct bpf_object_skeleton *skeleton;
	struct bpf_object *obj;
	struct {
		struct bpf_map *start;
		struct bpf_map *bss;
	} maps;
	struct {
		struct bpf_program *fentry_migrate_misplaced_page;
		struct bpf_program *fentry_migrate_misplaced_folio;
		struct bpf_program *kprobe_migrate_misplaced_page;
		struct bpf_program *kprobe_migrate_misplaced_folio;
		struct bpf_program *fexit_migrate_misplaced_page_exit;
		struct bpf_program *fexit_migrate_misplaced_folio_exit;
		struct bpf_program *kretprobe_migrate_misplaced_page_exit;
		struct bpf_program *kretprobe_migrate_misplaced_folio_exit;
	} progs;
	struct {
		struct bpf_link *fentry_migrate_misplaced_page;
		struct bpf_link *fentry_migrate_misplaced_folio;
		struct bpf_link *kprobe_migrate_misplaced_page;
		struct bpf_link *kprobe_migrate_misplaced_folio;
		struct bpf_link *fexit_migrate_misplaced_page_exit;
		struct bpf_link *fexit_migrate_misplaced_folio_exit;
		struct bpf_link *kretprobe_migrate_misplaced_page_exit;
		struct bpf_link *kretprobe_migrate_misplaced_folio_exit;
	} links;
	struct numamove_bpf__bss {
		__u64 latency;
		__u64 num;
	} *bss;

#ifdef __cplusplus
	static inline struct numamove_bpf *open(const struct bpf_object_open_opts *opts = nullptr);
	static inline struct numamove_bpf *open_and_load();
	static inline int load(struct numamove_bpf *skel);
	static inline int attach(struct numamove_bpf *skel);
	static inline void detach(struct numamove_bpf *skel);
	static inline void destroy(struct numamove_bpf *skel);
	static inline const void *elf_bytes(size_t *sz);
#endif /* __cplusplus */
};

static void
numamove_bpf__destroy(struct numamove_bpf *obj)
{
	if (!obj)
		return;
	if (obj->skeleton)
		bpf_object__destroy_skeleton(obj->skeleton);
	free(obj);
}

static inline int
numamove_bpf__create_skeleton(struct numamove_bpf *obj);

static inline struct numamove_bpf *
numamove_bpf__open_opts(const struct bpf_object_open_opts *opts)
{
	struct numamove_bpf *obj;
	int err;

	obj = (struct numamove_bpf *)calloc(1, sizeof(*obj));
	if (!obj) {
		errno = ENOMEM;
		return NULL;
	}

	err = numamove_bpf__create_skeleton(obj);
	if (err)
		goto err_out;

	err = bpf_object__open_skeleton(obj->skeleton, opts);
	if (err)
		goto err_out;

	return obj;
err_out:
	numamove_bpf__destroy(obj);
	errno = -err;
	return NULL;
}

static inline struct numamove_bpf *
numamove_bpf__open(void)
{
	return numamove_bpf__open_opts(NULL);
}

static inline int
numamove_bpf__load(struct numamove_bpf *obj)
{
	return bpf_object__load_skeleton(obj->skeleton);
}

static inline struct numamove_bpf *
numamove_bpf__open_and_load(void)
{
	struct numamove_bpf *obj;
	int err;

	obj = numamove_bpf__open();
	if (!obj)
		return NULL;
	err = numamove_bpf__load(obj);
	if (err) {
		numamove_bpf__destroy(obj);
		errno = -err;
		return NULL;
	}
	return obj;
}

static inline int
numamove_bpf__attach(struct numamove_bpf *obj)
{
	return bpf_object__attach_skeleton(obj->skeleton);
}

static inline void
numamove_bpf__detach(struct numamove_bpf *obj)
{
	bpf_object__detach_skeleton(obj->skeleton);
}

static inline const void *numamove_bpf__elf_bytes(size_t *sz);

static inline int
numamove_bpf__create_skeleton(struct numamove_bpf *obj)
{
	struct bpf_object_skeleton *s;
	int err;

	s = (struct bpf_object_skeleton *)calloc(1, sizeof(*s));
	if (!s)	{
		err = -ENOMEM;
		goto err;
	}

	s->sz = sizeof(*s);
	s->name = "numamove_bpf";
	s->obj = &obj->obj;

	/* maps */
	s->map_cnt = 2;
	s->map_skel_sz = sizeof(*s->maps);
	s->maps = (struct bpf_map_skeleton *)calloc(s->map_cnt, s->map_skel_sz);
	if (!s->maps) {
		err = -ENOMEM;
		goto err;
	}

	s->maps[0].name = "start";
	s->maps[0].map = &obj->maps.start;

	s->maps[1].name = "numamove.bss";
	s->maps[1].map = &obj->maps.bss;
	s->maps[1].mmaped = (void **)&obj->bss;

	/* programs */
	s->prog_cnt = 8;
	s->prog_skel_sz = sizeof(*s->progs);
	s->progs = (struct bpf_prog_skeleton *)calloc(s->prog_cnt, s->prog_skel_sz);
	if (!s->progs) {
		err = -ENOMEM;
		goto err;
	}

	s->progs[0].name = "fentry_migrate_misplaced_page";
	s->progs[0].prog = &obj->progs.fentry_migrate_misplaced_page;
	s->progs[0].link = &obj->links.fentry_migrate_misplaced_page;

	s->progs[1].name = "fentry_migrate_misplaced_folio";
	s->progs[1].prog = &obj->progs.fentry_migrate_misplaced_folio;
	s->progs[1].link = &obj->links.fentry_migrate_misplaced_folio;

	s->progs[2].name = "kprobe_migrate_misplaced_page";
	s->progs[2].prog = &obj->progs.kprobe_migrate_misplaced_page;
	s->progs[2].link = &obj->links.kprobe_migrate_misplaced_page;

	s->progs[3].name = "kprobe_migrate_misplaced_folio";
	s->progs[3].prog = &obj->progs.kprobe_migrate_misplaced_folio;
	s->progs[3].link = &obj->links.kprobe_migrate_misplaced_folio;

	s->progs[4].name = "fexit_migrate_misplaced_page_exit";
	s->progs[4].prog = &obj->progs.fexit_migrate_misplaced_page_exit;
	s->progs[4].link = &obj->links.fexit_migrate_misplaced_page_exit;

	s->progs[5].name = "fexit_migrate_misplaced_folio_exit";
	s->progs[5].prog = &obj->progs.fexit_migrate_misplaced_folio_exit;
	s->progs[5].link = &obj->links.fexit_migrate_misplaced_folio_exit;

	s->progs[6].name = "kretprobe_migrate_misplaced_page_exit";
	s->progs[6].prog = &obj->progs.kretprobe_migrate_misplaced_page_exit;
	s->progs[6].link = &obj->links.kretprobe_migrate_misplaced_page_exit;

	s->progs[7].name = "kretprobe_migrate_misplaced_folio_exit";
	s->progs[7].prog = &obj->progs.kretprobe_migrate_misplaced_folio_exit;
	s->progs[7].link = &obj->links.kretprobe_migrate_misplaced_folio_exit;

	s->data = (void *)numamove_bpf__elf_bytes(&s->data_sz);

	obj->skeleton = s;
	return 0;
err:
	bpf_object__destroy_skeleton(s);
	return err;
}

static inline const void *numamove_bpf__elf_bytes(size_t *sz)
{
	*sz = 9800;
	return (const void *)"\
\x7f\x45\x4c\x46\x02\x01\x01\0\0\0\0\0\0\0\0\0\x01\0\xf7\0\x01\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x48\x1f\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\0\0\x40\0\x1c\0\
\x01\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\
\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\
\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\
\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\
\x0e\0\0\0\x63\x0a\xfc\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\
\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\
\0\xf0\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\
\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\
\x0a\xfc\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\
\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\
\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\
\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\0\0\
\0\0\x85\0\0\0\x05\0\0\0\x7b\x0a\xf0\xff\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xfc\xff\xff\xff\xbf\xa3\0\0\0\0\0\0\x07\x03\0\0\xf0\xff\xff\xff\x18\x01\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xb7\x04\0\0\0\0\0\0\x85\0\0\0\x02\0\0\0\xb4\0\0\0\0\0\
\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\0\0\0\0\x85\0\0\0\
\x05\0\0\0\xbf\x06\0\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\
\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x10\0\0\0\0\0\
\x79\x01\0\0\0\0\0\0\x1f\x16\0\0\0\0\0\0\xc5\x06\x08\0\0\0\0\0\x37\x06\0\0\x40\
\x42\x0f\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x61\0\0\x01\0\0\0\xb7\x01\0\
\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xbf\xa2\
\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\
\x63\x0a\xfc\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\xbf\x06\0\0\0\0\0\0\xbf\xa2\0\0\0\
\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\
\0\x01\0\0\0\x15\0\x10\0\0\0\0\0\x79\x01\0\0\0\0\0\0\x1f\x16\0\0\0\0\0\0\xc5\
\x06\x08\0\0\0\0\0\x37\x06\0\0\x40\x42\x0f\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xdb\x61\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\xdb\x12\0\0\x01\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\
\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\0\0\0\0\x85\0\0\0\x05\0\0\0\xbf\
\x06\0\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\0\x10\0\0\0\0\0\x79\x01\0\0\0\0\
\0\0\x1f\x16\0\0\0\0\0\0\xc5\x06\x08\0\0\0\0\0\x37\x06\0\0\x40\x42\x0f\0\x18\
\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x61\0\0\x01\0\0\0\xb7\x01\0\0\x01\0\0\0\
\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\x01\0\0\0\xbf\xa2\0\0\0\0\0\0\
\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x03\
\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x85\0\0\0\x0e\0\0\0\x63\x0a\xfc\xff\
\0\0\0\0\x85\0\0\0\x05\0\0\0\xbf\x06\0\0\0\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\
\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x85\0\0\0\x01\0\0\0\x15\
\0\x10\0\0\0\0\0\x79\x01\0\0\0\0\0\0\x1f\x16\0\0\0\0\0\0\xc5\x06\x08\0\0\0\0\0\
\x37\x06\0\0\x40\x42\x0f\0\x18\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x61\0\0\x01\
\0\0\0\xb7\x01\0\0\x01\0\0\0\x18\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xdb\x12\0\0\
\x01\0\0\0\xbf\xa2\0\0\0\0\0\0\x07\x02\0\0\xfc\xff\xff\xff\x18\x01\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x85\0\0\0\x03\0\0\0\xb4\0\0\0\0\0\0\0\x95\0\0\0\0\0\0\0\x47\
\x50\x4c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x9f\xeb\x01\0\x18\0\0\0\0\0\0\0\xd4\x02\0\0\xd4\x02\0\0\xb9\x05\0\0\0\0\0\
\0\0\0\0\x02\x03\0\0\0\x01\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\x01\0\0\0\0\0\0\0\
\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\x01\0\0\0\x05\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\
\0\0\0\0\0\0\0\0\0\x02\x06\0\0\0\0\0\0\0\0\0\0\x03\0\0\0\0\x02\0\0\0\x04\0\0\0\
\0\x28\0\0\0\0\0\0\0\0\0\x02\x08\0\0\0\x19\0\0\0\0\0\0\x08\x09\0\0\0\x1d\0\0\0\
\0\0\0\x08\x0a\0\0\0\x23\0\0\0\0\0\0\x01\x04\0\0\0\x20\0\0\0\0\0\0\0\0\0\0\x02\
\x0c\0\0\0\x30\0\0\0\0\0\0\x08\x0d\0\0\0\x34\0\0\0\0\0\0\x08\x0e\0\0\0\x3a\0\0\
\0\0\0\0\x01\x08\0\0\0\x40\0\0\0\0\0\0\0\x04\0\0\x04\x20\0\0\0\x4d\0\0\0\x01\0\
\0\0\0\0\0\0\x52\0\0\0\x05\0\0\0\x40\0\0\0\x5e\0\0\0\x07\0\0\0\x80\0\0\0\x62\0\
\0\0\x0b\0\0\0\xc0\0\0\0\x68\0\0\0\0\0\0\x0e\x0f\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\
\x02\x0e\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\0\0\0\x11\0\0\0\x72\0\0\0\x01\
\0\0\x0c\x12\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\0\0\0\x11\0\0\0\x7a\x01\0\
\0\x01\0\0\x0c\x14\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\0\0\0\x11\0\0\0\xe5\
\x01\0\0\x01\0\0\x0c\x16\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\0\0\0\x11\0\0\
\0\x4d\x02\0\0\x01\0\0\x0c\x18\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\0\0\0\
\x11\0\0\0\xb8\x02\0\0\x01\0\0\x0c\x1a\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\0\x6e\
\0\0\0\x11\0\0\0\x22\x04\0\0\x01\0\0\x0c\x1c\0\0\0\0\0\0\0\x01\0\0\x0d\x02\0\0\
\0\x6e\0\0\0\x11\0\0\0\x94\x04\0\0\x01\0\0\x0c\x1e\0\0\0\0\0\0\0\x01\0\0\x0d\
\x02\0\0\0\x6e\0\0\0\x11\0\0\0\x0f\x05\0\0\x01\0\0\x0c\x20\0\0\0\x8d\x05\0\0\0\
\0\0\x0e\x0d\0\0\0\x01\0\0\0\x95\x05\0\0\0\0\0\x0e\x0d\0\0\0\x01\0\0\0\x99\x05\
\0\0\0\0\0\x01\x01\0\0\0\x08\0\0\x01\0\0\0\0\0\0\0\x03\0\0\0\0\x24\0\0\0\x04\0\
\0\0\x04\0\0\0\x9e\x05\0\0\0\0\0\x0e\x25\0\0\0\x01\0\0\0\xa6\x05\0\0\x02\0\0\
\x0f\0\0\0\0\x22\0\0\0\0\0\0\0\x08\0\0\0\x23\0\0\0\0\0\0\0\x08\0\0\0\xab\x05\0\
\0\x01\0\0\x0f\0\0\0\0\x10\0\0\0\0\0\0\0\x20\0\0\0\xb1\x05\0\0\x01\0\0\x0f\0\0\
\0\0\x26\0\0\0\0\0\0\0\x04\0\0\0\0\x69\x6e\x74\0\x5f\x5f\x41\x52\x52\x41\x59\
\x5f\x53\x49\x5a\x45\x5f\x54\x59\x50\x45\x5f\x5f\0\x75\x33\x32\0\x5f\x5f\x75\
\x33\x32\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x69\x6e\x74\0\x75\x36\x34\0\x5f\
\x5f\x75\x36\x34\0\x75\x6e\x73\x69\x67\x6e\x65\x64\x20\x6c\x6f\x6e\x67\x20\x6c\
\x6f\x6e\x67\0\x74\x79\x70\x65\0\x6d\x61\x78\x5f\x65\x6e\x74\x72\x69\x65\x73\0\
\x6b\x65\x79\0\x76\x61\x6c\x75\x65\0\x73\x74\x61\x72\x74\0\x63\x74\x78\0\x66\
\x65\x6e\x74\x72\x79\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\
\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x66\x65\x6e\x74\x72\x79\x2f\x6d\x69\x67\
\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\
\x2f\x62\x75\x69\x6c\x64\x2f\x62\x63\x63\x2f\x73\x72\x63\x2f\x62\x63\x63\x2f\
\x6c\x69\x62\x62\x70\x66\x2d\x74\x6f\x6f\x6c\x73\x2f\x6e\x75\x6d\x61\x6d\x6f\
\x76\x65\x2e\x62\x70\x66\x2e\x63\0\x09\x75\x33\x32\x20\x70\x69\x64\x20\x3d\x20\
\x62\x70\x66\x5f\x67\x65\x74\x5f\x63\x75\x72\x72\x65\x6e\x74\x5f\x70\x69\x64\
\x5f\x74\x67\x69\x64\x28\x29\x3b\0\x09\x75\x36\x34\x20\x74\x73\x20\x3d\x20\x62\
\x70\x66\x5f\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\
\x62\x70\x66\x5f\x6d\x61\x70\x5f\x75\x70\x64\x61\x74\x65\x5f\x65\x6c\x65\x6d\
\x28\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x2c\x20\x26\x74\x73\x2c\
\x20\x30\x29\x3b\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\
\x6e\x74\x72\x79\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\
\x63\x65\x64\x5f\x70\x61\x67\x65\x29\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x69\x67\
\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\
\x6f\0\x66\x65\x6e\x74\x72\x79\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\
\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x69\x6e\x74\x20\x42\x50\x46\
\x5f\x50\x52\x4f\x47\x28\x66\x65\x6e\x74\x72\x79\x5f\x6d\x69\x67\x72\x61\x74\
\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\x29\0\x6b\
\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\
\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x6b\x70\x72\x6f\x62\x65\x2f\x6d\x69\x67\
\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\
\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x6b\x70\x72\x6f\x62\x65\
\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\
\x70\x61\x67\x65\x29\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\
\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x6b\x70\x72\
\x6f\x62\x65\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\
\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\
\x47\x28\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\
\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\x29\0\x66\x65\x78\x69\x74\
\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\
\x70\x61\x67\x65\x5f\x65\x78\x69\x74\0\x66\x65\x78\x69\x74\x2f\x6d\x69\x67\x72\
\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x09\
\x75\x36\x34\x20\x2a\x74\x73\x70\x2c\x20\x74\x73\x20\x3d\x20\x62\x70\x66\x5f\
\x6b\x74\x69\x6d\x65\x5f\x67\x65\x74\x5f\x6e\x73\x28\x29\x3b\0\x09\x74\x73\x70\
\x20\x3d\x20\x62\x70\x66\x5f\x6d\x61\x70\x5f\x6c\x6f\x6f\x6b\x75\x70\x5f\x65\
\x6c\x65\x6d\x28\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x29\x3b\0\x09\
\x69\x66\x20\x28\x21\x74\x73\x70\x29\0\x09\x64\x65\x6c\x74\x61\x20\x3d\x20\x28\
\x73\x36\x34\x29\x28\x74\x73\x20\x2d\x20\x2a\x74\x73\x70\x29\x3b\0\x09\x69\x66\
\x20\x28\x64\x65\x6c\x74\x61\x20\x3c\x20\x30\x29\0\x09\x5f\x5f\x73\x79\x6e\x63\
\x5f\x66\x65\x74\x63\x68\x5f\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x6c\x61\x74\
\x65\x6e\x63\x79\x2c\x20\x64\x65\x6c\x74\x61\x20\x2f\x20\x31\x30\x30\x30\x30\
\x30\x30\x55\x29\x3b\0\x09\x5f\x5f\x73\x79\x6e\x63\x5f\x66\x65\x74\x63\x68\x5f\
\x61\x6e\x64\x5f\x61\x64\x64\x28\x26\x6e\x75\x6d\x2c\x20\x31\x29\x3b\0\x09\x62\
\x70\x66\x5f\x6d\x61\x70\x5f\x64\x65\x6c\x65\x74\x65\x5f\x65\x6c\x65\x6d\x28\
\x26\x73\x74\x61\x72\x74\x2c\x20\x26\x70\x69\x64\x29\x3b\0\x69\x6e\x74\x20\x42\
\x50\x46\x5f\x50\x52\x4f\x47\x28\x66\x65\x78\x69\x74\x5f\x6d\x69\x67\x72\x61\
\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\x5f\x65\
\x78\x69\x74\x29\0\x66\x65\x78\x69\x74\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\
\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\x5f\x65\x78\x69\x74\0\
\x66\x65\x78\x69\x74\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\
\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\
\x52\x4f\x47\x28\x66\x65\x78\x69\x74\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\
\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\x5f\x65\x78\x69\x74\
\x29\0\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\
\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\x5f\x65\x78\x69\x74\0\
\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\
\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x69\x6e\x74\x20\x42\x50\
\x46\x5f\x50\x52\x4f\x47\x28\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x5f\x6d\x69\
\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\
\x65\x5f\x65\x78\x69\x74\x29\0\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x5f\x6d\x69\
\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\
\x69\x6f\x5f\x65\x78\x69\x74\0\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x2f\x6d\x69\
\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\
\x69\x6f\0\x69\x6e\x74\x20\x42\x50\x46\x5f\x50\x52\x4f\x47\x28\x6b\x72\x65\x74\
\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\
\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\x5f\x65\x78\x69\x74\x29\0\x6c\x61\x74\
\x65\x6e\x63\x79\0\x6e\x75\x6d\0\x63\x68\x61\x72\0\x4c\x49\x43\x45\x4e\x53\x45\
\0\x2e\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x6c\x69\x63\x65\x6e\x73\x65\0\0\0\0\
\x9f\xeb\x01\0\x20\0\0\0\0\0\0\0\x84\0\0\0\x84\0\0\0\x04\x05\0\0\x88\x05\0\0\0\
\0\0\0\x08\0\0\0\x90\0\0\0\x01\0\0\0\0\0\0\0\x13\0\0\0\x99\x01\0\0\x01\0\0\0\0\
\0\0\0\x15\0\0\0\x03\x02\0\0\x01\0\0\0\0\0\0\0\x17\0\0\0\x6c\x02\0\0\x01\0\0\0\
\0\0\0\0\x19\0\0\0\xda\x02\0\0\x01\0\0\0\0\0\0\0\x1b\0\0\0\x45\x04\0\0\x01\0\0\
\0\0\0\0\0\x1d\0\0\0\xba\x04\0\0\x01\0\0\0\0\0\0\0\x1f\0\0\0\x36\x05\0\0\x01\0\
\0\0\0\0\0\0\x21\0\0\0\x10\0\0\0\x90\0\0\0\x06\0\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\
\0\x0c\x4c\0\0\x08\0\0\0\xae\0\0\0\xdd\0\0\0\x06\x4c\0\0\x10\0\0\0\xae\0\0\0\
\x04\x01\0\0\x0b\x50\0\0\x18\0\0\0\xae\0\0\0\x04\x01\0\0\x06\x50\0\0\x40\0\0\0\
\xae\0\0\0\x22\x01\0\0\x02\x58\0\0\x60\0\0\0\xae\0\0\0\x4e\x01\0\0\x05\x6c\0\0\
\x99\x01\0\0\x06\0\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\0\x0c\x4c\0\0\x08\0\0\0\xae\0\
\0\0\xdd\0\0\0\x06\x4c\0\0\x10\0\0\0\xae\0\0\0\x04\x01\0\0\x0b\x50\0\0\x18\0\0\
\0\xae\0\0\0\x04\x01\0\0\x06\x50\0\0\x40\0\0\0\xae\0\0\0\x22\x01\0\0\x02\x58\0\
\0\x60\0\0\0\xae\0\0\0\xb8\x01\0\0\x05\x84\0\0\x03\x02\0\0\x06\0\0\0\0\0\0\0\
\xae\0\0\0\xdd\0\0\0\x0c\x4c\0\0\x08\0\0\0\xae\0\0\0\xdd\0\0\0\x06\x4c\0\0\x10\
\0\0\0\xae\0\0\0\x04\x01\0\0\x0b\x50\0\0\x18\0\0\0\xae\0\0\0\x04\x01\0\0\x06\
\x50\0\0\x40\0\0\0\xae\0\0\0\x22\x01\0\0\x02\x58\0\0\x60\0\0\0\xae\0\0\0\x21\
\x02\0\0\x05\x9c\0\0\x6c\x02\0\0\x06\0\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\0\x0c\x4c\
\0\0\x08\0\0\0\xae\0\0\0\xdd\0\0\0\x06\x4c\0\0\x10\0\0\0\xae\0\0\0\x04\x01\0\0\
\x0b\x50\0\0\x18\0\0\0\xae\0\0\0\x04\x01\0\0\x06\x50\0\0\x40\0\0\0\xae\0\0\0\
\x22\x01\0\0\x02\x58\0\0\x60\0\0\0\xae\0\0\0\x8b\x02\0\0\x05\xb4\0\0\xda\x02\0\
\0\x0d\0\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\0\x0c\xd0\0\0\x08\0\0\0\xae\0\0\0\xdd\0\
\0\0\x06\xd0\0\0\x10\0\0\0\xae\0\0\0\xf7\x02\0\0\x11\xd4\0\0\x30\0\0\0\xae\0\0\
\0\x1b\x03\0\0\x08\xe0\0\0\x48\0\0\0\xae\0\0\0\x45\x03\0\0\x06\xe4\0\0\x50\0\0\
\0\xae\0\0\0\x50\x03\0\0\x15\xec\0\0\x58\0\0\0\xae\0\0\0\x50\x03\0\0\x13\xec\0\
\0\x60\0\0\0\xae\0\0\0\x6b\x03\0\0\x0c\xf0\0\0\x68\0\0\0\xae\0\0\0\x7b\x03\0\0\
\x27\xf8\0\0\x70\0\0\0\xae\0\0\0\x7b\x03\0\0\x02\xf8\0\0\x90\0\0\0\xae\0\0\0\
\xae\x03\0\0\x02\xfc\0\0\xb8\0\0\0\xae\0\0\0\xce\x03\0\0\x02\x08\x01\0\xd0\0\0\
\0\xae\0\0\0\xf2\x03\0\0\x05\x1c\x01\0\x45\x04\0\0\x0d\0\0\0\0\0\0\0\xae\0\0\0\
\xdd\0\0\0\x0c\xd0\0\0\x08\0\0\0\xae\0\0\0\xdd\0\0\0\x06\xd0\0\0\x10\0\0\0\xae\
\0\0\0\xf7\x02\0\0\x11\xd4\0\0\x30\0\0\0\xae\0\0\0\x1b\x03\0\0\x08\xe0\0\0\x48\
\0\0\0\xae\0\0\0\x45\x03\0\0\x06\xe4\0\0\x50\0\0\0\xae\0\0\0\x50\x03\0\0\x15\
\xec\0\0\x58\0\0\0\xae\0\0\0\x50\x03\0\0\x13\xec\0\0\x60\0\0\0\xae\0\0\0\x6b\
\x03\0\0\x0c\xf0\0\0\x68\0\0\0\xae\0\0\0\x7b\x03\0\0\x27\xf8\0\0\x70\0\0\0\xae\
\0\0\0\x7b\x03\0\0\x02\xf8\0\0\x90\0\0\0\xae\0\0\0\xae\x03\0\0\x02\xfc\0\0\xb8\
\0\0\0\xae\0\0\0\xce\x03\0\0\x02\x08\x01\0\xd0\0\0\0\xae\0\0\0\x63\x04\0\0\x05\
\x34\x01\0\xba\x04\0\0\x0d\0\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\0\x0c\xd0\0\0\x08\0\
\0\0\xae\0\0\0\xdd\0\0\0\x06\xd0\0\0\x10\0\0\0\xae\0\0\0\xf7\x02\0\0\x11\xd4\0\
\0\x30\0\0\0\xae\0\0\0\x1b\x03\0\0\x08\xe0\0\0\x48\0\0\0\xae\0\0\0\x45\x03\0\0\
\x06\xe4\0\0\x50\0\0\0\xae\0\0\0\x50\x03\0\0\x15\xec\0\0\x58\0\0\0\xae\0\0\0\
\x50\x03\0\0\x13\xec\0\0\x60\0\0\0\xae\0\0\0\x6b\x03\0\0\x0c\xf0\0\0\x68\0\0\0\
\xae\0\0\0\x7b\x03\0\0\x27\xf8\0\0\x70\0\0\0\xae\0\0\0\x7b\x03\0\0\x02\xf8\0\0\
\x90\0\0\0\xae\0\0\0\xae\x03\0\0\x02\xfc\0\0\xb8\0\0\0\xae\0\0\0\xce\x03\0\0\
\x02\x08\x01\0\xd0\0\0\0\xae\0\0\0\xdb\x04\0\0\x05\x4c\x01\0\x36\x05\0\0\x0d\0\
\0\0\0\0\0\0\xae\0\0\0\xdd\0\0\0\x0c\xd0\0\0\x08\0\0\0\xae\0\0\0\xdd\0\0\0\x06\
\xd0\0\0\x10\0\0\0\xae\0\0\0\xf7\x02\0\0\x11\xd4\0\0\x30\0\0\0\xae\0\0\0\x1b\
\x03\0\0\x08\xe0\0\0\x48\0\0\0\xae\0\0\0\x45\x03\0\0\x06\xe4\0\0\x50\0\0\0\xae\
\0\0\0\x50\x03\0\0\x15\xec\0\0\x58\0\0\0\xae\0\0\0\x50\x03\0\0\x13\xec\0\0\x60\
\0\0\0\xae\0\0\0\x6b\x03\0\0\x0c\xf0\0\0\x68\0\0\0\xae\0\0\0\x7b\x03\0\0\x27\
\xf8\0\0\x70\0\0\0\xae\0\0\0\x7b\x03\0\0\x02\xf8\0\0\x90\0\0\0\xae\0\0\0\xae\
\x03\0\0\x02\xfc\0\0\xb8\0\0\0\xae\0\0\0\xce\x03\0\0\x02\x08\x01\0\xd0\0\0\0\
\xae\0\0\0\x58\x05\0\0\x05\x64\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x05\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x07\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x09\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0b\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x0d\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x03\0\x0f\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x03\0\x11\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa5\x01\0\0\x12\0\x03\0\0\0\0\0\0\0\0\0\x70\0\
\0\0\0\0\0\0\x1c\0\0\0\x11\0\x15\0\0\0\0\0\0\0\0\0\x20\0\0\0\0\0\0\0\xbf\0\0\0\
\x12\0\x05\0\0\0\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\xc3\x01\0\0\x12\0\x07\0\0\0\0\0\
\0\0\0\0\x70\0\0\0\0\0\0\0\xde\0\0\0\x12\0\x09\0\0\0\0\0\0\0\0\0\x70\0\0\0\0\0\
\0\0\x6c\0\0\0\x12\0\x0b\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x01\0\0\0\x11\0\
\x13\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\x8b\x01\0\0\x11\0\x13\0\x08\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\x22\0\0\0\x12\0\x0d\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\
\x8e\0\0\0\x12\0\x0f\0\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x45\0\0\0\x12\0\x11\0\
\0\0\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\x84\x02\0\0\x11\0\x14\0\0\0\0\0\0\0\0\0\x04\
\0\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\
\0\x0a\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x40\0\0\0\0\0\0\0\x01\0\0\0\
\x0a\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x70\0\0\0\0\0\0\0\x01\0\0\0\
\x0f\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\xb8\0\0\0\0\0\0\0\x01\0\0\0\
\x0a\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x70\0\0\0\0\0\0\0\x01\0\0\0\
\x0f\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\xb8\0\0\0\0\0\0\0\x01\0\0\0\
\x0a\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x70\0\0\0\0\0\0\0\x01\0\0\0\
\x0f\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\xb8\0\0\0\0\0\0\0\x01\0\0\0\
\x0a\0\0\0\x30\0\0\0\0\0\0\0\x01\0\0\0\x0a\0\0\0\x70\0\0\0\0\0\0\0\x01\0\0\0\
\x0f\0\0\0\x90\0\0\0\0\0\0\0\x01\0\0\0\x10\0\0\0\xb8\0\0\0\0\0\0\0\x01\0\0\0\
\x0a\0\0\0\xa8\x02\0\0\0\0\0\0\x04\0\0\0\x0f\0\0\0\xb4\x02\0\0\0\0\0\0\x04\0\0\
\0\x10\0\0\0\xcc\x02\0\0\0\0\0\0\x04\0\0\0\x0a\0\0\0\xe4\x02\0\0\0\0\0\0\x04\0\
\0\0\x14\0\0\0\x2c\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\x3c\0\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x4c\0\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x5c\0\0\0\0\0\0\0\x04\0\0\0\
\x04\0\0\0\x6c\0\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x7c\0\0\0\0\0\0\0\x04\0\0\0\
\x06\0\0\0\x8c\0\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x9c\0\0\0\0\0\0\0\x04\0\0\0\
\x08\0\0\0\xb0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xc0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xd0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\xe0\0\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\xf0\0\0\0\0\0\0\0\x04\0\0\0\x01\0\0\0\0\x01\0\0\0\0\0\0\x04\0\0\0\
\x01\0\0\0\x18\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x28\x01\0\0\0\0\0\0\x04\0\0\
\0\x02\0\0\0\x38\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x48\x01\0\0\0\0\0\0\x04\0\
\0\0\x02\0\0\0\x58\x01\0\0\0\0\0\0\x04\0\0\0\x02\0\0\0\x68\x01\0\0\0\0\0\0\x04\
\0\0\0\x02\0\0\0\x80\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\x90\x01\0\0\0\0\0\0\
\x04\0\0\0\x03\0\0\0\xa0\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xb0\x01\0\0\0\0\0\
\0\x04\0\0\0\x03\0\0\0\xc0\x01\0\0\0\0\0\0\x04\0\0\0\x03\0\0\0\xd0\x01\0\0\0\0\
\0\0\x04\0\0\0\x03\0\0\0\xe8\x01\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\xf8\x01\0\0\0\
\0\0\0\x04\0\0\0\x04\0\0\0\x08\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x18\x02\0\0\
\0\0\0\0\x04\0\0\0\x04\0\0\0\x28\x02\0\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x38\x02\0\
\0\0\0\0\0\x04\0\0\0\x04\0\0\0\x50\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x60\x02\
\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x70\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x80\
\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x90\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\
\xa0\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xb0\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\
\0\xc0\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xd0\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\
\0\0\xe0\x02\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\xf0\x02\0\0\0\0\0\0\x04\0\0\0\x05\
\0\0\0\0\x03\0\0\0\0\0\0\x04\0\0\0\x05\0\0\0\x10\x03\0\0\0\0\0\0\x04\0\0\0\x05\
\0\0\0\x28\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x38\x03\0\0\0\0\0\0\x04\0\0\0\
\x06\0\0\0\x48\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x58\x03\0\0\0\0\0\0\x04\0\0\
\0\x06\0\0\0\x68\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x78\x03\0\0\0\0\0\0\x04\0\
\0\0\x06\0\0\0\x88\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\x98\x03\0\0\0\0\0\0\x04\
\0\0\0\x06\0\0\0\xa8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xb8\x03\0\0\0\0\0\0\
\x04\0\0\0\x06\0\0\0\xc8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\xd8\x03\0\0\0\0\0\
\0\x04\0\0\0\x06\0\0\0\xe8\x03\0\0\0\0\0\0\x04\0\0\0\x06\0\0\0\0\x04\0\0\0\0\0\
\0\x04\0\0\0\x07\0\0\0\x10\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x20\x04\0\0\0\0\
\0\0\x04\0\0\0\x07\0\0\0\x30\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x40\x04\0\0\0\
\0\0\0\x04\0\0\0\x07\0\0\0\x50\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x60\x04\0\0\
\0\0\0\0\x04\0\0\0\x07\0\0\0\x70\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x80\x04\0\
\0\0\0\0\0\x04\0\0\0\x07\0\0\0\x90\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xa0\x04\
\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xb0\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xc0\
\x04\0\0\0\0\0\0\x04\0\0\0\x07\0\0\0\xd8\x04\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\
\xe8\x04\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\xf8\x04\0\0\0\0\0\0\x04\0\0\0\x08\0\0\
\0\x08\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x18\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\
\0\0\x28\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x38\x05\0\0\0\0\0\0\x04\0\0\0\x08\
\0\0\0\x48\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x58\x05\0\0\0\0\0\0\x04\0\0\0\
\x08\0\0\0\x68\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x78\x05\0\0\0\0\0\0\x04\0\0\
\0\x08\0\0\0\x88\x05\0\0\0\0\0\0\x04\0\0\0\x08\0\0\0\x98\x05\0\0\0\0\0\0\x04\0\
\0\0\x08\0\0\0\x13\x15\x16\x17\x18\x1b\x1c\x1d\x19\x1a\x1e\x14\0\x6c\x61\x74\
\x65\x6e\x63\x79\0\x2e\x74\x65\x78\x74\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\x2e\
\x65\x78\x74\0\x73\x74\x61\x72\x74\0\x66\x65\x78\x69\x74\x5f\x6d\x69\x67\x72\
\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\
\x5f\x65\x78\x69\x74\0\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\
\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\
\x5f\x65\x78\x69\x74\0\x66\x65\x78\x69\x74\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\
\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\x5f\x65\x78\x69\x74\0\
\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\
\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\x5f\x65\x78\x69\x74\0\x2e\
\x62\x73\x73\0\x2e\x6d\x61\x70\x73\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x69\x67\
\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\
\x6f\0\x6b\x70\x72\x6f\x62\x65\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\
\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x2e\x72\x65\x6c\x66\x65\x6e\
\x74\x72\x79\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\
\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x2e\x72\x65\x6c\x66\x65\x78\x69\x74\x2f\x6d\
\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\
\x6c\x69\x6f\0\x2e\x72\x65\x6c\x6b\x72\x65\x74\x70\x72\x6f\x62\x65\x2f\x6d\x69\
\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\
\x69\x6f\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\x65\x2f\x6d\x69\x67\x72\x61\x74\
\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x66\x6f\x6c\x69\x6f\0\x6e\x75\
\x6d\0\x2e\x6c\x6c\x76\x6d\x5f\x61\x64\x64\x72\x73\x69\x67\0\x6c\x69\x63\x65\
\x6e\x73\x65\0\x66\x65\x6e\x74\x72\x79\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\
\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x6b\x70\x72\x6f\x62\x65\
\x5f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\
\x70\x61\x67\x65\0\x2e\x72\x65\x6c\x66\x65\x6e\x74\x72\x79\x2f\x6d\x69\x67\x72\
\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x2e\
\x72\x65\x6c\x66\x65\x78\x69\x74\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\
\x73\x70\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x2e\x72\x65\x6c\x6b\x72\x65\
\x74\x70\x72\x6f\x62\x65\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\
\x6c\x61\x63\x65\x64\x5f\x70\x61\x67\x65\0\x2e\x72\x65\x6c\x6b\x70\x72\x6f\x62\
\x65\x2f\x6d\x69\x67\x72\x61\x74\x65\x5f\x6d\x69\x73\x70\x6c\x61\x63\x65\x64\
\x5f\x70\x61\x67\x65\0\x2e\x73\x74\x72\x74\x61\x62\0\x2e\x73\x79\x6d\x74\x61\
\x62\0\x2e\x72\x65\x6c\x2e\x42\x54\x46\0\x4c\x49\x43\x45\x4e\x53\x45\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x6b\x02\0\0\x03\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\xbc\x1c\0\0\0\0\0\0\x8c\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x09\0\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xe5\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x40\0\0\0\
\0\0\0\0\x70\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xe1\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xf0\x15\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x1b\0\0\0\x03\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x01\
\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\0\0\0\0\0\0\0\x70\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xfd\0\0\0\x09\0\0\
\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1b\0\
\0\0\x05\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x4d\x02\0\0\x01\0\0\0\x06\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x01\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x49\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x10\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1b\0\0\0\x07\0\0\0\x08\
\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x6c\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\x90\x01\0\0\0\0\0\0\x70\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\x68\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x20\x16\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x1b\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\
\x10\0\0\0\0\0\0\0\x07\x02\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x02\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\0\x03\x02\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x30\x16\0\0\0\0\
\0\0\x40\0\0\0\0\0\0\0\x1b\0\0\0\x0b\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\
\x24\x01\0\0\x01\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xe0\x02\0\0\0\0\0\0\
\xe0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x20\x01\0\
\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x70\x16\0\0\0\0\0\0\x40\0\0\0\0\
\0\0\0\x1b\0\0\0\x0d\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x28\x02\0\0\x01\
\0\0\0\x06\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xc0\x03\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x24\x02\0\0\x09\0\0\0\x40\0\
\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xb0\x16\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x1b\0\0\0\
\x0f\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x46\x01\0\0\x01\0\0\0\x06\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\xa0\x04\0\0\0\0\0\0\xe0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x42\x01\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\xf0\x16\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x1b\0\0\0\x11\0\0\0\x08\0\0\
\0\0\0\0\0\x10\0\0\0\0\0\0\0\xb4\0\0\0\x08\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\0\x80\x05\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\x9d\x01\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x80\x05\
\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\xb9\0\0\0\x01\0\0\0\x03\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x88\x05\0\0\0\0\0\0\
\x20\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x08\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7f\x02\0\
\0\x01\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\xa8\x05\0\0\0\0\0\0\xa5\x08\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x7b\x02\0\0\x09\0\0\0\
\x40\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x30\x17\0\0\0\0\0\0\x40\0\0\0\0\0\0\0\x1b\0\
\0\0\x16\0\0\0\x08\0\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x13\0\0\0\x01\0\0\0\0\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x50\x0e\0\0\0\0\0\0\xa8\x05\0\0\0\0\0\0\0\0\0\0\0\0\0\
\0\x04\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x0f\0\0\0\x09\0\0\0\x40\0\0\0\0\0\0\0\0\0\
\0\0\0\0\0\0\x70\x17\0\0\0\0\0\0\x40\x05\0\0\0\0\0\0\x1b\0\0\0\x18\0\0\0\x08\0\
\0\0\0\0\0\0\x10\0\0\0\0\0\0\0\x8f\x01\0\0\x03\x4c\xff\x6f\0\0\0\x80\0\0\0\0\0\
\0\0\0\0\0\0\0\xb0\x1c\0\0\0\0\0\0\x0c\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\x01\0\0\0\
\0\0\0\0\0\0\0\0\0\0\0\0\x73\x02\0\0\x02\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\
\xf8\x13\0\0\0\0\0\0\xf8\x01\0\0\0\0\0\0\x01\0\0\0\x09\0\0\0\x08\0\0\0\0\0\0\0\
\x18\0\0\0\0\0\0\0";
}

#ifdef __cplusplus
struct numamove_bpf *numamove_bpf::open(const struct bpf_object_open_opts *opts) { return numamove_bpf__open_opts(opts); }
struct numamove_bpf *numamove_bpf::open_and_load() { return numamove_bpf__open_and_load(); }
int numamove_bpf::load(struct numamove_bpf *skel) { return numamove_bpf__load(skel); }
int numamove_bpf::attach(struct numamove_bpf *skel) { return numamove_bpf__attach(skel); }
void numamove_bpf::detach(struct numamove_bpf *skel) { numamove_bpf__detach(skel); }
void numamove_bpf::destroy(struct numamove_bpf *skel) { numamove_bpf__destroy(skel); }
const void *numamove_bpf::elf_bytes(size_t *sz) { return numamove_bpf__elf_bytes(sz); }
#endif /* __cplusplus */

__attribute__((unused)) static void
numamove_bpf__assert(struct numamove_bpf *s __attribute__((unused)))
{
#ifdef __cplusplus
#define _Static_assert static_assert
#endif
	_Static_assert(sizeof(s->bss->latency) == 8, "unexpected size of 'latency'");
	_Static_assert(sizeof(s->bss->num) == 8, "unexpected size of 'num'");
#ifdef __cplusplus
#undef _Static_assert
#endif
}

#endif /* __NUMAMOVE_BPF_SKEL_H__ */
