/* baobab-cellrenderers.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from baobab-cellrenderers.vala, do not modify */

/* -*- tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* Baobab - disk usage analyzer
 *
 * Copyright (C) 2012  Ryan Lortie <desrt@desrt.ca>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include "baobab.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

gchar*
baobab_format_items (gint items)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf (ngettext ("%d item", "%d items", (gulong) items), items);
	result = _tmp0_;
	return result;
}

gchar*
baobab_format_time_approximate (guint64 time)
{
	GDateTime* dt = NULL;
	GDateTime* _tmp1_;
	GDateTime* now = NULL;
	GDateTime* _tmp2_;
	GTimeSpan ts = 0LL;
	GDateTime* _tmp3_;
	GDateTime* _tmp4_;
	gulong years = 0UL;
	gchar* _tmp8_;
	gchar* result;
	if (time == ((guint64) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (_ ("Unknown"));
		result = _tmp0_;
		return result;
	}
	_tmp1_ = g_date_time_new_from_unix_local ((gint64) time);
	dt = _tmp1_;
	_tmp2_ = g_date_time_new_now_local ();
	now = _tmp2_;
	_tmp3_ = now;
	_tmp4_ = dt;
	ts = g_date_time_difference (_tmp3_, _tmp4_);
	if (ts < G_TIME_SPAN_DAY) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (_ ("Today"));
		result = _tmp5_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	if (ts < (31 * G_TIME_SPAN_DAY)) {
		gulong days = 0UL;
		gchar* _tmp6_;
		days = (gulong) (ts / G_TIME_SPAN_DAY);
		_tmp6_ = g_strdup_printf (ngettext ("%lu day", "%lu days", days), days);
		result = _tmp6_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	if (ts < (365 * G_TIME_SPAN_DAY)) {
		gulong months = 0UL;
		gchar* _tmp7_;
		months = (gulong) (ts / (31 * G_TIME_SPAN_DAY));
		_tmp7_ = g_strdup_printf (ngettext ("%lu month", "%lu months", months), months);
		result = _tmp7_;
		_g_date_time_unref0 (now);
		_g_date_time_unref0 (dt);
		return result;
	}
	years = (gulong) (ts / (365 * G_TIME_SPAN_DAY));
	_tmp8_ = g_strdup_printf (ngettext ("%lu year", "%lu years", years), years);
	result = _tmp8_;
	_g_date_time_unref0 (now);
	_g_date_time_unref0 (dt);
	return result;
}

