/* Generated automatically by the program `genextract'
   from the machine description file `md'.  */

#define IN_TARGET_CODE 1
#include "config.h"
#include "system.h"
#include "coretypes.h"
#include "tm.h"
#include "rtl.h"
#include "insn-config.h"
#include "recog.h"
#include "diagnostic-core.h"

/* This variable is used as the "location" of any missing operand
   whose numbers are skipped by a given pattern.  */
static rtx junk ATTRIBUTE_UNUSED;

void
insn_extract (rtx_insn *insn)
{
  rtx *ro = recog_data.operand;
  rtx **ro_loc = recog_data.operand_loc;
  rtx pat = PATTERN (insn);
  int i ATTRIBUTE_UNUSED; /* only for peepholes */

  if (flag_checking)
    {
      memset (ro, 0xab, sizeof (*ro) * MAX_RECOG_OPERANDS);
      memset (ro_loc, 0xab, sizeof (*ro_loc) * MAX_RECOG_OPERANDS);
    }

  switch (INSN_CODE (insn))
    {
    default:
      /* Control reaches here if insn_extract has been called with an
         unrecognizable insn (code -1), or an insn whose INSN_CODE
         corresponds to a DEFINE_EXPAND in the machine description;
         either way, a bug.  */
      if (INSN_CODE (insn) < 0)
        fatal_insn ("unrecognizable insn:", insn);
      else
        fatal_insn ("insn with invalid code number:", insn);

    case 3518:
    case 3517:
    case 3516:
    case 3515:
    case 3514:
    case 3513:
    case 3512:
    case 3511:
    case 3510:
    case 3509:
    case 3508:
    case 3507:
    case 3506:
    case 3505:
    case 3504:
    case 3503:
      for (i = XVECLEN (pat, 0) - 1; i >= 0; i--)
          ro[i] = *(ro_loc[i] = &XVECEXP (pat, 0, i));
      break;

    case 3303:  /* compare_const_uta2 */
    case 3302:  /* compare_const_ta2 */
    case 3301:  /* compare_const_uda2 */
    case 3300:  /* compare_const_da2 */
    case 3299:  /* compare_const_udq2 */
    case 3298:  /* compare_const_dq2 */
    case 3297:  /* compare_const_di2 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 3296:  /* cbranch_const_uta2_split */
    case 3295:  /* cbranch_const_ta2_split */
    case 3294:  /* cbranch_const_uda2_split */
    case 3293:  /* cbranch_const_da2_split */
    case 3292:  /* cbranch_const_udq2_split */
    case 3291:  /* cbranch_const_dq2_split */
    case 3290:  /* cbranch_const_di2_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 3271:  /* *ussubuta3_const_insn */
    case 3270:  /* *usadduta3_const_insn */
    case 3269:  /* *ussubuda3_const_insn */
    case 3268:  /* *usadduda3_const_insn */
    case 3267:  /* *ussubudq3_const_insn */
    case 3266:  /* *usaddudq3_const_insn */
    case 3247:  /* *sssubta3_const_insn */
    case 3246:  /* *ssaddta3_const_insn */
    case 3245:  /* *sssubda3_const_insn */
    case 3244:  /* *ssaddda3_const_insn */
    case 3243:  /* *sssubdq3_const_insn */
    case 3242:  /* *ssadddq3_const_insn */
    case 3223:  /* *subuta3_const_insn */
    case 3222:  /* *subta3_const_insn */
    case 3221:  /* *subuda3_const_insn */
    case 3220:  /* *subda3_const_insn */
    case 3219:  /* *subudq3_const_insn */
    case 3218:  /* *subdq3_const_insn */
    case 3217:  /* *subdi3_const_insn */
    case 3195:  /* *adduta3_const_insn */
    case 3194:  /* *addta3_const_insn */
    case 3193:  /* *adduda3_const_insn */
    case 3192:  /* *addda3_const_insn */
    case 3191:  /* *addudq3_const_insn */
    case 3190:  /* *adddq3_const_insn */
    case 3189:  /* *adddi3_const_insn */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 1495:  /* *nzb=1.ior.ashift */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0), 1));
      break;

    case 1493:  /* *nzb=1.and.zerox.not */
    case 1492:  /* *nzb=1.ior.zerox.not */
    case 1491:  /* *nzb=1.xor.zerox.not */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 2));
      ro[3] = *(ro_loc[3] = &XVECEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0, 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 1484:  /* *nzb=1.and.zerox.not_split */
    case 1483:  /* *nzb=1.ior.zerox.not_split */
    case 1482:  /* *nzb=1.xor.zerox.not_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1));
      break;

    case 1478:  /* *nzb=1.and.zerox */
    case 1477:  /* *nzb=1.ior.zerox */
    case 1476:  /* *nzb=1.xor.zerox */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 2));
      ro[3] = *(ro_loc[3] = &XVECEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0, 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 1475:  /* *nzb=1.and.zerox_split */
    case 1474:  /* *nzb=1.ior.zerox_split */
    case 1473:  /* *nzb=1.xor.zerox_split */
    case 1472:  /* *map.and1-to-skip.si */
    case 1471:  /* *map.and1-to-skip.psi */
    case 1470:  /* *map.and1-to-skip.hi */
    case 1469:  /* *map.and1-to-skip.qi */
    case 1468:  /* *map.and1-to-skip.si */
    case 1467:  /* *map.and1-to-skip.psi */
    case 1466:  /* *map.and1-to-skip.hi */
    case 1465:  /* *map.and1-to-skip.qi */
    case 1464:  /* *map.and1-to-skip.si */
    case 1463:  /* *map.and1-to-skip.psi */
    case 1462:  /* *map.and1-to-skip.hi */
    case 1461:  /* *map.and1-to-skip.qi */
    case 1460:  /* *map.and1-to-skip.si */
    case 1459:  /* *map.and1-to-skip.psi */
    case 1458:  /* *map.and1-to-skip.hi */
    case 1457:  /* *map.and1-to-skip.qi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 1487:  /* *nzb=1.and.lsr.not_split */
    case 1486:  /* *nzb=1.ior.lsr.not_split */
    case 1485:  /* *nzb=1.xor.lsr.not_split */
    case 1412:  /* *shl.and-to-skip.si */
    case 1411:  /* *shl.and-to-skip.si */
    case 1410:  /* *shl.and-to-skip.si */
    case 1409:  /* *shl.and-to-skip.psi */
    case 1408:  /* *shl.and-to-skip.psi */
    case 1407:  /* *shl.and-to-skip.psi */
    case 1406:  /* *shl.and-to-skip.hi */
    case 1405:  /* *shl.and-to-skip.hi */
    case 1404:  /* *shl.and-to-skip.hi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1));
      break;

    case 1403:  /* *shl.ext.and1-to-skip.si */
    case 1402:  /* *shl.ext.and1-to-skip.si */
    case 1401:  /* *shl.ext.and1-to-skip.si */
    case 1400:  /* *shl.ext.and1-to-skip.si */
    case 1399:  /* *shl.ext.and1-to-skip.si */
    case 1398:  /* *shl.ext.and1-to-skip.si */
    case 1397:  /* *shl.ext.and1-to-skip.si */
    case 1396:  /* *shl.ext.and1-to-skip.si */
    case 1395:  /* *shl.ext.and1-to-skip.si */
    case 1394:  /* *shl.ext.and1-to-skip.si */
    case 1393:  /* *shl.ext.and1-to-skip.si */
    case 1392:  /* *shl.ext.and1-to-skip.si */
    case 1391:  /* *shl.ext.and1-to-skip.psi */
    case 1390:  /* *shl.ext.and1-to-skip.psi */
    case 1389:  /* *shl.ext.and1-to-skip.psi */
    case 1388:  /* *shl.ext.and1-to-skip.psi */
    case 1387:  /* *shl.ext.and1-to-skip.psi */
    case 1386:  /* *shl.ext.and1-to-skip.psi */
    case 1385:  /* *shl.ext.and1-to-skip.si */
    case 1384:  /* *shl.ext.and1-to-skip.si */
    case 1383:  /* *shl.ext.and1-to-skip.si */
    case 1382:  /* *shl.ext.and1-to-skip.si */
    case 1381:  /* *shl.ext.and1-to-skip.si */
    case 1380:  /* *shl.ext.and1-to-skip.si */
    case 1379:  /* *shl.ext.and1-to-skip.psi */
    case 1378:  /* *shl.ext.and1-to-skip.psi */
    case 1377:  /* *shl.ext.and1-to-skip.psi */
    case 1376:  /* *shl.ext.and1-to-skip.psi */
    case 1375:  /* *shl.ext.and1-to-skip.psi */
    case 1374:  /* *shl.ext.and1-to-skip.psi */
    case 1373:  /* *shl.ext.and1-to-skip.hi */
    case 1372:  /* *shl.ext.and1-to-skip.hi */
    case 1371:  /* *shl.ext.and1-to-skip.hi */
    case 1370:  /* *shl.ext.and1-to-skip.hi */
    case 1369:  /* *shl.ext.and1-to-skip.hi */
    case 1368:  /* *shl.ext.and1-to-skip.hi */
    case 1367:  /* *mul.ext.and1-to-skip.si */
    case 1366:  /* *mul.ext.and1-to-skip.si */
    case 1365:  /* *mul.ext.and1-to-skip.si */
    case 1364:  /* *mul.ext.and1-to-skip.si */
    case 1363:  /* *mul.ext.and1-to-skip.si */
    case 1362:  /* *mul.ext.and1-to-skip.si */
    case 1361:  /* *mul.ext.and1-to-skip.si */
    case 1360:  /* *mul.ext.and1-to-skip.si */
    case 1359:  /* *mul.ext.and1-to-skip.si */
    case 1358:  /* *mul.ext.and1-to-skip.si */
    case 1357:  /* *mul.ext.and1-to-skip.si */
    case 1356:  /* *mul.ext.and1-to-skip.si */
    case 1355:  /* *mul.ext.and1-to-skip.psi */
    case 1354:  /* *mul.ext.and1-to-skip.psi */
    case 1353:  /* *mul.ext.and1-to-skip.psi */
    case 1352:  /* *mul.ext.and1-to-skip.psi */
    case 1351:  /* *mul.ext.and1-to-skip.psi */
    case 1350:  /* *mul.ext.and1-to-skip.psi */
    case 1349:  /* *mul.ext.and1-to-skip.si */
    case 1348:  /* *mul.ext.and1-to-skip.si */
    case 1347:  /* *mul.ext.and1-to-skip.si */
    case 1346:  /* *mul.ext.and1-to-skip.si */
    case 1345:  /* *mul.ext.and1-to-skip.si */
    case 1344:  /* *mul.ext.and1-to-skip.si */
    case 1343:  /* *mul.ext.and1-to-skip.psi */
    case 1342:  /* *mul.ext.and1-to-skip.psi */
    case 1341:  /* *mul.ext.and1-to-skip.psi */
    case 1340:  /* *mul.ext.and1-to-skip.psi */
    case 1339:  /* *mul.ext.and1-to-skip.psi */
    case 1338:  /* *mul.ext.and1-to-skip.psi */
    case 1337:  /* *mul.ext.and1-to-skip.hi */
    case 1336:  /* *mul.ext.and1-to-skip.hi */
    case 1335:  /* *mul.ext.and1-to-skip.hi */
    case 1334:  /* *mul.ext.and1-to-skip.hi */
    case 1333:  /* *mul.ext.and1-to-skip.hi */
    case 1332:  /* *mul.ext.and1-to-skip.hi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 1319:  /* *pixop-to-skip.si */
    case 1318:  /* *pixop-to-skip.si */
    case 1317:  /* *pixop-to-skip.si */
    case 1316:  /* *pixop-to-skip.psi */
    case 1315:  /* *pixop-to-skip.psi */
    case 1314:  /* *pixop-to-skip.psi */
    case 1313:  /* *pixop-to-skip.hi */
    case 1312:  /* *pixop-to-skip.hi */
    case 1311:  /* *pixop-to-skip.hi */
    case 1310:  /* *pixop-to-skip.qi */
    case 1309:  /* *pixop-to-skip.qi */
    case 1308:  /* *pixop-to-skip.qi */
    case 1307:  /* *pixop-to-skip.si */
    case 1306:  /* *pixop-to-skip.si */
    case 1305:  /* *pixop-to-skip.si */
    case 1304:  /* *pixop-to-skip.psi */
    case 1303:  /* *pixop-to-skip.psi */
    case 1302:  /* *pixop-to-skip.psi */
    case 1301:  /* *pixop-to-skip.hi */
    case 1300:  /* *pixop-to-skip.hi */
    case 1299:  /* *pixop-to-skip.hi */
    case 1298:  /* *pixop-to-skip.qi */
    case 1297:  /* *pixop-to-skip.qi */
    case 1296:  /* *pixop-to-skip.qi */
    case 1295:  /* *pixop-to-skip.si */
    case 1294:  /* *pixop-to-skip.si */
    case 1293:  /* *pixop-to-skip.si */
    case 1292:  /* *pixop-to-skip.psi */
    case 1291:  /* *pixop-to-skip.psi */
    case 1290:  /* *pixop-to-skip.psi */
    case 1289:  /* *pixop-to-skip.hi */
    case 1288:  /* *pixop-to-skip.hi */
    case 1287:  /* *pixop-to-skip.hi */
    case 1286:  /* *pixop-to-skip.qi */
    case 1285:  /* *pixop-to-skip.qi */
    case 1284:  /* *pixop-to-skip.qi */
    case 1283:  /* *pixop-to-skip.si */
    case 1282:  /* *pixop-to-skip.si */
    case 1281:  /* *pixop-to-skip.si */
    case 1280:  /* *pixop-to-skip.psi */
    case 1279:  /* *pixop-to-skip.psi */
    case 1278:  /* *pixop-to-skip.psi */
    case 1277:  /* *pixop-to-skip.hi */
    case 1276:  /* *pixop-to-skip.hi */
    case 1275:  /* *pixop-to-skip.hi */
    case 1274:  /* *pixop-to-skip.qi */
    case 1273:  /* *pixop-to-skip.qi */
    case 1272:  /* *pixop-to-skip.qi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 1271:  /* *neg.zextr-to-sextr.si.si */
    case 1270:  /* *neg.zextr-to-sextr.si.psi */
    case 1269:  /* *neg.zextr-to-sextr.si.hi */
    case 1268:  /* *neg.zextr-to-sextr.si.qi */
    case 1267:  /* *neg.zextr-to-sextr.si.si */
    case 1266:  /* *neg.zextr-to-sextr.si.psi */
    case 1265:  /* *neg.zextr-to-sextr.si.hi */
    case 1264:  /* *neg.zextr-to-sextr.si.qi */
    case 1263:  /* *neg.zextr-to-sextr.psi.si */
    case 1262:  /* *neg.zextr-to-sextr.psi.psi */
    case 1261:  /* *neg.zextr-to-sextr.psi.hi */
    case 1260:  /* *neg.zextr-to-sextr.psi.qi */
    case 1259:  /* *neg.zextr-to-sextr.si.si */
    case 1258:  /* *neg.zextr-to-sextr.si.psi */
    case 1257:  /* *neg.zextr-to-sextr.si.hi */
    case 1256:  /* *neg.zextr-to-sextr.si.qi */
    case 1255:  /* *neg.zextr-to-sextr.psi.si */
    case 1254:  /* *neg.zextr-to-sextr.psi.psi */
    case 1253:  /* *neg.zextr-to-sextr.psi.hi */
    case 1252:  /* *neg.zextr-to-sextr.psi.qi */
    case 1251:  /* *neg.zextr-to-sextr.hi.si */
    case 1250:  /* *neg.zextr-to-sextr.hi.psi */
    case 1249:  /* *neg.zextr-to-sextr.hi.hi */
    case 1248:  /* *neg.zextr-to-sextr.hi.qi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 2));
      break;

    case 1215:  /* *extract.subreg.bit */
    case 1214:  /* *extract.subreg.bit */
    case 1213:  /* *extract.subreg.bit */
    case 1212:  /* *extract.subreg.bit */
    case 1211:  /* *extract.subreg.bit */
    case 1210:  /* *extract.subreg.bit */
    case 1180:  /* *neg.ashiftrtsi.msb */
    case 1179:  /* *neg.ashiftrtpsi.msb */
    case 1178:  /* *neg.ashiftrthi.msb */
    case 1177:  /* *neg.ashiftrtqi.msb */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1));
      break;

    case 1172:  /* *extzv.xor */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 2));
      break;

    case 1171:  /* *extzv.si.subreg3 */
    case 1170:  /* *extzv.si.subreg2 */
    case 1169:  /* *extzv.si.subreg1 */
    case 1168:  /* *extzv.si.subreg0 */
    case 1167:  /* *extzv.psi.subreg3 */
    case 1166:  /* *extzv.psi.subreg2 */
    case 1165:  /* *extzv.psi.subreg1 */
    case 1164:  /* *extzv.psi.subreg0 */
    case 1163:  /* *extzv.hi.subreg3 */
    case 1162:  /* *extzv.hi.subreg2 */
    case 1161:  /* *extzv.hi.subreg1 */
    case 1160:  /* *extzv.hi.subreg0 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 2));
      break;

    case 1209:  /* *extzv.sihi2 */
    case 1208:  /* *extzv.psihi2 */
    case 1207:  /* *extzv.hihi2 */
    case 1206:  /* *extzv.qihi2 */
    case 1159:  /* *extzv.subreg.si */
    case 1158:  /* *extzv.subreg.psi */
    case 1157:  /* *extzv.subreg.hi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 2));
      break;

    case 1156:  /* *extzv.not */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 2));
      break;

    case 1155:  /* *extzv.not_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 2));
      break;

    case 1247:  /* *sextr.si.si */
    case 1246:  /* *sextr.psi.si */
    case 1245:  /* *sextr.hi.si */
    case 1244:  /* *sextr.qi.si */
    case 1243:  /* *sextr.si.psi */
    case 1242:  /* *sextr.psi.psi */
    case 1241:  /* *sextr.hi.psi */
    case 1240:  /* *sextr.qi.psi */
    case 1239:  /* *sextr.si.hi */
    case 1238:  /* *sextr.psi.hi */
    case 1237:  /* *sextr.hi.hi */
    case 1236:  /* *sextr.qi.hi */
    case 1235:  /* *sextr.si.qi */
    case 1234:  /* *sextr.psi.qi */
    case 1233:  /* *sextr.hi.qi */
    case 1232:  /* *sextr.qi.qi */
    case 1152:  /* *extzvsi */
    case 1151:  /* *extzvpsi */
    case 1150:  /* *extzvhi */
    case 1149:  /* *extzvqi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 2));
      break;

    case 1231:  /* *sextr.si.si_split */
    case 1230:  /* *sextr.psi.si_split */
    case 1229:  /* *sextr.hi.si_split */
    case 1228:  /* *sextr.qi.si_split */
    case 1227:  /* *sextr.si.psi_split */
    case 1226:  /* *sextr.psi.psi_split */
    case 1225:  /* *sextr.hi.psi_split */
    case 1224:  /* *sextr.qi.psi_split */
    case 1223:  /* *sextr.si.hi_split */
    case 1222:  /* *sextr.psi.hi_split */
    case 1221:  /* *sextr.hi.hi_split */
    case 1220:  /* *sextr.qi.hi_split */
    case 1219:  /* *sextr.si.qi_split */
    case 1218:  /* *sextr.psi.qi_split */
    case 1217:  /* *sextr.hi.qi_split */
    case 1216:  /* *sextr.qi.qi_split */
    case 1154:  /* *extzv.qihi1 */
    case 1153:  /* *extzv.qihi1 */
    case 1148:  /* *extzvsi_split */
    case 1147:  /* *extzvpsi_split */
    case 1146:  /* *extzvhi_split */
    case 1145:  /* *extzvqi_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 2));
      break;

    case 1141:  /* *iorhi3.ashift8-ext.zerox */
    case 1140:  /* *iorhi3.ashift8-ext.zerox */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 1139:  /* *iorsipsi.ashift */
    case 1138:  /* *xorsipsi.ashift */
    case 1137:  /* *iorsipsi.lshiftrt */
    case 1136:  /* *xorsipsi.lshiftrt */
    case 1135:  /* *iorsihi.ashift */
    case 1134:  /* *xorsihi.ashift */
    case 1133:  /* *iorsihi.lshiftrt */
    case 1132:  /* *xorsihi.lshiftrt */
    case 1131:  /* *iorpsihi.ashift */
    case 1130:  /* *xorpsihi.ashift */
    case 1129:  /* *iorpsihi.lshiftrt */
    case 1128:  /* *xorpsihi.lshiftrt */
    case 1127:  /* *iorsiqi.ashift */
    case 1126:  /* *xorsiqi.ashift */
    case 1125:  /* *iorsiqi.lshiftrt */
    case 1124:  /* *xorsiqi.lshiftrt */
    case 1123:  /* *iorpsiqi.ashift */
    case 1122:  /* *xorpsiqi.ashift */
    case 1121:  /* *iorpsiqi.lshiftrt */
    case 1120:  /* *xorpsiqi.lshiftrt */
    case 1119:  /* *iorhiqi.ashift */
    case 1118:  /* *xorhiqi.ashift */
    case 1117:  /* *iorhiqi.lshiftrt */
    case 1116:  /* *xorhiqi.lshiftrt */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 1103:  /* *iorsi.ashift */
    case 1102:  /* *xorsi.ashift */
    case 1101:  /* *iorsi.lshiftrt */
    case 1100:  /* *xorsi.lshiftrt */
    case 1099:  /* *iorpsi.ashift */
    case 1098:  /* *xorpsi.ashift */
    case 1097:  /* *iorpsi.lshiftrt */
    case 1096:  /* *xorpsi.lshiftrt */
    case 1095:  /* *iorhi.ashift */
    case 1094:  /* *xorhi.ashift */
    case 1093:  /* *iorhi.lshiftrt */
    case 1092:  /* *xorhi.lshiftrt */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 1091:  /* *insv.xor-extract_split */
    case 1090:  /* *insv.xor-extract_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 2));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 1089:  /* *insv.not-bit.7_split */
    case 1088:  /* *insv.not-bit.0_split */
    case 1087:  /* *insv.xor1-bit.0_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 1086:  /* *insv.not-shiftrt_split */
    case 1085:  /* *insv.not-shiftrt_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 1084:  /* insv_notbit */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 2));
      break;

    case 1083:  /* *insv.shiftrt */
    case 1082:  /* *insv.shiftrt */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 1081:  /* *insv.extract */
    case 1080:  /* *insv.extract */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 2));
      break;

    case 1079:  /* *insv.reg */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 0), 1));
      break;

    case 1078:  /* *insv.reg_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (pat, 1));
      break;

    case 1077:  /* *insv.not.io */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 1076:  /* *insv.io */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 0), 2));
      ro[2] = *(ro_loc[2] = &XEXP (pat, 1));
      break;

    case 1074:  /* *movbitsi.0-6 */
    case 1073:  /* *movbitpsi.0-6 */
    case 1072:  /* *movbithi.0-6 */
    case 1071:  /* *movbitqi.0-6 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      break;

    case 1070:  /* *movbitqi.1-6.b */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      break;

    case 1069:  /* *movbitqi.1-6.a */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 0), 1));
      ro[5] = *(ro_loc[5] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      break;

    case 3145:  /* *roundusq3_const */
    case 3144:  /* *roundusa3_const */
    case 3143:  /* *rounduha3_const */
    case 3142:  /* *rounduhq3_const */
    case 3141:  /* *rounduqq3_const */
    case 3140:  /* *roundsq3_const */
    case 3139:  /* *roundsa3_const */
    case 3138:  /* *roundha3_const */
    case 3137:  /* *roundhq3_const */
    case 3136:  /* *roundqq3_const */
    case 1066:  /* *fmulsu_insn */
    case 1062:  /* *fmuls_insn */
    case 1058:  /* *fmul_insn */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 1));
      break;

    case 1056:  /* *wdr */
    case 1055:  /* *sleep */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 1), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0, 0);
      recog_data.dup_num[0] = 0;
      break;

    case 1031:  /* *popcounthi2.split8 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      break;

    case 1020:  /* *flash_segment1 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 1017:  /* *avr.md:9021 */
    case 1015:  /* mask1_0x80_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 1), 0));
      break;

    case 1019:  /* *mask1_0xfe */
    case 1016:  /* *mask1_0x80 */
    case 1014:  /* *mask1_0x01 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 1018:  /* mask1_0xfe_split */
    case 1013:  /* mask1_0x01_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 1012:  /* *insert_bits */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 1));
      ro[3] = *(ro_loc[3] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 2));
      break;

    case 1011:  /* insert_bits */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XVECEXP (XEXP (pat, 1), 0, 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (pat, 1), 0, 1));
      ro[3] = *(ro_loc[3] = &XVECEXP (XEXP (pat, 1), 0, 2));
      break;

    case 1010:  /* *delay_cycles_4 */
    case 1009:  /* delay_cycles_4 */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 3), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 4), 0));
      ro[5] = *(ro_loc[5] = &XEXP (XVECEXP (pat, 0, 5), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0, 0);
      recog_data.dup_num[0] = 1;
      break;

    case 1008:  /* *delay_cycles_3 */
    case 1007:  /* delay_cycles_3 */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 3), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 4), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0, 0);
      recog_data.dup_num[0] = 1;
      break;

    case 1006:  /* *delay_cycles_2 */
    case 1005:  /* delay_cycles_2 */
    case 1004:  /* *delay_cycles_1 */
    case 1003:  /* delay_cycles_1 */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0, 0);
      recog_data.dup_num[0] = 1;
      break;

    case 998:  /* *gasisr */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 0));
      ro[1] = *(ro_loc[1] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 1));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 2), 1), 0, 0);
      recog_data.dup_num[0] = 2;
      break;

    case 997:  /* epilogue_restores */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 1));
      recog_data.dup_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 2), 1), 1);
      recog_data.dup_num[0] = 0;
      break;

    case 996:  /* call_prologue_saves */
      ro[0] = *(ro_loc[0] = &XVECEXP (pat, 0, 1));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 2), 1), 1));
      break;

    case 1054:  /* *nopv */
    case 995:  /* cli_sei */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 0), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0, 0);
      recog_data.dup_num[0] = 1;
      break;

    case 994:  /* popqi */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      break;

    case 993:  /* *sbix_branch_tmp_bit7 */
    case 987:  /* *sbix_branch_bit7 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 992:  /* *sbix_branch_tmp_bit7_split */
    case 986:  /* *sbix_branch_bit7_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 991:  /* *sbix_branch_tmp */
    case 990:  /* *sbix_branch_tmp */
    case 985:  /* *sbix_branch */
    case 984:  /* *sbix_branch */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 989:  /* *sbix_branch_tmp_split */
    case 988:  /* *sbix_branch_tmp_split */
    case 983:  /* *sbix_branch_split */
    case 982:  /* *sbix_branch_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 981:  /* *sbi */
    case 980:  /* *cbi */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 1));
      recog_data.dup_loc[0] = &XEXP (XEXP (XEXP (pat, 1), 0), 0);
      recog_data.dup_num[0] = 0;
      break;

    case 979:  /* casesi_hi_sequence */
    case 978:  /* casesi_qi_sequence */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 1), 0, 0), 1), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 2), 0, 0), 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 4), 0, 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 2), 0, 0), 1), 1), 0));
      ro[5] = *(ro_loc[5] = &XEXP (XVECEXP (XVECEXP (pat, 0, 1), 0, 0), 0));
      ro[6] = *(ro_loc[6] = &XEXP (XVECEXP (pat, 0, 3), 1));
      ro[7] = *(ro_loc[7] = &XEXP (XVECEXP (pat, 0, 3), 0));
      ro[8] = *(ro_loc[8] = &XEXP (XVECEXP (XVECEXP (pat, 0, 4), 0, 2), 0));
      ro[9] = *(ro_loc[9] = &XEXP (XVECEXP (XVECEXP (pat, 0, 4), 0, 3), 0));
      ro[10] = *(ro_loc[10] = &XEXP (XVECEXP (pat, 0, 0), 1));
      ro[11] = *(ro_loc[11] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      recog_data.dup_loc[0] = &XVECEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 4), 0, 0), 1), 0, 0);
      recog_data.dup_num[0] = 7;
      recog_data.dup_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 2), 0, 0), 1), 0), 0);
      recog_data.dup_num[1] = 5;
      recog_data.dup_loc[2] = &XEXP (XEXP (XVECEXP (XVECEXP (pat, 0, 1), 0, 0), 1), 0);
      recog_data.dup_num[2] = 0;
      break;

    case 977:  /* *tablejump.3byte-pc */
    case 976:  /* *tablejump.3byte-pc_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 0), 0));
      break;

    case 975:  /* *tablejump */
    case 974:  /* *tablejump_split */
      ro[0] = *(ro_loc[0] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      break;

    case 970:  /* call_insn */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 0), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 969:  /* jump */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 968:  /* branch_ZN */
    case 967:  /* branch_N */
    case 966:  /* branch */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 965:  /* *sbrx_and_branchsi */
    case 964:  /* *sbrx_and_branchpsi */
    case 963:  /* *sbrx_and_branchhi */
    case 962:  /* *sbrx_and_branchqi */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 961:  /* *sbrx_and_branchsi_split */
    case 960:  /* *sbrx_and_branchpsi_split */
    case 959:  /* *sbrx_and_branchhi_split */
    case 958:  /* *sbrx_and_branchqi_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 957:  /* *sbrx_branchdi */
    case 956:  /* *sbrx_branchsi */
    case 955:  /* *sbrx_branchpsi */
    case 954:  /* *sbrx_branchhi */
    case 953:  /* *sbrx_branchqi */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 952:  /* sbrx_branchdi_split */
    case 951:  /* sbrx_branchsi_split */
    case 950:  /* sbrx_branchpsi_split */
    case 949:  /* sbrx_branchhi_split */
    case 948:  /* sbrx_branchqi_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 2));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 939:  /* *ashift.for.ccn.si */
    case 938:  /* *ashift.for.ccn.psi */
    case 937:  /* *ashift.for.ccn.hi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      break;

    case 936:  /* *sub-extendpsi.for.cczn.si */
    case 935:  /* *sub-extendpsi.for.cczn.si */
    case 934:  /* *sub-extendhi.for.cczn.si */
    case 933:  /* *sub-extendhi.for.cczn.si */
    case 932:  /* *sub-extendhi.for.cczn.psi */
    case 931:  /* *sub-extendhi.for.cczn.psi */
    case 930:  /* *sub-extendqi.for.cczn.si */
    case 929:  /* *sub-extendqi.for.cczn.si */
    case 928:  /* *sub-extendqi.for.cczn.psi */
    case 927:  /* *sub-extendqi.for.cczn.psi */
    case 926:  /* *sub-extendqi.for.cczn.hi */
    case 925:  /* *sub-extendqi.for.cczn.hi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1), 0));
      break;

    case 947:  /* *op8.for.cczn.lshiftrt */
    case 946:  /* *op8.for.cczn.ashiftrt */
    case 945:  /* *op8.for.cczn.ashift */
    case 944:  /* *op8.for.cczn.xor */
    case 943:  /* *op8.for.cczn.ior */
    case 942:  /* *op8.for.cczn.and */
    case 941:  /* *op8.for.cczn.minus */
    case 940:  /* *op8.for.cczn.plus */
    case 924:  /* *sub.for.cczn.si */
    case 923:  /* *sub.for.cczn.psi */
    case 922:  /* *sub.for.cczn.hi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      break;

    case 921:  /* *add.for.ccn.si */
    case 920:  /* *add.for.ccn.psi */
    case 919:  /* *add.for.ccn.hi */
    case 918:  /* *add.for.cczn.si */
    case 917:  /* *add.for.cczn.psi */
    case 916:  /* *add.for.cczn.hi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0));
      ro[5] = *(ro_loc[5] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 1));
      break;

    case 915:  /* *cbranchsi.zero_extendpsi.0 */
    case 914:  /* *cbranchsi.sign_extendpsi.0 */
    case 913:  /* *cbranchsi.zero_extendhi.0 */
    case 912:  /* *cbranchsi.sign_extendhi.0 */
    case 911:  /* *cbranchpsi.zero_extendhi.0 */
    case 910:  /* *cbranchpsi.sign_extendhi.0 */
    case 909:  /* *cbranchsi.zero_extendqi.0 */
    case 908:  /* *cbranchsi.sign_extendqi.0 */
    case 907:  /* *cbranchpsi.zero_extendqi.0 */
    case 906:  /* *cbranchpsi.sign_extendqi.0 */
    case 905:  /* *cbranchhi.zero_extendqi.0 */
    case 904:  /* *cbranchhi.sign_extendqi.0 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 903:  /* *cbranchsi.zero_extendpsi.0 */
    case 902:  /* *cbranchsi.sign_extendpsi.0 */
    case 901:  /* *cbranchsi.zero_extendhi.0 */
    case 900:  /* *cbranchsi.sign_extendhi.0 */
    case 899:  /* *cbranchpsi.zero_extendhi.0 */
    case 898:  /* *cbranchpsi.sign_extendhi.0 */
    case 897:  /* *cbranchsi.zero_extendqi.0 */
    case 896:  /* *cbranchsi.sign_extendqi.0 */
    case 895:  /* *cbranchpsi.zero_extendqi.0 */
    case 894:  /* *cbranchpsi.sign_extendqi.0 */
    case 893:  /* *cbranchhi.zero_extendqi.0 */
    case 892:  /* *cbranchhi.sign_extendqi.0 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 891:  /* cbranchuha4_insn */
    case 890:  /* cbranchha4_insn */
    case 889:  /* cbranchuhq4_insn */
    case 888:  /* cbranchhq4_insn */
    case 887:  /* cbranchhi4_insn */
    case 886:  /* cbranchpsi4_insn */
    case 885:  /* cbranchusa4_insn */
    case 884:  /* cbranchsa4_insn */
    case 883:  /* cbranchusq4_insn */
    case 882:  /* cbranchsq4_insn */
    case 881:  /* cbranchsi4_insn */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 880:  /* cbranchuqq4_insn */
    case 879:  /* cbranchqq4_insn */
    case 878:  /* cbranchqi4_insn */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 877:  /* *cmpsi_lsr */
    case 876:  /* *cmppsi_lsr */
    case 875:  /* *cmphi_lsr */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      break;

    case 874:  /* *cmpusa */
    case 873:  /* *cmpsa */
    case 872:  /* *cmpusq */
    case 871:  /* *cmpsq */
    case 870:  /* *cmpsi */
    case 869:  /* *cmppsi */
    case 868:  /* cmpuha3 */
    case 867:  /* cmpha3 */
    case 866:  /* cmpuhq3 */
    case 865:  /* cmphq3 */
    case 864:  /* cmphi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 3288:  /* cbranch_const8_di2_split */
    case 3280:  /* cbranch_uta2_split */
    case 3279:  /* cbranch_ta2_split */
    case 3278:  /* cbranch_uda2_split */
    case 3277:  /* cbranch_da2_split */
    case 3276:  /* cbranch_udq2_split */
    case 3275:  /* cbranch_dq2_split */
    case 3274:  /* cbranch_di2_split */
    case 863:  /* *cmpsi.zero_extendpsi.1 */
    case 862:  /* *cmpsi.sign_extendpsi.1 */
    case 861:  /* *cmpsi.zero_extendhi.1 */
    case 860:  /* *cmpsi.sign_extendhi.1 */
    case 859:  /* *cmppsi.zero_extendhi.1 */
    case 858:  /* *cmppsi.sign_extendhi.1 */
    case 857:  /* *cmpsi.zero_extendqi.1 */
    case 856:  /* *cmpsi.sign_extendqi.1 */
    case 855:  /* *cmppsi.zero_extendqi.1 */
    case 854:  /* *cmppsi.sign_extendqi.1 */
    case 853:  /* *cmphi.zero_extendqi.1 */
    case 852:  /* *cmphi.sign_extendqi.1 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 851:  /* *cmpsi.zero_extendpsi.0 */
    case 850:  /* *cmpsi.sign_extendpsi.0 */
    case 849:  /* *cmpsi.zero_extendhi.0 */
    case 848:  /* *cmpsi.sign_extendhi.0 */
    case 847:  /* *cmppsi.zero_extendhi.0 */
    case 846:  /* *cmppsi.sign_extendhi.0 */
    case 845:  /* *cmpsi.zero_extendqi.0 */
    case 844:  /* *cmpsi.sign_extendqi.0 */
    case 843:  /* *cmppsi.zero_extendqi.0 */
    case 842:  /* *cmppsi.sign_extendqi.0 */
    case 841:  /* *cmphi.zero_extendqi.0 */
    case 840:  /* *cmphi.sign_extendqi.0 */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 3265:  /* ussubuta3_const_insn */
    case 3264:  /* usadduta3_const_insn */
    case 3263:  /* ussubuda3_const_insn */
    case 3262:  /* usadduda3_const_insn */
    case 3261:  /* ussubudq3_const_insn */
    case 3260:  /* usaddudq3_const_insn */
    case 3241:  /* sssubta3_const_insn */
    case 3240:  /* ssaddta3_const_insn */
    case 3239:  /* sssubda3_const_insn */
    case 3238:  /* ssaddda3_const_insn */
    case 3237:  /* sssubdq3_const_insn */
    case 3236:  /* ssadddq3_const_insn */
    case 3216:  /* subuta3_const_insn */
    case 3215:  /* subta3_const_insn */
    case 3214:  /* subuda3_const_insn */
    case 3213:  /* subda3_const_insn */
    case 3212:  /* subudq3_const_insn */
    case 3211:  /* subdq3_const_insn */
    case 3210:  /* subdi3_const_insn */
    case 3188:  /* adduta3_const_insn */
    case 3187:  /* addta3_const_insn */
    case 3186:  /* adduda3_const_insn */
    case 3185:  /* addda3_const_insn */
    case 3184:  /* addudq3_const_insn */
    case 3183:  /* adddq3_const_insn */
    case 3182:  /* adddi3_const_insn */
    case 833:  /* *swapped_tstpsi */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 839:  /* cmpuqq3 */
    case 838:  /* cmpqq3 */
    case 837:  /* cmpqi3 */
    case 836:  /* *swapped_tstsa */
    case 835:  /* *swapped_tstsq */
    case 834:  /* *swapped_tstsi */
    case 832:  /* *swapped_tstha */
    case 831:  /* *swapped_tsthq */
    case 830:  /* *swapped_tsthi */
    case 829:  /* *swapped_tstqq */
    case 828:  /* *swapped_tstqi */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 704:  /* *ashlqi.1.zextpsi_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      break;

    case 1021:  /* *split.flash_segment */
    case 681:  /* *ashlhiqi3 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 680:  /* *ashluqihiqi3.mem */
    case 679:  /* *ashlsqihiqi3.mem */
    case 678:  /* *ashluqihiqi3 */
    case 677:  /* *ashlsqihiqi3 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      break;

    case 3059:  /* *ssabsqq2 */
    case 3057:  /* *ssnegqq2 */
    case 3015:  /* *fractunssidi2 */
    case 3014:  /* *fractunshidi2 */
    case 3013:  /* *fractunsqidi2 */
    case 3012:  /* *fractunsutadi2 */
    case 3011:  /* *fractunstadi2 */
    case 3010:  /* *fractunsudadi2 */
    case 3009:  /* *fractunsdadi2 */
    case 3008:  /* *fractunsudqdi2 */
    case 3007:  /* *fractunsdqdi2 */
    case 3006:  /* *fractunsusadi2 */
    case 3005:  /* *fractunssadi2 */
    case 3004:  /* *fractunsusqdi2 */
    case 3003:  /* *fractunssqdi2 */
    case 3002:  /* *fractunsuhadi2 */
    case 3001:  /* *fractunshadi2 */
    case 3000:  /* *fractunsuhqdi2 */
    case 2999:  /* *fractunshqdi2 */
    case 2998:  /* *fractunsuqqdi2 */
    case 2997:  /* *fractunsqqdi2 */
    case 2996:  /* *fractunsdisi2 */
    case 2995:  /* *fractunshisi2 */
    case 2994:  /* *fractunsqisi2 */
    case 2993:  /* *fractunsutasi2 */
    case 2992:  /* *fractunstasi2 */
    case 2991:  /* *fractunsudasi2 */
    case 2990:  /* *fractunsdasi2 */
    case 2989:  /* *fractunsudqsi2 */
    case 2988:  /* *fractunsdqsi2 */
    case 2987:  /* *fractunsusasi2 */
    case 2986:  /* *fractunssasi2 */
    case 2985:  /* *fractunsusqsi2 */
    case 2984:  /* *fractunssqsi2 */
    case 2983:  /* *fractunsuhasi2 */
    case 2982:  /* *fractunshasi2 */
    case 2981:  /* *fractunsuhqsi2 */
    case 2980:  /* *fractunshqsi2 */
    case 2979:  /* *fractunsuqqsi2 */
    case 2978:  /* *fractunsqqsi2 */
    case 2977:  /* *fractunsdihi2 */
    case 2976:  /* *fractunssihi2 */
    case 2975:  /* *fractunsqihi2 */
    case 2974:  /* *fractunsutahi2 */
    case 2973:  /* *fractunstahi2 */
    case 2972:  /* *fractunsudahi2 */
    case 2971:  /* *fractunsdahi2 */
    case 2970:  /* *fractunsudqhi2 */
    case 2969:  /* *fractunsdqhi2 */
    case 2968:  /* *fractunsusahi2 */
    case 2967:  /* *fractunssahi2 */
    case 2966:  /* *fractunsusqhi2 */
    case 2965:  /* *fractunssqhi2 */
    case 2964:  /* *fractunsuhahi2 */
    case 2963:  /* *fractunshahi2 */
    case 2962:  /* *fractunsuhqhi2 */
    case 2961:  /* *fractunshqhi2 */
    case 2960:  /* *fractunsuqqhi2 */
    case 2959:  /* *fractunsqqhi2 */
    case 2958:  /* *fractunsdiqi2 */
    case 2957:  /* *fractunssiqi2 */
    case 2956:  /* *fractunshiqi2 */
    case 2955:  /* *fractunsutaqi2 */
    case 2954:  /* *fractunstaqi2 */
    case 2953:  /* *fractunsudaqi2 */
    case 2952:  /* *fractunsdaqi2 */
    case 2951:  /* *fractunsudqqi2 */
    case 2950:  /* *fractunsdqqi2 */
    case 2949:  /* *fractunsusaqi2 */
    case 2948:  /* *fractunssaqi2 */
    case 2947:  /* *fractunsusqqi2 */
    case 2946:  /* *fractunssqqi2 */
    case 2945:  /* *fractunsuhaqi2 */
    case 2944:  /* *fractunshaqi2 */
    case 2943:  /* *fractunsuhqqi2 */
    case 2942:  /* *fractunshqqi2 */
    case 2941:  /* *fractunsuqqqi2 */
    case 2940:  /* *fractunsqqqi2 */
    case 2939:  /* *fractunsdiuta2 */
    case 2938:  /* *fractunssiuta2 */
    case 2937:  /* *fractunshiuta2 */
    case 2936:  /* *fractunsqiuta2 */
    case 2935:  /* *fractunstauta2 */
    case 2934:  /* *fractunsudauta2 */
    case 2933:  /* *fractunsdauta2 */
    case 2932:  /* *fractunsudquta2 */
    case 2931:  /* *fractunsdquta2 */
    case 2930:  /* *fractunsusauta2 */
    case 2929:  /* *fractunssauta2 */
    case 2928:  /* *fractunsusquta2 */
    case 2927:  /* *fractunssquta2 */
    case 2926:  /* *fractunsuhauta2 */
    case 2925:  /* *fractunshauta2 */
    case 2924:  /* *fractunsuhquta2 */
    case 2923:  /* *fractunshquta2 */
    case 2922:  /* *fractunsuqquta2 */
    case 2921:  /* *fractunsqquta2 */
    case 2920:  /* *fractunsdita2 */
    case 2919:  /* *fractunssita2 */
    case 2918:  /* *fractunshita2 */
    case 2917:  /* *fractunsqita2 */
    case 2916:  /* *fractunsutata2 */
    case 2915:  /* *fractunsudata2 */
    case 2914:  /* *fractunsdata2 */
    case 2913:  /* *fractunsudqta2 */
    case 2912:  /* *fractunsdqta2 */
    case 2911:  /* *fractunsusata2 */
    case 2910:  /* *fractunssata2 */
    case 2909:  /* *fractunsusqta2 */
    case 2908:  /* *fractunssqta2 */
    case 2907:  /* *fractunsuhata2 */
    case 2906:  /* *fractunshata2 */
    case 2905:  /* *fractunsuhqta2 */
    case 2904:  /* *fractunshqta2 */
    case 2903:  /* *fractunsuqqta2 */
    case 2902:  /* *fractunsqqta2 */
    case 2901:  /* *fractunsdiuda2 */
    case 2900:  /* *fractunssiuda2 */
    case 2899:  /* *fractunshiuda2 */
    case 2898:  /* *fractunsqiuda2 */
    case 2897:  /* *fractunsutauda2 */
    case 2896:  /* *fractunstauda2 */
    case 2895:  /* *fractunsdauda2 */
    case 2894:  /* *fractunsudquda2 */
    case 2893:  /* *fractunsdquda2 */
    case 2892:  /* *fractunsusauda2 */
    case 2891:  /* *fractunssauda2 */
    case 2890:  /* *fractunsusquda2 */
    case 2889:  /* *fractunssquda2 */
    case 2888:  /* *fractunsuhauda2 */
    case 2887:  /* *fractunshauda2 */
    case 2886:  /* *fractunsuhquda2 */
    case 2885:  /* *fractunshquda2 */
    case 2884:  /* *fractunsuqquda2 */
    case 2883:  /* *fractunsqquda2 */
    case 2882:  /* *fractunsdida2 */
    case 2881:  /* *fractunssida2 */
    case 2880:  /* *fractunshida2 */
    case 2879:  /* *fractunsqida2 */
    case 2878:  /* *fractunsutada2 */
    case 2877:  /* *fractunstada2 */
    case 2876:  /* *fractunsudada2 */
    case 2875:  /* *fractunsudqda2 */
    case 2874:  /* *fractunsdqda2 */
    case 2873:  /* *fractunsusada2 */
    case 2872:  /* *fractunssada2 */
    case 2871:  /* *fractunsusqda2 */
    case 2870:  /* *fractunssqda2 */
    case 2869:  /* *fractunsuhada2 */
    case 2868:  /* *fractunshada2 */
    case 2867:  /* *fractunsuhqda2 */
    case 2866:  /* *fractunshqda2 */
    case 2865:  /* *fractunsuqqda2 */
    case 2864:  /* *fractunsqqda2 */
    case 2863:  /* *fractunsdiudq2 */
    case 2862:  /* *fractunssiudq2 */
    case 2861:  /* *fractunshiudq2 */
    case 2860:  /* *fractunsqiudq2 */
    case 2859:  /* *fractunsutaudq2 */
    case 2858:  /* *fractunstaudq2 */
    case 2857:  /* *fractunsudaudq2 */
    case 2856:  /* *fractunsdaudq2 */
    case 2855:  /* *fractunsdqudq2 */
    case 2854:  /* *fractunsusaudq2 */
    case 2853:  /* *fractunssaudq2 */
    case 2852:  /* *fractunsusqudq2 */
    case 2851:  /* *fractunssqudq2 */
    case 2850:  /* *fractunsuhaudq2 */
    case 2849:  /* *fractunshaudq2 */
    case 2848:  /* *fractunsuhqudq2 */
    case 2847:  /* *fractunshqudq2 */
    case 2846:  /* *fractunsuqqudq2 */
    case 2845:  /* *fractunsqqudq2 */
    case 2844:  /* *fractunsdidq2 */
    case 2843:  /* *fractunssidq2 */
    case 2842:  /* *fractunshidq2 */
    case 2841:  /* *fractunsqidq2 */
    case 2840:  /* *fractunsutadq2 */
    case 2839:  /* *fractunstadq2 */
    case 2838:  /* *fractunsudadq2 */
    case 2837:  /* *fractunsdadq2 */
    case 2836:  /* *fractunsudqdq2 */
    case 2835:  /* *fractunsusadq2 */
    case 2834:  /* *fractunssadq2 */
    case 2833:  /* *fractunsusqdq2 */
    case 2832:  /* *fractunssqdq2 */
    case 2831:  /* *fractunsuhadq2 */
    case 2830:  /* *fractunshadq2 */
    case 2829:  /* *fractunsuhqdq2 */
    case 2828:  /* *fractunshqdq2 */
    case 2827:  /* *fractunsuqqdq2 */
    case 2826:  /* *fractunsqqdq2 */
    case 2825:  /* *fractunsdiusa2 */
    case 2824:  /* *fractunssiusa2 */
    case 2823:  /* *fractunshiusa2 */
    case 2822:  /* *fractunsqiusa2 */
    case 2821:  /* *fractunsutausa2 */
    case 2820:  /* *fractunstausa2 */
    case 2819:  /* *fractunsudausa2 */
    case 2818:  /* *fractunsdausa2 */
    case 2817:  /* *fractunsudqusa2 */
    case 2816:  /* *fractunsdqusa2 */
    case 2815:  /* *fractunssausa2 */
    case 2814:  /* *fractunsusqusa2 */
    case 2813:  /* *fractunssqusa2 */
    case 2812:  /* *fractunsuhausa2 */
    case 2811:  /* *fractunshausa2 */
    case 2810:  /* *fractunsuhqusa2 */
    case 2809:  /* *fractunshqusa2 */
    case 2808:  /* *fractunsuqqusa2 */
    case 2807:  /* *fractunsqqusa2 */
    case 2806:  /* *fractunsdisa2 */
    case 2805:  /* *fractunssisa2 */
    case 2804:  /* *fractunshisa2 */
    case 2803:  /* *fractunsqisa2 */
    case 2802:  /* *fractunsutasa2 */
    case 2801:  /* *fractunstasa2 */
    case 2800:  /* *fractunsudasa2 */
    case 2799:  /* *fractunsdasa2 */
    case 2798:  /* *fractunsudqsa2 */
    case 2797:  /* *fractunsdqsa2 */
    case 2796:  /* *fractunsusasa2 */
    case 2795:  /* *fractunsusqsa2 */
    case 2794:  /* *fractunssqsa2 */
    case 2793:  /* *fractunsuhasa2 */
    case 2792:  /* *fractunshasa2 */
    case 2791:  /* *fractunsuhqsa2 */
    case 2790:  /* *fractunshqsa2 */
    case 2789:  /* *fractunsuqqsa2 */
    case 2788:  /* *fractunsqqsa2 */
    case 2787:  /* *fractunsdiusq2 */
    case 2786:  /* *fractunssiusq2 */
    case 2785:  /* *fractunshiusq2 */
    case 2784:  /* *fractunsqiusq2 */
    case 2783:  /* *fractunsutausq2 */
    case 2782:  /* *fractunstausq2 */
    case 2781:  /* *fractunsudausq2 */
    case 2780:  /* *fractunsdausq2 */
    case 2779:  /* *fractunsudqusq2 */
    case 2778:  /* *fractunsdqusq2 */
    case 2777:  /* *fractunsusausq2 */
    case 2776:  /* *fractunssausq2 */
    case 2775:  /* *fractunssqusq2 */
    case 2774:  /* *fractunsuhausq2 */
    case 2773:  /* *fractunshausq2 */
    case 2772:  /* *fractunsuhqusq2 */
    case 2771:  /* *fractunshqusq2 */
    case 2770:  /* *fractunsuqqusq2 */
    case 2769:  /* *fractunsqqusq2 */
    case 2768:  /* *fractunsdisq2 */
    case 2767:  /* *fractunssisq2 */
    case 2766:  /* *fractunshisq2 */
    case 2765:  /* *fractunsqisq2 */
    case 2764:  /* *fractunsutasq2 */
    case 2763:  /* *fractunstasq2 */
    case 2762:  /* *fractunsudasq2 */
    case 2761:  /* *fractunsdasq2 */
    case 2760:  /* *fractunsudqsq2 */
    case 2759:  /* *fractunsdqsq2 */
    case 2758:  /* *fractunsusasq2 */
    case 2757:  /* *fractunssasq2 */
    case 2756:  /* *fractunsusqsq2 */
    case 2755:  /* *fractunsuhasq2 */
    case 2754:  /* *fractunshasq2 */
    case 2753:  /* *fractunsuhqsq2 */
    case 2752:  /* *fractunshqsq2 */
    case 2751:  /* *fractunsuqqsq2 */
    case 2750:  /* *fractunsqqsq2 */
    case 2749:  /* *fractunsdiuha2 */
    case 2748:  /* *fractunssiuha2 */
    case 2747:  /* *fractunshiuha2 */
    case 2746:  /* *fractunsqiuha2 */
    case 2745:  /* *fractunsutauha2 */
    case 2744:  /* *fractunstauha2 */
    case 2743:  /* *fractunsudauha2 */
    case 2742:  /* *fractunsdauha2 */
    case 2741:  /* *fractunsudquha2 */
    case 2740:  /* *fractunsdquha2 */
    case 2739:  /* *fractunsusauha2 */
    case 2738:  /* *fractunssauha2 */
    case 2737:  /* *fractunsusquha2 */
    case 2736:  /* *fractunssquha2 */
    case 2735:  /* *fractunshauha2 */
    case 2734:  /* *fractunsuhquha2 */
    case 2733:  /* *fractunshquha2 */
    case 2732:  /* *fractunsuqquha2 */
    case 2731:  /* *fractunsqquha2 */
    case 2730:  /* *fractunsdiha2 */
    case 2729:  /* *fractunssiha2 */
    case 2728:  /* *fractunshiha2 */
    case 2727:  /* *fractunsqiha2 */
    case 2726:  /* *fractunsutaha2 */
    case 2725:  /* *fractunstaha2 */
    case 2724:  /* *fractunsudaha2 */
    case 2723:  /* *fractunsdaha2 */
    case 2722:  /* *fractunsudqha2 */
    case 2721:  /* *fractunsdqha2 */
    case 2720:  /* *fractunsusaha2 */
    case 2719:  /* *fractunssaha2 */
    case 2718:  /* *fractunsusqha2 */
    case 2717:  /* *fractunssqha2 */
    case 2716:  /* *fractunsuhaha2 */
    case 2715:  /* *fractunsuhqha2 */
    case 2714:  /* *fractunshqha2 */
    case 2713:  /* *fractunsuqqha2 */
    case 2712:  /* *fractunsqqha2 */
    case 2711:  /* *fractunsdiuhq2 */
    case 2710:  /* *fractunssiuhq2 */
    case 2709:  /* *fractunshiuhq2 */
    case 2708:  /* *fractunsqiuhq2 */
    case 2707:  /* *fractunsutauhq2 */
    case 2706:  /* *fractunstauhq2 */
    case 2705:  /* *fractunsudauhq2 */
    case 2704:  /* *fractunsdauhq2 */
    case 2703:  /* *fractunsudquhq2 */
    case 2702:  /* *fractunsdquhq2 */
    case 2701:  /* *fractunsusauhq2 */
    case 2700:  /* *fractunssauhq2 */
    case 2699:  /* *fractunsusquhq2 */
    case 2698:  /* *fractunssquhq2 */
    case 2697:  /* *fractunsuhauhq2 */
    case 2696:  /* *fractunshauhq2 */
    case 2695:  /* *fractunshquhq2 */
    case 2694:  /* *fractunsuqquhq2 */
    case 2693:  /* *fractunsqquhq2 */
    case 2692:  /* *fractunsdihq2 */
    case 2691:  /* *fractunssihq2 */
    case 2690:  /* *fractunshihq2 */
    case 2689:  /* *fractunsqihq2 */
    case 2688:  /* *fractunsutahq2 */
    case 2687:  /* *fractunstahq2 */
    case 2686:  /* *fractunsudahq2 */
    case 2685:  /* *fractunsdahq2 */
    case 2684:  /* *fractunsudqhq2 */
    case 2683:  /* *fractunsdqhq2 */
    case 2682:  /* *fractunsusahq2 */
    case 2681:  /* *fractunssahq2 */
    case 2680:  /* *fractunsusqhq2 */
    case 2679:  /* *fractunssqhq2 */
    case 2678:  /* *fractunsuhahq2 */
    case 2677:  /* *fractunshahq2 */
    case 2676:  /* *fractunsuhqhq2 */
    case 2675:  /* *fractunsuqqhq2 */
    case 2674:  /* *fractunsqqhq2 */
    case 2673:  /* *fractunsdiuqq2 */
    case 2672:  /* *fractunssiuqq2 */
    case 2671:  /* *fractunshiuqq2 */
    case 2670:  /* *fractunsqiuqq2 */
    case 2669:  /* *fractunsutauqq2 */
    case 2668:  /* *fractunstauqq2 */
    case 2667:  /* *fractunsudauqq2 */
    case 2666:  /* *fractunsdauqq2 */
    case 2665:  /* *fractunsudquqq2 */
    case 2664:  /* *fractunsdquqq2 */
    case 2663:  /* *fractunsusauqq2 */
    case 2662:  /* *fractunssauqq2 */
    case 2661:  /* *fractunsusquqq2 */
    case 2660:  /* *fractunssquqq2 */
    case 2659:  /* *fractunsuhauqq2 */
    case 2658:  /* *fractunshauqq2 */
    case 2657:  /* *fractunsuhquqq2 */
    case 2656:  /* *fractunshquqq2 */
    case 2655:  /* *fractunsqquqq2 */
    case 2654:  /* *fractunsdiqq2 */
    case 2653:  /* *fractunssiqq2 */
    case 2652:  /* *fractunshiqq2 */
    case 2651:  /* *fractunsqiqq2 */
    case 2650:  /* *fractunsutaqq2 */
    case 2649:  /* *fractunstaqq2 */
    case 2648:  /* *fractunsudaqq2 */
    case 2647:  /* *fractunsdaqq2 */
    case 2646:  /* *fractunsudqqq2 */
    case 2645:  /* *fractunsdqqq2 */
    case 2644:  /* *fractunsusaqq2 */
    case 2643:  /* *fractunssaqq2 */
    case 2642:  /* *fractunsusqqq2 */
    case 2641:  /* *fractunssqqq2 */
    case 2640:  /* *fractunsuhaqq2 */
    case 2639:  /* *fractunshaqq2 */
    case 2638:  /* *fractunsuhqqq2 */
    case 2637:  /* *fractunshqqq2 */
    case 2636:  /* *fractunsuqqqq2 */
    case 2255:  /* *fractsidi2 */
    case 2254:  /* *fracthidi2 */
    case 2253:  /* *fractqidi2 */
    case 2252:  /* *fractutadi2 */
    case 2251:  /* *fracttadi2 */
    case 2250:  /* *fractudadi2 */
    case 2249:  /* *fractdadi2 */
    case 2248:  /* *fractudqdi2 */
    case 2247:  /* *fractdqdi2 */
    case 2246:  /* *fractusadi2 */
    case 2245:  /* *fractsadi2 */
    case 2244:  /* *fractusqdi2 */
    case 2243:  /* *fractsqdi2 */
    case 2242:  /* *fractuhadi2 */
    case 2241:  /* *fracthadi2 */
    case 2240:  /* *fractuhqdi2 */
    case 2239:  /* *fracthqdi2 */
    case 2238:  /* *fractuqqdi2 */
    case 2237:  /* *fractqqdi2 */
    case 2236:  /* *fractdisi2 */
    case 2235:  /* *fracthisi2 */
    case 2234:  /* *fractqisi2 */
    case 2233:  /* *fractutasi2 */
    case 2232:  /* *fracttasi2 */
    case 2231:  /* *fractudasi2 */
    case 2230:  /* *fractdasi2 */
    case 2229:  /* *fractudqsi2 */
    case 2228:  /* *fractdqsi2 */
    case 2227:  /* *fractusasi2 */
    case 2226:  /* *fractsasi2 */
    case 2225:  /* *fractusqsi2 */
    case 2224:  /* *fractsqsi2 */
    case 2223:  /* *fractuhasi2 */
    case 2222:  /* *fracthasi2 */
    case 2221:  /* *fractuhqsi2 */
    case 2220:  /* *fracthqsi2 */
    case 2219:  /* *fractuqqsi2 */
    case 2218:  /* *fractqqsi2 */
    case 2217:  /* *fractdihi2 */
    case 2216:  /* *fractsihi2 */
    case 2215:  /* *fractqihi2 */
    case 2214:  /* *fractutahi2 */
    case 2213:  /* *fracttahi2 */
    case 2212:  /* *fractudahi2 */
    case 2211:  /* *fractdahi2 */
    case 2210:  /* *fractudqhi2 */
    case 2209:  /* *fractdqhi2 */
    case 2208:  /* *fractusahi2 */
    case 2207:  /* *fractsahi2 */
    case 2206:  /* *fractusqhi2 */
    case 2205:  /* *fractsqhi2 */
    case 2204:  /* *fractuhahi2 */
    case 2203:  /* *fracthahi2 */
    case 2202:  /* *fractuhqhi2 */
    case 2201:  /* *fracthqhi2 */
    case 2200:  /* *fractuqqhi2 */
    case 2199:  /* *fractqqhi2 */
    case 2198:  /* *fractdiqi2 */
    case 2197:  /* *fractsiqi2 */
    case 2196:  /* *fracthiqi2 */
    case 2195:  /* *fractutaqi2 */
    case 2194:  /* *fracttaqi2 */
    case 2193:  /* *fractudaqi2 */
    case 2192:  /* *fractdaqi2 */
    case 2191:  /* *fractudqqi2 */
    case 2190:  /* *fractdqqi2 */
    case 2189:  /* *fractusaqi2 */
    case 2188:  /* *fractsaqi2 */
    case 2187:  /* *fractusqqi2 */
    case 2186:  /* *fractsqqi2 */
    case 2185:  /* *fractuhaqi2 */
    case 2184:  /* *fracthaqi2 */
    case 2183:  /* *fractuhqqi2 */
    case 2182:  /* *fracthqqi2 */
    case 2181:  /* *fractuqqqi2 */
    case 2180:  /* *fractqqqi2 */
    case 2179:  /* *fractdiuta2 */
    case 2178:  /* *fractsiuta2 */
    case 2177:  /* *fracthiuta2 */
    case 2176:  /* *fractqiuta2 */
    case 2175:  /* *fracttauta2 */
    case 2174:  /* *fractudauta2 */
    case 2173:  /* *fractdauta2 */
    case 2172:  /* *fractudquta2 */
    case 2171:  /* *fractdquta2 */
    case 2170:  /* *fractusauta2 */
    case 2169:  /* *fractsauta2 */
    case 2168:  /* *fractusquta2 */
    case 2167:  /* *fractsquta2 */
    case 2166:  /* *fractuhauta2 */
    case 2165:  /* *fracthauta2 */
    case 2164:  /* *fractuhquta2 */
    case 2163:  /* *fracthquta2 */
    case 2162:  /* *fractuqquta2 */
    case 2161:  /* *fractqquta2 */
    case 2160:  /* *fractdita2 */
    case 2159:  /* *fractsita2 */
    case 2158:  /* *fracthita2 */
    case 2157:  /* *fractqita2 */
    case 2156:  /* *fractutata2 */
    case 2155:  /* *fractudata2 */
    case 2154:  /* *fractdata2 */
    case 2153:  /* *fractudqta2 */
    case 2152:  /* *fractdqta2 */
    case 2151:  /* *fractusata2 */
    case 2150:  /* *fractsata2 */
    case 2149:  /* *fractusqta2 */
    case 2148:  /* *fractsqta2 */
    case 2147:  /* *fractuhata2 */
    case 2146:  /* *fracthata2 */
    case 2145:  /* *fractuhqta2 */
    case 2144:  /* *fracthqta2 */
    case 2143:  /* *fractuqqta2 */
    case 2142:  /* *fractqqta2 */
    case 2141:  /* *fractdiuda2 */
    case 2140:  /* *fractsiuda2 */
    case 2139:  /* *fracthiuda2 */
    case 2138:  /* *fractqiuda2 */
    case 2137:  /* *fractutauda2 */
    case 2136:  /* *fracttauda2 */
    case 2135:  /* *fractdauda2 */
    case 2134:  /* *fractudquda2 */
    case 2133:  /* *fractdquda2 */
    case 2132:  /* *fractusauda2 */
    case 2131:  /* *fractsauda2 */
    case 2130:  /* *fractusquda2 */
    case 2129:  /* *fractsquda2 */
    case 2128:  /* *fractuhauda2 */
    case 2127:  /* *fracthauda2 */
    case 2126:  /* *fractuhquda2 */
    case 2125:  /* *fracthquda2 */
    case 2124:  /* *fractuqquda2 */
    case 2123:  /* *fractqquda2 */
    case 2122:  /* *fractdida2 */
    case 2121:  /* *fractsida2 */
    case 2120:  /* *fracthida2 */
    case 2119:  /* *fractqida2 */
    case 2118:  /* *fractutada2 */
    case 2117:  /* *fracttada2 */
    case 2116:  /* *fractudada2 */
    case 2115:  /* *fractudqda2 */
    case 2114:  /* *fractdqda2 */
    case 2113:  /* *fractusada2 */
    case 2112:  /* *fractsada2 */
    case 2111:  /* *fractusqda2 */
    case 2110:  /* *fractsqda2 */
    case 2109:  /* *fractuhada2 */
    case 2108:  /* *fracthada2 */
    case 2107:  /* *fractuhqda2 */
    case 2106:  /* *fracthqda2 */
    case 2105:  /* *fractuqqda2 */
    case 2104:  /* *fractqqda2 */
    case 2103:  /* *fractdiudq2 */
    case 2102:  /* *fractsiudq2 */
    case 2101:  /* *fracthiudq2 */
    case 2100:  /* *fractqiudq2 */
    case 2099:  /* *fractutaudq2 */
    case 2098:  /* *fracttaudq2 */
    case 2097:  /* *fractudaudq2 */
    case 2096:  /* *fractdaudq2 */
    case 2095:  /* *fractdqudq2 */
    case 2094:  /* *fractusaudq2 */
    case 2093:  /* *fractsaudq2 */
    case 2092:  /* *fractusqudq2 */
    case 2091:  /* *fractsqudq2 */
    case 2090:  /* *fractuhaudq2 */
    case 2089:  /* *fracthaudq2 */
    case 2088:  /* *fractuhqudq2 */
    case 2087:  /* *fracthqudq2 */
    case 2086:  /* *fractuqqudq2 */
    case 2085:  /* *fractqqudq2 */
    case 2084:  /* *fractdidq2 */
    case 2083:  /* *fractsidq2 */
    case 2082:  /* *fracthidq2 */
    case 2081:  /* *fractqidq2 */
    case 2080:  /* *fractutadq2 */
    case 2079:  /* *fracttadq2 */
    case 2078:  /* *fractudadq2 */
    case 2077:  /* *fractdadq2 */
    case 2076:  /* *fractudqdq2 */
    case 2075:  /* *fractusadq2 */
    case 2074:  /* *fractsadq2 */
    case 2073:  /* *fractusqdq2 */
    case 2072:  /* *fractsqdq2 */
    case 2071:  /* *fractuhadq2 */
    case 2070:  /* *fracthadq2 */
    case 2069:  /* *fractuhqdq2 */
    case 2068:  /* *fracthqdq2 */
    case 2067:  /* *fractuqqdq2 */
    case 2066:  /* *fractqqdq2 */
    case 2065:  /* *fractdiusa2 */
    case 2064:  /* *fractsiusa2 */
    case 2063:  /* *fracthiusa2 */
    case 2062:  /* *fractqiusa2 */
    case 2061:  /* *fractutausa2 */
    case 2060:  /* *fracttausa2 */
    case 2059:  /* *fractudausa2 */
    case 2058:  /* *fractdausa2 */
    case 2057:  /* *fractudqusa2 */
    case 2056:  /* *fractdqusa2 */
    case 2055:  /* *fractsausa2 */
    case 2054:  /* *fractusqusa2 */
    case 2053:  /* *fractsqusa2 */
    case 2052:  /* *fractuhausa2 */
    case 2051:  /* *fracthausa2 */
    case 2050:  /* *fractuhqusa2 */
    case 2049:  /* *fracthqusa2 */
    case 2048:  /* *fractuqqusa2 */
    case 2047:  /* *fractqqusa2 */
    case 2046:  /* *fractdisa2 */
    case 2045:  /* *fractsisa2 */
    case 2044:  /* *fracthisa2 */
    case 2043:  /* *fractqisa2 */
    case 2042:  /* *fractutasa2 */
    case 2041:  /* *fracttasa2 */
    case 2040:  /* *fractudasa2 */
    case 2039:  /* *fractdasa2 */
    case 2038:  /* *fractudqsa2 */
    case 2037:  /* *fractdqsa2 */
    case 2036:  /* *fractusasa2 */
    case 2035:  /* *fractusqsa2 */
    case 2034:  /* *fractsqsa2 */
    case 2033:  /* *fractuhasa2 */
    case 2032:  /* *fracthasa2 */
    case 2031:  /* *fractuhqsa2 */
    case 2030:  /* *fracthqsa2 */
    case 2029:  /* *fractuqqsa2 */
    case 2028:  /* *fractqqsa2 */
    case 2027:  /* *fractdiusq2 */
    case 2026:  /* *fractsiusq2 */
    case 2025:  /* *fracthiusq2 */
    case 2024:  /* *fractqiusq2 */
    case 2023:  /* *fractutausq2 */
    case 2022:  /* *fracttausq2 */
    case 2021:  /* *fractudausq2 */
    case 2020:  /* *fractdausq2 */
    case 2019:  /* *fractudqusq2 */
    case 2018:  /* *fractdqusq2 */
    case 2017:  /* *fractusausq2 */
    case 2016:  /* *fractsausq2 */
    case 2015:  /* *fractsqusq2 */
    case 2014:  /* *fractuhausq2 */
    case 2013:  /* *fracthausq2 */
    case 2012:  /* *fractuhqusq2 */
    case 2011:  /* *fracthqusq2 */
    case 2010:  /* *fractuqqusq2 */
    case 2009:  /* *fractqqusq2 */
    case 2008:  /* *fractdisq2 */
    case 2007:  /* *fractsisq2 */
    case 2006:  /* *fracthisq2 */
    case 2005:  /* *fractqisq2 */
    case 2004:  /* *fractutasq2 */
    case 2003:  /* *fracttasq2 */
    case 2002:  /* *fractudasq2 */
    case 2001:  /* *fractdasq2 */
    case 2000:  /* *fractudqsq2 */
    case 1999:  /* *fractdqsq2 */
    case 1998:  /* *fractusasq2 */
    case 1997:  /* *fractsasq2 */
    case 1996:  /* *fractusqsq2 */
    case 1995:  /* *fractuhasq2 */
    case 1994:  /* *fracthasq2 */
    case 1993:  /* *fractuhqsq2 */
    case 1992:  /* *fracthqsq2 */
    case 1991:  /* *fractuqqsq2 */
    case 1990:  /* *fractqqsq2 */
    case 1989:  /* *fractdiuha2 */
    case 1988:  /* *fractsiuha2 */
    case 1987:  /* *fracthiuha2 */
    case 1986:  /* *fractqiuha2 */
    case 1985:  /* *fractutauha2 */
    case 1984:  /* *fracttauha2 */
    case 1983:  /* *fractudauha2 */
    case 1982:  /* *fractdauha2 */
    case 1981:  /* *fractudquha2 */
    case 1980:  /* *fractdquha2 */
    case 1979:  /* *fractusauha2 */
    case 1978:  /* *fractsauha2 */
    case 1977:  /* *fractusquha2 */
    case 1976:  /* *fractsquha2 */
    case 1975:  /* *fracthauha2 */
    case 1974:  /* *fractuhquha2 */
    case 1973:  /* *fracthquha2 */
    case 1972:  /* *fractuqquha2 */
    case 1971:  /* *fractqquha2 */
    case 1970:  /* *fractdiha2 */
    case 1969:  /* *fractsiha2 */
    case 1968:  /* *fracthiha2 */
    case 1967:  /* *fractqiha2 */
    case 1966:  /* *fractutaha2 */
    case 1965:  /* *fracttaha2 */
    case 1964:  /* *fractudaha2 */
    case 1963:  /* *fractdaha2 */
    case 1962:  /* *fractudqha2 */
    case 1961:  /* *fractdqha2 */
    case 1960:  /* *fractusaha2 */
    case 1959:  /* *fractsaha2 */
    case 1958:  /* *fractusqha2 */
    case 1957:  /* *fractsqha2 */
    case 1956:  /* *fractuhaha2 */
    case 1955:  /* *fractuhqha2 */
    case 1954:  /* *fracthqha2 */
    case 1953:  /* *fractuqqha2 */
    case 1952:  /* *fractqqha2 */
    case 1951:  /* *fractdiuhq2 */
    case 1950:  /* *fractsiuhq2 */
    case 1949:  /* *fracthiuhq2 */
    case 1948:  /* *fractqiuhq2 */
    case 1947:  /* *fractutauhq2 */
    case 1946:  /* *fracttauhq2 */
    case 1945:  /* *fractudauhq2 */
    case 1944:  /* *fractdauhq2 */
    case 1943:  /* *fractudquhq2 */
    case 1942:  /* *fractdquhq2 */
    case 1941:  /* *fractusauhq2 */
    case 1940:  /* *fractsauhq2 */
    case 1939:  /* *fractusquhq2 */
    case 1938:  /* *fractsquhq2 */
    case 1937:  /* *fractuhauhq2 */
    case 1936:  /* *fracthauhq2 */
    case 1935:  /* *fracthquhq2 */
    case 1934:  /* *fractuqquhq2 */
    case 1933:  /* *fractqquhq2 */
    case 1932:  /* *fractdihq2 */
    case 1931:  /* *fractsihq2 */
    case 1930:  /* *fracthihq2 */
    case 1929:  /* *fractqihq2 */
    case 1928:  /* *fractutahq2 */
    case 1927:  /* *fracttahq2 */
    case 1926:  /* *fractudahq2 */
    case 1925:  /* *fractdahq2 */
    case 1924:  /* *fractudqhq2 */
    case 1923:  /* *fractdqhq2 */
    case 1922:  /* *fractusahq2 */
    case 1921:  /* *fractsahq2 */
    case 1920:  /* *fractusqhq2 */
    case 1919:  /* *fractsqhq2 */
    case 1918:  /* *fractuhahq2 */
    case 1917:  /* *fracthahq2 */
    case 1916:  /* *fractuhqhq2 */
    case 1915:  /* *fractuqqhq2 */
    case 1914:  /* *fractqqhq2 */
    case 1913:  /* *fractdiuqq2 */
    case 1912:  /* *fractsiuqq2 */
    case 1911:  /* *fracthiuqq2 */
    case 1910:  /* *fractqiuqq2 */
    case 1909:  /* *fractutauqq2 */
    case 1908:  /* *fracttauqq2 */
    case 1907:  /* *fractudauqq2 */
    case 1906:  /* *fractdauqq2 */
    case 1905:  /* *fractudquqq2 */
    case 1904:  /* *fractdquqq2 */
    case 1903:  /* *fractusauqq2 */
    case 1902:  /* *fractsauqq2 */
    case 1901:  /* *fractusquqq2 */
    case 1900:  /* *fractsquqq2 */
    case 1899:  /* *fractuhauqq2 */
    case 1898:  /* *fracthauqq2 */
    case 1897:  /* *fractuhquqq2 */
    case 1896:  /* *fracthquqq2 */
    case 1895:  /* *fractqquqq2 */
    case 1894:  /* *fractdiqq2 */
    case 1893:  /* *fractsiqq2 */
    case 1892:  /* *fracthiqq2 */
    case 1891:  /* *fractqiqq2 */
    case 1890:  /* *fractutaqq2 */
    case 1889:  /* *fracttaqq2 */
    case 1888:  /* *fractudaqq2 */
    case 1887:  /* *fractdaqq2 */
    case 1886:  /* *fractudqqq2 */
    case 1885:  /* *fractdqqq2 */
    case 1884:  /* *fractusaqq2 */
    case 1883:  /* *fractsaqq2 */
    case 1882:  /* *fractusqqq2 */
    case 1881:  /* *fractsqqq2 */
    case 1880:  /* *fractuhaqq2 */
    case 1879:  /* *fracthaqq2 */
    case 1878:  /* *fractuhqqq2 */
    case 1877:  /* *fracthqqq2 */
    case 1876:  /* *fractuqqqq2 */
    case 1024:  /* *parityqihi2.2 */
    case 1022:  /* *parityhi2 */
    case 817:  /* *extendpsisi2 */
    case 815:  /* *extendhisi2 */
    case 813:  /* *extendhipsi2 */
    case 811:  /* *extendqisi2 */
    case 809:  /* *extendqipsi2 */
    case 807:  /* *extendqihi2 */
    case 805:  /* *one_cmplsi2 */
    case 803:  /* *one_cmplpsi2 */
    case 801:  /* *one_cmplhi2 */
    case 799:  /* *one_cmplqi2 */
    case 797:  /* *negsf2 */
    case 795:  /* *negsi2 */
    case 792:  /* *negpsi2 */
    case 790:  /* *neghi2 */
    case 786:  /* *negqi2 */
    case 784:  /* *abssf2 */
    case 782:  /* *absqi2 */
    case 655:  /* *rotlsi2.31 */
    case 653:  /* *rotlsi2.1 */
    case 651:  /* *rotlpsi2.23 */
    case 649:  /* *rotlpsi2.1 */
    case 647:  /* *rotlhi2.15 */
    case 645:  /* *rotlhi2.1 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      break;

    case 3058:  /* ssabsqq2 */
    case 3056:  /* ssnegqq2 */
    case 2635:  /* fractunssidi2 */
    case 2634:  /* fractunshidi2 */
    case 2633:  /* fractunsqidi2 */
    case 2632:  /* fractunsutadi2 */
    case 2631:  /* fractunstadi2 */
    case 2630:  /* fractunsudadi2 */
    case 2629:  /* fractunsdadi2 */
    case 2628:  /* fractunsudqdi2 */
    case 2627:  /* fractunsdqdi2 */
    case 2626:  /* fractunsusadi2 */
    case 2625:  /* fractunssadi2 */
    case 2624:  /* fractunsusqdi2 */
    case 2623:  /* fractunssqdi2 */
    case 2622:  /* fractunsuhadi2 */
    case 2621:  /* fractunshadi2 */
    case 2620:  /* fractunsuhqdi2 */
    case 2619:  /* fractunshqdi2 */
    case 2618:  /* fractunsuqqdi2 */
    case 2617:  /* fractunsqqdi2 */
    case 2616:  /* fractunsdisi2 */
    case 2615:  /* fractunshisi2 */
    case 2614:  /* fractunsqisi2 */
    case 2613:  /* fractunsutasi2 */
    case 2612:  /* fractunstasi2 */
    case 2611:  /* fractunsudasi2 */
    case 2610:  /* fractunsdasi2 */
    case 2609:  /* fractunsudqsi2 */
    case 2608:  /* fractunsdqsi2 */
    case 2607:  /* fractunsusasi2 */
    case 2606:  /* fractunssasi2 */
    case 2605:  /* fractunsusqsi2 */
    case 2604:  /* fractunssqsi2 */
    case 2603:  /* fractunsuhasi2 */
    case 2602:  /* fractunshasi2 */
    case 2601:  /* fractunsuhqsi2 */
    case 2600:  /* fractunshqsi2 */
    case 2599:  /* fractunsuqqsi2 */
    case 2598:  /* fractunsqqsi2 */
    case 2597:  /* fractunsdihi2 */
    case 2596:  /* fractunssihi2 */
    case 2595:  /* fractunsqihi2 */
    case 2594:  /* fractunsutahi2 */
    case 2593:  /* fractunstahi2 */
    case 2592:  /* fractunsudahi2 */
    case 2591:  /* fractunsdahi2 */
    case 2590:  /* fractunsudqhi2 */
    case 2589:  /* fractunsdqhi2 */
    case 2588:  /* fractunsusahi2 */
    case 2587:  /* fractunssahi2 */
    case 2586:  /* fractunsusqhi2 */
    case 2585:  /* fractunssqhi2 */
    case 2584:  /* fractunsuhahi2 */
    case 2583:  /* fractunshahi2 */
    case 2582:  /* fractunsuhqhi2 */
    case 2581:  /* fractunshqhi2 */
    case 2580:  /* fractunsuqqhi2 */
    case 2579:  /* fractunsqqhi2 */
    case 2578:  /* fractunsdiqi2 */
    case 2577:  /* fractunssiqi2 */
    case 2576:  /* fractunshiqi2 */
    case 2575:  /* fractunsutaqi2 */
    case 2574:  /* fractunstaqi2 */
    case 2573:  /* fractunsudaqi2 */
    case 2572:  /* fractunsdaqi2 */
    case 2571:  /* fractunsudqqi2 */
    case 2570:  /* fractunsdqqi2 */
    case 2569:  /* fractunsusaqi2 */
    case 2568:  /* fractunssaqi2 */
    case 2567:  /* fractunsusqqi2 */
    case 2566:  /* fractunssqqi2 */
    case 2565:  /* fractunsuhaqi2 */
    case 2564:  /* fractunshaqi2 */
    case 2563:  /* fractunsuhqqi2 */
    case 2562:  /* fractunshqqi2 */
    case 2561:  /* fractunsuqqqi2 */
    case 2560:  /* fractunsqqqi2 */
    case 2559:  /* fractunsdiuta2 */
    case 2558:  /* fractunssiuta2 */
    case 2557:  /* fractunshiuta2 */
    case 2556:  /* fractunsqiuta2 */
    case 2555:  /* fractunstauta2 */
    case 2554:  /* fractunsudauta2 */
    case 2553:  /* fractunsdauta2 */
    case 2552:  /* fractunsudquta2 */
    case 2551:  /* fractunsdquta2 */
    case 2550:  /* fractunsusauta2 */
    case 2549:  /* fractunssauta2 */
    case 2548:  /* fractunsusquta2 */
    case 2547:  /* fractunssquta2 */
    case 2546:  /* fractunsuhauta2 */
    case 2545:  /* fractunshauta2 */
    case 2544:  /* fractunsuhquta2 */
    case 2543:  /* fractunshquta2 */
    case 2542:  /* fractunsuqquta2 */
    case 2541:  /* fractunsqquta2 */
    case 2540:  /* fractunsdita2 */
    case 2539:  /* fractunssita2 */
    case 2538:  /* fractunshita2 */
    case 2537:  /* fractunsqita2 */
    case 2536:  /* fractunsutata2 */
    case 2535:  /* fractunsudata2 */
    case 2534:  /* fractunsdata2 */
    case 2533:  /* fractunsudqta2 */
    case 2532:  /* fractunsdqta2 */
    case 2531:  /* fractunsusata2 */
    case 2530:  /* fractunssata2 */
    case 2529:  /* fractunsusqta2 */
    case 2528:  /* fractunssqta2 */
    case 2527:  /* fractunsuhata2 */
    case 2526:  /* fractunshata2 */
    case 2525:  /* fractunsuhqta2 */
    case 2524:  /* fractunshqta2 */
    case 2523:  /* fractunsuqqta2 */
    case 2522:  /* fractunsqqta2 */
    case 2521:  /* fractunsdiuda2 */
    case 2520:  /* fractunssiuda2 */
    case 2519:  /* fractunshiuda2 */
    case 2518:  /* fractunsqiuda2 */
    case 2517:  /* fractunsutauda2 */
    case 2516:  /* fractunstauda2 */
    case 2515:  /* fractunsdauda2 */
    case 2514:  /* fractunsudquda2 */
    case 2513:  /* fractunsdquda2 */
    case 2512:  /* fractunsusauda2 */
    case 2511:  /* fractunssauda2 */
    case 2510:  /* fractunsusquda2 */
    case 2509:  /* fractunssquda2 */
    case 2508:  /* fractunsuhauda2 */
    case 2507:  /* fractunshauda2 */
    case 2506:  /* fractunsuhquda2 */
    case 2505:  /* fractunshquda2 */
    case 2504:  /* fractunsuqquda2 */
    case 2503:  /* fractunsqquda2 */
    case 2502:  /* fractunsdida2 */
    case 2501:  /* fractunssida2 */
    case 2500:  /* fractunshida2 */
    case 2499:  /* fractunsqida2 */
    case 2498:  /* fractunsutada2 */
    case 2497:  /* fractunstada2 */
    case 2496:  /* fractunsudada2 */
    case 2495:  /* fractunsudqda2 */
    case 2494:  /* fractunsdqda2 */
    case 2493:  /* fractunsusada2 */
    case 2492:  /* fractunssada2 */
    case 2491:  /* fractunsusqda2 */
    case 2490:  /* fractunssqda2 */
    case 2489:  /* fractunsuhada2 */
    case 2488:  /* fractunshada2 */
    case 2487:  /* fractunsuhqda2 */
    case 2486:  /* fractunshqda2 */
    case 2485:  /* fractunsuqqda2 */
    case 2484:  /* fractunsqqda2 */
    case 2483:  /* fractunsdiudq2 */
    case 2482:  /* fractunssiudq2 */
    case 2481:  /* fractunshiudq2 */
    case 2480:  /* fractunsqiudq2 */
    case 2479:  /* fractunsutaudq2 */
    case 2478:  /* fractunstaudq2 */
    case 2477:  /* fractunsudaudq2 */
    case 2476:  /* fractunsdaudq2 */
    case 2475:  /* fractunsdqudq2 */
    case 2474:  /* fractunsusaudq2 */
    case 2473:  /* fractunssaudq2 */
    case 2472:  /* fractunsusqudq2 */
    case 2471:  /* fractunssqudq2 */
    case 2470:  /* fractunsuhaudq2 */
    case 2469:  /* fractunshaudq2 */
    case 2468:  /* fractunsuhqudq2 */
    case 2467:  /* fractunshqudq2 */
    case 2466:  /* fractunsuqqudq2 */
    case 2465:  /* fractunsqqudq2 */
    case 2464:  /* fractunsdidq2 */
    case 2463:  /* fractunssidq2 */
    case 2462:  /* fractunshidq2 */
    case 2461:  /* fractunsqidq2 */
    case 2460:  /* fractunsutadq2 */
    case 2459:  /* fractunstadq2 */
    case 2458:  /* fractunsudadq2 */
    case 2457:  /* fractunsdadq2 */
    case 2456:  /* fractunsudqdq2 */
    case 2455:  /* fractunsusadq2 */
    case 2454:  /* fractunssadq2 */
    case 2453:  /* fractunsusqdq2 */
    case 2452:  /* fractunssqdq2 */
    case 2451:  /* fractunsuhadq2 */
    case 2450:  /* fractunshadq2 */
    case 2449:  /* fractunsuhqdq2 */
    case 2448:  /* fractunshqdq2 */
    case 2447:  /* fractunsuqqdq2 */
    case 2446:  /* fractunsqqdq2 */
    case 2445:  /* fractunsdiusa2 */
    case 2444:  /* fractunssiusa2 */
    case 2443:  /* fractunshiusa2 */
    case 2442:  /* fractunsqiusa2 */
    case 2441:  /* fractunsutausa2 */
    case 2440:  /* fractunstausa2 */
    case 2439:  /* fractunsudausa2 */
    case 2438:  /* fractunsdausa2 */
    case 2437:  /* fractunsudqusa2 */
    case 2436:  /* fractunsdqusa2 */
    case 2435:  /* fractunssausa2 */
    case 2434:  /* fractunsusqusa2 */
    case 2433:  /* fractunssqusa2 */
    case 2432:  /* fractunsuhausa2 */
    case 2431:  /* fractunshausa2 */
    case 2430:  /* fractunsuhqusa2 */
    case 2429:  /* fractunshqusa2 */
    case 2428:  /* fractunsuqqusa2 */
    case 2427:  /* fractunsqqusa2 */
    case 2426:  /* fractunsdisa2 */
    case 2425:  /* fractunssisa2 */
    case 2424:  /* fractunshisa2 */
    case 2423:  /* fractunsqisa2 */
    case 2422:  /* fractunsutasa2 */
    case 2421:  /* fractunstasa2 */
    case 2420:  /* fractunsudasa2 */
    case 2419:  /* fractunsdasa2 */
    case 2418:  /* fractunsudqsa2 */
    case 2417:  /* fractunsdqsa2 */
    case 2416:  /* fractunsusasa2 */
    case 2415:  /* fractunsusqsa2 */
    case 2414:  /* fractunssqsa2 */
    case 2413:  /* fractunsuhasa2 */
    case 2412:  /* fractunshasa2 */
    case 2411:  /* fractunsuhqsa2 */
    case 2410:  /* fractunshqsa2 */
    case 2409:  /* fractunsuqqsa2 */
    case 2408:  /* fractunsqqsa2 */
    case 2407:  /* fractunsdiusq2 */
    case 2406:  /* fractunssiusq2 */
    case 2405:  /* fractunshiusq2 */
    case 2404:  /* fractunsqiusq2 */
    case 2403:  /* fractunsutausq2 */
    case 2402:  /* fractunstausq2 */
    case 2401:  /* fractunsudausq2 */
    case 2400:  /* fractunsdausq2 */
    case 2399:  /* fractunsudqusq2 */
    case 2398:  /* fractunsdqusq2 */
    case 2397:  /* fractunsusausq2 */
    case 2396:  /* fractunssausq2 */
    case 2395:  /* fractunssqusq2 */
    case 2394:  /* fractunsuhausq2 */
    case 2393:  /* fractunshausq2 */
    case 2392:  /* fractunsuhqusq2 */
    case 2391:  /* fractunshqusq2 */
    case 2390:  /* fractunsuqqusq2 */
    case 2389:  /* fractunsqqusq2 */
    case 2388:  /* fractunsdisq2 */
    case 2387:  /* fractunssisq2 */
    case 2386:  /* fractunshisq2 */
    case 2385:  /* fractunsqisq2 */
    case 2384:  /* fractunsutasq2 */
    case 2383:  /* fractunstasq2 */
    case 2382:  /* fractunsudasq2 */
    case 2381:  /* fractunsdasq2 */
    case 2380:  /* fractunsudqsq2 */
    case 2379:  /* fractunsdqsq2 */
    case 2378:  /* fractunsusasq2 */
    case 2377:  /* fractunssasq2 */
    case 2376:  /* fractunsusqsq2 */
    case 2375:  /* fractunsuhasq2 */
    case 2374:  /* fractunshasq2 */
    case 2373:  /* fractunsuhqsq2 */
    case 2372:  /* fractunshqsq2 */
    case 2371:  /* fractunsuqqsq2 */
    case 2370:  /* fractunsqqsq2 */
    case 2369:  /* fractunsdiuha2 */
    case 2368:  /* fractunssiuha2 */
    case 2367:  /* fractunshiuha2 */
    case 2366:  /* fractunsqiuha2 */
    case 2365:  /* fractunsutauha2 */
    case 2364:  /* fractunstauha2 */
    case 2363:  /* fractunsudauha2 */
    case 2362:  /* fractunsdauha2 */
    case 2361:  /* fractunsudquha2 */
    case 2360:  /* fractunsdquha2 */
    case 2359:  /* fractunsusauha2 */
    case 2358:  /* fractunssauha2 */
    case 2357:  /* fractunsusquha2 */
    case 2356:  /* fractunssquha2 */
    case 2355:  /* fractunshauha2 */
    case 2354:  /* fractunsuhquha2 */
    case 2353:  /* fractunshquha2 */
    case 2352:  /* fractunsuqquha2 */
    case 2351:  /* fractunsqquha2 */
    case 2350:  /* fractunsdiha2 */
    case 2349:  /* fractunssiha2 */
    case 2348:  /* fractunshiha2 */
    case 2347:  /* fractunsqiha2 */
    case 2346:  /* fractunsutaha2 */
    case 2345:  /* fractunstaha2 */
    case 2344:  /* fractunsudaha2 */
    case 2343:  /* fractunsdaha2 */
    case 2342:  /* fractunsudqha2 */
    case 2341:  /* fractunsdqha2 */
    case 2340:  /* fractunsusaha2 */
    case 2339:  /* fractunssaha2 */
    case 2338:  /* fractunsusqha2 */
    case 2337:  /* fractunssqha2 */
    case 2336:  /* fractunsuhaha2 */
    case 2335:  /* fractunsuhqha2 */
    case 2334:  /* fractunshqha2 */
    case 2333:  /* fractunsuqqha2 */
    case 2332:  /* fractunsqqha2 */
    case 2331:  /* fractunsdiuhq2 */
    case 2330:  /* fractunssiuhq2 */
    case 2329:  /* fractunshiuhq2 */
    case 2328:  /* fractunsqiuhq2 */
    case 2327:  /* fractunsutauhq2 */
    case 2326:  /* fractunstauhq2 */
    case 2325:  /* fractunsudauhq2 */
    case 2324:  /* fractunsdauhq2 */
    case 2323:  /* fractunsudquhq2 */
    case 2322:  /* fractunsdquhq2 */
    case 2321:  /* fractunsusauhq2 */
    case 2320:  /* fractunssauhq2 */
    case 2319:  /* fractunsusquhq2 */
    case 2318:  /* fractunssquhq2 */
    case 2317:  /* fractunsuhauhq2 */
    case 2316:  /* fractunshauhq2 */
    case 2315:  /* fractunshquhq2 */
    case 2314:  /* fractunsuqquhq2 */
    case 2313:  /* fractunsqquhq2 */
    case 2312:  /* fractunsdihq2 */
    case 2311:  /* fractunssihq2 */
    case 2310:  /* fractunshihq2 */
    case 2309:  /* fractunsqihq2 */
    case 2308:  /* fractunsutahq2 */
    case 2307:  /* fractunstahq2 */
    case 2306:  /* fractunsudahq2 */
    case 2305:  /* fractunsdahq2 */
    case 2304:  /* fractunsudqhq2 */
    case 2303:  /* fractunsdqhq2 */
    case 2302:  /* fractunsusahq2 */
    case 2301:  /* fractunssahq2 */
    case 2300:  /* fractunsusqhq2 */
    case 2299:  /* fractunssqhq2 */
    case 2298:  /* fractunsuhahq2 */
    case 2297:  /* fractunshahq2 */
    case 2296:  /* fractunsuhqhq2 */
    case 2295:  /* fractunsuqqhq2 */
    case 2294:  /* fractunsqqhq2 */
    case 2293:  /* fractunsdiuqq2 */
    case 2292:  /* fractunssiuqq2 */
    case 2291:  /* fractunshiuqq2 */
    case 2290:  /* fractunsqiuqq2 */
    case 2289:  /* fractunsutauqq2 */
    case 2288:  /* fractunstauqq2 */
    case 2287:  /* fractunsudauqq2 */
    case 2286:  /* fractunsdauqq2 */
    case 2285:  /* fractunsudquqq2 */
    case 2284:  /* fractunsdquqq2 */
    case 2283:  /* fractunsusauqq2 */
    case 2282:  /* fractunssauqq2 */
    case 2281:  /* fractunsusquqq2 */
    case 2280:  /* fractunssquqq2 */
    case 2279:  /* fractunsuhauqq2 */
    case 2278:  /* fractunshauqq2 */
    case 2277:  /* fractunsuhquqq2 */
    case 2276:  /* fractunshquqq2 */
    case 2275:  /* fractunsqquqq2 */
    case 2274:  /* fractunsdiqq2 */
    case 2273:  /* fractunssiqq2 */
    case 2272:  /* fractunshiqq2 */
    case 2271:  /* fractunsqiqq2 */
    case 2270:  /* fractunsutaqq2 */
    case 2269:  /* fractunstaqq2 */
    case 2268:  /* fractunsudaqq2 */
    case 2267:  /* fractunsdaqq2 */
    case 2266:  /* fractunsudqqq2 */
    case 2265:  /* fractunsdqqq2 */
    case 2264:  /* fractunsusaqq2 */
    case 2263:  /* fractunssaqq2 */
    case 2262:  /* fractunsusqqq2 */
    case 2261:  /* fractunssqqq2 */
    case 2260:  /* fractunsuhaqq2 */
    case 2259:  /* fractunshaqq2 */
    case 2258:  /* fractunsuhqqq2 */
    case 2257:  /* fractunshqqq2 */
    case 2256:  /* fractunsuqqqq2 */
    case 1875:  /* fractsidi2 */
    case 1874:  /* fracthidi2 */
    case 1873:  /* fractqidi2 */
    case 1872:  /* fractutadi2 */
    case 1871:  /* fracttadi2 */
    case 1870:  /* fractudadi2 */
    case 1869:  /* fractdadi2 */
    case 1868:  /* fractudqdi2 */
    case 1867:  /* fractdqdi2 */
    case 1866:  /* fractusadi2 */
    case 1865:  /* fractsadi2 */
    case 1864:  /* fractusqdi2 */
    case 1863:  /* fractsqdi2 */
    case 1862:  /* fractuhadi2 */
    case 1861:  /* fracthadi2 */
    case 1860:  /* fractuhqdi2 */
    case 1859:  /* fracthqdi2 */
    case 1858:  /* fractuqqdi2 */
    case 1857:  /* fractqqdi2 */
    case 1856:  /* fractdisi2 */
    case 1855:  /* fracthisi2 */
    case 1854:  /* fractqisi2 */
    case 1853:  /* fractutasi2 */
    case 1852:  /* fracttasi2 */
    case 1851:  /* fractudasi2 */
    case 1850:  /* fractdasi2 */
    case 1849:  /* fractudqsi2 */
    case 1848:  /* fractdqsi2 */
    case 1847:  /* fractusasi2 */
    case 1846:  /* fractsasi2 */
    case 1845:  /* fractusqsi2 */
    case 1844:  /* fractsqsi2 */
    case 1843:  /* fractuhasi2 */
    case 1842:  /* fracthasi2 */
    case 1841:  /* fractuhqsi2 */
    case 1840:  /* fracthqsi2 */
    case 1839:  /* fractuqqsi2 */
    case 1838:  /* fractqqsi2 */
    case 1837:  /* fractdihi2 */
    case 1836:  /* fractsihi2 */
    case 1835:  /* fractqihi2 */
    case 1834:  /* fractutahi2 */
    case 1833:  /* fracttahi2 */
    case 1832:  /* fractudahi2 */
    case 1831:  /* fractdahi2 */
    case 1830:  /* fractudqhi2 */
    case 1829:  /* fractdqhi2 */
    case 1828:  /* fractusahi2 */
    case 1827:  /* fractsahi2 */
    case 1826:  /* fractusqhi2 */
    case 1825:  /* fractsqhi2 */
    case 1824:  /* fractuhahi2 */
    case 1823:  /* fracthahi2 */
    case 1822:  /* fractuhqhi2 */
    case 1821:  /* fracthqhi2 */
    case 1820:  /* fractuqqhi2 */
    case 1819:  /* fractqqhi2 */
    case 1818:  /* fractdiqi2 */
    case 1817:  /* fractsiqi2 */
    case 1816:  /* fracthiqi2 */
    case 1815:  /* fractutaqi2 */
    case 1814:  /* fracttaqi2 */
    case 1813:  /* fractudaqi2 */
    case 1812:  /* fractdaqi2 */
    case 1811:  /* fractudqqi2 */
    case 1810:  /* fractdqqi2 */
    case 1809:  /* fractusaqi2 */
    case 1808:  /* fractsaqi2 */
    case 1807:  /* fractusqqi2 */
    case 1806:  /* fractsqqi2 */
    case 1805:  /* fractuhaqi2 */
    case 1804:  /* fracthaqi2 */
    case 1803:  /* fractuhqqi2 */
    case 1802:  /* fracthqqi2 */
    case 1801:  /* fractuqqqi2 */
    case 1800:  /* fractqqqi2 */
    case 1799:  /* fractdiuta2 */
    case 1798:  /* fractsiuta2 */
    case 1797:  /* fracthiuta2 */
    case 1796:  /* fractqiuta2 */
    case 1795:  /* fracttauta2 */
    case 1794:  /* fractudauta2 */
    case 1793:  /* fractdauta2 */
    case 1792:  /* fractudquta2 */
    case 1791:  /* fractdquta2 */
    case 1790:  /* fractusauta2 */
    case 1789:  /* fractsauta2 */
    case 1788:  /* fractusquta2 */
    case 1787:  /* fractsquta2 */
    case 1786:  /* fractuhauta2 */
    case 1785:  /* fracthauta2 */
    case 1784:  /* fractuhquta2 */
    case 1783:  /* fracthquta2 */
    case 1782:  /* fractuqquta2 */
    case 1781:  /* fractqquta2 */
    case 1780:  /* fractdita2 */
    case 1779:  /* fractsita2 */
    case 1778:  /* fracthita2 */
    case 1777:  /* fractqita2 */
    case 1776:  /* fractutata2 */
    case 1775:  /* fractudata2 */
    case 1774:  /* fractdata2 */
    case 1773:  /* fractudqta2 */
    case 1772:  /* fractdqta2 */
    case 1771:  /* fractusata2 */
    case 1770:  /* fractsata2 */
    case 1769:  /* fractusqta2 */
    case 1768:  /* fractsqta2 */
    case 1767:  /* fractuhata2 */
    case 1766:  /* fracthata2 */
    case 1765:  /* fractuhqta2 */
    case 1764:  /* fracthqta2 */
    case 1763:  /* fractuqqta2 */
    case 1762:  /* fractqqta2 */
    case 1761:  /* fractdiuda2 */
    case 1760:  /* fractsiuda2 */
    case 1759:  /* fracthiuda2 */
    case 1758:  /* fractqiuda2 */
    case 1757:  /* fractutauda2 */
    case 1756:  /* fracttauda2 */
    case 1755:  /* fractdauda2 */
    case 1754:  /* fractudquda2 */
    case 1753:  /* fractdquda2 */
    case 1752:  /* fractusauda2 */
    case 1751:  /* fractsauda2 */
    case 1750:  /* fractusquda2 */
    case 1749:  /* fractsquda2 */
    case 1748:  /* fractuhauda2 */
    case 1747:  /* fracthauda2 */
    case 1746:  /* fractuhquda2 */
    case 1745:  /* fracthquda2 */
    case 1744:  /* fractuqquda2 */
    case 1743:  /* fractqquda2 */
    case 1742:  /* fractdida2 */
    case 1741:  /* fractsida2 */
    case 1740:  /* fracthida2 */
    case 1739:  /* fractqida2 */
    case 1738:  /* fractutada2 */
    case 1737:  /* fracttada2 */
    case 1736:  /* fractudada2 */
    case 1735:  /* fractudqda2 */
    case 1734:  /* fractdqda2 */
    case 1733:  /* fractusada2 */
    case 1732:  /* fractsada2 */
    case 1731:  /* fractusqda2 */
    case 1730:  /* fractsqda2 */
    case 1729:  /* fractuhada2 */
    case 1728:  /* fracthada2 */
    case 1727:  /* fractuhqda2 */
    case 1726:  /* fracthqda2 */
    case 1725:  /* fractuqqda2 */
    case 1724:  /* fractqqda2 */
    case 1723:  /* fractdiudq2 */
    case 1722:  /* fractsiudq2 */
    case 1721:  /* fracthiudq2 */
    case 1720:  /* fractqiudq2 */
    case 1719:  /* fractutaudq2 */
    case 1718:  /* fracttaudq2 */
    case 1717:  /* fractudaudq2 */
    case 1716:  /* fractdaudq2 */
    case 1715:  /* fractdqudq2 */
    case 1714:  /* fractusaudq2 */
    case 1713:  /* fractsaudq2 */
    case 1712:  /* fractusqudq2 */
    case 1711:  /* fractsqudq2 */
    case 1710:  /* fractuhaudq2 */
    case 1709:  /* fracthaudq2 */
    case 1708:  /* fractuhqudq2 */
    case 1707:  /* fracthqudq2 */
    case 1706:  /* fractuqqudq2 */
    case 1705:  /* fractqqudq2 */
    case 1704:  /* fractdidq2 */
    case 1703:  /* fractsidq2 */
    case 1702:  /* fracthidq2 */
    case 1701:  /* fractqidq2 */
    case 1700:  /* fractutadq2 */
    case 1699:  /* fracttadq2 */
    case 1698:  /* fractudadq2 */
    case 1697:  /* fractdadq2 */
    case 1696:  /* fractudqdq2 */
    case 1695:  /* fractusadq2 */
    case 1694:  /* fractsadq2 */
    case 1693:  /* fractusqdq2 */
    case 1692:  /* fractsqdq2 */
    case 1691:  /* fractuhadq2 */
    case 1690:  /* fracthadq2 */
    case 1689:  /* fractuhqdq2 */
    case 1688:  /* fracthqdq2 */
    case 1687:  /* fractuqqdq2 */
    case 1686:  /* fractqqdq2 */
    case 1685:  /* fractdiusa2 */
    case 1684:  /* fractsiusa2 */
    case 1683:  /* fracthiusa2 */
    case 1682:  /* fractqiusa2 */
    case 1681:  /* fractutausa2 */
    case 1680:  /* fracttausa2 */
    case 1679:  /* fractudausa2 */
    case 1678:  /* fractdausa2 */
    case 1677:  /* fractudqusa2 */
    case 1676:  /* fractdqusa2 */
    case 1675:  /* fractsausa2 */
    case 1674:  /* fractusqusa2 */
    case 1673:  /* fractsqusa2 */
    case 1672:  /* fractuhausa2 */
    case 1671:  /* fracthausa2 */
    case 1670:  /* fractuhqusa2 */
    case 1669:  /* fracthqusa2 */
    case 1668:  /* fractuqqusa2 */
    case 1667:  /* fractqqusa2 */
    case 1666:  /* fractdisa2 */
    case 1665:  /* fractsisa2 */
    case 1664:  /* fracthisa2 */
    case 1663:  /* fractqisa2 */
    case 1662:  /* fractutasa2 */
    case 1661:  /* fracttasa2 */
    case 1660:  /* fractudasa2 */
    case 1659:  /* fractdasa2 */
    case 1658:  /* fractudqsa2 */
    case 1657:  /* fractdqsa2 */
    case 1656:  /* fractusasa2 */
    case 1655:  /* fractusqsa2 */
    case 1654:  /* fractsqsa2 */
    case 1653:  /* fractuhasa2 */
    case 1652:  /* fracthasa2 */
    case 1651:  /* fractuhqsa2 */
    case 1650:  /* fracthqsa2 */
    case 1649:  /* fractuqqsa2 */
    case 1648:  /* fractqqsa2 */
    case 1647:  /* fractdiusq2 */
    case 1646:  /* fractsiusq2 */
    case 1645:  /* fracthiusq2 */
    case 1644:  /* fractqiusq2 */
    case 1643:  /* fractutausq2 */
    case 1642:  /* fracttausq2 */
    case 1641:  /* fractudausq2 */
    case 1640:  /* fractdausq2 */
    case 1639:  /* fractudqusq2 */
    case 1638:  /* fractdqusq2 */
    case 1637:  /* fractusausq2 */
    case 1636:  /* fractsausq2 */
    case 1635:  /* fractsqusq2 */
    case 1634:  /* fractuhausq2 */
    case 1633:  /* fracthausq2 */
    case 1632:  /* fractuhqusq2 */
    case 1631:  /* fracthqusq2 */
    case 1630:  /* fractuqqusq2 */
    case 1629:  /* fractqqusq2 */
    case 1628:  /* fractdisq2 */
    case 1627:  /* fractsisq2 */
    case 1626:  /* fracthisq2 */
    case 1625:  /* fractqisq2 */
    case 1624:  /* fractutasq2 */
    case 1623:  /* fracttasq2 */
    case 1622:  /* fractudasq2 */
    case 1621:  /* fractdasq2 */
    case 1620:  /* fractudqsq2 */
    case 1619:  /* fractdqsq2 */
    case 1618:  /* fractusasq2 */
    case 1617:  /* fractsasq2 */
    case 1616:  /* fractusqsq2 */
    case 1615:  /* fractuhasq2 */
    case 1614:  /* fracthasq2 */
    case 1613:  /* fractuhqsq2 */
    case 1612:  /* fracthqsq2 */
    case 1611:  /* fractuqqsq2 */
    case 1610:  /* fractqqsq2 */
    case 1609:  /* fractdiuha2 */
    case 1608:  /* fractsiuha2 */
    case 1607:  /* fracthiuha2 */
    case 1606:  /* fractqiuha2 */
    case 1605:  /* fractutauha2 */
    case 1604:  /* fracttauha2 */
    case 1603:  /* fractudauha2 */
    case 1602:  /* fractdauha2 */
    case 1601:  /* fractudquha2 */
    case 1600:  /* fractdquha2 */
    case 1599:  /* fractusauha2 */
    case 1598:  /* fractsauha2 */
    case 1597:  /* fractusquha2 */
    case 1596:  /* fractsquha2 */
    case 1595:  /* fracthauha2 */
    case 1594:  /* fractuhquha2 */
    case 1593:  /* fracthquha2 */
    case 1592:  /* fractuqquha2 */
    case 1591:  /* fractqquha2 */
    case 1590:  /* fractdiha2 */
    case 1589:  /* fractsiha2 */
    case 1588:  /* fracthiha2 */
    case 1587:  /* fractqiha2 */
    case 1586:  /* fractutaha2 */
    case 1585:  /* fracttaha2 */
    case 1584:  /* fractudaha2 */
    case 1583:  /* fractdaha2 */
    case 1582:  /* fractudqha2 */
    case 1581:  /* fractdqha2 */
    case 1580:  /* fractusaha2 */
    case 1579:  /* fractsaha2 */
    case 1578:  /* fractusqha2 */
    case 1577:  /* fractsqha2 */
    case 1576:  /* fractuhaha2 */
    case 1575:  /* fractuhqha2 */
    case 1574:  /* fracthqha2 */
    case 1573:  /* fractuqqha2 */
    case 1572:  /* fractqqha2 */
    case 1571:  /* fractdiuhq2 */
    case 1570:  /* fractsiuhq2 */
    case 1569:  /* fracthiuhq2 */
    case 1568:  /* fractqiuhq2 */
    case 1567:  /* fractutauhq2 */
    case 1566:  /* fracttauhq2 */
    case 1565:  /* fractudauhq2 */
    case 1564:  /* fractdauhq2 */
    case 1563:  /* fractudquhq2 */
    case 1562:  /* fractdquhq2 */
    case 1561:  /* fractusauhq2 */
    case 1560:  /* fractsauhq2 */
    case 1559:  /* fractusquhq2 */
    case 1558:  /* fractsquhq2 */
    case 1557:  /* fractuhauhq2 */
    case 1556:  /* fracthauhq2 */
    case 1555:  /* fracthquhq2 */
    case 1554:  /* fractuqquhq2 */
    case 1553:  /* fractqquhq2 */
    case 1552:  /* fractdihq2 */
    case 1551:  /* fractsihq2 */
    case 1550:  /* fracthihq2 */
    case 1549:  /* fractqihq2 */
    case 1548:  /* fractutahq2 */
    case 1547:  /* fracttahq2 */
    case 1546:  /* fractudahq2 */
    case 1545:  /* fractdahq2 */
    case 1544:  /* fractudqhq2 */
    case 1543:  /* fractdqhq2 */
    case 1542:  /* fractusahq2 */
    case 1541:  /* fractsahq2 */
    case 1540:  /* fractusqhq2 */
    case 1539:  /* fractsqhq2 */
    case 1538:  /* fractuhahq2 */
    case 1537:  /* fracthahq2 */
    case 1536:  /* fractuhqhq2 */
    case 1535:  /* fractuqqhq2 */
    case 1534:  /* fractqqhq2 */
    case 1533:  /* fractdiuqq2 */
    case 1532:  /* fractsiuqq2 */
    case 1531:  /* fracthiuqq2 */
    case 1530:  /* fractqiuqq2 */
    case 1529:  /* fractutauqq2 */
    case 1528:  /* fracttauqq2 */
    case 1527:  /* fractudauqq2 */
    case 1526:  /* fractdauqq2 */
    case 1525:  /* fractudquqq2 */
    case 1524:  /* fractdquqq2 */
    case 1523:  /* fractusauqq2 */
    case 1522:  /* fractsauqq2 */
    case 1521:  /* fractusquqq2 */
    case 1520:  /* fractsquqq2 */
    case 1519:  /* fractuhauqq2 */
    case 1518:  /* fracthauqq2 */
    case 1517:  /* fractuhquqq2 */
    case 1516:  /* fracthquqq2 */
    case 1515:  /* fractqquqq2 */
    case 1514:  /* fractdiqq2 */
    case 1513:  /* fractsiqq2 */
    case 1512:  /* fracthiqq2 */
    case 1511:  /* fractqiqq2 */
    case 1510:  /* fractutaqq2 */
    case 1509:  /* fracttaqq2 */
    case 1508:  /* fractudaqq2 */
    case 1507:  /* fractdaqq2 */
    case 1506:  /* fractudqqq2 */
    case 1505:  /* fractdqqq2 */
    case 1504:  /* fractusaqq2 */
    case 1503:  /* fractsaqq2 */
    case 1502:  /* fractusqqq2 */
    case 1501:  /* fractsqqq2 */
    case 1500:  /* fractuhaqq2 */
    case 1499:  /* fracthaqq2 */
    case 1498:  /* fractuhqqq2 */
    case 1497:  /* fracthqqq2 */
    case 1496:  /* fractuqqqq2 */
    case 1181:  /* *extzv.io.lsr7 */
    case 827:  /* zero_extendsidi2 */
    case 826:  /* zero_extendhidi2 */
    case 825:  /* zero_extendqidi2 */
    case 824:  /* zero_extendpsisi2 */
    case 823:  /* zero_extendhisi2 */
    case 821:  /* zero_extendhipsi2 */
    case 820:  /* zero_extendqisi2 */
    case 819:  /* zero_extendqipsi2 */
    case 818:  /* zero_extendqihi2 */
    case 816:  /* extendpsisi2 */
    case 814:  /* extendhisi2 */
    case 812:  /* extendhipsi2 */
    case 810:  /* extendqisi2 */
    case 808:  /* extendqipsi2 */
    case 806:  /* extendqihi2 */
    case 804:  /* one_cmplsi2 */
    case 802:  /* one_cmplpsi2 */
    case 800:  /* one_cmplhi2 */
    case 798:  /* one_cmplqi2 */
    case 796:  /* negsf2 */
    case 793:  /* negsi2 */
    case 791:  /* negpsi2 */
    case 789:  /* neghi2 */
    case 785:  /* negqi2 */
    case 783:  /* abssf2 */
    case 781:  /* absqi2 */
    case 654:  /* *rotlsi2.31_split */
    case 652:  /* *rotlsi2.1_split */
    case 650:  /* *rotlpsi2.23_split */
    case 648:  /* *rotlpsi2.1_split */
    case 646:  /* *rotlhi2.15_split */
    case 644:  /* *rotlhi2.1_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 599:  /* *umulhiqipsi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      break;

    case 598:  /* *umulhiqipsi3_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      break;

    case 615:  /* udivmodsi4 */
    case 612:  /* divmodsi4 */
    case 609:  /* udivmodpsi4 */
    case 606:  /* divmodpsi4 */
    case 593:  /* udivmodhi4 */
    case 590:  /* divmodhi4 */
    case 587:  /* udivmodqi4 */
    case 584:  /* divmodqi4 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 1), 0));
      recog_data.dup_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 0);
      recog_data.dup_num[0] = 1;
      recog_data.dup_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 1), 1), 1);
      recog_data.dup_num[1] = 2;
      break;

    case 547:  /* *mulohisi3 */
    case 536:  /* *muloqihi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 535:  /* muloqihi3 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 529:  /* *ashifthi3.signx.const7 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 971:  /* call_value_insn */
    case 530:  /* *ashifthi3.zerox.const */
    case 528:  /* *ashifthi3.signx.const */
    case 525:  /* *mulsqihi3.oconst */
    case 524:  /* *mulsqihi3.uconst */
    case 523:  /* *muluqihi3.sconst */
    case 522:  /* *muluqihi3.uconst */
    case 521:  /* *mulsqihi3.sconst */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 520:  /* *sumsubqihi4.uconst */
    case 518:  /* *msubqihi4.sconst.ashift */
    case 517:  /* *umsubqihi4.uconst.ashift */
    case 516:  /* *umsubqihi4.uconst */
    case 515:  /* *msubqihi4.sconst */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 519:  /* *sumaddqihi4.uconst */
    case 514:  /* *umaddqihi4.uconst */
    case 513:  /* *maddqihi4.sconst */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 511:  /* *sumsubqihi4 */
    case 510:  /* *usmsubqihi4 */
    case 503:  /* *umsubqihi4 */
    case 502:  /* *msubqihi4 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      break;

    case 509:  /* *sumsubqihi4_split */
    case 508:  /* *usmsubqihi4_split */
    case 501:  /* *umsubqihi4_split */
    case 500:  /* *msubqihi4_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 507:  /* *sumsubqihi4 */
    case 506:  /* *usmsubqihi4 */
    case 499:  /* *umaddqihi4 */
    case 498:  /* *maddqihi4 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 505:  /* *sumsubqihi4_split */
    case 504:  /* *usmsubqihi4_split */
    case 497:  /* *umaddqihi4_split */
    case 496:  /* *maddqihi4_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 495:  /* *msubqi4.const */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 494:  /* *maddqi4.const */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 493:  /* *msubqi4 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      break;

    case 492:  /* *msubqi4_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 1205:  /* *insv.any_shift.si */
    case 1204:  /* *insv.any_shift.si */
    case 1203:  /* *insv.any_shift.si */
    case 1202:  /* *insv.any_shift.psi */
    case 1201:  /* *insv.any_shift.psi */
    case 1200:  /* *insv.any_shift.psi */
    case 1199:  /* *insv.any_shift.hi */
    case 1198:  /* *insv.any_shift.hi */
    case 1197:  /* *insv.any_shift.hi */
    case 1196:  /* *insv.any_shift.qi */
    case 1195:  /* *insv.any_shift.qi */
    case 1194:  /* *insv.any_shift.qi */
    case 491:  /* *maddqi4 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 489:  /* *oumulqihi3 */
    case 487:  /* *osmulqihi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 488:  /* *oumulqihi3_split */
    case 486:  /* *osmulqihi3_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 347:  /* *subsi3.sex.msbit_split */
    case 346:  /* *subsi3.sex.msbit_split */
    case 345:  /* *subsi3.sex.msbit_split */
    case 344:  /* *subsi3.sex.msbit_split */
    case 343:  /* *subpsi3.sex.msbit_split */
    case 342:  /* *subpsi3.sex.msbit_split */
    case 341:  /* *subsi3.sex.msbit_split */
    case 340:  /* *subsi3.sex.msbit_split */
    case 339:  /* *subpsi3.sex.msbit_split */
    case 338:  /* *subpsi3.sex.msbit_split */
    case 337:  /* *subhi3.sex.msbit_split */
    case 336:  /* *subhi3.sex.msbit_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 1), 0), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      break;

    case 1331:  /* *mul.and1-to-skip.si */
    case 1330:  /* *mul.and1-to-skip.si */
    case 1329:  /* *mul.and1-to-skip.si */
    case 1328:  /* *mul.and1-to-skip.psi */
    case 1327:  /* *mul.and1-to-skip.psi */
    case 1326:  /* *mul.and1-to-skip.psi */
    case 1325:  /* *mul.and1-to-skip.hi */
    case 1324:  /* *mul.and1-to-skip.hi */
    case 1323:  /* *mul.and1-to-skip.hi */
    case 1322:  /* *mul.and1-to-skip.qi */
    case 1321:  /* *mul.and1-to-skip.qi */
    case 1320:  /* *mul.and1-to-skip.qi */
    case 335:  /* *addsi3.sex.msbit_split */
    case 334:  /* *addsi3.sex.msbit_split */
    case 333:  /* *addsi3.sex.msbit_split */
    case 332:  /* *addsi3.sex.msbit_split */
    case 331:  /* *addpsi3.sex.msbit_split */
    case 330:  /* *addpsi3.sex.msbit_split */
    case 329:  /* *addsi3.sex.msbit_split */
    case 328:  /* *addsi3.sex.msbit_split */
    case 327:  /* *addpsi3.sex.msbit_split */
    case 326:  /* *addpsi3.sex.msbit_split */
    case 325:  /* *addhi3.sex.msbit_split */
    case 324:  /* *addhi3.sex.msbit_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 1494:  /* *nzb=1.ior.ashift_split */
    case 1481:  /* *nzb=1.and.lsr_split */
    case 1480:  /* *nzb=1.ior.lsr_split */
    case 1479:  /* *nzb=1.xor.lsr_split */
    case 1193:  /* *insv.any_shift.si_split */
    case 1192:  /* *insv.any_shift.si_split */
    case 1191:  /* *insv.any_shift.si_split */
    case 1190:  /* *insv.any_shift.psi_split */
    case 1189:  /* *insv.any_shift.psi_split */
    case 1188:  /* *insv.any_shift.psi_split */
    case 1187:  /* *insv.any_shift.hi_split */
    case 1186:  /* *insv.any_shift.hi_split */
    case 1185:  /* *insv.any_shift.hi_split */
    case 1184:  /* *insv.any_shift.qi_split */
    case 1183:  /* *insv.any_shift.qi_split */
    case 1182:  /* *insv.any_shift.qi_split */
    case 490:  /* *maddqi4_split */
    case 323:  /* *addsi3.msbit_split */
    case 322:  /* *addsi3.msbit_split */
    case 321:  /* *addpsi3.msbit_split */
    case 320:  /* *addpsi3.msbit_split */
    case 319:  /* *addhi3.msbit_split */
    case 318:  /* *addhi3.msbit_split */
    case 317:  /* *addqi3.msbit_split */
    case 316:  /* *addqi3.msbit_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 0), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 315:  /* *subsi3.msbit_split */
    case 314:  /* *subsi3.msbit_split */
    case 313:  /* *subpsi3.msbit_split */
    case 312:  /* *subpsi3.msbit_split */
    case 311:  /* *subhi3.msbit_split */
    case 310:  /* *subhi3.msbit_split */
    case 309:  /* *subqi3.msbit_split */
    case 308:  /* *subqi3.msbit_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XEXP (XEXP (pat, 1), 1), 1));
      break;

    case 307:  /* *umulqi3_highpart */
    case 306:  /* *smulqi3_highpart */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 1), 0));
      break;

    case 305:  /* umulqi3_highpart */
    case 304:  /* smulqi3_highpart */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 1), 0));
      break;

    case 822:  /* n_extendhipsi2 */
    case 780:  /* *lshrusa3_const */
    case 779:  /* *lshrsa3_const */
    case 778:  /* *lshrusq3_const */
    case 777:  /* *lshrsq3_const */
    case 776:  /* *lshrsi3_const */
    case 775:  /* *lshruha3_const */
    case 774:  /* *lshrha3_const */
    case 773:  /* *lshruhq3_const */
    case 772:  /* *lshrhq3_const */
    case 771:  /* *lshrhi3_const */
    case 760:  /* *lshrpsi3 */
    case 759:  /* lshrpsi3 */
    case 742:  /* *ashrusa3_const */
    case 741:  /* *ashrsa3_const */
    case 740:  /* *ashrusq3_const */
    case 739:  /* *ashrsq3_const */
    case 738:  /* *ashrsi3_const */
    case 737:  /* *ashruha3_const */
    case 736:  /* *ashrha3_const */
    case 735:  /* *ashruhq3_const */
    case 734:  /* *ashrhq3_const */
    case 733:  /* *ashrhi3_const */
    case 722:  /* *ashrpsi3 */
    case 721:  /* ashrpsi3 */
    case 703:  /* *ashlpsi3 */
    case 702:  /* *ashlpsi3_split */
    case 701:  /* *ashlusa3_const */
    case 700:  /* *ashlsa3_const */
    case 699:  /* *ashlusq3_const */
    case 698:  /* *ashlsq3_const */
    case 697:  /* *ashlsi3_const */
    case 696:  /* *ashluha3_const */
    case 695:  /* *ashlha3_const */
    case 694:  /* *ashluhq3_const */
    case 693:  /* *ashlhq3_const */
    case 692:  /* *ashlhi3_const */
    case 660:  /* *rotbsi */
    case 659:  /* *rotbpsi */
    case 658:  /* *rotbhi */
    case 657:  /* *rotwsi */
    case 656:  /* *rotwhi */
    case 641:  /* *xorsi3 */
    case 640:  /* xorsi3 */
    case 639:  /* *xorpsi3 */
    case 638:  /* xorpsi3 */
    case 637:  /* *xorhi3 */
    case 636:  /* xorhi3 */
    case 633:  /* *iorsi3 */
    case 632:  /* iorsi3 */
    case 631:  /* *iorpsi3 */
    case 630:  /* iorpsi3 */
    case 629:  /* *iorhi3 */
    case 628:  /* iorhi3 */
    case 625:  /* *andsi3 */
    case 624:  /* andsi3 */
    case 623:  /* *andpsi3 */
    case 622:  /* andpsi3 */
    case 621:  /* *andhi3 */
    case 620:  /* andhi3 */
    case 299:  /* *subusa3 */
    case 298:  /* *subsa3 */
    case 297:  /* *subusq3 */
    case 296:  /* *subsq3 */
    case 295:  /* *subsi3 */
    case 294:  /* subusa3 */
    case 293:  /* subsa3 */
    case 292:  /* subusq3 */
    case 291:  /* subsq3 */
    case 290:  /* subsi3 */
    case 289:  /* *subuha3 */
    case 288:  /* *subha3 */
    case 287:  /* *subuhq3 */
    case 286:  /* *subhq3 */
    case 285:  /* *subhi3 */
    case 284:  /* subuha3 */
    case 283:  /* subha3 */
    case 282:  /* subuhq3 */
    case 281:  /* subhq3 */
    case 280:  /* subhi3 */
    case 271:  /* *addpsi3 */
    case 270:  /* addpsi3 */
    case 223:  /* *addusa3 */
    case 222:  /* *addsa3 */
    case 221:  /* *addusq3 */
    case 220:  /* *addsq3 */
    case 219:  /* *addsi3 */
    case 218:  /* addusa3 */
    case 217:  /* addsa3 */
    case 216:  /* addusq3 */
    case 215:  /* addsq3 */
    case 214:  /* addsi3 */
    case 213:  /* *adduha3_clobber */
    case 212:  /* *addha3_clobber */
    case 211:  /* *adduhq3_clobber */
    case 210:  /* *addhq3_clobber */
    case 209:  /* *addhi3_clobber */
    case 208:  /* adduha3_clobber */
    case 207:  /* addha3_clobber */
    case 206:  /* adduhq3_clobber */
    case 205:  /* addhq3_clobber */
    case 204:  /* addhi3_clobber */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 193:  /* *addhi3_sp */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (pat, 1), 1));
      ro[1] = *(ro_loc[1] = &XEXP (pat, 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 0));
      break;

    case 597:  /* *umulqihipsi3 */
    case 563:  /* *uumulhihisi3 */
    case 562:  /* *sumulhihisi3 */
    case 561:  /* *usmulhihisi3 */
    case 560:  /* *ssmulhihisi3 */
    case 559:  /* *uumulqihisi3 */
    case 558:  /* *sumulqihisi3 */
    case 557:  /* *usmulqihisi3 */
    case 556:  /* *ssmulqihisi3 */
    case 555:  /* *uumulhiqisi3 */
    case 554:  /* *sumulhiqisi3 */
    case 553:  /* *usmulhiqisi3 */
    case 552:  /* *ssmulhiqisi3 */
    case 551:  /* *uumulqiqisi3 */
    case 550:  /* *sumulqiqisi3 */
    case 549:  /* *usmulqiqisi3 */
    case 548:  /* *ssmulqiqisi3 */
    case 485:  /* *sumulqihi3 */
    case 483:  /* *usmulqihi3 */
    case 481:  /* umulqihi3 */
    case 480:  /* mulqihi3 */
    case 192:  /* *udiff_widenqihi3 */
    case 190:  /* *usum_widenqihi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 1144:  /* *iorhi3.ashift8-reg.zerox */
    case 1075:  /* *movbitqi.7 */
    case 596:  /* *umulqihipsi3_split */
    case 484:  /* *sumulqihi3_split */
    case 482:  /* usmulqihi3 */
    case 479:  /* umulqihi3_split */
    case 478:  /* mulqihi3_split */
    case 191:  /* *udiff_widenqihi3_split */
    case 189:  /* *usum_widenqihi3_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 188:  /* *addhi3_zero_extend.ashift1 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 1456:  /* *map.shl.ext.and1-to-skip.si */
    case 1455:  /* *map.shl.ext.and1-to-skip.si */
    case 1454:  /* *map.shl.ext.and1-to-skip.si */
    case 1453:  /* *map.shl.ext.and1-to-skip.si */
    case 1452:  /* *map.shl.ext.and1-to-skip.psi */
    case 1451:  /* *map.shl.ext.and1-to-skip.psi */
    case 1450:  /* *map.shl.ext.and1-to-skip.si */
    case 1449:  /* *map.shl.ext.and1-to-skip.si */
    case 1448:  /* *map.shl.ext.and1-to-skip.psi */
    case 1447:  /* *map.shl.ext.and1-to-skip.psi */
    case 1446:  /* *map.shl.ext.and1-to-skip.hi */
    case 1445:  /* *map.shl.ext.and1-to-skip.hi */
    case 1444:  /* *map.mul.ext.and1-to-skip.si */
    case 1443:  /* *map.mul.ext.and1-to-skip.si */
    case 1442:  /* *map.mul.ext.and1-to-skip.si */
    case 1441:  /* *map.mul.ext.and1-to-skip.si */
    case 1440:  /* *map.mul.ext.and1-to-skip.psi */
    case 1439:  /* *map.mul.ext.and1-to-skip.psi */
    case 1438:  /* *map.mul.ext.and1-to-skip.si */
    case 1437:  /* *map.mul.ext.and1-to-skip.si */
    case 1436:  /* *map.mul.ext.and1-to-skip.psi */
    case 1435:  /* *map.mul.ext.and1-to-skip.psi */
    case 1434:  /* *map.mul.ext.and1-to-skip.hi */
    case 1433:  /* *map.mul.ext.and1-to-skip.hi */
    case 1143:  /* *iorhi3.ashift8-ext.reg */
    case 1142:  /* *iorhi3.ashift8-ext.reg */
    case 512:  /* *umaddqihi4.2 */
    case 187:  /* *addhi3_zero_extend.ashift1.split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XEXP (pat, 1), 0), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 379:  /* *subsi3.lt0 */
    case 378:  /* *subsi3.ge0 */
    case 377:  /* *subpsi3.lt0 */
    case 376:  /* *subpsi3.ge0 */
    case 375:  /* *subhi3.lt0 */
    case 374:  /* *subhi3.ge0 */
    case 373:  /* *subqi3.lt0 */
    case 372:  /* *subqi3.ge0 */
    case 371:  /* *subsi3.lt0 */
    case 370:  /* *subsi3.ge0 */
    case 369:  /* *subpsi3.lt0 */
    case 368:  /* *subpsi3.ge0 */
    case 367:  /* *subhi3.lt0 */
    case 366:  /* *subhi3.ge0 */
    case 365:  /* *subqi3.lt0 */
    case 364:  /* *subqi3.ge0 */
    case 363:  /* *subsi3.lt0 */
    case 362:  /* *subsi3.ge0 */
    case 361:  /* *subpsi3.lt0 */
    case 360:  /* *subpsi3.ge0 */
    case 359:  /* *subhi3.lt0 */
    case 358:  /* *subhi3.ge0 */
    case 357:  /* *subqi3.lt0 */
    case 356:  /* *subqi3.ge0 */
    case 355:  /* *subsi3.lt0 */
    case 354:  /* *subsi3.ge0 */
    case 353:  /* *subpsi3.lt0 */
    case 352:  /* *subpsi3.ge0 */
    case 351:  /* *subhi3.lt0 */
    case 350:  /* *subhi3.ge0 */
    case 349:  /* *subqi3.lt0 */
    case 348:  /* *subqi3.ge0 */
    case 269:  /* *subsi3.zero_extend.psi */
    case 268:  /* *subsi3.sign_extend.psi */
    case 267:  /* *subsi3.zero_extend.hi */
    case 266:  /* *subsi3.sign_extend.hi */
    case 265:  /* *subpsi3.zero_extend.hi */
    case 264:  /* *subpsi3.sign_extend.hi */
    case 263:  /* *subsi3.zero_extend.qi */
    case 262:  /* *subsi3.sign_extend.qi */
    case 261:  /* *subpsi3.zero_extend.qi */
    case 260:  /* *subpsi3.sign_extend.qi */
    case 259:  /* *subhi3.zero_extend.qi */
    case 258:  /* *subhi3.sign_extend.qi */
    case 183:  /* *addhi3_zero_extend1 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1), 0));
      break;

    case 475:  /* *subsi3.lt0_split */
    case 474:  /* *subsi3.ge0_split */
    case 473:  /* *subpsi3.lt0_split */
    case 472:  /* *subpsi3.ge0_split */
    case 471:  /* *subhi3.lt0_split */
    case 470:  /* *subhi3.ge0_split */
    case 469:  /* *subqi3.lt0_split */
    case 468:  /* *subqi3.ge0_split */
    case 467:  /* *subsi3.lt0_split */
    case 466:  /* *subsi3.ge0_split */
    case 465:  /* *subpsi3.lt0_split */
    case 464:  /* *subpsi3.ge0_split */
    case 463:  /* *subhi3.lt0_split */
    case 462:  /* *subhi3.ge0_split */
    case 461:  /* *subqi3.lt0_split */
    case 460:  /* *subqi3.ge0_split */
    case 459:  /* *subsi3.lt0_split */
    case 458:  /* *subsi3.ge0_split */
    case 457:  /* *subpsi3.lt0_split */
    case 456:  /* *subpsi3.ge0_split */
    case 455:  /* *subhi3.lt0_split */
    case 454:  /* *subhi3.ge0_split */
    case 453:  /* *subqi3.lt0_split */
    case 452:  /* *subqi3.ge0_split */
    case 451:  /* *subsi3.lt0_split */
    case 450:  /* *subsi3.ge0_split */
    case 449:  /* *subpsi3.lt0_split */
    case 448:  /* *subpsi3.ge0_split */
    case 447:  /* *subhi3.lt0_split */
    case 446:  /* *subhi3.ge0_split */
    case 445:  /* *subqi3.lt0_split */
    case 444:  /* *subqi3.ge0_split */
    case 257:  /* *subsi3.zero_extend.psi_split */
    case 256:  /* *subsi3.sign_extend.psi_split */
    case 255:  /* *subsi3.zero_extend.hi_split */
    case 254:  /* *subsi3.sign_extend.hi_split */
    case 253:  /* *subpsi3.zero_extend.hi_split */
    case 252:  /* *subpsi3.sign_extend.hi_split */
    case 251:  /* *subsi3.zero_extend.qi_split */
    case 250:  /* *subsi3.sign_extend.qi_split */
    case 249:  /* *subpsi3.zero_extend.qi_split */
    case 248:  /* *subpsi3.sign_extend.qi_split */
    case 247:  /* *subhi3.zero_extend.qi_split */
    case 246:  /* *subhi3.sign_extend.qi_split */
    case 182:  /* *addhi3_zero_extend1_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XEXP (pat, 1), 1), 0));
      break;

    case 600:  /* *mulsqipsi3 */
    case 546:  /* *mulshisi3 */
    case 545:  /* *mulsqisi3 */
    case 544:  /* *muluhisi3 */
    case 543:  /* *muluqisi3 */
    case 534:  /* *muluqihi3 */
    case 532:  /* *mulsqihi3 */
    case 411:  /* *addsi3.lt0 */
    case 410:  /* *addsi3.ge0 */
    case 409:  /* *addpsi3.lt0 */
    case 408:  /* *addpsi3.ge0 */
    case 407:  /* *addhi3.lt0 */
    case 406:  /* *addhi3.ge0 */
    case 405:  /* *addqi3.lt0 */
    case 404:  /* *addqi3.ge0 */
    case 403:  /* *addsi3.lt0 */
    case 402:  /* *addsi3.ge0 */
    case 401:  /* *addpsi3.lt0 */
    case 400:  /* *addpsi3.ge0 */
    case 399:  /* *addhi3.lt0 */
    case 398:  /* *addhi3.ge0 */
    case 397:  /* *addqi3.lt0 */
    case 396:  /* *addqi3.ge0 */
    case 395:  /* *addsi3.lt0 */
    case 394:  /* *addsi3.ge0 */
    case 393:  /* *addpsi3.lt0 */
    case 392:  /* *addpsi3.ge0 */
    case 391:  /* *addhi3.lt0 */
    case 390:  /* *addhi3.ge0 */
    case 389:  /* *addqi3.lt0 */
    case 388:  /* *addqi3.ge0 */
    case 387:  /* *addsi3.lt0 */
    case 386:  /* *addsi3.ge0 */
    case 385:  /* *addpsi3.lt0 */
    case 384:  /* *addpsi3.ge0 */
    case 383:  /* *addhi3.lt0 */
    case 382:  /* *addhi3.ge0 */
    case 381:  /* *addqi3.lt0 */
    case 380:  /* *addqi3.ge0 */
    case 245:  /* *addsi3.zero_extend.psi */
    case 244:  /* *addsi3.sign_extend.psi */
    case 243:  /* *addsi3.zero_extend.hi */
    case 242:  /* *addsi3.sign_extend.hi */
    case 241:  /* *addpsi3.zero_extend.hi */
    case 240:  /* *addpsi3.sign_extend.hi */
    case 239:  /* *addsi3.zero_extend.qi */
    case 238:  /* *addsi3.sign_extend.qi */
    case 237:  /* *addpsi3.zero_extend.qi */
    case 236:  /* *addpsi3.sign_extend.qi */
    case 235:  /* *addhi3.sign_extend.qi */
    case 185:  /* *addhi3_zero_extend.const */
    case 181:  /* *addhi3_zero_extend */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 1490:  /* *nzb=1.and.ge0_split */
    case 1489:  /* *nzb=1.ior.ge0_split */
    case 1488:  /* *nzb=1.xor.ge0_split */
    case 1432:  /* *map.mul.and1-to-skip.si */
    case 1431:  /* *map.mul.and1-to-skip.psi */
    case 1430:  /* *map.mul.and1-to-skip.hi */
    case 1429:  /* *map.mul.and1-to-skip.qi */
    case 1428:  /* *map.mul.and1-to-skip.si */
    case 1427:  /* *map.mul.and1-to-skip.psi */
    case 1426:  /* *map.mul.and1-to-skip.hi */
    case 1425:  /* *map.mul.and1-to-skip.qi */
    case 1424:  /* *map.mul.and1-to-skip.si */
    case 1423:  /* *map.mul.and1-to-skip.psi */
    case 1422:  /* *map.mul.and1-to-skip.hi */
    case 1421:  /* *map.mul.and1-to-skip.qi */
    case 1420:  /* *map.mul.and1-to-skip.si */
    case 1419:  /* *map.mul.and1-to-skip.psi */
    case 1418:  /* *map.mul.and1-to-skip.hi */
    case 1417:  /* *map.mul.and1-to-skip.qi */
    case 1416:  /* *map.mul.and1-to-skip.si */
    case 1415:  /* *map.mul.and1-to-skip.psi */
    case 1414:  /* *map.mul.and1-to-skip.hi */
    case 1413:  /* *map.mul.and1-to-skip.qi */
    case 1115:  /* *iorsipsi.0 */
    case 1114:  /* *xorsipsi.0 */
    case 1113:  /* *iorsihi.0 */
    case 1112:  /* *xorsihi.0 */
    case 1111:  /* *iorpsihi.0 */
    case 1110:  /* *xorpsihi.0 */
    case 1109:  /* *iorsiqi.0 */
    case 1108:  /* *xorsiqi.0 */
    case 1107:  /* *iorpsiqi.0 */
    case 1106:  /* *xorpsiqi.0 */
    case 1105:  /* *iorhiqi.0 */
    case 1104:  /* *xorhiqi.0 */
    case 533:  /* muluqihi3 */
    case 531:  /* mulsqihi3 */
    case 443:  /* *addsi3.lt0_split */
    case 442:  /* *addsi3.ge0_split */
    case 441:  /* *addpsi3.lt0_split */
    case 440:  /* *addpsi3.ge0_split */
    case 439:  /* *addhi3.lt0_split */
    case 438:  /* *addhi3.ge0_split */
    case 437:  /* *addqi3.lt0_split */
    case 436:  /* *addqi3.ge0_split */
    case 435:  /* *addsi3.lt0_split */
    case 434:  /* *addsi3.ge0_split */
    case 433:  /* *addpsi3.lt0_split */
    case 432:  /* *addpsi3.ge0_split */
    case 431:  /* *addhi3.lt0_split */
    case 430:  /* *addhi3.ge0_split */
    case 429:  /* *addqi3.lt0_split */
    case 428:  /* *addqi3.ge0_split */
    case 427:  /* *addsi3.lt0_split */
    case 426:  /* *addsi3.ge0_split */
    case 425:  /* *addpsi3.lt0_split */
    case 424:  /* *addpsi3.ge0_split */
    case 423:  /* *addhi3.lt0_split */
    case 422:  /* *addhi3.ge0_split */
    case 421:  /* *addqi3.lt0_split */
    case 420:  /* *addqi3.ge0_split */
    case 419:  /* *addsi3.lt0_split */
    case 418:  /* *addsi3.ge0_split */
    case 417:  /* *addpsi3.lt0_split */
    case 416:  /* *addpsi3.ge0_split */
    case 415:  /* *addhi3.lt0_split */
    case 414:  /* *addhi3.ge0_split */
    case 413:  /* *addqi3.lt0_split */
    case 412:  /* *addqi3.ge0_split */
    case 234:  /* *addsi3.zero_extend.psi_split */
    case 233:  /* *addsi3.sign_extend.psi_split */
    case 232:  /* *addsi3.zero_extend.hi_split */
    case 231:  /* *addsi3.sign_extend.hi_split */
    case 230:  /* *addpsi3.zero_extend.hi_split */
    case 229:  /* *addpsi3.sign_extend.hi_split */
    case 228:  /* *addsi3.zero_extend.qi_split */
    case 227:  /* *addsi3.sign_extend.qi_split */
    case 226:  /* *addpsi3.zero_extend.qi_split */
    case 225:  /* *addpsi3.sign_extend.qi_split */
    case 224:  /* *addhi3.sign_extend.qi_split */
    case 186:  /* *aligned_add_symbol */
    case 184:  /* *addhi3_zero_extend.const_split */
    case 180:  /* *addhi3_zero_extend_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 3079:  /* *muluqq3_enh */
    case 3077:  /* *mulqq3_enh */
    case 3055:  /* *ussubusq3 */
    case 3054:  /* *usaddusq3 */
    case 3053:  /* *ussubusa3 */
    case 3052:  /* *usaddusa3 */
    case 3051:  /* *ussubuha3 */
    case 3050:  /* *usadduha3 */
    case 3049:  /* *ussubuhq3 */
    case 3048:  /* *usadduhq3 */
    case 3047:  /* *ussubuqq3 */
    case 3046:  /* *usadduqq3 */
    case 3035:  /* *sssubsq3 */
    case 3034:  /* *ssaddsq3 */
    case 3033:  /* *sssubsa3 */
    case 3032:  /* *ssaddsa3 */
    case 3031:  /* *sssubha3 */
    case 3030:  /* *ssaddha3 */
    case 3029:  /* *sssubhq3 */
    case 3028:  /* *ssaddhq3 */
    case 3027:  /* *sssubqq3 */
    case 3026:  /* *ssaddqq3 */
    case 770:  /* *lshrusa3 */
    case 769:  /* *lshrsa3 */
    case 768:  /* *lshrusq3 */
    case 767:  /* *lshrsq3 */
    case 766:  /* *lshrsi3 */
    case 758:  /* *lshruha3 */
    case 757:  /* *lshrha3 */
    case 756:  /* *lshruhq3 */
    case 755:  /* *lshrhq3 */
    case 754:  /* *lshrhi3 */
    case 748:  /* *lshruqq3 */
    case 747:  /* *lshrqq3 */
    case 746:  /* *lshrqi3 */
    case 732:  /* *ashrusa3 */
    case 731:  /* *ashrsa3 */
    case 730:  /* *ashrusq3 */
    case 729:  /* *ashrsq3 */
    case 728:  /* *ashrsi3 */
    case 720:  /* *ashruha3 */
    case 719:  /* *ashrha3 */
    case 718:  /* *ashruhq3 */
    case 717:  /* *ashrhq3 */
    case 716:  /* *ashrhi3 */
    case 710:  /* *ashruqq3 */
    case 709:  /* *ashrqq3 */
    case 708:  /* *ashrqi3 */
    case 691:  /* *ashlusa3 */
    case 690:  /* *ashlsa3 */
    case 689:  /* *ashlusq3 */
    case 688:  /* *ashlsq3 */
    case 687:  /* *ashlsi3 */
    case 676:  /* *ashluha3 */
    case 675:  /* *ashlha3 */
    case 674:  /* *ashluhq3 */
    case 673:  /* *ashlhq3 */
    case 672:  /* *ashlhi3 */
    case 666:  /* *ashluqq3 */
    case 665:  /* *ashlqq3 */
    case 664:  /* *ashlqi3 */
    case 643:  /* *rotlqi3 */
    case 635:  /* *xorqi3 */
    case 627:  /* *iorqi3 */
    case 619:  /* *andqi3 */
    case 601:  /* *mulpsi3 */
    case 542:  /* *mulsi3_pr118012 */
    case 541:  /* *mulsi3 */
    case 538:  /* *mulhi3_enh */
    case 301:  /* *mulqi3_enh */
    case 279:  /* *subuqq3 */
    case 278:  /* *subqq3 */
    case 277:  /* *subqi3 */
    case 273:  /* *subpsi3 */
    case 203:  /* *adduha3 */
    case 202:  /* *addha3 */
    case 201:  /* *adduhq3 */
    case 200:  /* *addhq3 */
    case 199:  /* *addhi3 */
    case 179:  /* *adduqq3 */
    case 178:  /* *addqq3 */
    case 177:  /* *addqi3 */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 1));
      break;

    case 3078:  /* muluqq3_enh */
    case 3076:  /* mulqq3_enh */
    case 3045:  /* ussubusq3 */
    case 3044:  /* usaddusq3 */
    case 3043:  /* ussubusa3 */
    case 3042:  /* usaddusa3 */
    case 3041:  /* ussubuha3 */
    case 3040:  /* usadduha3 */
    case 3039:  /* ussubuhq3 */
    case 3038:  /* usadduhq3 */
    case 3037:  /* ussubuqq3 */
    case 3036:  /* usadduqq3 */
    case 3025:  /* sssubsq3 */
    case 3024:  /* ssaddsq3 */
    case 3023:  /* sssubsa3 */
    case 3022:  /* ssaddsa3 */
    case 3021:  /* sssubha3 */
    case 3020:  /* ssaddha3 */
    case 3019:  /* sssubhq3 */
    case 3018:  /* ssaddhq3 */
    case 3017:  /* sssubqq3 */
    case 3016:  /* ssaddqq3 */
    case 1176:  /* *extzvsi.ge */
    case 1175:  /* *extzvpsi.ge */
    case 1174:  /* *extzvhi.ge */
    case 1173:  /* *extzvqi.ge */
    case 1051:  /* copysignsf3 */
    case 765:  /* lshrusa3 */
    case 764:  /* lshrsa3 */
    case 763:  /* lshrusq3 */
    case 762:  /* lshrsq3 */
    case 761:  /* lshrsi3 */
    case 753:  /* lshruha3 */
    case 752:  /* lshrha3 */
    case 751:  /* lshruhq3 */
    case 750:  /* lshrhq3 */
    case 749:  /* lshrhi3 */
    case 745:  /* *lshruqq3_split */
    case 744:  /* *lshrqq3_split */
    case 743:  /* *lshrqi3_split */
    case 727:  /* ashrusa3 */
    case 726:  /* ashrsa3 */
    case 725:  /* ashrusq3 */
    case 724:  /* ashrsq3 */
    case 723:  /* ashrsi3 */
    case 715:  /* ashruha3 */
    case 714:  /* ashrha3 */
    case 713:  /* ashruhq3 */
    case 712:  /* ashrhq3 */
    case 711:  /* ashrhi3 */
    case 707:  /* ashruqq3 */
    case 706:  /* ashrqq3 */
    case 705:  /* ashrqi3 */
    case 686:  /* ashlusa3 */
    case 685:  /* ashlsa3 */
    case 684:  /* ashlusq3 */
    case 683:  /* ashlsq3 */
    case 682:  /* ashlsi3 */
    case 671:  /* ashluha3 */
    case 670:  /* ashlha3 */
    case 669:  /* ashluhq3 */
    case 668:  /* ashlhq3 */
    case 667:  /* ashlhi3 */
    case 663:  /* *ashluqq3_split */
    case 662:  /* *ashlqq3_split */
    case 661:  /* *ashlqi3_split */
    case 642:  /* *rotlqi3_split */
    case 634:  /* xorqi3 */
    case 626:  /* iorqi3 */
    case 618:  /* andqi3 */
    case 537:  /* *mulhi3_enh_split */
    case 300:  /* *mulqi3_enh_split */
    case 276:  /* subuqq3 */
    case 275:  /* subqq3 */
    case 274:  /* subqi3 */
    case 272:  /* subpsi3 */
    case 198:  /* *adduha3_split */
    case 197:  /* *addha3_split */
    case 196:  /* *adduhq3_split */
    case 195:  /* *addhq3_split */
    case 194:  /* *addhi3_split */
    case 176:  /* adduqq3 */
    case 175:  /* addqq3 */
    case 174:  /* addqi3 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (pat, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XEXP (pat, 1), 1));
      break;

    case 173:  /* *strlenhi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 0), 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0, 2));
      break;

    case 172:  /* *strlenhi_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (XEXP (pat, 1), 0, 0), 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (pat, 1), 0, 2));
      break;

    case 171:  /* *clrmemhi */
    case 170:  /* *clrmemhi_split */
    case 169:  /* *clrmemqi */
    case 168:  /* *clrmemqi_split */
      ro[0] = *(ro_loc[0] = &XEXP (XEXP (XVECEXP (pat, 0, 0), 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 3), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 4), 0));
      break;

    case 167:  /* *cpymemx_hi */
    case 166:  /* *cpymemx_qi */
    case 165:  /* cpymemx_hi */
    case 164:  /* cpymemx_qi */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 1), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XVECEXP (pat, 0, 8), 0), 0));
      break;

    case 163:  /* *cpymem_hi */
    case 162:  /* *cpymem_qi */
    case 161:  /* cpymem_hi */
    case 160:  /* cpymem_qi */
      ro[0] = *(ro_loc[0] = &XVECEXP (XVECEXP (pat, 0, 1), 0, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 6), 0));
      break;

    case 156:  /* set_some */
      ro[0] = *(ro_loc[0] = &PATTERN (insn));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 1), 0));
      ro[3] = *(ro_loc[3] = &XEXP (XVECEXP (pat, 0, 2), 0));
      ro[4] = *(ro_loc[4] = &XEXP (XVECEXP (pat, 0, 3), 0));
      ro[5] = *(ro_loc[5] = &XEXP (XVECEXP (pat, 0, 5), 0));
      ro[6] = *(ro_loc[6] = &XEXP (XVECEXP (pat, 0, 5), 1));
      break;

    case 3135:  /* roundusq3_const */
    case 3134:  /* roundusa3_const */
    case 3133:  /* rounduha3_const */
    case 3132:  /* rounduhq3_const */
    case 3131:  /* rounduqq3_const */
    case 3130:  /* roundsq3_const */
    case 3129:  /* roundsa3_const */
    case 3128:  /* roundha3_const */
    case 3127:  /* roundhq3_const */
    case 3126:  /* roundqq3_const */
    case 1065:  /* fmulsu_insn */
    case 1061:  /* fmuls_insn */
    case 1057:  /* fmul_insn */
    case 122:  /* movhi_sp_r */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XVECEXP (XEXP (pat, 1), 0, 0));
      ro[2] = *(ro_loc[2] = &XVECEXP (XEXP (pat, 1), 0, 1));
      break;

    case 159:  /* *reload_insf */
    case 145:  /* *reload_insi */
    case 144:  /* *reload_insi */
    case 143:  /* *reload_insi */
    case 142:  /* *reload_insi */
    case 141:  /* *reload_insi */
    case 138:  /* *reload_inpsi */
    case 127:  /* *reload_inuha */
    case 126:  /* *reload_inha */
    case 125:  /* *reload_inuhq */
    case 124:  /* *reload_inhq */
    case 123:  /* *reload_inhi */
    case 121:  /* *reload_inuqq */
    case 120:  /* *reload_inqq */
    case 119:  /* *reload_inqi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 0), 1));
      ro[2] = *(ro_loc[2] = &XEXP (XVECEXP (pat, 0, 1), 0));
      break;

    case 157:  /* *movsf_split */
    case 150:  /* *movusa_split */
    case 149:  /* *movsa_split */
    case 148:  /* *movusq_split */
    case 147:  /* *movsq_split */
    case 146:  /* *movsi_split */
    case 139:  /* *movpsi_split */
    case 132:  /* *movuha_split */
    case 131:  /* *movha_split */
    case 130:  /* *movuhq_split */
    case 129:  /* *movhq_split */
    case 128:  /* *movhi_split */
    case 115:  /* movuqq_insn_split */
    case 114:  /* movqq_insn_split */
    case 113:  /* movqi_insn_split */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (pat, 1));
      break;

    case 3363:  /* *umulsidi3_insn */
    case 3362:  /* *mulsidi3_insn */
    case 3361:  /* umulsidi3_insn */
    case 3360:  /* mulsidi3_insn */
    case 3359:  /* *rotluta3_insn */
    case 3358:  /* *lshruta3_insn */
    case 3357:  /* *ashruta3_insn */
    case 3356:  /* *ashluta3_insn */
    case 3355:  /* *rotlta3_insn */
    case 3354:  /* *lshrta3_insn */
    case 3353:  /* *ashrta3_insn */
    case 3352:  /* *ashlta3_insn */
    case 3351:  /* *rotluda3_insn */
    case 3350:  /* *lshruda3_insn */
    case 3349:  /* *ashruda3_insn */
    case 3348:  /* *ashluda3_insn */
    case 3347:  /* *rotlda3_insn */
    case 3346:  /* *lshrda3_insn */
    case 3345:  /* *ashrda3_insn */
    case 3344:  /* *ashlda3_insn */
    case 3343:  /* *rotludq3_insn */
    case 3342:  /* *lshrudq3_insn */
    case 3341:  /* *ashrudq3_insn */
    case 3340:  /* *ashludq3_insn */
    case 3339:  /* *rotldq3_insn */
    case 3338:  /* *lshrdq3_insn */
    case 3337:  /* *ashrdq3_insn */
    case 3336:  /* *ashldq3_insn */
    case 3335:  /* *rotldi3_insn */
    case 3334:  /* *lshrdi3_insn */
    case 3333:  /* *ashrdi3_insn */
    case 3332:  /* *ashldi3_insn */
    case 3331:  /* rotluta3_insn */
    case 3330:  /* lshruta3_insn */
    case 3329:  /* ashruta3_insn */
    case 3328:  /* ashluta3_insn */
    case 3327:  /* rotlta3_insn */
    case 3326:  /* lshrta3_insn */
    case 3325:  /* ashrta3_insn */
    case 3324:  /* ashlta3_insn */
    case 3323:  /* rotluda3_insn */
    case 3322:  /* lshruda3_insn */
    case 3321:  /* ashruda3_insn */
    case 3320:  /* ashluda3_insn */
    case 3319:  /* rotlda3_insn */
    case 3318:  /* lshrda3_insn */
    case 3317:  /* ashrda3_insn */
    case 3316:  /* ashlda3_insn */
    case 3315:  /* rotludq3_insn */
    case 3314:  /* lshrudq3_insn */
    case 3313:  /* ashrudq3_insn */
    case 3312:  /* ashludq3_insn */
    case 3311:  /* rotldq3_insn */
    case 3310:  /* lshrdq3_insn */
    case 3309:  /* ashrdq3_insn */
    case 3308:  /* ashldq3_insn */
    case 3307:  /* rotldi3_insn */
    case 3306:  /* lshrdi3_insn */
    case 3305:  /* ashrdi3_insn */
    case 3304:  /* ashldi3_insn */
    case 3289:  /* compare_const8_di2 */
    case 3287:  /* compare_uta2 */
    case 3286:  /* compare_ta2 */
    case 3285:  /* compare_uda2 */
    case 3284:  /* compare_da2 */
    case 3283:  /* compare_udq2 */
    case 3282:  /* compare_dq2 */
    case 3281:  /* compare_di2 */
    case 3273:  /* *negdi2_insn */
    case 3272:  /* negdi2_insn */
    case 3259:  /* *ussubuta3_insn */
    case 3258:  /* *usadduta3_insn */
    case 3257:  /* *ussubuda3_insn */
    case 3256:  /* *usadduda3_insn */
    case 3255:  /* *ussubudq3_insn */
    case 3254:  /* *usaddudq3_insn */
    case 3253:  /* ussubuta3_insn */
    case 3252:  /* usadduta3_insn */
    case 3251:  /* ussubuda3_insn */
    case 3250:  /* usadduda3_insn */
    case 3249:  /* ussubudq3_insn */
    case 3248:  /* usaddudq3_insn */
    case 3235:  /* *sssubta3_insn */
    case 3234:  /* *ssaddta3_insn */
    case 3233:  /* *sssubda3_insn */
    case 3232:  /* *ssaddda3_insn */
    case 3231:  /* *sssubdq3_insn */
    case 3230:  /* *ssadddq3_insn */
    case 3229:  /* sssubta3_insn */
    case 3228:  /* ssaddta3_insn */
    case 3227:  /* sssubda3_insn */
    case 3226:  /* ssaddda3_insn */
    case 3225:  /* sssubdq3_insn */
    case 3224:  /* ssadddq3_insn */
    case 3209:  /* *subuta3_insn */
    case 3208:  /* *subta3_insn */
    case 3207:  /* *subuda3_insn */
    case 3206:  /* *subda3_insn */
    case 3205:  /* *subudq3_insn */
    case 3204:  /* *subdq3_insn */
    case 3203:  /* *subdi3_insn */
    case 3202:  /* subuta3_insn */
    case 3201:  /* subta3_insn */
    case 3200:  /* subuda3_insn */
    case 3199:  /* subda3_insn */
    case 3198:  /* subudq3_insn */
    case 3197:  /* subdq3_insn */
    case 3196:  /* subdi3_insn */
    case 3181:  /* *adddi3_const8_insn */
    case 3180:  /* adddi3_const8_insn */
    case 3179:  /* *adduta3_insn */
    case 3178:  /* *addta3_insn */
    case 3177:  /* *adduda3_insn */
    case 3176:  /* *addda3_insn */
    case 3175:  /* *addudq3_insn */
    case 3174:  /* *adddq3_insn */
    case 3173:  /* *adddi3_insn */
    case 3172:  /* adduta3_insn */
    case 3171:  /* addta3_insn */
    case 3170:  /* adduda3_insn */
    case 3169:  /* addda3_insn */
    case 3168:  /* addudq3_insn */
    case 3167:  /* adddq3_insn */
    case 3166:  /* adddi3_insn */
    case 3165:  /* *roundusa3.libgcc */
    case 3164:  /* *roundsa3.libgcc */
    case 3163:  /* *roundusq3.libgcc */
    case 3162:  /* *roundsq3.libgcc */
    case 3161:  /* *roundusa3.libgcc_split */
    case 3160:  /* *roundsa3.libgcc_split */
    case 3159:  /* *roundusq3.libgcc_split */
    case 3158:  /* *roundsq3.libgcc_split */
    case 3157:  /* *rounduha3.libgcc */
    case 3156:  /* *roundha3.libgcc */
    case 3155:  /* *rounduhq3.libgcc */
    case 3154:  /* *roundhq3.libgcc */
    case 3153:  /* *rounduha3.libgcc_split */
    case 3152:  /* *roundha3.libgcc_split */
    case 3151:  /* *rounduhq3.libgcc_split */
    case 3150:  /* *roundhq3.libgcc_split */
    case 3149:  /* *rounduqq3.libgcc */
    case 3148:  /* *roundqq3.libgcc */
    case 3147:  /* *rounduqq3.libgcc_split */
    case 3146:  /* *roundqq3.libgcc_split */
    case 3125:  /* *divusa3.call */
    case 3124:  /* *udivusa3.call */
    case 3123:  /* *divsa3.call */
    case 3122:  /* *udivsa3.call */
    case 3121:  /* *divusa3.call_split */
    case 3120:  /* *udivusa3.call_split */
    case 3119:  /* *divsa3.call_split */
    case 3118:  /* *udivsa3.call_split */
    case 3117:  /* *divuha3.call */
    case 3116:  /* *udivuha3.call */
    case 3115:  /* *divha3.call */
    case 3114:  /* *udivha3.call */
    case 3113:  /* *divuhq3.call */
    case 3112:  /* *udivuhq3.call */
    case 3111:  /* *divhq3.call */
    case 3110:  /* *udivhq3.call */
    case 3109:  /* *divuha3.call_split */
    case 3108:  /* *udivuha3.call_split */
    case 3107:  /* *divha3.call_split */
    case 3106:  /* *udivha3.call_split */
    case 3105:  /* *divuhq3.call_split */
    case 3104:  /* *udivuhq3.call_split */
    case 3103:  /* *divhq3.call_split */
    case 3102:  /* *udivhq3.call_split */
    case 3101:  /* *divuqq3.call */
    case 3100:  /* *udivuqq3.call */
    case 3099:  /* *divqq3.call */
    case 3098:  /* *udivqq3.call */
    case 3097:  /* *divuqq3.call_split */
    case 3096:  /* *udivuqq3.call_split */
    case 3095:  /* *divqq3.call_split */
    case 3094:  /* *udivqq3.call_split */
    case 3093:  /* *mulusa3.call */
    case 3092:  /* *mulsa3.call */
    case 3091:  /* *mulusa3.call_split */
    case 3090:  /* *mulsa3.call_split */
    case 3089:  /* *muluha3.call */
    case 3088:  /* *mulha3.call */
    case 3087:  /* *muluhq3.call */
    case 3086:  /* *mulhq3.call */
    case 3085:  /* *muluha3.call_split */
    case 3084:  /* *mulha3.call_split */
    case 3083:  /* *muluhq3.call_split */
    case 3082:  /* *mulhq3.call_split */
    case 3081:  /* *mulqq3.call */
    case 3080:  /* *mulqq3.call_split */
    case 3075:  /* *ssnegsq2 */
    case 3074:  /* *ssabssq2 */
    case 3073:  /* *ssnegsa2 */
    case 3072:  /* *ssabssa2 */
    case 3071:  /* *ssnegsq2_split */
    case 3070:  /* *ssabssq2_split */
    case 3069:  /* *ssnegsa2_split */
    case 3068:  /* *ssabssa2_split */
    case 3067:  /* *ssnegha2 */
    case 3066:  /* *ssabsha2 */
    case 3065:  /* *ssneghq2 */
    case 3064:  /* *ssabshq2 */
    case 3063:  /* *ssnegha2_split */
    case 3062:  /* *ssabsha2_split */
    case 3061:  /* *ssneghq2_split */
    case 3060:  /* *ssabshq2_split */
    case 1068:  /* *fmulsu.call */
    case 1067:  /* *fmulsu.call_split */
    case 1064:  /* *fmuls.call */
    case 1063:  /* *fmuls.call_split */
    case 1060:  /* *fmul.call */
    case 1059:  /* *fmul.call_split */
    case 1053:  /* *bswapsi2.libgcc */
    case 1052:  /* *bswapsi2.libgcc_split */
    case 1050:  /* *ffssihi2.libgcc */
    case 1049:  /* *ffssihi2.libgcc_split */
    case 1048:  /* *ffshi2.libgcc */
    case 1047:  /* *ffshi2.libgcc_split */
    case 1046:  /* *ctzsihi2.libgcc */
    case 1045:  /* *ctzsihi2.libgcc_split */
    case 1044:  /* *ctzhi2.libgcc */
    case 1043:  /* *ctzhi2.libgcc_split */
    case 1042:  /* *clzsihi2.libgcc */
    case 1041:  /* *clzsihi2.libgcc_split */
    case 1040:  /* *clzhi2.libgcc */
    case 1039:  /* *clzhi2.libgcc_split */
    case 1038:  /* *popcountqihi2.libgcc */
    case 1037:  /* *popcountqi2.libgcc */
    case 1036:  /* *popcountqi2.libgcc_split */
    case 1035:  /* *popcountsi2.libgcc */
    case 1034:  /* *popcountsi2.libgcc_split */
    case 1033:  /* *popcounthi2.libgcc */
    case 1032:  /* *popcounthi2.libgcc_split */
    case 1030:  /* *paritysihi2.libgcc */
    case 1029:  /* *paritysihi2.libgcc_split */
    case 1028:  /* *parityqihi2.libgcc */
    case 1027:  /* *parityqihi2.libgcc_split */
    case 1026:  /* *parityhi2.libgcc */
    case 1025:  /* *parityhi2.libgcc_split */
    case 1002:  /* return_from_naked_epilogue */
    case 1001:  /* return_from_interrupt_epilogue */
    case 1000:  /* return_from_epilogue */
    case 999:  /* return */
    case 972:  /* nop */
    case 794:  /* *negsi2.libgcc */
    case 617:  /* *udivmodsi4_call */
    case 616:  /* *udivmodsi4_call_split */
    case 614:  /* *divmodsi4_call */
    case 613:  /* *divmodsi4_call_split */
    case 611:  /* *udivmodpsi4_call */
    case 610:  /* *udivmodpsi4_call_split */
    case 608:  /* *divmodpsi4_call */
    case 607:  /* *divmodpsi4_call_split */
    case 605:  /* *mulpsi3.libgcc */
    case 604:  /* *mulpsi3.libgcc_split */
    case 603:  /* *mulsqipsi3.libgcc */
    case 602:  /* *mulsqipsi3.libgcc_split */
    case 595:  /* *udivmodhi4_call */
    case 594:  /* *udivmodhi4_call_split */
    case 592:  /* *divmodhi4_call */
    case 591:  /* *divmodhi4_call_split */
    case 589:  /* *udivmodqi4_call */
    case 588:  /* *udivmodqi4_call_split */
    case 586:  /* *divmodqi4_call */
    case 585:  /* *divmodqi4_call_split */
    case 583:  /* *mulohisi3_call */
    case 582:  /* *mulohisi3_call_split */
    case 581:  /* *muluhisi3_call */
    case 580:  /* *mulshisi3_call */
    case 579:  /* *muluhisi3_call_split */
    case 578:  /* *mulshisi3_call_split */
    case 577:  /* *usmulhisi3_call */
    case 576:  /* *usmulhisi3_call_split */
    case 575:  /* *umulhi3_highpart_call */
    case 574:  /* *smulhi3_highpart_call */
    case 573:  /* *umulhi3_highpart_call_split */
    case 572:  /* *smulhi3_highpart_call_split */
    case 571:  /* *umulhisi3_call */
    case 570:  /* *mulhisi3_call */
    case 569:  /* *umulhisi3_call_split */
    case 568:  /* *mulhisi3_call_split */
    case 567:  /* *mulsi3_call_pr118012 */
    case 566:  /* *mulsi3_call */
    case 565:  /* *mulsi3_call_pr118012_split */
    case 564:  /* *mulsi3_call_split */
    case 540:  /* *mulhi3_call */
    case 539:  /* *mulhi3_call_split */
    case 477:  /* *umulqihi3.call */
    case 476:  /* *umulqihi3.call_split */
    case 303:  /* *mulqi3_call */
    case 302:  /* *mulqi3_call_split */
    case 112:  /* *fxload_psi_libgcc */
    case 111:  /* *fxload_sf_libgcc */
    case 110:  /* *fxload_usa_libgcc */
    case 109:  /* *fxload_sa_libgcc */
    case 108:  /* *fxload_usq_libgcc */
    case 107:  /* *fxload_sq_libgcc */
    case 106:  /* *fxload_si_libgcc */
    case 105:  /* *fxload_uha_libgcc */
    case 104:  /* *fxload_ha_libgcc */
    case 103:  /* *fxload_uhq_libgcc */
    case 102:  /* *fxload_hq_libgcc */
    case 101:  /* *fxload_hi_libgcc */
    case 100:  /* *fxload_uqq_libgcc */
    case 99:  /* *fxload_qq_libgcc */
    case 98:  /* *fxload_qi_libgcc */
    case 97:  /* fxload_psi_libgcc */
    case 96:  /* fxload_sf_libgcc */
    case 95:  /* fxload_usa_libgcc */
    case 94:  /* fxload_sa_libgcc */
    case 93:  /* fxload_usq_libgcc */
    case 92:  /* fxload_sq_libgcc */
    case 91:  /* fxload_si_libgcc */
    case 90:  /* fxload_uha_libgcc */
    case 89:  /* fxload_ha_libgcc */
    case 88:  /* fxload_uhq_libgcc */
    case 87:  /* fxload_hq_libgcc */
    case 86:  /* fxload_hi_libgcc */
    case 85:  /* fxload_uqq_libgcc */
    case 84:  /* fxload_qq_libgcc */
    case 83:  /* fxload_qi_libgcc */
      break;

    case 1023:  /* *parityqihi2.1 */
    case 788:  /* *negqihi2 */
    case 527:  /* *ashiftqihi2.signx.1 */
    case 67:  /* fmovpsi */
    case 66:  /* fmovsf */
    case 65:  /* fmovusa */
    case 64:  /* fmovsa */
    case 63:  /* fmovusq */
    case 62:  /* fmovsq */
    case 61:  /* fmovsi */
    case 60:  /* fmovuha */
    case 59:  /* fmovha */
    case 58:  /* fmovuhq */
    case 57:  /* fmovhq */
    case 56:  /* fmovhi */
    case 55:  /* fmovuqq */
    case 54:  /* fmovqq */
    case 53:  /* fmovqi */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (XVECEXP (pat, 0, 0), 1), 0), 0));
      break;

    case 787:  /* *negqihi2_split */
    case 526:  /* *ashiftqihi2.signx.1_split */
    case 52:  /* xmovuqq_8 */
    case 51:  /* xmovqq_8 */
    case 50:  /* xmovqi_8 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 0));
      ro[1] = *(ro_loc[1] = &XEXP (XEXP (XEXP (pat, 1), 0), 0));
      break;

    case 158:  /* *movsf */
    case 155:  /* *movusa */
    case 154:  /* *movsa */
    case 153:  /* *movusq */
    case 152:  /* *movsq */
    case 151:  /* *movsi */
    case 140:  /* *movpsi */
    case 137:  /* *movuha */
    case 136:  /* *movha */
    case 135:  /* *movuhq */
    case 134:  /* *movhq */
    case 133:  /* *movhi */
    case 118:  /* movuqq_insn */
    case 117:  /* movqq_insn */
    case 116:  /* movqi_insn */
    case 82:  /* fxloadpsi_A */
    case 81:  /* fxloadsf_A */
    case 80:  /* fxloadusa_A */
    case 79:  /* fxloadsa_A */
    case 78:  /* fxloadusq_A */
    case 77:  /* fxloadsq_A */
    case 76:  /* fxloadsi_A */
    case 75:  /* fxloaduha_A */
    case 74:  /* fxloadha_A */
    case 73:  /* fxloaduhq_A */
    case 72:  /* fxloadhq_A */
    case 71:  /* fxloadhi_A */
    case 70:  /* fxloaduqq_A */
    case 69:  /* fxloadqq_A */
    case 68:  /* fxloadqi_A */
    case 49:  /* fxmovpsi_A */
    case 48:  /* fxmovsf_A */
    case 47:  /* fxmovusa_A */
    case 46:  /* fxmovsa_A */
    case 45:  /* fxmovusq_A */
    case 44:  /* fxmovsq_A */
    case 43:  /* fxmovsi_A */
    case 42:  /* fxmovuha_A */
    case 41:  /* fxmovha_A */
    case 40:  /* fxmovuhq_A */
    case 39:  /* fxmovhq_A */
    case 38:  /* fxmovhi_A */
    case 37:  /* fxmovuqq_A */
    case 36:  /* fxmovqq_A */
    case 35:  /* fxmovqi_A */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 0));
      ro[1] = *(ro_loc[1] = &XEXP (XVECEXP (pat, 0, 0), 1));
      break;

    case 34:  /* *load_psi_libgcc */
    case 33:  /* *load_sf_libgcc */
    case 32:  /* *load_usa_libgcc */
    case 31:  /* *load_sa_libgcc */
    case 30:  /* *load_usq_libgcc */
    case 29:  /* *load_sq_libgcc */
    case 28:  /* *load_si_libgcc */
    case 27:  /* *load_uha_libgcc */
    case 26:  /* *load_ha_libgcc */
    case 25:  /* *load_uhq_libgcc */
    case 24:  /* *load_hq_libgcc */
    case 23:  /* *load_hi_libgcc */
    case 22:  /* *load_uqq_libgcc */
    case 21:  /* *load_qq_libgcc */
    case 20:  /* *load_qi_libgcc */
      ro[0] = *(ro_loc[0] = &XEXP (XVECEXP (pat, 0, 0), 1));
      break;

    case 973:  /* *indirect_jump */
    case 19:  /* load_psi_libgcc */
    case 18:  /* load_sf_libgcc */
    case 17:  /* load_usa_libgcc */
    case 16:  /* load_sa_libgcc */
    case 15:  /* load_usq_libgcc */
    case 14:  /* load_sq_libgcc */
    case 13:  /* load_si_libgcc */
    case 12:  /* load_uha_libgcc */
    case 11:  /* load_ha_libgcc */
    case 10:  /* load_uhq_libgcc */
    case 9:  /* load_hq_libgcc */
    case 8:  /* load_hi_libgcc */
    case 7:  /* load_uqq_libgcc */
    case 6:  /* load_qq_libgcc */
    case 5:  /* load_qi_libgcc */
    case 4:  /* pushhi1_insn */
    case 3:  /* pushuqq1 */
    case 2:  /* pushqq1 */
    case 1:  /* pushqi1 */
      ro[0] = *(ro_loc[0] = &XEXP (pat, 1));
      break;

    }
}
