/******************************************************************************
  This source file is part of the Avogadro project.
  This source code is released under the 3-Clause BSD License, (see "LICENSE").
******************************************************************************/

#include <QtCore/QtPlugin>

#include "/build/avogadrolibs/src/avogadrolibs/avogadro/qtplugins/surfaces/orbitals.h"


namespace Avogadro::QtPlugins {

class OrbitalsFactory : public QObject, public QtGui::ExtensionPluginFactory
{
  Q_OBJECT
  Q_PLUGIN_METADATA(IID "org.openchemistry.avogadro.ExtensionPluginFactory")
  Q_INTERFACES(Avogadro::QtGui::ExtensionPluginFactory)

public:
  explicit OrbitalsFactory(QObject* parent_ = nullptr) : QObject(parent_) {}

  QtGui::ExtensionPlugin* createInstance(QObject* parent_ = nullptr) override
  {
    auto* object = new Orbitals(parent_);
    object->setObjectName("Orbitals");
    return object;
  }

  QString identifier() const override { return "Orbitals"; }

  QString description() const override { return "Render Molecular Orbitals"; }

};

} // namespace Avogadro::QtPlugins

#include "OrbitalsPlugin.moc"
