// SPDX-License-Identifier: LGPL-2.1-only OR LGPL-3.0-only OR LicenseRef-KDE-Accepted-LGPL
// SPDX-FileCopyrightText: 2024 Arjen Hiemstra <ahiemstra@heimr.nl>
//
// This file is automatically generated from property.cpp.j2.
// To regenerate, run `tools/propertygenerator/generate_properties.py`.

#include "CornersProperty.h"

#include <QRegularExpression>

#include "PropertiesTypes.h"

using namespace Union::Properties;
using namespace Qt::StringLiterals;

class Union::Properties::CornersPropertyPrivate
{
public:
    std::unique_ptr<CornerProperty> topLeft;
    std::unique_ptr<CornerProperty> topRight;
    std::unique_ptr<CornerProperty> bottomLeft;
    std::unique_ptr<CornerProperty> bottomRight;
};

CornersProperty::CornersProperty()
    : d(std::make_unique<CornersPropertyPrivate>())
{
}

CornersProperty::CornersProperty(const CornersProperty &other)
    : d(std::make_unique<CornersPropertyPrivate>())
{
    d->topLeft = std::make_unique<CornerProperty>();
    *(d->topLeft) = *(other.d->topLeft);
    d->topRight = std::make_unique<CornerProperty>();
    *(d->topRight) = *(other.d->topRight);
    d->bottomLeft = std::make_unique<CornerProperty>();
    *(d->bottomLeft) = *(other.d->bottomLeft);
    d->bottomRight = std::make_unique<CornerProperty>();
    *(d->bottomRight) = *(other.d->bottomRight);
}

CornersProperty::CornersProperty(CornersProperty &&other)
    : d(std::move(other.d))
{
}

CornersProperty::~CornersProperty() = default;

CornersProperty &CornersProperty::operator=(const CornersProperty &other)
{
    if (this != &other) {
        *(d->topLeft) = *(other.d->topLeft);
        *(d->topRight) = *(other.d->topRight);
        *(d->bottomLeft) = *(other.d->bottomLeft);
        *(d->bottomRight) = *(other.d->bottomRight);
    }
    return *this;
}

CornersProperty &CornersProperty::operator=(CornersProperty &&other)
{
    std::swap(d, other.d);
    return *this;
}

CornerProperty *CornersProperty::topLeft() const
{
    return d->topLeft.get();
}

void CornersProperty::setTopLeft(std::unique_ptr<CornerProperty> &&newValue)
{
    d->topLeft = std::move(newValue);
}

CornerProperty *CornersProperty::topRight() const
{
    return d->topRight.get();
}

void CornersProperty::setTopRight(std::unique_ptr<CornerProperty> &&newValue)
{
    d->topRight = std::move(newValue);
}

CornerProperty *CornersProperty::bottomLeft() const
{
    return d->bottomLeft.get();
}

void CornersProperty::setBottomLeft(std::unique_ptr<CornerProperty> &&newValue)
{
    d->bottomLeft = std::move(newValue);
}

CornerProperty *CornersProperty::bottomRight() const
{
    return d->bottomRight.get();
}

void CornersProperty::setBottomRight(std::unique_ptr<CornerProperty> &&newValue)
{
    d->bottomRight = std::move(newValue);
}

bool CornersProperty::hasAnyValue() const
{
    if (d->topLeft && d->topLeft->hasAnyValue()) {
        return true;
    }
    if (d->topRight && d->topRight->hasAnyValue()) {
        return true;
    }
    if (d->bottomLeft && d->bottomLeft->hasAnyValue()) {
        return true;
    }
    if (d->bottomRight && d->bottomRight->hasAnyValue()) {
        return true;
    }
    return false;
}

bool CornersProperty::isEmpty() const
{
    if (!hasAnyValue()) {
        return true;
    }

    if (d->topLeft && !d->topLeft->isEmpty()) {
        return false;
    }
    if (d->topRight && !d->topRight->isEmpty()) {
        return false;
    }
    if (d->bottomLeft && !d->bottomLeft->isEmpty()) {
        return false;
    }
    if (d->bottomRight && !d->bottomRight->isEmpty()) {
        return false;
    }

    return true;
}

QString CornersProperty::toString(int indentation, ToStringFlags flags) const
{
    if (!hasAnyValue()) {
        return u"(empty)"_s;
    }

    const bool multiline = flags & ToStringFlag::MultiLine;
    const bool types = flags & ToStringFlag::Types;

    QString result;
    QTextStream out(&result);

    constexpr auto indent = [](int amount, bool multiline, bool first) {
        if (multiline) {
            return QByteArray(amount, ' ');
        } else if (!first) {
            return QByteArray(", ");
        } else {
            return QByteArray(" ");
        }
    };

    const QByteArray maybeNewLine = multiline ? "\n" : "";
    const QByteArray empty = "(empty)";

    if (types) {
        out << "CornersProperty(" << maybeNewLine;
    } else if (indentation > 0) {
        out << maybeNewLine;
    }

    out << indent(indentation, multiline, true) << "topLeft: ";
    if (d->topLeft) {
        out << d->topLeft->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "topRight: ";
    if (d->topRight) {
        out << d->topRight->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "bottomLeft: ";
    if (d->bottomLeft) {
        out << d->bottomLeft->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }
    out << indent(indentation, multiline, false) << "bottomRight: ";
    if (d->bottomRight) {
        out << d->bottomRight->toString(indentation + 2, flags);
    } else {
        out << empty << maybeNewLine;
    }

    if (types) {
        out << indent(indentation - 2, multiline, true) << ")";
    }
    out << maybeNewLine;

    out.flush();

    return result;
}

void CornersProperty::resolveProperties(const CornersProperty *source, CornersProperty *destination)
{
    if (!source || !destination) {
        return;
    }

    if (source->d->topLeft) {
        if (!destination->d->topLeft) {
            destination->d->topLeft = std::make_unique<CornerProperty>();
        }
        CornerProperty::resolveProperties(source->d->topLeft.get(), destination->d->topLeft.get());
    }
    if (source->d->topRight) {
        if (!destination->d->topRight) {
            destination->d->topRight = std::make_unique<CornerProperty>();
        }
        CornerProperty::resolveProperties(source->d->topRight.get(), destination->d->topRight.get());
    }
    if (source->d->bottomLeft) {
        if (!destination->d->bottomLeft) {
            destination->d->bottomLeft = std::make_unique<CornerProperty>();
        }
        CornerProperty::resolveProperties(source->d->bottomLeft.get(), destination->d->bottomLeft.get());
    }
    if (source->d->bottomRight) {
        if (!destination->d->bottomRight) {
            destination->d->bottomRight = std::make_unique<CornerProperty>();
        }
        CornerProperty::resolveProperties(source->d->bottomRight.get(), destination->d->bottomRight.get());
    }
}

std::unique_ptr<CornersProperty> CornersProperty::empty()
{
    auto result = std::make_unique<CornersProperty>();
    result->d->topLeft = CornerProperty::empty();
    result->d->topRight = CornerProperty::empty();
    result->d->bottomLeft = CornerProperty::empty();
    result->d->bottomRight = CornerProperty::empty();
    return result;
}

CornersProperty::CornerRadii CornersProperty::radii() const
{
    CornerRadii result;

    if (d->topLeft) {
        result.topLeft = d->topLeft->radius().value_or(0.0);
    }
    if (d->topRight) {
        result.topRight = d->topRight->radius().value_or(0.0);
    }
    if (d->bottomLeft) {
        result.bottomLeft = d->bottomLeft->radius().value_or(0.0);
    }
    if (d->bottomRight) {
        result.bottomRight = d->bottomRight->radius().value_or(0.0);
    }

    return result;
}

bool Union::Properties::operator==(const CornersProperty &left, const CornersProperty &right)
{
    if (left.topLeft() && right.topLeft()) {
        if (*(left.topLeft()) != *(right.topLeft())) {
            return false;
        }
    } else if (left.topLeft() != right.topLeft()) {
        return false;
    }
    if (left.topRight() && right.topRight()) {
        if (*(left.topRight()) != *(right.topRight())) {
            return false;
        }
    } else if (left.topRight() != right.topRight()) {
        return false;
    }
    if (left.bottomLeft() && right.bottomLeft()) {
        if (*(left.bottomLeft()) != *(right.bottomLeft())) {
            return false;
        }
    } else if (left.bottomLeft() != right.bottomLeft()) {
        return false;
    }
    if (left.bottomRight() && right.bottomRight()) {
        if (*(left.bottomRight()) != *(right.bottomRight())) {
            return false;
        }
    } else if (left.bottomRight() != right.bottomRight()) {
        return false;
    }
    return true;
}

QDebug operator<<(QDebug debug, Union::Properties::CornersProperty *type)
{
    QDebugStateSaver saver(debug);
    debug.nospace() << qPrintable(type->toString(0, ToStringFlag::Types));
    return debug;
}