/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.mordant.terminal.CursorMovements;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0014\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\rH\u0016J\b\u0010\u0014\u001a\u00020\u000bH\u0016J\b\u0010\u0015\u001a\u00020\u000bH\u0016J\b\u0010\u0016\u001a\u00020\u000bH\u0016J\b\u0010\u0017\u001a\u00020\u000bH\u0016J\b\u0010\u0018\u001a\u00020\u000bH\u0016J\b\u0010\u0019\u001a\u00020\u000bH\u0016J\b\u0010\u001a\u001a\u00020\u000bH\u0016J\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u000bH\u0016J\u0010\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u001e\u001a\u00020\u0007H\u0002J\u0010\u0010\u001f\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\u0007H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006!"}, d2={"Lcom/github/ajalt/mordant/terminal/AnsiMovements;", "Lcom/github/ajalt/mordant/terminal/CursorMovements;", "<init>", "()V", "builder", "Ljava/lang/StringBuilder;", "output", "", "getOutput", "()Ljava/lang/String;", "up", "", "count", "", "down", "right", "left", "setPosition", "x", "y", "startOfLine", "clearScreen", "clearScreenAfterCursor", "clearScreenBeforeCursor", "clearLineAfterCursor", "clearLineBeforeCursor", "clearLine", "savePosition", "restorePosition", "csi", "command", "print", "text", "mordant"})
@SourceDebugExtension(value={"SMAP\nTerminalCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalCursor.kt\ncom/github/ajalt/mordant/terminal/AnsiMovements\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,201:1\n1#2:202\n*E\n"})
final class AnsiMovements
implements CursorMovements {
    @NotNull
    private final StringBuilder builder = new StringBuilder();

    @NotNull
    public final String getOutput() {
        String string = this.builder.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        return string;
    }

    @Override
    public void up(int count2) {
        if (count2 < 0) {
            this.down(-count2);
        } else if (count2 > 0) {
            this.csi("" + count2 + 'A');
        }
    }

    @Override
    public void down(int count2) {
        if (count2 < 0) {
            this.up(-count2);
        } else if (count2 > 0) {
            this.csi("" + count2 + 'B');
        }
    }

    @Override
    public void right(int count2) {
        if (count2 < 0) {
            this.left(-count2);
        } else if (count2 > 0) {
            this.csi("" + count2 + 'C');
        }
    }

    @Override
    public void left(int count2) {
        if (count2 < 0) {
            this.right(-count2);
        } else if (count2 > 0) {
            this.csi("" + count2 + 'D');
        }
    }

    @Override
    public void setPosition(int x, int y) {
        if (!(x >= 0)) {
            boolean $i$a$-require-AnsiMovements$setPosition$32 = false;
            String $i$a$-require-AnsiMovements$setPosition$32 = "Invalid cursor column " + x + "; value cannot be negative";
            throw new IllegalArgumentException($i$a$-require-AnsiMovements$setPosition$32.toString());
        }
        if (!(y >= 0)) {
            boolean bl = false;
            String string = "Invalid cursor column " + y + "; value cannot be negative";
            throw new IllegalArgumentException(string.toString());
        }
        this.csi("" + (y + 1) + ';' + (x + 1) + 'H');
    }

    @Override
    public void startOfLine() {
        this.print("\r");
    }

    @Override
    public void clearScreen() {
        this.csi("2J");
    }

    @Override
    public void clearScreenAfterCursor() {
        this.csi("0J");
    }

    @Override
    public void clearScreenBeforeCursor() {
        this.csi("1J");
    }

    @Override
    public void clearLineAfterCursor() {
        this.csi("0K");
    }

    @Override
    public void clearLineBeforeCursor() {
        this.csi("1K");
    }

    @Override
    public void clearLine() {
        this.csi("2K");
    }

    @Override
    public void savePosition() {
        this.csi("s");
    }

    @Override
    public void restorePosition() {
        this.csi("u");
    }

    private final void csi(String command2) {
        this.print("\u001b[" + command2);
    }

    private final void print(String text2) {
        this.builder.append(text2);
    }
}

