/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.security;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.cert.X509Certificate;
import java.util.Map;
import javax.servlet.FilterChain;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.solr.common.util.StrUtils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.security.AuthenticationPlugin;
import org.apache.solr.security.cert.CertPrincipalResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CertAuthPlugin
extends AuthenticationPlugin {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String PARAM_PRINCIPAL_RESOLVER = "principalResolver";
    private static final String PARAM_CLASS = "class";
    private static final String PARAM_PARAMS = "params";
    private static final CertPrincipalResolver DEFAULT_PRINCIPAL_RESOLVER = certificate -> certificate.getSubjectX500Principal();
    protected final CoreContainer coreContainer;
    private CertPrincipalResolver principalResolver;

    public CertAuthPlugin() {
        this(null);
    }

    public CertAuthPlugin(CoreContainer coreContainer) {
        this.coreContainer = coreContainer;
    }

    @Override
    public void init(Map<String, Object> pluginConfig) {
        this.principalResolver = this.resolveComponent(pluginConfig, PARAM_PRINCIPAL_RESOLVER, CertPrincipalResolver.class, DEFAULT_PRINCIPAL_RESOLVER, PARAM_PRINCIPAL_RESOLVER);
    }

    private <T> T resolveComponent(Map<String, Object> pluginConfig, String configKey, Class<T> clazz, T defaultInstance, String componentName) {
        Map configMap = (Map)pluginConfig.get(configKey);
        if (this.coreContainer == null) {
            log.warn("No coreContainer configured. Using the default {}", (Object)componentName);
            return defaultInstance;
        }
        if (configMap == null) {
            log.warn("No {} configured. Using the default one", (Object)componentName);
            return defaultInstance;
        }
        String className = (String)configMap.get(PARAM_CLASS);
        if (StrUtils.isNullOrEmpty((String)className)) {
            log.warn("No {} class configured. Using the default one", (Object)componentName);
            return defaultInstance;
        }
        Map params = (Map)configMap.get(PARAM_PARAMS);
        if (params == null) {
            log.warn("No params found for {}. Using the default class", (Object)componentName);
            return defaultInstance;
        }
        log.info("Found a {} class: {}", (Object)componentName, (Object)className);
        return this.coreContainer.getResourceLoader().newInstance(className, clazz, null, new Class[]{Map.class}, new Object[]{params});
    }

    @Override
    public boolean doAuthenticate(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws Exception {
        X509Certificate[] certs = (X509Certificate[])request.getAttribute("javax.servlet.request.X509Certificate");
        if (certs == null || certs.length == 0) {
            return this.sendError(response, "require certificate");
        }
        HttpServletRequest wrapped = this.wrapWithPrincipal(request, this.principalResolver.resolvePrincipal(certs[0]));
        this.numAuthenticated.inc();
        filterChain.doFilter((ServletRequest)wrapped, (ServletResponse)response);
        return true;
    }

    private boolean sendError(HttpServletResponse response, String msg) throws IOException {
        this.numMissingCredentials.inc();
        response.setHeader("WWW-Authenticate", "Certificate");
        response.sendError(401, msg);
        return false;
    }
}

