/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.facet;

import java.io.IOException;
import java.util.function.IntFunction;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.QueryValueSource;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.facet.FacetContext;
import org.apache.solr.search.facet.FacetMerger;
import org.apache.solr.search.facet.FacetModule;
import org.apache.solr.search.facet.SimpleAggValueSource;
import org.apache.solr.search.facet.SlotAcc;
import org.apache.solr.search.function.FieldNameValueSource;

public class MissingAgg
extends SimpleAggValueSource {
    public MissingAgg(ValueSource vs) {
        super("missing", vs);
    }

    @Override
    public SlotAcc createSlotAcc(FacetContext fcontext, long numDocs, int numSlots) throws IOException {
        ValueSource vs = this.getArg();
        if (vs instanceof FieldNameValueSource) {
            String field = ((FieldNameValueSource)vs).getFieldName();
            SchemaField sf = fcontext.qcontext.searcher().getSchema().getField(field);
            if (sf.multiValued() || sf.getType().multiValuedFieldCache()) {
                Object query = null;
                query = sf.hasDocValues() ? new DocValuesFieldExistsQuery(sf.getName()) : sf.getType().getRangeQuery(null, sf, null, null, false, false);
                vs = new QueryValueSource((Query)query, 0.0f);
            } else {
                vs = sf.getType().getValueSource(sf, null);
            }
        }
        return new MissingSlotAcc(vs, fcontext, numSlots);
    }

    @Override
    public FacetMerger createFacetMerger(Object prototype) {
        return new FacetModule.FacetLongMerger();
    }

    static class MissingSlotAcc
    extends SlotAcc.LongFuncSlotAcc {
        public MissingSlotAcc(ValueSource values, FacetContext fcontext, int numSlots) {
            super(values, fcontext, numSlots, 0L);
        }

        @Override
        public void collect(int doc, int slot, IntFunction<SlotAcc.SlotContext> slotContext) throws IOException {
            if (!this.values.exists(doc)) {
                int n = slot;
                this.result[n] = this.result[n] + 1L;
            }
        }
    }
}

