/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.embedded;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.lucene.search.TotalHits;
import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.StreamingResponseCallback;
import org.apache.solr.client.solrj.impl.BinaryRequestWriter;
import org.apache.solr.client.solrj.impl.BinaryResponseParser;
import org.apache.solr.client.solrj.impl.InputStreamResponseParser;
import org.apache.solr.client.solrj.impl.XMLRequestWriter;
import org.apache.solr.client.solrj.request.ContentStreamUpdateRequest;
import org.apache.solr.client.solrj.request.RequestWriter;
import org.apache.solr.common.SolrDocument;
import org.apache.solr.common.SolrDocumentList;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.MapSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.ContentStreamBase;
import org.apache.solr.common.util.JavaBinCodec;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.Utils;
import org.apache.solr.core.CoreContainer;
import org.apache.solr.core.NodeConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.request.SolrRequestHandler;
import org.apache.solr.request.SolrRequestInfo;
import org.apache.solr.response.BinaryResponseWriter;
import org.apache.solr.response.QueryResponseWriterUtil;
import org.apache.solr.response.ResultContext;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.servlet.SolrRequestParsers;

public class EmbeddedSolrServer
extends SolrClient {
    protected final CoreContainer coreContainer;
    protected final String coreName;
    private final SolrRequestParsers _parser;
    private final RequestWriterSupplier supplier;
    private boolean containerIsLocal = false;

    public EmbeddedSolrServer(Path solrHome, String defaultCoreName) {
        this(EmbeddedSolrServer.load(new CoreContainer(solrHome, new Properties())), defaultCoreName);
        this.containerIsLocal = true;
    }

    public EmbeddedSolrServer(NodeConfig nodeConfig, String defaultCoreName) {
        this(EmbeddedSolrServer.load(new CoreContainer(nodeConfig)), defaultCoreName);
        this.containerIsLocal = true;
    }

    private static CoreContainer load(CoreContainer cc) {
        cc.load();
        return cc;
    }

    public EmbeddedSolrServer(SolrCore core) {
        this(core.getCoreContainer(), core.getName());
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName) {
        this(coreContainer, coreName, RequestWriterSupplier.JavaBin);
    }

    public EmbeddedSolrServer(CoreContainer coreContainer, String coreName, RequestWriterSupplier supplier) {
        if (coreContainer == null) {
            throw new NullPointerException("CoreContainer instance required");
        }
        this.coreContainer = coreContainer;
        this.coreName = coreName;
        this._parser = new SolrRequestParsers(null);
        this.supplier = supplier;
    }

    public NamedList<Object> request(SolrRequest<?> request, String coreName) throws SolrServerException, IOException {
        SolrRequestHandler handler;
        String path = request.getPath();
        if (path == null || !path.startsWith("/")) {
            path = "/select";
        }
        if ((handler = this.coreContainer.getRequestHandler(path)) != null) {
            try {
                SolrQueryRequest req = this._parser.buildRequestFrom(null, EmbeddedSolrServer.getParams(request), this.getContentStreams(request), request.getUserPrincipal());
                req.getContext().put("httpMethod", request.getMethod());
                req.getContext().put("path", path);
                SolrQueryResponse resp = new SolrQueryResponse();
                handler.handleRequest(req, resp);
                EmbeddedSolrServer.checkForExceptions(resp);
                return this.writeResponse(request, req, resp);
            }
            catch (IOException | SolrException iox) {
                throw iox;
            }
            catch (Exception ex) {
                throw new SolrServerException((Throwable)ex);
            }
        }
        if (coreName == null && (coreName = this.coreName) == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No core specified on request and no default core has been set.");
        }
        SolrQueryRequest req = null;
        try {
            SolrCore core = this.coreContainer.getCore(coreName);
            try {
                String qt;
                if (core == null) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "No such core: " + coreName);
                }
                SolrParams params = EmbeddedSolrServer.getParams(request);
                handler = core.getRequestHandler(path);
                if (handler == null && ("/select".equals(path) || "/select/".equalsIgnoreCase(path)) && (handler = core.getRequestHandler(qt = params.get("qt"))) == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + qt);
                }
                if (handler == null) {
                    throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "unknown handler: " + path);
                }
                req = core.getSolrConfig().getRequestParsers().buildRequestFrom(core, params, this.getContentStreams(request), request.getUserPrincipal());
                req.getContext().put("path", path);
                req.getContext().put("httpMethod", request.getMethod());
                SolrQueryResponse rsp = new SolrQueryResponse();
                SolrRequestInfo.setRequestInfo(new SolrRequestInfo(req, rsp));
                core.execute(handler, req, rsp);
                EmbeddedSolrServer.checkForExceptions(rsp);
                NamedList<Object> namedList = this.writeResponse(request, req, rsp);
                if (core != null) {
                    core.close();
                }
                return namedList;
            }
            catch (Throwable throwable) {
                try {
                    if (core != null) {
                        try {
                            core.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SolrException iox) {
                    throw iox;
                }
                catch (Exception ex) {
                    throw new SolrServerException((Throwable)ex);
                }
            }
        }
        finally {
            if (req != null) {
                req.close();
                SolrRequestInfo.clearRequestInfo();
            }
        }
    }

    private static SolrParams getParams(SolrRequest<?> request) {
        SolrParams params = request.getParams();
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = new BinaryResponseParser();
        }
        MapSolrParams addParams = new MapSolrParams(Map.of("wt", responseParser.getWriterType(), "version", responseParser.getVersion()));
        return SolrParams.wrapDefaults((SolrParams)addParams, (SolrParams)params);
    }

    private NamedList<Object> writeResponse(SolrRequest<?> request, SolrQueryRequest req, SolrQueryResponse rsp) throws IOException {
        ResponseParser responseParser = request.getResponseParser();
        if (responseParser == null) {
            responseParser = new BinaryResponseParser();
        }
        StreamingResponseCallback callback = request.getStreamingResponseCallback();
        var byteBuffer = new ByteArrayOutputStream(){

            ByteArrayInputStream toInputStream() {
                return new ByteArrayInputStream(this.buf, 0, this.count);
            }
        };
        if (callback == null) {
            QueryResponseWriterUtil.writeQueryResponse(byteBuffer, req.getResponseWriter(), req, rsp, null);
        } else {
            if (!(responseParser instanceof BinaryResponseParser)) {
                throw new IllegalArgumentException("Only javabin is supported when using a streaming response callback");
            }
            BinaryResponseWriter.Resolver resolver = new BinaryResponseWriter.Resolver(req, rsp.getReturnFields()){

                @Override
                public void writeResults(ResultContext ctx, JavaBinCodec codec) throws IOException {
                    SolrDocumentList docs = new SolrDocumentList();
                    docs.setNumFound(ctx.getDocList().matches());
                    docs.setNumFoundExact(Boolean.valueOf(ctx.getDocList().hitCountRelation() == TotalHits.Relation.EQUAL_TO));
                    docs.setStart((long)ctx.getDocList().offset());
                    docs.setMaxScore(Float.valueOf(ctx.getDocList().maxScore()));
                    codec.writeSolrDocumentList(docs);
                    this.writeResultsBody(ctx, codec);
                }
            };
            try (JavaBinCodec javaBinCodec = this.createJavaBinCodec(callback, resolver);){
                javaBinCodec.setWritableDocFields((JavaBinCodec.WritableDocFields)resolver).marshal(rsp.getValues(), (OutputStream)byteBuffer);
            }
        }
        if (responseParser instanceof InputStreamResponseParser) {
            return InputStreamResponseParser.createInputStreamNamedList((int)200, (InputStream)byteBuffer.toInputStream());
        }
        return responseParser.processResponse((InputStream)byteBuffer.toInputStream(), null);
    }

    private List<ContentStream> getContentStreams(SolrRequest<?> request) throws IOException {
        String cType;
        ContentStreamUpdateRequest csur;
        Collection cs;
        if (request.getMethod() == SolrRequest.METHOD.GET) {
            return List.of();
        }
        if (request instanceof ContentStreamUpdateRequest && (cs = (csur = (ContentStreamUpdateRequest)request).getContentStreams()) != null) {
            return new ArrayList<ContentStream>(cs);
        }
        RequestWriter.ContentWriter contentWriter = request.getContentWriter(null);
        Utils.BAOS baos = new Utils.BAOS();
        if (contentWriter != null) {
            contentWriter.write((OutputStream)baos);
            cType = contentWriter.getContentType();
        } else {
            RequestWriter rw = this.supplier.newRequestWriter();
            cType = rw.getUpdateContentType();
            rw.write(request, (OutputStream)baos);
        }
        final byte[] buf = baos.toByteArray();
        if (buf.length > 0) {
            return List.of(new ContentStreamBase(){

                public InputStream getStream() throws IOException {
                    return new ByteArrayInputStream(buf);
                }

                public String getContentType() {
                    return cType;
                }
            });
        }
        return List.of();
    }

    private JavaBinCodec createJavaBinCodec(final StreamingResponseCallback callback, BinaryResponseWriter.Resolver resolver) {
        return new JavaBinCodec(resolver){

            public void writeSolrDocument(SolrDocument doc) {
                callback.streamSolrDocument(doc);
            }

            public void writeSolrDocumentList(SolrDocumentList docs) throws IOException {
                if (docs.size() > 0) {
                    SolrDocumentList tmp = new SolrDocumentList();
                    tmp.setMaxScore(docs.getMaxScore());
                    tmp.setNumFound(docs.getNumFound());
                    tmp.setStart(docs.getStart());
                    docs = tmp;
                }
                callback.streamDocListInfo(docs.getNumFound(), docs.getStart(), docs.getMaxScore());
                super.writeSolrDocumentList(docs);
            }
        };
    }

    private static void checkForExceptions(SolrQueryResponse rsp) throws Exception {
        if (rsp.getException() != null) {
            if (rsp.getException() instanceof SolrException) {
                throw rsp.getException();
            }
            throw new SolrServerException((Throwable)rsp.getException());
        }
    }

    public void close() throws IOException {
        if (this.containerIsLocal) {
            this.coreContainer.shutdown();
        }
    }

    public CoreContainer getCoreContainer() {
        return this.coreContainer;
    }

    public static enum RequestWriterSupplier {
        JavaBin(BinaryRequestWriter::new),
        XML(XMLRequestWriter::new);

        private final Supplier<RequestWriter> supplier;

        private RequestWriterSupplier(Supplier<RequestWriter> supplier) {
            this.supplier = supplier;
        }

        public RequestWriter newRequestWriter() {
            return this.supplier.get();
        }
    }
}

