/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.prepare;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.jdbc.CalcitePrepare;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptMaterialization;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.prepare.CalcitePrepareImpl;
import org.apache.calcite.prepare.Prepare;
import org.apache.calcite.prepare.RelOptTableImpl;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.StarTable;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.SqlToRelConverter;

class CalciteMaterializer
extends CalcitePrepareImpl.CalcitePreparingStmt {
    CalciteMaterializer(CalcitePrepareImpl prepare, CalcitePrepare.Context context, Prepare.CatalogReader catalogReader, CalciteSchema schema, RelOptCluster cluster, SqlRexConvertletTable convertletTable) {
        super(prepare, context, catalogReader, catalogReader.getTypeFactory(), schema, EnumerableRel.Prefer.ANY, cluster, BindableConvention.INSTANCE, convertletTable);
    }

    void populate(Prepare.Materialization materialization) {
        SqlNode node;
        SqlParser parser = SqlParser.create(materialization.sql);
        try {
            node = parser.parseStmt();
        }
        catch (SqlParseException e) {
            throw new RuntimeException("parse failed", e);
        }
        SqlToRelConverter.Config config = SqlToRelConverter.config().withTrimUnusedFields(true);
        SqlToRelConverter sqlToRelConverter2 = this.getSqlToRelConverter(this.getSqlValidator(), this.catalogReader, config);
        RelRoot root = sqlToRelConverter2.convertQuery(node, true, true);
        materialization.queryRel = this.trimUnusedFields((RelRoot)root).rel;
        this.useStar(this.schema, materialization);
        List<String> tableName = materialization.materializedTable.path();
        RelOptTable table = (RelOptTable)((Object)Objects.requireNonNull(this.catalogReader.getTable((List)tableName), () -> "table " + tableName + " is not found"));
        materialization.tableRel = sqlToRelConverter2.toRel(table, (List<RelHint>)ImmutableList.of());
    }

    private void useStar(CalciteSchema schema, Prepare.Materialization materialization) {
        RelNode queryRel = Objects.requireNonNull(materialization.queryRel, "materialization.queryRel");
        for (Callback x : this.useStar(schema, queryRel)) {
            materialization.materialize(x.rel, x.starRelOptTable);
            if (!CalciteSystemProperty.DEBUG.value().booleanValue()) continue;
            System.out.println("Materialization " + materialization.materializedTable + " matched star table " + x.starTable + "; query after re-write: " + RelOptUtil.toString(queryRel));
        }
    }

    private Iterable<Callback> useStar(CalciteSchema schema, RelNode queryRel) {
        List<CalciteSchema.TableEntry> starTables = Schemas.getStarTables(schema.root());
        if (starTables.isEmpty()) {
            return ImmutableList.of();
        }
        ArrayList<Callback> list = new ArrayList<Callback>();
        RelNode rel2 = RelOptMaterialization.toLeafJoinForm(queryRel);
        for (CalciteSchema.TableEntry starTable : starTables) {
            Table table = starTable.getTable();
            assert (table instanceof StarTable);
            RelOptTableImpl starRelOptTable = RelOptTableImpl.create((RelOptSchema)this.catalogReader, table.getRowType(this.typeFactory), starTable, null);
            RelNode rel3 = RelOptMaterialization.tryUseStar(rel2, starRelOptTable);
            if (rel3 == null) continue;
            list.add(new Callback(rel3, starTable, starRelOptTable));
        }
        return list;
    }

    static class Callback {
        public final RelNode rel;
        public final CalciteSchema.TableEntry starTable;
        public final RelOptTableImpl starRelOptTable;

        Callback(RelNode rel, CalciteSchema.TableEntry starTable, RelOptTableImpl starRelOptTable) {
            this.rel = rel;
            this.starTable = starTable;
            this.starRelOptTable = starRelOptTable;
        }
    }
}

