/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.s3;

import org.apache.solr.common.util.EnvUtils;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.s3.S3StorageClient;

public class S3BackupRepositoryConfig {
    public static final String PROFILE = "s3.profile";
    public static final String BUCKET_NAME = "s3.bucket.name";
    public static final String REGION = "s3.region";
    public static final String ENDPOINT = "s3.endpoint";
    public static final String PROXY_URL = "s3.proxy.url";
    public static final String PROXY_USE_SYSTEM_SETTINGS = "s3.proxy.useSystemSettings";
    public static final String RETRIES_DISABLE = "s3.retries.disable";
    private final String profile;
    private final String bucketName;
    private final String region;
    private final String proxyURL;
    private final boolean proxyUseSystemSettings;
    private final String endpoint;
    private final boolean disableRetries;

    public S3BackupRepositoryConfig(NamedList<?> config) {
        this.profile = S3BackupRepositoryConfig.getStringConfig(config, PROFILE);
        this.region = S3BackupRepositoryConfig.getStringConfig(config, REGION);
        this.bucketName = S3BackupRepositoryConfig.getStringConfig(config, BUCKET_NAME);
        this.proxyURL = S3BackupRepositoryConfig.getStringConfig(config, PROXY_URL);
        this.proxyUseSystemSettings = S3BackupRepositoryConfig.getBooleanConfig(config, PROXY_USE_SYSTEM_SETTINGS, true);
        this.endpoint = S3BackupRepositoryConfig.getStringConfig(config, ENDPOINT);
        this.disableRetries = S3BackupRepositoryConfig.getBooleanConfig(config, RETRIES_DISABLE, false);
    }

    public S3StorageClient buildClient() {
        return new S3StorageClient(this.bucketName, this.profile, this.region, this.proxyURL, this.proxyUseSystemSettings, this.endpoint, this.disableRetries);
    }

    static String getStringConfig(NamedList<?> config, String property) {
        String envProp = EnvUtils.getProperty((String)property);
        if (envProp == null) {
            Object configProp = config.get(property);
            return configProp == null ? null : configProp.toString();
        }
        return envProp;
    }

    static int getIntConfig(NamedList<?> config, String property) {
        return S3BackupRepositoryConfig.getIntConfig(config, property, 0);
    }

    static int getIntConfig(NamedList<?> config, String property, int def) {
        String envProp = EnvUtils.getProperty((String)property);
        if (envProp == null) {
            Object configProp = config.get(property);
            return configProp instanceof Integer ? (Integer)configProp : def;
        }
        return Integer.parseInt(envProp);
    }

    static boolean getBooleanConfig(NamedList<?> config, String property) {
        return S3BackupRepositoryConfig.getBooleanConfig(config, property, false);
    }

    static boolean getBooleanConfig(NamedList<?> config, String property, boolean def) {
        String envProp = EnvUtils.getProperty((String)property);
        if (envProp == null) {
            Boolean configProp = config.getBooleanArg(property);
            return configProp == null ? def : configProp;
        }
        return Boolean.parseBoolean(envProp);
    }
}

