/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.feature.jts;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.util.ArgumentChecks;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequences;
import org.locationtech.jts.geom.CoordinateXY;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.impl.PackedCoordinateSequence;

abstract class PackedCoordinateSequence
implements CoordinateSequence,
Serializable {
    private static final long serialVersionUID = 6323915437380051705L;
    protected final int dimension;
    private final int hasZM;
    private static final int Z_MASK = 1;
    private static final int M_MASK = 2;

    PackedCoordinateSequence(PackedCoordinateSequence packedCoordinateSequence) {
        this.dimension = packedCoordinateSequence.dimension;
        this.hasZM = packedCoordinateSequence.hasZM;
    }

    PackedCoordinateSequence(int n, int n2) {
        int n3;
        ArgumentChecks.ensurePositive("measures", n2);
        ArgumentChecks.ensureBetween("dimension", 2 + n2, Math.addExact(3, n2), n);
        this.dimension = n;
        int n4 = n3 = n2 == 0 ? 0 : 2;
        if (n - n2 >= 3) {
            n3 |= 1;
        }
        this.hasZM = n3;
    }

    private static int getSpatialDimension(int n) {
        return 2 | n & 1;
    }

    public final int getDimension() {
        return this.dimension;
    }

    public final int getMeasures() {
        return this.dimension - PackedCoordinateSequence.getSpatialDimension(this.hasZM);
    }

    public final boolean hasZ() {
        return (this.hasZM & 1) != 0;
    }

    public final boolean hasM() {
        return (this.hasZM & 2) != 0;
    }

    public final double getX(int n) {
        return this.coordinate(n * this.dimension + 0);
    }

    public final double getY(int n) {
        return this.coordinate(n * this.dimension + 1);
    }

    public final double getZ(int n) {
        return (this.hasZM & 1) != 0 ? this.coordinate(n * this.dimension + 2) : java.lang.Double.NaN;
    }

    public final double getM(int n) {
        switch (this.hasZM) {
            default: {
                return java.lang.Double.NaN;
            }
            case 2: {
                return this.coordinate(n * this.dimension + 2);
            }
            case 3: 
        }
        return this.coordinate(n * this.dimension + 3);
    }

    public final Coordinate getCoordinate(int n) {
        double d = this.coordinate(n *= this.dimension);
        double d2 = this.coordinate(++n);
        switch (this.hasZM) {
            default: {
                return new Coordinate(d, d2);
            }
            case 0: {
                return new CoordinateXY(d, d2);
            }
            case 1: {
                return new Coordinate(d, d2, this.coordinate(++n));
            }
            case 2: {
                return new CoordinateXYM(d, d2, this.coordinate(++n));
            }
            case 3: 
        }
        return new CoordinateXYZM(d, d2, this.coordinate(++n), this.coordinate(++n));
    }

    public final void getCoordinate(int n, Coordinate coordinate) {
        coordinate.x = this.coordinate(n *= this.dimension);
        coordinate.y = this.coordinate(++n);
        switch (this.hasZM) {
            case 1: {
                coordinate.setZ(this.coordinate(++n));
                break;
            }
            case 3: {
                coordinate.setZ(this.coordinate(++n));
            }
            case 2: {
                coordinate.setM(this.coordinate(++n));
            }
        }
    }

    public final Coordinate getCoordinateCopy(int n) {
        return this.getCoordinate(n);
    }

    public final double getOrdinate(int n, int n2) {
        return this.coordinate(n * this.dimension + n2);
    }

    abstract double coordinate(int var1);

    abstract void setCoordinates(Coordinate[] var1);

    void setCoordinates(CoordinateSequence coordinateSequence) {
        this.setCoordinates(coordinateSequence.toCoordinateArray());
    }

    public final Coordinate[] toCoordinateArray() {
        Coordinate[] coordinateArray = new Coordinate[this.size()];
        for (int i = 0; i < coordinateArray.length; ++i) {
            coordinateArray[i] = this.getCoordinate(i);
        }
        return coordinateArray;
    }

    public final String toString() {
        return CoordinateSequences.toString((CoordinateSequence)this);
    }

    public int hashCode() {
        return 37 * this.dimension ^ this.hasZM;
    }

    public boolean equals(Object object) {
        if (object != null && object.getClass() == this.getClass()) {
            PackedCoordinateSequence packedCoordinateSequence = (PackedCoordinateSequence)object;
            return packedCoordinateSequence.dimension == this.dimension && packedCoordinateSequence.hasZM == this.hasZM;
        }
        return false;
    }

    @Deprecated
    public final Object clone() {
        return this.copy();
    }

    static final class Float
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 2625498691139718968L;
        private final float[] coordinates;

        private Float(Float float_) {
            super(float_);
            this.coordinates = (float[])float_.coordinates.clone();
        }

        Float(float[] fArray, int n) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(fArray, n);
        }

        Float(int n, int n2, int n3) {
            super(n2, n3);
            this.coordinates = new float[Math.multiplyExact(n, n2)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int n) {
            return this.coordinates[n];
        }

        public void setOrdinate(int n, int n2, double d) {
            this.coordinates[n * this.dimension + n2] = (float)d;
        }

        @Override
        void setCoordinates(Coordinate[] coordinateArray) {
            int n = 0;
            for (Coordinate coordinate : coordinateArray) {
                for (int i = 0; i < this.dimension; ++i) {
                    this.coordinates[n++] = (float)coordinate.getOrdinate(i);
                }
            }
            assert (n == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence coordinateSequence) {
            if (coordinateSequence instanceof PackedCoordinateSequence.Float) {
                System.arraycopy(((PackedCoordinateSequence.Float)coordinateSequence).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(coordinateSequence);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude((double)this.coordinates[i], (double)this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Float(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && Arrays.equals(((Float)object).coordinates, this.coordinates);
        }
    }

    static final class Double
    extends PackedCoordinateSequence {
        private static final long serialVersionUID = 1940132733783453171L;
        private final double[] coordinates;

        private Double(Double double_) {
            super(double_);
            this.coordinates = (double[])double_.coordinates.clone();
        }

        Double(double[] dArray, int n) {
            super(2, 0);
            this.coordinates = Arrays.copyOf(dArray, n);
        }

        Double(int n, int n2, int n3) {
            super(n2, n3);
            this.coordinates = new double[Math.multiplyExact(n, n2)];
        }

        public int size() {
            return this.coordinates.length / this.dimension;
        }

        @Override
        double coordinate(int n) {
            return this.coordinates[n];
        }

        public void setOrdinate(int n, int n2, double d) {
            this.coordinates[n * this.dimension + n2] = d;
        }

        @Override
        void setCoordinates(Coordinate[] coordinateArray) {
            int n = 0;
            for (Coordinate coordinate : coordinateArray) {
                for (int i = 0; i < this.dimension; ++i) {
                    this.coordinates[n++] = coordinate.getOrdinate(i);
                }
            }
            assert (n == this.coordinates.length);
        }

        @Override
        void setCoordinates(CoordinateSequence coordinateSequence) {
            if (coordinateSequence instanceof PackedCoordinateSequence.Double) {
                System.arraycopy(((PackedCoordinateSequence.Double)coordinateSequence).getRawCoordinates(), 0, this.coordinates, 0, this.coordinates.length);
            } else {
                super.setCoordinates(coordinateSequence);
            }
        }

        public Envelope expandEnvelope(Envelope envelope) {
            for (int i = 0; i < this.coordinates.length; i += this.dimension) {
                envelope.expandToInclude(this.coordinates[i], this.coordinates[i + 1]);
            }
            return envelope;
        }

        public CoordinateSequence copy() {
            return new Double(this);
        }

        @Override
        public int hashCode() {
            return Arrays.hashCode(this.coordinates) + super.hashCode();
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && Arrays.equals(((Double)object).coordinates, this.coordinates);
        }
    }
}

