# Interface methods for submodule: FlatStructuringElement
from typing import Union, Any
# additional imports
from .support.template_class import itkTemplate as _itkTemplate
from ._proxies import NeighborhoodProxy as _NeighborhoodProxy


# Interface methods for class: FlatStructuringElement
class FlatStructuringElementProxy(_NeighborhoodProxy):
	@staticmethod
	def Box(radius: Sequence[int]) -> FlatStructuringElement:
		""""""
		...

	@staticmethod
	def Ball(radius: Sequence[int], radiusIsParametric: bool = False) -> FlatStructuringElement:
		""""""
		...

	@staticmethod
	def Cross(radius: Sequence[int]) -> FlatStructuringElement:
		""""""
		...

	@staticmethod
	def Annulus(radius: Sequence[int], thickness: int = 1, includeCenter: bool = False, radiusIsParametric: bool = False) -> FlatStructuringElement:
		""""""
		...

	@staticmethod
	def Polygon(radius: Sequence[int], lines: int) -> FlatStructuringElement:
		""""""
		...

	def GetDecomposable(self) -> bool:
		""""""
		...

	def SetDecomposable(self, v: bool) -> None:
		""""""
		...

	def GetLines(self):
		""""""
		...

	def AddLine(self, l: Sequence[float]) -> None:
		""""""
		...

	def CheckParallel(self, NewVec: Sequence[float]) -> bool:
		""""""
		...

	def ComputeBufferFromLines(self) -> None:
		""""""
		...

	def GetRadiusIsParametric(self) -> bool:
		""""""
		...

	def SetRadiusIsParametric(self, flag: bool) -> None:
		""""""
		...

	def RadiusIsParametricOn(self) -> None:
		""""""
		...

	def RadiusIsParametricOff(self) -> None:
		""""""
		...

	@staticmethod
	def FromImage(image) -> FlatStructuringElement:
		""""""
		...

