/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.testing;

import com.intellij.execution.lineMarker.RunLineMarkerContributor;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.util.ThreeState;
import com.jetbrains.python.PyTokenTypes;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyFile;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.types.TypeEvalContext;
import com.jetbrains.python.testing.PyTestDiscoveryUtil;
import com.jetbrains.python.testing.PyTestLineMarkerContributorCustomizer;
import com.jetbrains.python.testing.PyTestsSharedKt;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/jetbrains/python/testing/PyTestLineMarkerContributor;", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor;", "Lcom/intellij/openapi/project/DumbAware;", "<init>", "()V", "getInfo", "Lcom/intellij/execution/lineMarker/RunLineMarkerContributor$Info;", "element", "Lcom/intellij/psi/PsiElement;", "intellij.python.community.impl"})
public final class PyTestLineMarkerContributor
extends RunLineMarkerContributor
implements DumbAware {
    @Nullable
    public RunLineMarkerContributor.Info getInfo(@NotNull PsiElement element) {
        PyFile pyFile;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (!(element instanceof LeafPsiElement) || !Intrinsics.areEqual((Object)((LeafPsiElement)element).getElementType(), (Object)PyTokenTypes.IDENTIFIER)) {
            return null;
        }
        PsiElement psiElement = ((LeafPsiElement)element).getParent();
        if (psiElement == null) {
            return null;
        }
        PsiElement testElement = psiElement;
        if (!PyTestLineMarkerContributorCustomizer.Companion.shouldProcessElement(testElement)) {
            return null;
        }
        Module module2 = ModuleUtilCore.findModuleForPsiElement((PsiElement)testElement);
        PsiFile psiFile = testElement.getContainingFile();
        PyFile pyFile2 = pyFile = psiFile instanceof PyFile ? (PyFile)psiFile : null;
        if (!PyTestDiscoveryUtil.isPyTestAllowedForFile(module2, pyFile)) {
            return null;
        }
        TypeEvalContext typeEvalContext = TypeEvalContext.codeAnalysis((Project)((LeafPsiElement)element).getProject(), (PsiFile)((LeafPsiElement)element).getContainingFile());
        if (testElement instanceof PyClass || testElement instanceof PyFunction) {
            Intrinsics.checkNotNull((Object)typeEvalContext);
            if (PyTestsSharedKt.isTestElement(testElement, ThreeState.UNSURE, typeEvalContext)) {
                return RunLineMarkerContributor.withExecutorActions((Icon)AllIcons.RunConfigurations.TestState.Run);
            }
        }
        return null;
    }
}

