/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cef.remote.thrift.protocol;

import com.jetbrains.cef.remote.thrift.TException;
import com.jetbrains.cef.remote.thrift.protocol.TCompactProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TList;
import com.jetbrains.cef.remote.thrift.protocol.TMap;
import com.jetbrains.cef.remote.thrift.protocol.TProtocol;
import com.jetbrains.cef.remote.thrift.protocol.TProtocolFactory;
import com.jetbrains.cef.remote.thrift.protocol.TSet;
import com.jetbrains.cef.remote.thrift.scheme.IScheme;
import com.jetbrains.cef.remote.thrift.scheme.TupleScheme;
import com.jetbrains.cef.remote.thrift.transport.TTransport;
import java.util.BitSet;

public final class TTupleProtocol
extends TCompactProtocol {
    public TTupleProtocol(TTransport transport) {
        super(transport);
    }

    @Override
    public Class<? extends IScheme> getScheme() {
        return TupleScheme.class;
    }

    public void writeBitSet(BitSet bs, int vectorWidth) throws TException {
        byte[] bytes;
        for (byte b : bytes = TTupleProtocol.toByteArray(bs, vectorWidth)) {
            this.writeByte(b);
        }
    }

    public BitSet readBitSet(int i) throws TException {
        int length = (int)Math.ceil((double)i / 8.0);
        byte[] bytes = new byte[length];
        for (int j = 0; j < length; ++j) {
            bytes[j] = this.readByte();
        }
        BitSet bs = TTupleProtocol.fromByteArray(bytes);
        return bs;
    }

    public static BitSet fromByteArray(byte[] bytes) {
        BitSet bits = new BitSet();
        for (int i = 0; i < bytes.length * 8; ++i) {
            if ((bytes[bytes.length - i / 8 - 1] & 1 << i % 8) <= 0) continue;
            bits.set(i);
        }
        return bits;
    }

    public static byte[] toByteArray(BitSet bits, int vectorWidth) {
        byte[] bytes = new byte[(int)Math.ceil((double)vectorWidth / 8.0)];
        for (int i = 0; i < bits.length(); ++i) {
            if (!bits.get(i)) continue;
            int n = bytes.length - i / 8 - 1;
            bytes[n] = (byte)(bytes[n] | 1 << i % 8);
        }
        return bytes;
    }

    public TMap readMapBegin(byte keyType, byte valTyep) throws TException {
        int size = super.readI32();
        TMap map = new TMap(keyType, valTyep, size);
        this.checkReadBytesAvailable(map);
        return map;
    }

    public TList readListBegin(byte type) throws TException {
        int size = super.readI32();
        TList list = new TList(type, size);
        this.checkReadBytesAvailable(list);
        return list;
    }

    public TSet readSetBegin(byte type) throws TException {
        return new TSet(this.readListBegin(type));
    }

    @Override
    public void readMapEnd() throws TException {
    }

    @Override
    public void readListEnd() throws TException {
    }

    @Override
    public void readSetEnd() throws TException {
    }

    public static class Factory
    implements TProtocolFactory {
        @Override
        public TProtocol getProtocol(TTransport trans) {
            return new TTupleProtocol(trans);
        }
    }
}

