/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cli;

public class ErrorStatus {
    private int nbErrors;
    private int nbOk;

    private ErrorStatus() {
    }

    public static ErrorStatus init() {
        return new ErrorStatus();
    }

    public synchronized void incError() {
        ++this.nbErrors;
    }

    public synchronized void incOk() {
        ++this.nbOk;
    }

    public synchronized boolean hasError() {
        return this.nbErrors > 0;
    }

    public synchronized boolean isEmpty() {
        return this.nbErrors == 0 && this.nbOk == 0;
    }

    public synchronized int getExitCode() {
        if (this.isEmpty()) {
            return 100;
        }
        if (this.hasError()) {
            return 200;
        }
        return 0;
    }

    public String toString() {
        return "nbErrors=" + this.nbErrors + " nbOk=" + this.nbOk;
    }
}

