/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util.format.postgresql.format.compiled;

import java.text.ParseException;
import java.text.ParsePosition;
import java.time.ZonedDateTime;
import java.util.Locale;
import java.util.Set;
import org.apache.calcite.util.format.postgresql.ChronoUnitEnum;
import org.apache.calcite.util.format.postgresql.PatternModifier;
import org.apache.calcite.util.format.postgresql.format.compiled.CompiledPattern;

public class TimeZoneOffsetCompiledPattern
extends CompiledPattern {
    public TimeZoneOffsetCompiledPattern(Set<PatternModifier> modifiers) {
        super(ChronoUnitEnum.TIMEZONE_MINUTES, modifiers);
    }

    @Override
    public String convertToString(ZonedDateTime dateTime, Locale locale) {
        int offsetSeconds = dateTime.getOffset().getTotalSeconds();
        int hours = offsetSeconds / 3600;
        int minutes = offsetSeconds % 3600 / 60;
        String formattedHours = String.format(Locale.ROOT, "%s%02d", hours < 0 ? "-" : "+", hours);
        if (minutes == 0) {
            return formattedHours;
        }
        return String.format(Locale.ROOT, "%s:%02d", formattedHours, minutes);
    }

    @Override
    public int parseValue(ParsePosition inputPosition, String input, boolean enforceLength, Locale locale) throws ParseException {
        throw new ParseException("OF pattern is not supported in parsing datetime values", inputPosition.getIndex());
    }

    @Override
    protected int getBaseFormatPatternLength() {
        return 2;
    }

    @Override
    public boolean isNumeric() {
        return true;
    }
}

