/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.enumerable;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.EnumerableTraitsUtils;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.enumerable.RexToLixTranslator;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.BlockStatement;
import org.apache.calcite.linq4j.tree.Blocks;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MemberDeclaration;
import org.apache.calcite.linq4j.tree.NewExpression;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.ParameterExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.linq4j.tree.Types;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Calc;
import org.apache.calcite.rel.hint.RelHint;
import org.apache.calcite.rel.metadata.RelMdCollation;
import org.apache.calcite.rel.metadata.RelMdDistribution;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexProgram;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.calcite.sql.validate.SqlConformanceEnum;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class EnumerableCalc
extends Calc
implements EnumerableRel {
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program) {
        super(cluster, traitSet, (List<RelHint>)ImmutableList.of(), input, program);
        assert (this.getConvention() instanceof EnumerableConvention);
        assert (!program.containsAggs());
    }

    @Deprecated
    public EnumerableCalc(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexProgram program, List<RelCollation> collationList) {
        this(cluster, traitSet, input, program);
        Util.discard(collationList);
    }

    public static EnumerableCalc create(RelNode input, RexProgram program) {
        RelOptCluster cluster = input.getCluster();
        RelMetadataQuery mq = cluster.getMetadataQuery();
        RelTraitSet traitSet = cluster.traitSet().replace(EnumerableConvention.INSTANCE).replaceIfs(RelCollationTraitDef.INSTANCE, () -> RelMdCollation.calc(mq, input, program)).replaceIf(RelDistributionTraitDef.INSTANCE, () -> RelMdDistribution.calc(mq, input, program));
        return new EnumerableCalc(cluster, traitSet, input, program);
    }

    @Override
    public EnumerableCalc copy(RelTraitSet traitSet, RelNode child, RexProgram program) {
        return new EnumerableCalc(this.getCluster(), traitSet, child, program);
    }

    @Override
    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockStatement moveNextBody;
        RelMetadataQuery mq;
        RelOptPredicateList predicates;
        RexSimplify simplify;
        JavaTypeFactory typeFactory = implementor.getTypeFactory();
        BlockBuilder builder = new BlockBuilder();
        EnumerableRel child = (EnumerableRel)this.getInput();
        EnumerableRel.Result result = implementor.visitChild(this, 0, child, pref);
        PhysType physType = PhysTypeImpl.of(typeFactory, this.getRowType(), pref.prefer(result.format));
        Type outputJavaType = physType.getJavaRowType();
        Type enumeratorType = Types.of(Enumerator.class, (Type[])new Type[]{outputJavaType});
        Type inputJavaType = result.physType.getJavaRowType();
        ParameterExpression inputEnumerator = Expressions.parameter((Type)Types.of(Enumerator.class, (Type[])new Type[]{inputJavaType}), (String)"inputEnumerator");
        Expression input = EnumUtils.convert((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_CURRENT.method, (Expression[])new Expression[0]), inputJavaType);
        RexBuilder rexBuilder = this.getCluster().getRexBuilder();
        RexProgram program = this.program.normalize(rexBuilder, simplify = new RexSimplify(rexBuilder, predicates = (mq = this.getCluster().getMetadataQuery()).getPulledUpPredicates(child), RexUtil.EXECUTOR));
        if (program.getCondition() == null) {
            moveNextBody = Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]));
        } else {
            BlockBuilder builder2 = new BlockBuilder();
            Expression condition = RexToLixTranslator.translateCondition(program, typeFactory, builder2, new RexToLixTranslator.InputGetterImpl(input, result.physType), implementor.allCorrelateVariables, implementor.getConformance());
            builder2.add((Statement)Expressions.ifThen((Expression)condition, (Node)Expressions.return_(null, (Expression)Expressions.constant((Object)true))));
            moveNextBody = Expressions.block((Statement[])new Statement[]{Expressions.while_((Expression)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, (Expression[])new Expression[0]), (Statement)builder2.toBlock()), Expressions.return_(null, (Expression)Expressions.constant((Object)false))});
        }
        BlockBuilder builder3 = new BlockBuilder();
        SqlConformance conformance = (SqlConformance)implementor.map.getOrDefault("_conformance", SqlConformanceEnum.DEFAULT);
        List<Expression> expressions = RexToLixTranslator.translateProjects(program, typeFactory, conformance, builder3, null, physType, (Expression)DataContext.ROOT, new RexToLixTranslator.InputGetterImpl(input, result.physType), implementor.allCorrelateVariables);
        builder3.add((Statement)Expressions.return_(null, (Expression)physType.record(expressions)));
        BlockStatement currentBody = builder3.toBlock();
        Expression inputEnumerable = builder.append("inputEnumerable", result.block, false);
        NewExpression body = Expressions.new_((Type)enumeratorType, EnumUtils.NO_EXPRS, (Iterable)Expressions.list((Object[])new MemberDeclaration[]{Expressions.fieldDecl((int)17, (ParameterExpression)inputEnumerator, (Expression)Expressions.call((Expression)inputEnumerable, (Method)BuiltInMethod.ENUMERABLE_ENUMERATOR.method, (Expression[])new Expression[0])), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_RESET.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_RESET.method, (Expression[])new Expression[0]))), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_MOVE_NEXT.method, EnumUtils.NO_PARAMS, moveNextBody), EnumUtils.overridingMethodDecl(BuiltInMethod.ENUMERATOR_CLOSE.method, EnumUtils.NO_PARAMS, Blocks.toFunctionBlock((Node)Expressions.call((Expression)inputEnumerator, (Method)BuiltInMethod.ENUMERATOR_CLOSE.method, (Expression[])new Expression[0]))), Expressions.methodDecl((int)1, Object.class, (String)"current", EnumUtils.NO_PARAMS, (BlockStatement)currentBody)}));
        builder.add((Statement)Expressions.return_(null, (Expression)Expressions.new_((Constructor)BuiltInMethod.ABSTRACT_ENUMERABLE_CTOR.constructor, EnumUtils.NO_EXPRS, (Iterable)ImmutableList.of((Object)Expressions.methodDecl((int)1, (Type)enumeratorType, (String)BuiltInMethod.ENUMERABLE_ENUMERATOR.method.getName(), EnumUtils.NO_PARAMS, (BlockStatement)Blocks.toFunctionBlock((Node)body))))));
        return implementor.result(physType, builder.toBlock());
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> passThroughTraits(RelTraitSet required) {
        List<RexNode> exps = Util.transform(this.program.getProjectList(), this.program::expandLocalRef);
        return EnumerableTraitsUtils.passThroughTraitsForProject(required, exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }

    @Override
    public @Nullable Pair<RelTraitSet, List<RelTraitSet>> deriveTraits(RelTraitSet childTraits, int childId) {
        List<RexNode> exps = Util.transform(this.program.getProjectList(), this.program::expandLocalRef);
        return EnumerableTraitsUtils.deriveTraitsForProject(childTraits, childId, exps, this.input.getRowType(), this.input.getCluster().getTypeFactory(), this.traitSet);
    }

    @Override
    public RexProgram getProgram() {
        return this.program;
    }
}

