/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.cryptography.primitives.model;

import java.nio.ByteBuffer;
import java.util.Objects;
import software.amazon.cryptography.primitives.model.ECDHCurveSpec;

public class DecompressPublicKeyInput {
    private final ByteBuffer compressedPublicKey;
    private final ECDHCurveSpec eccCurve;

    protected DecompressPublicKeyInput(BuilderImpl builder) {
        this.compressedPublicKey = builder.compressedPublicKey();
        this.eccCurve = builder.eccCurve();
    }

    public ByteBuffer compressedPublicKey() {
        return this.compressedPublicKey;
    }

    public ECDHCurveSpec eccCurve() {
        return this.eccCurve;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    static class BuilderImpl
    implements Builder {
        protected ByteBuffer compressedPublicKey;
        protected ECDHCurveSpec eccCurve;

        protected BuilderImpl() {
        }

        protected BuilderImpl(DecompressPublicKeyInput model) {
            this.compressedPublicKey = model.compressedPublicKey();
            this.eccCurve = model.eccCurve();
        }

        @Override
        public Builder compressedPublicKey(ByteBuffer compressedPublicKey) {
            this.compressedPublicKey = compressedPublicKey;
            return this;
        }

        @Override
        public ByteBuffer compressedPublicKey() {
            return this.compressedPublicKey;
        }

        @Override
        public Builder eccCurve(ECDHCurveSpec eccCurve) {
            this.eccCurve = eccCurve;
            return this;
        }

        @Override
        public ECDHCurveSpec eccCurve() {
            return this.eccCurve;
        }

        @Override
        public DecompressPublicKeyInput build() {
            if (Objects.isNull(this.compressedPublicKey())) {
                throw new IllegalArgumentException("Missing value for required field `compressedPublicKey`");
            }
            if (Objects.isNull((Object)this.eccCurve())) {
                throw new IllegalArgumentException("Missing value for required field `eccCurve`");
            }
            return new DecompressPublicKeyInput(this);
        }
    }

    public static interface Builder {
        public Builder compressedPublicKey(ByteBuffer var1);

        public ByteBuffer compressedPublicKey();

        public Builder eccCurve(ECDHCurveSpec var1);

        public ECDHCurveSpec eccCurve();

        public DecompressPublicKeyInput build();
    }
}

