/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ml.processor;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.OpenSearchStatusException;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.support.GroupedActionListener;
import org.opensearch.common.collect.Tuple;
import org.opensearch.common.xcontent.XContentHelper;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.common.bytes.BytesReference;
import org.opensearch.core.common.util.CollectionUtils;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.MediaType;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContent;
import org.opensearch.core.xcontent.XContentBuilder;
import org.opensearch.ingest.ConfigurationUtils;
import org.opensearch.ml.common.FunctionName;
import org.opensearch.ml.common.exception.MLResourceNotFoundException;
import org.opensearch.ml.common.output.MLOutput;
import org.opensearch.ml.common.transport.MLTaskResponse;
import org.opensearch.ml.common.transport.prediction.MLPredictionTaskAction;
import org.opensearch.ml.common.utils.StringUtils;
import org.opensearch.ml.processor.InferenceProcessorAttributes;
import org.opensearch.ml.processor.MLInferenceSearchResponse;
import org.opensearch.ml.processor.ModelExecutor;
import org.opensearch.ml.utils.MapUtils;
import org.opensearch.ml.utils.SearchResponseUtil;
import org.opensearch.search.SearchHit;
import org.opensearch.search.pipeline.AbstractProcessor;
import org.opensearch.search.pipeline.PipelineProcessingContext;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchResponseProcessor;
import org.opensearch.transport.client.Client;

public class MLInferenceSearchResponseProcessor
extends AbstractProcessor
implements SearchResponseProcessor,
ModelExecutor {
    public static final String REQUEST_PREFIX = "_request.";
    private final NamedXContentRegistry xContentRegistry;
    private static final Logger logger = LogManager.getLogger(MLInferenceSearchResponseProcessor.class);
    private final InferenceProcessorAttributes inferenceProcessorAttributes;
    private final boolean ignoreMissing;
    private final String functionName;
    private final boolean override;
    private final boolean fullResponsePath;
    private final boolean oneToOne;
    private final boolean ignoreFailure;
    private final String modelInput;
    private static Client client;
    public static final String TYPE = "ml_inference";
    public static final String IGNORE_MISSING = "ignore_missing";
    public static final String FUNCTION_NAME = "function_name";
    public static final String FULL_RESPONSE_PATH = "full_response_path";
    public static final String MODEL_INPUT = "model_input";
    public static final String ONE_TO_ONE = "one_to_one";
    public static final String DEFAULT_MODEL_INPUT = "{ \"parameters\": ${ml_inference.parameters} }";
    public static final int DEFAULT_MAX_PREDICTION_TASKS = 10;
    public static final String DEFAULT_OUTPUT_FIELD_NAME = "inference_results";
    public static final String EXTENSION_PREFIX = "ext.ml_inference";
    private final List<Map<String, String>> optionalInputMaps;
    private final List<Map<String, String>> optionalOutputMaps;

    protected MLInferenceSearchResponseProcessor(String modelId, List<Map<String, String>> inputMaps, List<Map<String, String>> outputMaps, List<Map<String, String>> optionalInputMaps, List<Map<String, String>> optionalOutputMaps, Map<String, String> modelConfigMaps, int maxPredictionTask, String tag, String description, boolean ignoreMissing, String functionName, boolean fullResponsePath, boolean ignoreFailure, boolean override, String modelInput, Client client, NamedXContentRegistry xContentRegistry, boolean oneToOne) {
        super(tag, description, ignoreFailure);
        this.oneToOne = oneToOne;
        this.inferenceProcessorAttributes = new InferenceProcessorAttributes(modelId, inputMaps, outputMaps, modelConfigMaps, maxPredictionTask);
        this.optionalInputMaps = optionalInputMaps;
        this.optionalOutputMaps = optionalOutputMaps;
        this.ignoreMissing = ignoreMissing;
        this.functionName = functionName;
        this.fullResponsePath = fullResponsePath;
        this.ignoreFailure = ignoreFailure;
        this.override = override;
        this.modelInput = modelInput;
        MLInferenceSearchResponseProcessor.client = client;
        this.xContentRegistry = xContentRegistry;
    }

    public SearchResponse processResponse(SearchRequest request, SearchResponse response) throws Exception {
        throw new RuntimeException("ML inference search response processor make asynchronous calls and does not call processRequest");
    }

    public void processResponseAsync(SearchRequest request, SearchResponse response, PipelineProcessingContext responseContext, ActionListener<SearchResponse> responseListener) {
        block9: {
            try {
                SearchHit[] hits = response.getHits().getHits();
                String queryString = request.source().toString();
                if (hits.length == 0) {
                    responseListener.onResponse((Object)response);
                    return;
                }
                this.setRequestContextFromExt(request, responseContext);
                if (!this.oneToOne) {
                    MLInferenceSearchResponse mlInferenceSearchResponse = response instanceof MLInferenceSearchResponse ? (MLInferenceSearchResponse)response : new MLInferenceSearchResponse(null, response.getInternalResponse(), response.getScrollId(), response.getTotalShards(), response.getSuccessfulShards(), response.getSkippedShards(), response.getSuccessfulShards(), response.getShardFailures(), response.getClusters());
                    this.rewriteResponseDocuments(mlInferenceSearchResponse, responseListener, queryString);
                    break block9;
                }
                GroupedActionListener<SearchResponse> combineResponseListener = this.getCombineResponseGroupedActionListener(response, responseListener, hits);
                AtomicBoolean isOneHitListenerFailed = new AtomicBoolean(false);
                for (SearchHit hit : hits) {
                    SearchHit[] newHits = new SearchHit[]{hit};
                    SearchResponse oneHitResponse = SearchResponseUtil.replaceHits(newHits, response);
                    ActionListener<SearchResponse> oneHitListener = MLInferenceSearchResponseProcessor.getOneHitListener(combineResponseListener, isOneHitListenerFailed);
                    this.rewriteResponseDocuments(oneHitResponse, oneHitListener, queryString);
                    if (!isOneHitListenerFailed.get()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                if (this.ignoreFailure) {
                    responseListener.onResponse((Object)response);
                }
                responseListener.onFailure(e);
                if (e instanceof OpenSearchStatusException) {
                    responseListener.onFailure((Exception)new OpenSearchStatusException("Failed to process response: " + e.getMessage(), RestStatus.fromCode((int)((OpenSearchStatusException)e).status().getStatus()), new Object[0]));
                }
                if (e instanceof MLResourceNotFoundException) {
                    responseListener.onFailure((Exception)new OpenSearchStatusException("Failed to process response: " + e.getMessage(), RestStatus.NOT_FOUND, new Object[0]));
                }
                responseListener.onFailure(e);
            }
        }
    }

    private static ActionListener<SearchResponse> getOneHitListener(final GroupedActionListener<SearchResponse> combineResponseListener, final AtomicBoolean isOneHitListenerFailed) {
        ActionListener<SearchResponse> oneHitListener = new ActionListener<SearchResponse>(){

            public void onResponse(SearchResponse response) {
                combineResponseListener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                isOneHitListenerFailed.compareAndSet(false, true);
                combineResponseListener.onFailure(e);
            }
        };
        return oneHitListener;
    }

    private GroupedActionListener<SearchResponse> getCombineResponseGroupedActionListener(final SearchResponse response, final ActionListener<SearchResponse> responseListener, final SearchHit[] hits) {
        GroupedActionListener combineResponseListener = new GroupedActionListener((ActionListener)new ActionListener<Collection<SearchResponse>>(){

            public void onResponse(Collection<SearchResponse> responseMapCollection) {
                SearchHit[] combinedHits = new SearchHit[hits.length];
                int i = 0;
                for (SearchResponse OneHitResponseAfterInference : responseMapCollection) {
                    SearchHit[] hitsAfterInference = OneHitResponseAfterInference.getHits().getHits();
                    combinedHits[i] = hitsAfterInference[0];
                    ++i;
                }
                SearchResponse oneToOneInferenceSearchResponse = SearchResponseUtil.replaceHits(combinedHits, response);
                responseListener.onResponse((Object)oneToOneInferenceSearchResponse);
            }

            public void onFailure(Exception e) {
                if (MLInferenceSearchResponseProcessor.this.ignoreFailure) {
                    responseListener.onResponse((Object)response);
                } else {
                    responseListener.onFailure(e);
                }
            }
        }, hits.length);
        return combineResponseListener;
    }

    private void rewriteResponseDocuments(SearchResponse response, ActionListener<SearchResponse> responseListener, String queryString) throws IOException {
        List<Map<String, String>> processInputMap = this.inferenceProcessorAttributes.getInputMaps();
        List<Map<String, String>> processOutputMap = this.inferenceProcessorAttributes.getOutputMaps();
        List<Map<String, String>> combinedInputMaps = ModelExecutor.combineMaps(processInputMap, this.optionalInputMaps);
        List<Map<String, String>> combinedOutputMaps = ModelExecutor.combineMaps(processOutputMap, this.optionalOutputMaps);
        int inputMapSize = combinedInputMaps == null ? 0 : combinedInputMaps.size();
        HashMap<Integer, Integer> hitCountInPredictions = new HashMap<Integer, Integer>();
        ActionListener<Map<Integer, MLOutput>> rewriteResponseListener = this.createRewriteResponseListener(response, responseListener, processInputMap, combinedInputMaps, combinedOutputMaps, hitCountInPredictions);
        GroupedActionListener<Map<Integer, MLOutput>> batchPredictionListener = this.createBatchPredictionListener(rewriteResponseListener, inputMapSize);
        SearchHit[] hits = response.getHits().getHits();
        for (int inputMapIndex = 0; inputMapIndex < Math.max(inputMapSize, 1); ++inputMapIndex) {
            this.processPredictions(hits, combinedInputMaps, inputMapIndex, batchPredictionListener, hitCountInPredictions, queryString);
        }
    }

    private void processPredictions(SearchHit[] hits, List<Map<String, String>> processInputMap, final int inputMapIndex, final GroupedActionListener<Map<Integer, MLOutput>> batchPredictionListener, Map<Integer, Integer> hitCountInPredictions, String queryString) throws IOException {
        HashMap<String, String> modelParameters = new HashMap<String, String>();
        HashMap<String, String> modelConfigs = new HashMap<String, String>();
        if (this.inferenceProcessorAttributes.getModelConfigMaps() != null) {
            Map<String, String> modelConfigMapsInput = this.inferenceProcessorAttributes.getModelConfigMaps();
            modelParameters.putAll(modelConfigMapsInput);
            modelConfigs.putAll(modelConfigMapsInput);
        }
        HashMap<String, Object> modelInputParameters = new HashMap<String, Object>();
        if (!CollectionUtils.isEmpty(processInputMap)) {
            Map<String, String> inputMapping = processInputMap.get(inputMapIndex);
            boolean isRequestInputMissing = this.checkIsRequestInputMissing(queryString, inputMapping);
            if (isRequestInputMissing && !this.ignoreMissing) {
                throw new IllegalArgumentException("Missing required input field in query body. input_map: " + String.valueOf(inputMapping.values()) + ", query body:" + queryString);
            }
            List<Map<String, String>> requiredInputFields = this.getInferenceProcessorAttributes().getInputMaps();
            Map<Object, Object> requiredInputMapping = requiredInputFields != null && requiredInputFields.size() > inputMapIndex ? requiredInputFields.get(inputMapIndex) : new HashMap();
            for (SearchHit hit : hits) {
                Map document = hit.getSourceAsMap();
                boolean isDocumentFieldMissing = this.checkIsDocumentFieldMissing(document, requiredInputMapping);
                if (!isDocumentFieldMissing) {
                    MapUtils.incrementCounter(hitCountInPredictions, inputMapIndex);
                    for (Map.Entry<String, String> entry : inputMapping.entrySet()) {
                        String modelInputFieldName = entry.getKey();
                        String documentFieldName = entry.getValue();
                        if (StringUtils.isValidJSONPath((String)documentFieldName) && (documentFieldName.startsWith("$._request.") || documentFieldName.startsWith(REQUEST_PREFIX)) && !modelInputParameters.containsKey(modelInputFieldName)) {
                            String requestFieldName = documentFieldName.replaceFirst(REQUEST_PREFIX, "");
                            Object queryText = JsonPath.using((Configuration)suppressExceptionConfiguration).parse(queryString).read(requestFieldName, new Predicate[0]);
                            if (queryText == null) continue;
                            modelInputParameters.put(modelInputFieldName, StringUtils.toJson((Object)queryText));
                            continue;
                        }
                        Object documentValue = JsonPath.using((Configuration)suppressExceptionConfiguration).parse((Object)document).read(documentFieldName, new Predicate[0]);
                        if (documentValue == null) continue;
                        this.updateModelInputParameters(modelInputParameters, modelInputFieldName, documentValue);
                    }
                    continue;
                }
                if (this.ignoreMissing) continue;
                throw new IllegalArgumentException("cannot find all required input fields: " + String.valueOf(inputMapping.values()) + " in hit:" + String.valueOf(hit) + " and query body:" + queryString);
            }
        } else {
            for (SearchHit hit : hits) {
                Map document = hit.getSourceAsMap();
                MapUtils.incrementCounter(hitCountInPredictions, inputMapIndex);
                for (Map.Entry entry : document.entrySet()) {
                    String modelInputFieldName = (String)entry.getKey();
                    Object documentValue = entry.getValue();
                    this.updateModelInputParameters(modelInputParameters, modelInputFieldName, documentValue);
                }
            }
        }
        Map modelParametersInString = StringUtils.getParameterMap(modelInputParameters);
        modelParameters.putAll(modelParametersInString);
        HashSet inputMapKeys = new HashSet(modelParameters.keySet());
        inputMapKeys.removeAll(modelConfigs.keySet());
        HashMap<String, String> inputMappings = new HashMap<String, String>();
        for (String k : inputMapKeys) {
            inputMappings.put(k, (String)modelParameters.get(k));
        }
        ActionRequest request = this.getMLModelInferenceRequest(this.xContentRegistry, modelParameters, modelConfigs, inputMappings, this.inferenceProcessorAttributes.getModelId(), this.functionName, this.modelInput);
        client.execute((ActionType)MLPredictionTaskAction.INSTANCE, request, (ActionListener)new ActionListener<MLTaskResponse>(this){

            public void onResponse(MLTaskResponse mlTaskResponse) {
                MLOutput mlOutput = mlTaskResponse.getOutput();
                HashMap<Integer, MLOutput> mlOutputMap = new HashMap<Integer, MLOutput>();
                mlOutputMap.put(inputMapIndex, mlOutput);
                batchPredictionListener.onResponse(mlOutputMap);
            }

            public void onFailure(Exception e) {
                batchPredictionListener.onFailure(e);
            }
        });
    }

    private void updateModelInputParameters(Map<String, Object> modelInputParameters, String modelInputFieldName, Object documentValue) {
        if (!this.oneToOne) {
            if (!modelInputParameters.containsKey(modelInputFieldName)) {
                ArrayList<Object> documentValueList = new ArrayList<Object>();
                documentValueList.add(documentValue);
                modelInputParameters.put(modelInputFieldName, documentValueList);
            } else {
                List valueList = (List)modelInputParameters.get(modelInputFieldName);
                valueList.add(documentValue);
            }
        } else {
            modelInputParameters.put(modelInputFieldName, documentValue);
        }
    }

    private GroupedActionListener<Map<Integer, MLOutput>> createBatchPredictionListener(final ActionListener<Map<Integer, MLOutput>> rewriteResponseListener, int inputMapSize) {
        return new GroupedActionListener((ActionListener)new ActionListener<Collection<Map<Integer, MLOutput>>>(this){

            public void onResponse(Collection<Map<Integer, MLOutput>> mlOutputMapCollection) {
                HashMap<Integer, MLOutput> mlOutputMaps = new HashMap<Integer, MLOutput>();
                for (Map<Integer, MLOutput> mlOutputMap : mlOutputMapCollection) {
                    mlOutputMaps.putAll(mlOutputMap);
                }
                rewriteResponseListener.onResponse(mlOutputMaps);
            }

            public void onFailure(Exception e) {
                logger.error("Prediction Failed:", (Throwable)e);
                rewriteResponseListener.onFailure(e);
            }
        }, Math.max(inputMapSize, 1));
    }

    private ActionListener<Map<Integer, MLOutput>> createRewriteResponseListener(final SearchResponse response, final ActionListener<SearchResponse> responseListener, final List<Map<String, String>> requiredInputFields, final List<Map<String, String>> processInputMap, final List<Map<String, String>> processOutputMap, final Map<Integer, Integer> hitCountInPredictions) {
        return new ActionListener<Map<Integer, MLOutput>>(){

            public void onResponse(Map<Integer, MLOutput> multipleMLOutputs) {
                try {
                    HashMap<Integer, Map<String, Integer>> writeOutputMapDocCounter = new HashMap<Integer, Map<String, Integer>>();
                    for (SearchHit hit : response.getHits().getHits()) {
                        HashMap<String, Object> sourceAsMapWithInference = new HashMap<String, Object>();
                        if (!hit.hasSource()) continue;
                        BytesReference sourceRef = hit.getSourceRef();
                        Tuple typeAndSourceMap = XContentHelper.convertToMap((BytesReference)sourceRef, (boolean)false, (MediaType)null);
                        Map sourceAsMap = (Map)typeAndSourceMap.v2();
                        sourceAsMapWithInference.putAll(sourceAsMap);
                        Map document = hit.getSourceAsMap();
                        for (Map.Entry<Integer, MLOutput> entry : multipleMLOutputs.entrySet()) {
                            Integer mappingIndex = entry.getKey();
                            MLOutput mlOutput = entry.getValue();
                            Map<String, String> outputMapping = MLInferenceSearchResponseProcessor.getDefaultOutputMapping(mappingIndex, processOutputMap);
                            Map requiredInputMapping = requiredInputFields != null && requiredInputFields.size() > mappingIndex ? (Map)requiredInputFields.get(mappingIndex) : new HashMap();
                            boolean isDocumentFieldMissing = false;
                            if (!CollectionUtils.isEmpty((Collection)processInputMap)) {
                                isDocumentFieldMissing = MLInferenceSearchResponseProcessor.this.checkIsDocumentFieldMissing(document, requiredInputMapping);
                            }
                            if (isDocumentFieldMissing) continue;
                            for (Map.Entry<String, String> outputMapEntry : outputMapping.entrySet()) {
                                Object modelOutputValuePerDoc;
                                String newDocumentFieldName = outputMapEntry.getKey();
                                String modelOutputFieldName = outputMapEntry.getValue();
                                MapUtils.incrementCounter(writeOutputMapDocCounter, mappingIndex, modelOutputFieldName);
                                Object modelOutputValue = MLInferenceSearchResponseProcessor.this.getModelOutputValue(mlOutput, modelOutputFieldName, MLInferenceSearchResponseProcessor.this.ignoreMissing, MLInferenceSearchResponseProcessor.this.fullResponsePath);
                                if (newDocumentFieldName.startsWith(MLInferenceSearchResponseProcessor.EXTENSION_PREFIX)) {
                                    Map<String, Object> params = ((MLInferenceSearchResponse)response).getParams();
                                    String paramsName = newDocumentFieldName.replaceFirst("ext.ml_inference.", "");
                                    if (params != null) {
                                        params.put(paramsName, modelOutputValue);
                                        ((MLInferenceSearchResponse)response).setParams(params);
                                        continue;
                                    }
                                    HashMap<String, Object> newParams = new HashMap<String, Object>();
                                    newParams.put(paramsName, modelOutputValue);
                                    ((MLInferenceSearchResponse)response).setParams(newParams);
                                    continue;
                                }
                                if (hitCountInPredictions.containsKey(mappingIndex)) {
                                    if (modelOutputValue instanceof List && ((List)modelOutputValue).size() == ((Integer)hitCountInPredictions.get(mappingIndex)).intValue() && !MLInferenceSearchResponseProcessor.this.oneToOne) {
                                        Object valuePerDoc = ((List)modelOutputValue).get(MapUtils.getCounter(writeOutputMapDocCounter, mappingIndex, modelOutputFieldName));
                                        modelOutputValuePerDoc = valuePerDoc;
                                    } else {
                                        modelOutputValuePerDoc = modelOutputValue;
                                    }
                                } else {
                                    modelOutputValuePerDoc = modelOutputValue;
                                }
                                if (sourceAsMap.containsKey(newDocumentFieldName)) {
                                    if (MLInferenceSearchResponseProcessor.this.override) {
                                        sourceAsMapWithInference.remove(newDocumentFieldName);
                                        sourceAsMapWithInference.put(newDocumentFieldName, modelOutputValuePerDoc);
                                        continue;
                                    }
                                    logger.debug("{} already exists in the search response hit. Skip processing this field.", (Object)newDocumentFieldName);
                                    continue;
                                }
                                sourceAsMapWithInference.put(newDocumentFieldName, modelOutputValuePerDoc);
                            }
                        }
                        XContentBuilder builder = XContentBuilder.builder((XContent)((MediaType)typeAndSourceMap.v1()).xContent());
                        builder.map(sourceAsMapWithInference);
                        hit.sourceRef(BytesReference.bytes((XContentBuilder)builder));
                    }
                }
                catch (Exception e) {
                    if (MLInferenceSearchResponseProcessor.this.ignoreFailure) {
                        responseListener.onResponse((Object)response);
                    }
                    responseListener.onFailure(e);
                }
                responseListener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                if (MLInferenceSearchResponseProcessor.this.ignoreFailure) {
                    logger.error("Failed in writing prediction outcomes to search response", (Throwable)e);
                    responseListener.onResponse((Object)response);
                } else {
                    responseListener.onFailure(e);
                }
            }
        };
    }

    private boolean checkIsDocumentFieldMissing(Map<String, Object> document, Map<String, String> inputMapping) {
        return inputMapping.values().stream().filter(fieldName -> !fieldName.startsWith("$._request.") && !fieldName.startsWith(REQUEST_PREFIX)).anyMatch(fieldName -> {
            boolean isFieldPresentInDocument = document != null && this.hasField(document, (String)fieldName);
            boolean isFieldPresentInModelConfig = this.inferenceProcessorAttributes.modelConfigMaps != null && this.inferenceProcessorAttributes.modelConfigMaps.containsKey(fieldName);
            return !isFieldPresentInDocument && !isFieldPresentInModelConfig;
        });
    }

    private boolean checkIsRequestInputMissing(String queryString, Map<String, String> inputMapping) {
        return inputMapping.values().stream().filter(fieldName -> fieldName.startsWith("$._request.") || fieldName.startsWith(REQUEST_PREFIX)).map(fieldName -> fieldName.replaceFirst(REQUEST_PREFIX, "")).anyMatch(requestFieldName -> {
            boolean isFieldPresentInQuery = queryString != null && this.hasField(queryString, (String)requestFieldName);
            boolean isFieldPresentInModelConfig = this.inferenceProcessorAttributes.modelConfigMaps != null && this.inferenceProcessorAttributes.modelConfigMaps.containsKey(requestFieldName);
            return !isFieldPresentInQuery && !isFieldPresentInModelConfig;
        });
    }

    private static Map<String, String> getDefaultOutputMapping(Integer mappingIndex, List<Map<String, String>> processOutputMap) {
        HashMap<String, String> outputMapping;
        if (processOutputMap == null || processOutputMap.size() == 0) {
            outputMapping = new HashMap<String, Object>();
            outputMapping.put(DEFAULT_OUTPUT_FIELD_NAME, null);
        } else {
            outputMapping = processOutputMap.get(mappingIndex);
        }
        return outputMapping;
    }

    private static Map<String, String> getDefaultInputMapping(Map<String, Object> sourceAsMap, Integer mappingIndex, List<Map<String, String>> processInputMap) {
        HashMap<String, String> inputMapping;
        if (!CollectionUtils.isEmpty(processInputMap)) {
            inputMapping = new HashMap();
            inputMapping.putAll(StringUtils.getParameterMap(sourceAsMap));
        } else {
            inputMapping = processInputMap.get(mappingIndex);
        }
        return inputMapping;
    }

    public String getType() {
        return TYPE;
    }

    @Generated
    public InferenceProcessorAttributes getInferenceProcessorAttributes() {
        return this.inferenceProcessorAttributes;
    }

    @Generated
    public List<Map<String, String>> getOptionalInputMaps() {
        return this.optionalInputMaps;
    }

    @Generated
    public List<Map<String, String>> getOptionalOutputMaps() {
        return this.optionalOutputMaps;
    }

    public static class Factory
    implements Processor.Factory<SearchResponseProcessor> {
        private final Client client;
        private final NamedXContentRegistry xContentRegistry;

        public Factory(Client client, NamedXContentRegistry xContentRegistry) {
            this.client = client;
            this.xContentRegistry = xContentRegistry;
        }

        public MLInferenceSearchResponseProcessor create(Map<String, Processor.Factory<SearchResponseProcessor>> processorFactories, String processorTag, String description, boolean ignoreFailure, Map<String, Object> config, Processor.PipelineContext pipelineContext) {
            String modelId = ConfigurationUtils.readStringProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"model_id");
            Map modelConfigInput = ConfigurationUtils.readOptionalMap((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"model_config");
            List inputMaps = ConfigurationUtils.readOptionalList((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"input_map");
            List outputMaps = ConfigurationUtils.readOptionalList((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"output_map");
            List optionalInputMaps = ConfigurationUtils.readOptionalList((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"optional_input_map");
            List optionalOutputMaps = ConfigurationUtils.readOptionalList((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"optional_output_map");
            int maxPredictionTask = ConfigurationUtils.readIntProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"max_prediction_tasks", (Integer)10);
            boolean ignoreMissing = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchResponseProcessor.IGNORE_MISSING, (boolean)false);
            String functionName = ConfigurationUtils.readStringProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchResponseProcessor.FUNCTION_NAME, (String)FunctionName.REMOTE.name());
            boolean override = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)"override", (boolean)false);
            boolean oneToOne = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchResponseProcessor.ONE_TO_ONE, (boolean)false);
            String modelInput = ConfigurationUtils.readOptionalStringProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchResponseProcessor.MODEL_INPUT);
            if (functionName.equalsIgnoreCase("remote")) {
                modelInput = modelInput != null ? modelInput : MLInferenceSearchResponseProcessor.DEFAULT_MODEL_INPUT;
            } else if (modelInput == null) {
                throw new IllegalArgumentException("Please provide model input when using a local model in ML Inference Processor");
            }
            boolean defaultFullResponsePath = !functionName.equalsIgnoreCase(FunctionName.REMOTE.name());
            boolean fullResponsePath = ConfigurationUtils.readBooleanProperty((String)MLInferenceSearchResponseProcessor.TYPE, (String)processorTag, config, (String)MLInferenceSearchResponseProcessor.FULL_RESPONSE_PATH, (boolean)defaultFullResponsePath);
            Map modelConfigMaps = null;
            if (modelConfigInput != null) {
                modelConfigMaps = StringUtils.getParameterMap((Map)modelConfigInput);
            }
            List<Map<String, String>> combinedInputMaps = ModelExecutor.combineMaps(inputMaps, optionalInputMaps);
            List<Map<String, String>> combinedOutputMaps = ModelExecutor.combineMaps(outputMaps, optionalOutputMaps);
            if (combinedInputMaps != null && combinedInputMaps.size() > maxPredictionTask) {
                throw new IllegalArgumentException("The number of prediction task setting in this process is " + combinedInputMaps.size() + ". It exceeds the max_prediction_tasks of " + maxPredictionTask + ". Please reduce the size of input_map or optional_input_map or increase max_prediction_tasks.");
            }
            if (!CollectionUtils.isEmpty(combinedOutputMaps) && !CollectionUtils.isEmpty(combinedInputMaps) && combinedOutputMaps.size() != combinedInputMaps.size()) {
                throw new IllegalArgumentException("when output_maps/optional_output_maps and input_maps/optional_input_maps are provided, their length needs to match. The input is in length of " + combinedInputMaps.size() + ", while output_maps is in the length of " + combinedOutputMaps.size() + ". Please adjust mappings.");
            }
            boolean writeToSearchExtension = false;
            if (outputMaps != null) {
                writeToSearchExtension = outputMaps.stream().filter(Objects::nonNull).flatMap(outputMap -> outputMap.keySet().stream()).anyMatch(key -> key.startsWith(MLInferenceSearchResponseProcessor.EXTENSION_PREFIX));
            }
            if (writeToSearchExtension & oneToOne) {
                throw new IllegalArgumentException("Write model response to search extension does not support when one_to_one is true.");
            }
            return new MLInferenceSearchResponseProcessor(modelId, inputMaps, outputMaps, optionalInputMaps, optionalOutputMaps, modelConfigMaps, maxPredictionTask, processorTag, description, ignoreMissing, functionName, fullResponsePath, ignoreFailure, override, modelInput, this.client, this.xContentRegistry, oneToOne);
        }
    }
}

