/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals.events;

import java.util.Optional;
import org.apache.kafka.clients.consumer.internals.ConsumerUtils;
import org.apache.kafka.clients.consumer.internals.events.ApplicationEvent;
import org.apache.kafka.clients.consumer.internals.events.MetadataErrorNotifiableEvent;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.utils.Time;

public class AsyncPollEvent
extends ApplicationEvent
implements MetadataErrorNotifiableEvent {
    private final long deadlineMs;
    private final long pollTimeMs;
    private volatile KafkaException error;
    private volatile boolean isComplete;
    private volatile boolean isValidatePositionsComplete;

    public AsyncPollEvent(long deadlineMs, long pollTimeMs) {
        super(ApplicationEvent.Type.ASYNC_POLL);
        this.deadlineMs = deadlineMs;
        this.pollTimeMs = pollTimeMs;
    }

    public long deadlineMs() {
        return this.deadlineMs;
    }

    public long pollTimeMs() {
        return this.pollTimeMs;
    }

    public Optional<KafkaException> error() {
        return Optional.ofNullable(this.error);
    }

    public boolean isExpired(Time time) {
        return time.milliseconds() >= this.deadlineMs();
    }

    public boolean isValidatePositionsComplete() {
        return this.isValidatePositionsComplete;
    }

    public void markValidatePositionsComplete() {
        this.isValidatePositionsComplete = true;
    }

    public boolean isComplete() {
        return this.isComplete;
    }

    public void completeSuccessfully() {
        this.isComplete = true;
    }

    public void completeExceptionally(KafkaException e) {
        this.error = e;
        this.isComplete = true;
    }

    @Override
    public void onMetadataError(Exception metadataError) {
        this.completeExceptionally(ConsumerUtils.maybeWrapAsKafkaException(metadataError));
    }

    @Override
    protected String toStringBase() {
        return super.toStringBase() + ", deadlineMs=" + this.deadlineMs + ", pollTimeMs=" + this.pollTimeMs + ", error=" + String.valueOf(this.error) + ", isComplete=" + this.isComplete + ", isValidatePositionsComplete=" + this.isValidatePositionsComplete;
    }
}

