/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.maven.compiler;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.builders.artifacts.ArtifactBuildTaskProvider;
import org.jetbrains.jps.builders.storage.BuildDataPaths;
import org.jetbrains.jps.incremental.BuildTask;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.FSOperations;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactUtil;
import org.jetbrains.jps.incremental.fs.CompilationRound;
import org.jetbrains.jps.maven.model.JpsMavenExtensionService;
import org.jetbrains.jps.maven.model.impl.MavenModuleResourceConfiguration;
import org.jetbrains.jps.maven.model.impl.MavenProjectConfiguration;
import org.jetbrains.jps.model.artifact.JpsArtifact;
import org.jetbrains.jps.model.artifact.elements.JpsArtifactRootElement;
import org.jetbrains.jps.model.artifact.elements.JpsDirectoryPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsFileCopyPackagingElement;
import org.jetbrains.jps.model.artifact.elements.JpsPackagingElement;
import org.jetbrains.jps.model.ex.JpsElementBase;

public final class MavenManifestGenerationBuildTaskProvider
extends ArtifactBuildTaskProvider {
    @NotNull
    public List<? extends BuildTask> createArtifactBuildTasks(@NotNull JpsArtifact artifact, @NotNull ArtifactBuildTaskProvider.ArtifactBuildPhase buildPhase) {
        if (artifact == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(0);
        }
        if (buildPhase == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(1);
        }
        String artifactName = artifact.getName();
        if (buildPhase == ArtifactBuildTaskProvider.ArtifactBuildPhase.PRE_PROCESSING && (artifactName.endsWith(" exploded") || artifactName.endsWith("ejb-client")) && artifact.getRootElement() instanceof JpsArtifactRootElement) {
            List<MavenManifestGenerationBuildTask> list = Collections.singletonList(new MavenManifestGenerationBuildTask(artifact));
            if (list == null) {
                MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(2);
            }
            return list;
        }
        List list = Collections.emptyList();
        if (list == null) {
            MavenManifestGenerationBuildTaskProvider.$$$reportNull$$$0(3);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildPhase";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createArtifactBuildTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createArtifactBuildTasks";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MavenManifestGenerationBuildTask
    extends BuildTask {
        private static final Logger LOG = Logger.getInstance(MavenManifestGenerationBuildTask.class);
        private final JpsArtifact myArtifact;

        MavenManifestGenerationBuildTask(JpsArtifact artifact) {
            this.myArtifact = artifact;
        }

        public void build(CompileContext context) {
            BuildDataPaths dataPaths = context.getProjectDescriptor().dataManager.getDataPaths();
            MavenProjectConfiguration projectConfiguration = JpsMavenExtensionService.getInstance().getMavenProjectConfiguration(dataPaths);
            if (projectConfiguration == null) {
                return;
            }
            MavenModuleResourceConfiguration moduleResourceConfiguration = projectConfiguration.moduleConfigurations.get(MavenManifestGenerationBuildTask.getModuleName(this.myArtifact.getName()));
            if (moduleResourceConfiguration != null && StringUtil.isNotEmpty((String)moduleResourceConfiguration.manifest)) {
                try {
                    File output = new File(this.myArtifact.getOutputPath(), "META-INF/MANIFEST.MF");
                    FileUtil.writeToFile((File)output, (byte[])Base64.getDecoder().decode(moduleResourceConfiguration.manifest));
                    this.handleSkinnyWars(context, projectConfiguration, moduleResourceConfiguration);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e);
                }
            }
        }

        private void handleSkinnyWars(CompileContext context, MavenProjectConfiguration projectConfiguration, MavenModuleResourceConfiguration moduleResourceConfiguration) {
            if (!"ear".equals(moduleResourceConfiguration.modelMap.get("packaging"))) {
                return;
            }
            if (!Boolean.parseBoolean(moduleResourceConfiguration.modelMap.get("build.plugin.maven-ear-plugin.skinnyWars"))) {
                return;
            }
            String earClasspath = moduleResourceConfiguration.classpath;
            if (earClasspath == null) {
                return;
            }
            Map earClasspathMap = ContainerUtil.map2Map((Collection)StringUtil.split((String)earClasspath, (String)" "), s -> {
                int idx = s.lastIndexOf("/");
                return Pair.create((Object)s.substring(idx == -1 ? 0 : idx + 1), (Object)s);
            });
            JpsArtifactUtil.processPackagingElements((JpsPackagingElement)this.myArtifact.getRootElement(), element -> {
                if (!(element instanceof JpsFileCopyPackagingElement)) {
                    return true;
                }
                JpsFileCopyPackagingElement fileCopyPackagingElement = (JpsFileCopyPackagingElement)element;
                String filePath = fileCopyPackagingElement.getFilePath();
                Path skinnyManifest = Path.of(filePath, new String[0]);
                if (!skinnyManifest.endsWith("SKINNY_MANIFEST.MF")) {
                    return true;
                }
                String skinnyWarModuleName = skinnyManifest.getParent().getParent().getFileName().toString();
                MavenModuleResourceConfiguration warConfiguration = projectConfiguration.moduleConfigurations.get(skinnyWarModuleName);
                if (warConfiguration == null || warConfiguration.classpath == null) {
                    return true;
                }
                try {
                    Path skinnyManifestTargetFile;
                    block16: {
                        byte[] warManifestData = Base64.getDecoder().decode(warConfiguration.manifest);
                        Manifest warManifest = new Manifest(new ByteArrayInputStream(warManifestData));
                        ArrayList<String> skinnyWarClasspath = new ArrayList<String>();
                        Iterator iterator = StringUtil.split((String)warConfiguration.classpath, (String)" ").iterator();
                        while (iterator.hasNext()) {
                            String entry;
                            int idx = (entry = (String)iterator.next()).lastIndexOf("/");
                            String entryName = entry.substring(idx == -1 ? 0 : idx + 1);
                            String earEntryPath = (String)earClasspathMap.get(entryName);
                            skinnyWarClasspath.add(earEntryPath == null ? entry : earEntryPath);
                        }
                        Attributes warManifestMainAttributes = warManifest.getMainAttributes();
                        warManifestMainAttributes.putValue("Class-Path", StringUtil.join(skinnyWarClasspath, (String)" "));
                        skinnyManifestTargetFile = null;
                        Files.createDirectories(skinnyManifest.getParent(), new FileAttribute[0]);
                        try (OutputStream outputStream = Files.newOutputStream(skinnyManifest, new OpenOption[0]);){
                            warManifest.write(outputStream);
                            if (!(fileCopyPackagingElement instanceof JpsElementBase)) break block16;
                            LinkedList<String> pathParts = new LinkedList<String>();
                            pathParts.add(fileCopyPackagingElement.getRenamedOutputFileName());
                            for (JpsElementBase parent = ((JpsElementBase)fileCopyPackagingElement).getParent(); parent != null; parent = parent.getParent()) {
                                String outputPath;
                                if (parent instanceof JpsDirectoryPackagingElement) {
                                    pathParts.addFirst(((JpsDirectoryPackagingElement)parent).getDirectoryName());
                                    continue;
                                }
                                if (!(parent instanceof JpsArtifact) || (outputPath = ((JpsArtifact)parent).getOutputPath()) == null) continue;
                                pathParts.addFirst(outputPath);
                                skinnyManifestTargetFile = Path.of(String.join((CharSequence)"/", pathParts), new String[0]);
                                break;
                            }
                        }
                    }
                    if (skinnyManifestTargetFile != null) {
                        Files.createDirectories(skinnyManifestTargetFile.getParent(), new FileAttribute[0]);
                        FileUtil.copy((File)skinnyManifest.toFile(), (File)skinnyManifestTargetFile.toFile());
                    }
                    FSOperations.markDirtyIfNotDeleted((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (Path)skinnyManifest);
                    if (skinnyManifestTargetFile != null) {
                        FSOperations.markDirtyIfNotDeleted((CompileContext)context, (CompilationRound)CompilationRound.NEXT, (Path)skinnyManifestTargetFile);
                    }
                }
                catch (IOException e) {
                    LOG.debug((Throwable)e);
                }
                return true;
            });
        }

        @Nullable
        private static String getModuleName(@NotNull String artifactName) {
            if (artifactName == null) {
                MavenManifestGenerationBuildTask.$$$reportNull$$$0(0);
            }
            return StringUtil.substringBefore((String)artifactName, (String)":");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "artifactName", "org/jetbrains/jps/maven/compiler/MavenManifestGenerationBuildTaskProvider$MavenManifestGenerationBuildTask", "getModuleName"));
        }
    }
}

