/*
 * Decompiled with CFR 0.152.
 */
package org.editorconfig.configmanagement;

import com.intellij.editorconfig.common.EditorConfigBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.editorconfig.Utils;
import org.editorconfig.configmanagement.editor.EditorConfigPreviewManager;
import org.editorconfig.language.util.EditorConfigPresentationUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0014B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001d\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r2\u0006\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\nH\u0002\u00a8\u0006\u0015"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigNavigationActionsFactory;", "", "<init>", "()V", "getNavigationActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "project", "Lcom/intellij/openapi/project/Project;", "sourceFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getActionName", "", "Lorg/jetbrains/annotations/Nls;", "file", "withFolder", "", "openEditorConfig", "", "editorConfigFile", "NavigationActionGroup", "intellij.editorconfig.backend"})
@SourceDebugExtension(value={"SMAP\nEditorConfigNavigationActionsFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EditorConfigNavigationActionsFactory.kt\norg/editorconfig/configmanagement/EditorConfigNavigationActionsFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1563#2:59\n1634#2,3:60\n*S KotlinDebug\n*F\n+ 1 EditorConfigNavigationActionsFactory.kt\norg/editorconfig/configmanagement/EditorConfigNavigationActionsFactory\n*L\n24#1:59\n24#1:60,3\n*E\n"})
public final class EditorConfigNavigationActionsFactory {
    @NotNull
    public static final EditorConfigNavigationActionsFactory INSTANCE = new EditorConfigNavigationActionsFactory();

    private EditorConfigNavigationActionsFactory() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<AnAction> getNavigationActions(@NotNull Project project, @NotNull VirtualFile sourceFile) {
        List list;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)sourceFile, (String)"sourceFile");
        List<VirtualFile> editorConfigFiles = Utils.INSTANCE.relatedEditorConfigFiles(sourceFile);
        if (editorConfigFiles.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        boolean withFolder = editorConfigFiles.size() > 1;
        Iterable $this$map$iv = editorConfigFiles;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void editorConfigFile;
            VirtualFile virtualFile = (VirtualFile)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(DumbAwareAction.create((String)INSTANCE.getActionName((VirtualFile)editorConfigFile, withFolder), arg_0 -> EditorConfigNavigationActionsFactory.getNavigationActions$lambda$0$1(arg_0 -> EditorConfigNavigationActionsFactory.getNavigationActions$lambda$0$0(project, sourceFile, (VirtualFile)editorConfigFile, arg_0), arg_0)));
        }
        List navigationActions = (List)destination$iv$iv;
        if (withFolder) {
            Collection collection = navigationActions;
            Intrinsics.checkNotNullExpressionValue((Object)AnAction.EMPTY_ARRAY, (String)"EMPTY_ARRAY");
            list = CollectionsKt.listOf((Object)((Object)new NavigationActionGroup((AnAction[])UtilKt.toArray((Collection)collection, (Object[])AnAction.EMPTY_ARRAY))));
        } else {
            list = navigationActions;
        }
        return list;
    }

    private final String getActionName(VirtualFile file, boolean withFolder) {
        return !withFolder ? EditorConfigBundle.message((String)"action.open.file") : EditorConfigPresentationUtil.getFileName(file, withFolder);
    }

    private final void openEditorConfig(Project project, VirtualFile sourceFile, VirtualFile editorConfigFile) {
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        if (fileEditorManager.isFileOpen(editorConfigFile)) {
            fileEditorManager.closeFile(editorConfigFile);
        }
        EditorConfigPreviewManager.getInstance(project).associateWithPreviewFile(editorConfigFile, sourceFile);
        fileEditorManager.openFile(editorConfigFile, true);
    }

    private static final Unit getNavigationActions$lambda$0$0(Project $project, VirtualFile $sourceFile, VirtualFile $editorConfigFile, AnActionEvent it) {
        INSTANCE.openEditorConfig($project, $sourceFile, $editorConfigFile);
        return Unit.INSTANCE;
    }

    private static final void getNavigationActions$lambda$0$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016\u00a2\u0006\u0002\u0010\u000bR\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/editorconfig/configmanagement/EditorConfigNavigationActionsFactory$NavigationActionGroup;", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "myChildActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "<init>", "([Lcom/intellij/openapi/actionSystem/AnAction;)V", "[Lcom/intellij/openapi/actionSystem/AnAction;", "getChildren", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "(Lcom/intellij/openapi/actionSystem/AnActionEvent;)[Lcom/intellij/openapi/actionSystem/AnAction;", "intellij.editorconfig.backend"})
    private static final class NavigationActionGroup
    extends ActionGroup {
        @NotNull
        private final AnAction[] myChildActions;

        public NavigationActionGroup(@NotNull AnAction[] myChildActions) {
            Intrinsics.checkNotNullParameter((Object)myChildActions, (String)"myChildActions");
            super(EditorConfigBundle.message((String)"action.open.file"), true);
            this.myChildActions = myChildActions;
        }

        @NotNull
        public AnAction[] getChildren(@Nullable AnActionEvent e) {
            return this.myChildActions;
        }
    }
}

