/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.text;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.Size;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Canvas;
import androidx.compose.ui.graphics.Rects_skikoKt;
import androidx.compose.ui.graphics.Shadow;
import androidx.compose.ui.graphics.SkiaBackedCanvas_skikoKt;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.drawscope.DrawStyle;
import androidx.compose.ui.text.CharHelpers_jvmKt;
import androidx.compose.ui.text.CharHelpers_skikoKt;
import androidx.compose.ui.text.ExperimentalTextApi;
import androidx.compose.ui.text.Paragraph;
import androidx.compose.ui.text.SkiaParagraph_skikoKt;
import androidx.compose.ui.text.TextInclusionStrategy;
import androidx.compose.ui.text.TextRange;
import androidx.compose.ui.text.TextRangeKt;
import androidx.compose.ui.text.internal.InlineClassHelperKt;
import androidx.compose.ui.text.platform.ParagraphLayouter;
import androidx.compose.ui.text.platform.SkiaParagraphIntrinsics;
import androidx.compose.ui.text.style.ResolvedTextDirection;
import androidx.compose.ui.text.style.TextAlign;
import androidx.compose.ui.text.style.TextDecoration;
import androidx.compose.ui.text.style.TextOverflow;
import androidx.compose.ui.unit.Constraints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.skia.Font;
import org.jetbrains.skia.FontMetrics;
import org.jetbrains.skia.Path;
import org.jetbrains.skia.paragraph.Direction;
import org.jetbrains.skia.paragraph.LineMetrics;
import org.jetbrains.skia.paragraph.RectHeightMode;
import org.jetbrains.skia.paragraph.RectWidthMode;
import org.jetbrains.skia.paragraph.TextBox;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00e4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0014\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0001\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020\u00052\u0006\u0010?\u001a\u00020\u0005H\u0016J\u0010\u0010@\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010B\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010D\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010E\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010F\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010G\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bHJ\u0010\u0010I\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0015\u0010J\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0000\u00a2\u0006\u0002\bKJ\u0012\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u0010\u0010N\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010O\u001a\u00020$2\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010P\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0018\u0010Q\u001a\u00020\u00052\u0006\u0010C\u001a\u00020\u00052\u0006\u0010R\u001a\u000202H\u0016J\u0010\u0010S\u001a\u0002022\u0006\u0010C\u001a\u00020\u0005H\u0016J\u0010\u0010T\u001a\u00020\u00052\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010U\u001a\u00020\u00052\u0006\u0010V\u001a\u00020$H\u0016J\u0012\u0010W\u001a\u0004\u0018\u00010M2\u0006\u0010V\u001a\u00020$H\u0002J\u0018\u0010X\u001a\u00020$2\u0006\u0010A\u001a\u00020\u00052\u0006\u0010Y\u001a\u000202H\u0016J\u0010\u0010Z\u001a\u00020$2\u0006\u0010[\u001a\u000202H\u0002J\u0013\u0010b\u001a\b\u0012\u0004\u0012\u00020M0]H\u0002\u00a2\u0006\u0002\u0010aJ\u0012\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u0005H\u0002J\u001c\u0010e\u001a\u0004\u0018\u00010d2\u0006\u0010A\u001a\u00020\u00052\b\b\u0002\u0010?\u001a\u00020\u0005H\u0002J\u0010\u0010f\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0010\u0010h\u001a\u00020g2\u0006\u0010A\u001a\u00020\u0005H\u0016J\u0017\u0010i\u001a\u00020\u00052\u0006\u0010j\u001a\u00020kH\u0016\u00a2\u0006\u0004\bl\u0010mJ'\u0010n\u001a\u00020o2\u0006\u0010p\u001a\u0002092\u0006\u0010q\u001a\u00020r2\u0006\u0010s\u001a\u00020tH\u0016\u00a2\u0006\u0004\bu\u0010vJ\u0010\u0010w\u001a\u0002092\u0006\u0010A\u001a\u00020\u0005H\u0016J'\u0010x\u001a\u00020y2\u0006\u0010z\u001a\u00020o2\u0006\u0010{\u001a\u00020|2\u0006\u0010}\u001a\u00020\u0005H\u0016\u00a2\u0006\u0004\b~\u0010\u007fJ\u001a\u0010\u0080\u0001\u001a\u00020o2\u0006\u0010A\u001a\u00020\u0005H\u0016\u00a2\u0006\u0006\b\u0081\u0001\u0010\u0082\u0001J>\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u0001H\u0016\u00a2\u0006\u0006\b\u008c\u0001\u0010\u008d\u0001JT\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0086\u0001\u001a\u00030\u0087\u00012\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0092\u0001\u0010\u0093\u0001J]\u0010\u0083\u0001\u001a\u00020y2\b\u0010\u0084\u0001\u001a\u00030\u0085\u00012\b\u0010\u0094\u0001\u001a\u00030\u0095\u00012\u0007\u0010\u0096\u0001\u001a\u00020$2\n\u0010\u0088\u0001\u001a\u0005\u0018\u00010\u0089\u00012\n\u0010\u008a\u0001\u001a\u0005\u0018\u00010\u008b\u00012\n\u0010\u008e\u0001\u001a\u0005\u0018\u00010\u008f\u00012\b\u0010\u0090\u0001\u001a\u00030\u0091\u0001H\u0017\u00a2\u0006\u0006\b\u0097\u0001\u0010\u0098\u0001J\u0012\u0010\u0099\u0001\u001a\u00020y2\u0006\u0010A\u001a\u00020\u0005H\u0082\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0010\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u000eR\u0013\u0010\b\u001a\u00020\t\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u001e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u0019@BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010 R\u0014\u0010#\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b(\u0010&R\u0014\u0010)\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010&R\u0014\u0010+\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010&R\u0014\u0010-\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010&R\u0014\u0010/\u001a\u00020$8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u0010&R\u0014\u00101\u001a\u0002028VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b3\u00104R\u0014\u00105\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b6\u0010\rR\u001c\u00107\u001a\n\u0012\u0006\u0012\u0004\u0018\u000109088VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010;R\u0018\u0010\\\u001a\n\u0012\u0004\u0012\u00020M\u0018\u00010]X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010^R\u001a\u0010_\u001a\b\u0012\u0004\u0012\u00020M0]8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010a\u00a8\u0006\u009a\u0001"}, d2={"Landroidx/compose/ui/text/SkiaParagraph;", "Landroidx/compose/ui/text/Paragraph;", "paragraphIntrinsics", "Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;", "maxLines", "", "overflow", "Landroidx/compose/ui/text/style/TextOverflow;", "constraints", "Landroidx/compose/ui/unit/Constraints;", "<init>", "(Landroidx/compose/ui/text/platform/SkiaParagraphIntrinsics;IIJLkotlin/jvm/internal/DefaultConstructorMarker;)V", "getMaxLines", "()I", "I", "getConstraints-msEJaDk", "()J", "J", "layouter", "Landroidx/compose/ui/text/platform/ParagraphLayouter;", "defaultFont", "Lorg/jetbrains/skia/Font;", "getDefaultFont$ui_text", "()Lorg/jetbrains/skia/Font;", "value", "Lorg/jetbrains/skia/paragraph/Paragraph;", "paragraph", "setParagraph", "(Lorg/jetbrains/skia/paragraph/Paragraph;)V", "ellipsis", "", "getEllipsis", "()Ljava/lang/String;", "text", "getText", "width", "", "getWidth", "()F", "height", "getHeight", "minIntrinsicWidth", "getMinIntrinsicWidth", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "firstBaseline", "getFirstBaseline", "lastBaseline", "getLastBaseline", "didExceedMaxLines", "", "getDidExceedMaxLines", "()Z", "lineCount", "getLineCount", "placeholderRects", "", "Landroidx/compose/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getPathForRange", "Landroidx/compose/ui/graphics/Path;", "start", "end", "getCursorRect", "offset", "getLineLeft", "lineIndex", "getLineRight", "getLineTop", "getLineBottom", "getLineAscent", "getLineAscent$ui_text", "getLineBaseline", "getLineDescent", "getLineDescent$ui_text", "lineMetricsForOffset", "Lorg/jetbrains/skia/paragraph/LineMetrics;", "getLineHeight", "getLineWidth", "getLineStart", "getLineEnd", "visibleEnd", "isLineEllipsized", "getLineForOffset", "getLineForVerticalPosition", "vertical", "getLineMetricsForVerticalPosition", "getHorizontalPosition", "usePrimaryDirection", "getAlignedStartingPosition", "isRtl", "_lineMetrics", "", "[Lorg/jetbrains/skia/paragraph/LineMetrics;", "lineMetrics", "getLineMetrics", "()[Lorg/jetbrains/skia/paragraph/LineMetrics;", "receiveLineMetrics", "getBoxForwardByOffset", "Lorg/jetbrains/skia/paragraph/TextBox;", "getBoxBackwardByOffset", "getParagraphDirection", "Landroidx/compose/ui/text/style/ResolvedTextDirection;", "getBidiRunDirection", "getOffsetForPosition", "position", "Landroidx/compose/ui/geometry/Offset;", "getOffsetForPosition-k-4lQ0M", "(J)I", "getRangeForRect", "Landroidx/compose/ui/text/TextRange;", "rect", "granularity", "Landroidx/compose/ui/text/TextGranularity;", "inclusionStrategy", "Landroidx/compose/ui/text/TextInclusionStrategy;", "getRangeForRect-8-6BmAI", "(Landroidx/compose/ui/geometry/Rect;ILandroidx/compose/ui/text/TextInclusionStrategy;)J", "getBoundingBox", "fillBoundingBoxes", "", "range", "array", "", "arrayStart", "fillBoundingBoxes-8ffj60Q", "(J[FI)V", "getWordBoundary", "getWordBoundary--jx7JFs", "(I)J", "paint", "canvas", "Landroidx/compose/ui/graphics/Canvas;", "color", "Landroidx/compose/ui/graphics/Color;", "shadow", "Landroidx/compose/ui/graphics/Shadow;", "textDecoration", "Landroidx/compose/ui/text/style/TextDecoration;", "paint-RPmYEkk", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;)V", "drawStyle", "Landroidx/compose/ui/graphics/drawscope/DrawStyle;", "blendMode", "Landroidx/compose/ui/graphics/BlendMode;", "paint-LG529CI", "(Landroidx/compose/ui/graphics/Canvas;JLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "brush", "Landroidx/compose/ui/graphics/Brush;", "alpha", "paint-hn5TExg", "(Landroidx/compose/ui/graphics/Canvas;Landroidx/compose/ui/graphics/Brush;FLandroidx/compose/ui/graphics/Shadow;Landroidx/compose/ui/text/style/TextDecoration;Landroidx/compose/ui/graphics/drawscope/DrawStyle;I)V", "checkOffsetIsValid", "ui-text"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nSkiaParagraph.skiko.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n+ 2 InlineClassHelper.kt\nandroidx/compose/ui/text/internal/InlineClassHelperKt\n+ 3 Size.kt\nandroidx/compose/ui/geometry/SizeKt\n+ 4 InlineClassHelper.kt\nandroidx/compose/ui/util/InlineClassHelperKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 6 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 7 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph_skikoKt\n+ 8 Offset.kt\nandroidx/compose/ui/geometry/Offset\n+ 9 InlineClassHelper.jvm.kt\nandroidx/compose/ui/util/InlineClassHelper_jvmKt\n*L\n1#1,755:1\n663#1:777\n664#1:780\n666#1:782\n663#1:830\n664#1:833\n666#1:835\n118#2,4:756\n118#2,4:760\n118#2,4:773\n118#2,2:778\n121#2:781\n118#2,4:826\n118#2,2:831\n121#2:834\n118#2,4:840\n33#3:764\n33#3:836\n53#4,3:765\n60#4:804\n70#4:807\n70#4:809\n60#4:812\n60#4:815\n70#4:818\n60#4:821\n70#4:824\n53#4,3:837\n1#5:768\n11561#6:769\n11896#6,3:770\n744#7,10:783\n744#7,10:793\n65#8:803\n69#8:806\n69#8:808\n65#8:811\n65#8:814\n69#8:817\n65#8:820\n69#8:823\n22#9:805\n22#9:810\n22#9:813\n22#9:816\n22#9:819\n22#9:822\n22#9:825\n*S KotlinDebug\n*F\n+ 1 SkiaParagraph.skiko.kt\nandroidx/compose/ui/text/SkiaParagraph\n*L\n181#1:777\n181#1:780\n181#1:782\n561#1:830\n561#1:833\n561#1:835\n79#1:756,4\n83#1:760,4\n162#1:773,4\n181#1:778,2\n181#1:781\n543#1:826,4\n561#1:831,2\n561#1:834\n663#1:840,4\n88#1:764\n642#1:836\n88#1:765,3\n431#1:804\n431#1:807\n470#1:809\n474#1:812\n516#1:815\n517#1:818\n518#1:821\n519#1:824\n642#1:837,3\n157#1:769\n157#1:770,3\n242#1:783,10\n290#1:793,10\n431#1:803\n431#1:806\n470#1:808\n474#1:811\n516#1:814\n517#1:817\n518#1:820\n519#1:823\n431#1:805\n470#1:810\n474#1:813\n516#1:816\n517#1:819\n518#1:822\n519#1:825\n*E\n"})
public final class SkiaParagraph
implements Paragraph {
    @NotNull
    private final SkiaParagraphIntrinsics paragraphIntrinsics;
    private final int maxLines;
    private final int overflow;
    private final long constraints;
    @NotNull
    private final ParagraphLayouter layouter;
    @NotNull
    private org.jetbrains.skia.paragraph.Paragraph paragraph;
    @Nullable
    private LineMetrics[] _lineMetrics;
    public static final int $stable = 8;

    /*
     * WARNING - void declaration
     */
    private SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints) {
        int calculatedMaxLines;
        void val1$iv$iv;
        void width$iv;
        void $this$layouter_u24lambda_u240;
        ParagraphLayouter paragraphLayouter;
        Intrinsics.checkNotNullParameter((Object)paragraphIntrinsics, (String)"paragraphIntrinsics");
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.overflow = overflow;
        this.constraints = constraints;
        ParagraphLayouter paragraphLayouter2 = paragraphLayouter = this.paragraphIntrinsics.layouter();
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$layouter_u24lambda_u240.setParagraphStyle(this.maxLines, this.getEllipsis());
        skiaParagraph.layouter = paragraphLayouter;
        this.paragraph = this.layouter.layoutParagraph(this.getWidth());
        boolean value$iv = Constraints.getMinHeight-impl(this.constraints) == 0 && Constraints.getMinWidth-impl(this.constraints) == 0;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl2 = false;
            InlineClassHelperKt.throwIllegalArgumentException("Setting Constraints.minWidth and Constraints.minHeight is not supported, these should be the default zero values instead.");
        }
        value$iv = this.maxLines >= 1;
        $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl3 = false;
            InlineClassHelperKt.throwIllegalArgumentException("maxLines should be greater than 0");
        }
        float value$iv2 = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        void var9_14 = width$iv;
        float val2$iv$iv = height$iv;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
        long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
        this.layouter.setBrushSize-uvyYCjk(Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        if (TextOverflow.equals-impl0(this.overflow, TextOverflow.Companion.getEllipsis-gIe3tQ8()) && this.paragraph.getHeight() > (float)Constraints.getMaxHeight-impl(this.constraints) && this.maxLines > 1 && (calculatedMaxLines = SkiaParagraph_skikoKt.access$numberOfLinesThatFitMaxHeight(this, Constraints.getMaxHeight-impl(this.constraints))) >= 0 && calculatedMaxLines != this.maxLines) {
            this.layouter.setParagraphStyle(RangesKt.coerceAtLeast((int)calculatedMaxLines, (int)1), this.getEllipsis());
            this.setParagraph(this.layouter.layoutParagraph(this.getWidth()));
        }
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final long getConstraints-msEJaDk() {
        return this.constraints;
    }

    @NotNull
    public final Font getDefaultFont$ui_text() {
        return this.layouter.getDefaultFont();
    }

    private final void setParagraph(org.jetbrains.skia.paragraph.Paragraph value) {
        this.paragraph = value;
        this._lineMetrics = null;
    }

    private final String getEllipsis() {
        Object[] objectArray = new TextOverflow[]{TextOverflow.box-impl(TextOverflow.Companion.getEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getMiddleEllipsis-gIe3tQ8()), TextOverflow.box-impl(TextOverflow.Companion.getStartEllipsis-gIe3tQ8())};
        return CollectionsKt.listOf((Object[])objectArray).contains(TextOverflow.box-impl(this.overflow)) ? "\u2026" : "";
    }

    private final String getText() {
        return this.paragraphIntrinsics.getText();
    }

    @Override
    public float getWidth() {
        return Constraints.getMaxWidth-impl(this.constraints);
    }

    @Override
    public float getHeight() {
        return this.paragraph.getHeight();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.firstOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_firstBaseline__u24lambda_u240 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_firstBaseline__u24lambda_u240.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLastBaseline() {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.lastOrNull((Object[])this.getLineMetrics());
        if (lineMetrics != null) {
            LineMetrics $this$_get_lastBaseline__u24lambda_u240 = lineMetrics;
            boolean bl = false;
            f = (float)$this$_get_lastBaseline__u24lambda_u240.getBaseline();
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.paragraph.didExceedMaxLines();
    }

    @Override
    public int getLineCount() {
        return Intrinsics.areEqual((Object)this.getText(), (Object)"") || this.paragraph.getLineNumber() < 1 ? 1 : this.paragraph.getLineNumber();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<Rect> getPlaceholderRects() {
        void $this$mapTo$iv$iv;
        TextBox[] $this$map$iv = this.paragraph.getRectsForPlaceholders();
        boolean $i$f$map = false;
        TextBox[] textBoxArray = $this$map$iv;
        Collection destination$iv$iv = new ArrayList($this$map$iv.length);
        boolean $i$f$mapTo = false;
        int n = ((void)$this$mapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            void it;
            void item$iv$iv;
            void var9_9 = item$iv$iv = $this$mapTo$iv$iv[i];
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(Rects_skikoKt.toComposeRect(it.getRect()));
        }
        return (List)destination$iv$iv;
    }

    @Override
    @NotNull
    public androidx.compose.ui.graphics.Path getPathForRange(int start, int end) {
        boolean value$iv = (0 <= start ? start <= end : false) && end <= this.getText().length();
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("start(" + start + ") or end(" + end + ") is out of range [0.." + this.getText().length() + "], or start > end!");
        }
        TextBox[] boxes = this.paragraph.getRectsForRange(start, end, RectHeightMode.MAX, RectWidthMode.TIGHT);
        androidx.compose.ui.graphics.Path path = SkiaBackedPath_skikoKt.Path();
        for (TextBox b : boxes) {
            Path.addRect$default((Path)SkiaBackedPath_skikoKt.asSkiaPath(path), (org.jetbrains.skia.Rect)b.getRect(), null, (int)0, (int)6, null);
        }
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        double d;
        double d2;
        void this_$iv;
        SkiaParagraph skiaParagraph = this;
        int offset$iv = offset;
        boolean $i$f$checkOffsetIsValid = false;
        boolean value$iv$iv = 0 <= offset$iv ? offset$iv <= super.getText().length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset$iv + ") is out of bounds [0," + super.getText().length() + "]");
        }
        float horizontal = this.getHorizontalPosition(offset, true);
        LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
        Intrinsics.checkNotNull((Object)lineMetrics);
        LineMetrics line = lineMetrics;
        boolean isNewEmptyLine = offset - 1 == line.getStartIndex() && offset == this.getText().length();
        FontMetrics metrics = this.getDefaultFont$ui_text().getMetrics();
        double it = line.getAscent();
        boolean bl = false;
        if (isNewEmptyLine) {
            double ascent = -((double)metrics.getAscent());
            d2 = RangesKt.coerceAtMost((double)it, (double)ascent);
        } else {
            d2 = it;
        }
        double asc = d2;
        double it2 = line.getDescent();
        boolean bl2 = false;
        if (isNewEmptyLine) {
            double descent = metrics.getDescent();
            d = RangesKt.coerceAtMost((double)it2, (double)descent);
        } else {
            d = it2;
        }
        double desc = d;
        return new Rect(horizontal, (float)(line.getBaseline() - asc), horizontal, (float)(line.getBaseline() + desc));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getLeft() : 0.0f;
    }

    @Override
    public float getLineRight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getRight() : 0.0f;
    }

    @Override
    public float getLineTop(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() - line.getAscent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    @Override
    public float getLineBottom(int lineIndex) {
        float f;
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics != null) {
            LineMetrics line = lineMetrics;
            boolean bl = false;
            f = (float)Math.floor((float)(line.getBaseline() + line.getDescent()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public final float getLineAscent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return -(lineMetrics != null ? (float)lineMetrics.getAscent() : 0.0f);
    }

    @Override
    public float getLineBaseline(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getBaseline() : 0.0f;
    }

    public final float getLineDescent$ui_text(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getDescent() : 0.0f;
    }

    private final LineMetrics lineMetricsForOffset(int offset) {
        Object object;
        boolean bl = 0 <= offset ? offset <= this.getText().length() : false;
        if (bl) {
            Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
            boolean $i$f$binarySearchFirstMatchingOrLast = false;
            if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
                object = null;
            } else {
                int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(offset){
                    final /* synthetic */ int $offset$inlined;
                    {
                        this.$offset$inlined = n;
                    }

                    /*
                     * Ignored method signature, as it can't be verified against descriptor
                     */
                    public final Integer invoke(Object it) {
                        LineMetrics it2 = (LineMetrics)it;
                        boolean bl = false;
                        return this.$offset$inlined < it2.getEndIncludingNewline() ? 1 : -1;
                    }
                }), (int)3, null);
                object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
            }
        } else {
            object = null;
        }
        return object;
    }

    @Override
    public float getLineHeight(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getHeight() : 0.0f;
    }

    @Override
    public float getLineWidth(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? (float)lineMetrics.getWidth() : 0.0f;
    }

    @Override
    public int getLineStart(int lineIndex) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        return lineMetrics != null ? lineMetrics.getStartIndex() : 0;
    }

    @Override
    public int getLineEnd(int lineIndex, boolean visibleEnd) {
        LineMetrics lineMetrics = (LineMetrics)ArraysKt.getOrNull((Object[])this.getLineMetrics(), (int)lineIndex);
        if (lineMetrics == null) {
            return 0;
        }
        LineMetrics metrics = lineMetrics;
        return visibleEnd ? (lineIndex > 0 && metrics.getStartIndex() < this.getLineMetrics()[lineIndex - 1].getEndIndex() ? metrics.getEndIndex() : (metrics.getStartIndex() < this.getText().length() && this.getText().charAt(metrics.getStartIndex()) == '\n' ? metrics.getStartIndex() : metrics.getEndExcludingWhitespaces())) : metrics.getEndIndex();
    }

    @Override
    public boolean isLineEllipsized(int lineIndex) {
        return false;
    }

    @Override
    public int getLineForOffset(int offset) {
        int n;
        if (offset < 0) {
            n = 0;
        } else if (offset > this.getText().length()) {
            n = this.getLineCount() - 1;
        } else {
            LineMetrics lineMetrics = this.lineMetricsForOffset(offset);
            Intrinsics.checkNotNull((Object)lineMetrics);
            n = lineMetrics.getLineNumber();
        }
        return n;
    }

    @Override
    public int getLineForVerticalPosition(float vertical) {
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(vertical);
        return lineMetrics != null ? lineMetrics.getLineNumber() : 0;
    }

    private final LineMetrics getLineMetricsForVerticalPosition(float vertical) {
        Object object;
        Object[] $this$binarySearchFirstMatchingOrLast$iv = this.getLineMetrics();
        boolean $i$f$binarySearchFirstMatchingOrLast = false;
        if ($this$binarySearchFirstMatchingOrLast$iv.length == 0) {
            object = null;
        } else {
            int index$iv = CollectionsKt.binarySearch$default((List)ArraysKt.asList((Object[])$this$binarySearchFirstMatchingOrLast$iv), (int)0, (int)0, (Function1)((Function1)new Function1<LineMetrics, Integer>(vertical){
                final /* synthetic */ float $vertical$inlined;
                {
                    this.$vertical$inlined = f;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public final Integer invoke(Object it) {
                    LineMetrics it2 = (LineMetrics)it;
                    boolean bl = false;
                    return (double)this.$vertical$inlined < it2.getBaseline() + it2.getDescent() ? 1 : -1;
                }
            }), (int)3, null);
            object = $this$binarySearchFirstMatchingOrLast$iv[RangesKt.coerceAtMost((int)(-index$iv - 1), (int)ArraysKt.getLastIndex((Object[])$this$binarySearchFirstMatchingOrLast$iv))];
        }
        return object;
    }

    @Override
    public float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float f;
        TextBox prevBox = SkiaParagraph.getBoxBackwardByOffset$default(this, offset, 0, 2, null);
        TextBox nextBox = this.getBoxForwardByOffset(offset);
        boolean isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        boolean isLtr = !isRtl;
        if (prevBox == null && nextBox == null) {
            f = this.getAlignedStartingPosition(isRtl);
        } else if (prevBox == null) {
            TextBox textBox = nextBox;
            Intrinsics.checkNotNull((Object)textBox);
            f = androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(textBox, true);
        } else {
            f = nextBox == null ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : (nextBox.getDirection() == prevBox.getDirection() ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isLtr && prevBox.getDirection() == Direction.LTR ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (isRtl && prevBox.getDirection() == Direction.RTL ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true) : (usePrimaryDirection ? androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition$default(prevBox, false, 1, null) : androidx.compose.ui.text.platform.SkiaParagraph_skikoKt.cursorHorizontalPosition(nextBox, true)))));
        }
        return f;
    }

    private final float getAlignedStartingPosition(boolean isRtl) {
        int n = this.layouter.getTextStyle().getTextAlign-e0LSkKk();
        return TextAlign.equals-impl0(n, TextAlign.Companion.getLeft-e0LSkKk()) ? 0.0f : (TextAlign.equals-impl0(n, TextAlign.Companion.getRight-e0LSkKk()) ? this.getWidth() : (TextAlign.equals-impl0(n, TextAlign.Companion.getCenter-e0LSkKk()) ? this.getWidth() / (float)2 : (TextAlign.equals-impl0(n, TextAlign.Companion.getStart-e0LSkKk()) ? (isRtl ? this.getWidth() : 0.0f) : (TextAlign.equals-impl0(n, TextAlign.Companion.getEnd-e0LSkKk()) ? (isRtl ? 0.0f : this.getWidth()) : 0.0f))));
    }

    private final LineMetrics[] getLineMetrics() {
        LineMetrics[] lineMetricsArray = this._lineMetrics;
        if (this._lineMetrics == null) {
            LineMetrics[] lineMetricsArray2;
            LineMetrics[] it = lineMetricsArray2 = this.receiveLineMetrics();
            boolean bl = false;
            this._lineMetrics = it;
            lineMetricsArray = lineMetricsArray2;
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        return lineMetrics;
    }

    private final LineMetrics[] receiveLineMetrics() {
        LineMetrics[] lineMetricsArray;
        if (((CharSequence)this.getText()).length() == 0) {
            lineMetricsArray = this.layouter.emptyLineMetrics$ui_text(this.paragraph);
        } else {
            LineMetrics[] lineMetricsArray2 = this.paragraph.getLineMetrics();
            if (lineMetricsArray2.length == 0) {
                boolean bl = false;
                lineMetricsArray = this.layouter.emptyLineMetrics$ui_text(this.paragraph);
            } else {
                lineMetricsArray = lineMetricsArray2;
            }
        }
        LineMetrics[] lineMetrics = lineMetricsArray;
        FontMetrics fontMetrics = this.getDefaultFont$ui_text().getMetrics();
        lineMetrics[0] = SkiaParagraph_skikoKt.access$trimFirstAscent(lineMetrics[0], fontMetrics, this.layouter.getTextStyle());
        lineMetrics[lineMetrics.length - 1] = SkiaParagraph_skikoKt.access$trimLastDescent(lineMetrics[lineMetrics.length - 1], fontMetrics, this.layouter.getTextStyle());
        return lineMetrics;
    }

    private final TextBox getBoxForwardByOffset(int offset) {
        if (!(0 <= offset ? offset <= this.getText().length() : false)) {
            return null;
        }
        for (int to = offset + 1; to <= this.getText().length(); ++to) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(offset, to, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) continue;
            return box;
        }
        return null;
    }

    private final TextBox getBoxBackwardByOffset(int offset, int end) {
        boolean isRtl;
        if (!(0 <= offset ? offset <= this.getText().length() : false)) {
            return null;
        }
        boolean bl = isRtl = this.paragraphIntrinsics.getTextDirection() == ResolvedTextDirection.Rtl;
        for (int from = offset - 1; from >= 0; --from) {
            TextBox box = (TextBox)ArraysKt.firstOrNull((Object[])this.paragraph.getRectsForRange(from, end, RectHeightMode.STRUT, RectWidthMode.TIGHT));
            if (box == null) {
                continue;
            }
            if (this.getText().charAt(from) == '\n') {
                TextBox textBox;
                if (!isRtl) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(0.0f, box.getRect().getBottom(), 0.0f, bottom);
                    return new TextBox(rect, box.getDirection());
                }
                if (from == StringsKt.getLastIndex((CharSequence)this.getText())) {
                    float bottom = box.getRect().getBottom() + box.getRect().getBottom() - box.getRect().getTop();
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(this.getWidth(), box.getRect().getBottom(), this.getWidth(), bottom);
                    textBox = new TextBox(rect, box.getDirection());
                } else {
                    TextBox nextBox = (TextBox)ArraysKt.first((Object[])this.paragraph.getRectsForRange(offset, offset + 1, RectHeightMode.STRUT, RectWidthMode.TIGHT));
                    org.jetbrains.skia.Rect rect = new org.jetbrains.skia.Rect(nextBox.getRect().getLeft(), nextBox.getRect().getTop(), nextBox.getRect().getLeft(), nextBox.getRect().getBottom());
                    textBox = new TextBox(rect, nextBox.getDirection());
                }
                return textBox;
            }
            return box;
        }
        return null;
    }

    static /* synthetic */ TextBox getBoxBackwardByOffset$default(SkiaParagraph skiaParagraph, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = n;
        }
        return skiaParagraph.getBoxBackwardByOffset(n, n2);
    }

    @Override
    @NotNull
    public ResolvedTextDirection getParagraphDirection(int offset) {
        return this.paragraphIntrinsics.getTextDirection();
    }

    @Override
    @NotNull
    public ResolvedTextDirection getBidiRunDirection(int offset) {
        ResolvedTextDirection resolvedTextDirection;
        TextBox textBox = this.getBoxForwardByOffset(offset);
        Object object = textBox != null ? textBox.getDirection() : null;
        switch (object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) {
            case 1: {
                resolvedTextDirection = ResolvedTextDirection.Rtl;
                break;
            }
            case 2: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            case -1: {
                resolvedTextDirection = ResolvedTextDirection.Ltr;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return resolvedTextDirection;
    }

    @Override
    public int getOffsetForPosition-k-4lQ0M(long l) {
        boolean $i$f$unpackFloat2;
        boolean hasNonSpacingMarkAtEnd;
        int lastCharIndex;
        float rightX;
        TextBox rects;
        TextBox textBox;
        boolean isNonSpacingMark;
        long l2 = l;
        boolean bl = false;
        long value$iv$iv = l2;
        boolean $i$f$unpackFloat1 = false;
        int bits$iv$iv$iv = (int)(value$iv$iv >> 32);
        boolean $i$f$floatFromBits = false;
        float f = Float.intBitsToFloat(bits$iv$iv$iv);
        l2 = l;
        boolean bl2 = false;
        value$iv$iv = l2;
        boolean $i$f$unpackFloat22 = false;
        bits$iv$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        $i$f$floatFromBits = false;
        int initialGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(f, Float.intBitsToFloat(bits$iv$iv$iv)).getPosition();
        int glyphPosition = initialGlyphPosition;
        boolean bl3 = 0 <= glyphPosition ? glyphPosition < this.getText().length() : false;
        if (bl3 && (isNonSpacingMark = CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), glyphPosition)))) {
            int precedingBreak = CharHelpers_skikoKt.findPrecedingBreak(this.getText(), glyphPosition);
            int followingBreak = CharHelpers_skikoKt.findFollowingBreak(this.getText(), glyphPosition);
            if (precedingBreak != glyphPosition && followingBreak != glyphPosition) {
                glyphPosition = followingBreak;
            }
        }
        $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
        $i$f$getY-impl = false;
        long value$iv$iv2 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
        boolean $i$f$unpackFloat23 = false;
        int bits$iv$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $i$f$floatFromBits2 = false;
        LineMetrics lineMetrics = this.getLineMetricsForVerticalPosition(Float.intBitsToFloat(bits$iv$iv$iv2));
        if (lineMetrics == null) {
            return glyphPosition;
        }
        LineMetrics expectedLine = lineMetrics;
        boolean isNotEmptyLine = expectedLine.getStartIndex() < expectedLine.getEndIndex();
        $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
        $i$f$getX-impl = false;
        value$iv$iv2 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
        boolean $i$f$unpackFloat12 = false;
        bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
        $i$f$floatFromBits2 = false;
        if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) > expectedLine.getLeft()) {
            $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
            $i$f$getX-impl = false;
            value$iv$iv2 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
            $i$f$unpackFloat12 = false;
            bits$iv$iv$iv2 = (int)(value$iv$iv2 >> 32);
            $i$f$floatFromBits2 = false;
            if ((double)Float.intBitsToFloat(bits$iv$iv$iv2) < expectedLine.getRight()) {
                return glyphPosition;
            }
        }
        float leftX = (textBox = (rects = isNotEmptyLine ? this.paragraph.getRectsForRange(expectedLine.getStartIndex(), expectedLine.isHardBreak() ? expectedLine.getEndIndex() : expectedLine.getEndIndex() - 1, RectHeightMode.STRUT, RectWidthMode.TIGHT) : null)) != null && (textBox = (TextBox[])ArraysKt.firstOrNull(textBox)) != null && (textBox = textBox.getRect()) != null ? textBox.getLeft() : (float)expectedLine.getLeft();
        TextBox textBox2 = rects;
        float f2 = rightX = textBox2 != null && (textBox2 = (TextBox)ArraysKt.lastOrNull((Object[])textBox2)) != null && (textBox2 = textBox2.getRect()) != null ? textBox2.getRight() : (float)expectedLine.getRight();
        if (leftX == rightX) {
            return glyphPosition;
        }
        boolean bl4 = isNotEmptyLine && expectedLine.getEndExcludingWhitespaces() > 0 ? ((lastCharIndex = expectedLine.getEndExcludingWhitespaces() - 1) >= 0 && lastCharIndex < this.getText().length() ? CharHelpers_jvmKt.isNonSpacingMark(CharHelpers_skikoKt.codePointAt(this.getText(), lastCharIndex)) : false) : (hasNonSpacingMarkAtEnd = false);
        if (hasNonSpacingMarkAtEnd) {
            return glyphPosition;
        }
        int correctedGlyphPosition = glyphPosition;
        $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
        $i$f$getX-impl = false;
        long value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
        boolean $i$f$unpackFloat13 = false;
        int bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
        boolean $i$f$floatFromBits3 = false;
        if (Float.intBitsToFloat(bits$iv$iv$iv3) <= leftX) {
            $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
            $i$f$getY-impl = false;
            value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
            $i$f$unpackFloat2 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
            $i$f$floatFromBits3 = false;
            correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(leftX + 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
        } else {
            $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
            $i$f$getX-impl = false;
            value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
            $i$f$unpackFloat13 = false;
            bits$iv$iv$iv3 = (int)(value$iv$iv3 >> 32);
            $i$f$floatFromBits3 = false;
            if (Float.intBitsToFloat(bits$iv$iv$iv3) >= rightX) {
                boolean isNeutralChar;
                $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv = l;
                $i$f$getY-impl = false;
                value$iv$iv3 = $v$c$androidx-compose-ui-geometry-Offset$-this$0$iv;
                $i$f$unpackFloat2 = false;
                bits$iv$iv$iv3 = (int)(value$iv$iv3 & 0xFFFFFFFFL);
                $i$f$floatFromBits3 = false;
                correctedGlyphPosition = this.paragraph.getGlyphPositionAtCoordinate(rightX - 1.0f, Float.intBitsToFloat(bits$iv$iv$iv3)).getPosition();
                boolean bl5 = isNeutralChar = (0 <= correctedGlyphPosition ? correctedGlyphPosition < ((CharSequence)this.getText()).length() : false) ? CharHelpers_jvmKt.isNeutralDirection(CharHelpers_skikoKt.codePointAt(this.getText(), correctedGlyphPosition)) : false;
                if (!isNeutralChar) {
                    TextBox textBox3 = SkiaParagraph.getBoxBackwardByOffset$default(this, correctedGlyphPosition, 0, 2, null);
                    if ((textBox3 != null ? textBox3.getDirection() : null) == Direction.RTL) {
                        --correctedGlyphPosition;
                    }
                }
            }
        }
        return correctedGlyphPosition;
    }

    @Override
    public long getRangeForRect-8-6BmAI(@NotNull Rect rect, int n, @NotNull TextInclusionStrategy inclusionStrategy) {
        Intrinsics.checkNotNullParameter((Object)rect, (String)"rect");
        Intrinsics.checkNotNullParameter((Object)inclusionStrategy, (String)"inclusionStrategy");
        return TextRange.Companion.getZero-d9O1mEE();
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        TextBox textBox;
        boolean value$iv = 0 <= offset ? offset < ((CharSequence)this.getText()).length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset + ") is out of bounds [0," + this.getText().length() + ")");
        }
        if ((textBox = this.getBoxForwardByOffset(offset)) == null) {
            TextBox textBox2 = this.getBoxBackwardByOffset(offset, this.getText().length());
            textBox = textBox2;
            Intrinsics.checkNotNull((Object)textBox2);
        }
        TextBox box = textBox;
        return Rects_skikoKt.toComposeRect(box.getRect());
    }

    @Override
    public void fillBoundingBoxes-8ffj60Q(long l, @NotNull float[] array, int arrayStart) {
        Intrinsics.checkNotNullParameter((Object)array, (String)"array");
        System.out.println((Object)"Compose Multiplatform doesn't support fillBoundingBoxes` yet. Follow https://youtrack.jetbrains.com/issue/CMP-720");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long getWordBoundary--jx7JFs(int offset) {
        void this_$iv;
        SkiaParagraph skiaParagraph = this;
        int offset$iv = offset;
        boolean $i$f$checkOffsetIsValid = false;
        boolean value$iv$iv = 0 <= offset$iv ? offset$iv <= super.getText().length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset$iv + ") is out of bounds [0," + super.getText().length() + "]");
        }
        if (offset < this.getText().length() && CharsKt.isWhitespace((char)this.getText().charAt(offset)) || offset == this.getText().length()) {
            return offset > 0 && !CharsKt.isWhitespace((char)this.getText().charAt(offset - 1)) ? SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset - 1)) : TextRangeKt.TextRange(offset, offset);
        }
        return SkiaParagraph_skikoKt.access$toTextRange(this.paragraph.getWordBoundary(offset));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void paint-RPmYEkk(@NotNull Canvas canvas, long l, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration) {
        void $this$paint_RPmYEkk_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_RPmYEkk_u24lambda_u240.setColor-8_81llA(l);
        $this$paint_RPmYEkk_u24lambda_u240.setTextStyle(shadow, textDecoration);
        skiaParagraph.setParagraph($this$paint_RPmYEkk_u24lambda_u240.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-LG529CI(@NotNull Canvas canvas, long l, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int n) {
        void $this$paint_LG529CI_u24lambda_u240;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        $this$paint_LG529CI_u24lambda_u240.setColor-8_81llA(l);
        $this$paint_LG529CI_u24lambda_u240.setTextStyle(shadow, textDecoration);
        $this$paint_LG529CI_u24lambda_u240.setDrawStyle(drawStyle);
        $this$paint_LG529CI_u24lambda_u240.setBlendMode-s9anfk8(n);
        skiaParagraph.setParagraph($this$paint_LG529CI_u24lambda_u240.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ExperimentalTextApi
    public void paint-hn5TExg(@NotNull Canvas canvas, @NotNull Brush brush, float alpha, @Nullable Shadow shadow, @Nullable TextDecoration textDecoration, @Nullable DrawStyle drawStyle, int n) {
        void $this$paint_hn5TExg_u24lambda_u240;
        void val1$iv$iv;
        void width$iv;
        Intrinsics.checkNotNullParameter((Object)canvas, (String)"canvas");
        Intrinsics.checkNotNullParameter((Object)brush, (String)"brush");
        ParagraphLayouter paragraphLayouter = this.layouter;
        SkiaParagraph skiaParagraph = this;
        boolean bl = false;
        float f = this.getWidth();
        float height$iv = this.getHeight();
        boolean $i$f$Size = false;
        void var13_14 = width$iv;
        float val2$iv$iv = height$iv;
        boolean $i$f$packFloats = false;
        long v1$iv$iv = Float.floatToRawIntBits((float)val1$iv$iv);
        long v2$iv$iv = Float.floatToRawIntBits(val2$iv$iv);
        $this$paint_hn5TExg_u24lambda_u240.setBrush-12SF9DM(brush, Size.constructor-impl(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL), alpha);
        $this$paint_hn5TExg_u24lambda_u240.setTextStyle(shadow, textDecoration);
        $this$paint_hn5TExg_u24lambda_u240.setDrawStyle(drawStyle);
        $this$paint_hn5TExg_u24lambda_u240.setBlendMode-s9anfk8(n);
        skiaParagraph.setParagraph($this$paint_hn5TExg_u24lambda_u240.layoutParagraph(this.getWidth()));
        this.paragraph.paint(SkiaBackedCanvas_skikoKt.getNativeCanvas(canvas), 0.0f, 0.0f);
    }

    private final void checkOffsetIsValid(int offset) {
        boolean $i$f$checkOffsetIsValid = false;
        boolean value$iv = 0 <= offset ? offset <= this.getText().length() : false;
        boolean $i$f$requirePrecondition = false;
        if (!value$iv) {
            boolean bl = false;
            InlineClassHelperKt.throwIllegalArgumentException("offset(" + offset + ") is out of bounds [0," + this.getText().length() + "]");
        }
    }

    public /* synthetic */ SkiaParagraph(SkiaParagraphIntrinsics paragraphIntrinsics, int maxLines, int overflow, long constraints, DefaultConstructorMarker $constructor_marker) {
        this(paragraphIntrinsics, maxLines, overflow, constraints);
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Direction.values().length];
            try {
                nArray[Direction.RTL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Direction.LTR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

